/*****************************************************************************
*   $Id: awk.c,v 8.4 2000/06/22 02:15:53 darren Exp $
*
*   Copyright (c) 2000, Darren Hiebert
*
*   This source code is released for free distribution under the terms of the
*   GNU General Public License.
*
*   This module contains functions for generating tags for AWK functions.
*****************************************************************************/

/*============================================================================
=   Include files
============================================================================*/
#include "general.h"	/* must always come first */

#include <ctype.h>	/* to define isalpha(), isalnum(), isspace() */
#include <string.h>

#include "entry.h"
#include "parse.h"
#include "read.h"
#include "vstring.h"

/*============================================================================
=   Function prototypes
============================================================================*/
static void makeFunctionTag __ARGS((const vString* const name));

/*============================================================================
=   Function definitions
============================================================================*/

static void makeFunctionTag( name )
    const vString* const name;
{
    tagEntryInfo e;
    initTagEntry(&e, vStringValue(name));

    e.kindName = "function";
    e.kind     = 'f';

    makeTagEntry(&e);
}

extern void createAwkTags()
{
    vString *vLine = vStringNew();
    vString *name = vStringNew();
    const char *line;

    while ((line = fileReadLine(vLine)) != NULL)
    {
	if (strncmp(line, "function", (size_t)8) == 0  && isspace((int)line[8]))
	{
	    const unsigned char *cp = (const unsigned char*)line + 8;

	    while (isspace((int)*cp))
		++cp;
	    while (isalnum((int)*cp)  ||  *cp == '_')
	    {
		vStringPut(name, (int)*cp);
		++cp;
	    }
	    vStringTerminate(name);
	    while (isspace((int)*cp))
		++cp;
	    if (*cp++ == '(')
		makeFunctionTag(name);
	    vStringClear(name);
	}
    }
    vStringDelete(name);
    vStringDelete(vLine);
}

/* vi:set tabstop=8 shiftwidth=4: */
