# ReplaceSupport 1.0.3
# (c) 2000-2005, Stefan H. Holek, stefan@epy.co.at
# http://zope.org/Members/shh/ReplaceSupport
# License: ZPL
# Zope: 2.6-2.8

__doc__ = 'ReplaceHandler registry'
__version__ = '0.2.0'

class HandlerRegistry:
        '''Handler registry'''

        def __init__( self ):
                self._handlers = {}
        
        def getHandler( self, metatype ):
                try:    return self._handlers[metatype]
                except: return None

        def registerHandler( self, handler ):
                self._handlers[handler.getMetaType()] = handler

        def getHandlerMetaTypes( self ):
                keys = self._handlers.keys()
                keys.sort()
                return keys

reg = HandlerRegistry()

from Globals import package_home
import os

handlers = os.listdir( package_home(globals()) )
handlers = filter( lambda x: x[-3:] == '.py' and x[:1] != '_', handlers )
handlers = map( lambda x: x[:-3], handlers )

for module in handlers:
        exec 'from %s import %s' % (module, '__handler_class_name__')
        exec 'from %s import %s' % (module, __handler_class_name__)
        reg.registerHandler( eval('%s()' % __handler_class_name__) )

from Products.ReplaceSupport.ReplaceSupport import ReplaceSupport
ReplaceSupport._ReplaceHandlerRegistry = reg

