from Products.Archetypes.public import process_types, listTypes
from Products.CMFCore import utils
from Products.CMFCore.DirectoryView import registerDirectory
from AccessControl import ModuleSecurityInfo

from Products.PloneFormGen.config import PROJECTNAME, \
    ADD_CONTENT_PERMISSION, SKINS_DIR, GLOBALS

registerDirectory(SKINS_DIR + '/PloneFormGen', GLOBALS)

def initialize(context):    

    import content, validators, tools, widgets

    ##
    ## Adds the new content type
    ##
    content_types, constructors, ftis = process_types(
        listTypes(PROJECTNAME), PROJECTNAME)

    utils.ContentInit(
        PROJECTNAME + ' Content',
        content_types = content_types,
        permission = ADD_CONTENT_PERMISSION,
        extra_constructors = constructors,
        fti = ftis,
        ).initialize(context)

    utils.ToolInit('PloneFormGen Tool',
        tools=( tools.formGenTool.FormGenTool, ), 
        icon='Form.gif',
        ).initialize(context) 

    ModuleSecurityInfo('Products.PloneFormGen').declarePublic('PloneFormGenMessageFactory')
    ModuleSecurityInfo('Products.PloneFormGen').declarePublic('HAS_PLONE25')


# Import "PloneFormGenMessageFactory as _" to create message ids
# in the ploneformgen domain
# Zope 3.1-style messagefactory module
# BBB: Zope 2.8 / Zope X3.0
try:
    from zope.i18nmessageid import MessageFactory
except ImportError:
    from messagefactory_ import PloneFormGenMessageFactory
else:
    PloneFormGenMessageFactory = MessageFactory('ploneformgen')

# Check for Plone 2.5
try:
    from Products.CMFPlone.migrations import v2_5
except ImportError:
    HAS_PLONE25 = False
else:
    HAS_PLONE25 = True

