import os, sys, string
if __name__ == '__main__':
    execfile(os.path.join(sys.path[0], 'framework.py'))

from Testing import ZopeTestCase
from sets import Set
from DateTime import DateTime

from ZPublisher.HTTPRequest import record

from Products.CMFCore.utils import getToolByName
from Products.CMFMember.tests.CMFMemberTestCase import CMFMemberTestCase, \
     testMemberData, default_user

email = testMemberData['email']

fullname = testMemberData['fullname']

query = {'getId':'0member', 'getFullname':'0%s' % fullname,
         'getEmail':'0%s' % email}

class TestMemberSearch(CMFMemberTestCase):

    def afterSetUp(self):
        CMFMemberTestCase.afterSetUp( self )
        self.addTestMembers(howmany=3) # makes 3 more users
        self.howmany = 3
        
    def testInstallationofMemberCatalog(self):
        self.failUnless(hasattr(self.portal, 'member_catalog'))
        self.failUnless('review_state' in self.portal.member_catalog.indexes())
        cat_indexes = Set(self.portal.member_catalog.indexes())
        schema = self.portal.archetype_tool.lookupType('CMFMember','Member')['schema']
        accessors = Set([x.accessor  for x in schema.fields() if x.index] + ['review_state'])
        self.assertEqual(accessors & cat_indexes, accessors)

    def testKWSearchForMembers(self):
        results = self.memberdata.searchForMembers(getId='0member', 
                                                   getFullname=query['getFullname'], 
                                                   getEmail=query['getEmail'], brains='yes_please')
        self.assertEquals(results[0].getFullname, query['getFullname'])

    def testReturn(self):
        # with brains
        request = self.app.REQUEST
        request.set('brains', True)
        request.form = query
        results = self.memberdata.searchForMembers(request)
        self.assertEquals([x.getId for x in results], ['0member'])
        self.assertEquals([x.getFullname for x in results], [query['getFullname']])

        # brainless(objects)
        request.set('brains', False)
        results = self.memberdata.searchForMembers(request)
        self.assertEquals([x.getFullname() for x in results], [query['getFullname']])

    def testSearchByLoginTime(self):
        request = self.app.REQUEST
        request.form = {
            'getLastLoginTime' : DateTime('2000/01/01'),
            'getLastLoginTime_usage' : 'range:min',
            'brains' : 'yes please!'
            }
        search = self.memberdata.searchForMembers(request)
        self.failUnless(Set(['0member', '1member', '2member']).issubset( \
                          Set([x.getId for x in search])))

    def testSearchForMembers(self):
        # can we search at all?
        request = self.app.REQUEST
        request.set('brains', 'yes please!')
        search = self.memberdata.searchForMembers(request)

        test_set    = Set([x.getId for x in search])
        control_set = Set(['0member', '1member', '2member'])
        self.failUnless( control_set.issubset(test_set),
                         "Isn't subset control_set: %s test_set:%s" %(control_set,
                                                                      test_set) )

    def testSearchByImplicitGroupRole(self):
        # demonstrating issue #173
        rolename = 'Bogus'
        groupname = 'bogus_group'
        self.portal._addRole(rolename)

        gtool = getToolByName(self.portal, 'portal_groups')
        mcat = getToolByName(self.portal, 'member_catalog')

        gtool.addGroup(groupname, roles=['Bogus'])
        self.portal.prefs_group_members_add(groupname,
                                            add=[self.portal_user.getId()])
        brains = mcat(getFilteredRoles=[rolename])
        self.failUnless(len(brains) == 1 and \
                        brains[0].id == self.portal_user.getId())

    def testUserPrefsCatalogReindexing(self):
        userid = self.portal_user.getId()
        member = self.membership.getMemberById(userid)
        rec = record()
        rec.id = userid
        rec.roles = ['Reviewer']
        rec.email = member.getEmail()
        self.portal.prefs_user_manage(users=[rec])
        
        res = self.membership.searchForMembers(roles=['Reviewer'])
        self.failUnless(len(res)==1 and res[0].getId()==userid)

    def testGlobOnZCTextIndexes(self):
        request = self.app.REQUEST
        request.form = {
            'brains': 'yes please!',
            'getId': '0me',
            }
        search = self.memberdata.searchForMembers(request)
        self.assertEquals('0member', search[0].getId)


if __name__ == '__main__':
    framework(verbosity=1)
else:
    from unittest import TestSuite, makeSuite
    def test_suite():
        suite = TestSuite()
        suite.addTest(makeSuite(TestMemberSearch))
        return suite
