"""
LDAPStorage used for CMFMember

(C) 2004, Sasha Vincic, Sweden

Released as open-source under the current Archetypes license

$Id: ldapstorage.py 8137 2005-04-23 09:25:18Z rafrombrc $
"""

from Products.Archetypes.Storage import Storage
from Products.Archetypes.utils import shasattr
from Products.Archetypes.interfaces.field import IObjectField
from Products.CMFCore.utils import getToolByName

from userfolderstorage import UserFolderStorage

from Acquisition import aq_base, aq_parent, aq_inner


class LDAPUserFolderStorage(UserFolderStorage):
    """ LDAPUserFolderStorage depends and uses LDAPUserFolder to communicate 
        with LDAP. This means that control like read only/writeable and which 
        fields are editable in ldap is handled by the LDAP user folder. """

    # Methods of base class Storage
    def __init__(self, cache=True, mappings={}):
        """ Mappings is used to map 
            between AT fieldname to LDAP field name. """
        UserFolderStorage.__init__(self, cache)
        self._mappings = mappings
            


    def updateUserObject(self, instance):
        self._syncMappingsWithUserFolder(instance)
        if instance.hasUser():
            user = instance.getUser()
            acl_users  = aq_parent(aq_inner(user)).getUserSource(user.getUserSourceId())
            fields = instance.Schema().fields()
            kwargs = {}
            for f in fields:
                if IObjectField.isImplementedBy(f) \
                    and f.getStorage().__class__ is self.__class__:
                    kwargs[self.getMapping(f.getName())] = self.get(f.getName(), instance)
            
            user_dn = "cn=%s,%s" % (instance.getUserName(), acl_users.getProperty('users_base'))
            acl_users.manage_editUser( user_dn , kwargs=kwargs)
            
    # Helping methods
    def getMapping(self, name):
        """ Return the mapping of AT field name -> LDAP field name if it exists 
            otherwise the same name. """
        return self._mappings.get(name, name)
         
    def setMapping(self, ldap_name
                       , friendly_name=''
                       , multivalued=''
                       , public_name='' ):
        """ Adds or changes a mapping. 
        """
        self._mappings[public_name] = ldap_name
        self._inSync = False
        
    def setAndSyncMapping(self, context, public_name, storage_data):
        """ Used as a post method from ATSchemaEditor.
        """
        if storage_data is not None and storage_data.has_key('mapping'):
            self.setMapping(storage_data['mapping'], public_name=public_name)
            self._userFolder = storage_data.get('user_src')
            self._inSync = False
            self._syncMappingsWithUserFolder(context)
        
            
    def setSchemaConfig(self, schema ):
        """ Sets all mappings at once. This method overwrites 
            existing mappings. """
            
        for mapping in schema.values():
            self.setMapping(public_name=mapping['public_name'], ldap_name=mapping['ldap_name'])
            self._inSync = False
        
    def _syncMappingsWithUserFolder(self, context):
        """ LDAPUserFolder need to be updated when mappings are changed
            through ATSchemaEditor or programaticlly. """
            
        if not hasattr(self, '_inSync') or not self._inSync:
            gruf = context.acl_users
            if not hasattr(self, '_luf'):
                self._luf = gruf.getUserSource(self._userFolder)
                
            self._luf.manage_deleteLDAPSchemaItems(self._mappings.keys())
            for public_name in self._mappings.keys():
                self._luf.manage_addLDAPSchemaItem(ldap_name = self._mappings[public_name],
                                                   public_name = public_name)  
            self._inSync = True
        

ldap_person = { 'userPassword': 'password',
                'telephoneNumber': '',
                'seeAlso' : '',
                'description' : '',
                'sn' : '',
                'cn' : '' }
            
ldap_organizationalPerson = { 'title' : '',
                              'x121Address' : '',
                              'registeredAddress' : '',
                              'destinationIndicator' : '',
                              'preferredDeliveryMethod' : '',
                              'telexNumber' : '',
                              'teletexTerminalIdentifier' : '',
                              'telephoneNumber' : '',
                              'internationaliSDNNumber' : '',
                              'facsimileTelephoneNumber' : '',
                              'street' : '',
                              'postOfficeBox' : '',
                              'postalCode' : '',
                              'postalAddress' : '',
                              'physicalDeliveryOfficeName' : '' }

ldap_inetOrgPerson = { 'audio' : '',
                       'businessCategory' : '',
                       'carLicense' : '',
                       'departmentNumber' : '',
                       'displayName' : '',
                       'employeeNumber' : '',
                       'employeeType' : '',
                       'givenName' : '',
                       'homePhone' : '',
                       'homePostalAddress' : '',
                       'initials' : '',
                       'jpegPhoto' : '', 
                       'labeledURI' : '',
                       'mail' : 'email',
                       'manager' : '',
                       'mobile' : '',
                       'o' : '',
                       'pager' : '',
                       'photo' : 'portrait',
                       'roomNumber' : '',
                       'secretary' : '',
                       'uid' : '',
                       'userCertificate' : '',
                       'x500uniqueIdentifier' : '',
                       'preferredLanguage' : '',
                       'userSMIMECertificate' : '',
                       'userPKCS12' : '' }
        