##################################################
#                                                #
#    Copyright (C), 2004, Raphael Ritz           #
#    <r.ritz@biologie.hu-berlin.de>              #
#                                                #
#    Humboldt University Berlin                  #
#                                                #
##################################################

import os, sys

if __name__ == '__main__':
    execfile(os.path.join(sys.path[0], 'framework.py'))

from Testing import ZopeTestCase
from Products.CMFPlone.tests import PloneTestCase
from Products.CMFBibliographyAT.tests import setup

class TestMemberAuthors(PloneTestCase.PloneTestCase):
    '''Test the reference types'''

    def afterSetUp(self):
        self._refreshSkinData()

    # some utility methods

    def getEmptyBibFolder(self):
        uf = self.folder
        uf.invokeFactory(type_name = "BibliographyFolder",
                         id = 'bib_folder')
        return getattr(uf, 'bib_folder')

    def getPopulatedBibFolder(self):
        bf = self.getEmptyBibFolder()
        med_source = open('medline_test.med', 'r').read()
        bf.processImport(med_source, 'medline_test.med')
        return bf   

    # the individual tests

    def dont_testArticleCreation(self):
        uf = self.folder
        uf.invokeFactory('SimpleType',
                         'simpleuser',
                         fullname='Firstname Lastname')
        user = uf.simpleuser
        uf.invokeFactory('TestType',
                         'testuser',
                         firstname='First2',
                         middlename='Middle2',
                         lastname='Last2',
                         homepage='http://this.is')
        user2 = uf.testuser
        bf = self.getEmptyBibFolder()
        bf.invokeFactory(type_name = 'ArticleReference',
                         id = 'test_article')
        self.failUnless('test_article' in bf.contentIds())
        article = bf.test_article
        article.setMemberPublicationAuthors([user.UID()])
        self.failUnlessEqual(article.Authors(abbrev=0, lastnamefirst=0),
                             'Firstname Lastname')
        self.failUnlessEqual(article.Authors(abbrev=0, lastnamefirst=1),
                             'Lastname, Firstname')
        article.setMemberPublicationAuthors([user2.UID()])
        self.failUnlessEqual(article.Authors(abbrev=0, lastnamefirst=0),
                             'First2 Middle2 Last2')
        self.failUnlessEqual(article.Authors(abbrev=0, lastnamefirst=1),
                             'Last2, First2 Middle2')
        article.setMemberPublicationAuthors([user.UID(), user2.UID()])
        self.failUnlessEqual(article.Authors(abbrev=0, lastnamefirst=0),
                             'First2 Middle2 Last2 and Firstname Lastname')
        self.failUnlessEqual(article.Authors(abbrev=0, lastnamefirst=1),
                             'Last2, First2 Middle2 and Lastname, Firstname')
        self.failUnless(article.Authors())

    # end of the individual tests

def test_suite():
    from unittest import TestSuite, makeSuite
    suite = TestSuite()
    suite.addTest(makeSuite(TestMemberAuthors))
    return suite

if __name__ == '__main__':
    framework()
