/*   (C) Copyright 2001, 2002, 2003, 2004, 2005, 2006, 2007 Stijn van Dongen
 *
 * This file is part of Zoem. You can redistribute and/or modify Zoem under the
 * terms of the GNU General Public License;  either version 3 of the License or
 * (at your option) any later  version.  You should have received a copy of the
 * GPL along with Zoem, in the file COPYING.
*/

#include <string.h>
#include <stdio.h>
#include <stdlib.h>
#include <ctype.h>
#include <stdarg.h>

#include "key.h"
#include "dict.h"
#include "sink.h"
#include "read.h"
#include "util.h"

#include "util/ting.h"
#include "util/io.h"
#include "util/minmax.h"
#include "util/types.h"
#include "util/array.h"
#include "util/hash.h"

/*
,  __$args__
,  __$xargs__

!  __sysval__
!  __zoemput__
!  __zoemstat__
*/

const char *strSession[]
=
{  "\\$__args__       (local to env) key/value pairs given to \\begin#2"
,  "\\$__xargs__      (local to env) key/value pairs given to \\begin#2, expanded"
,  "\\__device__     name of device (given by -d)"
,  "\\__fnbase__     base name of entry file (given by -i/-I)"
,  "\\__fnentry__    name of entry file (given by -i/-I)"
,  "\\__fnin__       name of current input file"
,  "\\__fnout__      name of current output file"
,  "\\__fnpath__     path component of entry file (given by -i/-I)"
,  "\\__fnwrite__    arg1 to \\write#3, accessible in arg3 scope"
,  "\\__lc__         expands to a left curly (only for magic)"
,  "\\__line__       index of current input line"
,  "\\__parmode__    paragraph slurping mode for interactive sessions"
,  "\\__rc__         expands to a right curly (only for magic)"
,  "\\__searchpath__ search path for macro packages (e.g. man.zmm)"
,  "\\__split__      user space toggle for chapter mode indicator"
,  "\\__sysval__     exit status of last system command"
,  "\\__version__    version of zoem, formatted as e.g. 2003, 2004-010"
,  "\\__zoemput__    result text of last \\try#1 key"
,  "\\__zoemstat__   status of last \\try#1 key"

,  NULL
}  ;


static dictStack* usrstack = NULL;
static dim n_user_override = 0;


mcxstatus usrDictPop
(  const char* label
)
   {  return dictStackPop(usrstack, "user", label)
;  }

mcxstatus usrDictPush
(  const char* label
)
   {  return dictStackPush(usrstack, 16, label)
;  }


void yamKeyList
(  const char* mode
)
   {  mcxbool listAll = strstr(mode, "all") != NULL
   ;  if (listAll || strstr(mode, "session"))  
      {  int m
      ;  fputs("\nPredefined session variables\n", stdout)
      ;  for (m=0;strSession[m];m++)
         fprintf(stdout, "%s\n", strSession[m])
   ;  }
;  }


void  yamKeySet
(  const char* key
,  const char* val
)
   {  mcxTing*  keytxt   =  mcxTingNew(key)

   ;  if (yamKeyInsert(keytxt, val, strlen(val), 0) != keytxt)
      mcxTingFree(&keytxt)
;  }


void  yamKeyDef
(  const char* key
,  const char* val
)
   {  mcxTing*  keytxt   =  mcxTingNew(key)

   ;  if (yamKeyInsert(keytxt, val, strlen(val), 0) != keytxt)
      {  yamErr("yamKeyDef", "overwriting key <%s>", keytxt->str)
      ;  mcxTingFree(&keytxt)
   ;  }
   }


mcxTing* yamKeyInsert
(  mcxTing*       key
,  const char*    valstr         /* fixme: add length ? */
,  dim            vallen
,  mcxbits        bits
)
   {  keyDict *dict
   =     key->str[0] == '$'
      ?  sinkGetDLRtop()
      :     bits & YAM_SET_GLOBAL
         ?  usrstack->bottom
         :  usrstack->top

   ;  mcxKV* kv   =  mcxHashSearch
                     (  key
                     ,  dict->table
                     ,  MCX_DATUM_INSERT
                     )
   ;  if (!kv)
      yamErrx(1, "yamKeyInsert", "panic&|PBD cannot insert key")

   ;  else
      {  if (!kv->val)
         kv->val = mcxTingNNew(valstr, vallen)
      ;  else if (bits & YAM_SET_APPEND)
         mcxTingNAppend((mcxTing*) (kv->val), valstr, vallen)
      ;  else if (!(bits & YAM_SET_COND))
         mcxTingNWrite((mcxTing*) (kv->val), valstr, vallen)
   ;  }
      return kv->key
;  }


mcxbool yamKeyDeletex
(  const char* key
)
   {  mcxTing* deletee = yamKeyDelete(key, FALSE)
   ;  mcxbool  found = deletee ? TRUE : FALSE
   ;  mcxTingFree(&deletee)
   ;  return found
;  }


mcxTing* yamKeyDelete
(  const char* keystr
,  mcxbool     global
)
   {  mcxTing* key   = mcxTingNew(keystr)
   ;  keyDict *dict  =     global
                        ?  usrstack->bottom
                        :     keystr[0] == '$'
                           ?  sinkGetDLRtop()
                           :  usrstack->top

   ;  mcxKV*   kv
            =  (mcxKV*) mcxHashSearch
               (  key
               ,  dict->table
               ,  MCX_DATUM_DELETE
               )
   ;  mcxTingFree(&key)

   ;  if (kv)
      {  mcxTing* kvval = kv->val
      ;  mcxTing* kvkey = kv->key
      ;  mcxTingFree(&kvkey)
      ;  return kvval
   ;  }
      return NULL
;  }


mcxTing* yamKeyGetGlobal
(  mcxTing*  key
)
   {  keyDict *dict = usrstack->bottom
   ;  mcxKV*   kv
      =  (mcxKV*) mcxHashSearch
         (  key
         ,  dict->table
         ,  MCX_DATUM_FIND
         )
   ;  if (kv)
      return (mcxTing*) kv->val
   ;  return NULL
;  }


mcxTing* yamKeyGetLocal
(  mcxTing*  key
)
   {  keyDict *dict  = *(key->str) == '$' ? sinkGetDLRtop() : usrstack->top
   ;  mcxKV*   kv
      =  (mcxKV*) mcxHashSearch
         (  key
         ,  dict->table
         ,  MCX_DATUM_FIND
         )
   ;  if (kv)
      return (mcxTing*) kv->val
   ;  return NULL
;  }


mcxTing* yamKeyGet
(  mcxTing*  key
)
   {  keyDict *dict =      (unsigned char) key->str[0] == '$'
                        ?  sinkGetDLRtop()
                        :  usrstack->top
   ;  mcxKV* kv

   ;  while (dict)
      {  if ((kv = mcxHashSearch(key, dict->table, MCX_DATUM_FIND)))
         return (mcxTing*) kv->val
      ;  dict = dict->down
   ;  }

      if ((unsigned char) key->str[0] == '$')
      {  dict = sinkGetDLRdefault()
      ;  while (dict)
         {  if ((kv = mcxHashSearch(key, dict->table, MCX_DATUM_FIND)))
            return (mcxTing*) kv->val
         ;  dict = dict->down
      ;  }
      }

      return NULL
;  }


void mod_key_exit
(  void
)
   {  dictStackFree(&usrstack)
;  }


void mod_key_init
(  dim dict_size
)
   {  dim n_max = n_user_override > 0 ? n_user_override : 100
   ;  usrstack = dictStackNew(dict_size, n_max)
;  }


void yamKeyStats
(  void
)
   {  mcxHashStats(stdout, usrstack->bottom->table)
;  }


void keyULimit
(  dim   n_user
)
   {  n_user_override = n_user;
;  }


