/*
 * Decompiled with CFR 0.152.
 */
package Freeze;

import Freeze.Connection;
import Freeze.ConnectionI;
import Freeze.Evictor;
import Freeze.EvictorI;
import Freeze.FatalErrorCallback;
import Freeze.Index;
import Freeze.ServantInitializer;
import Freeze.Transaction;
import Freeze.TransactionI;
import Ice.Communicator;
import Ice.ObjectAdapter;
import com.sleepycat.db.Environment;

public class Util {
    private static String _catalogName = "__catalog";
    private static FatalErrorCallback _fatalErrorCallback = null;

    public static Evictor createEvictor(ObjectAdapter adapter, String envName, String filename, ServantInitializer initializer, Index[] indices, boolean createDb) {
        return new EvictorI(adapter, envName, filename, initializer, indices, createDb);
    }

    public static Evictor createEvictor(ObjectAdapter adapter, String envName, Environment dbEnv, String filename, ServantInitializer initializer, Index[] indices, boolean createDb) {
        return new EvictorI(adapter, envName, dbEnv, filename, initializer, indices, createDb);
    }

    public static Connection createConnection(Communicator communicator, String envName) {
        return new ConnectionI(communicator, envName, null);
    }

    public static Connection createConnection(Communicator communicator, String envName, Environment dbEnv) {
        return new ConnectionI(communicator, envName, dbEnv);
    }

    public static String catalogName() {
        return _catalogName;
    }

    public static com.sleepycat.db.Transaction getTxn(Transaction tx) {
        try {
            return ((TransactionI)tx).dbTxn();
        }
        catch (ClassCastException e) {
            return null;
        }
    }

    public static synchronized FatalErrorCallback registerFatalErrorCallback(FatalErrorCallback cb) {
        FatalErrorCallback result = _fatalErrorCallback;
        _fatalErrorCallback = cb;
        return result;
    }

    static synchronized void handleFatalError(Evictor evictor, Communicator communicator, RuntimeException ex) {
        if (_fatalErrorCallback != null) {
            _fatalErrorCallback.handleError(evictor, communicator, ex);
        } else {
            communicator.getLogger().error("*** Halting JVM ***");
            Runtime.getRuntime().halt(1);
        }
    }
}

