/*
 * Zaz
 * Copyright (C) Remigiusz Dybka 2009 <remigiusz.dybka@gmail.com>
 *
 Zaz is free software: you can redistribute it and/or modify it
 under the terms of the GNU General Public License as published by the
 Free Software Foundation, either version 3 of the License, or
 (at your option) any later version.

 Zaz is distributed in the hope that it will be useful, but
 WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 See the GNU General Public License for more details.

 You should have received a copy of the GNU General Public License along
 with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <fstream>
#include <sstream>
#include "level.h"
#include "error.h"
#include "common.h"
#include "textureloader.h"

Level::Level(Bezier paths[], int npaths, bool loop, bool invert, string name)
        :loop(loop), name(name), invert(invert), startFeedRate(1), endFeedRate(1),
        ballsToDraw(10), ballsFromStart(0), colors(3), backgroundTex(0)
{

}

Level::~Level()
{
    if (backgroundTex)
    {
        glDeleteTextures(1, &backgroundTex);
    }
}

void Level::NewLevel()
{
    loop = false;
    invert = false;
    name = "New Level";
    startFeedRate = 1.0;
    endFeedRate = 1.0;
    ballsToDraw = 20;
    ballsFromStart = 20;
    colors = 5;
    backgroundTex = 0;
    time = 180;
};

void Level::Save()
{
    Save(savePhilename.c_str());
}

void Level::Save(const char *philename)
{
    std::ofstream out(philename);

    // level name
    out << name << endl;
    // number of paths
    out << paths.size() << endl;
    // paths
    for (uint i = 0; i < paths.size(); ++i)
    {
        // number of points
        out << paths[i].points.size() << endl;
        for (uint p = 0; p < paths[i].points.size(); ++p)
        {
            BezierPoint pt = paths[i].points[p];
            out << pt.x << " " << pt.y << " " << pt.cx << " " << pt.cy << endl;
        }
    }

    out << loop << endl;
    out << invert << endl;
    out << startFeedRate << endl;
    out << endFeedRate << endl;
    out << ballsToDraw << endl;
    out << ballsFromStart << endl;
    out << colors << endl;
    out << time << endl;

}

void Level::LoadData(string philename)
{
    savePhilename = philename;

    std::ifstream in(philename.c_str());

    if (!in)
    {
        return;
    }

    paths.clear();
    int npaths;

    istringstream sl;
    string l;

    // name
    getline(in, l);
    Strip(l);
    name = l;

    // number of paths
    getline(in, l);
    sl.str(l);
    sl >> npaths;

    // paths
    for (int i = 0; i < npaths; ++i)
    {
        paths.push_back(Bezier());

        int pl = 0;

        getline(in, l);
        Strip(l);
        sl.clear();
        sl.str(l);
        sl >> pl;

        for (int p = 0; p < pl; ++p)
        {
            getline(in, l);
            sl.clear();
            sl.str(l);

            double x, y, cx, cy;
            sl >> x >> y >> cx >> cy;
            paths[i].points.push_back(BezierPoint (x, y, cx, cy));
        }

    }

    // loop
    getline(in, l);
    sl.clear();
    sl.str(l);
    sl >> loop;

    // invert
    getline(in, l);
    sl.clear();
    sl.str(l);
    sl >> invert;

    // startFeedRate
    getline(in, l);
    sl.clear();
    sl.str(l);
    sl >> startFeedRate;

    // endFeedRate
    getline(in, l);
    sl.clear();
    sl.str(l);
    sl >> endFeedRate;

    // ballsToDraw
    getline(in, l);
    sl.clear();
    sl.str(l);
    sl >> ballsToDraw;

    // ballsFromStart
    getline(in, l);
    sl.clear();
    sl.str(l);
    sl >> ballsFromStart;

    // colours
    getline(in, l);
    sl.clear();
    sl.str(l);
    sl >> colors;

    // time
    getline(in, l);
    sl.clear();
    sl.str(l);
    sl >> time;

}

Level::Level(const char *philename, bool skipGfx)
{
    NewLevel();

    string phn(philename);
    // strip philename of extensions
    phn = phn.substr(0, phn.find_last_of("."));

    LoadData(phn + ".lvl");

    if (!skipGfx)
    {
        phn+=".png";
        backgroundTex = LoadTextureFile(phn.c_str());
    }
}
