/*
 * $Id: yorick.c,v 1.2 2007/07/28 02:15:26 dhmunro Exp $
 *
 * Based on Berkeley Yacc (byacc) parser generated from yorick.y.
 * Modified to handle parser stack overflow gracefully.
 * Modified parser to take single step.
 */
/* Copyright (c) 2005, The Regents of the University of California.
 * All rights reserved.
 * This file is part of yorick (http://yorick.sourceforge.net).
 * Read the accompanying LICENSE file for details.
 */

#include "parse.h"
#include "pstdlib.h"
#include "play.h"
#include <string.h>

/* Sun Fortran formatted I/O stupidly uses a yacc parser which uses
 * the names yyparse and yylex.  Sheesh.  */
static int yylex(void);
static int yyparse_step(int last_state);
static void yyerror(char *msg);

#ifdef DO_DEBUG
#include <stdio.h>
#define YYDEBUG 1
/* must also set yydebug non-0 */
#endif

/* The Yorick grammar requires two "lexical tie-ins"-- both alter the
   token returned by yylex when an end-of-line (EOL) is encountered:
   (1) If parentheses () and square brackets [] are balanced, then
       EOL returns a ';' token, unless the previous token was ';'.
       If the token immediately before EOL was an operator which needs
       a right operand, yylex treats it as if there were an open
       parenthesis-- no ';' token is generated.
   (2) If there are no open control structures (func or struct definitions,
       if, while, do, for or compound statements), then EOL returns the
       YACC end-of-file (EOF) token.  This is applied after rule (1).
 */
static int nOpenCS;     /* The openCS rule increments nOpenCS, while the
                           action when the control structure is complete
                           decrements it.  */
static int parenDepth;  /* The openP rule increments parenDepth; the
                           closeP rule decrements it.  */
static int braceDepth;  /* The openC rule increments braceDepth; the
                           closeC rule decrements it.  */
static int needOperand; /* set if previous token needs right operand */
static int supressSemi; /* set to prevent yylex from returning ';' at EOL
                           -- used for if, while, do, and for */
static int needBody;    /* set if looking for open curly brace */
static int keyCount;    /* key_expr state information */

/* A bizzare lexical tie-in is required for graphics routines which
   need the textual form of their arguments to generate default
   legend strings...  */
static int nQuines, quining;
static void BeginQuine(void);
static void GrabQuine(char *stop);
static int DoQuine(void);

static int EndOfLine(void);

typedef union {
  long l;
  double d;
  Quote q;
  int i;            /* counter or index */
  CodeBlock cb;     /* code block index (see parse.c) */
  Literal lit;      /* literal table index (see parse.c) */
  CBorLit def;      /* CodeBlock or Literal for assign_predicate */
} YYSTYPE;
#define CHAR 257
#define SHORT 258
#define INT 259
#define LONG 260
#define CHAR_ERR 261
#define FLOAT 262
#define DOUBLE 263
#define IMAGINARY 264
#define STRING 265
#define STRING_ERR 266
#define SYSCALL 267
#define NAME 268
#define RFNAME 269
#define FUNC 270
#define STRUCT 271
#define IF 272
#define ELSE 273
#define WHILE 274
#define DO 275
#define FOR 276
#define GOTO 277
#define CONTINUE 278
#define BREAK 279
#define RETURN 280
#define EXTERN 281
#define LOCAL 282
#define DOTDOT 283
#define NEXT_ARG 284
#define MORE_ARGS 285
#define PEQ 286
#define MEQ 287
#define TMSEQ 288
#define DIVEQ 289
#define MODEQ 290
#define SHLEQ 291
#define SHREQ 292
#define ANDEQ 293
#define XOREQ 294
#define OREQ 295
#define OR 296
#define AND 297
#define EQ 298
#define NE 299
#define LE 300
#define GE 301
#define SHL 302
#define SHR 303
#define UNARY 304
#define ARROW 305
#define PLUSPLUS 306
#define MINUSMINUS 307
#define NOINPUT 308
#define YYERRCODE 256
static short yylhs[] = {                                        -1,
    0,    0,    0,    0,    0,    0,    0,    0,    0,   33,
   33,   33,   33,   34,   36,   42,   43,   44,   39,   41,
   45,   45,   12,   12,   12,   12,   12,   49,   12,   12,
   54,   12,   12,   12,   12,   12,   12,   12,   12,   12,
   12,   12,   12,   12,   12,   12,   12,   12,   12,   12,
   12,   12,   13,   13,   10,   10,   10,   10,   11,   11,
   53,   51,   60,   61,   62,   38,   50,   52,   55,   56,
   57,   63,   59,   40,   40,   64,   65,   65,   66,   66,
   66,    2,    2,    8,    8,    8,   29,   35,   67,   28,
   37,   37,   37,   37,   37,   37,   37,   68,   68,   68,
   68,   69,   69,   70,   71,    4,   72,   48,    5,    5,
    5,    6,    6,    7,    7,   73,   73,   32,   32,   32,
   32,   31,   31,   16,   16,   16,   16,   17,   17,    3,
    3,    3,   46,   46,   47,   47,   15,   15,   15,   15,
    9,    1,    1,    1,    1,    1,    1,    1,    1,    1,
    1,   18,   18,   18,   19,   19,   19,   19,   19,   19,
   19,   19,   19,   19,   19,   19,   19,   19,   19,   19,
   19,   19,   19,   24,   24,   24,   23,   23,   22,   22,
   22,   22,   22,   22,   22,   25,   25,   74,   25,   25,
   25,   25,   25,   25,   25,   25,   25,   25,   25,   25,
   25,   25,   25,   14,   20,   20,   58,   75,   58,   21,
   21,   27,   30,   26,   26,   26,   26,   26,   26,   26,
   26,
};
static short yylen[] = {                                         2,
    1,    1,    4,    7,    6,    7,    4,    6,    3,    1,
    3,    2,    2,    0,    1,    1,    1,    1,    2,    2,
    0,    1,    3,    3,    2,    1,    2,    0,    5,    8,
    0,   12,    7,    8,   11,    9,    2,    2,    2,    3,
    3,    3,    2,    5,    3,    5,    3,    7,    5,    4,
    5,    3,    1,    1,    2,    3,    3,    4,    1,    2,
    0,    0,    0,    0,    0,    2,    0,    0,    0,    0,
    0,    0,    2,    3,    4,    1,    1,    3,    2,    5,
    5,    0,    2,    1,    1,    3,    1,    1,    0,    2,
    1,    3,    1,    1,    3,    5,    3,    1,    3,    2,
    4,    2,    4,    1,    0,    2,    0,    2,    1,    1,
    3,    1,    3,    1,    3,    1,    1,    1,    1,    3,
    3,    0,    1,    1,    1,    2,    3,    3,    5,    1,
    1,    1,    1,    3,    1,    3,    1,    2,    2,    3,
    2,    1,    1,    1,    1,    1,    1,    1,    1,    1,
    1,    1,    8,    4,    1,    3,    3,    3,    3,    3,
    3,    3,    3,    3,    3,    3,    3,    3,    3,    3,
    3,    4,    4,    1,    2,    2,    1,    3,    1,    2,
    2,    2,    2,    2,    2,    1,    1,    0,    5,    4,
    3,    3,    4,    2,    3,    3,    2,    2,    3,    4,
    4,    3,    3,    0,    0,    1,    0,    0,    2,    1,
    3,    1,    1,    1,    1,    1,    1,    1,    1,    1,
    1,
};
static short yydefred[] = {                                      0,
    0,  214,  215,  216,  217,  218,  219,  221,  220,    0,
    0,  213,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    1,   15,
   17,    0,    0,    0,   26,   10,    0,  137,    0,    0,
  174,  155,    0,  186,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,   13,   25,   43,    0,    0,
   37,   38,  212,    0,    0,    0,   39,    0,    0,    0,
  124,    0,  187,    0,  133,    0,    0,  135,    0,    0,
    0,    0,    0,    0,  175,  176,  180,    0,    0,    0,
   22,   19,  138,  139,   27,   63,   62,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,  141,  142,  143,  144,  145,  146,
  147,  148,  149,  150,  151,    0,    0,    0,    0,  197,
  198,    0,  107,    0,    0,   12,    0,    0,    0,    0,
    0,    0,    0,   59,   55,    0,   18,    0,  194,    0,
    0,    0,    0,   73,   42,    0,   40,   41,    0,   11,
   23,    0,   24,    0,   16,  191,  192,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,  156,  157,  158,    0,  178,  140,  195,  196,
    0,  105,    0,    0,    0,    0,    0,   88,    0,    9,
    0,    0,  203,  199,    0,   57,   20,   60,   56,  202,
    0,   85,    0,   45,    0,   47,    0,    0,    0,   52,
    0,  127,    0,    0,  134,  136,    0,    0,  154,    0,
  200,    0,    0,    0,  119,    0,  112,  108,  201,  190,
  116,    0,  106,    0,  110,    0,    7,    3,    0,    0,
   90,   58,    0,  193,    0,   62,    0,   62,   50,    0,
    0,  210,    0,    0,    0,    0,  189,    0,   29,    0,
    0,    0,    0,    0,  104,    0,   65,    0,    0,    0,
    0,   76,    0,   82,    0,   44,   65,   46,   65,   49,
    0,   51,    0,    0,  129,   64,  121,    0,  113,  111,
    0,    0,  102,  100,    0,    0,    0,    0,    0,    8,
    5,   82,    0,    0,   77,    0,    0,    0,    0,    0,
   62,  211,    0,    6,    4,   66,    0,    0,    0,    0,
    0,    0,    0,    0,   87,   83,    0,   74,   82,   68,
   53,   54,   33,   48,    0,   65,    0,    0,  153,  101,
    0,  103,   75,    0,   78,    0,   34,    0,    0,    0,
    0,    0,    0,   31,   36,   65,   81,   80,   61,    0,
    0,   35,   32,
};
static short yydgoto[] = {                                      33,
  127,  313,   68,  196,  243,  234,  245,  211,   34,   35,
  143,  342,  343,  148,   37,  235,   71,   38,   39,  263,
  264,   84,   41,   42,   43,   44,   73,  201,  337,   46,
   74,  237,   47,  114,  199,   49,  277,  305,   50,  283,
  145,  166,   51,  149,   92,   77,   79,  270,  133,   52,
  169,  356,  371,  369,   53,   54,   55,  346,   58,  168,
  323,  306,   59,  284,  314,  315,  202,  278,  279,  280,
  197,  194,  246,  192,  347,
};
static short yysindex[] = {                                    294,
  -34,    0,    0,    0,    0,    0,    0,    0,    0,  -21,
    0,    0, -219,   -1,   53, 1000, -238, -215,   36,   36,
 2670, 2670, 1613, 1613, 1613, 2670, 2670, 2670,    0,    0,
    0,   55,    0,   93,    0,    0,   59,    0, 2431,  249,
    0,    0,  -36,    0,    0,   36,  743, -185, 1030,  486,
  -86, -205, -154, -150, -139,    0,    0,    0,   81,   88,
    0,    0,    0,    0, 1613, 1613,    0,   91,  132,  156,
    0, 2431,    0,  159,    0,  162,   10,    0,  116,  199,
  199,  -36,  -36,  152,    0,    0,    0,  -36,  -36,  -36,
    0,    0,    0,    0,    0,    0,    0, 1438, 1438, 1438,
 1438, 1438, 1438, 1438, 1438, 1438, 1438, 1438, 1438, 1438,
 1438, 1438, 1438,  216,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0, 1438, 1438,   25,   32,    0,
    0,   29,    0,   56,   51,    0,   52,   70,  199,  199,
  580,   55,  580,    0,    0,  235,    0, 1438,    0,  -25,
  -20,  646,  -19,    0,    0, 1438,    0,    0, 1438,    0,
    0,   74,    0,   86,    0,    0,    0, 1438, 1438, 1914,
 2272,  523,  202,  202,  214,  214,  214,  214,  550,  550,
  293,  293,    0,    0,    0,  104,    0,    0,    0,    0,
  199,    0, 1492,  321,  199,  199, 1063,    0,   17,    0,
  261,  102,    0,    0,  580,    0,    0,    0,    0,    0,
  -30,    0, 2431,    0, 1117,    0, 1135,  331,  121,    0,
 1190,    0, 2431,  354,    0,    0, 2481,  753,    0, 1438,
    0,  199,  357,  373,    0,  159,    0,    0,    0,    0,
    0, 1613,    0,    0,    0,  390,    0,    0,  -15, -228,
    0,    0, 1438,    0,  199,    0,  199,    0,    0,   -6,
  199,    0,  378,  394, 1438, 2368,    0,   93,    0, 1492,
 1063, 1492,  199,  382,    0,  176,    0,  402,  407,  412,
  336,    0, -123,    0, 2431,    0,    0,    0,    0,    0,
 1317,    0, 1372, 1438,    0,    0,    0,  159,    0,    0,
    0,  261,    0,    0,  261,  199,   22,  195,  210,    0,
    0,    0,  -39,  122,    0,  743,  682,  199,  199,    0,
    0,    0, 1438,    0,    0,    0,  382,  219,  407,  438,
  427,  382,  407,  124,    0,    0,   36,    0,    0,    0,
    0,    0,    0,    0,  433,    0, 1438,  434,    0,    0,
  210,    0,    0, 1424,    0,  227,    0,  682,  394,    0,
  407,  199,  115,    0,    0,    0,    0,    0,    0,  682,
  743,    0,    0,
};
static short yyrindex[] = {                                    426,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
 1728,    0,    0,    0,    0,  449,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,  388,    0,  449,    0,    0,    0,    0,  270, 2340,
    0,    0, 1884,    0, 1786,    0,    8,    0,    0,  -63,
 1478,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,  540,  381,  436,    0,   24,    0,    0,
    0,  135,    0,    0,    0,    0,    0,    0,    0,    0,
    0, 1943, 2001, 2283,    0,    0,    0, 2070, 2160, 2214,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,  830,    0,  935,    0,    0,    0,  241,    0,    0,
  -63,  129,  -63,    0,    0,    0,    0,  449,    0,    0,
    0,  -63,    0,    0,    0,  573,    0,    0,  432,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0, 1143,
  955, 2860, 2773, 2782, 2644, 2681, 2713, 2750, 2560, 2588,
 2501, 2552,    0,    0,    0, 1551,    0,    0,    0,    0,
    0,    0,   31,    0,    0,    0,   83,    0,    0,    0,
    0,    0,    0,    0,  -63,    0,    0,    0,    0,    0,
    0,    0,   20,    0,    0,    0,    0,    0,    0,    0,
  451,    0,  440,  141,    0,    0,  -22,  145,    0,    0,
    0,    0, 1846,  464,    0,  114,    0,    0,    0,    0,
    0,  245,    0,  297,    0,  471,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,  456,  183,    0,    0,  575,    0,  575,
   83,   83,    0,  303,    0,    0,    0,  477,  479,  481,
    0,    0,    0,    0,   -2,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,  247,    0,    0,
  325,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,  -63,  -63,    0,    0,   39,
    0,    0,    0,    0,    0,    0,  338,    0,  489,  491,
    0,    0,  504,    0,    0,    0,  143,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,  449,    0,  190,    0,  -63,  507,   39,
  508,    0,    0,    0,    0,    0,    0,    0,    0,  -63,
  -63,    0,    0,
};
static short yygindex[] = {                                      0,
    0,    0,    0,  335,    0, -184,  284,  213,    0, -183,
  423,    9, -326,    0,  -16,  -10,  -82,  259,   -5,    0,
  239,    1,  350,    0,  614,    0,    5,    0,    0,    0,
  410,  -75,    0,  588,    0,   27,    0,  140,  393,    0,
  240,  228,    0, -119,  447,    0,    0, -121,    0,    0,
 -124,    0,    0,    0,    0,    0,    0,  236,    0,    0,
    0,    0,    0,  322,  292,  267,    0,    0, -264,  301,
    0,    0,    0,    0,    0,
};
#define YYTABLESIZE 3157
static short yytable[] = {                                      69,
   40,  142,  336,   30,   45,   70,  147,    2,   36,  128,
   72,  193,  244,  253,   30,  248,   40,   93,  173,   30,
   30,  173,  276,   94,   56,   87,  210,  281,   72,   75,
   76,  365,  140,   30,   40,  173,  173,   57,   86,  282,
  173,   86,  329,  372,  333,   80,   81,   40,   60,   40,
   40,   45,   78,  162,   45,  136,   30,   61,  144,  328,
   84,  230,  147,   84,  125,  212,  150,  125,  161,  132,
  173,  208,  134,  222,  122,   30,  208,  123,  208,  207,
  208,  208,  125,  208,  137,  138,  361,  301,  122,  122,
   86,  254,  170,  171,  172,  173,  174,  175,  176,  177,
  178,  179,  180,  181,  182,  183,  184,  185,  132,  132,
  188,   62,   84,   91,  132,  132,  132,   95,  324,  151,
  187,  325,  271,  122,  152,   26,  122,   40,   21,  208,
   22,  287,   30,  289,   25,   65,  153,   66,  154,   32,
  122,   40,  213,   40,  282,   45,  155,   45,  156,  144,
  223,  208,   40,  223,  118,  165,   45,  118,  253,  164,
  219,   21,  227,  228,  208,  339,   21,  339,   21,  146,
   21,   21,  118,   21,  163,  152,  215,  217,  152,  221,
  338,  128,  353,   31,  128,  172,   79,  223,  172,   30,
  157,  223,  123,  152,  299,  299,  348,   14,  256,  128,
  258,   79,  172,  172,  262,   40,  251,  172,   67,   45,
   69,   70,   71,  208,  158,   40,  159,   40,   21,   21,
  160,   40,   30,  122,  266,  249,  122,   30,  335,   30,
  214,   30,   30,  128,   30,  216,  220,  172,  113,  165,
  273,  122,   87,  111,  109,  126,  110,  285,  112,  290,
  113,   21,  274,   21,   21,  111,  109,  297,  110,  223,
  112,  103,  223,  104,  223,  223,  223,  275,  129,  130,
  131,  212,  247,  173,  319,  122,  321,  322,  186,   67,
   30,   69,   70,   71,  191,  117,  291,  120,  117,  327,
  120,   40,  189,   40,   40,  208,  208,  208,  208,  190,
  208,  208,  208,  208,  275,  120,  208,  208,  167,  115,
  152,  195,   30,  152,   30,   30,   40,   40,   75,  198,
   45,   45,  208,  208,  340,  200,   26,  147,  152,  113,
  262,   22,   14,   30,  111,   25,   23,  109,   24,  112,
  107,  225,  126,   98,  208,  208,   98,   40,  213,    2,
    3,    4,    5,  226,    6,    7,    8,    9,   40,  229,
   63,   64,   45,  354,  238,  115,  203,  204,  107,   63,
   40,   40,   85,   86,   45,   45,   19,   20,   99,  373,
  206,   99,  209,   32,   31,   21,   21,   21,   21,  259,
   21,   21,   21,   21,  260,   21,   21,   21,   27,   28,
   21,   21,   21,   21,   21,   21,   21,   21,   21,   21,
   21,  265,   21,   21,   85,   86,   32,  268,  231,   21,
   21,  131,  239,  240,  131,   21,  316,   21,  317,   21,
   21,  269,   21,  272,   21,   21,  293,  294,  131,  131,
  172,  172,  303,  304,  252,  307,   30,   30,   30,   30,
  308,   30,   30,   30,   30,  309,   30,   30,   30,  267,
  142,   30,  331,   30,   30,   30,   30,   30,   30,   30,
   30,   30,  122,   30,   30,  122,  132,  332,   21,  132,
  123,  351,  286,  123,  288,  358,  350,  352,  292,  122,
  122,  357,  360,  132,  132,   30,   30,  123,  123,  364,
  302,  105,  106,  107,  108,  370,  122,  107,   89,  205,
   21,  114,   21,   21,  206,  107,  108,   91,   26,   93,
  310,   94,  311,   22,  122,   30,  232,   25,   23,   92,
   24,   95,  123,  326,  116,  117,  118,  119,  120,  121,
  122,  123,  124,  125,   97,  344,  345,  209,   96,    1,
    2,    3,    4,    5,  300,    6,    7,    8,    9,  113,
   10,   11,   12,  205,  111,  109,  363,  110,  224,  112,
   13,   14,   15,   16,   17,   18,   31,   19,   20,  213,
  130,  349,  103,  130,  104,  359,  113,   48,  207,  367,
  368,  111,  109,  250,  110,  366,  112,  130,  130,   27,
   28,   29,  236,  334,  312,  355,  236,  330,   32,    0,
  142,   21,   26,  126,    0,  122,  126,   22,  122,   30,
    0,   25,   23,    0,   24,    0,    0,    0,    0,    0,
  122,  126,  122,  122,   82,   83,    0,    0,    0,   88,
   89,   90,    0,   21,   21,   21,   21,   21,    0,   21,
   21,   21,   21,    0,   21,   21,   21,    0,    0,   21,
    0,   21,   21,   21,   21,   21,   21,   21,   21,   21,
   31,   21,   21,    0,  295,    0,    0,  298,   26,  236,
  236,  236,    0,   22,    0,   30,    0,   25,   23,    0,
   24,    0,    0,   21,   21,   14,   14,   67,    0,   69,
   70,   71,   32,    0,  142,   21,    0,    0,    0,    0,
    0,    0,    0,    0,   26,    0,    0,    0,    0,   22,
    0,   30,    0,   25,   23,    0,   24,    0,    0,    0,
    0,    0,    0,    0,    0,    0,   31,    0,    0,    0,
  341,  141,    2,    3,    4,    5,    0,    6,    7,    8,
    9,    0,   10,   11,   12,    0,    0,    0,    0,    0,
    0,    0,   13,   14,   15,   16,  135,   18,   32,   19,
   20,   21,   31,    0,    0,   26,    0,    0,    0,    0,
   22,    0,   30,    0,   25,   23,    0,   24,    0,  113,
  100,   27,   28,    0,  111,  109,    0,  110,    0,  112,
    0,    0,    0,    0,   32,    0,    0,   21,    0,    0,
    0,    0,  103,    0,  104,    0,    0,    0,    0,    0,
  101,  102,  105,  106,  107,  108,    0,    0,    0,    0,
    0,    0,    0,   31,    0,    0,    2,    3,    4,    5,
    0,    6,    7,    8,    9,    0,   10,   11,   12,    0,
    0,    0,    0,    0,    0,    0,   13,   14,   15,   16,
  135,   18,  188,   19,   20,   32,    0,  188,   21,  188,
  188,  188,  188,  188,  188,    0,   98,    0,   99,    0,
    0,    0,    0,    0,    0,   27,   28,  188,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,  218,    2,    3,    4,    5,    0,    6,    7,    8,
    9,    0,   10,   11,   12,    0,    0,    0,    0,    0,
  188,    0,   13,   14,   15,   16,  135,   18,    0,   19,
   20,    0,    0,    0,    0,    0,    0,    0,    2,    3,
    4,    5,    0,    6,    7,    8,    9,    0,   10,   11,
   12,   27,   28,    0,    0,  188,    0,    0,   13,   14,
   15,   16,  135,   18,    0,   19,   20,  105,    0,    0,
    0,    0,  105,    0,  105,  105,  105,  105,  105,  105,
    0,    0,    0,    0,    0,    0,    0,   27,   28,    0,
    0,    0,  105,    0,    0,  170,    0,    0,  170,    2,
    3,    4,    5,    0,    6,    7,    8,    9,    0,   10,
   11,   12,  170,  170,    0,    0,    0,  170,    0,   13,
   14,   15,   16,  135,   18,  105,   19,   20,    0,    0,
    0,    0,   26,    0,    0,    0,    0,   22,    0,   30,
    0,   25,   65,    0,   66,    0,    0,  170,   27,   28,
  101,  102,  105,  106,  107,  108,    0,    0,   67,    0,
  105,    0,   26,    0,    0,    0,    0,   22,    0,   30,
    0,   25,   23,    0,   24,    0,    0,    0,  170,    0,
  170,    0,    0,    0,    0,    0,  188,  188,  188,  188,
   31,  188,  188,  188,  188,   26,    0,  188,  188,    0,
   22,    0,   30,    0,  242,   65,    0,   66,    0,    0,
    0,    0,  188,  188,  188,    0,    0,    0,    0,    0,
   31,    0,    0,    0,    0,   21,    0,    0,    0,    0,
    0,    0,    0,    0,    0,  188,  188,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,   26,
    0,    0,    0,   31,   22,   21,   30,    0,   25,   23,
    0,   24,    0,    0,    0,    0,    0,   26,    0,    0,
    0,    0,   22,    0,   30,    0,   25,   23,    0,   24,
    0,    0,    0,  171,    0,    0,  171,    0,   21,    0,
    0,  105,  105,  105,  105,    0,  105,  105,  105,  105,
  171,  171,  105,  105,    0,  171,    0,   31,    0,    0,
    0,    0,    0,    0,    0,    0,    0,  105,  105,  105,
    0,    0,   26,    0,    0,   31,    0,   22,    0,   30,
    0,   25,   23,    0,   24,  171,    0,    0,    0,    0,
  105,  105,   21,    0,    0,    0,    0,    0,    0,    0,
  170,  170,    0,    0,    0,    0,    2,    3,    4,    5,
   21,    6,    7,    8,    9,    0,  171,   63,   64,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
   31,    0,    0,   19,   20,  139,    2,    3,    4,    5,
    0,    6,    7,    8,    9,    0,    0,   63,   12,    0,
    0,    0,    0,    0,    0,   27,   28,    0,    0,    0,
    0,    0,    0,   19,   20,   21,    0,    0,    0,    2,
    3,    4,    5,    0,    6,    7,    8,    9,    0,    0,
  233,   64,    0,    0,    0,   27,   28,    0,    0,    0,
    0,    0,    0,    0,    0,  241,   19,   20,    0,   26,
    0,    0,    0,    0,   22,    0,   30,    0,   25,   23,
    0,   24,    0,    0,    0,    0,    0,    0,   27,   28,
    0,    0,  255,    2,    3,    4,    5,    0,    6,    7,
    8,    9,    0,    0,   63,   12,    0,    0,    0,    0,
  257,    2,    3,    4,    5,    0,    6,    7,    8,    9,
   19,   20,   63,   12,   26,    0,    0,   31,    0,   22,
    0,   30,    0,   25,   23,    0,   24,    0,   19,   20,
    0,    0,   27,   28,    0,    0,    0,    0,    0,    0,
  320,    0,    0,    0,    0,    0,    0,    0,  171,  171,
   27,   28,   21,    0,    0,  261,    2,    3,    4,    5,
    0,    6,    7,    8,    9,    0,   26,   63,   12,    0,
    0,   22,   31,   30,    0,   25,   23,    0,   24,    0,
   26,    0,    0,   19,   20,   22,    0,   30,    0,   25,
   23,    0,   24,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,   27,   28,   21,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
  204,    0,    0,    0,   31,  204,    0,  204,    0,  204,
  204,    0,  204,    0,   26,    0,    0,    0,   31,   22,
    0,   30,    0,   25,   65,  204,   66,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,   21,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,   21,    0,    0,    0,    0,  204,    0,
    0,    0,  318,    2,    3,    4,    5,    0,    6,    7,
    8,    9,   31,   62,   63,   12,    0,    0,   62,    0,
   62,    0,   62,   62,    0,   62,    0,    0,    0,    0,
   19,   20,    0,  204,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,   21,    0,    0,
    0,    0,   27,   28,    0,    0,    0,    0,    2,    3,
    4,    5,    0,    6,    7,    8,    9,    0,    0,   63,
   12,   62,    0,    0,    0,   26,    0,    0,    0,    0,
   22,    0,   30,    0,   25,   19,   20,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,   62,   27,   28,  362,
    2,    3,    4,    5,    0,    6,    7,    8,    9,    0,
    0,   63,   12,    0,    2,    3,    4,    5,    0,    6,
    7,    8,    9,   31,    0,   63,   12,   19,   20,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,   19,   20,    0,    0,    0,    0,    0,    0,   27,
   28,    0,    0,    0,  204,  204,  204,  204,   21,  204,
  204,  204,  204,   27,   28,  204,  204,    0,    2,    3,
    4,    5,    0,    6,    7,    8,    9,    0,    0,  233,
   64,  204,  204,    0,  212,  212,    0,  212,    0,  212,
  212,  212,  212,  212,  212,   19,   20,    0,    0,    0,
    0,    0,    0,  204,  204,   72,  212,  212,  212,  212,
  212,    0,    0,    0,    0,    0,    0,   27,   28,    0,
    0,    0,    0,    0,    0,    0,    0,   62,   62,   62,
   62,    0,   62,   62,   62,   62,    0,    0,   62,   62,
    0,  212,  187,  187,    0,  187,    0,  187,  187,   28,
  187,  187,  187,    0,   62,   62,    0,    0,    0,    0,
    0,    0,    0,    0,  187,  187,  187,  187,  187,    0,
    0,  212,    0,  212,    0,    0,   62,   62,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    2,
    3,    4,    5,    0,    6,    7,    8,    9,    0,  187,
   63,   12,  212,  212,    0,  212,  212,  212,  212,  212,
  212,  212,  212,    0,    0,    0,   19,   20,    0,    0,
    0,    0,    0,  212,  212,  212,    0,  212,    0,  187,
    0,  187,    0,    0,    0,    0,    0,    0,   27,   28,
  179,  179,    0,    0,  179,  179,  179,  179,  179,    0,
  179,    0,    0,    0,    0,    0,    0,    0,    0,  212,
    0,  179,  179,  179,  179,  179,  179,    0,    0,    0,
  113,  100,    0,    0,    0,  111,  109,    0,  110,    0,
  112,    0,    0,    0,    0,    0,    0,    0,    0,  212,
    0,  212,    0,  103,    0,  104,  179,  179,    0,  182,
  182,    0,    0,  182,  182,  182,  182,  182,    0,  182,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
  182,  182,  182,  182,  182,  182,    0,  179,    0,  179,
    0,    0,    0,  212,  212,  212,  212,  212,  212,  212,
  212,  212,  212,  212,  212,  212,  212,  212,  212,  212,
  212,    0,  212,  212,  212,  182,  182,  181,  181,   99,
    0,  181,  181,  181,  181,  181,    0,  181,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,  181,  181,
  181,  181,  181,  181,    0,    0,  182,    0,  182,    0,
    0,  187,  187,  187,  187,  187,  187,  187,  187,  187,
  187,  187,  187,  187,  187,  187,  187,  187,  187,    0,
  187,  187,  187,  181,  181,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,  183,  183,    0,    0,
  183,  183,  183,  183,  183,    0,  183,    0,    0,    0,
    0,    0,    0,    0,  181,    0,  181,  183,  183,  183,
  183,  183,  183,    0,    0,    0,    0,    0,    0,    0,
    0,  212,  212,  212,  212,  212,  212,  212,  212,    0,
  212,  212,  212,    0,    0,    0,    0,    0,    0,    0,
    0,    0,  183,  183,    0,    0,    0,    0,    0,  179,
  179,  179,  179,  179,  179,  179,  179,  179,  179,  179,
  179,  179,  179,  179,  179,  179,  179,    0,    0,    0,
    0,    0,    0,  183,    0,  183,  184,  184,    0,    0,
  184,  184,  184,  184,  184,    0,  184,    0,    0,    0,
    0,  101,  102,  105,  106,  107,  108,  184,  184,  184,
  184,  184,  184,    0,    0,    0,    0,    0,  182,  182,
  182,  182,  182,  182,  182,  182,  182,  182,  182,  182,
  182,  182,  182,  182,  182,  182,    0,    0,    0,    0,
  185,  185,  184,  184,  185,  185,  185,  185,  185,    0,
  185,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,  185,  185,  185,  185,  185,  185,    0,    0,    0,
    0,    0,    0,  184,    0,  184,  181,  181,  181,  181,
  181,  181,  181,  181,  181,  181,  181,  181,  181,  181,
  181,  181,  181,  181,    0,    0,  185,  185,  113,  100,
    0,    0,    0,  111,  109,    0,  110,    0,  112,  177,
  177,    0,    0,  177,  177,  177,  177,  177,    0,  177,
    0,  103,    0,  104,    0,    0,    0,  185,    0,  185,
  177,  177,  177,    0,  177,  177,    0,    0,    0,    0,
    0,    0,    0,    0,    0,  183,  183,  183,  183,  183,
  183,  183,  183,  183,  183,  183,  183,  183,  183,  183,
  183,  183,  183,    0,    0,  177,  177,  177,    0,    0,
  177,  177,  177,  177,  177,    0,  177,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,  177,  177,  177,
    0,  177,  177,    0,  113,  100,  177,    0,  177,  111,
  109,    0,  110,    0,  112,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,  296,    0,  103,    0,  104,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,  184,  184,  184,  184,  184,
  184,  184,  184,  184,  184,  184,  184,  184,  184,  184,
  184,  184,  184,  177,    0,  177,    0,  113,  100,    0,
    0,    0,  111,  109,    0,  110,    0,  112,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
  103,   98,  104,   99,    0,    0,    0,    0,    0,  185,
  185,  185,  185,  185,  185,  185,  185,  185,  185,  185,
  185,  185,  185,  185,  185,  185,  185,  113,  100,    0,
    0,    0,  111,  109,    0,  110,    0,  112,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,  159,    0,
  103,  159,  104,  159,  159,  159,    0,    0,    0,    0,
    0,    0,    0,    0,   98,    0,   99,    0,  159,  159,
  159,    0,  159,  159,    0,    0,    0,    0,    0,  101,
  102,  105,  106,  107,  108,    0,    0,    0,  177,  177,
  177,  177,  177,  177,  177,  177,    0,    0,    0,  160,
    0,    0,  160,  159,  160,  160,  160,  161,    0,    0,
  161,    0,    0,  161,   98,    0,   99,    0,    0,  160,
  160,  160,    0,  160,  160,    0,    0,  161,  161,  161,
    0,  161,  161,    0,  159,  162,  159,    0,  162,    0,
    0,  162,    0,    0,    0,  177,  177,  177,  177,  177,
  177,  177,  177,    0,  160,  162,  162,  162,    0,  162,
  162,    0,  161,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,   96,   97,  101,  102,  105,  106,  107,
  108,    0,    0,    0,    0,  160,    0,  160,    0,    0,
  162,  163,    0,  161,  163,  161,    0,  163,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,  163,  163,  163,    0,  163,  163,    0,    0,   30,
    0,  162,    0,  162,    0,    0,    0,    0,  164,    0,
    0,  164,    0,    0,  164,    0,   96,   97,  101,  102,
  105,  106,  107,  108,    0,    0,  163,    0,  164,  164,
  164,    0,  164,  164,    0,    0,    0,    0,    0,    0,
  165,    0,    0,  165,    0,    0,  165,    0,    0,    0,
   31,    0,    0,    0,    0,    0,    0,  163,    0,  163,
  165,  165,  165,  164,  165,  165,    0,   97,  101,  102,
  105,  106,  107,  108,    0,    0,    0,  166,    0,    0,
  166,    0,    0,  166,    0,    0,  159,  159,  159,  159,
  159,  159,  159,  159,  164,  165,  164,  166,  166,  166,
  167,  166,  166,  167,    0,    0,  167,    0,    0,  168,
    0,    0,  168,    0,    0,  168,    0,    0,    0,    0,
  167,  167,    0,    0,    0,  167,  165,    0,  165,  168,
  168,    0,  166,    0,  168,    0,    0,  160,  160,  160,
  160,  160,  160,  160,  160,  161,  161,  161,  161,  161,
  161,  161,  161,    0,    0,  167,    0,    0,    0,    0,
    0,    0,    0,  166,  168,  166,    0,    0,    0,    0,
    0,    0,    0,  162,  162,  162,  162,  162,  162,  162,
  162,    0,    0,    0,    0,    0,  167,  169,  167,    0,
  169,    0,    0,  169,    0,  168,    0,  168,    0,    0,
    0,    0,    0,    0,    0,    0,    0,  169,  169,    0,
    0,    0,  169,    0,    0,    0,    2,    3,    4,    5,
    0,    6,    7,    8,    9,    0,    0,   63,   12,  163,
  163,  163,  163,  163,  163,    0,    0,    0,    0,    0,
    0,    0,  169,   19,   20,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,  164,  164,  164,  164,
  164,  164,    0,  169,    0,  169,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,  165,  165,
  165,  165,  165,  165,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,  166,  166,  166,  166,  166,
  166,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,  167,  167,
  167,  167,    0,    0,    0,    0,    0,  168,  168,  168,
  168,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,  169,  169,
};
static short yycheck[] = {                                      16,
    0,  125,   42,   40,    0,   16,   93,    0,    0,   46,
   16,  133,  197,   44,   40,  199,   16,   34,   41,   40,
   40,   44,   38,   34,   59,   25,  146,  256,   34,  268,
  269,  358,   49,   40,   34,   58,   59,   59,   41,  268,
   63,   44,  307,  370,  309,   19,   20,   47,  268,   49,
   50,   47,  268,   44,   50,   47,   40,   59,   50,   38,
   41,  186,   93,   44,   41,  148,  272,   44,   59,   43,
   93,   33,   46,  156,   44,   40,   38,   58,   40,   41,
   42,   43,   59,   45,  270,  271,  351,  272,   58,   59,
   93,  211,   98,   99,  100,  101,  102,  103,  104,  105,
  106,  107,  108,  109,  110,  111,  112,  113,   82,   83,
  127,   59,   93,   59,   88,   89,   90,   59,  302,  274,
  126,  305,  244,   41,  275,   33,   44,  127,    0,   91,
   38,  256,   40,  258,   42,   43,  276,   45,   58,  123,
   58,  141,  148,  143,  268,  141,   59,  143,   58,  141,
  156,  143,  152,  159,   41,   41,  152,   44,   44,   44,
  152,   33,  168,  169,  126,   44,   38,   44,   40,  256,
   42,   43,   59,   45,   59,   41,  150,  151,   44,  153,
   59,   41,   59,   91,   44,   41,   44,  193,   44,    0,
   59,  197,   58,   59,  270,  271,  321,   63,  215,   59,
  217,   59,   58,   59,  221,  205,  202,   63,  272,  205,
  274,  275,  276,  205,   59,  215,   58,  217,  126,   91,
   59,  221,   33,   41,  230,  199,   44,   38,  268,   40,
  256,   42,   43,   93,   45,  256,  256,   93,   37,   41,
  256,   59,  242,   42,   43,   94,   45,  253,   47,  256,
   37,  123,  268,  125,  126,   42,   43,  268,   45,  265,
   47,   60,  268,   62,  270,  271,  272,  283,  305,  306,
  307,  354,  256,  296,  291,   93,  293,  294,   63,  272,
   91,  274,  275,  276,  256,   41,  260,   41,   44,  268,
   44,  291,  268,  293,  294,  257,  258,  259,  260,  268,
  262,  263,  264,  265,  283,   59,  268,  269,   81,   61,
   41,  256,  123,   44,  125,  126,  316,  317,  268,  268,
  316,  317,  284,  285,  316,  256,   33,   93,   59,   37,
  347,   38,   63,   40,   42,   42,   43,   41,   45,   47,
   44,  268,   94,   41,  306,  307,   44,  347,  354,  257,
  258,  259,  260,  268,  262,  263,  264,  265,  358,  256,
  268,  269,  358,  337,   44,   41,  139,  140,   44,  268,
  370,  371,   23,   24,  370,  371,  284,  285,   41,  371,
  141,   44,  143,  123,   91,  257,  258,  259,  260,   59,
  262,  263,  264,  265,  274,  267,  268,  269,  306,  307,
  272,  273,  274,  275,  276,  277,  278,  279,  280,  281,
  282,   58,  284,  285,   65,   66,  123,   61,  191,  126,
   33,   41,  195,  196,   44,   38,  287,   40,  289,   42,
   43,   59,   45,   44,  306,  307,   59,   44,   58,   59,
  296,  297,   61,  268,  205,   44,  257,  258,  259,  260,
   44,  262,  263,  264,  265,   44,  267,  268,  269,  232,
  125,  272,  268,  274,  275,  276,  277,  278,  279,  280,
  281,  282,   41,  284,  285,   44,   41,  268,   91,   44,
   41,   44,  255,   44,  257,  346,  268,   61,  261,   58,
   59,   59,   59,   58,   59,  306,  307,   58,   59,  273,
  273,  300,  301,  302,  303,  366,   58,   44,  268,   59,
  123,   41,  125,  126,   59,  302,  303,   41,   33,   41,
  281,   41,  283,   38,   93,   40,  192,   42,   43,   41,
   45,   41,   93,  306,  286,  287,  288,  289,  290,  291,
  292,  293,  294,  295,   41,  318,  319,   41,   41,  256,
  257,  258,  259,  260,  271,  262,  263,  264,  265,   37,
  267,  268,  269,  141,   42,   43,  354,   45,  159,   47,
  277,  278,  279,  280,  281,  282,   91,  284,  285,   40,
   41,  323,   60,   44,   62,  347,   37,    0,  142,  362,
  363,   42,   43,  201,   45,  360,   47,   58,   59,  306,
  307,  308,  193,  312,  283,  339,  197,  307,  123,   -1,
  125,  126,   33,   41,   -1,   41,   44,   38,   44,   40,
   -1,   42,   43,   -1,   45,   -1,   -1,   -1,   -1,   -1,
   58,   59,   58,   59,   21,   22,   -1,   -1,   -1,   26,
   27,   28,   -1,  256,  257,  258,  259,  260,   -1,  262,
  263,  264,  265,   -1,  267,  268,  269,   -1,   -1,  272,
   -1,  274,  275,  276,  277,  278,  279,  280,  281,  282,
   91,  284,  285,   -1,  265,   -1,   -1,  268,   33,  270,
  271,  272,   -1,   38,   -1,   40,   -1,   42,   43,   -1,
   45,   -1,   -1,  306,  307,  270,  271,  272,   -1,  274,
  275,  276,  123,   -1,  125,  126,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   33,   -1,   -1,   -1,   -1,   38,
   -1,   40,   -1,   42,   43,   -1,   45,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   91,   -1,   -1,   -1,
   59,  256,  257,  258,  259,  260,   -1,  262,  263,  264,
  265,   -1,  267,  268,  269,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,  277,  278,  279,  280,  281,  282,  123,  284,
  285,  126,   91,   -1,   -1,   33,   -1,   -1,   -1,   -1,
   38,   -1,   40,   -1,   42,   43,   -1,   45,   -1,   37,
   38,  306,  307,   -1,   42,   43,   -1,   45,   -1,   47,
   -1,   -1,   -1,   -1,  123,   -1,   -1,  126,   -1,   -1,
   -1,   -1,   60,   -1,   62,   -1,   -1,   -1,   -1,   -1,
  298,  299,  300,  301,  302,  303,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   91,   -1,   -1,  257,  258,  259,  260,
   -1,  262,  263,  264,  265,   -1,  267,  268,  269,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,  277,  278,  279,  280,
  281,  282,   33,  284,  285,  123,   -1,   38,  126,   40,
   41,   42,   43,   44,   45,   -1,  124,   -1,  126,   -1,
   -1,   -1,   -1,   -1,   -1,  306,  307,   58,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,  256,  257,  258,  259,  260,   -1,  262,  263,  264,
  265,   -1,  267,  268,  269,   -1,   -1,   -1,   -1,   -1,
   91,   -1,  277,  278,  279,  280,  281,  282,   -1,  284,
  285,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  257,  258,
  259,  260,   -1,  262,  263,  264,  265,   -1,  267,  268,
  269,  306,  307,   -1,   -1,  126,   -1,   -1,  277,  278,
  279,  280,  281,  282,   -1,  284,  285,   33,   -1,   -1,
   -1,   -1,   38,   -1,   40,   41,   42,   43,   44,   45,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,  306,  307,   -1,
   -1,   -1,   58,   -1,   -1,   41,   -1,   -1,   44,  257,
  258,  259,  260,   -1,  262,  263,  264,  265,   -1,  267,
  268,  269,   58,   59,   -1,   -1,   -1,   63,   -1,  277,
  278,  279,  280,  281,  282,   91,  284,  285,   -1,   -1,
   -1,   -1,   33,   -1,   -1,   -1,   -1,   38,   -1,   40,
   -1,   42,   43,   -1,   45,   -1,   -1,   93,  306,  307,
  298,  299,  300,  301,  302,  303,   -1,   -1,   59,   -1,
  126,   -1,   33,   -1,   -1,   -1,   -1,   38,   -1,   40,
   -1,   42,   43,   -1,   45,   -1,   -1,   -1,  124,   -1,
  126,   -1,   -1,   -1,   -1,   -1,  257,  258,  259,  260,
   91,  262,  263,  264,  265,   33,   -1,  268,  269,   -1,
   38,   -1,   40,   -1,   42,   43,   -1,   45,   -1,   -1,
   -1,   -1,  283,  284,  285,   -1,   -1,   -1,   -1,   -1,
   91,   -1,   -1,   -1,   -1,  126,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,  306,  307,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   33,
   -1,   -1,   -1,   91,   38,  126,   40,   -1,   42,   43,
   -1,   45,   -1,   -1,   -1,   -1,   -1,   33,   -1,   -1,
   -1,   -1,   38,   -1,   40,   -1,   42,   43,   -1,   45,
   -1,   -1,   -1,   41,   -1,   -1,   44,   -1,  126,   -1,
   -1,  257,  258,  259,  260,   -1,  262,  263,  264,  265,
   58,   59,  268,  269,   -1,   63,   -1,   91,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,  283,  284,  285,
   -1,   -1,   33,   -1,   -1,   91,   -1,   38,   -1,   40,
   -1,   42,   43,   -1,   45,   93,   -1,   -1,   -1,   -1,
  306,  307,  126,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  296,  297,   -1,   -1,   -1,   -1,  257,  258,  259,  260,
  126,  262,  263,  264,  265,   -1,  124,  268,  269,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   91,   -1,   -1,  284,  285,  256,  257,  258,  259,  260,
   -1,  262,  263,  264,  265,   -1,   -1,  268,  269,   -1,
   -1,   -1,   -1,   -1,   -1,  306,  307,   -1,   -1,   -1,
   -1,   -1,   -1,  284,  285,  126,   -1,   -1,   -1,  257,
  258,  259,  260,   -1,  262,  263,  264,  265,   -1,   -1,
  268,  269,   -1,   -1,   -1,  306,  307,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,  283,  284,  285,   -1,   33,
   -1,   -1,   -1,   -1,   38,   -1,   40,   -1,   42,   43,
   -1,   45,   -1,   -1,   -1,   -1,   -1,   -1,  306,  307,
   -1,   -1,  256,  257,  258,  259,  260,   -1,  262,  263,
  264,  265,   -1,   -1,  268,  269,   -1,   -1,   -1,   -1,
  256,  257,  258,  259,  260,   -1,  262,  263,  264,  265,
  284,  285,  268,  269,   33,   -1,   -1,   91,   -1,   38,
   -1,   40,   -1,   42,   43,   -1,   45,   -1,  284,  285,
   -1,   -1,  306,  307,   -1,   -1,   -1,   -1,   -1,   -1,
   59,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  296,  297,
  306,  307,  126,   -1,   -1,  256,  257,  258,  259,  260,
   -1,  262,  263,  264,  265,   -1,   33,  268,  269,   -1,
   -1,   38,   91,   40,   -1,   42,   43,   -1,   45,   -1,
   33,   -1,   -1,  284,  285,   38,   -1,   40,   -1,   42,
   43,   -1,   45,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,  306,  307,  126,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   33,   -1,   -1,   -1,   91,   38,   -1,   40,   -1,   42,
   43,   -1,   45,   -1,   33,   -1,   -1,   -1,   91,   38,
   -1,   40,   -1,   42,   43,   58,   45,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  126,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,  126,   -1,   -1,   -1,   -1,   91,   -1,
   -1,   -1,  256,  257,  258,  259,  260,   -1,  262,  263,
  264,  265,   91,   33,  268,  269,   -1,   -1,   38,   -1,
   40,   -1,   42,   43,   -1,   45,   -1,   -1,   -1,   -1,
  284,  285,   -1,  126,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,  126,   -1,   -1,
   -1,   -1,  306,  307,   -1,   -1,   -1,   -1,  257,  258,
  259,  260,   -1,  262,  263,  264,  265,   -1,   -1,  268,
  269,   91,   -1,   -1,   -1,   33,   -1,   -1,   -1,   -1,
   38,   -1,   40,   -1,   42,  284,  285,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,  126,  306,  307,  256,
  257,  258,  259,  260,   -1,  262,  263,  264,  265,   -1,
   -1,  268,  269,   -1,  257,  258,  259,  260,   -1,  262,
  263,  264,  265,   91,   -1,  268,  269,  284,  285,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,  284,  285,   -1,   -1,   -1,   -1,   -1,   -1,  306,
  307,   -1,   -1,   -1,  257,  258,  259,  260,  126,  262,
  263,  264,  265,  306,  307,  268,  269,   -1,  257,  258,
  259,  260,   -1,  262,  263,  264,  265,   -1,   -1,  268,
  269,  284,  285,   -1,   37,   38,   -1,   40,   -1,   42,
   43,   44,   45,   46,   47,  284,  285,   -1,   -1,   -1,
   -1,   -1,   -1,  306,  307,   58,   59,   60,   61,   62,
   63,   -1,   -1,   -1,   -1,   -1,   -1,  306,  307,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,  257,  258,  259,
  260,   -1,  262,  263,  264,  265,   -1,   -1,  268,  269,
   -1,   94,   37,   38,   -1,   40,   -1,   42,   43,   44,
   45,   46,   47,   -1,  284,  285,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   59,   60,   61,   62,   63,   -1,
   -1,  124,   -1,  126,   -1,   -1,  306,  307,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  257,
  258,  259,  260,   -1,  262,  263,  264,  265,   -1,   94,
  268,  269,   37,   38,   -1,   40,   41,   42,   43,   44,
   45,   46,   47,   -1,   -1,   -1,  284,  285,   -1,   -1,
   -1,   -1,   -1,   58,   59,   60,   -1,   62,   -1,  124,
   -1,  126,   -1,   -1,   -1,   -1,   -1,   -1,  306,  307,
   37,   38,   -1,   -1,   41,   42,   43,   44,   45,   -1,
   47,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   94,
   -1,   58,   59,   60,   61,   62,   63,   -1,   -1,   -1,
   37,   38,   -1,   -1,   -1,   42,   43,   -1,   45,   -1,
   47,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  124,
   -1,  126,   -1,   60,   -1,   62,   93,   94,   -1,   37,
   38,   -1,   -1,   41,   42,   43,   44,   45,   -1,   47,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   58,   59,   60,   61,   62,   63,   -1,  124,   -1,  126,
   -1,   -1,   -1,  286,  287,  288,  289,  290,  291,  292,
  293,  294,  295,  296,  297,  298,  299,  300,  301,  302,
  303,   -1,  305,  306,  307,   93,   94,   37,   38,  126,
   -1,   41,   42,   43,   44,   45,   -1,   47,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   58,   59,
   60,   61,   62,   63,   -1,   -1,  124,   -1,  126,   -1,
   -1,  286,  287,  288,  289,  290,  291,  292,  293,  294,
  295,  296,  297,  298,  299,  300,  301,  302,  303,   -1,
  305,  306,  307,   93,   94,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   37,   38,   -1,   -1,
   41,   42,   43,   44,   45,   -1,   47,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,  124,   -1,  126,   58,   59,   60,
   61,   62,   63,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,  296,  297,  298,  299,  300,  301,  302,  303,   -1,
  305,  306,  307,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   93,   94,   -1,   -1,   -1,   -1,   -1,  286,
  287,  288,  289,  290,  291,  292,  293,  294,  295,  296,
  297,  298,  299,  300,  301,  302,  303,   -1,   -1,   -1,
   -1,   -1,   -1,  124,   -1,  126,   37,   38,   -1,   -1,
   41,   42,   43,   44,   45,   -1,   47,   -1,   -1,   -1,
   -1,  298,  299,  300,  301,  302,  303,   58,   59,   60,
   61,   62,   63,   -1,   -1,   -1,   -1,   -1,  286,  287,
  288,  289,  290,  291,  292,  293,  294,  295,  296,  297,
  298,  299,  300,  301,  302,  303,   -1,   -1,   -1,   -1,
   37,   38,   93,   94,   41,   42,   43,   44,   45,   -1,
   47,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   58,   59,   60,   61,   62,   63,   -1,   -1,   -1,
   -1,   -1,   -1,  124,   -1,  126,  286,  287,  288,  289,
  290,  291,  292,  293,  294,  295,  296,  297,  298,  299,
  300,  301,  302,  303,   -1,   -1,   93,   94,   37,   38,
   -1,   -1,   -1,   42,   43,   -1,   45,   -1,   47,   37,
   38,   -1,   -1,   41,   42,   43,   44,   45,   -1,   47,
   -1,   60,   -1,   62,   -1,   -1,   -1,  124,   -1,  126,
   58,   59,   60,   -1,   62,   63,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,  286,  287,  288,  289,  290,
  291,  292,  293,  294,  295,  296,  297,  298,  299,  300,
  301,  302,  303,   -1,   -1,   93,   37,   38,   -1,   -1,
   41,   42,   43,   44,   45,   -1,   47,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   58,   59,   60,
   -1,   62,   63,   -1,   37,   38,  124,   -1,  126,   42,
   43,   -1,   45,   -1,   47,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   58,   -1,   60,   -1,   62,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,  286,  287,  288,  289,  290,
  291,  292,  293,  294,  295,  296,  297,  298,  299,  300,
  301,  302,  303,  124,   -1,  126,   -1,   37,   38,   -1,
   -1,   -1,   42,   43,   -1,   45,   -1,   47,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   60,  124,   62,  126,   -1,   -1,   -1,   -1,   -1,  286,
  287,  288,  289,  290,  291,  292,  293,  294,  295,  296,
  297,  298,  299,  300,  301,  302,  303,   37,   38,   -1,
   -1,   -1,   42,   43,   -1,   45,   -1,   47,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   38,   -1,
   60,   41,   62,   43,   44,   45,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,  124,   -1,  126,   -1,   58,   59,
   60,   -1,   62,   63,   -1,   -1,   -1,   -1,   -1,  298,
  299,  300,  301,  302,  303,   -1,   -1,   -1,  296,  297,
  298,  299,  300,  301,  302,  303,   -1,   -1,   -1,   38,
   -1,   -1,   41,   93,   43,   44,   45,   38,   -1,   -1,
   41,   -1,   -1,   44,  124,   -1,  126,   -1,   -1,   58,
   59,   60,   -1,   62,   63,   -1,   -1,   58,   59,   60,
   -1,   62,   63,   -1,  124,   38,  126,   -1,   41,   -1,
   -1,   44,   -1,   -1,   -1,  296,  297,  298,  299,  300,
  301,  302,  303,   -1,   93,   58,   59,   60,   -1,   62,
   63,   -1,   93,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,  296,  297,  298,  299,  300,  301,  302,
  303,   -1,   -1,   -1,   -1,  124,   -1,  126,   -1,   -1,
   93,   38,   -1,  124,   41,  126,   -1,   44,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   58,   59,   60,   -1,   62,   63,   -1,   -1,   40,
   -1,  124,   -1,  126,   -1,   -1,   -1,   -1,   38,   -1,
   -1,   41,   -1,   -1,   44,   -1,  296,  297,  298,  299,
  300,  301,  302,  303,   -1,   -1,   93,   -1,   58,   59,
   60,   -1,   62,   63,   -1,   -1,   -1,   -1,   -1,   -1,
   38,   -1,   -1,   41,   -1,   -1,   44,   -1,   -1,   -1,
   91,   -1,   -1,   -1,   -1,   -1,   -1,  124,   -1,  126,
   58,   59,   60,   93,   62,   63,   -1,  297,  298,  299,
  300,  301,  302,  303,   -1,   -1,   -1,   38,   -1,   -1,
   41,   -1,   -1,   44,   -1,   -1,  296,  297,  298,  299,
  300,  301,  302,  303,  124,   93,  126,   58,   59,   60,
   38,   62,   63,   41,   -1,   -1,   44,   -1,   -1,   38,
   -1,   -1,   41,   -1,   -1,   44,   -1,   -1,   -1,   -1,
   58,   59,   -1,   -1,   -1,   63,  124,   -1,  126,   58,
   59,   -1,   93,   -1,   63,   -1,   -1,  296,  297,  298,
  299,  300,  301,  302,  303,  296,  297,  298,  299,  300,
  301,  302,  303,   -1,   -1,   93,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,  124,   93,  126,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,  296,  297,  298,  299,  300,  301,  302,
  303,   -1,   -1,   -1,   -1,   -1,  124,   38,  126,   -1,
   41,   -1,   -1,   44,   -1,  124,   -1,  126,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   58,   59,   -1,
   -1,   -1,   63,   -1,   -1,   -1,  257,  258,  259,  260,
   -1,  262,  263,  264,  265,   -1,   -1,  268,  269,  296,
  297,  298,  299,  300,  301,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   93,  284,  285,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,  296,  297,  298,  299,
  300,  301,   -1,  124,   -1,  126,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  296,  297,
  298,  299,  300,  301,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,  296,  297,  298,  299,  300,
  301,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  296,  297,
  298,  299,   -1,   -1,   -1,   -1,   -1,  296,  297,  298,
  299,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,  296,  297,
};
#define YYFINAL 33
#ifndef YYDEBUG
#define YYDEBUG 0
#endif
#define YYMAXTOKEN 308
#if YYDEBUG
static char *yyname[] = {
"end-of-file",0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
"'!'",0,0,0,"'%'","'&'",0,"'('","')'","'*'","'+'","','","'-'","'.'","'/'",0,0,0,
0,0,0,0,0,0,0,"':'","';'","'<'","'='","'>'","'?'",0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,"'['",0,"']'","'^'",0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,"'{'","'|'","'}'","'~'",0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,"CHAR","SHORT",
"INT","LONG","CHAR_ERR","FLOAT","DOUBLE","IMAGINARY","STRING","STRING_ERR",
"SYSCALL","NAME","RFNAME","FUNC","STRUCT","IF","ELSE","WHILE","DO","FOR","GOTO",
"CONTINUE","BREAK","RETURN","EXTERN","LOCAL","DOTDOT","NEXT_ARG","MORE_ARGS",
"PEQ","MEQ","TMSEQ","DIVEQ","MODEQ","SHLEQ","SHREQ","ANDEQ","XOREQ","OREQ","OR",
"AND","EQ","NE","LE","GE","SHL","SHR","UNARY","ARROW","PLUSPLUS","MINUSMINUS",
"NOINPUT",
};
static char *yyrule[] = {
"$accept : program_unit",
"program_unit : NOINPUT",
"program_unit : main_program",
"program_unit : openCS FUNC func_name compound",
"program_unit : openCS FUNC func_name openP param_list closeP_wait compound",
"program_unit : openCS STRUCT struct_name openC declar_list closeC",
"program_unit : openCS FUNC func_name openP error closeP compound",
"program_unit : openCS FUNC func_name error",
"program_unit : openCS STRUCT struct_name openC error closeC",
"program_unit : openCS STRUCT error",
"main_program : statement",
"main_program : EXTERN RFNAME ';'",
"main_program : main_program statement",
"main_program : error ';'",
"openCS :",
"openP : '('",
"closeP : ')'",
"openB : '['",
"closeB : ']'",
"openC : '{' optional_semi",
"closeC : '}' optional_semi",
"optional_semi :",
"optional_semi : ';'",
"statement : EXTERN extern_vars ';'",
"statement : LOCAL local_vars ';'",
"statement : SYSCALL ';'",
"statement : compound",
"statement : assign_expr ';'",
"$$1 :",
"statement : variable $$1 arg_sep lj_arg_list ';'",
"statement : if_test IF openP assign_expr brfalse closeP_wait statement if_done",
"$$2 :",
"statement : if_test IF openP assign_expr brfalse closeP_wait statement if_done ELSE $$2 branch statement",
"statement : wloop WHILE openP assign_expr brfalse closeP_wait nil_statement",
"statement : dloop DO statement WHILE openP assign_expr closeP ';'",
"statement : floop FOR openP for_expr ';' assign_expr brfalse ';' inc_expr closeP_wait nil_statement",
"statement : floop FOR openP for_expr ';' ';' inc_expr closeP_wait nil_statement",
"statement : CONTINUE ';'",
"statement : BREAK ';'",
"statement : RETURN ';'",
"statement : RETURN assign_expr ';'",
"statement : RETURN range_expr ';'",
"statement : GOTO NAME ';'",
"statement : NAME lab_delim",
"statement : if_test IF openP error closeP",
"statement : if_test IF error",
"statement : wloop WHILE openP error closeP",
"statement : wloop WHILE error",
"statement : dloop DO statement WHILE openP error closeP",
"statement : dloop DO statement WHILE error",
"statement : dloop DO error ';'",
"statement : floop FOR openP error closeP",
"statement : floop FOR error",
"nil_statement : ';'",
"nil_statement : statement",
"compound : openC closeC",
"compound : openC statement_list closeC",
"compound : openC error closeC",
"compound : openC error statement_list closeC",
"statement_list : statement",
"statement_list : statement_list statement",
"branch :",
"brfalse :",
"brtrue :",
"branch_pop :",
"$$3 :",
"closeP_wait : $$3 closeP",
"if_test :",
"if_done :",
"wloop :",
"dloop :",
"floop :",
"$$4 :",
"lab_delim : $$4 ':'",
"declar_list : data_type declarators ';'",
"declar_list : declar_list data_type declarators ';'",
"data_type : NAME",
"declarators : declarator",
"declarators : declarators ',' declarator",
"declarator : pointer member",
"declarator : pointer member openP expr_list closeP",
"declarator : pointer member openP error closeP",
"pointer :",
"pointer : pointer '*'",
"expr_list : expr",
"expr_list : simple_range",
"expr_list : expr_list ',' expr",
"member : NAME",
"func_name : NAME",
"$$5 :",
"struct_name : $$5 variable",
"param_list : positionals",
"param_list : positionals ',' keywords",
"param_list : keywords",
"param_list : dot_dot",
"param_list : positionals ',' dot_dot",
"param_list : positionals ',' dot_dot ',' keywords",
"param_list : dot_dot ',' keywords",
"positionals : NAME",
"positionals : positionals ',' NAME",
"positionals : '&' NAME",
"positionals : positionals ',' '&' NAME",
"keywords : NAME '='",
"keywords : keywords ',' NAME '='",
"dot_dot : DOTDOT",
"$$6 :",
"arg_list : $$6 func_arg_list",
"$$7 :",
"arg_sep : $$7 ','",
"func_arg_list : lj_arg_list",
"func_arg_list : rj_arg_list",
"func_arg_list : lj_arg_list arg_sep rj_arg_list",
"lj_arg_list : key_expr",
"lj_arg_list : lj_arg_list arg_sep key_expr",
"rj_arg_list : dotdot",
"rj_arg_list : dotdot ',' lj_arg_list",
"dotdot : DOTDOT",
"dotdot : '*'",
"key_expr : nil_expr",
"key_expr : range_expr",
"key_expr : NAME '=' nil_expr",
"key_expr : NAME '=' range_expr",
"nil_expr :",
"nil_expr : expr",
"range_expr : simple_range",
"range_expr : range_func",
"range_expr : range_func ':'",
"range_expr : range_func ':' simple_range",
"simple_range : nil_expr ':' nil_expr",
"simple_range : nil_expr ':' nil_expr ':' nil_expr",
"range_func : RFNAME",
"range_func : '+'",
"range_func : '-'",
"extern_vars : NAME",
"extern_vars : extern_vars ',' NAME",
"local_vars : NAME",
"local_vars : local_vars ',' NAME",
"assign_expr : cond_expr",
"assign_expr : assign_predicate assign_expr",
"assign_expr : assign_predicate range_expr",
"assign_expr : unary_expr assign_op assign_expr",
"assign_predicate : unary_expr '='",
"assign_op : PEQ",
"assign_op : MEQ",
"assign_op : TMSEQ",
"assign_op : DIVEQ",
"assign_op : MODEQ",
"assign_op : SHLEQ",
"assign_op : SHREQ",
"assign_op : ANDEQ",
"assign_op : XOREQ",
"assign_op : OREQ",
"cond_expr : expr",
"cond_expr : expr openCS '?' brfalse expr ':' branch_pop cond_expr",
"cond_expr : expr openCS '?' error",
"expr : pm_expr",
"expr : expr '*' expr",
"expr : expr '/' expr",
"expr : expr '%' expr",
"expr : expr '+' expr",
"expr : expr '-' expr",
"expr : expr SHL expr",
"expr : expr SHR expr",
"expr : expr '<' expr",
"expr : expr '>' expr",
"expr : expr LE expr",
"expr : expr GE expr",
"expr : expr EQ expr",
"expr : expr NE expr",
"expr : expr '&' expr",
"expr : expr '~' expr",
"expr : expr '|' expr",
"expr : expr AND brfalse expr",
"expr : expr OR brtrue expr",
"pm_expr : term",
"pm_expr : '+' term",
"pm_expr : '-' term",
"term : unary_expr",
"term : unary_expr '^' expr",
"unary_expr : basic_expr",
"unary_expr : '*' unary_expr",
"unary_expr : '&' basic_expr",
"unary_expr : '~' basic_expr",
"unary_expr : '!' basic_expr",
"unary_expr : PLUSPLUS basic_expr",
"unary_expr : MINUSMINUS basic_expr",
"basic_expr : constant",
"basic_expr : variable",
"$$8 :",
"basic_expr : basic_expr openP $$8 arg_list closeP",
"basic_expr : rfname openP arg_list closeP",
"basic_expr : NEXT_ARG openP closeP",
"basic_expr : MORE_ARGS openP closeP",
"basic_expr : openB get_pc expr_list closeB",
"basic_expr : openB closeB",
"basic_expr : basic_expr '.' NAME",
"basic_expr : basic_expr ARROW NAME",
"basic_expr : basic_expr PLUSPLUS",
"basic_expr : basic_expr MINUSMINUS",
"basic_expr : openP assign_expr closeP",
"basic_expr : basic_expr openP error closeP",
"basic_expr : rfname openP error closeP",
"basic_expr : openB error closeB",
"basic_expr : openP error closeP",
"get_pc :",
"for_expr :",
"for_expr : assign_expr_list",
"inc_expr :",
"$$9 :",
"inc_expr : $$9 assign_expr_list",
"assign_expr_list : assign_expr",
"assign_expr_list : assign_expr_list ',' assign_expr",
"variable : NAME",
"rfname : RFNAME",
"constant : CHAR",
"constant : SHORT",
"constant : INT",
"constant : LONG",
"constant : FLOAT",
"constant : DOUBLE",
"constant : STRING",
"constant : IMAGINARY",
};
#endif
#define yyclearin (yychar=(-1))
#define yyerrok (yyerrflag=0)
#ifdef YYSTACKSIZE
#ifndef YYMAXDEPTH
#define YYMAXDEPTH YYSTACKSIZE
#endif
#else
#ifdef YYMAXDEPTH
#define YYSTACKSIZE YYMAXDEPTH
#else
#define YYSTACKSIZE 200
#define YYMAXDEPTH 200
#endif
#endif
#ifndef YYOVERFLOW
#define YYOVERFLOW 10000
#endif
#if YYDEBUG
static int yydebug;
#endif
static int yynerrs;
static int yyerrflag;
static int yychar;
static short *yyssp;
static YYSTYPE *yyvsp;
static YYSTYPE yyval, yy_zero;
static YYSTYPE yylval;
static short *yyss= 0;
static YYSTYPE *yyvs= 0;
/* #define yystacksize YYSTACKSIZE */
static long yystacksize= 0;
/* End YACC grammar rules */
/*--------------------------------------------------------------------------*/



/*--------------------------------------------------------------------------*/
/* Begin C code */

static char *curLine, *nextChar= 0;
static int curChar;
static char *prevToken;

static int prevWasSemi, prevWasComma, noInputYet;
static char *quineBegin, *quineEnd, *quineText;

static int EndOfLine(void);

/* CheckMulti checks for multi-character special symbols.
   In the "multis" list, CheckMulti assumes that any 3 character
   symbol comes immediately after a matching 2 character symbol, AND
   no other symbols with the same FIRST character follow.
   More than one 3-symbol may not match a 2-symbol, and symbols of
   more than 3 characters are not allowed.  */
static int CheckMulti(void);

/* CheckName checks for reserved words and range function names.
   The "reserved" list must be alphabetized.  */
static int CheckName(char *name);

static char *AppendString(char *s, long ns, char *t, long nt);
static int StringValue(int resuming);
static int CharValue(void);
static int NumberValue(void);

/* CheckSyscall checks for $ system escape sequence */
static int CheckSyscall(int resuming);

/* ------------------------------ */

static int yp_prev_state= 0;
static int yp_keybd_input= 0;
#define YP_KEYBD_INPUT 0x4000
#define YP_EOL_EXPR 1
#define YP_EOL_COMMENT 2
#define YP_EOL_STRING 4
#define YP_EOL_SYSCALL 8

/* The context argument to YpNextLine determines how that routine will
 * prompt for input, if input is from a terminal.
 * NL_MAIN      -- read first line for parse
 * NL_NOINPUT   -- no non-comment input yet,
 *                   read next line (if file) or return EOF (if terminal)
 * NL_CONTINUE  -- need more input to complete program unit (cont>)
 * NL_QUOTE     -- inside multi-line quoted string (quot>)
 * NL_COMMENT   -- inside multi-line comment (comm>)
 */
/* Since NL_NOINPUT cannot result in a prompt being issued, its "spot"
 * is used for the debugging mode prompt.  */
static char *yp_prompts[]= { "> ", "dbug> ", "cont> ", "quot> ", "comm> " };

extern void y_do_prompt(void);
extern int ym_dbenter;

void
y_do_prompt(void)
{
  extern int yDebugLevel;        /* declared in ydata.h */
  int i;
  if (yp_keybd_input & YP_EOL_COMMENT) i = NL_COMMENT;
  else if (yp_keybd_input & YP_EOL_STRING) i = NL_QUOTE;
  else if (yp_keybd_input & YP_EOL_SYSCALL) i = NL_QUOTE;
  else if (yp_keybd_input & YP_EOL_EXPR) i = NL_CONTINUE;
  else i = (yDebugLevel &&
            (!ym_dbenter || yDebugLevel>1))? NL_NOINPUT : NL_MAIN;
  p_stdout(yp_prompts[i]);
}

int
YpParse(void *func)
{
  YpParseInit(func);
  nOpenCS= 0;    /* initialize number of open control structures */
  parenDepth= 0; /* initialize number of open parentheses/square brackets */
  braceDepth= 0; /* initialize number of open curly braces */
  needOperand= prevWasSemi= prevWasComma= supressSemi= 0; /* more EOL flags */
  nQuines= quining= 0;
  ypSkipIncludes= 0;  /* see ScanForFunc */
  curLine= nextChar= YpNextLine(NL_MAIN);
  prevToken= 0;
  if (!nextChar) return 0;
  noInputYet= 1;

  yp_keybd_input= 0;  /* YpParse no longer used to parse keyboard input */
  return yyparse_step(0);
}

int
yp_parse_keybd(char *line, int first)
{
  if (first) {
    YpParseInit(0);
    nOpenCS= 0;    /* initialize number of open control structures */
    parenDepth= 0; /* initialize number of open parentheses/square brackets */
    braceDepth= 0; /* initialize number of open curly braces */
    needOperand= prevWasSemi= prevWasComma= supressSemi= 0; /* EOL flags */
    nQuines= quining= 0;
    ypSkipIncludes= 0;  /* see ScanForFunc */
    prevToken= 0;
    if (!line) return 0;
    noInputYet= 1;
    yp_prev_state= 0;
    yp_keybd_input= YP_KEYBD_INPUT;
  }
  curLine= nextChar= line;
  yp_prev_state= yyparse_step(yp_prev_state);
  if (noInputYet && yp_prev_state==0x2000 && !ypErrors &&
      !(yp_keybd_input&YP_EOL_COMMENT))
    yp_prev_state = 0;
  if (ypErrors) {
    curLine= nextChar= 0;
    yyparse_step(yp_prev_state);
    yp_prev_state= 1;
  }
  if (!(yp_prev_state & 0x6000)) yp_keybd_input= 0;
  return yp_prev_state;          /* 0 success, 1 error, else unfinished */
}

/* ------------------------------ */

static char *multis[]= { "!=", "%=", "&&", "&=", "*=", "++", "+=",
  "--", "-=", "->", "..", "/=", "<<", "<<=", "<=", "==", ">=", ">>", ">>=",
  "|=", "||", "~=", "" };

static int multiTypes[]= { NE, MODEQ, AND, ANDEQ, TMSEQ, PLUSPLUS, PEQ,
  MINUSMINUS, MEQ, ARROW, DOTDOT, DIVEQ, SHL, SHLEQ, LE, EQ, GE, SHR, SHREQ,
  OREQ, OR, XOREQ };

static char *reserved[]= { "avg", "break", "continue", "cum", "dif", "do",
  "else", "extern", "for", "func", "goto", "if", "local", "max", "min", "mnx",
  "more_args", "mxx", "next_arg", "pcen", "psum", "ptp", "return", "rms",
  "struct", "sum", "uncp", "while", "zcen", "" };

static int reservedTypes[]= { RFNAME, BREAK, CONTINUE, RFNAME, RFNAME, DO,
  ELSE, EXTERN, FOR, FUNC, GOTO, IF, LOCAL, RFNAME, RFNAME, RFNAME,
  MORE_ARGS, RFNAME, NEXT_ARG, RFNAME, RFNAME, RFNAME, RETURN, RFNAME,
  STRUCT, RFNAME, RFNAME, WHILE, RFNAME };

static int reservedRFs[]= { 0, -1, -1, 1, 2, -1,
  -1, -1, -1, -1, -1, -1, -1, 3, 4, 5,
  -1, 6, -1, 7, 8, 9, -1, 10, -1, 11,
  12, -1, 13 };

/* ------------------------------ */

static int EndOfLine(void)
{
  if (!nextChar) return 1;
  while ((curChar= *nextChar) && (curChar==' ' || curChar=='\t'))
    nextChar++;        /* skip over tabs and blanks */
  return !curChar;
}

static int CheckMulti(void)
{
  char **now= multis;
  char *cur= *now;
  int token;

  token= curChar;
  nextChar++;
  while (cur[0] && curChar!=cur[0]) cur= *(++now);

  if (*cur++) {
    /* first character of symbol matches at least one multi-symbol */
    int second= *nextChar;

    do {
      if (second == *cur) {
        /* second character of symbol matches at least one multi-symbol */
        nextChar++;
        now++;
        if (curChar==(*now)[0] && *nextChar && *nextChar==(*now)[2]) {
          nextChar++;        /* found 3 character multi-symbol */
        } else {
          now--;             /* found 2 character multi-symbol */
        }
        token= multiTypes[now-multis];
        break;
      }
      cur= *(++now);
    } while (curChar == (cur++)[0]);

    if (token!=DOTDOT && token!=PLUSPLUS && token!=MINUSMINUS)
      needOperand= 1;

  } else if (curChar=='^') {
    /* Caret is the only operator which is NOT the first character of
       at least one multi-symbol.  */
    needOperand= 1;

  } else if (curChar==',') {
    if (quining==1) quineEnd= nextChar-1;
    prevWasComma= 1;
  } else if (needBody && curChar=='{') {
    needBody= 0;  /* no need to supress semicolon on EOL any more */
  }

  return token;
}

static int CheckName(char *name)
{
  char *now= name;
  int c= *now++;

  if (c>='a' && c<='z') { /* from "avg" to "zcen" NOT a to z! */
    char *match, **lst, **fst= reserved;
    int i= 1;

    /* find position of 1st character of name in reserved list */
    while (**fst<c) fst++;
    lst= fst;
    while (**lst==c) lst++;
    lst--;

    /* if first character matches, procede with following characters */
    while (fst <= lst) {
      if (fst==lst) {
        match= &(*fst)[i];   /* only one possible match */
        while (now<nextChar && match[0]==now[0]) { match++; now++; }
        if (*match || now!=nextChar) break;

        yylval.i= reservedRFs[fst-reserved];
        if (reservedTypes[fst-reserved]==ELSE) supressSemi= 1;
        return reservedTypes[fst-reserved];     /* found a reserved word */

      }
      c= *now++;
      while (fst<=lst && (*fst)[i]<c) fst++;
      while (fst<=lst && (*lst)[i]>c) lst--;
      i++;
    }
  }

  yylval.lit= YpName(name, nextChar-name);
  return NAME;             /* NOT a reserved word, just an ordinary name */
}

/* ------------------------------ */

static char *AppendString(char *s, long ns, char *t, long nt)
{
  char *n_w= p_malloc(ns+nt+1);
  if (ns) strcpy(n_w, s);
  p_free(s);
  if (nt) strncpy(n_w+ns, t, nt);
  n_w[ns+nt]= '\0';
  return n_w;
}

static char *quote= 0;  /* for StringValue and CheckSyscall */

static int
StringValue(int resuming)
{
  char c, *begin, *next;
  long n, len= 0;

  if (!resuming) {
    begin= quote;
    quote= 0;
    p_free(begin);
    begin= ++nextChar;  /* skip open quote */
  } else {
    len= quote? strlen(quote) : 0;
    begin= prevToken= curLine;
    if (quining==1) quineBegin= quineEnd= nextChar;
    if (!curLine) {
      if (len) p_free(quote);
      YpError("open \" at end-of-file");
      return 0;                    /* EOF reached (inside string) */
    }
  }

  while ((c=*nextChar++)) {
    if (c=='\\') {
      if (*nextChar) {
        nextChar[-1]= YpEscapeSeq(nextChar, &next);
        quote= AppendString(quote, len, begin, nextChar-begin);
        len+= nextChar-begin;
        begin= nextChar= next;

      } else {
        /* escaped newline */
        n= nextChar-begin-1;
        quote= AppendString(quote, len, begin, n);
        len+= n;
        if (quining==1) GrabQuine(nextChar-1);
        return -1;  /* signal NL_QUOTE next line required */
      }

    } else if (c=='\"') {
      /* only legitimate way out is close quote */
      quote= AppendString(quote, len, begin, nextChar-begin-1);
      yylval.q= YpQuoteConst(quote);
      return STRING;
    }
  }

  if (len) {
    begin= quote;
    quote= 0;
    p_free(begin);
  }
  YpError("missing close \"");
  yylval.q= 0;
  return STRING_ERR;  /* unmatched open quote */
}

static int CharValue(void)
{
  int c= *(++nextChar);
  if (*nextChar) nextChar++;
  if (c=='\\') c= YpEscapeSeq(nextChar, &nextChar);
  if (*nextChar && (*nextChar++ != '\'')) {
    /* skip past matching close quote, if one on current line */
    while (*nextChar && (*nextChar++ != '\''));
    YpError("missing close \'");
    yylval.l= 0;
    return CHAR_ERR;
  }
  yylval.l= c;
  return CHAR;
}

static int NumberValue(void)
{
  char *begin= nextChar;
  int isReal= (curChar=='.');
  long trialValue= 0;
  char testc;

  if (!isReal) {
    /* strtoul does not exist on Suns, but the Sun strtol works
       properly there, hence this switch */
#ifndef NO_STRTOUL
    trialValue= strtoul(begin, &nextChar, 0);
#else
    trialValue= strtol(begin, &nextChar, 0);
#endif
    testc= nextChar[0];

    /* Mac MetroWerks C library strtoul does not advance nextChar
       past all digits if there are too many to represent a number;
       instead, it leaves nextChar==begin, which is a disaster.  Try
       to avert the disaster here. */
    if (begin[0]=='0') {
      if (begin[1]=='x') {
        while ((testc>='0' && testc<='9') ||
               (testc>='A' && testc<='F') ||
               (testc>='a' && testc<='f')) testc= *(++nextChar);
      } else {
        while (testc>='0' && testc<='7') testc= *(++nextChar);
      }
    } else {
      while (testc>='0' && testc<='9') testc= *(++nextChar);
    }

    if (testc=='.') {
      isReal= 1;
    } else if (testc=='e' || testc=='E') {
      int i= 1;
      if (nextChar[1]=='+' || nextChar[1]=='-') i= 2;
      if (nextChar[i]>='0' && nextChar[i]<='9') isReal= 1;
    }
  }

  if (isReal) {
    yylval.d= strtod(begin, &nextChar);

    if (nextChar==begin) {
      /* avert MetroWerks disaster described above */
      if (begin[0]=='.') nextChar++;
      testc= nextChar[0];
      while (testc>='0' && testc<='9') testc= *(++nextChar);
    }

    if (*nextChar=='f' || *nextChar=='F') {
      nextChar++;
      return FLOAT;
    } else if (*nextChar=='i' || *nextChar=='I') {
      /* alternative suggestion: 1j for imaginary, 1i for int */
      nextChar++;
      return IMAGINARY;
    } else {
      return DOUBLE;
    }

  } else {
    yylval.l= trialValue;
    if (*nextChar=='l' || *nextChar=='L') {
      nextChar++;
      return LONG;
    } else if (*nextChar=='i' || *nextChar=='I') {
      nextChar++;
      yylval.d= (double)trialValue;
      return IMAGINARY;
    } else if (*nextChar=='s' || *nextChar=='S') {
      nextChar++;
      return SHORT;
    } else if (*nextChar=='n' || *nextChar=='N') {
      /* alternative suggestion: 1j for imaginary, 1i for int */
      nextChar++;
      return INT;
    } else {
      return LONG;
    }
  }
}

/* ------------------------------ */

static int
CheckSyscall(int resuming)
{
  long n, len;
  int more;

  if (!resuming) {
    if (EndOfLine() || curChar!='$') return 0;
    nextChar++;
    for (n=0 ; nextChar[n] ; n++)
      if (nextChar[n]!=' ' && nextChar[n]!='\t') break;
    if (!nextChar[n]) return 0;

    nextChar+= n;               /* skip past leading whitespace */
    len= 0;

    if (quote) {
      char *prev= quote;
      quote= 0;
      p_free(prev);
    }
  } else {
    len= quote? strlen(quote) : 0;
    prevToken= curLine;
    if (curLine) resuming= 0;
  }
  if (!resuming) {
    n= strlen(nextChar);
    more= (n && nextChar[n-1]=='\\');
    if (more) n--;

    quote= AppendString(quote, len, nextChar, n);
    len+= n;
    nextChar+= n;

    if (more) return -1;   /* signal NL_QUOTE next line required */
  }

  yylval.q= YpQuoteConst(quote);
  return 1;
}

/* ------------------------------ */

static void BeginQuine(void)
{
  /* nextChar is just past comma for argument to be quined */
  EndOfLine();   /* skip whitespace */
  if (quineText) p_free(quineText);
  quineText= 0;
  quineBegin= quineEnd= nextChar;
  if (curChar=='\\' && !nextChar[1]) quineBegin++;
}

static void GrabQuine(char *stop)
{
  long n= stop>quineBegin? stop-quineBegin : 0;
  char *text= p_strncat(quineText, quineBegin, n);
  p_free(quineText);
  quineText= text;
}

static int DoQuine(void)
{
  if (quining!=1) return 0;
  while (quineEnd>curLine && (quineEnd[-1]==' ' || quineEnd[-1]=='\t'))
    quineEnd--;
  GrabQuine(quineEnd);
  YpString(YpQuoteConst(quineText));
  p_free(quineText);
  quineText= quineBegin= quineEnd= 0;
  nQuines--;
  if (nQuines==0) quining= 0;
  return 1;
}

/* ------------------------------ */

static int yylex(void)
{
  int eol, continuation, bol;
  int supress= parenDepth || needOperand || supressSemi;

  if (yp_keybd_input&YP_EOL_STRING) {          /* NL_QUOTE (string case) */
    /* resume quoted string */
    int tok= StringValue(1);
    if (tok == -1) return yp_keybd_input;
    yp_keybd_input &= ~YP_EOL_STRING;
    return tok;
  } else if (yp_keybd_input&YP_EOL_SYSCALL) {  /* NL_QUOTE (syscall case) */
    int tok= CheckSyscall(1);
    if (tok == -1) return yp_keybd_input;
    yp_keybd_input &= ~YP_EOL_SYSCALL;
    return SYSCALL;
  } else if (yp_keybd_input&YP_EOL_COMMENT) {  /* NL_COMMENT */
    yp_keybd_input &= ~YP_EOL_COMMENT;
    goto comment;  /* yuck */
  } else if (yp_keybd_input&YP_EOL_EXPR) {     /* NL_NOINPUT or NL_CONTINUE */
    yp_keybd_input &= ~YP_EOL_EXPR;
    goto cntinue;  /* yuck */
  } else if (noInputYet==2) {
    return 0;
  }

  for (;;) { /* loop past all whitespace, comments, and escaped newlines */

    for (;;) {  /* loop past blank lines */
      bol= (nextChar && nextChar==curLine);
      eol= EndOfLine();
      continuation= (nextChar && curChar=='\\' && !nextChar[1]);
      bol= (bol && !continuation && !supress);
      if (!eol && !continuation) break;

      if (!continuation && !supress && !noInputYet &&
          !prevWasComma && !needBody) {
        if (!prevWasSemi) {
          /* if there are no open parentheses or operators, and the
             previous token was NOT ';', EOL is same as ';' */
          if (quining==1) quineEnd= nextChar;
          prevWasSemi= 1;
          return ';';
        }
        /* EOL (after ';') is same as EOF if no reason to continue */
        if (!nOpenCS && !braceDepth) return 0;
      }

      if (quining==1) GrabQuine(nextChar);
      if (yp_keybd_input) return (yp_keybd_input|= YP_EOL_EXPR);
      else curLine= nextChar= YpNextLine(noInputYet?NL_NOINPUT:NL_CONTINUE);
    cntinue:
      prevToken= curLine;
      if (quining==1) quineBegin= quineEnd= nextChar;

      if (!curLine) {                        /* hit EOF */
        if (noInputYet) {
          noInputYet= 2;
          return NOINPUT;
        } else {
          return 0;
        }
      }
    }

    if (curChar=='/' && nextChar[1]=='/') {
      while (*nextChar) nextChar++;
      continue;
    }

    if (curChar!='/' || nextChar[1]!='*') break;

    nextChar+= 2;                        /* skip past open comment */
    curChar= *nextChar++;

    while (curChar!='*' || *nextChar!='/') {  /* skip comment body */
      if (!curChar) {
        if (quining==1) GrabQuine(nextChar-1);
        if (yp_keybd_input) return (yp_keybd_input|= YP_EOL_COMMENT);
        else curLine= nextChar= YpNextLine(NL_COMMENT);
      comment:
        prevToken= curLine;
        if (quining==1) quineBegin= quineEnd= nextChar;
        if (!curLine) {
          YpError("open comment at end-of-file");
          return 0;           /* EOF reached (in comment) */
        }
      }
      curChar= *nextChar++;
    }
    nextChar++;
  }

  /* At last!  A real token has arrived! */

  needOperand= supressSemi= prevWasSemi= prevWasComma= 0;

  prevToken= nextChar;
  noInputYet= 0;

  if (curChar=='\"') {
    /* token is quoted string */
    int tok= StringValue(0);
    if (tok == -1) {
      if (yp_keybd_input) {
        return (yp_keybd_input|= YP_EOL_STRING);
      } else do {
        curLine= nextChar= YpNextLine(NL_QUOTE);
        tok= StringValue(1);
      } while (tok == -1);
    }
    return tok;         /* may include escaped newlines */

  } else if (curChar=='\'') {
    /* token is character constant */
    return CharValue();

  } else if ((curChar>='0' && curChar<='9') ||
             (curChar=='.' && nextChar[1]>='0' && nextChar[1]<='9')) {
    /* token is some sort of number */
    return NumberValue();

  } else {
    /* token is not a number, check for a variable name */
    while ((curChar>='a'&&curChar<='z') || (curChar>='A'&&curChar<='Z') ||
           (curChar>='0'&&curChar<='9') || curChar=='_')
      curChar= *(++nextChar);

    if (nextChar > prevToken) {
      /* token is a name */
      int nmtk = CheckName(prevToken);
      return nmtk;

    } else if (curChar!=';') {
      /* token must be a symbol */
      if (bol) {
        int tok= CheckSyscall(0);
        if (tok == -1) {
          if (yp_keybd_input) {
            return (yp_keybd_input|= YP_EOL_SYSCALL);
          } else do {
            curLine= nextChar= YpNextLine(NL_QUOTE);
            tok= CheckSyscall(1);
          } while (tok == -1);
        } else if (tok) {
          return SYSCALL;
        }
      }
      return CheckMulti();
    } else {
      if (quining==1) quineEnd= nextChar;
      prevWasSemi= 1;
      nextChar++;
      return ';';
    }
  }
}

/* ------------------------------ */

static void yyerror(char *msg)
{
  char errorMsg[81];
  long n;

  if (yychar==CHAR_ERR || yychar==STRING_ERR) return;

  n= strlen(msg);
  strncpy(errorMsg, msg, 80);
  if (n>=80) {
    errorMsg[80]= '\0';
  } else if (n>=70) {
    errorMsg[n]= '\0';
  } else {
    msg= errorMsg+n;
    strcpy(msg, " near ");
    msg+= 6;
    n= 80-n;
    if (n>16) n= 16;
    if (yychar==0) {
      strcpy(msg, "<EOF>");
    } else if (!prevToken || *prevToken==0) {
      strcpy(msg, "<EOL>");
    } else if (yychar==STRING && *prevToken!='\"') {
      strcpy(msg, "\"...\"");
    } else {
      strncpy(msg, prevToken, n);
      msg[n]= '\0';
    }
  }

  YpError(errorMsg);
}

/* ------------------------------ */

/* ScanForFunc is a "pseudo-parser" which merely calls yylex until
   it finds a func, struct, or extern definition for fname.  It returns
   the location of the line on which the definition began, suitable
   for use with fseek.  */
long ScanForFunc(const char *fname, int notExtern)
{
  int type, counter= 0;
  long position= -1;
  int token;
  YpParseInit((void *)0); /* necessary to receive literals and quotes */
  nOpenCS= 0;    /* initialize number of open control structures */
  parenDepth= 0; /* initialize number of open parentheses/square brackets */
  braceDepth= 0; /* initialize number of open curly braces */
  needOperand= prevWasSemi= prevWasComma= supressSemi= 0; /* more EOL flags */
  nQuines= quining= 0;
  /* this time, want to skip any include files and remember address of
     each line before it is read */
  ypSkipIncludes= 1;
  /* Get 1st line in NL_NOINPUT mode.  This is not really too important
   * here, but if input were from keyboard, this would force YpNextLine
   * to wait for input instead of possibly returning eof to handle
   * input from another source.
   * -- input cannot be from keyboard now */
  yp_keybd_input= 0;
  curLine= nextChar= YpNextLine(NL_NOINPUT);
  prevToken= 0;
  if (!nextChar) return 0;

  for (;;) {
    noInputYet= 1;     /* keep calling YpNextLine(NL_NOINPUT) --
                        * assures that YpNextLine will keep track of
                        * beginning line number */
    token= yylex();
    if (!token || token==NOINPUT) break;
    if (token=='{') braceDepth++;
    else if (token=='}') braceDepth--;
    else if (!braceDepth) {
      if (token==FUNC) type= 1;
      else if (token==STRUCT) type= 2;
      else if (!notExtern && (token==EXTERN||token==LOCAL)) type= 3;
      else type= 0;
      if (type) {
        position= YpStandby();
        noInputYet= 0;     /* if necessary, YpNextLine(NL_CONTINUE) */
        supressSemi= 1;    /* dont get confused by newline */
        token= yylex();
        supressSemi= 0;
        if (token==NAME && strcmp(fname, YpLitName(yylval.lit))==0) break;
        if (type==3) {
          while ((token= yylex())==',') {
            token= yylex();
            if (token==NAME && strcmp(fname, YpLitName(yylval.lit))==0)
              goto found;
          }
        }
        position= -1;
        if (!token || token==NOINPUT) break;
      }
    } else if (token==NAME || token==STRING || token==SYSCALL) {
      /* try to keep the literal and constant tables reasonably small */
      counter++;
      if (counter>=32) { YpParseInit((void *)0); counter= 0; }
    }
  }
 found:

  return position;
}

/* End C code */
/*--------------------------------------------------------------------------*/
#define YYABORT goto yyabort
#define YYACCEPT goto yyaccept

/* modifed byacc parser
 * -- return value will be 0 if parse finishes, 1 on error,
 *    >= 0x2000 if another token is required
 * -- in latter case, pass return value in subsequent call */

static int
yyparse_step(int last_state)
{
    register int yym, yyn, yystate;
#if YYDEBUG
    register char *yys;
    extern char *getenv();

    if (!(last_state&0x6000) && (yys = getenv("YYDEBUG")))
    {
        yyn = *yys;
        if (yyn >= '0' && yyn <= '9')
            yydebug = yyn - '0';
    }
#endif

    /* recover from previous call */
    if (last_state&0x2000) {
      yystate= last_state&0x1fff;
      goto yytop;
    } else if (last_state&0x4000) {
      yystate= last_state&0x1fff;
      goto yybot;
    }

    yynerrs = 0;
    yyerrflag = 0;
    yychar = (-1);

    if (yystacksize!=YYSTACKSIZE) {
      yyss= p_realloc(yyss, YYSTACKSIZE*sizeof(short));
      yyvs= p_realloc(yyvs, YYSTACKSIZE*sizeof(YYSTYPE));
      yystacksize= YYSTACKSIZE;
    }
    yyssp = yyss;
    yyvsp = yyvs;
    *yyssp = yystate = 0;

yyloop:
    if ((yyn = yydefred[yystate])) goto yyreduce;
    if (yychar < 0)
    {
      yytop:
        yychar= yylex();
        if (yychar & YP_KEYBD_INPUT) return 0x2000 | yystate;
        if (yychar < 0) yychar = 0;
#if YYDEBUG
        if (yydebug)
        {
            yys = 0;
            if (yychar <= YYMAXTOKEN) yys = yyname[yychar];
            if (!yys) yys = "illegal-symbol";
            printf("yydebug: state %d, reading %d (%s)\n", yystate,
                    yychar, yys);
        }
#endif
    }
    if ((yyn = yysindex[yystate]) && (yyn += yychar) >= 0 &&
            yyn <= YYTABLESIZE && yycheck[yyn] == yychar)
    {
#if YYDEBUG
        if (yydebug)
            printf("yydebug: state %d, shifting to state %d\n",
                    yystate, yytable[yyn]);
#endif
        if (yyssp >= yyss + yystacksize - 1)
        {
          long iyyssp= yyssp-yyss;
          long iyyvsp= yyvsp-yyvs;
          yystacksize*= 2;
          if (yystacksize>YYOVERFLOW) goto yyoverflow;
          yyss= p_realloc(yyss, yystacksize*sizeof(short));
          yyvs= p_realloc(yyvs, yystacksize*sizeof(YYSTYPE));
          yyssp= yyss+iyyssp;
          yyvsp= yyvs+iyyvsp;
        }
        *++yyssp = yystate = yytable[yyn];
        *++yyvsp = yylval;
        yychar = (-1);
        if (yyerrflag > 0)  --yyerrflag;
        goto yyloop;
    }
    if ((yyn = yyrindex[yystate]) && (yyn += yychar) >= 0 &&
            yyn <= YYTABLESIZE && yycheck[yyn] == yychar)
    {
        yyn = yytable[yyn];
        goto yyreduce;
    }
    if (yyerrflag) goto yyinrecovery;
    yyerror("syntax error");
    ++yynerrs;
yyinrecovery:
    if (yyerrflag < 3)
    {
        yyerrflag = 3;
        for (;;)
        {
            if ((yyn = yysindex[*yyssp]) && (yyn += YYERRCODE) >= 0 &&
                    yyn <= YYTABLESIZE && yycheck[yyn] == YYERRCODE)
            {
#if YYDEBUG
                if (yydebug)
                    printf("yydebug: state %d, error recovery shifting\
 to state %d\n", *yyssp, yytable[yyn]);
#endif
                if (yyssp >= yyss + yystacksize - 1)
                {
                  long iyyssp= yyssp-yyss;
                  long iyyvsp= yyvsp-yyvs;
                  yystacksize*= 2;
                  if (yystacksize>YYOVERFLOW) goto yyoverflow;
                  yyss= p_realloc(yyss, yystacksize*sizeof(short));
                  yyvs= p_realloc(yyvs, yystacksize*sizeof(YYSTYPE));
                  yyssp= yyss+iyyssp;
                  yyvsp= yyvs+iyyvsp;
                }
                *++yyssp = yystate = yytable[yyn];
                *++yyvsp = yylval;
                goto yyloop;
            }
            else
            {
#if YYDEBUG
                if (yydebug)
                    printf("yydebug: error recovery discarding state %d\n",
                            *yyssp);
#endif
                if (yyssp <= yyss) goto yyabort;
                --yyssp;
                --yyvsp;
            }
        }
    }
    else
    {
        if (yychar == 0) goto yyabort;
#if YYDEBUG
        if (yydebug)
        {
            yys = 0;
            if (yychar <= YYMAXTOKEN) yys = yyname[yychar];
            if (!yys) yys = "illegal-symbol";
            printf("yydebug: state %d, error recovery discards token %d (%s)\n",
                    yystate, yychar, yys);
        }
#endif
        yychar = (-1);
        goto yyloop;
    }
yyreduce:
#if YYDEBUG
    if (yydebug)
        printf("yydebug: state %d, reducing by rule %d (%s)\n",
                yystate, yyn, yyrule[yyn]);
#endif
    yym = yylen[yyn];
    /* yyvsp[1] can be beyond end of yyval stack -- do not access */
    yyval = yym? yyvsp[1-yym] : yy_zero;
    switch (yyn)
    {
case 2:
{ YpFunc(1, 1); }
break;
case 3:
{ nOpenCS--; YpFunc(0, EndOfLine()); }
break;
case 4:
{ nOpenCS--; YpFunc(0, EndOfLine()); }
break;
case 5:
{ nOpenCS--; YpStruct(yyvsp[-3].cb, EndOfLine()); }
break;
case 6:
{ nOpenCS--; YpFunc(0, EndOfLine()); }
break;
case 7:
{ nOpenCS--; needBody=0; YpFunc(0, EndOfLine()); }
break;
case 8:
{ nOpenCS--; YpStruct(yyvsp[-3].cb, EndOfLine()); }
break;
case 9:
{ nOpenCS--; needBody=0; YpStruct(NONE, EndOfLine()); }
break;
case 11:
{ YpSpecial(yyvsp[-1].i); }
break;
case 14:
{ nOpenCS++; }
break;
case 15:
{ parenDepth++; }
break;
case 16:
{ parenDepth--; }
break;
case 17:
{ parenDepth++; }
break;
case 18:
{ parenDepth--; }
break;
case 19:
{ braceDepth++; }
break;
case 20:
{ braceDepth--; }
break;
case 23:
{ yyval.cb= YpNoop(); }
break;
case 24:
{ yyval.cb= YpNoop(); }
break;
case 25:
{ yyval.cb= YpSyscall(yyvsp[-1].q); }
break;
case 27:
{ yyval.cb= YpAssignOrPrint(yyvsp[-1].cb); }
break;
case 28:
{ if ((nQuines= YpCallInit(yyvsp[0].cb))) quining= 1; }
break;
case 29:
{ nQuines= quining= 0; yyval.cb= YpCall(yyvsp[-4].cb, yyvsp[-1].i); }
break;
case 30:
{ yyval.cb= YpIfElse(yyvsp[-4].cb, yyvsp[-1].cb, NONE); }
break;
case 31:
{ nOpenCS++; }
break;
case 32:
{ nOpenCS--; yyval.cb= YpIfElse(yyvsp[-8].cb, yyvsp[-5].cb, yyvsp[0].cb); }
break;
case 33:
{ nOpenCS--; yyval.cb= YpWhile(yyvsp[-3].cb, yyvsp[0].cb); }
break;
case 34:
{ nOpenCS--; yyval.cb= YpDo(yyvsp[-5].cb, yyvsp[-2].cb); }
break;
case 35:
{ nOpenCS--; yyval.cb= YpFor(yyvsp[-7].cb, yyvsp[-5].cb, yyvsp[0].cb); }
break;
case 36:
{ nOpenCS--; yyval.cb= YpFor(yyvsp[-5].cb, NONE, yyvsp[0].cb); }
break;
case 37:
{ yyval.cb= YpContinue(); }
break;
case 38:
{ yyval.cb= YpBreak(); }
break;
case 39:
{ yyval.cb= YpReturn(NONE); }
break;
case 40:
{ yyval.cb= YpReturn(yyvsp[-1].cb); }
break;
case 41:
{ yyval.cb= YpReturn(yyvsp[-1].cb); }
break;
case 42:
{ yyval.cb= YpGoto(yyvsp[-1].lit); }
break;
case 43:
{ yyval.cb= YpLabel(yyvsp[-1].lit); }
break;
case 44:
{ nOpenCS--; yyval.cb= YpReset(); }
break;
case 45:
{ nOpenCS--; yyval.cb= YpReset(); }
break;
case 46:
{ nOpenCS--; yyval.cb= YpReset(); }
break;
case 47:
{ nOpenCS--; yyval.cb= YpReset(); }
break;
case 48:
{ nOpenCS--; yyval.cb= YpReset(); }
break;
case 49:
{ nOpenCS--; yyval.cb= YpReset(); }
break;
case 50:
{ nOpenCS--; yyval.cb= YpReset(); }
break;
case 51:
{ nOpenCS--; yyval.cb= YpReset(); }
break;
case 52:
{ nOpenCS--; yyval.cb= YpReset(); }
break;
case 53:
{ yyval.cb= YpNoop(); }
break;
case 55:
{ yyval.cb= YpNoop(); }
break;
case 56:
{ yyval.cb= yyvsp[-1].cb; }
break;
case 57:
{ yyval.cb= YpReset(); }
break;
case 58:
{ yyval.cb= YpReset(); }
break;
case 61:
{ YpBranch(0); }
break;
case 62:
{ YpBranch(1); }
break;
case 63:
{ YpBranch(2); }
break;
case 64:
{ YpBranch(3); }
break;
case 65:
{ supressSemi= 1; }
break;
case 67:
{ supressSemi= 1; nOpenCS++; }
break;
case 68:
{ nOpenCS--; }
break;
case 69:
{ supressSemi= 1; nOpenCS++; YpLoop(0); }
break;
case 70:
{ supressSemi= 1; nOpenCS++; YpLoop(1); }
break;
case 71:
{ supressSemi= 1; nOpenCS++; YpLoop(2); }
break;
case 72:
{ supressSemi= 1; }
break;
case 76:
{ YpDataType(yyvsp[0].lit); }
break;
case 79:
{ YpDeclarator(yyvsp[-1].i, yyvsp[0].cb, 0); }
break;
case 80:
{ YpDeclarator(yyvsp[-4].i, yyvsp[-3].cb, yyvsp[-1].i); }
break;
case 81:
{ YpReset(); }
break;
case 82:
{ yyval.i= 0; }
break;
case 83:
{ yyval.i= yyvsp[-1].i+1; }
break;
case 84:
{ yyval.i= 1; }
break;
case 85:
{ yyval.i= 1; }
break;
case 86:
{ yyval.i= yyvsp[-2].i + 1; }
break;
case 87:
{ yyval.cb= YpQuoted(yyvsp[0].lit); }
break;
case 88:
{ needBody= 1; YpInitFunc(yyvsp[0].lit); }
break;
case 89:
{ needBody= 1; }
break;
case 90:
{ yyval.cb= yyvsp[0].cb; }
break;
case 98:
{ YpPosParam(yyvsp[0].lit, 0); }
break;
case 99:
{ YpPosParam(yyvsp[0].lit, 0); }
break;
case 100:
{ YpPosParam(yyvsp[0].lit, 1); }
break;
case 101:
{ YpPosParam(yyvsp[0].lit, 1); }
break;
case 102:
{ YpKeyParam(yyvsp[-1].lit); }
break;
case 103:
{ YpKeyParam(yyvsp[-1].lit); }
break;
case 104:
{ YpHasPosList(); }
break;
case 105:
{ if (nQuines) quining++; }
break;
case 106:
{ yyval.i= yyvsp[0].i; if (nQuines) quining--; }
break;
case 107:
{ if (quining==1) BeginQuine(); }
break;
case 111:
{ yyval.i= yyvsp[-2].i + yyvsp[0].i; }
break;
case 112:
{ yyval.i= keyCount; YpCheckRef(yyvsp[0].cb); }
break;
case 113:
{ yyval.i= yyvsp[-2].i + keyCount; YpCheckRef(yyvsp[0].cb); }
break;
case 114:
{ yyval.i= 1; }
break;
case 115:
{ yyval.i= 1 + yyvsp[0].i; }
break;
case 116:
{ YpDotDot(0); }
break;
case 117:
{ YpDotDot(1); }
break;
case 118:
{ yyval.cb= yyvsp[0].cb; keyCount= 1 + DoQuine(); }
break;
case 119:
{ yyval.cb= yyvsp[0].cb; keyCount= 1 + DoQuine(); }
break;
case 120:
{ yyval.cb= yyvsp[0].cb; keyCount= 2; YpKeyword(yyvsp[-2].lit, yyvsp[0].cb); }
break;
case 121:
{ yyval.cb= yyvsp[0].cb; keyCount= 2; YpKeyword(yyvsp[-2].lit, yyvsp[0].cb); }
break;
case 122:
{ yyval.cb= YpNil(); }
break;
case 125:
{ yyval.cb= YpRangeFunc(yyvsp[0].i, NONE); }
break;
case 126:
{ yyval.cb= YpRangeFunc(yyvsp[-1].i, NONE); }
break;
case 127:
{ yyval.cb= YpRangeFunc(yyvsp[-2].i, yyvsp[0].cb); }
break;
case 128:
{ yyval.cb= YpRange(yyvsp[-2].cb, 0); }
break;
case 129:
{ yyval.cb= YpRange(yyvsp[-4].cb, 1); }
break;
case 131:
{ yyval.i= 14; }
break;
case 132:
{ yyval.i= 15; }
break;
case 133:
{ YpExtern(yyvsp[0].lit); }
break;
case 134:
{ YpExtern(yyvsp[0].lit); }
break;
case 135:
{ YpLocal(yyvsp[0].lit); }
break;
case 136:
{ YpLocal(yyvsp[0].lit); }
break;
case 138:
{ yyval.cb= YpAssign(yyvsp[-1].def, yyvsp[0].cb); }
break;
case 139:
{ yyval.cb= YpAssign(yyvsp[-1].def, yyvsp[0].cb); }
break;
case 140:
{ yyval.cb= YpIncrement(yyvsp[-2].cb, yyvsp[-1].i, yyvsp[0].cb); }
break;
case 141:
{ yyval.def= YpCheckDefine(yyvsp[-1].cb); }
break;
case 142:
{ yyval.i= 0; }
break;
case 143:
{ yyval.i= 1; }
break;
case 144:
{ yyval.i= 2; }
break;
case 145:
{ yyval.i= 3; }
break;
case 146:
{ yyval.i= 4; }
break;
case 147:
{ yyval.i= 5; }
break;
case 148:
{ yyval.i= 6; }
break;
case 149:
{ yyval.i= 7; }
break;
case 150:
{ yyval.i= 8; }
break;
case 151:
{ yyval.i= 9; }
break;
case 153:
{ nOpenCS--; yyval.cb= YpTernop(yyvsp[-7].cb, yyvsp[-3].cb, yyvsp[0].cb); }
break;
case 154:
{ nOpenCS--; yyval.cb= YpReset(); }
break;
case 156:
{ yyval.cb= YpMultop(yyvsp[-2].cb); }
break;
case 157:
{ yyval.cb= YpBinop(yyvsp[-2].cb, 2); }
break;
case 158:
{ yyval.cb= YpBinop(yyvsp[-2].cb, 3); }
break;
case 159:
{ yyval.cb= YpBinop(yyvsp[-2].cb, 4); }
break;
case 160:
{ yyval.cb= YpBinop(yyvsp[-2].cb, 5); }
break;
case 161:
{ yyval.cb= YpBinop(yyvsp[-2].cb, 6); }
break;
case 162:
{ yyval.cb= YpBinop(yyvsp[-2].cb, 7); }
break;
case 163:
{ yyval.cb= YpBinop(yyvsp[-2].cb, 8); }
break;
case 164:
{ yyval.cb= YpBinop(yyvsp[-2].cb, 9); }
break;
case 165:
{ yyval.cb= YpBinop(yyvsp[-2].cb, 10); }
break;
case 166:
{ yyval.cb= YpBinop(yyvsp[-2].cb, 11); }
break;
case 167:
{ yyval.cb= YpBinop(yyvsp[-2].cb, 12); }
break;
case 168:
{ yyval.cb= YpBinop(yyvsp[-2].cb, 13); }
break;
case 169:
{ yyval.cb= YpBinop(yyvsp[-2].cb, 14); }
break;
case 170:
{ yyval.cb= YpBinop(yyvsp[-2].cb, 15); }
break;
case 171:
{ yyval.cb= YpBinop(yyvsp[-2].cb, 16); }
break;
case 172:
{ yyval.cb= YpLogop(yyvsp[-3].cb, 0, yyvsp[0].cb); }
break;
case 173:
{ yyval.cb= YpLogop(yyvsp[-3].cb, 1, yyvsp[0].cb); }
break;
case 175:
{ yyval.cb= YpUnop(2, yyvsp[0].cb); }
break;
case 176:
{ yyval.cb= YpUnop(3, yyvsp[0].cb); }
break;
case 178:
{ yyval.cb= YpBinop(yyvsp[-2].cb, 0); }
break;
case 180:
{ yyval.cb= YpUnop(0, yyvsp[0].cb); }
break;
case 181:
{ YpCheckRef(yyvsp[0].cb); yyval.cb= YpUnop(1, yyvsp[0].cb); }
break;
case 182:
{ yyval.cb= YpUnop(4, yyvsp[0].cb); }
break;
case 183:
{ yyval.cb= YpUnop(5, yyvsp[0].cb); }
break;
case 184:
{ yyval.cb= YpUnop(6, YpCheckDefine(yyvsp[0].cb)); }
break;
case 185:
{ yyval.cb= YpUnop(7, YpCheckDefine(yyvsp[0].cb)); }
break;
case 188:
{ YpEvalInit(yyvsp[-1].cb); }
break;
case 189:
{ yyval.cb= YpEval(yyvsp[-4].cb, yyvsp[-1].i); }
break;
case 190:
{ yyval.cb= YpEval(yyvsp[-3].cb, yyvsp[-1].i); }
break;
case 191:
{ yyval.cb= YpNextArg(0); }
break;
case 192:
{ yyval.cb= YpNextArg(1); }
break;
case 193:
{ yyval.cb= YpBuild(yyvsp[-2].cb, yyvsp[-1].i); }
break;
case 194:
{ yyval.cb= YpNil(); }
break;
case 195:
{ yyval.cb= YpMember(yyvsp[-2].cb, 0, yyvsp[0].lit); }
break;
case 196:
{ yyval.cb= YpMember(yyvsp[-2].cb, 1, yyvsp[0].lit); }
break;
case 197:
{ yyval.cb= YpPostfix(YpCheckDefine(yyvsp[-1].cb), 0); }
break;
case 198:
{ yyval.cb= YpPostfix(YpCheckDefine(yyvsp[-1].cb), 1); }
break;
case 199:
{ yyval.cb= yyvsp[-1].cb; }
break;
case 200:
{ yyval.cb= YpReset(); }
break;
case 201:
{ yyval.cb= YpReset(); }
break;
case 202:
{ yyval.cb= YpReset(); }
break;
case 203:
{ yyval.cb= YpReset(); }
break;
case 204:
{ yyval.cb= YpNoop(); }
break;
case 205:
{ yyval.cb= YpNoop(); }
break;
case 208:
{ YpBeginInc(); }
break;
case 209:
{ YpEndInc(yyvsp[0].cb); }
break;
case 210:
{ yyval.cb= yyvsp[0].cb; YpDrop(); }
break;
case 211:
{ yyval.cb= yyvsp[-2].cb; YpDrop(); }
break;
case 212:
{ yyval.cb= YpVariable(yyvsp[0].lit); }
break;
case 213:
{ yyval.cb= YpPushRF(yyvsp[0].i); }
break;
case 214:
{ yyval.cb= YpChar(yyvsp[0].l); }
break;
case 215:
{ yyval.cb= YpShort(yyvsp[0].l); }
break;
case 216:
{ yyval.cb= YpInt(yyvsp[0].l); }
break;
case 217:
{ yyval.cb= YpLong(yyvsp[0].l); }
break;
case 218:
{ yyval.cb= YpFloat(yyvsp[0].d); }
break;
case 219:
{ yyval.cb= YpDouble(yyvsp[0].d); }
break;
case 220:
{ yyval.cb= YpString(yyvsp[0].q); }
break;
case 221:
{ yyval.cb= YpImaginary(yyvsp[0].d); }
break;
    }
    yyssp -= yym;
    yystate = *yyssp;
    yyvsp -= yym;
    yym = yylhs[yyn];
    if (yystate == 0 && yym == 0)
    {
#if YYDEBUG
        if (yydebug)
            printf("yydebug: after reduction, shifting from state 0 to\
 state %d\n", YYFINAL);
#endif
        yystate = YYFINAL;
        *++yyssp = YYFINAL;
        *++yyvsp = yyval;
        if (yychar < 0)
        {
          yybot:
            yychar= yylex();
            if (yychar & YP_KEYBD_INPUT) return 0x4000 | yystate;
            if (yychar < 0) yychar = 0;
#if YYDEBUG
            if (yydebug)
            {
                yys = 0;
                if (yychar <= YYMAXTOKEN) yys = yyname[yychar];
                if (!yys) yys = "illegal-symbol";
                printf("yydebug: state %d, reading %d (%s)\n",
                        YYFINAL, yychar, yys);
            }
#endif
        }
        if (yychar == 0) goto yyaccept;
        goto yyloop;
    }
    if ((yyn = yygindex[yym]) && (yyn += yystate) >= 0 &&
            yyn <= YYTABLESIZE && yycheck[yyn] == yystate)
        yystate = yytable[yyn];
    else
        yystate = yydgoto[yym];
#if YYDEBUG
    if (yydebug)
        printf("yydebug: after reduction, shifting from state %d \
to state %d\n", *yyssp, yystate);
#endif
    if (yyssp >= yyss + yystacksize - 1)
    {
      long iyyssp= yyssp-yyss;
      long iyyvsp= yyvsp-yyvs;
      yystacksize*= 2;
      if (yystacksize>YYOVERFLOW) goto yyoverflow;
      yyss= p_realloc(yyss, yystacksize*sizeof(short));
      yyvs= p_realloc(yyvs, yystacksize*sizeof(YYSTYPE));
      yyssp= yyss+iyyssp;
      yyvsp= yyvs+iyyvsp;
    }
    *++yyssp = yystate;
    *++yyvsp = yyval;
    goto yyloop;
yyoverflow:
    yyss= p_realloc(yyss, YYSTACKSIZE*sizeof(short));
    yyvs= p_realloc(yyvs, YYSTACKSIZE*sizeof(YYSTYPE));
    yystacksize= YYSTACKSIZE;
    yyerror("yacc stack overflow");
yyabort:
    return (1);
yyaccept:
    return (0);
}
