/* Generated by re2c 0.9.1-C on Wed Jul 12 20:29:42 2006
 */
#line 1 "./modules/parsers/nasm/nasm-token.re"
/*
 * NASM-compatible re2c lexer
 *
 *  Copyright (C) 2001  Peter Johnson
 *
 *  Portions based on re2c's example code.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND OTHER CONTRIBUTORS ``AS IS''
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR OTHER CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */
#include <util.h>
RCSID("$Id: nasm-token.re 1591 2006-07-13 03:25:38Z peter $");

#define YASM_LIB_INTERNAL
#include <libyasm.h>

#include "modules/parsers/nasm/nasm-parser.h"
#include "modules/parsers/nasm/nasm-defs.h"


#define BSIZE	8192

#define YYCURSOR	cursor
#define YYLIMIT		(s->lim)
#define YYMARKER	(s->ptr)
#define YYFILL(n)	{cursor = fill(parser_nasm, cursor);}

#define RETURN(i)	{s->cur = cursor; return i;}

#define SCANINIT()	{ \
	s->tchar = cursor - s->pos; \
	s->tline = s->cline; \
	s->tok = cursor; \
    }

#define TOK		((char *)s->tok)
#define TOKLEN		(size_t)(cursor-s->tok)


static YYCTYPE *
fill(yasm_parser_nasm *parser_nasm, YYCTYPE *cursor)
{
    Scanner *s = &parser_nasm->s;
    int first = 0;
    if(!s->eof){
	size_t cnt = s->tok - s->bot;
	if(cnt){
	    memmove(s->bot, s->tok, (size_t)(s->lim - s->tok));
	    s->tok = s->bot;
	    s->ptr -= cnt;
	    cursor -= cnt;
	    s->pos -= cnt;
	    s->lim -= cnt;
	}
	if (!s->bot)
	    first = 1;
	if((s->top - s->lim) < BSIZE){
	    YYCTYPE *buf = yasm_xmalloc((size_t)(s->lim - s->bot) + BSIZE);
	    memcpy(buf, s->tok, (size_t)(s->lim - s->tok));
	    s->tok = buf;
	    s->ptr = &buf[s->ptr - s->bot];
	    cursor = &buf[cursor - s->bot];
	    s->pos = &buf[s->pos - s->bot];
	    s->lim = &buf[s->lim - s->bot];
	    s->top = &s->lim[BSIZE];
	    if (s->bot)
		yasm_xfree(s->bot);
	    s->bot = buf;
	}
	if((cnt = yasm_preproc_input(parser_nasm->preproc, (char *)s->lim,
				     BSIZE)) == 0) {
	    s->eof = &s->lim[cnt]; *s->eof++ = '\n';
	}
	s->lim += cnt;
	if (first && parser_nasm->save_input) {
	    int i;
	    YYCTYPE *saveline;
	    parser_nasm->save_last ^= 1;
	    saveline = parser_nasm->save_line[parser_nasm->save_last];
	    /* save next line into cur_line */
	    for (i=0; i<79 && &s->tok[i] < s->lim && s->tok[i] != '\n'; i++)
		saveline[i] = s->tok[i];
	    saveline[i] = '\0';
	}
    }
    return cursor;
}

static YYCTYPE *
save_line(yasm_parser_nasm *parser_nasm, YYCTYPE *cursor)
{
    Scanner *s = &parser_nasm->s;
    int i = 0;
    YYCTYPE *saveline;

    parser_nasm->save_last ^= 1;
    saveline = parser_nasm->save_line[parser_nasm->save_last];

    /* save next line into cur_line */
    if ((YYLIMIT - YYCURSOR) < 80)
	YYFILL(80);
    for (i=0; i<79 && &cursor[i] < s->lim && cursor[i] != '\n'; i++)
	saveline[i] = cursor[i];
    saveline[i] = '\0';
    return cursor;
}

void
nasm_parser_cleanup(yasm_parser_nasm *parser_nasm)
{
    if (parser_nasm->s.bot)
	yasm_xfree(parser_nasm->s.bot);
}

/* starting size of string buffer */
#define STRBUF_ALLOC_SIZE	128

/* string buffer used when parsing strings/character constants */
static YYCTYPE *strbuf = NULL;

/* length of strbuf (including terminating NULL character) */
static size_t strbuf_size = 0;

static int linechg_numcount;

#line 153 "./modules/parsers/nasm/nasm-token.re"



int
nasm_parser_lex(YYSTYPE *lvalp, yasm_parser_nasm *parser_nasm)
{
    Scanner *s = &parser_nasm->s;
    YYCTYPE *cursor = s->cur;
    YYCTYPE endch;
    size_t count, len;
    YYCTYPE savech;

    /* Catch EOF */
    if (s->eof && cursor == s->eof)
	return 0;

    /* Jump to proper "exclusive" states */
    switch (parser_nasm->state) {
	case DIRECTIVE:
	    goto directive;
	case LINECHG:
	    goto linechg;
	case LINECHG2:
	    goto linechg2;
	default:
	    break;
    }

scan:
    SCANINIT();

    {
	static unsigned char yybm[] = {
	  4,   4,   4,   4,   4,   4,   4,   4, 
	  4,   6,   0,   4,   4,   6,   4,   4, 
	  4,   4,   4,   4,   4,   4,   4,   4, 
	  4,   4,   4,   4,   4,   4,   4,   4, 
	  6,   4,   4,  12,  12,   4,   4,   4, 
	  4,   4,   4,   4,   4,   4,  12,   4, 
	252, 252, 124, 124, 124, 124, 124, 124, 
	 60,  60,   4,   4,   4,   4,   4,  12, 
	 12,  28,  28,  28,  28,  28,  28,  12, 
	 12,  12,  12,  12,  12,  12,  12,  12, 
	 12,  12,  12,  12,  12,  12,  12,  12, 
	 12,  12,  12,   4,   4,   4,   4,  12, 
	  4,  28,  28,  28,  28,  28,  28,  12, 
	 12,  12,  12,  12,  12,  12,  12,  12, 
	 12,  12,  12,  12,  12,  12,  12,  12, 
	 12,  12,  12,   4,   4,   4,  12,   4, 
	  4,   4,   4,   4,   4,   4,   4,   4, 
	  4,   4,   4,   4,   4,   4,   4,   4, 
	  4,   4,   4,   4,   4,   4,   4,   4, 
	  4,   4,   4,   4,   4,   4,   4,   4, 
	  4,   4,   4,   4,   4,   4,   4,   4, 
	  4,   4,   4,   4,   4,   4,   4,   4, 
	  4,   4,   4,   4,   4,   4,   4,   4, 
	  4,   4,   4,   4,   4,   4,   4,   4, 
	  4,   4,   4,   4,   4,   4,   4,   4, 
	  4,   4,   4,   4,   4,   4,   4,   4, 
	  4,   4,   4,   4,   4,   4,   4,   4, 
	  4,   4,   4,   4,   4,   4,   4,   4, 
	  4,   4,   4,   4,   4,   4,   4,   4, 
	  4,   4,   4,   4,   4,   4,   4,   4, 
	  4,   4,   4,   4,   4,   4,   4,   4, 
	  4,   4,   4,   4,   4,   4,   4,   4, 
	};

#line 215 "nasm-token.c"
{
	YYCTYPE yych;
	unsigned int yyaccept;
	goto yy0;
	++YYCURSOR;
yy0:
	if((YYLIMIT - YYCURSOR) < 8) YYFILL(8);
	yych = *YYCURSOR;
	switch(yych){
	case '\t':	case '\r':	case ' ':	goto yy36;
	case '\n':	goto yy38;
	case '"':	case '\'':	goto yy9;
	case '$':	goto yy7;
	case '%':	goto yy11;
	case '&':	case '(':
	case ')':
	case '*':
	case '+':
	case ',':
	case '-':	case ':':	case '=':	case '[':	case '^':	case '|':	case '~':	goto yy29;
	case '.':	goto yy32;
	case '/':	goto yy28;
	case '0':	goto yy2;
	case '1':	goto yy4;
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':	goto yy5;
	case '8':
	case '9':	goto yy6;
	case ';':	goto yy34;
	case '<':	goto yy25;
	case '>':	goto yy27;
	case '?':	case 'A':	case 'C':	case 'F':
	case 'G':	case 'J':
	case 'K':	case 'M':	case 'O':
	case 'P':	case 'U':
	case 'V':	case 'X':
	case 'Y':
	case 'Z':	case '_':	case 'a':	case 'c':	case 'f':
	case 'g':	case 'j':
	case 'k':	case 'm':	case 'o':
	case 'p':	case 'u':
	case 'v':	case 'x':
	case 'y':
	case 'z':	goto yy33;
	case 'B':	case 'b':	goto yy12;
	case 'D':	case 'd':	goto yy16;
	case 'E':	case 'e':	goto yy22;
	case 'H':	case 'h':	goto yy14;
	case 'I':	case 'i':	goto yy21;
	case 'L':	case 'l':	goto yy17;
	case 'N':	case 'n':	goto yy24;
	case 'Q':	case 'q':	goto yy18;
	case 'R':	case 'r':	goto yy20;
	case 'S':	case 's':	goto yy23;
	case 'T':	case 't':	goto yy19;
	case 'W':	case 'w':	goto yy15;
	case ']':	goto yy30;
	default:	goto yy40;
	}
yy2:	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yybm[0+yych] & 128) {
		goto yy187;
	}
	switch(yych){
	case '.':	goto yy170;
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':	goto yy183;
	case '8':
	case '9':	goto yy173;
	case 'A':	case 'C':
	case 'D':
	case 'E':
	case 'F':	case 'a':	case 'c':
	case 'd':
	case 'e':
	case 'f':	goto yy175;
	case 'B':	case 'b':	goto yy189;
	case 'H':	case 'h':	goto yy177;
	case 'O':	case 'Q':	case 'o':	case 'q':	goto yy185;
	case 'x':	goto yy191;
	default:	goto yy3;
	}
yy3:
#line 186 "./modules/parsers/nasm/nasm-token.re"
{
	    savech = s->tok[TOKLEN];
	    s->tok[TOKLEN] = '\0';
	    lvalp->intn = yasm_intnum_create_dec(TOK, cur_line);
	    s->tok[TOKLEN] = savech;
	    RETURN(INTNUM);
	}
#line 318 "nasm-token.c"
yy4:	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yybm[0+yych] & 128) {
		goto yy187;
	}
	switch(yych){
	case '.':	goto yy170;
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':	goto yy183;
	case '8':
	case '9':	goto yy173;
	case 'A':	case 'C':
	case 'D':
	case 'E':
	case 'F':	case 'a':	case 'c':
	case 'd':
	case 'e':
	case 'f':	goto yy175;
	case 'B':	case 'b':	goto yy189;
	case 'H':	case 'h':	goto yy177;
	case 'O':	case 'Q':	case 'o':	case 'q':	goto yy185;
	default:	goto yy3;
	}
yy5:	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yybm[0+yych] & 64) {
		goto yy183;
	}
	if(yych <= 'O'){
		if(yych <= '@'){
			if(yych <= '.'){
				if(yych <= '-')	goto yy3;
				goto yy170;
			} else {
				if(yych <= '/')	goto yy3;
				if(yych <= '9')	goto yy173;
				goto yy3;
			}
		} else {
			if(yych <= 'G'){
				if(yych <= 'F')	goto yy175;
				goto yy3;
			} else {
				if(yych <= 'H')	goto yy177;
				if(yych <= 'N')	goto yy3;
				goto yy185;
			}
		}
	} else {
		if(yych <= 'g'){
			if(yych <= 'Q'){
				if(yych <= 'P')	goto yy3;
				goto yy185;
			} else {
				if(yych <= '`')	goto yy3;
				if(yych <= 'f')	goto yy175;
				goto yy3;
			}
		} else {
			if(yych <= 'o'){
				if(yych <= 'h')	goto yy177;
				if(yych <= 'n')	goto yy3;
				goto yy185;
			} else {
				if(yych == 'q')	goto yy185;
				goto yy3;
			}
		}
	}
yy6:	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= 'F'){
		if(yych <= '/'){
			if(yych == '.')	goto yy170;
			goto yy3;
		} else {
			if(yych <= '9')	goto yy173;
			if(yych <= '@')	goto yy3;
			goto yy175;
		}
	} else {
		if(yych <= '`'){
			if(yych == 'H')	goto yy177;
			goto yy3;
		} else {
			if(yych <= 'f')	goto yy175;
			if(yych == 'h')	goto yy177;
			goto yy3;
		}
	}
yy7:	yych = *++YYCURSOR;
	if(yych <= '>'){
		if(yych <= '-'){
			if(yych <= '"')	goto yy8;
			if(yych <= '#')	goto yy161;
			if(yych <= '$')	goto yy164;
			goto yy8;
		} else {
			if(yych <= '.')	goto yy161;
			if(yych <= '/')	goto yy8;
			if(yych <= '9')	goto yy166;
			goto yy8;
		}
	} else {
		if(yych <= '`'){
			if(yych <= 'Z')	goto yy161;
			if(yych == '_')	goto yy161;
			goto yy8;
		} else {
			if(yych <= 'z')	goto yy161;
			if(yych == '~')	goto yy161;
			goto yy8;
		}
	}
yy8:
#line 339 "./modules/parsers/nasm/nasm-token.re"
{ RETURN(s->tok[0]); }
#line 442 "nasm-token.c"
yy9:	yych = *++YYCURSOR;
	goto yy10;
yy10:
#line 239 "./modules/parsers/nasm/nasm-token.re"
{
	    endch = s->tok[0];
	    goto stringconst;
	}
#line 451 "nasm-token.c"
yy11:	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych == '%')	goto yy154;
	if(yych == 'l')	goto yy156;
	goto yy8;
yy12:	yych = *++YYCURSOR;
	if(yych == 'Y')	goto yy150;
	if(yych == 'y')	goto yy150;
	goto yy46;
yy13:
#line 383 "./modules/parsers/nasm/nasm-token.re"
{
	    savech = s->tok[TOKLEN];
	    s->tok[TOKLEN] = '\0';
	    if (parser_nasm->state != INSTRUCTION)
		switch (yasm_arch_parse_check_insnprefix
			(parser_nasm->arch, lvalp->arch_data, TOK, TOKLEN,
			 cur_line)) {
		    case YASM_ARCH_INSN:
			parser_nasm->state = INSTRUCTION;
			s->tok[TOKLEN] = savech;
			RETURN(INSN);
		    case YASM_ARCH_PREFIX:
			s->tok[TOKLEN] = savech;
			RETURN(PREFIX);
		    default:
			break;
		}
	    switch (yasm_arch_parse_check_regtmod
		    (parser_nasm->arch, lvalp->arch_data, TOK, TOKLEN,
		     cur_line)) {
		case YASM_ARCH_REG:
		    s->tok[TOKLEN] = savech;
		    RETURN(REG);
		case YASM_ARCH_SEGREG:
		    s->tok[TOKLEN] = savech;
		    RETURN(SEGREG);
		case YASM_ARCH_TARGETMOD:
		    s->tok[TOKLEN] = savech;
		    RETURN(TARGETMOD);
		default:
		    s->tok[TOKLEN] = savech;
	    }
	    /* Just an identifier, return as such. */
	    lvalp->str_val = yasm__xstrndup(TOK, TOKLEN);
	    RETURN(ID);
	}
#line 499 "nasm-token.c"
yy14:	yych = *++YYCURSOR;
	if(yych == 'W')	goto yy145;
	if(yych == 'w')	goto yy145;
	goto yy46;
yy15:	yych = *++YYCURSOR;
	if(yych <= 'R'){
		if(yych == 'O')	goto yy138;
		if(yych <= 'Q')	goto yy46;
		goto yy139;
	} else {
		if(yych <= 'o'){
			if(yych <= 'n')	goto yy46;
			goto yy138;
		} else {
			if(yych == 'r')	goto yy139;
			goto yy46;
		}
	}
yy16:	yych = *++YYCURSOR;
	switch(yych){
	case 'B':	case 'b':	goto yy116;
	case 'D':	case 'd':	goto yy118;
	case 'H':	case 'h':	goto yy120;
	case 'Q':	case 'q':	goto yy121;
	case 'T':	case 't':	goto yy123;
	case 'W':	case 'w':	goto yy125;
	default:	goto yy46;
	}
yy17:	yych = *++YYCURSOR;
	if(yych == 'O')	goto yy112;
	if(yych == 'o')	goto yy112;
	goto yy46;
yy18:	yych = *++YYCURSOR;
	if(yych == 'W')	goto yy107;
	if(yych == 'w')	goto yy107;
	goto yy46;
yy19:	yych = *++YYCURSOR;
	if(yych <= 'W'){
		if(yych == 'I')	goto yy97;
		if(yych <= 'V')	goto yy46;
		goto yy98;
	} else {
		if(yych <= 'i'){
			if(yych <= 'h')	goto yy46;
			goto yy97;
		} else {
			if(yych == 'w')	goto yy98;
			goto yy46;
		}
	}
yy20:	yych = *++YYCURSOR;
	if(yych == 'E')	goto yy80;
	if(yych == 'e')	goto yy80;
	goto yy46;
yy21:	yych = *++YYCURSOR;
	if(yych == 'N')	goto yy74;
	if(yych == 'n')	goto yy74;
	goto yy46;
yy22:	yych = *++YYCURSOR;
	if(yych == 'Q')	goto yy71;
	if(yych == 'q')	goto yy71;
	goto yy46;
yy23:	yych = *++YYCURSOR;
	if(yych == 'E')	goto yy68;
	if(yych == 'e')	goto yy68;
	goto yy46;
yy24:	yych = *++YYCURSOR;
	if(yych == 'O')	goto yy61;
	if(yych == 'o')	goto yy61;
	goto yy46;
yy25:	yych = *++YYCURSOR;
	if(yych == '<')	goto yy59;
	goto yy26;
yy26:
#line 431 "./modules/parsers/nasm/nasm-token.re"
{
	    yasm__warning(YASM_WARN_UNREC_CHAR, cur_line,
			  N_("ignoring unrecognized character `%s'"),
			  yasm__conv_unprint(s->tok[0]));
	    goto scan;
	}
#line 581 "nasm-token.c"
yy27:	yych = *++YYCURSOR;
	if(yych == '>')	goto yy57;
	goto yy26;
yy28:	yych = *++YYCURSOR;
	if(yych == '/')	goto yy55;
	goto yy8;
yy29:	yych = *++YYCURSOR;
	goto yy8;
yy30:	yych = *++YYCURSOR;
	goto yy31;
yy31:
#line 342 "./modules/parsers/nasm/nasm-token.re"
{
	    if (parser_nasm->state == DIRECTIVE2)
		parser_nasm->state = INITIAL;
	    RETURN(s->tok[0]);
	}
#line 599 "nasm-token.c"
yy32:	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= '>'){
		if(yych <= '-'){
			if(yych <= '"')	goto yy26;
			if(yych <= '$')	goto yy47;
			goto yy26;
		} else {
			if(yych <= '.')	goto yy50;
			if(yych <= '/')	goto yy26;
			if(yych <= '9')	goto yy47;
			goto yy26;
		}
	} else {
		if(yych <= '`'){
			if(yych <= 'Z')	goto yy47;
			if(yych == '_')	goto yy47;
			goto yy26;
		} else {
			if(yych <= 'z')	goto yy47;
			if(yych == '~')	goto yy47;
			goto yy26;
		}
	}
yy33:	yych = *++YYCURSOR;
	goto yy46;
yy34:	yych = *++YYCURSOR;
	goto yy44;
yy35:
#line 420 "./modules/parsers/nasm/nasm-token.re"
{ goto scan; }
#line 631 "nasm-token.c"
yy36:	yych = *++YYCURSOR;
	goto yy42;
yy37:
#line 422 "./modules/parsers/nasm/nasm-token.re"
{ goto scan; }
#line 637 "nasm-token.c"
yy38:	yych = *++YYCURSOR;
	goto yy39;
yy39:
#line 424 "./modules/parsers/nasm/nasm-token.re"
{
	    if (parser_nasm->save_input && cursor != s->eof)
		cursor = save_line(parser_nasm, cursor);
	    parser_nasm->state = INITIAL;
	    RETURN(s->tok[0]);
	}
#line 648 "nasm-token.c"
yy40:	yych = *++YYCURSOR;
	goto yy26;
yy41:	++YYCURSOR;
	if(YYLIMIT == YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	goto yy42;
yy42:	if(yybm[0+yych] & 2) {
		goto yy41;
	}
	goto yy37;
yy43:	++YYCURSOR;
	if(YYLIMIT == YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	goto yy44;
yy44:	if(yybm[0+yych] & 4) {
		goto yy43;
	}
	goto yy35;
yy45:	++YYCURSOR;
	if(YYLIMIT == YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	goto yy46;
yy46:	if(yybm[0+yych] & 8) {
		goto yy45;
	}
	goto yy13;
yy47:	++YYCURSOR;
	if(YYLIMIT == YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	goto yy48;
yy48:	if(yych <= '>'){
		if(yych <= '-'){
			if(yych <= '"')	goto yy49;
			if(yych <= '$')	goto yy47;
			goto yy49;
		} else {
			if(yych == '/')	goto yy49;
			if(yych <= '9')	goto yy47;
			goto yy49;
		}
	} else {
		if(yych <= '`'){
			if(yych <= 'Z')	goto yy47;
			if(yych == '_')	goto yy47;
			goto yy49;
		} else {
			if(yych <= 'z')	goto yy47;
			if(yych == '~')	goto yy47;
			goto yy49;
		}
	}
yy49:
#line 355 "./modules/parsers/nasm/nasm-token.re"
{
	    /* override local labels in directive state */
	    if (parser_nasm->state == DIRECTIVE2) {
		lvalp->str_val = yasm__xstrndup(TOK, TOKLEN);
		RETURN(ID);
	    } else if (!parser_nasm->locallabel_base) {
		lvalp->str_val = yasm__xstrndup(TOK, TOKLEN);
		yasm__warning(YASM_WARN_GENERAL, cur_line,
			      N_("no non-local label before `%s'"),
			      lvalp->str_val);
	    } else {
		len = TOKLEN + parser_nasm->locallabel_base_len;
		lvalp->str_val = yasm_xmalloc(len + 1);
		strcpy(lvalp->str_val, parser_nasm->locallabel_base);
		strncat(lvalp->str_val, TOK, TOKLEN);
		lvalp->str_val[len] = '\0';
	    }

	    RETURN(LOCAL_ID);
	}
#line 722 "nasm-token.c"
yy50:	yych = *++YYCURSOR;
	if(yych <= '>'){
		if(yych <= '-'){
			if(yych <= '"')	goto yy51;
			if(yych <= '$')	goto yy52;
			goto yy51;
		} else {
			if(yych == '/')	goto yy51;
			if(yych <= '9')	goto yy52;
			goto yy51;
		}
	} else {
		if(yych <= '`'){
			if(yych <= 'Z')	goto yy52;
			if(yych == '_')	goto yy52;
			goto yy51;
		} else {
			if(yych <= 'z')	goto yy52;
			if(yych == '~')	goto yy52;
			goto yy51;
		}
	}
yy51:	YYCURSOR = YYMARKER;
	switch(yyaccept){
	case 0:	goto yy3;
	case 4:	goto yy190;
	case 3:	goto yy172;
	case 1:	goto yy8;
	case 2:	goto yy26;
	}
yy52:	++YYCURSOR;
	if(YYLIMIT == YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	goto yy53;
yy53:	if(yych <= '>'){
		if(yych <= '-'){
			if(yych <= '"')	goto yy54;
			if(yych <= '$')	goto yy52;
			goto yy54;
		} else {
			if(yych == '/')	goto yy54;
			if(yych <= '9')	goto yy52;
			goto yy54;
		}
	} else {
		if(yych <= '`'){
			if(yych <= 'Z')	goto yy52;
			if(yych == '_')	goto yy52;
			goto yy54;
		} else {
			if(yych <= 'z')	goto yy52;
			if(yych == '~')	goto yy52;
			goto yy54;
		}
	}
yy54:
#line 349 "./modules/parsers/nasm/nasm-token.re"
{
	    lvalp->str_val = yasm__xstrndup(TOK, TOKLEN);
	    RETURN(SPECIAL_ID);
	}
#line 784 "nasm-token.c"
yy55:	yych = *++YYCURSOR;
	goto yy56;
yy56:
#line 336 "./modules/parsers/nasm/nasm-token.re"
{ RETURN(SIGNDIV); }
#line 790 "nasm-token.c"
yy57:	yych = *++YYCURSOR;
	goto yy58;
yy58:
#line 335 "./modules/parsers/nasm/nasm-token.re"
{ RETURN(RIGHT_OP); }
#line 796 "nasm-token.c"
yy59:	yych = *++YYCURSOR;
	goto yy60;
yy60:
#line 334 "./modules/parsers/nasm/nasm-token.re"
{ RETURN(LEFT_OP); }
#line 802 "nasm-token.c"
yy61:	yych = *++YYCURSOR;
	if(yych == 'S')	goto yy62;
	if(yych != 's')	goto yy46;
	goto yy62;
yy62:	yych = *++YYCURSOR;
	if(yych == 'P')	goto yy63;
	if(yych != 'p')	goto yy46;
	goto yy63;
yy63:	yych = *++YYCURSOR;
	if(yych == 'L')	goto yy64;
	if(yych != 'l')	goto yy46;
	goto yy64;
yy64:	yych = *++YYCURSOR;
	if(yych == 'I')	goto yy65;
	if(yych != 'i')	goto yy46;
	goto yy65;
yy65:	yych = *++YYCURSOR;
	if(yych == 'T')	goto yy66;
	if(yych != 't')	goto yy46;
	goto yy66;
yy66:	yych = *++YYCURSOR;
	if(yybm[0+yych] & 8) {
		goto yy45;
	}
	goto yy67;
yy67:
#line 331 "./modules/parsers/nasm/nasm-token.re"
{ RETURN(NOSPLIT); }
#line 831 "nasm-token.c"
yy68:	yych = *++YYCURSOR;
	if(yych == 'G')	goto yy69;
	if(yych != 'g')	goto yy46;
	goto yy69;
yy69:	yych = *++YYCURSOR;
	if(yybm[0+yych] & 8) {
		goto yy45;
	}
	goto yy70;
yy70:
#line 328 "./modules/parsers/nasm/nasm-token.re"
{ RETURN(SEG); }
#line 844 "nasm-token.c"
yy71:	yych = *++YYCURSOR;
	if(yych == 'U')	goto yy72;
	if(yych != 'u')	goto yy46;
	goto yy72;
yy72:	yych = *++YYCURSOR;
	if(yybm[0+yych] & 8) {
		goto yy45;
	}
	goto yy73;
yy73:
#line 324 "./modules/parsers/nasm/nasm-token.re"
{ RETURN(EQU); }
#line 857 "nasm-token.c"
yy74:	yych = *++YYCURSOR;
	if(yych == 'C')	goto yy75;
	if(yych != 'c')	goto yy46;
	goto yy75;
yy75:	yych = *++YYCURSOR;
	if(yych == 'B')	goto yy76;
	if(yych != 'b')	goto yy46;
	goto yy76;
yy76:	yych = *++YYCURSOR;
	if(yych == 'I')	goto yy77;
	if(yych != 'i')	goto yy46;
	goto yy77;
yy77:	yych = *++YYCURSOR;
	if(yych == 'N')	goto yy78;
	if(yych != 'n')	goto yy46;
	goto yy78;
yy78:	yych = *++YYCURSOR;
	if(yybm[0+yych] & 8) {
		goto yy45;
	}
	goto yy79;
yy79:
#line 322 "./modules/parsers/nasm/nasm-token.re"
{ RETURN(INCBIN); }
#line 882 "nasm-token.c"
yy80:	yych = *++YYCURSOR;
	if(yych == 'S')	goto yy81;
	if(yych != 's')	goto yy46;
	goto yy81;
yy81:	yych = *++YYCURSOR;
	switch(yych){
	case 'B':	case 'b':	goto yy82;
	case 'D':	case 'd':	goto yy84;
	case 'H':	case 'h':	goto yy86;
	case 'Q':	case 'q':	goto yy87;
	case 'T':	case 't':	goto yy89;
	case 'W':	case 'w':	goto yy91;
	default:	goto yy46;
	}
yy82:	yych = *++YYCURSOR;
	if(yybm[0+yych] & 8) {
		goto yy45;
	}
	goto yy83;
yy83:
#line 299 "./modules/parsers/nasm/nasm-token.re"
{ lvalp->int_info = 1; RETURN(RESERVE_SPACE); }
#line 905 "nasm-token.c"
yy84:	yych = *++YYCURSOR;
	if(yych <= 'Q'){
		if(yych <= '.'){
			if(yych <= '"')	goto yy85;
			if(yych <= '$')	goto yy45;
			if(yych >= '.')	goto yy45;
			goto yy85;
		} else {
			if(yych <= '9'){
				if(yych >= '0')	goto yy45;
				goto yy85;
			} else {
				if(yych <= '>')	goto yy85;
				if(yych <= 'P')	goto yy45;
				goto yy95;
			}
		}
	} else {
		if(yych <= 'p'){
			if(yych <= '^'){
				if(yych <= 'Z')	goto yy45;
				goto yy85;
			} else {
				if(yych != '`')	goto yy45;
				goto yy85;
			}
		} else {
			if(yych <= 'z'){
				if(yych <= 'q')	goto yy95;
				goto yy45;
			} else {
				if(yych == '~')	goto yy45;
				goto yy85;
			}
		}
	}
yy85:
#line 308 "./modules/parsers/nasm/nasm-token.re"
{
	    lvalp->int_info = yasm_arch_wordsize(parser_nasm->arch)*2;
	    RETURN(RESERVE_SPACE);
	}
#line 948 "nasm-token.c"
yy86:	yych = *++YYCURSOR;
	if(yych == 'W')	goto yy93;
	if(yych == 'w')	goto yy93;
	goto yy46;
yy87:	yych = *++YYCURSOR;
	if(yybm[0+yych] & 8) {
		goto yy45;
	}
	goto yy88;
yy88:
#line 312 "./modules/parsers/nasm/nasm-token.re"
{
	    lvalp->int_info = yasm_arch_wordsize(parser_nasm->arch)*4;
	    RETURN(RESERVE_SPACE);
	}
#line 964 "nasm-token.c"
yy89:	yych = *++YYCURSOR;
	if(yybm[0+yych] & 8) {
		goto yy45;
	}
	goto yy90;
yy90:
#line 316 "./modules/parsers/nasm/nasm-token.re"
{ lvalp->int_info = 10; RETURN(RESERVE_SPACE); }
#line 973 "nasm-token.c"
yy91:	yych = *++YYCURSOR;
	if(yybm[0+yych] & 8) {
		goto yy45;
	}
	goto yy92;
yy92:
#line 304 "./modules/parsers/nasm/nasm-token.re"
{
	    lvalp->int_info = yasm_arch_wordsize(parser_nasm->arch);
	    RETURN(RESERVE_SPACE);
	}
#line 985 "nasm-token.c"
yy93:	yych = *++YYCURSOR;
	if(yybm[0+yych] & 8) {
		goto yy45;
	}
	goto yy94;
yy94:
#line 300 "./modules/parsers/nasm/nasm-token.re"
{
	    lvalp->int_info = yasm_arch_wordsize(parser_nasm->arch)/2;
	    RETURN(RESERVE_SPACE);
	}
#line 997 "nasm-token.c"
yy95:	yych = *++YYCURSOR;
	if(yybm[0+yych] & 8) {
		goto yy45;
	}
	goto yy96;
yy96:
#line 317 "./modules/parsers/nasm/nasm-token.re"
{
	    lvalp->int_info = yasm_arch_wordsize(parser_nasm->arch)*8;
	    RETURN(RESERVE_SPACE);
	}
#line 1009 "nasm-token.c"
yy97:	yych = *++YYCURSOR;
	if(yych == 'M')	goto yy103;
	if(yych == 'm')	goto yy103;
	goto yy46;
yy98:	yych = *++YYCURSOR;
	if(yych == 'O')	goto yy99;
	if(yych != 'o')	goto yy46;
	goto yy99;
yy99:	yych = *++YYCURSOR;
	if(yych == 'R')	goto yy100;
	if(yych != 'r')	goto yy46;
	goto yy100;
yy100:	yych = *++YYCURSOR;
	if(yych == 'D')	goto yy101;
	if(yych != 'd')	goto yy46;
	goto yy101;
yy101:	yych = *++YYCURSOR;
	if(yybm[0+yych] & 8) {
		goto yy45;
	}
	goto yy102;
yy102:
#line 269 "./modules/parsers/nasm/nasm-token.re"
{ lvalp->int_info = 10; RETURN(SIZE_OVERRIDE); }
#line 1034 "nasm-token.c"
yy103:	yych = *++YYCURSOR;
	if(yych == 'E')	goto yy104;
	if(yych != 'e')	goto yy46;
	goto yy104;
yy104:	yych = *++YYCURSOR;
	if(yych == 'S')	goto yy105;
	if(yych != 's')	goto yy46;
	goto yy105;
yy105:	yych = *++YYCURSOR;
	if(yybm[0+yych] & 8) {
		goto yy45;
	}
	goto yy106;
yy106:
#line 326 "./modules/parsers/nasm/nasm-token.re"
{ RETURN(TIMES); }
#line 1051 "nasm-token.c"
yy107:	yych = *++YYCURSOR;
	if(yych == 'O')	goto yy108;
	if(yych != 'o')	goto yy46;
	goto yy108;
yy108:	yych = *++YYCURSOR;
	if(yych == 'R')	goto yy109;
	if(yych != 'r')	goto yy46;
	goto yy109;
yy109:	yych = *++YYCURSOR;
	if(yych == 'D')	goto yy110;
	if(yych != 'd')	goto yy46;
	goto yy110;
yy110:	yych = *++YYCURSOR;
	if(yybm[0+yych] & 8) {
		goto yy45;
	}
	goto yy111;
yy111:
#line 265 "./modules/parsers/nasm/nasm-token.re"
{
	    lvalp->int_info = yasm_arch_wordsize(parser_nasm->arch)*4;
	    RETURN(SIZE_OVERRIDE);
	}
#line 1075 "nasm-token.c"
yy112:	yych = *++YYCURSOR;
	if(yych == 'N')	goto yy113;
	if(yych != 'n')	goto yy46;
	goto yy113;
yy113:	yych = *++YYCURSOR;
	if(yych == 'G')	goto yy114;
	if(yych != 'g')	goto yy46;
	goto yy114;
yy114:	yych = *++YYCURSOR;
	if(yybm[0+yych] & 8) {
		goto yy45;
	}
	goto yy115;
yy115:
#line 261 "./modules/parsers/nasm/nasm-token.re"
{
	    lvalp->int_info = yasm_arch_wordsize(parser_nasm->arch)*2;
	    RETURN(SIZE_OVERRIDE);
	}
#line 1095 "nasm-token.c"
yy116:	yych = *++YYCURSOR;
	if(yybm[0+yych] & 8) {
		goto yy45;
	}
	goto yy117;
yy117:
#line 276 "./modules/parsers/nasm/nasm-token.re"
{ lvalp->int_info = 1; RETURN(DECLARE_DATA); }
#line 1104 "nasm-token.c"
yy118:	yych = *++YYCURSOR;
	if(yych <= 'Q'){
		if(yych <= '.'){
			if(yych <= '"')	goto yy119;
			if(yych <= '$')	goto yy45;
			if(yych >= '.')	goto yy45;
			goto yy119;
		} else {
			if(yych <= '9'){
				if(yych >= '0')	goto yy45;
				goto yy119;
			} else {
				if(yych <= '>')	goto yy119;
				if(yych <= 'P')	goto yy45;
				goto yy136;
			}
		}
	} else {
		if(yych <= 'p'){
			if(yych <= '^'){
				if(yych <= 'Z')	goto yy45;
				goto yy119;
			} else {
				if(yych != '`')	goto yy45;
				goto yy119;
			}
		} else {
			if(yych <= 'z'){
				if(yych <= 'q')	goto yy136;
				goto yy45;
			} else {
				if(yych == '~')	goto yy45;
				goto yy119;
			}
		}
	}
yy119:
#line 285 "./modules/parsers/nasm/nasm-token.re"
{
	    lvalp->int_info = yasm_arch_wordsize(parser_nasm->arch)*2;
	    RETURN(DECLARE_DATA);
	}
#line 1147 "nasm-token.c"
yy120:	yych = *++YYCURSOR;
	if(yych == 'W')	goto yy134;
	if(yych == 'w')	goto yy134;
	goto yy46;
yy121:	yych = *++YYCURSOR;
	if(yych <= 'W'){
		if(yych <= '.'){
			if(yych <= '"')	goto yy122;
			if(yych <= '$')	goto yy45;
			if(yych >= '.')	goto yy45;
			goto yy122;
		} else {
			if(yych <= '9'){
				if(yych >= '0')	goto yy45;
				goto yy122;
			} else {
				if(yych <= '>')	goto yy122;
				if(yych <= 'V')	goto yy45;
				goto yy129;
			}
		}
	} else {
		if(yych <= 'v'){
			if(yych <= '^'){
				if(yych <= 'Z')	goto yy45;
				goto yy122;
			} else {
				if(yych != '`')	goto yy45;
				goto yy122;
			}
		} else {
			if(yych <= 'z'){
				if(yych <= 'w')	goto yy129;
				goto yy45;
			} else {
				if(yych == '~')	goto yy45;
				goto yy122;
			}
		}
	}
yy122:
#line 289 "./modules/parsers/nasm/nasm-token.re"
{
	    lvalp->int_info = yasm_arch_wordsize(parser_nasm->arch)*4;
	    RETURN(DECLARE_DATA);
	}
#line 1194 "nasm-token.c"
yy123:	yych = *++YYCURSOR;
	if(yybm[0+yych] & 8) {
		goto yy45;
	}
	goto yy124;
yy124:
#line 293 "./modules/parsers/nasm/nasm-token.re"
{ lvalp->int_info = 10; RETURN(DECLARE_DATA); }
#line 1203 "nasm-token.c"
yy125:	yych = *++YYCURSOR;
	if(yych <= 'O'){
		if(yych <= '.'){
			if(yych <= '"')	goto yy126;
			if(yych <= '$')	goto yy45;
			if(yych >= '.')	goto yy45;
			goto yy126;
		} else {
			if(yych <= '9'){
				if(yych >= '0')	goto yy45;
				goto yy126;
			} else {
				if(yych <= '>')	goto yy126;
				if(yych <= 'N')	goto yy45;
				goto yy127;
			}
		}
	} else {
		if(yych <= 'n'){
			if(yych <= '^'){
				if(yych <= 'Z')	goto yy45;
				goto yy126;
			} else {
				if(yych != '`')	goto yy45;
				goto yy126;
			}
		} else {
			if(yych <= 'z'){
				if(yych <= 'o')	goto yy127;
				goto yy45;
			} else {
				if(yych == '~')	goto yy45;
				goto yy126;
			}
		}
	}
yy126:
#line 281 "./modules/parsers/nasm/nasm-token.re"
{
	    lvalp->int_info = yasm_arch_wordsize(parser_nasm->arch);
	    RETURN(DECLARE_DATA);
	}
#line 1246 "nasm-token.c"
yy127:	yych = *++YYCURSOR;
	if(yych == 'R')	goto yy128;
	if(yych != 'r')	goto yy46;
	goto yy128;
yy128:	yych = *++YYCURSOR;
	if(yych == 'D')	goto yy114;
	if(yych == 'd')	goto yy114;
	goto yy46;
yy129:	yych = *++YYCURSOR;
	if(yych == 'O')	goto yy130;
	if(yych != 'o')	goto yy46;
	goto yy130;
yy130:	yych = *++YYCURSOR;
	if(yych == 'R')	goto yy131;
	if(yych != 'r')	goto yy46;
	goto yy131;
yy131:	yych = *++YYCURSOR;
	if(yych == 'D')	goto yy132;
	if(yych != 'd')	goto yy46;
	goto yy132;
yy132:	yych = *++YYCURSOR;
	if(yybm[0+yych] & 8) {
		goto yy45;
	}
	goto yy133;
yy133:
#line 270 "./modules/parsers/nasm/nasm-token.re"
{
	    lvalp->int_info = yasm_arch_wordsize(parser_nasm->arch)*8;
	    RETURN(SIZE_OVERRIDE);
	}
#line 1278 "nasm-token.c"
yy134:	yych = *++YYCURSOR;
	if(yybm[0+yych] & 8) {
		goto yy45;
	}
	goto yy135;
yy135:
#line 277 "./modules/parsers/nasm/nasm-token.re"
{
	    lvalp->int_info = yasm_arch_wordsize(parser_nasm->arch)/2;
	    RETURN(DECLARE_DATA);
	}
#line 1290 "nasm-token.c"
yy136:	yych = *++YYCURSOR;
	if(yybm[0+yych] & 8) {
		goto yy45;
	}
	goto yy137;
yy137:
#line 294 "./modules/parsers/nasm/nasm-token.re"
{
	    lvalp->int_info = yasm_arch_wordsize(parser_nasm->arch)*8;
	    RETURN(DECLARE_DATA);
	}
#line 1302 "nasm-token.c"
yy138:	yych = *++YYCURSOR;
	if(yych == 'R')	goto yy142;
	if(yych == 'r')	goto yy142;
	goto yy46;
yy139:	yych = *++YYCURSOR;
	if(yych == 'T')	goto yy140;
	if(yych != 't')	goto yy46;
	goto yy140;
yy140:	yych = *++YYCURSOR;
	if(yybm[0+yych] & 8) {
		goto yy45;
	}
	goto yy141;
yy141:
#line 329 "./modules/parsers/nasm/nasm-token.re"
{ RETURN(WRT); }
#line 1319 "nasm-token.c"
yy142:	yych = *++YYCURSOR;
	if(yych == 'D')	goto yy143;
	if(yych != 'd')	goto yy46;
	goto yy143;
yy143:	yych = *++YYCURSOR;
	if(yybm[0+yych] & 8) {
		goto yy45;
	}
	goto yy144;
yy144:
#line 257 "./modules/parsers/nasm/nasm-token.re"
{
	    lvalp->int_info = yasm_arch_wordsize(parser_nasm->arch);
	    RETURN(SIZE_OVERRIDE);
	}
#line 1335 "nasm-token.c"
yy145:	yych = *++YYCURSOR;
	if(yych == 'O')	goto yy146;
	if(yych != 'o')	goto yy46;
	goto yy146;
yy146:	yych = *++YYCURSOR;
	if(yych == 'R')	goto yy147;
	if(yych != 'r')	goto yy46;
	goto yy147;
yy147:	yych = *++YYCURSOR;
	if(yych == 'D')	goto yy148;
	if(yych != 'd')	goto yy46;
	goto yy148;
yy148:	yych = *++YYCURSOR;
	if(yybm[0+yych] & 8) {
		goto yy45;
	}
	goto yy149;
yy149:
#line 253 "./modules/parsers/nasm/nasm-token.re"
{
	    lvalp->int_info = yasm_arch_wordsize(parser_nasm->arch)/2;
	    RETURN(SIZE_OVERRIDE);
	}
#line 1359 "nasm-token.c"
yy150:	yych = *++YYCURSOR;
	if(yych == 'T')	goto yy151;
	if(yych != 't')	goto yy46;
	goto yy151;
yy151:	yych = *++YYCURSOR;
	if(yych == 'E')	goto yy152;
	if(yych != 'e')	goto yy46;
	goto yy152;
yy152:	yych = *++YYCURSOR;
	if(yybm[0+yych] & 8) {
		goto yy45;
	}
	goto yy153;
yy153:
#line 252 "./modules/parsers/nasm/nasm-token.re"
{ lvalp->int_info = 1; RETURN(SIZE_OVERRIDE); }
#line 1376 "nasm-token.c"
yy154:	yych = *++YYCURSOR;
	goto yy155;
yy155:
#line 337 "./modules/parsers/nasm/nasm-token.re"
{ RETURN(SIGNMOD); }
#line 1382 "nasm-token.c"
yy156:	yych = *++YYCURSOR;
	if(yych != 'i')	goto yy51;
	goto yy157;
yy157:	yych = *++YYCURSOR;
	if(yych != 'n')	goto yy51;
	goto yy158;
yy158:	yych = *++YYCURSOR;
	if(yych != 'e')	goto yy51;
	goto yy159;
yy159:	yych = *++YYCURSOR;
	goto yy160;
yy160:
#line 245 "./modules/parsers/nasm/nasm-token.re"
{
	    parser_nasm->state = LINECHG;
	    linechg_numcount = 0;
	    RETURN(LINE);
	}
#line 1401 "nasm-token.c"
yy161:	++YYCURSOR;
	if(YYLIMIT == YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	goto yy162;
yy162:	if(yych <= '>'){
		if(yych <= '-'){
			if(yych <= '"')	goto yy163;
			if(yych <= '$')	goto yy161;
			goto yy163;
		} else {
			if(yych == '/')	goto yy163;
			if(yych <= '9')	goto yy161;
			goto yy163;
		}
	} else {
		if(yych <= '`'){
			if(yych <= 'Z')	goto yy161;
			if(yych == '_')	goto yy161;
			goto yy163;
		} else {
			if(yych <= 'z')	goto yy161;
			if(yych == '~')	goto yy161;
			goto yy163;
		}
	}
yy163:
#line 377 "./modules/parsers/nasm/nasm-token.re"
{
	    lvalp->str_val = yasm__xstrndup(TOK+1, TOKLEN-1);
	    RETURN(ID);
	}
#line 1433 "nasm-token.c"
yy164:	yych = *++YYCURSOR;
	if(yych <= '>'){
		if(yych <= '-'){
			if(yych <= '"')	goto yy165;
			if(yych <= '$')	goto yy161;
			goto yy165;
		} else {
			if(yych == '/')	goto yy165;
			if(yych <= '9')	goto yy161;
			goto yy165;
		}
	} else {
		if(yych <= '`'){
			if(yych <= 'Z')	goto yy161;
			if(yych == '_')	goto yy161;
			goto yy165;
		} else {
			if(yych <= 'z')	goto yy161;
			if(yych == '~')	goto yy161;
			goto yy165;
		}
	}
yy165:
#line 338 "./modules/parsers/nasm/nasm-token.re"
{ RETURN(START_SECTION_ID); }
#line 1459 "nasm-token.c"
yy166:	yych = *++YYCURSOR;
	if(yybm[0+yych] & 16) {
		goto yy167;
	}
	goto yy162;
yy167:	++YYCURSOR;
	if(YYLIMIT == YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	goto yy168;
yy168:	if(yybm[0+yych] & 16) {
		goto yy167;
	}
	if(yych <= 'Z'){
		if(yych <= '-'){
			if(yych <= '"')	goto yy169;
			if(yych <= '$')	goto yy161;
			goto yy169;
		} else {
			if(yych <= '.')	goto yy161;
			if(yych >= '?')	goto yy161;
			goto yy169;
		}
	} else {
		if(yych <= '`'){
			if(yych == '_')	goto yy161;
			goto yy169;
		} else {
			if(yych <= 'z')	goto yy161;
			if(yych == '~')	goto yy161;
			goto yy169;
		}
	}
yy169:
#line 216 "./modules/parsers/nasm/nasm-token.re"
{
	    savech = s->tok[TOKLEN];
	    s->tok[TOKLEN] = '\0';
	    if (s->tok[1] == 'x')
		/* skip 0 and x */
		lvalp->intn = yasm_intnum_create_hex(TOK+2, cur_line);
	    else
		/* don't skip 0 */
		lvalp->intn = yasm_intnum_create_hex(TOK+1, cur_line);
	    s->tok[TOKLEN] = savech;
	    RETURN(INTNUM);
	}
#line 1506 "nasm-token.c"
yy170:	yyaccept = 3;
	YYMARKER = ++YYCURSOR;
	if((YYLIMIT - YYCURSOR) < 3) YYFILL(3);
	yych = *YYCURSOR;
	goto yy171;
yy171:	if(yybm[0+yych] & 32) {
		goto yy170;
	}
	if(yych == 'E')	goto yy179;
	if(yych == 'e')	goto yy179;
	goto yy172;
yy172:
#line 230 "./modules/parsers/nasm/nasm-token.re"
{
	    savech = s->tok[TOKLEN];
	    s->tok[TOKLEN] = '\0';
	    lvalp->flt = yasm_floatnum_create(TOK);
	    s->tok[TOKLEN] = savech;
	    RETURN(FLTNUM);
	}
#line 1527 "nasm-token.c"
yy173:	yyaccept = 0;
	YYMARKER = ++YYCURSOR;
	if(YYLIMIT == YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	goto yy174;
yy174:	if(yych <= 'F'){
		if(yych <= '/'){
			if(yych == '.')	goto yy170;
			goto yy3;
		} else {
			if(yych <= '9')	goto yy173;
			if(yych <= '@')	goto yy3;
			goto yy175;
		}
	} else {
		if(yych <= '`'){
			if(yych == 'H')	goto yy177;
			goto yy3;
		} else {
			if(yych <= 'f')	goto yy175;
			if(yych == 'h')	goto yy177;
			goto yy3;
		}
	}
yy175:	++YYCURSOR;
	if(YYLIMIT == YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	goto yy176;
yy176:	if(yych <= 'G'){
		if(yych <= '9'){
			if(yych <= '/')	goto yy51;
			goto yy175;
		} else {
			if(yych <= '@')	goto yy51;
			if(yych <= 'F')	goto yy175;
			goto yy51;
		}
	} else {
		if(yych <= 'f'){
			if(yych <= 'H')	goto yy177;
			if(yych <= '`')	goto yy51;
			goto yy175;
		} else {
			if(yych != 'h')	goto yy51;
			goto yy177;
		}
	}
yy177:	yych = *++YYCURSOR;
	goto yy178;
yy178:
#line 209 "./modules/parsers/nasm/nasm-token.re"
{
	    s->tok[TOKLEN-1] = '\0'; /* strip off 'h' */
	    lvalp->intn = yasm_intnum_create_hex(TOK, cur_line);
	    RETURN(INTNUM);
	}
#line 1584 "nasm-token.c"
yy179:	yych = *++YYCURSOR;
	if(yych <= ','){
		if(yych != '+')	goto yy51;
		goto yy180;
	} else {
		if(yych <= '-')	goto yy180;
		if(yych <= '/')	goto yy51;
		if(yych <= '9')	goto yy181;
		goto yy51;
	}
yy180:	yych = *++YYCURSOR;
	if(yych <= '/')	goto yy51;
	if(yych >= ':')	goto yy51;
	goto yy181;
yy181:	++YYCURSOR;
	if(YYLIMIT == YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	goto yy182;
yy182:	if(yych <= '/')	goto yy172;
	if(yych <= '9')	goto yy181;
	goto yy172;
yy183:	yyaccept = 0;
	YYMARKER = ++YYCURSOR;
	if(YYLIMIT == YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	goto yy184;
yy184:	if(yybm[0+yych] & 64) {
		goto yy183;
	}
	if(yych <= 'O'){
		if(yych <= '@'){
			if(yych <= '.'){
				if(yych <= '-')	goto yy3;
				goto yy170;
			} else {
				if(yych <= '/')	goto yy3;
				if(yych <= '9')	goto yy173;
				goto yy3;
			}
		} else {
			if(yych <= 'G'){
				if(yych <= 'F')	goto yy175;
				goto yy3;
			} else {
				if(yych <= 'H')	goto yy177;
				if(yych <= 'N')	goto yy3;
				goto yy185;
			}
		}
	} else {
		if(yych <= 'g'){
			if(yych <= 'Q'){
				if(yych <= 'P')	goto yy3;
				goto yy185;
			} else {
				if(yych <= '`')	goto yy3;
				if(yych <= 'f')	goto yy175;
				goto yy3;
			}
		} else {
			if(yych <= 'o'){
				if(yych <= 'h')	goto yy177;
				if(yych <= 'n')	goto yy3;
				goto yy185;
			} else {
				if(yych != 'q')	goto yy3;
				goto yy185;
			}
		}
	}
yy185:	yych = *++YYCURSOR;
	goto yy186;
yy186:
#line 202 "./modules/parsers/nasm/nasm-token.re"
{
	    s->tok[TOKLEN-1] = '\0'; /* strip off 'q' or 'o' */
	    lvalp->intn = yasm_intnum_create_oct(TOK, cur_line);
	    RETURN(INTNUM);
	}
#line 1664 "nasm-token.c"
yy187:	yyaccept = 0;
	YYMARKER = ++YYCURSOR;
	if((YYLIMIT - YYCURSOR) < 2) YYFILL(2);
	yych = *YYCURSOR;
	goto yy188;
yy188:	if(yybm[0+yych] & 128) {
		goto yy187;
	}
	switch(yych){
	case '.':	goto yy170;
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':	goto yy183;
	case '8':
	case '9':	goto yy173;
	case 'A':	case 'C':
	case 'D':
	case 'E':
	case 'F':	case 'a':	case 'c':
	case 'd':
	case 'e':
	case 'f':	goto yy175;
	case 'B':	case 'b':	goto yy189;
	case 'H':	case 'h':	goto yy177;
	case 'O':	case 'Q':	case 'o':	case 'q':	goto yy185;
	default:	goto yy3;
	}
yy189:	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= 'G'){
		if(yych <= '9'){
			if(yych >= '0')	goto yy175;
			goto yy190;
		} else {
			if(yych <= '@')	goto yy190;
			if(yych <= 'F')	goto yy175;
			goto yy190;
		}
	} else {
		if(yych <= 'f'){
			if(yych <= 'H')	goto yy177;
			if(yych >= 'a')	goto yy175;
			goto yy190;
		} else {
			if(yych == 'h')	goto yy177;
			goto yy190;
		}
	}
yy190:
#line 195 "./modules/parsers/nasm/nasm-token.re"
{
	    s->tok[TOKLEN-1] = '\0'; /* strip off 'b' */
	    lvalp->intn = yasm_intnum_create_bin(TOK, cur_line);
	    RETURN(INTNUM);
	}
#line 1725 "nasm-token.c"
yy191:	yych = *++YYCURSOR;
	if(yych <= '@'){
		if(yych <= '/')	goto yy51;
		if(yych >= ':')	goto yy51;
		goto yy192;
	} else {
		if(yych <= 'F')	goto yy192;
		if(yych <= '`')	goto yy51;
		if(yych >= 'g')	goto yy51;
		goto yy192;
	}
yy192:	++YYCURSOR;
	if(YYLIMIT == YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	goto yy193;
yy193:	if(yych <= '@'){
		if(yych <= '/')	goto yy169;
		if(yych <= '9')	goto yy192;
		goto yy169;
	} else {
		if(yych <= 'F')	goto yy192;
		if(yych <= '`')	goto yy169;
		if(yych <= 'f')	goto yy192;
		goto yy169;
	}
}
}
#line 437 "./modules/parsers/nasm/nasm-token.re"


    /* %line linenum+lineinc filename */
linechg:
    SCANINIT();

    {
	static unsigned char yybm[] = {
	  0,   0,   0,   0,   0,   0,   0,   0, 
	  0,  64,   0,   0,   0,  64,   0,   0, 
	  0,   0,   0,   0,   0,   0,   0,   0, 
	  0,   0,   0,   0,   0,   0,   0,   0, 
	 64,   0,   0,   0,   0,   0,   0,   0, 
	  0,   0,   0,   0,   0,   0,   0,   0, 
	128, 128, 128, 128, 128, 128, 128, 128, 
	128, 128,   0,   0,   0,   0,   0,   0, 
	  0,   0,   0,   0,   0,   0,   0,   0, 
	  0,   0,   0,   0,   0,   0,   0,   0, 
	  0,   0,   0,   0,   0,   0,   0,   0, 
	  0,   0,   0,   0,   0,   0,   0,   0, 
	  0,   0,   0,   0,   0,   0,   0,   0, 
	  0,   0,   0,   0,   0,   0,   0,   0, 
	  0,   0,   0,   0,   0,   0,   0,   0, 
	  0,   0,   0,   0,   0,   0,   0,   0, 
	  0,   0,   0,   0,   0,   0,   0,   0, 
	  0,   0,   0,   0,   0,   0,   0,   0, 
	  0,   0,   0,   0,   0,   0,   0,   0, 
	  0,   0,   0,   0,   0,   0,   0,   0, 
	  0,   0,   0,   0,   0,   0,   0,   0, 
	  0,   0,   0,   0,   0,   0,   0,   0, 
	  0,   0,   0,   0,   0,   0,   0,   0, 
	  0,   0,   0,   0,   0,   0,   0,   0, 
	  0,   0,   0,   0,   0,   0,   0,   0, 
	  0,   0,   0,   0,   0,   0,   0,   0, 
	  0,   0,   0,   0,   0,   0,   0,   0, 
	  0,   0,   0,   0,   0,   0,   0,   0, 
	  0,   0,   0,   0,   0,   0,   0,   0, 
	  0,   0,   0,   0,   0,   0,   0,   0, 
	  0,   0,   0,   0,   0,   0,   0,   0, 
	  0,   0,   0,   0,   0,   0,   0,   0, 
	};

#line 1796 "nasm-token.c"
{
	YYCTYPE yych;
	goto yy194;
	++YYCURSOR;
yy194:
	if((YYLIMIT - YYCURSOR) < 2) YYFILL(2);
	yych = *YYCURSOR;
	if(yych <= '\037'){
		if(yych <= '\n'){
			if(yych <= '\b')	goto yy204;
			if(yych <= '\t')	goto yy202;
			goto yy198;
		} else {
			if(yych == '\r')	goto yy202;
			goto yy204;
		}
	} else {
		if(yych <= '+'){
			if(yych <= ' ')	goto yy202;
			if(yych <= '*')	goto yy204;
			goto yy200;
		} else {
			if(yych <= '/')	goto yy204;
			if(yych >= ':')	goto yy204;
			goto yy196;
		}
	}
yy196:	yych = *++YYCURSOR;
	goto yy209;
yy197:
#line 444 "./modules/parsers/nasm/nasm-token.re"
{
	    linechg_numcount++;
	    savech = s->tok[TOKLEN];
	    s->tok[TOKLEN] = '\0';
	    lvalp->intn = yasm_intnum_create_dec(TOK, cur_line);
	    s->tok[TOKLEN] = savech;
	    RETURN(INTNUM);
	}
#line 1836 "nasm-token.c"
yy198:	yych = *++YYCURSOR;
	goto yy199;
yy199:
#line 453 "./modules/parsers/nasm/nasm-token.re"
{
	    if (parser_nasm->save_input && cursor != s->eof)
		cursor = save_line(parser_nasm, cursor);
	    parser_nasm->state = INITIAL;
	    RETURN(s->tok[0]);
	}
#line 1847 "nasm-token.c"
yy200:	yych = *++YYCURSOR;
	goto yy201;
yy201:
#line 460 "./modules/parsers/nasm/nasm-token.re"
{
	    RETURN(s->tok[0]);
	}
#line 1855 "nasm-token.c"
yy202:	yych = *++YYCURSOR;
	goto yy207;
yy203:
#line 464 "./modules/parsers/nasm/nasm-token.re"
{
	    if (linechg_numcount == 2) {
		parser_nasm->state = LINECHG2;
		goto linechg2;
	    }
	    goto linechg;
	}
#line 1867 "nasm-token.c"
yy204:	yych = *++YYCURSOR;
	goto yy205;
yy205:
#line 472 "./modules/parsers/nasm/nasm-token.re"
{
	    yasm__warning(YASM_WARN_UNREC_CHAR, cur_line,
			  N_("ignoring unrecognized character `%s'"),
			  yasm__conv_unprint(s->tok[0]));
	    goto linechg;
	}
#line 1878 "nasm-token.c"
yy206:	++YYCURSOR;
	if(YYLIMIT == YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	goto yy207;
yy207:	if(yybm[0+yych] & 64) {
		goto yy206;
	}
	goto yy203;
yy208:	++YYCURSOR;
	if(YYLIMIT == YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	goto yy209;
yy209:	if(yybm[0+yych] & 128) {
		goto yy208;
	}
	goto yy197;
}
}
#line 478 "./modules/parsers/nasm/nasm-token.re"


linechg2:
    SCANINIT();

    {
	static unsigned char yybm[] = {
	128, 128, 128, 128, 128, 128, 128, 128, 
	128, 128,   0, 128, 128,   0, 128, 128, 
	128, 128, 128, 128, 128, 128, 128, 128, 
	128, 128, 128, 128, 128, 128, 128, 128, 
	128, 128, 128, 128, 128, 128, 128, 128, 
	128, 128, 128, 128, 128, 128, 128, 128, 
	128, 128, 128, 128, 128, 128, 128, 128, 
	128, 128, 128, 128, 128, 128, 128, 128, 
	128, 128, 128, 128, 128, 128, 128, 128, 
	128, 128, 128, 128, 128, 128, 128, 128, 
	128, 128, 128, 128, 128, 128, 128, 128, 
	128, 128, 128, 128, 128, 128, 128, 128, 
	128, 128, 128, 128, 128, 128, 128, 128, 
	128, 128, 128, 128, 128, 128, 128, 128, 
	128, 128, 128, 128, 128, 128, 128, 128, 
	128, 128, 128, 128, 128, 128, 128, 128, 
	128, 128, 128, 128, 128, 128, 128, 128, 
	128, 128, 128, 128, 128, 128, 128, 128, 
	128, 128, 128, 128, 128, 128, 128, 128, 
	128, 128, 128, 128, 128, 128, 128, 128, 
	128, 128, 128, 128, 128, 128, 128, 128, 
	128, 128, 128, 128, 128, 128, 128, 128, 
	128, 128, 128, 128, 128, 128, 128, 128, 
	128, 128, 128, 128, 128, 128, 128, 128, 
	128, 128, 128, 128, 128, 128, 128, 128, 
	128, 128, 128, 128, 128, 128, 128, 128, 
	128, 128, 128, 128, 128, 128, 128, 128, 
	128, 128, 128, 128, 128, 128, 128, 128, 
	128, 128, 128, 128, 128, 128, 128, 128, 
	128, 128, 128, 128, 128, 128, 128, 128, 
	128, 128, 128, 128, 128, 128, 128, 128, 
	128, 128, 128, 128, 128, 128, 128, 128, 
	};

#line 1939 "nasm-token.c"
{
	YYCTYPE yych;
	goto yy210;
	++YYCURSOR;
yy210:
	if(YYLIMIT == YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if(yybm[0+yych] & 128) {
		goto yy216;
	}
	if(yych >= '\r')	goto yy214;
	goto yy212;
yy212:	yych = *++YYCURSOR;
	goto yy213;
yy213:
#line 484 "./modules/parsers/nasm/nasm-token.re"
{
	    if (parser_nasm->save_input && cursor != s->eof)
		cursor = save_line(parser_nasm, cursor);
	    parser_nasm->state = INITIAL;
	    RETURN(s->tok[0]);
	}
#line 1962 "nasm-token.c"
yy214:	yych = *++YYCURSOR;
	goto yy215;
yy215:
#line 491 "./modules/parsers/nasm/nasm-token.re"
{ }
#line 1968 "nasm-token.c"
yy216:	++YYCURSOR;
	if(YYLIMIT == YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	goto yy217;
yy217:	if(yybm[0+yych] & 128) {
		goto yy216;
	}
	goto yy218;
yy218:
#line 493 "./modules/parsers/nasm/nasm-token.re"
{
	    parser_nasm->state = LINECHG;
	    lvalp->str_val = yasm__xstrndup(TOK, TOKLEN);
	    RETURN(FILENAME);
	}
#line 1984 "nasm-token.c"
}
}
#line 498 "./modules/parsers/nasm/nasm-token.re"


    /* directive: [name value] */
directive:
    SCANINIT();

    {
	static unsigned char yybm[] = {
	  0,   0,   0,   0,   0,   0,   0,   0, 
	  0,   0,   0,   0,   0,   0,   0,   0, 
	  0,   0,   0,   0,   0,   0,   0,   0, 
	  0,   0,   0,   0,   0,   0,   0,   0, 
	  0,   0,   0,   0,   0,   0,   0,   0, 
	  0,   0,   0,   0,   0,   0,   0,   0, 
	  0,   0,   0,   0,   0,   0,   0,   0, 
	  0,   0,   0,   0,   0,   0,   0,   0, 
	  0, 128, 128, 128, 128, 128, 128, 128, 
	128, 128, 128, 128, 128, 128, 128, 128, 
	128, 128, 128, 128, 128, 128, 128, 128, 
	128, 128, 128,   0,   0,   0,   0,   0, 
	  0, 128, 128, 128, 128, 128, 128, 128, 
	128, 128, 128, 128, 128, 128, 128, 128, 
	128, 128, 128, 128, 128, 128, 128, 128, 
	128, 128, 128,   0,   0,   0,   0,   0, 
	  0,   0,   0,   0,   0,   0,   0,   0, 
	  0,   0,   0,   0,   0,   0,   0,   0, 
	  0,   0,   0,   0,   0,   0,   0,   0, 
	  0,   0,   0,   0,   0,   0,   0,   0, 
	  0,   0,   0,   0,   0,   0,   0,   0, 
	  0,   0,   0,   0,   0,   0,   0,   0, 
	  0,   0,   0,   0,   0,   0,   0,   0, 
	  0,   0,   0,   0,   0,   0,   0,   0, 
	  0,   0,   0,   0,   0,   0,   0,   0, 
	  0,   0,   0,   0,   0,   0,   0,   0, 
	  0,   0,   0,   0,   0,   0,   0,   0, 
	  0,   0,   0,   0,   0,   0,   0,   0, 
	  0,   0,   0,   0,   0,   0,   0,   0, 
	  0,   0,   0,   0,   0,   0,   0,   0, 
	  0,   0,   0,   0,   0,   0,   0,   0, 
	  0,   0,   0,   0,   0,   0,   0,   0, 
	};

#line 2030 "nasm-token.c"
{
	YYCTYPE yych;
	goto yy219;
	++YYCURSOR;
yy219:
	if((YYLIMIT - YYCURSOR) < 2) YYFILL(2);
	yych = *YYCURSOR;
	if(yych <= 'Z'){
		if(yych == '\n')	goto yy221;
		if(yych <= '@')	goto yy225;
		goto yy223;
	} else {
		if(yych <= ']'){
			if(yych <= '\\')	goto yy225;
			goto yy221;
		} else {
			if(yych <= '`')	goto yy225;
			if(yych <= 'z')	goto yy223;
			goto yy225;
		}
	}
yy221:	yych = *++YYCURSOR;
	goto yy222;
yy222:
#line 505 "./modules/parsers/nasm/nasm-token.re"
{
	    if (parser_nasm->save_input && cursor != s->eof)
		cursor = save_line(parser_nasm, cursor);
	    parser_nasm->state = INITIAL;
	    RETURN(s->tok[0]);
	}
#line 2062 "nasm-token.c"
yy223:	yych = *++YYCURSOR;
	goto yy228;
yy224:
#line 512 "./modules/parsers/nasm/nasm-token.re"
{
	    parser_nasm->state = DIRECTIVE2;
	    lvalp->str_val = yasm__xstrndup(TOK, TOKLEN);
	    RETURN(DIRECTIVE_NAME);
	}
#line 2072 "nasm-token.c"
yy225:	yych = *++YYCURSOR;
	goto yy226;
yy226:
#line 518 "./modules/parsers/nasm/nasm-token.re"
{
	    yasm__warning(YASM_WARN_UNREC_CHAR, cur_line,
			  N_("ignoring unrecognized character `%s'"),
			  yasm__conv_unprint(s->tok[0]));
	    goto directive;
	}
#line 2083 "nasm-token.c"
yy227:	++YYCURSOR;
	if(YYLIMIT == YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	goto yy228;
yy228:	if(yybm[0+yych] & 128) {
		goto yy227;
	}
	goto yy224;
}
}
#line 524 "./modules/parsers/nasm/nasm-token.re"


    /* string/character constant values */
stringconst:
    strbuf = yasm_xmalloc(STRBUF_ALLOC_SIZE);
    strbuf_size = STRBUF_ALLOC_SIZE;
    count = 0;

stringconst_scan:
    SCANINIT();

    {

#line 2108 "nasm-token.c"
{
	YYCTYPE yych;
	goto yy229;
	++YYCURSOR;
yy229:
	if(YYLIMIT == YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if(yych != '\n')	goto yy233;
	goto yy231;
yy231:	yych = *++YYCURSOR;
	goto yy232;
yy232:
#line 536 "./modules/parsers/nasm/nasm-token.re"
{
	    if (cursor == s->eof)
		yasm__error(cur_line,
			    N_("unexpected end of file in string"));
	    else
		yasm__error(cur_line, N_("unterminated string"));
	    strbuf[count] = '\0';
	    lvalp->str.contents = (char *)strbuf;
	    lvalp->str.len = count;
	    if (parser_nasm->save_input && cursor != s->eof)
		cursor = save_line(parser_nasm, cursor);
	    if (count == 1)
		RETURN(ONECHARSTR);
	    RETURN(STRING);
	}
#line 2137 "nasm-token.c"
yy233:	yych = *++YYCURSOR;
	goto yy234;
yy234:
#line 552 "./modules/parsers/nasm/nasm-token.re"
{
	    if (s->tok[0] == endch) {
		strbuf[count] = '\0';
		lvalp->str.contents = (char *)strbuf;
		lvalp->str.len = count;
		if (count == 1)
		    RETURN(ONECHARSTR);
		RETURN(STRING);
	    }

	    strbuf[count++] = s->tok[0];
	    if (count >= strbuf_size) {
		strbuf = yasm_xrealloc(strbuf, strbuf_size + STRBUF_ALLOC_SIZE);
		strbuf_size += STRBUF_ALLOC_SIZE;
	    }

	    goto stringconst_scan;
	}
#line 2160 "nasm-token.c"
}
}
#line 570 "./modules/parsers/nasm/nasm-token.re"

}
