#include "xtama_createpixmap.h"

unsigned long AllocColor( Display *dpy , Colormap cmap , char *color , XColor *xcol , Bool sw )
{
  int cnum[3] , i ;
  char tmpcolor[3] ;
  static int AllocOfColor = 0 ;
  static struct _colordata{
    int red ;
    int green ;
    int blue ;
    
    int rred ;
    int rgreen ;
    int rblue ;
    
    int pixel ;
  } colordata[255] ;
  XColor rgb , hard ;

  xcol->flags = DoRed|DoGreen|DoBlue ;

  if ( !sw ){
    if ( color[0] == '#' ){
      color ++ ;
      for ( i = 0 ; i < 3 ; i ++ ){
	strncpy( tmpcolor , color , 2 ) ;
	sscanf( tmpcolor , "%x" , &cnum[i] ) ;
	cnum[i] *= 256 ;
	color += 2 ;
      }
      xcol->red = cnum[0] ;
      xcol->green = cnum[1] ;
      xcol->blue = cnum[2] ;
    }
    else {
      XLookupColor( dpy , cmap , color , &rgb , &hard ) ;
      xcol->red = hard.red ;
      xcol->green = hard.green ;
      xcol->blue = hard.blue ;
    }
    
    for ( i = 0 ; i < AllocOfColor ; i ++ ){
      if (( xcol->red == colordata[i].red && 
	   xcol->green == colordata[i].green &&
	   xcol->blue == colordata[i].blue ) ||
	  ( xcol->red == colordata[i].rred && 
	   xcol->green == colordata[i].rgreen &&
	   xcol->blue == colordata[i].rblue )){
	return colordata[i].pixel ;
      }
    }
  }
  
  colordata[AllocOfColor].red = xcol->red ;
  colordata[AllocOfColor].green = xcol->green ;
  colordata[AllocOfColor].blue = xcol->blue ;
  
  if ( !XAllocColor( dpy , cmap , xcol ) ){
    printf("\033[41;37m\rCan't allocate color cell !\nTry with option \"-install\"\n\033[m\b") ;
    exit(1) ;
  }
  
  colordata[AllocOfColor].rred = xcol->red ;
  colordata[AllocOfColor].rgreen = xcol->green ;
  colordata[AllocOfColor].rblue = xcol->blue ;
  colordata[AllocOfColor].pixel = xcol->pixel ;
  AllocOfColor ++ ;

  return xcol->pixel ;
}	

void CreatePixmapFromData( Display *dpy , Window win , Colormap cmap , char **xpmdata , Pixmap *pm1 , Pixmap *pm2 )
{
  int i , j , k , x , y , cforb , nofc ; 
  /* size is ( x , y ) : cforb means color for bytes
     nofc means number of colors */
  
  struct _ColorPallet {
    unsigned long pixel ; /*	pixel value for color pallet */
    char *cpattern ; 
  } CP[255] ;
  
  XColor tmpc ;
  GC gc = DefaultGC( dpy , DefaultScreen( dpy )) ;
  char buffer[20] , system , *mask , data[1000] ;
  
  sscanf( xpmdata[0] , "%d %d %d %d", &x , &y , &nofc , &cforb ) ;
  
  for ( i = 0 ; i < nofc ; i ++ ) {
    CP[i].cpattern = malloc( cforb + 1 ) ;
    if ( cforb != 1 ) sscanf( xpmdata[1+i] , "%s %c %s" , CP[i].cpattern , &system , buffer ) ;
    else{
      sscanf( &xpmdata[1+i][1] , " %c %s" , &system , buffer ) ;
      CP[i].cpattern[0] = xpmdata[1+i][0] ;
    }
    if ( system == 'c' ) CP[i].pixel = AllocColor( dpy , cmap , buffer , &tmpc , False ) ;	
    else	CP[i].pixel = -1 ;
    
  }

  *pm1 = XCreatePixmap( dpy , win , x , y , DefaultDepth(dpy,DefaultScreen(dpy))) ;
  mask = malloc( y*(x/8+1)) ;
  if ( mask == NULL )
    printf("Can't allocate memory\n");
  memset( mask , 0 , y*(x/8+1)) ;

  for ( i = 0 ; i < y ; i ++ ){
    decomp( xpmdata[1+nofc+i] , data , x , cforb ) ;
    for ( j = 0 ; j < x ; j ++ )
      for ( k = 0 ; k < nofc ; k ++ ){
	if ( !strncmp( &data[j*cforb] , CP[k].cpattern , cforb ))
	  if ( CP[k].pixel != -1 ){
	    XSetForeground( dpy , gc , CP[k].pixel );
	    XDrawPoint( dpy , *pm1 , gc , j , i ) ;
	    MDrawPoint( mask , j , i , x , y ) ;
	    k = nofc ;
	  }
      }
  }  

  if ( pm2 != NULL ){
    *pm2 = XCreateBitmapFromData( dpy , win , mask , x , y ) ;
  }
  free( mask ) ;
  
}

void MDrawPoint( char *ptr , int x , int y , int xx , int yy )
{
  int i , j ;
  int bpl ;

  bpl = xx / 8 ; /* bytes per line */
  if ( xx % 8 )
    bpl ++ ;
  
  i = x / 8 ;
  j = x % 8 ;

  ptr[bpl*y+i] |= 1 << j ;
}

void decomp( char *data , char *rtn , int width , int cforb){
  int i , ii , ptr , r = 0 ;
  char buf[10] , rp ;

  rtn[0] = '\0' ;
  for ( i = 0 , ptr = 0 ; i < width ; ptr ++){
    strncpy( buf , &data[ptr] , cforb ) ;
    buf[cforb] = '\0' ;
    ptr += cforb ;
    rp = data[ptr] ;
    r = rp - '#' + 1 ;
    for ( ii = 0 ; ii < r ; ii ++ ){
      strcat( rtn , buf ) ;
      i ++ ;
    }
  }
}
