#! /usr/bin/perl -w


# Ham Radio Country info module result.pm by PA0R.

# This program is published under the GPL license.
#   Copyright (C) 2005, 2006
#       Rein Couperus PA0R (rein@couperus.com)
# 
# *    result.pm is free software; you can redistribute it and/or modify
# *    it under the terms of the GNU General Public License as published by
# *    the Free Software Foundation; either version 2 of the License, or
# *    (at your option) any later version.
# *
# *    result.pm is distributed in the hope that it will be useful,
# *    but WITHOUT ANY WARRANTY; without even the implied warranty of
# *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# *    GNU General Public License for more details.
# *
# *    You should have received a copy of the GNU General Public License
# *    along with this program; if not, write to the Free Software
# *    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

# Date: 04-04-06

use prefix;

###########################################################
sub qsos {
###########################################################
	my @pts = countqso();
	my $ptsprint = sprintf ("QSO  : %4d  %4d  %4d  %4d  %4d  %4d\n", $pts[0], $pts[1], $pts[2],
	 $pts[3], $pts[4], $pts[5]);
	
	return ($pts[0] + $pts[1] + $pts[2] + $pts[3] + $pts[4] + $pts[5], $ptsprint);

}
###########################################################
sub cwqsos {
###########################################################
	my @pts = countcwqso();
	my $ptsprint = sprintf ("CWQso: %4d  %4d  %4d  %4d  %4d  %4d\n", $pts[0], $pts[1], $pts[2],
	 $pts[3], $pts[4], $pts[5]);
	
	return ($pts[0] + $pts[1] + $pts[2] + $pts[3] + $pts[4] + $pts[5], $ptsprint);

}
###########################################################
sub ssbqsos {
###########################################################
	my @pts = countssbqso();
	my $ptsprint = sprintf ("PHQso: %4d  %4d  %4d  %4d  %4d  %4d\n", $pts[0], $pts[1], $pts[2],
	 $pts[3], $pts[4], $pts[5]);
	
	return ($pts[0] + $pts[1] + $pts[2] + $pts[3] + $pts[4] + $pts[5], $ptsprint);

}

###########################################################
sub cnt_countries {
###########################################################
	my @out = ();
	my @cties = count_country();
	my $ctieprint= sprintf ("cty  : %4d  %4d  %4d  %4d  %4d  %4d\n", $cties[0], $cties[1], $cties[2],
	 $cties[3], $cties[4], $cties[5]);
	my $totalcties = $cties[0] + $cties[1] + $cties[2] + $cties[3] + $cties[4] + $cties[5];
	push @out, $totalcties;
	push @out, $ctieprint;
	return  @out;
}

###########################################################
sub cnt_cqzones {
###########################################################
	my @zones = count_cqzone();
	my $zoneprint = sprintf ("Zones: %4d  %4d  %4d  %4d  %4d  %4d\n", $zones[0], $zones[1], $zones[2],
	 $zones[3], $zones[4], $zones[5]);

	return ($zones[0] + $zones[1] + $zones[2] + $zones[3] + $zones[4] + $zones[5], $zoneprint); 
}
###########################################################
sub cnt_ituzones {
###########################################################
	my @zones = count_ituzone();
	my $zoneprint = sprintf ("ITU-Z: %4d  %4d  %4d  %4d  %4d  %4d\n", $zones[0], $zones[1], $zones[2],
	 $zones[3], $zones[4], $zones[5]);

	return ($zones[0] + $zones[1] + $zones[2] + $zones[3] + $zones[4] + $zones[5], $zoneprint); 
}

###########################################################
sub cnt_yupfxes {
###########################################################
	my @pfxes = count_yupfxes();
	my $pfxprint = sprintf ("YUPFX: %4d  %4d  %4d  %4d  %4d  %4d\n", $pfxes[0],
		   	$pfxes[1], $pfxes[2], $pfxes[3], $pfxes[4], $pfxes[5]);

	return ($pfxes[0] + $pfxes[1] + $pfxes[2] + $pfxes[3] + $pfxes[4] +
			$pfxes[5], $pfxprint); 
}

###########################################################
sub cnt_sections {
###########################################################
	my @sections = countsections();
	my $sectionprint = sprintf ("Sect : %4d  %4d  %4d  %4d  %4d  %4d\n", $sections[0], $sections[1], $sections[2], $sections[3], $sections[4], $sections[5]);

	return ($sections[0] + $sections[1] + $sections[2] + $sections[3] + $sections[4] + $sections[5], $sectionprint); 
}
###########################################################
sub cnt_wsections {
###########################################################
	my @sections = countwsections();
	my $sectionprint = sprintf ("Sect : %4d  %4d  %4d  %4d  %4d  %4d\n", $sections[0], $sections[1], $sections[2], $sections[3], $sections[4], $sections[5]);

	return ($sections[0] + $sections[1] + $sections[2] + $sections[3] + $sections[4] + $sections[5], $sectionprint); 
}
###########################################################
sub cnt_sections_all {
###########################################################
	my @sections = countsections_all();
	my $sectionprint = sprintf ("Sect : %4d\n", $sections[0]);

	return ($sections[0], $sectionprint); 
}

###########################################################
sub cnt_cwsections {
###########################################################
	my @sections = countcwsections();
	my $cwsectionprint = sprintf ("CWsect %4d  %4d  %4d  %4d  %4d  %4d\n", $sections[0], $sections[1], $sections[2], $sections[3], $sections[4], $sections[5]);

	return ($sections[0] + $sections[1] + $sections[2] + $sections[3] + $sections[4] + $sections[5], $cwsectionprint); 
}
###########################################################
sub cnt_ssbsections {
###########################################################
	my @sections = countssbsections();
	my $ssbsectionprint = sprintf ("PHsect %4d  %4d  %4d  %4d  %4d  %4d\n", $sections[0], $sections[1], $sections[2], $sections[3], $sections[4], $sections[5]);

	return ($sections[0] + $sections[1] + $sections[2] + $sections[3] + $sections[4] + $sections[5], $ssbsectionprint); 
}
##########################################################
sub cnt_prefixes {
##########################################################
	my $prefixes = countprefixes();
	my $prefixesprint = sprintf ("Pfx  : %d\n", $prefixes);
	return ($prefixes, $prefixesprint);
}

###########################################################
sub printresult {
###########################################################
my ($totalpoints, $totalmults, $score, $printlines) = @_;

print "$contestname\n";
print "-----------------------------------------\n";
print "Band    160    80    40    20    15    10\n";
print $printlines;
print "-----------------------------------------\n";
printf ("Pts: %6d  Mults: %4d  Score: %8d", $totalpoints, $totalmults, $score);
#print "-----------------------------------------\n";
}
###########################################################
sub printtable {
###########################################################
my ($totalpoints, $totalmults, $score, $printlines) = @_;

if ($contestname eq "DXpedition mode" || $contestname eq "General QSO mode") { return 0;}

my $table = "";
#$table .= $contestname;
$table .=  "Band    160    80    40    20    15    10\n";
$table .=  "-----------------------------------------\n";
$table .=  $printlines;
$table .=  "-----------------------------------------\n";
my $resultline =  sprintf ("Pts: %6d  Mults: %4d  Score: %8d", $totalpoints, $totalmults, $score);
$table .= $resultline;
#$table .=  "-----------------------------------------\n";

return $table;
}
###########################################################
1;

