/*******************************************************************
 * Handle state machine related functions.
 *
 * Licensed under a dual GPL/BSD license.  (See LICENSE file for more info.)
 *
 * File: statemachine.h
 *
 * Authors: Chris.Hessing@utah.edu
 *
 *******************************************************************/

#ifndef _STATEMACHINE_H_
#define _STATEMACHINE_H_

// This matches the order of states listed in IEEE 802.1x-2001, pg. 59,
// section 8.5.10.
#define LOGOFF           0
#define DISCONNECTED     1
#define CONNECTING       2
#define ACQUIRED         3
#define AUTHENTICATING   4
#define HELD             5
#define AUTHENTICATED    6

// 802.1x-REV-d11 (2004) specifies a few additional states.  Also, in EAPoL
// v2, the ACQUIRED state no longer exists.
#define RESTART          7
#define S_FORCE_AUTH     8
#define S_FORCE_UNAUTH   9

int statemachine_init(struct interface_data *);
int statemachine_reinit(struct interface_data *);
int statemachine_run(struct interface_data *);
int statemachine_cleanup(struct interface_data *);
int txLogoff(struct interface_data *);
int txRspId(struct interface_data *, char *, int *);
int txRspAuth(struct interface_data *, char *, int, char *, int *);
int txStart(struct interface_data *);
int statemachine_change_state(struct interface_data *, int);
#endif
