/*
 * Copyright (c) 2001-2008
 *     DecisionSoft Limited. All rights reserved.
 * Copyright (c) 2004-2008
 *     Oracle. All rights reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * $Id$
 */

#ifndef _MESSAGELISTENER_HPP
#define _MESSAGELISTENER_HPP

#include <xqilla/framework/XQillaExport.hpp>
#include <xercesc/util/XercesDefs.hpp>

class LocationInfo;
class DynamicContext;
class Sequence;

/** 
 * A class used to listen for warnings or trace information
 */
class XQILLA_API MessageListener {
public:
  /* virtual destructor, does nothing */
  virtual ~MessageListener() {};

  /**
   * Called to report a warning message
   */
  virtual void warning(const XMLCh *message, const LocationInfo *location) = 0;

  /**
   * Called to report a trace message
   */
  virtual void trace(const XMLCh *label, const Sequence &sequence, const LocationInfo *location, const DynamicContext *context) = 0;

};
#endif
