/*-
# X-BASED SKEWB
#
#  SkewbP.h
#
###
#
#  Copyright (c) 1994 - 2007	David Albert Bagley, bagleyd@tux.org
#
#                   All Rights Reserved
#
#  Permission to use, copy, modify, and distribute this software and
#  its documentation for any purpose and without fee is hereby granted,
#  provided that the above copyright notice appear in all copies and
#  that both that copyright notice and this permission notice appear in
#  supporting documentation, and that the name of the author not be
#  used in advertising or publicity pertaining to distribution of the
#  software without specific, written prior permission.
#
#  This program is distributed in the hope that it will be "playable",
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
#
*/

/* Private header file for Skewb */

#ifndef _SkewbP_h
#define _SkewbP_h

#include "xwin.h"
#include "timer.h"
#include "Skewb.h"

#ifdef WINVER
extern void DestroyPuzzle(HBRUSH brush);
extern void ResizePuzzle(SkewbWidget w);
extern void SizePuzzle(SkewbWidget w);
extern void InitializePuzzle(SkewbWidget w, HBRUSH brush);
extern void ExposePuzzle(SkewbWidget w);
extern void DimPuzzle(SkewbWidget w);
extern int  MovePuzzleDir(SkewbWidget w, const int direction);
extern void setPuzzle(SkewbWidget w, int reason);
extern void setPuzzleMove(SkewbWidget w, int reason, int face, int position,
	int direction);

#else

/* This gets around C's inability to do inheritance */
typedef struct _SkewbClassPart {
	int         ignore;
} SkewbClassPart;

typedef struct _SkewbClassRec {
	CoreClassPart coreClass;
	SkewbClassPart skewbClass;
} SkewbClassRec;

extern SkewbClassRec skewbClassRec;

extern void QuitPuzzle(SkewbWidget w, XEvent *event, char **args, int nArgs);
extern void MovePuzzleCw(SkewbWidget w, XEvent *event, char **args, int nArgs);
extern void MovePuzzleCcw(SkewbWidget w, XEvent *event, char **args,
	int nArgs);
#endif

#ifndef MOVESOUND
#define MOVESOUND "move"
#endif

#define SYMBOL ':'

#define TR 0
#define BR 1
#define BL 2
#define TL 3
#define STRT 4
#define CW 5
#define HALF 6
#define CCW 7
#define TOP 8
#define RIGHT 9
#define BOTTOM 10
#define LEFT 11
#define MAXORIENT 4
#define MAXROTATE 3
#define MAXCUBES (MAXORIENT+1)
#define MINOR 0
#define MAJOR 1

typedef struct _SkewbLocPos {
	int         face, position, direction;
} SkewbLocPos;

typedef struct _MoveRecord {
#if 0
	int face, position, direction, control;
#endif
	unsigned short int packed;  /* This makes assumptions on the data. */
} MoveRecord;

typedef struct _MoveStack {
	MoveRecord move;
	struct _MoveStack *previous, *next;
} MoveStack;

typedef struct _SkewbStack {
	MoveStack *currMove, *lastMove, *firstMove;
	int count;
} SkewbStack;

typedef struct _SkewbLoc {
	int face, rotation;
} SkewbLoc;

typedef struct _SkewbPart {
	SkewbLoc    cubeLoc[MAXFACES][MAXCUBES];
	SkewbLoc    faceLoc[MAXCUBES];
	SkewbLoc    rowLoc[MAXORIENT][MAXCUBES];
	SkewbLoc    minorLoc[MAXORIENT], majorLoc[MAXORIENT][MAXORIENT];
	SkewbLoc    skewbLoc[MAXFACES][MAXCUBES];
	int         currentFace, currentPosition, currentDirection;
	Boolean     started, cheat, sound;
	Boolean     practice, orient, vertical, mono, reverse, focus;
	Boolean     scoreOnly, versionOnly;
	int         dim; /* This allows us to reuse code between 2d and 3d */
	int         degreeTurn, view;
	int         delay;
	Position    delta;
	Position    orientLineLength;
	Point       puzzleSize;
	Point       puzzleOffset, letterOffset;
	GC          frameGC, borderGC, inverseGC;
	GC          faceGC[MAXFACES];
#ifdef WINVER
	char        userName[81], scoreFile[81], moveSound[81];
	char        faceChar[MAXFACES];
#else
	int         menu, pixmapSize;
	char       *userName, *scoreFile, *moveSound, *font;
	XFontStruct *fontInfo;
	char       *faceName[MAXFACES];
	Pixel       foreground, background;
	Pixel       frameColor, borderColor;
	Pixel       faceColor[MAXFACES];
	XtCallbackList select;
#endif
} SkewbPart;

typedef struct _SkewbRec {
	CorePart    core;
	SkewbPart   skewb;
} SkewbRec;

typedef struct _RowNext {
	int         face, direction, sideFace;
} RowNext;

extern void HidePuzzle(
#ifdef WINVER
const SkewbWidget w
#else
SkewbWidget w, XEvent *event, char **args, int nArgs
#endif
);
extern void SelectPuzzle(SkewbWidget w
#ifdef WINVER
, const int x, const int y, const int control, const int alt
#else
, XEvent *event, char **args, int nArgs
#endif
);
extern void ReleasePuzzle(SkewbWidget w
#ifdef WINVER
, const int x, const int y, const int control, const int alt
#else
, XEvent *event, char **args, int nArgs
#endif
);
#ifndef WINVER
extern void PracticePuzzleMaybe(SkewbWidget w
, XEvent *event, char **args, int nArgs
);
extern void PracticePuzzle2(SkewbWidget w
, XEvent *event, char **args, int nArgs
);
extern void RandomizePuzzleMaybe(SkewbWidget w
, XEvent *event, char **args, int nArgs
);
extern void RandomizePuzzle2(SkewbWidget w
, XEvent *event, char **args, int nArgs
);
#endif
extern void GetPuzzle(SkewbWidget w
#ifndef WINVER
, XEvent *event, char **args, int nArgs
#endif
);
extern void WritePuzzle(SkewbWidget w
#ifndef WINVER
, XEvent *event, char **args, int nArgs
#endif
);
extern void UndoPuzzle(SkewbWidget w
#ifndef WINVER
, XEvent *event, char **args, int nArgs
#endif
);
extern void RedoPuzzle(SkewbWidget w
#ifndef WINVER
, XEvent *event, char **args, int nArgs
#endif
);
extern void ClearPuzzle(SkewbWidget w
#ifndef WINVER
, XEvent *event, char **args, int nArgs
#endif
);
extern void RandomizePuzzle(SkewbWidget w
#ifndef WINVER
, XEvent *event, char **args, int nArgs
#endif
);
extern void SolvePuzzle(SkewbWidget w
#ifndef WINVER
, XEvent *event, char **args, int nArgs
#endif
);
extern void PracticePuzzle(SkewbWidget w
#ifndef WINVER
, XEvent *event, char **args, int nArgs
#endif
);
extern void OrientizePuzzle(SkewbWidget w
#ifndef WINVER
, XEvent *event, char **args, int nArgs
#endif
);
extern void ViewPuzzle(SkewbWidget w
#ifndef WINVER
, XEvent *event, char **args, int nArgs
#endif
);
extern void SpeedPuzzle(SkewbWidget w
#ifndef WINVER
, XEvent *event, char **args, int nArgs
#endif
);
extern void SlowPuzzle(SkewbWidget w
#ifndef WINVER
, XEvent *event, char **args, int nArgs
#endif
);
extern void SoundPuzzle(SkewbWidget w
#ifndef WINVER
, XEvent *event, char **args, int nArgs
#endif
);
extern void EnterPuzzle(SkewbWidget w
#ifndef WINVER
, XEvent *event, char **args, int nArgs
#endif
);
extern void LeavePuzzle(SkewbWidget w
#ifndef WINVER
, XEvent *event, char **args, int nArgs
#endif
);

extern void MovePuzzleInput(SkewbWidget w, int x, int y, int direction,
	int control, int alt);
extern void MovePuzzle(SkewbWidget w, int face, int position, int direction,
	int control);
extern void SetAllColors(SkewbWidget w);
#if 0
/* For future auto-solver */
extern void SolvePieces(SkewbWidget w);

#endif
extern void DrawAllPieces(SkewbWidget w);
extern Boolean CheckSolved(SkewbWidget w);
extern void newMoves(SkewbStack *s);
extern void deleteMoves(SkewbStack *s);
extern void setMove(SkewbStack *s,
	int face, int position, int direction, int control);
extern void getMove(SkewbStack *s,
	int *face, int *position, int *direction, int *control);
extern int madeMoves(SkewbStack *s);
extern void flushMoves(SkewbWidget w, SkewbStack *s, Boolean undo);
extern int numMoves(SkewbStack *s);
extern void scanMoves(FILE *fp, SkewbWidget w, int moves);
extern void printMoves(FILE *fp, SkewbStack *s);
extern void scanStartPosition(FILE *fp, SkewbWidget w);
extern void printStartPosition(FILE *fp, SkewbWidget w);
extern void setStartPosition(SkewbWidget w);

#ifdef DEBUG
extern void PrintCube(SkewbWidget w);

#endif

#endif /* _SkewbP_h */
