/*-
# X-BASED PYRAMINX(tm)
#
#  Pyraminx.h
#
###
#
#  Copyright (c) 1994 - 2007	David Albert Bagley, bagleyd@tux.org
#
#                   All Rights Reserved
#
#  Permission to use, copy, modify, and distribute this software and
#  its documentation for any purpose and without fee is hereby granted,
#  provided that the above copyright notice appear in all copies and
#  that both that copyright notice and this permission notice appear in
#  supporting documentation, and that the name of the author not be
#  used in advertising or publicity pertaining to distribution of the
#  software without specific, written prior permission.
#
#  This program is distributed in the hope that it will be "playable",
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
#
*/

/* Public header file for Pyraminx */

#ifndef _XtPyraminx_h
#define _XtPyraminx_h

/***********************************************************************
 *
 * Pyraminx Widget
 *
 ***********************************************************************/

#ifndef WINVER
#define XtNmono ((char *) "mono")
#define XtNframeColor ((char *) "frameColor")
#define XtNfaceColor0 ((char *) "faceColor0")
#define XtNfaceColor1 ((char *) "faceColor1")
#define XtNfaceColor2 ((char *) "faceColor2")
#define XtNfaceColor3 ((char *) "faceColor3")
#define XtNpieceBorder ((char *) "pieceBorder")
#define XtNdelay ((char *) "delay")
#define XtNsound ((char *) "sound")
#define XtNmoveSound ((char *) "moveSound")
#define XtNsize ((char *) "size")
#define XtNsticky ((char *) "sticky")
#define XtNmode ((char *) "mode")
#define XtNorient ((char *) "orient")
#define XtNpractice ((char *) "practice")
#define XtNuserName ((char *) "userName")
#define XtNscoreFile ((char *) "scoreFile")
#define XtNscoreOnly ((char *) "scoreOnly")
#define XtNversionOnly ((char *) "versionOnly")
#define XtNmenu ((char *) "menu")
#define XtNstart ((char *) "start")
#define XtNcheat ((char *) "cheat")
#define XtNpixmapSize ((char *) "pixmapSize")
#define XtNselectCallback ((char *) "selectCallback")
#define XtCMono ((char *) "Mono")
#define XtCDelay ((char *) "Delay")
#define XtCSound ((char *) "Sound")
#define XtCMoveSound ((char *) "MoveSound")
#define XtCSize ((char *) "Size")
#define XtCSticky ((char *) "Sticky")
#define XtCMode ((char *) "Mode")
#define XtCOrient ((char *) "Orient")
#define XtCPractice ((char *) "Practice")
#define XtCUserName ((char *) "UserName")
#define XtCScoreFile ((char *) "ScoreFile")
#define XtCMenu ((char *) "Menu")
#define XtCPixmapSize ((char *) "PixmapSize")

typedef struct _PyraminxClassRec *PyraminxWidgetClass;

extern WidgetClass pyraminxWidgetClass;

typedef struct {
	XEvent     *event;
	int         reason;
} pyraminxCallbackStruct;
#endif

#define ACTION_GET 100
#define ACTION_WRITE 101
#define ACTION_EXIT 102
#define ACTION_HIDE 103
#define ACTION_PRACTICE_QUERY 104
#define ACTION_RANDOMIZE_QUERY 105
#define ACTION_SOLVE_MESSAGE 106
#define ACTION_RESTORE 107
#define ACTION_RESET 108
#define ACTION_AMBIGUOUS 109
#define ACTION_ILLEGAL 110
#define ACTION_MOVED 111
#define ACTION_CONTROL 112
#define ACTION_SOLVED 113
#define ACTION_COMPUTED 114
#define ACTION_UNDO 200
#define ACTION_REDO 201
#define ACTION_CLEAR 202
#define ACTION_PRACTICE 203
#define ACTION_RANDOMIZE 204
#define ACTION_SOLVE 205
#define ACTION_INCREMENT 206
#define ACTION_DECREMENT 207
#define ACTION_ORIENTIZE 208
#define ACTION_STICKY 209
#define ACTION_SPEED 210
#define ACTION_SLOW 211
#define ACTION_SOUND 212
#define ACTION_TOP 300
#define ACTION_TR 301
#define ACTION_RIGHT 302
#define ACTION_BOTTOM 303
#define ACTION_BL 304
#define ACTION_LEFT 305
#define ACTION_CW 307
#define ACTION_CCW 311
#define ACTION_SHIFT_TOP 320
#define ACTION_SHIFT_TR 321
#define ACTION_SHIFT_RIGHT 322
#define ACTION_SHIFT_BOTTOM 323
#define ACTION_SHIFT_BL 324
#define ACTION_SHIFT_LEFT 325
#define ACTION_SHIFT_CW 327
#define ACTION_SHIFT_CCW 331
#define ACTION_CONTROL_TOP 340
#define ACTION_CONTROL_TR 341
#define ACTION_CONTROL_RIGHT 342
#define ACTION_CONTROL_BOTTOM 343
#define ACTION_CONTROL_BL 344
#define ACTION_CONTROL_LEFT 345
#define ACTION_CONTROL_CW 347
#define ACTION_CONTROL_CCW 351
#define ACTION_SHIFTCONTROL_TOP 360
#define ACTION_SHIFTCONTROL_TR 361
#define ACTION_SHIFTCONTROL_RIGHT 362
#define ACTION_SHIFTCONTROL_BOTTOM 363
#define ACTION_SHIFTCONTROL_BL 364
#define ACTION_SHIFTCONTROL_LEFT 365
#define ACTION_SHIFTCONTROL_CW 367
#define ACTION_SHIFTCONTROL_CCW 371
#define ACTION_PERIOD2 400
#define ACTION_PERIOD3 401
#define ACTION_BOTH 402
#define ACTION_DESCRIPTION 900
#define ACTION_FEATURES 901
#define ACTION_REFERENCES 902
#define ACTION_ABOUT 903
#define ACTION_IGNORE 999

#define MINFACETS 1
#define PERIOD2 2
#define PERIOD3 3
#define BOTH 4
#define MAXMODES 3
#define DEFAULTMODE PERIOD3
#define DEFAULTFACETS 3
#define DEFAULTORIENT FALSE
#define DEFAULTPRACTICE TRUE
#define DEFAULTSTICKY FALSE
#ifdef MONOTEST
#define DEFAULTMONO TRUE
#else
#define DEFAULTMONO FALSE
#endif
#define DEFAULTREVERSE FALSE

#define BOOL_STRING(a) ((a==0)?"false":"true")

typedef struct _PyraminxRec *PyraminxWidget;

#endif /* _XtPyraminx_h */
/* DON'T ADD STUFF AFTER THIS #endif */
