/*

    xpuyopuyo - pinterface-gtk.c    Copyright(c) 1999,2000 Justin David Smith
    justins(at)chaos2.org           http://chaos2.org/

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/


#include <stdlib.h>
#include <stdio.h>
#include <stdarg.h>
#include <string.h>
#include <config.h>
#include <pwindow-gtk.h>
#include <pdialog-gtk.h>
#include <pkey-gtk.h>
#include <pmenu-gtk.h>
#include <pai-gtk.h>
#include <pfield.h>
#include <ppiece.h>
#include <pmanip.h>
#include <psnprintf.h>
#include <pnet.h>



void p_window_run(pwindow *w_, pconfig *c) {

   pwindow_gtk *w = (pwindow_gtk *)w_;

   if(w == NULL) return;
   w->c = c;
   gtk_main();
   return;

}



void p_window_idle(pwindow *w_) {

   if(w_ == NULL) return;
   while (gtk_events_pending()) gtk_main_iteration();

}


void p_window_set_message(pwindow *w_, const char *msg) {

   pwindow_gtk *w = (pwindow_gtk *)w_;
   
   if(w == NULL) {
      printf("dialog:  %s\n", msg);
   } else {
      if(!w->c->quiet) printf("dialog:  %s\n", msg);
      p_dialog(w, "Message", msg);
   }

}


void p_window_set_status(pwindow *w_, const char *msg) {

   pwindow_gtk *w = (pwindow_gtk *)w_;

   if(w == NULL) {
      if(msg != NULL) printf("status:  %s\n", msg);
   } else {
      if(w->status.message != NULL) free(w->status.message);
      w->status.message = NULL;
      if(msg != NULL) {
         w->status.message = (char *)malloc(strlen(msg) + 1);
         if(w->status.message != NULL) strncpy(w->status.message, msg, strlen(msg) + 1);
      }
      p_window_statusbar_paint(&w->status);
   }
      
}


void p_window_set_waiting(pwindow *w_, int waiting) {

   pwindow_gtk *w = (pwindow_gtk *)w_;
   
   if(w == NULL) return;
   if(waiting && w->c->waiting) return;
   if(!waiting && !w->c->waiting) return;
   
   w->c->waiting = waiting;
   p_window_update_menus(w);

}


void p_window_set_player_info(pwindow *w_, int i, const pplayer *p) {

   pwindow_gtk *w = (pwindow_gtk *)w_;
   pwindow_gtk_status *sp;
   
   if(w == NULL) return;
   
   sp = &w->player[i];
   if(sp->message != NULL) free(sp->message);
   sp->message = NULL;
   if(p != NULL) {
      sp->message = (char *)malloc(64);
      if(sp->message != NULL) {
         p_snprintf(sp->message, 64, "%d: %s %s [%d]", p->number + 1, p->name, p->aiactive ? "(ai)" : (p->network ? "(net)" : ""), p->wins);
      } 
   }
   
   p_window_statusbar_paint(sp);
   
}


#if !HAVE_SNPRINTF
int int_snprintf(char *buf, size_t n, const char *format, ...) {

   va_list args;
   int result;
   
   va_start(args, format);
   result = g_vsnprintf(buf, n, format, args);
   va_end(args);
   
   return(result);

}
#endif /* Don't have snprintf() ? */
