/*

    xpuyopuyo - pgame.c       Copyright(c) 1999,2000 Justin David Smith
    justins(at)chaos2.org     http://chaos2.org/
    
    Main game control code.
    

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/


#include <stdio.h>
#include <stdlib.h>
#include <getopt.h>
#include <config.h>
#include <xpuyopuyo.h>
#include <pwindow.h>
#include <pfield.h>
#include <pmanip.h>
#include <ppiece.h>
#include <ptournament.h>
#include <pai.h>


#if USE_AIBREED


void p_game_tournament_init(pconfig *c) {
/* p_game_tournament_init */

   int i;

   printf("\n\nRunning in tournament mode ...\n\n");

   for(i = 0; i < P_AI_COUNT; i++) c->tcurround[i] = i;
   c->tournament = P_AI_COUNT;
   
}


void p_game_tournament_next_round(pconfig *c) {
/* p_game_tournament_next_round */

   int i;
   int j;
   
   printf("Moving to next round ...\n\n");
   for(i = 0, j = 0; i < c->tournament; i++) {
      if(c->tnextround[i] != -1) c->tcurround[j++] = c->tnextround[i];
   }
   c->tournament = j;
   return;
   
}


void p_game_tournament_randomize_current(pconfig *c) {
/* p_game_tournament_randomize_current */

   int i;
   int j;

   for(i = 1; i < c->tournament; i++) {
      for(j = 0; j < i; j++) {
         if((rand() & 3) == 0) {
            c->tcurround[j] = c->tcurround[j] + c->tcurround[i];
            c->tcurround[i] = c->tcurround[j] - c->tcurround[i];
            c->tcurround[j] = c->tcurround[j] - c->tcurround[i];
         }
      }
   }
   printf("For this round, the participants are:\n");
   for(i = 0; i < c->tournament; i++) {   
      printf("  %s", p_ai_name_of(c->airules, c->tcurround[i]));
   }
   printf("\n\n");
   
   return;
   
}


void p_game_tournament_clear_next(pconfig *c) {
/* p_game_tournament_clear_next */

   int i;
   
   for(i = 0; i < P_AI_COUNT; i++) {
      c->tnextround[i] = -1;
   }
   return;

}


void p_game_tournament_advance(pconfig *c, int r) {
/* p_game_tournament_advance */

   int i;
   
   for(i = 0; i < P_AI_COUNT; i++) {
      if(c->tnextround[i] == -1) {
         c->tnextround[i] = r;
         i = P_AI_COUNT;
      }
   }
   
   printf("%s will advance to the next round.\n", p_ai_name_of(c->airules, r));

   return;

}


void p_game_tournament_remove_current(pconfig *c) {
/* p_game_tournament_remove_current */

   int i;
   
   for(i = 2; i < P_AI_COUNT; i++) {
      c->tcurround[i - 2] = c->tcurround[i];
   }
   c->tcurround[P_AI_COUNT - 2] = -1;
   c->tcurround[P_AI_COUNT - 1] = -1;
   return;

}


#endif
