/*
 * Copyright (c) 2001-2008 International Computer Science Institute
 * See LICENSE file for licensing, conditions, and warranties on use.
 *
 * DO NOT EDIT THIS FILE - IT IS PROGRAMMATICALLY GENERATED
 *
 * Generated by 'clnt-gen'.
 *
 * $XORP: xorp/xrl/interfaces/test_peer_xif.hh,v 1.20 2008/01/04 03:18:02 pavlin Exp $
 */

#ifndef __XRL_INTERFACES_TEST_PEER_XIF_HH__
#define __XRL_INTERFACES_TEST_PEER_XIF_HH__

#undef XORP_LIBRARY_NAME
#define XORP_LIBRARY_NAME "XifTestPeer"

#include "libxorp/xlog.h"
#include "libxorp/callback.hh"

#include "libxipc/xrl.hh"
#include "libxipc/xrl_error.hh"
#include "libxipc/xrl_sender.hh"


class XrlTestPeerV0p1Client {
public:
    XrlTestPeerV0p1Client(XrlSender* s) : _sender(s) {}
    virtual ~XrlTestPeerV0p1Client() {}

    typedef XorpCallback1<void, const XrlError&>::RefPtr RegisterCB;
    /**
     *  Send Xrl intended to:
     *
     *  Register for receiving packets and events. The registering process must
     *  implement the "datain" interface in order to receive data.
     *
     *  @param dst_xrl_target_name the Xrl target name of the destination.
     *
     *  @param genid Generation id.
     */
    bool send_register(
	const char*	dst_xrl_target_name,
	const string&	coordinator,
	const uint32_t&	genid,
	const RegisterCB&	cb
    );

    typedef XorpCallback1<void, const XrlError&>::RefPtr PacketisationCB;
    /**
     *  Send Xrl intended to:
     *
     *  Packetisation style.
     *
     *  @param dst_xrl_target_name the Xrl target name of the destination.
     */
    bool send_packetisation(
	const char*	dst_xrl_target_name,
	const string&	protocol,
	const PacketisationCB&	cb
    );

    typedef XorpCallback1<void, const XrlError&>::RefPtr Use4ByteAsnumsCB;
    /**
     *  Send Xrl intended to:
     *
     *  Set whether to assume 2 or 4 byte AS numbers when decoding.
     *
     *  @param dst_xrl_target_name the Xrl target name of the destination.
     */
    bool send_use_4byte_asnums(
	const char*	dst_xrl_target_name,
	const bool&	use,
	const Use4ByteAsnumsCB&	cb
    );

    typedef XorpCallback1<void, const XrlError&>::RefPtr ConnectCB;
    /**
     *  Send Xrl intended to:
     *
     *  Make a tcp connection to the specified host and port.
     *
     *  @param dst_xrl_target_name the Xrl target name of the destination.
     *
     *  @param host name.
     *
     *  @param port number.
     */
    bool send_connect(
	const char*	dst_xrl_target_name,
	const string&	host,
	const uint32_t&	port,
	const ConnectCB&	cb
    );

    typedef XorpCallback1<void, const XrlError&>::RefPtr ListenCB;
    /**
     *  Send Xrl intended to:
     *
     *  Listen for connections on this address and port.
     *
     *  @param dst_xrl_target_name the Xrl target name of the destination.
     *
     *  @param address local address.
     *
     *  @param port local port number.
     */
    bool send_listen(
	const char*	dst_xrl_target_name,
	const string&	address,
	const uint32_t&	port,
	const ListenCB&	cb
    );

    typedef XorpCallback1<void, const XrlError&>::RefPtr BindCB;
    /**
     *  Send Xrl intended to:
     *
     *  Bind the port but don't perform the listen or accept.
     *
     *  @param dst_xrl_target_name the Xrl target name of the destination.
     *
     *  @param address local address.
     *
     *  @param port local port number.
     */
    bool send_bind(
	const char*	dst_xrl_target_name,
	const string&	address,
	const uint32_t&	port,
	const BindCB&	cb
    );

    typedef XorpCallback1<void, const XrlError&>::RefPtr SendCB;
    /**
     *  Send Xrl intended to:
     *
     *  Send data Send data to the peer.
     *
     *  @param dst_xrl_target_name the Xrl target name of the destination.
     */
    bool send_send(
	const char*	dst_xrl_target_name,
	const vector<uint8_t>&	data,
	const SendCB&	cb
    );

    typedef XorpCallback1<void, const XrlError&>::RefPtr DisconnectCB;
    /**
     *  Send Xrl intended to:
     *
     *  Disconnect from the peer.
     *
     *  @param dst_xrl_target_name the Xrl target name of the destination.
     */
    bool send_disconnect(
	const char*	dst_xrl_target_name,
	const DisconnectCB&	cb
    );

    typedef XorpCallback1<void, const XrlError&>::RefPtr ResetCB;
    /**
     *  Send Xrl intended to:
     *
     *  Reset the peer. Take it back to a known state.
     *
     *  @param dst_xrl_target_name the Xrl target name of the destination.
     */
    bool send_reset(
	const char*	dst_xrl_target_name,
	const ResetCB&	cb
    );

    typedef XorpCallback1<void, const XrlError&>::RefPtr TerminateCB;
    /**
     *  Send Xrl intended to:
     *
     *  Terminate the test peer process.
     *
     *  @param dst_xrl_target_name the Xrl target name of the destination.
     */
    bool send_terminate(
	const char*	dst_xrl_target_name,
	const TerminateCB&	cb
    );

protected:
    XrlSender* _sender;

private:
    void unmarshall_register(
	const XrlError&	e,
	XrlArgs*	a,
	RegisterCB		cb
    );

    void unmarshall_packetisation(
	const XrlError&	e,
	XrlArgs*	a,
	PacketisationCB		cb
    );

    void unmarshall_use_4byte_asnums(
	const XrlError&	e,
	XrlArgs*	a,
	Use4ByteAsnumsCB		cb
    );

    void unmarshall_connect(
	const XrlError&	e,
	XrlArgs*	a,
	ConnectCB		cb
    );

    void unmarshall_listen(
	const XrlError&	e,
	XrlArgs*	a,
	ListenCB		cb
    );

    void unmarshall_bind(
	const XrlError&	e,
	XrlArgs*	a,
	BindCB		cb
    );

    void unmarshall_send(
	const XrlError&	e,
	XrlArgs*	a,
	SendCB		cb
    );

    void unmarshall_disconnect(
	const XrlError&	e,
	XrlArgs*	a,
	DisconnectCB		cb
    );

    void unmarshall_reset(
	const XrlError&	e,
	XrlArgs*	a,
	ResetCB		cb
    );

    void unmarshall_terminate(
	const XrlError&	e,
	XrlArgs*	a,
	TerminateCB		cb
    );

};

#endif /* __XRL_INTERFACES_TEST_PEER_XIF_HH__ */
