/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import net.sf.saxon.expr.ItemMappingFunction;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.trans.XPathException;

public final class ItemMappingIterator
implements SequenceIterator {
    private SequenceIterator base;
    private ItemMappingFunction action;
    private Item current = null;
    private int position = 0;

    public ItemMappingIterator(SequenceIterator sequenceIterator, ItemMappingFunction itemMappingFunction) {
        this.base = sequenceIterator;
        this.action = itemMappingFunction;
    }

    public Item next() throws XPathException {
        do {
            Item item;
            if ((item = this.base.next()) == null) {
                this.current = null;
                this.position = -1;
                return null;
            }
            this.current = this.action.map(item);
        } while (this.current == null);
        ++this.position;
        return this.current;
    }

    public Item current() {
        return this.current;
    }

    public int position() {
        return this.position;
    }

    public SequenceIterator getAnother() throws XPathException {
        return new ItemMappingIterator(this.base.getAnother(), this.action);
    }

    public int getProperties() {
        return 0;
    }
}

