/*
  Copyright (C) 2000-2007

  Code contributed by Greg Collecutt, Joseph Hope and the xmds-devel team

  This file is part of xmds.

  This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU General Public License
  as published by the Free Software Foundation; either version 2
  of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/

/*
  $Id: xmds_vector.h 1637 2007-12-31 04:00:26Z joehope $
*/

/*! @file xmds_vector.h
  @brief 

  More detailed explanation...
*/

#ifndef XMDS_VECTOR_H
#define XMDS_VECTOR_H

#include <xmds_field.h>

// *****************************************************************************
// *****************************************************************************
//                              xmdsVector
// *****************************************************************************
// *****************************************************************************

//! xmds vector class
class xmdsVector {

  public :

    //! Constructor for xmdsVector object
    xmdsVector(
         const xmdsField *const yourField);

  //! Destructor
  virtual ~xmdsVector();

  //! Writes relevant \#defines out to file
  void writeDefines(
                    FILE *const outfile) const;

  //! Writes relevant global variable declarations to file
  void writeGlobals(
                    FILE *const outfile) const;

  //! Writes function prototypes to file
  void writePrototypes(
                       FILE *const outfile) const;

  //! Writes the function routines to file
  void writeRoutines(
                     FILE *const outfile) const;

  //! Writes the initialisation call
  void writeInitialisationCall(
                               FILE *const outfile,
                               const char *const indent) const;

  //! I think this grabs the xmds simulation name
  const XMLString* name() const;

  //! Sets the name of something, possibly the xmds simulation name
  void setName(
               const XMLString& yourName);

  //! Returns the vector type of an xmds vector
  xmdsVectorType vectorType() const;

  //! Sets the vector type (duh!)
  void setVectorType(
                     const xmdsVectorType& yourType);

  //! Obtains the number of components (possibly in the xmds simulation)
  unsigned long nComponents() const;

  //! Obtains the name of the component
  const XMLString* componentName(
                                 const unsigned long& index) const;

  //! Obtains the length of the component
  const long componentLength(
                                 const unsigned long& index) const;

  //! Gets the component
  bool getComponent(
                    const XMLString& ofName,
                    unsigned long& index) const;

  //! Sets a component
  void setComponents(
                     const list<XMLString>& yourComponentsNamesList);

  //! Sets a component
  void setLengths(
                     const list<long>& yourComponentsLengthsList);

  //! Determines if the FFTW routines are needed
  bool needsFFTWRoutines() const;

  //! Sets whether the FFTW routines are needed
  void setNeedsFFTWRoutines() const;

  //! Determines the initial space for the xmds vector (x-space or k-space)
  unsigned long initialSpace() const;

  //! Sets the initial space to x-space or k-space
  void setInitialSpace(
                       const unsigned long& yourInitialSpace);

 protected:

  //! Writes the initialise routine
  virtual void writeInitialiseRoutine(
                                      FILE *const outfile) const;

  //! Obtains an instance of the xmdsField object
  const xmdsField* field() const;

  //! Returns true if the space at index is the initial space (I think...)
  bool space(
             const long unsigned int& index) const;
  private :

    const xmdsField *const  myField;                 //!< The field object
  XMLString               myName;                  //!< The name of the field
  xmdsVectorType          myType;                  //!< The data type of the field (double or complex)
  unsigned long           myInitialSpace;          //!< The initial space of the simulation (x-space or k-space)
  list<XMLString>         myComponentsNamesList;   //!< The list of the names of the components
  list<long>			  myComponentsLengthsList; //!< The list of the lengths of the components
  mutable bool            myNeedsFFTWRoutines;     //!< Whether or not the fftw routines are needed

};

#endif  // XMDS_VECTOR_H
