/*
  Copyright (C) 2000-2007

  Code contributed by Greg Collecutt, Joseph Hope and Paul Cochrane

  This file is part of xmds.

  This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU General Public License
  as published by the Free Software Foundation; either version 2
  of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/

/*
  $Id: xmds_globals.cc 1635 2007-12-30 17:34:42Z paultcochrane $
*/

/*! @file xmds_globals.cc
  @brief Globals element parsing classes and methods

  More detailed explanation...
*/

#include <xmds_common.h>
#include <xmds_globals.h>

// **************************************************************************
// **************************************************************************
//                              xmdsGlobals public
// **************************************************************************
// **************************************************************************

extern bool debugFlag;

long nxmdsGlobals = 0;   //!< Number of xmds global objects

// **************************************************************************
xmdsGlobals::xmdsGlobals(
                         const xmdsSimulation *const yourSimulation,
                         const bool& yourVerboseMode) :
  xmdsElement(yourSimulation, yourVerboseMode) {
  if (debugFlag) {
    nxmdsGlobals++;
    printf("xmdsGlobals::xmdsGlobals\n");
    printf("nxmdsGlobals=%li\n", nxmdsGlobals);
  }
}

// **************************************************************************
xmdsGlobals::~xmdsGlobals() {
  if (debugFlag) {
    nxmdsGlobals--;
    printf("xmdsGlobals::~xmdsGlobals\n");
    printf("nxmdsGlobals=%li\n", nxmdsGlobals);
  }
}

// **************************************************************************
void xmdsGlobals::processElement(
                                 const Element *const yourElement) {
  if (debugFlag) {
    printf("xmdsGlobals::processXMLElement\n");
  }

  if (verbose()) {
    printf("Processing constants element ...\n");
  }
  myGlobalsCode = *yourElement->textContent(0);

  if (verbose()) {
    if (myGlobalsCode.isAllWhiteSpace()) {
      printf("No globals found\n");
    }
    else {
      printf("Globals code loaded\n");
    }
  }

}

// **************************************************************************
// **************************************************************************
//                              xmdsGlobals private
// **************************************************************************
// **************************************************************************

// **************************************************************************
void xmdsGlobals::writeGlobals(FILE *const outfile) const
{
  if (debugFlag) {
    printf("xmdsGlobals::writeGlobals\n");
  }

  fprintf(outfile,
      "\n// ********** Code from globals element *********\n"
      "%s\n"
      "// **********************************************\n"
      "\n",
      myGlobalsCode.c_str());

}

/*
 * Local variables:
 * c-indentation-style: bsd
 * c-basic-offset: 2
 * indent-tabs-mode: nil
 * End:
 *
 * vim: tabstop=2 expandtab shiftwidth=2:
 */
