/*

   xlog - GTK+ logging program for amateur radio operators
   Copyright (C) 2001 - 2008 Joop Stakenborg <pg4i@amsat.org>

   This file is part of xlog.

   Xlog is free software: you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation, either version 3 of the License, or
   (at your option) any later version.

   Xlog is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with xlog.  If not, see <http://www.gnu.org/licenses/>.

*/

/*
 * xlog_enum.h
 */

enum /* we have 29 amateur radio bands */
{
	BAND_2190,  /* 0.136 - 0.137 MHz experimental */
	BAND_160,
	BAND_80,
	BAND_60,    /* 5.2 - 5.5 MHz, some countries */
	BAND_40,
	BAND_30,
	BAND_20,
	BAND_17,
	BAND_15,
	BAND_12,
	BAND_10,
	BAND_6,
	BAND_4,
	BAND_2,
	BAND_125CM, /* 220 - 225 MHz, region 2 */
	BAND_70CM,
	BAND_33CM,  /* 902 - 928 MHz, region 2 */
	BAND_23CM,
	BAND_13CM,
	BAND_9CM,
	BAND_6CM,
	BAND_3CM,
	BAND_12HMM,
	BAND_6MM,
	BAND_4MM,
	BAND_2HMM,
	BAND_2MM,
	BAND_1MM,
	BAND_SUBMM,
	MAX_BANDS   /* number of bands in the enumeration */
};

enum /* modes taken from ADIF specs */
{
	MODE_SSB,
	MODE_CW,
	MODE_FM,
	MODE_AM,
	MODE_ASCI,
	MODE_ATV,
	MODE_CLO,
	MODE_FAX,
	MODE_GTOR,
	MODE_HELL,
	MODE_HFSK,
	MODE_JT44,
	MODE_JT6M,
	MODE_MFSK8,
	MODE_MFSK16,
	MODE_MTTY,
	MODE_MT63,
	MODE_OLIVIA,
	MODE_PAC,
	MODE_PAC2,
	MODE_PAC3,
	MODE_PCW,
	MODE_PKT,
	MODE_PSK31,
	MODE_PSK63,
	MODE_PSK125,
	MODE_Q15,
	MODE_RTTY,
	MODE_SSTV,
	MODE_THRB,
	MODE_TOR,
	MAX_MODES
};

gchar *band_enum2char (guint band_enum);
gchar *band_enum2cabrillochar (guint band_enum);
gint freq2enum (gchar * str);
gint hamlibfreq2enum (long long f);
gchar *band_enum2bandchar (guint band_enum);
gint meters2enum (gchar * str);
gchar *mode_enum2char (guint mode_enum);
gint reportlen(guint mode_enum);
gint mode2enum (gchar * str);
