/*
 * dyna.h -- ưŪ礭ʤХåե
 * Copyright (C) 1991-1993 by candy
 * Thu Oct 31 10:13:53 JST 1996
 *   DYNA_IZ() פ
 * Sat May  3 00:27:48 JST 1997
 *   BOGUS_REALLOC
 */
/*
 * $Id: dyna.h,v 3.6 1996/11/28 09:01:21 candy Exp $
 */
#ifndef __DYNA_H /* [ */
#define __DYNA_H

#ifdef BOGUS_REALLOC
#undef realloc
#define realloc(p,s) ((p)?((realloc)(p,s)):malloc(s))
#endif

/*
 * NAME
 * 	STRUCT_DYNA - ¤Τ(ΰ)
 *
 * SYNOPSIS
 * 	struct DYNA STRUCT_DYNA(TYPE);
 *
 * DESCRIPTION
 * 	TYPE ǤȤưŪ礭ʤ򰷤¤
 * 		struct DYNA
 * 	ޤ
 *
 * EXAPMLE
 * 	struct CHAR_BUF STRUCT_DYNA(char);  ʸХåե
 * 	struct LIST_BUF STRUCT_DYNA(char *);  ʸΥꥹ
 * 	Τ褦ޤ
 * 	TYPE ν񼰤ˤ¤äơ
 * 		TYPE * identifier;
 * 	ˤơidentifier  TYPE ؤΥݥ󥿤Ȥʤ褦ʤΤ񤱤ޤ
 * 	㤨
 * 		STRUCT_DYNA(char **) Ϥ
 * 		STRUCT_DYNA(int (*)()) ϤǤ
 */
#define STRUCT_DYNA(TYPE) \
	{ \
	unsigned int more, size, used; \
	TYPE *buf; \
	TYPE *spare; \
	}

/*
 * NAME
 * 	DYNA_IZ - ¤Τν
 *
 * SYNOPSIS
 * 	void DYNA_IZ(struct DYNA *dyna, unsigned int nmore);
 *
 * DESCRIPTION
 * 	¤Τޤ
 * 	dyna ˤ STRUCT_DYNA ¤ΤΥɥ쥹Ϳޤ
 * 	nmore ˤϰ٤äǤοꤷޤ
 *
 * EXAMPLE
 * 	struct LIST_BUF STRUCT_DYNA(char *) list_buf;
 * 	λ
 * 	DYNA_IZ(&list_buf, 64);
 * 	Τ褦˽ޤ
 */
#define DYNA_IZ(dyna, nmore) ((void)( \
	(dyna)->more = (nmore), \
	(dyna)->used = (dyna)->size = 0, \
	(dyna)->buf = (void *)0 \
	))

/*
 * NAME
 * 	DYNA_BRK - γ
 *
 * SYNOPSIS
 * 	TYPE *DYNA_BRK(struct DYNA *dyna, unsigned int nmore);
 *
 * DESCRIPTION
 * 	¤Τ nmore Ĥ礷ޤ
 * 	DYNA_NEXT() ưŪ˼¹ԤΤ̤ϴطޤ
 * 	ʤ NULL ʳ֤Ԥʤ NULL ֤ޤ
 *
 * EXAMPLE
 * 	struct LIST_BUF STRUCT_DYNA(char *) list_buf;
 * 	DYNA_IZ(&list_buf, 64);
 * 	λ
 * 	if (DYNA_BRK(&list_buf, 16) == NULL)
 * 		goto no_memory;
 * 	ʤɤȤޤ
 */
#define DYNA_BRK(dyna, nmore) ( \
	(dyna)->spare = (dyna)->buf, \
	(dyna)->size += (nmore), \
	(dyna)->buf = realloc((dyna)->buf, (dyna)->size * sizeof((dyna)->buf[0])), \
	(((dyna)->buf != (void *)0) ? (dyna)->buf \
	: ((dyna)->buf = (dyna)->spare, \
		(dyna)->size -= (nmore), \
		(void *)0)) \
	)

/*
 * NAME
 * 	DYNA_NEXT - Хåեγ
 *
 * SYNOPSIS
 * 	TYPE *DYNA_NEXT(struct DYNA *dyna);
 *
 * DESCRIPTION
 * 	οǤΥɥ쥹֤ޤ
 * 	ΰ褬 1 ޤ
 * 	­ʤ DYNA_BRK() ƤӽФޤ
 * 	Ԥʤ NULL ֤ޤ
 *
 * EXAMPLE
 * 	struct LIST_BUF STRUCT_DYNA(char *)list_buf;
 * 	char **next;
 * 	DYNA_IZ(&list_buf, 64);
 * 	λ
 * 	if ((next = DYNA_NEXT(&list_buf)) == NULL)
 * 		goto no_memory;
 * *next = malloc(256);
 * 	ʤɤȤޤ
 */
#define DYNA_NEXT(dyna) ( \
	((dyna)->used >= (dyna)->size && DYNA_BRK(dyna, \
		((dyna)->more ? (dyna)->more : 256)) == (void *)0) \
	? (void *)0 \
	: (dyna)->buf + (dyna)->used++ \
	)

/*
 * NAME
 * 	DYNA_ALLOC - Хåեγ
 *
 * SYNOPSIS
 * 	TYPE *DYNA_ALLOC(struct DYNA *dyna, unsigned int n);
 *
 * DESCRIPTION
 * 	ο n ĤϢ³ǤΥɥ쥹֤ޤ
 * 	ΰ褬 n ޤ
 * 	­ʤ DYNA_BRK() ƤӽФޤ
 * 	Ԥʤ NULL ֤ޤ
 *
 * EXAMPLE
 * 	struct CHAR_BUF STRUCT_DYNA(char) char_buf;
 * 	char *next;
 * 	DYNA_IZ(&char_buf, 256);
 * 	λ
 * 	if ((next = DYNA_ALLOC(&char_buf, strlen(s) + 1)) == NULL)
 * 		goto no_memory;
 * 	strcpy(next, s);
 * ʤɤȤޤ
 */
#define DYNA_ALLOC(dyna, nmore) ( \
	((dyna)->used + (nmore) > (dyna)->size && DYNA_BRK(dyna, (dyna)->more + (nmore)) == (void *)0) \
	? ((void *)0)\
	: ((dyna)->used += (nmore), (dyna)->buf + (dyna)->used - (nmore))\
	)

/*
 * NAME
 * 	DYNA_RESET - Хåեˤ
 *
 * SYNOPSIS
 * 	void DYNA_RESET(struct DYNA *dyna)
 *
 * DESCRIPTION
 * 	Хåեˤޤ(ΰ 0 ˤޤ)
 * 	dyna ˤ STRUCT_DYNA ¤ΤΥɥ쥹Ϳޤ
 */
#define DYNA_RESET(dyna) ((void)((dyna)->used = 0))

/*
 * NAME
 * 	DYNA_UNGROW - Хåեν̾
 *
 * SYNOPSIS
 * 	void DYNA_UNGROW(struct DYNA *dyna, unsigned int n);
 *
 * DESCRIPTION
 * 	Хåե礭(ΰ) 0 ǤʤСn ʬ̾ޤ
 *
 */
#define DYNA_UNGROW(dyna, n) ((void)((dyna)->used > (n) ? ((dyna)->used -= (n)) : ((dyna)->used = 0)))

/*
 * NAME
 * 	DYNA_BUF - ХåեΥɥ쥹
 *
 * SYNOPSIS
 * 	TYPE *DYNA_BUF(struct DYNA *dyna);
 *
 * DESCRIPTION
 * 	ХåեκǽǤΥɥ쥹֤ޤ
 * 	DYNA_BRK()  DYNA_NEXT() ˤäͤѲޤΤǡ
 * 	ƤӽФϰ̵ͤˤʤޤ
 */
#define DYNA_BUF(dyna) ((dyna)->buf)

/*
 * NAME
 * 	DYNA_USED - Хåե礭
 *
 * SYNOPSIS
 * 	unsigned int DYNA_USED(struct DYNA *dyna);
 *
 * DESCRIPTION
 * 	Хåե礭֤ޤ
 * 	DYNA_IZ() ľ 0 ǡ
 * 	DYNA_NEXT()  + 1 ޤ
 */
#define DYNA_USED(dyna) ((dyna)->used)

#endif /* ] !__DYNA_H */
