/*
 *  xfce4-volstatus-icon
 *
 *  Copyright (c) 2006 Brian Tarricone <bjt23@cornell.edu>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; version 2 of the License ONLY.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef __XFCE_VOLSTATUS_ICON_H__
#define __XFCE_VOLSTATUS_ICON_H__

#include <ghal/ghal.h>

#include <gtk/gtk.h>

#define XFCE_TYPE_VOLSTATUS_ICON     (xfce_volstatus_icon_get_type())
#define XFCE_VOLSTATUS_ICON(obj)     (G_TYPE_CHECK_INSTANCE_CAST((obj), XFCE_TYPE_VOLSTATUS_ICON, XfceVolstatusIcon))
#define XFCE_IS_VOLSTATUS_ICON(obj)  (G_TYPE_CHECK_INSTANCE_TYPE((obj), XFCE_TYPE_VOLSTATUS_ICON))

G_BEGIN_DECLS

typedef struct _XfceVolstatusIcon XfceVolstatusIcon;

GType xfce_volstatus_icon_get_type() G_GNUC_CONST;

GtkStatusIcon *xfce_volstatus_icon_new(GdkScreen *screen);

/* call when a removable/hotpluggable device is plugged in */
void xfce_volstatus_icon_add_drive(XfceVolstatusIcon *icon,
                                   GHalDrive *drive);
/* call when a removable/hotpluggable device is unplugged */
void xfce_volstatus_icon_remove_drive(XfceVolstatusIcon *icon,
                                      GHalDrive *drive);

GList *xfce_volstatus_icon_list_drives(XfceVolstatusIcon *icon);

G_END_DECLS

#endif  /* __XFCE_VOLSTATUS_ICON_H__ */
