/*
 * xfce4-hdaps, an XFCE4 panel plugin for the HDAPS system.
 *
 * Copyright Michael Orlitzky
 *
 * http://michael.orlitzky.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * http://www.fsf.org/licensing/licenses/gpl.html
 */

#ifndef __XFCE4_HDAPS_H__
#define __XFCE4_HDAPS_H__

#include <gtk/gtk.h>
#include <libxfce4panel/xfce-panel-plugin.h>
#include <libxfce4panel/xfce-hvbox.h>
#include <libxfce4util/libxfce4util.h>
#include "hdaps.h"

G_BEGIN_DECLS

typedef struct {
  XfcePanelPlugin *plugin;
  
  /* Panel widgets */
  GtkWidget   *eventbox;
  GtkWidget   *hvbox;
  GtkWidget   *icon;
  GtkTooltips *tooltip;
  
  /* A pointer to the timeout function.
     That is, a pointer to the function that gets
     executed every poll_frequency milliseconds. */
  gint timeout;

  /* Keep track of the previous status so we don't update the
     icon every poll_frequency for no reason. */
  int previous_status;
  
  /* Settings */
  gchar *device_name;
  gint  poll_frequency;
  
  /* Pseudo-setting, updated whenever device_name is. */
  char sysfs_file[FILENAME_MAX];
  
  /* Configuration dialog widgets */  
  GtkWidget *sb_poll_frequency; /* Spinners on all our rides, yo. */
  GtkWidget *cb_device_name;    /* The "Device name" combo box. */
  
  
} HdapsPlugin;

void hdaps_save(XfcePanelPlugin *plugin,
		HdapsPlugin     *hdaps);

G_END_DECLS

#endif
