#define barrier()               asm volatile("": : :"memory")

typedef struct {
	volatile unsigned int slock;
} spinlock_t;

#define SPIN_LOCK_UNLOCKED      (spinlock_t) { .slock = 1 }
#define spin_lock_init(x)	do { (x)->slock = 1; } while(0)

#define spin_is_locked(x)	(*(volatile signed char *)(&(x)->slock) <= 0)
#define spin_unlock_wait(x)	do { barrier(); } while(spin_is_locked(x))

#define spin_lock_string \
	"\n1:\t" \
	"lock ; decb %0\n\t" \
	"jns 3f\n" \
	"2:\t" \
	"pause\n\t" \
	"cmpb $0,%0\n\t" \
	"jle 2b\n\t" \
	"jmp 1b\n" \
	"3:\n\t"

#define spin_unlock_string \
	"xchgb %b0, %1" \
		:"=q" (oldval), "=m" (lock->slock) \
		:"0" (oldval) : "memory"

static inline void spin_lock(spinlock_t *lock)
{
	asm volatile(
		spin_lock_string
		:"=m" (lock->slock) : : "memory");
}

static inline void spin_unlock(spinlock_t *lock)
{
	char oldval = 1;

	asm volatile(
		spin_unlock_string
	);
}
