/*-----------------------------------------------------------------------------

	ST-Sound ( YM files player library )

	Copyright (C) 1995-1999 Arnaud Carre ( http://leonard.oxg.free.fr )

	Sample datas of some common YM music. ( YM2 format )
	YM3 or greater uses sample data inside the music file.
	
-----------------------------------------------------------------------------*/

/*-----------------------------------------------------------------------------

	This file is part of ST-Sound

	ST-Sound is free software; you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation; either version 2 of the License, or
	(at your option) any later version.

	ST-Sound is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with ST-Sound; if not, write to the Free Software
	Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

-----------------------------------------------------------------------------*/

#include "YmTypes.h"

static ymu8	sample00[631]={
		0xCC,0x84,0xB4,0x70,0x90,0x94,0x70,0x80,0x80,0xAC,
		0x58,0xFF,0x00,0x80,0x54,0x40,0x6C,0x78,0x94,0x7C,
		0x8C,0x58,0x84,0x08,0x4C,0x54,0x78,0xA8,0xDC,0xDC,
		0xFF,0xFF,0xF0,0xA4,0x70,0x44,0x3C,0x2C,0x14,0x00,
		0x00,0x00,0x00,0x1C,0x90,0xE4,0xFF,0xFF,0xFF,0xFF,
		0xFF,0xFF,0xF4,0xB4,0x8C,0x44,0x08,0x00,0x00,0x00,
		0x00,0x00,0x00,0x00,0x00,0x28,0x70,0xDC,0xFF,0xFF,
		0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xC0,0x78,0x38,0x00,
		0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
		0x00,0x38,0x84,0xEC,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
		0xFF,0xFF,0xFF,0xFF,0xFF,0xC0,0x84,0x50,0x18,0x00,
		0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
		0x00,0x00,0x04,0x50,0x98,0xDC,0xFF,0xFF,0xFF,0xFF,
		0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
		0xD8,0x8C,0x44,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
		0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x28,0x58,
		0xA0,0xDC,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
		0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xDC,0xC0,0x88,
		0x58,0x1C,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
		0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x18,0x40,
		0x64,0x80,0xA8,0xD0,0xF8,0xFF,0xFF,0xFF,0xFF,0xFF,
		0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
		0xFF,0xE4,0xBC,0x8C,0x68,0x48,0x20,0x00,0x00,0x00,
		0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
		0x00,0x00,0x00,0x04,0x2C,0x60,0x78,0xA0,0xC4,0xF0,
		0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
		0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xEC,0xC4,0x98,0x64,
		0x30,0x04,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
		0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x0C,0x2C,0x50,
		0x74,0x8C,0xB0,0xCC,0xE8,0xFC,0xFF,0xFF,0xFF,0xFF,
		0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xF8,
		0xF0,0xDC,0xC8,0xBC,0xB0,0x90,0x80,0x70,0x5C,0x58,
		0x48,0x38,0x38,0x28,0x24,0x1C,0x24,0x24,0x20,0x28,
		0x38,0x48,0x58,0x50,0x50,0x5C,0x60,0x5C,0x5C,0x5C,
		0x5C,0x60,0x5C,0x60,0x60,0x5C,0x54,0x5C,0x58,0x64,
		0x68,0x64,0x64,0x6C,0x74,0x7C,0x78,0x80,0x88,0x90,
		0x98,0x9C,0xA8,0xB8,0xB8,0xC0,0xC8,0xD0,0xD8,0xE0,
		0xE0,0xE4,0xDC,0xD4,0xD8,0xDC,0xD0,0xCC,0xC0,0xC4,
		0xBC,0xB0,0xA8,0x9C,0x98,0x94,0x90,0x7C,0x74,0x6C,
		0x64,0x4C,0x40,0x30,0x20,0x18,0x08,0x00,0x00,0x00,
		0x00,0x00,0x00,0x00,0x00,0x00,0x04,0x0C,0x14,0x28,
		0x34,0x44,0x50,0x64,0x74,0x84,0x98,0x98,0xAC,0xC0,
		0xD0,0xD8,0xEC,0xF0,0xFC,0xFF,0xFF,0xFF,0xFF,0xFF,
		0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xF0,0xD8,
		0xD4,0xC8,0xBC,0x9C,0x8C,0x6C,0x74,0x50,0x40,0x34,
		0x24,0x18,0x08,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
		0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x08,0x10,0x24,
		0x38,0x4C,0x58,0x6C,0x80,0x90,0xA4,0xAC,0xBC,0xC8,
		0xD8,0xE4,0xE4,0xEC,0xF0,0xF4,0xFC,0xFC,0xFC,0xF8,
		0xFC,0xFC,0xF8,0xF8,0xF0,0xF0,0xEC,0xEC,0xE4,0xE0,
		0xD8,0xD0,0xC4,0xBC,0xB0,0xA0,0x94,0x88,0x78,0x68,
		0x58,0x44,0x38,0x30,0x24,0x20,0x14,0x0C,0x08,0x00,
		0x00,0x00,0x04,0x0C,0x14,0x18,0x18,0x20,0x24,0x34,
		0x38,0x40,0x48,0x50,0x5C,0x60,0x6C,0x70,0x74,0x80,
		0x8C,0x90,0x98,0x9C,0xAC,0xB0,0xB8,0xC4,0xC0,0xBC,
		0xC0,0xC8,0xD0,0xCC,0xC8,0xC4,0xC0,0xC0,0xC0,0xB4,
		0xB4,0xAC,0xB0,0xA8,0xA4,0xA4,0x9C,0x98,0x94,0x94,
		0x94,0x94,0x94,0x8C,0x80,0x80,0x74,0x74,0x70,0x64,
		0x58,0x50,0x4C,0x4C,0x44,0x40,0x48,0x48,0x4C,0x4C,
		0x4C,0x58,0x60,0x68,0x6C,0x6C,0x74,0x7C,0x7C,0x84,
		0x84,0x88,0x8C,0x8C,0x88,0x88,0x84,0x84,0x84,0x7C,
		0x78,0x70,0x6C,0x68,0x64,0x64,0x64,0x60,0x68,0x6C,
		0x6C,0x70,0x7C,0x84,0x80,0x80,0x80,0x80,0x80,0x80,
		0x80,};
static ymu8	sample01[631]={
		0x97,0x81,0x90,0x7B,0x84,0x86,0x7B,0x80,0x80,0x8D,
		0x73,0xA7,0x58,0x80,0x72,0x6C,0x79,0x7D,0x86,0x7E,
		0x83,0x73,0x81,0x5A,0x6F,0x72,0x7D,0x8C,0x9C,0x9C,
		0xA7,0xA7,0xA2,0x8B,0x7B,0x6D,0x6A,0x65,0x5E,0x58,
		0x58,0x58,0x58,0x60,0x84,0x9F,0xA7,0xA7,0xA7,0xA7,
		0xA7,0xA7,0xA4,0x90,0x83,0x6D,0x5A,0x58,0x58,0x58,
		0x58,0x58,0x58,0x58,0x58,0x64,0x7B,0x9C,0xA7,0xA7,
		0xA7,0xA7,0xA7,0xA7,0xA7,0xA7,0x93,0x7D,0x69,0x58,
		0x58,0x58,0x58,0x58,0x58,0x58,0x58,0x58,0x58,0x58,
		0x58,0x69,0x81,0xA1,0xA7,0xA7,0xA7,0xA7,0xA7,0xA7,
		0xA7,0xA7,0xA7,0xA7,0xA7,0x93,0x81,0x71,0x5F,0x58,
		0x58,0x58,0x58,0x58,0x58,0x58,0x58,0x58,0x58,0x58,
		0x58,0x58,0x59,0x71,0x87,0x9C,0xA7,0xA7,0xA7,0xA7,
		0xA7,0xA7,0xA7,0xA7,0xA7,0xA7,0xA7,0xA7,0xA7,0xA7,
		0x9B,0x83,0x6D,0x58,0x58,0x58,0x58,0x58,0x58,0x58,
		0x58,0x58,0x58,0x58,0x58,0x58,0x58,0x58,0x64,0x73,
		0x89,0x9C,0xA7,0xA7,0xA7,0xA7,0xA7,0xA7,0xA7,0xA7,
		0xA7,0xA7,0xA7,0xA7,0xA7,0xA7,0xA7,0x9C,0x93,0x82,
		0x73,0x60,0x58,0x58,0x58,0x58,0x58,0x58,0x58,0x58,
		0x58,0x58,0x58,0x58,0x58,0x58,0x58,0x58,0x5F,0x6C,
		0x77,0x80,0x8C,0x98,0xA5,0xA7,0xA7,0xA7,0xA7,0xA7,
		0xA7,0xA7,0xA7,0xA7,0xA7,0xA7,0xA7,0xA7,0xA7,0xA7,
		0xA7,0x9F,0x92,0x83,0x78,0x6E,0x62,0x58,0x58,0x58,
		0x58,0x58,0x58,0x58,0x58,0x58,0x58,0x58,0x58,0x58,
		0x58,0x58,0x58,0x59,0x65,0x76,0x7D,0x89,0x95,0xA2,
		0xA7,0xA7,0xA7,0xA7,0xA7,0xA7,0xA7,0xA7,0xA7,0xA7,
		0xA7,0xA7,0xA7,0xA7,0xA7,0xA7,0xA1,0x95,0x87,0x77,
		0x67,0x59,0x58,0x58,0x58,0x58,0x58,0x58,0x58,0x58,
		0x58,0x58,0x58,0x58,0x58,0x58,0x58,0x5B,0x65,0x71,
		0x7C,0x83,0x8E,0x97,0xA0,0xA6,0xA7,0xA7,0xA7,0xA7,
		0xA7,0xA7,0xA7,0xA7,0xA7,0xA7,0xA7,0xA7,0xA7,0xA5,
		0xA2,0x9C,0x96,0x92,0x8E,0x84,0x80,0x7B,0x74,0x73,
		0x6E,0x69,0x69,0x64,0x63,0x60,0x63,0x63,0x62,0x64,
		0x69,0x6E,0x73,0x71,0x71,0x74,0x76,0x74,0x74,0x74,
		0x74,0x76,0x74,0x76,0x76,0x74,0x72,0x74,0x73,0x77,
		0x78,0x77,0x77,0x79,0x7C,0x7E,0x7D,0x80,0x82,0x84,
		0x87,0x88,0x8C,0x91,0x91,0x93,0x96,0x98,0x9B,0x9D,
		0x9D,0x9F,0x9C,0x9A,0x9B,0x9C,0x98,0x97,0x93,0x95,
		0x92,0x8E,0x8C,0x88,0x87,0x86,0x84,0x7E,0x7C,0x79,
		0x77,0x6F,0x6C,0x67,0x62,0x5F,0x5A,0x58,0x58,0x58,
		0x58,0x58,0x58,0x58,0x58,0x58,0x59,0x5B,0x5E,0x64,
		0x68,0x6D,0x71,0x77,0x7C,0x81,0x87,0x87,0x8D,0x93,
		0x98,0x9B,0xA1,0xA2,0xA6,0xA7,0xA7,0xA7,0xA7,0xA7,
		0xA7,0xA7,0xA7,0xA7,0xA7,0xA7,0xA7,0xA7,0xA2,0x9B,
		0x9A,0x96,0x92,0x88,0x83,0x79,0x7C,0x71,0x6C,0x68,
		0x63,0x5F,0x5A,0x58,0x58,0x58,0x58,0x58,0x58,0x58,
		0x58,0x58,0x58,0x58,0x58,0x58,0x58,0x5A,0x5D,0x63,
		0x69,0x6F,0x73,0x79,0x80,0x84,0x8B,0x8D,0x92,0x96,
		0x9B,0x9F,0x9F,0xA1,0xA2,0xA4,0xA6,0xA6,0xA6,0xA5,
		0xA6,0xA6,0xA5,0xA5,0xA2,0xA2,0xA1,0xA1,0x9F,0x9D,
		0x9B,0x98,0x95,0x92,0x8E,0x89,0x86,0x82,0x7D,0x78,
		0x73,0x6D,0x69,0x67,0x63,0x62,0x5E,0x5B,0x5A,0x58,
		0x58,0x58,0x59,0x5B,0x5E,0x5F,0x5F,0x62,0x63,0x68,
		0x69,0x6C,0x6E,0x71,0x74,0x76,0x79,0x7B,0x7C,0x80,
		0x83,0x84,0x87,0x88,0x8D,0x8E,0x91,0x95,0x93,0x92,
		0x93,0x96,0x98,0x97,0x96,0x95,0x93,0x93,0x93,0x90,
		0x90,0x8D,0x8E,0x8C,0x8B,0x8B,0x88,0x87,0x86,0x86,
		0x86,0x86,0x86,0x83,0x80,0x80,0x7C,0x7C,0x7B,0x77,
		0x73,0x71,0x6F,0x6F,0x6D,0x6C,0x6E,0x6E,0x6F,0x6F,
		0x6F,0x73,0x76,0x78,0x79,0x79,0x7C,0x7E,0x7E,0x81,
		0x81,0x82,0x83,0x83,0x82,0x82,0x81,0x81,0x81,0x7E,
		0x7D,0x7B,0x79,0x78,0x77,0x77,0x77,0x76,0x78,0x79,
		0x79,0x7B,0x7E,0x81,0x80,0x80,0x80,0x80,0x80,0x80,
		0x80,};
static ymu8	sample02[490]={
		0x74,0xB4,0x96,0x64,0x3C,0x00,0x1E,0x70,0x00,0x40,
		0xF9,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xCA,0x4C,0x00,
		0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x0A,0xDB,0xFF,
		0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
		0xFF,0xE4,0x5A,0x16,0x24,0x02,0x00,0x00,0x00,0x00,
		0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x28,0xC4,
		0xEF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
		0xFF,0xFF,0xED,0xFF,0x4A,0x06,0x1A,0x00,0x00,0x00,
		0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
		0x1E,0x84,0xBA,0xBE,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
		0xFF,0xFF,0xFF,0xFF,0xFD,0xF9,0x6E,0x00,0x3A,0x0C,
		0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x96,
		0x8A,0x58,0x60,0xDD,0xB3,0x40,0xFF,0xF3,0x90,0xFD,
		0xEF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xE9,
		0x8A,0xEB,0xB9,0x44,0x04,0x00,0x00,0x00,0x00,0x00,
		0x00,0x00,0x00,0x08,0x50,0x14,0x36,0xFD,0xD3,0xD9,
		0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xAD,0xCF,
		0xF5,0x92,0xFD,0xC2,0x10,0xA6,0x24,0x06,0x14,0x00,
		0x00,0x00,0x00,0x00,0x1C,0x00,0x72,0x18,0x6A,0xF1,
		0x80,0xFF,0xFF,0xFF,0xFF,0xF9,0xFF,0xF3,0xAA,0x88,
		0xA8,0xAA,0x8C,0x1A,0xCA,0x50,0xB9,0x00,0xD9,0x5E,
		0xA2,0x24,0x30,0x80,0x30,0x2E,0x00,0x0C,0x5E,0x06,
		0x08,0x70,0x58,0x00,0x9E,0xFD,0xA8,0xFF,0xFF,0xF7,
		0xFF,0xF5,0xFF,0xF5,0xFB,0xD5,0x70,0xC8,0xB6,0xA2,
		0x36,0xC3,0x00,0x72,0x30,0x2E,0x00,0x3E,0x30,0x2E,
		0x1C,0x74,0x56,0x32,0x5C,0xD5,0x9C,0x74,0xD0,0xDB,
		0xB5,0xB9,0xCB,0x9E,0xE0,0xFF,0x90,0xCC,0x98,0xE9,
		0x72,0xB4,0xB8,0x60,0xAE,0x6C,0x0C,0x44,0x4A,0x3C,
		0x36,0x60,0x10,0x2C,0x88,0x02,0x88,0x60,0x92,0x94,
		0xE1,0x6E,0xC4,0xE7,0xF7,0xF3,0x7A,0xCB,0xD0,0xAA,
		0x6E,0xC4,0xCD,0xB6,0x6A,0x90,0x44,0x34,0x5A,0x20,
		0x58,0x10,0x40,0x22,0x10,0x38,0x4A,0x42,0x5A,0x74,
		0x42,0x92,0xC6,0xBE,0xE1,0xDF,0xE7,0xFF,0xF5,0xD5,
		0xB1,0xC8,0xCA,0xD5,0x6E,0x6A,0x8A,0x40,0x52,0x22,
		0x72,0x48,0x44,0x3E,0x92,0x82,0x66,0xD2,0x88,0xD2,
		0xAC,0xA0,0x84,0x8A,0x8C,0x94,0xA3,0x86,0xE3,0x90,
		0x7A,0xE1,0x8E,0xE7,0xAC,0x7C,0xAC,0xCD,0x86,0x7A,
		0xA4,0x80,0x9A,0x3A,0x76,0x86,0x4E,0x50,0x94,0x4C,
		0x32,0x9E,0x70,0xA0,0x72,0x74,0x56,0xAE,0xB8,0x80,
		0xCA,0x82,0xA4,0x7C,0xEA,0xAA,0x84,0x32,0xD5,0xA2,
		0x9A,0x50,0x4A,0x6A,0x28,0x9A,0x18,0x16,0x78,0x82,
		0x94,0x94,0x9C,0x92,0x8E,0x7E,0x72,0x5A,0x88,0x44,
		0x98,0xA8,0x64,0xA0,0x66,0xA6,0x84,0x7E,0x8C,0x92,
		0xBC,0x92,0xB6,0x92,0xAA,0x5A,0x70,0x7A,0x66,0x7E,
		0x4E,0x62,0xAE,0x6A,0x82,0x84,0x54,0x88,0x80,0x94,
		0x78,0xBE,0xAC,0xA2,0xE1,0x8E,0xDD,0xD6,0xA6,0xAA,
		0x60,0xA2,0x86,0x90,0x78,0x5C,0x94,0x72,0x54,0xB2,
		0x6A,0x74,0x60,0x90,0x78,0x5A,0x9A,0x70,0x8C,0xA2,
		0x64,0x4C,0xA8,0x80,0x80,0x80,0x80,0x80,0x80,0x80,};
static ymu8	sample03[490]={
		0x7C,0x90,0x86,0x77,0x6A,0x58,0x61,0x7B,0x58,0x6C,
		0xA5,0xA7,0xA7,0xA7,0xA7,0xA7,0xA7,0x97,0x6F,0x58,
		0x58,0x58,0x58,0x58,0x58,0x58,0x58,0x5B,0x9C,0xA7,
		0xA7,0xA7,0xA7,0xA7,0xA7,0xA7,0xA7,0xA7,0xA7,0xA7,
		0xA7,0x9F,0x74,0x5E,0x63,0x58,0x58,0x58,0x58,0x58,
		0x58,0x58,0x58,0x58,0x58,0x58,0x58,0x58,0x64,0x95,
		0xA2,0xA7,0xA7,0xA7,0xA7,0xA7,0xA7,0xA7,0xA7,0xA7,
		0xA7,0xA7,0xA2,0xA7,0x6F,0x59,0x60,0x58,0x58,0x58,
		0x58,0x58,0x58,0x58,0x58,0x58,0x58,0x58,0x58,0x58,
		0x61,0x81,0x92,0x93,0xA7,0xA7,0xA7,0xA7,0xA7,0xA7,
		0xA7,0xA7,0xA7,0xA7,0xA7,0xA5,0x7A,0x58,0x6A,0x5B,
		0x58,0x58,0x58,0x58,0x58,0x58,0x58,0x58,0x58,0x86,
		0x83,0x73,0x76,0x9D,0x8F,0x6C,0xA7,0xA3,0x84,0xA7,
		0xA2,0xA7,0xA7,0xA7,0xA7,0xA7,0xA7,0xA7,0xA7,0xA0,
		0x83,0xA1,0x91,0x6D,0x59,0x58,0x58,0x58,0x58,0x58,
		0x58,0x58,0x58,0x5A,0x71,0x5E,0x68,0xA7,0x99,0x9B,
		0xA7,0xA7,0xA7,0xA7,0xA7,0xA7,0xA7,0xA7,0x8E,0x98,
		0xA4,0x85,0xA7,0x94,0x5D,0x8B,0x63,0x59,0x5E,0x58,
		0x58,0x58,0x58,0x58,0x60,0x58,0x7B,0x5F,0x79,0xA3,
		0x80,0xA7,0xA7,0xA7,0xA7,0xA5,0xA7,0xA3,0x8D,0x82,
		0x8C,0x8D,0x83,0x60,0x97,0x71,0x91,0x58,0x9B,0x75,
		0x8A,0x63,0x67,0x80,0x67,0x66,0x58,0x5B,0x75,0x59,
		0x5A,0x7B,0x73,0x58,0x89,0xA7,0x8C,0xA7,0xA7,0xA5,
		0xA7,0xA4,0xA7,0xA4,0xA6,0x9A,0x7B,0x96,0x90,0x8A,
		0x68,0x94,0x58,0x7B,0x67,0x66,0x58,0x6B,0x67,0x66,
		0x60,0x7C,0x72,0x67,0x74,0x9A,0x88,0x7C,0x98,0x9C,
		0x90,0x91,0x97,0x89,0x9D,0xA7,0x84,0x97,0x87,0xA0,
		0x7B,0x90,0x91,0x76,0x8E,0x79,0x5B,0x6D,0x6F,0x6A,
		0x68,0x76,0x5D,0x65,0x82,0x58,0x82,0x76,0x85,0x86,
		0x9E,0x7A,0x95,0xA0,0xA5,0xA3,0x7E,0x97,0x98,0x8D,
		0x7A,0x95,0x98,0x90,0x79,0x84,0x6D,0x68,0x74,0x62,
		0x73,0x5D,0x6C,0x62,0x5D,0x69,0x6F,0x6C,0x74,0x7C,
		0x6C,0x85,0x95,0x93,0x9E,0x9D,0xA0,0xA7,0xA4,0x9A,
		0x8F,0x96,0x97,0x9A,0x7A,0x79,0x83,0x6C,0x71,0x62,
		0x7B,0x6E,0x6D,0x6B,0x85,0x80,0x77,0x99,0x82,0x99,
		0x8D,0x89,0x81,0x83,0x83,0x86,0x8A,0x81,0x9E,0x84,
		0x7E,0x9E,0x84,0xA0,0x8D,0x7E,0x8D,0x98,0x81,0x7E,
		0x8B,0x80,0x88,0x6A,0x7C,0x81,0x70,0x71,0x86,0x6F,
		0x67,0x89,0x7B,0x89,0x7B,0x7C,0x72,0x8E,0x91,0x80,
		0x97,0x80,0x8B,0x7E,0xA1,0x8D,0x81,0x67,0x9A,0x8A,
		0x88,0x71,0x6F,0x79,0x64,0x88,0x5F,0x5E,0x7D,0x80,
		0x86,0x86,0x88,0x85,0x84,0x80,0x7B,0x74,0x82,0x6D,
		0x87,0x8C,0x77,0x89,0x77,0x8B,0x81,0x80,0x83,0x85,
		0x92,0x85,0x90,0x85,0x8D,0x74,0x7B,0x7E,0x77,0x80,
		0x70,0x76,0x8E,0x79,0x80,0x81,0x72,0x82,0x80,0x86,
		0x7D,0x93,0x8D,0x8A,0x9E,0x84,0x9D,0x9A,0x8B,0x8D,
		0x76,0x8A,0x81,0x84,0x7D,0x74,0x86,0x7B,0x72,0x8F,
		0x79,0x7C,0x76,0x84,0x7D,0x74,0x88,0x7B,0x83,0x8A,
		0x77,0x6F,0x8C,0x80,0x80,0x80,0x80,0x80,0x80,0x80,};
static ymu8	sample04[699]={
		0x80,0x80,0x80,0x80,0x80,0x80,0x90,0x94,0x94,0xE0,
		0x28,0xC0,0x00,0x34,0xFF,0xA4,0xFF,0x78,0xE4,0xC0,
		0x98,0x70,0xFF,0x30,0x7C,0x28,0x58,0x00,0xFF,0x00,
		0xFF,0x00,0x00,0x5C,0x64,0x00,0x94,0x38,0x00,0x8C,
		0x00,0x00,0x00,0x50,0x48,0x4C,0xBC,0xC8,0xF8,0xFF,
		0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
		0xFF,0xFF,0xFF,0xFF,0x9C,0xF8,0x44,0x3C,0x00,0x00,
		0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
		0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x28,0x38,
		0x18,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
		0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
		0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
		0xB8,0x10,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
		0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
		0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
		0x00,0x00,0x00,0x00,0x68,0xFF,0xFF,0xFF,0xFF,0xFF,
		0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
		0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
		0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
		0xFF,0xFF,0xFF,0xCC,0x7C,0x38,0x00,0x00,0x00,0x00,
		0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
		0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
		0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
		0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x04,0x4C,
		0x88,0xE8,0xE4,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
		0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
		0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
		0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
		0xFF,0xFF,0xFF,0xFF,0xFF,0xE8,0xAC,0x48,0x24,0x00,
		0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
		0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
		0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
		0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x08,
		0x3C,0x7C,0x98,0xD4,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
		0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
		0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
		0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
		0xFF,0xEC,0xC8,0xB4,0x9C,0x68,0x60,0x40,0x34,0x2C,
		0x0C,0x18,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
		0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
		0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
		0x00,0x00,0x00,0x00,0x00,0x00,0x0C,0x08,0x1C,0x1C,
		0x20,0x50,0x58,0x64,0x7C,0x98,0x7C,0x90,0xA0,0xB4,
		0xC0,0xB8,0xC8,0xDC,0xE4,0xF0,0xDC,0xF4,0xF0,0xFC,
		0xFF,0xF0,0xF4,0xEC,0xE8,0xEC,0xE4,0xDC,0xF4,0xDC,
		0xD8,0xE4,0xCC,0xD8,0xCC,0xBC,0xA0,0xAC,0xA0,0xB4,
		0xA4,0xA4,0xA8,0x9C,0x90,0x84,0x74,0x64,0x6C,0x58,
		0x68,0x5C,0x5C,0x54,0x4C,0x40,0x4C,0x40,0x20,0x34,
		0x20,0x14,0x20,0x20,0x10,0x1C,0x18,0x18,0x18,0x18,
		0x20,0x20,0x18,0x18,0x28,0x24,0x38,0x40,0x34,0x3C,
		0x4C,0x48,0x50,0x48,0x50,0x58,0x68,0x68,0x70,0x74,
		0x74,0x84,0x88,0x94,0x90,0x90,0x98,0xA0,0xA4,0xAC,
		0xA8,0xB8,0xB0,0xB4,0xB8,0xA8,0xB4,0xB8,0xB4,0xBC,
		0xC0,0xB4,0xB4,0xC4,0xC8,0xC8,0xC0,0xD0,0xBC,0xCC,
		0xC8,0xCC,0xCC,0xE0,0xD0,0xD8,0xDC,0xDC,0xE8,0xEC,
		0xEC,0xE0,0xDC,0xE0,0xD8,0xE0,0xDC,0xD0,0xC8,0xC8,
		0xC8,0xC8,0xBC,0xB4,0xB4,0xA0,0x98,0x88,0x8C,0x8C,
		0x80,0x7C,0x78,0x68,0x5C,0x5C,0x4C,0x48,0x40,0x40,
		0x34,0x34,0x34,0x34,0x2C,0x28,0x24,0x18,0x20,0x14,
		0x18,0x20,0x18,0x24,0x1C,0x18,0x28,0x1C,0x2C,0x2C,
		0x2C,0x3C,0x38,0x30,0x40,0x38,0x44,0x48,0x4C,0x48,
		0x54,0x50,0x5C,0x64,0x64,0x70,0x68,0x70,0x78,0x84,
		0x84,0x88,0x98,0x9C,0xAC,0xAC,0xAC,0xAC,0xB4,0xA8,
		0xC4,0xC4,0xBC,0xCC,0xC8,0xC0,0xC0,0xB8,0xB4,0xB4,
		0xB4,0xB0,0xB4,0xA8,0xA8,0xA0,0x94,0x94,0x8C,0x88,
		0x88,0x88,0x80,0x7C,0x78,0x70,0x6C,0x64,0x60,0x60,
		0x5C,0x5C,0x54,0x54,0x4C,0x48,0x40,0x40,0x40,0x3C,
		0x44,0x40,0x40,0x48,0x40,0x40,0x44,0x44,0x48,0x4C,
		0x58,0x60,0x5C,0x64,0x64,0x6C,0x6C,0x70,0x6C,0x70,
		0x78,0x88,0x80,0x80,0x80,0x80,0x80,0x80,0x80,};
static ymu8	sample05[505]={
		0x9F,0x74,0x71,0x47,0x4D,0x63,0x2C,0x2F,0x80,0x99,
		0xD9,0xC3,0xFA,0xB3,0xA7,0xA1,0x94,0x95,0x5A,0x69,
		0x02,0x29,0x0B,0x13,0x00,0x0B,0x0A,0x03,0x00,0x41,
		0x92,0xC4,0xE5,0xFF,0xFF,0xFF,0xEB,0x93,0xF9,0xB4,
		0xC3,0xFF,0xFF,0xFB,0xDD,0xF4,0xD7,0x88,0x52,0x22,
		0x06,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
		0x00,0x00,0x4A,0x9E,0xE8,0xFF,0xFF,0xF9,0xFF,0xE1,
		0xFF,0xFC,0xFF,0xFE,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
		0xFF,0xFB,0xAA,0x7E,0x0E,0x00,0x00,0x00,0x00,0x00,
		0x00,0x09,0x1A,0x28,0x15,0x2D,0x23,0x15,0x0E,0x17,
		0x17,0x24,0x38,0x36,0xA0,0x75,0x95,0x96,0x8F,0x90,
		0x5B,0x4F,0x00,0x00,0x00,0x00,0x26,0x5E,0xA2,0xC7,
		0xEF,0xFE,0xFF,0xFF,0xFA,0xFF,0xF9,0xE3,0xFA,0xD7,
		0xFE,0x83,0x93,0xA1,0xC7,0x73,0xFF,0xDE,0xEC,0xFE,
		0xCF,0xB5,0x89,0x8A,0x51,0x95,0x42,0x9E,0x7B,0x84,
		0x93,0x8C,0x5C,0xA3,0x5C,0x46,0x16,0x0C,0x33,0x02,
		0x73,0x10,0x1A,0x00,0x2B,0x00,0x48,0x22,0x73,0x52,
		0x83,0xB2,0xA0,0x5C,0xB5,0x54,0x38,0x3D,0x00,0x0B,
		0x2A,0x14,0x1D,0x2B,0x07,0x0F,0x2B,0x16,0x26,0x4A,
		0x80,0xE2,0xDE,0xFE,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
		0xFF,0xFF,0xFF,0xFD,0xFF,0xFF,0xFA,0xFE,0xFF,0xFA,
		0xFF,0xFA,0xFB,0xF7,0x80,0x4E,0x00,0x00,0x00,0x00,
		0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
		0x20,0x00,0x1B,0x1B,0x2C,0x1E,0x3D,0x44,0x56,0x52,
		0x77,0x84,0x8B,0x8A,0x92,0x8D,0xBA,0xE8,0xFF,0xFF,
		0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
		0xFF,0xFF,0xFF,0xFF,0xF8,0xE0,0xD6,0xB4,0x7C,0x8A,
		0x33,0x4B,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
		0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x03,
		0x2A,0x52,0x1C,0x6B,0x5B,0x7A,0xAC,0xAD,0xA8,0xE2,
		0xA7,0xD9,0x90,0xD1,0x95,0xD4,0x8A,0xD2,0xB6,0xE4,
		0xEA,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
		0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xEA,0xF9,
		0xC8,0x95,0x4F,0x3E,0x0F,0x00,0x09,0x02,0x03,0x00,
		0x29,0x05,0x12,0x17,0x0C,0x08,0x17,0x00,0x00,0x00,
		0x00,0x00,0x00,0x00,0x00,0x01,0x01,0x2A,0x22,0x40,
		0x47,0x93,0x64,0x9B,0xAC,0xB5,0xF2,0xD7,0xFD,0xFE,
		0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xA7,0xF9,0xC6,
		0xB3,0xE4,0xAA,0xBA,0x97,0xA6,0x44,0x60,0x1C,0x14,
		0x47,0x10,0x05,0x00,0x00,0x00,0x1C,0x07,0x00,0x0B,
		0x23,0x35,0x61,0x66,0xA6,0xA4,0x96,0x8E,0xA6,0xB0,
		0x5D,0xBD,0x7D,0x7C,0x57,0x77,0x52,0x62,0x69,0x6E,
		0x7B,0x62,0x97,0x80,0xA1,0x92,0xC2,0xA9,0xB0,0xC7,
		0xFC,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
		0xFF,0xFF,0xF3,0xE7,0xC8,0xCB,0x91,0xAC,0x7D,0x67,
		0x41,0x30,0x04,0x00,0x00,0x00,0x00,0x00,0x09,0x00,
		0x00,0x34,0x0C,0x1E,0x34,0x1F,0x25,0x2B,0x18,0x12,
		0x09,0x1B,0x00,0x16,0x0F,0x39,0x1E,0x40,0x49,0x55,
		0x6E,0x7D,0x84,0xA2,0xBC,0xCA,0xC6,0xCA,0xC3,0xCA,
		0xB4,0xD7,0xAC,0x86,0x9F,0x7E,0x89,0x81,0x80,0x80,
		0x80,0x80,0x80,0x80,0x80,};
static ymu8	sample06[727]={
		0x8C,0x38,0x74,0xA4,0x64,0x98,0xD8,0x80,0x0C,0x44,
		0xB0,0xB4,0xA4,0xA4,0x54,0x14,0x48,0x84,0xC4,0xF8,
		0xFF,0x5C,0x00,0x00,0x5C,0xFF,0xFF,0x7C,0x8C,0x20,
		0x00,0xA8,0xF8,0x68,0x2C,0x8C,0xB0,0x14,0x00,0x74,
		0xFF,0xFF,0xE4,0x0C,0x00,0x60,0x5C,0x00,0x00,0x00,
		0xFF,0xFF,0xFF,0xFF,0xFF,0x9C,0x00,0x00,0x00,0x00,
		0x00,0x14,0xF8,0xF4,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
		0xFF,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x38,0xA4,
		0xFF,0xFF,0xFF,0xFF,0xA8,0x10,0x00,0x00,0x00,0x70,
		0x8C,0x84,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFC,
		0x70,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x60,
		0xE4,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
		0xFF,0x70,0xB4,0xE4,0x84,0x3C,0x00,0x00,0x00,0x00,
		0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x84,0xBC,0xDC,
		0xE8,0xE0,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
		0xFF,0xFF,0x84,0x34,0x30,0x00,0x00,0x00,0x00,0x00,
		0x00,0x00,0x00,0x00,0x00,0x3C,0x34,0x58,0xAC,0x58,
		0xCC,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xE4,0xFF,
		0xFF,0xFF,0xFF,0x44,0x00,0x38,0x00,0x00,0x00,0x00,
		0x00,0x00,0x00,0x00,0x00,0x30,0xFF,0x38,0x00,0x00,
		0xDC,0xFF,0xFF,0x98,0x7C,0xB8,0xFF,0xFF,0xFF,0xFF,
		0xFF,0xFF,0xFF,0xFF,0xFF,0x8C,0x00,0x00,0x00,0x00,
		0x00,0x00,0x00,0x6C,0x00,0x00,0x64,0x6C,0x08,0x48,
		0x40,0x30,0x70,0x3C,0x68,0xFF,0x8C,0x1C,0x54,0x98,
		0x8C,0xC8,0xFF,0xFF,0xFF,0xBC,0xFF,0xFF,0xFF,0xFF,
		0x24,0x60,0xFF,0xF8,0x00,0x00,0x00,0x38,0x00,0x00,
		0x40,0x00,0x00,0x34,0xFF,0xFF,0x14,0x0C,0xFF,0x8C,
		0x00,0x10,0xFC,0xA8,0x54,0x00,0x68,0xFF,0xFF,0xFF,
		0xD4,0xA8,0xFF,0xFF,0xFF,0x8C,0x40,0xFF,0xFF,0x00,
		0x00,0x64,0x6C,0x00,0x00,0x00,0x00,0x00,0x38,0xF0,
		0x40,0x00,0x24,0x84,0xA4,0x00,0x00,0x98,0xFF,0x08,
		0x00,0xFF,0xFF,0xE4,0x94,0xFF,0xFF,0xFF,0x54,0xFF,
		0xFF,0xFF,0xE8,0xFF,0x78,0x00,0x00,0xF8,0xFF,0x00,
		0x00,0x70,0x3C,0x00,0x54,0x74,0x00,0x00,0x28,0xFF,
		0xEC,0x00,0x00,0x44,0xFF,0xFF,0x94,0x30,0xA8,0xFF,
		0xFF,0xFF,0x94,0xD8,0xFF,0xFF,0x80,0x00,0xBC,0xFF,
		0x30,0x00,0x34,0xFF,0x30,0x00,0x00,0xC8,0xC4,0x64,
		0x00,0x00,0xD4,0x74,0x00,0x00,0xDC,0xFC,0x00,0x00,
		0x00,0xFF,0xFF,0x14,0x00,0xFF,0xFF,0xFF,0xD8,0xFF,
		0xFF,0xFC,0xD8,0x5C,0x00,0x40,0xFF,0xFF,0x00,0x00,
		0x00,0xE4,0xFF,0x1C,0x00,0x7C,0xFF,0xA4,0x00,0x54,
		0xFF,0x08,0x00,0x00,0x3C,0x04,0x98,0x18,0x18,0xF0,
		0xFF,0xFF,0x14,0x4C,0xFF,0xFF,0xE4,0x14,0x00,0xA8,
		0xFF,0xFF,0x00,0x00,0x38,0xFF,0xFF,0x20,0x00,0xC4,
		0xFF,0x5C,0xA8,0xB0,0x28,0x50,0xFF,0x90,0x00,0x00,
		0xF8,0xA4,0x00,0x00,0x10,0xB0,0xCC,0xC4,0xFF,0xFF,
		0xEC,0x7C,0xFF,0xFF,0x98,0x9C,0xFF,0x8C,0x00,0x00,
		0xFF,0xFF,0x84,0x00,0x30,0xFF,0xFC,0x04,0x08,0xD0,
		0x90,0x00,0x00,0x44,0xB4,0x20,0x00,0x00,0x5C,0xF0,
		0x58,0x1C,0xFF,0xFF,0xFF,0x70,0x50,0xFF,0xFF,0xFF,
		0xC0,0x88,0x40,0x20,0xF4,0xFF,0x14,0x00,0x00,0x0C,
		0x7C,0xA0,0x68,0x00,0x00,0x40,0x94,0x38,0xA0,0x60,
		0x00,0x24,0xFF,0xF0,0x00,0x00,0x38,0xFF,0xFF,0x8C,
		0x2C,0x64,0xFF,0xFF,0xA4,0xD4,0x8C,0x00,0x2C,0xE4,
		0x8C,0x70,0x6C,0x00,0x44,0xA8,0x68,0x78,0xFF,0xEC,
		0x00,0x00,0xF0,0xFF,0x84,0x10,0x00,0x6C,0xFF,0x30,
		0x00,0xDC,0xFF,0x1C,0x08,0xFF,0xFF,0xA4,0x00,0x50,
		0xFF,0xD8,0x24,0x60,0xFC,0x70,0x00,0x64,0xFF,0xC0,
		0x00,0x0C,0xFF,0xEC,0xFF,0xFF,0x30,0x00,0xC4,0xFF,
		0x00,0x1C,0xE0,0x40,0x00,0x70,0xC0,0x9C,0x00,0x00,
		0xD4,0xFF,0x7C,0x00,0x3C,0xFF,0xD4,0x00,0x0C,0xFF,
		0xD4,0x00,0x10,0xF0,0xFF,0x14,0x00,0xFF,0xDC,0x74,
		0xFF,0xFF,0x10,0x00,0xFF,0xFF,0x00,0x00,0xC8,0xA4,
		0x00,0x34,0xD8,0xB8,0x00,0x00,0xA0,0xFF,0x78,0x00,
		0x68,0xFF,0x80,0x00,0xBC,0xBC,0x5C,0xB4,0x08,0x00,
		0xDC,0xFF,0x88,0x00,0x84,0xFF,0xA4,0x14,0x84,0x68,
		0x5C,0x10,0x00,0x70,0x34,0x00,0x00,0xC8,0xEC,0x40,
		0x00,0x00,0xD8,0xFF,0xFF,0x40,0x70,0xA0,0x78,0xDC,
		0xFF,0xE4,0x00,0x58,0xE8,0xFF,0xFF,0x94,0x18,0x70,
		0xFF,0xFF,0x98,0x00,0x8C,0xB4,0x20,0x14,0xBC,0xFF,
		0x48,0x00,0x00,0xFF,0xFF,0x00,0x00,0x94,0xFF,0xD0,
		0x00,0x1C,0xFF,0xFF,0x38,0x00,0xBC,0xFF,0x44,0x38,
		0x80,0x80,0x80,0x80,0x80,0x80,0x80,};
static ymu8	sample07[480]={
		0x3E,0xFD,0x13,0xFA,0x18,0xD5,0x1D,0xC1,0xC3,0xB5,
		0xE7,0x6F,0xDF,0x01,0xFF,0x70,0xAD,0xE9,0x27,0xEB,
		0x9F,0x2B,0xFD,0x38,0xB2,0xD9,0x0D,0xFF,0x4C,0x3B,
		0xFB,0x00,0xD3,0x9D,0x00,0xD3,0xDF,0x1C,0xED,0xCD,
		0x00,0xCB,0xB2,0x00,0x86,0xCE,0x10,0x13,0xD1,0x85,
		0x90,0x07,0xCD,0xE3,0x22,0x3D,0x8F,0x8A,0x33,0x7E,
		0xB4,0x3A,0x45,0xCE,0xA7,0x3A,0x47,0xE9,0xAF,0x08,
		0x49,0xAE,0xC0,0x4C,0x10,0x46,0xF1,0x38,0x03,0x89,
		0xEF,0x6A,0x11,0xC7,0xF3,0x43,0x00,0x2D,0xE5,0xF1,
		0x3E,0x00,0x17,0xA9,0xFF,0xEC,0x73,0x00,0x43,0xE5,
		0xF3,0x72,0x28,0x57,0xFF,0xC7,0x4E,0x22,0x5F,0xF3,
		0xFF,0xF1,0x65,0x0B,0x08,0xA9,0xFF,0xDF,0x66,0x24,
		0x18,0xA7,0xC6,0x9C,0xDC,0x9D,0xA3,0x56,0x00,0x00,
		0x63,0xD1,0xF8,0xFD,0x94,0x32,0x00,0x15,0x9E,0xF9,
		0xFD,0x91,0x5E,0x02,0x01,0x23,0x5A,0xDA,0xFE,0xFE,
		0xBC,0x3E,0x00,0x00,0x65,0xD6,0xFF,0xED,0xD8,0x4D,
		0x02,0x00,0x00,0x28,0xAD,0xFF,0xFF,0xFF,0xDB,0x69,
		0x29,0x00,0x01,0x00,0x03,0x8C,0xDF,0xFF,0xFF,0xFF,
		0xD5,0xC7,0x0B,0x37,0x00,0x00,0x21,0x4B,0x85,0xB3,
		0xB8,0xD0,0xFD,0x9E,0xBB,0xA2,0xE3,0xB1,0x60,0x25,
		0x30,0x02,0x28,0x58,0x3D,0x69,0xE0,0xFF,0xFF,0xD5,
		0x94,0x6D,0xA1,0x46,0x3C,0x00,0x00,0x00,0x04,0x79,
		0xB9,0xBF,0xD2,0xFF,0xFF,0xFF,0xFF,0xC5,0x76,0x52,
		0x5C,0x72,0x42,0x00,0x00,0x00,0x00,0x29,0x62,0xFF,
		0xE5,0xFF,0xFF,0xFE,0xD6,0xFE,0xE8,0xBF,0x96,0x81,
		0x79,0x62,0x2F,0x00,0x01,0x0E,0x1D,0x29,0x0D,0x27,
		0x48,0x97,0xCB,0xE7,0xEC,0xF6,0xF1,0xFF,0xF5,0x9C,
		0xA9,0xB2,0x9C,0x8A,0x6E,0x47,0x21,0x00,0x00,0x00,
		0x00,0x02,0x1C,0x47,0x5D,0x70,0x79,0x87,0xBF,0xCA,
		0xDF,0xDA,0xFD,0xFF,0xEF,0xFF,0xCF,0xF7,0xC5,0xDF,
		0xB3,0x7C,0x13,0x03,0x01,0x50,0x00,0x00,0x00,0x00,
		0x3C,0x69,0x82,0x65,0x62,0x71,0x8B,0x9D,0xBB,0x9F,
		0x9E,0x99,0xBA,0xAD,0xB5,0xE3,0xD5,0xF1,0xB2,0x9F,
		0x95,0x86,0x8F,0xBA,0xC9,0xDA,0xDA,0xDA,0x70,0x39,
		0x4C,0x58,0x6F,0x52,0x29,0x00,0x00,0x2D,0x0B,0x00,
		0x00,0x03,0x3F,0x82,0xA7,0xF5,0x98,0x99,0x8A,0xCD,
		0xB0,0x9B,0xDD,0xFE,0xFF,0xFF,0xF1,0xBA,0x92,0x6C,
		0x71,0x5A,0x91,0x4A,0x49,0x59,0x58,0x69,0x61,0x7A,
		0x75,0x67,0x62,0x81,0x92,0xD9,0xD9,0x82,0x34,0x03,
		0x28,0x3D,0x67,0x62,0x52,0x7B,0x6D,0x8F,0x90,0x81,
		0x7D,0x84,0x9D,0xC0,0xCE,0xBE,0x9C,0x93,0xA5,0xBA,
		0xA8,0xB7,0xAE,0x94,0x8F,0x82,0x6A,0x6D,0x51,0x5A,
		0x5F,0x69,0x84,0x95,0x8B,0x85,0x74,0x78,0x7A,0xA0,
		0x88,0x74,0x58,0x3B,0x34,0x09,0x00,0x00,0x0E,0x47,
		0x7E,0x94,0x8B,0x74,0x61,0x7B,0x80,0x90,0x90,0xA0,
		0xBD,0xCB,0xDA,0xC6,0xC1,0xA3,0x9F,0x92,0x98,0xA5,
		0x9C,0xAB,0xB0,0xAB,0xA8,0x96,0xB7,0xB5,0xC7,0xA4,
		0xB5,0xD0,0xD9,0x80,0x80,0x80,0x80,0x80,0x80,0x80,};
static ymu8	sample08[2108]={
		0x8A,0xAB,0x9D,0x3F,0x29,0x4A,0x68,0x97,0xF2,0x85,
		0x90,0x6D,0x68,0x68,0x71,0x82,0x88,0xEB,0x9A,0x59,
		0x30,0x00,0x33,0x41,0x84,0xA9,0xCC,0x92,0x81,0x60,
		0x77,0x79,0x80,0x95,0xB6,0xDA,0x92,0x6B,0x45,0x2E,
		0x02,0x51,0x63,0x8B,0xA1,0xA3,0xD6,0x92,0x92,0x83,
		0x76,0x7D,0x7C,0x7C,0x8B,0x88,0x7D,0x92,0xD5,0xAC,
		0x60,0x48,0x32,0x19,0x0C,0x49,0x5A,0x93,0x8D,0x93,
		0xA7,0xD6,0x90,0x88,0x78,0x7D,0x75,0x8D,0x7E,0x7E,
		0x8F,0x84,0x89,0x8B,0xE7,0xA9,0x61,0x53,0x36,0x28,
		0x1B,0x4E,0x5E,0x7C,0xA0,0x99,0xA5,0xCC,0xA8,0x9A,
		0x94,0x89,0x87,0x89,0x98,0x83,0x8C,0x8F,0x84,0x7A,
		0x8E,0xD4,0xD3,0x58,0x48,0x24,0x24,0x06,0x47,0x4E,
		0x82,0x97,0x89,0x9D,0xEC,0x83,0x95,0x8C,0x7C,0x7E,
		0x89,0x89,0x76,0x86,0x87,0x78,0x89,0xA2,0x86,0xB9,
		0x62,0x3D,0x1D,0x2D,0x10,0x4A,0x63,0x8A,0x98,0x98,
		0xB1,0xF3,0xA0,0xA9,0x8D,0x87,0x93,0x92,0x8F,0x90,
		0x94,0x90,0x81,0x8F,0xC8,0x54,0xA3,0x6A,0x36,0x28,
		0x2C,0x2B,0x38,0x6B,0x90,0x96,0xA5,0xEB,0x96,0x8D,
		0x81,0x7D,0x7D,0x89,0x8F,0x8F,0x87,0x91,0xB3,0xB1,
		0x63,0x54,0x30,0x03,0x4A,0x49,0x6C,0x86,0xB7,0x80,
		0x85,0x7C,0x69,0x80,0x79,0x89,0x89,0x95,0xBC,0xBE,
		0x6F,0x60,0x3F,0x06,0x5B,0x60,0x83,0x9C,0xC3,0x93,
		0x8B,0x86,0x6F,0x7A,0x7C,0x85,0x8E,0x97,0xBB,0xC5,
		0x6A,0x5C,0x34,0x04,0x4E,0x4E,0x80,0x97,0xB9,0x90,
		0x81,0x75,0x6A,0x73,0x7A,0x86,0x89,0x90,0xB5,0xBA,
		0x63,0x58,0x40,0x06,0x55,0x5E,0x82,0x91,0xBC,0x92,
		0x83,0x7D,0x69,0x7A,0x79,0x85,0x86,0x91,0xB8,0xB0,
		0x62,0x65,0x45,0x08,0x53,0x5E,0x8A,0x9A,0xEE,0x8F,
		0x86,0x6D,0x74,0x72,0x7E,0x88,0x92,0xC1,0xD6,0x70,
		0x56,0x33,0x13,0x53,0x5D,0x8C,0x98,0xDF,0x89,0x7E,
		0x66,0x70,0x79,0x79,0x87,0x8D,0xA3,0xC6,0x79,0x65,
		0x40,0x13,0x57,0x59,0x75,0x8D,0xA3,0xB2,0x84,0x83,
		0x6D,0x7A,0x81,0x80,0x8A,0x91,0xAA,0xCE,0x80,0x6C,
		0x43,0x12,0x50,0x54,0x76,0x95,0xAA,0xB4,0x86,0x82,
		0x67,0x6E,0x7A,0x80,0x90,0x90,0xA4,0xCA,0x77,0x69,
		0x3F,0x0F,0x4E,0x5B,0x79,0x8E,0xA5,0xB7,0x87,0x82,
		0x65,0x70,0x7A,0x83,0x85,0x92,0xA4,0xC5,0x7B,0x65,
		0x43,0x1C,0x48,0x59,0x70,0x95,0x9D,0xF0,0x8A,0x8A,
		0x70,0x70,0x7B,0x7C,0x8B,0x8D,0x90,0xA0,0xC6,0x81,
		0x66,0x44,0x28,0x37,0x55,0x6C,0x93,0x98,0xDE,0x80,
		0x88,0x71,0x74,0x79,0x76,0x8A,0x8A,0x90,0x90,0xEE,
		0xCB,0x63,0x52,0x32,0x05,0x50,0x5F,0x7D,0x90,0x9C,
		0xE7,0x80,0x8D,0x78,0x6B,0x77,0x7C,0x87,0x88,0x91,
		0x92,0xB8,0xC4,0x66,0x56,0x37,0x2A,0x31,0x54,0x70,
		0x92,0x8F,0xB2,0xBC,0x8E,0x8B,0x76,0x7E,0x7A,0x85,
		0x8B,0x88,0x8F,0x98,0xDF,0xB9,0x6D,0x49,0x2A,0x07,
		0x53,0x5C,0x80,0x95,0x97,0xEB,0x85,0x88,0x73,0x71,
		0x78,0x75,0x83,0x92,0x90,0x8D,0xCD,0xC1,0x57,0x57,
		0x3A,0x21,0x4A,0x5D,0x70,0x8B,0x9B,0xB0,0x8B,0x88,
		0x84,0x70,0x78,0x82,0x86,0x85,0x90,0x8F,0x8F,0xA1,
		0xC0,0x98,0x62,0x49,0x32,0x1A,0x4A,0x60,0x76,0x96,
		0x98,0x9E,0xE4,0x8B,0x8B,0x7A,0x79,0x7D,0x7D,0x85,
		0x86,0x85,0x85,0x89,0x8A,0xD1,0xB9,0x5C,0x3F,0x30,
		0x26,0x2D,0x56,0x74,0x8C,0x95,0xA4,0xC8,0x8F,0x96,
		0x84,0x79,0x81,0x80,0x88,0x89,0x8F,0x87,0x88,0x94,
		0xEA,0xD8,0x65,0x4B,0x30,0x27,0x15,0x51,0x66,0x90,
		0x91,0x99,0xB7,0xA6,0x97,0x8D,0x80,0x87,0x82,0x8C,
		0x8A,0x86,0x88,0x85,0x83,0x9C,0xA8,0x90,0x52,0x43,
		0x2F,0x24,0x20,0x5C,0x69,0x89,0x94,0x9B,0xA5,0xEC,
		0x95,0x94,0x80,0x8A,0x80,0x83,0x8D,0x85,0x85,0x89,
		0x87,0x85,0xC8,0xA8,0x5F,0x4C,0x3B,0x29,0x13,0x4C,
		0x5A,0x73,0x92,0x98,0xA1,0xB2,0xBA,0x96,0x94,0x87,
		0x88,0x84,0x8A,0x8B,0x82,0x84,0x88,0x80,0x7E,0x88,
		0xE5,0xC2,0x5C,0x47,0x2F,0x2C,0x30,0x09,0x58,0x6D,
		0x8D,0x93,0x9D,0xA9,0xAE,0xF5,0x9F,0x9F,0x87,0x8B,
		0x87,0x84,0x86,0x85,0x7E,0x76,0x78,0x76,0x7A,0x83,
		0xE2,0xBD,0x55,0x3E,0x2C,0x29,0x31,0x0E,0x5E,0x70,
		0x8F,0x9D,0xA5,0xAC,0xB7,0xF3,0xA7,0xA7,0x8C,0x88,
		0x85,0x7E,0x84,0x83,0x81,0x7D,0x7B,0x7B,0x75,0x80,
		0xE7,0xB9,0x43,0x40,0x2C,0x28,0x2D,0x05,0x4E,0x69,
		0x91,0x9A,0xA8,0xAD,0xAF,0xF7,0x99,0xA5,0x8D,0x89,
		0x89,0x82,0x83,0x80,0x7B,0x7B,0x76,0x73,0x78,0x82,
		0xDF,0x56,0x87,0x4D,0x27,0x2D,0x30,0x03,0x97,0x70,
		0x80,0x96,0xAA,0xA8,0xAF,0xF2,0x6F,0xCB,0x90,0x83,
		0x8D,0x80,0x88,0x84,0x80,0x80,0x78,0x71,0x79,0x7C,
		0xC8,0x8F,0x93,0x26,0x37,0x22,0x2A,0x05,0x6B,0x56,
		0x92,0x97,0xA7,0xAA,0xAE,0xEF,0xCA,0x7C,0xB3,0x71,
		0x9C,0x77,0x94,0x81,0x81,0x7D,0x76,0x74,0x76,0x78,
		0xB4,0xCD,0x81,0x35,0x18,0x34,0x1E,0x04,0x20,0xA9,
		0x60,0xB0,0xB1,0xA2,0xB8,0xE5,0xF6,0x63,0xAA,0x98,
		0x70,0x95,0x82,0x7C,0x84,0x7D,0x78,0x76,0x75,0x77,
		0xA1,0xD9,0x8F,0x50,0x03,0x33,0x17,0x00,0x92,0x6B,
		0x8B,0x9B,0xA5,0xAE,0xB4,0xD5,0xB2,0xA6,0x9F,0x87,
		0x87,0x81,0x87,0x83,0x80,0x7D,0x80,0x7A,0x75,0x78,
		0x78,0xC1,0x80,0x72,0x44,0x33,0x25,0x28,0x28,0x3C,
		0x6C,0x7D,0x9F,0xA1,0xAA,0xB2,0xB3,0xEF,0xA1,0xA9,
		0x8F,0x84,0x81,0x7D,0x7B,0x7D,0x7C,0x76,0x73,0x71,
		0x6D,0x71,0x75,0x9A,0x79,0xA8,0x4F,0x3B,0x2B,0x32,
		0x35,0x0E,0x6B,0x76,0x94,0xA7,0xAD,0xB8,0xB8,0xBF,
		0xED,0xA8,0xAF,0x95,0x85,0x84,0x7B,0x7B,0x75,0x76,
		0x6F,0x6A,0x6A,0x6A,0x6E,0x6D,0x74,0xD7,0x86,0x5A,
		0x40,0x31,0x2E,0x3A,0x3A,0x1A,0x6D,0x7C,0x9E,0xA9,
		0xB3,0xBA,0xBC,0xC0,0xF4,0xAD,0xAA,0x8D,0x84,0x7E,
		0x79,0x77,0x74,0x74,0x6D,0x69,0x6B,0x69,0x6B,0x70,
		0x77,0xD9,0x80,0x6D,0x43,0x36,0x31,0x38,0x3D,0x1E,
		0x71,0x78,0x94,0xAF,0xB4,0xBD,0xBF,0xC3,0xC7,0xF5,
		0xAE,0xA1,0x86,0x80,0x73,0x6F,0x6F,0x6E,0x67,0x65,
		0x63,0x5F,0x63,0x69,0x68,0x6C,0x7D,0xB4,0xC4,0x50,
		0x44,0x34,0x33,0x45,0x4B,0x11,0x77,0x85,0xA6,0xB4,
		0xBD,0xBF,0xBF,0xC4,0xD3,0xBF,0xAC,0xA0,0x7D,0x7D,
		0x74,0x6F,0x6C,0x69,0x66,0x62,0x60,0x63,0x63,0x6A,
		0x6C,0x6D,0x8F,0x82,0xE0,0x2D,0x47,0x3E,0x34,0x42,
		0x4F,0x0B,0x73,0x83,0xA7,0xAF,0xB8,0xBD,0xB9,0xBD,
		0xBE,0xCC,0xCA,0xA1,0x92,0x73,0x6F,0x67,0x63,0x61,
		0x64,0x60,0x5D,0x61,0x61,0x63,0x66,0x6B,0x72,0x73,
		0x7E,0x95,0xA6,0xCA,0x60,0x4D,0x46,0x3F,0x4B,0x54,
		0x5F,0x28,0x85,0x90,0xB2,0xB7,0xBE,0xC2,0xC0,0xBE,
		0xBE,0xC7,0xC3,0x9A,0x8C,0x6D,0x66,0x5D,0x5B,0x58,
		0x5A,0x58,0x55,0x56,0x58,0x5D,0x61,0x66,0x6D,0x73,
		0x77,0x88,0xC2,0xBB,0x5D,0x5C,0x50,0x3F,0x4F,0x57,
		0x5F,0x0E,0x87,0x92,0xB4,0xBF,0xC3,0xC6,0xC6,0xC5,
		0xC3,0xCA,0xF7,0xA2,0x86,0x6B,0x69,0x62,0x5F,0x5D,
		0x5B,0x5D,0x5A,0x57,0x59,0x5D,0x5E,0x66,0x71,0x71,
		0x79,0x88,0xF7,0x3C,0xCB,0x1E,0x5B,0x32,0x46,0x4F,
		0x54,0x1C,0x93,0x71,0xBA,0xAE,0xC0,0xC3,0xC1,0xC1,
		0xC1,0xC6,0xFD,0x83,0x98,0x7B,0x56,0x73,0x50,0x64,
		0x54,0x60,0x54,0x57,0x5E,0x5D,0x64,0x67,0x6D,0x73,
		0x7A,0x84,0xDB,0xC1,0x9B,0x56,0x31,0x3E,0x3D,0x49,
		0x57,0x65,0x25,0x8E,0xA0,0xBD,0xC3,0xCB,0xCA,0xC5,
		0xC5,0xBF,0xB9,0xBA,0xED,0x91,0x82,0x61,0x57,0x4E,
		0x4E,0x4F,0x4A,0x4E,0x4F,0x50,0x54,0x59,0x61,0x66,
		0x6D,0x77,0x78,0x82,0x89,0x8E,0xBD,0x81,0xDA,0x5C,
		0x58,0x52,0x4B,0x56,0x61,0x67,0x67,0x44,0x90,0x98,
		0xB8,0xBD,0xC3,0xC2,0xC2,0xC1,0xB9,0xB7,0xB6,0xF1,
		0x9D,0x8C,0x64,0x57,0x52,0x4D,0x4D,0x4C,0x4D,0x4B,
		0x4F,0x55,0x56,0x5E,0x67,0x6A,0x72,0x79,0x80,0x85,
		0x8B,0xB4,0x99,0xDA,0x7B,0x51,0x52,0x46,0x55,0x5C,
		0x67,0x6C,0x0D,0xCC,0x8E,0xB2,0xC3,0xC2,0xC8,0xC5,
		0xC5,0xC2,0xBB,0xBC,0xFA,0x65,0xAA,0x4F,0x63,0x48,
		0x4D,0x4B,0x49,0x4A,0x4F,0x4E,0x51,0x59,0x5F,0x66,
		0x6B,0x71,0x78,0x80,0x86,0x8E,0xA5,0xF4,0x79,0xA1,
		0x5A,0x32,0x4E,0x54,0x52,0x62,0x6D,0x2A,0x6D,0xD1,
		0x95,0xD0,0xC2,0xCD,0xC4,0xC2,0xC3,0xBD,0xBA,0xE0,
		0x81,0x87,0x6A,0x55,0x53,0x47,0x49,0x4A,0x47,0x4A,
		0x4E,0x51,0x59,0x5D,0x63,0x67,0x70,0x79,0x7E,0x85,
		0x8B,0x8F,0x96,0xE6,0x86,0xDD,0x5F,0x5B,0x48,0x4A,
		0x55,0x5D,0x68,0x6B,0x1E,0x8F,0x9A,0xB5,0xBE,0xC2,
		0xC8,0xC3,0xC1,0xBD,0xB9,0xB5,0xB0,0xED,0x91,0x7E,
		0x5A,0x51,0x46,0x46,0x46,0x45,0x49,0x4A,0x4E,0x53,
		0x58,0x61,0x67,0x72,0x75,0x7D,0x86,0x8A,0x8E,0x93,
		0x9D,0xEF,0x82,0xC2,0x3F,0x6F,0x48,0x55,0x5A,0x63,
		0x6D,0x6D,0x15,0xC2,0x9A,0xAA,0xC1,0xC2,0xC4,0xC2,
		0xBF,0xBA,0xB4,0xAF,0xAD,0xF6,0x40,0x96,0x3F,0x58,
		0x43,0x45,0x44,0x47,0x47,0x48,0x4F,0x54,0x59,0x61,
		0x68,0x6D,0x75,0x80,0x85,0x89,0x91,0x95,0xA0,0xF9,
		0x7A,0xAE,0x70,0x3A,0x47,0x58,0x56,0x60,0x6F,0x6F,
		0x1F,0xC4,0x7D,0xD7,0xC3,0xC4,0xCC,0xC7,0xC3,0xBF,
		0xBB,0xAF,0xA8,0xA8,0xC3,0x76,0x68,0x45,0x3E,0x39,
		0x37,0x37,0x39,0x42,0x43,0x47,0x51,0x59,0x60,0x6E,
		0x77,0x7C,0x84,0x8A,0x8F,0x92,0x96,0x9B,0x9A,0x9E,
		0xB8,0x84,0x95,0x9D,0x64,0x5A,0x48,0x55,0x56,0x63,
		0x6F,0x73,0x77,0x2A,0x8C,0xA1,0xC2,0xC7,0xCB,0xCC,
		0xC8,0xC0,0xBB,0xB6,0xAC,0x9F,0x99,0xC6,0x48,0x62,
		0x53,0x3B,0x35,0x30,0x31,0x30,0x3A,0x3E,0x41,0x49,
		0x53,0x5B,0x65,0x71,0x78,0x80,0x8A,0x90,0x92,0x97,
		0x9D,0x9F,0x9F,0xA2,0xEA,0x6F,0xC7,0x94,0x39,0x70,
		0x4B,0x58,0x61,0x63,0x76,0x77,0x6F,0x49,0xD3,0x8A,
		0xDD,0xB7,0xD0,0xC6,0xC1,0xBE,0xB6,0xB1,0xA5,0x9C,
		0x93,0xA0,0x70,0x61,0x4D,0x34,0x33,0x2C,0x2F,0x32,
		0x36,0x3B,0x3E,0x48,0x52,0x5A,0x67,0x71,0x78,0x82,
		0x89,0x91,0x96,0x9A,0x9F,0x9F,0xA0,0xA0,0x9D,0x9D,
		0x9D,0xC6,0x7A,0x8B,0xBC,0x5F,0x5B,0x48,0x4F,0x54,
		0x60,0x6B,0x74,0x7E,0x84,0x55,0xC0,0xB3,0xC5,0xD2,
		0xD2,0xD2,0xCA,0xC1,0xB8,0xAE,0xA2,0x99,0x8D,0x80,
		0x76,0x81,0x67,0x63,0x3B,0x1B,0x1E,0x1E,0x25,0x2A,
		0x33,0x3A,0x40,0x4E,0x58,0x65,0x71,0x7C,0x88,0x90,
		0x97,0x9F,0xA3,0xA7,0xA9,0xAB,0xAB,0xAA,0xA8,0xA4,
		0xA2,0xAC,0xF0,0x49,0xCB,0x7C,0x3A,0x6A,0x3E,0x5D,
		0x5D,0x68,0x70,0x79,0x82,0x86,0x33,0xA4,0xAE,0xC7,
		0xCC,0xCC,0xC8,0xBF,0xB8,0xAD,0xA2,0x97,0x8C,0x80,
		0x74,0x69,0x62,0xB3,0x3F,0x38,0x1E,0x1A,0x1B,0x1E,
		0x26,0x30,0x38,0x43,0x4F,0x58,0x65,0x71,0x7E,0x88,
		0x94,0x9C,0xA3,0xA7,0xAD,0xAF,0xAF,0xB0,0xAE,0xAD,
		0xA8,0xA6,0xA2,0x9E,0xA1,0xF1,0x82,0x8C,0x81,0x57,
		0x4F,0x4F,0x55,0x5B,0x68,0x6F,0x77,0x80,0x87,0x85,
		0x53,0xAF,0xC5,0xC2,0xC6,0xC9,0xBF,0xB8,0xAF,0xA4,
		0x9A,0x8F,0x84,0x76,0x6A,0x5F,0x59,0xA0,0x0C,0x4F,
		0x07,0x25,0x16,0x23,0x29,0x35,0x3F,0x48,0x55,0x60,
		0x6D,0x7A,0x86,0x90,0x9A,0xA2,0xA8,0xAC,0xB1,0xB3,
		0xB1,0xB0,0xAF,0xAB,0xA8,0xA6,0xA0,0x9D,0x9D,0xE1,
		0x7D,0x86,0xA7,0x3A,0x6C,0x42,0x58,0x59,0x63,0x6D,
		0x74,0x7B,0x86,0x8E,0x8F,0x3E,0xAB,0xAF,0xC3,0xC7,
		0xC1,0xBD,0xB3,0xA8,0x9B,0x93,0x89,0x79,0x6E,0x64,
		0x58,0x4D,0x48,0x43,0x80,0x20,0x2C,0x1E,0x1A,0x25,
		0x29,0x36,0x44,0x51,0x5B,0x68,0x74,0x80,0x8C,0x97,
		0x9F,0xA8,0xB1,0xB5,0xB6,0xB9,0xBA,0xB7,0xB5,0xB3,
		0xAF,0xA9,0xA4,0x9E,0x99,0x95,0x92,0x8C,0x8B,0x8A,
		0xD3,0x4F,0x94,0x8D,0x5A,0x41,0x56,0x44,0x5B,0x5C,
		0x68,0x70,0x77,0x80,0x85,0x8C,0x89,0x47,0xD5,0x93,
		0xCC,0xB6,0xB6,0xB3,0xA2,0x9D,0x8F,0x86,0x7D,0x72,
		0x67,0x5D,0x56,0x4D,0x46,0x46,0x74,0x50,0x18,0x37,
		0x23,0x2E,0x38,0x46,0x50,0x5D,0x6A,0x74,0x81,0x8B,
		0x95,0x9E,0xA6,0xAE,0xB4,0xB7,0xB8,0xB9,0xB7,0xB7,
		0xB1,0xAE,0xAA,0xA5,0xA1,0x9C,0x98,0x91,0x8F,0x8A,
		0x85,0x83,0x81,0x7E,0x7E,0x83,0xD5,0x7C,0x71,0x9D,
		0x39,0x5E,0x4B,0x4D,0x58,0x5F,0x69,0x70,0x78,0x80,
		0x84,0x8D,0x91,0x94,0x82,0x89,0x8F,0xB7,0xB9,0xAA,
		0xA9,0x9E,0x95,0x8B,0x80,0x77,0x6D,0x63,0x5C,0x54,
		0x4D,0x49,0x44,0x42,0x42,0x47,0x88,0x3F,0x3E,0x44,
		0x36,0x54,0x4E,0x67,0x6B,0x7E,0x85,0x90,0x9A,0xA1,
		0xA8,0xAD,0xB3,0xB9,0xBC,0xBD,0xBD,0xBC,0xB9,0xB5,
		0xB2,0xAD,0xAB,0xA4,0x9E,0x99,0x93,0x8F,0x89,0x85,
		0x81,0x7C,0x7A,0x77,0x76,0x74,0x72,0x73,0xA5,0x52,
		0x62,0x69,0x67,0x54,0x45,0x43,0x4D,0x54,0x5D,0x65,
		0x6D,0x75,0x7C,0x81,0x87,0x8C,0x8B,0x39,0xAF,0xAB,
		0xB2,0xAA,0xA8,0xA2,0x9A,0x90,0x87,0x81,0x79,0x71,
		0x68,0x61,0x5B,0x56,0x53,0x52,0x51,0x52,0x58,0xAF,
		0x35,0x47,0x46,0x4F,0x58,0x63,0x6E,0x79,0x85,0x8D,
		0x96,0x9F,0xA4,0xAB,0xB3,0xB6,0xB9,0xBB,0xBC,0xB8,
		0xB5,0xB5,0xAF,0xAB,0xA8,0xA2,0x9D,0x97,0x92,0x8A,
		0x85,0x80,0x80,0x80,0x80,0x80,0x80,0x80,};
static ymu8	sample09[4231]={
		0x7E,0x7E,0x7C,0x7E,0x7E,0x80,0x7A,0x7C,0x70,0x70,
		0x74,0x62,0x6A,0x62,0x74,0x6E,0x72,0x6C,0x6C,0x6C,
		0x64,0x62,0x5A,0x58,0x52,0x54,0x50,0x4E,0x4E,0x4E,
		0x4E,0x52,0x52,0x58,0x60,0x6C,0x76,0x86,0x90,0xA6,
		0xB4,0xBE,0xCE,0xD8,0xE2,0xE8,0xF4,0xEA,0xEE,0xE0,
		0xDC,0xD8,0xCA,0xC6,0xB0,0xB0,0x94,0x84,0x7A,0x66,
		0x62,0x4A,0x4C,0x4A,0x42,0x42,0x34,0x2E,0x3A,0x2C,
		0x38,0x24,0x30,0x2E,0x40,0x46,0x42,0x4A,0x54,0x56,
		0x6E,0x72,0x70,0x74,0x70,0x7E,0x70,0x7C,0x7E,0x82,
		0x82,0x92,0xA2,0xC0,0xEA,0xFF,0xFF,0xFF,0xFF,0xFF,
		0xFF,0xFF,0xFA,0xFF,0xF2,0xFF,0xFF,0xFF,0xFF,0xFF,
		0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFC,0xF8,0xEC,0xDE,
		0xD8,0xDA,0xDA,0xE4,0xD2,0xDC,0xDC,0xC4,0xC8,0xA2,
		0x96,0x76,0x44,0x32,0x00,0x00,0x00,0x00,0x00,0x00,
		0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
		0x00,0x00,0x00,0x00,0x00,0x00,0x04,0x10,0x18,0x22,
		0x1A,0x22,0x16,0x0C,0x02,0x00,0x00,0x00,0x00,0x00,
		0x00,0x08,0x0C,0x18,0x2E,0x2A,0x42,0x3A,0x4C,0x4A,
		0x50,0x54,0x50,0x64,0x58,0x7C,0x74,0x9C,0x9C,0xAA,
		0xAA,0xAC,0xAE,0xBC,0xCA,0xCA,0xDA,0xD4,0xE6,0xF0,
		0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
		0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFE,
		0xF4,0xF6,0xEA,0xE0,0xC6,0xB6,0x94,0x84,0x6E,0x5E,
		0x54,0x44,0x34,0x36,0x34,0x44,0x4A,0x5A,0x5E,0x62,
		0x68,0x6A,0x7A,0x7C,0x86,0x90,0x9E,0xAA,0xA6,0xB4,
		0xB0,0xC8,0xC8,0xD8,0xC8,0xD6,0xCC,0xCE,0xB0,0x9C,
		0x6E,0x60,0x46,0x44,0x36,0x36,0x30,0x3E,0x42,0x54,
		0x50,0x60,0x56,0x5C,0x4C,0x48,0x46,0x46,0x4A,0x58,
		0x5E,0x6A,0x70,0x7E,0x88,0x9C,0xA2,0xB8,0xBA,0xCE,
		0xC0,0xAE,0x86,0x68,0x4E,0x50,0x44,0x50,0x4E,0x5E,
		0x72,0x82,0x9A,0x98,0xA6,0x98,0x98,0x8C,0x7E,0x78,
		0x78,0x82,0x8C,0x96,0x9C,0x98,0xAC,0xAA,0xBA,0xB6,
		0xC4,0xBA,0xBA,0x8C,0x66,0x34,0x18,0x12,0x0E,0x1E,
		0x26,0x36,0x50,0x62,0x7C,0x80,0x8A,0x84,0x7E,0x78,
		0x66,0x64,0x6C,0x76,0x92,0x98,0xB4,0xB8,0xC4,0xCE,
		0xD6,0xE2,0xE0,0xDE,0xBC,0x7E,0x52,0x18,0x18,0x0A,
		0x12,0x20,0x26,0x4C,0x5C,0x78,0x80,0x7E,0x86,0x76,
		0x70,0x56,0x4A,0x4C,0x52,0x72,0x7E,0x9E,0xAC,0xC0,
		0xD0,0xDA,0xEE,0xEA,0xE2,0xA8,0x6A,0x40,0x18,0x1C,
		0x0C,0x18,0x2A,0x46,0x74,0x86,0x9C,0xA4,0xA6,0xAE,
		0x98,0x86,0x68,0x5A,0x64,0x68,0x82,0x94,0xB0,0xC8,
		0xD4,0xF0,0xEA,0xFF,0xF4,0xEA,0xA4,0x6C,0x34,0x1C,
		0x12,0x06,0x10,0x1A,0x42,0x68,0x7E,0x94,0x90,0x9C,
		0x96,0x84,0x6E,0x48,0x44,0x44,0x50,0x54,0x7E,0xA2,
		0xBC,0xCC,0xEA,0xFF,0xFF,0xFC,0xCC,0x6A,0x46,0x18,
		0x00,0x00,0x00,0x26,0x46,0x74,0x8C,0x96,0xB6,0xA4,
		0x8C,0x74,0x4C,0x48,0x26,0x2A,0x3A,0x5A,0x8A,0xA0,
		0xC8,0xE8,0xF6,0xFF,0xFF,0xFF,0xFF,0xBE,0x3C,0x2E,
		0x00,0x00,0x00,0x00,0x4A,0x72,0xA2,0xB2,0xC0,0xE0,
		0xA0,0x74,0x50,0x32,0x22,0x00,0x16,0x4C,0x68,0x96,
		0xAC,0xEA,0xFF,0xFC,0xFF,0xFF,0xFF,0xFF,0xB2,0x36,
		0x4C,0x00,0x00,0x00,0x00,0x60,0x64,0x8A,0xD0,0xD4,
		0xD6,0x9E,0x80,0x78,0x32,0x0C,0x0A,0x20,0x44,0x48,
		0x82,0xBE,0xD4,0xEA,0xFA,0xFF,0xFF,0xFF,0xFF,0xF2,
		0x52,0x5A,0x1E,0x00,0x00,0x00,0x2E,0x50,0x5A,0xBA,
		0xD6,0xCC,0xC6,0xA0,0xA0,0x5E,0x24,0x1E,0x18,0x18,
		0x30,0x54,0x9A,0xAC,0xD4,0xF8,0xFF,0xFF,0xFF,0xFF,
		0xFF,0x9A,0x62,0x62,0x00,0x00,0x00,0x00,0x1E,0x2C,
		0x72,0xCE,0xB4,0xC8,0xD6,0xC0,0x9E,0x5E,0x46,0x32,
		0x02,0x14,0x30,0x5A,0x82,0xA4,0xDA,0xFE,0xFF,0xFF,
		0xFF,0xFF,0xFE,0x84,0x9C,0x36,0x00,0x00,0x00,0x00,
		0x06,0x2A,0x78,0x9E,0xA4,0xE0,0xD2,0xC6,0xB2,0x7E,
		0x5E,0x2C,0x14,0x2A,0x22,0x50,0x7E,0xA6,0xCE,0xF6,
		0xFF,0xFF,0xFF,0xFF,0xAC,0xCE,0x70,0x00,0x0C,0x00,
		0x00,0x00,0x00,0x32,0x62,0x7C,0xB4,0xC0,0xD0,0xD2,
		0xAC,0xA0,0x64,0x4A,0x44,0x2E,0x48,0x6A,0x7C,0xAC,
		0xD2,0xFF,0xFF,0xFF,0xFF,0xD2,0xE0,0x58,0x46,0x2A,
		0x00,0x00,0x00,0x00,0x1C,0x3A,0x60,0x86,0x9E,0xC0,
		0xB6,0xBA,0xAA,0x86,0x80,0x6C,0x5A,0x7C,0x74,0x94,
		0xBC,0xD6,0xF0,0xFF,0xBA,0xF0,0xBC,0x4E,0x90,0x2E,
		0x04,0x2C,0x04,0x0C,0x30,0x36,0x4A,0x62,0x90,0x7A,
		0xA0,0xAC,0x84,0x96,0x94,0x6C,0x88,0x8C,0x8A,0xA2,
		0xC0,0xD6,0xE2,0xFF,0xAA,0xDC,0xC4,0x3C,0x94,0x32,
		0x04,0x34,0x14,0x02,0x40,0x34,0x52,0x54,0x9A,0x6E,
		0x96,0xAA,0x7A,0x8A,0x9C,0x5A,0x90,0x86,0x86,0xA0,
		0xBE,0xBC,0xE8,0xFA,0xD8,0xB4,0xFF,0x56,0x82,0x74,
		0x0A,0x28,0x32,0x00,0x2A,0x30,0x36,0x4A,0x7C,0x72,
		0x88,0xA6,0x8E,0x86,0xAA,0x70,0x84,0x8C,0x84,0x90,
		0xB4,0xAC,0xD4,0xE6,0xFA,0x98,0xFC,0xAE,0x4C,0xB8,
		0x2C,0x1E,0x50,0x06,0x10,0x38,0x26,0x32,0x58,0x76,
		0x50,0xA8,0x8A,0x76,0xB0,0x80,0x7E,0xA2,0x7E,0x98,
		0xAE,0xB2,0xC4,0xDE,0xFA,0xB4,0xC0,0xF4,0x2E,0xBA,
		0x5A,0x16,0x54,0x26,0x02,0x3E,0x20,0x32,0x40,0x74,
		0x4C,0x8A,0x94,0x74,0xA2,0x96,0x72,0xAA,0x80,0x92,
		0xA0,0xAE,0xB0,0xDA,0xDA,0xF8,0x9C,0xFC,0x94,0x68,
		0xB8,0x26,0x4A,0x44,0x0E,0x28,0x2C,0x28,0x2E,0x58,
		0x5A,0x56,0x9E,0x72,0x90,0xA4,0x7A,0x9C,0x92,0x88,
		0x9C,0xA0,0xAE,0xC4,0xD4,0xF4,0xC2,0xC4,0xF2,0x40,
		0xCA,0x4E,0x36,0x58,0x22,0x1A,0x34,0x26,0x2E,0x3C,
		0x68,0x44,0x8A,0x82,0x74,0xA8,0x88,0x86,0xA4,0x80,
		0x9E,0x96,0xAE,0xAC,0xD4,0xD2,0xF0,0xA0,0xFE,0x92,
		0x7A,0xB0,0x2A,0x5E,0x3A,0x24,0x24,0x36,0x2A,0x28,
		0x5E,0x46,0x5C,0x92,0x60,0x98,0x92,0x84,0x9A,0x90,
		0x90,0x98,0xA4,0xA8,0xBE,0xD2,0xDA,0xDA,0xA8,0xFC,
		0x5E,0xAC,0x76,0x3A,0x5A,0x30,0x2C,0x2A,0x36,0x2A,
		0x36,0x60,0x40,0x76,0x7A,0x6E,0x98,0x86,0x8C,0x98,
		0x8E,0x9A,0x98,0xB0,0xA8,0xCE,0xCE,0xE8,0xBA,0xC8,
		0xD4,0x5A,0xC0,0x4E,0x52,0x4E,0x32,0x28,0x30,0x3A,
		0x22,0x48,0x58,0x3C,0x8C,0x64,0x7C,0x94,0x7E,0x90,
		0x90,0x90,0x96,0x9C,0xAE,0xA2,0xDA,0xBC,0xEE,0xAC,
		0xD0,0xC2,0x64,0xC0,0x42,0x60,0x50,0x30,0x34,0x34,
		0x36,0x2A,0x4A,0x52,0x44,0x88,0x62,0x88,0x90,0x86,
		0x94,0x90,0x92,0x96,0x9A,0xAE,0x9E,0xD0,0xBA,0xDC,
		0xBE,0xB6,0xD0,0x66,0xB0,0x62,0x4E,0x64,0x2E,0x3E,
		0x32,0x3A,0x30,0x3E,0x58,0x46,0x72,0x78,0x72,0x98,
		0x84,0x8A,0x90,0x8E,0x92,0x98,0xA6,0x9C,0xB0,0xC8,
		0xB0,0xE2,0x96,0xD0,0x9E,0x70,0xAE,0x48,0x68,0x56,
		0x36,0x4C,0x32,0x46,0x30,0x48,0x5C,0x46,0x86,0x6E,
		0x7C,0x94,0x78,0x96,0x7E,0x90,0x94,0x8C,0xA6,0x98,
		0xAE,0xB4,0xB8,0xD0,0xA4,0xB4,0xC0,0x68,0xAA,0x6E,
		0x58,0x68,0x48,0x46,0x3C,0x46,0x40,0x36,0x6C,0x4C,
		0x6E,0x86,0x6A,0x8A,0x8C,0x78,0x8C,0x96,0x7E,0x90,
		0xA8,0x86,0xA4,0xB2,0xA6,0xB4,0xCA,0xAC,0x9C,0xC6,
		0x82,0x80,0x90,0x5E,0x54,0x58,0x42,0x38,0x40,0x52,
		0x36,0x5E,0x72,0x56,0x80,0x8C,0x66,0x90,0x90,0x6C,
		0x94,0x86,0x84,0x92,0x96,0x9A,0x90,0xAE,0xA2,0xA6,
		0xC4,0xAE,0x9C,0xBC,0x94,0x72,0x90,0x58,0x4E,0x54,
		0x3E,0x40,0x40,0x58,0x54,0x58,0x7E,0x6C,0x74,0x8E,
		0x78,0x80,0x88,0x78,0x7E,0x82,0x8A,0x80,0x96,0x96,
		0x8A,0x9E,0xAA,0x8A,0xC0,0xA4,0xB2,0x9A,0xA4,0x94,
		0x6A,0x84,0x64,0x42,0x64,0x44,0x4A,0x54,0x5E,0x66,
		0x5C,0x84,0x7A,0x6A,0x98,0x76,0x7E,0x86,0x7A,0x80,
		0x80,0x82,0x92,0x7C,0xA0,0x86,0x9C,0x92,0x92,0xA4,
		0x8C,0xA2,0x9A,0x94,0x8E,0x8C,0x7E,0x72,0x6A,0x6C,
		0x5C,0x62,0x60,0x66,0x6A,0x6A,0x76,0x78,0x72,0x7A,
		0x7A,0x7E,0x7E,0x7E,0x82,0x7A,0x84,0x7E,0x84,0x8A,
		0x86,0x8C,0x88,0x86,0x8A,0x8C,0x86,0x88,0x8A,0x94,
		0x86,0x90,0x84,0x88,0x84,0x7E,0x7E,0x64,0x68,0x60,
		0x50,0x64,0x58,0x60,0x6C,0x5C,0x78,0x6C,0x7C,0x7C,
		0x68,0x80,0x70,0x78,0x74,0x84,0x74,0x7C,0x70,0x88,
		0x60,0xA4,0x70,0xA4,0x9C,0x8C,0xA0,0x94,0xC0,0x88,
		0xA4,0x8C,0x7C,0x84,0x7C,0x78,0x6C,0x74,0x6C,0x70,
		0x6C,0x74,0x70,0x68,0x70,0x64,0x64,0x58,0x70,0x5C,
		0x60,0x7C,0x68,0x7C,0x74,0x84,0x8C,0x8C,0x90,0xA0,
		0x88,0x94,0x88,0x94,0x90,0x8C,0x88,0x88,0x8C,0x94,
		0x88,0x9C,0x88,0x9C,0x80,0x88,0x84,0x74,0x7C,0x6C,
		0x6C,0x5C,0x60,0x6C,0x60,0x6C,0x78,0x64,0x80,0x6C,
		0x90,0x68,0x84,0x7C,0x7C,0x84,0x84,0x80,0x80,0x78,
		0x90,0x7C,0x94,0x84,0x88,0x8C,0x84,0x80,0x94,0x78,
		0x88,0x68,0x94,0x70,0x80,0x94,0x70,0x88,0x7C,0x74,
		0x80,0x6C,0x90,0x64,0x7C,0x88,0x6C,0x74,0x60,0x7C,
		0x78,0x64,0x8C,0x84,0x60,0x98,0x50,0x90,0x60,0x8C,
		0x74,0x68,0x8C,0x70,0x8C,0x80,0x80,0x88,0x7C,0x90,
		0x80,0x90,0x88,0x7C,0x7C,0x90,0x70,0x8C,0x78,0x8C,
		0x78,0x84,0x80,0x70,0x8C,0x6C,0x88,0x78,0x80,0x7C,
		0x6C,0x70,0x70,0x80,0x68,0x78,0x80,0x78,0x6C,0x90,
		0x74,0x80,0x74,0x94,0x70,0x80,0x8C,0x8C,0x80,0x78,
		0x90,0x68,0x80,0x8C,0x90,0x7C,0x80,0x94,0x6C,0x80,
		0x88,0x74,0x88,0x64,0x88,0x68,0x78,0x78,0x78,0x7C,
		0x70,0x8C,0x74,0x7C,0x78,0x80,0x78,0x80,0x6C,0x88,
		0x7C,0x6C,0x8C,0x7C,0x80,0x70,0x88,0x8C,0x80,0x7C,
		0x84,0x7C,0x7C,0x5C,0x90,0x74,0x7C,0x78,0x6C,0x80,
		0x70,0x74,0x84,0x80,0x80,0x74,0x80,0x90,0x5C,0x8C,
		0x74,0x74,0x88,0x68,0x90,0x74,0x70,0x98,0x70,0x90,
		0x70,0x88,0x84,0x68,0x6C,0x88,0x68,0x80,0x6C,0x84,
		0x78,0x78,0x70,0x84,0x68,0x74,0x60,0x78,0x70,0x68,
		0x68,0x88,0x70,0x70,0x78,0x80,0x7C,0x74,0x78,0x80,
		0x80,0x70,0x84,0x7C,0x84,0x78,0x7C,0x78,0x88,0x84,
		0x8C,0x90,0x90,0x94,0x98,0x98,0x94,0x94,0x94,0x94,
		0x9C,0x9C,0x98,0x98,0xA8,0xA0,0xA4,0xA8,0xA8,0xA4,
		0xA8,0xAC,0xA0,0x9C,0x94,0xAC,0xA0,0x8C,0xA4,0xA8,
		0xA8,0x98,0x9C,0x98,0x88,0x9C,0x8C,0x8C,0x8C,0x78,
		0x80,0x74,0x68,0x58,0x58,0x58,0x48,0x4C,0x50,0x48,
		0x44,0x44,0x58,0x48,0x44,0x4C,0x4C,0x5C,0x54,0x5C,
		0x60,0x64,0x70,0x70,0x70,0x7C,0x80,0x84,0x90,0x90,
		0x90,0x8C,0x90,0x84,0x84,0x7C,0x80,0x7E,0x7E,0x7E,
		0x7A,0x7E,0x7A,0x7C,0x7C,0x74,0x74,0x74,0x74,0x74,
		0x76,0x74,0x74,0x7A,0x7A,0x7A,0x80,0x7C,0x80,0x82,
		0x82,0x82,0x82,0x84,0x80,0x80,0x7E,0x7E,0x7A,0x7E,
		0x7E,0x7E,0x7E,0x80,0x80,0x7E,0x80,0x80,0x80,0x80,
		0x82,0x82,0x84,0x86,0x88,0x88,0x8A,0x8E,0x8C,0x8A,
		0x8E,0x8E,0x8A,0x8A,0x8A,0x88,0x88,0x84,0x84,0x82,
		0x80,0x7E,0x7E,0x7C,0x7C,0x7C,0x78,0x78,0x76,0x76,
		0x70,0x70,0x70,0x6E,0x6C,0x6E,0x70,0x6E,0x6C,0x6E,
		0x6E,0x74,0x72,0x74,0x76,0x76,0x7A,0x7C,0x7C,0x80,
		0x80,0x82,0x84,0x84,0x86,0x84,0x84,0x8A,0x8A,0x88,
		0x86,0x84,0x80,0x7A,0x7A,0x7A,0x7A,0x7A,0x78,0x74,
		0x72,0x72,0x72,0x74,0x76,0x7A,0x7A,0x7A,0x7C,0x7C,
		0x80,0x80,0x84,0x86,0x84,0x86,0x86,0x88,0x88,0x8A,
		0x8A,0x8C,0x8E,0x90,0x8E,0x8A,0x86,0x7E,0x78,0x74,
		0x74,0x72,0x72,0x70,0x72,0x6E,0x6E,0x70,0x72,0x72,
		0x72,0x72,0x74,0x76,0x76,0x7A,0x7A,0x7A,0x7C,0x80,
		0x82,0x84,0x86,0x8A,0x8A,0x8C,0x8C,0x90,0x92,0x96,
		0x96,0x94,0x8E,0x86,0x7E,0x76,0x76,0x76,0x78,0x78,
		0x78,0x76,0x76,0x76,0x76,0x78,0x7A,0x78,0x78,0x78,
		0x78,0x7A,0x7A,0x7A,0x7C,0x7C,0x7E,0x80,0x82,0x84,
		0x86,0x88,0x8A,0x8C,0x92,0x94,0x94,0x92,0x88,0x7E,
		0x72,0x6A,0x6C,0x72,0x7A,0x7C,0x7C,0x7C,0x7C,0x7E,
		0x82,0x82,0x84,0x84,0x82,0x82,0x84,0x86,0x88,0x8A,
		0x8A,0x8A,0x8A,0x8A,0x8E,0x90,0x92,0x94,0x96,0x9A,
		0xA0,0xA2,0x9E,0x94,0x84,0x74,0x64,0x5E,0x5C,0x62,
		0x70,0x76,0x78,0x76,0x74,0x76,0x78,0x7C,0x7A,0x78,
		0x76,0x70,0x72,0x74,0x7A,0x7C,0x7E,0x82,0x84,0x8A,
		0x90,0x94,0x9C,0x9E,0xA6,0xAC,0xAE,0xAC,0xA4,0x92,
		0x80,0x6E,0x62,0x5E,0x62,0x6A,0x76,0x80,0x84,0x86,
		0x88,0x8A,0x90,0x90,0x8C,0x84,0x7A,0x74,0x72,0x7A,
		0x80,0x88,0x8E,0x8E,0x90,0x90,0x92,0x94,0x96,0x9A,
		0xA0,0xA8,0xA4,0x9A,0x82,0x66,0x4C,0x3C,0x38,0x3C,
		0x4C,0x5A,0x66,0x6E,0x72,0x76,0x7A,0x80,0x82,0x82,
		0x76,0x68,0x54,0x4A,0x48,0x5A,0x72,0x80,0x86,0x86,
		0x88,0x88,0x90,0x96,0xA2,0xB0,0xBA,0xBC,0xB2,0x98,
		0x74,0x50,0x38,0x30,0x3A,0x4E,0x62,0x76,0x80,0x84,
		0x88,0x8A,0x8E,0x90,0x90,0x82,0x6C,0x4E,0x34,0x26,
		0x2A,0x48,0x74,0x98,0xA8,0xA2,0x9A,0x92,0x94,0x9E,
		0xB4,0xC4,0xCE,0xBC,0x9E,0x6C,0x3A,0x1C,0x14,0x2A,
		0x4A,0x70,0x8C,0x98,0x9C,0x9A,0x98,0x9A,0x9C,0x9A,
		0x8A,0x6E,0x48,0x2A,0x1A,0x22,0x42,0x70,0x9E,0xBE,
		0xCA,0xC4,0xB0,0xA4,0x9C,0xA8,0xC0,0xD6,0xDA,0xBA,
		0x86,0x40,0x16,0x08,0x26,0x5A,0x90,0xB6,0xBE,0xB4,
		0xA2,0x90,0x90,0x92,0x94,0x84,0x66,0x3C,0x1C,0x14,
		0x28,0x5A,0x8C,0xB2,0xBE,0xBA,0xAC,0x9E,0x98,0xA0,
		0xB0,0xCC,0xDE,0xDE,0xAC,0x6C,0x18,0x00,0x00,0x14,
		0x60,0x9E,0xC8,0xC6,0xB4,0x9A,0x86,0x86,0x7E,0x74,
		0x58,0x36,0x22,0x1C,0x40,0x64,0x96,0xAC,0xAC,0xA0,
		0x88,0x82,0x84,0x9A,0xB2,0xC8,0xE4,0xF2,0xEE,0xBA,
		0x6C,0x0C,0x00,0x00,0x04,0x64,0xB0,0xE2,0xE4,0xC8,
		0xA6,0x86,0x74,0x5C,0x44,0x28,0x14,0x24,0x4A,0x86,
		0xB0,0xBE,0xA6,0x7E,0x66,0x5C,0x76,0x98,0xB6,0xCC,
		0xD4,0xE4,0xFC,0xFF,0xC8,0x62,0x00,0x00,0x00,0x0A,
		0x98,0xFC,0xFF,0xF6,0xB6,0x82,0x66,0x60,0x44,0x24,
		0x00,0x0E,0x4A,0x9A,0xDC,0xD8,0xA4,0x5C,0x30,0x40,
		0x68,0xA0,0xBA,0xC2,0xC2,0xC8,0xEE,0xFF,0xFF,0xC4,
		0x2C,0x00,0x00,0x00,0x58,0xF8,0xFF,0xFF,0xC6,0x88,
		0x86,0x72,0x52,0x02,0x00,0x00,0x54,0xD8,0xFF,0xEE,
		0x88,0x28,0x16,0x34,0x72,0x90,0x98,0xA0,0xAC,0xD0,
		0xE2,0xF0,0xFA,0xF8,0xD4,0x54,0x00,0x00,0x00,0x2A,
		0xBC,0xFF,0xFF,0xDE,0xA2,0x74,0x60,0x24,0x00,0x00,
		0x1A,0x94,0xEA,0xFF,0xB8,0x5A,0x22,0x1C,0x48,0x60,
		0x7C,0x92,0xAA,0xCC,0xCA,0xC6,0xB8,0xC6,0xF0,0xFF,
		0xDE,0x3C,0x00,0x00,0x00,0x86,0xF2,0xFF,0xCA,0xA8,
		0x9C,0x88,0x58,0x00,0x00,0x06,0x92,0xFF,0xFF,0xAE,
		0x46,0x26,0x36,0x4C,0x56,0x54,0x80,0xB0,0xCC,0xB8,
		0x8E,0x8C,0xAC,0xE4,0xFF,0xFF,0xE4,0x5C,0x00,0x00,
		0x00,0x50,0xA6,0xF2,0xEE,0xD4,0xBC,0x78,0x3A,0x00,
		0x00,0x2A,0x88,0xEC,0xEA,0xBE,0x62,0x30,0x28,0x20,
		0x40,0x60,0x9C,0xC2,0xAE,0x8E,0x6A,0x90,0xBE,0xDA,
		0xE0,0xD6,0xFA,0xF6,0x64,0x00,0x00,0x00,0x88,0xE6,
		0xFF,0xD0,0xC6,0xC2,0x78,0x0E,0x00,0x00,0x68,0xDE,
		0xFF,0xCE,0x96,0x5C,0x2E,0x22,0x00,0x34,0x88,0xC2,
		0xD2,0x80,0x66,0x70,0xA6,0xD0,0xBE,0xBC,0xD0,0xFF,
		0xFF,0x98,0x00,0x00,0x00,0x8C,0xCC,0xD6,0xE2,0xE6,
		0xF4,0x72,0x00,0x00,0x00,0x8A,0xCA,0xD4,0xDC,0xD4,
		0xCC,0x28,0x00,0x00,0x30,0xC0,0xAC,0x9C,0x9C,0x86,
		0x90,0x60,0x7A,0xBA,0xCA,0xE0,0xC2,0xF0,0xFF,0xD2,
		0x00,0x00,0x00,0x72,0xC8,0xB6,0xC6,0xF2,0xEE,0x74,
		0x00,0x00,0x14,0x8A,0xAE,0xB8,0xEA,0xFF,0xBA,0x2E,
		0x00,0x00,0x4C,0x82,0xA6,0xA8,0xC8,0xA2,0x42,0x36,
		0x68,0xC4,0xD4,0xAE,0xC8,0xE6,0xFF,0xFF,0x98,0x00,
		0x00,0x00,0x3C,0x7A,0xB4,0xFF,0xFF,0xB6,0x3A,0x00,
		0x0E,0x20,0x32,0x7C,0xE0,0xFF,0xE0,0x80,0x50,0x26,
		0x00,0x06,0x48,0x9E,0xC8,0x9E,0x98,0x6A,0x58,0x66,
		0x82,0xC4,0xCA,0xB8,0xC8,0xD0,0xFA,0xFC,0xB0,0x08,
		0x00,0x0C,0x28,0x62,0x9E,0xFF,0xFF,0xB4,0x58,0x2C,
		0x18,0x0E,0x0C,0x74,0xD8,0xEE,0xD6,0xAA,0x82,0x40,
		0x00,0x00,0x4A,0x78,0xA0,0xB0,0xC2,0xA4,0x48,0x50,
		0x76,0x92,0xA4,0xB0,0xE0,0xEE,0xD6,0xF8,0xFC,0x9E,
		0x00,0x00,0x18,0x1C,0x50,0xA6,0xFF,0xFF,0xAC,0x7C,
		0x4E,0x00,0x00,0x0C,0x80,0xB2,0xB6,0xE6,0xE8,0xA4,
		0x44,0x04,0x0A,0x24,0x1E,0x66,0xC2,0xC2,0xA4,0x84,
		0x84,0x7A,0x6A,0x98,0xB6,0xB0,0xC0,0xDA,0xF6,0xFC,
		0xD6,0x6A,0x00,0x10,0x02,0x0E,0x74,0xB6,0xDE,0xCC,
		0xB6,0xAE,0x54,0x10,0x20,0x2A,0x4C,0x70,0xAA,0xD2,
		0xBC,0xB2,0xA4,0x48,0x06,0x2A,0x1E,0x36,0x7C,0xAC,
		0xB8,0x98,0xA2,0xA2,0x6C,0x78,0x9A,0x9C,0xAC,0xC4,
		0xDA,0xE6,0xFA,0xDA,0x60,0x26,0x30,0x00,0x00,0x5A,
		0x8E,0xB4,0xCE,0xEC,0xCC,0x72,0x60,0x46,0x0A,0x16,
		0x46,0x6A,0x8E,0xB6,0xDA,0xC2,0x96,0x72,0x38,0x2E,
		0x10,0x2C,0x64,0x72,0xA4,0xBA,0xAC,0xAE,0xA0,0xA6,
		0x9A,0x8A,0xA2,0xA4,0xA8,0xD4,0xE6,0xC4,0x84,0x68,
		0x62,0x00,0x0C,0x48,0x34,0x62,0xB6,0xBC,0xBC,0xBE,
		0xA6,0x72,0x4A,0x4A,0x34,0x1E,0x52,0x6E,0x7E,0xAA,
		0xC4,0xAC,0x92,0x94,0x48,0x24,0x48,0x38,0x4A,0x7C,
		0x9C,0xAE,0xB8,0xBC,0xB2,0x9C,0xAC,0x9E,0x98,0xB2,
		0xC0,0xCA,0xBA,0x80,0x64,0x5C,0x14,0x2C,0x42,0x38,
		0x72,0xA0,0x9A,0xAE,0xB6,0x9A,0x78,0x66,0x5C,0x50,
		0x58,0x68,0x62,0x76,0x8C,0x84,0x8A,0x80,0x7A,0x84,
		0x62,0x64,0x64,0x5E,0x70,0x70,0x74,0x8C,0x96,0xA8,
		0xB4,0xB6,0xBC,0xB4,0xBC,0xBE,0xBC,0xAC,0x98,0x5E,
		0x6C,0x34,0x1E,0x4C,0x3A,0x50,0x7C,0x7C,0x90,0xA4,
		0x9A,0x9C,0x9C,0x8A,0x76,0x70,0x68,0x5A,0x5C,0x5E,
		0x56,0x70,0x7A,0x7A,0x84,0x90,0x7C,0x76,0x80,0x6A,
		0x72,0x76,0x6A,0x74,0x84,0x8E,0xA6,0xB4,0xB8,0xBA,
		0xC4,0xC2,0xC2,0xAE,0x9E,0x6E,0x76,0x46,0x30,0x48,
		0x2A,0x3E,0x5C,0x62,0x78,0x90,0x9A,0xA6,0xB2,0xAA,
		0x9A,0x9A,0x7C,0x62,0x60,0x4A,0x44,0x56,0x5C,0x6A,
		0x78,0x80,0x80,0x84,0x82,0x7C,0x7E,0x7E,0x7C,0x90,
		0x94,0xA4,0xA4,0xB0,0xB0,0xCC,0xD8,0xFF,0xFF,0xFF,
		0xD4,0x98,0x9C,0x24,0x28,0x00,0x00,0x04,0x14,0x20,
		0x4C,0x70,0x80,0xA0,0xBC,0xAC,0xC0,0xC0,0xA4,0xA4,
		0x90,0x70,0x68,0x54,0x34,0x30,0x2C,0x20,0x44,0x48,
		0x6C,0x88,0x88,0x94,0xA4,0x98,0xA0,0xA8,0x9C,0x9C,
		0xB8,0xB8,0xD8,0xEC,0xE0,0xD8,0xE0,0x8C,0x98,0x64,
		0x30,0x4C,0x20,0x20,0x30,0x28,0x1C,0x40,0x4C,0x50,
		0x8C,0xA4,0xB4,0xD4,0xC0,0xB8,0xB8,0x9C,0x7C,0x7C,
		0x5C,0x4C,0x48,0x3C,0x34,0x50,0x48,0x4C,0x70,0x64,
		0x70,0x7C,0x70,0x8C,0x9C,0xB0,0xBC,0xCC,0xC4,0xD8,
		0xDC,0xD0,0xBC,0xD8,0x9C,0x94,0x9C,0x44,0x6C,0x40,
		0x1C,0x1C,0x18,0x14,0x34,0x54,0x58,0x8C,0x98,0x94,
		0xC0,0xB4,0xA4,0xB8,0xA8,0x90,0x94,0x74,0x5C,0x68,
		0x4C,0x44,0x50,0x48,0x40,0x5C,0x50,0x5C,0x74,0x64,
		0x7C,0x94,0xA0,0xBC,0xC0,0xB8,0xB8,0xBC,0xAC,0xC8,
		0xC4,0xD4,0xA8,0xB0,0x8C,0x60,0x70,0x2C,0x2C,0x24,
		0x2C,0x30,0x4C,0x50,0x5C,0x78,0x74,0x90,0xA4,0xA0,
		0xB4,0xB4,0xA8,0xA0,0x9C,0x80,0x7C,0x70,0x58,0x5C,
		0x4C,0x44,0x3C,0x44,0x4C,0x54,0x68,0x6C,0x88,0x94,
		0xA0,0xAC,0xA8,0xAC,0xB4,0xBC,0xB8,0xCC,0xC4,0xC8,
		0xA4,0xA0,0x80,0x64,0x6C,0x40,0x40,0x38,0x40,0x38,
		0x4C,0x48,0x54,0x6C,0x70,0x8C,0x98,0x9C,0xA4,0xA8,
		0x9C,0x9C,0x9C,0x88,0x88,0x78,0x6C,0x70,0x5C,0x58,
		0x48,0x48,0x48,0x50,0x60,0x70,0x88,0x8C,0x98,0x9C,
		0x9C,0x9C,0xA4,0xA8,0xB8,0xC4,0xC4,0xD0,0xB8,0xA4,
		0x98,0x60,0x60,0x44,0x48,0x44,0x54,0x44,0x54,0x54,
		0x48,0x60,0x68,0x74,0x84,0x90,0x9C,0xA8,0xAC,0xA0,
		0xA0,0x8C,0x84,0x80,0x78,0x78,0x7C,0x68,0x68,0x60,
		0x58,0x5C,0x60,0x60,0x68,0x74,0x78,0x88,0x8C,0x90,
		0x9C,0x9C,0xA0,0xA8,0xAC,0xB4,0xB4,0xB0,0x9C,0xA4,
		0x7C,0x74,0x68,0x54,0x54,0x50,0x4C,0x44,0x5C,0x54,
		0x6C,0x70,0x70,0x7C,0x80,0x84,0x8C,0x9C,0xA0,0xA8,
		0xA4,0x94,0x94,0x80,0x70,0x6C,0x70,0x6C,0x78,0x78,
		0x74,0x78,0x70,0x68,0x6C,0x64,0x68,0x6C,0x70,0x78,
		0x80,0x84,0x8C,0x88,0x88,0x8C,0x8C,0x8C,0x94,0x94,
		0x94,0x9C,0x9C,0x94,0x98,0x84,0x80,0x74,0x6C,0x64,
		0x64,0x68,0x6C,0x74,0x70,0x74,0x74,0x6C,0x70,0x68,
		0x6C,0x78,0x84,0x8C,0x8C,0x90,0x8C,0x84,0x80,0x7C,
		0x78,0x80,0x80,0x80,0x84,0x80,0x80,0x78,0x68,0x68,
		0x70,0x70,0x78,0x70,0x70,0x78,0x80,0x80,0x88,0x88,
		0x88,0x88,0x88,0x80,0x88,0x80,0x78,0x70,0x78,0x78,
		0x80,0x80,0x80,0x78,0x78,0x68,0x60,0x60,0x68,0x68,
		0x70,0x78,0x80,0x80,0x80,0x80,0x78,0x70,0x80,0x78,
		0x80,0x80,0x88,0x88,0x88,0x80,0x80,0x80,0x78,0x80,
		0x78,0x80,0x80,0x80,0x78,0x68,0x70,0x70,0x70,0x70,
		0x78,0x78,0x80,0x78,0x78,0x78,0x70,0x68,0x68,0x60,
		0x70,0x70,0x78,0x70,0x78,0x78,0x78,0x70,0x78,0x78,
		0x80,0x80,0x80,0x78,0x80,0x88,0x88,0x80,0x80,0x78,
		0x80,0x80,0x78,0x78,0x80,0x78,0x78,0x78,0x78,0x78,
		0x78,0x78,0x70,0x78,0x80,0x78,0x70,0x78,0x78,0x70,
		0x78,0x78,0x78,0x80,0x88,0x80,0x88,0x80,0x80,0x80,
		0x80,0x80,0x80,0x80,0x78,0x80,0x88,0x80,0x78,0x70,
		0x68,0x68,0x70,0x78,0x80,0x80,0x88,0x88,0x88,0x88,
		0x80,0x78,0x78,0x78,0x80,0x78,0x80,0x78,0x80,0x80,
		0x88,0x80,0x80,0x78,0x80,0x78,0x78,0x80,0x80,0x88,
		0x88,0x80,0x80,0x78,0x80,0x78,0x78,0x80,0x88,0x88,
		0x88,0x80,0x80,0x78,0x70,0x68,0x70,0x78,0x80,0x80,
		0x80,0x80,0x80,0x80,0x80,0x78,0x80,0x78,0x80,0x78,
		0x80,0x80,0x80,0x80,0x80,0x78,0x78,0x70,0x70,0x78,
		0x80,0x80,0x80,0x88,0x88,0x80,0x70,0x68,0x68,0x68,
		0x70,0x78,0x88,0x80,0x88,0x80,0x88,0x80,0x78,0x78,
		0x78,0x70,0x78,0x78,0x80,0x80,0x80,0x78,0x70,0x70,
		0x78,0x80,0x78,0x80,0x80,0x80,0x80,0x78,0x70,0x70,
		0x70,0x78,0x80,0x78,0x80,0x78,0x80,0x78,0x80,0x78,
		0x80,0x78,0x78,0x78,0x78,0x70,0x78,0x70,0x78,0x70,
		0x78,0x78,0x80,0x78,0x80,0x78,0x80,0x78,0x80,0x78,
		0x78,0x70,0x78,0x80,0x80,0x80,0x80,0x78,0x80,0x78,
		0x78,0x78,0x80,0x78,0x78,0x70,0x78,0x78,0x78,0x70,
		0x78,0x78,0x78,0x80,0x88,0x80,0x88,0x80,0x80,0x78,
		0x78,0x80,0x80,0x78,0x80,0x78,0x80,0x78,0x78,0x70,
		0x78,0x78,0x80,0x80,0x80,0x80,0x80,0x80,0x78,0x70,
		0x78,0x80,0x78,0x80,0x88,0x80,0x88,0x80,0x78,0x70,
		0x70,0x70,0x78,0x70,0x78,0x70,0x78,0x78,0x80,0x78,
		0x80,0x78,0x80,0x80,0x80,0x88,0x80,0x80,0x80,0x78,
		0x80,0x78,0x80,0x78,0x78,0x70,0x78,0x70,0x78,0x78,
		0x78,0x78,0x78,0x78,0x78,0x80,0x78,0x70,0x78,0x78,
		0x80,0x80,0x88,0x80,0x88,0x80,0x80,0x78,0x70,0x68,
		0x70,0x68,0x70,0x78,0x80,0x78,0x80,0x78,0x80,0x78,
		0x80,0x78,0x80,0x80,0x80,0x80,0x80,0x78,0x80,0x78,
		0x78,0x70,0x78,0x78,0x80,0x78,0x80,0x78,0x78,0x70,
		0x78,0x70,0x78,0x78,0x80,0x78,0x78,0x80,0x88,0x80,
		0x80,0x80,0x80,0x78,0x80,0x78,0x80,0x78,0x80,0x78,
		0x78,0x78,0x80,0x78,0x80,0x78,0x80,0x78,0x80,0x80,
		0x80,0x80,0x80,0x78,0x78,0x78,0x80,0x78,0x80,0x78,
		0x80,0x78,0x78,0x70,0x70,0x70,0x78,0x80,0x88,0x80,
		0x88,0x78,0x80,0x78,0x78,0x78,0x80,0x80,0x88,0x80,
		0x88,0x80,0x80,0x78,0x78,0x70,0x78,0x78,0x80,0x78,
		0x80,0x78,0x78,0x70,0x78,0x70,0x78,0x70,0x80,0x78,
		0x80,0x78,0x80,0x78,0x80,0x78,0x80,0x78,0x80,0x78,
		0x78,0x70,0x78,0x78,0x80,0x78,0x80,0x78,0x80,0x78,
		0x78,0x70,0x80,0x78,0x88,0x80,0x80,0x78,0x78,0x70,
		0x78,0x70,0x80,0x78,0x80,0x78,0x80,0x70,0x80,0x60,
		0x80,0x40,0x78,0x58,0x80,0x80,0x80,0x90,0x78,0x98,
		0x80,0x98,0x80,0x90,0x78,0x80,0x78,0x78,0x60,0x70,
		0x78,0x70,0x80,0x70,0x80,0x70,0x78,0x78,0x78,0x70,
		0x70,0x88,0x88,0x80,0x78,0x70,0x80,0x80,0x90,0x70,
		0x78,0x70,0x80,0x78,0x78,0x88,0x78,0x70,0x78,0x88,
		0x80,0x88,0x88,0x80,0x90,0x70,0x88,0x68,0x80,0x78,
		0x68,0x70,0x88,0x68,0x78,0x98,0x88,0x80,0x90,0x70,
		0x78,0x88,0x88,0x78,0x88,0x78,0x80,0x80,0x78,0x88,
		0x50,0x40,0x88,0x68,0xB8,0x78,0xA0,0x50,0xB0,0x70,
		0xB0,0x38,0x68,0x70,0x70,0x98,0xA8,0x90,0x78,0xA0,
		0x80,0x88,0x88,0x98,0x88,0x68,0x88,0x80,0x60,0x68,
		0x80,0x80,0x70,0x80,0x60,0x68,0x80,0x80,0x78,0x80,
		0x78,0x88,0x80,0x78,0x88,0x88,0x80,0x80,0x78,0x78,
		0x78,0x80,0x78,0x98,0x70,0x80,0x78,0x68,0x78,0x88,
		0x78,0x88,0x78,0x80,0x80,0x80,0x88,0x80,0x78,0x70,
		0x78,0x78,0x80,0x88,0x70,0x88,0x80,0x88,0x78,0x90,
		0x78,0x78,0x80,0x80,0x78,0x80,0x80,0x88,0x88,0x90,
		0x80,0x88,0x80,0x78,0x88,0x70,0x78,0x88,0x78,0x80,
		0x80,0x80,0x78,0x78,0x78,0x68,0x78,0x78,0x90,0x80,
		0x80,0x88,0x78,0x78,0x88,0x70,0x80,0x80,0x88,0x80,
		0x80,0x88,0x70,0x80,0x68,0x80,0x80,0x80,0x78,0x80,
		0x80,0x80,0x78,0x88,0x68,0x78,0x80,0x80,0x78,0x80,
		0x80,0x78,0x80,0x78,0x78,0x78,0x78,0x88,0x70,0x80,
		0x78,0x88,0x78,0x70,0x80,0x78,0x80,0x78,0x80,0x80,
		0x70,0x80,0x80,0x80,0x80,0x80,0x78,0x78,0x70,0x80,
		0x80,0x88,0x78,0x90,0x80,0x78,0x80,0x78,0x78,0x70,
		0x70,0x88,0x78,0x80,0x80,0x80,0x80,0x70,0x80,0x78,
		0x78,0x78,0x84,0x80,0x7C,0x80,0x80,0x7C,0x7C,0x80,
		0x80,0x80,0x80,0x88,0x80,0x84,0x7C,0x80,0x78,0x7C,
		0x7C,0x7C,0x80,0x7C,0x80,0x7C,0x80,0x7C,0x80,0x84,
		0x78,0x84,0x7C,0x80,0x7C,0x7C,0x80,0x7C,0x7C,0x7C,
		0x7C,0x80,0x7C,0x80,0x80,0x7C,0x80,0x80,0x80,0x7C,
		0x7C,0x80,0x7C,0x80,0x7C,0x80,0x80,0x80,0x80,0x80,
		0x84,0x7C,0x7C,0x80,0x7C,0x80,0x80,0x84,0x7C,0x7C,
		0x80,0x7C,0x80,0x7C,0x80,0x80,0x7C,0x80,0x7C,0x80,
		0x7C,0x80,0x80,0x7C,0x80,0x80,0x80,0x80,0x80,0x84,
		0x7C,0x80,0x7C,0x80,0x80,0x7C,0x80,0x7C,0x80,0x80,
		0x7C,0x80,0x7C,0x80,0x7C,0x80,0x80,0x7C,0x80,0x7C,
		0x80,0x80,0x7C,0x7C,0x80,0x80,0x7C,0x7C,0x7C,0x7C,
		0x7C,0x7C,0x80,0x80,0x7C,0x80,0x7C,0x80,0x7C,0x80,
		0x7C,0x7C,0x7C,0x7C,0x7C,0x80,0x7C,0x7C,0x7C,0x80,
		0x80,0x80,0x80,0x80,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,
		0x7C,0x80,0x7C,0x7C,0x7C,0x7C,0x7C,0x80,0x7C,0x80,
		0x7C,0x80,0x80,0x80,0x7C,0x80,0x7C,0x7C,0x7C,0x80,
		0x7C,0x80,0x7E,0x80,0x80,0x80,0x80,0x80,0x80,0x80,
		0x80,};
static ymu8	sample10[378]={
		0x80,0x80,0xCE,0xD4,0xFA,0xFF,0xFF,0xBE,0x9E,0xFF,
		0xFF,0x00,0xFF,0x5E,0xFF,0xFF,0x18,0xDC,0x00,0x9E,
		0x00,0x14,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
		0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
		0x2C,0x1C,0x52,0x66,0xA2,0xCC,0xFF,0xFF,0xFF,0xFF,
		0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
		0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xF4,0xFF,
		0x92,0xA8,0x56,0x1C,0x00,0x00,0x00,0x00,0x00,0x00,
		0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
		0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
		0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x1A,0x36,
		0x5A,0x7A,0x98,0xA6,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
		0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
		0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
		0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
		0xFF,0xE6,0xAA,0x86,0x80,0x6C,0x40,0x24,0x00,0x00,
		0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
		0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
		0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
		0x08,0x20,0x62,0x76,0x6E,0x8A,0xB4,0xA4,0xCC,0xE2,
		0xE4,0xF6,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
		0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
		0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
		0xD6,0xD2,0xD4,0xB2,0xBE,0xB6,0x96,0x92,0x6E,0x70,
		0x52,0x58,0x58,0x3C,0x26,0x2C,0x0A,0x00,0x00,0x00,
		0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x0E,
		0x00,0x02,0x14,0x06,0x16,0x48,0x18,0x30,0x78,0x64,
		0x7C,0xBE,0x9A,0xA6,0xA8,0x9E,0x98,0x9C,0x92,0x74,
		0xA2,0xB6,0xB6,0x9A,0xBE,0xBE,0xA4,0xB0,0x86,0x8C,
		0xAC,0xB4,0xBA,0xA6,0xD2,0xC0,0xDC,0xD8,0xE8,0xDE,
		0xC2,0xAC,0x90,0x9C,0x9E,0x84,0x7A,0x7A,0x78,0x84,
		0x56,0x56,0x2C,0x44,0x4C,0x12,0x22,0x0C,0x30,0x12,
		0x24,0x00,0x00,0x16,0x00,0x00,0x00,0x00,0x06,0x16,
		0x14,0x3C,0x22,0x36,0x3A,0x46,0x30,0x58,0x5E,0x54,
		0x8C,0x84,0x6C,0x8A,0x9A,0x96,0xB0,0xBA,0xBA,0x98,
		0xAE,0xB2,0x96,0xB6,0xAE,0xB4,0xB8,0xB4,0xAE,0xAE,
		0xAE,0xB2,0xB4,0xD2,0xC6,0xBE,0xD2,0xC4,0xC4,0xB2,
		0xAC,0x80,0x80,0x80,0x80,0x80,0x80,0x80,};
static ymu8	sample11[1527]={
		0xA0,0x90,0xC4,0xB6,0x92,0xE8,0xFF,0xFF,0x52,0xFE,
		0x4E,0x86,0xAE,0xEC,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
		0xD6,0xFF,0xFF,0x00,0xBC,0x46,0x00,0x00,0x16,0x00,
		0x36,0x7E,0xDE,0xFE,0xFF,0xFF,0xFF,0xFF,0xBE,0xFF,
		0xFF,0xF6,0xFF,0xFF,0x98,0xFF,0xFF,0xFF,0xFF,0xFF,
		0xFF,0xFF,0xFF,0xFF,0xA4,0x86,0x66,0x00,0x00,0x1C,
		0x00,0x00,0x10,0x00,0x00,0x00,0x00,0x06,0x46,0x0E,
		0xAE,0xAE,0x4E,0xFF,0xFF,0xFF,0xCE,0xE8,0xB4,0xA6,
		0x92,0xBC,0xC6,0xA6,0xBA,0xB6,0x66,0x5A,0x3E,0x0A,
		0x04,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
		0x00,0x00,0x00,0x00,0x86,0x26,0xAE,0x2E,0x94,0x9E,
		0xEA,0xA0,0x8A,0xA4,0xA0,0x86,0x74,0xF4,0x60,0xB6,
		0xBE,0x9E,0x8E,0x72,0x86,0x00,0x00,0x00,0x00,0x00,
		0x00,0x00,0x00,0x1C,0x1E,0x00,0x0A,0x26,0x46,0x30,
		0x1C,0x60,0x92,0x26,0xE6,0x9A,0xE6,0xCA,0xFF,0xFF,
		0xFE,0xFF,0xD6,0xFF,0xFF,0xFF,0xE2,0xFF,0x8A,0x8A,
		0xA0,0x7C,0x4A,0x4E,0x5E,0x64,0x8E,0x4E,0x5A,0x72,
		0x6C,0x3A,0x12,0x32,0xCE,0x96,0xB8,0x9E,0xCC,0xD2,
		0xE6,0xE6,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
		0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xD6,0x7E,0xCA,
		0xFE,0xB4,0x6E,0x76,0x4C,0x96,0x60,0x1E,0x56,0x8A,
		0x62,0xF0,0x8A,0x3E,0xC6,0x56,0xC2,0x74,0x86,0xD2,
		0xE2,0xFF,0xFF,0xA6,0xFF,0xFF,0xD6,0xDE,0xAA,0xB8,
		0xFC,0xC0,0x86,0x9A,0x84,0x2C,0x44,0x52,0x48,0x5E,
		0x02,0x56,0x00,0x48,0x12,0x00,0x1E,0x12,0x00,0x16,
		0x14,0x00,0x12,0x0E,0x00,0x22,0x08,0x0E,0x0A,0x5E,
		0x8A,0x4A,0x9E,0x6E,0x86,0x60,0x76,0x5C,0x66,0x36,
		0x1C,0x4C,0x16,0x72,0x0E,0x00,0x0A,0x1A,0x02,0x00,
		0x00,0x00,0x00,0x06,0x0A,0x00,0x00,0x12,0x16,0x4E,
		0x22,0x20,0x72,0x56,0x64,0x4E,0x5E,0x9A,0x94,0x8E,
		0xA2,0x7A,0x7A,0x9A,0xAC,0xAE,0xA6,0xC2,0xAE,0xA6,
		0xBA,0x9E,0xDC,0x9E,0xC2,0x8E,0x6E,0x7C,0x80,0x9A,
		0x76,0x80,0x88,0x82,0xB0,0xD6,0x7E,0x94,0xBC,0xFC,
		0xD6,0xFF,0xF8,0xFF,0xE6,0xFF,0xB2,0xFC,0xBE,0xF4,
		0xFA,0xFF,0xFF,0xFF,0xFF,0xFF,0xF2,0xFF,0xD0,0xC8,
		0xAA,0xFF,0xDA,0xFF,0xC2,0xF0,0xEA,0xB0,0xD0,0xC8,
		0xEC,0xDE,0xF6,0xCA,0xEE,0xBE,0x8E,0x9E,0xBA,0x5E,
		0x8A,0xC8,0x9A,0xA8,0xDE,0x8C,0xB2,0x8A,0x96,0x70,
		0xA8,0x9A,0x92,0xAE,0xE6,0x82,0xA8,0x9E,0x22,0x5C,
		0x58,0x5E,0x30,0xA4,0x54,0x5E,0x32,0x6A,0x14,0x2C,
		0x6C,0x2C,0x36,0x00,0x00,0x00,0x00,0x4A,0x00,0x00,
		0x00,0x06,0x1C,0x00,0x06,0x00,0x14,0x00,0x32,0x20,
		0x40,0x4C,0x42,0x0A,0x2E,0x1C,0x0E,0x00,0x00,0x00,
		0x1A,0x00,0x00,0x00,0x00,0x00,0x1E,0x36,0x54,0x16,
		0x2A,0x12,0x2A,0x38,0x46,0x00,0x0C,0x24,0x1E,0x14,
		0x14,0x3C,0x18,0x3C,0x60,0x88,0x86,0x88,0x96,0xA6,
		0xBA,0x7C,0xBA,0x82,0xAC,0x82,0x84,0x80,0xA4,0x22,
		0xA4,0x8A,0xA2,0xC8,0xD6,0xBE,0xD6,0xB4,0xD4,0x9A,
		0xB6,0x98,0xA0,0xA6,0xB6,0xD0,0xAA,0xCC,0xC6,0xF6,
		0xE8,0xDC,0xDA,0xE6,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
		0xEA,0xFF,0xF6,0xFF,0xEA,0xE4,0xF6,0xF8,0xD4,0xD2,
		0xDA,0xDA,0xFE,0xF4,0xD8,0xD0,0xDA,0xBE,0xF2,0xE0,
		0xDA,0xBA,0xDE,0xD6,0xC6,0xFF,0xC6,0xE2,0xB6,0xB6,
		0x9E,0xB8,0xA8,0xB8,0x70,0xBA,0x96,0xDE,0xB6,0xA6,
		0x8E,0x9A,0x82,0x5E,0x42,0x74,0x64,0x6C,0xA4,0x68,
		0x7A,0x74,0x6E,0x56,0x00,0x22,0x50,0x4E,0x3E,0x5C,
		0x62,0x4C,0x30,0x12,0x00,0x34,0x00,0x00,0x0A,0x0E,
		0x1C,0x44,0x3C,0x5A,0x2E,0x3E,0x06,0x20,0x00,0x0E,
		0x12,0x30,0x36,0x00,0x0A,0x00,0x00,0x00,0x00,0x00,
		0x00,0x00,0x00,0x2E,0x30,0x5C,0x48,0x20,0x4C,0x28,
		0x0E,0x46,0x26,0x4C,0x2A,0x2C,0x54,0x40,0x26,0x00,
		0x34,0x58,0x64,0x40,0x62,0x18,0x46,0x58,0x3A,0x5A,
		0x2A,0x9A,0x6E,0x74,0xAC,0xBA,0xC8,0x9A,0xA0,0x98,
		0xB8,0xB4,0xCE,0xB6,0xD2,0x86,0xC0,0xA6,0xB6,0xDA,
		0xFF,0xFF,0xFF,0xFF,0xFF,0xD0,0xBA,0xAA,0xF4,0xFA,
		0xDE,0xC4,0xDE,0xCA,0xEA,0xF2,0xFF,0xF6,0xE8,0xFF,
		0xFF,0xE8,0xE8,0xDC,0xFF,0xFF,0xFF,0xFF,0xFE,0xFF,
		0xFF,0xFF,0xFF,0xFF,0xFC,0xFF,0xE6,0xFF,0xEA,0xD8,
		0xCA,0xCA,0xC6,0xC2,0xE6,0xA0,0xC2,0x96,0x7E,0xAE,
		0x58,0x8A,0x5E,0x6A,0x82,0x84,0x44,0x5C,0x86,0x5C,
		0x8C,0x9A,0x80,0x86,0x86,0x4C,0x60,0x7E,0x50,0x4C,
		0x36,0x6E,0x44,0x40,0x1C,0x3A,0x14,0x02,0x20,0x1A,
		0x3C,0x3A,0x04,0x2C,0x0A,0x1E,0x26,0x00,0x00,0x02,
		0x00,0x00,0x02,0x00,0x00,0x14,0x0C,0x10,0x00,0x00,
		0x00,0x16,0x1A,0x24,0x40,0x50,0x6A,0x44,0x2E,0x2C,
		0x38,0x28,0x38,0x38,0x6E,0x6A,0x5C,0x7E,0x40,0x44,
		0x34,0x2E,0x28,0x74,0x44,0x2A,0x3A,0x5C,0x66,0x84,
		0x88,0x74,0x78,0x9E,0x9E,0x9E,0x82,0x9A,0x82,0xA6,
		0x66,0xB0,0x9A,0xA2,0xA6,0xEE,0xB8,0xD4,0xD6,0x96,
		0xC6,0xB8,0xB4,0xA8,0xE2,0xB0,0xC8,0xA6,0xD2,0xD2,
		0xD4,0xDE,0xF6,0xCA,0xD0,0xBA,0xB4,0xC0,0xB6,0xB6,
		0xC6,0x9C,0xD4,0xDA,0xC0,0xA6,0xC2,0xC0,0xD2,0xA8,
		0xBC,0xB2,0x98,0xCA,0x80,0xCA,0xB2,0xF6,0xE2,0xC2,
		0xBC,0xD6,0xAE,0x86,0xB8,0x8E,0xBA,0xB0,0x80,0x92,
		0x58,0x9C,0x7E,0x82,0x74,0x72,0x82,0x6C,0x8A,0x7C,
		0x9A,0x7E,0x7A,0x7C,0x92,0x7C,0x78,0x96,0x80,0x7E,
		0x64,0x54,0x5A,0x4C,0x62,0x64,0x70,0x3E,0x68,0x6E,
		0x78,0x7A,0x76,0x58,0x4C,0x46,0x40,0x3C,0x2E,0x38,
		0x34,0x44,0x4C,0x28,0x52,0x50,0x46,0x48,0x64,0x4E,
		0x4E,0x50,0x62,0x32,0x46,0x66,0x60,0x66,0x80,0x7E,
		0x60,0x60,0x7E,0x52,0x6A,0x66,0x60,0x48,0x5A,0x50,
		0x66,0x5C,0x6A,0x4E,0x52,0x48,0x54,0x72,0x60,0x7A,
		0x72,0x7A,0x76,0x78,0x7C,0x7C,0x64,0x8A,0x6E,0x78,
		0x84,0x8E,0x98,0xB6,0x98,0xB8,0x92,0xA2,0x8E,0x86,
		0x72,0x80,0x82,0x88,0x84,0x96,0x78,0x88,0x7E,0x8A,
		0x8E,0x76,0x9C,0x98,0x98,0x7E,0x90,0x70,0x76,0x8C,
		0xA2,0xA6,0x8C,0xB2,0xA0,0xAE,0x92,0xA6,0x90,0x88,
		0x9C,0xAE,0xA8,0xBA,0xBA,0xA4,0xBC,0x9E,0x7E,0x7E,
		0x7E,0x86,0x96,0x72,0xA0,0x86,0x84,0xB6,0x8E,0x96,
		0x8E,0x9A,0xA2,0x8A,0x8E,0x80,0x76,0x82,0x8A,0x7A,
		0x80,0x64,0x80,0x96,0xA2,0x9E,0xAA,0xAC,0xA4,0xA4,
		0xA2,0x80,0x74,0x74,0x6A,0x78,0x6A,0x74,0x7C,0x7A,
		0x7E,0x60,0x80,0x72,0x6A,0x76,0x7E,0x80,0x5A,0x78,
		0x74,0x66,0x72,0x76,0x8A,0x6A,0x66,0x78,0x6C,0x68,
		0x80,0x86,0x68,0x86,0x92,0x8E,0x88,0x74,0x64,0x38,
		0x4A,0x4E,0x54,0x6E,0x5E,0x82,0x6E,0x7A,0x6A,0x9C,
		0x6C,0x80,0x74,0x78,0x90,0x82,0x7A,0x78,0x60,0x5E,
		0x5E,0x70,0x72,0x62,0x64,0x74,0x68,0x86,0x7A,0x9A,
		0x78,0x9C,0x80,0x9E,0x7C,0x5A,0x66,0x96,0x7A,0x88,
		0x88,0x9A,0x70,0x86,0x6C,0x6A,0x7A,0x64,0x8E,0x80,
		0x84,0x7A,0x84,0x82,0x92,0x9A,0x9E,0x8A,0xA0,0x9E,
		0x84,0x90,0x98,0x6E,0x7A,0x74,0x82,0x86,0x80,0x8E,
		0x92,0x84,0x84,0x7A,0x92,0x94,0x94,0xAC,0x8C,0x8E,
		0x7C,0x8C,0x94,0x80,0x88,0x68,0x7E,0x74,0x8C,0x8E,
		0x74,0x92,0x92,0x8E,0x94,0x72,0x92,0x8E,0x72,0x88,
		0x8A,0x84,0x88,0x8A,0x96,0x82,0x8C,0x84,0x84,0x9A,
		0x70,0x68,0x80,0x7A,0x66,0x82,0x7C,0x78,0x78,0x7C,
		0x74,0x6E,0x72,0x78,0x7A,0x88,0x7E,0x82,0x84,0x80,
		0x84,0x7C,0x8A,0x72,0x76,0x80,0x7C,0x80,0x82,0x82,
		0x80,0x8C,0x8C,0x80,0x84,0x76,0x7E,0x6C,0x7A,0x78,
		0x7A,0x7E,0x74,0x70,0x68,0x70,0x72,0x74,0x70,0x76,
		0x74,0x86,0x76,0x98,0x84,0x80,0x7C,0x6E,0x7C,0x82,
		0x7A,0x8E,0x88,0x8A,0x76,0x84,0x7C,0x8E,0x70,0x8C,
		0x8C,0x7E,0x8E,0x82,0x7E,0x84,0x68,0x66,0x78,0x80,
		0x92,0x84,0x82,0x74,0x7E,0x72,0x76,0x6C,0x6A,0x72,
		0x76,0x86,0x8E,0x8E,0x8A,0x86,0x86,0x70,0x84,0x78,
		0x92,0x8E,0x8E,0x90,0x8C,0x8E,0x7E,0x82,0x7C,0x82,
		0x70,0x80,0x74,0x72,0x6C,0x74,0x76,0x70,0x6E,0x7E,
		0x80,0x78,0x7A,0x88,0x82,0x92,0x82,0x8A,0x80,0x7A,
		0x88,0x86,0x7E,0x8A,0x86,0x88,0x96,0x8E,0x82,0x8C,
		0x76,0x8C,0x84,0xA0,0x88,0x86,0x7C,0x8A,0x82,0x7C,
		0x8C,0x60,0x7C,0x82,0x76,0x86,0x80,0x78,0x76,0x72,
		0x7E,0x78,0x78,0x7E,0x80,0x6E,0x7E,0x7E,0x8C,0x9E,
		0x86,0x92,0x8E,0x96,0x7C,0x82,0x78,0x7C,0x8A,0x82,
		0x86,0x76,0x80,0x76,0x80,0x7E,0x82,0x78,0x7C,0x80,
		0x7E,0x88,0x80,0x7E,0x70,0x86,0x7A,0x80,0x7C,0x74,
		0x76,0x7E,0x74,0x6C,0x70,0x7A,0x7A,0x86,0x82,0x86,
		0x8A,0x8A,0x86,0x88,0x78,0x82,0x78,0x82,0x74,0x7A,
		0x7C,0x76,0x84,0x7C,0x7A,0x8A,0x7C,0x84,0x7E,0x7E,
		0x80,0x7E,0x82,0x7A,0x7A,0x7A,0x6E,0x76,0x78,0x6E,
		0x7A,0x7C,0x86,0x78,0x8A,0x82,0x78,0x8E,0x80,0x8A,
		0x86,0x8A,0x8C,0x84,0x94,0x88,0x8E,0x84,0x7A,0x78,
		0x7A,0x84,0x80,0x7E,0x7C,0x86,0x7C,0x86,0x82,0x7C,
		0x7A,0x7A,0x76,0x76,0x7A,0x7E,0x84,0x84,0x80,0x7A,
		0x7C,0x7C,0x80,0x84,0x80,0x8C,0x82,0x86,0x82,0x86,
		0x7E,0x80,0x7C,0x84,0x8A,0x82,0x7E,0x88,0x7C,0x82,
		0x7A,0x86,0x78,0x7C,0x72,0x84,0x7E,0x7C,0x72,0x80,
		0x82,0x82,0x84,0x86,0x82,0x82,0x80,0x80,0x78,0x7A,
		0x7A,0x82,0x7E,0x7A,0x7E,0x72,0x78,0x84,0x82,0x84,
		0x86,0x8E,0x7E,0x78,0x7E,0x78,0x7A,0x7A,0x84,0x8C,
		0x8A,0x86,0x86,0x7E,0x7A,0x74,0x80,0x88,0x7E,0x80,
		0x7E,0x74,0x80,0x80,0x88,0x7A,0x80,0x76,0x7C,0x7E,
		0x80,0x80,0x80,0x80,0x80,0x80,0x80,};
static ymu8	sample12[258]={
		0x6F,0x77,0x80,0x5F,0x41,0x80,0xE0,0xFF,0x3F,0x01,
		0xC0,0xFF,0x07,0xC0,0xBF,0x00,0xFE,0x07,0xE0,0x3F,
		0xC0,0x3F,0xC0,0x3F,0xE0,0x07,0xFF,0x00,0xFF,0x40,
		0x3F,0xFF,0x00,0xBF,0xE0,0x00,0xFF,0xC0,0x00,0xFF,
		0xF0,0x00,0x80,0xFF,0x20,0x00,0xFF,0xF0,0x00,0x0F,
		0xFF,0xF0,0x00,0x01,0xDF,0xFF,0x80,0x00,0x3F,0xFF,
		0xFC,0x50,0x00,0x3F,0xDF,0xFF,0xA0,0x20,0x03,0x5F,
		0xDF,0xFC,0xB0,0x50,0x2B,0x77,0xC7,0xCC,0x94,0x60,
		0x30,0x1F,0x5F,0xAF,0xC4,0xB0,0x84,0x60,0x30,0x18,
		0x37,0x77,0xA7,0xDB,0xD8,0xB4,0x80,0x54,0x35,0x3F,
		0x5F,0x87,0xAF,0xDB,0xDA,0xC0,0x9A,0x78,0x58,0x42,
		0x47,0x5F,0x80,0x9B,0xBB,0xD6,0xCA,0xB8,0xA0,0x84,
		0x68,0x4C,0x45,0x4D,0x5F,0x73,0x87,0x9F,0xAF,0xC7,
		0xBC,0xA8,0x9C,0x88,0x70,0x58,0x4C,0x4A,0x49,0x53,
		0x69,0x75,0x85,0x97,0xAD,0xB3,0xB2,0xAA,0xA0,0x90,
		0x80,0x70,0x5C,0x51,0x48,0x49,0x49,0x4F,0x5E,0x6B,
		0x7B,0x8D,0x97,0x9F,0xAB,0xB0,0xAE,0xA8,0xA0,0x94,
		0x8B,0x80,0x70,0x65,0x60,0x58,0x53,0x52,0x52,0x57,
		0x5F,0x69,0x6D,0x7D,0x83,0x8F,0x97,0x9E,0xA4,0xA6,
		0xAD,0xA8,0xA5,0xA2,0x9A,0x93,0x8B,0x82,0x79,0x70,
		0x72,0x65,0x60,0x5B,0x55,0x52,0x4F,0x56,0x53,0x57,
		0x5B,0x5F,0x65,0x6F,0x71,0x7B,0x83,0x8B,0x92,0x9B,
		0xA1,0xA7,0xB2,0xB6,0xB5,0xB5,0xB4,0xB0,0xAB,0xA4,
		0x9C,0x94,0x92,0x82,0x81,0x79,0x71,0x77,0x6D,0x68,
		0x67,0x61,0x5C,0x5E,0x59,0x5C,0x5C,0x63,0x69,0x6D,
		0x73,0x80,0x80,0x80,0x80,0x80,0x80,0x80,};
static ymu8	sample13[258]={
		0x77,0x7B,0x80,0x6F,0x60,0x80,0xAF,0xBF,0x5F,0x40,
		0x9F,0xBF,0x43,0x9F,0x9F,0x40,0xBE,0x43,0xAF,0x5F,
		0x9F,0x5F,0x9F,0x5F,0xAF,0x43,0xBF,0x40,0xBF,0x60,
		0x5F,0xBF,0x40,0x9F,0xAF,0x40,0xBF,0x9F,0x40,0xBF,
		0xB7,0x40,0x80,0xBF,0x50,0x40,0xBF,0xB7,0x40,0x47,
		0xBF,0xB7,0x40,0x40,0xAF,0xBF,0x80,0x40,0x5F,0xBF,
		0xBD,0x68,0x40,0x5F,0xAF,0xBF,0x90,0x50,0x41,0x6F,
		0xAF,0xBD,0x97,0x68,0x55,0x7B,0xA3,0xA5,0x8A,0x70,
		0x58,0x4F,0x6F,0x97,0xA1,0x97,0x82,0x70,0x58,0x4C,
		0x5B,0x7B,0x93,0xAD,0xAB,0x99,0x80,0x6A,0x5A,0x5F,
		0x6F,0x83,0x97,0xAD,0xAC,0x9F,0x8D,0x7C,0x6C,0x61,
		0x63,0x6F,0x80,0x8D,0x9D,0xAA,0xA4,0x9B,0x90,0x82,
		0x74,0x66,0x62,0x66,0x6F,0x79,0x83,0x8F,0x97,0xA3,
		0x9D,0x93,0x8E,0x84,0x78,0x6C,0x66,0x65,0x64,0x69,
		0x74,0x7A,0x82,0x8B,0x96,0x99,0x98,0x94,0x90,0x88,
		0x80,0x78,0x6E,0x68,0x64,0x64,0x64,0x67,0x6F,0x75,
		0x7D,0x86,0x8B,0x8F,0x95,0x97,0x96,0x93,0x90,0x8A,
		0x85,0x80,0x78,0x72,0x70,0x6C,0x69,0x69,0x69,0x6B,
		0x6F,0x74,0x76,0x7E,0x81,0x87,0x8B,0x8F,0x91,0x92,
		0x96,0x93,0x92,0x90,0x8D,0x89,0x85,0x81,0x7C,0x78,
		0x79,0x72,0x70,0x6D,0x6A,0x69,0x67,0x6B,0x69,0x6B,
		0x6D,0x6F,0x72,0x77,0x78,0x7D,0x81,0x85,0x89,0x8D,
		0x90,0x93,0x98,0x9A,0x9A,0x9A,0x99,0x97,0x95,0x91,
		0x8E,0x8A,0x89,0x81,0x80,0x7C,0x78,0x7B,0x76,0x74,
		0x73,0x70,0x6E,0x6F,0x6C,0x6E,0x6E,0x71,0x74,0x76,
		0x79,0x80,0x80,0x80,0x80,0x80,0x80,0x80,};
static ymu8	sample14[451]={
		0x96,0x9E,0x00,0xEE,0x78,0xFF,0xFF,0xFF,0x00,0xFF,
		0x7E,0xF6,0xD2,0x16,0x78,0xA0,0x00,0x00,0x00,0x00,
		0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x08,
		0x5A,0x64,0xA6,0xAA,0xE6,0xFF,0xFF,0xFF,0xFF,0xFF,
		0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
		0xFF,0xFF,0xFC,0xD6,0xAE,0x7C,0x4C,0x1A,0x00,0x00,
		0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
		0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
		0x00,0x0C,0x3A,0x5C,0x82,0xAE,0xE8,0xFF,0xFF,0xFF,
		0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
		0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
		0xFF,0xE4,0xDE,0xBE,0xA6,0x70,0x5E,0x36,0x12,0x04,
		0x08,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
		0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
		0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x08,0x0E,
		0x28,0x2C,0x46,0x66,0x76,0x7C,0x72,0x82,0x9A,0xAA,
		0xAA,0xB4,0xCA,0xDA,0xEC,0xF4,0xF8,0xFF,0xFF,0xFF,
		0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
		0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
		0xFF,0xFF,0xFF,0xFE,0xF8,0xD6,0xD8,0xD4,0xC8,0xB6,
		0xBA,0xA2,0x8C,0x8C,0x76,0x62,0x5E,0x56,0x38,0x24,
		0x20,0x20,0x0E,0x02,0x00,0x00,0x00,0x00,0x00,0x00,
		0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
		0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x02,
		0x06,0x0C,0x1C,0x1E,0x2E,0x3E,0x4A,0x5A,0x5E,0x74,
		0x82,0x8C,0xA0,0xAA,0xB8,0xBA,0xBE,0xC8,0xD2,0xD0,
		0xF6,0xE6,0xEE,0xFC,0xF0,0xFF,0xFF,0xFF,0xFF,0xFF,
		0xFF,0xFA,0xFF,0xFA,0xFE,0xFF,0xFF,0xFF,0xFF,0xFF,
		0xFF,0xFF,0xFE,0xFF,0xF8,0xEC,0xFF,0xF0,0xF4,0xCE,
		0xD4,0xCA,0xCC,0xCE,0xBA,0xAA,0xB4,0x9E,0xAA,0x7A,
		0xBC,0x96,0xAC,0x9A,0x6E,0x84,0x80,0x72,0x6C,0x6A,
		0x72,0x6C,0x5A,0x58,0x68,0x4A,0x46,0x52,0x3A,0x3A,
		0x36,0x3E,0x36,0x30,0x24,0x24,0x0C,0x1E,0x02,0x16,
		0x00,0x02,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
		0x00,0x00,0x00,0x00,0x00,0x02,0x1A,0x16,0x22,0x28,
		0x38,0x52,0x5E,0x66,0x7E,0x7E,0x92,0x8E,0xA6,0xA2,
		0xAE,0xB0,0xBE,0xC0,0xC8,0xBC,0xCC,0xC6,0xC6,0xC8,
		0xCA,0xD0,0xC8,0xD6,0xC6,0xC6,0xD0,0xCE,0xD0,0xCE,
		0xCA,0xCE,0xCA,0xBC,0xC8,0xC4,0xC4,0xC4,0xBA,0xBC,
		0xB0,0xA6,0xBE,0xAE,0xC2,0x9A,0xB4,0x98,0x88,0xA0,
		0xA0,0xA2,0x9A,0x90,0xA6,0x9A,0x98,0x7E,0x80,0x8C,
		0x90,0x7E,0x86,0x84,0x78,0x6C,0x6A,0x6A,0x64,0x78,
		0x84,0x5C,0x82,0x72,0x7A,0x62,0x84,0x80,0x94,0x96,
		0x8E,0x96,0x94,0x92,0xAE,0x90,0xB0,0x92,0xB6,0xA2,
		0x9C,0x88,0x96,0x86,0x80,0x80,0x80,0x80,0x80,0x80,
		0x80,};
static ymu8	sample15[1795]={
		0x80,0x80,0x7A,0x80,0x7C,0xD4,0xFF,0xCE,0x44,0x00,
		0x00,0x00,0x7C,0x0A,0xFF,0xDE,0xDE,0xFF,0xFF,0xA4,
		0x82,0xDE,0xCE,0x08,0x72,0x00,0x94,0x98,0x00,0x00,
		0x12,0x00,0x42,0x2A,0x5E,0x38,0x9A,0xEE,0x5E,0x72,
		0xE6,0xFF,0xFF,0xFF,0xFF,0xEE,0x7A,0x0E,0x00,0x00,
		0x00,0x3A,0x1A,0x00,0x12,0x10,0x46,0xE6,0xE8,0xFF,
		0xF0,0xFF,0xFF,0xF6,0x94,0xAA,0x68,0x32,0x00,0x00,
		0x4E,0x6C,0x32,0x7E,0xB2,0x72,0x5C,0x10,0x00,0x22,
		0x86,0xB8,0xFF,0x96,0xFF,0xFF,0x58,0xDE,0xFA,0xFF,
		0xFF,0x88,0x1C,0x00,0x00,0x00,0xA6,0x44,0x16,0x14,
		0x8A,0x3C,0xA4,0x62,0xFF,0xFF,0xFF,0xFF,0xB0,0x68,
		0x52,0x7A,0x6C,0x9C,0x4E,0xB6,0x94,0x3C,0x00,0x00,
		0x00,0x04,0x74,0xC6,0xBA,0x6C,0x44,0x4A,0xC2,0xF2,
		0xFF,0xD6,0xFF,0xF6,0xD8,0xFF,0xB2,0x80,0x48,0x00,
		0x00,0x00,0x00,0x00,0x0E,0x82,0xF8,0xD6,0xB2,0xCE,
		0x5E,0x9E,0xFE,0xFF,0xCA,0xC6,0x9C,0x7C,0x5A,0x62,
		0x04,0x00,0x6C,0x78,0x9A,0x80,0x44,0x12,0x3A,0x06,
		0x50,0x4C,0x7C,0xC0,0xEC,0xC4,0x76,0xFF,0xFF,0xFF,
		0xEA,0xB8,0x76,0x44,0x76,0x2C,0x42,0x00,0x1E,0x00,
		0x0E,0x4C,0x84,0x72,0x34,0x88,0xBA,0xFA,0xF2,0xFF,
		0xF6,0xAE,0xD6,0xB4,0x72,0x68,0x72,0x0A,0x32,0x94,
		0x90,0x54,0x5A,0x00,0x14,0x0E,0x3E,0x76,0x94,0x84,
		0x9A,0x9E,0xA4,0xE6,0xA4,0xEC,0xDE,0xFF,0xFF,0xA0,
		0xA6,0x3A,0x24,0x14,0x00,0x00,0x00,0x18,0x3C,0x82,
		0xCC,0xD4,0xD0,0xA8,0xA8,0xB8,0xD6,0xDC,0x90,0x86,
		0x84,0x58,0x4E,0x54,0x9A,0x9E,0x8A,0xAE,0x52,0x26,
		0x58,0x36,0x24,0x12,0x0A,0x66,0xAE,0xF2,0xD8,0xFF,
		0xD8,0x96,0x92,0x3C,0x7E,0xAE,0x88,0x8A,0x7E,0x82,
		0x94,0x22,0x28,0x18,0x04,0x22,0x18,0x92,0x60,0xA6,
		0xA6,0x9C,0xAA,0xFF,0xF0,0xE4,0xE0,0x7A,0x96,0x84,
		0x52,0x1A,0x00,0x00,0x32,0x06,0x82,0xA2,0x8C,0x52,
		0x9A,0x72,0x9E,0xA6,0xE6,0xE2,0xE8,0x60,0x72,0x90,
		0x7A,0x92,0x80,0x78,0xAE,0xC0,0x7C,0x5E,0x1A,0x00,
		0x0E,0x26,0x18,0x58,0x94,0xD4,0xFF,0xFF,0xFE,0xDE,
		0x1C,0x30,0x4C,0xD0,0x92,0x90,0x14,0x40,0x70,0xFF,
		0xBC,0x9A,0x6E,0x32,0x56,0x44,0x1C,0x6E,0x8E,0x96,
		0x98,0x62,0x3A,0xA4,0x84,0xD6,0xD8,0x8E,0xC0,0xE2,
		0xCA,0xE2,0x6E,0x38,0x12,0x00,0x52,0x52,0x5A,0x12,
		0x3A,0x86,0x8C,0x92,0x7A,0xA4,0x82,0xD2,0xC0,0x80,
		0x98,0xD8,0xD8,0x78,0x78,0xAA,0x86,0x2E,0x54,0x4A,
		0x32,0x0C,0x72,0x62,0x22,0x58,0x62,0xBC,0xE0,0xB4,
		0x86,0xC2,0xD8,0xF0,0xFF,0xC4,0xB2,0xA4,0x84,0x08,
		0x00,0x00,0x00,0x08,0x50,0x5E,0xDE,0xFF,0xE2,0xA0,
		0x90,0x9A,0x80,0xB0,0xAC,0x9E,0xBA,0xD4,0x4A,0x24,
		0x00,0x00,0x36,0x9E,0xBC,0xB4,0xA8,0xAA,0x82,0x00,
		0x0C,0xA4,0xB2,0x8A,0x90,0x80,0x60,0x54,0xB4,0xEE,
		0xFC,0xA2,0x76,0x8A,0x6A,0xCE,0x76,0x3E,0x00,0x00,
		0x00,0x34,0x86,0xDC,0xFF,0xEE,0xDA,0xE6,0x4C,0x44,
		0xE0,0xB8,0xFF,0xBC,0x56,0x38,0x3C,0x40,0x26,0x32,
		0x00,0x00,0x34,0x1E,0x4A,0x84,0xB6,0xFF,0xFC,0xEE,
		0xE6,0xD0,0x84,0x80,0xCE,0xBA,0xAA,0xAA,0x5C,0x4E,
		0x32,0x00,0x10,0x00,0x2C,0x52,0x54,0x86,0x5E,0x8A,
		0xA2,0xFF,0xFF,0xBC,0xBE,0xE6,0x74,0xAE,0x94,0xBA,
		0x56,0x00,0x36,0x72,0x56,0x3E,0x30,0x3A,0x78,0xBA,
		0xC6,0x56,0x7A,0xC0,0x62,0x74,0xE4,0xC2,0xC8,0x80,
		0x44,0x7C,0xFF,0xFF,0x6C,0x4E,0x00,0x28,0x0C,0x00,
		0x1C,0x8E,0xB0,0xFF,0xF0,0x4C,0x7A,0xA0,0xB4,0xA6,
		0x70,0xAC,0x9A,0xA6,0x88,0x6E,0x2E,0x42,0x06,0x00,
		0x1C,0x7C,0xC6,0xCE,0xDA,0x82,0x56,0x76,0x9E,0xAE,
		0xAE,0xFF,0xFE,0x80,0x5C,0x2E,0x42,0x9E,0x82,0x38,
		0x00,0x04,0x62,0x62,0x74,0x58,0x80,0x50,0xA8,0x96,
		0xEE,0xFF,0xFF,0xE6,0x88,0x48,0x38,0x40,0x62,0x1E,
		0x2C,0x58,0x5A,0x48,0x52,0x26,0x80,0x7A,0x76,0x6E,
		0xEE,0xFF,0xD0,0xC6,0x7A,0xD6,0xE0,0xC2,0xAA,0x58,
		0x1A,0x68,0x5C,0x20,0x3A,0x46,0x26,0x30,0x26,0x3A,
		0x52,0x9A,0x9A,0xA8,0xFF,0xFF,0xFF,0xFF,0xB8,0x56,
		0x66,0x60,0x26,0x02,0x00,0x00,0x0A,0x4A,0x9E,0x4E,
		0x6C,0x90,0xB2,0xCC,0xC4,0x8A,0xB2,0xA6,0xB8,0xCC,
		0xCA,0x66,0x72,0x86,0x4E,0x12,0x4C,0x70,0x34,0x34,
		0x8A,0xC2,0xE0,0xD6,0x1E,0x00,0x2A,0x82,0xB6,0xE2,
		0xFF,0xFF,0xD4,0x6A,0x2A,0x6E,0x7A,0x6A,0x5E,0x1A,
		0x00,0x0A,0x72,0x96,0xA8,0xDC,0xD8,0xA0,0x84,0x76,
		0x9E,0x7E,0x70,0x62,0x9A,0xB6,0x8A,0x76,0x32,0x66,
		0x42,0x60,0x72,0x6E,0x6C,0xA0,0xA0,0xAC,0xB2,0x86,
		0x8A,0x5C,0x7C,0x5C,0x70,0x88,0xA0,0xB4,0xA0,0x86,
		0x84,0x6C,0x72,0x5C,0x2C,0x54,0x56,0x6A,0x7C,0x80,
		0x84,0x98,0xC0,0xBC,0xA2,0x86,0xA6,0x82,0x72,0x64,
		0x40,0x80,0x6E,0x4C,0x6E,0x8E,0x9A,0xA8,0x72,0x5A,
		0x6C,0x9C,0xA0,0x86,0x68,0x60,0x74,0x7C,0x90,0xAA,
		0x78,0x50,0x54,0x60,0xAC,0xE0,0xA2,0x96,0x5A,0x56,
		0x58,0x92,0x82,0x3A,0x44,0x76,0x90,0xAE,0xA4,0xC4,
		0x90,0x8A,0x6A,0x46,0x46,0x54,0x8A,0x9A,0x8C,0x80,
		0x5C,0x6E,0x78,0x80,0xA8,0xB6,0xAA,0x9E,0x62,0x5C,
		0x46,0x6C,0x58,0x84,0x74,0x64,0x8A,0x92,0xAA,0x7A,
		0xA0,0xBC,0x54,0x44,0x84,0xA0,0xD2,0x8A,0x16,0x2C,
		0x84,0xBE,0x8C,0x88,0x7C,0x6E,0x8C,0xA2,0xA4,0x6A,
		0x46,0x4A,0x56,0x54,0x8A,0xA4,0xC2,0x9E,0x7C,0x7E,
		0x9C,0xB2,0xA8,0x86,0x6C,0x68,0x7A,0x62,0x4C,0x44,
		0x36,0x4C,0x6E,0xAC,0xA0,0xBA,0xB6,0x9A,0x88,0x86,
		0x88,0x8E,0x52,0x6A,0x74,0x6A,0x7A,0x7E,0x9C,0x88,
		0x4C,0x50,0x86,0xA2,0xC0,0x7C,0x62,0x4C,0x40,0x80,
		0xA2,0x84,0x5C,0x82,0x9A,0x7A,0xAC,0xAA,0x84,0x7A,
		0x9A,0x98,0x7E,0x60,0x52,0x70,0x58,0x4A,0x52,0x6C,
		0x94,0xA2,0x9C,0xB2,0xAE,0xA8,0x98,0x72,0x64,0x50,
		0x68,0x8C,0x8C,0x6E,0x64,0x70,0x82,0x8E,0x74,0x6E,
		0x80,0x6C,0x80,0x82,0x94,0xA2,0x60,0x4C,0x58,0x70,
		0x9A,0x8E,0x92,0x8C,0x86,0xA0,0xAA,0x9E,0x8E,0x58,
		0x44,0x36,0x50,0x52,0x7A,0x94,0x7E,0x9C,0x9E,0xB8,
		0x96,0x8A,0x5C,0x60,0x86,0x9A,0x94,0x8A,0x70,0x48,
		0x58,0x62,0x64,0x8A,0x9E,0x98,0xA8,0x94,0x90,0x6A,
		0x62,0x54,0x5E,0x90,0xAE,0x8E,0x6A,0x7E,0x82,0x6C,
		0x68,0x8E,0x92,0x88,0x6C,0x76,0x88,0x64,0x7C,0x70,
		0x80,0x66,0x8C,0x80,0x76,0x90,0x94,0x98,0x8C,0x76,
		0x76,0x68,0x68,0x6C,0x82,0x92,0x72,0x8A,0x7C,0x72,
		0x6C,0x48,0x7E,0xAA,0xAE,0xAC,0x86,0x80,0x64,0x5E,
		0x6A,0x88,0x70,0x72,0x94,0xAA,0xAA,0x8C,0x70,0x5E,
		0x5A,0x6C,0x70,0x84,0x90,0x7A,0x7C,0x60,0x6C,0x80,
		0x8A,0x7A,0x8A,0x92,0x96,0x90,0x8A,0x80,0x74,0x6E,
		0x60,0x66,0x7C,0x80,0x82,0x70,0x70,0x5C,0x7C,0x98,
		0x90,0x94,0x8A,0x8C,0x84,0x88,0x80,0x6C,0x58,0x7A,
		0x7E,0x78,0x86,0x90,0xA2,0xA2,0x96,0x7E,0x50,0x44,
		0x54,0x62,0x72,0x96,0xB2,0x94,0x92,0x68,0x60,0x84,
		0x88,0x90,0x94,0x7C,0x82,0x82,0x76,0x6A,0x6E,0x82,
		0x84,0x80,0x6C,0x74,0x6E,0x76,0x76,0x86,0x84,0x86,
		0x7C,0x7A,0x76,0x88,0x9C,0x76,0x8A,0x88,0x8E,0x8A,
		0x80,0x86,0x88,0x5E,0x50,0x40,0x6C,0x96,0x9E,0x94,
		0x7E,0x7A,0x86,0x7A,0x80,0x76,0x88,0x90,0x78,0x78,
		0x6C,0x80,0x8A,0x98,0x74,0x7C,0x72,0x60,0x8A,0x90,
		0x6C,0x70,0x78,0x78,0x92,0x92,0x7E,0x74,0x8A,0x84,
		0x6C,0x74,0x7E,0x7A,0x88,0x82,0x86,0x78,0x7C,0x80,
		0x72,0x80,0x82,0x76,0x7C,0x68,0x62,0x64,0x8C,0x9C,
		0x90,0xA0,0x92,0x72,0x6C,0x6C,0x7E,0x92,0x7A,0x76,
		0x68,0x74,0x8C,0x90,0x72,0x5C,0x74,0x94,0x9E,0x8E,
		0x7A,0x90,0x80,0x68,0x72,0x7E,0x7E,0x7C,0x74,0x68,
		0x76,0x7C,0x80,0x94,0x8C,0x98,0x8C,0x84,0x5E,0x60,
		0x7E,0x80,0x64,0x7A,0x90,0x8E,0x80,0x78,0x76,0x70,
		0x76,0x76,0x7C,0x94,0x82,0x7C,0x76,0x7C,0x68,0x80,
		0x72,0x80,0x7E,0x7A,0x8A,0x84,0x86,0x96,0x94,0x7E,
		0x62,0x62,0x70,0x80,0x76,0x86,0x70,0x80,0x88,0x6C,
		0x84,0x80,0x84,0x8A,0x86,0x8A,0x80,0x8E,0x80,0x76,
		0x6E,0x70,0x7A,0x7A,0x78,0x7E,0x7E,0x84,0x7A,0x84,
		0x92,0x7C,0x7A,0x80,0x86,0x76,0x7A,0x72,0x72,0x78,
		0x7E,0x80,0x7C,0x74,0x72,0x84,0x94,0x8E,0x88,0x78,
		0x64,0x72,0x7A,0x72,0x7A,0x80,0x7A,0x7A,0x7E,0x80,
		0x84,0xA0,0x8C,0x82,0x7C,0x78,0x78,0x78,0x7E,0x76,
		0x76,0x72,0x8E,0x8A,0x84,0x82,0x7C,0x7C,0x72,0x76,
		0x80,0x78,0x84,0x86,0x86,0x82,0x86,0x88,0x8C,0x82,
		0x6C,0x68,0x76,0x70,0x76,0x80,0x98,0x8A,0x80,0x6E,
		0x68,0x7A,0x82,0x82,0x84,0x80,0x8A,0x88,0x76,0x74,
		0x76,0x86,0x88,0x7E,0x7C,0x76,0x80,0x90,0x7A,0x74,
		0x6E,0x78,0x84,0x86,0x8E,0x88,0x82,0x78,0x80,0x82,
		0x7C,0x80,0x82,0x78,0x7A,0x80,0x80,0x82,0x7C,0x76,
		0x7C,0x78,0x80,0x88,0x82,0x8A,0x8A,0x84,0x72,0x6C,
		0x6C,0x6E,0x72,0x84,0x9A,0x90,0x88,0x82,0x70,0x66,
		0x68,0x82,0x84,0x80,0x80,0x7E,0x80,0x82,0x80,0x80,
		0x84,0x78,0x78,0x7C,0x84,0x88,0x7A,0x7A,0x7A,0x7E,
		0x7E,0x8A,0x86,0x82,0x78,0x80,0x84,0x74,0x72,0x78,
		0x86,0x8C,0x82,0x7C,0x84,0x82,0x7A,0x70,0x72,0x88,
		0x88,0x86,0x76,0x6E,0x78,0x90,0x80,0x70,0x78,0x74,
		0x84,0x7C,0x80,0x82,0x78,0x7E,0x82,0x82,0x7A,0x7E,
		0x80,0x80,0x78,0x7E,0x78,0x76,0x84,0x7E,0x78,0x7A,
		0x82,0x82,0x80,0x8A,0x84,0x82,0x84,0x7A,0x78,0x78,
		0x78,0x7E,0x86,0x82,0x7A,0x7E,0x7E,0x78,0x78,0x7C,
		0x82,0x86,0x80,0x80,0x80,0x84,0x80,0x76,0x7A,0x74,
		0x7A,0x7C,0x82,0x88,0x82,0x7A,0x7A,0x76,0x7A,0x7E,
		0x80,0x86,0x7C,0x78,0x74,0x84,0x82,0x7E,0x7C,0x7A,
		0x7E,0x78,0x7C,0x88,0x8E,0x82,0x7A,0x7A,0x7A,0x74,
		0x7C,0x84,0x84,0x7C,0x80,0x80,0x78,0x72,0x78,0x88,
		0x88,0x84,0x82,0x76,0x72,0x7A,0x82,0x84,0x94,0x88,
		0x76,0x6E,0x68,0x74,0x84,0x8A,0x82,0x80,0x7A,0x72,
		0x78,0x80,0x84,0x7C,0x88,0x82,0x7E,0x76,0x74,0x7A,
		0x7E,0x7E,0x80,0x80,0x7E,0x82,0x82,0x80,0x7A,0x78,
		0x80,0x78,0x7C,0x80,0x86,0x82,0x82,0x7E,0x7C,0x86,
		0x7C,0x7C,0x7A,0x82,0x88,0x7E,0x7A,0x70,0x76,0x7E,
		0x84,0x84,0x7E,0x82,0x7E,0x80,0x76,0x7A,0x78,0x82,
		0x86,0x7C,0x7C,0x80,0x82,0x7C,0x7A,0x7C,0x74,0x7C,
		0x86,0x82,0x7E,0x7C,0x7E,0x7E,0x7C,0x86,0x80,0x84,
		0x84,0x7E,0x7C,0x7E,0x7C,0x7A,0x7C,0x7E,0x7C,0x82,
		0x82,0x7E,0x7A,0x7C,0x7E,0x80,0x7E,0x7A,0x7E,0x7C,
		0x80,0x86,0x7C,0x74,0x7E,0x7E,0x7E,0x84,0x80,0x7E,
		0x7C,0x74,0x78,0x7E,0x86,0x82,0x7A,0x76,0x7A,0x84,
		0x7C,0x80,0x84,0x84,0x82,0x78,0x78,0x7A,0x84,0x84,
		0x76,0x7E,0x78,0x7E,0x80,0x80,0x7C,0x7E,0x78,0x7E,
		0x7C,0x78,0x82,0x88,0x80,0x7A,0x72,0x7A,0x80,0x7E,
		0x86,0x82,0x84,0x82,0x78,0x78,0x78,0x72,0x7A,0x8A,
		0x86,0x7E,0x7C,0x7A,0x7C,0x7C,0x82,0x84,0x82,0x80,
		0x74,0x76,0x7A,0x82,0x80,0x7E,0x80,0x7C,0x7E,0x82,
		0x80,0x80,0x7E,0x80,0x7C,0x7C,0x7E,0x7C,0x80,0x84,
		0x80,0x7E,0x7A,0x7C,0x78,0x7A,0x84,0x84,0x80,0x80,
		0x80,0x80,0x80,0x80,0x80,};
static ymu8	sample16[271]={
		0x6A,0x1E,0x20,0x00,0x00,0x14,0x5A,0x9A,0xAA,0xBC,
		0xFF,0xFF,0xFF,0xFF,0xFE,0xBE,0xFF,0xFF,0x00,0xFF,
		0xFF,0xFF,0xFF,0xFF,0xFF,0x9A,0x34,0x00,0x00,0x00,
		0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
		0x00,0x00,0x00,0x00,0x00,0x38,0x6C,0xB8,0xFF,0xFF,
		0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
		0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
		0xFF,0xFF,0xFF,0xDA,0xA2,0x40,0x00,0x00,0x00,0x00,
		0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
		0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
		0x00,0x00,0x00,0x00,0x00,0x00,0x30,0x42,0x6C,0xA6,
		0xCE,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
		0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
		0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
		0xFF,0xFF,0xFF,0xE4,0xC4,0xBE,0xC4,0x9E,0x92,0x86,
		0x74,0x64,0x4E,0x2C,0x18,0x1A,0x06,0x00,0x00,0x00,
		0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
		0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
		0x00,0x00,0x10,0x0C,0x24,0x40,0x42,0x54,0x54,0x5C,
		0x70,0x76,0x86,0x88,0x92,0x98,0x96,0x98,0xA6,0xC4,
		0xB4,0xC2,0xBC,0xB6,0xD0,0xCA,0xBE,0xB6,0xC4,0xB6,
		0xAE,0xAA,0xB6,0xAC,0x9E,0x94,0x8E,0x96,0x8E,0x8E,
		0x8E,0x8A,0x94,0x8A,0x94,0x94,0x9A,0xA2,0x9E,0xAC,
		0xA4,0xB2,0xB8,0xBC,0xBE,0xCC,0xCC,0xDE,0xCC,0xD2,
		0xDE,0xDC,0xDC,0xCC,0xD6,0xEE,0xE2,0xDA,0xD8,0xDA,
		0xC8,0xC8,0xB8,0xC4,0xBC,0xA6,0x9E,0x94,0x8E,0x86,
		0x82,0x6C,0x70,0x66,0x80,0x80,0x80,0x80,0x80,0x80,
		0x80,};
static ymu8	sample17[633]={
		0x34,0x14,0x92,0xCE,0xFF,0xFF,0xCC,0xFF,0x00,0xFF,
		0xFF,0xFF,0xF0,0x00,0x56,0x00,0x00,0x00,0x00,0x00,
		0x00,0x00,0x00,0x32,0x00,0x20,0x60,0x7C,0xD0,0xEE,
		0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xCE,
		0x94,0x02,0x12,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
		0x00,0x00,0x00,0x00,0x00,0x00,0xD8,0xB0,0xE6,0xFF,
		0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
		0xFF,0x8A,0x82,0x58,0x10,0x00,0x00,0x00,0x00,0x00,
		0x00,0x00,0x00,0x00,0x00,0x2A,0x50,0xA2,0x66,0xFF,
		0xFF,0xB2,0xFF,0xE4,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
		0xFF,0xEC,0xFF,0xB2,0x96,0x36,0x1A,0x12,0x00,0x0E,
		0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x5E,
		0x00,0xE2,0x3C,0xFF,0xFF,0xFF,0xC8,0xFF,0xFF,0xFF,
		0xFF,0xFF,0xFF,0xFF,0xD2,0xF4,0x64,0x64,0x9E,0x06,
		0x00,0x0E,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x42,
		0x00,0x5E,0x0A,0xFF,0xAC,0xFF,0xFF,0xFF,0xF6,0xFF,
		0xFF,0xFF,0xFF,0xFF,0xFF,0xCE,0xFF,0xF4,0xAA,0x8C,
		0x70,0x48,0x00,0x00,0x2A,0x00,0x00,0x00,0x00,0x00,
		0x00,0x00,0x76,0x00,0x00,0x6E,0x70,0xC6,0xFF,0xFF,
		0xFF,0xAC,0xB8,0xFF,0xFF,0xFF,0xFF,0x42,0x70,0xFF,
		0xAE,0x00,0x78,0x86,0x00,0x00,0xA6,0x20,0x98,0x00,
		0x00,0xFF,0x24,0x00,0x12,0x00,0xA4,0x24,0x00,0x48,
		0xEA,0xF8,0xB6,0xC4,0xFF,0xFF,0xF4,0xC8,0xFF,0x8A,
		0xB6,0x8C,0xA8,0x6A,0xA2,0xA8,0x94,0xA0,0x54,0x72,
		0xF6,0x00,0x00,0xB0,0x6C,0x00,0x00,0x34,0x76,0x0E,
		0xE4,0x3C,0xC8,0x72,0x74,0xF4,0x3C,0x42,0xFF,0x84,
		0x90,0x8E,0xEC,0x84,0xE6,0xAC,0x48,0x78,0xFF,0x10,
		0x82,0xFA,0x58,0xC2,0xF2,0x82,0x1A,0x00,0x88,0xF6,
		0xEE,0xA4,0x64,0x38,0x44,0x3E,0xB6,0x2C,0x20,0x94,
		0x2E,0x12,0x82,0xA4,0x2C,0x5E,0xD2,0xF0,0x26,0x82,
		0xFF,0xB6,0xA2,0xB0,0x50,0xFF,0xFF,0x90,0xFF,0x94,
		0x38,0x74,0x82,0x32,0x70,0xE8,0x82,0x9E,0x2A,0x00,
		0x34,0x32,0x4C,0x48,0x40,0x30,0x14,0x70,0x86,0xBA,
		0x18,0x74,0xFF,0x74,0x14,0xF0,0x60,0x5E,0xB0,0x9C,
		0xC6,0xFF,0xDC,0x84,0xC0,0x94,0xB8,0x6E,0xA6,0xC8,
		0x8A,0x94,0x94,0xFF,0x32,0x78,0x36,0x80,0x2A,0x52,
		0x10,0x48,0x3A,0x00,0x5C,0x78,0x84,0x74,0x78,0x62,
		0x40,0xBE,0xC8,0xCE,0xFF,0x8E,0xC2,0xB0,0x8E,0xFF,
		0x54,0x6A,0xD2,0xFF,0xA0,0x32,0x38,0xBE,0x4A,0x14,
		0x2A,0x2A,0x74,0x3C,0x66,0x00,0x00,0x0C,0x4A,0x82,
		0x52,0x84,0xC8,0xC2,0x80,0xA2,0xBA,0x9E,0xF4,0xCC,
		0x90,0xD2,0xBC,0xE8,0xD8,0xC8,0xB0,0x32,0x98,0x6A,
		0x0A,0x88,0x78,0x52,0x66,0x00,0x46,0x6E,0x0A,0x5A,
		0x2A,0x60,0x70,0x64,0x2C,0xBA,0x6E,0x56,0xA6,0x9C,
		0x96,0xA8,0x9C,0x76,0x9C,0xD2,0x24,0xB8,0x90,0xBA,
		0x50,0xDA,0x84,0x94,0x6E,0x64,0xF4,0x78,0x5C,0x90,
		0x90,0x44,0x70,0x66,0x20,0x40,0xC2,0x14,0x38,0x94,
		0x5C,0xB6,0x4A,0x7C,0x78,0x42,0x40,0x5C,0xBC,0x72,
		0x8C,0xF4,0x74,0xB6,0x98,0x94,0xD0,0xA0,0x78,0xEA,
		0x84,0xF8,0x76,0x5C,0xB0,0x92,0x7E,0x5A,0x58,0xA8,
		0x6C,0x24,0x0C,0x52,0x40,0x74,0x8C,0x20,0x00,0x44,
		0x46,0x92,0x44,0x90,0x96,0x3C,0xDC,0xA8,0x62,0xC2,
		0xBC,0xDC,0xD0,0xB8,0xA4,0xA0,0xBE,0xE6,0x9A,0x42,
		0x2C,0x54,0xA2,0xAA,0xB0,0x7A,0x00,0x88,0x74,0x32,
		0x22,0x94,0x1A,0x46,0x56,0x9A,0x8A,0x00,0x7E,0x76,
		0x7A,0x56,0x6C,0x9C,0xE2,0x4C,0xD8,0xC8,0x84,0xC0,
		0xD2,0x9A,0xF2,0xAC,0xCA,0x9C,0x80,0xC6,0xC8,0x18,
		0x7E,0x82,0x34,0x62,0x4E,0x5E,0x38,0x7A,0x8E,0x3A,
		0x4C,0x2E,0x36,0x78,0x54,0x24,0x5C,0x46,0x80,0x96,
		0x54,0x8A,0xA2,0xC0,0xE6,0x9E,0xA0,0xEE,0xE0,0xE2,
		0x8E,0xFF,0x6E,0xE0,0x70,0x82,0xBC,0x40,0x70,0x3C,
		0x90,0x06,0x34,0x7A,0x4A,0x52,0x38,0x48,0x76,0x48,
		0x70,0x00,0x50,0x7E,0x8C,0x6E,0x80,0x80,0x80,0x80,
		0x80,0x80,0x80,};
static ymu8	sample18[1379]={
		0xF4,0xFF,0xFF,0xFF,0xFF,0xEA,0x00,0x4A,0x00,0x00,
		0x00,0x84,0x00,0xB4,0xA6,0xD8,0xFF,0xEA,0x82,0x0C,
		0x00,0x00,0x00,0x00,0x00,0x00,0x2E,0x74,0x44,0xFF,
		0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xDE,
		0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x14,
		0x10,0xAA,0xF4,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
		0xEC,0xD2,0x14,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
		0x00,0x00,0x00,0x14,0x82,0xE8,0xFF,0xFF,0xFF,0xFF,
		0xFF,0xFF,0xFF,0xFF,0xFF,0xBA,0x9E,0x3A,0x00,0x00,
		0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x68,0xFF,
		0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
		0xBC,0x2E,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
		0x00,0x00,0x00,0x40,0x50,0xB0,0xE2,0xBC,0xFF,0xFF,
		0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xC0,0x5C,0x14,
		0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x0A,
		0x52,0xB6,0xD6,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
		0xFF,0xFF,0xFF,0xD2,0x82,0x20,0x00,0x00,0x00,0x00,
		0x00,0x00,0x00,0x00,0x00,0x00,0x08,0x64,0xBA,0xF6,
		0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xB8,
		0xD4,0x78,0x28,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
		0x00,0x00,0x32,0x22,0x36,0xD2,0xBC,0xFF,0xFF,0xFF,
		0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xE2,0x7E,0x20,
		0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
		0x00,0x42,0x7A,0xD0,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
		0xFF,0xFF,0xFF,0xFF,0xD6,0xEA,0x50,0x00,0x00,0x00,
		0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x02,0x84,0x8A,
		0xC6,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xF4,
		0xC8,0xC0,0x94,0x36,0x04,0x00,0x00,0x00,0x00,0x00,
		0x00,0x00,0x00,0x00,0x00,0x04,0x26,0x7C,0x98,0xC2,
		0xFF,0xFF,0xFF,0xE8,0xF4,0xA4,0xC2,0xAC,0xB0,0x94,
		0xE4,0x82,0xB4,0xA4,0x98,0x72,0x86,0x60,0x46,0x64,
		0x2C,0x00,0x0A,0x00,0x00,0x0C,0x24,0x00,0x42,0x5E,
		0x9A,0xAA,0xC0,0xFF,0xC0,0xF6,0xA0,0xC4,0xAA,0xA4,
		0x98,0xB8,0xB8,0xDE,0xDE,0xAC,0x8E,0x96,0x58,0x4A,
		0x0A,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x0A,
		0x64,0xB0,0xCE,0xD8,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
		0xFF,0xF2,0xE6,0xC2,0x7C,0x74,0x52,0x24,0x00,0x00,
		0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x04,0x3A,
		0x92,0xBA,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
		0xFF,0xFF,0xCE,0xBC,0x6C,0x4C,0x00,0x00,0x00,0x00,
		0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x2A,0x48,0x42,
		0x84,0xB2,0xF0,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xF2,
		0xF8,0xC6,0xCC,0xA6,0x5A,0x44,0x3C,0x18,0x0E,0x10,
		0x00,0x00,0x00,0x00,0x0C,0x1C,0x38,0x56,0x64,0x40,
		0x6C,0x4A,0x72,0x62,0x96,0xBC,0xC8,0xDA,0xAE,0xB6,
		0x98,0xA6,0xA8,0xBC,0x94,0xA4,0xBE,0xBC,0xA2,0xA0,
		0x7A,0x32,0x2A,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
		0x08,0x00,0x36,0x46,0x92,0x7C,0xB4,0xB4,0xD2,0xF4,
		0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xE2,0xF8,0xDC,0x96,
		0x8C,0x76,0x24,0x30,0x00,0x00,0x00,0x00,0x00,0x00,
		0x00,0x02,0x0E,0x2C,0x38,0x58,0x80,0xA4,0xD6,0xDE,
		0xFF,0xE0,0xFF,0xFF,0xFF,0xFC,0xDC,0xBA,0x80,0x94,
		0x12,0x46,0x30,0x28,0x2A,0x50,0x3E,0x48,0x34,0x2A,
		0x38,0x2A,0x1C,0x58,0x3A,0x38,0x44,0x56,0x4C,0x68,
		0x84,0x78,0x9A,0x8C,0xB8,0xB8,0xAA,0xB0,0xB2,0xA4,
		0xA2,0x8E,0x88,0x60,0x84,0x7A,0x78,0x8E,0x64,0x7C,
		0x46,0x34,0x44,0x32,0x34,0x36,0x38,0x6A,0x22,0x44,
		0x54,0x50,0x5A,0x50,0x3C,0x42,0x5C,0x7C,0x8A,0xB2,
		0xC8,0xD8,0xFE,0xE0,0xF0,0xE2,0xB4,0xC0,0xBC,0xA0,
		0x9E,0x6E,0x8A,0x54,0x70,0x48,0x34,0x00,0x00,0x00,
		0x00,0x00,0x00,0x10,0x34,0x5E,0x64,0xB4,0xA6,0xD8,
		0xC8,0xFF,0xD8,0xFF,0xE8,0xFF,0xDC,0xD0,0xDC,0xA4,
		0x8E,0x7C,0x7E,0x6E,0x3E,0x10,0x10,0x02,0x00,0x00,
		0x00,0x00,0x00,0x00,0x00,0x00,0x2E,0x3A,0x7C,0x88,
		0x9A,0xD0,0xDE,0xF8,0xFF,0xFF,0xFF,0xFF,0xDE,0xA4,
		0x8A,0x78,0x26,0x2A,0x14,0x08,0x00,0x00,0x02,0x08,
		0x20,0x04,0x48,0x56,0x8C,0xA8,0xA2,0xB6,0xF2,0xF0,
		0xF2,0xE2,0xFF,0xEA,0xEE,0xAC,0x98,0x6A,0x32,0x0C,
		0x00,0x00,0x00,0x00,0x00,0x00,0x22,0x66,0x74,0xB4,
		0xAA,0xEA,0xD6,0xB2,0xCC,0xB2,0xB2,0xB0,0xA2,0xC2,
		0xD4,0xCE,0xDC,0xDA,0x9A,0x90,0x66,0x2E,0x00,0x00,
		0x00,0x00,0x00,0x00,0x00,0x00,0x1C,0x5E,0x88,0xA0,
		0xE0,0xF0,0xFF,0xFF,0xFF,0xFF,0xFF,0xFE,0xEE,0xBE,
		0x7A,0x76,0x18,0x08,0x00,0x00,0x00,0x00,0x00,0x00,
		0x00,0x00,0x32,0x4C,0x84,0xA8,0xC8,0xDA,0xFF,0xFA,
		0xFF,0xEC,0xEC,0xB8,0xDE,0xA2,0x8A,0x80,0x54,0x28,
		0x28,0x04,0x00,0x00,0x00,0x00,0x00,0x3E,0x4A,0x72,
		0x90,0xB8,0xBE,0xF0,0xD8,0xFF,0xFE,0xFF,0xFF,0xFF,
		0xC8,0x96,0x7E,0x62,0x30,0x10,0x06,0x00,0x00,0x00,
		0x00,0x00,0x00,0x16,0x3C,0x56,0x88,0x96,0xD4,0xDE,
		0xD8,0xFF,0xFF,0xFF,0xF4,0xD2,0xD0,0xA0,0x74,0x58,
		0x28,0x28,0x0C,0x08,0x00,0x00,0x00,0x00,0x28,0x0C,
		0x32,0x2E,0x4E,0xA0,0x8A,0x8A,0xC6,0x8A,0xB6,0x8C,
		0xA4,0x8C,0xB4,0x6E,0xA0,0x62,0x94,0x72,0x5A,0x40,
		0x2C,0x6C,0x0E,0x4C,0x2A,0x60,0x5C,0x66,0x72,0xB0,
		0x92,0x8A,0xBC,0x86,0xA6,0x76,0x8A,0x6C,0x86,0x86,
		0x9A,0xA4,0x9A,0xAE,0xA2,0x76,0x92,0x66,0x4E,0x02,
		0x24,0x24,0x32,0x26,0x66,0x74,0x82,0x94,0xA4,0xE6,
		0xC6,0xEA,0xA4,0x94,0x6E,0x50,0x5C,0x42,0x1C,0x4C,
		0x1C,0x42,0x54,0x54,0x64,0x56,0x6E,0x6A,0x8E,0x80,
		0xA0,0x96,0xC2,0xB0,0xE2,0xDA,0xBA,0x98,0xB0,0x7E,
		0x66,0x64,0x4C,0x28,0x30,0x00,0x00,0x00,0x00,0x00,
		0x00,0x00,0x16,0x36,0x64,0x64,0x94,0xBA,0xD0,0xEE,
		0xDC,0xE2,0xFF,0xEE,0xCC,0xF0,0xB8,0x94,0x86,0x56,
		0x4E,0x1A,0x04,0x0E,0x00,0x00,0x00,0x08,0x00,0x02,
		0x5E,0x5E,0x82,0x90,0xB2,0xD6,0xF6,0xFF,0xFF,0xFF,
		0xFF,0xFF,0xFA,0xD6,0x9C,0xA4,0x4C,0x44,0x00,0x00,
		0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x30,0x6C,0x90,
		0xA6,0xD4,0xF2,0xFF,0xFF,0xFF,0xFF,0xE8,0xF0,0x9E,
		0x9A,0x76,0x44,0x32,0x1C,0x0C,0x04,0x0C,0x10,0x16,
		0x42,0x3C,0x6E,0x64,0x86,0x74,0x9A,0x68,0x78,0x74,
		0x82,0x94,0x98,0x94,0x8E,0xB8,0x92,0x8C,0x7E,0x58,
		0x60,0x48,0x2E,0x42,0x2A,0x32,0x22,0x44,0x3A,0x58,
		0x5A,0x6C,0x6A,0x90,0x98,0xB2,0xBA,0xD4,0xCE,0xCA,
		0xB8,0xA2,0xBA,0xA2,0x9A,0x8E,0x66,0x68,0x2A,0x2A,
		0x12,0x0C,0x10,0x22,0x2C,0x42,0x52,0x72,0x72,0x88,
		0xAE,0xA4,0xC4,0xC6,0xCA,0xC6,0xC6,0xAE,0xA4,0xA2,
		0x8E,0x78,0x70,0x42,0x5A,0x34,0x36,0x32,0x28,0x38,
		0x2C,0x3C,0x56,0x58,0x7C,0x7E,0x98,0x8A,0xAA,0xA0,
		0x98,0x9E,0x9E,0x8E,0x92,0x70,0x72,0x68,0x62,0x50,
		0x52,0x52,0x4E,0x48,0x4C,0x48,0x4C,0x50,0x4E,0x46,
		0x62,0x54,0x60,0x74,0x7A,0x84,0x98,0x80,0x92,0x8A,
		0x86,0x86,0x7C,0x78,0x76,0x80,0x86,0x6E,0x84,0x74,
		0x72,0x7C,0x6A,0x80,0x76,0x8E,0x7A,0x84,0x7A,0x86,
		0x7A,0x82,0x80,0x86,0x70,0x76,0x6E,0x78,0x66,0x70,
		0x64,0x6C,0x64,0x6A,0x66,0x7A,0x78,0x7E,0x82,0x84,
		0x88,0x8C,0x82,0x88,0x88,0x8A,0x88,0x8C,0x94,0x7A,
		0x92,0x72,0x76,0x66,0x5C,0x54,0x5C,0x56,0x60,0x52,
		0x5C,0x52,0x5C,0x60,0x70,0x60,0x6E,0x6E,0x76,0x7A,
		0x88,0x74,0x78,0x6A,0x66,0x62,0x6C,0x6E,0x7C,0x7C,
		0x6A,0x76,0x6E,0x6C,0x60,0x6E,0x62,0x60,0x64,0x64,
		0x64,0x6C,0x5A,0x60,0x5C,0x62,0x62,0x66,0x6E,0x68,
		0x6A,0x74,0x7A,0x84,0x88,0x8E,0x90,0x9C,0xA6,0xA0,
		0xA8,0x9E,0xA6,0x94,0x98,0x88,0x86,0x74,0x78,0x5C,
		0x62,0x52,0x52,0x4E,0x4E,0x46,0x3A,0x4E,0x4C,0x48,
		0x5A,0x5E,0x62,0x78,0x74,0x88,0x8E,0xA2,0x9C,0x98,
		0xAE,0xA2,0xAE,0xA0,0xA2,0x98,0x88,0x92,0x7E,0x76,
		0x6E,0x5C,0x60,0x4C,0x40,0x36,0x36,0x2A,0x34,0x26,
		0x3E,0x34,0x40,0x48,0x50,0x6A,0x68,0x70,0x84,0x90,
		0x94,0x92,0x9E,0xAA,0xA4,0xA4,0x90,0x92,0x7E,0x7E,
		0x72,0x6A,0x56,0x50,0x42,0x40,0x30,0x2E,0x2E,0x2E,
		0x3C,0x38,0x50,0x5E,0x6A,0x7C,0x8A,0x92,0xAE,0xB0,
		0xB2,0xBA,0xBE,0xC0,0xB8,0xB6,0xB2,0xA2,0x9A,0x94,
		0x80,0x78,0x70,0x60,0x56,0x4A,0x3E,0x3E,0x2A,0x40,
		0x3C,0x44,0x46,0x52,0x56,0x64,0x6E,0x7A,0x86,0x8C,
		0x8E,0x92,0x9E,0x96,0x9A,0x9E,0x98,0x9C,0x94,0x8E,
		0x8C,0x82,0x6E,0x6A,0x60,0x5C,0x48,0x48,0x44,0x3A,
		0x4C,0x34,0x80,0x80,0x80,0x80,0x80,0x80,0x80,};
static ymu8	sample19[147]={
		0x8E,0x71,0x59,0x3C,0x25,0x10,0x04,0x0A,0x16,0x14,
		0x24,0x4A,0x70,0x96,0xC1,0xEA,0xFE,0xFC,0xFD,0xFC,
		0xFD,0xFC,0xFD,0xFC,0xEF,0xC1,0x89,0x53,0x25,0x07,
		0x01,0x01,0x01,0x01,0x01,0x01,0x02,0x01,0x01,0x0C,
		0x36,0x4A,0x73,0xAA,0xE2,0xFD,0xFC,0xFD,0xFC,0xFD,
		0xFC,0xFD,0xFC,0xFC,0xFC,0xFD,0xF9,0xD6,0xAB,0x7D,
		0x58,0x44,0x18,0x02,0x01,0x01,0x01,0x01,0x01,0x01,
		0x01,0x01,0x01,0x01,0x00,0x0D,0x34,0x5E,0x89,0xB2,
		0xDC,0xF5,0xFC,0xFD,0xFD,0xFD,0xFD,0xFD,0xFD,0xFC,
		0xFD,0xFC,0xFD,0xFC,0xFD,0xED,0xC7,0xA1,0x79,0x52,
		0x2A,0x08,0x00,0x02,0x01,0x02,0x01,0x02,0x01,0x02,
		0x02,0x02,0x02,0x02,0x01,0x01,0x14,0x36,0x5A,0x80,
		0xA5,0xC8,0xE9,0xFE,0xFC,0xFD,0xFC,0xFD,0xFC,0xFD,
		0xFC,0xFD,0xFC,0xFD,0xFC,0xFD,0xFC,0xF8,0xDD,0xC4,
		0x80,0x80,0x80,0x80,0x80,0x80,0x80,};
static ymu8	sample20[139]={
		0x83,0x97,0x7A,0xC9,0x3D,0x49,0xC5,0x94,0x58,0x17,
		0x3F,0x8A,0xEA,0x9E,0x3A,0x27,0xB6,0x9F,0x42,0x9C,
		0x92,0x8E,0x49,0x70,0x5E,0x9B,0xA7,0x78,0x42,0x6E,
		0x9F,0x88,0x77,0x5A,0x8D,0x85,0x79,0x7D,0x7E,0x7A,
		0x69,0x84,0x89,0x84,0x41,0xDE,0x8A,0x11,0x5D,0xC6,
		0xCE,0x51,0x22,0xA3,0xB0,0x00,0xB0,0xCE,0x71,0x0F,
		0x9B,0xB2,0x34,0xAA,0x99,0x98,0x50,0x3E,0x96,0xA3,
		0x67,0x7A,0x94,0x6B,0x6A,0x95,0x8F,0x69,0x58,0x80,
		0xB1,0x83,0x53,0x80,0x8C,0x77,0x7C,0x77,0x9B,0x78,
		0x68,0x7A,0xA4,0x4D,0x5B,0x89,0x8B,0x70,0xCB,0xC1,
		0x38,0x38,0xCD,0xD6,0xA8,0x35,0x38,0xEF,0x72,0x1A,
		0x7C,0xD4,0xC1,0x51,0x2B,0xBC,0xAA,0x41,0x67,0xAB,
		0x89,0x4C,0x9B,0x90,0x63,0x66,0x83,0xA0,0x77,0x65,
		0x62,0xB6,0x80,0x80,0x80,0x80,0x80,0x80,0x80,};
static ymu8	sample21[85]={
		0x76,0xAE,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
		0x00,0x00,0x26,0x5E,0x9A,0xCA,0xFA,0xFF,0xFF,0xFF,
		0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
		0xD6,0x98,0x74,0x32,0x00,0x00,0x00,0x00,0x00,0x00,
		0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
		0x00,0x00,0x12,0x4A,0x86,0xB4,0xEA,0xFF,0xFF,0xFF,
		0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
		0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFC,0xBC,0x80,0x80,
		0x80,0x80,0x80,0x80,0x80,};
static ymu8	sample22[150]={
		0xAD,0x92,0x5F,0xB2,0x56,0x52,0x65,0xBD,0x80,0x84,
		0x80,0xB1,0xC2,0x9A,0x98,0x80,0x9D,0xDD,0x89,0xB8,
		0x64,0x9A,0x22,0xB1,0xB2,0x7A,0xB0,0x52,0xB9,0x9E,
		0xA5,0x52,0x68,0xC8,0x64,0xD4,0x44,0xA0,0x72,0x63,
		0x8B,0x76,0x9D,0x7E,0x82,0x79,0xB6,0x81,0x64,0xAF,
		0x90,0xA8,0x72,0xA3,0xA5,0xA1,0xA4,0x9E,0xBD,0x96,
		0xA9,0x8A,0x96,0x98,0x9A,0xB1,0x5B,0x90,0x4A,0x6C,
		0x93,0x8D,0x9D,0x83,0x9D,0x7D,0xAE,0x8D,0x89,0x88,
		0x64,0xC8,0x7E,0x88,0x74,0x94,0x87,0x88,0x93,0x75,
		0x62,0x70,0x98,0x8B,0xC0,0x93,0x8F,0x81,0x7B,0x92,
		0x95,0x60,0xA4,0x90,0xA8,0x64,0x9A,0x9E,0x5B,0x63,
		0x82,0xA8,0x9B,0x7B,0xA5,0x93,0x97,0x7D,0xA6,0x91,
		0x83,0x9F,0xB7,0x92,0x73,0x99,0x8D,0x81,0x86,0x9F,
		0x9C,0x7D,0x9E,0x87,0xA1,0xA0,0x81,0x75,0xA2,0x74,
		0xA7,0x80,0x95,0x80,0x80,0x80,0x80,0x80,0x80,0x80,};
static ymu8	sample23[507]={
		0x77,0x83,0x29,0x08,0x7D,0xF8,0xE2,0xEF,0xE7,0xEF,
		0x79,0x49,0x37,0x2D,0x14,0x0E,0x13,0x0E,0x16,0x06,
		0x56,0xB5,0xE4,0xF6,0xE6,0xF7,0xE3,0xFF,0xBC,0xD2,
		0xB5,0xBC,0xE2,0xDE,0x9D,0xB1,0xC7,0x83,0x23,0x0A,
		0x15,0x0E,0x13,0x0E,0x13,0x0E,0x14,0x0D,0x1A,0x5A,
		0xCD,0xF6,0xEA,0xF1,0xEB,0xF0,0xEC,0xF0,0xEC,0xF1,
		0xEB,0xF2,0xE1,0xBF,0xAC,0x48,0x5A,0x27,0x13,0x11,
		0x10,0x12,0x0F,0x13,0x0E,0x15,0x0A,0x33,0x65,0x86,
		0xF6,0xE7,0xF3,0xEA,0xF1,0xEB,0xF0,0xEC,0xF0,0xEB,
		0xF2,0xE2,0xA0,0xC0,0x9B,0x8F,0x63,0x20,0x22,0x08,
		0x17,0x0C,0x15,0x0D,0x15,0x0D,0x15,0x0C,0x1A,0x55,
		0xB0,0xCA,0xE8,0xEE,0xED,0xEE,0xEE,0xEE,0xED,0xF0,
		0xCE,0xBF,0xA7,0x98,0x59,0x54,0x20,0x10,0x15,0x0E,
		0x13,0x0E,0x14,0x10,0x3C,0x54,0x6C,0x55,0x73,0xB0,
		0xB4,0xA3,0xDE,0xEF,0xEE,0xED,0xF0,0xE8,0xD4,0xF6,
		0xE7,0xF3,0xBB,0xB1,0x9D,0xA4,0x91,0x4E,0x43,0x1D,
		0x27,0x12,0x2E,0x17,0x19,0x14,0x1A,0x11,0x17,0x3C,
		0x5D,0xA3,0xCC,0xE8,0xF0,0xED,0xF0,0xEC,0xF0,0xEC,
		0xF0,0x99,0x78,0x5A,0x52,0x3B,0x4F,0x44,0x32,0x07,
		0x1A,0x0C,0x20,0x10,0x17,0x14,0x21,0x37,0x5C,0x84,
		0xA9,0x8A,0xA9,0xB6,0xC7,0xC2,0xE4,0xE9,0xC3,0xD2,
		0xA6,0xBD,0x9F,0x96,0xA1,0x8B,0x81,0x5D,0x52,0x35,
		0x2B,0x0F,0x11,0x23,0x20,0x20,0x29,0x38,0x3E,0x61,
		0x81,0x93,0x99,0xAD,0xC6,0xE1,0xEE,0xE7,0xE9,0xE3,
		0xD5,0xAC,0x97,0x7D,0x76,0x5C,0x5E,0x60,0x41,0x41,
		0x59,0x63,0x36,0x5B,0x2E,0x37,0x47,0x57,0x4D,0x67,
		0x7D,0xA8,0xB4,0xCF,0xE8,0xD5,0xCA,0xBC,0xBD,0xA8,
		0x97,0x95,0x94,0x9D,0xA0,0xB2,0xA6,0x9C,0x79,0x6E,
		0x55,0x43,0x32,0x34,0x37,0x32,0x3A,0x45,0x63,0x81,
		0x9B,0xB3,0xA9,0xAD,0x96,0x98,0x7A,0x80,0x77,0x95,
		0xAB,0xC2,0xDD,0xC5,0xC8,0xAD,0x95,0x6E,0x60,0x63,
		0x38,0x30,0x4B,0x37,0x35,0x54,0x52,0x60,0x68,0x6D,
		0x78,0x75,0x78,0x8A,0x8D,0xA0,0x8F,0x97,0xA0,0xAE,
		0x94,0xA1,0xAB,0xA3,0x98,0x95,0x91,0x82,0x69,0x74,
		0x6C,0x79,0x5B,0x5E,0x52,0x5D,0x5C,0x6B,0x65,0x7A,
		0x60,0x6E,0x7B,0x7B,0x6D,0x78,0x60,0x69,0x71,0x77,
		0x9A,0x96,0xA5,0xB1,0xA2,0xA4,0xAE,0xA5,0xA7,0x86,
		0x7B,0x70,0x70,0x67,0x55,0x5E,0x59,0x59,0x53,0x5D,
		0x57,0x62,0x6C,0x5E,0x6B,0x74,0x83,0x8F,0xA0,0xA5,
		0xB1,0xAD,0xB9,0xB2,0xAF,0xA7,0x96,0x91,0x8D,0x80,
		0x7E,0x80,0x73,0x6D,0x69,0x65,0x63,0x5E,0x68,0x6B,
		0x6C,0x6E,0x67,0x71,0x75,0x70,0x7D,0x72,0x7D,0x7B,
		0x71,0x8C,0x98,0x8D,0xA3,0xAC,0x9F,0xAA,0xB1,0xAA,
		0xA2,0x92,0x8C,0x80,0x77,0x6D,0x55,0x5C,0x61,0x50,
		0x4F,0x59,0x5E,0x5C,0x5E,0x73,0x72,0x7B,0x87,0x93,
		0x92,0xA4,0xA1,0xA1,0x95,0x93,0x8C,0x8A,0x87,0x89,
		0x82,0x92,0x8D,0x88,0x85,0x85,0x82,0x80,0x70,0x6C,
		0x6E,0x58,0x64,0x62,0x6A,0x74,0x77,0x80,0x74,0x86,
		0x7B,0x80,0x77,0x75,0x72,0x7E,0x86,0x80,0x95,0x8B,
		0x98,0xA1,0xAA,0x8E,0x8E,0x90,0x7D,0x83,0x71,0x74,
		0x80,0x80,0x80,0x80,0x80,0x80,0x80,};
static ymu8	sample24[230]={
		0xA0,0x66,0xA6,0xAA,0xC8,0xC4,0xCC,0xD8,0xEC,0xEE,
		0xFF,0xFF,0xFF,0xFF,0xBE,0xAE,0x5A,0x62,0x26,0x10,
		0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x26,0x3E,0x4E,
		0x7A,0xAE,0xB8,0xE4,0xCE,0xCE,0xFF,0xFF,0xFF,0xFF,
		0xFF,0xFF,0xFF,0xCA,0xC0,0xAE,0x9A,0x4E,0x40,0x58,
		0x5A,0x60,0x50,0x5A,0x62,0xA6,0x64,0x78,0x44,0x62,
		0x9E,0xB8,0xB4,0xA4,0x80,0x64,0x62,0x50,0x46,0x4E,
		0x34,0x48,0x4C,0x5C,0x5C,0x5C,0x76,0x86,0x64,0x4C,
		0x52,0x3E,0x6A,0x8A,0xBA,0xD0,0xF6,0xFF,0xFF,0xFF,
		0xFF,0xEA,0xE0,0xB2,0xA4,0x86,0x92,0x9A,0x90,0x70,
		0x5A,0x44,0x4C,0x44,0x56,0x72,0x62,0x68,0x52,0x56,
		0x64,0x56,0x6E,0x3A,0x3C,0x40,0x64,0x54,0x66,0x5C,
		0x82,0xAC,0xA8,0xCA,0xC4,0xE2,0xC2,0xC0,0x94,0xB4,
		0x96,0xC8,0xBE,0xB0,0xC6,0xB2,0xD4,0xD2,0xCA,0xC2,
		0xA0,0x8E,0x7C,0x5E,0x42,0x2A,0x0C,0x00,0x00,0x00,
		0x00,0x1A,0x2E,0x34,0x52,0x72,0x7E,0x9A,0x8E,0xA2,
		0xB0,0xB2,0xBC,0xAE,0x96,0x6E,0x44,0x38,0x58,0x6E,
		0xAA,0xD6,0xFF,0xFA,0xF2,0xD4,0xD0,0xC0,0xC0,0xC8,
		0xBA,0x96,0x8E,0x70,0x70,0x82,0x90,0xAC,0xBE,0xB8,
		0xB4,0x92,0x82,0x80,0x72,0x6E,0x60,0x4C,0x42,0x22,
		0x1C,0x12,0x00,0x16,0x3E,0x54,0x86,0xA4,0xD0,0xDE,
		0xEA,0xD4,0xC8,0xAC,0xA6,0x9A,0xAC,0xAE,0xAC,0xAA,
		0x94,0x84,0x7E,0x80,0x80,0x80,0x80,0x80,0x80,0x80,};
static ymu8	sample25[120]={
		0x84,0x6E,0x52,0xA4,0x62,0x78,0xEC,0x28,0x7A,0x68,
		0x5A,0x8E,0x68,0x30,0x3E,0x40,0x6E,0xA2,0x7A,0xAE,
		0xFC,0xAE,0xB0,0xA6,0x8A,0x94,0x54,0xA2,0x6E,0x56,
		0x64,0x7E,0x62,0x46,0x52,0x32,0x7C,0x50,0xA2,0x5E,
		0xB0,0x7A,0x86,0xB2,0x78,0x7C,0x84,0x9A,0x62,0x90,
		0x82,0xB0,0x9A,0x5E,0x72,0x24,0x62,0x68,0x22,0x68,
		0x46,0x8A,0x58,0xB8,0x9C,0xCC,0x94,0xCE,0x5C,0x5A,
		0x60,0x3A,0x80,0x5A,0x74,0x6A,0xA6,0x8E,0x80,0x9A,
		0x80,0x62,0x52,0x60,0x58,0x84,0x3C,0x74,0x4E,0x6E,
		0x9E,0x50,0x92,0x96,0x72,0x94,0x5A,0x78,0x6E,0x70,
		0x6A,0x92,0x66,0x86,0x6C,0x74,0x6E,0x64,0x8E,0x8C,
		0x90,0xAA,0x8C,0x80,0x80,0x80,0x80,0x80,0x80,0x80,};
static ymu8	sample26[271]={
		0x56,0x78,0x70,0x70,0x66,0x6E,0x54,0x64,0x62,0x36,
		0x52,0x00,0xCE,0x28,0x1A,0xE6,0x00,0xF4,0x5E,0x90,
		0xD4,0x00,0xFF,0x00,0x3A,0x00,0x00,0x00,0x00,0x24,
		0xE6,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
		0xFF,0xFF,0xA2,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
		0x00,0x00,0x0C,0x9C,0xEC,0xFF,0xFF,0xFF,0xFF,0xFF,
		0xFF,0xFF,0xFF,0xD0,0x30,0x00,0x00,0x00,0x00,0x00,
		0x00,0x00,0x00,0x3E,0xD4,0xC4,0xFF,0xFF,0xFF,0xFF,
		0xFF,0xFF,0xFF,0xFF,0xE6,0x00,0x00,0x00,0x00,0x00,
		0x00,0x00,0x00,0x0A,0x5A,0x00,0xFF,0xFF,0xFF,0xFF,
		0xFF,0xFF,0xFF,0xFF,0xFF,0xF6,0xF0,0x00,0x00,0x00,
		0x00,0x00,0x00,0x00,0x00,0x00,0x4C,0x08,0x92,0xEE,
		0x36,0xFF,0xBE,0xFF,0xF6,0xFF,0xF8,0xFF,0xBC,0xD2,
		0x30,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
		0x00,0x00,0xCC,0x00,0xFF,0x60,0xB0,0xFF,0xE0,0xFF,
		0xA0,0xFF,0xBC,0xFF,0xFF,0x44,0xAA,0x00,0x00,0x00,
		0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x6C,0x7C,
		0x1E,0xF6,0x00,0xFF,0x44,0xF8,0xCA,0xFF,0xEC,0xFF,
		0xB8,0xFF,0xBC,0xB4,0xE2,0x00,0x66,0x00,0x00,0x00,
		0x00,0x00,0x00,0x00,0x00,0x00,0x60,0x00,0xD0,0x00,
		0xE6,0x00,0xFC,0x2C,0xF4,0x94,0x94,0xD6,0x7C,0xDE,
		0x62,0xFF,0x7A,0xFF,0xD2,0xFF,0x1C,0xFF,0x00,0xEE,
		0x00,0x42,0x00,0x1A,0x00,0x8A,0x00,0xE4,0x00,0xD8,
		0x42,0x7E,0x84,0x32,0xD2,0x1C,0xFF,0x14,0xFC,0x58,
		0xFF,0xCC,0xC4,0x92,0xC2,0x70,0xFF,0x44,0xC8,0x72,
		0xBA,0x50,0xC0,0x48,0x2A,0x7E,0x00,0x32,0x00,0x22,
		0x00,0x14,0x36,0x00,0x80,0x80,0x80,0x80,0x80,0x80,
		0x80,};
static ymu8	sample27[293]={
		0x80,0x80,0x9F,0x80,0x9F,0x9F,0x5F,0x80,0x80,0x9F,
		0xCA,0x80,0x80,0xDF,0xBE,0xBF,0x80,0x88,0xBF,0x3F,
		0xDE,0x20,0x80,0xC6,0x6F,0x02,0x5F,0x9E,0x3F,0x00,
		0x9F,0x07,0x3F,0x80,0xDF,0x14,0x9F,0xB7,0xFF,0x3F,
		0xFE,0xFF,0xFE,0xFF,0xFF,0xCF,0xFF,0xFF,0xBF,0x93,
		0xCF,0xD7,0x12,0x4F,0x93,0x3A,0x1F,0x04,0x00,0x00,
		0x18,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
		0x10,0x16,0x77,0x0A,0xFD,0x80,0xFF,0xFF,0xFF,0xFF,
		0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
		0xFF,0xEF,0xDF,0xFA,0xC9,0x5A,0x5B,0x31,0x1F,0x00,
		0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
		0x00,0x00,0x00,0x00,0x08,0x00,0x08,0x1E,0x68,0xA6,
		0xAD,0xFF,0xF7,0xEE,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
		0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
		0xFF,0xFF,0xFF,0xF8,0xE3,0xDD,0xE5,0xC8,0x86,0x86,
		0x6A,0x43,0x28,0x1D,0x15,0x00,0x09,0x1F,0x00,0x00,
		0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x24,0x3E,0x00,
		0x0F,0x0A,0x0F,0x0F,0x00,0x00,0x00,0x00,0x00,0x00,
		0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
		0x04,0x00,0x14,0x23,0x22,0x4A,0x58,0x8D,0xA5,0xA6,
		0xC9,0xD0,0xF3,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
		0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
		0xFF,0xFF,0xFF,0xFF,0xFF,0xF7,0xF7,0xE6,0xB5,0xA4,
		0x65,0x3A,0x54,0x37,0x06,0x07,0x0D,0x00,0x0E,0x00,
		0x00,0x00,0x03,0x00,0x00,0x00,0x02,0x05,0x00,0x04,
		0x1F,0x00,0x0F,0x2B,0x24,0x10,0x04,0x15,0x07,0x08,
		0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
		0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x0E,
		0x25,0x3A,0x44,0x61,0x6C,0x91,0x80,0x80,0x80,0x80,
		0x80,0x80,0x80,};
static ymu8	sample28[391]={
		0x8B,0x8E,0x8F,0x8C,0x8D,0x8E,0x91,0x93,0x97,0xB0,
		0xDF,0xFF,0xFF,0xDE,0x00,0x3F,0x3F,0x97,0x80,0x00,
		0x00,0x08,0xBF,0xBF,0xBF,0xBF,0xBF,0x9E,0xA6,0xFF,
		0xE8,0xF3,0x1C,0x00,0x00,0x00,0x5E,0x15,0x00,0x00,
		0x1F,0xBE,0xFF,0x10,0x00,0x37,0x2F,0x00,0x1C,0x3F,
		0x5E,0x4F,0x80,0xFF,0xFF,0xFF,0xFF,0xF6,0xFF,0xE3,
		0xFF,0x80,0x5F,0x94,0xFF,0xFF,0xFF,0x7E,0x3F,0xDF,
		0x87,0x3A,0x00,0x00,0x2B,0x00,0x00,0x0E,0x9C,0xE7,
		0x9E,0xEF,0xCF,0xFF,0xFF,0xFF,0xFF,0xFF,0xDF,0x00,
		0x14,0x18,0x3F,0x23,0x56,0x00,0x00,0x65,0x4B,0x60,
		0x2F,0x08,0x8E,0x2F,0xA7,0xD3,0xA3,0xFF,0xF7,0xEF,
		0xFF,0xFF,0xFF,0xC3,0x8B,0x28,0x5F,0x34,0x2F,0x10,
		0x00,0x00,0x00,0x1F,0x46,0xB3,0xE3,0xA7,0xCF,0xDE,
		0xE2,0xB6,0x9C,0x5D,0x53,0x77,0x84,0x47,0x56,0x7E,
		0xDA,0xF7,0xAC,0xDE,0x55,0x73,0x42,0x0F,0x3F,0x00,
		0x00,0x00,0x0C,0x00,0x8F,0x00,0xCB,0xD6,0xCF,0xFF,
		0xFF,0xE0,0xA6,0x75,0x9F,0x3F,0x00,0x16,0x36,0x66,
		0x18,0x3F,0x85,0xC7,0xEE,0x88,0x3E,0x80,0xB8,0x45,
		0x37,0x2F,0x2B,0x27,0x38,0x90,0xDB,0xE6,0xEE,0x8C,
		0xBF,0x6F,0x66,0x3F,0x00,0x00,0x00,0x00,0x00,0x3F,
		0x54,0xBF,0xDE,0xFF,0xE5,0xFA,0xBE,0x93,0xCF,0x6B,
		0xAE,0x80,0xC7,0x86,0x97,0xD3,0xC7,0xC1,0xD7,0xAA,
		0x75,0x6F,0x6D,0x80,0x18,0x0A,0x0D,0x1F,0x6A,0x6F,
		0xE3,0xDF,0xE6,0xEE,0xF6,0xFB,0xEF,0xC4,0x56,0x89,
		0x3F,0x3F,0x38,0x77,0x6B,0x9F,0x4B,0x95,0x66,0x6A,
		0x96,0x72,0x87,0x57,0x73,0x60,0x67,0x8F,0x97,0xD6,
		0x97,0xD9,0xDB,0xE7,0x9E,0xBB,0x3F,0x68,0x17,0x24,
		0x16,0x1F,0x6F,0x27,0x3F,0x47,0x9F,0x82,0x7D,0x70,
		0x45,0x5F,0x5F,0x87,0x20,0x58,0x5F,0x33,0xA6,0xCC,
		0x6F,0xC1,0x80,0x79,0x9A,0x9A,0x71,0x33,0x3F,0x0C,
		0x16,0x29,0x2E,0x57,0x3B,0xCF,0xBB,0xDE,0xEE,0xF0,
		0xD9,0xB9,0x8B,0x27,0x8D,0x87,0x75,0x2E,0x6E,0x63,
		0x4A,0x6B,0x79,0xAE,0xAE,0x9F,0xBB,0xAB,0xAF,0xA6,
		0xAA,0x4D,0x28,0x5A,0x56,0x9E,0x9C,0x7B,0xA9,0xA9,
		0x4D,0x87,0x84,0x92,0x7D,0x9F,0x4B,0xA7,0x9F,0xB5,
		0x83,0xA5,0xBA,0xC9,0xE7,0xB1,0x9D,0x66,0x4D,0x6D,
		0x2F,0x52,0x77,0x5D,0x4F,0x5B,0x9C,0xBC,0xD5,0xCF,
		0x97,0xA2,0x91,0xA0,0x60,0x56,0x61,0x4B,0x51,0x88,
		0x8B,0x8C,0xC6,0xBF,0x80,0x80,0x80,0x80,0x80,0x80,
		0x80,};
static ymu8	sample29[391]={
		0x86,0x88,0x89,0x87,0x88,0x88,0x8A,0x8B,0x8E,0x9D,
		0xBB,0xCF,0xCF,0xBA,0x30,0x57,0x57,0x8E,0x80,0x30,
		0x30,0x35,0xA7,0xA7,0xA7,0xA7,0xA7,0x92,0x97,0xCF,
		0xC0,0xC7,0x41,0x30,0x30,0x30,0x6A,0x3D,0x30,0x30,
		0x43,0xA6,0xCF,0x3A,0x30,0x52,0x4D,0x30,0x41,0x57,
		0x6A,0x61,0x80,0xCF,0xCF,0xCF,0xCF,0xC9,0xCF,0xBD,
		0xCF,0x80,0x6B,0x8C,0xCF,0xCF,0xCF,0x7E,0x57,0xBB,
		0x84,0x54,0x30,0x30,0x4A,0x30,0x30,0x38,0x91,0xC0,
		0x92,0xC5,0xB1,0xCF,0xCF,0xCF,0xCF,0xCF,0xBB,0x30,
		0x3C,0x3F,0x57,0x45,0x65,0x30,0x30,0x6F,0x5E,0x6C,
		0x4D,0x35,0x88,0x4D,0x98,0xB3,0x95,0xCF,0xCA,0xC5,
		0xCF,0xCF,0xCF,0xA9,0x86,0x49,0x6B,0x50,0x4D,0x3A,
		0x30,0x30,0x30,0x43,0x5B,0x9F,0xBD,0x98,0xB1,0xBA,
		0xBD,0xA1,0x91,0x6A,0x63,0x7A,0x82,0x5C,0x65,0x7E,
		0xB8,0xCA,0x9B,0xBA,0x65,0x77,0x59,0x39,0x57,0x30,
		0x30,0x30,0x37,0x30,0x89,0x30,0xAE,0xB5,0xB1,0xCF,
		0xCF,0xBB,0x97,0x79,0x93,0x57,0x30,0x3D,0x51,0x6F,
		0x3F,0x57,0x83,0xAC,0xC4,0x84,0x56,0x80,0xA2,0x5B,
		0x52,0x4D,0x4A,0x48,0x53,0x89,0xB8,0xBF,0xC4,0x87,
		0xA7,0x75,0x6F,0x57,0x30,0x30,0x30,0x30,0x30,0x57,
		0x64,0xA7,0xBA,0xCF,0xBF,0xCC,0xA6,0x8B,0xB1,0x72,
		0x9C,0x80,0xAC,0x83,0x8E,0xB3,0xAC,0xA8,0xB6,0x9A,
		0x79,0x75,0x74,0x80,0x3F,0x36,0x38,0x43,0x72,0x75,
		0xBD,0xBB,0xBF,0xC4,0xC9,0xCC,0xC5,0xAA,0x65,0x85,
		0x57,0x57,0x53,0x7A,0x72,0x93,0x5E,0x8D,0x6F,0x72,
		0x8D,0x77,0x84,0x66,0x77,0x6C,0x70,0x89,0x8E,0xB5,
		0x8E,0xB7,0xB8,0xC0,0x92,0xA4,0x57,0x71,0x3E,0x46,
		0x3D,0x43,0x75,0x48,0x57,0x5C,0x93,0x81,0x7E,0x76,
		0x5B,0x6B,0x6B,0x84,0x44,0x67,0x6B,0x4F,0x97,0xAF,
		0x75,0xA8,0x80,0x7B,0x90,0x90,0x76,0x4F,0x57,0x37,
		0x3D,0x49,0x4C,0x66,0x54,0xB1,0xA4,0xBA,0xC4,0xC5,
		0xB7,0xA3,0x86,0x48,0x88,0x84,0x79,0x4C,0x74,0x6D,
		0x5E,0x72,0x7B,0x9C,0x9C,0x93,0xA4,0x9A,0x9D,0x97,
		0x9A,0x60,0x49,0x68,0x65,0x92,0x91,0x7C,0x99,0x99,
		0x60,0x84,0x82,0x8B,0x7E,0x93,0x5E,0x98,0x93,0xA1,
		0x81,0x97,0xA4,0xAD,0xC0,0x9E,0x92,0x6F,0x60,0x74,
		0x4D,0x63,0x7A,0x6A,0x61,0x68,0x91,0xA5,0xB5,0xB1,
		0x8E,0x95,0x8A,0x93,0x6C,0x65,0x6C,0x5E,0x62,0x84,
		0x86,0x87,0xAB,0xA7,0x80,0x80,0x80,0x80,0x80,0x80,
		0x80,};
static ymu8	sample30[391]={
		0x84,0x85,0x85,0x84,0x85,0x85,0x86,0x87,0x89,0x92,
		0xA5,0xB2,0xB2,0xA5,0x4D,0x66,0x66,0x89,0x80,0x4D,
		0x4D,0x50,0x98,0x98,0x98,0x98,0x98,0x8B,0x8F,0xB2,
		0xA9,0xAD,0x58,0x4D,0x4D,0x4D,0x72,0x55,0x4D,0x4D,
		0x59,0x98,0xB2,0x53,0x4D,0x63,0x5F,0x4D,0x58,0x66,
		0x72,0x6C,0x80,0xB2,0xB2,0xB2,0xB2,0xAE,0xB2,0xA7,
		0xB2,0x80,0x72,0x87,0xB2,0xB2,0xB2,0x80,0x66,0xA5,
		0x82,0x64,0x4D,0x4D,0x5E,0x4D,0x4D,0x52,0x8B,0xA8,
		0x8B,0xAB,0x9F,0xB2,0xB2,0xB2,0xB2,0xB2,0xA5,0x4D,
		0x55,0x56,0x66,0x5B,0x6F,0x4D,0x4D,0x75,0x6B,0x73,
		0x5F,0x50,0x85,0x5F,0x8F,0xA0,0x8D,0xB2,0xAF,0xAB,
		0xB2,0xB2,0xB2,0x9A,0x84,0x5D,0x72,0x61,0x5F,0x53,
		0x4D,0x4D,0x4D,0x59,0x69,0x94,0xA7,0x8F,0x9F,0xA5,
		0xA6,0x95,0x8B,0x72,0x6E,0x7C,0x81,0x69,0x6F,0x80,
		0xA3,0xAF,0x91,0xA5,0x6E,0x7A,0x67,0x53,0x66,0x4D,
		0x4D,0x4D,0x52,0x4D,0x85,0x4D,0x9D,0xA2,0x9F,0xB2,
		0xB2,0xA5,0x8F,0x7B,0x8C,0x66,0x4D,0x56,0x62,0x75,
		0x56,0x66,0x81,0x9C,0xAB,0x83,0x65,0x80,0x96,0x68,
		0x63,0x5F,0x5E,0x5C,0x63,0x86,0xA3,0xA8,0xAB,0x84,
		0x98,0x79,0x75,0x66,0x4D,0x4D,0x4D,0x4D,0x4D,0x66,
		0x6E,0x98,0xA5,0xB2,0xA7,0xB0,0x98,0x87,0x9F,0x77,
		0x92,0x80,0x9C,0x82,0x89,0xA0,0x9C,0x99,0xA2,0x90,
		0x7B,0x79,0x78,0x80,0x56,0x51,0x52,0x59,0x77,0x79,
		0xA7,0xA5,0xA8,0xAB,0xAE,0xB0,0xAB,0x9A,0x6F,0x83,
		0x66,0x66,0x63,0x7C,0x77,0x8C,0x6B,0x88,0x75,0x77,
		0x88,0x7A,0x82,0x6F,0x7A,0x73,0x76,0x85,0x89,0xA2,
		0x89,0xA3,0xA3,0xA8,0x8B,0x97,0x66,0x76,0x56,0x5B,
		0x56,0x59,0x79,0x5C,0x66,0x69,0x8C,0x80,0x7E,0x79,
		0x68,0x72,0x72,0x82,0x5A,0x70,0x72,0x61,0x8F,0x9E,
		0x79,0x99,0x80,0x7D,0x8A,0x8A,0x7A,0x61,0x66,0x52,
		0x56,0x5D,0x5F,0x6F,0x64,0x9F,0x97,0xA5,0xAB,0xAC,
		0xA3,0x96,0x84,0x5C,0x85,0x82,0x7B,0x5F,0x78,0x74,
		0x6A,0x77,0x7D,0x92,0x92,0x8C,0x97,0x91,0x92,0x8F,
		0x90,0x6B,0x5D,0x70,0x6F,0x8B,0x8B,0x7E,0x90,0x90,
		0x6B,0x82,0x81,0x87,0x7E,0x8C,0x6B,0x8F,0x8C,0x94,
		0x81,0x8E,0x96,0x9C,0xA8,0x93,0x8B,0x75,0x6B,0x78,
		0x5F,0x6D,0x7C,0x72,0x6C,0x71,0x8B,0x97,0xA1,0x9F,
		0x89,0x8D,0x86,0x8C,0x73,0x6F,0x73,0x6B,0x6D,0x83,
		0x84,0x84,0x9B,0x98,0x80,0x80,0x80,0x80,0x80,0x80,
		0x80,};
static ymu8	sample31[407]={
		0x72,0x7A,0x84,0x96,0xB0,0xBC,0xB4,0xA6,0x9A,0xBA,
		0x36,0xFF,0x76,0x00,0x00,0x4E,0xE4,0xFF,0xFF,0xFF,
		0xFF,0x00,0x00,0x00,0x00,0x00,0x00,0xFF,0xFF,0xFF,
		0xFF,0xFF,0xFF,0x00,0x00,0x00,0x00,0x00,0x00,0xFF,
		0xFF,0xFF,0xFF,0x4A,0x12,0x00,0x00,0x00,0x6C,0xE2,
		0x62,0xFF,0xFF,0xFF,0xAC,0x42,0xFF,0xBE,0x96,0x4E,
		0x48,0x00,0x00,0x00,0x00,0x00,0x32,0x62,0xC6,0xFF,
		0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x00,0x00,0x00,0x00,
		0x1A,0x00,0x76,0x8A,0xAC,0x16,0x00,0x00,0x00,0x00,
		0x00,0x26,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
		0xA4,0x54,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
		0x00,0x00,0x00,0x00,0x00,0x76,0x90,0xFF,0xFF,0xFF,
		0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xBA,0xFF,0xB4,0xB4,
		0x00,0x00,0x00,0x00,0x00,0x00,0xD0,0xFF,0x8C,0x00,
		0x00,0x00,0x96,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xC6,
		0x5A,0x88,0x00,0x0E,0x58,0x6A,0x24,0x82,0x38,0xD8,
		0xFF,0xFF,0xCC,0x6A,0x02,0x00,0x00,0x00,0x00,0x92,
		0xFF,0xF2,0xF4,0x66,0x00,0x00,0x00,0x00,0x00,0x00,
		0x00,0x0A,0xD6,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
		0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x3C,0x66,0x26,
		0x00,0x00,0x00,0x04,0x1C,0x00,0x00,0x00,0x00,0x00,
		0x00,0x00,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x8C,
		0x68,0x64,0x66,0xFF,0xE4,0xFF,0x7A,0x06,0x00,0x00,
		0x00,0x00,0x00,0x0E,0x50,0x80,0xC6,0xFF,0xFF,0xFF,
		0xFF,0xFF,0xFF,0xF6,0xFF,0xFF,0xFF,0x8C,0x44,0x4A,
		0x2A,0x00,0x00,0x32,0x00,0x4A,0xC2,0xBC,0xB0,0x2E,
		0x00,0x00,0x00,0x00,0x00,0xE6,0xFF,0xEA,0xFF,0xFF,
		0xFF,0xFF,0xFF,0xC6,0x8A,0x38,0x00,0x00,0x00,0x08,
		0x16,0xB2,0xD8,0xFF,0xD2,0xFF,0x66,0xD4,0x44,0x70,
		0x64,0x9E,0xAC,0xEA,0xFA,0xF0,0xFF,0xF4,0x7A,0xC4,
		0x4C,0x6C,0x6C,0x68,0x1C,0x16,0x60,0x5E,0x38,0x2A,
		0x02,0x00,0x00,0x16,0x02,0x40,0x7C,0x4E,0x2A,0x86,
		0xB8,0x66,0x56,0x86,0x8C,0xBC,0x92,0xC6,0xEC,0xF4,
		0x9E,0x16,0x34,0x40,0x8E,0xAC,0xA6,0xD0,0xD2,0xB6,
		0xEC,0xFF,0xF6,0xFF,0xFF,0xFF,0xFF,0x74,0x96,0x46,
		0x6C,0x42,0x50,0x22,0x00,0x30,0x30,0x24,0x92,0x98,
		0x2E,0x66,0x7C,0x66,0x78,0x62,0x1C,0xA8,0x5A,0xD4,
		0xFF,0xFF,0xD0,0x4C,0x2E,0x00,0x00,0x00,0x00,0x00,
		0x00,0x00,0x5E,0x72,0xA4,0x8A,0xFF,0x96,0x88,0x40,
		0x40,0x2E,0x4C,0xB4,0xE0,0xFF,0xEA,0xFF,0xFE,0xD8,
		0x80,0x80,0x80,0x80,0x80,0x80,0x80,};
static ymu8	sample32[407]={
		0x77,0x7C,0x82,0x8D,0x9D,0xA5,0xA0,0x97,0x90,0xA4,
		0x51,0xCF,0x79,0x30,0x30,0x60,0xBE,0xCF,0xCF,0xCF,
		0xCF,0x30,0x30,0x30,0x30,0x30,0x30,0xCF,0xCF,0xCF,
		0xCF,0xCF,0xCF,0x30,0x30,0x30,0x30,0x30,0x30,0xCF,
		0xCF,0xCF,0xCF,0x5E,0x3B,0x30,0x30,0x30,0x73,0xBD,
		0x6D,0xCF,0xCF,0xCF,0x9B,0x59,0xCF,0xA6,0x8D,0x60,
		0x5D,0x30,0x30,0x30,0x30,0x30,0x4F,0x6D,0xAB,0xCF,
		0xCF,0xCF,0xCF,0xCF,0xCF,0xCF,0x30,0x30,0x30,0x30,
		0x40,0x30,0x79,0x86,0x9B,0x3D,0x30,0x30,0x30,0x30,
		0x30,0x47,0xCF,0xCF,0xCF,0xCF,0xCF,0xCF,0xCF,0xCF,
		0x96,0x64,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0x30,
		0x30,0x30,0x30,0x30,0x30,0x79,0x89,0xCF,0xCF,0xCF,
		0xCF,0xCF,0xCF,0xCF,0xCF,0xCF,0xA4,0xCF,0xA0,0xA0,
		0x30,0x30,0x30,0x30,0x30,0x30,0xB1,0xCF,0x87,0x30,
		0x30,0x30,0x8D,0xCF,0xCF,0xCF,0xCF,0xCF,0xCF,0xAB,
		0x68,0x84,0x30,0x38,0x67,0x72,0x46,0x81,0x53,0xB6,
		0xCF,0xCF,0xAF,0x72,0x31,0x30,0x30,0x30,0x30,0x8B,
		0xCF,0xC7,0xC8,0x6F,0x30,0x30,0x30,0x30,0x30,0x30,
		0x30,0x36,0xB5,0xCF,0xCF,0xCF,0xCF,0xCF,0xCF,0xCF,
		0xCF,0xCF,0xCF,0xCF,0xCF,0xCF,0xCF,0x55,0x6F,0x47,
		0x30,0x30,0x30,0x32,0x41,0x30,0x30,0x30,0x30,0x30,
		0x30,0x30,0xCF,0xCF,0xCF,0xCF,0xCF,0xCF,0xCF,0x87,
		0x71,0x6E,0x6F,0xCF,0xBE,0xCF,0x7C,0x33,0x30,0x30,
		0x30,0x30,0x30,0x38,0x62,0x80,0xAB,0xCF,0xCF,0xCF,
		0xCF,0xCF,0xCF,0xC9,0xCF,0xCF,0xCF,0x87,0x5A,0x5E,
		0x4A,0x30,0x30,0x4F,0x30,0x5E,0xA9,0xA5,0x9D,0x4C,
		0x30,0x30,0x30,0x30,0x30,0xBF,0xCF,0xC2,0xCF,0xCF,
		0xCF,0xCF,0xCF,0xAB,0x86,0x53,0x30,0x30,0x30,0x35,
		0x3D,0x9F,0xB6,0xCF,0xB3,0xCF,0x6F,0xB4,0x5A,0x76,
		0x6E,0x92,0x9B,0xC2,0xCC,0xC5,0xCF,0xC8,0x7C,0xAA,
		0x5F,0x73,0x73,0x71,0x41,0x3D,0x6C,0x6A,0x53,0x4A,
		0x31,0x30,0x30,0x3D,0x31,0x58,0x7D,0x60,0x4A,0x83,
		0xA2,0x6F,0x65,0x83,0x87,0xA5,0x8B,0xAB,0xC3,0xC8,
		0x92,0x3D,0x50,0x58,0x88,0x9B,0x97,0xB1,0xB3,0xA1,
		0xC3,0xCF,0xC9,0xCF,0xCF,0xCF,0xCF,0x78,0x8D,0x5B,
		0x73,0x59,0x62,0x45,0x30,0x4E,0x4E,0x46,0x8B,0x8E,
		0x4C,0x6F,0x7D,0x6F,0x7B,0x6D,0x41,0x98,0x68,0xB4,
		0xCF,0xCF,0xB1,0x5F,0x4C,0x30,0x30,0x30,0x30,0x30,
		0x30,0x30,0x6A,0x77,0x96,0x86,0xCF,0x8D,0x84,0x58,
		0x58,0x4C,0x5F,0xA0,0xBB,0xCF,0xC2,0xCF,0xCE,0xB6,
		0x80,0x80,0x80,0x80,0x80,0x80,0x80,};
static ymu8	sample33[407]={
		0x7B,0x7E,0x81,0x86,0x8F,0x92,0x90,0x8C,0x88,0x92,
		0x68,0xA8,0x7C,0x57,0x57,0x70,0x9F,0xA8,0xA8,0xA8,
		0xA8,0x57,0x57,0x57,0x57,0x57,0x57,0xA8,0xA8,0xA8,
		0xA8,0xA8,0xA8,0x57,0x57,0x57,0x57,0x57,0x57,0xA8,
		0xA8,0xA8,0xA8,0x6E,0x5D,0x57,0x57,0x57,0x79,0x9F,
		0x76,0xA8,0xA8,0xA8,0x8D,0x6C,0xA8,0x93,0x86,0x70,
		0x6E,0x57,0x57,0x57,0x57,0x57,0x67,0x76,0x96,0xA8,
		0xA8,0xA8,0xA8,0xA8,0xA8,0xA8,0x57,0x57,0x57,0x57,
		0x5F,0x57,0x7C,0x83,0x8D,0x5E,0x57,0x57,0x57,0x57,
		0x57,0x63,0xA8,0xA8,0xA8,0xA8,0xA8,0xA8,0xA8,0xA8,
		0x8B,0x72,0x57,0x57,0x57,0x57,0x57,0x57,0x57,0x57,
		0x57,0x57,0x57,0x57,0x57,0x7C,0x85,0xA8,0xA8,0xA8,
		0xA8,0xA8,0xA8,0xA8,0xA8,0xA8,0x92,0xA8,0x90,0x90,
		0x57,0x57,0x57,0x57,0x57,0x57,0x99,0xA8,0x83,0x57,
		0x57,0x57,0x86,0xA8,0xA8,0xA8,0xA8,0xA8,0xA8,0x96,
		0x73,0x82,0x57,0x5B,0x73,0x79,0x62,0x80,0x69,0x9B,
		0xA8,0xA8,0x98,0x79,0x58,0x57,0x57,0x57,0x57,0x85,
		0xA8,0xA4,0xA4,0x77,0x57,0x57,0x57,0x57,0x57,0x57,
		0x57,0x5A,0x9B,0xA8,0xA8,0xA8,0xA8,0xA8,0xA8,0xA8,
		0xA8,0xA8,0xA8,0xA8,0xA8,0xA8,0xA8,0x6A,0x77,0x63,
		0x57,0x57,0x57,0x58,0x60,0x57,0x57,0x57,0x57,0x57,
		0x57,0x57,0xA8,0xA8,0xA8,0xA8,0xA8,0xA8,0xA8,0x83,
		0x78,0x77,0x77,0xA8,0x9F,0xA8,0x7E,0x59,0x57,0x57,
		0x57,0x57,0x57,0x5B,0x70,0x80,0x96,0xA8,0xA8,0xA8,
		0xA8,0xA8,0xA8,0xA5,0xA8,0xA8,0xA8,0x83,0x6D,0x6E,
		0x64,0x57,0x57,0x67,0x57,0x6E,0x94,0x92,0x8F,0x66,
		0x57,0x57,0x57,0x57,0x57,0xA0,0xA8,0xA1,0xA8,0xA8,
		0xA8,0xA8,0xA8,0x96,0x83,0x69,0x57,0x57,0x57,0x5A,
		0x5E,0x8F,0x9B,0xA8,0x99,0xA8,0x77,0x9A,0x6D,0x7A,
		0x77,0x89,0x8D,0xA1,0xA6,0xA3,0xA8,0xA4,0x7E,0x95,
		0x6F,0x79,0x79,0x78,0x60,0x5E,0x75,0x75,0x69,0x64,
		0x58,0x57,0x57,0x5E,0x58,0x6B,0x7E,0x70,0x64,0x81,
		0x91,0x77,0x72,0x81,0x83,0x92,0x85,0x96,0xA2,0xA4,
		0x89,0x5E,0x67,0x6B,0x84,0x8D,0x8C,0x99,0x99,0x91,
		0xA2,0xA8,0xA5,0xA8,0xA8,0xA8,0xA8,0x7C,0x86,0x6D,
		0x79,0x6C,0x70,0x62,0x57,0x66,0x66,0x62,0x85,0x87,
		0x66,0x77,0x7E,0x77,0x7D,0x76,0x60,0x8C,0x73,0x9A,
		0xA8,0xA8,0x99,0x6F,0x66,0x57,0x57,0x57,0x57,0x57,
		0x57,0x57,0x75,0x7B,0x8B,0x83,0xA8,0x86,0x82,0x6B,
		0x6B,0x66,0x6F,0x90,0x9E,0xA8,0xA1,0xA8,0xA7,0x9B,
		0x80,0x80,0x80,0x80,0x80,0x80,0x80,};
static ymu8	sample34[317]={
		0x80,0x80,0x86,0x8A,0x88,0x9C,0xD0,0x78,0xB6,0xBA,
		0xCA,0xBC,0xBA,0xEA,0x82,0xB8,0x8A,0xB2,0x70,0x82,
		0x7C,0x6A,0x3C,0x10,0x00,0x54,0x14,0x00,0xFF,0x00,
		0x7E,0x00,0x00,0x00,0x00,0x16,0x28,0x38,0x44,0x4E,
		0x58,0x60,0x66,0x00,0x00,0x00,0x00,0x00,0x2C,0x8A,
		0xE4,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
		0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
		0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
		0xE0,0x6E,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
		0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
		0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
		0x00,0x00,0x00,0x00,0x2A,0x38,0x4C,0x5C,0x6C,0x7E,
		0x8A,0x98,0x90,0x90,0xA6,0x9E,0xAA,0xBC,0x9A,0xC8,
		0xC4,0x8A,0x9E,0xCA,0xD8,0xDA,0xF8,0xFF,0xFF,0xFF,
		0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
		0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
		0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
		0xFF,0xFF,0xE2,0xC4,0xA2,0x76,0x44,0x2E,0x08,0x00,
		0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
		0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
		0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
		0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
		0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
		0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x1E,0x4A,0x6E,
		0x94,0xBE,0xE8,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
		0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
		0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
		0xFF,0xFE,0xD8,0xB6,0x90,0x7A,0x5C,0x46,0x30,0x1E,
		0x06,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
		0x02,0x12,0x1E,0x2C,0x3C,0x44,0x52,0x66,0x6E,0x7A,
		0x7E,0x88,0x8C,0x90,0x8C,0x8E,0x8C,0x88,0x80,0x7A,
		0x80,0x80,0x80,0x80,0x80,0x80,0x80,};
static ymu8	sample35[407]={
		0x7E,0x80,0x80,0x7C,0x74,0x74,0x7E,0x84,0x8A,0xA2,
		0x5A,0x3C,0x02,0x28,0xFF,0xFF,0xFF,0xF2,0x88,0x00,
		0x00,0x00,0x00,0x00,0x3C,0xEE,0xFF,0xFF,0xFF,0xFF,
		0xFF,0xFF,0x34,0x26,0x00,0x02,0x5C,0xAC,0x8E,0x00,
		0x00,0x00,0x00,0x00,0x40,0x82,0xFC,0xE0,0xEE,0xFF,
		0xFF,0xFF,0xFF,0xFF,0xE6,0xDE,0x92,0x56,0x00,0x00,
		0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x0C,0x5C,0x78,
		0xD6,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
		0xFF,0xFF,0x8C,0x52,0x00,0x06,0x1E,0x00,0x00,0x00,
		0x00,0x00,0x00,0x00,0x00,0x06,0x66,0xB0,0xEE,0xFF,
		0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xCA,0xBC,0xC0,0x38,
		0x46,0x7C,0x64,0x0C,0x00,0x38,0x0E,0x00,0x00,0x00,
		0x5A,0x48,0x8E,0xC0,0x62,0xC4,0xFF,0xFF,0xFF,0xB8,
		0x76,0xB8,0xCE,0xFF,0x94,0x40,0x7C,0x0E,0x4C,0x48,
		0x68,0x24,0x9A,0x3C,0x0C,0x00,0x20,0x58,0xFC,0x90,
		0x98,0xFF,0xBE,0xB2,0xBE,0xA2,0xBC,0x26,0x5E,0x7C,
		0xAE,0xEA,0xA8,0x78,0x66,0xB4,0x7E,0xC4,0xFF,0x00,
		0x00,0x3E,0x70,0x66,0x00,0x56,0xEA,0x00,0x9E,0xFF,
		0x3E,0x00,0x7C,0xFF,0x6C,0x28,0xFF,0xFF,0x7C,0x78,
		0xFF,0x96,0x04,0x9E,0xDC,0xFF,0x0E,0x00,0x54,0x14,
		0xA0,0xDC,0x50,0x84,0x82,0x00,0x00,0x70,0xC4,0x00,
		0x5E,0xF8,0x00,0x26,0xFF,0xEA,0xCA,0x84,0x9A,0x7E,
		0xFF,0xE2,0xC2,0x64,0xA6,0x32,0x0A,0xC2,0x22,0x3C,
		0x18,0xA6,0x62,0x10,0x02,0x7A,0x00,0x4C,0xD0,0x5A,
		0xFE,0xE0,0x80,0x5C,0x9C,0xFF,0xFF,0xB6,0x92,0x44,
		0x96,0x76,0x0E,0xB0,0x40,0xCC,0xA6,0x48,0x06,0x0E,
		0x90,0x00,0x00,0xC0,0xC6,0x82,0x4E,0xB4,0xFF,0x92,
		0xAC,0x60,0x62,0xA2,0x98,0xFF,0xB6,0xEE,0x68,0x54,
		0xA2,0x52,0x86,0x2A,0x92,0x4A,0x74,0x9A,0x68,0x0C,
		0xE0,0x8E,0x2A,0x5C,0x4C,0x38,0x40,0x88,0x52,0x94,
		0xBA,0xD2,0xBE,0xE8,0x56,0x16,0x42,0x80,0x54,0xFF,
		0xBA,0xAA,0xB6,0x64,0x74,0xD0,0xAE,0x66,0x68,0x8A,
		0x70,0x36,0x16,0x28,0x2A,0x82,0x88,0xAE,0x94,0x52,
		0x72,0x86,0x5A,0x94,0xB6,0xFF,0xA4,0x78,0xB8,0xD2,
		0x70,0x6E,0xE2,0x72,0xA4,0x7E,0x5A,0x42,0x3E,0x64,
		0x68,0x76,0x0A,0x4A,0x00,0x42,0x24,0x56,0x80,0x50,
		0x7E,0xB2,0xBC,0xB2,0xCE,0xD4,0xDE,0xCE,0xFF,0x7A,
		0xBE,0x9A,0x8C,0x8E,0x68,0x00,0x2A,0x36,0x3C,0x88,
		0xA6,0x7C,0x7C,0x7A,0x5C,0x96,0x5C,0x08,0x8A,0x7A,
		0x88,0xB2,0xF4,0xCC,0x6C,0xF0,0xC2,0x9C,0xDC,0x9A,
		0x80,0x80,0x80,0x80,0x80,0x80,0x80,};
static ymu8	sample36[311]={
		0x82,0xA0,0x78,0x88,0xA6,0xAC,0x72,0xBC,0x2C,0xC4,
		0x52,0x86,0xA4,0x28,0xFF,0x00,0xFF,0x2A,0x7A,0xFF,
		0x00,0xFF,0x64,0x3A,0x8C,0x38,0xB6,0x26,0xFF,0x00,
		0xFF,0x00,0xCE,0x44,0x5C,0x6A,0x50,0x6E,0x20,0x58,
		0x86,0x66,0x00,0xBA,0x10,0xB8,0x5E,0x26,0xDA,0x32,
		0xFA,0xB6,0xFF,0xD8,0xFF,0xE2,0xFF,0xDC,0xFF,0xF0,
		0xFF,0xDE,0xC8,0xFF,0xB4,0x8E,0x96,0x68,0xA2,0x1A,
		0xB6,0x00,0x72,0x24,0x36,0x04,0x28,0x08,0x0E,0x00,
		0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
		0x00,0x00,0x0E,0x0A,0x1E,0x40,0x5C,0x6E,0x6C,0x70,
		0xB0,0x7E,0xD6,0xE0,0xFF,0xFF,0xF8,0xFF,0xFF,0xFF,
		0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
		0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xF4,0xE0,0xA2,
		0xD4,0x64,0xB8,0x60,0x18,0x3E,0x22,0x00,0x18,0x00,
		0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
		0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
		0x00,0x00,0x00,0x00,0x00,0x08,0x00,0x1A,0x24,0x34,
		0x48,0x40,0x7A,0x60,0xA8,0x98,0xCE,0xDA,0xD0,0xFF,
		0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
		0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
		0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFE,
		0xB4,0xB2,0x92,0x8A,0x62,0x50,0x42,0x1C,0x16,0x00,
		0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
		0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
		0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
		0x00,0x12,0x18,0x34,0x3E,0x58,0x7A,0x88,0x94,0xC4,
		0xD2,0xF2,0xF2,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
		0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
		0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
		0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xEC,0xE0,0xCE,0xC8,
		0xA6,0xAA,0x74,0x90,0x80,0x80,0x80,0x80,0x80,0x80,
		0x80,};
static ymu8	sample37[459]={
		0x81,0x82,0x85,0x85,0x81,0x7E,0x7A,0x77,0x30,0x00,
		0x4B,0x94,0xEF,0xDF,0xC2,0xFF,0x00,0xFF,0xFF,0xFF,
		0xFF,0x00,0x6D,0x0F,0x17,0x00,0x10,0x00,0x00,0x00,
		0x00,0x30,0x08,0x00,0x84,0x6F,0xE9,0xFF,0xFF,0xFF,
		0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xAF,0x04,
		0x20,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
		0x00,0x00,0x1F,0x00,0x00,0xFF,0xE6,0xEF,0xFF,0xFF,
		0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xD4,
		0x5E,0x40,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
		0x00,0x00,0x00,0x13,0x30,0x86,0xCF,0xEE,0xFF,0xEE,
		0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
		0xF5,0xC3,0x71,0x48,0x21,0x00,0x00,0x00,0x00,0x00,
		0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x08,0x3A,0x78,
		0xAD,0xF5,0xFE,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
		0xFF,0xFF,0xCF,0xF7,0xBE,0x98,0x1A,0x47,0x07,0x00,
		0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x3C,
		0xB0,0xAB,0xC7,0xFA,0xF9,0xFF,0xF9,0xFF,0xFF,0xFF,
		0xFF,0xFF,0xFF,0xE6,0xFF,0xE3,0xCE,0xA2,0xAD,0x1A,
		0x41,0x16,0x00,0x04,0x04,0x22,0x00,0x00,0x00,0x00,
		0x04,0x25,0x75,0x4B,0x87,0xCB,0xEB,0xFF,0xF7,0xFF,
		0xFF,0xE8,0x8E,0xFA,0xFF,0xE3,0xFE,0x44,0x86,0xEF,
		0x75,0x21,0x59,0xC8,0x3B,0x07,0x32,0x37,0xB0,0x18,
		0x05,0xCE,0x4A,0x18,0x13,0x50,0x73,0x95,0x07,0x9D,
		0xC6,0xE5,0xC8,0xEE,0xCE,0xB0,0x8D,0x85,0xB5,0xA0,
		0x9A,0x86,0xEF,0xA5,0x8A,0xA9,0x83,0xF6,0x8B,0x60,
		0x80,0x16,0x02,0x8E,0x33,0x07,0x77,0x92,0x4C,0x08,
		0x98,0x70,0x70,0x55,0x4B,0xBE,0x78,0x2F,0xB9,0x56,
		0xBB,0x66,0xA5,0x83,0xBB,0xA8,0xD7,0x5E,0xE7,0x89,
		0xBD,0xEA,0xB7,0xB7,0xB4,0x57,0x82,0x83,0x68,0x7A,
		0xA4,0x61,0x4E,0x2A,0x3E,0x22,0x6E,0x46,0x1E,0x7B,
		0x23,0x88,0x91,0x75,0xA1,0xCF,0x80,0xC3,0x60,0x8C,
		0xB3,0x88,0xD3,0xB1,0x75,0xA5,0xD7,0xDD,0xD2,0x78,
		0x4C,0x62,0x74,0x34,0x86,0xC6,0x7B,0x58,0x03,0x5B,
		0x93,0x29,0x5B,0x4F,0x3C,0xA6,0x6A,0x56,0x8D,0x9E,
		0x5F,0x6B,0xCB,0x6C,0x5C,0xC9,0x8C,0x87,0x95,0x5D,
		0x9C,0xE2,0xDA,0x79,0xA9,0x87,0x96,0x99,0x8B,0x60,
		0xA6,0xA3,0x8C,0xB2,0x60,0x92,0x63,0x94,0x0F,0x7D,
		0x32,0x3F,0x6D,0x3A,0x66,0x5E,0x81,0x85,0x8E,0x77,
		0x53,0x7B,0xD5,0xA9,0xC3,0x9F,0x97,0xBC,0x9C,0xAA,
		0xA5,0x6F,0xB0,0xB6,0x96,0x51,0x46,0x76,0x76,0x4C,
		0x44,0x3D,0x70,0x3B,0x4C,0x3C,0x42,0x51,0x91,0x9B,
		0x65,0xBA,0x99,0x96,0x69,0x6F,0x9C,0xA0,0xA6,0xCA,
		0x80,0x9B,0x93,0xC1,0x8F,0x8A,0xAD,0x70,0x73,0x95,
		0x47,0xA2,0xAB,0x54,0x8D,0x4F,0x7A,0x7D,0x6D,0x87,
		0x48,0x80,0x69,0x69,0x5F,0x7C,0x5E,0x72,0x5C,0x8E,
		0x59,0x93,0x80,0x80,0x80,0x80,0x80,0x80,0x80,};
static ymu8	sample38[329]={
		0xAE,0xAC,0x84,0x7A,0x52,0x5C,0x5C,0x24,0xFF,0xFF,
		0x8E,0x00,0x00,0x76,0xFF,0xFF,0xFF,0xFF,0xDE,0x5A,
		0x00,0x00,0x7A,0xCC,0xFF,0xFF,0x00,0x3A,0x00,0x00,
		0x00,0x02,0x70,0xFF,0xDA,0xFF,0xFF,0xFF,0xFF,0xFF,
		0xFF,0xFF,0xFF,0xB6,0x14,0x00,0x00,0x00,0x00,0x00,
		0x00,0x00,0x00,0x00,0x00,0x00,0xC8,0xFF,0xFF,0xFF,
		0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFC,
		0x52,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
		0x00,0x00,0x34,0xF4,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
		0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xDE,0xA0,0x5C,
		0x52,0x02,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
		0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x44,0x8A,0xBC,
		0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
		0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xBC,0x46,0x00,
		0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
		0x00,0x00,0x00,0x00,0x00,0x02,0x3E,0xDE,0xF8,0xFF,
		0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xF6,0xFA,0xD2,
		0xEE,0xDC,0xBC,0xA2,0xA0,0xE2,0xFF,0xFF,0xFF,0xFF,
		0xFF,0xFF,0xFF,0xFF,0xFF,0xEA,0xCC,0x90,0x50,0x12,
		0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
		0x00,0x00,0x00,0x26,0x56,0x66,0x6C,0x70,0x74,0x90,
		0xB6,0xE6,0xFF,0xFF,0xFF,0xFC,0xE6,0xCC,0xB4,0xB8,
		0xB4,0xDE,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
		0xFF,0xFF,0xFF,0xFF,0xFF,0xE6,0xA6,0x64,0x42,0x2E,
		0x0A,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
		0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x02,0x1E,0x4C,
		0x4A,0x68,0x84,0x96,0x9E,0xC4,0xE2,0xFF,0xFF,0xFF,
		0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
		0xFF,0xFF,0xFF,0xFF,0xFF,0xE4,0xD4,0xB2,0x88,0x74,
		0x4E,0x42,0x2E,0x1E,0x22,0x1C,0x32,0x30,0x28,0x1E,
		0x20,0x06,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
		0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x04,0x32,
		0x6E,0x88,0x80,0x80,0x80,0x80,0x80,0x80,0x80,};
static ymu8	sample39[656]={
		0x8A,0x42,0x00,0x00,0x0E,0x00,0x00,0x00,0x00,0x3C,
		0x7A,0xC0,0xDC,0xCE,0xFF,0xFF,0xBC,0xFF,0xFF,0xF4,
		0xFF,0xFF,0xE4,0xC8,0x6E,0x28,0x44,0x00,0x08,0x00,
		0x00,0x00,0x00,0x00,0x60,0x64,0x22,0x8E,0xFF,0xE8,
		0xBA,0xB0,0xFA,0xFF,0xFF,0xFF,0xFF,0xFF,0xEC,0xB6,
		0x84,0x5C,0x60,0x26,0x00,0x00,0x00,0x00,0x00,0x00,
		0x00,0x00,0x9A,0x02,0x44,0x34,0x98,0x3E,0x5A,0xFF,
		0xF0,0xFF,0xFF,0xFF,0xFF,0x9A,0x46,0x2A,0x00,0x00,
		0x00,0x00,0x4C,0x3E,0xC2,0x66,0x00,0x00,0x1E,0x7A,
		0xF4,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
		0xE4,0x54,0x32,0x4E,0x0A,0x00,0x00,0x00,0x00,0x00,
		0x00,0x00,0x00,0x00,0x22,0x60,0x34,0x82,0x8E,0xCE,
		0xE4,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xDE,0x78,
		0x00,0x00,0x58,0x36,0x32,0x10,0x00,0x20,0x00,0x00,
		0x0E,0x00,0x22,0xA4,0xB2,0xFF,0xCC,0xF4,0xB0,0xEA,
		0x74,0xCE,0xA6,0xCE,0x78,0x34,0x00,0x1A,0x24,0x00,
		0x00,0x00,0xF2,0x50,0x60,0x1E,0x72,0x8C,0x84,0x4E,
		0xEC,0xCE,0xFF,0xFF,0xFF,0xFF,0xF8,0x74,0xA2,0xE6,
		0xC2,0x16,0x10,0x9A,0x9E,0x2A,0x96,0x70,0x06,0x0E,
		0x00,0x00,0x00,0x00,0x00,0x22,0x00,0x00,0x72,0x9E,
		0x94,0xFF,0xDE,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xD6,
		0x86,0x14,0x68,0x12,0x00,0x40,0x4E,0x00,0x00,0x96,
		0x00,0x22,0x4E,0x4A,0x90,0xFF,0xFF,0xFF,0xFF,0xFF,
		0xFF,0x56,0xAA,0xE2,0x9A,0x32,0xDC,0x00,0x60,0xA8,
		0x2A,0x00,0x76,0x00,0x64,0x80,0x74,0x00,0x82,0x28,
		0x98,0x46,0xAC,0x70,0xAA,0xD8,0xF2,0xA8,0x8E,0x8C,
		0x82,0xC2,0x44,0xC0,0x8E,0x6E,0xBC,0x26,0xE0,0x4C,
		0x5C,0x6E,0x26,0x46,0x00,0x32,0x00,0x9A,0x68,0x38,
		0xD8,0x5C,0xDC,0xCA,0xD8,0xF8,0x9C,0xFE,0xFF,0xEE,
		0xFF,0xBE,0xC8,0x34,0x6E,0x26,0x00,0x04,0x00,0x7A,
		0x0A,0x78,0x10,0x5C,0x44,0x88,0xB2,0x90,0xFF,0xDE,
		0xFF,0xFF,0xFF,0xEA,0xC6,0xC4,0xB4,0x76,0x50,0x08,
		0x6E,0x5E,0x44,0x9A,0x54,0x3C,0x8E,0x2C,0x5C,0x52,
		0x44,0x1C,0xA0,0x7E,0xFF,0xD8,0xC8,0xFF,0xF6,0x9E,
		0xA4,0x88,0xC8,0x62,0xBA,0x26,0x42,0x00,0x48,0x2C,
		0x6C,0x24,0x92,0x36,0x44,0x92,0xF2,0x80,0x84,0xA6,
		0xD8,0x88,0xD8,0x90,0xA0,0xC0,0xAC,0xEC,0x8A,0xB4,
		0xC8,0xA6,0x5C,0x88,0x4A,0x4E,0x6A,0x76,0x6C,0xCA,
		0x30,0x3C,0x7E,0x2E,0x50,0x00,0x7C,0x66,0x5E,0x9A,
		0x9C,0xFF,0xD2,0xFF,0xDE,0x9E,0xDE,0x80,0xEE,0xB8,
		0x64,0x46,0x8A,0x0A,0x22,0x58,0x48,0x58,0x2A,0x72,
		0x3E,0xA8,0x54,0x46,0xD6,0x5C,0xFC,0xA8,0xC8,0xE0,
		0xC0,0xA6,0x5C,0x80,0x24,0x34,0x7E,0x4C,0x9A,0x62,
		0x64,0x68,0x94,0x62,0x42,0x72,0xCE,0x72,0xB0,0xAC,
		0xB8,0x9A,0x8E,0x80,0x30,0x24,0x1E,0x70,0x14,0x50,
		0x86,0x64,0xA2,0xB2,0xBC,0xBE,0xDA,0xCE,0xDC,0xFA,
		0xB4,0x7A,0x92,0x38,0x58,0x0E,0x5E,0x56,0x56,0x54,
		0x34,0x80,0x54,0x78,0x46,0x38,0xA2,0x94,0x90,0xB0,
		0xB8,0xAE,0xEA,0x90,0x78,0x92,0x96,0x58,0x8C,0x4A,
		0x56,0x50,0x40,0x66,0x68,0x66,0x80,0x72,0x62,0x64,
		0x9C,0x58,0x6E,0x62,0xE2,0x72,0xD0,0xC4,0x7E,0xAE,
		0x64,0x8A,0x5C,0x52,0x66,0x5A,0x90,0x6E,0x70,0xA4,
		0xFF,0x6C,0xBA,0x74,0xE0,0x56,0x7A,0xAE,0x4A,0x70,
		0x80,0x80,0x9A,0x86,0x5E,0xAC,0x90,0xA0,0xA8,0x74,
		0x9C,0xB0,0x7A,0xA4,0x66,0x7A,0xB6,0x6A,0x5E,0x7E,
		0x74,0x52,0x72,0x58,0x5E,0x5C,0xA2,0x68,0x88,0x96,
		0xBE,0xD2,0xAA,0xB2,0x6A,0x66,0x6C,0x6E,0x56,0x68,
		0x70,0x52,0x48,0x70,0x7A,0x32,0x82,0x9A,0x62,0x56,
		0xAC,0x84,0xAA,0x92,0xE0,0xE2,0xCC,0xC2,0xAA,0x72,
		0x74,0x6C,0x4C,0x46,0x54,0x68,0x42,0x6E,0x5E,0x74,
		0x8E,0x6E,0x98,0xC4,0x76,0x98,0xBE,0x92,0xAA,0xA8,
		0xB2,0x9C,0xA4,0x82,0xC0,0x88,0x6E,0x52,0x70,0x2E,
		0x28,0x54,0x4E,0x5A,0xAC,0x62,0x8C,0xC0,0x7E,0x74,
		0x92,0x8A,0xB2,0xA4,0x8A,0x7A,0x9E,0x62,0x7E,0x92,
		0x74,0xA8,0x7A,0x8A,0x94,0x50,0x9C,0x90,0x80,0x80,
		0x80,0x80,0x80,0x80,0x80,0x80,};
/***********************************************************/

ymu8 *sampleAdress[40] = {
		sample00,sample01,sample02,sample03,sample04,sample05,sample06,sample07,
		sample08,sample09,sample10,sample11,sample12,sample13,sample14,sample15,
		sample16,sample17,sample18,sample19,sample20,sample21,sample22,sample23,
		sample24,sample25,sample26,sample27,sample28,sample29,sample30,sample31,
		sample32,sample33,sample34,sample35,sample36,sample37,sample38,sample39,};

/***********************************************************/

ymu32 sampleLen[40] = {
		  631,  631,  490,  490,  699,  505,  727,  480,
		 2108, 4231,  378, 1527,  258,  258,  451, 1795,
		  271,  633, 1379,  147,  139,   85,  150,  507,
		  230,  120,  271,  293,  391,  391,  391,  407,
		  407,  407,  317,  407,  311,  459,  329,  656,};

/*********************** END OF FILE ***********************/
