#include "xev.h"
#include "enemy.h"

PRIVATE Pixmap pixmap[6],pixmap_mask[6];
PRIVATE GC gc[6];
PRIVATE int sol_anim[48] = {
      1,1,1,1,1,1,1,1,
      2,2,2,2,2,2,2,2,
      3,3,3,3,3,3,3,3,
      4,4,4,4,4,4,4,4,
      5,5,5,5,5,5,5,5,
      5,5,5,5,5,5,5,5
};

PRIVATE int c_size[40] = {
      32,32,32,32,32,32,32,32,
      32,32,32,32,32,32,32,32,
      32,32,32,32,32,32,32,32,
      64,64,64,64,64,64,64,64,
      64,64,64,64,64,64,64,64
};
PRIVATE char *fn[] = {
      "shiba.img",
      "sol5.img",
      "sol4.img",
      "sol3.img",
      "sol21.img",
      "sol22.img",
      "sol23.img",
      "sol24.img",
      "sol11.img",
      "sol12.img",
      "sol13.img",
      "sol14.img"
};

void SolSetChar()
{
      int c_no,i;
      char img[CSIZE*CSIZE*4],img1[CSIZE*CSIZE];
      char img2[CSIZE*CSIZE],img3[CSIZE*CSIZE],img4[CSIZE*CSIZE];
      char mask2[512],mask[128];
      XGCValues gcv;

      gcv.graphics_exposures = False;
      for(i = 0 ; i < 2 ; i++) {
	    int x,y;
	    sprintf(tpath , "%s/%s",IMAGE_DIR,fn[i*4+4]);
            LoadChar(tpath,img1 , sizeof(img1));
	    
	    sprintf(tpath , "%s/%s",IMAGE_DIR,fn[i*4+5]);
            LoadChar(tpath,img2 , sizeof(img2));

	    sprintf(tpath , "%s/%s",IMAGE_DIR,fn[i*4+6]);
            LoadChar(tpath,img3 , sizeof(img3));
	    
	    sprintf(tpath , "%s/%s",IMAGE_DIR,fn[i*4+7]);
            LoadChar(tpath,img4 , sizeof(img4));
	    
	    
	    for(y = 0 ; y < CSIZE ; y++)
	      for(x = 0 ; x < CSIZE ; x++) {
		    img[x+y*CSIZE*2] = img1[y*CSIZE+x];
		    img[x+CSIZE+y*CSIZE*2] = img2[y*CSIZE+x];
		    img[x+(y+CSIZE)*CSIZE*2] = img3[y*CSIZE+x];
		    img[x+CSIZE+(y+CSIZE)*CSIZE*2] = img4[y*CSIZE+x];
	      }
	    pixmap[i+4] = XCreatePixmap(d,w,64,64,depth);
	    gc[i+4] = XCreateGC(d,w,GCGraphicsExposures,&gcv);
	    bzero(mask2 , sizeof(mask2));
	      
	    for(y = 0 ; y < CSIZE*2 ; y++)
              for(x = 0 ; x < CSIZE*2 ; x++) {
                    if(img[y*CSIZE*2+x] != 100) {
                          mask2[y*8+x/8] |= (1<< (x%8));
                          XSetForeground(d,gc[i+4],
                                         pixel[img[y*CSIZE*2+x]]);
                          XDrawPoint(d,pixmap[i+4],gc[i+4],x,y);
                    }
              }
	    pixmap_mask[i+4] 
	      = XCreateBitmapFromData(d,w,mask2,64,64);
            XSetClipMask(d,gc[i+4],pixmap_mask[i+4]);
      }
      
      for(c_no = 0 ; c_no < 4 ; c_no++) {
	    int x,y;
            sprintf(tpath , "%s/%s",IMAGE_DIR,fn[c_no]);
            LoadChar(tpath,img1 , sizeof(img1));
	    
            pixmap[c_no] = XCreatePixmap(d,w,CSIZE,CSIZE,depth);
            bzero(mask , sizeof(mask));
            gc[c_no] = XCreateGC(d,w,GCGraphicsExposures,&gcv);

            for(y = 0 ; y < CSIZE ; y++)
              for(x = 0 ; x < CSIZE ; x++) {
                    if(img1[y*CSIZE+x] != 100) {
                          mask[y*4+x/8] |= (1<< (x%8));
                          XSetForeground(d,gc[c_no],
                                         pixel[img1[y*CSIZE+x]]);
                          XDrawPoint(d,pixmap[c_no],gc[c_no],x,y);
                    }
              }
            pixmap_mask[c_no] 
              = XCreateBitmapFromData(d,w,mask,CSIZE,CSIZE);
            XSetClipMask(d,gc[c_no],pixmap_mask[c_no]);
      }
      
}

void SolFree()
{
      int i;
      
      for(i = 0 ; i > 6 ; i++) {
            XFreePixmap(d,pixmap[i]);
            XFreePixmap(d,pixmap_mask[i]);
	    XFreeGC(d,gc[i]);
      }
}


int Sol(enemy_no)
     int enemy_no;
{
      int sx,sy;
      
      sx = enemy_chijou[enemy_no].x.sht[UNION];
      sy = enemy_chijou[enemy_no].y.sht[UNION];
      
      enemy_chijou[enemy_no].y.dummy += STPF*65536;
      
      enemy_chijou[enemy_no].tmp1 +=
        (enemy_chijou[enemy_no].tmp1 < 39)*enemy_chijou[enemy_no].tmp2;
      
      if(enemy_chijou[enemy_no].tmp2) {
	    SetSprite(sx,sy,pixmap[sol_anim[enemy_chijou[enemy_no].tmp1]],
		      gc[sol_anim[enemy_chijou[enemy_no].tmp1]],
		      c_size[enemy_chijou[enemy_no].tmp1],
		      c_size[enemy_chijou[enemy_no].tmp1]);
      }
      
      
      if(sy > YSIZE) {
            enemy_chijou[enemy_no].enemy_no = 0;
      }
      
      if((jx.sht[UNION] - sx) > -20 &&
         (jx.sht[UNION] - sx) < 20 &&
         (jy.sht[UNION] - sy) > 192 &&
         (jy.sht[UNION] - sy) < 224)
        shojun_flag = 1;

      if(shot_chi.z == 1) {
	    if((shot_chi.x.sht[UNION] - sx) > -10 &&
	       (shot_chi.x.sht[UNION] - sx) < 32 &&
	       (shot_chi.y.sht[UNION] - sy) > -10 &&
	       (shot_chi.y.sht[UNION] - sy) < 42) {
		  if(!enemy_chijou[enemy_no].tmp2) {
			enemy_chijou[enemy_no].tmp2 = STPF/2;
			score += 1000;
		  } else {
			if(enemy_chijou[enemy_no].tmp1 >= 38) {
			      BombCInit(enemy_no);
			      score += 1000;
			      return 1;
			}
		  }
	    }
      }else{
	    return 0;
      }
}

