/*
 *========================================================================
 * $Id: xmlsysd_startup.c 133 2004-02-21 15:49:06Z rgb $
 *
 * See copyright in copyright.h and the accompanying file COPYING
 *========================================================================
 */


#include "xmlsysd.h"

/*
 * This routine handles all default initialization and command line
 * parsing, as well as sundry other startup activity.
 */

void xmlsysd_startup()
{

 int i;

 /*
  * Space required for strtok() in parse().
  */
 fields = (char **) malloc((size_t) (MAXFIELDNUMBER*sizeof(char*)));
 for(i = 0;i < MAXFIELDNUMBER;i++) {
   fields[i] = (char *) malloc((size_t)(MAXFIELDNUMBER*K*sizeof(char)));
 }

 /*
  * Curiously, looks like we need to be more careful with file
  * descriptors to avoid leaking.  We null this vector of file
  * descriptors so we can treat it more carefully in init_stats().
  * Basically we open files only ONE TIME and leave them open
  * forever.  The old way we reopened without closing and leaked
  * file descriptors.  This is a bad idea.  We don't close and
  * reopen to avoid the overhead; it is harmless to hold a
  * half-dozen descriptors in proc open indefinitely.
  */
 for(i = 0;i < N_SOURCES;i++){
   stat_fd[i] = 0;
 }

 /* Create linked lists for users and tasks */
 dctl.userlist = newlist();
 dctl.uidlist = newlist();
 dctl.tasklist = newlist();

}	/* End of xmlsysd_startup() */
