/*
 * (C)opyright MMIV-MMV Anselm R. Garbe <garbeam at gmail dot com>
 * See LICENSE file for license details.
 */

#include <X11/Xlib.h>

#define DEFAULT_FT_FAM	  "fixed"
#define DEFAULT_F_TEXT	  "#eeeeee"
#define DEFAULT_N_TEXT	  "#bbbbbb"
#define DEFAULT_F_BG		"#506070"
#define DEFAULT_N_BG		"#222222"
#define DEFAULT_F_BORDER	"#708090"
#define DEFAULT_N_BORDER	"#000000"

typedef enum {
	CENTER, WEST, NWEST, NORTH, NEAST, EAST,
	SEAST, SOUTH, SWEST
}               Align;

typedef struct Draw Draw;

struct Draw {
	Drawable        drawable;
	GC              gc;
	unsigned long   bg;
	unsigned long   fg;
	unsigned long   border;
	Align           align;
	XFontStruct    *font;
	XRectangle      rect;	/* relative rect */
	XRectangle     *notch;	/* relative notch rect */
	char           *data;
};

/* draw.c */
XFontStruct    *blitz_getfont(Display * dpy, char *fontstr);
unsigned long   blitz_loadcolor(Display * dpy, int mon, char *colstr);
void            blitz_drawlabel(Display * dpy, Draw * r);
void            blitz_drawmeter(Display * dpy, Draw * r);
void            blitz_drawlabelnoborder(Display * dpy, Draw * r);

/* geometry.c */
int blitz_strtorect(XRectangle * root, XRectangle * r, char *val);
int             blitz_ispointinrect(int x, int y, XRectangle * r);
int             blitz_distance(XRectangle * origin, XRectangle * target);
void 
blitz_getbasegeometry(void **items, unsigned int *size,
		      unsigned int *cols, unsigned int *rows);

/* mouse.c */
char           *blitz_buttontostr(unsigned int button);
unsigned int    blitz_strtobutton(char *val);

/* kb.c */
char           *blitz_modtostr(unsigned long mod);
unsigned long   blitz_strtomod(char *val);

/* util.c */
long long 
_strtonum(const char *numstr, long long minval,
	  long long maxval);
