###################################################
# client calls generator
# Copyright tridge@samba.org 2003
# Copyright jelmer@samba.org 2005-2006
# released under the GNU GPL

package Parse::Pidl::Samba4::NDR::Client;

use Parse::Pidl::Samba4 qw(choose_header is_intree);

use vars qw($VERSION);
$VERSION = '0.01';

use strict;

my($res,$res_hdr);

#####################################################################
# parse a function
sub ParseFunction($$)
{
	my ($interface, $fn) = @_;
	my $name = $fn->{NAME};
	my $uname = uc $name;

	$res_hdr .= "\nstruct rpc_request *dcerpc_$name\_send(struct dcerpc_pipe *p, TALLOC_CTX *mem_ctx, struct $name *r);
NTSTATUS dcerpc_$name(struct dcerpc_pipe *p, TALLOC_CTX *mem_ctx, struct $name *r);
";

	$res .= "
struct rpc_request *dcerpc_$name\_send(struct dcerpc_pipe *p, TALLOC_CTX *mem_ctx, struct $name *r)
{
	if (p->conn->flags & DCERPC_DEBUG_PRINT_IN) {
		NDR_PRINT_IN_DEBUG($name, r);
	}
	
	return dcerpc_ndr_request_send(p, NULL, &dcerpc_table_$interface->{NAME}, DCERPC_$uname, mem_ctx, r);
}

NTSTATUS dcerpc_$name(struct dcerpc_pipe *p, TALLOC_CTX *mem_ctx, struct $name *r)
{
	struct rpc_request *req;
	NTSTATUS status;
	
	req = dcerpc_$name\_send(p, mem_ctx, r);
	if (req == NULL) return NT_STATUS_NO_MEMORY;

	status = dcerpc_ndr_request_recv(req);

	if (NT_STATUS_IS_OK(status) && (p->conn->flags & DCERPC_DEBUG_PRINT_OUT)) {
		NDR_PRINT_OUT_DEBUG($name, r);		
	}
";
    
        if (defined($fn->{RETURN_TYPE}) and $fn->{RETURN_TYPE} eq "NTSTATUS") {
             $res .= "\tif (NT_STATUS_IS_OK(status)) status = r->out.result;\n";
        }
	$res .= 
"
	return status;
}
";
}

my %done;

#####################################################################
# parse the interface definitions
sub ParseInterface($)
{
	my($interface) = shift;

	$res_hdr .= "#ifndef _HEADER_RPC_$interface->{NAME}\n";
	$res_hdr .= "#define _HEADER_RPC_$interface->{NAME}\n\n";

	if (defined $interface->{PROPERTIES}->{uuid}) {
		$res_hdr .= "extern const struct dcerpc_interface_table dcerpc_table_$interface->{NAME};\n";
	}

	$res .= "/* $interface->{NAME} - client functions generated by pidl */\n\n";

	foreach my $fn (@{$interface->{FUNCTIONS}}) {
		next if not defined($fn->{OPNUM});
		next if defined($done{$fn->{NAME}});
		ParseFunction($interface, $fn);
		$done{$fn->{NAME}} = 1;
	}

	$res_hdr .= "#endif /* _HEADER_RPC_$interface->{NAME} */\n";

	return $res;
}

sub Parse($$$$)
{
	my($ndr,$header,$ndr_header,$client_header) = @_;

	$res = "";
	$res_hdr = "";

	$res .= "/* client functions auto-generated by pidl */\n";
	$res .= "\n";
	if (is_intree()) {
		$res .= "#include \"includes.h\"\n";
	} else {
		$res .= "#define _GNU_SOURCE\n";
		$res .= "#include <stdio.h>\n";
		$res .= "#include <stdbool.h>\n";
		$res .= "#include <stdlib.h>\n";
		$res .= "#include <stdint.h>\n";
		$res .= "#include <stdarg.h>\n";
		$res .= "#include <core/nterr.h>\n";
	}
	$res .= "#include \"$ndr_header\"\n";
	$res .= "#include \"$client_header\"\n";
	$res .= "\n";

	$res_hdr .= choose_header("librpc/rpc/dcerpc.h", "dcerpc.h")."\n";
	$res_hdr .= "#include \"$header\"\n";

	foreach my $x (@{$ndr}) {
		($x->{TYPE} eq "INTERFACE") && ParseInterface($x);
	}

	return ($res,$res_hdr);
}

1;
