/* Do not modify this file.                                                   */
/* It is created automatically by the ASN.1 to Wireshark dissector compiler   */
/* packet-lte-rrc.c                                                           */
/* ../../tools/asn2wrs.py -L -p lte-rrc -c ./lte-rrc.cnf -s ./packet-lte-rrc-template -D . -O ../../epan/dissectors EUTRA-RRC-Definitions.asn EUTRA-UE-Variables.asn EUTRA-InterNodeDefinitions.asn */

/* Input file: packet-lte-rrc-template.c */

#line 1 "../../asn1/lte-rrc/packet-lte-rrc-template.c"
/* packet-lte-rrc-template.c
 * Routines for Evolved Universal Terrestrial Radio Access (E-UTRA);
 * Radio Resource Control (RRC) protocol specification
 * (3GPP TS 36.331 V10.5.0 Release 10) packet dissection
 * Copyright 2008, Vincent Helfre
 *
 * $Id: packet-lte-rrc.c 42913 2012-05-30 08:49:56Z pascal $
 *
 * Wireshark - Network traffic analyzer
 * By Gerald Combs <gerald@wireshark.org>
 * Copyright 1998 Gerald Combs
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 */

#ifdef HAVE_CONFIG_H
# include "config.h"
#endif

#include <glib.h>
#include <epan/packet.h>
#include <epan/asn1.h>
#include <epan/expert.h>

#include "packet-ber.h"
#include "packet-per.h"
#include "packet-rrc.h"
#include "packet-gsm_a_common.h"
#include "packet-lpp.h"

#define PNAME  "LTE Radio Resource Control (RRC) protocol"
#define PSNAME "LTE RRC"
#define PFNAME "lte_rrc"

static dissector_handle_t nas_eps_handle = NULL;
static dissector_handle_t rrc_irat_ho_to_utran_cmd_handle = NULL;
static dissector_handle_t rrc_sys_info_cont_handle = NULL;
static dissector_handle_t gsm_a_dtap_handle = NULL;
static dissector_handle_t gsm_rlcmac_dl_handle = NULL;
static guint32 lte_rrc_rat_type_value = -1;
static guint32 lte_rrc_ho_target_rat_type_value = -1;
static gint lte_rrc_si_or_psi_geran_val = -1;

/* Include constants */

/*--- Included file: packet-lte-rrc-val.h ---*/
#line 1 "../../asn1/lte-rrc/packet-lte-rrc-val.h"
#define maxBandComb_r10                128
#define maxBands                       64
#define maxBandwidthClass_r10          16
#define maxCDMA_BandClass              32
#define maxCellBlack                   16
#define maxCellInfoGERAN_r9            32
#define maxCellInfoUTRA_r9             16
#define maxFreqUTRA_TDD_r10            6
#define maxCellInter                   16
#define maxCellIntra                   16
#define maxCellListGERAN               3
#define maxCellMeas                    32
#define maxCellReport                  8
#define maxDRB                         11
#define maxEARFCN                      65535
#define maxFreq                        8
#define maxGERAN_SI                    10
#define maxGNFG                        16
#define maxLogMeasReport_r10           520
#define maxMBSFN_Allocations           8
#define maxMBSFN_Area                  8
#define maxMBSFN_Area_1                7
#define maxMeasId                      32
#define maxObjectId                    32
#define maxPageRec                     16
#define maxPhysCellIdRange_r9          4
#define maxPNOffset                    511
#define maxPMCH_PerMBSFN               15
#define maxRAT_Capabilities            8
#define maxReportConfigId              32
#define maxRSTD_Freq_r10               3
#define maxSCell_r10                   4
#define maxServCell_r10                5
#define maxServiceCount                16
#define maxServiceCount_1              15
#define maxSessionPerPMCH              29
#define maxSessionPerPMCH_1            28
#define maxSIB                         32
#define maxSIB_1                       31
#define maxSI_Message                  32
#define maxSimultaneousBands_r10       64
#define maxUTRA_FDD_Carrier            16
#define maxUTRA_TDD_Carrier            16
#define maxLogMeas_r10                 4060
#define maxReestabInfo                 32

/*--- End of included file: packet-lte-rrc-val.h ---*/
#line 59 "../../asn1/lte-rrc/packet-lte-rrc-template.c"

/* Initialize the protocol and registered fields */
static int proto_lte_rrc = -1;


/*--- Included file: packet-lte-rrc-hf.c ---*/
#line 1 "../../asn1/lte-rrc/packet-lte-rrc-hf.c"
static int hf_lte_rrc_BCCH_BCH_Message_PDU = -1;  /* BCCH_BCH_Message */
static int hf_lte_rrc_BCCH_DL_SCH_Message_PDU = -1;  /* BCCH_DL_SCH_Message */
static int hf_lte_rrc_MCCH_Message_PDU = -1;      /* MCCH_Message */
static int hf_lte_rrc_PCCH_Message_PDU = -1;      /* PCCH_Message */
static int hf_lte_rrc_DL_CCCH_Message_PDU = -1;   /* DL_CCCH_Message */
static int hf_lte_rrc_DL_DCCH_Message_PDU = -1;   /* DL_DCCH_Message */
static int hf_lte_rrc_UL_CCCH_Message_PDU = -1;   /* UL_CCCH_Message */
static int hf_lte_rrc_UL_DCCH_Message_PDU = -1;   /* UL_DCCH_Message */
static int hf_lte_rrc_UECapabilityInformation_PDU = -1;  /* UECapabilityInformation */
static int hf_lte_rrc_lte_rrc_UE_EUTRA_Capability_PDU = -1;  /* UE_EUTRA_Capability */
static int hf_lte_rrc_lte_rrc_HandoverCommand_PDU = -1;  /* HandoverCommand */
static int hf_lte_rrc_lte_rrc_HandoverPreparationInformation_PDU = -1;  /* HandoverPreparationInformation */
static int hf_lte_rrc_lte_rrc_UERadioAccessCapabilityInformation_PDU = -1;  /* UERadioAccessCapabilityInformation */
static int hf_lte_rrc_SystemInformationBlockType1_PDU = -1;  /* SystemInformationBlockType1 */
static int hf_lte_rrc_UE_EUTRA_Capability_v9a0_IEs_PDU = -1;  /* UE_EUTRA_Capability_v9a0_IEs */
static int hf_lte_rrc_SystemInformationBlockType1_v890_IEs_PDU = -1;  /* SystemInformationBlockType1_v890_IEs */
static int hf_lte_rrc_message = -1;               /* BCCH_BCH_MessageType */
static int hf_lte_rrc_message_01 = -1;            /* BCCH_DL_SCH_MessageType */
static int hf_lte_rrc_c1 = -1;                    /* T_c1 */
static int hf_lte_rrc_systemInformation = -1;     /* SystemInformation */
static int hf_lte_rrc_systemInformationBlockType1 = -1;  /* SystemInformationBlockType1 */
static int hf_lte_rrc_messageClassExtension = -1;  /* T_messageClassExtension */
static int hf_lte_rrc_message_02 = -1;            /* MCCH_MessageType */
static int hf_lte_rrc_c1_01 = -1;                 /* T_c1_01 */
static int hf_lte_rrc_mbsfnAreaConfiguration_r9 = -1;  /* MBSFNAreaConfiguration_r9 */
static int hf_lte_rrc_later = -1;                 /* T_later */
static int hf_lte_rrc_c2 = -1;                    /* T_c2 */
static int hf_lte_rrc_mbmsCountingRequest_r10 = -1;  /* MBMSCountingRequest_r10 */
static int hf_lte_rrc_messageClassExtension_01 = -1;  /* T_messageClassExtension_01 */
static int hf_lte_rrc_message_03 = -1;            /* PCCH_MessageType */
static int hf_lte_rrc_c1_02 = -1;                 /* T_c1_02 */
static int hf_lte_rrc_paging = -1;                /* Paging */
static int hf_lte_rrc_messageClassExtension_02 = -1;  /* T_messageClassExtension_02 */
static int hf_lte_rrc_message_04 = -1;            /* DL_CCCH_MessageType */
static int hf_lte_rrc_c1_03 = -1;                 /* T_c1_03 */
static int hf_lte_rrc_rrcConnectionReestablishment = -1;  /* RRCConnectionReestablishment */
static int hf_lte_rrc_rrcConnectionReestablishmentReject = -1;  /* RRCConnectionReestablishmentReject */
static int hf_lte_rrc_rrcConnectionReject = -1;   /* RRCConnectionReject */
static int hf_lte_rrc_rrcConnectionSetup = -1;    /* RRCConnectionSetup */
static int hf_lte_rrc_messageClassExtension_03 = -1;  /* T_messageClassExtension_03 */
static int hf_lte_rrc_message_05 = -1;            /* DL_DCCH_MessageType */
static int hf_lte_rrc_c1_04 = -1;                 /* T_c1_04 */
static int hf_lte_rrc_csfbParametersResponseCDMA2000 = -1;  /* CSFBParametersResponseCDMA2000 */
static int hf_lte_rrc_dlInformationTransfer = -1;  /* DLInformationTransfer */
static int hf_lte_rrc_handoverFromEUTRAPreparationRequest = -1;  /* HandoverFromEUTRAPreparationRequest */
static int hf_lte_rrc_mobilityFromEUTRACommand = -1;  /* MobilityFromEUTRACommand */
static int hf_lte_rrc_rrcConnectionReconfiguration = -1;  /* RRCConnectionReconfiguration */
static int hf_lte_rrc_rrcConnectionRelease = -1;  /* RRCConnectionRelease */
static int hf_lte_rrc_securityModeCommand = -1;   /* SecurityModeCommand */
static int hf_lte_rrc_ueCapabilityEnquiry = -1;   /* UECapabilityEnquiry */
static int hf_lte_rrc_counterCheck = -1;          /* CounterCheck */
static int hf_lte_rrc_ueInformationRequest_r9 = -1;  /* UEInformationRequest_r9 */
static int hf_lte_rrc_loggedMeasurementConfiguration_r10 = -1;  /* LoggedMeasurementConfiguration_r10 */
static int hf_lte_rrc_rnReconfiguration_r10 = -1;  /* RNReconfiguration_r10 */
static int hf_lte_rrc_spare4 = -1;                /* NULL */
static int hf_lte_rrc_spare3 = -1;                /* NULL */
static int hf_lte_rrc_spare2 = -1;                /* NULL */
static int hf_lte_rrc_spare1 = -1;                /* NULL */
static int hf_lte_rrc_messageClassExtension_04 = -1;  /* T_messageClassExtension_04 */
static int hf_lte_rrc_message_06 = -1;            /* UL_CCCH_MessageType */
static int hf_lte_rrc_c1_05 = -1;                 /* T_c1_05 */
static int hf_lte_rrc_rrcConnectionReestablishmentRequest = -1;  /* RRCConnectionReestablishmentRequest */
static int hf_lte_rrc_rrcConnectionRequest = -1;  /* RRCConnectionRequest */
static int hf_lte_rrc_messageClassExtension_05 = -1;  /* T_messageClassExtension_05 */
static int hf_lte_rrc_message_07 = -1;            /* UL_DCCH_MessageType */
static int hf_lte_rrc_c1_06 = -1;                 /* T_c1_06 */
static int hf_lte_rrc_csfbParametersRequestCDMA2000 = -1;  /* CSFBParametersRequestCDMA2000 */
static int hf_lte_rrc_measurementReport = -1;     /* MeasurementReport */
static int hf_lte_rrc_rrcConnectionReconfigurationComplete = -1;  /* RRCConnectionReconfigurationComplete */
static int hf_lte_rrc_rrcConnectionReestablishmentComplete = -1;  /* RRCConnectionReestablishmentComplete */
static int hf_lte_rrc_rrcConnectionSetupComplete = -1;  /* RRCConnectionSetupComplete */
static int hf_lte_rrc_securityModeComplete = -1;  /* SecurityModeComplete */
static int hf_lte_rrc_securityModeFailure = -1;   /* SecurityModeFailure */
static int hf_lte_rrc_ueCapabilityInformation = -1;  /* UECapabilityInformation */
static int hf_lte_rrc_ulHandoverPreparationTransfer = -1;  /* ULHandoverPreparationTransfer */
static int hf_lte_rrc_ulInformationTransfer = -1;  /* ULInformationTransfer */
static int hf_lte_rrc_counterCheckResponse = -1;  /* CounterCheckResponse */
static int hf_lte_rrc_ueInformationResponse_r9 = -1;  /* UEInformationResponse_r9 */
static int hf_lte_rrc_proximityIndication_r9 = -1;  /* ProximityIndication_r9 */
static int hf_lte_rrc_rnReconfigurationComplete_r10 = -1;  /* RNReconfigurationComplete_r10 */
static int hf_lte_rrc_mbmsCountingResponse_r10 = -1;  /* MBMSCountingResponse_r10 */
static int hf_lte_rrc_interFreqRSTDMeasurementIndication_r10 = -1;  /* InterFreqRSTDMeasurementIndication_r10 */
static int hf_lte_rrc_messageClassExtension_06 = -1;  /* T_messageClassExtension_06 */
static int hf_lte_rrc_rrc_TransactionIdentifier = -1;  /* RRC_TransactionIdentifier */
static int hf_lte_rrc_criticalExtensions = -1;    /* T_criticalExtensions */
static int hf_lte_rrc_c1_07 = -1;                 /* T_c1_07 */
static int hf_lte_rrc_counterCheck_r8 = -1;       /* CounterCheck_r8_IEs */
static int hf_lte_rrc_criticalExtensionsFuture = -1;  /* T_criticalExtensionsFuture */
static int hf_lte_rrc_drb_CountMSB_InfoList = -1;  /* DRB_CountMSB_InfoList */
static int hf_lte_rrc_nonCriticalExtension = -1;  /* CounterCheck_v8a0_IEs */
static int hf_lte_rrc_lateNonCriticalExtension = -1;  /* OCTET_STRING */
static int hf_lte_rrc_nonCriticalExtension_01 = -1;  /* T_nonCriticalExtension */
static int hf_lte_rrc_DRB_CountMSB_InfoList_item = -1;  /* DRB_CountMSB_Info */
static int hf_lte_rrc_drb_Identity = -1;          /* DRB_Identity */
static int hf_lte_rrc_countMSB_Uplink = -1;       /* INTEGER_0_33554431 */
static int hf_lte_rrc_countMSB_Downlink = -1;     /* INTEGER_0_33554431 */
static int hf_lte_rrc_criticalExtensions_01 = -1;  /* T_criticalExtensions_01 */
static int hf_lte_rrc_counterCheckResponse_r8 = -1;  /* CounterCheckResponse_r8_IEs */
static int hf_lte_rrc_criticalExtensionsFuture_01 = -1;  /* T_criticalExtensionsFuture_01 */
static int hf_lte_rrc_drb_CountInfoList = -1;     /* DRB_CountInfoList */
static int hf_lte_rrc_nonCriticalExtension_02 = -1;  /* CounterCheckResponse_v8a0_IEs */
static int hf_lte_rrc_nonCriticalExtension_03 = -1;  /* T_nonCriticalExtension_01 */
static int hf_lte_rrc_DRB_CountInfoList_item = -1;  /* DRB_CountInfo */
static int hf_lte_rrc_count_Uplink = -1;          /* INTEGER_0_4294967295 */
static int hf_lte_rrc_count_Downlink = -1;        /* INTEGER_0_4294967295 */
static int hf_lte_rrc_criticalExtensions_02 = -1;  /* T_criticalExtensions_02 */
static int hf_lte_rrc_csfbParametersRequestCDMA2000_r8 = -1;  /* CSFBParametersRequestCDMA2000_r8_IEs */
static int hf_lte_rrc_criticalExtensionsFuture_02 = -1;  /* T_criticalExtensionsFuture_02 */
static int hf_lte_rrc_nonCriticalExtension_04 = -1;  /* CSFBParametersRequestCDMA2000_v8a0_IEs */
static int hf_lte_rrc_nonCriticalExtension_05 = -1;  /* T_nonCriticalExtension_02 */
static int hf_lte_rrc_criticalExtensions_03 = -1;  /* T_criticalExtensions_03 */
static int hf_lte_rrc_csfbParametersResponseCDMA2000_r8 = -1;  /* CSFBParametersResponseCDMA2000_r8_IEs */
static int hf_lte_rrc_criticalExtensionsFuture_03 = -1;  /* T_criticalExtensionsFuture_03 */
static int hf_lte_rrc_rand = -1;                  /* RAND_CDMA2000 */
static int hf_lte_rrc_mobilityParameters = -1;    /* MobilityParametersCDMA2000 */
static int hf_lte_rrc_nonCriticalExtension_06 = -1;  /* CSFBParametersResponseCDMA2000_v8a0_IEs */
static int hf_lte_rrc_nonCriticalExtension_07 = -1;  /* T_nonCriticalExtension_03 */
static int hf_lte_rrc_criticalExtensions_04 = -1;  /* T_criticalExtensions_04 */
static int hf_lte_rrc_c1_08 = -1;                 /* T_c1_08 */
static int hf_lte_rrc_dlInformationTransfer_r8 = -1;  /* DLInformationTransfer_r8_IEs */
static int hf_lte_rrc_criticalExtensionsFuture_04 = -1;  /* T_criticalExtensionsFuture_04 */
static int hf_lte_rrc_dedicatedInfoType = -1;     /* T_dedicatedInfoType */
static int hf_lte_rrc_dedicatedInfoNAS = -1;      /* DedicatedInfoNAS */
static int hf_lte_rrc_dedicatedInfoCDMA2000_1XRTT = -1;  /* DedicatedInfoCDMA2000 */
static int hf_lte_rrc_dedicatedInfoCDMA2000_HRPD = -1;  /* DedicatedInfoCDMA2000 */
static int hf_lte_rrc_nonCriticalExtension_08 = -1;  /* DLInformationTransfer_v8a0_IEs */
static int hf_lte_rrc_nonCriticalExtension_09 = -1;  /* T_nonCriticalExtension_04 */
static int hf_lte_rrc_criticalExtensions_05 = -1;  /* T_criticalExtensions_05 */
static int hf_lte_rrc_c1_09 = -1;                 /* T_c1_09 */
static int hf_lte_rrc_handoverFromEUTRAPreparationRequest_r8 = -1;  /* HandoverFromEUTRAPreparationRequest_r8_IEs */
static int hf_lte_rrc_criticalExtensionsFuture_05 = -1;  /* T_criticalExtensionsFuture_05 */
static int hf_lte_rrc_cdma2000_Type = -1;         /* CDMA2000_Type */
static int hf_lte_rrc_nonCriticalExtension_10 = -1;  /* HandoverFromEUTRAPreparationRequest_v890_IEs */
static int hf_lte_rrc_nonCriticalExtension_11 = -1;  /* HandoverFromEUTRAPreparationRequest_v920_IEs */
static int hf_lte_rrc_concurrPrepCDMA2000_HRPD_r9 = -1;  /* BOOLEAN */
static int hf_lte_rrc_nonCriticalExtension_12 = -1;  /* HandoverFromEUTRAPreparationRequest_v1020_IEs */
static int hf_lte_rrc_dualRxTxRedirectIndicator_r10 = -1;  /* T_dualRxTxRedirectIndicator_r10 */
static int hf_lte_rrc_redirectCarrierCDMA2000_1XRTT_r10 = -1;  /* CarrierFreqCDMA2000 */
static int hf_lte_rrc_nonCriticalExtension_13 = -1;  /* T_nonCriticalExtension_05 */
static int hf_lte_rrc_criticalExtensions_06 = -1;  /* T_criticalExtensions_06 */
static int hf_lte_rrc_c1_10 = -1;                 /* T_c1_10 */
static int hf_lte_rrc_interFreqRSTDMeasurementIndication_r10_01 = -1;  /* InterFreqRSTDMeasurementIndication_r10_IEs */
static int hf_lte_rrc_criticalExtensionsFuture_06 = -1;  /* T_criticalExtensionsFuture_06 */
static int hf_lte_rrc_rstd_InterFreqIndication_r10 = -1;  /* T_rstd_InterFreqIndication_r10 */
static int hf_lte_rrc_start = -1;                 /* T_start */
static int hf_lte_rrc_rstd_InterFreqInfoList_r10 = -1;  /* RSTD_InterFreqInfoList_r10 */
static int hf_lte_rrc_stop = -1;                  /* NULL */
static int hf_lte_rrc_nonCriticalExtension_14 = -1;  /* T_nonCriticalExtension_06 */
static int hf_lte_rrc_RSTD_InterFreqInfoList_r10_item = -1;  /* RSTD_InterFreqInfo_r10 */
static int hf_lte_rrc_carrierFreq_r10 = -1;       /* ARFCN_ValueEUTRA */
static int hf_lte_rrc_measPRS_Offset_r10 = -1;    /* INTEGER_0_39 */
static int hf_lte_rrc_criticalExtensions_07 = -1;  /* T_criticalExtensions_07 */
static int hf_lte_rrc_c1_11 = -1;                 /* T_c1_11 */
static int hf_lte_rrc_loggedMeasurementConfiguration_r10_01 = -1;  /* LoggedMeasurementConfiguration_r10_IEs */
static int hf_lte_rrc_criticalExtensionsFuture_07 = -1;  /* T_criticalExtensionsFuture_07 */
static int hf_lte_rrc_traceReference_r10 = -1;    /* TraceReference_r10 */
static int hf_lte_rrc_traceRecordingSessionRef_r10 = -1;  /* OCTET_STRING_SIZE_2 */
static int hf_lte_rrc_tce_Id_r10 = -1;            /* OCTET_STRING_SIZE_1 */
static int hf_lte_rrc_absoluteTimeInfo_r10 = -1;  /* AbsoluteTimeInfo_r10 */
static int hf_lte_rrc_areaConfiguration_r10 = -1;  /* AreaConfiguration_r10 */
static int hf_lte_rrc_loggingDuration_r10 = -1;   /* LoggingDuration_r10 */
static int hf_lte_rrc_loggingInterval_r10 = -1;   /* LoggingInterval_r10 */
static int hf_lte_rrc_nonCriticalExtension_15 = -1;  /* T_nonCriticalExtension_07 */
static int hf_lte_rrc_dl_Bandwidth = -1;          /* T_dl_Bandwidth */
static int hf_lte_rrc_phich_Config = -1;          /* PHICH_Config */
static int hf_lte_rrc_systemFrameNumber = -1;     /* BIT_STRING_SIZE_8 */
static int hf_lte_rrc_spare = -1;                 /* BIT_STRING_SIZE_10 */
static int hf_lte_rrc_countingRequestList_r10 = -1;  /* CountingRequestList_r10 */
static int hf_lte_rrc_nonCriticalExtension_16 = -1;  /* T_nonCriticalExtension_08 */
static int hf_lte_rrc_CountingRequestList_r10_item = -1;  /* CountingRequestInfo_r10 */
static int hf_lte_rrc_tmgi_r10 = -1;              /* TMGI_r9 */
static int hf_lte_rrc_criticalExtensions_08 = -1;  /* T_criticalExtensions_08 */
static int hf_lte_rrc_c1_12 = -1;                 /* T_c1_12 */
static int hf_lte_rrc_countingResponse_r10 = -1;  /* MBMSCountingResponse_r10_IEs */
static int hf_lte_rrc_criticalExtensionsFuture_08 = -1;  /* T_criticalExtensionsFuture_08 */
static int hf_lte_rrc_mbsfn_AreaIndex_r10 = -1;   /* INTEGER_0_maxMBSFN_Area_1 */
static int hf_lte_rrc_countingResponseList_r10 = -1;  /* CountingResponseList_r10 */
static int hf_lte_rrc_nonCriticalExtension_17 = -1;  /* T_nonCriticalExtension_09 */
static int hf_lte_rrc_CountingResponseList_r10_item = -1;  /* CountingResponseInfo_r10 */
static int hf_lte_rrc_countingResponseService_r10 = -1;  /* INTEGER_0_maxServiceCount_1 */
static int hf_lte_rrc_commonSF_Alloc_r9 = -1;     /* CommonSF_AllocPatternList_r9 */
static int hf_lte_rrc_commonSF_AllocPeriod_r9 = -1;  /* T_commonSF_AllocPeriod_r9 */
static int hf_lte_rrc_pmch_InfoList_r9 = -1;      /* PMCH_InfoList_r9 */
static int hf_lte_rrc_nonCriticalExtension_18 = -1;  /* MBSFNAreaConfiguration_v930_IEs */
static int hf_lte_rrc_nonCriticalExtension_19 = -1;  /* T_nonCriticalExtension_10 */
static int hf_lte_rrc_CommonSF_AllocPatternList_r9_item = -1;  /* MBSFN_SubframeConfig */
static int hf_lte_rrc_criticalExtensions_09 = -1;  /* T_criticalExtensions_09 */
static int hf_lte_rrc_c1_13 = -1;                 /* T_c1_13 */
static int hf_lte_rrc_measurementReport_r8 = -1;  /* MeasurementReport_r8_IEs */
static int hf_lte_rrc_spare7 = -1;                /* NULL */
static int hf_lte_rrc_spare6 = -1;                /* NULL */
static int hf_lte_rrc_spare5 = -1;                /* NULL */
static int hf_lte_rrc_criticalExtensionsFuture_09 = -1;  /* T_criticalExtensionsFuture_09 */
static int hf_lte_rrc_measResults = -1;           /* MeasResults */
static int hf_lte_rrc_nonCriticalExtension_20 = -1;  /* MeasurementReport_v8a0_IEs */
static int hf_lte_rrc_nonCriticalExtension_21 = -1;  /* T_nonCriticalExtension_11 */
static int hf_lte_rrc_criticalExtensions_10 = -1;  /* T_criticalExtensions_10 */
static int hf_lte_rrc_c1_14 = -1;                 /* T_c1_14 */
static int hf_lte_rrc_mobilityFromEUTRACommand_r8 = -1;  /* MobilityFromEUTRACommand_r8_IEs */
static int hf_lte_rrc_mobilityFromEUTRACommand_r9 = -1;  /* MobilityFromEUTRACommand_r9_IEs */
static int hf_lte_rrc_criticalExtensionsFuture_10 = -1;  /* T_criticalExtensionsFuture_10 */
static int hf_lte_rrc_cs_FallbackIndicator = -1;  /* BOOLEAN */
static int hf_lte_rrc_purpose = -1;               /* T_purpose */
static int hf_lte_rrc_handover = -1;              /* Handover */
static int hf_lte_rrc_cellChangeOrder = -1;       /* CellChangeOrder */
static int hf_lte_rrc_nonCriticalExtension_22 = -1;  /* MobilityFromEUTRACommand_v8a0_IEs */
static int hf_lte_rrc_nonCriticalExtension_23 = -1;  /* MobilityFromEUTRACommand_v8d0_IEs */
static int hf_lte_rrc_bandIndicator = -1;         /* BandIndicatorGERAN */
static int hf_lte_rrc_nonCriticalExtension_24 = -1;  /* T_nonCriticalExtension_12 */
static int hf_lte_rrc_purpose_01 = -1;            /* T_purpose_01 */
static int hf_lte_rrc_e_CSFB_r9 = -1;             /* E_CSFB_r9 */
static int hf_lte_rrc_nonCriticalExtension_25 = -1;  /* MobilityFromEUTRACommand_v930_IEs */
static int hf_lte_rrc_nonCriticalExtension_26 = -1;  /* MobilityFromEUTRACommand_v960_IEs */
static int hf_lte_rrc_nonCriticalExtension_27 = -1;  /* T_nonCriticalExtension_13 */
static int hf_lte_rrc_targetRAT_Type = -1;        /* T_targetRAT_Type */
static int hf_lte_rrc_targetRAT_MessageContainer = -1;  /* T_targetRAT_MessageContainer */
static int hf_lte_rrc_nas_SecurityParamFromEUTRA = -1;  /* T_nas_SecurityParamFromEUTRA */
static int hf_lte_rrc_systemInformation_01 = -1;  /* SI_OrPSI_GERAN */
static int hf_lte_rrc_t304 = -1;                  /* T_t304 */
static int hf_lte_rrc_targetRAT_Type_01 = -1;     /* T_targetRAT_Type_01 */
static int hf_lte_rrc_geran = -1;                 /* T_geran */
static int hf_lte_rrc_physCellId = -1;            /* PhysCellIdGERAN */
static int hf_lte_rrc_carrierFreq = -1;           /* CarrierFreqGERAN */
static int hf_lte_rrc_networkControlOrder = -1;   /* BIT_STRING_SIZE_2 */
static int hf_lte_rrc_si = -1;                    /* SystemInfoListGERAN */
static int hf_lte_rrc_psi = -1;                   /* SystemInfoListGERAN */
static int hf_lte_rrc_messageContCDMA2000_1XRTT_r9 = -1;  /* OCTET_STRING */
static int hf_lte_rrc_mobilityCDMA2000_HRPD_r9 = -1;  /* T_mobilityCDMA2000_HRPD_r9 */
static int hf_lte_rrc_messageContCDMA2000_HRPD_r9 = -1;  /* OCTET_STRING */
static int hf_lte_rrc_redirectCarrierCDMA2000_HRPD_r9 = -1;  /* CarrierFreqCDMA2000 */
static int hf_lte_rrc_pagingRecordList = -1;      /* PagingRecordList */
static int hf_lte_rrc_systemInfoModification = -1;  /* T_systemInfoModification */
static int hf_lte_rrc_etws_Indication = -1;       /* T_etws_Indication */
static int hf_lte_rrc_nonCriticalExtension_28 = -1;  /* Paging_v890_IEs */
static int hf_lte_rrc_nonCriticalExtension_29 = -1;  /* Paging_v920_IEs */
static int hf_lte_rrc_cmas_Indication_r9 = -1;    /* T_cmas_Indication_r9 */
static int hf_lte_rrc_nonCriticalExtension_30 = -1;  /* T_nonCriticalExtension_14 */
static int hf_lte_rrc_PagingRecordList_item = -1;  /* PagingRecord */
static int hf_lte_rrc_ue_Identity = -1;           /* PagingUE_Identity */
static int hf_lte_rrc_cn_Domain = -1;             /* T_cn_Domain */
static int hf_lte_rrc_s_TMSI = -1;                /* S_TMSI */
static int hf_lte_rrc_imsi = -1;                  /* IMSI */
static int hf_lte_rrc_IMSI_item = -1;             /* IMSI_Digit */
static int hf_lte_rrc_criticalExtensions_11 = -1;  /* T_criticalExtensions_11 */
static int hf_lte_rrc_c1_15 = -1;                 /* T_c1_15 */
static int hf_lte_rrc_proximityIndication_r9_01 = -1;  /* ProximityIndication_r9_IEs */
static int hf_lte_rrc_criticalExtensionsFuture_11 = -1;  /* T_criticalExtensionsFuture_11 */
static int hf_lte_rrc_type_r9 = -1;               /* T_type_r9 */
static int hf_lte_rrc_carrierFreq_r9 = -1;        /* T_carrierFreq_r9 */
static int hf_lte_rrc_eutra_r9 = -1;              /* ARFCN_ValueEUTRA */
static int hf_lte_rrc_utra_r9 = -1;               /* ARFCN_ValueUTRA */
static int hf_lte_rrc_nonCriticalExtension_31 = -1;  /* ProximityIndication_v930_IEs */
static int hf_lte_rrc_nonCriticalExtension_32 = -1;  /* T_nonCriticalExtension_15 */
static int hf_lte_rrc_criticalExtensions_12 = -1;  /* T_criticalExtensions_12 */
static int hf_lte_rrc_c1_16 = -1;                 /* T_c1_16 */
static int hf_lte_rrc_rnReconfiguration_r10_01 = -1;  /* RNReconfiguration_r10_IEs */
static int hf_lte_rrc_criticalExtensionsFuture_12 = -1;  /* T_criticalExtensionsFuture_12 */
static int hf_lte_rrc_rn_SystemInfo_r10 = -1;     /* RN_SystemInfo_r10 */
static int hf_lte_rrc_rn_SubframeConfig_r10 = -1;  /* RN_SubframeConfig_r10 */
static int hf_lte_rrc_nonCriticalExtension_33 = -1;  /* T_nonCriticalExtension_16 */
static int hf_lte_rrc_systemInformationBlockType1_r10 = -1;  /* T_systemInformationBlockType1_r10 */
static int hf_lte_rrc_systemInformationBlockType2_r10 = -1;  /* SystemInformationBlockType2 */
static int hf_lte_rrc_criticalExtensions_13 = -1;  /* T_criticalExtensions_13 */
static int hf_lte_rrc_c1_17 = -1;                 /* T_c1_17 */
static int hf_lte_rrc_rnReconfigurationComplete_r10_01 = -1;  /* RNReconfigurationComplete_r10_IEs */
static int hf_lte_rrc_criticalExtensionsFuture_13 = -1;  /* T_criticalExtensionsFuture_13 */
static int hf_lte_rrc_nonCriticalExtension_34 = -1;  /* T_nonCriticalExtension_17 */
static int hf_lte_rrc_criticalExtensions_14 = -1;  /* T_criticalExtensions_14 */
static int hf_lte_rrc_c1_18 = -1;                 /* T_c1_18 */
static int hf_lte_rrc_rrcConnectionReconfiguration_r8 = -1;  /* RRCConnectionReconfiguration_r8_IEs */
static int hf_lte_rrc_criticalExtensionsFuture_14 = -1;  /* T_criticalExtensionsFuture_14 */
static int hf_lte_rrc_measConfig = -1;            /* MeasConfig */
static int hf_lte_rrc_mobilityControlInfo = -1;   /* MobilityControlInfo */
static int hf_lte_rrc_dedicatedInfoNASList = -1;  /* SEQUENCE_SIZE_1_maxDRB_OF_DedicatedInfoNAS */
static int hf_lte_rrc_dedicatedInfoNASList_item = -1;  /* DedicatedInfoNAS */
static int hf_lte_rrc_radioResourceConfigDedicated = -1;  /* RadioResourceConfigDedicated */
static int hf_lte_rrc_securityConfigHO = -1;      /* SecurityConfigHO */
static int hf_lte_rrc_nonCriticalExtension_35 = -1;  /* RRCConnectionReconfiguration_v890_IEs */
static int hf_lte_rrc_nonCriticalExtension_36 = -1;  /* RRCConnectionReconfiguration_v920_IEs */
static int hf_lte_rrc_otherConfig_r9 = -1;        /* OtherConfig_r9 */
static int hf_lte_rrc_fullConfig_r9 = -1;         /* T_fullConfig_r9 */
static int hf_lte_rrc_nonCriticalExtension_37 = -1;  /* RRCConnectionReconfiguration_v1020_IEs */
static int hf_lte_rrc_sCellToReleaseList_r10 = -1;  /* SCellToReleaseList_r10 */
static int hf_lte_rrc_sCellToAddModList_r10 = -1;  /* SCellToAddModList_r10 */
static int hf_lte_rrc_nonCriticalExtension_38 = -1;  /* T_nonCriticalExtension_18 */
static int hf_lte_rrc_SCellToAddModList_r10_item = -1;  /* SCellToAddMod_r10 */
static int hf_lte_rrc_sCellIndex_r10 = -1;        /* SCellIndex_r10 */
static int hf_lte_rrc_cellIdentification_r10 = -1;  /* T_cellIdentification_r10 */
static int hf_lte_rrc_physCellId_r10 = -1;        /* PhysCellId */
static int hf_lte_rrc_dl_CarrierFreq_r10 = -1;    /* ARFCN_ValueEUTRA */
static int hf_lte_rrc_radioResourceConfigCommonSCell_r10 = -1;  /* RadioResourceConfigCommonSCell_r10 */
static int hf_lte_rrc_radioResourceConfigDedicatedSCell_r10 = -1;  /* RadioResourceConfigDedicatedSCell_r10 */
static int hf_lte_rrc_SCellToReleaseList_r10_item = -1;  /* SCellIndex_r10 */
static int hf_lte_rrc_handoverType = -1;          /* T_handoverType */
static int hf_lte_rrc_intraLTE = -1;              /* T_intraLTE */
static int hf_lte_rrc_securityAlgorithmConfig = -1;  /* SecurityAlgorithmConfig */
static int hf_lte_rrc_keyChangeIndicator = -1;    /* BOOLEAN */
static int hf_lte_rrc_nextHopChainingCount = -1;  /* NextHopChainingCount */
static int hf_lte_rrc_interRAT = -1;              /* T_interRAT */
static int hf_lte_rrc_nas_SecurityParamToEUTRA = -1;  /* T_nas_SecurityParamToEUTRA */
static int hf_lte_rrc_criticalExtensions_15 = -1;  /* T_criticalExtensions_15 */
static int hf_lte_rrc_rrcConnectionReconfigurationComplete_r8 = -1;  /* RRCConnectionReconfigurationComplete_r8_IEs */
static int hf_lte_rrc_criticalExtensionsFuture_15 = -1;  /* T_criticalExtensionsFuture_15 */
static int hf_lte_rrc_nonCriticalExtension_39 = -1;  /* RRCConnectionReconfigurationComplete_v8a0_IEs */
static int hf_lte_rrc_nonCriticalExtension_40 = -1;  /* RRCConnectionReconfigurationComplete_v1020_IEs */
static int hf_lte_rrc_rlf_InfoAvailable_r10 = -1;  /* T_rlf_InfoAvailable_r10 */
static int hf_lte_rrc_logMeasAvailable_r10 = -1;  /* T_logMeasAvailable_r10 */
static int hf_lte_rrc_nonCriticalExtension_41 = -1;  /* T_nonCriticalExtension_19 */
static int hf_lte_rrc_criticalExtensions_16 = -1;  /* T_criticalExtensions_16 */
static int hf_lte_rrc_c1_19 = -1;                 /* T_c1_19 */
static int hf_lte_rrc_rrcConnectionReestablishment_r8 = -1;  /* RRCConnectionReestablishment_r8_IEs */
static int hf_lte_rrc_criticalExtensionsFuture_16 = -1;  /* T_criticalExtensionsFuture_16 */
static int hf_lte_rrc_nonCriticalExtension_42 = -1;  /* RRCConnectionReestablishment_v8a0_IEs */
static int hf_lte_rrc_nonCriticalExtension_43 = -1;  /* T_nonCriticalExtension_20 */
static int hf_lte_rrc_criticalExtensions_17 = -1;  /* T_criticalExtensions_17 */
static int hf_lte_rrc_rrcConnectionReestablishmentComplete_r8 = -1;  /* RRCConnectionReestablishmentComplete_r8_IEs */
static int hf_lte_rrc_criticalExtensionsFuture_17 = -1;  /* T_criticalExtensionsFuture_17 */
static int hf_lte_rrc_nonCriticalExtension_44 = -1;  /* RRCConnectionReestablishmentComplete_v920_IEs */
static int hf_lte_rrc_rlf_InfoAvailable_r9 = -1;  /* T_rlf_InfoAvailable_r9 */
static int hf_lte_rrc_nonCriticalExtension_45 = -1;  /* RRCConnectionReestablishmentComplete_v8a0_IEs */
static int hf_lte_rrc_nonCriticalExtension_46 = -1;  /* RRCConnectionReestablishmentComplete_v1020_IEs */
static int hf_lte_rrc_logMeasAvailable_r10_01 = -1;  /* T_logMeasAvailable_r10_01 */
static int hf_lte_rrc_nonCriticalExtension_47 = -1;  /* T_nonCriticalExtension_21 */
static int hf_lte_rrc_criticalExtensions_18 = -1;  /* T_criticalExtensions_18 */
static int hf_lte_rrc_rrcConnectionReestablishmentReject_r8 = -1;  /* RRCConnectionReestablishmentReject_r8_IEs */
static int hf_lte_rrc_criticalExtensionsFuture_18 = -1;  /* T_criticalExtensionsFuture_18 */
static int hf_lte_rrc_nonCriticalExtension_48 = -1;  /* RRCConnectionReestablishmentReject_v8a0_IEs */
static int hf_lte_rrc_nonCriticalExtension_49 = -1;  /* T_nonCriticalExtension_22 */
static int hf_lte_rrc_criticalExtensions_19 = -1;  /* T_criticalExtensions_19 */
static int hf_lte_rrc_rrcConnectionReestablishmentRequest_r8 = -1;  /* RRCConnectionReestablishmentRequest_r8_IEs */
static int hf_lte_rrc_criticalExtensionsFuture_19 = -1;  /* T_criticalExtensionsFuture_19 */
static int hf_lte_rrc_ue_Identity_01 = -1;        /* ReestabUE_Identity */
static int hf_lte_rrc_reestablishmentCause = -1;  /* ReestablishmentCause */
static int hf_lte_rrc_spare_01 = -1;              /* BIT_STRING_SIZE_2 */
static int hf_lte_rrc_c_RNTI = -1;                /* C_RNTI */
static int hf_lte_rrc_physCellId_01 = -1;         /* PhysCellId */
static int hf_lte_rrc_shortMAC_I = -1;            /* ShortMAC_I */
static int hf_lte_rrc_criticalExtensions_20 = -1;  /* T_criticalExtensions_20 */
static int hf_lte_rrc_c1_20 = -1;                 /* T_c1_20 */
static int hf_lte_rrc_rrcConnectionReject_r8 = -1;  /* RRCConnectionReject_r8_IEs */
static int hf_lte_rrc_criticalExtensionsFuture_20 = -1;  /* T_criticalExtensionsFuture_20 */
static int hf_lte_rrc_waitTime = -1;              /* T_waitTime */
static int hf_lte_rrc_nonCriticalExtension_50 = -1;  /* RRCConnectionReject_v8a0_IEs */
static int hf_lte_rrc_nonCriticalExtension_51 = -1;  /* RRCConnectionReject_v1020_IEs */
static int hf_lte_rrc_extendedWaitTime_r10 = -1;  /* T_extendedWaitTime_r10 */
static int hf_lte_rrc_nonCriticalExtension_52 = -1;  /* T_nonCriticalExtension_23 */
static int hf_lte_rrc_criticalExtensions_21 = -1;  /* T_criticalExtensions_21 */
static int hf_lte_rrc_c1_21 = -1;                 /* T_c1_21 */
static int hf_lte_rrc_rrcConnectionRelease_r8 = -1;  /* RRCConnectionRelease_r8_IEs */
static int hf_lte_rrc_criticalExtensionsFuture_21 = -1;  /* T_criticalExtensionsFuture_21 */
static int hf_lte_rrc_releaseCause = -1;          /* ReleaseCause */
static int hf_lte_rrc_redirectedCarrierInfo = -1;  /* RedirectedCarrierInfo */
static int hf_lte_rrc_idleModeMobilityControlInfo = -1;  /* IdleModeMobilityControlInfo */
static int hf_lte_rrc_nonCriticalExtension_53 = -1;  /* RRCConnectionRelease_v890_IEs */
static int hf_lte_rrc_nonCriticalExtension_54 = -1;  /* RRCConnectionRelease_v920_IEs */
static int hf_lte_rrc_cellInfoList_r9 = -1;       /* T_cellInfoList_r9 */
static int hf_lte_rrc_geran_r9 = -1;              /* CellInfoListGERAN_r9 */
static int hf_lte_rrc_utra_FDD_r9 = -1;           /* CellInfoListUTRA_FDD_r9 */
static int hf_lte_rrc_utra_TDD_r9 = -1;           /* CellInfoListUTRA_TDD_r9 */
static int hf_lte_rrc_utra_TDD_r10 = -1;          /* CellInfoListUTRA_TDD_r10 */
static int hf_lte_rrc_nonCriticalExtension_55 = -1;  /* RRCConnectionRelease_v1020_IEs */
static int hf_lte_rrc_extendedWaitTime_r10_01 = -1;  /* T_extendedWaitTime_r10_01 */
static int hf_lte_rrc_nonCriticalExtension_56 = -1;  /* T_nonCriticalExtension_24 */
static int hf_lte_rrc_eutra = -1;                 /* ARFCN_ValueEUTRA */
static int hf_lte_rrc_geran_01 = -1;              /* CarrierFreqsGERAN */
static int hf_lte_rrc_utra_FDD = -1;              /* ARFCN_ValueUTRA */
static int hf_lte_rrc_utra_TDD = -1;              /* ARFCN_ValueUTRA */
static int hf_lte_rrc_cdma2000_HRPD = -1;         /* CarrierFreqCDMA2000 */
static int hf_lte_rrc_cdma2000_1xRTT = -1;        /* CarrierFreqCDMA2000 */
static int hf_lte_rrc_utra_TDD_r10_01 = -1;       /* CarrierFreqListUTRA_TDD_r10 */
static int hf_lte_rrc_CarrierFreqListUTRA_TDD_r10_item = -1;  /* ARFCN_ValueUTRA */
static int hf_lte_rrc_freqPriorityListEUTRA = -1;  /* FreqPriorityListEUTRA */
static int hf_lte_rrc_freqPriorityListGERAN = -1;  /* FreqsPriorityListGERAN */
static int hf_lte_rrc_freqPriorityListUTRA_FDD = -1;  /* FreqPriorityListUTRA_FDD */
static int hf_lte_rrc_freqPriorityListUTRA_TDD = -1;  /* FreqPriorityListUTRA_TDD */
static int hf_lte_rrc_bandClassPriorityListHRPD = -1;  /* BandClassPriorityListHRPD */
static int hf_lte_rrc_bandClassPriorityList1XRTT = -1;  /* BandClassPriorityList1XRTT */
static int hf_lte_rrc_t320 = -1;                  /* T_t320 */
static int hf_lte_rrc_FreqPriorityListEUTRA_item = -1;  /* FreqPriorityEUTRA */
static int hf_lte_rrc_carrierFreq_01 = -1;        /* ARFCN_ValueEUTRA */
static int hf_lte_rrc_cellReselectionPriority = -1;  /* CellReselectionPriority */
static int hf_lte_rrc_FreqsPriorityListGERAN_item = -1;  /* FreqsPriorityGERAN */
static int hf_lte_rrc_carrierFreqs = -1;          /* CarrierFreqsGERAN */
static int hf_lte_rrc_FreqPriorityListUTRA_FDD_item = -1;  /* FreqPriorityUTRA_FDD */
static int hf_lte_rrc_carrierFreq_02 = -1;        /* ARFCN_ValueUTRA */
static int hf_lte_rrc_FreqPriorityListUTRA_TDD_item = -1;  /* FreqPriorityUTRA_TDD */
static int hf_lte_rrc_BandClassPriorityListHRPD_item = -1;  /* BandClassPriorityHRPD */
static int hf_lte_rrc_bandClass = -1;             /* BandclassCDMA2000 */
static int hf_lte_rrc_BandClassPriorityList1XRTT_item = -1;  /* BandClassPriority1XRTT */
static int hf_lte_rrc_CellInfoListGERAN_r9_item = -1;  /* CellInfoGERAN_r9 */
static int hf_lte_rrc_physCellId_r9 = -1;         /* PhysCellIdGERAN */
static int hf_lte_rrc_carrierFreq_r9_01 = -1;     /* CarrierFreqGERAN */
static int hf_lte_rrc_systemInformation_r9 = -1;  /* SystemInfoListGERAN */
static int hf_lte_rrc_CellInfoListUTRA_FDD_r9_item = -1;  /* CellInfoUTRA_FDD_r9 */
static int hf_lte_rrc_physCellId_r9_01 = -1;      /* PhysCellIdUTRA_FDD */
static int hf_lte_rrc_utra_BCCH_Container_r9 = -1;  /* T_utra_BCCH_Container_r9 */
static int hf_lte_rrc_CellInfoListUTRA_TDD_r9_item = -1;  /* CellInfoUTRA_TDD_r9 */
static int hf_lte_rrc_physCellId_r9_02 = -1;      /* PhysCellIdUTRA_TDD */
static int hf_lte_rrc_utra_BCCH_Container_r9_01 = -1;  /* T_utra_BCCH_Container_r9_01 */
static int hf_lte_rrc_CellInfoListUTRA_TDD_r10_item = -1;  /* CellInfoUTRA_TDD_r10 */
static int hf_lte_rrc_physCellId_r10_01 = -1;     /* PhysCellIdUTRA_TDD */
static int hf_lte_rrc_carrierFreq_r10_01 = -1;    /* ARFCN_ValueUTRA */
static int hf_lte_rrc_utra_BCCH_Container_r10 = -1;  /* OCTET_STRING */
static int hf_lte_rrc_criticalExtensions_22 = -1;  /* T_criticalExtensions_22 */
static int hf_lte_rrc_rrcConnectionRequest_r8 = -1;  /* RRCConnectionRequest_r8_IEs */
static int hf_lte_rrc_criticalExtensionsFuture_22 = -1;  /* T_criticalExtensionsFuture_22 */
static int hf_lte_rrc_ue_Identity_02 = -1;        /* InitialUE_Identity */
static int hf_lte_rrc_establishmentCause = -1;    /* EstablishmentCause */
static int hf_lte_rrc_spare_02 = -1;              /* BIT_STRING_SIZE_1 */
static int hf_lte_rrc_randomValue = -1;           /* BIT_STRING_SIZE_40 */
static int hf_lte_rrc_criticalExtensions_23 = -1;  /* T_criticalExtensions_23 */
static int hf_lte_rrc_c1_22 = -1;                 /* T_c1_22 */
static int hf_lte_rrc_rrcConnectionSetup_r8 = -1;  /* RRCConnectionSetup_r8_IEs */
static int hf_lte_rrc_criticalExtensionsFuture_23 = -1;  /* T_criticalExtensionsFuture_23 */
static int hf_lte_rrc_nonCriticalExtension_57 = -1;  /* RRCConnectionSetup_v8a0_IEs */
static int hf_lte_rrc_nonCriticalExtension_58 = -1;  /* T_nonCriticalExtension_25 */
static int hf_lte_rrc_criticalExtensions_24 = -1;  /* T_criticalExtensions_24 */
static int hf_lte_rrc_c1_23 = -1;                 /* T_c1_23 */
static int hf_lte_rrc_rrcConnectionSetupComplete_r8 = -1;  /* RRCConnectionSetupComplete_r8_IEs */
static int hf_lte_rrc_criticalExtensionsFuture_24 = -1;  /* T_criticalExtensionsFuture_24 */
static int hf_lte_rrc_selectedPLMN_Identity = -1;  /* INTEGER_1_6 */
static int hf_lte_rrc_registeredMME = -1;         /* RegisteredMME */
static int hf_lte_rrc_nonCriticalExtension_59 = -1;  /* RRCConnectionSetupComplete_v8a0_IEs */
static int hf_lte_rrc_nonCriticalExtension_60 = -1;  /* RRCConnectionSetupComplete_v1020_IEs */
static int hf_lte_rrc_gummei_Type_r10 = -1;       /* T_gummei_Type_r10 */
static int hf_lte_rrc_rlf_InfoAvailable_r10_01 = -1;  /* T_rlf_InfoAvailable_r10_01 */
static int hf_lte_rrc_logMeasAvailable_r10_02 = -1;  /* T_logMeasAvailable_r10_02 */
static int hf_lte_rrc_rn_SubframeConfigReq_r10 = -1;  /* T_rn_SubframeConfigReq_r10 */
static int hf_lte_rrc_nonCriticalExtension_61 = -1;  /* T_nonCriticalExtension_26 */
static int hf_lte_rrc_plmn_Identity = -1;         /* PLMN_Identity */
static int hf_lte_rrc_mmegi = -1;                 /* BIT_STRING_SIZE_16 */
static int hf_lte_rrc_mmec = -1;                  /* MMEC */
static int hf_lte_rrc_criticalExtensions_25 = -1;  /* T_criticalExtensions_25 */
static int hf_lte_rrc_c1_24 = -1;                 /* T_c1_24 */
static int hf_lte_rrc_securityModeCommand_r8 = -1;  /* SecurityModeCommand_r8_IEs */
static int hf_lte_rrc_criticalExtensionsFuture_25 = -1;  /* T_criticalExtensionsFuture_25 */
static int hf_lte_rrc_securityConfigSMC = -1;     /* SecurityConfigSMC */
static int hf_lte_rrc_nonCriticalExtension_62 = -1;  /* SecurityModeCommand_v8a0_IEs */
static int hf_lte_rrc_nonCriticalExtension_63 = -1;  /* T_nonCriticalExtension_27 */
static int hf_lte_rrc_criticalExtensions_26 = -1;  /* T_criticalExtensions_26 */
static int hf_lte_rrc_securityModeComplete_r8 = -1;  /* SecurityModeComplete_r8_IEs */
static int hf_lte_rrc_criticalExtensionsFuture_26 = -1;  /* T_criticalExtensionsFuture_26 */
static int hf_lte_rrc_nonCriticalExtension_64 = -1;  /* SecurityModeComplete_v8a0_IEs */
static int hf_lte_rrc_nonCriticalExtension_65 = -1;  /* T_nonCriticalExtension_28 */
static int hf_lte_rrc_criticalExtensions_27 = -1;  /* T_criticalExtensions_27 */
static int hf_lte_rrc_securityModeFailure_r8 = -1;  /* SecurityModeFailure_r8_IEs */
static int hf_lte_rrc_criticalExtensionsFuture_27 = -1;  /* T_criticalExtensionsFuture_27 */
static int hf_lte_rrc_nonCriticalExtension_66 = -1;  /* SecurityModeFailure_v8a0_IEs */
static int hf_lte_rrc_nonCriticalExtension_67 = -1;  /* T_nonCriticalExtension_29 */
static int hf_lte_rrc_criticalExtensions_28 = -1;  /* T_criticalExtensions_28 */
static int hf_lte_rrc_systemInformation_r8 = -1;  /* SystemInformation_r8_IEs */
static int hf_lte_rrc_criticalExtensionsFuture_28 = -1;  /* T_criticalExtensionsFuture_28 */
static int hf_lte_rrc_sib_TypeAndInfo = -1;       /* T_sib_TypeAndInfo */
static int hf_lte_rrc_sib_TypeAndInfo_item = -1;  /* T_sib_TypeAndInfo_item */
static int hf_lte_rrc_sib2 = -1;                  /* SystemInformationBlockType2 */
static int hf_lte_rrc_sib3 = -1;                  /* SystemInformationBlockType3 */
static int hf_lte_rrc_sib4 = -1;                  /* SystemInformationBlockType4 */
static int hf_lte_rrc_sib5 = -1;                  /* SystemInformationBlockType5 */
static int hf_lte_rrc_sib6 = -1;                  /* SystemInformationBlockType6 */
static int hf_lte_rrc_sib7 = -1;                  /* SystemInformationBlockType7 */
static int hf_lte_rrc_sib8 = -1;                  /* SystemInformationBlockType8 */
static int hf_lte_rrc_sib9 = -1;                  /* SystemInformationBlockType9 */
static int hf_lte_rrc_sib10 = -1;                 /* SystemInformationBlockType10 */
static int hf_lte_rrc_sib11 = -1;                 /* SystemInformationBlockType11 */
static int hf_lte_rrc_sib12_v920 = -1;            /* SystemInformationBlockType12_r9 */
static int hf_lte_rrc_sib13_v920 = -1;            /* SystemInformationBlockType13_r9 */
static int hf_lte_rrc_nonCriticalExtension_68 = -1;  /* SystemInformation_v8a0_IEs */
static int hf_lte_rrc_nonCriticalExtension_69 = -1;  /* T_nonCriticalExtension_30 */
static int hf_lte_rrc_cellAccessRelatedInfo = -1;  /* T_cellAccessRelatedInfo */
static int hf_lte_rrc_plmn_IdentityList = -1;     /* PLMN_IdentityList */
static int hf_lte_rrc_trackingAreaCode = -1;      /* TrackingAreaCode */
static int hf_lte_rrc_cellIdentity = -1;          /* CellIdentity */
static int hf_lte_rrc_cellBarred = -1;            /* T_cellBarred */
static int hf_lte_rrc_intraFreqReselection = -1;  /* T_intraFreqReselection */
static int hf_lte_rrc_csg_Indication = -1;        /* BOOLEAN */
static int hf_lte_rrc_csg_Identity = -1;          /* CSG_Identity */
static int hf_lte_rrc_cellSelectionInfo = -1;     /* T_cellSelectionInfo */
static int hf_lte_rrc_q_RxLevMin = -1;            /* Q_RxLevMin */
static int hf_lte_rrc_q_RxLevMinOffset = -1;      /* INTEGER_1_8 */
static int hf_lte_rrc_p_Max = -1;                 /* P_Max */
static int hf_lte_rrc_freqBandIndicator = -1;     /* INTEGER_1_64 */
static int hf_lte_rrc_schedulingInfoList = -1;    /* SchedulingInfoList */
static int hf_lte_rrc_tdd_Config = -1;            /* TDD_Config */
static int hf_lte_rrc_si_WindowLength = -1;       /* T_si_WindowLength */
static int hf_lte_rrc_systemInfoValueTag = -1;    /* INTEGER_0_31 */
static int hf_lte_rrc_nonCriticalExtension_70 = -1;  /* SystemInformationBlockType1_v890_IEs */
static int hf_lte_rrc_nonCriticalExtension_71 = -1;  /* SystemInformationBlockType1_v920_IEs */
static int hf_lte_rrc_ims_EmergencySupport_r9 = -1;  /* T_ims_EmergencySupport_r9 */
static int hf_lte_rrc_cellSelectionInfo_v920 = -1;  /* CellSelectionInfo_v920 */
static int hf_lte_rrc_nonCriticalExtension_72 = -1;  /* T_nonCriticalExtension_31 */
static int hf_lte_rrc_PLMN_IdentityList_item = -1;  /* PLMN_IdentityInfo */
static int hf_lte_rrc_cellReservedForOperatorUse = -1;  /* T_cellReservedForOperatorUse */
static int hf_lte_rrc_SchedulingInfoList_item = -1;  /* SchedulingInfo */
static int hf_lte_rrc_si_Periodicity = -1;        /* T_si_Periodicity */
static int hf_lte_rrc_sib_MappingInfo = -1;       /* SIB_MappingInfo */
static int hf_lte_rrc_SIB_MappingInfo_item = -1;  /* SIB_Type */
static int hf_lte_rrc_q_QualMin_r9 = -1;          /* Q_QualMin_r9 */
static int hf_lte_rrc_q_QualMinOffset_r9 = -1;    /* T_q_QualMinOffset_r9 */
static int hf_lte_rrc_criticalExtensions_29 = -1;  /* T_criticalExtensions_29 */
static int hf_lte_rrc_c1_25 = -1;                 /* T_c1_25 */
static int hf_lte_rrc_ueCapabilityEnquiry_r8 = -1;  /* UECapabilityEnquiry_r8_IEs */
static int hf_lte_rrc_criticalExtensionsFuture_29 = -1;  /* T_criticalExtensionsFuture_29 */
static int hf_lte_rrc_ue_CapabilityRequest = -1;  /* UE_CapabilityRequest */
static int hf_lte_rrc_nonCriticalExtension_73 = -1;  /* UECapabilityEnquiry_v8a0_IEs */
static int hf_lte_rrc_nonCriticalExtension_74 = -1;  /* T_nonCriticalExtension_32 */
static int hf_lte_rrc_UE_CapabilityRequest_item = -1;  /* RAT_Type */
static int hf_lte_rrc_criticalExtensions_30 = -1;  /* T_criticalExtensions_30 */
static int hf_lte_rrc_c1_26 = -1;                 /* T_c1_26 */
static int hf_lte_rrc_ueCapabilityInformation_r8 = -1;  /* UECapabilityInformation_r8_IEs */
static int hf_lte_rrc_criticalExtensionsFuture_30 = -1;  /* T_criticalExtensionsFuture_30 */
static int hf_lte_rrc_ue_CapabilityRAT_ContainerList = -1;  /* UE_CapabilityRAT_ContainerList */
static int hf_lte_rrc_nonCriticalExtension_75 = -1;  /* UECapabilityInformation_v8a0_IEs */
static int hf_lte_rrc_nonCriticalExtension_76 = -1;  /* T_nonCriticalExtension_33 */
static int hf_lte_rrc_criticalExtensions_31 = -1;  /* T_criticalExtensions_31 */
static int hf_lte_rrc_c1_27 = -1;                 /* T_c1_27 */
static int hf_lte_rrc_ueInformationRequest_r9_01 = -1;  /* UEInformationRequest_r9_IEs */
static int hf_lte_rrc_criticalExtensionsFuture_31 = -1;  /* T_criticalExtensionsFuture_31 */
static int hf_lte_rrc_rach_ReportReq_r9 = -1;     /* BOOLEAN */
static int hf_lte_rrc_rlf_ReportReq_r9 = -1;      /* BOOLEAN */
static int hf_lte_rrc_nonCriticalExtension_77 = -1;  /* UEInformationRequest_v930_IEs */
static int hf_lte_rrc_nonCriticalExtension_78 = -1;  /* UEInformationRequest_v1020_IEs */
static int hf_lte_rrc_logMeasReportReq_r10 = -1;  /* T_logMeasReportReq_r10 */
static int hf_lte_rrc_nonCriticalExtension_79 = -1;  /* T_nonCriticalExtension_34 */
static int hf_lte_rrc_criticalExtensions_32 = -1;  /* T_criticalExtensions_32 */
static int hf_lte_rrc_c1_28 = -1;                 /* T_c1_28 */
static int hf_lte_rrc_ueInformationResponse_r9_01 = -1;  /* UEInformationResponse_r9_IEs */
static int hf_lte_rrc_criticalExtensionsFuture_32 = -1;  /* T_criticalExtensionsFuture_32 */
static int hf_lte_rrc_rach_Report_r9 = -1;        /* T_rach_Report_r9 */
static int hf_lte_rrc_numberOfPreamblesSent_r9 = -1;  /* INTEGER_1_200 */
static int hf_lte_rrc_contentionDetected_r9 = -1;  /* BOOLEAN */
static int hf_lte_rrc_rlf_Report_r9 = -1;         /* RLF_Report_r9 */
static int hf_lte_rrc_nonCriticalExtension_80 = -1;  /* UEInformationResponse_v930_IEs */
static int hf_lte_rrc_nonCriticalExtension_81 = -1;  /* UEInformationResponse_v1020_IEs */
static int hf_lte_rrc_logMeasReport_r10 = -1;     /* LogMeasReport_r10 */
static int hf_lte_rrc_nonCriticalExtension_82 = -1;  /* T_nonCriticalExtension_35 */
static int hf_lte_rrc_measResultLastServCell_r9 = -1;  /* T_measResultLastServCell_r9 */
static int hf_lte_rrc_rsrpResult_r9 = -1;         /* RSRP_Range */
static int hf_lte_rrc_rsrqResult_r9 = -1;         /* RSRQ_Range */
static int hf_lte_rrc_measResultNeighCells_r9 = -1;  /* T_measResultNeighCells_r9 */
static int hf_lte_rrc_measResultListEUTRA_r9 = -1;  /* MeasResultList2EUTRA_r9 */
static int hf_lte_rrc_measResultListUTRA_r9 = -1;  /* MeasResultList2UTRA_r9 */
static int hf_lte_rrc_measResultListGERAN_r9 = -1;  /* MeasResultListGERAN */
static int hf_lte_rrc_measResultsCDMA2000_r9 = -1;  /* MeasResultList2CDMA2000_r9 */
static int hf_lte_rrc_locationInfo_r10 = -1;      /* LocationInfo_r10 */
static int hf_lte_rrc_failedPCellId_r10 = -1;     /* T_failedPCellId_r10 */
static int hf_lte_rrc_cellGlobalId_r10 = -1;      /* CellGlobalIdEUTRA */
static int hf_lte_rrc_pci_arfcn_r10 = -1;         /* T_pci_arfcn_r10 */
static int hf_lte_rrc_reestablishmentCellId_r10 = -1;  /* CellGlobalIdEUTRA */
static int hf_lte_rrc_timeConnFailure_r10 = -1;   /* T_timeConnFailure_r10 */
static int hf_lte_rrc_connectionFailureType_r10 = -1;  /* T_connectionFailureType_r10 */
static int hf_lte_rrc_previousPCellId_r10 = -1;   /* CellGlobalIdEUTRA */
static int hf_lte_rrc_MeasResultList2EUTRA_r9_item = -1;  /* MeasResult2EUTRA_r9 */
static int hf_lte_rrc_carrierFreq_r9_02 = -1;     /* ARFCN_ValueEUTRA */
static int hf_lte_rrc_measResultList_r9 = -1;     /* MeasResultListEUTRA */
static int hf_lte_rrc_MeasResultList2UTRA_r9_item = -1;  /* MeasResult2UTRA_r9 */
static int hf_lte_rrc_carrierFreq_r9_03 = -1;     /* ARFCN_ValueUTRA */
static int hf_lte_rrc_measResultList_r9_01 = -1;  /* MeasResultListUTRA */
static int hf_lte_rrc_MeasResultList2CDMA2000_r9_item = -1;  /* MeasResult2CDMA2000_r9 */
static int hf_lte_rrc_carrierFreq_r9_04 = -1;     /* CarrierFreqCDMA2000 */
static int hf_lte_rrc_measResultList_r9_02 = -1;  /* MeasResultsCDMA2000 */
static int hf_lte_rrc_absoluteTimeStamp_r10 = -1;  /* AbsoluteTimeInfo_r10 */
static int hf_lte_rrc_logMeasInfoList_r10 = -1;   /* LogMeasInfoList_r10 */
static int hf_lte_rrc_logMeasAvailable_r10_03 = -1;  /* T_logMeasAvailable_r10_03 */
static int hf_lte_rrc_LogMeasInfoList_r10_item = -1;  /* LogMeasInfo_r10 */
static int hf_lte_rrc_relativeTimeStamp_r10 = -1;  /* INTEGER_0_7200 */
static int hf_lte_rrc_servCellIdentity_r10 = -1;  /* CellGlobalIdEUTRA */
static int hf_lte_rrc_measResultServCell_r10 = -1;  /* T_measResultServCell_r10 */
static int hf_lte_rrc_rsrpResult_r10 = -1;        /* RSRP_Range */
static int hf_lte_rrc_rsrqResult_r10 = -1;        /* RSRQ_Range */
static int hf_lte_rrc_measResultNeighCells_r10 = -1;  /* T_measResultNeighCells_r10 */
static int hf_lte_rrc_measResultListEUTRA_r10 = -1;  /* MeasResultList2EUTRA_r9 */
static int hf_lte_rrc_measResultListUTRA_r10 = -1;  /* MeasResultList2UTRA_r9 */
static int hf_lte_rrc_measResultListGERAN_r10 = -1;  /* MeasResultList2GERAN_r10 */
static int hf_lte_rrc_measResultListCDMA2000_r10 = -1;  /* MeasResultList2CDMA2000_r9 */
static int hf_lte_rrc_MeasResultList2GERAN_r10_item = -1;  /* MeasResultListGERAN */
static int hf_lte_rrc_criticalExtensions_33 = -1;  /* T_criticalExtensions_33 */
static int hf_lte_rrc_c1_29 = -1;                 /* T_c1_29 */
static int hf_lte_rrc_ulHandoverPreparationTransfer_r8 = -1;  /* ULHandoverPreparationTransfer_r8_IEs */
static int hf_lte_rrc_criticalExtensionsFuture_33 = -1;  /* T_criticalExtensionsFuture_33 */
static int hf_lte_rrc_meid = -1;                  /* BIT_STRING_SIZE_56 */
static int hf_lte_rrc_dedicatedInfo = -1;         /* DedicatedInfoCDMA2000 */
static int hf_lte_rrc_nonCriticalExtension_83 = -1;  /* ULHandoverPreparationTransfer_v8a0_IEs */
static int hf_lte_rrc_nonCriticalExtension_84 = -1;  /* T_nonCriticalExtension_36 */
static int hf_lte_rrc_criticalExtensions_34 = -1;  /* T_criticalExtensions_34 */
static int hf_lte_rrc_c1_30 = -1;                 /* T_c1_30 */
static int hf_lte_rrc_ulInformationTransfer_r8 = -1;  /* ULInformationTransfer_r8_IEs */
static int hf_lte_rrc_criticalExtensionsFuture_34 = -1;  /* T_criticalExtensionsFuture_34 */
static int hf_lte_rrc_dedicatedInfoType_01 = -1;  /* T_dedicatedInfoType_01 */
static int hf_lte_rrc_nonCriticalExtension_85 = -1;  /* ULInformationTransfer_v8a0_IEs */
static int hf_lte_rrc_nonCriticalExtension_86 = -1;  /* T_nonCriticalExtension_37 */
static int hf_lte_rrc_ac_BarringInfo = -1;        /* T_ac_BarringInfo */
static int hf_lte_rrc_ac_BarringForEmergency = -1;  /* BOOLEAN */
static int hf_lte_rrc_ac_BarringForMO_Signalling = -1;  /* AC_BarringConfig */
static int hf_lte_rrc_ac_BarringForMO_Data = -1;  /* AC_BarringConfig */
static int hf_lte_rrc_radioResourceConfigCommon = -1;  /* RadioResourceConfigCommonSIB */
static int hf_lte_rrc_ue_TimersAndConstants = -1;  /* UE_TimersAndConstants */
static int hf_lte_rrc_freqInfo = -1;              /* T_freqInfo */
static int hf_lte_rrc_ul_CarrierFreq = -1;        /* ARFCN_ValueEUTRA */
static int hf_lte_rrc_ul_Bandwidth = -1;          /* T_ul_Bandwidth */
static int hf_lte_rrc_additionalSpectrumEmission = -1;  /* AdditionalSpectrumEmission */
static int hf_lte_rrc_mbsfn_SubframeConfigList = -1;  /* MBSFN_SubframeConfigList */
static int hf_lte_rrc_timeAlignmentTimerCommon = -1;  /* TimeAlignmentTimer */
static int hf_lte_rrc_ssac_BarringForMMTEL_Voice_r9 = -1;  /* AC_BarringConfig */
static int hf_lte_rrc_ssac_BarringForMMTEL_Video_r9 = -1;  /* AC_BarringConfig */
static int hf_lte_rrc_ac_BarringForCSFB_r10 = -1;  /* AC_BarringConfig */
static int hf_lte_rrc_ac_BarringFactor = -1;      /* T_ac_BarringFactor */
static int hf_lte_rrc_ac_BarringTime = -1;        /* T_ac_BarringTime */
static int hf_lte_rrc_ac_BarringForSpecialAC = -1;  /* BIT_STRING_SIZE_5 */
static int hf_lte_rrc_MBSFN_SubframeConfigList_item = -1;  /* MBSFN_SubframeConfig */
static int hf_lte_rrc_cellReselectionInfoCommon = -1;  /* T_cellReselectionInfoCommon */
static int hf_lte_rrc_q_Hyst = -1;                /* T_q_Hyst */
static int hf_lte_rrc_speedStateReselectionPars = -1;  /* T_speedStateReselectionPars */
static int hf_lte_rrc_mobilityStateParameters = -1;  /* MobilityStateParameters */
static int hf_lte_rrc_q_HystSF = -1;              /* T_q_HystSF */
static int hf_lte_rrc_sf_Medium = -1;             /* T_sf_Medium */
static int hf_lte_rrc_sf_High = -1;               /* T_sf_High */
static int hf_lte_rrc_cellReselectionServingFreqInfo = -1;  /* T_cellReselectionServingFreqInfo */
static int hf_lte_rrc_s_NonIntraSearch = -1;      /* ReselectionThreshold */
static int hf_lte_rrc_threshServingLow = -1;      /* ReselectionThreshold */
static int hf_lte_rrc_intraFreqCellReselectionInfo = -1;  /* T_intraFreqCellReselectionInfo */
static int hf_lte_rrc_s_IntraSearch = -1;         /* ReselectionThreshold */
static int hf_lte_rrc_allowedMeasBandwidth = -1;  /* AllowedMeasBandwidth */
static int hf_lte_rrc_presenceAntennaPort1 = -1;  /* PresenceAntennaPort1 */
static int hf_lte_rrc_neighCellConfig = -1;       /* NeighCellConfig */
static int hf_lte_rrc_t_ReselectionEUTRA = -1;    /* T_Reselection */
static int hf_lte_rrc_t_ReselectionEUTRA_SF = -1;  /* SpeedStateScaleFactors */
static int hf_lte_rrc_s_IntraSearch_v920 = -1;    /* T_s_IntraSearch_v920 */
static int hf_lte_rrc_s_IntraSearchP_r9 = -1;     /* ReselectionThreshold */
static int hf_lte_rrc_s_IntraSearchQ_r9 = -1;     /* ReselectionThresholdQ_r9 */
static int hf_lte_rrc_s_NonIntraSearch_v920 = -1;  /* T_s_NonIntraSearch_v920 */
static int hf_lte_rrc_s_NonIntraSearchP_r9 = -1;  /* ReselectionThreshold */
static int hf_lte_rrc_s_NonIntraSearchQ_r9 = -1;  /* ReselectionThresholdQ_r9 */
static int hf_lte_rrc_threshServingLowQ_r9 = -1;  /* ReselectionThresholdQ_r9 */
static int hf_lte_rrc_intraFreqNeighCellList = -1;  /* IntraFreqNeighCellList */
static int hf_lte_rrc_intraFreqBlackCellList = -1;  /* IntraFreqBlackCellList */
static int hf_lte_rrc_csg_PhysCellIdRange = -1;   /* PhysCellIdRange */
static int hf_lte_rrc_IntraFreqNeighCellList_item = -1;  /* IntraFreqNeighCellInfo */
static int hf_lte_rrc_q_OffsetCell = -1;          /* Q_OffsetRange */
static int hf_lte_rrc_IntraFreqBlackCellList_item = -1;  /* PhysCellIdRange */
static int hf_lte_rrc_interFreqCarrierFreqList = -1;  /* InterFreqCarrierFreqList */
static int hf_lte_rrc_InterFreqCarrierFreqList_item = -1;  /* InterFreqCarrierFreqInfo */
static int hf_lte_rrc_dl_CarrierFreq = -1;        /* ARFCN_ValueEUTRA */
static int hf_lte_rrc_threshX_High = -1;          /* ReselectionThreshold */
static int hf_lte_rrc_threshX_Low = -1;           /* ReselectionThreshold */
static int hf_lte_rrc_q_OffsetFreq = -1;          /* Q_OffsetRange */
static int hf_lte_rrc_interFreqNeighCellList = -1;  /* InterFreqNeighCellList */
static int hf_lte_rrc_interFreqBlackCellList = -1;  /* InterFreqBlackCellList */
static int hf_lte_rrc_threshX_Q_r9 = -1;          /* T_threshX_Q_r9 */
static int hf_lte_rrc_threshX_HighQ_r9 = -1;      /* ReselectionThresholdQ_r9 */
static int hf_lte_rrc_threshX_LowQ_r9 = -1;       /* ReselectionThresholdQ_r9 */
static int hf_lte_rrc_InterFreqNeighCellList_item = -1;  /* InterFreqNeighCellInfo */
static int hf_lte_rrc_InterFreqBlackCellList_item = -1;  /* PhysCellIdRange */
static int hf_lte_rrc_carrierFreqListUTRA_FDD = -1;  /* CarrierFreqListUTRA_FDD */
static int hf_lte_rrc_carrierFreqListUTRA_TDD = -1;  /* CarrierFreqListUTRA_TDD */
static int hf_lte_rrc_t_ReselectionUTRA = -1;     /* T_Reselection */
static int hf_lte_rrc_t_ReselectionUTRA_SF = -1;  /* SpeedStateScaleFactors */
static int hf_lte_rrc_CarrierFreqListUTRA_FDD_item = -1;  /* CarrierFreqUTRA_FDD */
static int hf_lte_rrc_q_RxLevMin_01 = -1;         /* INTEGER_M60_M13 */
static int hf_lte_rrc_p_MaxUTRA = -1;             /* T_p_MaxUTRA */
static int hf_lte_rrc_q_QualMin = -1;             /* T_q_QualMin */
static int hf_lte_rrc_threshX_Q_r9_01 = -1;       /* T_threshX_Q_r9_01 */
static int hf_lte_rrc_CarrierFreqListUTRA_TDD_item = -1;  /* CarrierFreqUTRA_TDD */
static int hf_lte_rrc_p_MaxUTRA_01 = -1;          /* T_p_MaxUTRA_01 */
static int hf_lte_rrc_t_ReselectionGERAN = -1;    /* T_Reselection */
static int hf_lte_rrc_t_ReselectionGERAN_SF = -1;  /* SpeedStateScaleFactors */
static int hf_lte_rrc_carrierFreqsInfoList = -1;  /* CarrierFreqsInfoListGERAN */
static int hf_lte_rrc_CarrierFreqsInfoListGERAN_item = -1;  /* CarrierFreqsInfoGERAN */
static int hf_lte_rrc_commonInfo = -1;            /* T_commonInfo */
static int hf_lte_rrc_ncc_Permitted = -1;         /* BIT_STRING_SIZE_8 */
static int hf_lte_rrc_q_RxLevMin_02 = -1;         /* INTEGER_0_45 */
static int hf_lte_rrc_p_MaxGERAN = -1;            /* T_p_MaxGERAN */
static int hf_lte_rrc_systemTimeInfo = -1;        /* SystemTimeInfoCDMA2000 */
static int hf_lte_rrc_searchWindowSize = -1;      /* INTEGER_0_15 */
static int hf_lte_rrc_parametersHRPD = -1;        /* T_parametersHRPD */
static int hf_lte_rrc_preRegistrationInfoHRPD = -1;  /* PreRegistrationInfoHRPD */
static int hf_lte_rrc_cellReselectionParametersHRPD = -1;  /* CellReselectionParametersCDMA2000 */
static int hf_lte_rrc_parameters1XRTT = -1;       /* T_parameters1XRTT */
static int hf_lte_rrc_csfb_RegistrationParam1XRTT = -1;  /* CSFB_RegistrationParam1XRTT */
static int hf_lte_rrc_longCodeState1XRTT = -1;    /* BIT_STRING_SIZE_42 */
static int hf_lte_rrc_cellReselectionParameters1XRTT = -1;  /* CellReselectionParametersCDMA2000 */
static int hf_lte_rrc_csfb_SupportForDualRxUEs_r9 = -1;  /* BOOLEAN */
static int hf_lte_rrc_cellReselectionParametersHRPD_v920 = -1;  /* CellReselectionParametersCDMA2000_v920 */
static int hf_lte_rrc_cellReselectionParameters1XRTT_v920 = -1;  /* CellReselectionParametersCDMA2000_v920 */
static int hf_lte_rrc_csfb_RegistrationParam1XRTT_v920 = -1;  /* CSFB_RegistrationParam1XRTT_v920 */
static int hf_lte_rrc_ac_BarringConfig1XRTT_r9 = -1;  /* AC_BarringConfig1XRTT_r9 */
static int hf_lte_rrc_csfb_DualRxTxSupport_r10 = -1;  /* T_csfb_DualRxTxSupport_r10 */
static int hf_lte_rrc_bandClassList = -1;         /* BandClassListCDMA2000 */
static int hf_lte_rrc_neighCellList = -1;         /* NeighCellListCDMA2000 */
static int hf_lte_rrc_t_ReselectionCDMA2000 = -1;  /* T_Reselection */
static int hf_lte_rrc_t_ReselectionCDMA2000_SF = -1;  /* SpeedStateScaleFactors */
static int hf_lte_rrc_neighCellList_v920 = -1;    /* NeighCellListCDMA2000_v920 */
static int hf_lte_rrc_NeighCellListCDMA2000_item = -1;  /* NeighCellCDMA2000 */
static int hf_lte_rrc_neighCellsPerFreqList = -1;  /* NeighCellsPerBandclassListCDMA2000 */
static int hf_lte_rrc_NeighCellsPerBandclassListCDMA2000_item = -1;  /* NeighCellsPerBandclassCDMA2000 */
static int hf_lte_rrc_arfcn = -1;                 /* ARFCN_ValueCDMA2000 */
static int hf_lte_rrc_physCellIdList = -1;        /* PhysCellIdListCDMA2000 */
static int hf_lte_rrc_NeighCellListCDMA2000_v920_item = -1;  /* NeighCellCDMA2000_v920 */
static int hf_lte_rrc_neighCellsPerFreqList_v920 = -1;  /* NeighCellsPerBandclassListCDMA2000_v920 */
static int hf_lte_rrc_NeighCellsPerBandclassListCDMA2000_v920_item = -1;  /* NeighCellsPerBandclassCDMA2000_v920 */
static int hf_lte_rrc_physCellIdList_v920 = -1;   /* PhysCellIdListCDMA2000_v920 */
static int hf_lte_rrc_PhysCellIdListCDMA2000_item = -1;  /* PhysCellIdCDMA2000 */
static int hf_lte_rrc_PhysCellIdListCDMA2000_v920_item = -1;  /* PhysCellIdCDMA2000 */
static int hf_lte_rrc_BandClassListCDMA2000_item = -1;  /* BandClassInfoCDMA2000 */
static int hf_lte_rrc_threshX_High_01 = -1;       /* INTEGER_0_63 */
static int hf_lte_rrc_threshX_Low_01 = -1;        /* INTEGER_0_63 */
static int hf_lte_rrc_ac_Barring0to9_r9 = -1;     /* INTEGER_0_63 */
static int hf_lte_rrc_ac_Barring10_r9 = -1;       /* INTEGER_0_7 */
static int hf_lte_rrc_ac_Barring11_r9 = -1;       /* INTEGER_0_7 */
static int hf_lte_rrc_ac_Barring12_r9 = -1;       /* INTEGER_0_7 */
static int hf_lte_rrc_ac_Barring13_r9 = -1;       /* INTEGER_0_7 */
static int hf_lte_rrc_ac_Barring14_r9 = -1;       /* INTEGER_0_7 */
static int hf_lte_rrc_ac_Barring15_r9 = -1;       /* INTEGER_0_7 */
static int hf_lte_rrc_ac_BarringMsg_r9 = -1;      /* INTEGER_0_7 */
static int hf_lte_rrc_ac_BarringReg_r9 = -1;      /* INTEGER_0_7 */
static int hf_lte_rrc_ac_BarringEmg_r9 = -1;      /* INTEGER_0_7 */
static int hf_lte_rrc_hnb_Name = -1;              /* OCTET_STRING_SIZE_1_48 */
static int hf_lte_rrc_messageIdentifier = -1;     /* BIT_STRING_SIZE_16 */
static int hf_lte_rrc_serialNumber = -1;          /* BIT_STRING_SIZE_16 */
static int hf_lte_rrc_warningType = -1;           /* OCTET_STRING_SIZE_2 */
static int hf_lte_rrc_warningSecurityInfo = -1;   /* OCTET_STRING_SIZE_50 */
static int hf_lte_rrc_warningMessageSegmentType = -1;  /* T_warningMessageSegmentType */
static int hf_lte_rrc_warningMessageSegmentNumber = -1;  /* INTEGER_0_63 */
static int hf_lte_rrc_warningMessageSegment = -1;  /* OCTET_STRING */
static int hf_lte_rrc_dataCodingScheme = -1;      /* OCTET_STRING_SIZE_1 */
static int hf_lte_rrc_messageIdentifier_r9 = -1;  /* BIT_STRING_SIZE_16 */
static int hf_lte_rrc_serialNumber_r9 = -1;       /* BIT_STRING_SIZE_16 */
static int hf_lte_rrc_warningMessageSegmentType_r9 = -1;  /* T_warningMessageSegmentType_r9 */
static int hf_lte_rrc_warningMessageSegmentNumber_r9 = -1;  /* INTEGER_0_63 */
static int hf_lte_rrc_warningMessageSegment_r9 = -1;  /* OCTET_STRING */
static int hf_lte_rrc_dataCodingScheme_r9 = -1;   /* OCTET_STRING_SIZE_1 */
static int hf_lte_rrc_mbsfn_AreaInfoList_r9 = -1;  /* MBSFN_AreaInfoList_r9 */
static int hf_lte_rrc_notificationConfig_r9 = -1;  /* MBMS_NotificationConfig_r9 */
static int hf_lte_rrc_antennaPortsCount = -1;     /* T_antennaPortsCount */
static int hf_lte_rrc_transmissionMode = -1;      /* T_transmissionMode */
static int hf_lte_rrc_codebookSubsetRestriction = -1;  /* T_codebookSubsetRestriction */
static int hf_lte_rrc_n2TxAntenna_tm3 = -1;       /* BIT_STRING_SIZE_2 */
static int hf_lte_rrc_n4TxAntenna_tm3 = -1;       /* BIT_STRING_SIZE_4 */
static int hf_lte_rrc_n2TxAntenna_tm4 = -1;       /* BIT_STRING_SIZE_6 */
static int hf_lte_rrc_n4TxAntenna_tm4 = -1;       /* BIT_STRING_SIZE_64 */
static int hf_lte_rrc_n2TxAntenna_tm5 = -1;       /* BIT_STRING_SIZE_4 */
static int hf_lte_rrc_n4TxAntenna_tm5 = -1;       /* BIT_STRING_SIZE_16 */
static int hf_lte_rrc_n2TxAntenna_tm6 = -1;       /* BIT_STRING_SIZE_4 */
static int hf_lte_rrc_n4TxAntenna_tm6 = -1;       /* BIT_STRING_SIZE_16 */
static int hf_lte_rrc_ue_TransmitAntennaSelection = -1;  /* T_ue_TransmitAntennaSelection */
static int hf_lte_rrc_release = -1;               /* NULL */
static int hf_lte_rrc_setup = -1;                 /* T_setup */
static int hf_lte_rrc_codebookSubsetRestriction_v920 = -1;  /* T_codebookSubsetRestriction_v920 */
static int hf_lte_rrc_n2TxAntenna_tm8_r9 = -1;    /* BIT_STRING_SIZE_6 */
static int hf_lte_rrc_n4TxAntenna_tm8_r9 = -1;    /* BIT_STRING_SIZE_32 */
static int hf_lte_rrc_transmissionMode_r10 = -1;  /* T_transmissionMode_r10 */
static int hf_lte_rrc_codebookSubsetRestriction_r10 = -1;  /* BIT_STRING */
static int hf_lte_rrc_ue_TransmitAntennaSelection_01 = -1;  /* T_ue_TransmitAntennaSelection_01 */
static int hf_lte_rrc_setup_01 = -1;              /* T_setup_01 */
static int hf_lte_rrc_transmissionModeUL_r10 = -1;  /* T_transmissionModeUL_r10 */
static int hf_lte_rrc_fourAntennaPortActivated_r10 = -1;  /* T_fourAntennaPortActivated_r10 */
static int hf_lte_rrc_cqi_ReportModeAperiodic = -1;  /* CQI_ReportModeAperiodic */
static int hf_lte_rrc_nomPDSCH_RS_EPRE_Offset = -1;  /* INTEGER_M1_6 */
static int hf_lte_rrc_cqi_ReportPeriodic = -1;    /* CQI_ReportPeriodic */
static int hf_lte_rrc_cqi_Mask_r9 = -1;           /* T_cqi_Mask_r9 */
static int hf_lte_rrc_pmi_RI_Report_r9 = -1;      /* T_pmi_RI_Report_r9 */
static int hf_lte_rrc_cqi_ReportAperiodic_r10 = -1;  /* CQI_ReportAperiodic_r10 */
static int hf_lte_rrc_cqi_ReportPeriodic_r10 = -1;  /* CQI_ReportPeriodic_r10 */
static int hf_lte_rrc_pmi_RI_Report_r9_01 = -1;   /* T_pmi_RI_Report_r9_01 */
static int hf_lte_rrc_csi_SubframePatternConfig_r10 = -1;  /* T_csi_SubframePatternConfig_r10 */
static int hf_lte_rrc_setup_02 = -1;              /* T_setup_02 */
static int hf_lte_rrc_csi_MeasSubframeSet1_r10 = -1;  /* MeasSubframePattern_r10 */
static int hf_lte_rrc_csi_MeasSubframeSet2_r10 = -1;  /* MeasSubframePattern_r10 */
static int hf_lte_rrc_cqi_ReportModeAperiodic_r10 = -1;  /* CQI_ReportModeAperiodic */
static int hf_lte_rrc_nomPDSCH_RS_EPRE_Offset_r10 = -1;  /* INTEGER_M1_6 */
static int hf_lte_rrc_cqi_ReportPeriodicSCell_r10 = -1;  /* CQI_ReportPeriodic_r10 */
static int hf_lte_rrc_pmi_RI_Report_r10 = -1;     /* T_pmi_RI_Report_r10 */
static int hf_lte_rrc_setup_03 = -1;              /* T_setup_03 */
static int hf_lte_rrc_cqi_PUCCH_ResourceIndex = -1;  /* INTEGER_0_1185 */
static int hf_lte_rrc_cqi_pmi_ConfigIndex = -1;   /* INTEGER_0_1023 */
static int hf_lte_rrc_cqi_FormatIndicatorPeriodic = -1;  /* T_cqi_FormatIndicatorPeriodic */
static int hf_lte_rrc_widebandCQI = -1;           /* NULL */
static int hf_lte_rrc_subbandCQI = -1;            /* T_subbandCQI */
static int hf_lte_rrc_k = -1;                     /* INTEGER_1_4 */
static int hf_lte_rrc_ri_ConfigIndex = -1;        /* INTEGER_0_1023 */
static int hf_lte_rrc_simultaneousAckNackAndCQI = -1;  /* BOOLEAN */
static int hf_lte_rrc_setup_04 = -1;              /* T_setup_04 */
static int hf_lte_rrc_cqi_PUCCH_ResourceIndex_r10 = -1;  /* INTEGER_0_1184 */
static int hf_lte_rrc_cqi_PUCCH_ResourceIndexP1_r10 = -1;  /* INTEGER_0_1184 */
static int hf_lte_rrc_cqi_FormatIndicatorPeriodic_r10 = -1;  /* T_cqi_FormatIndicatorPeriodic_r10 */
static int hf_lte_rrc_widebandCQI_r10 = -1;       /* T_widebandCQI_r10 */
static int hf_lte_rrc_csi_ReportMode_r10 = -1;    /* T_csi_ReportMode_r10 */
static int hf_lte_rrc_subbandCQI_r10 = -1;        /* T_subbandCQI_r10 */
static int hf_lte_rrc_periodicityFactor_r10 = -1;  /* T_periodicityFactor_r10 */
static int hf_lte_rrc_cqi_Mask_r9_01 = -1;        /* T_cqi_Mask_r9_01 */
static int hf_lte_rrc_csi_ConfigIndex_r10 = -1;   /* T_csi_ConfigIndex_r10 */
static int hf_lte_rrc_setup_05 = -1;              /* T_setup_05 */
static int hf_lte_rrc_cqi_pmi_ConfigIndex2_r10 = -1;  /* INTEGER_0_1023 */
static int hf_lte_rrc_ri_ConfigIndex2_r10 = -1;   /* INTEGER_0_1023 */
static int hf_lte_rrc_setup_06 = -1;              /* T_setup_06 */
static int hf_lte_rrc_aperiodicCSI_Trigger_r10 = -1;  /* T_aperiodicCSI_Trigger_r10 */
static int hf_lte_rrc_trigger1_r10 = -1;          /* BIT_STRING_SIZE_8 */
static int hf_lte_rrc_trigger2_r10 = -1;          /* BIT_STRING_SIZE_8 */
static int hf_lte_rrc_schedulingCellInfo_r10 = -1;  /* T_schedulingCellInfo_r10 */
static int hf_lte_rrc_own_r10 = -1;               /* T_own_r10 */
static int hf_lte_rrc_cif_Presence_r10 = -1;      /* BOOLEAN */
static int hf_lte_rrc_other_r10 = -1;             /* T_other_r10 */
static int hf_lte_rrc_schedulingCellId_r10 = -1;  /* ServCellIndex_r10 */
static int hf_lte_rrc_pdsch_Start_r10 = -1;       /* INTEGER_1_4 */
static int hf_lte_rrc_csi_RS_r10 = -1;            /* T_csi_RS_r10 */
static int hf_lte_rrc_setup_07 = -1;              /* T_setup_07 */
static int hf_lte_rrc_antennaPortsCount_r10 = -1;  /* T_antennaPortsCount_r10 */
static int hf_lte_rrc_resourceConfig_r10 = -1;    /* INTEGER_0_31 */
static int hf_lte_rrc_subframeConfig_r10 = -1;    /* INTEGER_0_154 */
static int hf_lte_rrc_p_C_r10 = -1;               /* INTEGER_M8_15 */
static int hf_lte_rrc_zeroTxPowerCSI_RS_r10 = -1;  /* T_zeroTxPowerCSI_RS_r10 */
static int hf_lte_rrc_setup_08 = -1;              /* T_setup_08 */
static int hf_lte_rrc_zeroTxPowerResourceConfigList_r10 = -1;  /* BIT_STRING_SIZE_16 */
static int hf_lte_rrc_zeroTxPowerSubframeConfig_r10 = -1;  /* INTEGER_0_154 */
static int hf_lte_rrc_ul_SpecificParameters = -1;  /* T_ul_SpecificParameters */
static int hf_lte_rrc_priority = -1;              /* INTEGER_1_16 */
static int hf_lte_rrc_prioritisedBitRate = -1;    /* T_prioritisedBitRate */
static int hf_lte_rrc_bucketSizeDuration = -1;    /* T_bucketSizeDuration */
static int hf_lte_rrc_logicalChannelGroup = -1;   /* INTEGER_0_3 */
static int hf_lte_rrc_logicalChannelSR_Mask_r9 = -1;  /* T_logicalChannelSR_Mask_r9 */
static int hf_lte_rrc_ul_SCH_Config = -1;         /* T_ul_SCH_Config */
static int hf_lte_rrc_maxHARQ_Tx = -1;            /* T_maxHARQ_Tx */
static int hf_lte_rrc_periodicBSR_Timer = -1;     /* T_periodicBSR_Timer */
static int hf_lte_rrc_retxBSR_Timer = -1;         /* T_retxBSR_Timer */
static int hf_lte_rrc_ttiBundling = -1;           /* BOOLEAN */
static int hf_lte_rrc_drx_Config = -1;            /* DRX_Config */
static int hf_lte_rrc_timeAlignmentTimerDedicated = -1;  /* TimeAlignmentTimer */
static int hf_lte_rrc_phr_Config = -1;            /* T_phr_Config */
static int hf_lte_rrc_setup_09 = -1;              /* T_setup_09 */
static int hf_lte_rrc_periodicPHR_Timer = -1;     /* T_periodicPHR_Timer */
static int hf_lte_rrc_prohibitPHR_Timer = -1;     /* T_prohibitPHR_Timer */
static int hf_lte_rrc_dl_PathlossChange = -1;     /* T_dl_PathlossChange */
static int hf_lte_rrc_sr_ProhibitTimer_r9 = -1;   /* T_sr_ProhibitTimer_r9 */
static int hf_lte_rrc_mac_MainConfig_v1020 = -1;  /* T_mac_MainConfig_v1020 */
static int hf_lte_rrc_sCellDeactivationTimer_r10 = -1;  /* T_sCellDeactivationTimer_r10 */
static int hf_lte_rrc_extendedBSR_Sizes_r10 = -1;  /* T_extendedBSR_Sizes_r10 */
static int hf_lte_rrc_extendedPHR_r10 = -1;       /* T_extendedPHR_r10 */
static int hf_lte_rrc_setup_10 = -1;              /* T_setup_10 */
static int hf_lte_rrc_onDurationTimer = -1;       /* T_onDurationTimer */
static int hf_lte_rrc_drx_InactivityTimer = -1;   /* T_drx_InactivityTimer */
static int hf_lte_rrc_drx_RetransmissionTimer = -1;  /* T_drx_RetransmissionTimer */
static int hf_lte_rrc_longDRX_CycleStartOffset = -1;  /* T_longDRX_CycleStartOffset */
static int hf_lte_rrc_sf10 = -1;                  /* INTEGER_0_9 */
static int hf_lte_rrc_sf20 = -1;                  /* INTEGER_0_19 */
static int hf_lte_rrc_sf32 = -1;                  /* INTEGER_0_31 */
static int hf_lte_rrc_sf40 = -1;                  /* INTEGER_0_39 */
static int hf_lte_rrc_sf64 = -1;                  /* INTEGER_0_63 */
static int hf_lte_rrc_sf80 = -1;                  /* INTEGER_0_79 */
static int hf_lte_rrc_sf128 = -1;                 /* INTEGER_0_127 */
static int hf_lte_rrc_sf160 = -1;                 /* INTEGER_0_159 */
static int hf_lte_rrc_sf256 = -1;                 /* INTEGER_0_255 */
static int hf_lte_rrc_sf320 = -1;                 /* INTEGER_0_319 */
static int hf_lte_rrc_sf512 = -1;                 /* INTEGER_0_511 */
static int hf_lte_rrc_sf640 = -1;                 /* INTEGER_0_639 */
static int hf_lte_rrc_sf1024 = -1;                /* INTEGER_0_1023 */
static int hf_lte_rrc_sf1280 = -1;                /* INTEGER_0_1279 */
static int hf_lte_rrc_sf2048 = -1;                /* INTEGER_0_2047 */
static int hf_lte_rrc_sf2560 = -1;                /* INTEGER_0_2559 */
static int hf_lte_rrc_shortDRX = -1;              /* T_shortDRX */
static int hf_lte_rrc_shortDRX_Cycle = -1;        /* T_shortDRX_Cycle */
static int hf_lte_rrc_drxShortCycleTimer = -1;    /* T_drxShortCycleTimer */
static int hf_lte_rrc_discardTimer = -1;          /* T_discardTimer */
static int hf_lte_rrc_rlc_AM = -1;                /* T_rlc_AM */
static int hf_lte_rrc_statusReportRequired = -1;  /* BOOLEAN */
static int hf_lte_rrc_rlc_UM = -1;                /* T_rlc_UM */
static int hf_lte_rrc_pdcp_SN_Size = -1;          /* T_pdcp_SN_Size */
static int hf_lte_rrc_headerCompression = -1;     /* T_headerCompression */
static int hf_lte_rrc_notUsed = -1;               /* NULL */
static int hf_lte_rrc_rohc = -1;                  /* T_rohc */
static int hf_lte_rrc_maxCID = -1;                /* INTEGER_1_16383 */
static int hf_lte_rrc_profiles = -1;              /* T_profiles */
static int hf_lte_rrc_profile0x0001 = -1;         /* BOOLEAN */
static int hf_lte_rrc_profile0x0002 = -1;         /* BOOLEAN */
static int hf_lte_rrc_profile0x0003 = -1;         /* BOOLEAN */
static int hf_lte_rrc_profile0x0004 = -1;         /* BOOLEAN */
static int hf_lte_rrc_profile0x0006 = -1;         /* BOOLEAN */
static int hf_lte_rrc_profile0x0101 = -1;         /* BOOLEAN */
static int hf_lte_rrc_profile0x0102 = -1;         /* BOOLEAN */
static int hf_lte_rrc_profile0x0103 = -1;         /* BOOLEAN */
static int hf_lte_rrc_profile0x0104 = -1;         /* BOOLEAN */
static int hf_lte_rrc_rn_IntegrityProtection_r10 = -1;  /* T_rn_IntegrityProtection_r10 */
static int hf_lte_rrc_referenceSignalPower = -1;  /* T_referenceSignalPower */
static int hf_lte_rrc_p_b = -1;                   /* INTEGER_0_3 */
static int hf_lte_rrc_p_a = -1;                   /* T_p_a */
static int hf_lte_rrc_phich_Duration = -1;        /* T_phich_Duration */
static int hf_lte_rrc_phich_Resource = -1;        /* T_phich_Resource */
static int hf_lte_rrc_pdsch_ConfigDedicated = -1;  /* PDSCH_ConfigDedicated */
static int hf_lte_rrc_pucch_ConfigDedicated = -1;  /* PUCCH_ConfigDedicated */
static int hf_lte_rrc_pusch_ConfigDedicated = -1;  /* PUSCH_ConfigDedicated */
static int hf_lte_rrc_uplinkPowerControlDedicated = -1;  /* UplinkPowerControlDedicated */
static int hf_lte_rrc_tpc_PDCCH_ConfigPUCCH = -1;  /* TPC_PDCCH_Config */
static int hf_lte_rrc_tpc_PDCCH_ConfigPUSCH = -1;  /* TPC_PDCCH_Config */
static int hf_lte_rrc_cqi_ReportConfig = -1;      /* CQI_ReportConfig */
static int hf_lte_rrc_soundingRS_UL_ConfigDedicated = -1;  /* SoundingRS_UL_ConfigDedicated */
static int hf_lte_rrc_antennaInfo = -1;           /* T_antennaInfo */
static int hf_lte_rrc_explicitValue = -1;         /* AntennaInfoDedicated */
static int hf_lte_rrc_defaultValue = -1;          /* NULL */
static int hf_lte_rrc_schedulingRequestConfig = -1;  /* SchedulingRequestConfig */
static int hf_lte_rrc_cqi_ReportConfig_v920 = -1;  /* CQI_ReportConfig_v920 */
static int hf_lte_rrc_antennaInfo_v920 = -1;      /* AntennaInfoDedicated_v920 */
static int hf_lte_rrc_antennaInfo_r10 = -1;       /* T_antennaInfo_r10 */
static int hf_lte_rrc_explicitValue_r10 = -1;     /* AntennaInfoDedicated_r10 */
static int hf_lte_rrc_antennaInfoUL_r10 = -1;     /* AntennaInfoUL_r10 */
static int hf_lte_rrc_cqi_ReportConfig_r10 = -1;  /* CQI_ReportConfig_r10 */
static int hf_lte_rrc_csi_RS_Config_r10 = -1;     /* CSI_RS_Config_r10 */
static int hf_lte_rrc_pucch_ConfigDedicated_v1020 = -1;  /* PUCCH_ConfigDedicated_v1020 */
static int hf_lte_rrc_pusch_ConfigDedicated_v1020 = -1;  /* PUSCH_ConfigDedicated_v1020 */
static int hf_lte_rrc_schedulingRequestConfig_v1020 = -1;  /* SchedulingRequestConfig_v1020 */
static int hf_lte_rrc_soundingRS_UL_ConfigDedicated_v1020 = -1;  /* SoundingRS_UL_ConfigDedicated_v1020 */
static int hf_lte_rrc_soundingRS_UL_ConfigDedicatedAperiodic_r10 = -1;  /* SoundingRS_UL_ConfigDedicatedAperiodic_r10 */
static int hf_lte_rrc_uplinkPowerControlDedicated_v1020 = -1;  /* UplinkPowerControlDedicated_v1020 */
static int hf_lte_rrc_additionalSpectrumEmissionCA_r10 = -1;  /* T_additionalSpectrumEmissionCA_r10 */
static int hf_lte_rrc_setup_11 = -1;              /* T_setup_11 */
static int hf_lte_rrc_additionalSpectrumEmissionPCell_r10 = -1;  /* AdditionalSpectrumEmission */
static int hf_lte_rrc_nonUL_Configuration_r10 = -1;  /* T_nonUL_Configuration_r10 */
static int hf_lte_rrc_antennaInfo_r10_01 = -1;    /* AntennaInfoDedicated_r10 */
static int hf_lte_rrc_crossCarrierSchedulingConfig_r10 = -1;  /* CrossCarrierSchedulingConfig_r10 */
static int hf_lte_rrc_pdsch_ConfigDedicated_r10 = -1;  /* PDSCH_ConfigDedicated */
static int hf_lte_rrc_ul_Configuration_r10 = -1;  /* T_ul_Configuration_r10 */
static int hf_lte_rrc_pusch_ConfigDedicatedSCell_r10 = -1;  /* PUSCH_ConfigDedicatedSCell_r10 */
static int hf_lte_rrc_uplinkPowerControlDedicatedSCell_r10 = -1;  /* UplinkPowerControlDedicatedSCell_r10 */
static int hf_lte_rrc_cqi_ReportConfigSCell_r10 = -1;  /* CQI_ReportConfigSCell_r10 */
static int hf_lte_rrc_soundingRS_UL_ConfigDedicated_r10 = -1;  /* SoundingRS_UL_ConfigDedicated */
static int hf_lte_rrc_rootSequenceIndex = -1;     /* INTEGER_0_837 */
static int hf_lte_rrc_prach_ConfigInfo = -1;      /* PRACH_ConfigInfo */
static int hf_lte_rrc_prach_ConfigIndex_r10 = -1;  /* INTEGER_0_63 */
static int hf_lte_rrc_prach_ConfigIndex = -1;     /* INTEGER_0_63 */
static int hf_lte_rrc_highSpeedFlag = -1;         /* BOOLEAN */
static int hf_lte_rrc_zeroCorrelationZoneConfig = -1;  /* INTEGER_0_15 */
static int hf_lte_rrc_prach_FreqOffset = -1;      /* INTEGER_0_94 */
static int hf_lte_rrc_deltaPUCCH_Shift = -1;      /* T_deltaPUCCH_Shift */
static int hf_lte_rrc_nRB_CQI = -1;               /* INTEGER_0_98 */
static int hf_lte_rrc_nCS_AN = -1;                /* INTEGER_0_7 */
static int hf_lte_rrc_n1PUCCH_AN = -1;            /* INTEGER_0_2047 */
static int hf_lte_rrc_ackNackRepetition = -1;     /* T_ackNackRepetition */
static int hf_lte_rrc_setup_12 = -1;              /* T_setup_12 */
static int hf_lte_rrc_repetitionFactor = -1;      /* T_repetitionFactor */
static int hf_lte_rrc_n1PUCCH_AN_Rep = -1;        /* INTEGER_0_2047 */
static int hf_lte_rrc_tdd_AckNackFeedbackMode = -1;  /* T_tdd_AckNackFeedbackMode */
static int hf_lte_rrc_pucch_Format_r10 = -1;      /* T_pucch_Format_r10 */
static int hf_lte_rrc_format3_r10 = -1;           /* T_format3_r10 */
static int hf_lte_rrc_n3PUCCH_AN_List_r10 = -1;   /* T_n3PUCCH_AN_List_r10 */
static int hf_lte_rrc_n3PUCCH_AN_List_r10_item = -1;  /* INTEGER_0_549 */
static int hf_lte_rrc_twoAntennaPortActivatedPUCCH_Format3_r10 = -1;  /* T_twoAntennaPortActivatedPUCCH_Format3_r10 */
static int hf_lte_rrc_setup_13 = -1;              /* T_setup_13 */
static int hf_lte_rrc_n3PUCCH_AN_ListP1_r10 = -1;  /* T_n3PUCCH_AN_ListP1_r10 */
static int hf_lte_rrc_n3PUCCH_AN_ListP1_r10_item = -1;  /* INTEGER_0_549 */
static int hf_lte_rrc_channelSelection_r10 = -1;  /* T_channelSelection_r10 */
static int hf_lte_rrc_n1PUCCH_AN_CS_r10 = -1;     /* T_n1PUCCH_AN_CS_r10 */
static int hf_lte_rrc_setup_14 = -1;              /* T_setup_14 */
static int hf_lte_rrc_n1PUCCH_AN_CS_List_r10 = -1;  /* SEQUENCE_SIZE_1_2_OF_N1PUCCH_AN_CS_r10 */
static int hf_lte_rrc_n1PUCCH_AN_CS_List_r10_item = -1;  /* N1PUCCH_AN_CS_r10 */
static int hf_lte_rrc_twoAntennaPortActivatedPUCCH_Format1a1b_r10 = -1;  /* T_twoAntennaPortActivatedPUCCH_Format1a1b_r10 */
static int hf_lte_rrc_simultaneousPUCCH_PUSCH_r10 = -1;  /* T_simultaneousPUCCH_PUSCH_r10 */
static int hf_lte_rrc_n1PUCCH_AN_RepP1_r10 = -1;  /* INTEGER_0_2047 */
static int hf_lte_rrc_N1PUCCH_AN_CS_r10_item = -1;  /* INTEGER_0_2047 */
static int hf_lte_rrc_pusch_ConfigBasic = -1;     /* T_pusch_ConfigBasic */
static int hf_lte_rrc_n_SB = -1;                  /* INTEGER_1_4 */
static int hf_lte_rrc_hoppingMode = -1;           /* T_hoppingMode */
static int hf_lte_rrc_pusch_HoppingOffset = -1;   /* INTEGER_0_98 */
static int hf_lte_rrc_enable64QAM = -1;           /* BOOLEAN */
static int hf_lte_rrc_ul_ReferenceSignalsPUSCH = -1;  /* UL_ReferenceSignalsPUSCH */
static int hf_lte_rrc_betaOffset_ACK_Index = -1;  /* INTEGER_0_15 */
static int hf_lte_rrc_betaOffset_RI_Index = -1;   /* INTEGER_0_15 */
static int hf_lte_rrc_betaOffset_CQI_Index = -1;  /* INTEGER_0_15 */
static int hf_lte_rrc_betaOffsetMC_r10 = -1;      /* T_betaOffsetMC_r10 */
static int hf_lte_rrc_betaOffset_ACK_Index_MC_r10 = -1;  /* INTEGER_0_15 */
static int hf_lte_rrc_betaOffset_RI_Index_MC_r10 = -1;  /* INTEGER_0_15 */
static int hf_lte_rrc_betaOffset_CQI_Index_MC_r10 = -1;  /* INTEGER_0_15 */
static int hf_lte_rrc_groupHoppingDisabled_r10 = -1;  /* T_groupHoppingDisabled_r10 */
static int hf_lte_rrc_dmrs_WithOCC_Activated_r10 = -1;  /* T_dmrs_WithOCC_Activated_r10 */
static int hf_lte_rrc_groupHoppingDisabled_r10_01 = -1;  /* T_groupHoppingDisabled_r10_01 */
static int hf_lte_rrc_dmrs_WithOCC_Activated_r10_01 = -1;  /* T_dmrs_WithOCC_Activated_r10_01 */
static int hf_lte_rrc_groupHoppingEnabled = -1;   /* BOOLEAN */
static int hf_lte_rrc_groupAssignmentPUSCH = -1;  /* INTEGER_0_29 */
static int hf_lte_rrc_sequenceHoppingEnabled = -1;  /* BOOLEAN */
static int hf_lte_rrc_cyclicShift = -1;           /* INTEGER_0_7 */
static int hf_lte_rrc_preambleInfo = -1;          /* T_preambleInfo */
static int hf_lte_rrc_numberOfRA_Preambles = -1;  /* T_numberOfRA_Preambles */
static int hf_lte_rrc_preamblesGroupAConfig = -1;  /* T_preamblesGroupAConfig */
static int hf_lte_rrc_sizeOfRA_PreamblesGroupA = -1;  /* T_sizeOfRA_PreamblesGroupA */
static int hf_lte_rrc_messageSizeGroupA = -1;     /* T_messageSizeGroupA */
static int hf_lte_rrc_messagePowerOffsetGroupB = -1;  /* T_messagePowerOffsetGroupB */
static int hf_lte_rrc_powerRampingParameters = -1;  /* T_powerRampingParameters */
static int hf_lte_rrc_powerRampingStep = -1;      /* T_powerRampingStep */
static int hf_lte_rrc_preambleInitialReceivedTargetPower = -1;  /* T_preambleInitialReceivedTargetPower */
static int hf_lte_rrc_ra_SupervisionInfo = -1;    /* T_ra_SupervisionInfo */
static int hf_lte_rrc_preambleTransMax = -1;      /* T_preambleTransMax */
static int hf_lte_rrc_ra_ResponseWindowSize = -1;  /* T_ra_ResponseWindowSize */
static int hf_lte_rrc_mac_ContentionResolutionTimer = -1;  /* T_mac_ContentionResolutionTimer */
static int hf_lte_rrc_maxHARQ_Msg3Tx = -1;        /* INTEGER_1_8 */
static int hf_lte_rrc_ra_PreambleIndex = -1;      /* INTEGER_0_63 */
static int hf_lte_rrc_ra_PRACH_MaskIndex = -1;    /* INTEGER_0_15 */
static int hf_lte_rrc_rach_ConfigCommon = -1;     /* RACH_ConfigCommon */
static int hf_lte_rrc_bcch_Config = -1;           /* BCCH_Config */
static int hf_lte_rrc_pcch_Config = -1;           /* PCCH_Config */
static int hf_lte_rrc_prach_Config = -1;          /* PRACH_ConfigSIB */
static int hf_lte_rrc_pdsch_ConfigCommon = -1;    /* PDSCH_ConfigCommon */
static int hf_lte_rrc_pusch_ConfigCommon = -1;    /* PUSCH_ConfigCommon */
static int hf_lte_rrc_pucch_ConfigCommon = -1;    /* PUCCH_ConfigCommon */
static int hf_lte_rrc_soundingRS_UL_ConfigCommon = -1;  /* SoundingRS_UL_ConfigCommon */
static int hf_lte_rrc_uplinkPowerControlCommon = -1;  /* UplinkPowerControlCommon */
static int hf_lte_rrc_ul_CyclicPrefixLength = -1;  /* UL_CyclicPrefixLength */
static int hf_lte_rrc_uplinkPowerControlCommon_v1020 = -1;  /* UplinkPowerControlCommon_v1020 */
static int hf_lte_rrc_prach_Config_01 = -1;       /* PRACH_Config */
static int hf_lte_rrc_antennaInfoCommon = -1;     /* AntennaInfoCommon */
static int hf_lte_rrc_nonUL_Configuration_r10_01 = -1;  /* T_nonUL_Configuration_r10_01 */
static int hf_lte_rrc_dl_Bandwidth_r10 = -1;      /* T_dl_Bandwidth_r10 */
static int hf_lte_rrc_antennaInfoCommon_r10 = -1;  /* AntennaInfoCommon */
static int hf_lte_rrc_mbsfn_SubframeConfigList_r10 = -1;  /* MBSFN_SubframeConfigList */
static int hf_lte_rrc_phich_Config_r10 = -1;      /* PHICH_Config */
static int hf_lte_rrc_pdsch_ConfigCommon_r10 = -1;  /* PDSCH_ConfigCommon */
static int hf_lte_rrc_tdd_Config_r10 = -1;        /* TDD_Config */
static int hf_lte_rrc_ul_Configuration_r10_01 = -1;  /* T_ul_Configuration_r10_01 */
static int hf_lte_rrc_ul_FreqInfo_r10 = -1;       /* T_ul_FreqInfo_r10 */
static int hf_lte_rrc_ul_CarrierFreq_r10 = -1;    /* ARFCN_ValueEUTRA */
static int hf_lte_rrc_ul_Bandwidth_r10 = -1;      /* T_ul_Bandwidth_r10 */
static int hf_lte_rrc_additionalSpectrumEmissionSCell_r10 = -1;  /* AdditionalSpectrumEmission */
static int hf_lte_rrc_p_Max_r10 = -1;             /* P_Max */
static int hf_lte_rrc_uplinkPowerControlCommonSCell_r10 = -1;  /* UplinkPowerControlCommonSCell_r10 */
static int hf_lte_rrc_soundingRS_UL_ConfigCommon_r10 = -1;  /* SoundingRS_UL_ConfigCommon */
static int hf_lte_rrc_ul_CyclicPrefixLength_r10 = -1;  /* UL_CyclicPrefixLength */
static int hf_lte_rrc_prach_ConfigSCell_r10 = -1;  /* PRACH_ConfigSCell_r10 */
static int hf_lte_rrc_pusch_ConfigCommon_r10 = -1;  /* PUSCH_ConfigCommon */
static int hf_lte_rrc_modificationPeriodCoeff = -1;  /* T_modificationPeriodCoeff */
static int hf_lte_rrc_defaultPagingCycle = -1;    /* T_defaultPagingCycle */
static int hf_lte_rrc_nB = -1;                    /* T_nB */
static int hf_lte_rrc_srb_ToAddModList = -1;      /* SRB_ToAddModList */
static int hf_lte_rrc_drb_ToAddModList = -1;      /* DRB_ToAddModList */
static int hf_lte_rrc_drb_ToReleaseList = -1;     /* DRB_ToReleaseList */
static int hf_lte_rrc_mac_MainConfig = -1;        /* T_mac_MainConfig */
static int hf_lte_rrc_explicitValue_01 = -1;      /* MAC_MainConfig */
static int hf_lte_rrc_sps_Config = -1;            /* SPS_Config */
static int hf_lte_rrc_physicalConfigDedicated = -1;  /* PhysicalConfigDedicated */
static int hf_lte_rrc_rlf_TimersAndConstants_r9 = -1;  /* RLF_TimersAndConstants_r9 */
static int hf_lte_rrc_measSubframePatternPCell_r10 = -1;  /* MeasSubframePatternPCell_r10 */
static int hf_lte_rrc_physicalConfigDedicatedSCell_r10 = -1;  /* PhysicalConfigDedicatedSCell_r10 */
static int hf_lte_rrc_SRB_ToAddModList_item = -1;  /* SRB_ToAddMod */
static int hf_lte_rrc_srb_Identity = -1;          /* INTEGER_1_2 */
static int hf_lte_rrc_rlc_Config = -1;            /* T_rlc_Config */
static int hf_lte_rrc_explicitValue_02 = -1;      /* RLC_Config */
static int hf_lte_rrc_logicalChannelConfig = -1;  /* T_logicalChannelConfig */
static int hf_lte_rrc_explicitValue_03 = -1;      /* LogicalChannelConfig */
static int hf_lte_rrc_DRB_ToAddModList_item = -1;  /* DRB_ToAddMod */
static int hf_lte_rrc_eps_BearerIdentity = -1;    /* INTEGER_0_15 */
static int hf_lte_rrc_pdcp_Config = -1;           /* PDCP_Config */
static int hf_lte_rrc_rlc_Config_01 = -1;         /* RLC_Config */
static int hf_lte_rrc_logicalChannelIdentity = -1;  /* INTEGER_3_10 */
static int hf_lte_rrc_logicalChannelConfig_01 = -1;  /* LogicalChannelConfig */
static int hf_lte_rrc_DRB_ToReleaseList_item = -1;  /* DRB_Identity */
static int hf_lte_rrc_setup_15 = -1;              /* MeasSubframePattern_r10 */
static int hf_lte_rrc_am = -1;                    /* T_am */
static int hf_lte_rrc_ul_AM_RLC = -1;             /* UL_AM_RLC */
static int hf_lte_rrc_dl_AM_RLC = -1;             /* DL_AM_RLC */
static int hf_lte_rrc_um_Bi_Directional = -1;     /* T_um_Bi_Directional */
static int hf_lte_rrc_ul_UM_RLC = -1;             /* UL_UM_RLC */
static int hf_lte_rrc_dl_UM_RLC = -1;             /* DL_UM_RLC */
static int hf_lte_rrc_um_Uni_Directional_UL = -1;  /* T_um_Uni_Directional_UL */
static int hf_lte_rrc_um_Uni_Directional_DL = -1;  /* T_um_Uni_Directional_DL */
static int hf_lte_rrc_t_PollRetransmit = -1;      /* T_PollRetransmit */
static int hf_lte_rrc_pollPDU = -1;               /* PollPDU */
static int hf_lte_rrc_pollByte = -1;              /* PollByte */
static int hf_lte_rrc_maxRetxThreshold = -1;      /* T_maxRetxThreshold */
static int hf_lte_rrc_t_Reordering = -1;          /* T_Reordering */
static int hf_lte_rrc_t_StatusProhibit = -1;      /* T_StatusProhibit */
static int hf_lte_rrc_sn_FieldLength = -1;        /* SN_FieldLength */
static int hf_lte_rrc_setup_16 = -1;              /* T_setup_15 */
static int hf_lte_rrc_t301_r9 = -1;               /* T_t301_r9 */
static int hf_lte_rrc_t310_r9 = -1;               /* T_t310_r9 */
static int hf_lte_rrc_n310_r9 = -1;               /* T_n310_r9 */
static int hf_lte_rrc_t311_r9 = -1;               /* T_t311_r9 */
static int hf_lte_rrc_n311_r9 = -1;               /* T_n311_r9 */
static int hf_lte_rrc_subframeConfigPattern_r10 = -1;  /* T_subframeConfigPattern_r10 */
static int hf_lte_rrc_subframeConfigPatternFDD_r10 = -1;  /* BIT_STRING_SIZE_8 */
static int hf_lte_rrc_subframeConfigPatternTDD_r10 = -1;  /* INTEGER_0_31 */
static int hf_lte_rrc_rpdcch_Config_r10 = -1;     /* T_rpdcch_Config_r10 */
static int hf_lte_rrc_resourceAllocationType_r10 = -1;  /* T_resourceAllocationType_r10 */
static int hf_lte_rrc_resourceBlockAssignment_r10 = -1;  /* T_resourceBlockAssignment_r10 */
static int hf_lte_rrc_type01_r10 = -1;            /* T_type01_r10 */
static int hf_lte_rrc_nrb6_r10 = -1;              /* BIT_STRING_SIZE_6 */
static int hf_lte_rrc_nrb15_r10 = -1;             /* BIT_STRING_SIZE_8 */
static int hf_lte_rrc_nrb25_r10 = -1;             /* BIT_STRING_SIZE_13 */
static int hf_lte_rrc_nrb50_r10 = -1;             /* BIT_STRING_SIZE_17 */
static int hf_lte_rrc_nrb75_r10 = -1;             /* BIT_STRING_SIZE_19 */
static int hf_lte_rrc_nrb100_r10 = -1;            /* BIT_STRING_SIZE_25 */
static int hf_lte_rrc_type2_r10 = -1;             /* T_type2_r10 */
static int hf_lte_rrc_nrb6_r10_01 = -1;           /* BIT_STRING_SIZE_5 */
static int hf_lte_rrc_nrb15_r10_01 = -1;          /* BIT_STRING_SIZE_7 */
static int hf_lte_rrc_nrb25_r10_01 = -1;          /* BIT_STRING_SIZE_9 */
static int hf_lte_rrc_nrb50_r10_01 = -1;          /* BIT_STRING_SIZE_11 */
static int hf_lte_rrc_nrb75_r10_01 = -1;          /* BIT_STRING_SIZE_12 */
static int hf_lte_rrc_nrb100_r10_01 = -1;         /* BIT_STRING_SIZE_13 */
static int hf_lte_rrc_demodulationRS_r10 = -1;    /* T_demodulationRS_r10 */
static int hf_lte_rrc_interleaving_r10 = -1;      /* T_interleaving_r10 */
static int hf_lte_rrc_noInterleaving_r10 = -1;    /* T_noInterleaving_r10 */
static int hf_lte_rrc_pdsch_Start_r10_01 = -1;    /* INTEGER_1_3 */
static int hf_lte_rrc_pucch_Config_r10 = -1;      /* T_pucch_Config_r10 */
static int hf_lte_rrc_tdd = -1;                   /* T_tdd */
static int hf_lte_rrc_channelSelectionMultiplexingBundling = -1;  /* T_channelSelectionMultiplexingBundling */
static int hf_lte_rrc_n1PUCCH_AN_List_r10 = -1;   /* T_n1PUCCH_AN_List_r10 */
static int hf_lte_rrc_n1PUCCH_AN_List_r10_item = -1;  /* INTEGER_0_2047 */
static int hf_lte_rrc_fallbackForFormat3 = -1;    /* T_fallbackForFormat3 */
static int hf_lte_rrc_n1PUCCH_AN_P0_r10 = -1;     /* INTEGER_0_2047 */
static int hf_lte_rrc_n1PUCCH_AN_P1_r10 = -1;     /* INTEGER_0_2047 */
static int hf_lte_rrc_fdd = -1;                   /* T_fdd */
static int hf_lte_rrc_setup_17 = -1;              /* T_setup_16 */
static int hf_lte_rrc_sr_PUCCH_ResourceIndex = -1;  /* INTEGER_0_2047 */
static int hf_lte_rrc_sr_ConfigIndex = -1;        /* INTEGER_0_157 */
static int hf_lte_rrc_dsr_TransMax = -1;          /* T_dsr_TransMax */
static int hf_lte_rrc_sr_PUCCH_ResourceIndexP1_r10 = -1;  /* INTEGER_0_2047 */
static int hf_lte_rrc_setup_18 = -1;              /* T_setup_17 */
static int hf_lte_rrc_srs_BandwidthConfig = -1;   /* T_srs_BandwidthConfig */
static int hf_lte_rrc_srs_SubframeConfig = -1;    /* T_srs_SubframeConfig */
static int hf_lte_rrc_ackNackSRS_SimultaneousTransmission = -1;  /* BOOLEAN */
static int hf_lte_rrc_srs_MaxUpPts = -1;          /* T_srs_MaxUpPts */
static int hf_lte_rrc_setup_19 = -1;              /* T_setup_18 */
static int hf_lte_rrc_srs_Bandwidth = -1;         /* T_srs_Bandwidth */
static int hf_lte_rrc_srs_HoppingBandwidth = -1;  /* T_srs_HoppingBandwidth */
static int hf_lte_rrc_freqDomainPosition = -1;    /* INTEGER_0_23 */
static int hf_lte_rrc_duration = -1;              /* T_duration */
static int hf_lte_rrc_srs_ConfigIndex = -1;       /* INTEGER_0_1023 */
static int hf_lte_rrc_transmissionComb = -1;      /* INTEGER_0_1 */
static int hf_lte_rrc_cyclicShift_01 = -1;        /* T_cyclicShift */
static int hf_lte_rrc_srs_AntennaPort_r10 = -1;   /* SRS_AntennaPort */
static int hf_lte_rrc_setup_20 = -1;              /* T_setup_19 */
static int hf_lte_rrc_srs_ConfigIndexAp_r10 = -1;  /* INTEGER_0_31 */
static int hf_lte_rrc_srs_ConfigApDCI_Format4_r10 = -1;  /* SEQUENCE_SIZE_1_3_OF_SRS_ConfigAp_r10 */
static int hf_lte_rrc_srs_ConfigApDCI_Format4_r10_item = -1;  /* SRS_ConfigAp_r10 */
static int hf_lte_rrc_srs_ActivateAp_r10 = -1;    /* T_srs_ActivateAp_r10 */
static int hf_lte_rrc_setup_21 = -1;              /* T_setup_20 */
static int hf_lte_rrc_srs_ConfigApDCI_Format0_r10 = -1;  /* SRS_ConfigAp_r10 */
static int hf_lte_rrc_srs_ConfigApDCI_Format1a2b2c_r10 = -1;  /* SRS_ConfigAp_r10 */
static int hf_lte_rrc_srs_AntennaPortAp_r10 = -1;  /* SRS_AntennaPort */
static int hf_lte_rrc_srs_BandwidthAp_r10 = -1;   /* T_srs_BandwidthAp_r10 */
static int hf_lte_rrc_freqDomainPositionAp_r10 = -1;  /* INTEGER_0_23 */
static int hf_lte_rrc_transmissionCombAp_r10 = -1;  /* INTEGER_0_1 */
static int hf_lte_rrc_cyclicShiftAp_r10 = -1;     /* T_cyclicShiftAp_r10 */
static int hf_lte_rrc_semiPersistSchedC_RNTI = -1;  /* C_RNTI */
static int hf_lte_rrc_sps_ConfigDL = -1;          /* SPS_ConfigDL */
static int hf_lte_rrc_sps_ConfigUL = -1;          /* SPS_ConfigUL */
static int hf_lte_rrc_setup_22 = -1;              /* T_setup_21 */
static int hf_lte_rrc_semiPersistSchedIntervalDL = -1;  /* T_semiPersistSchedIntervalDL */
static int hf_lte_rrc_numberOfConfSPS_Processes = -1;  /* INTEGER_1_8 */
static int hf_lte_rrc_n1PUCCH_AN_PersistentList = -1;  /* N1PUCCH_AN_PersistentList */
static int hf_lte_rrc_twoAntennaPortActivated_r10 = -1;  /* T_twoAntennaPortActivated_r10 */
static int hf_lte_rrc_setup_23 = -1;              /* T_setup_22 */
static int hf_lte_rrc_n1PUCCH_AN_PersistentListP1_r10 = -1;  /* N1PUCCH_AN_PersistentList */
static int hf_lte_rrc_setup_24 = -1;              /* T_setup_23 */
static int hf_lte_rrc_semiPersistSchedIntervalUL = -1;  /* T_semiPersistSchedIntervalUL */
static int hf_lte_rrc_implicitReleaseAfter = -1;  /* T_implicitReleaseAfter */
static int hf_lte_rrc_p0_Persistent = -1;         /* T_p0_Persistent */
static int hf_lte_rrc_p0_NominalPUSCH_Persistent = -1;  /* T_p0_NominalPUSCH_Persistent */
static int hf_lte_rrc_p0_UE_PUSCH_Persistent = -1;  /* T_p0_UE_PUSCH_Persistent */
static int hf_lte_rrc_twoIntervalsConfig = -1;    /* T_twoIntervalsConfig */
static int hf_lte_rrc_N1PUCCH_AN_PersistentList_item = -1;  /* INTEGER_0_2047 */
static int hf_lte_rrc_subframeAssignment = -1;    /* T_subframeAssignment */
static int hf_lte_rrc_specialSubframePatterns = -1;  /* T_specialSubframePatterns */
static int hf_lte_rrc_setup_25 = -1;              /* T_setup_24 */
static int hf_lte_rrc_tpc_RNTI = -1;              /* BIT_STRING_SIZE_16 */
static int hf_lte_rrc_tpc_Index = -1;             /* TPC_Index */
static int hf_lte_rrc_indexOfFormat3 = -1;        /* INTEGER_1_15 */
static int hf_lte_rrc_indexOfFormat3A = -1;       /* INTEGER_1_31 */
static int hf_lte_rrc_p0_NominalPUSCH = -1;       /* T_p0_NominalPUSCH */
static int hf_lte_rrc_alpha = -1;                 /* T_alpha */
static int hf_lte_rrc_p0_NominalPUCCH = -1;       /* T_p0_NominalPUCCH */
static int hf_lte_rrc_deltaFList_PUCCH = -1;      /* DeltaFList_PUCCH */
static int hf_lte_rrc_deltaPreambleMsg3 = -1;     /* INTEGER_M1_6 */
static int hf_lte_rrc_deltaF_PUCCH_Format3_r10 = -1;  /* T_deltaF_PUCCH_Format3_r10 */
static int hf_lte_rrc_deltaF_PUCCH_Format1bCS_r10 = -1;  /* T_deltaF_PUCCH_Format1bCS_r10 */
static int hf_lte_rrc_p0_NominalPUSCH_r10 = -1;   /* T_p0_NominalPUSCH_r10 */
static int hf_lte_rrc_alpha_r10 = -1;             /* T_alpha_r10 */
static int hf_lte_rrc_p0_UE_PUSCH = -1;           /* T_p0_UE_PUSCH */
static int hf_lte_rrc_deltaMCS_Enabled = -1;      /* T_deltaMCS_Enabled */
static int hf_lte_rrc_accumulationEnabled = -1;   /* BOOLEAN */
static int hf_lte_rrc_p0_UE_PUCCH = -1;           /* T_p0_UE_PUCCH */
static int hf_lte_rrc_pSRS_Offset = -1;           /* INTEGER_0_15 */
static int hf_lte_rrc_filterCoefficient = -1;     /* FilterCoefficient */
static int hf_lte_rrc_deltaTxD_OffsetListPUCCH_r10 = -1;  /* DeltaTxD_OffsetListPUCCH_r10 */
static int hf_lte_rrc_pSRS_OffsetAp_r10 = -1;     /* INTEGER_0_15 */
static int hf_lte_rrc_p0_UE_PUSCH_r10 = -1;       /* T_p0_UE_PUSCH_r10 */
static int hf_lte_rrc_deltaMCS_Enabled_r10 = -1;  /* T_deltaMCS_Enabled_r10 */
static int hf_lte_rrc_accumulationEnabled_r10 = -1;  /* BOOLEAN */
static int hf_lte_rrc_pSRS_Offset_r10 = -1;       /* INTEGER_0_15 */
static int hf_lte_rrc_filterCoefficient_r10 = -1;  /* FilterCoefficient */
static int hf_lte_rrc_pathlossReferenceLinking_r10 = -1;  /* T_pathlossReferenceLinking_r10 */
static int hf_lte_rrc_deltaF_PUCCH_Format1 = -1;  /* T_deltaF_PUCCH_Format1 */
static int hf_lte_rrc_deltaF_PUCCH_Format1b = -1;  /* T_deltaF_PUCCH_Format1b */
static int hf_lte_rrc_deltaF_PUCCH_Format2 = -1;  /* T_deltaF_PUCCH_Format2 */
static int hf_lte_rrc_deltaF_PUCCH_Format2a = -1;  /* T_deltaF_PUCCH_Format2a */
static int hf_lte_rrc_deltaF_PUCCH_Format2b = -1;  /* T_deltaF_PUCCH_Format2b */
static int hf_lte_rrc_deltaTxD_OffsetPUCCH_Format1_r10 = -1;  /* T_deltaTxD_OffsetPUCCH_Format1_r10 */
static int hf_lte_rrc_deltaTxD_OffsetPUCCH_Format1a1b_r10 = -1;  /* T_deltaTxD_OffsetPUCCH_Format1a1b_r10 */
static int hf_lte_rrc_deltaTxD_OffsetPUCCH_Format22a2b_r10 = -1;  /* T_deltaTxD_OffsetPUCCH_Format22a2b_r10 */
static int hf_lte_rrc_deltaTxD_OffsetPUCCH_Format3_r10 = -1;  /* T_deltaTxD_OffsetPUCCH_Format3_r10 */
static int hf_lte_rrc_cipheringAlgorithm = -1;    /* T_cipheringAlgorithm */
static int hf_lte_rrc_integrityProtAlgorithm = -1;  /* T_integrityProtAlgorithm */
static int hf_lte_rrc_arfcn_01 = -1;              /* ARFCN_ValueGERAN */
static int hf_lte_rrc_startingARFCN = -1;         /* ARFCN_ValueGERAN */
static int hf_lte_rrc_followingARFCNs = -1;       /* T_followingARFCNs */
static int hf_lte_rrc_explicitListOfARFCNs = -1;  /* ExplicitListOfARFCNs */
static int hf_lte_rrc_equallySpacedARFCNs = -1;   /* T_equallySpacedARFCNs */
static int hf_lte_rrc_arfcn_Spacing = -1;         /* INTEGER_1_8 */
static int hf_lte_rrc_numberOfFollowingARFCNs = -1;  /* INTEGER_0_31 */
static int hf_lte_rrc_variableBitMapOfARFCNs = -1;  /* OCTET_STRING_SIZE_1_16 */
static int hf_lte_rrc_ExplicitListOfARFCNs_item = -1;  /* ARFCN_ValueGERAN */
static int hf_lte_rrc_CellIndexList_item = -1;    /* CellIndex */
static int hf_lte_rrc_sid = -1;                   /* BIT_STRING_SIZE_15 */
static int hf_lte_rrc_nid = -1;                   /* BIT_STRING_SIZE_16 */
static int hf_lte_rrc_multipleSID = -1;           /* BOOLEAN */
static int hf_lte_rrc_multipleNID = -1;           /* BOOLEAN */
static int hf_lte_rrc_homeReg = -1;               /* BOOLEAN */
static int hf_lte_rrc_foreignSIDReg = -1;         /* BOOLEAN */
static int hf_lte_rrc_foreignNIDReg = -1;         /* BOOLEAN */
static int hf_lte_rrc_parameterReg = -1;          /* BOOLEAN */
static int hf_lte_rrc_powerUpReg = -1;            /* BOOLEAN */
static int hf_lte_rrc_registrationPeriod = -1;    /* BIT_STRING_SIZE_7 */
static int hf_lte_rrc_registrationZone = -1;      /* BIT_STRING_SIZE_12 */
static int hf_lte_rrc_totalZone = -1;             /* BIT_STRING_SIZE_3 */
static int hf_lte_rrc_zoneTimer = -1;             /* BIT_STRING_SIZE_3 */
static int hf_lte_rrc_powerDownReg_r9 = -1;       /* T_powerDownReg_r9 */
static int hf_lte_rrc_cellIdentity_01 = -1;       /* BIT_STRING_SIZE_28 */
static int hf_lte_rrc_locationAreaCode = -1;      /* BIT_STRING_SIZE_16 */
static int hf_lte_rrc_cellIdentity_02 = -1;       /* BIT_STRING_SIZE_16 */
static int hf_lte_rrc_cellGlobalId1XRTT = -1;     /* BIT_STRING_SIZE_47 */
static int hf_lte_rrc_cellGlobalIdHRPD = -1;      /* BIT_STRING_SIZE_128 */
static int hf_lte_rrc_targetPhysCellId = -1;      /* PhysCellId */
static int hf_lte_rrc_carrierFreq_03 = -1;        /* CarrierFreqEUTRA */
static int hf_lte_rrc_carrierBandwidth = -1;      /* CarrierBandwidthEUTRA */
static int hf_lte_rrc_t304_01 = -1;               /* T_t304_01 */
static int hf_lte_rrc_newUE_Identity = -1;        /* C_RNTI */
static int hf_lte_rrc_radioResourceConfigCommon_01 = -1;  /* RadioResourceConfigCommon */
static int hf_lte_rrc_rach_ConfigDedicated = -1;  /* RACH_ConfigDedicated */
static int hf_lte_rrc_dl_Bandwidth_01 = -1;       /* T_dl_Bandwidth_01 */
static int hf_lte_rrc_ul_Bandwidth_01 = -1;       /* T_ul_Bandwidth_01 */
static int hf_lte_rrc_t_Evaluation = -1;          /* T_t_Evaluation */
static int hf_lte_rrc_t_HystNormal = -1;          /* T_t_HystNormal */
static int hf_lte_rrc_n_CellChangeMedium = -1;    /* INTEGER_1_16 */
static int hf_lte_rrc_n_CellChangeHigh = -1;      /* INTEGER_1_16 */
static int hf_lte_rrc_start_01 = -1;              /* PhysCellId */
static int hf_lte_rrc_range = -1;                 /* T_range */
static int hf_lte_rrc_PhysCellIdRangeUTRA_FDDList_r9_item = -1;  /* PhysCellIdRangeUTRA_FDD_r9 */
static int hf_lte_rrc_start_r9 = -1;              /* PhysCellIdUTRA_FDD */
static int hf_lte_rrc_range_r9 = -1;              /* INTEGER_2_512 */
static int hf_lte_rrc_networkColourCode = -1;     /* BIT_STRING_SIZE_3 */
static int hf_lte_rrc_baseStationColourCode = -1;  /* BIT_STRING_SIZE_3 */
static int hf_lte_rrc_mcc = -1;                   /* MCC */
static int hf_lte_rrc_mnc = -1;                   /* MNC */
static int hf_lte_rrc_MCC_item = -1;              /* MCC_MNC_Digit */
static int hf_lte_rrc_MNC_item = -1;              /* MCC_MNC_Digit */
static int hf_lte_rrc_preRegistrationAllowed = -1;  /* BOOLEAN */
static int hf_lte_rrc_preRegistrationZoneId = -1;  /* PreRegistrationZoneIdHRPD */
static int hf_lte_rrc_secondaryPreRegistrationZoneIdList = -1;  /* SecondaryPreRegistrationZoneIdListHRPD */
static int hf_lte_rrc_SecondaryPreRegistrationZoneIdListHRPD_item = -1;  /* PreRegistrationZoneIdHRPD */
static int hf_lte_rrc_sf_Medium_01 = -1;          /* T_sf_Medium_01 */
static int hf_lte_rrc_sf_High_01 = -1;            /* T_sf_High_01 */
static int hf_lte_rrc_SystemInfoListGERAN_item = -1;  /* SystemInfoListGERAN_item */
static int hf_lte_rrc_cdma_EUTRA_Synchronisation = -1;  /* BOOLEAN */
static int hf_lte_rrc_cdma_SystemTime = -1;       /* T_cdma_SystemTime */
static int hf_lte_rrc_synchronousSystemTime = -1;  /* BIT_STRING_SIZE_39 */
static int hf_lte_rrc_asynchronousSystemTime = -1;  /* BIT_STRING_SIZE_49 */
static int hf_lte_rrc_locationCoordinates_r10 = -1;  /* T_locationCoordinates_r10 */
static int hf_lte_rrc_ellipsoid_Point_r10 = -1;   /* T_ellipsoid_Point_r10 */
static int hf_lte_rrc_ellipsoidPointWithAltitude_r10 = -1;  /* T_ellipsoidPointWithAltitude_r10 */
static int hf_lte_rrc_horizontalVelocity_r10 = -1;  /* T_horizontalVelocity_r10 */
static int hf_lte_rrc_gnss_TOD_msec_r10 = -1;     /* T_gnss_TOD_msec_r10 */
static int hf_lte_rrc_measObjectToRemoveList = -1;  /* MeasObjectToRemoveList */
static int hf_lte_rrc_measObjectToAddModList = -1;  /* MeasObjectToAddModList */
static int hf_lte_rrc_reportConfigToRemoveList = -1;  /* ReportConfigToRemoveList */
static int hf_lte_rrc_reportConfigToAddModList = -1;  /* ReportConfigToAddModList */
static int hf_lte_rrc_measIdToRemoveList = -1;    /* MeasIdToRemoveList */
static int hf_lte_rrc_measIdToAddModList = -1;    /* MeasIdToAddModList */
static int hf_lte_rrc_quantityConfig = -1;        /* QuantityConfig */
static int hf_lte_rrc_measGapConfig = -1;         /* MeasGapConfig */
static int hf_lte_rrc_s_Measure = -1;             /* S_Measure */
static int hf_lte_rrc_speedStatePars = -1;        /* T_speedStatePars */
static int hf_lte_rrc_setup_26 = -1;              /* T_setup_25 */
static int hf_lte_rrc_timeToTrigger_SF = -1;      /* SpeedStateScaleFactors */
static int hf_lte_rrc_MeasIdToRemoveList_item = -1;  /* MeasId */
static int hf_lte_rrc_MeasObjectToRemoveList_item = -1;  /* MeasObjectId */
static int hf_lte_rrc_ReportConfigToRemoveList_item = -1;  /* ReportConfigId */
static int hf_lte_rrc_setup_27 = -1;              /* T_setup_26 */
static int hf_lte_rrc_gapOffset = -1;             /* T_gapOffset */
static int hf_lte_rrc_gp0 = -1;                   /* INTEGER_0_39 */
static int hf_lte_rrc_gp1 = -1;                   /* INTEGER_0_79 */
static int hf_lte_rrc_MeasIdToAddModList_item = -1;  /* MeasIdToAddMod */
static int hf_lte_rrc_measId = -1;                /* MeasId */
static int hf_lte_rrc_measObjectId = -1;          /* MeasObjectId */
static int hf_lte_rrc_reportConfigId = -1;        /* ReportConfigId */
static int hf_lte_rrc_carrierFreq_04 = -1;        /* CarrierFreqCDMA2000 */
static int hf_lte_rrc_offsetFreq = -1;            /* Q_OffsetRangeInterRAT */
static int hf_lte_rrc_cellsToRemoveList = -1;     /* CellIndexList */
static int hf_lte_rrc_cellsToAddModList = -1;     /* CellsToAddModListCDMA2000 */
static int hf_lte_rrc_cellForWhichToReportCGI = -1;  /* PhysCellIdCDMA2000 */
static int hf_lte_rrc_CellsToAddModListCDMA2000_item = -1;  /* CellsToAddModCDMA2000 */
static int hf_lte_rrc_cellIndex = -1;             /* INTEGER_1_maxCellMeas */
static int hf_lte_rrc_physCellId_02 = -1;         /* PhysCellIdCDMA2000 */
static int hf_lte_rrc_offsetFreq_01 = -1;         /* Q_OffsetRange */
static int hf_lte_rrc_cellsToAddModList_01 = -1;  /* CellsToAddModList */
static int hf_lte_rrc_blackCellsToRemoveList = -1;  /* CellIndexList */
static int hf_lte_rrc_blackCellsToAddModList = -1;  /* BlackCellsToAddModList */
static int hf_lte_rrc_cellForWhichToReportCGI_01 = -1;  /* PhysCellId */
static int hf_lte_rrc_measCycleSCell_r10 = -1;    /* MeasCycleSCell_r10 */
static int hf_lte_rrc_measSubframePatternConfigNeigh_r10 = -1;  /* MeasSubframePatternConfigNeigh_r10 */
static int hf_lte_rrc_CellsToAddModList_item = -1;  /* CellsToAddMod */
static int hf_lte_rrc_cellIndividualOffset = -1;  /* Q_OffsetRange */
static int hf_lte_rrc_BlackCellsToAddModList_item = -1;  /* BlackCellsToAddMod */
static int hf_lte_rrc_physCellIdRange = -1;       /* PhysCellIdRange */
static int hf_lte_rrc_setup_28 = -1;              /* T_setup_27 */
static int hf_lte_rrc_measSubframePatternNeigh_r10 = -1;  /* MeasSubframePattern_r10 */
static int hf_lte_rrc_measSubframeCellList_r10 = -1;  /* MeasSubframeCellList_r10 */
static int hf_lte_rrc_MeasSubframeCellList_r10_item = -1;  /* PhysCellIdRange */
static int hf_lte_rrc_cellForWhichToReportCGI_02 = -1;  /* PhysCellIdGERAN */
static int hf_lte_rrc_MeasObjectToAddModList_item = -1;  /* MeasObjectToAddMod */
static int hf_lte_rrc_measObject = -1;            /* T_measObject */
static int hf_lte_rrc_measObjectEUTRA = -1;       /* MeasObjectEUTRA */
static int hf_lte_rrc_measObjectUTRA = -1;        /* MeasObjectUTRA */
static int hf_lte_rrc_measObjectGERAN = -1;       /* MeasObjectGERAN */
static int hf_lte_rrc_measObjectCDMA2000 = -1;    /* MeasObjectCDMA2000 */
static int hf_lte_rrc_cellsToAddModList_02 = -1;  /* T_cellsToAddModList */
static int hf_lte_rrc_cellsToAddModListUTRA_FDD = -1;  /* CellsToAddModListUTRA_FDD */
static int hf_lte_rrc_cellsToAddModListUTRA_TDD = -1;  /* CellsToAddModListUTRA_TDD */
static int hf_lte_rrc_cellForWhichToReportCGI_03 = -1;  /* T_cellForWhichToReportCGI */
static int hf_lte_rrc_utra_FDD_01 = -1;           /* PhysCellIdUTRA_FDD */
static int hf_lte_rrc_utra_TDD_01 = -1;           /* PhysCellIdUTRA_TDD */
static int hf_lte_rrc_csg_allowedReportingCells_v930 = -1;  /* CSG_AllowedReportingCells_r9 */
static int hf_lte_rrc_CellsToAddModListUTRA_FDD_item = -1;  /* CellsToAddModUTRA_FDD */
static int hf_lte_rrc_physCellId_03 = -1;         /* PhysCellIdUTRA_FDD */
static int hf_lte_rrc_CellsToAddModListUTRA_TDD_item = -1;  /* CellsToAddModUTRA_TDD */
static int hf_lte_rrc_physCellId_04 = -1;         /* PhysCellIdUTRA_TDD */
static int hf_lte_rrc_physCellIdRangeUTRA_FDDList_r9 = -1;  /* PhysCellIdRangeUTRA_FDDList_r9 */
static int hf_lte_rrc_measResultPCell = -1;       /* T_measResultPCell */
static int hf_lte_rrc_rsrpResult = -1;            /* RSRP_Range */
static int hf_lte_rrc_rsrqResult = -1;            /* RSRQ_Range */
static int hf_lte_rrc_measResultNeighCells = -1;  /* T_measResultNeighCells */
static int hf_lte_rrc_measResultListEUTRA = -1;   /* MeasResultListEUTRA */
static int hf_lte_rrc_measResultListUTRA = -1;    /* MeasResultListUTRA */
static int hf_lte_rrc_measResultListGERAN = -1;   /* MeasResultListGERAN */
static int hf_lte_rrc_measResultsCDMA2000 = -1;   /* MeasResultsCDMA2000 */
static int hf_lte_rrc_measResultForECID_r9 = -1;  /* MeasResultForECID_r9 */
static int hf_lte_rrc_measResultServFreqList_r10 = -1;  /* MeasResultServFreqList_r10 */
static int hf_lte_rrc_MeasResultListEUTRA_item = -1;  /* MeasResultEUTRA */
static int hf_lte_rrc_cgi_Info = -1;              /* T_cgi_Info */
static int hf_lte_rrc_cellGlobalId = -1;          /* CellGlobalIdEUTRA */
static int hf_lte_rrc_plmn_IdentityList_01 = -1;  /* PLMN_IdentityList2 */
static int hf_lte_rrc_measResult = -1;            /* T_measResult */
static int hf_lte_rrc_additionalSI_Info_r9 = -1;  /* AdditionalSI_Info_r9 */
static int hf_lte_rrc_MeasResultServFreqList_r10_item = -1;  /* MeasResultServFreq_r10 */
static int hf_lte_rrc_servFreqId_r10 = -1;        /* ServCellIndex_r10 */
static int hf_lte_rrc_measResultSCell_r10 = -1;   /* T_measResultSCell_r10 */
static int hf_lte_rrc_rsrpResultSCell_r10 = -1;   /* RSRP_Range */
static int hf_lte_rrc_rsrqResultSCell_r10 = -1;   /* RSRQ_Range */
static int hf_lte_rrc_measResultBestNeighCell_r10 = -1;  /* T_measResultBestNeighCell_r10 */
static int hf_lte_rrc_rsrpResultNCell_r10 = -1;   /* RSRP_Range */
static int hf_lte_rrc_rsrqResultNCell_r10 = -1;   /* RSRQ_Range */
static int hf_lte_rrc_MeasResultListUTRA_item = -1;  /* MeasResultUTRA */
static int hf_lte_rrc_physCellId_05 = -1;         /* T_physCellId */
static int hf_lte_rrc_fdd_01 = -1;                /* PhysCellIdUTRA_FDD */
static int hf_lte_rrc_tdd_01 = -1;                /* PhysCellIdUTRA_TDD */
static int hf_lte_rrc_cgi_Info_01 = -1;           /* T_cgi_Info_01 */
static int hf_lte_rrc_cellGlobalId_01 = -1;       /* CellGlobalIdUTRA */
static int hf_lte_rrc_routingAreaCode = -1;       /* BIT_STRING_SIZE_8 */
static int hf_lte_rrc_measResult_01 = -1;         /* T_measResult_01 */
static int hf_lte_rrc_utra_RSCP = -1;             /* INTEGER_M5_91 */
static int hf_lte_rrc_utra_EcN0 = -1;             /* INTEGER_0_49 */
static int hf_lte_rrc_MeasResultListGERAN_item = -1;  /* MeasResultGERAN */
static int hf_lte_rrc_cgi_Info_02 = -1;           /* T_cgi_Info_02 */
static int hf_lte_rrc_cellGlobalId_02 = -1;       /* CellGlobalIdGERAN */
static int hf_lte_rrc_measResult_02 = -1;         /* T_measResult_02 */
static int hf_lte_rrc_rssi = -1;                  /* INTEGER_0_63 */
static int hf_lte_rrc_preRegistrationStatusHRPD = -1;  /* BOOLEAN */
static int hf_lte_rrc_measResultListCDMA2000 = -1;  /* MeasResultListCDMA2000 */
static int hf_lte_rrc_MeasResultListCDMA2000_item = -1;  /* MeasResultCDMA2000 */
static int hf_lte_rrc_cgi_Info_03 = -1;           /* CellGlobalIdCDMA2000 */
static int hf_lte_rrc_measResult_03 = -1;         /* T_measResult_03 */
static int hf_lte_rrc_pilotPnPhase = -1;          /* INTEGER_0_32767 */
static int hf_lte_rrc_pilotStrength = -1;         /* INTEGER_0_63 */
static int hf_lte_rrc_ue_RxTxTimeDiffResult_r9 = -1;  /* INTEGER_0_4095 */
static int hf_lte_rrc_currentSFN_r9 = -1;         /* BIT_STRING_SIZE_10 */
static int hf_lte_rrc_PLMN_IdentityList2_item = -1;  /* PLMN_Identity */
static int hf_lte_rrc_csg_MemberStatus_r9 = -1;   /* T_csg_MemberStatus_r9 */
static int hf_lte_rrc_csg_Identity_r9 = -1;       /* CSG_Identity */
static int hf_lte_rrc_quantityConfigEUTRA = -1;   /* QuantityConfigEUTRA */
static int hf_lte_rrc_quantityConfigUTRA = -1;    /* QuantityConfigUTRA */
static int hf_lte_rrc_quantityConfigGERAN = -1;   /* QuantityConfigGERAN */
static int hf_lte_rrc_quantityConfigCDMA2000 = -1;  /* QuantityConfigCDMA2000 */
static int hf_lte_rrc_quantityConfigUTRA_v1020 = -1;  /* QuantityConfigUTRA_v1020 */
static int hf_lte_rrc_filterCoefficientRSRP = -1;  /* FilterCoefficient */
static int hf_lte_rrc_filterCoefficientRSRQ = -1;  /* FilterCoefficient */
static int hf_lte_rrc_measQuantityUTRA_FDD = -1;  /* T_measQuantityUTRA_FDD */
static int hf_lte_rrc_measQuantityUTRA_TDD = -1;  /* T_measQuantityUTRA_TDD */
static int hf_lte_rrc_filterCoefficient2_FDD_r10 = -1;  /* FilterCoefficient */
static int hf_lte_rrc_measQuantityGERAN = -1;     /* T_measQuantityGERAN */
static int hf_lte_rrc_measQuantityCDMA2000 = -1;  /* T_measQuantityCDMA2000 */
static int hf_lte_rrc_triggerType = -1;           /* T_triggerType */
static int hf_lte_rrc_event = -1;                 /* T_event */
static int hf_lte_rrc_eventId = -1;               /* T_eventId */
static int hf_lte_rrc_eventA1 = -1;               /* T_eventA1 */
static int hf_lte_rrc_a1_Threshold = -1;          /* ThresholdEUTRA */
static int hf_lte_rrc_eventA2 = -1;               /* T_eventA2 */
static int hf_lte_rrc_a2_Threshold = -1;          /* ThresholdEUTRA */
static int hf_lte_rrc_eventA3 = -1;               /* T_eventA3 */
static int hf_lte_rrc_a3_Offset = -1;             /* INTEGER_M30_30 */
static int hf_lte_rrc_reportOnLeave = -1;         /* BOOLEAN */
static int hf_lte_rrc_eventA4 = -1;               /* T_eventA4 */
static int hf_lte_rrc_a4_Threshold = -1;          /* ThresholdEUTRA */
static int hf_lte_rrc_eventA5 = -1;               /* T_eventA5 */
static int hf_lte_rrc_a5_Threshold1 = -1;         /* ThresholdEUTRA */
static int hf_lte_rrc_a5_Threshold2 = -1;         /* ThresholdEUTRA */
static int hf_lte_rrc_eventA6_r10 = -1;           /* T_eventA6_r10 */
static int hf_lte_rrc_a6_Offset_r10 = -1;         /* INTEGER_M30_30 */
static int hf_lte_rrc_a6_ReportOnLeave_r10 = -1;  /* BOOLEAN */
static int hf_lte_rrc_hysteresis = -1;            /* Hysteresis */
static int hf_lte_rrc_timeToTrigger = -1;         /* TimeToTrigger */
static int hf_lte_rrc_periodical = -1;            /* T_periodical */
static int hf_lte_rrc_purpose_02 = -1;            /* T_purpose_02 */
static int hf_lte_rrc_triggerQuantity = -1;       /* T_triggerQuantity */
static int hf_lte_rrc_reportQuantity = -1;        /* T_reportQuantity */
static int hf_lte_rrc_maxReportCells = -1;        /* INTEGER_1_maxCellReport */
static int hf_lte_rrc_reportInterval = -1;        /* ReportInterval */
static int hf_lte_rrc_reportAmount = -1;          /* T_reportAmount */
static int hf_lte_rrc_si_RequestForHO_r9 = -1;    /* T_si_RequestForHO_r9 */
static int hf_lte_rrc_ue_RxTxTimeDiffPeriodical_r9 = -1;  /* T_ue_RxTxTimeDiffPeriodical_r9 */
static int hf_lte_rrc_includeLocationInfo_r10 = -1;  /* T_includeLocationInfo_r10 */
static int hf_lte_rrc_reportAddNeighMeas_r10 = -1;  /* T_reportAddNeighMeas_r10 */
static int hf_lte_rrc_threshold_RSRP = -1;        /* Threshold_RSRP_Range */
static int hf_lte_rrc_threshold_RSRQ = -1;        /* Threshold_RSRQ_Range */
static int hf_lte_rrc_triggerType_01 = -1;        /* T_triggerType_01 */
static int hf_lte_rrc_event_01 = -1;              /* T_event_01 */
static int hf_lte_rrc_eventId_01 = -1;            /* T_eventId_01 */
static int hf_lte_rrc_eventB1 = -1;               /* T_eventB1 */
static int hf_lte_rrc_b1_Threshold = -1;          /* T_b1_Threshold */
static int hf_lte_rrc_b1_ThresholdUTRA = -1;      /* ThresholdUTRA */
static int hf_lte_rrc_b1_ThresholdGERAN = -1;     /* ThresholdGERAN */
static int hf_lte_rrc_b1_ThresholdCDMA2000 = -1;  /* ThresholdCDMA2000 */
static int hf_lte_rrc_eventB2 = -1;               /* T_eventB2 */
static int hf_lte_rrc_b2_Threshold1 = -1;         /* ThresholdEUTRA */
static int hf_lte_rrc_b2_Threshold2 = -1;         /* T_b2_Threshold2 */
static int hf_lte_rrc_b2_Threshold2UTRA = -1;     /* ThresholdUTRA */
static int hf_lte_rrc_b2_Threshold2GERAN = -1;    /* ThresholdGERAN */
static int hf_lte_rrc_b2_Threshold2CDMA2000 = -1;  /* ThresholdCDMA2000 */
static int hf_lte_rrc_periodical_01 = -1;         /* T_periodical_01 */
static int hf_lte_rrc_purpose_03 = -1;            /* T_purpose_03 */
static int hf_lte_rrc_reportAmount_01 = -1;       /* T_reportAmount_01 */
static int hf_lte_rrc_si_RequestForHO_r9_01 = -1;  /* T_si_RequestForHO_r9_01 */
static int hf_lte_rrc_reportQuantityUTRA_FDD_r10 = -1;  /* T_reportQuantityUTRA_FDD_r10 */
static int hf_lte_rrc_utra_RSCP_01 = -1;          /* Threshold_utra_RSRP */
static int hf_lte_rrc_utra_EcN0_01 = -1;          /* Threshold_utra_EcN0 */
static int hf_lte_rrc_ReportConfigToAddModList_item = -1;  /* ReportConfigToAddMod */
static int hf_lte_rrc_reportConfig = -1;          /* T_reportConfig */
static int hf_lte_rrc_reportConfigEUTRA = -1;     /* ReportConfigEUTRA */
static int hf_lte_rrc_reportConfigInterRAT = -1;  /* ReportConfigInterRAT */
static int hf_lte_rrc_cellGlobalIdList_r10 = -1;  /* CellGlobalIdList_r10 */
static int hf_lte_rrc_trackingAreaCodeList_r10 = -1;  /* TrackingAreaCodeList_r10 */
static int hf_lte_rrc_CellGlobalIdList_r10_item = -1;  /* CellGlobalIdEUTRA */
static int hf_lte_rrc_TrackingAreaCodeList_r10_item = -1;  /* TrackingAreaCode */
static int hf_lte_rrc_subframePatternFDD_r10 = -1;  /* BIT_STRING_SIZE_40 */
static int hf_lte_rrc_subframePatternTDD_r10 = -1;  /* T_subframePatternTDD_r10 */
static int hf_lte_rrc_subframeConfig1_5_r10 = -1;  /* BIT_STRING_SIZE_20 */
static int hf_lte_rrc_subframeConfig0_r10 = -1;   /* BIT_STRING_SIZE_70 */
static int hf_lte_rrc_subframeConfig6_r10 = -1;   /* BIT_STRING_SIZE_60 */
static int hf_lte_rrc_reportProximityConfig_r9 = -1;  /* ReportProximityConfig_r9 */
static int hf_lte_rrc_proximityIndicationEUTRA_r9 = -1;  /* T_proximityIndicationEUTRA_r9 */
static int hf_lte_rrc_proximityIndicationUTRA_r9 = -1;  /* T_proximityIndicationUTRA_r9 */
static int hf_lte_rrc_m_TMSI = -1;                /* BIT_STRING_SIZE_32 */
static int hf_lte_rrc_plmn_Identity_r10 = -1;     /* PLMN_Identity */
static int hf_lte_rrc_traceId_r10 = -1;           /* OCTET_STRING_SIZE_3 */
static int hf_lte_rrc_UE_CapabilityRAT_ContainerList_item = -1;  /* UE_CapabilityRAT_Container */
static int hf_lte_rrc_rat_Type = -1;              /* RAT_Type */
static int hf_lte_rrc_ueCapabilityRAT_Container = -1;  /* T_ueCapabilityRAT_Container */
static int hf_lte_rrc_accessStratumRelease = -1;  /* AccessStratumRelease */
static int hf_lte_rrc_ue_Category = -1;           /* INTEGER_1_5 */
static int hf_lte_rrc_pdcp_Parameters = -1;       /* PDCP_Parameters */
static int hf_lte_rrc_phyLayerParameters = -1;    /* PhyLayerParameters */
static int hf_lte_rrc_rf_Parameters = -1;         /* RF_Parameters */
static int hf_lte_rrc_measParameters = -1;        /* MeasParameters */
static int hf_lte_rrc_featureGroupIndicators = -1;  /* T_featureGroupIndicators */
static int hf_lte_rrc_interRAT_Parameters = -1;   /* T_interRAT_Parameters */
static int hf_lte_rrc_utraFDD = -1;               /* IRAT_ParametersUTRA_FDD */
static int hf_lte_rrc_utraTDD128 = -1;            /* IRAT_ParametersUTRA_TDD128 */
static int hf_lte_rrc_utraTDD384 = -1;            /* IRAT_ParametersUTRA_TDD384 */
static int hf_lte_rrc_utraTDD768 = -1;            /* IRAT_ParametersUTRA_TDD768 */
static int hf_lte_rrc_geran_02 = -1;              /* IRAT_ParametersGERAN */
static int hf_lte_rrc_cdma2000_HRPD_01 = -1;      /* IRAT_ParametersCDMA2000_HRPD */
static int hf_lte_rrc_cdma2000_1xRTT_01 = -1;     /* IRAT_ParametersCDMA2000_1XRTT */
static int hf_lte_rrc_nonCriticalExtension_87 = -1;  /* UE_EUTRA_Capability_v920_IEs */
static int hf_lte_rrc_phyLayerParameters_v920 = -1;  /* PhyLayerParameters_v920 */
static int hf_lte_rrc_interRAT_ParametersGERAN_v920 = -1;  /* IRAT_ParametersGERAN_v920 */
static int hf_lte_rrc_interRAT_ParametersUTRA_v920 = -1;  /* IRAT_ParametersUTRA_v920 */
static int hf_lte_rrc_interRAT_ParametersCDMA2000_v920 = -1;  /* IRAT_ParametersCDMA2000_1XRTT_v920 */
static int hf_lte_rrc_deviceType_r9 = -1;         /* T_deviceType_r9 */
static int hf_lte_rrc_csg_ProximityIndicationParameters_r9 = -1;  /* CSG_ProximityIndicationParameters_r9 */
static int hf_lte_rrc_neighCellSI_AcquisitionParameters_r9 = -1;  /* NeighCellSI_AcquisitionParameters_r9 */
static int hf_lte_rrc_son_Parameters_r9 = -1;     /* SON_Parameters_r9 */
static int hf_lte_rrc_nonCriticalExtension_88 = -1;  /* UE_EUTRA_Capability_v940_IEs */
static int hf_lte_rrc_lateNonCriticalExtension_01 = -1;  /* T_lateNonCriticalExtension */
static int hf_lte_rrc_nonCriticalExtension_89 = -1;  /* UE_EUTRA_Capability_v1020_IEs */
static int hf_lte_rrc_featureGroupIndRel9Add_r9 = -1;  /* T_featureGroupIndRel9Add_r9 */
static int hf_lte_rrc_fdd_Add_UE_EUTRA_Capabilities_r9 = -1;  /* UE_EUTRA_CapabilityAddXDD_Mode_r9 */
static int hf_lte_rrc_tdd_Add_UE_EUTRA_Capabilities_r9 = -1;  /* UE_EUTRA_CapabilityAddXDD_Mode_r9 */
static int hf_lte_rrc_nonCriticalExtension_90 = -1;  /* T_nonCriticalExtension_38 */
static int hf_lte_rrc_ue_Category_v1020 = -1;     /* INTEGER_6_8 */
static int hf_lte_rrc_phyLayerParameters_v1020 = -1;  /* PhyLayerParameters_v1020 */
static int hf_lte_rrc_rf_Parameters_v1020 = -1;   /* RF_Parameters_v1020 */
static int hf_lte_rrc_measParameters_v1020 = -1;  /* MeasParameters_v1020 */
static int hf_lte_rrc_featureGroupIndRel10_r10 = -1;  /* T_featureGroupIndRel10_r10 */
static int hf_lte_rrc_interRAT_ParametersCDMA2000_v1020 = -1;  /* IRAT_ParametersCDMA2000_1XRTT_v1020 */
static int hf_lte_rrc_ue_BasedNetwPerfMeasParameters_r10 = -1;  /* UE_BasedNetwPerfMeasParameters_r10 */
static int hf_lte_rrc_interRAT_ParametersUTRA_TDD_v1020 = -1;  /* IRAT_ParametersUTRA_TDD_v1020 */
static int hf_lte_rrc_nonCriticalExtension_91 = -1;  /* T_nonCriticalExtension_39 */
static int hf_lte_rrc_phyLayerParameters_r9 = -1;  /* PhyLayerParameters */
static int hf_lte_rrc_featureGroupIndicators_r9 = -1;  /* T_featureGroupIndicators_r9 */
static int hf_lte_rrc_featureGroupIndRel9Add_r9_01 = -1;  /* T_featureGroupIndRel9Add_r9_01 */
static int hf_lte_rrc_interRAT_ParametersGERAN_r9 = -1;  /* IRAT_ParametersGERAN */
static int hf_lte_rrc_interRAT_ParametersUTRA_r9 = -1;  /* IRAT_ParametersUTRA_v920 */
static int hf_lte_rrc_interRAT_ParametersCDMA2000_r9 = -1;  /* IRAT_ParametersCDMA2000_1XRTT_v920 */
static int hf_lte_rrc_supportedROHC_Profiles = -1;  /* T_supportedROHC_Profiles */
static int hf_lte_rrc_maxNumberROHC_ContextSessions = -1;  /* T_maxNumberROHC_ContextSessions */
static int hf_lte_rrc_ue_TxAntennaSelectionSupported = -1;  /* BOOLEAN */
static int hf_lte_rrc_ue_SpecificRefSigsSupported = -1;  /* BOOLEAN */
static int hf_lte_rrc_enhancedDualLayerFDD_r9 = -1;  /* T_enhancedDualLayerFDD_r9 */
static int hf_lte_rrc_enhancedDualLayerTDD_r9 = -1;  /* T_enhancedDualLayerTDD_r9 */
static int hf_lte_rrc_twoAntennaPortsForPUCCH_r10 = -1;  /* T_twoAntennaPortsForPUCCH_r10 */
static int hf_lte_rrc_tm9_With_8Tx_FDD_r10 = -1;  /* T_tm9_With_8Tx_FDD_r10 */
static int hf_lte_rrc_pmi_Disabling_r10 = -1;     /* T_pmi_Disabling_r10 */
static int hf_lte_rrc_crossCarrierScheduling_r10 = -1;  /* T_crossCarrierScheduling_r10 */
static int hf_lte_rrc_simultaneousPUCCH_PUSCH_r10_01 = -1;  /* T_simultaneousPUCCH_PUSCH_r10_01 */
static int hf_lte_rrc_multiClusterPUSCH_WithinCC_r10 = -1;  /* T_multiClusterPUSCH_WithinCC_r10 */
static int hf_lte_rrc_nonContiguousUL_RA_WithinCC_List_r10 = -1;  /* NonContiguousUL_RA_WithinCC_List_r10 */
static int hf_lte_rrc_NonContiguousUL_RA_WithinCC_List_r10_item = -1;  /* NonContiguousUL_RA_WithinCC_r10 */
static int hf_lte_rrc_nonContiguousUL_RA_WithinCC_Info_r10 = -1;  /* T_nonContiguousUL_RA_WithinCC_Info_r10 */
static int hf_lte_rrc_supportedBandListEUTRA = -1;  /* SupportedBandListEUTRA */
static int hf_lte_rrc_supportedBandCombination_r10 = -1;  /* SupportedBandCombination_r10 */
static int hf_lte_rrc_SupportedBandCombination_r10_item = -1;  /* BandCombinationParameters_r10 */
static int hf_lte_rrc_BandCombinationParameters_r10_item = -1;  /* BandParameters_r10 */
static int hf_lte_rrc_bandEUTRA_r10 = -1;         /* INTEGER_1_64 */
static int hf_lte_rrc_bandParametersUL_r10 = -1;  /* BandParametersUL_r10 */
static int hf_lte_rrc_bandParametersDL_r10 = -1;  /* BandParametersDL_r10 */
static int hf_lte_rrc_BandParametersUL_r10_item = -1;  /* CA_MIMO_ParametersUL_r10 */
static int hf_lte_rrc_ca_BandwidthClassUL_r10 = -1;  /* CA_BandwidthClass_r10 */
static int hf_lte_rrc_supportedMIMO_CapabilityUL_r10 = -1;  /* MIMO_CapabilityUL_r10 */
static int hf_lte_rrc_BandParametersDL_r10_item = -1;  /* CA_MIMO_ParametersDL_r10 */
static int hf_lte_rrc_ca_BandwidthClassDL_r10 = -1;  /* CA_BandwidthClass_r10 */
static int hf_lte_rrc_supportedMIMO_CapabilityDL_r10 = -1;  /* MIMO_CapabilityDL_r10 */
static int hf_lte_rrc_SupportedBandListEUTRA_item = -1;  /* SupportedBandEUTRA */
static int hf_lte_rrc_bandEUTRA = -1;             /* INTEGER_1_64 */
static int hf_lte_rrc_halfDuplex = -1;            /* BOOLEAN */
static int hf_lte_rrc_bandListEUTRA = -1;         /* BandListEUTRA */
static int hf_lte_rrc_bandCombinationListEUTRA_r10 = -1;  /* BandCombinationListEUTRA_r10 */
static int hf_lte_rrc_BandListEUTRA_item = -1;    /* BandInfoEUTRA */
static int hf_lte_rrc_BandCombinationListEUTRA_r10_item = -1;  /* BandInfoEUTRA */
static int hf_lte_rrc_interFreqBandList = -1;     /* InterFreqBandList */
static int hf_lte_rrc_interRAT_BandList = -1;     /* InterRAT_BandList */
static int hf_lte_rrc_InterFreqBandList_item = -1;  /* InterFreqBandInfo */
static int hf_lte_rrc_interFreqNeedForGaps = -1;  /* BOOLEAN */
static int hf_lte_rrc_InterRAT_BandList_item = -1;  /* InterRAT_BandInfo */
static int hf_lte_rrc_interRAT_NeedForGaps = -1;  /* BOOLEAN */
static int hf_lte_rrc_supportedBandListUTRA_FDD = -1;  /* SupportedBandListUTRA_FDD */
static int hf_lte_rrc_e_RedirectionUTRA_r9 = -1;  /* T_e_RedirectionUTRA_r9 */
static int hf_lte_rrc_SupportedBandListUTRA_FDD_item = -1;  /* SupportedBandUTRA_FDD */
static int hf_lte_rrc_supportedBandListUTRA_TDD128 = -1;  /* SupportedBandListUTRA_TDD128 */
static int hf_lte_rrc_SupportedBandListUTRA_TDD128_item = -1;  /* SupportedBandUTRA_TDD128 */
static int hf_lte_rrc_supportedBandListUTRA_TDD384 = -1;  /* SupportedBandListUTRA_TDD384 */
static int hf_lte_rrc_SupportedBandListUTRA_TDD384_item = -1;  /* SupportedBandUTRA_TDD384 */
static int hf_lte_rrc_supportedBandListUTRA_TDD768 = -1;  /* SupportedBandListUTRA_TDD768 */
static int hf_lte_rrc_SupportedBandListUTRA_TDD768_item = -1;  /* SupportedBandUTRA_TDD768 */
static int hf_lte_rrc_e_RedirectionUTRA_TDD_r10 = -1;  /* T_e_RedirectionUTRA_TDD_r10 */
static int hf_lte_rrc_supportedBandListGERAN = -1;  /* SupportedBandListGERAN */
static int hf_lte_rrc_interRAT_PS_HO_ToGERAN = -1;  /* BOOLEAN */
static int hf_lte_rrc_dtm_r9 = -1;                /* T_dtm_r9 */
static int hf_lte_rrc_e_RedirectionGERAN_r9 = -1;  /* T_e_RedirectionGERAN_r9 */
static int hf_lte_rrc_SupportedBandListGERAN_item = -1;  /* SupportedBandGERAN */
static int hf_lte_rrc_supportedBandListHRPD = -1;  /* SupportedBandListHRPD */
static int hf_lte_rrc_tx_ConfigHRPD = -1;         /* T_tx_ConfigHRPD */
static int hf_lte_rrc_rx_ConfigHRPD = -1;         /* T_rx_ConfigHRPD */
static int hf_lte_rrc_SupportedBandListHRPD_item = -1;  /* BandclassCDMA2000 */
static int hf_lte_rrc_supportedBandList1XRTT = -1;  /* SupportedBandList1XRTT */
static int hf_lte_rrc_tx_Config1XRTT = -1;        /* T_tx_Config1XRTT */
static int hf_lte_rrc_rx_Config1XRTT = -1;        /* T_rx_Config1XRTT */
static int hf_lte_rrc_e_CSFB_1XRTT_r9 = -1;       /* T_e_CSFB_1XRTT_r9 */
static int hf_lte_rrc_e_CSFB_ConcPS_Mob1XRTT_r9 = -1;  /* T_e_CSFB_ConcPS_Mob1XRTT_r9 */
static int hf_lte_rrc_e_CSFB_dual_1XRTT_r10 = -1;  /* T_e_CSFB_dual_1XRTT_r10 */
static int hf_lte_rrc_SupportedBandList1XRTT_item = -1;  /* BandclassCDMA2000 */
static int hf_lte_rrc_intraFreqProximityIndication_r9 = -1;  /* T_intraFreqProximityIndication_r9 */
static int hf_lte_rrc_interFreqProximityIndication_r9 = -1;  /* T_interFreqProximityIndication_r9 */
static int hf_lte_rrc_utran_ProximityIndication_r9 = -1;  /* T_utran_ProximityIndication_r9 */
static int hf_lte_rrc_intraFreqSI_AcquisitionForHO_r9 = -1;  /* T_intraFreqSI_AcquisitionForHO_r9 */
static int hf_lte_rrc_interFreqSI_AcquisitionForHO_r9 = -1;  /* T_interFreqSI_AcquisitionForHO_r9 */
static int hf_lte_rrc_utran_SI_AcquisitionForHO_r9 = -1;  /* T_utran_SI_AcquisitionForHO_r9 */
static int hf_lte_rrc_rach_Report_r9_01 = -1;     /* T_rach_Report_r9_01 */
static int hf_lte_rrc_loggedMeasurementsIdle_r10 = -1;  /* T_loggedMeasurementsIdle_r10 */
static int hf_lte_rrc_standaloneGNSS_Location_r10 = -1;  /* T_standaloneGNSS_Location_r10 */
static int hf_lte_rrc_t300 = -1;                  /* T_t300 */
static int hf_lte_rrc_t301 = -1;                  /* T_t301 */
static int hf_lte_rrc_t310 = -1;                  /* T_t310 */
static int hf_lte_rrc_n310 = -1;                  /* T_n310 */
static int hf_lte_rrc_t311 = -1;                  /* T_t311 */
static int hf_lte_rrc_n311 = -1;                  /* T_n311 */
static int hf_lte_rrc_notificationRepetitionCoeff_r9 = -1;  /* T_notificationRepetitionCoeff_r9 */
static int hf_lte_rrc_notificationOffset_r9 = -1;  /* INTEGER_0_10 */
static int hf_lte_rrc_notificationSF_Index_r9 = -1;  /* INTEGER_1_6 */
static int hf_lte_rrc_MBSFN_AreaInfoList_r9_item = -1;  /* MBSFN_AreaInfo_r9 */
static int hf_lte_rrc_mbsfn_AreaId_r9 = -1;       /* INTEGER_0_255 */
static int hf_lte_rrc_non_MBSFNregionLength = -1;  /* T_non_MBSFNregionLength */
static int hf_lte_rrc_notificationIndicator_r9 = -1;  /* INTEGER_0_7 */
static int hf_lte_rrc_mcch_Config_r9 = -1;        /* T_mcch_Config_r9 */
static int hf_lte_rrc_mcch_RepetitionPeriod_r9 = -1;  /* T_mcch_RepetitionPeriod_r9 */
static int hf_lte_rrc_mcch_Offset_r9 = -1;        /* INTEGER_0_10 */
static int hf_lte_rrc_mcch_ModificationPeriod_r9 = -1;  /* T_mcch_ModificationPeriod_r9 */
static int hf_lte_rrc_sf_AllocInfo_r9 = -1;       /* BIT_STRING_SIZE_6 */
static int hf_lte_rrc_signallingMCS_r9 = -1;      /* T_signallingMCS_r9 */
static int hf_lte_rrc_radioframeAllocationPeriod = -1;  /* T_radioframeAllocationPeriod */
static int hf_lte_rrc_radioframeAllocationOffset = -1;  /* INTEGER_0_7 */
static int hf_lte_rrc_subframeAllocation = -1;    /* T_subframeAllocation */
static int hf_lte_rrc_oneFrame = -1;              /* BIT_STRING_SIZE_6 */
static int hf_lte_rrc_fourFrames = -1;            /* BIT_STRING_SIZE_24 */
static int hf_lte_rrc_PMCH_InfoList_r9_item = -1;  /* PMCH_Info_r9 */
static int hf_lte_rrc_pmch_Config_r9 = -1;        /* PMCH_Config_r9 */
static int hf_lte_rrc_mbms_SessionInfoList_r9 = -1;  /* MBMS_SessionInfoList_r9 */
static int hf_lte_rrc_MBMS_SessionInfoList_r9_item = -1;  /* MBMS_SessionInfo_r9 */
static int hf_lte_rrc_tmgi_r9 = -1;               /* TMGI_r9 */
static int hf_lte_rrc_sessionId_r9 = -1;          /* OCTET_STRING_SIZE_1 */
static int hf_lte_rrc_logicalChannelIdentity_r9 = -1;  /* INTEGER_0_maxSessionPerPMCH_1 */
static int hf_lte_rrc_sf_AllocEnd_r9 = -1;        /* INTEGER_0_1535 */
static int hf_lte_rrc_dataMCS_r9 = -1;            /* INTEGER_0_28 */
static int hf_lte_rrc_mch_SchedulingPeriod_r9 = -1;  /* T_mch_SchedulingPeriod_r9 */
static int hf_lte_rrc_plmn_Id_r9 = -1;            /* T_plmn_Id_r9 */
static int hf_lte_rrc_plmn_Index_r9 = -1;         /* INTEGER_1_6 */
static int hf_lte_rrc_explicitValue_r9 = -1;      /* PLMN_Identity */
static int hf_lte_rrc_serviceId_r9 = -1;          /* OCTET_STRING_SIZE_3 */
static int hf_lte_rrc_criticalExtensions_35 = -1;  /* T_criticalExtensions_35 */
static int hf_lte_rrc_c1_31 = -1;                 /* T_c1_31 */
static int hf_lte_rrc_handoverCommand_r8 = -1;    /* HandoverCommand_r8_IEs */
static int hf_lte_rrc_criticalExtensionsFuture_35 = -1;  /* T_criticalExtensionsFuture_35 */
static int hf_lte_rrc_handoverCommandMessage = -1;  /* T_handoverCommandMessage */
static int hf_lte_rrc_nonCriticalExtension_92 = -1;  /* T_nonCriticalExtension_40 */
static int hf_lte_rrc_criticalExtensions_36 = -1;  /* T_criticalExtensions_36 */
static int hf_lte_rrc_c1_32 = -1;                 /* T_c1_32 */
static int hf_lte_rrc_handoverPreparationInformation_r8 = -1;  /* HandoverPreparationInformation_r8_IEs */
static int hf_lte_rrc_criticalExtensionsFuture_36 = -1;  /* T_criticalExtensionsFuture_36 */
static int hf_lte_rrc_ue_RadioAccessCapabilityInfo = -1;  /* UE_CapabilityRAT_ContainerList */
static int hf_lte_rrc_as_Config = -1;             /* AS_Config */
static int hf_lte_rrc_rrm_Config = -1;            /* RRM_Config */
static int hf_lte_rrc_as_Context = -1;            /* AS_Context */
static int hf_lte_rrc_nonCriticalExtension_93 = -1;  /* HandoverPreparationInformation_v920_IEs */
static int hf_lte_rrc_ue_ConfigRelease_r9 = -1;   /* T_ue_ConfigRelease_r9 */
static int hf_lte_rrc_nonCriticalExtension_94 = -1;  /* T_nonCriticalExtension_41 */
static int hf_lte_rrc_criticalExtensions_37 = -1;  /* T_criticalExtensions_37 */
static int hf_lte_rrc_c1_33 = -1;                 /* T_c1_33 */
static int hf_lte_rrc_ueRadioAccessCapabilityInformation_r8 = -1;  /* UERadioAccessCapabilityInformation_r8_IEs */
static int hf_lte_rrc_criticalExtensionsFuture_37 = -1;  /* T_criticalExtensionsFuture_37 */
static int hf_lte_rrc_ue_RadioAccessCapabilityInfo_01 = -1;  /* T_ue_RadioAccessCapabilityInfo */
static int hf_lte_rrc_nonCriticalExtension_95 = -1;  /* T_nonCriticalExtension_42 */
static int hf_lte_rrc_sourceMeasConfig = -1;      /* MeasConfig */
static int hf_lte_rrc_sourceRadioResourceConfig = -1;  /* RadioResourceConfigDedicated */
static int hf_lte_rrc_sourceSecurityAlgorithmConfig = -1;  /* SecurityAlgorithmConfig */
static int hf_lte_rrc_sourceUE_Identity = -1;     /* C_RNTI */
static int hf_lte_rrc_sourceMasterInformationBlock = -1;  /* MasterInformationBlock */
static int hf_lte_rrc_sourceSystemInformationBlockType1 = -1;  /* SystemInformationBlockType1 */
static int hf_lte_rrc_sourceSystemInformationBlockType2 = -1;  /* SystemInformationBlockType2 */
static int hf_lte_rrc_sourceDl_CarrierFreq = -1;  /* ARFCN_ValueEUTRA */
static int hf_lte_rrc_sourceSystemInformationBlockType1Ext = -1;  /* T_sourceSystemInformationBlockType1Ext */
static int hf_lte_rrc_sourceOtherConfig_r9 = -1;  /* OtherConfig_r9 */
static int hf_lte_rrc_sourceSCellConfigList_r10 = -1;  /* SCellToAddModList_r10 */
static int hf_lte_rrc_reestablishmentInfo = -1;   /* ReestablishmentInfo */
static int hf_lte_rrc_sourcePhysCellId = -1;      /* PhysCellId */
static int hf_lte_rrc_targetCellShortMAC_I = -1;  /* ShortMAC_I */
static int hf_lte_rrc_additionalReestabInfoList = -1;  /* AdditionalReestabInfoList */
static int hf_lte_rrc_AdditionalReestabInfoList_item = -1;  /* AdditionalReestabInfo */
static int hf_lte_rrc_key_eNodeB_Star = -1;       /* Key_eNodeB_Star */
static int hf_lte_rrc_ue_InactiveTime = -1;       /* T_ue_InactiveTime */
static int hf_lte_rrc_candidateCellInfoList_r10 = -1;  /* CandidateCellInfoList_r10 */
static int hf_lte_rrc_CandidateCellInfoList_r10_item = -1;  /* CandidateCellInfo_r10 */
static int hf_lte_rrc_dummy_eag_field = -1; /* never registered */ 

/*--- End of included file: packet-lte-rrc-hf.c ---*/
#line 64 "../../asn1/lte-rrc/packet-lte-rrc-template.c"

static int hf_lte_rrc_eutra_cap_feat_group_ind_1 = -1;
static int hf_lte_rrc_eutra_cap_feat_group_ind_2 = -1;
static int hf_lte_rrc_eutra_cap_feat_group_ind_3 = -1;
static int hf_lte_rrc_eutra_cap_feat_group_ind_4 = -1;
static int hf_lte_rrc_eutra_cap_feat_group_ind_5 = -1;
static int hf_lte_rrc_eutra_cap_feat_group_ind_6 = -1;
static int hf_lte_rrc_eutra_cap_feat_group_ind_7 = -1;
static int hf_lte_rrc_eutra_cap_feat_group_ind_8 = -1;
static int hf_lte_rrc_eutra_cap_feat_group_ind_9 = -1;
static int hf_lte_rrc_eutra_cap_feat_group_ind_10 = -1;
static int hf_lte_rrc_eutra_cap_feat_group_ind_11 = -1;
static int hf_lte_rrc_eutra_cap_feat_group_ind_12 = -1;
static int hf_lte_rrc_eutra_cap_feat_group_ind_13 = -1;
static int hf_lte_rrc_eutra_cap_feat_group_ind_14 = -1;
static int hf_lte_rrc_eutra_cap_feat_group_ind_15 = -1;
static int hf_lte_rrc_eutra_cap_feat_group_ind_16 = -1;
static int hf_lte_rrc_eutra_cap_feat_group_ind_17 = -1;
static int hf_lte_rrc_eutra_cap_feat_group_ind_18 = -1;
static int hf_lte_rrc_eutra_cap_feat_group_ind_19 = -1;
static int hf_lte_rrc_eutra_cap_feat_group_ind_20 = -1;
static int hf_lte_rrc_eutra_cap_feat_group_ind_21 = -1;
static int hf_lte_rrc_eutra_cap_feat_group_ind_22 = -1;
static int hf_lte_rrc_eutra_cap_feat_group_ind_23 = -1;
static int hf_lte_rrc_eutra_cap_feat_group_ind_24 = -1;
static int hf_lte_rrc_eutra_cap_feat_group_ind_25 = -1;
static int hf_lte_rrc_eutra_cap_feat_group_ind_26 = -1;
static int hf_lte_rrc_eutra_cap_feat_group_ind_27 = -1;
static int hf_lte_rrc_eutra_cap_feat_group_ind_28 = -1;
static int hf_lte_rrc_eutra_cap_feat_group_ind_29 = -1;
static int hf_lte_rrc_eutra_cap_feat_group_ind_30 = -1;
static int hf_lte_rrc_eutra_cap_feat_group_ind_31 = -1;
static int hf_lte_rrc_eutra_cap_feat_group_ind_32 = -1;
static int hf_lte_rrc_eutra_cap_feat_group_ind_33 = -1;
static int hf_lte_rrc_eutra_cap_feat_group_ind_34 = -1;
static int hf_lte_rrc_eutra_cap_feat_group_ind_35 = -1;
static int hf_lte_rrc_eutra_cap_feat_group_ind_36 = -1;
static int hf_lte_rrc_eutra_cap_feat_group_ind_37 = -1;
static int hf_lte_rrc_eutra_cap_feat_group_ind_38 = -1;
static int hf_lte_rrc_eutra_cap_feat_group_ind_39 = -1;
static int hf_lte_rrc_eutra_cap_feat_group_ind_40 = -1;
static int hf_lte_rrc_eutra_cap_feat_group_ind_41 = -1;
static int hf_lte_rrc_eutra_cap_feat_group_ind_42 = -1;
static int hf_lte_rrc_eutra_cap_feat_group_ind_43 = -1;
static int hf_lte_rrc_eutra_cap_feat_group_ind_44 = -1;
static int hf_lte_rrc_eutra_cap_feat_group_ind_45 = -1;
static int hf_lte_rrc_eutra_cap_feat_group_ind_46 = -1;
static int hf_lte_rrc_eutra_cap_feat_group_ind_47 = -1;
static int hf_lte_rrc_eutra_cap_feat_group_ind_48 = -1;
static int hf_lte_rrc_eutra_cap_feat_group_ind_49 = -1;
static int hf_lte_rrc_eutra_cap_feat_group_ind_50 = -1;
static int hf_lte_rrc_eutra_cap_feat_group_ind_51 = -1;
static int hf_lte_rrc_eutra_cap_feat_group_ind_52 = -1;
static int hf_lte_rrc_eutra_cap_feat_group_ind_53 = -1;
static int hf_lte_rrc_eutra_cap_feat_group_ind_54 = -1;
static int hf_lte_rrc_eutra_cap_feat_group_ind_55 = -1;
static int hf_lte_rrc_eutra_cap_feat_group_ind_56 = -1;
static int hf_lte_rrc_eutra_cap_feat_group_ind_57 = -1;
static int hf_lte_rrc_eutra_cap_feat_group_ind_58 = -1;
static int hf_lte_rrc_eutra_cap_feat_group_ind_59 = -1;
static int hf_lte_rrc_eutra_cap_feat_group_ind_60 = -1;
static int hf_lte_rrc_eutra_cap_feat_group_ind_61 = -1;
static int hf_lte_rrc_eutra_cap_feat_group_ind_62 = -1;
static int hf_lte_rrc_eutra_cap_feat_group_ind_63 = -1;
static int hf_lte_rrc_eutra_cap_feat_group_ind_64 = -1;
static int hf_lte_rrc_eutra_cap_feat_group_ind_101 = -1;
static int hf_lte_rrc_eutra_cap_feat_group_ind_102 = -1;
static int hf_lte_rrc_eutra_cap_feat_group_ind_103 = -1;
static int hf_lte_rrc_eutra_cap_feat_group_ind_104 = -1;
static int hf_lte_rrc_eutra_cap_feat_group_ind_105 = -1;
static int hf_lte_rrc_eutra_cap_feat_group_ind_106 = -1;
static int hf_lte_rrc_eutra_cap_feat_group_ind_107 = -1;
static int hf_lte_rrc_eutra_cap_feat_group_ind_108 = -1;
static int hf_lte_rrc_eutra_cap_feat_group_ind_109 = -1;
static int hf_lte_rrc_eutra_cap_feat_group_ind_110 = -1;
static int hf_lte_rrc_eutra_cap_feat_group_ind_111 = -1;
static int hf_lte_rrc_eutra_cap_feat_group_ind_112 = -1;
static int hf_lte_rrc_eutra_cap_feat_group_ind_113 = -1;
static int hf_lte_rrc_eutra_cap_feat_group_ind_114 = -1;
static int hf_lte_rrc_eutra_cap_feat_group_ind_115 = -1;
static int hf_lte_rrc_eutra_cap_feat_group_ind_116 = -1;
static int hf_lte_rrc_eutra_cap_feat_group_ind_117 = -1;
static int hf_lte_rrc_eutra_cap_feat_group_ind_118 = -1;
static int hf_lte_rrc_eutra_cap_feat_group_ind_119 = -1;
static int hf_lte_rrc_eutra_cap_feat_group_ind_120 = -1;
static int hf_lte_rrc_eutra_cap_feat_group_ind_121 = -1;
static int hf_lte_rrc_eutra_cap_feat_group_ind_122 = -1;
static int hf_lte_rrc_eutra_cap_feat_group_ind_123 = -1;
static int hf_lte_rrc_eutra_cap_feat_group_ind_124 = -1;
static int hf_lte_rrc_eutra_cap_feat_group_ind_125 = -1;
static int hf_lte_rrc_eutra_cap_feat_group_ind_126 = -1;
static int hf_lte_rrc_eutra_cap_feat_group_ind_127 = -1;
static int hf_lte_rrc_eutra_cap_feat_group_ind_128 = -1;
static int hf_lte_rrc_eutra_cap_feat_group_ind_129 = -1;
static int hf_lte_rrc_eutra_cap_feat_group_ind_130 = -1;
static int hf_lte_rrc_eutra_cap_feat_group_ind_131 = -1;
static int hf_lte_rrc_eutra_cap_feat_group_ind_132 = -1;

/* Initialize the subtree pointers */
static int ett_lte_rrc = -1;


/*--- Included file: packet-lte-rrc-ett.c ---*/
#line 1 "../../asn1/lte-rrc/packet-lte-rrc-ett.c"
static gint ett_lte_rrc_BCCH_BCH_Message = -1;
static gint ett_lte_rrc_BCCH_DL_SCH_Message = -1;
static gint ett_lte_rrc_BCCH_DL_SCH_MessageType = -1;
static gint ett_lte_rrc_T_c1 = -1;
static gint ett_lte_rrc_T_messageClassExtension = -1;
static gint ett_lte_rrc_MCCH_Message = -1;
static gint ett_lte_rrc_MCCH_MessageType = -1;
static gint ett_lte_rrc_T_c1_01 = -1;
static gint ett_lte_rrc_T_later = -1;
static gint ett_lte_rrc_T_c2 = -1;
static gint ett_lte_rrc_T_messageClassExtension_01 = -1;
static gint ett_lte_rrc_PCCH_Message = -1;
static gint ett_lte_rrc_PCCH_MessageType = -1;
static gint ett_lte_rrc_T_c1_02 = -1;
static gint ett_lte_rrc_T_messageClassExtension_02 = -1;
static gint ett_lte_rrc_DL_CCCH_Message = -1;
static gint ett_lte_rrc_DL_CCCH_MessageType = -1;
static gint ett_lte_rrc_T_c1_03 = -1;
static gint ett_lte_rrc_T_messageClassExtension_03 = -1;
static gint ett_lte_rrc_DL_DCCH_Message = -1;
static gint ett_lte_rrc_DL_DCCH_MessageType = -1;
static gint ett_lte_rrc_T_c1_04 = -1;
static gint ett_lte_rrc_T_messageClassExtension_04 = -1;
static gint ett_lte_rrc_UL_CCCH_Message = -1;
static gint ett_lte_rrc_UL_CCCH_MessageType = -1;
static gint ett_lte_rrc_T_c1_05 = -1;
static gint ett_lte_rrc_T_messageClassExtension_05 = -1;
static gint ett_lte_rrc_UL_DCCH_Message = -1;
static gint ett_lte_rrc_UL_DCCH_MessageType = -1;
static gint ett_lte_rrc_T_c1_06 = -1;
static gint ett_lte_rrc_T_messageClassExtension_06 = -1;
static gint ett_lte_rrc_CounterCheck = -1;
static gint ett_lte_rrc_T_criticalExtensions = -1;
static gint ett_lte_rrc_T_c1_07 = -1;
static gint ett_lte_rrc_T_criticalExtensionsFuture = -1;
static gint ett_lte_rrc_CounterCheck_r8_IEs = -1;
static gint ett_lte_rrc_CounterCheck_v8a0_IEs = -1;
static gint ett_lte_rrc_T_nonCriticalExtension = -1;
static gint ett_lte_rrc_DRB_CountMSB_InfoList = -1;
static gint ett_lte_rrc_DRB_CountMSB_Info = -1;
static gint ett_lte_rrc_CounterCheckResponse = -1;
static gint ett_lte_rrc_T_criticalExtensions_01 = -1;
static gint ett_lte_rrc_T_criticalExtensionsFuture_01 = -1;
static gint ett_lte_rrc_CounterCheckResponse_r8_IEs = -1;
static gint ett_lte_rrc_CounterCheckResponse_v8a0_IEs = -1;
static gint ett_lte_rrc_T_nonCriticalExtension_01 = -1;
static gint ett_lte_rrc_DRB_CountInfoList = -1;
static gint ett_lte_rrc_DRB_CountInfo = -1;
static gint ett_lte_rrc_CSFBParametersRequestCDMA2000 = -1;
static gint ett_lte_rrc_T_criticalExtensions_02 = -1;
static gint ett_lte_rrc_T_criticalExtensionsFuture_02 = -1;
static gint ett_lte_rrc_CSFBParametersRequestCDMA2000_r8_IEs = -1;
static gint ett_lte_rrc_CSFBParametersRequestCDMA2000_v8a0_IEs = -1;
static gint ett_lte_rrc_T_nonCriticalExtension_02 = -1;
static gint ett_lte_rrc_CSFBParametersResponseCDMA2000 = -1;
static gint ett_lte_rrc_T_criticalExtensions_03 = -1;
static gint ett_lte_rrc_T_criticalExtensionsFuture_03 = -1;
static gint ett_lte_rrc_CSFBParametersResponseCDMA2000_r8_IEs = -1;
static gint ett_lte_rrc_CSFBParametersResponseCDMA2000_v8a0_IEs = -1;
static gint ett_lte_rrc_T_nonCriticalExtension_03 = -1;
static gint ett_lte_rrc_DLInformationTransfer = -1;
static gint ett_lte_rrc_T_criticalExtensions_04 = -1;
static gint ett_lte_rrc_T_c1_08 = -1;
static gint ett_lte_rrc_T_criticalExtensionsFuture_04 = -1;
static gint ett_lte_rrc_DLInformationTransfer_r8_IEs = -1;
static gint ett_lte_rrc_T_dedicatedInfoType = -1;
static gint ett_lte_rrc_DLInformationTransfer_v8a0_IEs = -1;
static gint ett_lte_rrc_T_nonCriticalExtension_04 = -1;
static gint ett_lte_rrc_HandoverFromEUTRAPreparationRequest = -1;
static gint ett_lte_rrc_T_criticalExtensions_05 = -1;
static gint ett_lte_rrc_T_c1_09 = -1;
static gint ett_lte_rrc_T_criticalExtensionsFuture_05 = -1;
static gint ett_lte_rrc_HandoverFromEUTRAPreparationRequest_r8_IEs = -1;
static gint ett_lte_rrc_HandoverFromEUTRAPreparationRequest_v890_IEs = -1;
static gint ett_lte_rrc_HandoverFromEUTRAPreparationRequest_v920_IEs = -1;
static gint ett_lte_rrc_HandoverFromEUTRAPreparationRequest_v1020_IEs = -1;
static gint ett_lte_rrc_T_nonCriticalExtension_05 = -1;
static gint ett_lte_rrc_InterFreqRSTDMeasurementIndication_r10 = -1;
static gint ett_lte_rrc_T_criticalExtensions_06 = -1;
static gint ett_lte_rrc_T_c1_10 = -1;
static gint ett_lte_rrc_T_criticalExtensionsFuture_06 = -1;
static gint ett_lte_rrc_InterFreqRSTDMeasurementIndication_r10_IEs = -1;
static gint ett_lte_rrc_T_rstd_InterFreqIndication_r10 = -1;
static gint ett_lte_rrc_T_start = -1;
static gint ett_lte_rrc_T_nonCriticalExtension_06 = -1;
static gint ett_lte_rrc_RSTD_InterFreqInfoList_r10 = -1;
static gint ett_lte_rrc_RSTD_InterFreqInfo_r10 = -1;
static gint ett_lte_rrc_LoggedMeasurementConfiguration_r10 = -1;
static gint ett_lte_rrc_T_criticalExtensions_07 = -1;
static gint ett_lte_rrc_T_c1_11 = -1;
static gint ett_lte_rrc_T_criticalExtensionsFuture_07 = -1;
static gint ett_lte_rrc_LoggedMeasurementConfiguration_r10_IEs = -1;
static gint ett_lte_rrc_T_nonCriticalExtension_07 = -1;
static gint ett_lte_rrc_MasterInformationBlock = -1;
static gint ett_lte_rrc_MBMSCountingRequest_r10 = -1;
static gint ett_lte_rrc_T_nonCriticalExtension_08 = -1;
static gint ett_lte_rrc_CountingRequestList_r10 = -1;
static gint ett_lte_rrc_CountingRequestInfo_r10 = -1;
static gint ett_lte_rrc_MBMSCountingResponse_r10 = -1;
static gint ett_lte_rrc_T_criticalExtensions_08 = -1;
static gint ett_lte_rrc_T_c1_12 = -1;
static gint ett_lte_rrc_T_criticalExtensionsFuture_08 = -1;
static gint ett_lte_rrc_MBMSCountingResponse_r10_IEs = -1;
static gint ett_lte_rrc_T_nonCriticalExtension_09 = -1;
static gint ett_lte_rrc_CountingResponseList_r10 = -1;
static gint ett_lte_rrc_CountingResponseInfo_r10 = -1;
static gint ett_lte_rrc_MBSFNAreaConfiguration_r9 = -1;
static gint ett_lte_rrc_MBSFNAreaConfiguration_v930_IEs = -1;
static gint ett_lte_rrc_T_nonCriticalExtension_10 = -1;
static gint ett_lte_rrc_CommonSF_AllocPatternList_r9 = -1;
static gint ett_lte_rrc_MeasurementReport = -1;
static gint ett_lte_rrc_T_criticalExtensions_09 = -1;
static gint ett_lte_rrc_T_c1_13 = -1;
static gint ett_lte_rrc_T_criticalExtensionsFuture_09 = -1;
static gint ett_lte_rrc_MeasurementReport_r8_IEs = -1;
static gint ett_lte_rrc_MeasurementReport_v8a0_IEs = -1;
static gint ett_lte_rrc_T_nonCriticalExtension_11 = -1;
static gint ett_lte_rrc_MobilityFromEUTRACommand = -1;
static gint ett_lte_rrc_T_criticalExtensions_10 = -1;
static gint ett_lte_rrc_T_c1_14 = -1;
static gint ett_lte_rrc_T_criticalExtensionsFuture_10 = -1;
static gint ett_lte_rrc_MobilityFromEUTRACommand_r8_IEs = -1;
static gint ett_lte_rrc_T_purpose = -1;
static gint ett_lte_rrc_MobilityFromEUTRACommand_v8a0_IEs = -1;
static gint ett_lte_rrc_MobilityFromEUTRACommand_v8d0_IEs = -1;
static gint ett_lte_rrc_T_nonCriticalExtension_12 = -1;
static gint ett_lte_rrc_MobilityFromEUTRACommand_r9_IEs = -1;
static gint ett_lte_rrc_T_purpose_01 = -1;
static gint ett_lte_rrc_MobilityFromEUTRACommand_v930_IEs = -1;
static gint ett_lte_rrc_MobilityFromEUTRACommand_v960_IEs = -1;
static gint ett_lte_rrc_T_nonCriticalExtension_13 = -1;
static gint ett_lte_rrc_Handover = -1;
static gint ett_lte_rrc_CellChangeOrder = -1;
static gint ett_lte_rrc_T_targetRAT_Type_01 = -1;
static gint ett_lte_rrc_T_geran = -1;
static gint ett_lte_rrc_SI_OrPSI_GERAN = -1;
static gint ett_lte_rrc_E_CSFB_r9 = -1;
static gint ett_lte_rrc_Paging = -1;
static gint ett_lte_rrc_Paging_v890_IEs = -1;
static gint ett_lte_rrc_Paging_v920_IEs = -1;
static gint ett_lte_rrc_T_nonCriticalExtension_14 = -1;
static gint ett_lte_rrc_PagingRecordList = -1;
static gint ett_lte_rrc_PagingRecord = -1;
static gint ett_lte_rrc_PagingUE_Identity = -1;
static gint ett_lte_rrc_IMSI = -1;
static gint ett_lte_rrc_ProximityIndication_r9 = -1;
static gint ett_lte_rrc_T_criticalExtensions_11 = -1;
static gint ett_lte_rrc_T_c1_15 = -1;
static gint ett_lte_rrc_T_criticalExtensionsFuture_11 = -1;
static gint ett_lte_rrc_ProximityIndication_r9_IEs = -1;
static gint ett_lte_rrc_T_carrierFreq_r9 = -1;
static gint ett_lte_rrc_ProximityIndication_v930_IEs = -1;
static gint ett_lte_rrc_T_nonCriticalExtension_15 = -1;
static gint ett_lte_rrc_RNReconfiguration_r10 = -1;
static gint ett_lte_rrc_T_criticalExtensions_12 = -1;
static gint ett_lte_rrc_T_c1_16 = -1;
static gint ett_lte_rrc_T_criticalExtensionsFuture_12 = -1;
static gint ett_lte_rrc_RNReconfiguration_r10_IEs = -1;
static gint ett_lte_rrc_T_nonCriticalExtension_16 = -1;
static gint ett_lte_rrc_RN_SystemInfo_r10 = -1;
static gint ett_lte_rrc_RNReconfigurationComplete_r10 = -1;
static gint ett_lte_rrc_T_criticalExtensions_13 = -1;
static gint ett_lte_rrc_T_c1_17 = -1;
static gint ett_lte_rrc_T_criticalExtensionsFuture_13 = -1;
static gint ett_lte_rrc_RNReconfigurationComplete_r10_IEs = -1;
static gint ett_lte_rrc_T_nonCriticalExtension_17 = -1;
static gint ett_lte_rrc_RRCConnectionReconfiguration = -1;
static gint ett_lte_rrc_T_criticalExtensions_14 = -1;
static gint ett_lte_rrc_T_c1_18 = -1;
static gint ett_lte_rrc_T_criticalExtensionsFuture_14 = -1;
static gint ett_lte_rrc_RRCConnectionReconfiguration_r8_IEs = -1;
static gint ett_lte_rrc_SEQUENCE_SIZE_1_maxDRB_OF_DedicatedInfoNAS = -1;
static gint ett_lte_rrc_RRCConnectionReconfiguration_v890_IEs = -1;
static gint ett_lte_rrc_RRCConnectionReconfiguration_v920_IEs = -1;
static gint ett_lte_rrc_RRCConnectionReconfiguration_v1020_IEs = -1;
static gint ett_lte_rrc_T_nonCriticalExtension_18 = -1;
static gint ett_lte_rrc_SCellToAddModList_r10 = -1;
static gint ett_lte_rrc_SCellToAddMod_r10 = -1;
static gint ett_lte_rrc_T_cellIdentification_r10 = -1;
static gint ett_lte_rrc_SCellToReleaseList_r10 = -1;
static gint ett_lte_rrc_SecurityConfigHO = -1;
static gint ett_lte_rrc_T_handoverType = -1;
static gint ett_lte_rrc_T_intraLTE = -1;
static gint ett_lte_rrc_T_interRAT = -1;
static gint ett_lte_rrc_RRCConnectionReconfigurationComplete = -1;
static gint ett_lte_rrc_T_criticalExtensions_15 = -1;
static gint ett_lte_rrc_T_criticalExtensionsFuture_15 = -1;
static gint ett_lte_rrc_RRCConnectionReconfigurationComplete_r8_IEs = -1;
static gint ett_lte_rrc_RRCConnectionReconfigurationComplete_v8a0_IEs = -1;
static gint ett_lte_rrc_RRCConnectionReconfigurationComplete_v1020_IEs = -1;
static gint ett_lte_rrc_T_nonCriticalExtension_19 = -1;
static gint ett_lte_rrc_RRCConnectionReestablishment = -1;
static gint ett_lte_rrc_T_criticalExtensions_16 = -1;
static gint ett_lte_rrc_T_c1_19 = -1;
static gint ett_lte_rrc_T_criticalExtensionsFuture_16 = -1;
static gint ett_lte_rrc_RRCConnectionReestablishment_r8_IEs = -1;
static gint ett_lte_rrc_RRCConnectionReestablishment_v8a0_IEs = -1;
static gint ett_lte_rrc_T_nonCriticalExtension_20 = -1;
static gint ett_lte_rrc_RRCConnectionReestablishmentComplete = -1;
static gint ett_lte_rrc_T_criticalExtensions_17 = -1;
static gint ett_lte_rrc_T_criticalExtensionsFuture_17 = -1;
static gint ett_lte_rrc_RRCConnectionReestablishmentComplete_r8_IEs = -1;
static gint ett_lte_rrc_RRCConnectionReestablishmentComplete_v920_IEs = -1;
static gint ett_lte_rrc_RRCConnectionReestablishmentComplete_v8a0_IEs = -1;
static gint ett_lte_rrc_RRCConnectionReestablishmentComplete_v1020_IEs = -1;
static gint ett_lte_rrc_T_nonCriticalExtension_21 = -1;
static gint ett_lte_rrc_RRCConnectionReestablishmentReject = -1;
static gint ett_lte_rrc_T_criticalExtensions_18 = -1;
static gint ett_lte_rrc_T_criticalExtensionsFuture_18 = -1;
static gint ett_lte_rrc_RRCConnectionReestablishmentReject_r8_IEs = -1;
static gint ett_lte_rrc_RRCConnectionReestablishmentReject_v8a0_IEs = -1;
static gint ett_lte_rrc_T_nonCriticalExtension_22 = -1;
static gint ett_lte_rrc_RRCConnectionReestablishmentRequest = -1;
static gint ett_lte_rrc_T_criticalExtensions_19 = -1;
static gint ett_lte_rrc_T_criticalExtensionsFuture_19 = -1;
static gint ett_lte_rrc_RRCConnectionReestablishmentRequest_r8_IEs = -1;
static gint ett_lte_rrc_ReestabUE_Identity = -1;
static gint ett_lte_rrc_RRCConnectionReject = -1;
static gint ett_lte_rrc_T_criticalExtensions_20 = -1;
static gint ett_lte_rrc_T_c1_20 = -1;
static gint ett_lte_rrc_T_criticalExtensionsFuture_20 = -1;
static gint ett_lte_rrc_RRCConnectionReject_r8_IEs = -1;
static gint ett_lte_rrc_RRCConnectionReject_v8a0_IEs = -1;
static gint ett_lte_rrc_RRCConnectionReject_v1020_IEs = -1;
static gint ett_lte_rrc_T_nonCriticalExtension_23 = -1;
static gint ett_lte_rrc_RRCConnectionRelease = -1;
static gint ett_lte_rrc_T_criticalExtensions_21 = -1;
static gint ett_lte_rrc_T_c1_21 = -1;
static gint ett_lte_rrc_T_criticalExtensionsFuture_21 = -1;
static gint ett_lte_rrc_RRCConnectionRelease_r8_IEs = -1;
static gint ett_lte_rrc_RRCConnectionRelease_v890_IEs = -1;
static gint ett_lte_rrc_RRCConnectionRelease_v920_IEs = -1;
static gint ett_lte_rrc_T_cellInfoList_r9 = -1;
static gint ett_lte_rrc_RRCConnectionRelease_v1020_IEs = -1;
static gint ett_lte_rrc_T_nonCriticalExtension_24 = -1;
static gint ett_lte_rrc_RedirectedCarrierInfo = -1;
static gint ett_lte_rrc_CarrierFreqListUTRA_TDD_r10 = -1;
static gint ett_lte_rrc_IdleModeMobilityControlInfo = -1;
static gint ett_lte_rrc_FreqPriorityListEUTRA = -1;
static gint ett_lte_rrc_FreqPriorityEUTRA = -1;
static gint ett_lte_rrc_FreqsPriorityListGERAN = -1;
static gint ett_lte_rrc_FreqsPriorityGERAN = -1;
static gint ett_lte_rrc_FreqPriorityListUTRA_FDD = -1;
static gint ett_lte_rrc_FreqPriorityUTRA_FDD = -1;
static gint ett_lte_rrc_FreqPriorityListUTRA_TDD = -1;
static gint ett_lte_rrc_FreqPriorityUTRA_TDD = -1;
static gint ett_lte_rrc_BandClassPriorityListHRPD = -1;
static gint ett_lte_rrc_BandClassPriorityHRPD = -1;
static gint ett_lte_rrc_BandClassPriorityList1XRTT = -1;
static gint ett_lte_rrc_BandClassPriority1XRTT = -1;
static gint ett_lte_rrc_CellInfoListGERAN_r9 = -1;
static gint ett_lte_rrc_CellInfoGERAN_r9 = -1;
static gint ett_lte_rrc_CellInfoListUTRA_FDD_r9 = -1;
static gint ett_lte_rrc_CellInfoUTRA_FDD_r9 = -1;
static gint ett_lte_rrc_CellInfoListUTRA_TDD_r9 = -1;
static gint ett_lte_rrc_CellInfoUTRA_TDD_r9 = -1;
static gint ett_lte_rrc_CellInfoListUTRA_TDD_r10 = -1;
static gint ett_lte_rrc_CellInfoUTRA_TDD_r10 = -1;
static gint ett_lte_rrc_RRCConnectionRequest = -1;
static gint ett_lte_rrc_T_criticalExtensions_22 = -1;
static gint ett_lte_rrc_T_criticalExtensionsFuture_22 = -1;
static gint ett_lte_rrc_RRCConnectionRequest_r8_IEs = -1;
static gint ett_lte_rrc_InitialUE_Identity = -1;
static gint ett_lte_rrc_RRCConnectionSetup = -1;
static gint ett_lte_rrc_T_criticalExtensions_23 = -1;
static gint ett_lte_rrc_T_c1_22 = -1;
static gint ett_lte_rrc_T_criticalExtensionsFuture_23 = -1;
static gint ett_lte_rrc_RRCConnectionSetup_r8_IEs = -1;
static gint ett_lte_rrc_RRCConnectionSetup_v8a0_IEs = -1;
static gint ett_lte_rrc_T_nonCriticalExtension_25 = -1;
static gint ett_lte_rrc_RRCConnectionSetupComplete = -1;
static gint ett_lte_rrc_T_criticalExtensions_24 = -1;
static gint ett_lte_rrc_T_c1_23 = -1;
static gint ett_lte_rrc_T_criticalExtensionsFuture_24 = -1;
static gint ett_lte_rrc_RRCConnectionSetupComplete_r8_IEs = -1;
static gint ett_lte_rrc_RRCConnectionSetupComplete_v8a0_IEs = -1;
static gint ett_lte_rrc_RRCConnectionSetupComplete_v1020_IEs = -1;
static gint ett_lte_rrc_T_nonCriticalExtension_26 = -1;
static gint ett_lte_rrc_RegisteredMME = -1;
static gint ett_lte_rrc_SecurityModeCommand = -1;
static gint ett_lte_rrc_T_criticalExtensions_25 = -1;
static gint ett_lte_rrc_T_c1_24 = -1;
static gint ett_lte_rrc_T_criticalExtensionsFuture_25 = -1;
static gint ett_lte_rrc_SecurityModeCommand_r8_IEs = -1;
static gint ett_lte_rrc_SecurityModeCommand_v8a0_IEs = -1;
static gint ett_lte_rrc_T_nonCriticalExtension_27 = -1;
static gint ett_lte_rrc_SecurityConfigSMC = -1;
static gint ett_lte_rrc_SecurityModeComplete = -1;
static gint ett_lte_rrc_T_criticalExtensions_26 = -1;
static gint ett_lte_rrc_T_criticalExtensionsFuture_26 = -1;
static gint ett_lte_rrc_SecurityModeComplete_r8_IEs = -1;
static gint ett_lte_rrc_SecurityModeComplete_v8a0_IEs = -1;
static gint ett_lte_rrc_T_nonCriticalExtension_28 = -1;
static gint ett_lte_rrc_SecurityModeFailure = -1;
static gint ett_lte_rrc_T_criticalExtensions_27 = -1;
static gint ett_lte_rrc_T_criticalExtensionsFuture_27 = -1;
static gint ett_lte_rrc_SecurityModeFailure_r8_IEs = -1;
static gint ett_lte_rrc_SecurityModeFailure_v8a0_IEs = -1;
static gint ett_lte_rrc_T_nonCriticalExtension_29 = -1;
static gint ett_lte_rrc_SystemInformation = -1;
static gint ett_lte_rrc_T_criticalExtensions_28 = -1;
static gint ett_lte_rrc_T_criticalExtensionsFuture_28 = -1;
static gint ett_lte_rrc_SystemInformation_r8_IEs = -1;
static gint ett_lte_rrc_T_sib_TypeAndInfo = -1;
static gint ett_lte_rrc_T_sib_TypeAndInfo_item = -1;
static gint ett_lte_rrc_SystemInformation_v8a0_IEs = -1;
static gint ett_lte_rrc_T_nonCriticalExtension_30 = -1;
static gint ett_lte_rrc_SystemInformationBlockType1 = -1;
static gint ett_lte_rrc_T_cellAccessRelatedInfo = -1;
static gint ett_lte_rrc_T_cellSelectionInfo = -1;
static gint ett_lte_rrc_SystemInformationBlockType1_v890_IEs = -1;
static gint ett_lte_rrc_SystemInformationBlockType1_v920_IEs = -1;
static gint ett_lte_rrc_T_nonCriticalExtension_31 = -1;
static gint ett_lte_rrc_PLMN_IdentityList = -1;
static gint ett_lte_rrc_PLMN_IdentityInfo = -1;
static gint ett_lte_rrc_SchedulingInfoList = -1;
static gint ett_lte_rrc_SchedulingInfo = -1;
static gint ett_lte_rrc_SIB_MappingInfo = -1;
static gint ett_lte_rrc_CellSelectionInfo_v920 = -1;
static gint ett_lte_rrc_UECapabilityEnquiry = -1;
static gint ett_lte_rrc_T_criticalExtensions_29 = -1;
static gint ett_lte_rrc_T_c1_25 = -1;
static gint ett_lte_rrc_T_criticalExtensionsFuture_29 = -1;
static gint ett_lte_rrc_UECapabilityEnquiry_r8_IEs = -1;
static gint ett_lte_rrc_UECapabilityEnquiry_v8a0_IEs = -1;
static gint ett_lte_rrc_T_nonCriticalExtension_32 = -1;
static gint ett_lte_rrc_UE_CapabilityRequest = -1;
static gint ett_lte_rrc_UECapabilityInformation = -1;
static gint ett_lte_rrc_T_criticalExtensions_30 = -1;
static gint ett_lte_rrc_T_c1_26 = -1;
static gint ett_lte_rrc_T_criticalExtensionsFuture_30 = -1;
static gint ett_lte_rrc_UECapabilityInformation_r8_IEs = -1;
static gint ett_lte_rrc_UECapabilityInformation_v8a0_IEs = -1;
static gint ett_lte_rrc_T_nonCriticalExtension_33 = -1;
static gint ett_lte_rrc_UEInformationRequest_r9 = -1;
static gint ett_lte_rrc_T_criticalExtensions_31 = -1;
static gint ett_lte_rrc_T_c1_27 = -1;
static gint ett_lte_rrc_T_criticalExtensionsFuture_31 = -1;
static gint ett_lte_rrc_UEInformationRequest_r9_IEs = -1;
static gint ett_lte_rrc_UEInformationRequest_v930_IEs = -1;
static gint ett_lte_rrc_UEInformationRequest_v1020_IEs = -1;
static gint ett_lte_rrc_T_nonCriticalExtension_34 = -1;
static gint ett_lte_rrc_UEInformationResponse_r9 = -1;
static gint ett_lte_rrc_T_criticalExtensions_32 = -1;
static gint ett_lte_rrc_T_c1_28 = -1;
static gint ett_lte_rrc_T_criticalExtensionsFuture_32 = -1;
static gint ett_lte_rrc_UEInformationResponse_r9_IEs = -1;
static gint ett_lte_rrc_T_rach_Report_r9 = -1;
static gint ett_lte_rrc_UEInformationResponse_v930_IEs = -1;
static gint ett_lte_rrc_UEInformationResponse_v1020_IEs = -1;
static gint ett_lte_rrc_T_nonCriticalExtension_35 = -1;
static gint ett_lte_rrc_RLF_Report_r9 = -1;
static gint ett_lte_rrc_T_measResultLastServCell_r9 = -1;
static gint ett_lte_rrc_T_measResultNeighCells_r9 = -1;
static gint ett_lte_rrc_T_failedPCellId_r10 = -1;
static gint ett_lte_rrc_T_pci_arfcn_r10 = -1;
static gint ett_lte_rrc_MeasResultList2EUTRA_r9 = -1;
static gint ett_lte_rrc_MeasResult2EUTRA_r9 = -1;
static gint ett_lte_rrc_MeasResultList2UTRA_r9 = -1;
static gint ett_lte_rrc_MeasResult2UTRA_r9 = -1;
static gint ett_lte_rrc_MeasResultList2CDMA2000_r9 = -1;
static gint ett_lte_rrc_MeasResult2CDMA2000_r9 = -1;
static gint ett_lte_rrc_LogMeasReport_r10 = -1;
static gint ett_lte_rrc_LogMeasInfoList_r10 = -1;
static gint ett_lte_rrc_LogMeasInfo_r10 = -1;
static gint ett_lte_rrc_T_measResultServCell_r10 = -1;
static gint ett_lte_rrc_T_measResultNeighCells_r10 = -1;
static gint ett_lte_rrc_MeasResultList2GERAN_r10 = -1;
static gint ett_lte_rrc_ULHandoverPreparationTransfer = -1;
static gint ett_lte_rrc_T_criticalExtensions_33 = -1;
static gint ett_lte_rrc_T_c1_29 = -1;
static gint ett_lte_rrc_T_criticalExtensionsFuture_33 = -1;
static gint ett_lte_rrc_ULHandoverPreparationTransfer_r8_IEs = -1;
static gint ett_lte_rrc_ULHandoverPreparationTransfer_v8a0_IEs = -1;
static gint ett_lte_rrc_T_nonCriticalExtension_36 = -1;
static gint ett_lte_rrc_ULInformationTransfer = -1;
static gint ett_lte_rrc_T_criticalExtensions_34 = -1;
static gint ett_lte_rrc_T_c1_30 = -1;
static gint ett_lte_rrc_T_criticalExtensionsFuture_34 = -1;
static gint ett_lte_rrc_ULInformationTransfer_r8_IEs = -1;
static gint ett_lte_rrc_T_dedicatedInfoType_01 = -1;
static gint ett_lte_rrc_ULInformationTransfer_v8a0_IEs = -1;
static gint ett_lte_rrc_T_nonCriticalExtension_37 = -1;
static gint ett_lte_rrc_SystemInformationBlockType2 = -1;
static gint ett_lte_rrc_T_ac_BarringInfo = -1;
static gint ett_lte_rrc_T_freqInfo = -1;
static gint ett_lte_rrc_AC_BarringConfig = -1;
static gint ett_lte_rrc_MBSFN_SubframeConfigList = -1;
static gint ett_lte_rrc_SystemInformationBlockType3 = -1;
static gint ett_lte_rrc_T_cellReselectionInfoCommon = -1;
static gint ett_lte_rrc_T_speedStateReselectionPars = -1;
static gint ett_lte_rrc_T_q_HystSF = -1;
static gint ett_lte_rrc_T_cellReselectionServingFreqInfo = -1;
static gint ett_lte_rrc_T_intraFreqCellReselectionInfo = -1;
static gint ett_lte_rrc_T_s_IntraSearch_v920 = -1;
static gint ett_lte_rrc_T_s_NonIntraSearch_v920 = -1;
static gint ett_lte_rrc_SystemInformationBlockType4 = -1;
static gint ett_lte_rrc_IntraFreqNeighCellList = -1;
static gint ett_lte_rrc_IntraFreqNeighCellInfo = -1;
static gint ett_lte_rrc_IntraFreqBlackCellList = -1;
static gint ett_lte_rrc_SystemInformationBlockType5 = -1;
static gint ett_lte_rrc_InterFreqCarrierFreqList = -1;
static gint ett_lte_rrc_InterFreqCarrierFreqInfo = -1;
static gint ett_lte_rrc_T_threshX_Q_r9 = -1;
static gint ett_lte_rrc_InterFreqNeighCellList = -1;
static gint ett_lte_rrc_InterFreqNeighCellInfo = -1;
static gint ett_lte_rrc_InterFreqBlackCellList = -1;
static gint ett_lte_rrc_SystemInformationBlockType6 = -1;
static gint ett_lte_rrc_CarrierFreqListUTRA_FDD = -1;
static gint ett_lte_rrc_CarrierFreqUTRA_FDD = -1;
static gint ett_lte_rrc_T_threshX_Q_r9_01 = -1;
static gint ett_lte_rrc_CarrierFreqListUTRA_TDD = -1;
static gint ett_lte_rrc_CarrierFreqUTRA_TDD = -1;
static gint ett_lte_rrc_SystemInformationBlockType7 = -1;
static gint ett_lte_rrc_CarrierFreqsInfoListGERAN = -1;
static gint ett_lte_rrc_CarrierFreqsInfoGERAN = -1;
static gint ett_lte_rrc_T_commonInfo = -1;
static gint ett_lte_rrc_SystemInformationBlockType8 = -1;
static gint ett_lte_rrc_T_parametersHRPD = -1;
static gint ett_lte_rrc_T_parameters1XRTT = -1;
static gint ett_lte_rrc_CellReselectionParametersCDMA2000 = -1;
static gint ett_lte_rrc_CellReselectionParametersCDMA2000_v920 = -1;
static gint ett_lte_rrc_NeighCellListCDMA2000 = -1;
static gint ett_lte_rrc_NeighCellCDMA2000 = -1;
static gint ett_lte_rrc_NeighCellsPerBandclassListCDMA2000 = -1;
static gint ett_lte_rrc_NeighCellsPerBandclassCDMA2000 = -1;
static gint ett_lte_rrc_NeighCellListCDMA2000_v920 = -1;
static gint ett_lte_rrc_NeighCellCDMA2000_v920 = -1;
static gint ett_lte_rrc_NeighCellsPerBandclassListCDMA2000_v920 = -1;
static gint ett_lte_rrc_NeighCellsPerBandclassCDMA2000_v920 = -1;
static gint ett_lte_rrc_PhysCellIdListCDMA2000 = -1;
static gint ett_lte_rrc_PhysCellIdListCDMA2000_v920 = -1;
static gint ett_lte_rrc_BandClassListCDMA2000 = -1;
static gint ett_lte_rrc_BandClassInfoCDMA2000 = -1;
static gint ett_lte_rrc_AC_BarringConfig1XRTT_r9 = -1;
static gint ett_lte_rrc_SystemInformationBlockType9 = -1;
static gint ett_lte_rrc_SystemInformationBlockType10 = -1;
static gint ett_lte_rrc_SystemInformationBlockType11 = -1;
static gint ett_lte_rrc_SystemInformationBlockType12_r9 = -1;
static gint ett_lte_rrc_SystemInformationBlockType13_r9 = -1;
static gint ett_lte_rrc_AntennaInfoCommon = -1;
static gint ett_lte_rrc_AntennaInfoDedicated = -1;
static gint ett_lte_rrc_T_codebookSubsetRestriction = -1;
static gint ett_lte_rrc_T_ue_TransmitAntennaSelection = -1;
static gint ett_lte_rrc_AntennaInfoDedicated_v920 = -1;
static gint ett_lte_rrc_T_codebookSubsetRestriction_v920 = -1;
static gint ett_lte_rrc_AntennaInfoDedicated_r10 = -1;
static gint ett_lte_rrc_T_ue_TransmitAntennaSelection_01 = -1;
static gint ett_lte_rrc_AntennaInfoUL_r10 = -1;
static gint ett_lte_rrc_CQI_ReportConfig = -1;
static gint ett_lte_rrc_CQI_ReportConfig_v920 = -1;
static gint ett_lte_rrc_CQI_ReportConfig_r10 = -1;
static gint ett_lte_rrc_T_csi_SubframePatternConfig_r10 = -1;
static gint ett_lte_rrc_T_setup_02 = -1;
static gint ett_lte_rrc_CQI_ReportConfigSCell_r10 = -1;
static gint ett_lte_rrc_CQI_ReportPeriodic = -1;
static gint ett_lte_rrc_T_setup_03 = -1;
static gint ett_lte_rrc_T_cqi_FormatIndicatorPeriodic = -1;
static gint ett_lte_rrc_T_subbandCQI = -1;
static gint ett_lte_rrc_CQI_ReportPeriodic_r10 = -1;
static gint ett_lte_rrc_T_setup_04 = -1;
static gint ett_lte_rrc_T_cqi_FormatIndicatorPeriodic_r10 = -1;
static gint ett_lte_rrc_T_widebandCQI_r10 = -1;
static gint ett_lte_rrc_T_subbandCQI_r10 = -1;
static gint ett_lte_rrc_T_csi_ConfigIndex_r10 = -1;
static gint ett_lte_rrc_T_setup_05 = -1;
static gint ett_lte_rrc_CQI_ReportAperiodic_r10 = -1;
static gint ett_lte_rrc_T_setup_06 = -1;
static gint ett_lte_rrc_T_aperiodicCSI_Trigger_r10 = -1;
static gint ett_lte_rrc_CrossCarrierSchedulingConfig_r10 = -1;
static gint ett_lte_rrc_T_schedulingCellInfo_r10 = -1;
static gint ett_lte_rrc_T_own_r10 = -1;
static gint ett_lte_rrc_T_other_r10 = -1;
static gint ett_lte_rrc_CSI_RS_Config_r10 = -1;
static gint ett_lte_rrc_T_csi_RS_r10 = -1;
static gint ett_lte_rrc_T_setup_07 = -1;
static gint ett_lte_rrc_T_zeroTxPowerCSI_RS_r10 = -1;
static gint ett_lte_rrc_T_setup_08 = -1;
static gint ett_lte_rrc_LogicalChannelConfig = -1;
static gint ett_lte_rrc_T_ul_SpecificParameters = -1;
static gint ett_lte_rrc_MAC_MainConfig = -1;
static gint ett_lte_rrc_T_ul_SCH_Config = -1;
static gint ett_lte_rrc_T_phr_Config = -1;
static gint ett_lte_rrc_T_setup_09 = -1;
static gint ett_lte_rrc_T_mac_MainConfig_v1020 = -1;
static gint ett_lte_rrc_DRX_Config = -1;
static gint ett_lte_rrc_T_setup_10 = -1;
static gint ett_lte_rrc_T_longDRX_CycleStartOffset = -1;
static gint ett_lte_rrc_T_shortDRX = -1;
static gint ett_lte_rrc_PDCP_Config = -1;
static gint ett_lte_rrc_T_rlc_AM = -1;
static gint ett_lte_rrc_T_rlc_UM = -1;
static gint ett_lte_rrc_T_headerCompression = -1;
static gint ett_lte_rrc_T_rohc = -1;
static gint ett_lte_rrc_T_profiles = -1;
static gint ett_lte_rrc_PDSCH_ConfigCommon = -1;
static gint ett_lte_rrc_PDSCH_ConfigDedicated = -1;
static gint ett_lte_rrc_PHICH_Config = -1;
static gint ett_lte_rrc_PhysicalConfigDedicated = -1;
static gint ett_lte_rrc_T_antennaInfo = -1;
static gint ett_lte_rrc_T_antennaInfo_r10 = -1;
static gint ett_lte_rrc_T_additionalSpectrumEmissionCA_r10 = -1;
static gint ett_lte_rrc_T_setup_11 = -1;
static gint ett_lte_rrc_PhysicalConfigDedicatedSCell_r10 = -1;
static gint ett_lte_rrc_T_nonUL_Configuration_r10 = -1;
static gint ett_lte_rrc_T_ul_Configuration_r10 = -1;
static gint ett_lte_rrc_PRACH_ConfigSIB = -1;
static gint ett_lte_rrc_PRACH_Config = -1;
static gint ett_lte_rrc_PRACH_ConfigSCell_r10 = -1;
static gint ett_lte_rrc_PRACH_ConfigInfo = -1;
static gint ett_lte_rrc_PUCCH_ConfigCommon = -1;
static gint ett_lte_rrc_PUCCH_ConfigDedicated = -1;
static gint ett_lte_rrc_T_ackNackRepetition = -1;
static gint ett_lte_rrc_T_setup_12 = -1;
static gint ett_lte_rrc_PUCCH_ConfigDedicated_v1020 = -1;
static gint ett_lte_rrc_T_pucch_Format_r10 = -1;
static gint ett_lte_rrc_T_format3_r10 = -1;
static gint ett_lte_rrc_T_n3PUCCH_AN_List_r10 = -1;
static gint ett_lte_rrc_T_twoAntennaPortActivatedPUCCH_Format3_r10 = -1;
static gint ett_lte_rrc_T_setup_13 = -1;
static gint ett_lte_rrc_T_n3PUCCH_AN_ListP1_r10 = -1;
static gint ett_lte_rrc_T_channelSelection_r10 = -1;
static gint ett_lte_rrc_T_n1PUCCH_AN_CS_r10 = -1;
static gint ett_lte_rrc_T_setup_14 = -1;
static gint ett_lte_rrc_SEQUENCE_SIZE_1_2_OF_N1PUCCH_AN_CS_r10 = -1;
static gint ett_lte_rrc_N1PUCCH_AN_CS_r10 = -1;
static gint ett_lte_rrc_PUSCH_ConfigCommon = -1;
static gint ett_lte_rrc_T_pusch_ConfigBasic = -1;
static gint ett_lte_rrc_PUSCH_ConfigDedicated = -1;
static gint ett_lte_rrc_PUSCH_ConfigDedicated_v1020 = -1;
static gint ett_lte_rrc_T_betaOffsetMC_r10 = -1;
static gint ett_lte_rrc_PUSCH_ConfigDedicatedSCell_r10 = -1;
static gint ett_lte_rrc_UL_ReferenceSignalsPUSCH = -1;
static gint ett_lte_rrc_RACH_ConfigCommon = -1;
static gint ett_lte_rrc_T_preambleInfo = -1;
static gint ett_lte_rrc_T_preamblesGroupAConfig = -1;
static gint ett_lte_rrc_T_powerRampingParameters = -1;
static gint ett_lte_rrc_T_ra_SupervisionInfo = -1;
static gint ett_lte_rrc_RACH_ConfigDedicated = -1;
static gint ett_lte_rrc_RadioResourceConfigCommonSIB = -1;
static gint ett_lte_rrc_RadioResourceConfigCommon = -1;
static gint ett_lte_rrc_RadioResourceConfigCommonSCell_r10 = -1;
static gint ett_lte_rrc_T_nonUL_Configuration_r10_01 = -1;
static gint ett_lte_rrc_T_ul_Configuration_r10_01 = -1;
static gint ett_lte_rrc_T_ul_FreqInfo_r10 = -1;
static gint ett_lte_rrc_BCCH_Config = -1;
static gint ett_lte_rrc_PCCH_Config = -1;
static gint ett_lte_rrc_RadioResourceConfigDedicated = -1;
static gint ett_lte_rrc_T_mac_MainConfig = -1;
static gint ett_lte_rrc_RadioResourceConfigDedicatedSCell_r10 = -1;
static gint ett_lte_rrc_SRB_ToAddModList = -1;
static gint ett_lte_rrc_SRB_ToAddMod = -1;
static gint ett_lte_rrc_T_rlc_Config = -1;
static gint ett_lte_rrc_T_logicalChannelConfig = -1;
static gint ett_lte_rrc_DRB_ToAddModList = -1;
static gint ett_lte_rrc_DRB_ToAddMod = -1;
static gint ett_lte_rrc_DRB_ToReleaseList = -1;
static gint ett_lte_rrc_MeasSubframePatternPCell_r10 = -1;
static gint ett_lte_rrc_RLC_Config = -1;
static gint ett_lte_rrc_T_am = -1;
static gint ett_lte_rrc_T_um_Bi_Directional = -1;
static gint ett_lte_rrc_T_um_Uni_Directional_UL = -1;
static gint ett_lte_rrc_T_um_Uni_Directional_DL = -1;
static gint ett_lte_rrc_UL_AM_RLC = -1;
static gint ett_lte_rrc_DL_AM_RLC = -1;
static gint ett_lte_rrc_UL_UM_RLC = -1;
static gint ett_lte_rrc_DL_UM_RLC = -1;
static gint ett_lte_rrc_RLF_TimersAndConstants_r9 = -1;
static gint ett_lte_rrc_T_setup_15 = -1;
static gint ett_lte_rrc_RN_SubframeConfig_r10 = -1;
static gint ett_lte_rrc_T_subframeConfigPattern_r10 = -1;
static gint ett_lte_rrc_T_rpdcch_Config_r10 = -1;
static gint ett_lte_rrc_T_resourceBlockAssignment_r10 = -1;
static gint ett_lte_rrc_T_type01_r10 = -1;
static gint ett_lte_rrc_T_type2_r10 = -1;
static gint ett_lte_rrc_T_demodulationRS_r10 = -1;
static gint ett_lte_rrc_T_pucch_Config_r10 = -1;
static gint ett_lte_rrc_T_tdd = -1;
static gint ett_lte_rrc_T_channelSelectionMultiplexingBundling = -1;
static gint ett_lte_rrc_T_n1PUCCH_AN_List_r10 = -1;
static gint ett_lte_rrc_T_fallbackForFormat3 = -1;
static gint ett_lte_rrc_T_fdd = -1;
static gint ett_lte_rrc_SchedulingRequestConfig = -1;
static gint ett_lte_rrc_T_setup_16 = -1;
static gint ett_lte_rrc_SchedulingRequestConfig_v1020 = -1;
static gint ett_lte_rrc_SoundingRS_UL_ConfigCommon = -1;
static gint ett_lte_rrc_T_setup_17 = -1;
static gint ett_lte_rrc_SoundingRS_UL_ConfigDedicated = -1;
static gint ett_lte_rrc_T_setup_18 = -1;
static gint ett_lte_rrc_SoundingRS_UL_ConfigDedicated_v1020 = -1;
static gint ett_lte_rrc_SoundingRS_UL_ConfigDedicatedAperiodic_r10 = -1;
static gint ett_lte_rrc_T_setup_19 = -1;
static gint ett_lte_rrc_SEQUENCE_SIZE_1_3_OF_SRS_ConfigAp_r10 = -1;
static gint ett_lte_rrc_T_srs_ActivateAp_r10 = -1;
static gint ett_lte_rrc_T_setup_20 = -1;
static gint ett_lte_rrc_SRS_ConfigAp_r10 = -1;
static gint ett_lte_rrc_SPS_Config = -1;
static gint ett_lte_rrc_SPS_ConfigDL = -1;
static gint ett_lte_rrc_T_setup_21 = -1;
static gint ett_lte_rrc_T_twoAntennaPortActivated_r10 = -1;
static gint ett_lte_rrc_T_setup_22 = -1;
static gint ett_lte_rrc_SPS_ConfigUL = -1;
static gint ett_lte_rrc_T_setup_23 = -1;
static gint ett_lte_rrc_T_p0_Persistent = -1;
static gint ett_lte_rrc_N1PUCCH_AN_PersistentList = -1;
static gint ett_lte_rrc_TDD_Config = -1;
static gint ett_lte_rrc_TPC_PDCCH_Config = -1;
static gint ett_lte_rrc_T_setup_24 = -1;
static gint ett_lte_rrc_TPC_Index = -1;
static gint ett_lte_rrc_UplinkPowerControlCommon = -1;
static gint ett_lte_rrc_UplinkPowerControlCommon_v1020 = -1;
static gint ett_lte_rrc_UplinkPowerControlCommonSCell_r10 = -1;
static gint ett_lte_rrc_UplinkPowerControlDedicated = -1;
static gint ett_lte_rrc_UplinkPowerControlDedicated_v1020 = -1;
static gint ett_lte_rrc_UplinkPowerControlDedicatedSCell_r10 = -1;
static gint ett_lte_rrc_DeltaFList_PUCCH = -1;
static gint ett_lte_rrc_DeltaTxD_OffsetListPUCCH_r10 = -1;
static gint ett_lte_rrc_SecurityAlgorithmConfig = -1;
static gint ett_lte_rrc_CarrierFreqCDMA2000 = -1;
static gint ett_lte_rrc_CarrierFreqGERAN = -1;
static gint ett_lte_rrc_CarrierFreqsGERAN = -1;
static gint ett_lte_rrc_T_followingARFCNs = -1;
static gint ett_lte_rrc_T_equallySpacedARFCNs = -1;
static gint ett_lte_rrc_ExplicitListOfARFCNs = -1;
static gint ett_lte_rrc_CellIndexList = -1;
static gint ett_lte_rrc_CSFB_RegistrationParam1XRTT = -1;
static gint ett_lte_rrc_CSFB_RegistrationParam1XRTT_v920 = -1;
static gint ett_lte_rrc_CellGlobalIdEUTRA = -1;
static gint ett_lte_rrc_CellGlobalIdUTRA = -1;
static gint ett_lte_rrc_CellGlobalIdGERAN = -1;
static gint ett_lte_rrc_CellGlobalIdCDMA2000 = -1;
static gint ett_lte_rrc_MobilityControlInfo = -1;
static gint ett_lte_rrc_CarrierBandwidthEUTRA = -1;
static gint ett_lte_rrc_CarrierFreqEUTRA = -1;
static gint ett_lte_rrc_MobilityStateParameters = -1;
static gint ett_lte_rrc_PhysCellIdRange = -1;
static gint ett_lte_rrc_PhysCellIdRangeUTRA_FDDList_r9 = -1;
static gint ett_lte_rrc_PhysCellIdRangeUTRA_FDD_r9 = -1;
static gint ett_lte_rrc_PhysCellIdGERAN = -1;
static gint ett_lte_rrc_PLMN_Identity = -1;
static gint ett_lte_rrc_MCC = -1;
static gint ett_lte_rrc_MNC = -1;
static gint ett_lte_rrc_PreRegistrationInfoHRPD = -1;
static gint ett_lte_rrc_SecondaryPreRegistrationZoneIdListHRPD = -1;
static gint ett_lte_rrc_SpeedStateScaleFactors = -1;
static gint ett_lte_rrc_SystemInfoListGERAN = -1;
static gint ett_lte_rrc_SystemTimeInfoCDMA2000 = -1;
static gint ett_lte_rrc_T_cdma_SystemTime = -1;
static gint ett_lte_rrc_LocationInfo_r10 = -1;
static gint ett_lte_rrc_T_locationCoordinates_r10 = -1;
static gint ett_lte_rrc_MeasConfig = -1;
static gint ett_lte_rrc_T_speedStatePars = -1;
static gint ett_lte_rrc_T_setup_25 = -1;
static gint ett_lte_rrc_MeasIdToRemoveList = -1;
static gint ett_lte_rrc_MeasObjectToRemoveList = -1;
static gint ett_lte_rrc_ReportConfigToRemoveList = -1;
static gint ett_lte_rrc_MeasGapConfig = -1;
static gint ett_lte_rrc_T_setup_26 = -1;
static gint ett_lte_rrc_T_gapOffset = -1;
static gint ett_lte_rrc_MeasIdToAddModList = -1;
static gint ett_lte_rrc_MeasIdToAddMod = -1;
static gint ett_lte_rrc_MeasObjectCDMA2000 = -1;
static gint ett_lte_rrc_CellsToAddModListCDMA2000 = -1;
static gint ett_lte_rrc_CellsToAddModCDMA2000 = -1;
static gint ett_lte_rrc_MeasObjectEUTRA = -1;
static gint ett_lte_rrc_CellsToAddModList = -1;
static gint ett_lte_rrc_CellsToAddMod = -1;
static gint ett_lte_rrc_BlackCellsToAddModList = -1;
static gint ett_lte_rrc_BlackCellsToAddMod = -1;
static gint ett_lte_rrc_MeasSubframePatternConfigNeigh_r10 = -1;
static gint ett_lte_rrc_T_setup_27 = -1;
static gint ett_lte_rrc_MeasSubframeCellList_r10 = -1;
static gint ett_lte_rrc_MeasObjectGERAN = -1;
static gint ett_lte_rrc_MeasObjectToAddModList = -1;
static gint ett_lte_rrc_MeasObjectToAddMod = -1;
static gint ett_lte_rrc_T_measObject = -1;
static gint ett_lte_rrc_MeasObjectUTRA = -1;
static gint ett_lte_rrc_T_cellsToAddModList = -1;
static gint ett_lte_rrc_T_cellForWhichToReportCGI = -1;
static gint ett_lte_rrc_CellsToAddModListUTRA_FDD = -1;
static gint ett_lte_rrc_CellsToAddModUTRA_FDD = -1;
static gint ett_lte_rrc_CellsToAddModListUTRA_TDD = -1;
static gint ett_lte_rrc_CellsToAddModUTRA_TDD = -1;
static gint ett_lte_rrc_CSG_AllowedReportingCells_r9 = -1;
static gint ett_lte_rrc_MeasResults = -1;
static gint ett_lte_rrc_T_measResultPCell = -1;
static gint ett_lte_rrc_T_measResultNeighCells = -1;
static gint ett_lte_rrc_MeasResultListEUTRA = -1;
static gint ett_lte_rrc_MeasResultEUTRA = -1;
static gint ett_lte_rrc_T_cgi_Info = -1;
static gint ett_lte_rrc_T_measResult = -1;
static gint ett_lte_rrc_MeasResultServFreqList_r10 = -1;
static gint ett_lte_rrc_MeasResultServFreq_r10 = -1;
static gint ett_lte_rrc_T_measResultSCell_r10 = -1;
static gint ett_lte_rrc_T_measResultBestNeighCell_r10 = -1;
static gint ett_lte_rrc_MeasResultListUTRA = -1;
static gint ett_lte_rrc_MeasResultUTRA = -1;
static gint ett_lte_rrc_T_physCellId = -1;
static gint ett_lte_rrc_T_cgi_Info_01 = -1;
static gint ett_lte_rrc_T_measResult_01 = -1;
static gint ett_lte_rrc_MeasResultListGERAN = -1;
static gint ett_lte_rrc_MeasResultGERAN = -1;
static gint ett_lte_rrc_T_cgi_Info_02 = -1;
static gint ett_lte_rrc_T_measResult_02 = -1;
static gint ett_lte_rrc_MeasResultsCDMA2000 = -1;
static gint ett_lte_rrc_MeasResultListCDMA2000 = -1;
static gint ett_lte_rrc_MeasResultCDMA2000 = -1;
static gint ett_lte_rrc_T_measResult_03 = -1;
static gint ett_lte_rrc_MeasResultForECID_r9 = -1;
static gint ett_lte_rrc_PLMN_IdentityList2 = -1;
static gint ett_lte_rrc_AdditionalSI_Info_r9 = -1;
static gint ett_lte_rrc_QuantityConfig = -1;
static gint ett_lte_rrc_QuantityConfigEUTRA = -1;
static gint ett_lte_rrc_QuantityConfigUTRA = -1;
static gint ett_lte_rrc_QuantityConfigUTRA_v1020 = -1;
static gint ett_lte_rrc_QuantityConfigGERAN = -1;
static gint ett_lte_rrc_QuantityConfigCDMA2000 = -1;
static gint ett_lte_rrc_ReportConfigEUTRA = -1;
static gint ett_lte_rrc_T_triggerType = -1;
static gint ett_lte_rrc_T_event = -1;
static gint ett_lte_rrc_T_eventId = -1;
static gint ett_lte_rrc_T_eventA1 = -1;
static gint ett_lte_rrc_T_eventA2 = -1;
static gint ett_lte_rrc_T_eventA3 = -1;
static gint ett_lte_rrc_T_eventA4 = -1;
static gint ett_lte_rrc_T_eventA5 = -1;
static gint ett_lte_rrc_T_eventA6_r10 = -1;
static gint ett_lte_rrc_T_periodical = -1;
static gint ett_lte_rrc_ThresholdEUTRA = -1;
static gint ett_lte_rrc_ReportConfigInterRAT = -1;
static gint ett_lte_rrc_T_triggerType_01 = -1;
static gint ett_lte_rrc_T_event_01 = -1;
static gint ett_lte_rrc_T_eventId_01 = -1;
static gint ett_lte_rrc_T_eventB1 = -1;
static gint ett_lte_rrc_T_b1_Threshold = -1;
static gint ett_lte_rrc_T_eventB2 = -1;
static gint ett_lte_rrc_T_b2_Threshold2 = -1;
static gint ett_lte_rrc_T_periodical_01 = -1;
static gint ett_lte_rrc_ThresholdUTRA = -1;
static gint ett_lte_rrc_ReportConfigToAddModList = -1;
static gint ett_lte_rrc_ReportConfigToAddMod = -1;
static gint ett_lte_rrc_T_reportConfig = -1;
static gint ett_lte_rrc_AreaConfiguration_r10 = -1;
static gint ett_lte_rrc_CellGlobalIdList_r10 = -1;
static gint ett_lte_rrc_TrackingAreaCodeList_r10 = -1;
static gint ett_lte_rrc_MeasSubframePattern_r10 = -1;
static gint ett_lte_rrc_T_subframePatternTDD_r10 = -1;
static gint ett_lte_rrc_OtherConfig_r9 = -1;
static gint ett_lte_rrc_ReportProximityConfig_r9 = -1;
static gint ett_lte_rrc_S_TMSI = -1;
static gint ett_lte_rrc_TraceReference_r10 = -1;
static gint ett_lte_rrc_UE_CapabilityRAT_ContainerList = -1;
static gint ett_lte_rrc_UE_CapabilityRAT_Container = -1;
static gint ett_lte_rrc_UE_EUTRA_Capability = -1;
static gint ett_lte_rrc_T_interRAT_Parameters = -1;
static gint ett_lte_rrc_UE_EUTRA_Capability_v920_IEs = -1;
static gint ett_lte_rrc_UE_EUTRA_Capability_v940_IEs = -1;
static gint ett_lte_rrc_UE_EUTRA_Capability_v9a0_IEs = -1;
static gint ett_lte_rrc_T_nonCriticalExtension_38 = -1;
static gint ett_lte_rrc_UE_EUTRA_Capability_v1020_IEs = -1;
static gint ett_lte_rrc_T_nonCriticalExtension_39 = -1;
static gint ett_lte_rrc_UE_EUTRA_CapabilityAddXDD_Mode_r9 = -1;
static gint ett_lte_rrc_PDCP_Parameters = -1;
static gint ett_lte_rrc_T_supportedROHC_Profiles = -1;
static gint ett_lte_rrc_PhyLayerParameters = -1;
static gint ett_lte_rrc_PhyLayerParameters_v920 = -1;
static gint ett_lte_rrc_PhyLayerParameters_v1020 = -1;
static gint ett_lte_rrc_NonContiguousUL_RA_WithinCC_List_r10 = -1;
static gint ett_lte_rrc_NonContiguousUL_RA_WithinCC_r10 = -1;
static gint ett_lte_rrc_RF_Parameters = -1;
static gint ett_lte_rrc_RF_Parameters_v1020 = -1;
static gint ett_lte_rrc_SupportedBandCombination_r10 = -1;
static gint ett_lte_rrc_BandCombinationParameters_r10 = -1;
static gint ett_lte_rrc_BandParameters_r10 = -1;
static gint ett_lte_rrc_BandParametersUL_r10 = -1;
static gint ett_lte_rrc_CA_MIMO_ParametersUL_r10 = -1;
static gint ett_lte_rrc_BandParametersDL_r10 = -1;
static gint ett_lte_rrc_CA_MIMO_ParametersDL_r10 = -1;
static gint ett_lte_rrc_SupportedBandListEUTRA = -1;
static gint ett_lte_rrc_SupportedBandEUTRA = -1;
static gint ett_lte_rrc_MeasParameters = -1;
static gint ett_lte_rrc_MeasParameters_v1020 = -1;
static gint ett_lte_rrc_BandListEUTRA = -1;
static gint ett_lte_rrc_BandCombinationListEUTRA_r10 = -1;
static gint ett_lte_rrc_BandInfoEUTRA = -1;
static gint ett_lte_rrc_InterFreqBandList = -1;
static gint ett_lte_rrc_InterFreqBandInfo = -1;
static gint ett_lte_rrc_InterRAT_BandList = -1;
static gint ett_lte_rrc_InterRAT_BandInfo = -1;
static gint ett_lte_rrc_IRAT_ParametersUTRA_FDD = -1;
static gint ett_lte_rrc_IRAT_ParametersUTRA_v920 = -1;
static gint ett_lte_rrc_SupportedBandListUTRA_FDD = -1;
static gint ett_lte_rrc_IRAT_ParametersUTRA_TDD128 = -1;
static gint ett_lte_rrc_SupportedBandListUTRA_TDD128 = -1;
static gint ett_lte_rrc_IRAT_ParametersUTRA_TDD384 = -1;
static gint ett_lte_rrc_SupportedBandListUTRA_TDD384 = -1;
static gint ett_lte_rrc_IRAT_ParametersUTRA_TDD768 = -1;
static gint ett_lte_rrc_SupportedBandListUTRA_TDD768 = -1;
static gint ett_lte_rrc_IRAT_ParametersUTRA_TDD_v1020 = -1;
static gint ett_lte_rrc_IRAT_ParametersGERAN = -1;
static gint ett_lte_rrc_IRAT_ParametersGERAN_v920 = -1;
static gint ett_lte_rrc_SupportedBandListGERAN = -1;
static gint ett_lte_rrc_IRAT_ParametersCDMA2000_HRPD = -1;
static gint ett_lte_rrc_SupportedBandListHRPD = -1;
static gint ett_lte_rrc_IRAT_ParametersCDMA2000_1XRTT = -1;
static gint ett_lte_rrc_IRAT_ParametersCDMA2000_1XRTT_v920 = -1;
static gint ett_lte_rrc_IRAT_ParametersCDMA2000_1XRTT_v1020 = -1;
static gint ett_lte_rrc_SupportedBandList1XRTT = -1;
static gint ett_lte_rrc_CSG_ProximityIndicationParameters_r9 = -1;
static gint ett_lte_rrc_NeighCellSI_AcquisitionParameters_r9 = -1;
static gint ett_lte_rrc_SON_Parameters_r9 = -1;
static gint ett_lte_rrc_UE_BasedNetwPerfMeasParameters_r10 = -1;
static gint ett_lte_rrc_UE_TimersAndConstants = -1;
static gint ett_lte_rrc_MBMS_NotificationConfig_r9 = -1;
static gint ett_lte_rrc_MBSFN_AreaInfoList_r9 = -1;
static gint ett_lte_rrc_MBSFN_AreaInfo_r9 = -1;
static gint ett_lte_rrc_T_mcch_Config_r9 = -1;
static gint ett_lte_rrc_MBSFN_SubframeConfig = -1;
static gint ett_lte_rrc_T_subframeAllocation = -1;
static gint ett_lte_rrc_PMCH_InfoList_r9 = -1;
static gint ett_lte_rrc_PMCH_Info_r9 = -1;
static gint ett_lte_rrc_MBMS_SessionInfoList_r9 = -1;
static gint ett_lte_rrc_MBMS_SessionInfo_r9 = -1;
static gint ett_lte_rrc_PMCH_Config_r9 = -1;
static gint ett_lte_rrc_TMGI_r9 = -1;
static gint ett_lte_rrc_T_plmn_Id_r9 = -1;
static gint ett_lte_rrc_HandoverCommand = -1;
static gint ett_lte_rrc_T_criticalExtensions_35 = -1;
static gint ett_lte_rrc_T_c1_31 = -1;
static gint ett_lte_rrc_T_criticalExtensionsFuture_35 = -1;
static gint ett_lte_rrc_HandoverCommand_r8_IEs = -1;
static gint ett_lte_rrc_T_nonCriticalExtension_40 = -1;
static gint ett_lte_rrc_HandoverPreparationInformation = -1;
static gint ett_lte_rrc_T_criticalExtensions_36 = -1;
static gint ett_lte_rrc_T_c1_32 = -1;
static gint ett_lte_rrc_T_criticalExtensionsFuture_36 = -1;
static gint ett_lte_rrc_HandoverPreparationInformation_r8_IEs = -1;
static gint ett_lte_rrc_HandoverPreparationInformation_v920_IEs = -1;
static gint ett_lte_rrc_T_nonCriticalExtension_41 = -1;
static gint ett_lte_rrc_UERadioAccessCapabilityInformation = -1;
static gint ett_lte_rrc_T_criticalExtensions_37 = -1;
static gint ett_lte_rrc_T_c1_33 = -1;
static gint ett_lte_rrc_T_criticalExtensionsFuture_37 = -1;
static gint ett_lte_rrc_UERadioAccessCapabilityInformation_r8_IEs = -1;
static gint ett_lte_rrc_T_nonCriticalExtension_42 = -1;
static gint ett_lte_rrc_AS_Config = -1;
static gint ett_lte_rrc_AS_Context = -1;
static gint ett_lte_rrc_ReestablishmentInfo = -1;
static gint ett_lte_rrc_AdditionalReestabInfoList = -1;
static gint ett_lte_rrc_AdditionalReestabInfo = -1;
static gint ett_lte_rrc_RRM_Config = -1;
static gint ett_lte_rrc_CandidateCellInfoList_r10 = -1;
static gint ett_lte_rrc_CandidateCellInfo_r10 = -1;

/*--- End of included file: packet-lte-rrc-ett.c ---*/
#line 166 "../../asn1/lte-rrc/packet-lte-rrc-template.c"

static gint ett_lte_rrc_featureGroupIndicators = -1;
static gint ett_lte_rrc_featureGroupIndRel9Add = -1;
static gint ett_lte_rrc_featureGroupIndRel10 = -1;
static gint ett_lte_rrc_neighCellConfig = -1;
static gint ett_lte_rrc_absTimeInfo = -1;
static gint ett_lte_rrc_nas_SecurityParam = -1;

/* Forward declarations */
static int dissect_DL_DCCH_Message_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_);
static int dissect_UECapabilityInformation_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_);
int dissect_lte_rrc_UE_EUTRA_Capability_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_);

static const true_false_string lte_rrc_eutra_cap_feat_group_ind_1_val = {
  "Intra-subframe freq hopping for PUSCH scheduled by UL grant; DCI format 3a; PDSCH transmission mode 5; Aperiodic CQI/PMI/RI report on PUSCH: Mode 2-0 & 2-2 - Supported",
  "Intra-subframe freq hopping for PUSCH scheduled by UL grant; DCI format 3a; PDSCH transmission mode 5; Aperiodic CQI/PMI/RI report on PUSCH: Mode 2-0 & 2-2 - Not supported"
};
static const true_false_string lte_rrc_eutra_cap_feat_group_ind_2_val = {
  "Simultaneous CQI & ACK/NACK on PUCCH (format 2a/2b); Absolute TPC command for PUSCH; Resource alloc type 1 for PDSCH; Periodic CQI/PMI/RI report on PUCCH: Mode 2-0 & 2-1 - Supported",
  "Simultaneous CQI & ACK/NACK on PUCCH (format 2a/2b); Absolute TPC command for PUSCH; Resource alloc type 1 for PDSCH; Periodic CQI/PMI/RI report on PUCCH: Mode 2-0 & 2-1 - Not supported"
};
static const true_false_string lte_rrc_eutra_cap_feat_group_ind_3_val = {
  "5bit RLC UM SN; 7bit PDCP SN - Supported",
  "5bit RLC UM SN; 7bit PDCP SN - Not supported"
};
static const true_false_string lte_rrc_eutra_cap_feat_group_ind_4_val = {
  "Short DRX cycle - Supported",
  "Short DRX cycle - Not supported"
};
static const true_false_string lte_rrc_eutra_cap_feat_group_ind_5_val = {
  "Long DRX cycle; DRX command MAC control element - Supported",
  "Long DRX cycle; DRX command MAC control element - Not supported"
};
static const true_false_string lte_rrc_eutra_cap_feat_group_ind_6_val = {
  "Prioritised bit rate - Supported",
  "Prioritised bit rate - Not supported"
};
static const true_false_string lte_rrc_eutra_cap_feat_group_ind_7_val = {
  "RLC UM - Supported",
  "RLC UM - Not supported"
};
static const true_false_string lte_rrc_eutra_cap_feat_group_ind_8_val = {
  "EUTRA RRC_CONNECTED to UTRA CELL_DCH PS handover - Supported",
  "EUTRA RRC_CONNECTED to UTRA CELL_DCH PS handover - Not supported"
};
static const true_false_string lte_rrc_eutra_cap_feat_group_ind_9_val = {
  "EUTRA RRC_CONNECTED to GERAN GSM_Dedicated handover - Supported",
  "EUTRA RRC_CONNECTED to GERAN GSM_Dedicated handover - Not Supported"
};
static const true_false_string lte_rrc_eutra_cap_feat_group_ind_10_val = {
  "EUTRA RRC_CONNECTED to GERAN (Packet_) Idle by Cell Change Order; EUTRA RRC_CONNECTED to GERAN (Packet_) Idle by Cell Change Order with NACC - Supported",
  "EUTRA RRC_CONNECTED to GERAN (Packet_) Idle by Cell Change Order; EUTRA RRC_CONNECTED to GERAN (Packet_) Idle by Cell Change Order with NACC - Not supported"
};
static const true_false_string lte_rrc_eutra_cap_feat_group_ind_11_val = {
  "EUTRA RRC_CONNECTED to CDMA2000 1xRTT CS Active handover - Supported",
  "EUTRA RRC_CONNECTED to CDMA2000 1xRTT CS Active handover - Not supported"
};
static const true_false_string lte_rrc_eutra_cap_feat_group_ind_12_val = {
  "EUTRA RRC_CONNECTED to CDMA2000 HRPD Active handover - Supported",
  "EUTRA RRC_CONNECTED to CDMA2000 HRPD Active handover - Not supported"
};
static const true_false_string lte_rrc_eutra_cap_feat_group_ind_13_val = {
  "Inter-frequency handover (within FDD or TDD) - Supported",
  "Inter-frequency handover (within FDD or TDD) - Not supported"
};
static const true_false_string lte_rrc_eutra_cap_feat_group_ind_14_val = {
  "Measurement reporting event: Event A4 - Neighbour > threshold; Measurement reporting event: Event A5 - Serving < threshold1 & Neighbour > threshold2 - Supported",
  "Measurement reporting event: Event A4 - Neighbour > threshold; Measurement reporting event: Event A5 - Serving < threshold1 & Neighbour > threshold2 - Not supported"
};
static const true_false_string lte_rrc_eutra_cap_feat_group_ind_15_val = {
  "Measurement reporting event: Event B1 - Neighbour > threshold - Supported",
  "Measurement reporting event: Event B1 - Neighbour > threshold - Not supported"
};
static const true_false_string lte_rrc_eutra_cap_feat_group_ind_16_val = {
  "non-ANR related periodical measurement reporting - Supported",
  "non-ANR related periodical measurement reporting - Not supported"
};
static const true_false_string lte_rrc_eutra_cap_feat_group_ind_17_val = {
  "ANR related intra-frequency measurement reporting events - Supported",
  "ANR related intra-frequency measurement reporting events - Not supported"
};
static const true_false_string lte_rrc_eutra_cap_feat_group_ind_18_val = {
  "ANR related inter-frequency measurement reporting events - Supported",
  "ANR related inter-frequency measurement reporting events - Not supported"
};
static const true_false_string lte_rrc_eutra_cap_feat_group_ind_19_val = {
  "ANR related inter-RAT measurement reporting events - Supported",
  "ANR related inter-RAT measurement reporting events - Not supported"
};
static const true_false_string lte_rrc_eutra_cap_feat_group_ind_20_val = {
  "SRB1 and SRB2 for DCCH + 8x AM DRB; SRB1 and SRB2 for DCCH + 5x AM DRB + 3x UM DRB (if indicator 7 is supported) - Supported",
  "SRB1 and SRB2 for DCCH + 8x AM DRB; SRB1 and SRB2 for DCCH + 5x AM DRB + 3x UM DRB (if indicator 7 is supported) - Not supported"
};
static const true_false_string lte_rrc_eutra_cap_feat_group_ind_21_val = {
  "Predefined intra- and inter-subframe frequency hopping for PUSCH with N_sb > 1; Predefined inter-subframe frequency hopping for PUSCH with N_sb > 1 - Supported",
  "Predefined intra- and inter-subframe frequency hopping for PUSCH with N_sb > 1; Predefined inter-subframe frequency hopping for PUSCH with N_sb > 1 - Not supported"
};
static const true_false_string lte_rrc_eutra_cap_feat_group_ind_22_val = {
  "UTRAN measurements, reporting and measurement reporting event B2 in E-UTRA connected mode - Supported",
  "UTRAN measurements, reporting and measurement reporting event B2 in E-UTRA connected mode - Not supported"
};
static const true_false_string lte_rrc_eutra_cap_feat_group_ind_23_val = {
  "GERAN measurements, reporting and measurement reporting event B2 in E-UTRA connected mode - Supported",
  "GERAN measurements, reporting and measurement reporting event B2 in E-UTRA connected mode - Not supported"
};
static const true_false_string lte_rrc_eutra_cap_feat_group_ind_24_val = {
  "1xRTT measurements, reporting and measurement reporting event B2 in E-UTRA connected mode - Supported",
  "1xRTT measurements, reporting and measurement reporting event B2 in E-UTRA connected mode - Not supported"
};
static const true_false_string lte_rrc_eutra_cap_feat_group_ind_25_val = {
  "Inter-frequency measurements and reporting in E-UTRA connected mode - Supported",
  "Inter-frequency measurements and reporting in E-UTRA connected mode - Not supported"
};
static const true_false_string lte_rrc_eutra_cap_feat_group_ind_26_val = {
  "HRPD measurements, reporting and measurement reporting event B2 in E-UTRA connected mode - Supported",
  "HRPD measurements, reporting and measurement reporting event B2 in E-UTRA connected mode - Not supported"
};
static const true_false_string lte_rrc_eutra_cap_feat_group_ind_27_val = {
  "EUTRA RRC_CONNECTED to UTRA CELL_DCH CS handover - Supported",
  "EUTRA RRC_CONNECTED to UTRA CELL_DCH CS handover - Not supported"
};
static const true_false_string lte_rrc_eutra_cap_feat_group_ind_28_val = {
  "TTI bundling - Supported",
  "TTI bundling - Not supported"
};
static const true_false_string lte_rrc_eutra_cap_feat_group_ind_29_val = {
  "Semi-Persistent Scheduling - Supported",
  "Semi-Persistent Scheduling - Not supported"
};
static const true_false_string lte_rrc_eutra_cap_feat_group_ind_30_val = {
  "Handover between FDD and TDD - Supported",
  "Handover between FDD and TDD - Not supported"
};
static const true_false_string lte_rrc_eutra_cap_feat_group_ind_31_val = {
  "Undefined - Supported",
  "Undefined - Not supported"
};
static const true_false_string lte_rrc_eutra_cap_feat_group_ind_32_val = {
  "Undefined - Supported",
  "Undefined - Not supported"
};
static const true_false_string lte_rrc_eutra_cap_feat_group_ind_33_val = {
  "Inter-RAT ANR features for UTRAN - Supported",
  "Inter-RAT ANR features for UTRAN - Not supported"
};
static const true_false_string lte_rrc_eutra_cap_feat_group_ind_34_val = {
  "Inter-RAT ANR features for GERAN - Supported",
  "Inter-RAT ANR features for GERAN - Not supported"
};
static const true_false_string lte_rrc_eutra_cap_feat_group_ind_35_val = {
  "Inter-RAT ANR features for 1xRTT - Supported",
  "Inter-RAT ANR features for 1xRTT - Not supported"
};
static const true_false_string lte_rrc_eutra_cap_feat_group_ind_36_val = {
  "Inter-RAT ANR features for HRPD - Supported",
  "Inter-RAT ANR features for HRPD - Not supported"
};
static const true_false_string lte_rrc_eutra_cap_feat_group_ind_37_val = {
  "Undefined - Supported",
  "Undefined - Not supported"
};
static const true_false_string lte_rrc_eutra_cap_feat_group_ind_38_val = {
  "Undefined - Supported",
  "Undefined - Not supported"
};
static const true_false_string lte_rrc_eutra_cap_feat_group_ind_39_val = {
  "Undefined - Supported",
  "Undefined - Not supported"
};
static const true_false_string lte_rrc_eutra_cap_feat_group_ind_40_val = {
  "Undefined - Supported",
  "Undefined - Not supported"
};
static const true_false_string lte_rrc_eutra_cap_feat_group_ind_41_val = {
  "Undefined - Supported",
  "Undefined - Not supported"
};
static const true_false_string lte_rrc_eutra_cap_feat_group_ind_42_val = {
  "Undefined - Supported",
  "Undefined - Not supported"
};
static const true_false_string lte_rrc_eutra_cap_feat_group_ind_43_val = {
  "Undefined - Supported",
  "Undefined - Not supported"
};
static const true_false_string lte_rrc_eutra_cap_feat_group_ind_44_val = {
  "DCI format 3a; Aperiodic CQI/PMI/RI reporting on PUSCH: Mode 2-0 & 2-2; PUCCH format 2a & 2b; Periodic CQI/PMI/RI reporting on PUCCH: Mode 2-0 & 2-1 - Supported",
  "DCI format 3a; Aperiodic CQI/PMI/RI reporting on PUSCH: Mode 2-0 & 2-2; PUCCH format 2a & 2b; Periodic CQI/PMI/RI reporting on PUCCH: Mode 2-0 & 2-1 - Not supported"
};
static const true_false_string lte_rrc_eutra_cap_feat_group_ind_45_val = {
  "Undefined - Supported",
  "Undefined - Not supported"
};
static const true_false_string lte_rrc_eutra_cap_feat_group_ind_46_val = {
  "Undefined - Supported",
  "Undefined - Not supported"
};
static const true_false_string lte_rrc_eutra_cap_feat_group_ind_47_val = {
  "Undefined - Supported",
  "Undefined - Not supported"
};
static const true_false_string lte_rrc_eutra_cap_feat_group_ind_48_val = {
  "Undefined - Supported",
  "Undefined - Not supported"
};
static const true_false_string lte_rrc_eutra_cap_feat_group_ind_49_val = {
  "Undefined - Supported",
  "Undefined - Not supported"
};
static const true_false_string lte_rrc_eutra_cap_feat_group_ind_50_val = {
  "Undefined - Supported",
  "Undefined - Not supported"
};
static const true_false_string lte_rrc_eutra_cap_feat_group_ind_51_val = {
  "Undefined - Supported",
  "Undefined - Not supported"
};
static const true_false_string lte_rrc_eutra_cap_feat_group_ind_52_val = {
  "Undefined - Supported",
  "Undefined - Not supported"
};
static const true_false_string lte_rrc_eutra_cap_feat_group_ind_53_val = {
  "Undefined - Supported",
  "Undefined - Not supported"
};
static const true_false_string lte_rrc_eutra_cap_feat_group_ind_54_val = {
  "Undefined - Supported",
  "Undefined - Not supported"
};
static const true_false_string lte_rrc_eutra_cap_feat_group_ind_55_val = {
  "Undefined - Supported",
  "Undefined - Not supported"
};
static const true_false_string lte_rrc_eutra_cap_feat_group_ind_56_val = {
  "Undefined - Supported",
  "Undefined - Not supported"
};
static const true_false_string lte_rrc_eutra_cap_feat_group_ind_57_val = {
  "Undefined - Supported",
  "Undefined - Not supported"
};
static const true_false_string lte_rrc_eutra_cap_feat_group_ind_58_val = {
  "Undefined - Supported",
  "Undefined - Not supported"
};
static const true_false_string lte_rrc_eutra_cap_feat_group_ind_59_val = {
  "Undefined - Supported",
  "Undefined - Not supported"
};
static const true_false_string lte_rrc_eutra_cap_feat_group_ind_60_val = {
  "Undefined - Supported",
  "Undefined - Not supported"
};
static const true_false_string lte_rrc_eutra_cap_feat_group_ind_61_val = {
  "Undefined - Supported",
  "Undefined - Not supported"
};
static const true_false_string lte_rrc_eutra_cap_feat_group_ind_62_val = {
  "Undefined - Supported",
  "Undefined - Not supported"
};
static const true_false_string lte_rrc_eutra_cap_feat_group_ind_63_val = {
  "Undefined - Supported",
  "Undefined - Not supported"
};
static const true_false_string lte_rrc_eutra_cap_feat_group_ind_64_val = {
  "Undefined - Supported",
  "Undefined - Not supported"
};
static const true_false_string lte_rrc_eutra_cap_feat_group_ind_101_val = {
  "DMRS with OCC (orthogonal cover code) and SGH (sequence group hopping) disabling - Supported",
  "DMRS with OCC (orthogonal cover code) and SGH (sequence group hopping) disabling - Not supported"
};
static const true_false_string lte_rrc_eutra_cap_feat_group_ind_102_val = {
  "Trigger type 1 SRS (aperiodic SRS) transmission (Up to X ports) - Supported",
  "Trigger type 1 SRS (aperiodic SRS) transmission (Up to X ports) - Not supported"
};
static const true_false_string lte_rrc_eutra_cap_feat_group_ind_103_val = {
  "PDSCH TM9 when up to 4 CSI reference signal ports are configured - Supported",
  "PDSCH TM9 when up to 4 CSI reference signal ports are configured - Not supported"
};
static const true_false_string lte_rrc_eutra_cap_feat_group_ind_104_val = {
  "PDSCH TM9 for TDD when 8 CSI reference signal ports are configured - Supported",
  "PDSCH TM9 for TDD when 8 CSI reference signal ports are configured - Not supported"
};
static const true_false_string lte_rrc_eutra_cap_feat_group_ind_105_val = {
  "PUCCH RM2-0 when PDSCH TM9 is configured and RM2-1 when PDSCH TM9 and up to 4 CSI reference signal ports are configured - Supported",
  "PUCCH RM2-0 when PDSCH TM9 is configured and RM2-1 when PDSCH TM9 and up to 4 CSI reference signal ports are configured - Not supported"
};
static const true_false_string lte_rrc_eutra_cap_feat_group_ind_106_val = {
  "PUCCH RM2-1 when PDSCH TM9 and 8 CSI reference signal ports are configured - Supported",
  "PUCCH RM2-1 when PDSCH TM9 and 8 CSI reference signal ports are configured - Not supported"
};
static const true_false_string lte_rrc_eutra_cap_feat_group_ind_107_val = {
  "PUSCH RM2-0 when PDSCH TM9 is configured and RM2-2 when PDSCH TM9 and up to 4 CSI reference signal ports are configured - Supported",
  "PUSCH RM2-0 when PDSCH TM9 is configured and RM2-2 when PDSCH TM9 and up to 4 CSI reference signal ports are configured - Not supported"
};
static const true_false_string lte_rrc_eutra_cap_feat_group_ind_108_val = {
  "PUSCH RM2-2 when PDSCH TM9 and 8 CSI reference signal ports are configured - Supported",
  "PUSCH RM2-2 when PDSCH TM9 and 8 CSI reference signal ports are configured - Not supported"
};
static const true_false_string lte_rrc_eutra_cap_feat_group_ind_109_val = {
  "PUCCH RM1-1 submode 1 - Supported",
  "PUCCH RM1-1 submode 1 - Not supported"
};
static const true_false_string lte_rrc_eutra_cap_feat_group_ind_110_val = {
  "PUCCH RM1-1 submode 2 - Supported",
  "PUCCH RM1-1 submode 2 - Not supported"
};
static const true_false_string lte_rrc_eutra_cap_feat_group_ind_111_val = {
  "Measurement reporting trigger Event A6 - Supported",
  "Measurement reporting trigger Event A6 - Not supported"
};
static const true_false_string lte_rrc_eutra_cap_feat_group_ind_112_val = {
  "SCell addition within the Handover to EUTRA procedure - Supported",
  "SCell addition within the Handover to EUTRA procedure - Not supported"
};
static const true_false_string lte_rrc_eutra_cap_feat_group_ind_113_val = {
  "Trigger type 0 SRS (periodic SRS) transmission on X Serving Cells - Supported",
  "Trigger type 0 SRS (periodic SRS) transmission on X Serving Cells - Not supported"
};
static const true_false_string lte_rrc_eutra_cap_feat_group_ind_114_val = {
  "Reporting of both UTRA CPICH RSCP and Ec/N0 in a Measurement Report - Supported",
  "Reporting of both UTRA CPICH RSCP and Ec/N0 in a Measurement Report - Not supported"
};
static const true_false_string lte_rrc_eutra_cap_feat_group_ind_115_val = {
  "Time domain ICIC RLM/RRM / ICIC RRM / ICIC CSI measurement sf restriction for the serving cell / neighbour cells - Supported",
  "Time domain ICIC RLM/RRM / ICIC RRM / ICIC CSI measurement sf restriction for the serving cell / neighbour cells - Not supported"
};
static const true_false_string lte_rrc_eutra_cap_feat_group_ind_116_val = {
  "Relative transmit phase continuity for spatial multiplexing in UL - Supported",
  "Relative transmit phase continuity for spatial multiplexing in UL - Not supported"
};
static const true_false_string lte_rrc_eutra_cap_feat_group_ind_117_val = {
  "Undefined - Supported",
  "Undefined - Not supported"
};
static const true_false_string lte_rrc_eutra_cap_feat_group_ind_118_val = {
  "Undefined - Supported",
  "Undefined - Not supported"
};
static const true_false_string lte_rrc_eutra_cap_feat_group_ind_119_val = {
  "Undefined - Supported",
  "Undefined - Not supported"
};
static const true_false_string lte_rrc_eutra_cap_feat_group_ind_120_val = {
  "Undefined - Supported",
  "Undefined - Not supported"
};
static const true_false_string lte_rrc_eutra_cap_feat_group_ind_121_val = {
  "Undefined - Supported",
  "Undefined - Not supported"
};
static const true_false_string lte_rrc_eutra_cap_feat_group_ind_122_val = {
  "Undefined - Supported",
  "Undefined - Not supported"
};
static const true_false_string lte_rrc_eutra_cap_feat_group_ind_123_val = {
  "Undefined - Supported",
  "Undefined - Not supported"
};
static const true_false_string lte_rrc_eutra_cap_feat_group_ind_124_val = {
  "Undefined - Supported",
  "Undefined - Not supported"
};
static const true_false_string lte_rrc_eutra_cap_feat_group_ind_125_val = {
  "Undefined - Supported",
  "Undefined - Not supported"
};
static const true_false_string lte_rrc_eutra_cap_feat_group_ind_126_val = {
  "Undefined - Supported",
  "Undefined - Not supported"
};
static const true_false_string lte_rrc_eutra_cap_feat_group_ind_127_val = {
  "Undefined - Supported",
  "Undefined - Not supported"
};
static const true_false_string lte_rrc_eutra_cap_feat_group_ind_128_val = {
  "Undefined - Supported",
  "Undefined - Not supported"
};
static const true_false_string lte_rrc_eutra_cap_feat_group_ind_129_val = {
  "Undefined - Supported",
  "Undefined - Not supported"
};
static const true_false_string lte_rrc_eutra_cap_feat_group_ind_130_val = {
  "Undefined - Supported",
  "Undefined - Not supported"
};
static const true_false_string lte_rrc_eutra_cap_feat_group_ind_131_val = {
  "Undefined - Supported",
  "Undefined - Not supported"
};
static const true_false_string lte_rrc_eutra_cap_feat_group_ind_132_val = {
  "Undefined - Supported",
  "Undefined - Not supported"
};

static const value_string lte_rrc_q_RxLevMin_vals[] = {
  { -70, "-140dBm"},
  { -69, "-138dBm"},
  { -68, "-136dBm"},
  { -67, "-134dBm"},
  { -66, "-132dBm"},
  { -65, "-130dBm"},
  { -64, "-128dBm"},
  { -63, "-126dBm"},
  { -62, "-124dBm"},
  { -61, "-122dBm"},
  { -60, "-120dBm"},
  { -59, "-118dBm"},
  { -58, "-116dBm"},
  { -57, "-114dBm"},
  { -56, "-112dBm"},
  { -55, "-110dBm"},
  { -54, "-108dBm"},
  { -53, "-106dBm"},
  { -52, "-104dBm"},
  { -51, "-102dBm"},
  { -50, "-100dBm"},
  { -49, "-98dBm"},
  { -48, "-96dBm"},
  { -47, "-94dBm"},
  { -46, "-92dBm"},
  { -45, "-90dBm"},
  { -44, "-88dBm"},
  { -43, "-86dBm"},
  { -42, "-84dBm"},
  { -41, "-82dBm"},
  { -40, "-80dBm"},
  { -39, "-78dBm"},
  { -38, "-76dBm"},
  { -37, "-74dBm"},
  { -36, "-72dBm"},
  { -35, "-70dBm"},
  { -34, "-68dBm"},
  { -33, "-66dBm"},
  { -32, "-64dBm"},
  { -31, "-62dBm"},
  { -30, "-60dBm"},
  { -29, "-58dBm"},
  { -28, "-56dBm"},
  { -27, "-54dBm"},
  { -26, "-52dBm"},
  { -25, "-50dBm"},
  { -24, "-48dBm"},
  { -23, "-46dBm"},
  { -22, "-44dBm"},
  {   0, NULL}
};
static value_string_ext lte_rrc_q_RxLevMin_vals_ext = VALUE_STRING_EXT_INIT(lte_rrc_q_RxLevMin_vals);

static const value_string lte_rrc_q_RxLevMinOffset_vals[] = {
  { 1, "2dB"},
  { 2, "4dB"},
  { 3, "6dB"},
  { 4, "8dB"},
  { 5, "10dB"},
  { 6, "12dB"},
  { 7, "14dB"},
  { 8, "16dB"},
  { 0, NULL}
};

static const value_string lte_rrc_utra_q_RxLevMin_vals[] = {
  { -60, "-119dBm"},
  { -59, "-117dBm"},
  { -58, "-115dBm"},
  { -57, "-113dBm"},
  { -56, "-111dBm"},
  { -55, "-109dBm"},
  { -54, "-107dBm"},
  { -53, "-105dBm"},
  { -52, "-103dBm"},
  { -51, "-101dBm"},
  { -50, "-99dBm"},
  { -49, "-97dBm"},
  { -48, "-95dBm"},
  { -47, "-93dBm"},
  { -46, "-91dBm"},
  { -45, "-89dBm"},
  { -44, "-87dBm"},
  { -43, "-85dBm"},
  { -42, "-83dBm"},
  { -41, "-81dBm"},
  { -40, "-79dBm"},
  { -39, "-77dBm"},
  { -38, "-75dBm"},
  { -37, "-73dBm"},
  { -36, "-71dBm"},
  { -35, "-69dBm"},
  { -34, "-67dBm"},
  { -33, "-65dBm"},
  { -32, "-63dBm"},
  { -31, "-61dBm"},
  { -30, "-59dBm"},
  { -29, "-57dBm"},
  { -28, "-55dBm"},
  { -27, "-53dBm"},
  { -26, "-51dBm"},
  { -25, "-49dBm"},
  { -24, "-47dBm"},
  { -23, "-45dBm"},
  { -22, "-43dBm"},
  { -21, "-41dBm"},
  { -20, "-39dBm"},
  { -19, "-37dBm"},
  { -18, "-35dBm"},
  { -17, "-33dBm"},
  { -16, "-31dBm"},
  { -15, "-29dBm"},
  { -14, "-27dBm"},
  { -13, "-25dBm"},
  {   0, NULL}
};
static value_string_ext lte_rrc_utra_q_RxLevMin_vals_ext = VALUE_STRING_EXT_INIT(lte_rrc_utra_q_RxLevMin_vals);

static const value_string lte_rrc_geran_q_RxLevMin_vals[] = {
  { 0 , "-115dBm"},
  { 1 , "-113dBm"},
  { 2 , "-111dBm"},
  { 3 , "-109dBm"},
  { 4 , "-107dBm"},
  { 5 , "-105dBm"},
  { 6 , "-103dBm"},
  { 7 , "-101dBm"},
  { 8 , "-99dBm"},
  { 9 , "-97dBm"},
  { 10, "-95dBm"},
  { 11, "-93dBm"},
  { 12, "-91dBm"},
  { 13, "-89dBm"},
  { 14, "-87dBm"},
  { 15, "-85dBm"},
  { 16, "-83dBm"},
  { 17, "-81dBm"},
  { 18, "-79dBm"},
  { 19, "-77dBm"},
  { 20, "-75dBm"},
  { 21, "-73dBm"},
  { 22, "-71dBm"},
  { 23, "-69dBm"},
  { 24, "-67dBm"},
  { 25, "-65dBm"},
  { 26, "-63dBm"},
  { 27, "-61dBm"},
  { 28, "-59dBm"},
  { 29, "-57dBm"},
  { 30, "-55dBm"},
  { 31, "-53dBm"},
  { 32, "-51dBm"},
  { 33, "-49dBm"},
  { 34, "-47dBm"},
  { 35, "-45dBm"},
  { 36, "-43dBm"},
  { 37, "-41dBm"},
  { 38, "-39dBm"},
  { 39, "-37dBm"},
  { 40, "-35dBm"},
  { 41, "-33dBm"},
  { 42, "-31dBm"},
  { 43, "-29dBm"},
  { 44, "-27dBm"},
  { 45, "-25dBm"},
  {  0, NULL}
};
static value_string_ext lte_rrc_geran_q_RxLevMin_vals_ext = VALUE_STRING_EXT_INIT(lte_rrc_geran_q_RxLevMin_vals);

static const value_string lte_rrc_nomPDSCH_RS_EPRE_Offset_vals[] = {
  { -1, "-2dB"},
  {  0, "0dB"},
  {  1, "2dB"},
  {  2, "4dB"},
  {  3, "6dB"},
  {  4, "8dB"},
  {  5, "10dB"},
  {  6, "12dB"},
  {  0, NULL}
};

static const value_string lte_rrc_deltaPreambleMsg3_vals[] = {
  { -1, "-2dB"},
  {  0, "0dB"},
  {  1, "2dB"},
  {  2, "4dB"},
  {  3, "6dB"},
  {  4, "8dB"},
  {  5, "10dB"},
  {  6, "12dB"},
  {  0, NULL}
};

static const value_string lte_rrc_ReselectionThreshold_vals[] = {
  { 0 , "0dB"},
  { 1 , "2dB"},
  { 2 , "4dB"},
  { 3 , "6dB"},
  { 4 , "8dB"},
  { 5 , "10dB"},
  { 6 , "12dB"},
  { 7 , "14dB"},
  { 8 , "16dB"},
  { 9 , "18dB"},
  { 10, "20dB"},
  { 11, "22dB"},
  { 12, "24dB"},
  { 13, "26dB"},
  { 14, "28dB"},
  { 15, "30dB"},
  { 16, "32dB"},
  { 17, "34dB"},
  { 18, "36dB"},
  { 19, "38dB"},
  { 20, "40dB"},
  { 21, "42dB"},
  { 22, "44dB"},
  { 23, "46dB"},
  { 24, "48dB"},
  { 25, "50dB"},
  { 26, "52dB"},
  { 27, "54dB"},
  { 28, "56dB"},
  { 29, "58dB"},
  { 30, "60dB"},
  { 31, "62dB"},
  {  0, NULL}
};
static value_string_ext lte_rrc_ReselectionThreshold_vals_ext = VALUE_STRING_EXT_INIT(lte_rrc_ReselectionThreshold_vals);

static const value_string lte_rrc_Hysteresis_vals[] = {
  { 0 , "0dB"},
  { 1 , "0.5dB"},
  { 2 , "1dB"},
  { 3 , "1.5dB"},
  { 4 , "2dB"},
  { 5 , "2.5dB"},
  { 6 , "3dB"},
  { 7 , "3.5dB"},
  { 8 , "4dB"},
  { 9 , "4.5dB"},
  { 10, "5dB"},
  { 11, "5.5dB"},
  { 12, "6dB"},
  { 13, "6.5dB"},
  { 14, "7dB"},
  { 15, "7.5dB"},
  { 16, "8dB"},
  { 17, "8.5dB"},
  { 18, "9dB"},
  { 19, "9.5dB"},
  { 20, "10dB"},
  { 21, "10.5dB"},
  { 22, "11dB"},
  { 23, "11.5dB"},
  { 24, "12dB"},
  { 25, "12.5dB"},
  { 26, "13dB"},
  { 27, "13.5dB"},
  { 28, "14dB"},
  { 29, "14.5dB"},
  { 30, "15dB"},
  {  0, NULL}
};
static value_string_ext lte_rrc_Hysteresis_vals_ext = VALUE_STRING_EXT_INIT(lte_rrc_Hysteresis_vals);

static const value_string lte_rrc_s_Measure_vals[] = {
  {  0, "disabled"},
  {  1, "-139dBm"},
  {  2, "-138dBm"},
  {  3, "-137dBm"},
  {  4, "-136dBm"},
  {  5, "-135dBm"},
  {  6, "-134dBm"},
  {  7, "-133dBm"},
  {  8, "-132dBm"},
  {  9, "-131dBm"},
  { 10, "-130dBm"},
  { 11, "-129dBm"},
  { 12, "-128dBm"},
  { 13, "-127dBm"},
  { 14, "-126dBm"},
  { 15, "-125dBm"},
  { 16, "-124dBm"},
  { 17, "-123dBm"},
  { 18, "-122dBm"},
  { 19, "-121dBm"},
  { 20, "-120dBm"},
  { 21, "-119dBm"},
  { 22, "-118dBm"},
  { 23, "-117dBm"},
  { 24, "-116dBm"},
  { 25, "-115dBm"},
  { 26, "-114dBm"},
  { 27, "-113dBm"},
  { 28, "-112dBm"},
  { 29, "-111dBm"},
  { 30, "-110dBm"},
  { 31, "-109dBm"},
  { 32, "-108dBm"},
  { 33, "-107dBm"},
  { 34, "-106dBm"},
  { 35, "-105dBm"},
  { 36, "-104dBm"},
  { 37, "-103dBm"},
  { 38, "-102dBm"},
  { 39, "-101dBm"},
  { 40, "-100dBm"},
  { 41, "-99dBm"},
  { 42, "-98dBm"},
  { 43, "-97dBm"},
  { 44, "-96dBm"},
  { 45, "-95dBm"},
  { 46, "-94dBm"},
  { 47, "-93dBm"},
  { 48, "-92dBm"},
  { 49, "-91dBm"},
  { 50, "-90dBm"},
  { 51, "-89dBm"},
  { 52, "-88dBm"},
  { 53, "-87dBm"},
  { 54, "-86dBm"},
  { 55, "-85dBm"},
  { 56, "-84dBm"},
  { 57, "-83dBm"},
  { 58, "-82dBm"},
  { 59, "-81dBm"},
  { 60, "-80dBm"},
  { 61, "-79dBm"},
  { 62, "-78dBm"},
  { 63, "-77dBm"},
  { 64, "-76dBm"},
  { 65, "-75dBm"},
  { 66, "-74dBm"},
  { 67, "-73dBm"},
  { 68, "-72dBm"},
  { 69, "-71dBm"},
  { 70, "-70dBm"},
  { 71, "-69dBm"},
  { 72, "-68dBm"},
  { 73, "-67dBm"},
  { 74, "-66dBm"},
  { 75, "-65dBm"},
  { 76, "-64dBm"},
  { 77, "-63dBm"},
  { 78, "-62dBm"},
  { 79, "-61dBm"},
  { 80, "-60dBm"},
  { 81, "-59dBm"},
  { 82, "-58dBm"},
  { 83, "-57dBm"},
  { 84, "-56dBm"},
  { 85, "-55dBm"},
  { 86, "-54dBm"},
  { 87, "-53dBm"},
  { 88, "-52dBm"},
  { 89, "-51dBm"},
  { 90, "-50dBm"},
  { 91, "-49dBm"},
  { 92, "-48dBm"},
  { 93, "-47dBm"},
  { 94, "-46dBm"},
  { 95, "-45dBm"},
  { 96, "-44dBm"},
  { 97, "-43dBm"},
  {  0, NULL}
};
static value_string_ext lte_rrc_s_Measure_vals_ext = VALUE_STRING_EXT_INIT(lte_rrc_s_Measure_vals);

static const value_string lte_rrc_utra_EcN0_vals[] = {
  { 0 , "CPICH Ec/Io < -24dB"},
  { 1 , "-24dB <= CPICH Ec/Io < -23.5dB"},
  { 2 , "-23.5dB <= CPICH Ec/Io < -23dB"},
  { 3 , "-23dB <= CPICH Ec/Io < -22.5dB"},
  { 4 , "-22.5dB <= CPICH Ec/Io < -22dB"},
  { 5 , "-22dB <= CPICH Ec/Io < -21.5dB"},
  { 6 , "-21.5dB <= CPICH Ec/Io < -21dB"},
  { 7 , "-21dB <= CPICH Ec/Io < -20.5dB"},
  { 8 , "-20.5dB <= CPICH Ec/Io < -20dB"},
  { 9 , "-20dB <= CPICH Ec/Io < -19.5dB"},
  { 10, "-19.5dB <= CPICH Ec/Io < -19dB"},
  { 11, "-19dB <= CPICH Ec/Io < -18.5dB"},
  { 12, "-18.5dB <= CPICH Ec/Io < -18dB"},
  { 13, "-18dB <= CPICH Ec/Io < -17.5dB"},
  { 14, "-17.5dB <= CPICH Ec/Io < -17dB"},
  { 15, "-17dB <= CPICH Ec/Io < -16.5dB"},
  { 16, "-16.5dB <= CPICH Ec/Io < -16dB"},
  { 17, "-16dB <= CPICH Ec/Io < -15.5dB"},
  { 18, "-15.5dB <= CPICH Ec/Io < -15dB"},
  { 19, "-15dB <= CPICH Ec/Io < -14.5dB"},
  { 20, "-14.5dB <= CPICH Ec/Io < -14dB"},
  { 21, "-14dB <= CPICH Ec/Io < -13.5dB"},
  { 22, "-13.5dB <= CPICH Ec/Io < -13dB"},
  { 23, "-13dB <= CPICH Ec/Io < -12.5dB"},
  { 24, "-12.5dB <= CPICH Ec/Io < -12dB"},
  { 25, "-12dB <= CPICH Ec/Io < -11.5dB"},
  { 26, "-11.5dB <= CPICH Ec/Io < -11dB"},
  { 27, "-11dB <= CPICH Ec/Io < -10.5dB"},
  { 28, "-10.5dB <= CPICH Ec/Io < -10dB"},
  { 29, "-10dB <= CPICH Ec/Io < -9.5dB"},
  { 30, "-9.5dB <= CPICH Ec/Io < -9dB"},
  { 31, "-9dB <= CPICH Ec/Io < -8.5dB"},
  { 32, "-8.5dB <= CPICH Ec/Io < -8dB"},
  { 33, "-8dB <= CPICH Ec/Io < -7.5dB"},
  { 34, "-7.5dB <= CPICH Ec/Io < -7dB"},
  { 35, "-7dB <= CPICH Ec/Io < -6.5dB"},
  { 36, "-6.5dB <= CPICH Ec/Io < -6dB"},
  { 37, "-6dB <= CPICH Ec/Io < -5.5dB"},
  { 38, "-5.5dB <= CPICH Ec/Io < -5dB"},
  { 39, "-5dB <= CPICH Ec/Io < -4.5dB"},
  { 40, "-4.5dB <= CPICH Ec/Io < -4dB"},
  { 41, "-4dB <= CPICH Ec/Io < -3.5dB"},
  { 42, "-3.5dB <= CPICH Ec/Io < -3dB"},
  { 43, "-3dB <= CPICH Ec/Io < -2.5dB"},
  { 44, "-2.5dB <= CPICH Ec/Io < -2dB"},
  { 45, "-2dB <= CPICH Ec/Io < -1.5dB"},
  { 46, "-1.5dB <= CPICH Ec/Io < -1dB"},
  { 47, "-1dB <= CPICH Ec/Io < -0.5dB"},
  { 48, "-0.5dB <= CPICH Ec/Io < 0dB"},
  { 49, "0dB <= CPICH Ec/Io"},
  {  0, NULL}
};
static value_string_ext lte_rrc_utra_EcN0_vals_ext = VALUE_STRING_EXT_INIT(lte_rrc_utra_EcN0_vals);

static const value_string lte_rrc_utra_RSCP_vals[] = {
  { -5, "RSCP < -120dBm"},
  { -4, "-120dBm <= RSCP < -119dBm"},
  { -3, "-119dBm <= RSCP < -118dBm"},
  { -2, "-118dBm <= RSCP < -117dBm"},
  { -1, "-117dBm <= RSCP < -116dBm"},
  {  0, "-116dBm <= RSCP < -115dBm"},
  {  1, "-115dBm <= RSCP < -114dBm"},
  {  2, "-114dBm <= RSCP < -113dBm"},
  {  3, "-113dBm <= RSCP < -112dBm"},
  {  4, "-112dBm <= RSCP < -111dBm"},
  {  5, "-111dBm <= RSCP < -110dBm"},
  {  6, "-110dBm <= RSCP < -109dBm"},
  {  7, "-109dBm <= RSCP < -108dBm"},
  {  8, "-108dBm <= RSCP < -107dBm"},
  {  9, "-107dBm <= RSCP < -106dBm"},
  { 10, "-106dBm <= RSCP < -105dBm"},
  { 11, "-105dBm <= RSCP < -104dBm"},
  { 12, "-104dBm <= RSCP < -103dBm"},
  { 13, "-103dBm <= RSCP < -102dBm"},
  { 14, "-102dBm <= RSCP < -101dBm"},
  { 15, "-101dBm <= RSCP < -100dBm"},
  { 16, "-100dBm <= RSCP < -99dBm"},
  { 17, "-99dBm <= RSCP < -98dBm"},
  { 18, "-98dBm <= RSCP < -97dBm"},
  { 19, "-97dBm <= RSCP < -96dBm"},
  { 20, "-96dBm <= RSCP < -95dBm"},
  { 21, "-95dBm <= RSCP < -94dBm"},
  { 22, "-94dBm <= RSCP < -93dBm"},
  { 23, "-93dBm <= RSCP < -92dBm"},
  { 24, "-92dBm <= RSCP < -91dBm"},
  { 25, "-91dBm <= RSCP < -90dBm"},
  { 26, "-90dBm <= RSCP < -89dBm"},
  { 27, "-89dBm <= RSCP < -88dBm"},
  { 28, "-88dBm <= RSCP < -87dBm"},
  { 29, "-87dBm <= RSCP < -86dBm"},
  { 30, "-86dBm <= RSCP < -85dBm"},
  { 31, "-85dBm <= RSCP < -84dBm"},
  { 32, "-84dBm <= RSCP < -83dBm"},
  { 33, "-83dBm <= RSCP < -82dBm"},
  { 34, "-82dBm <= RSCP < -81dBm"},
  { 35, "-81dBm <= RSCP < -80dBm"},
  { 36, "-80dBm <= RSCP < -79dBm"},
  { 37, "-79dBm <= RSCP < -78dBm"},
  { 38, "-78dBm <= RSCP < -77dBm"},
  { 39, "-77dBm <= RSCP < -76dBm"},
  { 40, "-76dBm <= RSCP < -75dBm"},
  { 41, "-75dBm <= RSCP < -74dBm"},
  { 42, "-74dBm <= RSCP < -73dBm"},
  { 43, "-73dBm <= RSCP < -72dBm"},
  { 44, "-72dBm <= RSCP < -71dBm"},
  { 45, "-71dBm <= RSCP < -70dBm"},
  { 46, "-70dBm <= RSCP < -69dBm"},
  { 47, "-69dBm <= RSCP < -68dBm"},
  { 48, "-68dBm <= RSCP < -67dBm"},
  { 49, "-67dBm <= RSCP < -66dBm"},
  { 50, "-66dBm <= RSCP < -65dBm"},
  { 51, "-65dBm <= RSCP < -64dBm"},
  { 52, "-64dBm <= RSCP < -63dBm"},
  { 53, "-63dBm <= RSCP < -62dBm"},
  { 54, "-62dBm <= RSCP < -61dBm"},
  { 55, "-61dBm <= RSCP < -60dBm"},
  { 56, "-60dBm <= RSCP < -59dBm"},
  { 57, "-59dBm <= RSCP < -58dBm"},
  { 58, "-58dBm <= RSCP < -57dBm"},
  { 59, "-57dBm <= RSCP < -56dBm"},
  { 60, "-56dBm <= RSCP < -55dBm"},
  { 61, "-55dBm <= RSCP < -54dBm"},
  { 62, "-54dBm <= RSCP < -53dBm"},
  { 63, "-53dBm <= RSCP < -52dBm"},
  { 64, "-52dBm <= RSCP < -51dBm"},
  { 65, "-51dBm <= RSCP < -50dBm"},
  { 66, "-50dBm <= RSCP < -49dBm"},
  { 67, "-49dBm <= RSCP < -48dBm"},
  { 68, "-48dBm <= RSCP < -47dBm"},
  { 69, "-47dBm <= RSCP < -46dBm"},
  { 70, "-46dBm <= RSCP < -45dBm"},
  { 71, "-45dBm <= RSCP < -44dBm"},
  { 72, "-44dBm <= RSCP < -43dBm"},
  { 73, "-43dBm <= RSCP < -42dBm"},
  { 74, "-42dBm <= RSCP < -41dBm"},
  { 75, "-41dBm <= RSCP < -40dBm"},
  { 76, "-40dBm <= RSCP < -39dBm"},
  { 77, "-39dBm <= RSCP < -38dBm"},
  { 78, "-38dBm <= RSCP < -37dBm"},
  { 79, "-37dBm <= RSCP < -36dBm"},
  { 80, "-36dBm <= RSCP < -35dBm"},
  { 81, "-35dBm <= RSCP < -34dBm"},
  { 82, "-34dBm <= RSCP < -33dBm"},
  { 83, "-33dBm <= RSCP < -32dBm"},
  { 84, "-32dBm <= RSCP < -31dBm"},
  { 85, "-31dBm <= RSCP < -30dBm"},
  { 86, "-30dBm <= RSCP < -29dBm"},
  { 87, "-29dBm <= RSCP < -28dBm"},
  { 88, "-28dBm <= RSCP < -27dBm"},
  { 89, "-27dBm <= RSCP < -26dBm"},
  { 90, "-26dBm <= RSCP < -25dBm"},
  { 91, "-25dBm <= RSCP"},
  {  0, NULL}
};
static value_string_ext lte_rrc_utra_RSCP_vals_ext = VALUE_STRING_EXT_INIT(lte_rrc_utra_RSCP_vals);

static const value_string lte_rrc_a3_a6_Offset_vals[] = {
  { -30, "-15dB"},
  { -29, "-14.5dB"},
  { -28, "-14dB"},
  { -27, "-13.5dB"},
  { -26, "-13dB"},
  { -25, "-12.5dB"},
  { -24, "-12dB"},
  { -23, "-11.5dB"},
  { -22, "-11dB"},
  { -21, "-10.5dB"},
  { -20, "-10dB"},
  { -19, "-9.5dB"},
  { -18, "-9dB"},
  { -17, "-8.5dB"},
  { -16, "-8dB"},
  { -15, "-7.5dB"},
  { -14, "-7dB"},
  { -13, "-6.5dB"},
  { -12, "-6dB"},
  { -11, "-5.5dB"},
  { -10, "-5dB"},
  {  -9, "-4.5dB"},
  {  -8, "-4dB"},
  {  -7, "-3.5dB"},
  {  -6, "-3dB"},
  {  -5, "-2.5dB"},
  {  -4, "-2dB"},
  {  -3, "-1.5dB"},
  {  -2, "-1dB"},
  {  -1, "-0.5dB"},
  {   0, "0dB"},
  {   1, "0.5dB"},
  {   2, "1dB"},
  {   3, "1.5dB"},
  {   4, "2dB"},
  {   5, "2.5dB"},
  {   6, "3dB"},
  {   7, "3.5dB"},
  {   8, "4dB"},
  {   9, "4.5dB"},
  {  10, "5dB"},
  {  11, "5.5dB"},
  {  12, "6dB"},
  {  13, "6.5dB"},
  {  14, "7dB"},
  {  15, "7.5dB"},
  {  16, "8dB"},
  {  17, "8.5dB"},
  {  18, "9dB"},
  {  19, "9.5dB"},
  {  20, "10dB"},
  {  21, "10.5dB"},
  {  22, "11dB"},
  {  23, "11.5dB"},
  {  24, "12dB"},
  {  25, "12.5dB"},
  {  26, "13dB"},
  {  27, "13.5dB"},
  {  28, "14dB"},
  {  29, "14.5dB"},
  {  30, "15dB"},
  {  0, NULL}
};
static value_string_ext lte_rrc_a3_a6_Offset_vals_ext = VALUE_STRING_EXT_INIT(lte_rrc_a3_a6_Offset_vals);

static const value_string lte_rrc_threshold_RSRP_vals[] = {
  {  0, "-140dBm"},
  {  1, "-139dBm"},
  {  2, "-138dBm"},
  {  3, "-137dBm"},
  {  4, "-136dBm"},
  {  5, "-135dBm"},
  {  6, "-134dBm"},
  {  7, "-133dBm"},
  {  8, "-132dBm"},
  {  9, "-131dBm"},
  { 10, "-130dBm"},
  { 11, "-129dBm"},
  { 12, "-128dBm"},
  { 13, "-127dBm"},
  { 14, "-126dBm"},
  { 15, "-125dBm"},
  { 16, "-124dBm"},
  { 17, "-123dBm"},
  { 18, "-122dBm"},
  { 19, "-121dBm"},
  { 20, "-120dBm"},
  { 21, "-119dBm"},
  { 22, "-118dBm"},
  { 23, "-117dBm"},
  { 24, "-116dBm"},
  { 25, "-115dBm"},
  { 26, "-114dBm"},
  { 27, "-113dBm"},
  { 28, "-112dBm"},
  { 29, "-111dBm"},
  { 30, "-110dBm"},
  { 31, "-109dBm"},
  { 32, "-108dBm"},
  { 33, "-107dBm"},
  { 34, "-106dBm"},
  { 35, "-105dBm"},
  { 36, "-104dBm"},
  { 37, "-103dBm"},
  { 38, "-102dBm"},
  { 39, "-101dBm"},
  { 40, "-100dBm"},
  { 41, "-99dBm"},
  { 42, "-98dBm"},
  { 43, "-97dBm"},
  { 44, "-96dBm"},
  { 45, "-95dBm"},
  { 46, "-94dBm"},
  { 47, "-93dBm"},
  { 48, "-92dBm"},
  { 49, "-91dBm"},
  { 50, "-90dBm"},
  { 51, "-89dBm"},
  { 52, "-88dBm"},
  { 53, "-87dBm"},
  { 54, "-86dBm"},
  { 55, "-85dBm"},
  { 56, "-84dBm"},
  { 57, "-83dBm"},
  { 58, "-82dBm"},
  { 59, "-81dBm"},
  { 60, "-80dBm"},
  { 61, "-79dBm"},
  { 62, "-78dBm"},
  { 63, "-77dBm"},
  { 64, "-76dBm"},
  { 65, "-75dBm"},
  { 66, "-74dBm"},
  { 67, "-73dBm"},
  { 68, "-72dBm"},
  { 69, "-71dBm"},
  { 70, "-70dBm"},
  { 71, "-69dBm"},
  { 72, "-68dBm"},
  { 73, "-67dBm"},
  { 74, "-66dBm"},
  { 75, "-65dBm"},
  { 76, "-64dBm"},
  { 77, "-63dBm"},
  { 78, "-62dBm"},
  { 79, "-61dBm"},
  { 80, "-60dBm"},
  { 81, "-59dBm"},
  { 82, "-58dBm"},
  { 83, "-57dBm"},
  { 84, "-56dBm"},
  { 85, "-55dBm"},
  { 86, "-54dBm"},
  { 87, "-53dBm"},
  { 88, "-52dBm"},
  { 89, "-51dBm"},
  { 90, "-50dBm"},
  { 91, "-49dBm"},
  { 92, "-48dBm"},
  { 93, "-47dBm"},
  { 94, "-46dBm"},
  { 95, "-45dBm"},
  { 96, "-44dBm"},
  { 97, "-43dBm"},
  {  0, NULL}
};
static value_string_ext lte_rrc_threshold_RSRP_vals_ext = VALUE_STRING_EXT_INIT(lte_rrc_threshold_RSRP_vals);

static const value_string lte_rrc_threshold_RSRQ_vals[] = {
  {  0, "-20dB"},
  {  1, "-19.5dB"},
  {  2, "-19dB"},
  {  3, "-18.5dB"},
  {  4, "-18dB"},
  {  5, "-17.5dB"},
  {  6, "-17dB"},
  {  7, "-16.5dB"},
  {  8, "-16dB"},
  {  9, "-15.5dB"},
  { 10, "-15dB"},
  { 11, "-14.5dB"},
  { 12, "-14dB"},
  { 13, "-13.5dB"},
  { 14, "-13dB"},
  { 15, "-12.5dB"},
  { 16, "-12dB"},
  { 17, "-11.5dB"},
  { 18, "-11dB"},
  { 19, "-10.5dB"},
  { 20, "-10dB"},
  { 21, "-9.5dB"},
  { 22, "-9dB"},
  { 23, "-8.5dB"},
  { 24, "-8dB"},
  { 25, "-7.5dB"},
  { 26, "-7dB"},
  { 27, "-6.5dB"},
  { 28, "-6dB"},
  { 29, "-5.5dB"},
  { 30, "-5dB"},
  { 31, "-4.5dB"},
  { 32, "-4dB"},
  { 33, "-3.5dB"},
  { 34, "-3dB"},
  {  0, NULL}
};
static value_string_ext lte_rrc_threshold_RSRQ_vals_ext = VALUE_STRING_EXT_INIT(lte_rrc_threshold_RSRQ_vals);

static const value_string lte_rrc_thresholdGERAN_vals[] = {
  { 0 , "-110dBm"},
  { 1 , "-109dBm"},
  { 2 , "-108dBm"},
  { 3 , "-107dBm"},
  { 4 , "-106dBm"},
  { 5 , "-105dBm"},
  { 6 , "-104dBm"},
  { 7 , "-103dBm"},
  { 8 , "-102dBm"},
  { 9 , "-101dBm"},
  { 10, "-100dBm"},
  { 11, "-99dBm"},
  { 12, "-98dBm"},
  { 13, "-97dBm"},
  { 14, "-96dBm"},
  { 15, "-95dBm"},
  { 16, "-94dBm"},
  { 17, "-93dBm"},
  { 18, "-92dBm"},
  { 19, "-91dBm"},
  { 20, "-90dBm"},
  { 21, "-89dBm"},
  { 22, "-88dBm"},
  { 23, "-87dBm"},
  { 24, "-86dBm"},
  { 25, "-85dBm"},
  { 26, "-84dBm"},
  { 27, "-83dBm"},
  { 28, "-82dBm"},
  { 29, "-81dBm"},
  { 30, "-80dBm"},
  { 31, "-79dBm"},
  { 32, "-78dBm"},
  { 33, "-77dBm"},
  { 34, "-76dBm"},
  { 35, "-75dBm"},
  { 36, "-74dBm"},
  { 37, "-73dBm"},
  { 38, "-72dBm"},
  { 39, "-71dBm"},
  { 40, "-70dBm"},
  { 41, "-69dBm"},
  { 42, "-68dBm"},
  { 43, "-67dBm"},
  { 44, "-66dBm"},
  { 45, "-65dBm"},
  { 46, "-64dBm"},
  { 47, "-63dBm"},
  { 48, "-62dBm"},
  { 49, "-61dBm"},
  { 50, "-60dBm"},
  { 51, "-59dBm"},
  { 52, "-58dBm"},
  { 53, "-57dBm"},
  { 54, "-56dBm"},
  { 55, "-55dBm"},
  { 56, "-54dBm"},
  { 57, "-53dBm"},
  { 58, "-52dBm"},
  { 59, "-51dBm"},
  { 60, "-50dBm"},
  { 61, "-49dBm"},
  { 62, "-48dBm"},
  { 63, "-47dBm"},
  {  0, NULL}
};
static value_string_ext lte_rrc_thresholdGERAN_vals_ext = VALUE_STRING_EXT_INIT(lte_rrc_thresholdGERAN_vals);

static const value_string lte_rrc_thresholdUTRA_EcN0_vals[] = {
  { 0 , "-24.5dB"},
  { 1 , "-24dB"},
  { 2 , "-23.5dB"},
  { 3 , "-23dB"},
  { 4 , "-22.5dB"},
  { 5 , "-22dB"},
  { 6 , "-21.5dB"},
  { 7 , "-21dB"},
  { 8 , "-20.5dB"},
  { 9 , "-20dB"},
  { 10, "-19.5dB"},
  { 11, "-19dB"},
  { 12, "-18.5dB"},
  { 13, "-18dB"},
  { 14, "-17.5dB"},
  { 15, "-17dB"},
  { 16, "-16.5dB"},
  { 17, "-16dB"},
  { 18, "-15.5dB"},
  { 19, "-15dB"},
  { 20, "-14.5dB"},
  { 21, "-14dB"},
  { 22, "-13.5dB"},
  { 23, "-13dB"},
  { 24, "-12.5dB"},
  { 25, "-12dB"},
  { 26, "-11.5dB"},
  { 27, "-11dB"},
  { 28, "-10.5dB"},
  { 29, "-10dB"},
  { 30, "-9.5dB"},
  { 31, "-9dB"},
  { 32, "-8.5dB"},
  { 33, "-8dB"},
  { 34, "-7.5dB"},
  { 35, "-7dB"},
  { 36, "-6.5dB"},
  { 37, "-6dB"},
  { 38, "-5.5dB"},
  { 39, "-5dB"},
  { 40, "-4.5dB"},
  { 41, "-4dB"},
  { 42, "-3.5dB"},
  { 43, "-3dB"},
  { 44, "-2.5dB"},
  { 45, "-2dB"},
  { 46, "-1.5dB"},
  { 47, "-1dB"},
  { 48, "-0.5dB"},
  { 49, "0dB"},
  {  0, NULL}
};
static value_string_ext lte_rrc_thresholdUTRA_EcN0_vals_ext = VALUE_STRING_EXT_INIT(lte_rrc_thresholdUTRA_EcN0_vals);

static const value_string lte_rrc_thresholdUTRA_RSCP_vals[] = {
  { -5, "-120dBm"},
  { -4, "-119dBm"},
  { -3, "-118dBm"},
  { -2, "-117dBm"},
  { -1, "-116dBm"},
  {  0, "-115dBm"},
  {  1, "-114dBm"},
  {  2, "-113dBm"},
  {  3, "-112dBm"},
  {  4, "-111dBm"},
  {  5, "-110dBm"},
  {  6, "-109dBm"},
  {  7, "-108dBm"},
  {  8, "-107dBm"},
  {  9, "-106dBm"},
  { 10, "-105dBm"},
  { 11, "-104dBm"},
  { 12, "-103dBm"},
  { 13, "-102dBm"},
  { 14, "-101dBm"},
  { 15, "-100dBm"},
  { 16, "-99dBm"},
  { 17, "-98dBm"},
  { 18, "-97dBm"},
  { 19, "-96dBm"},
  { 20, "-95dBm"},
  { 21, "-94dBm"},
  { 22, "-93dBm"},
  { 23, "-92dBm"},
  { 24, "-91dBm"},
  { 25, "-90dBm"},
  { 26, "-89dBm"},
  { 27, "-88dBm"},
  { 28, "-87dBm"},
  { 29, "-86dBm"},
  { 30, "-85dBm"},
  { 31, "-84dBm"},
  { 32, "-83dBm"},
  { 33, "-82dBm"},
  { 34, "-81dBm"},
  { 35, "-80dBm"},
  { 36, "-79dBm"},
  { 37, "-78dBm"},
  { 38, "-77dBm"},
  { 39, "-76dBm"},
  { 40, "-75dBm"},
  { 41, "-74dBm"},
  { 42, "-73dBm"},
  { 43, "-72dBm"},
  { 44, "-71dBm"},
  { 45, "-70dBm"},
  { 46, "-69dBm"},
  { 47, "-68dBm"},
  { 48, "-67dBm"},
  { 49, "-66dBm"},
  { 50, "-65dBm"},
  { 51, "-64dBm"},
  { 52, "-63dBm"},
  { 53, "-62dBm"},
  { 54, "-61dBm"},
  { 55, "-60dBm"},
  { 56, "-59dBm"},
  { 57, "-58dBm"},
  { 58, "-57dBm"},
  { 59, "-56dBm"},
  { 60, "-55dBm"},
  { 61, "-54dBm"},
  { 62, "-53dBm"},
  { 63, "-52dBm"},
  { 64, "-51dBm"},
  { 65, "-50dBm"},
  { 66, "-49dBm"},
  { 67, "-48dBm"},
  { 68, "-47dBm"},
  { 69, "-46dBm"},
  { 70, "-45dBm"},
  { 71, "-44dBm"},
  { 72, "-43dBm"},
  { 73, "-42dBm"},
  { 74, "-41dBm"},
  { 75, "-40dBm"},
  { 76, "-39dBm"},
  { 77, "-38dBm"},
  { 78, "-37dBm"},
  { 79, "-36dBm"},
  { 80, "-35dBm"},
  { 81, "-34dBm"},
  { 82, "-33dBm"},
  { 83, "-32dBm"},
  { 84, "-31dBm"},
  { 85, "-30dBm"},
  { 86, "-29dBm"},
  { 87, "-28dBm"},
  { 88, "-27dBm"},
  { 89, "-26dBm"},
  { 90, "-25dBm"},
  { 91, "-24dBm"},
  {  0, NULL}
};
static value_string_ext lte_rrc_thresholdUTRA_RSCP_vals_ext = VALUE_STRING_EXT_INIT(lte_rrc_thresholdUTRA_RSCP_vals);

static const value_string lte_rrc_RSRP_Range_vals[] = {
  {  0, "RSRP < -140dBm"},
  {  1, "-140dBm <= RSRP < -139dBm"},
  {  2, "-139dBm <= RSRP < -138dBm"},
  {  3, "-138dBm <= RSRP < -137dBm"},
  {  4, "-137dBm <= RSRP < -136dBm"},
  {  5, "-136dBm <= RSRP < -135dBm"},
  {  6, "-135dBm <= RSRP < -134dBm"},
  {  7, "-134dBm <= RSRP < -133dBm"},
  {  8, "-133dBm <= RSRP < -132dBm"},
  {  9, "-132dBm <= RSRP < -131dBm"},
  { 10, "-131dBm <= RSRP < -130dBm"},
  { 11, "-130dBm <= RSRP < -129dBm"},
  { 12, "-129dBm <= RSRP < -128dBm"},
  { 13, "-128dBm <= RSRP < -127dBm"},
  { 14, "-127dBm <= RSRP < -126dBm"},
  { 15, "-126dBm <= RSRP < -125dBm"},
  { 16, "-125dBm <= RSRP < -124dBm"},
  { 17, "-124dBm <= RSRP < -123dBm"},
  { 18, "-123dBm <= RSRP < -122dBm"},
  { 19, "-122dBm <= RSRP < -121dBm"},
  { 20, "-121dBm <= RSRP < -120dBm"},
  { 21, "-120dBm <= RSRP < -119dBm"},
  { 22, "-119dBm <= RSRP < -118dBm"},
  { 23, "-118dBm <= RSRP < -117dBm"},
  { 24, "-117dBm <= RSRP < -116dBm"},
  { 25, "-116dBm <= RSRP < -115dBm"},
  { 26, "-115dBm <= RSRP < -114dBm"},
  { 27, "-114dBm <= RSRP < -113dBm"},
  { 28, "-113dBm <= RSRP < -112dBm"},
  { 29, "-112dBm <= RSRP < -111dBm"},
  { 30, "-111dBm <= RSRP < -110dBm"},
  { 31, "-110dBm <= RSRP < -109dBm"},
  { 32, "-109dBm <= RSRP < -108dBm"},
  { 33, "-108dBm <= RSRP < -107dBm"},
  { 34, "-107dBm <= RSRP < -106dBm"},
  { 35, "-106dBm <= RSRP < -105dBm"},
  { 36, "-105dBm <= RSRP < -104dBm"},
  { 37, "-104dBm <= RSRP < -103dBm"},
  { 38, "-103dBm <= RSRP < -102dBm"},
  { 39, "-102dBm <= RSRP < -101dBm"},
  { 40, "-101dBm <= RSRP < -100dBm"},
  { 41, "-100dBm <= RSRP < -99dBm"},
  { 42, "-99dBm <= RSRP < -98dBm"},
  { 43, "-98dBm <= RSRP < -97dBm"},
  { 44, "-97dBm <= RSRP < -96dBm"},
  { 45, "-96dBm <= RSRP < -95dBm"},
  { 46, "-95dBm <= RSRP < -94dBm"},
  { 47, "-94dBm <= RSRP < -93dBm"},
  { 48, "-93dBm <= RSRP < -92dBm"},
  { 49, "-92dBm <= RSRP < -91dBm"},
  { 50, "-91dBm <= RSRP < -90dBm"},
  { 51, "-90dBm <= RSRP < -89dBm"},
  { 52, "-89dBm <= RSRP < -88dBm"},
  { 53, "-88dBm <= RSRP < -87dBm"},
  { 54, "-87dBm <= RSRP < -86dBm"},
  { 55, "-86dBm <= RSRP < -85dBm"},
  { 56, "-85dBm <= RSRP < -84dBm"},
  { 57, "-84dBm <= RSRP < -83dBm"},
  { 58, "-83dBm <= RSRP < -82dBm"},
  { 59, "-82dBm <= RSRP < -81dBm"},
  { 60, "-81dBm <= RSRP < -80dBm"},
  { 61, "-80dBm <= RSRP < -79dBm"},
  { 62, "-79dBm <= RSRP < -78dBm"},
  { 63, "-78dBm <= RSRP < -77dBm"},
  { 64, "-77dBm <= RSRP < -76dBm"},
  { 65, "-76dBm <= RSRP < -75dBm"},
  { 66, "-75dBm <= RSRP < -74dBm"},
  { 67, "-74dBm <= RSRP < -73dBm"},
  { 68, "-73dBm <= RSRP < -72dBm"},
  { 69, "-72dBm <= RSRP < -71dBm"},
  { 70, "-71dBm <= RSRP < -70dBm"},
  { 71, "-70dBm <= RSRP < -69dBm"},
  { 72, "-69dBm <= RSRP < -68dBm"},
  { 73, "-68dBm <= RSRP < -67dBm"},
  { 74, "-67dBm <= RSRP < -66dBm"},
  { 75, "-66dBm <= RSRP < -65dBm"},
  { 76, "-65dBm <= RSRP < -64dBm"},
  { 77, "-64dBm <= RSRP < -63dBm"},
  { 78, "-63dBm <= RSRP < -62dBm"},
  { 79, "-62dBm <= RSRP < -61dBm"},
  { 80, "-61dBm <= RSRP < -60dBm"},
  { 81, "-60dBm <= RSRP < -59dBm"},
  { 82, "-59dBm <= RSRP < -58dBm"},
  { 83, "-58dBm <= RSRP < -57dBm"},
  { 84, "-57dBm <= RSRP < -56dBm"},
  { 85, "-56dBm <= RSRP < -55dBm"},
  { 86, "-55dBm <= RSRP < -54dBm"},
  { 87, "-54dBm <= RSRP < -53dBm"},
  { 88, "-53dBm <= RSRP < -52dBm"},
  { 89, "-52dBm <= RSRP < -51dBm"},
  { 90, "-51dBm <= RSRP < -50dBm"},
  { 91, "-50dBm <= RSRP < -49dBm"},
  { 92, "-49dBm <= RSRP < -48dBm"},
  { 93, "-48dBm <= RSRP < -47dBm"},
  { 94, "-47dBm <= RSRP < -46dBm"},
  { 95, "-46dBm <= RSRP < -45dBm"},
  { 96, "-45dBm <= RSRP < -44dBm"},
  { 97, "-44dBm <= RSRP"},
  {  0, NULL}
};
static value_string_ext lte_rrc_RSRP_Range_vals_ext = VALUE_STRING_EXT_INIT(lte_rrc_RSRP_Range_vals);

static const value_string lte_rrc_RSRQ_Range_vals[] = {
  {  0, "RSRQ < -19.5dB"},
  {  1, "-19.5dB <= RSRQ < -19dB"},
  {  2, "-19dB <= RSRQ < -18.5dB"},
  {  3, "-18.5dB <= RSRQ < -18dB"},
  {  4, "-18dB <= RSRQ < -17.5dB"},
  {  5, "-17.5dB <= RSRQ < -17dB"},
  {  6, "-17dB <= RSRQ < -16.5dB"},
  {  7, "-16.5dB <= RSRQ < -16dB"},
  {  8, "-16dB <= RSRQ < -15.5dB"},
  {  9, "-15.5dB <= RSRQ < -15dB"},
  { 10, "-15dB <= RSRQ < -14.5dB"},
  { 11, "-14.5dB <= RSRQ < -14dB"},
  { 12, "-14dB <= RSRQ < -13.5dB"},
  { 13, "-13.5dB <= RSRQ < -13dB"},
  { 14, "-13dB <= RSRQ < -12.5dB"},
  { 15, "-12.5dB <= RSRQ < -12dB"},
  { 16, "-12dB <= RSRQ < -11.5dB"},
  { 17, "-11.5dB <= RSRQ < -11dB"},
  { 18, "-11dB <= RSRQ < -10.5dB"},
  { 19, "-10.5dB <= RSRQ < -10dB"},
  { 20, "-10dB <= RSRQ < -9.5dB"},
  { 21, "-9.5dB <= RSRQ < -9dB"},
  { 22, "-9dB <= RSRQ < -8.5dB"},
  { 23, "-8.5dB <= RSRQ < -8dB"},
  { 24, "-8dB <= RSRQ < -7.5dB"},
  { 25, "-7.5dB <= RSRQ < -7dB"},
  { 26, "-7dB <= RSRQ < -6.5dB"},
  { 27, "-6.5dB <= RSRQ < -6dB"},
  { 28, "-6dB <= RSRQ < -5.5dB"},
  { 29, "-5.5dB <= RSRQ < -5dB"},
  { 30, "-5dB <= RSRQ < -4.5dB"},
  { 31, "-4.5dB <= RSRQ < -4dB"},
  { 32, "-4dB <= RSRQ < -3.5dB"},
  { 33, "-3.5dB <= RSRQ < -3dB"},
  { 34, "-3dB <= RSRQ"},
  {  0, NULL}
};
static value_string_ext lte_rrc_RSRQ_Range_vals_ext = VALUE_STRING_EXT_INIT(lte_rrc_RSRQ_Range_vals);

static const true_false_string lte_rrc_duration_val = {
  "indefinite",
  "single"
};


/*--- Included file: packet-lte-rrc-fn.c ---*/
#line 1 "../../asn1/lte-rrc/packet-lte-rrc-fn.c"
/*--- PDUs declarations ---*/
static int dissect_SystemInformationBlockType1_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_);
static int dissect_UE_EUTRA_Capability_v9a0_IEs_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_);
static int dissect_SystemInformationBlockType1_v890_IEs_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_);


static const value_string lte_rrc_T_dl_Bandwidth_vals[] = {
  {   0, "n6" },
  {   1, "n15" },
  {   2, "n25" },
  {   3, "n50" },
  {   4, "n75" },
  {   5, "n100" },
  { 0, NULL }
};


static int
dissect_lte_rrc_T_dl_Bandwidth(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     6, NULL, FALSE, 0, NULL);

  return offset;
}


static const value_string lte_rrc_T_phich_Duration_vals[] = {
  {   0, "normal" },
  {   1, "extended" },
  { 0, NULL }
};


static int
dissect_lte_rrc_T_phich_Duration(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, FALSE, 0, NULL);

  return offset;
}


static const value_string lte_rrc_T_phich_Resource_vals[] = {
  {   0, "oneSixth" },
  {   1, "half" },
  {   2, "one" },
  {   3, "two" },
  { 0, NULL }
};


static int
dissect_lte_rrc_T_phich_Resource(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     4, NULL, FALSE, 0, NULL);

  return offset;
}


static const per_sequence_t PHICH_Config_sequence[] = {
  { &hf_lte_rrc_phich_Duration, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_T_phich_Duration },
  { &hf_lte_rrc_phich_Resource, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_T_phich_Resource },
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_PHICH_Config(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_PHICH_Config, PHICH_Config_sequence);

  return offset;
}



static int
dissect_lte_rrc_BIT_STRING_SIZE_8(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     8, 8, FALSE, NULL);

  return offset;
}



static int
dissect_lte_rrc_BIT_STRING_SIZE_10(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     10, 10, FALSE, NULL);

  return offset;
}


static const per_sequence_t MasterInformationBlock_sequence[] = {
  { &hf_lte_rrc_dl_Bandwidth, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_T_dl_Bandwidth },
  { &hf_lte_rrc_phich_Config, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_PHICH_Config },
  { &hf_lte_rrc_systemFrameNumber, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_BIT_STRING_SIZE_8 },
  { &hf_lte_rrc_spare       , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_BIT_STRING_SIZE_10 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_MasterInformationBlock(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {

col_append_str(actx->pinfo->cinfo, COL_INFO, "MasterInformationBlock ");

  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_MasterInformationBlock, MasterInformationBlock_sequence);

  return offset;
}



static int
dissect_lte_rrc_BCCH_BCH_MessageType(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_lte_rrc_MasterInformationBlock(tvb, offset, actx, tree, hf_index);

  return offset;
}


static const per_sequence_t BCCH_BCH_Message_sequence[] = {
  { &hf_lte_rrc_message     , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_BCCH_BCH_MessageType },
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_BCCH_BCH_Message(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_BCCH_BCH_Message, BCCH_BCH_Message_sequence);

  return offset;
}



static int
dissect_lte_rrc_BOOLEAN(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_boolean(tvb, offset, actx, tree, hf_index, NULL);

  return offset;
}


static const value_string lte_rrc_T_ac_BarringFactor_vals[] = {
  {   0, "p00" },
  {   1, "p05" },
  {   2, "p10" },
  {   3, "p15" },
  {   4, "p20" },
  {   5, "p25" },
  {   6, "p30" },
  {   7, "p40" },
  {   8, "p50" },
  {   9, "p60" },
  {  10, "p70" },
  {  11, "p75" },
  {  12, "p80" },
  {  13, "p85" },
  {  14, "p90" },
  {  15, "p95" },
  { 0, NULL }
};


static int
dissect_lte_rrc_T_ac_BarringFactor(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     16, NULL, FALSE, 0, NULL);

  return offset;
}


static const value_string lte_rrc_T_ac_BarringTime_vals[] = {
  {   0, "s4" },
  {   1, "s8" },
  {   2, "s16" },
  {   3, "s32" },
  {   4, "s64" },
  {   5, "s128" },
  {   6, "s256" },
  {   7, "s512" },
  { 0, NULL }
};


static int
dissect_lte_rrc_T_ac_BarringTime(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     8, NULL, FALSE, 0, NULL);

  return offset;
}



static int
dissect_lte_rrc_BIT_STRING_SIZE_5(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     5, 5, FALSE, NULL);

  return offset;
}


static const per_sequence_t AC_BarringConfig_sequence[] = {
  { &hf_lte_rrc_ac_BarringFactor, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_T_ac_BarringFactor },
  { &hf_lte_rrc_ac_BarringTime, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_T_ac_BarringTime },
  { &hf_lte_rrc_ac_BarringForSpecialAC, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_BIT_STRING_SIZE_5 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_AC_BarringConfig(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_AC_BarringConfig, AC_BarringConfig_sequence);

  return offset;
}


static const per_sequence_t T_ac_BarringInfo_sequence[] = {
  { &hf_lte_rrc_ac_BarringForEmergency, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_BOOLEAN },
  { &hf_lte_rrc_ac_BarringForMO_Signalling, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lte_rrc_AC_BarringConfig },
  { &hf_lte_rrc_ac_BarringForMO_Data, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lte_rrc_AC_BarringConfig },
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_T_ac_BarringInfo(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_T_ac_BarringInfo, T_ac_BarringInfo_sequence);

  return offset;
}


static const value_string lte_rrc_T_numberOfRA_Preambles_vals[] = {
  {   0, "n4" },
  {   1, "n8" },
  {   2, "n12" },
  {   3, "n16" },
  {   4, "n20" },
  {   5, "n24" },
  {   6, "n28" },
  {   7, "n32" },
  {   8, "n36" },
  {   9, "n40" },
  {  10, "n44" },
  {  11, "n48" },
  {  12, "n52" },
  {  13, "n56" },
  {  14, "n60" },
  {  15, "n64" },
  { 0, NULL }
};


static int
dissect_lte_rrc_T_numberOfRA_Preambles(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     16, NULL, FALSE, 0, NULL);

  return offset;
}


static const value_string lte_rrc_T_sizeOfRA_PreamblesGroupA_vals[] = {
  {   0, "n4" },
  {   1, "n8" },
  {   2, "n12" },
  {   3, "n16" },
  {   4, "n20" },
  {   5, "n24" },
  {   6, "n28" },
  {   7, "n32" },
  {   8, "n36" },
  {   9, "n40" },
  {  10, "n44" },
  {  11, "n48" },
  {  12, "n52" },
  {  13, "n56" },
  {  14, "n60" },
  { 0, NULL }
};


static int
dissect_lte_rrc_T_sizeOfRA_PreamblesGroupA(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     15, NULL, FALSE, 0, NULL);

  return offset;
}


static const value_string lte_rrc_T_messageSizeGroupA_vals[] = {
  {   0, "b56" },
  {   1, "b144" },
  {   2, "b208" },
  {   3, "b256" },
  { 0, NULL }
};


static int
dissect_lte_rrc_T_messageSizeGroupA(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     4, NULL, FALSE, 0, NULL);

  return offset;
}


static const value_string lte_rrc_T_messagePowerOffsetGroupB_vals[] = {
  {   0, "minusinfinity" },
  {   1, "dB0" },
  {   2, "dB5" },
  {   3, "dB8" },
  {   4, "dB10" },
  {   5, "dB12" },
  {   6, "dB15" },
  {   7, "dB18" },
  { 0, NULL }
};


static int
dissect_lte_rrc_T_messagePowerOffsetGroupB(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     8, NULL, FALSE, 0, NULL);

  return offset;
}


static const per_sequence_t T_preamblesGroupAConfig_sequence[] = {
  { &hf_lte_rrc_sizeOfRA_PreamblesGroupA, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lte_rrc_T_sizeOfRA_PreamblesGroupA },
  { &hf_lte_rrc_messageSizeGroupA, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lte_rrc_T_messageSizeGroupA },
  { &hf_lte_rrc_messagePowerOffsetGroupB, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lte_rrc_T_messagePowerOffsetGroupB },
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_T_preamblesGroupAConfig(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_T_preamblesGroupAConfig, T_preamblesGroupAConfig_sequence);

  return offset;
}


static const per_sequence_t T_preambleInfo_sequence[] = {
  { &hf_lte_rrc_numberOfRA_Preambles, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_T_numberOfRA_Preambles },
  { &hf_lte_rrc_preamblesGroupAConfig, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lte_rrc_T_preamblesGroupAConfig },
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_T_preambleInfo(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_T_preambleInfo, T_preambleInfo_sequence);

  return offset;
}


static const value_string lte_rrc_T_powerRampingStep_vals[] = {
  {   0, "dB0" },
  {   1, "dB2" },
  {   2, "dB4" },
  {   3, "dB6" },
  { 0, NULL }
};


static int
dissect_lte_rrc_T_powerRampingStep(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     4, NULL, FALSE, 0, NULL);

  return offset;
}


static const value_string lte_rrc_T_preambleInitialReceivedTargetPower_vals[] = {
  {   0, "dBm-120" },
  {   1, "dBm-118" },
  {   2, "dBm-116" },
  {   3, "dBm-114" },
  {   4, "dBm-112" },
  {   5, "dBm-110" },
  {   6, "dBm-108" },
  {   7, "dBm-106" },
  {   8, "dBm-104" },
  {   9, "dBm-102" },
  {  10, "dBm-100" },
  {  11, "dBm-98" },
  {  12, "dBm-96" },
  {  13, "dBm-94" },
  {  14, "dBm-92" },
  {  15, "dBm-90" },
  { 0, NULL }
};


static int
dissect_lte_rrc_T_preambleInitialReceivedTargetPower(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     16, NULL, FALSE, 0, NULL);

  return offset;
}


static const per_sequence_t T_powerRampingParameters_sequence[] = {
  { &hf_lte_rrc_powerRampingStep, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_T_powerRampingStep },
  { &hf_lte_rrc_preambleInitialReceivedTargetPower, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_T_preambleInitialReceivedTargetPower },
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_T_powerRampingParameters(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_T_powerRampingParameters, T_powerRampingParameters_sequence);

  return offset;
}


static const value_string lte_rrc_T_preambleTransMax_vals[] = {
  {   0, "n3" },
  {   1, "n4" },
  {   2, "n5" },
  {   3, "n6" },
  {   4, "n7" },
  {   5, "n8" },
  {   6, "n10" },
  {   7, "n20" },
  {   8, "n50" },
  {   9, "n100" },
  {  10, "n200" },
  { 0, NULL }
};


static int
dissect_lte_rrc_T_preambleTransMax(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     11, NULL, FALSE, 0, NULL);

  return offset;
}


static const value_string lte_rrc_T_ra_ResponseWindowSize_vals[] = {
  {   0, "sf2" },
  {   1, "sf3" },
  {   2, "sf4" },
  {   3, "sf5" },
  {   4, "sf6" },
  {   5, "sf7" },
  {   6, "sf8" },
  {   7, "sf10" },
  { 0, NULL }
};


static int
dissect_lte_rrc_T_ra_ResponseWindowSize(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     8, NULL, FALSE, 0, NULL);

  return offset;
}


static const value_string lte_rrc_T_mac_ContentionResolutionTimer_vals[] = {
  {   0, "sf8" },
  {   1, "sf16" },
  {   2, "sf24" },
  {   3, "sf32" },
  {   4, "sf40" },
  {   5, "sf48" },
  {   6, "sf56" },
  {   7, "sf64" },
  { 0, NULL }
};


static int
dissect_lte_rrc_T_mac_ContentionResolutionTimer(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     8, NULL, FALSE, 0, NULL);

  return offset;
}


static const per_sequence_t T_ra_SupervisionInfo_sequence[] = {
  { &hf_lte_rrc_preambleTransMax, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_T_preambleTransMax },
  { &hf_lte_rrc_ra_ResponseWindowSize, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_T_ra_ResponseWindowSize },
  { &hf_lte_rrc_mac_ContentionResolutionTimer, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_T_mac_ContentionResolutionTimer },
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_T_ra_SupervisionInfo(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_T_ra_SupervisionInfo, T_ra_SupervisionInfo_sequence);

  return offset;
}



static int
dissect_lte_rrc_INTEGER_1_8(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            1U, 8U, NULL, FALSE);

  return offset;
}


static const per_sequence_t RACH_ConfigCommon_sequence[] = {
  { &hf_lte_rrc_preambleInfo, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lte_rrc_T_preambleInfo },
  { &hf_lte_rrc_powerRampingParameters, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lte_rrc_T_powerRampingParameters },
  { &hf_lte_rrc_ra_SupervisionInfo, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lte_rrc_T_ra_SupervisionInfo },
  { &hf_lte_rrc_maxHARQ_Msg3Tx, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lte_rrc_INTEGER_1_8 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_RACH_ConfigCommon(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_RACH_ConfigCommon, RACH_ConfigCommon_sequence);

  return offset;
}


static const value_string lte_rrc_T_modificationPeriodCoeff_vals[] = {
  {   0, "n2" },
  {   1, "n4" },
  {   2, "n8" },
  {   3, "n16" },
  { 0, NULL }
};


static int
dissect_lte_rrc_T_modificationPeriodCoeff(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     4, NULL, FALSE, 0, NULL);

  return offset;
}


static const per_sequence_t BCCH_Config_sequence[] = {
  { &hf_lte_rrc_modificationPeriodCoeff, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_T_modificationPeriodCoeff },
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_BCCH_Config(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_BCCH_Config, BCCH_Config_sequence);

  return offset;
}


static const value_string lte_rrc_T_defaultPagingCycle_vals[] = {
  {   0, "rf32" },
  {   1, "rf64" },
  {   2, "rf128" },
  {   3, "rf256" },
  { 0, NULL }
};


static int
dissect_lte_rrc_T_defaultPagingCycle(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     4, NULL, FALSE, 0, NULL);

  return offset;
}


static const value_string lte_rrc_T_nB_vals[] = {
  {   0, "fourT" },
  {   1, "twoT" },
  {   2, "oneT" },
  {   3, "halfT" },
  {   4, "quarterT" },
  {   5, "oneEighthT" },
  {   6, "oneSixteenthT" },
  {   7, "oneThirtySecondT" },
  { 0, NULL }
};


static int
dissect_lte_rrc_T_nB(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     8, NULL, FALSE, 0, NULL);

  return offset;
}


static const per_sequence_t PCCH_Config_sequence[] = {
  { &hf_lte_rrc_defaultPagingCycle, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_T_defaultPagingCycle },
  { &hf_lte_rrc_nB          , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_T_nB },
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_PCCH_Config(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_PCCH_Config, PCCH_Config_sequence);

  return offset;
}



static int
dissect_lte_rrc_INTEGER_0_837(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 837U, NULL, FALSE);

  return offset;
}



static int
dissect_lte_rrc_INTEGER_0_63(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 63U, NULL, FALSE);

  return offset;
}



static int
dissect_lte_rrc_INTEGER_0_15(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 15U, NULL, FALSE);

  return offset;
}



static int
dissect_lte_rrc_INTEGER_0_94(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 94U, NULL, FALSE);

  return offset;
}


static const per_sequence_t PRACH_ConfigInfo_sequence[] = {
  { &hf_lte_rrc_prach_ConfigIndex, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_INTEGER_0_63 },
  { &hf_lte_rrc_highSpeedFlag, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_BOOLEAN },
  { &hf_lte_rrc_zeroCorrelationZoneConfig, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_INTEGER_0_15 },
  { &hf_lte_rrc_prach_FreqOffset, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_INTEGER_0_94 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_PRACH_ConfigInfo(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_PRACH_ConfigInfo, PRACH_ConfigInfo_sequence);

  return offset;
}


static const per_sequence_t PRACH_ConfigSIB_sequence[] = {
  { &hf_lte_rrc_rootSequenceIndex, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_INTEGER_0_837 },
  { &hf_lte_rrc_prach_ConfigInfo, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_PRACH_ConfigInfo },
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_PRACH_ConfigSIB(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_PRACH_ConfigSIB, PRACH_ConfigSIB_sequence);

  return offset;
}



static int
dissect_lte_rrc_T_referenceSignalPower(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            -60, 50U, NULL, FALSE);

  proto_item_append_text(actx->created_item, "dBm");


  return offset;
}



static int
dissect_lte_rrc_INTEGER_0_3(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 3U, NULL, FALSE);

  return offset;
}


static const per_sequence_t PDSCH_ConfigCommon_sequence[] = {
  { &hf_lte_rrc_referenceSignalPower, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_T_referenceSignalPower },
  { &hf_lte_rrc_p_b         , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_INTEGER_0_3 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_PDSCH_ConfigCommon(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_PDSCH_ConfigCommon, PDSCH_ConfigCommon_sequence);

  return offset;
}



static int
dissect_lte_rrc_INTEGER_1_4(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            1U, 4U, NULL, FALSE);

  return offset;
}


static const value_string lte_rrc_T_hoppingMode_vals[] = {
  {   0, "interSubFrame" },
  {   1, "intraAndInterSubFrame" },
  { 0, NULL }
};


static int
dissect_lte_rrc_T_hoppingMode(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, FALSE, 0, NULL);

  return offset;
}



static int
dissect_lte_rrc_INTEGER_0_98(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 98U, NULL, FALSE);

  return offset;
}


static const per_sequence_t T_pusch_ConfigBasic_sequence[] = {
  { &hf_lte_rrc_n_SB        , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_INTEGER_1_4 },
  { &hf_lte_rrc_hoppingMode , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_T_hoppingMode },
  { &hf_lte_rrc_pusch_HoppingOffset, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_INTEGER_0_98 },
  { &hf_lte_rrc_enable64QAM , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_BOOLEAN },
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_T_pusch_ConfigBasic(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_T_pusch_ConfigBasic, T_pusch_ConfigBasic_sequence);

  return offset;
}



static int
dissect_lte_rrc_INTEGER_0_29(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 29U, NULL, FALSE);

  return offset;
}



static int
dissect_lte_rrc_INTEGER_0_7(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 7U, NULL, FALSE);

  return offset;
}


static const per_sequence_t UL_ReferenceSignalsPUSCH_sequence[] = {
  { &hf_lte_rrc_groupHoppingEnabled, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_BOOLEAN },
  { &hf_lte_rrc_groupAssignmentPUSCH, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_INTEGER_0_29 },
  { &hf_lte_rrc_sequenceHoppingEnabled, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_BOOLEAN },
  { &hf_lte_rrc_cyclicShift , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_INTEGER_0_7 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_UL_ReferenceSignalsPUSCH(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_UL_ReferenceSignalsPUSCH, UL_ReferenceSignalsPUSCH_sequence);

  return offset;
}


static const per_sequence_t PUSCH_ConfigCommon_sequence[] = {
  { &hf_lte_rrc_pusch_ConfigBasic, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_T_pusch_ConfigBasic },
  { &hf_lte_rrc_ul_ReferenceSignalsPUSCH, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_UL_ReferenceSignalsPUSCH },
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_PUSCH_ConfigCommon(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_PUSCH_ConfigCommon, PUSCH_ConfigCommon_sequence);

  return offset;
}


static const value_string lte_rrc_T_deltaPUCCH_Shift_vals[] = {
  {   0, "ds1" },
  {   1, "ds2" },
  {   2, "ds3" },
  { 0, NULL }
};


static int
dissect_lte_rrc_T_deltaPUCCH_Shift(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     3, NULL, FALSE, 0, NULL);

  return offset;
}



static int
dissect_lte_rrc_INTEGER_0_2047(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 2047U, NULL, FALSE);

  return offset;
}


static const per_sequence_t PUCCH_ConfigCommon_sequence[] = {
  { &hf_lte_rrc_deltaPUCCH_Shift, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_T_deltaPUCCH_Shift },
  { &hf_lte_rrc_nRB_CQI     , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_INTEGER_0_98 },
  { &hf_lte_rrc_nCS_AN      , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_INTEGER_0_7 },
  { &hf_lte_rrc_n1PUCCH_AN  , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_INTEGER_0_2047 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_PUCCH_ConfigCommon(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_PUCCH_ConfigCommon, PUCCH_ConfigCommon_sequence);

  return offset;
}



static int
dissect_lte_rrc_NULL(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_null(tvb, offset, actx, tree, hf_index);

  return offset;
}


static const value_string lte_rrc_T_srs_BandwidthConfig_vals[] = {
  {   0, "bw0" },
  {   1, "bw1" },
  {   2, "bw2" },
  {   3, "bw3" },
  {   4, "bw4" },
  {   5, "bw5" },
  {   6, "bw6" },
  {   7, "bw7" },
  { 0, NULL }
};


static int
dissect_lte_rrc_T_srs_BandwidthConfig(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     8, NULL, FALSE, 0, NULL);

  return offset;
}


static const value_string lte_rrc_T_srs_SubframeConfig_vals[] = {
  {   0, "sc0" },
  {   1, "sc1" },
  {   2, "sc2" },
  {   3, "sc3" },
  {   4, "sc4" },
  {   5, "sc5" },
  {   6, "sc6" },
  {   7, "sc7" },
  {   8, "sc8" },
  {   9, "sc9" },
  {  10, "sc10" },
  {  11, "sc11" },
  {  12, "sc12" },
  {  13, "sc13" },
  {  14, "sc14" },
  {  15, "sc15" },
  { 0, NULL }
};


static int
dissect_lte_rrc_T_srs_SubframeConfig(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     16, NULL, FALSE, 0, NULL);

  return offset;
}


static const value_string lte_rrc_T_srs_MaxUpPts_vals[] = {
  {   0, "true" },
  { 0, NULL }
};


static int
dissect_lte_rrc_T_srs_MaxUpPts(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, FALSE, 0, NULL);

  return offset;
}


static const per_sequence_t T_setup_17_sequence[] = {
  { &hf_lte_rrc_srs_BandwidthConfig, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_T_srs_BandwidthConfig },
  { &hf_lte_rrc_srs_SubframeConfig, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_T_srs_SubframeConfig },
  { &hf_lte_rrc_ackNackSRS_SimultaneousTransmission, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_BOOLEAN },
  { &hf_lte_rrc_srs_MaxUpPts, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lte_rrc_T_srs_MaxUpPts },
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_T_setup_17(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_T_setup_17, T_setup_17_sequence);

  return offset;
}


static const value_string lte_rrc_SoundingRS_UL_ConfigCommon_vals[] = {
  {   0, "release" },
  {   1, "setup" },
  { 0, NULL }
};

static const per_choice_t SoundingRS_UL_ConfigCommon_choice[] = {
  {   0, &hf_lte_rrc_release     , ASN1_NO_EXTENSIONS     , dissect_lte_rrc_NULL },
  {   1, &hf_lte_rrc_setup_18    , ASN1_NO_EXTENSIONS     , dissect_lte_rrc_T_setup_17 },
  { 0, NULL, 0, NULL }
};

static int
dissect_lte_rrc_SoundingRS_UL_ConfigCommon(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_lte_rrc_SoundingRS_UL_ConfigCommon, SoundingRS_UL_ConfigCommon_choice,
                                 NULL);

  return offset;
}



static int
dissect_lte_rrc_T_p0_NominalPUSCH(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            -126, 24U, NULL, FALSE);

  proto_item_append_text(actx->created_item, "dBm");


  return offset;
}


static const value_string lte_rrc_T_alpha_vals[] = {
  {   0, "al0" },
  {   1, "al04" },
  {   2, "al05" },
  {   3, "al06" },
  {   4, "al07" },
  {   5, "al08" },
  {   6, "al09" },
  {   7, "al1" },
  { 0, NULL }
};


static int
dissect_lte_rrc_T_alpha(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     8, NULL, FALSE, 0, NULL);

  return offset;
}



static int
dissect_lte_rrc_T_p0_NominalPUCCH(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            -127, -96, NULL, FALSE);

  proto_item_append_text(actx->created_item, "dBm");


  return offset;
}


static const value_string lte_rrc_T_deltaF_PUCCH_Format1_vals[] = {
  {   0, "deltaF-2" },
  {   1, "deltaF0" },
  {   2, "deltaF2" },
  { 0, NULL }
};


static int
dissect_lte_rrc_T_deltaF_PUCCH_Format1(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     3, NULL, FALSE, 0, NULL);

  return offset;
}


static const value_string lte_rrc_T_deltaF_PUCCH_Format1b_vals[] = {
  {   0, "deltaF1" },
  {   1, "deltaF3" },
  {   2, "deltaF5" },
  { 0, NULL }
};


static int
dissect_lte_rrc_T_deltaF_PUCCH_Format1b(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     3, NULL, FALSE, 0, NULL);

  return offset;
}


static const value_string lte_rrc_T_deltaF_PUCCH_Format2_vals[] = {
  {   0, "deltaF-2" },
  {   1, "deltaF0" },
  {   2, "deltaF1" },
  {   3, "deltaF2" },
  { 0, NULL }
};


static int
dissect_lte_rrc_T_deltaF_PUCCH_Format2(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     4, NULL, FALSE, 0, NULL);

  return offset;
}


static const value_string lte_rrc_T_deltaF_PUCCH_Format2a_vals[] = {
  {   0, "deltaF-2" },
  {   1, "deltaF0" },
  {   2, "deltaF2" },
  { 0, NULL }
};


static int
dissect_lte_rrc_T_deltaF_PUCCH_Format2a(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     3, NULL, FALSE, 0, NULL);

  return offset;
}


static const value_string lte_rrc_T_deltaF_PUCCH_Format2b_vals[] = {
  {   0, "deltaF-2" },
  {   1, "deltaF0" },
  {   2, "deltaF2" },
  { 0, NULL }
};


static int
dissect_lte_rrc_T_deltaF_PUCCH_Format2b(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     3, NULL, FALSE, 0, NULL);

  return offset;
}


static const per_sequence_t DeltaFList_PUCCH_sequence[] = {
  { &hf_lte_rrc_deltaF_PUCCH_Format1, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_T_deltaF_PUCCH_Format1 },
  { &hf_lte_rrc_deltaF_PUCCH_Format1b, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_T_deltaF_PUCCH_Format1b },
  { &hf_lte_rrc_deltaF_PUCCH_Format2, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_T_deltaF_PUCCH_Format2 },
  { &hf_lte_rrc_deltaF_PUCCH_Format2a, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_T_deltaF_PUCCH_Format2a },
  { &hf_lte_rrc_deltaF_PUCCH_Format2b, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_T_deltaF_PUCCH_Format2b },
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_DeltaFList_PUCCH(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_DeltaFList_PUCCH, DeltaFList_PUCCH_sequence);

  return offset;
}



static int
dissect_lte_rrc_INTEGER_M1_6(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            -1, 6U, NULL, FALSE);

  return offset;
}


static const per_sequence_t UplinkPowerControlCommon_sequence[] = {
  { &hf_lte_rrc_p0_NominalPUSCH, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_T_p0_NominalPUSCH },
  { &hf_lte_rrc_alpha       , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_T_alpha },
  { &hf_lte_rrc_p0_NominalPUCCH, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_T_p0_NominalPUCCH },
  { &hf_lte_rrc_deltaFList_PUCCH, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_DeltaFList_PUCCH },
  { &hf_lte_rrc_deltaPreambleMsg3, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_INTEGER_M1_6 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_UplinkPowerControlCommon(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_UplinkPowerControlCommon, UplinkPowerControlCommon_sequence);

  return offset;
}


static const value_string lte_rrc_UL_CyclicPrefixLength_vals[] = {
  {   0, "len1" },
  {   1, "len2" },
  { 0, NULL }
};


static int
dissect_lte_rrc_UL_CyclicPrefixLength(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, FALSE, 0, NULL);

  return offset;
}


static const value_string lte_rrc_T_deltaF_PUCCH_Format3_r10_vals[] = {
  {   0, "deltaF-1" },
  {   1, "deltaF0" },
  {   2, "deltaF1" },
  {   3, "deltaF2" },
  {   4, "deltaF3" },
  {   5, "deltaF4" },
  {   6, "deltaF5" },
  {   7, "deltaF6" },
  { 0, NULL }
};


static int
dissect_lte_rrc_T_deltaF_PUCCH_Format3_r10(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     8, NULL, FALSE, 0, NULL);

  return offset;
}


static const value_string lte_rrc_T_deltaF_PUCCH_Format1bCS_r10_vals[] = {
  {   0, "deltaF1" },
  {   1, "deltaF2" },
  {   2, "spare2" },
  {   3, "spare1" },
  { 0, NULL }
};


static int
dissect_lte_rrc_T_deltaF_PUCCH_Format1bCS_r10(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     4, NULL, FALSE, 0, NULL);

  return offset;
}


static const per_sequence_t UplinkPowerControlCommon_v1020_sequence[] = {
  { &hf_lte_rrc_deltaF_PUCCH_Format3_r10, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_T_deltaF_PUCCH_Format3_r10 },
  { &hf_lte_rrc_deltaF_PUCCH_Format1bCS_r10, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_T_deltaF_PUCCH_Format1bCS_r10 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_UplinkPowerControlCommon_v1020(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_UplinkPowerControlCommon_v1020, UplinkPowerControlCommon_v1020_sequence);

  return offset;
}


static const per_sequence_t RadioResourceConfigCommonSIB_eag_1_sequence[] = {
  { &hf_lte_rrc_uplinkPowerControlCommon_v1020, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lte_rrc_UplinkPowerControlCommon_v1020 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_RadioResourceConfigCommonSIB_eag_1(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence_eag(tvb, offset, actx, tree, RadioResourceConfigCommonSIB_eag_1_sequence);

  return offset;
}


static const per_sequence_t RadioResourceConfigCommonSIB_sequence[] = {
  { &hf_lte_rrc_rach_ConfigCommon, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lte_rrc_RACH_ConfigCommon },
  { &hf_lte_rrc_bcch_Config , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lte_rrc_BCCH_Config },
  { &hf_lte_rrc_pcch_Config , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lte_rrc_PCCH_Config },
  { &hf_lte_rrc_prach_Config, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lte_rrc_PRACH_ConfigSIB },
  { &hf_lte_rrc_pdsch_ConfigCommon, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lte_rrc_PDSCH_ConfigCommon },
  { &hf_lte_rrc_pusch_ConfigCommon, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lte_rrc_PUSCH_ConfigCommon },
  { &hf_lte_rrc_pucch_ConfigCommon, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lte_rrc_PUCCH_ConfigCommon },
  { &hf_lte_rrc_soundingRS_UL_ConfigCommon, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lte_rrc_SoundingRS_UL_ConfigCommon },
  { &hf_lte_rrc_uplinkPowerControlCommon, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lte_rrc_UplinkPowerControlCommon },
  { &hf_lte_rrc_ul_CyclicPrefixLength, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lte_rrc_UL_CyclicPrefixLength },
  { &hf_lte_rrc_dummy_eag_field, ASN1_NOT_EXTENSION_ROOT, ASN1_NOT_OPTIONAL, dissect_lte_rrc_RadioResourceConfigCommonSIB_eag_1 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_RadioResourceConfigCommonSIB(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_RadioResourceConfigCommonSIB, RadioResourceConfigCommonSIB_sequence);

  return offset;
}


static const value_string lte_rrc_T_t300_vals[] = {
  {   0, "ms100" },
  {   1, "ms200" },
  {   2, "ms300" },
  {   3, "ms400" },
  {   4, "ms600" },
  {   5, "ms1000" },
  {   6, "ms1500" },
  {   7, "ms2000" },
  { 0, NULL }
};


static int
dissect_lte_rrc_T_t300(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     8, NULL, FALSE, 0, NULL);

  return offset;
}


static const value_string lte_rrc_T_t301_vals[] = {
  {   0, "ms100" },
  {   1, "ms200" },
  {   2, "ms300" },
  {   3, "ms400" },
  {   4, "ms600" },
  {   5, "ms1000" },
  {   6, "ms1500" },
  {   7, "ms2000" },
  { 0, NULL }
};


static int
dissect_lte_rrc_T_t301(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     8, NULL, FALSE, 0, NULL);

  return offset;
}


static const value_string lte_rrc_T_t310_vals[] = {
  {   0, "ms0" },
  {   1, "ms50" },
  {   2, "ms100" },
  {   3, "ms200" },
  {   4, "ms500" },
  {   5, "ms1000" },
  {   6, "ms2000" },
  { 0, NULL }
};


static int
dissect_lte_rrc_T_t310(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     7, NULL, FALSE, 0, NULL);

  return offset;
}


static const value_string lte_rrc_T_n310_vals[] = {
  {   0, "n1" },
  {   1, "n2" },
  {   2, "n3" },
  {   3, "n4" },
  {   4, "n6" },
  {   5, "n8" },
  {   6, "n10" },
  {   7, "n20" },
  { 0, NULL }
};


static int
dissect_lte_rrc_T_n310(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     8, NULL, FALSE, 0, NULL);

  return offset;
}


static const value_string lte_rrc_T_t311_vals[] = {
  {   0, "ms1000" },
  {   1, "ms3000" },
  {   2, "ms5000" },
  {   3, "ms10000" },
  {   4, "ms15000" },
  {   5, "ms20000" },
  {   6, "ms30000" },
  { 0, NULL }
};


static int
dissect_lte_rrc_T_t311(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     7, NULL, FALSE, 0, NULL);

  return offset;
}


static const value_string lte_rrc_T_n311_vals[] = {
  {   0, "n1" },
  {   1, "n2" },
  {   2, "n3" },
  {   3, "n4" },
  {   4, "n5" },
  {   5, "n6" },
  {   6, "n8" },
  {   7, "n10" },
  { 0, NULL }
};


static int
dissect_lte_rrc_T_n311(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     8, NULL, FALSE, 0, NULL);

  return offset;
}


static const per_sequence_t UE_TimersAndConstants_sequence[] = {
  { &hf_lte_rrc_t300        , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lte_rrc_T_t300 },
  { &hf_lte_rrc_t301        , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lte_rrc_T_t301 },
  { &hf_lte_rrc_t310        , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lte_rrc_T_t310 },
  { &hf_lte_rrc_n310        , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lte_rrc_T_n310 },
  { &hf_lte_rrc_t311        , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lte_rrc_T_t311 },
  { &hf_lte_rrc_n311        , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lte_rrc_T_n311 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_UE_TimersAndConstants(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_UE_TimersAndConstants, UE_TimersAndConstants_sequence);

  return offset;
}



static int
dissect_lte_rrc_ARFCN_ValueEUTRA(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, maxEARFCN, NULL, FALSE);

  return offset;
}


static const value_string lte_rrc_T_ul_Bandwidth_vals[] = {
  {   0, "n6" },
  {   1, "n15" },
  {   2, "n25" },
  {   3, "n50" },
  {   4, "n75" },
  {   5, "n100" },
  { 0, NULL }
};


static int
dissect_lte_rrc_T_ul_Bandwidth(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     6, NULL, FALSE, 0, NULL);

  return offset;
}



static int
dissect_lte_rrc_AdditionalSpectrumEmission(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            1U, 32U, NULL, FALSE);

  return offset;
}


static const per_sequence_t T_freqInfo_sequence[] = {
  { &hf_lte_rrc_ul_CarrierFreq, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lte_rrc_ARFCN_ValueEUTRA },
  { &hf_lte_rrc_ul_Bandwidth, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lte_rrc_T_ul_Bandwidth },
  { &hf_lte_rrc_additionalSpectrumEmission, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_AdditionalSpectrumEmission },
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_T_freqInfo(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_T_freqInfo, T_freqInfo_sequence);

  return offset;
}


static const value_string lte_rrc_T_radioframeAllocationPeriod_vals[] = {
  {   0, "n1" },
  {   1, "n2" },
  {   2, "n4" },
  {   3, "n8" },
  {   4, "n16" },
  {   5, "n32" },
  { 0, NULL }
};


static int
dissect_lte_rrc_T_radioframeAllocationPeriod(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     6, NULL, FALSE, 0, NULL);

  return offset;
}



static int
dissect_lte_rrc_BIT_STRING_SIZE_6(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     6, 6, FALSE, NULL);

  return offset;
}



static int
dissect_lte_rrc_BIT_STRING_SIZE_24(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     24, 24, FALSE, NULL);

  return offset;
}


static const value_string lte_rrc_T_subframeAllocation_vals[] = {
  {   0, "oneFrame" },
  {   1, "fourFrames" },
  { 0, NULL }
};

static const per_choice_t T_subframeAllocation_choice[] = {
  {   0, &hf_lte_rrc_oneFrame    , ASN1_NO_EXTENSIONS     , dissect_lte_rrc_BIT_STRING_SIZE_6 },
  {   1, &hf_lte_rrc_fourFrames  , ASN1_NO_EXTENSIONS     , dissect_lte_rrc_BIT_STRING_SIZE_24 },
  { 0, NULL, 0, NULL }
};

static int
dissect_lte_rrc_T_subframeAllocation(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_lte_rrc_T_subframeAllocation, T_subframeAllocation_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t MBSFN_SubframeConfig_sequence[] = {
  { &hf_lte_rrc_radioframeAllocationPeriod, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_T_radioframeAllocationPeriod },
  { &hf_lte_rrc_radioframeAllocationOffset, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_INTEGER_0_7 },
  { &hf_lte_rrc_subframeAllocation, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_T_subframeAllocation },
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_MBSFN_SubframeConfig(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_MBSFN_SubframeConfig, MBSFN_SubframeConfig_sequence);

  return offset;
}


static const per_sequence_t MBSFN_SubframeConfigList_sequence_of[1] = {
  { &hf_lte_rrc_MBSFN_SubframeConfigList_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_MBSFN_SubframeConfig },
};

static int
dissect_lte_rrc_MBSFN_SubframeConfigList(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_lte_rrc_MBSFN_SubframeConfigList, MBSFN_SubframeConfigList_sequence_of,
                                                  1, maxMBSFN_Allocations, FALSE);

  return offset;
}


static const value_string lte_rrc_TimeAlignmentTimer_vals[] = {
  {   0, "sf500" },
  {   1, "sf750" },
  {   2, "sf1280" },
  {   3, "sf1920" },
  {   4, "sf2560" },
  {   5, "sf5120" },
  {   6, "sf10240" },
  {   7, "infinity" },
  { 0, NULL }
};


static int
dissect_lte_rrc_TimeAlignmentTimer(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     8, NULL, FALSE, 0, NULL);

  return offset;
}



static int
dissect_lte_rrc_OCTET_STRING(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_octet_string(tvb, offset, actx, tree, hf_index,
                                       NO_BOUND, NO_BOUND, FALSE, NULL);

  return offset;
}


static const per_sequence_t SystemInformationBlockType2_eag_1_sequence[] = {
  { &hf_lte_rrc_ssac_BarringForMMTEL_Voice_r9, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lte_rrc_AC_BarringConfig },
  { &hf_lte_rrc_ssac_BarringForMMTEL_Video_r9, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lte_rrc_AC_BarringConfig },
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_SystemInformationBlockType2_eag_1(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence_eag(tvb, offset, actx, tree, SystemInformationBlockType2_eag_1_sequence);

  return offset;
}


static const per_sequence_t SystemInformationBlockType2_eag_2_sequence[] = {
  { &hf_lte_rrc_ac_BarringForCSFB_r10, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lte_rrc_AC_BarringConfig },
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_SystemInformationBlockType2_eag_2(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence_eag(tvb, offset, actx, tree, SystemInformationBlockType2_eag_2_sequence);

  return offset;
}


static const per_sequence_t SystemInformationBlockType2_sequence[] = {
  { &hf_lte_rrc_ac_BarringInfo, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lte_rrc_T_ac_BarringInfo },
  { &hf_lte_rrc_radioResourceConfigCommon, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lte_rrc_RadioResourceConfigCommonSIB },
  { &hf_lte_rrc_ue_TimersAndConstants, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lte_rrc_UE_TimersAndConstants },
  { &hf_lte_rrc_freqInfo    , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lte_rrc_T_freqInfo },
  { &hf_lte_rrc_mbsfn_SubframeConfigList, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lte_rrc_MBSFN_SubframeConfigList },
  { &hf_lte_rrc_timeAlignmentTimerCommon, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lte_rrc_TimeAlignmentTimer },
  { &hf_lte_rrc_lateNonCriticalExtension, ASN1_NOT_EXTENSION_ROOT, ASN1_OPTIONAL    , dissect_lte_rrc_OCTET_STRING },
  { &hf_lte_rrc_dummy_eag_field, ASN1_NOT_EXTENSION_ROOT, ASN1_NOT_OPTIONAL, dissect_lte_rrc_SystemInformationBlockType2_eag_1 },
  { &hf_lte_rrc_dummy_eag_field, ASN1_NOT_EXTENSION_ROOT, ASN1_NOT_OPTIONAL, dissect_lte_rrc_SystemInformationBlockType2_eag_2 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_SystemInformationBlockType2(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_SystemInformationBlockType2, SystemInformationBlockType2_sequence);

  return offset;
}


static const value_string lte_rrc_T_q_Hyst_vals[] = {
  {   0, "dB0" },
  {   1, "dB1" },
  {   2, "dB2" },
  {   3, "dB3" },
  {   4, "dB4" },
  {   5, "dB5" },
  {   6, "dB6" },
  {   7, "dB8" },
  {   8, "dB10" },
  {   9, "dB12" },
  {  10, "dB14" },
  {  11, "dB16" },
  {  12, "dB18" },
  {  13, "dB20" },
  {  14, "dB22" },
  {  15, "dB24" },
  { 0, NULL }
};


static int
dissect_lte_rrc_T_q_Hyst(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     16, NULL, FALSE, 0, NULL);

  return offset;
}


static const value_string lte_rrc_T_t_Evaluation_vals[] = {
  {   0, "s30" },
  {   1, "s60" },
  {   2, "s120" },
  {   3, "s180" },
  {   4, "s240" },
  {   5, "spare3" },
  {   6, "spare2" },
  {   7, "spare1" },
  { 0, NULL }
};


static int
dissect_lte_rrc_T_t_Evaluation(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     8, NULL, FALSE, 0, NULL);

  return offset;
}


static const value_string lte_rrc_T_t_HystNormal_vals[] = {
  {   0, "s30" },
  {   1, "s60" },
  {   2, "s120" },
  {   3, "s180" },
  {   4, "s240" },
  {   5, "spare3" },
  {   6, "spare2" },
  {   7, "spare1" },
  { 0, NULL }
};


static int
dissect_lte_rrc_T_t_HystNormal(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     8, NULL, FALSE, 0, NULL);

  return offset;
}



static int
dissect_lte_rrc_INTEGER_1_16(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            1U, 16U, NULL, FALSE);

  return offset;
}


static const per_sequence_t MobilityStateParameters_sequence[] = {
  { &hf_lte_rrc_t_Evaluation, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_T_t_Evaluation },
  { &hf_lte_rrc_t_HystNormal, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_T_t_HystNormal },
  { &hf_lte_rrc_n_CellChangeMedium, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_INTEGER_1_16 },
  { &hf_lte_rrc_n_CellChangeHigh, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_INTEGER_1_16 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_MobilityStateParameters(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_MobilityStateParameters, MobilityStateParameters_sequence);

  return offset;
}


static const value_string lte_rrc_T_sf_Medium_vals[] = {
  {   0, "dB-6" },
  {   1, "dB-4" },
  {   2, "dB-2" },
  {   3, "dB0" },
  { 0, NULL }
};


static int
dissect_lte_rrc_T_sf_Medium(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     4, NULL, FALSE, 0, NULL);

  return offset;
}


static const value_string lte_rrc_T_sf_High_vals[] = {
  {   0, "dB-6" },
  {   1, "dB-4" },
  {   2, "dB-2" },
  {   3, "dB0" },
  { 0, NULL }
};


static int
dissect_lte_rrc_T_sf_High(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     4, NULL, FALSE, 0, NULL);

  return offset;
}


static const per_sequence_t T_q_HystSF_sequence[] = {
  { &hf_lte_rrc_sf_Medium   , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_T_sf_Medium },
  { &hf_lte_rrc_sf_High     , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_T_sf_High },
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_T_q_HystSF(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_T_q_HystSF, T_q_HystSF_sequence);

  return offset;
}


static const per_sequence_t T_speedStateReselectionPars_sequence[] = {
  { &hf_lte_rrc_mobilityStateParameters, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_MobilityStateParameters },
  { &hf_lte_rrc_q_HystSF    , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_T_q_HystSF },
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_T_speedStateReselectionPars(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_T_speedStateReselectionPars, T_speedStateReselectionPars_sequence);

  return offset;
}


static const per_sequence_t T_cellReselectionInfoCommon_sequence[] = {
  { &hf_lte_rrc_q_Hyst      , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_T_q_Hyst },
  { &hf_lte_rrc_speedStateReselectionPars, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lte_rrc_T_speedStateReselectionPars },
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_T_cellReselectionInfoCommon(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_T_cellReselectionInfoCommon, T_cellReselectionInfoCommon_sequence);

  return offset;
}



static int
dissect_lte_rrc_ReselectionThreshold(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 31U, NULL, FALSE);

  return offset;
}



static int
dissect_lte_rrc_CellReselectionPriority(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 7U, NULL, FALSE);

  return offset;
}


static const per_sequence_t T_cellReselectionServingFreqInfo_sequence[] = {
  { &hf_lte_rrc_s_NonIntraSearch, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lte_rrc_ReselectionThreshold },
  { &hf_lte_rrc_threshServingLow, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_ReselectionThreshold },
  { &hf_lte_rrc_cellReselectionPriority, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_CellReselectionPriority },
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_T_cellReselectionServingFreqInfo(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_T_cellReselectionServingFreqInfo, T_cellReselectionServingFreqInfo_sequence);

  return offset;
}



static int
dissect_lte_rrc_Q_RxLevMin(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            -70, -22, NULL, FALSE);

  return offset;
}



static int
dissect_lte_rrc_P_Max(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            -30, 33U, NULL, FALSE);

  proto_item_append_text(actx->created_item, "dBm");


  return offset;
}


static const value_string lte_rrc_AllowedMeasBandwidth_vals[] = {
  {   0, "mbw6" },
  {   1, "mbw15" },
  {   2, "mbw25" },
  {   3, "mbw50" },
  {   4, "mbw75" },
  {   5, "mbw100" },
  { 0, NULL }
};


static int
dissect_lte_rrc_AllowedMeasBandwidth(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     6, NULL, FALSE, 0, NULL);

  return offset;
}



static int
dissect_lte_rrc_PresenceAntennaPort1(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_boolean(tvb, offset, actx, tree, hf_index, NULL);

  return offset;
}



static int
dissect_lte_rrc_NeighCellConfig(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  tvbuff_t *neigh_cell_config_tvb = NULL;
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     2, 2, FALSE, &neigh_cell_config_tvb);

  if (neigh_cell_config_tvb) {
    guint8 bits;
    proto_tree *subtree;
    subtree = proto_item_add_subtree(actx->created_item, ett_lte_rrc_neighCellConfig);
    bits = tvb_get_bits8(neigh_cell_config_tvb, 0, 2);
    switch (bits) {
    case 0:
      proto_tree_add_text(subtree, neigh_cell_config_tvb, 0, 1, "Not all neighbour cells have the same MBSFN subframe allocation as serving cell");
      break;
    case 1:
      proto_tree_add_text(subtree, neigh_cell_config_tvb, 0, 1, "No MBSFN subframes are present in all neighbour cells");
      break;
    case 2:
      proto_tree_add_text(subtree, neigh_cell_config_tvb, 0, 1, "The MBSFN subframe allocations of all neighbour cells are identical to or subsets of that in the serving cell");
      break;
    case 3:
      proto_tree_add_text(subtree, neigh_cell_config_tvb, 0, 1, "Different UL/DL allocation in neighbouring cells for TDD compared to the serving cell");
      break;
    default:
      break;
    }
  }


  return offset;
}



static int
dissect_lte_rrc_T_Reselection(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 7U, NULL, FALSE);

  proto_item_append_text(actx->created_item, "s");


  return offset;
}


static const value_string lte_rrc_T_sf_Medium_01_vals[] = {
  {   0, "oDot25" },
  {   1, "oDot5" },
  {   2, "oDot75" },
  {   3, "lDot0" },
  { 0, NULL }
};


static int
dissect_lte_rrc_T_sf_Medium_01(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     4, NULL, FALSE, 0, NULL);

  return offset;
}


static const value_string lte_rrc_T_sf_High_01_vals[] = {
  {   0, "oDot25" },
  {   1, "oDot5" },
  {   2, "oDot75" },
  {   3, "lDot0" },
  { 0, NULL }
};


static int
dissect_lte_rrc_T_sf_High_01(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     4, NULL, FALSE, 0, NULL);

  return offset;
}


static const per_sequence_t SpeedStateScaleFactors_sequence[] = {
  { &hf_lte_rrc_sf_Medium_01, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_T_sf_Medium_01 },
  { &hf_lte_rrc_sf_High_01  , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_T_sf_High_01 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_SpeedStateScaleFactors(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_SpeedStateScaleFactors, SpeedStateScaleFactors_sequence);

  return offset;
}


static const per_sequence_t T_intraFreqCellReselectionInfo_sequence[] = {
  { &hf_lte_rrc_q_RxLevMin  , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_Q_RxLevMin },
  { &hf_lte_rrc_p_Max       , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lte_rrc_P_Max },
  { &hf_lte_rrc_s_IntraSearch, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lte_rrc_ReselectionThreshold },
  { &hf_lte_rrc_allowedMeasBandwidth, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lte_rrc_AllowedMeasBandwidth },
  { &hf_lte_rrc_presenceAntennaPort1, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_PresenceAntennaPort1 },
  { &hf_lte_rrc_neighCellConfig, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_NeighCellConfig },
  { &hf_lte_rrc_t_ReselectionEUTRA, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_T_Reselection },
  { &hf_lte_rrc_t_ReselectionEUTRA_SF, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lte_rrc_SpeedStateScaleFactors },
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_T_intraFreqCellReselectionInfo(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_T_intraFreqCellReselectionInfo, T_intraFreqCellReselectionInfo_sequence);

  return offset;
}



static int
dissect_lte_rrc_ReselectionThresholdQ_r9(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 31U, NULL, FALSE);

  proto_item_append_text(actx->created_item, "dB");


  return offset;
}


static const per_sequence_t T_s_IntraSearch_v920_sequence[] = {
  { &hf_lte_rrc_s_IntraSearchP_r9, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_ReselectionThreshold },
  { &hf_lte_rrc_s_IntraSearchQ_r9, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_ReselectionThresholdQ_r9 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_T_s_IntraSearch_v920(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_T_s_IntraSearch_v920, T_s_IntraSearch_v920_sequence);

  return offset;
}


static const per_sequence_t T_s_NonIntraSearch_v920_sequence[] = {
  { &hf_lte_rrc_s_NonIntraSearchP_r9, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_ReselectionThreshold },
  { &hf_lte_rrc_s_NonIntraSearchQ_r9, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_ReselectionThresholdQ_r9 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_T_s_NonIntraSearch_v920(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_T_s_NonIntraSearch_v920, T_s_NonIntraSearch_v920_sequence);

  return offset;
}



static int
dissect_lte_rrc_Q_QualMin_r9(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            -34, -3, NULL, FALSE);

  proto_item_append_text(actx->created_item, "dB");


  return offset;
}


static const per_sequence_t SystemInformationBlockType3_eag_1_sequence[] = {
  { &hf_lte_rrc_s_IntraSearch_v920, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lte_rrc_T_s_IntraSearch_v920 },
  { &hf_lte_rrc_s_NonIntraSearch_v920, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lte_rrc_T_s_NonIntraSearch_v920 },
  { &hf_lte_rrc_q_QualMin_r9, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lte_rrc_Q_QualMin_r9 },
  { &hf_lte_rrc_threshServingLowQ_r9, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lte_rrc_ReselectionThresholdQ_r9 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_SystemInformationBlockType3_eag_1(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence_eag(tvb, offset, actx, tree, SystemInformationBlockType3_eag_1_sequence);

  return offset;
}


static const per_sequence_t SystemInformationBlockType3_sequence[] = {
  { &hf_lte_rrc_cellReselectionInfoCommon, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lte_rrc_T_cellReselectionInfoCommon },
  { &hf_lte_rrc_cellReselectionServingFreqInfo, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lte_rrc_T_cellReselectionServingFreqInfo },
  { &hf_lte_rrc_intraFreqCellReselectionInfo, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lte_rrc_T_intraFreqCellReselectionInfo },
  { &hf_lte_rrc_lateNonCriticalExtension, ASN1_NOT_EXTENSION_ROOT, ASN1_OPTIONAL    , dissect_lte_rrc_OCTET_STRING },
  { &hf_lte_rrc_dummy_eag_field, ASN1_NOT_EXTENSION_ROOT, ASN1_NOT_OPTIONAL, dissect_lte_rrc_SystemInformationBlockType3_eag_1 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_SystemInformationBlockType3(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_SystemInformationBlockType3, SystemInformationBlockType3_sequence);

  return offset;
}



static int
dissect_lte_rrc_PhysCellId(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 503U, NULL, FALSE);

  return offset;
}


static const value_string lte_rrc_Q_OffsetRange_vals[] = {
  {   0, "dB-24" },
  {   1, "dB-22" },
  {   2, "dB-20" },
  {   3, "dB-18" },
  {   4, "dB-16" },
  {   5, "dB-14" },
  {   6, "dB-12" },
  {   7, "dB-10" },
  {   8, "dB-8" },
  {   9, "dB-6" },
  {  10, "dB-5" },
  {  11, "dB-4" },
  {  12, "dB-3" },
  {  13, "dB-2" },
  {  14, "dB-1" },
  {  15, "dB0" },
  {  16, "dB1" },
  {  17, "dB2" },
  {  18, "dB3" },
  {  19, "dB4" },
  {  20, "dB5" },
  {  21, "dB6" },
  {  22, "dB8" },
  {  23, "dB10" },
  {  24, "dB12" },
  {  25, "dB14" },
  {  26, "dB16" },
  {  27, "dB18" },
  {  28, "dB20" },
  {  29, "dB22" },
  {  30, "dB24" },
  { 0, NULL }
};


static int
dissect_lte_rrc_Q_OffsetRange(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     31, NULL, FALSE, 0, NULL);

  return offset;
}


static const per_sequence_t IntraFreqNeighCellInfo_sequence[] = {
  { &hf_lte_rrc_physCellId_01, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lte_rrc_PhysCellId },
  { &hf_lte_rrc_q_OffsetCell, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lte_rrc_Q_OffsetRange },
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_IntraFreqNeighCellInfo(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_IntraFreqNeighCellInfo, IntraFreqNeighCellInfo_sequence);

  return offset;
}


static const per_sequence_t IntraFreqNeighCellList_sequence_of[1] = {
  { &hf_lte_rrc_IntraFreqNeighCellList_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_IntraFreqNeighCellInfo },
};

static int
dissect_lte_rrc_IntraFreqNeighCellList(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_lte_rrc_IntraFreqNeighCellList, IntraFreqNeighCellList_sequence_of,
                                                  1, maxCellIntra, FALSE);

  return offset;
}


static const value_string lte_rrc_T_range_vals[] = {
  {   0, "n4" },
  {   1, "n8" },
  {   2, "n12" },
  {   3, "n16" },
  {   4, "n24" },
  {   5, "n32" },
  {   6, "n48" },
  {   7, "n64" },
  {   8, "n84" },
  {   9, "n96" },
  {  10, "n128" },
  {  11, "n168" },
  {  12, "n252" },
  {  13, "n504" },
  {  14, "spare2" },
  {  15, "spare1" },
  { 0, NULL }
};


static int
dissect_lte_rrc_T_range(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     16, NULL, FALSE, 0, NULL);

  return offset;
}


static const per_sequence_t PhysCellIdRange_sequence[] = {
  { &hf_lte_rrc_start_01    , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_PhysCellId },
  { &hf_lte_rrc_range       , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lte_rrc_T_range },
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_PhysCellIdRange(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_PhysCellIdRange, PhysCellIdRange_sequence);

  return offset;
}


static const per_sequence_t IntraFreqBlackCellList_sequence_of[1] = {
  { &hf_lte_rrc_IntraFreqBlackCellList_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_PhysCellIdRange },
};

static int
dissect_lte_rrc_IntraFreqBlackCellList(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_lte_rrc_IntraFreqBlackCellList, IntraFreqBlackCellList_sequence_of,
                                                  1, maxCellBlack, FALSE);

  return offset;
}


static const per_sequence_t SystemInformationBlockType4_sequence[] = {
  { &hf_lte_rrc_intraFreqNeighCellList, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lte_rrc_IntraFreqNeighCellList },
  { &hf_lte_rrc_intraFreqBlackCellList, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lte_rrc_IntraFreqBlackCellList },
  { &hf_lte_rrc_csg_PhysCellIdRange, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lte_rrc_PhysCellIdRange },
  { &hf_lte_rrc_lateNonCriticalExtension, ASN1_NOT_EXTENSION_ROOT, ASN1_OPTIONAL    , dissect_lte_rrc_OCTET_STRING },
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_SystemInformationBlockType4(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_SystemInformationBlockType4, SystemInformationBlockType4_sequence);

  return offset;
}


static const per_sequence_t InterFreqNeighCellInfo_sequence[] = {
  { &hf_lte_rrc_physCellId_01, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_PhysCellId },
  { &hf_lte_rrc_q_OffsetCell, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_Q_OffsetRange },
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_InterFreqNeighCellInfo(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_InterFreqNeighCellInfo, InterFreqNeighCellInfo_sequence);

  return offset;
}


static const per_sequence_t InterFreqNeighCellList_sequence_of[1] = {
  { &hf_lte_rrc_InterFreqNeighCellList_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_InterFreqNeighCellInfo },
};

static int
dissect_lte_rrc_InterFreqNeighCellList(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_lte_rrc_InterFreqNeighCellList, InterFreqNeighCellList_sequence_of,
                                                  1, maxCellInter, FALSE);

  return offset;
}


static const per_sequence_t InterFreqBlackCellList_sequence_of[1] = {
  { &hf_lte_rrc_InterFreqBlackCellList_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_PhysCellIdRange },
};

static int
dissect_lte_rrc_InterFreqBlackCellList(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_lte_rrc_InterFreqBlackCellList, InterFreqBlackCellList_sequence_of,
                                                  1, maxCellBlack, FALSE);

  return offset;
}


static const per_sequence_t T_threshX_Q_r9_sequence[] = {
  { &hf_lte_rrc_threshX_HighQ_r9, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_ReselectionThresholdQ_r9 },
  { &hf_lte_rrc_threshX_LowQ_r9, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_ReselectionThresholdQ_r9 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_T_threshX_Q_r9(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_T_threshX_Q_r9, T_threshX_Q_r9_sequence);

  return offset;
}


static const per_sequence_t InterFreqCarrierFreqInfo_eag_1_sequence[] = {
  { &hf_lte_rrc_q_QualMin_r9, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lte_rrc_Q_QualMin_r9 },
  { &hf_lte_rrc_threshX_Q_r9, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lte_rrc_T_threshX_Q_r9 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_InterFreqCarrierFreqInfo_eag_1(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence_eag(tvb, offset, actx, tree, InterFreqCarrierFreqInfo_eag_1_sequence);

  return offset;
}


static const per_sequence_t InterFreqCarrierFreqInfo_sequence[] = {
  { &hf_lte_rrc_dl_CarrierFreq, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lte_rrc_ARFCN_ValueEUTRA },
  { &hf_lte_rrc_q_RxLevMin  , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lte_rrc_Q_RxLevMin },
  { &hf_lte_rrc_p_Max       , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lte_rrc_P_Max },
  { &hf_lte_rrc_t_ReselectionEUTRA, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lte_rrc_T_Reselection },
  { &hf_lte_rrc_t_ReselectionEUTRA_SF, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lte_rrc_SpeedStateScaleFactors },
  { &hf_lte_rrc_threshX_High, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lte_rrc_ReselectionThreshold },
  { &hf_lte_rrc_threshX_Low , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lte_rrc_ReselectionThreshold },
  { &hf_lte_rrc_allowedMeasBandwidth, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lte_rrc_AllowedMeasBandwidth },
  { &hf_lte_rrc_presenceAntennaPort1, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lte_rrc_PresenceAntennaPort1 },
  { &hf_lte_rrc_cellReselectionPriority, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lte_rrc_CellReselectionPriority },
  { &hf_lte_rrc_neighCellConfig, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lte_rrc_NeighCellConfig },
  { &hf_lte_rrc_q_OffsetFreq, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lte_rrc_Q_OffsetRange },
  { &hf_lte_rrc_interFreqNeighCellList, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lte_rrc_InterFreqNeighCellList },
  { &hf_lte_rrc_interFreqBlackCellList, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lte_rrc_InterFreqBlackCellList },
  { &hf_lte_rrc_dummy_eag_field, ASN1_NOT_EXTENSION_ROOT, ASN1_NOT_OPTIONAL, dissect_lte_rrc_InterFreqCarrierFreqInfo_eag_1 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_InterFreqCarrierFreqInfo(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_InterFreqCarrierFreqInfo, InterFreqCarrierFreqInfo_sequence);

  return offset;
}


static const per_sequence_t InterFreqCarrierFreqList_sequence_of[1] = {
  { &hf_lte_rrc_InterFreqCarrierFreqList_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_InterFreqCarrierFreqInfo },
};

static int
dissect_lte_rrc_InterFreqCarrierFreqList(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_lte_rrc_InterFreqCarrierFreqList, InterFreqCarrierFreqList_sequence_of,
                                                  1, maxFreq, FALSE);

  return offset;
}


static const per_sequence_t SystemInformationBlockType5_sequence[] = {
  { &hf_lte_rrc_interFreqCarrierFreqList, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lte_rrc_InterFreqCarrierFreqList },
  { &hf_lte_rrc_lateNonCriticalExtension, ASN1_NOT_EXTENSION_ROOT, ASN1_OPTIONAL    , dissect_lte_rrc_OCTET_STRING },
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_SystemInformationBlockType5(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_SystemInformationBlockType5, SystemInformationBlockType5_sequence);

  return offset;
}



static int
dissect_lte_rrc_ARFCN_ValueUTRA(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 16383U, NULL, FALSE);

  return offset;
}



static int
dissect_lte_rrc_INTEGER_M60_M13(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            -60, -13, NULL, FALSE);

  return offset;
}



static int
dissect_lte_rrc_T_p_MaxUTRA(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            -50, 33U, NULL, FALSE);

  proto_item_append_text(actx->created_item, "dBm");


  return offset;
}



static int
dissect_lte_rrc_T_q_QualMin(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            -24, 0U, NULL, FALSE);

  proto_item_append_text(actx->created_item, "dB");


  return offset;
}


static const per_sequence_t T_threshX_Q_r9_01_sequence[] = {
  { &hf_lte_rrc_threshX_HighQ_r9, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_ReselectionThresholdQ_r9 },
  { &hf_lte_rrc_threshX_LowQ_r9, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_ReselectionThresholdQ_r9 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_T_threshX_Q_r9_01(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_T_threshX_Q_r9_01, T_threshX_Q_r9_01_sequence);

  return offset;
}


static const per_sequence_t CarrierFreqUTRA_FDD_eag_1_sequence[] = {
  { &hf_lte_rrc_threshX_Q_r9_01, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lte_rrc_T_threshX_Q_r9_01 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_CarrierFreqUTRA_FDD_eag_1(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence_eag(tvb, offset, actx, tree, CarrierFreqUTRA_FDD_eag_1_sequence);

  return offset;
}


static const per_sequence_t CarrierFreqUTRA_FDD_sequence[] = {
  { &hf_lte_rrc_carrierFreq_02, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lte_rrc_ARFCN_ValueUTRA },
  { &hf_lte_rrc_cellReselectionPriority, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lte_rrc_CellReselectionPriority },
  { &hf_lte_rrc_threshX_High, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lte_rrc_ReselectionThreshold },
  { &hf_lte_rrc_threshX_Low , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lte_rrc_ReselectionThreshold },
  { &hf_lte_rrc_q_RxLevMin_01, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lte_rrc_INTEGER_M60_M13 },
  { &hf_lte_rrc_p_MaxUTRA   , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lte_rrc_T_p_MaxUTRA },
  { &hf_lte_rrc_q_QualMin   , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lte_rrc_T_q_QualMin },
  { &hf_lte_rrc_dummy_eag_field, ASN1_NOT_EXTENSION_ROOT, ASN1_NOT_OPTIONAL, dissect_lte_rrc_CarrierFreqUTRA_FDD_eag_1 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_CarrierFreqUTRA_FDD(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_CarrierFreqUTRA_FDD, CarrierFreqUTRA_FDD_sequence);

  return offset;
}


static const per_sequence_t CarrierFreqListUTRA_FDD_sequence_of[1] = {
  { &hf_lte_rrc_CarrierFreqListUTRA_FDD_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_CarrierFreqUTRA_FDD },
};

static int
dissect_lte_rrc_CarrierFreqListUTRA_FDD(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_lte_rrc_CarrierFreqListUTRA_FDD, CarrierFreqListUTRA_FDD_sequence_of,
                                                  1, maxUTRA_FDD_Carrier, FALSE);

  return offset;
}



static int
dissect_lte_rrc_T_p_MaxUTRA_01(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            -50, 33U, NULL, FALSE);

  proto_item_append_text(actx->created_item, "dBm");


  return offset;
}


static const per_sequence_t CarrierFreqUTRA_TDD_sequence[] = {
  { &hf_lte_rrc_carrierFreq_02, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lte_rrc_ARFCN_ValueUTRA },
  { &hf_lte_rrc_cellReselectionPriority, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lte_rrc_CellReselectionPriority },
  { &hf_lte_rrc_threshX_High, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lte_rrc_ReselectionThreshold },
  { &hf_lte_rrc_threshX_Low , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lte_rrc_ReselectionThreshold },
  { &hf_lte_rrc_q_RxLevMin_01, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lte_rrc_INTEGER_M60_M13 },
  { &hf_lte_rrc_p_MaxUTRA_01, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lte_rrc_T_p_MaxUTRA_01 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_CarrierFreqUTRA_TDD(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_CarrierFreqUTRA_TDD, CarrierFreqUTRA_TDD_sequence);

  return offset;
}


static const per_sequence_t CarrierFreqListUTRA_TDD_sequence_of[1] = {
  { &hf_lte_rrc_CarrierFreqListUTRA_TDD_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_CarrierFreqUTRA_TDD },
};

static int
dissect_lte_rrc_CarrierFreqListUTRA_TDD(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_lte_rrc_CarrierFreqListUTRA_TDD, CarrierFreqListUTRA_TDD_sequence_of,
                                                  1, maxUTRA_TDD_Carrier, FALSE);

  return offset;
}


static const per_sequence_t SystemInformationBlockType6_sequence[] = {
  { &hf_lte_rrc_carrierFreqListUTRA_FDD, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lte_rrc_CarrierFreqListUTRA_FDD },
  { &hf_lte_rrc_carrierFreqListUTRA_TDD, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lte_rrc_CarrierFreqListUTRA_TDD },
  { &hf_lte_rrc_t_ReselectionUTRA, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lte_rrc_T_Reselection },
  { &hf_lte_rrc_t_ReselectionUTRA_SF, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lte_rrc_SpeedStateScaleFactors },
  { &hf_lte_rrc_lateNonCriticalExtension, ASN1_NOT_EXTENSION_ROOT, ASN1_OPTIONAL    , dissect_lte_rrc_OCTET_STRING },
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_SystemInformationBlockType6(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_SystemInformationBlockType6, SystemInformationBlockType6_sequence);

  return offset;
}



static int
dissect_lte_rrc_ARFCN_ValueGERAN(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 1023U, NULL, FALSE);

  return offset;
}


static const value_string lte_rrc_BandIndicatorGERAN_vals[] = {
  {   0, "dcs1800" },
  {   1, "pcs1900" },
  { 0, NULL }
};


static int
dissect_lte_rrc_BandIndicatorGERAN(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, FALSE, 0, NULL);

  return offset;
}


static const per_sequence_t ExplicitListOfARFCNs_sequence_of[1] = {
  { &hf_lte_rrc_ExplicitListOfARFCNs_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_ARFCN_ValueGERAN },
};

static int
dissect_lte_rrc_ExplicitListOfARFCNs(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_lte_rrc_ExplicitListOfARFCNs, ExplicitListOfARFCNs_sequence_of,
                                                  0, 31, FALSE);

  return offset;
}



static int
dissect_lte_rrc_INTEGER_0_31(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 31U, NULL, FALSE);

  return offset;
}


static const per_sequence_t T_equallySpacedARFCNs_sequence[] = {
  { &hf_lte_rrc_arfcn_Spacing, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_INTEGER_1_8 },
  { &hf_lte_rrc_numberOfFollowingARFCNs, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_INTEGER_0_31 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_T_equallySpacedARFCNs(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_T_equallySpacedARFCNs, T_equallySpacedARFCNs_sequence);

  return offset;
}



static int
dissect_lte_rrc_OCTET_STRING_SIZE_1_16(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_octet_string(tvb, offset, actx, tree, hf_index,
                                       1, 16, FALSE, NULL);

  return offset;
}


static const value_string lte_rrc_T_followingARFCNs_vals[] = {
  {   0, "explicitListOfARFCNs" },
  {   1, "equallySpacedARFCNs" },
  {   2, "variableBitMapOfARFCNs" },
  { 0, NULL }
};

static const per_choice_t T_followingARFCNs_choice[] = {
  {   0, &hf_lte_rrc_explicitListOfARFCNs, ASN1_NO_EXTENSIONS     , dissect_lte_rrc_ExplicitListOfARFCNs },
  {   1, &hf_lte_rrc_equallySpacedARFCNs, ASN1_NO_EXTENSIONS     , dissect_lte_rrc_T_equallySpacedARFCNs },
  {   2, &hf_lte_rrc_variableBitMapOfARFCNs, ASN1_NO_EXTENSIONS     , dissect_lte_rrc_OCTET_STRING_SIZE_1_16 },
  { 0, NULL, 0, NULL }
};

static int
dissect_lte_rrc_T_followingARFCNs(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_lte_rrc_T_followingARFCNs, T_followingARFCNs_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t CarrierFreqsGERAN_sequence[] = {
  { &hf_lte_rrc_startingARFCN, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_ARFCN_ValueGERAN },
  { &hf_lte_rrc_bandIndicator, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_BandIndicatorGERAN },
  { &hf_lte_rrc_followingARFCNs, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_T_followingARFCNs },
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_CarrierFreqsGERAN(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_CarrierFreqsGERAN, CarrierFreqsGERAN_sequence);

  return offset;
}



static int
dissect_lte_rrc_INTEGER_0_45(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 45U, NULL, FALSE);

  return offset;
}



static int
dissect_lte_rrc_T_p_MaxGERAN(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 39U, NULL, FALSE);

  proto_item_append_text(actx->created_item, "dBm");


  return offset;
}


static const per_sequence_t T_commonInfo_sequence[] = {
  { &hf_lte_rrc_cellReselectionPriority, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lte_rrc_CellReselectionPriority },
  { &hf_lte_rrc_ncc_Permitted, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_BIT_STRING_SIZE_8 },
  { &hf_lte_rrc_q_RxLevMin_02, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_INTEGER_0_45 },
  { &hf_lte_rrc_p_MaxGERAN  , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lte_rrc_T_p_MaxGERAN },
  { &hf_lte_rrc_threshX_High, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_ReselectionThreshold },
  { &hf_lte_rrc_threshX_Low , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_ReselectionThreshold },
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_T_commonInfo(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_T_commonInfo, T_commonInfo_sequence);

  return offset;
}


static const per_sequence_t CarrierFreqsInfoGERAN_sequence[] = {
  { &hf_lte_rrc_carrierFreqs, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lte_rrc_CarrierFreqsGERAN },
  { &hf_lte_rrc_commonInfo  , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lte_rrc_T_commonInfo },
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_CarrierFreqsInfoGERAN(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_CarrierFreqsInfoGERAN, CarrierFreqsInfoGERAN_sequence);

  return offset;
}


static const per_sequence_t CarrierFreqsInfoListGERAN_sequence_of[1] = {
  { &hf_lte_rrc_CarrierFreqsInfoListGERAN_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_CarrierFreqsInfoGERAN },
};

static int
dissect_lte_rrc_CarrierFreqsInfoListGERAN(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_lte_rrc_CarrierFreqsInfoListGERAN, CarrierFreqsInfoListGERAN_sequence_of,
                                                  1, maxGNFG, FALSE);

  return offset;
}


static const per_sequence_t SystemInformationBlockType7_sequence[] = {
  { &hf_lte_rrc_t_ReselectionGERAN, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lte_rrc_T_Reselection },
  { &hf_lte_rrc_t_ReselectionGERAN_SF, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lte_rrc_SpeedStateScaleFactors },
  { &hf_lte_rrc_carrierFreqsInfoList, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lte_rrc_CarrierFreqsInfoListGERAN },
  { &hf_lte_rrc_lateNonCriticalExtension, ASN1_NOT_EXTENSION_ROOT, ASN1_OPTIONAL    , dissect_lte_rrc_OCTET_STRING },
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_SystemInformationBlockType7(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_SystemInformationBlockType7, SystemInformationBlockType7_sequence);

  return offset;
}



static int
dissect_lte_rrc_BIT_STRING_SIZE_39(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     39, 39, FALSE, NULL);

  return offset;
}



static int
dissect_lte_rrc_BIT_STRING_SIZE_49(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     49, 49, FALSE, NULL);

  return offset;
}


static const value_string lte_rrc_T_cdma_SystemTime_vals[] = {
  {   0, "synchronousSystemTime" },
  {   1, "asynchronousSystemTime" },
  { 0, NULL }
};

static const per_choice_t T_cdma_SystemTime_choice[] = {
  {   0, &hf_lte_rrc_synchronousSystemTime, ASN1_NO_EXTENSIONS     , dissect_lte_rrc_BIT_STRING_SIZE_39 },
  {   1, &hf_lte_rrc_asynchronousSystemTime, ASN1_NO_EXTENSIONS     , dissect_lte_rrc_BIT_STRING_SIZE_49 },
  { 0, NULL, 0, NULL }
};

static int
dissect_lte_rrc_T_cdma_SystemTime(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_lte_rrc_T_cdma_SystemTime, T_cdma_SystemTime_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t SystemTimeInfoCDMA2000_sequence[] = {
  { &hf_lte_rrc_cdma_EUTRA_Synchronisation, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_BOOLEAN },
  { &hf_lte_rrc_cdma_SystemTime, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_T_cdma_SystemTime },
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_SystemTimeInfoCDMA2000(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_SystemTimeInfoCDMA2000, SystemTimeInfoCDMA2000_sequence);

  return offset;
}



static int
dissect_lte_rrc_PreRegistrationZoneIdHRPD(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 255U, NULL, FALSE);

  return offset;
}


static const per_sequence_t SecondaryPreRegistrationZoneIdListHRPD_sequence_of[1] = {
  { &hf_lte_rrc_SecondaryPreRegistrationZoneIdListHRPD_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_PreRegistrationZoneIdHRPD },
};

static int
dissect_lte_rrc_SecondaryPreRegistrationZoneIdListHRPD(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_lte_rrc_SecondaryPreRegistrationZoneIdListHRPD, SecondaryPreRegistrationZoneIdListHRPD_sequence_of,
                                                  1, 2, FALSE);

  return offset;
}


static const per_sequence_t PreRegistrationInfoHRPD_sequence[] = {
  { &hf_lte_rrc_preRegistrationAllowed, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_BOOLEAN },
  { &hf_lte_rrc_preRegistrationZoneId, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lte_rrc_PreRegistrationZoneIdHRPD },
  { &hf_lte_rrc_secondaryPreRegistrationZoneIdList, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lte_rrc_SecondaryPreRegistrationZoneIdListHRPD },
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_PreRegistrationInfoHRPD(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_PreRegistrationInfoHRPD, PreRegistrationInfoHRPD_sequence);

  return offset;
}


static const value_string lte_rrc_BandclassCDMA2000_vals[] = {
  {   0, "bc0" },
  {   1, "bc1" },
  {   2, "bc2" },
  {   3, "bc3" },
  {   4, "bc4" },
  {   5, "bc5" },
  {   6, "bc6" },
  {   7, "bc7" },
  {   8, "bc8" },
  {   9, "bc9" },
  {  10, "bc10" },
  {  11, "bc11" },
  {  12, "bc12" },
  {  13, "bc13" },
  {  14, "bc14" },
  {  15, "bc15" },
  {  16, "bc16" },
  {  17, "bc17" },
  {  18, "bc18-v9a0" },
  {  19, "bc19-v9a0" },
  {  20, "bc20-v9a0" },
  {  21, "bc21-v9a0" },
  {  22, "spare10" },
  {  23, "spare9" },
  {  24, "spare8" },
  {  25, "spare7" },
  {  26, "spare6" },
  {  27, "spare5" },
  {  28, "spare4" },
  {  29, "spare3" },
  {  30, "spare2" },
  {  31, "spare1" },
  { 0, NULL }
};


static int
dissect_lte_rrc_BandclassCDMA2000(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     32, NULL, TRUE, 0, NULL);

  return offset;
}


static const per_sequence_t BandClassInfoCDMA2000_sequence[] = {
  { &hf_lte_rrc_bandClass   , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lte_rrc_BandclassCDMA2000 },
  { &hf_lte_rrc_cellReselectionPriority, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lte_rrc_CellReselectionPriority },
  { &hf_lte_rrc_threshX_High_01, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lte_rrc_INTEGER_0_63 },
  { &hf_lte_rrc_threshX_Low_01, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lte_rrc_INTEGER_0_63 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_BandClassInfoCDMA2000(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_BandClassInfoCDMA2000, BandClassInfoCDMA2000_sequence);

  return offset;
}


static const per_sequence_t BandClassListCDMA2000_sequence_of[1] = {
  { &hf_lte_rrc_BandClassListCDMA2000_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_BandClassInfoCDMA2000 },
};

static int
dissect_lte_rrc_BandClassListCDMA2000(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_lte_rrc_BandClassListCDMA2000, BandClassListCDMA2000_sequence_of,
                                                  1, maxCDMA_BandClass, FALSE);

  return offset;
}



static int
dissect_lte_rrc_ARFCN_ValueCDMA2000(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 2047U, NULL, FALSE);

  return offset;
}



static int
dissect_lte_rrc_PhysCellIdCDMA2000(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, maxPNOffset, NULL, FALSE);

  return offset;
}


static const per_sequence_t PhysCellIdListCDMA2000_sequence_of[1] = {
  { &hf_lte_rrc_PhysCellIdListCDMA2000_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_PhysCellIdCDMA2000 },
};

static int
dissect_lte_rrc_PhysCellIdListCDMA2000(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_lte_rrc_PhysCellIdListCDMA2000, PhysCellIdListCDMA2000_sequence_of,
                                                  1, 16, FALSE);

  return offset;
}


static const per_sequence_t NeighCellsPerBandclassCDMA2000_sequence[] = {
  { &hf_lte_rrc_arfcn       , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_ARFCN_ValueCDMA2000 },
  { &hf_lte_rrc_physCellIdList, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_PhysCellIdListCDMA2000 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_NeighCellsPerBandclassCDMA2000(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_NeighCellsPerBandclassCDMA2000, NeighCellsPerBandclassCDMA2000_sequence);

  return offset;
}


static const per_sequence_t NeighCellsPerBandclassListCDMA2000_sequence_of[1] = {
  { &hf_lte_rrc_NeighCellsPerBandclassListCDMA2000_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_NeighCellsPerBandclassCDMA2000 },
};

static int
dissect_lte_rrc_NeighCellsPerBandclassListCDMA2000(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_lte_rrc_NeighCellsPerBandclassListCDMA2000, NeighCellsPerBandclassListCDMA2000_sequence_of,
                                                  1, 16, FALSE);

  return offset;
}


static const per_sequence_t NeighCellCDMA2000_sequence[] = {
  { &hf_lte_rrc_bandClass   , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_BandclassCDMA2000 },
  { &hf_lte_rrc_neighCellsPerFreqList, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_NeighCellsPerBandclassListCDMA2000 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_NeighCellCDMA2000(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_NeighCellCDMA2000, NeighCellCDMA2000_sequence);

  return offset;
}


static const per_sequence_t NeighCellListCDMA2000_sequence_of[1] = {
  { &hf_lte_rrc_NeighCellListCDMA2000_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_NeighCellCDMA2000 },
};

static int
dissect_lte_rrc_NeighCellListCDMA2000(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_lte_rrc_NeighCellListCDMA2000, NeighCellListCDMA2000_sequence_of,
                                                  1, 16, FALSE);

  return offset;
}


static const per_sequence_t CellReselectionParametersCDMA2000_sequence[] = {
  { &hf_lte_rrc_bandClassList, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_BandClassListCDMA2000 },
  { &hf_lte_rrc_neighCellList, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_NeighCellListCDMA2000 },
  { &hf_lte_rrc_t_ReselectionCDMA2000, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_T_Reselection },
  { &hf_lte_rrc_t_ReselectionCDMA2000_SF, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lte_rrc_SpeedStateScaleFactors },
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_CellReselectionParametersCDMA2000(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_CellReselectionParametersCDMA2000, CellReselectionParametersCDMA2000_sequence);

  return offset;
}


static const per_sequence_t T_parametersHRPD_sequence[] = {
  { &hf_lte_rrc_preRegistrationInfoHRPD, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_PreRegistrationInfoHRPD },
  { &hf_lte_rrc_cellReselectionParametersHRPD, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lte_rrc_CellReselectionParametersCDMA2000 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_T_parametersHRPD(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_T_parametersHRPD, T_parametersHRPD_sequence);

  return offset;
}



static int
dissect_lte_rrc_BIT_STRING_SIZE_15(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     15, 15, FALSE, NULL);

  return offset;
}



static int
dissect_lte_rrc_BIT_STRING_SIZE_16(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     16, 16, FALSE, NULL);

  return offset;
}



static int
dissect_lte_rrc_BIT_STRING_SIZE_7(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     7, 7, FALSE, NULL);

  return offset;
}



static int
dissect_lte_rrc_BIT_STRING_SIZE_12(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     12, 12, FALSE, NULL);

  return offset;
}



static int
dissect_lte_rrc_BIT_STRING_SIZE_3(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     3, 3, FALSE, NULL);

  return offset;
}


static const per_sequence_t CSFB_RegistrationParam1XRTT_sequence[] = {
  { &hf_lte_rrc_sid         , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_BIT_STRING_SIZE_15 },
  { &hf_lte_rrc_nid         , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_BIT_STRING_SIZE_16 },
  { &hf_lte_rrc_multipleSID , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_BOOLEAN },
  { &hf_lte_rrc_multipleNID , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_BOOLEAN },
  { &hf_lte_rrc_homeReg     , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_BOOLEAN },
  { &hf_lte_rrc_foreignSIDReg, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_BOOLEAN },
  { &hf_lte_rrc_foreignNIDReg, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_BOOLEAN },
  { &hf_lte_rrc_parameterReg, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_BOOLEAN },
  { &hf_lte_rrc_powerUpReg  , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_BOOLEAN },
  { &hf_lte_rrc_registrationPeriod, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_BIT_STRING_SIZE_7 },
  { &hf_lte_rrc_registrationZone, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_BIT_STRING_SIZE_12 },
  { &hf_lte_rrc_totalZone   , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_BIT_STRING_SIZE_3 },
  { &hf_lte_rrc_zoneTimer   , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_BIT_STRING_SIZE_3 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_CSFB_RegistrationParam1XRTT(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_CSFB_RegistrationParam1XRTT, CSFB_RegistrationParam1XRTT_sequence);

  return offset;
}



static int
dissect_lte_rrc_BIT_STRING_SIZE_42(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     42, 42, FALSE, NULL);

  return offset;
}


static const per_sequence_t T_parameters1XRTT_sequence[] = {
  { &hf_lte_rrc_csfb_RegistrationParam1XRTT, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lte_rrc_CSFB_RegistrationParam1XRTT },
  { &hf_lte_rrc_longCodeState1XRTT, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lte_rrc_BIT_STRING_SIZE_42 },
  { &hf_lte_rrc_cellReselectionParameters1XRTT, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lte_rrc_CellReselectionParametersCDMA2000 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_T_parameters1XRTT(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_T_parameters1XRTT, T_parameters1XRTT_sequence);

  return offset;
}


static const per_sequence_t PhysCellIdListCDMA2000_v920_sequence_of[1] = {
  { &hf_lte_rrc_PhysCellIdListCDMA2000_v920_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_PhysCellIdCDMA2000 },
};

static int
dissect_lte_rrc_PhysCellIdListCDMA2000_v920(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_lte_rrc_PhysCellIdListCDMA2000_v920, PhysCellIdListCDMA2000_v920_sequence_of,
                                                  0, 24, FALSE);

  return offset;
}


static const per_sequence_t NeighCellsPerBandclassCDMA2000_v920_sequence[] = {
  { &hf_lte_rrc_physCellIdList_v920, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_PhysCellIdListCDMA2000_v920 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_NeighCellsPerBandclassCDMA2000_v920(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_NeighCellsPerBandclassCDMA2000_v920, NeighCellsPerBandclassCDMA2000_v920_sequence);

  return offset;
}


static const per_sequence_t NeighCellsPerBandclassListCDMA2000_v920_sequence_of[1] = {
  { &hf_lte_rrc_NeighCellsPerBandclassListCDMA2000_v920_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_NeighCellsPerBandclassCDMA2000_v920 },
};

static int
dissect_lte_rrc_NeighCellsPerBandclassListCDMA2000_v920(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_lte_rrc_NeighCellsPerBandclassListCDMA2000_v920, NeighCellsPerBandclassListCDMA2000_v920_sequence_of,
                                                  1, 16, FALSE);

  return offset;
}


static const per_sequence_t NeighCellCDMA2000_v920_sequence[] = {
  { &hf_lte_rrc_neighCellsPerFreqList_v920, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_NeighCellsPerBandclassListCDMA2000_v920 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_NeighCellCDMA2000_v920(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_NeighCellCDMA2000_v920, NeighCellCDMA2000_v920_sequence);

  return offset;
}


static const per_sequence_t NeighCellListCDMA2000_v920_sequence_of[1] = {
  { &hf_lte_rrc_NeighCellListCDMA2000_v920_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_NeighCellCDMA2000_v920 },
};

static int
dissect_lte_rrc_NeighCellListCDMA2000_v920(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_lte_rrc_NeighCellListCDMA2000_v920, NeighCellListCDMA2000_v920_sequence_of,
                                                  1, 16, FALSE);

  return offset;
}


static const per_sequence_t CellReselectionParametersCDMA2000_v920_sequence[] = {
  { &hf_lte_rrc_neighCellList_v920, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_NeighCellListCDMA2000_v920 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_CellReselectionParametersCDMA2000_v920(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_CellReselectionParametersCDMA2000_v920, CellReselectionParametersCDMA2000_v920_sequence);

  return offset;
}


static const value_string lte_rrc_T_powerDownReg_r9_vals[] = {
  {   0, "true" },
  { 0, NULL }
};


static int
dissect_lte_rrc_T_powerDownReg_r9(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, FALSE, 0, NULL);

  return offset;
}


static const per_sequence_t CSFB_RegistrationParam1XRTT_v920_sequence[] = {
  { &hf_lte_rrc_powerDownReg_r9, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_T_powerDownReg_r9 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_CSFB_RegistrationParam1XRTT_v920(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_CSFB_RegistrationParam1XRTT_v920, CSFB_RegistrationParam1XRTT_v920_sequence);

  return offset;
}


static const per_sequence_t AC_BarringConfig1XRTT_r9_sequence[] = {
  { &hf_lte_rrc_ac_Barring0to9_r9, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_INTEGER_0_63 },
  { &hf_lte_rrc_ac_Barring10_r9, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_INTEGER_0_7 },
  { &hf_lte_rrc_ac_Barring11_r9, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_INTEGER_0_7 },
  { &hf_lte_rrc_ac_Barring12_r9, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_INTEGER_0_7 },
  { &hf_lte_rrc_ac_Barring13_r9, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_INTEGER_0_7 },
  { &hf_lte_rrc_ac_Barring14_r9, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_INTEGER_0_7 },
  { &hf_lte_rrc_ac_Barring15_r9, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_INTEGER_0_7 },
  { &hf_lte_rrc_ac_BarringMsg_r9, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_INTEGER_0_7 },
  { &hf_lte_rrc_ac_BarringReg_r9, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_INTEGER_0_7 },
  { &hf_lte_rrc_ac_BarringEmg_r9, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_INTEGER_0_7 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_AC_BarringConfig1XRTT_r9(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_AC_BarringConfig1XRTT_r9, AC_BarringConfig1XRTT_r9_sequence);

  return offset;
}


static const per_sequence_t SystemInformationBlockType8_eag_1_sequence[] = {
  { &hf_lte_rrc_csfb_SupportForDualRxUEs_r9, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lte_rrc_BOOLEAN },
  { &hf_lte_rrc_cellReselectionParametersHRPD_v920, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lte_rrc_CellReselectionParametersCDMA2000_v920 },
  { &hf_lte_rrc_cellReselectionParameters1XRTT_v920, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lte_rrc_CellReselectionParametersCDMA2000_v920 },
  { &hf_lte_rrc_csfb_RegistrationParam1XRTT_v920, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lte_rrc_CSFB_RegistrationParam1XRTT_v920 },
  { &hf_lte_rrc_ac_BarringConfig1XRTT_r9, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lte_rrc_AC_BarringConfig1XRTT_r9 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_SystemInformationBlockType8_eag_1(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence_eag(tvb, offset, actx, tree, SystemInformationBlockType8_eag_1_sequence);

  return offset;
}


static const value_string lte_rrc_T_csfb_DualRxTxSupport_r10_vals[] = {
  {   0, "true" },
  { 0, NULL }
};


static int
dissect_lte_rrc_T_csfb_DualRxTxSupport_r10(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, FALSE, 0, NULL);

  return offset;
}


static const per_sequence_t SystemInformationBlockType8_eag_2_sequence[] = {
  { &hf_lte_rrc_csfb_DualRxTxSupport_r10, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lte_rrc_T_csfb_DualRxTxSupport_r10 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_SystemInformationBlockType8_eag_2(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence_eag(tvb, offset, actx, tree, SystemInformationBlockType8_eag_2_sequence);

  return offset;
}


static const per_sequence_t SystemInformationBlockType8_sequence[] = {
  { &hf_lte_rrc_systemTimeInfo, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lte_rrc_SystemTimeInfoCDMA2000 },
  { &hf_lte_rrc_searchWindowSize, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lte_rrc_INTEGER_0_15 },
  { &hf_lte_rrc_parametersHRPD, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lte_rrc_T_parametersHRPD },
  { &hf_lte_rrc_parameters1XRTT, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lte_rrc_T_parameters1XRTT },
  { &hf_lte_rrc_lateNonCriticalExtension, ASN1_NOT_EXTENSION_ROOT, ASN1_OPTIONAL    , dissect_lte_rrc_OCTET_STRING },
  { &hf_lte_rrc_dummy_eag_field, ASN1_NOT_EXTENSION_ROOT, ASN1_NOT_OPTIONAL, dissect_lte_rrc_SystemInformationBlockType8_eag_1 },
  { &hf_lte_rrc_dummy_eag_field, ASN1_NOT_EXTENSION_ROOT, ASN1_NOT_OPTIONAL, dissect_lte_rrc_SystemInformationBlockType8_eag_2 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_SystemInformationBlockType8(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_SystemInformationBlockType8, SystemInformationBlockType8_sequence);

  return offset;
}



static int
dissect_lte_rrc_OCTET_STRING_SIZE_1_48(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_octet_string(tvb, offset, actx, tree, hf_index,
                                       1, 48, FALSE, NULL);

  return offset;
}


static const per_sequence_t SystemInformationBlockType9_sequence[] = {
  { &hf_lte_rrc_hnb_Name    , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lte_rrc_OCTET_STRING_SIZE_1_48 },
  { &hf_lte_rrc_lateNonCriticalExtension, ASN1_NOT_EXTENSION_ROOT, ASN1_OPTIONAL    , dissect_lte_rrc_OCTET_STRING },
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_SystemInformationBlockType9(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_SystemInformationBlockType9, SystemInformationBlockType9_sequence);

  return offset;
}



static int
dissect_lte_rrc_OCTET_STRING_SIZE_2(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_octet_string(tvb, offset, actx, tree, hf_index,
                                       2, 2, FALSE, NULL);

  return offset;
}



static int
dissect_lte_rrc_OCTET_STRING_SIZE_50(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_octet_string(tvb, offset, actx, tree, hf_index,
                                       50, 50, FALSE, NULL);

  return offset;
}


static const per_sequence_t SystemInformationBlockType10_sequence[] = {
  { &hf_lte_rrc_messageIdentifier, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lte_rrc_BIT_STRING_SIZE_16 },
  { &hf_lte_rrc_serialNumber, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lte_rrc_BIT_STRING_SIZE_16 },
  { &hf_lte_rrc_warningType , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lte_rrc_OCTET_STRING_SIZE_2 },
  { &hf_lte_rrc_warningSecurityInfo, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lte_rrc_OCTET_STRING_SIZE_50 },
  { &hf_lte_rrc_lateNonCriticalExtension, ASN1_NOT_EXTENSION_ROOT, ASN1_OPTIONAL    , dissect_lte_rrc_OCTET_STRING },
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_SystemInformationBlockType10(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_SystemInformationBlockType10, SystemInformationBlockType10_sequence);

  return offset;
}


static const value_string lte_rrc_T_warningMessageSegmentType_vals[] = {
  {   0, "notLastSegment" },
  {   1, "lastSegment" },
  { 0, NULL }
};


static int
dissect_lte_rrc_T_warningMessageSegmentType(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, FALSE, 0, NULL);

  return offset;
}



static int
dissect_lte_rrc_OCTET_STRING_SIZE_1(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_octet_string(tvb, offset, actx, tree, hf_index,
                                       1, 1, FALSE, NULL);

  return offset;
}


static const per_sequence_t SystemInformationBlockType11_sequence[] = {
  { &hf_lte_rrc_messageIdentifier, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lte_rrc_BIT_STRING_SIZE_16 },
  { &hf_lte_rrc_serialNumber, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lte_rrc_BIT_STRING_SIZE_16 },
  { &hf_lte_rrc_warningMessageSegmentType, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lte_rrc_T_warningMessageSegmentType },
  { &hf_lte_rrc_warningMessageSegmentNumber, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lte_rrc_INTEGER_0_63 },
  { &hf_lte_rrc_warningMessageSegment, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lte_rrc_OCTET_STRING },
  { &hf_lte_rrc_dataCodingScheme, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lte_rrc_OCTET_STRING_SIZE_1 },
  { &hf_lte_rrc_lateNonCriticalExtension, ASN1_NOT_EXTENSION_ROOT, ASN1_OPTIONAL    , dissect_lte_rrc_OCTET_STRING },
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_SystemInformationBlockType11(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_SystemInformationBlockType11, SystemInformationBlockType11_sequence);

  return offset;
}


static const value_string lte_rrc_T_warningMessageSegmentType_r9_vals[] = {
  {   0, "notLastSegment" },
  {   1, "lastSegment" },
  { 0, NULL }
};


static int
dissect_lte_rrc_T_warningMessageSegmentType_r9(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, FALSE, 0, NULL);

  return offset;
}


static const per_sequence_t SystemInformationBlockType12_r9_sequence[] = {
  { &hf_lte_rrc_messageIdentifier_r9, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lte_rrc_BIT_STRING_SIZE_16 },
  { &hf_lte_rrc_serialNumber_r9, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lte_rrc_BIT_STRING_SIZE_16 },
  { &hf_lte_rrc_warningMessageSegmentType_r9, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lte_rrc_T_warningMessageSegmentType_r9 },
  { &hf_lte_rrc_warningMessageSegmentNumber_r9, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lte_rrc_INTEGER_0_63 },
  { &hf_lte_rrc_warningMessageSegment_r9, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lte_rrc_OCTET_STRING },
  { &hf_lte_rrc_dataCodingScheme_r9, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lte_rrc_OCTET_STRING_SIZE_1 },
  { &hf_lte_rrc_lateNonCriticalExtension, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lte_rrc_OCTET_STRING },
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_SystemInformationBlockType12_r9(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_SystemInformationBlockType12_r9, SystemInformationBlockType12_r9_sequence);

  return offset;
}



static int
dissect_lte_rrc_INTEGER_0_255(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 255U, NULL, FALSE);

  return offset;
}


static const value_string lte_rrc_T_non_MBSFNregionLength_vals[] = {
  {   0, "s1" },
  {   1, "s2" },
  { 0, NULL }
};


static int
dissect_lte_rrc_T_non_MBSFNregionLength(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, FALSE, 0, NULL);

  return offset;
}


static const value_string lte_rrc_T_mcch_RepetitionPeriod_r9_vals[] = {
  {   0, "rf32" },
  {   1, "rf64" },
  {   2, "rf128" },
  {   3, "rf256" },
  { 0, NULL }
};


static int
dissect_lte_rrc_T_mcch_RepetitionPeriod_r9(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     4, NULL, FALSE, 0, NULL);

  return offset;
}



static int
dissect_lte_rrc_INTEGER_0_10(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 10U, NULL, FALSE);

  return offset;
}


static const value_string lte_rrc_T_mcch_ModificationPeriod_r9_vals[] = {
  {   0, "rf512" },
  {   1, "rf1024" },
  { 0, NULL }
};


static int
dissect_lte_rrc_T_mcch_ModificationPeriod_r9(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, FALSE, 0, NULL);

  return offset;
}


static const value_string lte_rrc_T_signallingMCS_r9_vals[] = {
  {   0, "n2" },
  {   1, "n7" },
  {   2, "n13" },
  {   3, "n19" },
  { 0, NULL }
};


static int
dissect_lte_rrc_T_signallingMCS_r9(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     4, NULL, FALSE, 0, NULL);

  return offset;
}


static const per_sequence_t T_mcch_Config_r9_sequence[] = {
  { &hf_lte_rrc_mcch_RepetitionPeriod_r9, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_T_mcch_RepetitionPeriod_r9 },
  { &hf_lte_rrc_mcch_Offset_r9, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_INTEGER_0_10 },
  { &hf_lte_rrc_mcch_ModificationPeriod_r9, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_T_mcch_ModificationPeriod_r9 },
  { &hf_lte_rrc_sf_AllocInfo_r9, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_BIT_STRING_SIZE_6 },
  { &hf_lte_rrc_signallingMCS_r9, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_T_signallingMCS_r9 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_T_mcch_Config_r9(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_T_mcch_Config_r9, T_mcch_Config_r9_sequence);

  return offset;
}


static const per_sequence_t MBSFN_AreaInfo_r9_sequence[] = {
  { &hf_lte_rrc_mbsfn_AreaId_r9, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lte_rrc_INTEGER_0_255 },
  { &hf_lte_rrc_non_MBSFNregionLength, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lte_rrc_T_non_MBSFNregionLength },
  { &hf_lte_rrc_notificationIndicator_r9, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lte_rrc_INTEGER_0_7 },
  { &hf_lte_rrc_mcch_Config_r9, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lte_rrc_T_mcch_Config_r9 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_MBSFN_AreaInfo_r9(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_MBSFN_AreaInfo_r9, MBSFN_AreaInfo_r9_sequence);

  return offset;
}


static const per_sequence_t MBSFN_AreaInfoList_r9_sequence_of[1] = {
  { &hf_lte_rrc_MBSFN_AreaInfoList_r9_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_MBSFN_AreaInfo_r9 },
};

static int
dissect_lte_rrc_MBSFN_AreaInfoList_r9(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_lte_rrc_MBSFN_AreaInfoList_r9, MBSFN_AreaInfoList_r9_sequence_of,
                                                  1, maxMBSFN_Area, FALSE);

  return offset;
}


static const value_string lte_rrc_T_notificationRepetitionCoeff_r9_vals[] = {
  {   0, "n2" },
  {   1, "n4" },
  { 0, NULL }
};


static int
dissect_lte_rrc_T_notificationRepetitionCoeff_r9(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, FALSE, 0, NULL);

  return offset;
}



static int
dissect_lte_rrc_INTEGER_1_6(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            1U, 6U, NULL, FALSE);

  return offset;
}


static const per_sequence_t MBMS_NotificationConfig_r9_sequence[] = {
  { &hf_lte_rrc_notificationRepetitionCoeff_r9, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_T_notificationRepetitionCoeff_r9 },
  { &hf_lte_rrc_notificationOffset_r9, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_INTEGER_0_10 },
  { &hf_lte_rrc_notificationSF_Index_r9, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_INTEGER_1_6 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_MBMS_NotificationConfig_r9(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_MBMS_NotificationConfig_r9, MBMS_NotificationConfig_r9_sequence);

  return offset;
}


static const per_sequence_t SystemInformationBlockType13_r9_sequence[] = {
  { &hf_lte_rrc_mbsfn_AreaInfoList_r9, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lte_rrc_MBSFN_AreaInfoList_r9 },
  { &hf_lte_rrc_notificationConfig_r9, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lte_rrc_MBMS_NotificationConfig_r9 },
  { &hf_lte_rrc_lateNonCriticalExtension, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lte_rrc_OCTET_STRING },
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_SystemInformationBlockType13_r9(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_SystemInformationBlockType13_r9, SystemInformationBlockType13_r9_sequence);

  return offset;
}


static const value_string lte_rrc_T_sib_TypeAndInfo_item_vals[] = {
  {   0, "sib2" },
  {   1, "sib3" },
  {   2, "sib4" },
  {   3, "sib5" },
  {   4, "sib6" },
  {   5, "sib7" },
  {   6, "sib8" },
  {   7, "sib9" },
  {   8, "sib10" },
  {   9, "sib11" },
  {  10, "sib12-v920" },
  {  11, "sib13-v920" },
  { 0, NULL }
};

static const per_choice_t T_sib_TypeAndInfo_item_choice[] = {
  {   0, &hf_lte_rrc_sib2        , ASN1_EXTENSION_ROOT    , dissect_lte_rrc_SystemInformationBlockType2 },
  {   1, &hf_lte_rrc_sib3        , ASN1_EXTENSION_ROOT    , dissect_lte_rrc_SystemInformationBlockType3 },
  {   2, &hf_lte_rrc_sib4        , ASN1_EXTENSION_ROOT    , dissect_lte_rrc_SystemInformationBlockType4 },
  {   3, &hf_lte_rrc_sib5        , ASN1_EXTENSION_ROOT    , dissect_lte_rrc_SystemInformationBlockType5 },
  {   4, &hf_lte_rrc_sib6        , ASN1_EXTENSION_ROOT    , dissect_lte_rrc_SystemInformationBlockType6 },
  {   5, &hf_lte_rrc_sib7        , ASN1_EXTENSION_ROOT    , dissect_lte_rrc_SystemInformationBlockType7 },
  {   6, &hf_lte_rrc_sib8        , ASN1_EXTENSION_ROOT    , dissect_lte_rrc_SystemInformationBlockType8 },
  {   7, &hf_lte_rrc_sib9        , ASN1_EXTENSION_ROOT    , dissect_lte_rrc_SystemInformationBlockType9 },
  {   8, &hf_lte_rrc_sib10       , ASN1_EXTENSION_ROOT    , dissect_lte_rrc_SystemInformationBlockType10 },
  {   9, &hf_lte_rrc_sib11       , ASN1_EXTENSION_ROOT    , dissect_lte_rrc_SystemInformationBlockType11 },
  {  10, &hf_lte_rrc_sib12_v920  , ASN1_NOT_EXTENSION_ROOT, dissect_lte_rrc_SystemInformationBlockType12_r9 },
  {  11, &hf_lte_rrc_sib13_v920  , ASN1_NOT_EXTENSION_ROOT, dissect_lte_rrc_SystemInformationBlockType13_r9 },
  { 0, NULL, 0, NULL }
};

static int
dissect_lte_rrc_T_sib_TypeAndInfo_item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_lte_rrc_T_sib_TypeAndInfo_item, T_sib_TypeAndInfo_item_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t T_sib_TypeAndInfo_sequence_of[1] = {
  { &hf_lte_rrc_sib_TypeAndInfo_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_T_sib_TypeAndInfo_item },
};

static int
dissect_lte_rrc_T_sib_TypeAndInfo(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_lte_rrc_T_sib_TypeAndInfo, T_sib_TypeAndInfo_sequence_of,
                                                  1, maxSIB, FALSE);

  return offset;
}


static const per_sequence_t T_nonCriticalExtension_30_sequence[] = {
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_T_nonCriticalExtension_30(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_T_nonCriticalExtension_30, T_nonCriticalExtension_30_sequence);

  return offset;
}


static const per_sequence_t SystemInformation_v8a0_IEs_sequence[] = {
  { &hf_lte_rrc_lateNonCriticalExtension, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lte_rrc_OCTET_STRING },
  { &hf_lte_rrc_nonCriticalExtension_69, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lte_rrc_T_nonCriticalExtension_30 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_SystemInformation_v8a0_IEs(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_SystemInformation_v8a0_IEs, SystemInformation_v8a0_IEs_sequence);

  return offset;
}


static const per_sequence_t SystemInformation_r8_IEs_sequence[] = {
  { &hf_lte_rrc_sib_TypeAndInfo, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_T_sib_TypeAndInfo },
  { &hf_lte_rrc_nonCriticalExtension_68, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lte_rrc_SystemInformation_v8a0_IEs },
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_SystemInformation_r8_IEs(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_SystemInformation_r8_IEs, SystemInformation_r8_IEs_sequence);

  return offset;
}


static const per_sequence_t T_criticalExtensionsFuture_28_sequence[] = {
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_T_criticalExtensionsFuture_28(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_T_criticalExtensionsFuture_28, T_criticalExtensionsFuture_28_sequence);

  return offset;
}


static const value_string lte_rrc_T_criticalExtensions_28_vals[] = {
  {   0, "systemInformation-r8" },
  {   1, "criticalExtensionsFuture" },
  { 0, NULL }
};

static const per_choice_t T_criticalExtensions_28_choice[] = {
  {   0, &hf_lte_rrc_systemInformation_r8, ASN1_NO_EXTENSIONS     , dissect_lte_rrc_SystemInformation_r8_IEs },
  {   1, &hf_lte_rrc_criticalExtensionsFuture_28, ASN1_NO_EXTENSIONS     , dissect_lte_rrc_T_criticalExtensionsFuture_28 },
  { 0, NULL, 0, NULL }
};

static int
dissect_lte_rrc_T_criticalExtensions_28(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_lte_rrc_T_criticalExtensions_28, T_criticalExtensions_28_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t SystemInformation_sequence[] = {
  { &hf_lte_rrc_criticalExtensions_28, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_T_criticalExtensions_28 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_SystemInformation(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {

col_append_str(actx->pinfo->cinfo, COL_INFO, "SystemInformation ");

  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_SystemInformation, SystemInformation_sequence);

  return offset;
}



static int
dissect_lte_rrc_MCC_MNC_Digit(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 9U, NULL, FALSE);

  return offset;
}


static const per_sequence_t MCC_sequence_of[1] = {
  { &hf_lte_rrc_MCC_item    , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_MCC_MNC_Digit },
};

static int
dissect_lte_rrc_MCC(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_lte_rrc_MCC, MCC_sequence_of,
                                                  3, 3, FALSE);

  return offset;
}


static const per_sequence_t MNC_sequence_of[1] = {
  { &hf_lte_rrc_MNC_item    , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_MCC_MNC_Digit },
};

static int
dissect_lte_rrc_MNC(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_lte_rrc_MNC, MNC_sequence_of,
                                                  2, 3, FALSE);

  return offset;
}


static const per_sequence_t PLMN_Identity_sequence[] = {
  { &hf_lte_rrc_mcc         , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lte_rrc_MCC },
  { &hf_lte_rrc_mnc         , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_MNC },
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_PLMN_Identity(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_PLMN_Identity, PLMN_Identity_sequence);

  return offset;
}


static const value_string lte_rrc_T_cellReservedForOperatorUse_vals[] = {
  {   0, "reserved" },
  {   1, "notReserved" },
  { 0, NULL }
};


static int
dissect_lte_rrc_T_cellReservedForOperatorUse(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, FALSE, 0, NULL);

  return offset;
}


static const per_sequence_t PLMN_IdentityInfo_sequence[] = {
  { &hf_lte_rrc_plmn_Identity, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_PLMN_Identity },
  { &hf_lte_rrc_cellReservedForOperatorUse, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_T_cellReservedForOperatorUse },
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_PLMN_IdentityInfo(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_PLMN_IdentityInfo, PLMN_IdentityInfo_sequence);

  return offset;
}


static const per_sequence_t PLMN_IdentityList_sequence_of[1] = {
  { &hf_lte_rrc_PLMN_IdentityList_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_PLMN_IdentityInfo },
};

static int
dissect_lte_rrc_PLMN_IdentityList(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_lte_rrc_PLMN_IdentityList, PLMN_IdentityList_sequence_of,
                                                  1, 6, FALSE);

  return offset;
}



static int
dissect_lte_rrc_TrackingAreaCode(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     16, 16, FALSE, NULL);

  return offset;
}



static int
dissect_lte_rrc_CellIdentity(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     28, 28, FALSE, NULL);

  return offset;
}


static const value_string lte_rrc_T_cellBarred_vals[] = {
  {   0, "barred" },
  {   1, "notBarred" },
  { 0, NULL }
};


static int
dissect_lte_rrc_T_cellBarred(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, FALSE, 0, NULL);

  return offset;
}


static const value_string lte_rrc_T_intraFreqReselection_vals[] = {
  {   0, "allowed" },
  {   1, "notAllowed" },
  { 0, NULL }
};


static int
dissect_lte_rrc_T_intraFreqReselection(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, FALSE, 0, NULL);

  return offset;
}



static int
dissect_lte_rrc_CSG_Identity(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     27, 27, FALSE, NULL);

  return offset;
}


static const per_sequence_t T_cellAccessRelatedInfo_sequence[] = {
  { &hf_lte_rrc_plmn_IdentityList, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_PLMN_IdentityList },
  { &hf_lte_rrc_trackingAreaCode, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_TrackingAreaCode },
  { &hf_lte_rrc_cellIdentity, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_CellIdentity },
  { &hf_lte_rrc_cellBarred  , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_T_cellBarred },
  { &hf_lte_rrc_intraFreqReselection, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_T_intraFreqReselection },
  { &hf_lte_rrc_csg_Indication, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_BOOLEAN },
  { &hf_lte_rrc_csg_Identity, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lte_rrc_CSG_Identity },
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_T_cellAccessRelatedInfo(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_T_cellAccessRelatedInfo, T_cellAccessRelatedInfo_sequence);

  return offset;
}


static const per_sequence_t T_cellSelectionInfo_sequence[] = {
  { &hf_lte_rrc_q_RxLevMin  , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_Q_RxLevMin },
  { &hf_lte_rrc_q_RxLevMinOffset, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lte_rrc_INTEGER_1_8 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_T_cellSelectionInfo(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_T_cellSelectionInfo, T_cellSelectionInfo_sequence);

  return offset;
}



static int
dissect_lte_rrc_INTEGER_1_64(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            1U, 64U, NULL, FALSE);

  return offset;
}


static const value_string lte_rrc_T_si_Periodicity_vals[] = {
  {   0, "rf8" },
  {   1, "rf16" },
  {   2, "rf32" },
  {   3, "rf64" },
  {   4, "rf128" },
  {   5, "rf256" },
  {   6, "rf512" },
  { 0, NULL }
};


static int
dissect_lte_rrc_T_si_Periodicity(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     7, NULL, FALSE, 0, NULL);

  return offset;
}


static const value_string lte_rrc_SIB_Type_vals[] = {
  {   0, "sibType3" },
  {   1, "sibType4" },
  {   2, "sibType5" },
  {   3, "sibType6" },
  {   4, "sibType7" },
  {   5, "sibType8" },
  {   6, "sibType9" },
  {   7, "sibType10" },
  {   8, "sibType11" },
  {   9, "sibType12-v920" },
  {  10, "sibType13-v920" },
  {  11, "spare5" },
  {  12, "spare4" },
  {  13, "spare3" },
  {  14, "spare2" },
  {  15, "spare1" },
  { 0, NULL }
};


static int
dissect_lte_rrc_SIB_Type(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     16, NULL, TRUE, 0, NULL);

  return offset;
}


static const per_sequence_t SIB_MappingInfo_sequence_of[1] = {
  { &hf_lte_rrc_SIB_MappingInfo_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_SIB_Type },
};

static int
dissect_lte_rrc_SIB_MappingInfo(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_lte_rrc_SIB_MappingInfo, SIB_MappingInfo_sequence_of,
                                                  0, maxSIB_1, FALSE);

  return offset;
}


static const per_sequence_t SchedulingInfo_sequence[] = {
  { &hf_lte_rrc_si_Periodicity, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_T_si_Periodicity },
  { &hf_lte_rrc_sib_MappingInfo, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_SIB_MappingInfo },
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_SchedulingInfo(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_SchedulingInfo, SchedulingInfo_sequence);

  return offset;
}


static const per_sequence_t SchedulingInfoList_sequence_of[1] = {
  { &hf_lte_rrc_SchedulingInfoList_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_SchedulingInfo },
};

static int
dissect_lte_rrc_SchedulingInfoList(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_lte_rrc_SchedulingInfoList, SchedulingInfoList_sequence_of,
                                                  1, maxSI_Message, FALSE);

  return offset;
}


static const value_string lte_rrc_T_subframeAssignment_vals[] = {
  {   0, "sa0" },
  {   1, "sa1" },
  {   2, "sa2" },
  {   3, "sa3" },
  {   4, "sa4" },
  {   5, "sa5" },
  {   6, "sa6" },
  { 0, NULL }
};


static int
dissect_lte_rrc_T_subframeAssignment(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     7, NULL, FALSE, 0, NULL);

  return offset;
}


static const value_string lte_rrc_T_specialSubframePatterns_vals[] = {
  {   0, "ssp0" },
  {   1, "ssp1" },
  {   2, "ssp2" },
  {   3, "ssp3" },
  {   4, "ssp4" },
  {   5, "ssp5" },
  {   6, "ssp6" },
  {   7, "ssp7" },
  {   8, "ssp8" },
  { 0, NULL }
};


static int
dissect_lte_rrc_T_specialSubframePatterns(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     9, NULL, FALSE, 0, NULL);

  return offset;
}


static const per_sequence_t TDD_Config_sequence[] = {
  { &hf_lte_rrc_subframeAssignment, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_T_subframeAssignment },
  { &hf_lte_rrc_specialSubframePatterns, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_T_specialSubframePatterns },
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_TDD_Config(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_TDD_Config, TDD_Config_sequence);

  return offset;
}


static const value_string lte_rrc_T_si_WindowLength_vals[] = {
  {   0, "ms1" },
  {   1, "ms2" },
  {   2, "ms5" },
  {   3, "ms10" },
  {   4, "ms15" },
  {   5, "ms20" },
  {   6, "ms40" },
  { 0, NULL }
};


static int
dissect_lte_rrc_T_si_WindowLength(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     7, NULL, FALSE, 0, NULL);

  return offset;
}


static const value_string lte_rrc_T_ims_EmergencySupport_r9_vals[] = {
  {   0, "true" },
  { 0, NULL }
};


static int
dissect_lte_rrc_T_ims_EmergencySupport_r9(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, FALSE, 0, NULL);

  return offset;
}



static int
dissect_lte_rrc_T_q_QualMinOffset_r9(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            1U, 8U, NULL, FALSE);

  proto_item_append_text(actx->created_item, "dB");


  return offset;
}


static const per_sequence_t CellSelectionInfo_v920_sequence[] = {
  { &hf_lte_rrc_q_QualMin_r9, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_Q_QualMin_r9 },
  { &hf_lte_rrc_q_QualMinOffset_r9, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lte_rrc_T_q_QualMinOffset_r9 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_CellSelectionInfo_v920(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_CellSelectionInfo_v920, CellSelectionInfo_v920_sequence);

  return offset;
}


static const per_sequence_t T_nonCriticalExtension_31_sequence[] = {
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_T_nonCriticalExtension_31(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_T_nonCriticalExtension_31, T_nonCriticalExtension_31_sequence);

  return offset;
}


static const per_sequence_t SystemInformationBlockType1_v920_IEs_sequence[] = {
  { &hf_lte_rrc_ims_EmergencySupport_r9, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lte_rrc_T_ims_EmergencySupport_r9 },
  { &hf_lte_rrc_cellSelectionInfo_v920, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lte_rrc_CellSelectionInfo_v920 },
  { &hf_lte_rrc_nonCriticalExtension_72, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lte_rrc_T_nonCriticalExtension_31 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_SystemInformationBlockType1_v920_IEs(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_SystemInformationBlockType1_v920_IEs, SystemInformationBlockType1_v920_IEs_sequence);

  return offset;
}


static const per_sequence_t SystemInformationBlockType1_v890_IEs_sequence[] = {
  { &hf_lte_rrc_lateNonCriticalExtension, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lte_rrc_OCTET_STRING },
  { &hf_lte_rrc_nonCriticalExtension_71, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lte_rrc_SystemInformationBlockType1_v920_IEs },
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_SystemInformationBlockType1_v890_IEs(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_SystemInformationBlockType1_v890_IEs, SystemInformationBlockType1_v890_IEs_sequence);

  return offset;
}


static const per_sequence_t SystemInformationBlockType1_sequence[] = {
  { &hf_lte_rrc_cellAccessRelatedInfo, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_T_cellAccessRelatedInfo },
  { &hf_lte_rrc_cellSelectionInfo, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_T_cellSelectionInfo },
  { &hf_lte_rrc_p_Max       , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lte_rrc_P_Max },
  { &hf_lte_rrc_freqBandIndicator, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_INTEGER_1_64 },
  { &hf_lte_rrc_schedulingInfoList, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_SchedulingInfoList },
  { &hf_lte_rrc_tdd_Config  , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lte_rrc_TDD_Config },
  { &hf_lte_rrc_si_WindowLength, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_T_si_WindowLength },
  { &hf_lte_rrc_systemInfoValueTag, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_INTEGER_0_31 },
  { &hf_lte_rrc_nonCriticalExtension_70, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lte_rrc_SystemInformationBlockType1_v890_IEs },
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_SystemInformationBlockType1(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {

col_append_str(actx->pinfo->cinfo, COL_INFO, "SystemInformationBlockType1 ");

  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_SystemInformationBlockType1, SystemInformationBlockType1_sequence);

  return offset;
}


static const value_string lte_rrc_T_c1_vals[] = {
  {   0, "systemInformation" },
  {   1, "systemInformationBlockType1" },
  { 0, NULL }
};

static const per_choice_t T_c1_choice[] = {
  {   0, &hf_lte_rrc_systemInformation, ASN1_NO_EXTENSIONS     , dissect_lte_rrc_SystemInformation },
  {   1, &hf_lte_rrc_systemInformationBlockType1, ASN1_NO_EXTENSIONS     , dissect_lte_rrc_SystemInformationBlockType1 },
  { 0, NULL, 0, NULL }
};

static int
dissect_lte_rrc_T_c1(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_lte_rrc_T_c1, T_c1_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t T_messageClassExtension_sequence[] = {
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_T_messageClassExtension(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_T_messageClassExtension, T_messageClassExtension_sequence);

  return offset;
}


static const value_string lte_rrc_BCCH_DL_SCH_MessageType_vals[] = {
  {   0, "c1" },
  {   1, "messageClassExtension" },
  { 0, NULL }
};

static const per_choice_t BCCH_DL_SCH_MessageType_choice[] = {
  {   0, &hf_lte_rrc_c1          , ASN1_NO_EXTENSIONS     , dissect_lte_rrc_T_c1 },
  {   1, &hf_lte_rrc_messageClassExtension, ASN1_NO_EXTENSIONS     , dissect_lte_rrc_T_messageClassExtension },
  { 0, NULL, 0, NULL }
};

static int
dissect_lte_rrc_BCCH_DL_SCH_MessageType(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_lte_rrc_BCCH_DL_SCH_MessageType, BCCH_DL_SCH_MessageType_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t BCCH_DL_SCH_Message_sequence[] = {
  { &hf_lte_rrc_message_01  , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_BCCH_DL_SCH_MessageType },
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_BCCH_DL_SCH_Message(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_BCCH_DL_SCH_Message, BCCH_DL_SCH_Message_sequence);

  return offset;
}


static const per_sequence_t CommonSF_AllocPatternList_r9_sequence_of[1] = {
  { &hf_lte_rrc_CommonSF_AllocPatternList_r9_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_MBSFN_SubframeConfig },
};

static int
dissect_lte_rrc_CommonSF_AllocPatternList_r9(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_lte_rrc_CommonSF_AllocPatternList_r9, CommonSF_AllocPatternList_r9_sequence_of,
                                                  1, maxMBSFN_Allocations, FALSE);

  return offset;
}


static const value_string lte_rrc_T_commonSF_AllocPeriod_r9_vals[] = {
  {   0, "rf4" },
  {   1, "rf8" },
  {   2, "rf16" },
  {   3, "rf32" },
  {   4, "rf64" },
  {   5, "rf128" },
  {   6, "rf256" },
  { 0, NULL }
};


static int
dissect_lte_rrc_T_commonSF_AllocPeriod_r9(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     7, NULL, FALSE, 0, NULL);

  return offset;
}



static int
dissect_lte_rrc_INTEGER_0_1535(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 1535U, NULL, FALSE);

  return offset;
}



static int
dissect_lte_rrc_INTEGER_0_28(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 28U, NULL, FALSE);

  return offset;
}


static const value_string lte_rrc_T_mch_SchedulingPeriod_r9_vals[] = {
  {   0, "rf8" },
  {   1, "rf16" },
  {   2, "rf32" },
  {   3, "rf64" },
  {   4, "rf128" },
  {   5, "rf256" },
  {   6, "rf512" },
  {   7, "rf1024" },
  { 0, NULL }
};


static int
dissect_lte_rrc_T_mch_SchedulingPeriod_r9(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     8, NULL, FALSE, 0, NULL);

  return offset;
}


static const per_sequence_t PMCH_Config_r9_sequence[] = {
  { &hf_lte_rrc_sf_AllocEnd_r9, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lte_rrc_INTEGER_0_1535 },
  { &hf_lte_rrc_dataMCS_r9  , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lte_rrc_INTEGER_0_28 },
  { &hf_lte_rrc_mch_SchedulingPeriod_r9, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lte_rrc_T_mch_SchedulingPeriod_r9 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_PMCH_Config_r9(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_PMCH_Config_r9, PMCH_Config_r9_sequence);

  return offset;
}


static const value_string lte_rrc_T_plmn_Id_r9_vals[] = {
  {   0, "plmn-Index-r9" },
  {   1, "explicitValue-r9" },
  { 0, NULL }
};

static const per_choice_t T_plmn_Id_r9_choice[] = {
  {   0, &hf_lte_rrc_plmn_Index_r9, ASN1_NO_EXTENSIONS     , dissect_lte_rrc_INTEGER_1_6 },
  {   1, &hf_lte_rrc_explicitValue_r9, ASN1_NO_EXTENSIONS     , dissect_lte_rrc_PLMN_Identity },
  { 0, NULL, 0, NULL }
};

static int
dissect_lte_rrc_T_plmn_Id_r9(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_lte_rrc_T_plmn_Id_r9, T_plmn_Id_r9_choice,
                                 NULL);

  return offset;
}



static int
dissect_lte_rrc_OCTET_STRING_SIZE_3(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_octet_string(tvb, offset, actx, tree, hf_index,
                                       3, 3, FALSE, NULL);

  return offset;
}


static const per_sequence_t TMGI_r9_sequence[] = {
  { &hf_lte_rrc_plmn_Id_r9  , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_T_plmn_Id_r9 },
  { &hf_lte_rrc_serviceId_r9, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_OCTET_STRING_SIZE_3 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_TMGI_r9(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_TMGI_r9, TMGI_r9_sequence);

  return offset;
}



static int
dissect_lte_rrc_INTEGER_0_maxSessionPerPMCH_1(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, maxSessionPerPMCH_1, NULL, FALSE);

  return offset;
}


static const per_sequence_t MBMS_SessionInfo_r9_sequence[] = {
  { &hf_lte_rrc_tmgi_r9     , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lte_rrc_TMGI_r9 },
  { &hf_lte_rrc_sessionId_r9, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lte_rrc_OCTET_STRING_SIZE_1 },
  { &hf_lte_rrc_logicalChannelIdentity_r9, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lte_rrc_INTEGER_0_maxSessionPerPMCH_1 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_MBMS_SessionInfo_r9(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_MBMS_SessionInfo_r9, MBMS_SessionInfo_r9_sequence);

  return offset;
}


static const per_sequence_t MBMS_SessionInfoList_r9_sequence_of[1] = {
  { &hf_lte_rrc_MBMS_SessionInfoList_r9_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_MBMS_SessionInfo_r9 },
};

static int
dissect_lte_rrc_MBMS_SessionInfoList_r9(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_lte_rrc_MBMS_SessionInfoList_r9, MBMS_SessionInfoList_r9_sequence_of,
                                                  0, maxSessionPerPMCH, FALSE);

  return offset;
}


static const per_sequence_t PMCH_Info_r9_sequence[] = {
  { &hf_lte_rrc_pmch_Config_r9, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lte_rrc_PMCH_Config_r9 },
  { &hf_lte_rrc_mbms_SessionInfoList_r9, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lte_rrc_MBMS_SessionInfoList_r9 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_PMCH_Info_r9(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_PMCH_Info_r9, PMCH_Info_r9_sequence);

  return offset;
}


static const per_sequence_t PMCH_InfoList_r9_sequence_of[1] = {
  { &hf_lte_rrc_PMCH_InfoList_r9_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_PMCH_Info_r9 },
};

static int
dissect_lte_rrc_PMCH_InfoList_r9(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_lte_rrc_PMCH_InfoList_r9, PMCH_InfoList_r9_sequence_of,
                                                  0, maxPMCH_PerMBSFN, FALSE);

  return offset;
}


static const per_sequence_t T_nonCriticalExtension_10_sequence[] = {
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_T_nonCriticalExtension_10(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_T_nonCriticalExtension_10, T_nonCriticalExtension_10_sequence);

  return offset;
}


static const per_sequence_t MBSFNAreaConfiguration_v930_IEs_sequence[] = {
  { &hf_lte_rrc_lateNonCriticalExtension, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lte_rrc_OCTET_STRING },
  { &hf_lte_rrc_nonCriticalExtension_19, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lte_rrc_T_nonCriticalExtension_10 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_MBSFNAreaConfiguration_v930_IEs(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_MBSFNAreaConfiguration_v930_IEs, MBSFNAreaConfiguration_v930_IEs_sequence);

  return offset;
}


static const per_sequence_t MBSFNAreaConfiguration_r9_sequence[] = {
  { &hf_lte_rrc_commonSF_Alloc_r9, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_CommonSF_AllocPatternList_r9 },
  { &hf_lte_rrc_commonSF_AllocPeriod_r9, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_T_commonSF_AllocPeriod_r9 },
  { &hf_lte_rrc_pmch_InfoList_r9, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_PMCH_InfoList_r9 },
  { &hf_lte_rrc_nonCriticalExtension_18, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lte_rrc_MBSFNAreaConfiguration_v930_IEs },
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_MBSFNAreaConfiguration_r9(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {

col_append_str(actx->pinfo->cinfo, COL_INFO, "MBSFNAreaConfiguration-r9 ");

  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_MBSFNAreaConfiguration_r9, MBSFNAreaConfiguration_r9_sequence);

  return offset;
}


static const value_string lte_rrc_T_c1_01_vals[] = {
  {   0, "mbsfnAreaConfiguration-r9" },
  { 0, NULL }
};

static const per_choice_t T_c1_01_choice[] = {
  {   0, &hf_lte_rrc_mbsfnAreaConfiguration_r9, ASN1_NO_EXTENSIONS     , dissect_lte_rrc_MBSFNAreaConfiguration_r9 },
  { 0, NULL, 0, NULL }
};

static int
dissect_lte_rrc_T_c1_01(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_lte_rrc_T_c1_01, T_c1_01_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t CountingRequestInfo_r10_sequence[] = {
  { &hf_lte_rrc_tmgi_r10    , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lte_rrc_TMGI_r9 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_CountingRequestInfo_r10(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_CountingRequestInfo_r10, CountingRequestInfo_r10_sequence);

  return offset;
}


static const per_sequence_t CountingRequestList_r10_sequence_of[1] = {
  { &hf_lte_rrc_CountingRequestList_r10_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_CountingRequestInfo_r10 },
};

static int
dissect_lte_rrc_CountingRequestList_r10(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_lte_rrc_CountingRequestList_r10, CountingRequestList_r10_sequence_of,
                                                  1, maxServiceCount, FALSE);

  return offset;
}


static const per_sequence_t T_nonCriticalExtension_08_sequence[] = {
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_T_nonCriticalExtension_08(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_T_nonCriticalExtension_08, T_nonCriticalExtension_08_sequence);

  return offset;
}


static const per_sequence_t MBMSCountingRequest_r10_sequence[] = {
  { &hf_lte_rrc_countingRequestList_r10, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_CountingRequestList_r10 },
  { &hf_lte_rrc_lateNonCriticalExtension, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lte_rrc_OCTET_STRING },
  { &hf_lte_rrc_nonCriticalExtension_16, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lte_rrc_T_nonCriticalExtension_08 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_MBMSCountingRequest_r10(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {

col_append_str(actx->pinfo->cinfo, COL_INFO, "MBMSCountingRequest-r10 ");

  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_MBMSCountingRequest_r10, MBMSCountingRequest_r10_sequence);

  return offset;
}


static const value_string lte_rrc_T_c2_vals[] = {
  {   0, "mbmsCountingRequest-r10" },
  { 0, NULL }
};

static const per_choice_t T_c2_choice[] = {
  {   0, &hf_lte_rrc_mbmsCountingRequest_r10, ASN1_NO_EXTENSIONS     , dissect_lte_rrc_MBMSCountingRequest_r10 },
  { 0, NULL, 0, NULL }
};

static int
dissect_lte_rrc_T_c2(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_lte_rrc_T_c2, T_c2_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t T_messageClassExtension_01_sequence[] = {
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_T_messageClassExtension_01(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_T_messageClassExtension_01, T_messageClassExtension_01_sequence);

  return offset;
}


static const value_string lte_rrc_T_later_vals[] = {
  {   0, "c2" },
  {   1, "messageClassExtension" },
  { 0, NULL }
};

static const per_choice_t T_later_choice[] = {
  {   0, &hf_lte_rrc_c2          , ASN1_NO_EXTENSIONS     , dissect_lte_rrc_T_c2 },
  {   1, &hf_lte_rrc_messageClassExtension_01, ASN1_NO_EXTENSIONS     , dissect_lte_rrc_T_messageClassExtension_01 },
  { 0, NULL, 0, NULL }
};

static int
dissect_lte_rrc_T_later(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_lte_rrc_T_later, T_later_choice,
                                 NULL);

  return offset;
}


static const value_string lte_rrc_MCCH_MessageType_vals[] = {
  {   0, "c1" },
  {   1, "later" },
  { 0, NULL }
};

static const per_choice_t MCCH_MessageType_choice[] = {
  {   0, &hf_lte_rrc_c1_01       , ASN1_NO_EXTENSIONS     , dissect_lte_rrc_T_c1_01 },
  {   1, &hf_lte_rrc_later       , ASN1_NO_EXTENSIONS     , dissect_lte_rrc_T_later },
  { 0, NULL, 0, NULL }
};

static int
dissect_lte_rrc_MCCH_MessageType(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_lte_rrc_MCCH_MessageType, MCCH_MessageType_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t MCCH_Message_sequence[] = {
  { &hf_lte_rrc_message_02  , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_MCCH_MessageType },
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_MCCH_Message(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_MCCH_Message, MCCH_Message_sequence);

  return offset;
}



static int
dissect_lte_rrc_MMEC(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     8, 8, FALSE, NULL);

  return offset;
}



static int
dissect_lte_rrc_BIT_STRING_SIZE_32(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     32, 32, FALSE, NULL);

  return offset;
}


static const per_sequence_t S_TMSI_sequence[] = {
  { &hf_lte_rrc_mmec        , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_MMEC },
  { &hf_lte_rrc_m_TMSI      , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_BIT_STRING_SIZE_32 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_S_TMSI(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_S_TMSI, S_TMSI_sequence);

  return offset;
}



static int
dissect_lte_rrc_IMSI_Digit(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 9U, NULL, FALSE);

  return offset;
}


static const per_sequence_t IMSI_sequence_of[1] = {
  { &hf_lte_rrc_IMSI_item   , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_IMSI_Digit },
};

static int
dissect_lte_rrc_IMSI(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_lte_rrc_IMSI, IMSI_sequence_of,
                                                  6, 21, FALSE);

  return offset;
}


static const value_string lte_rrc_PagingUE_Identity_vals[] = {
  {   0, "s-TMSI" },
  {   1, "imsi" },
  { 0, NULL }
};

static const per_choice_t PagingUE_Identity_choice[] = {
  {   0, &hf_lte_rrc_s_TMSI      , ASN1_EXTENSION_ROOT    , dissect_lte_rrc_S_TMSI },
  {   1, &hf_lte_rrc_imsi        , ASN1_EXTENSION_ROOT    , dissect_lte_rrc_IMSI },
  { 0, NULL, 0, NULL }
};

static int
dissect_lte_rrc_PagingUE_Identity(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_lte_rrc_PagingUE_Identity, PagingUE_Identity_choice,
                                 NULL);

  return offset;
}


static const value_string lte_rrc_T_cn_Domain_vals[] = {
  {   0, "ps" },
  {   1, "cs" },
  { 0, NULL }
};


static int
dissect_lte_rrc_T_cn_Domain(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, FALSE, 0, NULL);

  return offset;
}


static const per_sequence_t PagingRecord_sequence[] = {
  { &hf_lte_rrc_ue_Identity , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lte_rrc_PagingUE_Identity },
  { &hf_lte_rrc_cn_Domain   , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lte_rrc_T_cn_Domain },
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_PagingRecord(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_PagingRecord, PagingRecord_sequence);

  return offset;
}


static const per_sequence_t PagingRecordList_sequence_of[1] = {
  { &hf_lte_rrc_PagingRecordList_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_PagingRecord },
};

static int
dissect_lte_rrc_PagingRecordList(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_lte_rrc_PagingRecordList, PagingRecordList_sequence_of,
                                                  1, maxPageRec, FALSE);

  return offset;
}


static const value_string lte_rrc_T_systemInfoModification_vals[] = {
  {   0, "true" },
  { 0, NULL }
};


static int
dissect_lte_rrc_T_systemInfoModification(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, FALSE, 0, NULL);

  return offset;
}


static const value_string lte_rrc_T_etws_Indication_vals[] = {
  {   0, "true" },
  { 0, NULL }
};


static int
dissect_lte_rrc_T_etws_Indication(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, FALSE, 0, NULL);

  return offset;
}


static const value_string lte_rrc_T_cmas_Indication_r9_vals[] = {
  {   0, "true" },
  { 0, NULL }
};


static int
dissect_lte_rrc_T_cmas_Indication_r9(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, FALSE, 0, NULL);

  return offset;
}


static const per_sequence_t T_nonCriticalExtension_14_sequence[] = {
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_T_nonCriticalExtension_14(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_T_nonCriticalExtension_14, T_nonCriticalExtension_14_sequence);

  return offset;
}


static const per_sequence_t Paging_v920_IEs_sequence[] = {
  { &hf_lte_rrc_cmas_Indication_r9, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lte_rrc_T_cmas_Indication_r9 },
  { &hf_lte_rrc_nonCriticalExtension_30, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lte_rrc_T_nonCriticalExtension_14 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_Paging_v920_IEs(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_Paging_v920_IEs, Paging_v920_IEs_sequence);

  return offset;
}


static const per_sequence_t Paging_v890_IEs_sequence[] = {
  { &hf_lte_rrc_lateNonCriticalExtension, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lte_rrc_OCTET_STRING },
  { &hf_lte_rrc_nonCriticalExtension_29, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lte_rrc_Paging_v920_IEs },
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_Paging_v890_IEs(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_Paging_v890_IEs, Paging_v890_IEs_sequence);

  return offset;
}


static const per_sequence_t Paging_sequence[] = {
  { &hf_lte_rrc_pagingRecordList, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lte_rrc_PagingRecordList },
  { &hf_lte_rrc_systemInfoModification, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lte_rrc_T_systemInfoModification },
  { &hf_lte_rrc_etws_Indication, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lte_rrc_T_etws_Indication },
  { &hf_lte_rrc_nonCriticalExtension_28, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lte_rrc_Paging_v890_IEs },
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_Paging(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {

col_append_str(actx->pinfo->cinfo, COL_INFO, "Paging ");

  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_Paging, Paging_sequence);

  return offset;
}


static const value_string lte_rrc_T_c1_02_vals[] = {
  {   0, "paging" },
  { 0, NULL }
};

static const per_choice_t T_c1_02_choice[] = {
  {   0, &hf_lte_rrc_paging      , ASN1_NO_EXTENSIONS     , dissect_lte_rrc_Paging },
  { 0, NULL, 0, NULL }
};

static int
dissect_lte_rrc_T_c1_02(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_lte_rrc_T_c1_02, T_c1_02_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t T_messageClassExtension_02_sequence[] = {
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_T_messageClassExtension_02(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_T_messageClassExtension_02, T_messageClassExtension_02_sequence);

  return offset;
}


static const value_string lte_rrc_PCCH_MessageType_vals[] = {
  {   0, "c1" },
  {   1, "messageClassExtension" },
  { 0, NULL }
};

static const per_choice_t PCCH_MessageType_choice[] = {
  {   0, &hf_lte_rrc_c1_02       , ASN1_NO_EXTENSIONS     , dissect_lte_rrc_T_c1_02 },
  {   1, &hf_lte_rrc_messageClassExtension_02, ASN1_NO_EXTENSIONS     , dissect_lte_rrc_T_messageClassExtension_02 },
  { 0, NULL, 0, NULL }
};

static int
dissect_lte_rrc_PCCH_MessageType(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_lte_rrc_PCCH_MessageType, PCCH_MessageType_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t PCCH_Message_sequence[] = {
  { &hf_lte_rrc_message_03  , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_PCCH_MessageType },
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_PCCH_Message(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_PCCH_Message, PCCH_Message_sequence);

  return offset;
}



static int
dissect_lte_rrc_RRC_TransactionIdentifier(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 3U, NULL, FALSE);

  return offset;
}



static int
dissect_lte_rrc_INTEGER_1_2(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            1U, 2U, NULL, FALSE);

  return offset;
}


static const value_string lte_rrc_T_PollRetransmit_vals[] = {
  {   0, "ms5" },
  {   1, "ms10" },
  {   2, "ms15" },
  {   3, "ms20" },
  {   4, "ms25" },
  {   5, "ms30" },
  {   6, "ms35" },
  {   7, "ms40" },
  {   8, "ms45" },
  {   9, "ms50" },
  {  10, "ms55" },
  {  11, "ms60" },
  {  12, "ms65" },
  {  13, "ms70" },
  {  14, "ms75" },
  {  15, "ms80" },
  {  16, "ms85" },
  {  17, "ms90" },
  {  18, "ms95" },
  {  19, "ms100" },
  {  20, "ms105" },
  {  21, "ms110" },
  {  22, "ms115" },
  {  23, "ms120" },
  {  24, "ms125" },
  {  25, "ms130" },
  {  26, "ms135" },
  {  27, "ms140" },
  {  28, "ms145" },
  {  29, "ms150" },
  {  30, "ms155" },
  {  31, "ms160" },
  {  32, "ms165" },
  {  33, "ms170" },
  {  34, "ms175" },
  {  35, "ms180" },
  {  36, "ms185" },
  {  37, "ms190" },
  {  38, "ms195" },
  {  39, "ms200" },
  {  40, "ms205" },
  {  41, "ms210" },
  {  42, "ms215" },
  {  43, "ms220" },
  {  44, "ms225" },
  {  45, "ms230" },
  {  46, "ms235" },
  {  47, "ms240" },
  {  48, "ms245" },
  {  49, "ms250" },
  {  50, "ms300" },
  {  51, "ms350" },
  {  52, "ms400" },
  {  53, "ms450" },
  {  54, "ms500" },
  {  55, "spare9" },
  {  56, "spare8" },
  {  57, "spare7" },
  {  58, "spare6" },
  {  59, "spare5" },
  {  60, "spare4" },
  {  61, "spare3" },
  {  62, "spare2" },
  {  63, "spare1" },
  { 0, NULL }
};


static int
dissect_lte_rrc_T_PollRetransmit(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     64, NULL, FALSE, 0, NULL);

  return offset;
}


static const value_string lte_rrc_PollPDU_vals[] = {
  {   0, "p4" },
  {   1, "p8" },
  {   2, "p16" },
  {   3, "p32" },
  {   4, "p64" },
  {   5, "p128" },
  {   6, "p256" },
  {   7, "pInfinity" },
  { 0, NULL }
};


static int
dissect_lte_rrc_PollPDU(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     8, NULL, FALSE, 0, NULL);

  return offset;
}


static const value_string lte_rrc_PollByte_vals[] = {
  {   0, "kB25" },
  {   1, "kB50" },
  {   2, "kB75" },
  {   3, "kB100" },
  {   4, "kB125" },
  {   5, "kB250" },
  {   6, "kB375" },
  {   7, "kB500" },
  {   8, "kB750" },
  {   9, "kB1000" },
  {  10, "kB1250" },
  {  11, "kB1500" },
  {  12, "kB2000" },
  {  13, "kB3000" },
  {  14, "kBinfinity" },
  {  15, "spare1" },
  { 0, NULL }
};


static int
dissect_lte_rrc_PollByte(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     16, NULL, FALSE, 0, NULL);

  return offset;
}


static const value_string lte_rrc_T_maxRetxThreshold_vals[] = {
  {   0, "t1" },
  {   1, "t2" },
  {   2, "t3" },
  {   3, "t4" },
  {   4, "t6" },
  {   5, "t8" },
  {   6, "t16" },
  {   7, "t32" },
  { 0, NULL }
};


static int
dissect_lte_rrc_T_maxRetxThreshold(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     8, NULL, FALSE, 0, NULL);

  return offset;
}


static const per_sequence_t UL_AM_RLC_sequence[] = {
  { &hf_lte_rrc_t_PollRetransmit, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_T_PollRetransmit },
  { &hf_lte_rrc_pollPDU     , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_PollPDU },
  { &hf_lte_rrc_pollByte    , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_PollByte },
  { &hf_lte_rrc_maxRetxThreshold, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_T_maxRetxThreshold },
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_UL_AM_RLC(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_UL_AM_RLC, UL_AM_RLC_sequence);

  return offset;
}


static const value_string lte_rrc_T_Reordering_vals[] = {
  {   0, "ms0" },
  {   1, "ms5" },
  {   2, "ms10" },
  {   3, "ms15" },
  {   4, "ms20" },
  {   5, "ms25" },
  {   6, "ms30" },
  {   7, "ms35" },
  {   8, "ms40" },
  {   9, "ms45" },
  {  10, "ms50" },
  {  11, "ms55" },
  {  12, "ms60" },
  {  13, "ms65" },
  {  14, "ms70" },
  {  15, "ms75" },
  {  16, "ms80" },
  {  17, "ms85" },
  {  18, "ms90" },
  {  19, "ms95" },
  {  20, "ms100" },
  {  21, "ms110" },
  {  22, "ms120" },
  {  23, "ms130" },
  {  24, "ms140" },
  {  25, "ms150" },
  {  26, "ms160" },
  {  27, "ms170" },
  {  28, "ms180" },
  {  29, "ms190" },
  {  30, "ms200" },
  {  31, "spare1" },
  { 0, NULL }
};


static int
dissect_lte_rrc_T_Reordering(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     32, NULL, FALSE, 0, NULL);

  return offset;
}


static const value_string lte_rrc_T_StatusProhibit_vals[] = {
  {   0, "ms0" },
  {   1, "ms5" },
  {   2, "ms10" },
  {   3, "ms15" },
  {   4, "ms20" },
  {   5, "ms25" },
  {   6, "ms30" },
  {   7, "ms35" },
  {   8, "ms40" },
  {   9, "ms45" },
  {  10, "ms50" },
  {  11, "ms55" },
  {  12, "ms60" },
  {  13, "ms65" },
  {  14, "ms70" },
  {  15, "ms75" },
  {  16, "ms80" },
  {  17, "ms85" },
  {  18, "ms90" },
  {  19, "ms95" },
  {  20, "ms100" },
  {  21, "ms105" },
  {  22, "ms110" },
  {  23, "ms115" },
  {  24, "ms120" },
  {  25, "ms125" },
  {  26, "ms130" },
  {  27, "ms135" },
  {  28, "ms140" },
  {  29, "ms145" },
  {  30, "ms150" },
  {  31, "ms155" },
  {  32, "ms160" },
  {  33, "ms165" },
  {  34, "ms170" },
  {  35, "ms175" },
  {  36, "ms180" },
  {  37, "ms185" },
  {  38, "ms190" },
  {  39, "ms195" },
  {  40, "ms200" },
  {  41, "ms205" },
  {  42, "ms210" },
  {  43, "ms215" },
  {  44, "ms220" },
  {  45, "ms225" },
  {  46, "ms230" },
  {  47, "ms235" },
  {  48, "ms240" },
  {  49, "ms245" },
  {  50, "ms250" },
  {  51, "ms300" },
  {  52, "ms350" },
  {  53, "ms400" },
  {  54, "ms450" },
  {  55, "ms500" },
  {  56, "spare8" },
  {  57, "spare7" },
  {  58, "spare6" },
  {  59, "spare5" },
  {  60, "spare4" },
  {  61, "spare3" },
  {  62, "spare2" },
  {  63, "spare1" },
  { 0, NULL }
};


static int
dissect_lte_rrc_T_StatusProhibit(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     64, NULL, FALSE, 0, NULL);

  return offset;
}


static const per_sequence_t DL_AM_RLC_sequence[] = {
  { &hf_lte_rrc_t_Reordering, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_T_Reordering },
  { &hf_lte_rrc_t_StatusProhibit, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_T_StatusProhibit },
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_DL_AM_RLC(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_DL_AM_RLC, DL_AM_RLC_sequence);

  return offset;
}


static const per_sequence_t T_am_sequence[] = {
  { &hf_lte_rrc_ul_AM_RLC   , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_UL_AM_RLC },
  { &hf_lte_rrc_dl_AM_RLC   , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_DL_AM_RLC },
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_T_am(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_T_am, T_am_sequence);

  return offset;
}


static const value_string lte_rrc_SN_FieldLength_vals[] = {
  {   0, "size5" },
  {   1, "size10" },
  { 0, NULL }
};


static int
dissect_lte_rrc_SN_FieldLength(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, FALSE, 0, NULL);

  return offset;
}


static const per_sequence_t UL_UM_RLC_sequence[] = {
  { &hf_lte_rrc_sn_FieldLength, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_SN_FieldLength },
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_UL_UM_RLC(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_UL_UM_RLC, UL_UM_RLC_sequence);

  return offset;
}


static const per_sequence_t DL_UM_RLC_sequence[] = {
  { &hf_lte_rrc_sn_FieldLength, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_SN_FieldLength },
  { &hf_lte_rrc_t_Reordering, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_T_Reordering },
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_DL_UM_RLC(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_DL_UM_RLC, DL_UM_RLC_sequence);

  return offset;
}


static const per_sequence_t T_um_Bi_Directional_sequence[] = {
  { &hf_lte_rrc_ul_UM_RLC   , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_UL_UM_RLC },
  { &hf_lte_rrc_dl_UM_RLC   , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_DL_UM_RLC },
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_T_um_Bi_Directional(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_T_um_Bi_Directional, T_um_Bi_Directional_sequence);

  return offset;
}


static const per_sequence_t T_um_Uni_Directional_UL_sequence[] = {
  { &hf_lte_rrc_ul_UM_RLC   , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_UL_UM_RLC },
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_T_um_Uni_Directional_UL(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_T_um_Uni_Directional_UL, T_um_Uni_Directional_UL_sequence);

  return offset;
}


static const per_sequence_t T_um_Uni_Directional_DL_sequence[] = {
  { &hf_lte_rrc_dl_UM_RLC   , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_DL_UM_RLC },
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_T_um_Uni_Directional_DL(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_T_um_Uni_Directional_DL, T_um_Uni_Directional_DL_sequence);

  return offset;
}


static const value_string lte_rrc_RLC_Config_vals[] = {
  {   0, "am" },
  {   1, "um-Bi-Directional" },
  {   2, "um-Uni-Directional-UL" },
  {   3, "um-Uni-Directional-DL" },
  { 0, NULL }
};

static const per_choice_t RLC_Config_choice[] = {
  {   0, &hf_lte_rrc_am          , ASN1_EXTENSION_ROOT    , dissect_lte_rrc_T_am },
  {   1, &hf_lte_rrc_um_Bi_Directional, ASN1_EXTENSION_ROOT    , dissect_lte_rrc_T_um_Bi_Directional },
  {   2, &hf_lte_rrc_um_Uni_Directional_UL, ASN1_EXTENSION_ROOT    , dissect_lte_rrc_T_um_Uni_Directional_UL },
  {   3, &hf_lte_rrc_um_Uni_Directional_DL, ASN1_EXTENSION_ROOT    , dissect_lte_rrc_T_um_Uni_Directional_DL },
  { 0, NULL, 0, NULL }
};

static int
dissect_lte_rrc_RLC_Config(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_lte_rrc_RLC_Config, RLC_Config_choice,
                                 NULL);

  return offset;
}


static const value_string lte_rrc_T_rlc_Config_vals[] = {
  {   0, "explicitValue" },
  {   1, "defaultValue" },
  { 0, NULL }
};

static const per_choice_t T_rlc_Config_choice[] = {
  {   0, &hf_lte_rrc_explicitValue_02, ASN1_NO_EXTENSIONS     , dissect_lte_rrc_RLC_Config },
  {   1, &hf_lte_rrc_defaultValue, ASN1_NO_EXTENSIONS     , dissect_lte_rrc_NULL },
  { 0, NULL, 0, NULL }
};

static int
dissect_lte_rrc_T_rlc_Config(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_lte_rrc_T_rlc_Config, T_rlc_Config_choice,
                                 NULL);

  return offset;
}


static const value_string lte_rrc_T_prioritisedBitRate_vals[] = {
  {   0, "kBps0" },
  {   1, "kBps8" },
  {   2, "kBps16" },
  {   3, "kBps32" },
  {   4, "kBps64" },
  {   5, "kBps128" },
  {   6, "kBps256" },
  {   7, "infinity" },
  {   8, "kBps512-v1020" },
  {   9, "kBps1024-v1020" },
  {  10, "kBps2048-v1020" },
  {  11, "spare5" },
  {  12, "spare4" },
  {  13, "spare3" },
  {  14, "spare2" },
  {  15, "spare1" },
  { 0, NULL }
};


static int
dissect_lte_rrc_T_prioritisedBitRate(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     16, NULL, FALSE, 0, NULL);

  return offset;
}


static const value_string lte_rrc_T_bucketSizeDuration_vals[] = {
  {   0, "ms50" },
  {   1, "ms100" },
  {   2, "ms150" },
  {   3, "ms300" },
  {   4, "ms500" },
  {   5, "ms1000" },
  {   6, "spare2" },
  {   7, "spare1" },
  { 0, NULL }
};


static int
dissect_lte_rrc_T_bucketSizeDuration(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     8, NULL, FALSE, 0, NULL);

  return offset;
}


static const per_sequence_t T_ul_SpecificParameters_sequence[] = {
  { &hf_lte_rrc_priority    , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_INTEGER_1_16 },
  { &hf_lte_rrc_prioritisedBitRate, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_T_prioritisedBitRate },
  { &hf_lte_rrc_bucketSizeDuration, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_T_bucketSizeDuration },
  { &hf_lte_rrc_logicalChannelGroup, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lte_rrc_INTEGER_0_3 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_T_ul_SpecificParameters(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_T_ul_SpecificParameters, T_ul_SpecificParameters_sequence);

  return offset;
}


static const value_string lte_rrc_T_logicalChannelSR_Mask_r9_vals[] = {
  {   0, "setup" },
  { 0, NULL }
};


static int
dissect_lte_rrc_T_logicalChannelSR_Mask_r9(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, FALSE, 0, NULL);

  return offset;
}


static const per_sequence_t LogicalChannelConfig_eag_1_sequence[] = {
  { &hf_lte_rrc_logicalChannelSR_Mask_r9, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lte_rrc_T_logicalChannelSR_Mask_r9 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_LogicalChannelConfig_eag_1(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence_eag(tvb, offset, actx, tree, LogicalChannelConfig_eag_1_sequence);

  return offset;
}


static const per_sequence_t LogicalChannelConfig_sequence[] = {
  { &hf_lte_rrc_ul_SpecificParameters, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lte_rrc_T_ul_SpecificParameters },
  { &hf_lte_rrc_dummy_eag_field, ASN1_NOT_EXTENSION_ROOT, ASN1_NOT_OPTIONAL, dissect_lte_rrc_LogicalChannelConfig_eag_1 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_LogicalChannelConfig(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_LogicalChannelConfig, LogicalChannelConfig_sequence);

  return offset;
}


static const value_string lte_rrc_T_logicalChannelConfig_vals[] = {
  {   0, "explicitValue" },
  {   1, "defaultValue" },
  { 0, NULL }
};

static const per_choice_t T_logicalChannelConfig_choice[] = {
  {   0, &hf_lte_rrc_explicitValue_03, ASN1_NO_EXTENSIONS     , dissect_lte_rrc_LogicalChannelConfig },
  {   1, &hf_lte_rrc_defaultValue, ASN1_NO_EXTENSIONS     , dissect_lte_rrc_NULL },
  { 0, NULL, 0, NULL }
};

static int
dissect_lte_rrc_T_logicalChannelConfig(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_lte_rrc_T_logicalChannelConfig, T_logicalChannelConfig_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t SRB_ToAddMod_sequence[] = {
  { &hf_lte_rrc_srb_Identity, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lte_rrc_INTEGER_1_2 },
  { &hf_lte_rrc_rlc_Config  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lte_rrc_T_rlc_Config },
  { &hf_lte_rrc_logicalChannelConfig, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lte_rrc_T_logicalChannelConfig },
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_SRB_ToAddMod(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_SRB_ToAddMod, SRB_ToAddMod_sequence);

  return offset;
}


static const per_sequence_t SRB_ToAddModList_sequence_of[1] = {
  { &hf_lte_rrc_SRB_ToAddModList_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_SRB_ToAddMod },
};

static int
dissect_lte_rrc_SRB_ToAddModList(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_lte_rrc_SRB_ToAddModList, SRB_ToAddModList_sequence_of,
                                                  1, 2, FALSE);

  return offset;
}



static int
dissect_lte_rrc_DRB_Identity(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            1U, 32U, NULL, FALSE);

  return offset;
}


static const value_string lte_rrc_T_discardTimer_vals[] = {
  {   0, "ms50" },
  {   1, "ms100" },
  {   2, "ms150" },
  {   3, "ms300" },
  {   4, "ms500" },
  {   5, "ms750" },
  {   6, "ms1500" },
  {   7, "infinity" },
  { 0, NULL }
};


static int
dissect_lte_rrc_T_discardTimer(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     8, NULL, FALSE, 0, NULL);

  return offset;
}


static const per_sequence_t T_rlc_AM_sequence[] = {
  { &hf_lte_rrc_statusReportRequired, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_BOOLEAN },
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_T_rlc_AM(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_T_rlc_AM, T_rlc_AM_sequence);

  return offset;
}


static const value_string lte_rrc_T_pdcp_SN_Size_vals[] = {
  {   0, "len7bits" },
  {   1, "len12bits" },
  { 0, NULL }
};


static int
dissect_lte_rrc_T_pdcp_SN_Size(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, FALSE, 0, NULL);

  return offset;
}


static const per_sequence_t T_rlc_UM_sequence[] = {
  { &hf_lte_rrc_pdcp_SN_Size, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_T_pdcp_SN_Size },
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_T_rlc_UM(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_T_rlc_UM, T_rlc_UM_sequence);

  return offset;
}



static int
dissect_lte_rrc_INTEGER_1_16383(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            1U, 16383U, NULL, FALSE);

  return offset;
}


static const per_sequence_t T_profiles_sequence[] = {
  { &hf_lte_rrc_profile0x0001, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_BOOLEAN },
  { &hf_lte_rrc_profile0x0002, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_BOOLEAN },
  { &hf_lte_rrc_profile0x0003, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_BOOLEAN },
  { &hf_lte_rrc_profile0x0004, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_BOOLEAN },
  { &hf_lte_rrc_profile0x0006, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_BOOLEAN },
  { &hf_lte_rrc_profile0x0101, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_BOOLEAN },
  { &hf_lte_rrc_profile0x0102, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_BOOLEAN },
  { &hf_lte_rrc_profile0x0103, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_BOOLEAN },
  { &hf_lte_rrc_profile0x0104, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_BOOLEAN },
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_T_profiles(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_T_profiles, T_profiles_sequence);

  return offset;
}


static const per_sequence_t T_rohc_sequence[] = {
  { &hf_lte_rrc_maxCID      , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lte_rrc_INTEGER_1_16383 },
  { &hf_lte_rrc_profiles    , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lte_rrc_T_profiles },
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_T_rohc(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_T_rohc, T_rohc_sequence);

  return offset;
}


static const value_string lte_rrc_T_headerCompression_vals[] = {
  {   0, "notUsed" },
  {   1, "rohc" },
  { 0, NULL }
};

static const per_choice_t T_headerCompression_choice[] = {
  {   0, &hf_lte_rrc_notUsed     , ASN1_NO_EXTENSIONS     , dissect_lte_rrc_NULL },
  {   1, &hf_lte_rrc_rohc        , ASN1_NO_EXTENSIONS     , dissect_lte_rrc_T_rohc },
  { 0, NULL, 0, NULL }
};

static int
dissect_lte_rrc_T_headerCompression(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_lte_rrc_T_headerCompression, T_headerCompression_choice,
                                 NULL);

  return offset;
}


static const value_string lte_rrc_T_rn_IntegrityProtection_r10_vals[] = {
  {   0, "enabled" },
  { 0, NULL }
};


static int
dissect_lte_rrc_T_rn_IntegrityProtection_r10(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, FALSE, 0, NULL);

  return offset;
}


static const per_sequence_t PDCP_Config_eag_1_sequence[] = {
  { &hf_lte_rrc_rn_IntegrityProtection_r10, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lte_rrc_T_rn_IntegrityProtection_r10 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_PDCP_Config_eag_1(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence_eag(tvb, offset, actx, tree, PDCP_Config_eag_1_sequence);

  return offset;
}


static const per_sequence_t PDCP_Config_sequence[] = {
  { &hf_lte_rrc_discardTimer, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lte_rrc_T_discardTimer },
  { &hf_lte_rrc_rlc_AM      , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lte_rrc_T_rlc_AM },
  { &hf_lte_rrc_rlc_UM      , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lte_rrc_T_rlc_UM },
  { &hf_lte_rrc_headerCompression, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lte_rrc_T_headerCompression },
  { &hf_lte_rrc_dummy_eag_field, ASN1_NOT_EXTENSION_ROOT, ASN1_NOT_OPTIONAL, dissect_lte_rrc_PDCP_Config_eag_1 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_PDCP_Config(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_PDCP_Config, PDCP_Config_sequence);

  return offset;
}



static int
dissect_lte_rrc_INTEGER_3_10(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            3U, 10U, NULL, FALSE);

  return offset;
}


static const per_sequence_t DRB_ToAddMod_sequence[] = {
  { &hf_lte_rrc_eps_BearerIdentity, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lte_rrc_INTEGER_0_15 },
  { &hf_lte_rrc_drb_Identity, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lte_rrc_DRB_Identity },
  { &hf_lte_rrc_pdcp_Config , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lte_rrc_PDCP_Config },
  { &hf_lte_rrc_rlc_Config_01, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lte_rrc_RLC_Config },
  { &hf_lte_rrc_logicalChannelIdentity, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lte_rrc_INTEGER_3_10 },
  { &hf_lte_rrc_logicalChannelConfig_01, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lte_rrc_LogicalChannelConfig },
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_DRB_ToAddMod(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_DRB_ToAddMod, DRB_ToAddMod_sequence);

  return offset;
}


static const per_sequence_t DRB_ToAddModList_sequence_of[1] = {
  { &hf_lte_rrc_DRB_ToAddModList_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_DRB_ToAddMod },
};

static int
dissect_lte_rrc_DRB_ToAddModList(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_lte_rrc_DRB_ToAddModList, DRB_ToAddModList_sequence_of,
                                                  1, maxDRB, FALSE);

  return offset;
}


static const per_sequence_t DRB_ToReleaseList_sequence_of[1] = {
  { &hf_lte_rrc_DRB_ToReleaseList_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_DRB_Identity },
};

static int
dissect_lte_rrc_DRB_ToReleaseList(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_lte_rrc_DRB_ToReleaseList, DRB_ToReleaseList_sequence_of,
                                                  1, maxDRB, FALSE);

  return offset;
}


static const value_string lte_rrc_T_maxHARQ_Tx_vals[] = {
  {   0, "n1" },
  {   1, "n2" },
  {   2, "n3" },
  {   3, "n4" },
  {   4, "n5" },
  {   5, "n6" },
  {   6, "n7" },
  {   7, "n8" },
  {   8, "n10" },
  {   9, "n12" },
  {  10, "n16" },
  {  11, "n20" },
  {  12, "n24" },
  {  13, "n28" },
  {  14, "spare2" },
  {  15, "spare1" },
  { 0, NULL }
};


static int
dissect_lte_rrc_T_maxHARQ_Tx(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     16, NULL, FALSE, 0, NULL);

  return offset;
}


static const value_string lte_rrc_T_periodicBSR_Timer_vals[] = {
  {   0, "sf5" },
  {   1, "sf10" },
  {   2, "sf16" },
  {   3, "sf20" },
  {   4, "sf32" },
  {   5, "sf40" },
  {   6, "sf64" },
  {   7, "sf80" },
  {   8, "sf128" },
  {   9, "sf160" },
  {  10, "sf320" },
  {  11, "sf640" },
  {  12, "sf1280" },
  {  13, "sf2560" },
  {  14, "infinity" },
  {  15, "spare1" },
  { 0, NULL }
};


static int
dissect_lte_rrc_T_periodicBSR_Timer(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     16, NULL, FALSE, 0, NULL);

  return offset;
}


static const value_string lte_rrc_T_retxBSR_Timer_vals[] = {
  {   0, "sf320" },
  {   1, "sf640" },
  {   2, "sf1280" },
  {   3, "sf2560" },
  {   4, "sf5120" },
  {   5, "sf10240" },
  {   6, "spare2" },
  {   7, "spare1" },
  { 0, NULL }
};


static int
dissect_lte_rrc_T_retxBSR_Timer(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     8, NULL, FALSE, 0, NULL);

  return offset;
}


static const per_sequence_t T_ul_SCH_Config_sequence[] = {
  { &hf_lte_rrc_maxHARQ_Tx  , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lte_rrc_T_maxHARQ_Tx },
  { &hf_lte_rrc_periodicBSR_Timer, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lte_rrc_T_periodicBSR_Timer },
  { &hf_lte_rrc_retxBSR_Timer, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_T_retxBSR_Timer },
  { &hf_lte_rrc_ttiBundling , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_BOOLEAN },
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_T_ul_SCH_Config(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_T_ul_SCH_Config, T_ul_SCH_Config_sequence);

  return offset;
}


static const value_string lte_rrc_T_onDurationTimer_vals[] = {
  {   0, "psf1" },
  {   1, "psf2" },
  {   2, "psf3" },
  {   3, "psf4" },
  {   4, "psf5" },
  {   5, "psf6" },
  {   6, "psf8" },
  {   7, "psf10" },
  {   8, "psf20" },
  {   9, "psf30" },
  {  10, "psf40" },
  {  11, "psf50" },
  {  12, "psf60" },
  {  13, "psf80" },
  {  14, "psf100" },
  {  15, "psf200" },
  { 0, NULL }
};


static int
dissect_lte_rrc_T_onDurationTimer(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     16, NULL, FALSE, 0, NULL);

  return offset;
}


static const value_string lte_rrc_T_drx_InactivityTimer_vals[] = {
  {   0, "psf1" },
  {   1, "psf2" },
  {   2, "psf3" },
  {   3, "psf4" },
  {   4, "psf5" },
  {   5, "psf6" },
  {   6, "psf8" },
  {   7, "psf10" },
  {   8, "psf20" },
  {   9, "psf30" },
  {  10, "psf40" },
  {  11, "psf50" },
  {  12, "psf60" },
  {  13, "psf80" },
  {  14, "psf100" },
  {  15, "psf200" },
  {  16, "psf300" },
  {  17, "psf500" },
  {  18, "psf750" },
  {  19, "psf1280" },
  {  20, "psf1920" },
  {  21, "psf2560" },
  {  22, "psf0-v1020" },
  {  23, "spare9" },
  {  24, "spare8" },
  {  25, "spare7" },
  {  26, "spare6" },
  {  27, "spare5" },
  {  28, "spare4" },
  {  29, "spare3" },
  {  30, "spare2" },
  {  31, "spare1" },
  { 0, NULL }
};


static int
dissect_lte_rrc_T_drx_InactivityTimer(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     32, NULL, FALSE, 0, NULL);

  return offset;
}


static const value_string lte_rrc_T_drx_RetransmissionTimer_vals[] = {
  {   0, "psf1" },
  {   1, "psf2" },
  {   2, "psf4" },
  {   3, "psf6" },
  {   4, "psf8" },
  {   5, "psf16" },
  {   6, "psf24" },
  {   7, "psf33" },
  { 0, NULL }
};


static int
dissect_lte_rrc_T_drx_RetransmissionTimer(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     8, NULL, FALSE, 0, NULL);

  return offset;
}



static int
dissect_lte_rrc_INTEGER_0_9(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 9U, NULL, FALSE);

  return offset;
}



static int
dissect_lte_rrc_INTEGER_0_19(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 19U, NULL, FALSE);

  return offset;
}



static int
dissect_lte_rrc_INTEGER_0_39(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 39U, NULL, FALSE);

  return offset;
}



static int
dissect_lte_rrc_INTEGER_0_79(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 79U, NULL, FALSE);

  return offset;
}



static int
dissect_lte_rrc_INTEGER_0_127(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 127U, NULL, FALSE);

  return offset;
}



static int
dissect_lte_rrc_INTEGER_0_159(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 159U, NULL, FALSE);

  return offset;
}



static int
dissect_lte_rrc_INTEGER_0_319(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 319U, NULL, FALSE);

  return offset;
}



static int
dissect_lte_rrc_INTEGER_0_511(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 511U, NULL, FALSE);

  return offset;
}



static int
dissect_lte_rrc_INTEGER_0_639(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 639U, NULL, FALSE);

  return offset;
}



static int
dissect_lte_rrc_INTEGER_0_1023(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 1023U, NULL, FALSE);

  return offset;
}



static int
dissect_lte_rrc_INTEGER_0_1279(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 1279U, NULL, FALSE);

  return offset;
}



static int
dissect_lte_rrc_INTEGER_0_2559(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 2559U, NULL, FALSE);

  return offset;
}


static const value_string lte_rrc_T_longDRX_CycleStartOffset_vals[] = {
  {   0, "sf10" },
  {   1, "sf20" },
  {   2, "sf32" },
  {   3, "sf40" },
  {   4, "sf64" },
  {   5, "sf80" },
  {   6, "sf128" },
  {   7, "sf160" },
  {   8, "sf256" },
  {   9, "sf320" },
  {  10, "sf512" },
  {  11, "sf640" },
  {  12, "sf1024" },
  {  13, "sf1280" },
  {  14, "sf2048" },
  {  15, "sf2560" },
  { 0, NULL }
};

static const per_choice_t T_longDRX_CycleStartOffset_choice[] = {
  {   0, &hf_lte_rrc_sf10        , ASN1_NO_EXTENSIONS     , dissect_lte_rrc_INTEGER_0_9 },
  {   1, &hf_lte_rrc_sf20        , ASN1_NO_EXTENSIONS     , dissect_lte_rrc_INTEGER_0_19 },
  {   2, &hf_lte_rrc_sf32        , ASN1_NO_EXTENSIONS     , dissect_lte_rrc_INTEGER_0_31 },
  {   3, &hf_lte_rrc_sf40        , ASN1_NO_EXTENSIONS     , dissect_lte_rrc_INTEGER_0_39 },
  {   4, &hf_lte_rrc_sf64        , ASN1_NO_EXTENSIONS     , dissect_lte_rrc_INTEGER_0_63 },
  {   5, &hf_lte_rrc_sf80        , ASN1_NO_EXTENSIONS     , dissect_lte_rrc_INTEGER_0_79 },
  {   6, &hf_lte_rrc_sf128       , ASN1_NO_EXTENSIONS     , dissect_lte_rrc_INTEGER_0_127 },
  {   7, &hf_lte_rrc_sf160       , ASN1_NO_EXTENSIONS     , dissect_lte_rrc_INTEGER_0_159 },
  {   8, &hf_lte_rrc_sf256       , ASN1_NO_EXTENSIONS     , dissect_lte_rrc_INTEGER_0_255 },
  {   9, &hf_lte_rrc_sf320       , ASN1_NO_EXTENSIONS     , dissect_lte_rrc_INTEGER_0_319 },
  {  10, &hf_lte_rrc_sf512       , ASN1_NO_EXTENSIONS     , dissect_lte_rrc_INTEGER_0_511 },
  {  11, &hf_lte_rrc_sf640       , ASN1_NO_EXTENSIONS     , dissect_lte_rrc_INTEGER_0_639 },
  {  12, &hf_lte_rrc_sf1024      , ASN1_NO_EXTENSIONS     , dissect_lte_rrc_INTEGER_0_1023 },
  {  13, &hf_lte_rrc_sf1280      , ASN1_NO_EXTENSIONS     , dissect_lte_rrc_INTEGER_0_1279 },
  {  14, &hf_lte_rrc_sf2048      , ASN1_NO_EXTENSIONS     , dissect_lte_rrc_INTEGER_0_2047 },
  {  15, &hf_lte_rrc_sf2560      , ASN1_NO_EXTENSIONS     , dissect_lte_rrc_INTEGER_0_2559 },
  { 0, NULL, 0, NULL }
};

static int
dissect_lte_rrc_T_longDRX_CycleStartOffset(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_lte_rrc_T_longDRX_CycleStartOffset, T_longDRX_CycleStartOffset_choice,
                                 NULL);

  return offset;
}


static const value_string lte_rrc_T_shortDRX_Cycle_vals[] = {
  {   0, "sf2" },
  {   1, "sf5" },
  {   2, "sf8" },
  {   3, "sf10" },
  {   4, "sf16" },
  {   5, "sf20" },
  {   6, "sf32" },
  {   7, "sf40" },
  {   8, "sf64" },
  {   9, "sf80" },
  {  10, "sf128" },
  {  11, "sf160" },
  {  12, "sf256" },
  {  13, "sf320" },
  {  14, "sf512" },
  {  15, "sf640" },
  { 0, NULL }
};


static int
dissect_lte_rrc_T_shortDRX_Cycle(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     16, NULL, FALSE, 0, NULL);

  return offset;
}



static int
dissect_lte_rrc_T_drxShortCycleTimer(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            1U, 16U, NULL, FALSE);

  proto_item_append_text(actx->created_item, " (multiples of shortDRX-Cycle)");


  return offset;
}


static const per_sequence_t T_shortDRX_sequence[] = {
  { &hf_lte_rrc_shortDRX_Cycle, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_T_shortDRX_Cycle },
  { &hf_lte_rrc_drxShortCycleTimer, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_T_drxShortCycleTimer },
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_T_shortDRX(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_T_shortDRX, T_shortDRX_sequence);

  return offset;
}


static const per_sequence_t T_setup_10_sequence[] = {
  { &hf_lte_rrc_onDurationTimer, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_T_onDurationTimer },
  { &hf_lte_rrc_drx_InactivityTimer, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_T_drx_InactivityTimer },
  { &hf_lte_rrc_drx_RetransmissionTimer, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_T_drx_RetransmissionTimer },
  { &hf_lte_rrc_longDRX_CycleStartOffset, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_T_longDRX_CycleStartOffset },
  { &hf_lte_rrc_shortDRX    , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lte_rrc_T_shortDRX },
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_T_setup_10(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_T_setup_10, T_setup_10_sequence);

  return offset;
}


static const value_string lte_rrc_DRX_Config_vals[] = {
  {   0, "release" },
  {   1, "setup" },
  { 0, NULL }
};

static const per_choice_t DRX_Config_choice[] = {
  {   0, &hf_lte_rrc_release     , ASN1_NO_EXTENSIONS     , dissect_lte_rrc_NULL },
  {   1, &hf_lte_rrc_setup_10    , ASN1_NO_EXTENSIONS     , dissect_lte_rrc_T_setup_10 },
  { 0, NULL, 0, NULL }
};

static int
dissect_lte_rrc_DRX_Config(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_lte_rrc_DRX_Config, DRX_Config_choice,
                                 NULL);

  return offset;
}


static const value_string lte_rrc_T_periodicPHR_Timer_vals[] = {
  {   0, "sf10" },
  {   1, "sf20" },
  {   2, "sf50" },
  {   3, "sf100" },
  {   4, "sf200" },
  {   5, "sf500" },
  {   6, "sf1000" },
  {   7, "infinity" },
  { 0, NULL }
};


static int
dissect_lte_rrc_T_periodicPHR_Timer(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     8, NULL, FALSE, 0, NULL);

  return offset;
}


static const value_string lte_rrc_T_prohibitPHR_Timer_vals[] = {
  {   0, "sf0" },
  {   1, "sf10" },
  {   2, "sf20" },
  {   3, "sf50" },
  {   4, "sf100" },
  {   5, "sf200" },
  {   6, "sf500" },
  {   7, "sf1000" },
  { 0, NULL }
};


static int
dissect_lte_rrc_T_prohibitPHR_Timer(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     8, NULL, FALSE, 0, NULL);

  return offset;
}


static const value_string lte_rrc_T_dl_PathlossChange_vals[] = {
  {   0, "dB1" },
  {   1, "dB3" },
  {   2, "dB6" },
  {   3, "infinity" },
  { 0, NULL }
};


static int
dissect_lte_rrc_T_dl_PathlossChange(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     4, NULL, FALSE, 0, NULL);

  return offset;
}


static const per_sequence_t T_setup_09_sequence[] = {
  { &hf_lte_rrc_periodicPHR_Timer, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_T_periodicPHR_Timer },
  { &hf_lte_rrc_prohibitPHR_Timer, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_T_prohibitPHR_Timer },
  { &hf_lte_rrc_dl_PathlossChange, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_T_dl_PathlossChange },
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_T_setup_09(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_T_setup_09, T_setup_09_sequence);

  return offset;
}


static const value_string lte_rrc_T_phr_Config_vals[] = {
  {   0, "release" },
  {   1, "setup" },
  { 0, NULL }
};

static const per_choice_t T_phr_Config_choice[] = {
  {   0, &hf_lte_rrc_release     , ASN1_NO_EXTENSIONS     , dissect_lte_rrc_NULL },
  {   1, &hf_lte_rrc_setup_09    , ASN1_NO_EXTENSIONS     , dissect_lte_rrc_T_setup_09 },
  { 0, NULL, 0, NULL }
};

static int
dissect_lte_rrc_T_phr_Config(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_lte_rrc_T_phr_Config, T_phr_Config_choice,
                                 NULL);

  return offset;
}



static int
dissect_lte_rrc_T_sr_ProhibitTimer_r9(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 7U, NULL, FALSE);

  proto_item_append_text(actx->created_item, " (number of SR periods)");


  return offset;
}


static const per_sequence_t MAC_MainConfig_eag_1_sequence[] = {
  { &hf_lte_rrc_sr_ProhibitTimer_r9, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lte_rrc_T_sr_ProhibitTimer_r9 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_MAC_MainConfig_eag_1(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence_eag(tvb, offset, actx, tree, MAC_MainConfig_eag_1_sequence);

  return offset;
}


static const value_string lte_rrc_T_sCellDeactivationTimer_r10_vals[] = {
  {   0, "rf2" },
  {   1, "rf4" },
  {   2, "rf8" },
  {   3, "rf16" },
  {   4, "rf32" },
  {   5, "rf64" },
  {   6, "rf128" },
  {   7, "spare" },
  { 0, NULL }
};


static int
dissect_lte_rrc_T_sCellDeactivationTimer_r10(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     8, NULL, FALSE, 0, NULL);

  return offset;
}


static const value_string lte_rrc_T_extendedBSR_Sizes_r10_vals[] = {
  {   0, "setup" },
  { 0, NULL }
};


static int
dissect_lte_rrc_T_extendedBSR_Sizes_r10(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, FALSE, 0, NULL);

  return offset;
}


static const value_string lte_rrc_T_extendedPHR_r10_vals[] = {
  {   0, "setup" },
  { 0, NULL }
};


static int
dissect_lte_rrc_T_extendedPHR_r10(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, FALSE, 0, NULL);

  return offset;
}


static const per_sequence_t T_mac_MainConfig_v1020_sequence[] = {
  { &hf_lte_rrc_sCellDeactivationTimer_r10, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lte_rrc_T_sCellDeactivationTimer_r10 },
  { &hf_lte_rrc_extendedBSR_Sizes_r10, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lte_rrc_T_extendedBSR_Sizes_r10 },
  { &hf_lte_rrc_extendedPHR_r10, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lte_rrc_T_extendedPHR_r10 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_T_mac_MainConfig_v1020(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_T_mac_MainConfig_v1020, T_mac_MainConfig_v1020_sequence);

  return offset;
}


static const per_sequence_t MAC_MainConfig_eag_2_sequence[] = {
  { &hf_lte_rrc_mac_MainConfig_v1020, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lte_rrc_T_mac_MainConfig_v1020 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_MAC_MainConfig_eag_2(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence_eag(tvb, offset, actx, tree, MAC_MainConfig_eag_2_sequence);

  return offset;
}


static const per_sequence_t MAC_MainConfig_sequence[] = {
  { &hf_lte_rrc_ul_SCH_Config, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lte_rrc_T_ul_SCH_Config },
  { &hf_lte_rrc_drx_Config  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lte_rrc_DRX_Config },
  { &hf_lte_rrc_timeAlignmentTimerDedicated, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lte_rrc_TimeAlignmentTimer },
  { &hf_lte_rrc_phr_Config  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lte_rrc_T_phr_Config },
  { &hf_lte_rrc_dummy_eag_field, ASN1_NOT_EXTENSION_ROOT, ASN1_NOT_OPTIONAL, dissect_lte_rrc_MAC_MainConfig_eag_1 },
  { &hf_lte_rrc_dummy_eag_field, ASN1_NOT_EXTENSION_ROOT, ASN1_NOT_OPTIONAL, dissect_lte_rrc_MAC_MainConfig_eag_2 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_MAC_MainConfig(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_MAC_MainConfig, MAC_MainConfig_sequence);

  return offset;
}


static const value_string lte_rrc_T_mac_MainConfig_vals[] = {
  {   0, "explicitValue" },
  {   1, "defaultValue" },
  { 0, NULL }
};

static const per_choice_t T_mac_MainConfig_choice[] = {
  {   0, &hf_lte_rrc_explicitValue_01, ASN1_NO_EXTENSIONS     , dissect_lte_rrc_MAC_MainConfig },
  {   1, &hf_lte_rrc_defaultValue, ASN1_NO_EXTENSIONS     , dissect_lte_rrc_NULL },
  { 0, NULL, 0, NULL }
};

static int
dissect_lte_rrc_T_mac_MainConfig(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_lte_rrc_T_mac_MainConfig, T_mac_MainConfig_choice,
                                 NULL);

  return offset;
}



static int
dissect_lte_rrc_C_RNTI(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     16, 16, FALSE, NULL);

  return offset;
}


static const value_string lte_rrc_T_semiPersistSchedIntervalDL_vals[] = {
  {   0, "sf10" },
  {   1, "sf20" },
  {   2, "sf32" },
  {   3, "sf40" },
  {   4, "sf64" },
  {   5, "sf80" },
  {   6, "sf128" },
  {   7, "sf160" },
  {   8, "sf320" },
  {   9, "sf640" },
  {  10, "spare6" },
  {  11, "spare5" },
  {  12, "spare4" },
  {  13, "spare3" },
  {  14, "spare2" },
  {  15, "spare1" },
  { 0, NULL }
};


static int
dissect_lte_rrc_T_semiPersistSchedIntervalDL(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     16, NULL, FALSE, 0, NULL);

  return offset;
}


static const per_sequence_t N1PUCCH_AN_PersistentList_sequence_of[1] = {
  { &hf_lte_rrc_N1PUCCH_AN_PersistentList_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_INTEGER_0_2047 },
};

static int
dissect_lte_rrc_N1PUCCH_AN_PersistentList(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_lte_rrc_N1PUCCH_AN_PersistentList, N1PUCCH_AN_PersistentList_sequence_of,
                                                  1, 4, FALSE);

  return offset;
}


static const per_sequence_t T_setup_22_sequence[] = {
  { &hf_lte_rrc_n1PUCCH_AN_PersistentListP1_r10, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_N1PUCCH_AN_PersistentList },
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_T_setup_22(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_T_setup_22, T_setup_22_sequence);

  return offset;
}


static const value_string lte_rrc_T_twoAntennaPortActivated_r10_vals[] = {
  {   0, "release" },
  {   1, "setup" },
  { 0, NULL }
};

static const per_choice_t T_twoAntennaPortActivated_r10_choice[] = {
  {   0, &hf_lte_rrc_release     , ASN1_NO_EXTENSIONS     , dissect_lte_rrc_NULL },
  {   1, &hf_lte_rrc_setup_23    , ASN1_NO_EXTENSIONS     , dissect_lte_rrc_T_setup_22 },
  { 0, NULL, 0, NULL }
};

static int
dissect_lte_rrc_T_twoAntennaPortActivated_r10(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_lte_rrc_T_twoAntennaPortActivated_r10, T_twoAntennaPortActivated_r10_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t T_eag_1_sequence[] = {
  { &hf_lte_rrc_twoAntennaPortActivated_r10, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lte_rrc_T_twoAntennaPortActivated_r10 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_T_eag_1(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence_eag(tvb, offset, actx, tree, T_eag_1_sequence);

  return offset;
}


static const per_sequence_t T_setup_21_sequence[] = {
  { &hf_lte_rrc_semiPersistSchedIntervalDL, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lte_rrc_T_semiPersistSchedIntervalDL },
  { &hf_lte_rrc_numberOfConfSPS_Processes, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lte_rrc_INTEGER_1_8 },
  { &hf_lte_rrc_n1PUCCH_AN_PersistentList, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lte_rrc_N1PUCCH_AN_PersistentList },
  { &hf_lte_rrc_dummy_eag_field, ASN1_NOT_EXTENSION_ROOT, ASN1_NOT_OPTIONAL, dissect_lte_rrc_T_eag_1 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_T_setup_21(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_T_setup_21, T_setup_21_sequence);

  return offset;
}


static const value_string lte_rrc_SPS_ConfigDL_vals[] = {
  {   0, "release" },
  {   1, "setup" },
  { 0, NULL }
};

static const per_choice_t SPS_ConfigDL_choice[] = {
  {   0, &hf_lte_rrc_release     , ASN1_NO_EXTENSIONS     , dissect_lte_rrc_NULL },
  {   1, &hf_lte_rrc_setup_22    , ASN1_NO_EXTENSIONS     , dissect_lte_rrc_T_setup_21 },
  { 0, NULL, 0, NULL }
};

static int
dissect_lte_rrc_SPS_ConfigDL(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_lte_rrc_SPS_ConfigDL, SPS_ConfigDL_choice,
                                 NULL);

  return offset;
}


static const value_string lte_rrc_T_semiPersistSchedIntervalUL_vals[] = {
  {   0, "sf10" },
  {   1, "sf20" },
  {   2, "sf32" },
  {   3, "sf40" },
  {   4, "sf64" },
  {   5, "sf80" },
  {   6, "sf128" },
  {   7, "sf160" },
  {   8, "sf320" },
  {   9, "sf640" },
  {  10, "spare6" },
  {  11, "spare5" },
  {  12, "spare4" },
  {  13, "spare3" },
  {  14, "spare2" },
  {  15, "spare1" },
  { 0, NULL }
};


static int
dissect_lte_rrc_T_semiPersistSchedIntervalUL(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     16, NULL, FALSE, 0, NULL);

  return offset;
}


static const value_string lte_rrc_T_implicitReleaseAfter_vals[] = {
  {   0, "e2" },
  {   1, "e3" },
  {   2, "e4" },
  {   3, "e8" },
  { 0, NULL }
};


static int
dissect_lte_rrc_T_implicitReleaseAfter(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     4, NULL, FALSE, 0, NULL);

  return offset;
}



static int
dissect_lte_rrc_T_p0_NominalPUSCH_Persistent(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            -126, 24U, NULL, FALSE);

  proto_item_append_text(actx->created_item, "dBm");


  return offset;
}



static int
dissect_lte_rrc_T_p0_UE_PUSCH_Persistent(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            -8, 7U, NULL, FALSE);

  proto_item_append_text(actx->created_item, "dB");


  return offset;
}


static const per_sequence_t T_p0_Persistent_sequence[] = {
  { &hf_lte_rrc_p0_NominalPUSCH_Persistent, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_T_p0_NominalPUSCH_Persistent },
  { &hf_lte_rrc_p0_UE_PUSCH_Persistent, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_T_p0_UE_PUSCH_Persistent },
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_T_p0_Persistent(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_T_p0_Persistent, T_p0_Persistent_sequence);

  return offset;
}


static const value_string lte_rrc_T_twoIntervalsConfig_vals[] = {
  {   0, "true" },
  { 0, NULL }
};


static int
dissect_lte_rrc_T_twoIntervalsConfig(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, FALSE, 0, NULL);

  return offset;
}


static const per_sequence_t T_setup_23_sequence[] = {
  { &hf_lte_rrc_semiPersistSchedIntervalUL, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lte_rrc_T_semiPersistSchedIntervalUL },
  { &hf_lte_rrc_implicitReleaseAfter, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lte_rrc_T_implicitReleaseAfter },
  { &hf_lte_rrc_p0_Persistent, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lte_rrc_T_p0_Persistent },
  { &hf_lte_rrc_twoIntervalsConfig, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lte_rrc_T_twoIntervalsConfig },
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_T_setup_23(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_T_setup_23, T_setup_23_sequence);

  return offset;
}


static const value_string lte_rrc_SPS_ConfigUL_vals[] = {
  {   0, "release" },
  {   1, "setup" },
  { 0, NULL }
};

static const per_choice_t SPS_ConfigUL_choice[] = {
  {   0, &hf_lte_rrc_release     , ASN1_NO_EXTENSIONS     , dissect_lte_rrc_NULL },
  {   1, &hf_lte_rrc_setup_24    , ASN1_NO_EXTENSIONS     , dissect_lte_rrc_T_setup_23 },
  { 0, NULL, 0, NULL }
};

static int
dissect_lte_rrc_SPS_ConfigUL(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_lte_rrc_SPS_ConfigUL, SPS_ConfigUL_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t SPS_Config_sequence[] = {
  { &hf_lte_rrc_semiPersistSchedC_RNTI, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lte_rrc_C_RNTI },
  { &hf_lte_rrc_sps_ConfigDL, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lte_rrc_SPS_ConfigDL },
  { &hf_lte_rrc_sps_ConfigUL, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lte_rrc_SPS_ConfigUL },
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_SPS_Config(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_SPS_Config, SPS_Config_sequence);

  return offset;
}


static const value_string lte_rrc_T_p_a_vals[] = {
  {   0, "dB-6" },
  {   1, "dB-4dot77" },
  {   2, "dB-3" },
  {   3, "dB-1dot77" },
  {   4, "dB0" },
  {   5, "dB1" },
  {   6, "dB2" },
  {   7, "dB3" },
  { 0, NULL }
};


static int
dissect_lte_rrc_T_p_a(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     8, NULL, FALSE, 0, NULL);

  return offset;
}


static const per_sequence_t PDSCH_ConfigDedicated_sequence[] = {
  { &hf_lte_rrc_p_a         , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_T_p_a },
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_PDSCH_ConfigDedicated(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_PDSCH_ConfigDedicated, PDSCH_ConfigDedicated_sequence);

  return offset;
}


static const value_string lte_rrc_T_repetitionFactor_vals[] = {
  {   0, "n2" },
  {   1, "n4" },
  {   2, "n6" },
  {   3, "spare1" },
  { 0, NULL }
};


static int
dissect_lte_rrc_T_repetitionFactor(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     4, NULL, FALSE, 0, NULL);

  return offset;
}


static const per_sequence_t T_setup_12_sequence[] = {
  { &hf_lte_rrc_repetitionFactor, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_T_repetitionFactor },
  { &hf_lte_rrc_n1PUCCH_AN_Rep, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_INTEGER_0_2047 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_T_setup_12(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_T_setup_12, T_setup_12_sequence);

  return offset;
}


static const value_string lte_rrc_T_ackNackRepetition_vals[] = {
  {   0, "release" },
  {   1, "setup" },
  { 0, NULL }
};

static const per_choice_t T_ackNackRepetition_choice[] = {
  {   0, &hf_lte_rrc_release     , ASN1_NO_EXTENSIONS     , dissect_lte_rrc_NULL },
  {   1, &hf_lte_rrc_setup_12    , ASN1_NO_EXTENSIONS     , dissect_lte_rrc_T_setup_12 },
  { 0, NULL, 0, NULL }
};

static int
dissect_lte_rrc_T_ackNackRepetition(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_lte_rrc_T_ackNackRepetition, T_ackNackRepetition_choice,
                                 NULL);

  return offset;
}


static const value_string lte_rrc_T_tdd_AckNackFeedbackMode_vals[] = {
  {   0, "bundling" },
  {   1, "multiplexing" },
  { 0, NULL }
};


static int
dissect_lte_rrc_T_tdd_AckNackFeedbackMode(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, FALSE, 0, NULL);

  return offset;
}


static const per_sequence_t PUCCH_ConfigDedicated_sequence[] = {
  { &hf_lte_rrc_ackNackRepetition, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_T_ackNackRepetition },
  { &hf_lte_rrc_tdd_AckNackFeedbackMode, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lte_rrc_T_tdd_AckNackFeedbackMode },
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_PUCCH_ConfigDedicated(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_PUCCH_ConfigDedicated, PUCCH_ConfigDedicated_sequence);

  return offset;
}


static const per_sequence_t PUSCH_ConfigDedicated_sequence[] = {
  { &hf_lte_rrc_betaOffset_ACK_Index, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_INTEGER_0_15 },
  { &hf_lte_rrc_betaOffset_RI_Index, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_INTEGER_0_15 },
  { &hf_lte_rrc_betaOffset_CQI_Index, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_INTEGER_0_15 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_PUSCH_ConfigDedicated(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_PUSCH_ConfigDedicated, PUSCH_ConfigDedicated_sequence);

  return offset;
}



static int
dissect_lte_rrc_T_p0_UE_PUSCH(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            -8, 7U, NULL, FALSE);

  proto_item_append_text(actx->created_item, "dB");


  return offset;
}


static const value_string lte_rrc_T_deltaMCS_Enabled_vals[] = {
  {   0, "en0" },
  {   1, "en1" },
  { 0, NULL }
};


static int
dissect_lte_rrc_T_deltaMCS_Enabled(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, FALSE, 0, NULL);

  return offset;
}



static int
dissect_lte_rrc_T_p0_UE_PUCCH(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            -8, 7U, NULL, FALSE);

  proto_item_append_text(actx->created_item, "dB");


  return offset;
}


static const value_string lte_rrc_FilterCoefficient_vals[] = {
  {   0, "fc0" },
  {   1, "fc1" },
  {   2, "fc2" },
  {   3, "fc3" },
  {   4, "fc4" },
  {   5, "fc5" },
  {   6, "fc6" },
  {   7, "fc7" },
  {   8, "fc8" },
  {   9, "fc9" },
  {  10, "fc11" },
  {  11, "fc13" },
  {  12, "fc15" },
  {  13, "fc17" },
  {  14, "fc19" },
  {  15, "spare1" },
  { 0, NULL }
};


static int
dissect_lte_rrc_FilterCoefficient(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     16, NULL, TRUE, 0, NULL);

  return offset;
}


static const per_sequence_t UplinkPowerControlDedicated_sequence[] = {
  { &hf_lte_rrc_p0_UE_PUSCH , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_T_p0_UE_PUSCH },
  { &hf_lte_rrc_deltaMCS_Enabled, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_T_deltaMCS_Enabled },
  { &hf_lte_rrc_accumulationEnabled, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_BOOLEAN },
  { &hf_lte_rrc_p0_UE_PUCCH , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_T_p0_UE_PUCCH },
  { &hf_lte_rrc_pSRS_Offset , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_INTEGER_0_15 },
  { &hf_lte_rrc_filterCoefficient, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lte_rrc_FilterCoefficient },
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_UplinkPowerControlDedicated(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_UplinkPowerControlDedicated, UplinkPowerControlDedicated_sequence);

  return offset;
}



static int
dissect_lte_rrc_INTEGER_1_15(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            1U, 15U, NULL, FALSE);

  return offset;
}



static int
dissect_lte_rrc_INTEGER_1_31(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            1U, 31U, NULL, FALSE);

  return offset;
}


static const value_string lte_rrc_TPC_Index_vals[] = {
  {   0, "indexOfFormat3" },
  {   1, "indexOfFormat3A" },
  { 0, NULL }
};

static const per_choice_t TPC_Index_choice[] = {
  {   0, &hf_lte_rrc_indexOfFormat3, ASN1_NO_EXTENSIONS     , dissect_lte_rrc_INTEGER_1_15 },
  {   1, &hf_lte_rrc_indexOfFormat3A, ASN1_NO_EXTENSIONS     , dissect_lte_rrc_INTEGER_1_31 },
  { 0, NULL, 0, NULL }
};

static int
dissect_lte_rrc_TPC_Index(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_lte_rrc_TPC_Index, TPC_Index_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t T_setup_24_sequence[] = {
  { &hf_lte_rrc_tpc_RNTI    , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_BIT_STRING_SIZE_16 },
  { &hf_lte_rrc_tpc_Index   , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_TPC_Index },
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_T_setup_24(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_T_setup_24, T_setup_24_sequence);

  return offset;
}


static const value_string lte_rrc_TPC_PDCCH_Config_vals[] = {
  {   0, "release" },
  {   1, "setup" },
  { 0, NULL }
};

static const per_choice_t TPC_PDCCH_Config_choice[] = {
  {   0, &hf_lte_rrc_release     , ASN1_NO_EXTENSIONS     , dissect_lte_rrc_NULL },
  {   1, &hf_lte_rrc_setup_25    , ASN1_NO_EXTENSIONS     , dissect_lte_rrc_T_setup_24 },
  { 0, NULL, 0, NULL }
};

static int
dissect_lte_rrc_TPC_PDCCH_Config(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_lte_rrc_TPC_PDCCH_Config, TPC_PDCCH_Config_choice,
                                 NULL);

  return offset;
}


static const value_string lte_rrc_CQI_ReportModeAperiodic_vals[] = {
  {   0, "rm12" },
  {   1, "rm20" },
  {   2, "rm22" },
  {   3, "rm30" },
  {   4, "rm31" },
  {   5, "spare3" },
  {   6, "spare2" },
  {   7, "spare1" },
  { 0, NULL }
};


static int
dissect_lte_rrc_CQI_ReportModeAperiodic(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     8, NULL, FALSE, 0, NULL);

  return offset;
}



static int
dissect_lte_rrc_INTEGER_0_1185(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 1185U, NULL, FALSE);

  return offset;
}


static const per_sequence_t T_subbandCQI_sequence[] = {
  { &hf_lte_rrc_k           , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_INTEGER_1_4 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_T_subbandCQI(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_T_subbandCQI, T_subbandCQI_sequence);

  return offset;
}


static const value_string lte_rrc_T_cqi_FormatIndicatorPeriodic_vals[] = {
  {   0, "widebandCQI" },
  {   1, "subbandCQI" },
  { 0, NULL }
};

static const per_choice_t T_cqi_FormatIndicatorPeriodic_choice[] = {
  {   0, &hf_lte_rrc_widebandCQI , ASN1_NO_EXTENSIONS     , dissect_lte_rrc_NULL },
  {   1, &hf_lte_rrc_subbandCQI  , ASN1_NO_EXTENSIONS     , dissect_lte_rrc_T_subbandCQI },
  { 0, NULL, 0, NULL }
};

static int
dissect_lte_rrc_T_cqi_FormatIndicatorPeriodic(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_lte_rrc_T_cqi_FormatIndicatorPeriodic, T_cqi_FormatIndicatorPeriodic_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t T_setup_03_sequence[] = {
  { &hf_lte_rrc_cqi_PUCCH_ResourceIndex, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_INTEGER_0_1185 },
  { &hf_lte_rrc_cqi_pmi_ConfigIndex, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_INTEGER_0_1023 },
  { &hf_lte_rrc_cqi_FormatIndicatorPeriodic, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_T_cqi_FormatIndicatorPeriodic },
  { &hf_lte_rrc_ri_ConfigIndex, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lte_rrc_INTEGER_0_1023 },
  { &hf_lte_rrc_simultaneousAckNackAndCQI, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_BOOLEAN },
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_T_setup_03(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_T_setup_03, T_setup_03_sequence);

  return offset;
}


static const value_string lte_rrc_CQI_ReportPeriodic_vals[] = {
  {   0, "release" },
  {   1, "setup" },
  { 0, NULL }
};

static const per_choice_t CQI_ReportPeriodic_choice[] = {
  {   0, &hf_lte_rrc_release     , ASN1_NO_EXTENSIONS     , dissect_lte_rrc_NULL },
  {   1, &hf_lte_rrc_setup_03    , ASN1_NO_EXTENSIONS     , dissect_lte_rrc_T_setup_03 },
  { 0, NULL, 0, NULL }
};

static int
dissect_lte_rrc_CQI_ReportPeriodic(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_lte_rrc_CQI_ReportPeriodic, CQI_ReportPeriodic_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t CQI_ReportConfig_sequence[] = {
  { &hf_lte_rrc_cqi_ReportModeAperiodic, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lte_rrc_CQI_ReportModeAperiodic },
  { &hf_lte_rrc_nomPDSCH_RS_EPRE_Offset, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_INTEGER_M1_6 },
  { &hf_lte_rrc_cqi_ReportPeriodic, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lte_rrc_CQI_ReportPeriodic },
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_CQI_ReportConfig(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_CQI_ReportConfig, CQI_ReportConfig_sequence);

  return offset;
}


static const value_string lte_rrc_T_srs_Bandwidth_vals[] = {
  {   0, "bw0" },
  {   1, "bw1" },
  {   2, "bw2" },
  {   3, "bw3" },
  { 0, NULL }
};


static int
dissect_lte_rrc_T_srs_Bandwidth(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     4, NULL, FALSE, 0, NULL);

  return offset;
}


static const value_string lte_rrc_T_srs_HoppingBandwidth_vals[] = {
  {   0, "hbw0" },
  {   1, "hbw1" },
  {   2, "hbw2" },
  {   3, "hbw3" },
  { 0, NULL }
};


static int
dissect_lte_rrc_T_srs_HoppingBandwidth(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     4, NULL, FALSE, 0, NULL);

  return offset;
}



static int
dissect_lte_rrc_INTEGER_0_23(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 23U, NULL, FALSE);

  return offset;
}



static int
dissect_lte_rrc_T_duration(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  actx->created_item = proto_tree_add_bits_item(tree, hf_index, tvb, offset, 1, ENC_BIG_ENDIAN);
  offset++;


  return offset;
}



static int
dissect_lte_rrc_INTEGER_0_1(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 1U, NULL, FALSE);

  return offset;
}


static const value_string lte_rrc_T_cyclicShift_vals[] = {
  {   0, "cs0" },
  {   1, "cs1" },
  {   2, "cs2" },
  {   3, "cs3" },
  {   4, "cs4" },
  {   5, "cs5" },
  {   6, "cs6" },
  {   7, "cs7" },
  { 0, NULL }
};


static int
dissect_lte_rrc_T_cyclicShift(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     8, NULL, FALSE, 0, NULL);

  return offset;
}


static const per_sequence_t T_setup_18_sequence[] = {
  { &hf_lte_rrc_srs_Bandwidth, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_T_srs_Bandwidth },
  { &hf_lte_rrc_srs_HoppingBandwidth, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_T_srs_HoppingBandwidth },
  { &hf_lte_rrc_freqDomainPosition, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_INTEGER_0_23 },
  { &hf_lte_rrc_duration    , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_T_duration },
  { &hf_lte_rrc_srs_ConfigIndex, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_INTEGER_0_1023 },
  { &hf_lte_rrc_transmissionComb, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_INTEGER_0_1 },
  { &hf_lte_rrc_cyclicShift_01, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_T_cyclicShift },
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_T_setup_18(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_T_setup_18, T_setup_18_sequence);

  return offset;
}


static const value_string lte_rrc_SoundingRS_UL_ConfigDedicated_vals[] = {
  {   0, "release" },
  {   1, "setup" },
  { 0, NULL }
};

static const per_choice_t SoundingRS_UL_ConfigDedicated_choice[] = {
  {   0, &hf_lte_rrc_release     , ASN1_NO_EXTENSIONS     , dissect_lte_rrc_NULL },
  {   1, &hf_lte_rrc_setup_19    , ASN1_NO_EXTENSIONS     , dissect_lte_rrc_T_setup_18 },
  { 0, NULL, 0, NULL }
};

static int
dissect_lte_rrc_SoundingRS_UL_ConfigDedicated(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_lte_rrc_SoundingRS_UL_ConfigDedicated, SoundingRS_UL_ConfigDedicated_choice,
                                 NULL);

  return offset;
}


static const value_string lte_rrc_T_transmissionMode_vals[] = {
  {   0, "tm1" },
  {   1, "tm2" },
  {   2, "tm3" },
  {   3, "tm4" },
  {   4, "tm5" },
  {   5, "tm6" },
  {   6, "tm7" },
  {   7, "tm8-v920" },
  { 0, NULL }
};


static int
dissect_lte_rrc_T_transmissionMode(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     8, NULL, FALSE, 0, NULL);

  return offset;
}



static int
dissect_lte_rrc_BIT_STRING_SIZE_2(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     2, 2, FALSE, NULL);

  return offset;
}



static int
dissect_lte_rrc_BIT_STRING_SIZE_4(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     4, 4, FALSE, NULL);

  return offset;
}



static int
dissect_lte_rrc_BIT_STRING_SIZE_64(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     64, 64, FALSE, NULL);

  return offset;
}


static const value_string lte_rrc_T_codebookSubsetRestriction_vals[] = {
  {   0, "n2TxAntenna-tm3" },
  {   1, "n4TxAntenna-tm3" },
  {   2, "n2TxAntenna-tm4" },
  {   3, "n4TxAntenna-tm4" },
  {   4, "n2TxAntenna-tm5" },
  {   5, "n4TxAntenna-tm5" },
  {   6, "n2TxAntenna-tm6" },
  {   7, "n4TxAntenna-tm6" },
  { 0, NULL }
};

static const per_choice_t T_codebookSubsetRestriction_choice[] = {
  {   0, &hf_lte_rrc_n2TxAntenna_tm3, ASN1_NO_EXTENSIONS     , dissect_lte_rrc_BIT_STRING_SIZE_2 },
  {   1, &hf_lte_rrc_n4TxAntenna_tm3, ASN1_NO_EXTENSIONS     , dissect_lte_rrc_BIT_STRING_SIZE_4 },
  {   2, &hf_lte_rrc_n2TxAntenna_tm4, ASN1_NO_EXTENSIONS     , dissect_lte_rrc_BIT_STRING_SIZE_6 },
  {   3, &hf_lte_rrc_n4TxAntenna_tm4, ASN1_NO_EXTENSIONS     , dissect_lte_rrc_BIT_STRING_SIZE_64 },
  {   4, &hf_lte_rrc_n2TxAntenna_tm5, ASN1_NO_EXTENSIONS     , dissect_lte_rrc_BIT_STRING_SIZE_4 },
  {   5, &hf_lte_rrc_n4TxAntenna_tm5, ASN1_NO_EXTENSIONS     , dissect_lte_rrc_BIT_STRING_SIZE_16 },
  {   6, &hf_lte_rrc_n2TxAntenna_tm6, ASN1_NO_EXTENSIONS     , dissect_lte_rrc_BIT_STRING_SIZE_4 },
  {   7, &hf_lte_rrc_n4TxAntenna_tm6, ASN1_NO_EXTENSIONS     , dissect_lte_rrc_BIT_STRING_SIZE_16 },
  { 0, NULL, 0, NULL }
};

static int
dissect_lte_rrc_T_codebookSubsetRestriction(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_lte_rrc_T_codebookSubsetRestriction, T_codebookSubsetRestriction_choice,
                                 NULL);

  return offset;
}


static const value_string lte_rrc_T_setup_vals[] = {
  {   0, "closedLoop" },
  {   1, "openLoop" },
  { 0, NULL }
};


static int
dissect_lte_rrc_T_setup(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, FALSE, 0, NULL);

  return offset;
}


static const value_string lte_rrc_T_ue_TransmitAntennaSelection_vals[] = {
  {   0, "release" },
  {   1, "setup" },
  { 0, NULL }
};

static const per_choice_t T_ue_TransmitAntennaSelection_choice[] = {
  {   0, &hf_lte_rrc_release     , ASN1_NO_EXTENSIONS     , dissect_lte_rrc_NULL },
  {   1, &hf_lte_rrc_setup       , ASN1_NO_EXTENSIONS     , dissect_lte_rrc_T_setup },
  { 0, NULL, 0, NULL }
};

static int
dissect_lte_rrc_T_ue_TransmitAntennaSelection(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_lte_rrc_T_ue_TransmitAntennaSelection, T_ue_TransmitAntennaSelection_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t AntennaInfoDedicated_sequence[] = {
  { &hf_lte_rrc_transmissionMode, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_T_transmissionMode },
  { &hf_lte_rrc_codebookSubsetRestriction, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lte_rrc_T_codebookSubsetRestriction },
  { &hf_lte_rrc_ue_TransmitAntennaSelection, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_T_ue_TransmitAntennaSelection },
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_AntennaInfoDedicated(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_AntennaInfoDedicated, AntennaInfoDedicated_sequence);

  return offset;
}


static const value_string lte_rrc_T_antennaInfo_vals[] = {
  {   0, "explicitValue" },
  {   1, "defaultValue" },
  { 0, NULL }
};

static const per_choice_t T_antennaInfo_choice[] = {
  {   0, &hf_lte_rrc_explicitValue, ASN1_NO_EXTENSIONS     , dissect_lte_rrc_AntennaInfoDedicated },
  {   1, &hf_lte_rrc_defaultValue, ASN1_NO_EXTENSIONS     , dissect_lte_rrc_NULL },
  { 0, NULL, 0, NULL }
};

static int
dissect_lte_rrc_T_antennaInfo(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_lte_rrc_T_antennaInfo, T_antennaInfo_choice,
                                 NULL);

  return offset;
}



static int
dissect_lte_rrc_INTEGER_0_157(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 157U, NULL, FALSE);

  return offset;
}


static const value_string lte_rrc_T_dsr_TransMax_vals[] = {
  {   0, "n4" },
  {   1, "n8" },
  {   2, "n16" },
  {   3, "n32" },
  {   4, "n64" },
  {   5, "spare3" },
  {   6, "spare2" },
  {   7, "spare1" },
  { 0, NULL }
};


static int
dissect_lte_rrc_T_dsr_TransMax(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     8, NULL, FALSE, 0, NULL);

  return offset;
}


static const per_sequence_t T_setup_16_sequence[] = {
  { &hf_lte_rrc_sr_PUCCH_ResourceIndex, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_INTEGER_0_2047 },
  { &hf_lte_rrc_sr_ConfigIndex, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_INTEGER_0_157 },
  { &hf_lte_rrc_dsr_TransMax, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_T_dsr_TransMax },
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_T_setup_16(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_T_setup_16, T_setup_16_sequence);

  return offset;
}


static const value_string lte_rrc_SchedulingRequestConfig_vals[] = {
  {   0, "release" },
  {   1, "setup" },
  { 0, NULL }
};

static const per_choice_t SchedulingRequestConfig_choice[] = {
  {   0, &hf_lte_rrc_release     , ASN1_NO_EXTENSIONS     , dissect_lte_rrc_NULL },
  {   1, &hf_lte_rrc_setup_17    , ASN1_NO_EXTENSIONS     , dissect_lte_rrc_T_setup_16 },
  { 0, NULL, 0, NULL }
};

static int
dissect_lte_rrc_SchedulingRequestConfig(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_lte_rrc_SchedulingRequestConfig, SchedulingRequestConfig_choice,
                                 NULL);

  return offset;
}


static const value_string lte_rrc_T_cqi_Mask_r9_vals[] = {
  {   0, "setup" },
  { 0, NULL }
};


static int
dissect_lte_rrc_T_cqi_Mask_r9(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, FALSE, 0, NULL);

  return offset;
}


static const value_string lte_rrc_T_pmi_RI_Report_r9_vals[] = {
  {   0, "setup" },
  { 0, NULL }
};


static int
dissect_lte_rrc_T_pmi_RI_Report_r9(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, FALSE, 0, NULL);

  return offset;
}


static const per_sequence_t CQI_ReportConfig_v920_sequence[] = {
  { &hf_lte_rrc_cqi_Mask_r9 , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lte_rrc_T_cqi_Mask_r9 },
  { &hf_lte_rrc_pmi_RI_Report_r9, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lte_rrc_T_pmi_RI_Report_r9 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_CQI_ReportConfig_v920(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_CQI_ReportConfig_v920, CQI_ReportConfig_v920_sequence);

  return offset;
}


static const value_string lte_rrc_T_codebookSubsetRestriction_v920_vals[] = {
  {   0, "n2TxAntenna-tm8-r9" },
  {   1, "n4TxAntenna-tm8-r9" },
  { 0, NULL }
};

static const per_choice_t T_codebookSubsetRestriction_v920_choice[] = {
  {   0, &hf_lte_rrc_n2TxAntenna_tm8_r9, ASN1_NO_EXTENSIONS     , dissect_lte_rrc_BIT_STRING_SIZE_6 },
  {   1, &hf_lte_rrc_n4TxAntenna_tm8_r9, ASN1_NO_EXTENSIONS     , dissect_lte_rrc_BIT_STRING_SIZE_32 },
  { 0, NULL, 0, NULL }
};

static int
dissect_lte_rrc_T_codebookSubsetRestriction_v920(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_lte_rrc_T_codebookSubsetRestriction_v920, T_codebookSubsetRestriction_v920_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t AntennaInfoDedicated_v920_sequence[] = {
  { &hf_lte_rrc_codebookSubsetRestriction_v920, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lte_rrc_T_codebookSubsetRestriction_v920 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_AntennaInfoDedicated_v920(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_AntennaInfoDedicated_v920, AntennaInfoDedicated_v920_sequence);

  return offset;
}


static const per_sequence_t PhysicalConfigDedicated_eag_1_sequence[] = {
  { &hf_lte_rrc_cqi_ReportConfig_v920, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lte_rrc_CQI_ReportConfig_v920 },
  { &hf_lte_rrc_antennaInfo_v920, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lte_rrc_AntennaInfoDedicated_v920 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_PhysicalConfigDedicated_eag_1(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence_eag(tvb, offset, actx, tree, PhysicalConfigDedicated_eag_1_sequence);

  return offset;
}


static const value_string lte_rrc_T_transmissionMode_r10_vals[] = {
  {   0, "tm1" },
  {   1, "tm2" },
  {   2, "tm3" },
  {   3, "tm4" },
  {   4, "tm5" },
  {   5, "tm6" },
  {   6, "tm7" },
  {   7, "tm8-v920" },
  {   8, "tm9-v1020" },
  {   9, "spare7" },
  {  10, "spare6" },
  {  11, "spare5" },
  {  12, "spare4" },
  {  13, "spare3" },
  {  14, "spare2" },
  {  15, "spare1" },
  { 0, NULL }
};


static int
dissect_lte_rrc_T_transmissionMode_r10(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     16, NULL, FALSE, 0, NULL);

  return offset;
}



static int
dissect_lte_rrc_BIT_STRING(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     NO_BOUND, NO_BOUND, FALSE, NULL);

  return offset;
}


static const value_string lte_rrc_T_setup_01_vals[] = {
  {   0, "closedLoop" },
  {   1, "openLoop" },
  { 0, NULL }
};


static int
dissect_lte_rrc_T_setup_01(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, FALSE, 0, NULL);

  return offset;
}


static const value_string lte_rrc_T_ue_TransmitAntennaSelection_01_vals[] = {
  {   0, "release" },
  {   1, "setup" },
  { 0, NULL }
};

static const per_choice_t T_ue_TransmitAntennaSelection_01_choice[] = {
  {   0, &hf_lte_rrc_release     , ASN1_NO_EXTENSIONS     , dissect_lte_rrc_NULL },
  {   1, &hf_lte_rrc_setup_01    , ASN1_NO_EXTENSIONS     , dissect_lte_rrc_T_setup_01 },
  { 0, NULL, 0, NULL }
};

static int
dissect_lte_rrc_T_ue_TransmitAntennaSelection_01(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_lte_rrc_T_ue_TransmitAntennaSelection_01, T_ue_TransmitAntennaSelection_01_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t AntennaInfoDedicated_r10_sequence[] = {
  { &hf_lte_rrc_transmissionMode_r10, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_T_transmissionMode_r10 },
  { &hf_lte_rrc_codebookSubsetRestriction_r10, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lte_rrc_BIT_STRING },
  { &hf_lte_rrc_ue_TransmitAntennaSelection_01, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_T_ue_TransmitAntennaSelection_01 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_AntennaInfoDedicated_r10(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_AntennaInfoDedicated_r10, AntennaInfoDedicated_r10_sequence);

  return offset;
}


static const value_string lte_rrc_T_antennaInfo_r10_vals[] = {
  {   0, "explicitValue-r10" },
  {   1, "defaultValue" },
  { 0, NULL }
};

static const per_choice_t T_antennaInfo_r10_choice[] = {
  {   0, &hf_lte_rrc_explicitValue_r10, ASN1_NO_EXTENSIONS     , dissect_lte_rrc_AntennaInfoDedicated_r10 },
  {   1, &hf_lte_rrc_defaultValue, ASN1_NO_EXTENSIONS     , dissect_lte_rrc_NULL },
  { 0, NULL, 0, NULL }
};

static int
dissect_lte_rrc_T_antennaInfo_r10(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_lte_rrc_T_antennaInfo_r10, T_antennaInfo_r10_choice,
                                 NULL);

  return offset;
}


static const value_string lte_rrc_T_transmissionModeUL_r10_vals[] = {
  {   0, "tm1" },
  {   1, "tm2" },
  {   2, "spare6" },
  {   3, "spare5" },
  {   4, "spare4" },
  {   5, "spare3" },
  {   6, "spare2" },
  {   7, "spare1" },
  { 0, NULL }
};


static int
dissect_lte_rrc_T_transmissionModeUL_r10(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     8, NULL, FALSE, 0, NULL);

  return offset;
}


static const value_string lte_rrc_T_fourAntennaPortActivated_r10_vals[] = {
  {   0, "setup" },
  { 0, NULL }
};


static int
dissect_lte_rrc_T_fourAntennaPortActivated_r10(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, FALSE, 0, NULL);

  return offset;
}


static const per_sequence_t AntennaInfoUL_r10_sequence[] = {
  { &hf_lte_rrc_transmissionModeUL_r10, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lte_rrc_T_transmissionModeUL_r10 },
  { &hf_lte_rrc_fourAntennaPortActivated_r10, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lte_rrc_T_fourAntennaPortActivated_r10 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_AntennaInfoUL_r10(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_AntennaInfoUL_r10, AntennaInfoUL_r10_sequence);

  return offset;
}


static const per_sequence_t T_aperiodicCSI_Trigger_r10_sequence[] = {
  { &hf_lte_rrc_trigger1_r10, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_BIT_STRING_SIZE_8 },
  { &hf_lte_rrc_trigger2_r10, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_BIT_STRING_SIZE_8 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_T_aperiodicCSI_Trigger_r10(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_T_aperiodicCSI_Trigger_r10, T_aperiodicCSI_Trigger_r10_sequence);

  return offset;
}


static const per_sequence_t T_setup_06_sequence[] = {
  { &hf_lte_rrc_cqi_ReportModeAperiodic_r10, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_CQI_ReportModeAperiodic },
  { &hf_lte_rrc_aperiodicCSI_Trigger_r10, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lte_rrc_T_aperiodicCSI_Trigger_r10 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_T_setup_06(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_T_setup_06, T_setup_06_sequence);

  return offset;
}


static const value_string lte_rrc_CQI_ReportAperiodic_r10_vals[] = {
  {   0, "release" },
  {   1, "setup" },
  { 0, NULL }
};

static const per_choice_t CQI_ReportAperiodic_r10_choice[] = {
  {   0, &hf_lte_rrc_release     , ASN1_NO_EXTENSIONS     , dissect_lte_rrc_NULL },
  {   1, &hf_lte_rrc_setup_06    , ASN1_NO_EXTENSIONS     , dissect_lte_rrc_T_setup_06 },
  { 0, NULL, 0, NULL }
};

static int
dissect_lte_rrc_CQI_ReportAperiodic_r10(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_lte_rrc_CQI_ReportAperiodic_r10, CQI_ReportAperiodic_r10_choice,
                                 NULL);

  return offset;
}



static int
dissect_lte_rrc_INTEGER_0_1184(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 1184U, NULL, FALSE);

  return offset;
}


static const value_string lte_rrc_T_csi_ReportMode_r10_vals[] = {
  {   0, "submode1" },
  {   1, "submode2" },
  { 0, NULL }
};


static int
dissect_lte_rrc_T_csi_ReportMode_r10(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, FALSE, 0, NULL);

  return offset;
}


static const per_sequence_t T_widebandCQI_r10_sequence[] = {
  { &hf_lte_rrc_csi_ReportMode_r10, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lte_rrc_T_csi_ReportMode_r10 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_T_widebandCQI_r10(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_T_widebandCQI_r10, T_widebandCQI_r10_sequence);

  return offset;
}


static const value_string lte_rrc_T_periodicityFactor_r10_vals[] = {
  {   0, "n2" },
  {   1, "n4" },
  { 0, NULL }
};


static int
dissect_lte_rrc_T_periodicityFactor_r10(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, FALSE, 0, NULL);

  return offset;
}


static const per_sequence_t T_subbandCQI_r10_sequence[] = {
  { &hf_lte_rrc_k           , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_INTEGER_1_4 },
  { &hf_lte_rrc_periodicityFactor_r10, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_T_periodicityFactor_r10 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_T_subbandCQI_r10(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_T_subbandCQI_r10, T_subbandCQI_r10_sequence);

  return offset;
}


static const value_string lte_rrc_T_cqi_FormatIndicatorPeriodic_r10_vals[] = {
  {   0, "widebandCQI-r10" },
  {   1, "subbandCQI-r10" },
  { 0, NULL }
};

static const per_choice_t T_cqi_FormatIndicatorPeriodic_r10_choice[] = {
  {   0, &hf_lte_rrc_widebandCQI_r10, ASN1_NO_EXTENSIONS     , dissect_lte_rrc_T_widebandCQI_r10 },
  {   1, &hf_lte_rrc_subbandCQI_r10, ASN1_NO_EXTENSIONS     , dissect_lte_rrc_T_subbandCQI_r10 },
  { 0, NULL, 0, NULL }
};

static int
dissect_lte_rrc_T_cqi_FormatIndicatorPeriodic_r10(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_lte_rrc_T_cqi_FormatIndicatorPeriodic_r10, T_cqi_FormatIndicatorPeriodic_r10_choice,
                                 NULL);

  return offset;
}


static const value_string lte_rrc_T_cqi_Mask_r9_01_vals[] = {
  {   0, "setup" },
  { 0, NULL }
};


static int
dissect_lte_rrc_T_cqi_Mask_r9_01(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, FALSE, 0, NULL);

  return offset;
}


static const per_sequence_t T_setup_05_sequence[] = {
  { &hf_lte_rrc_cqi_pmi_ConfigIndex2_r10, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_INTEGER_0_1023 },
  { &hf_lte_rrc_ri_ConfigIndex2_r10, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lte_rrc_INTEGER_0_1023 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_T_setup_05(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_T_setup_05, T_setup_05_sequence);

  return offset;
}


static const value_string lte_rrc_T_csi_ConfigIndex_r10_vals[] = {
  {   0, "release" },
  {   1, "setup" },
  { 0, NULL }
};

static const per_choice_t T_csi_ConfigIndex_r10_choice[] = {
  {   0, &hf_lte_rrc_release     , ASN1_NO_EXTENSIONS     , dissect_lte_rrc_NULL },
  {   1, &hf_lte_rrc_setup_05    , ASN1_NO_EXTENSIONS     , dissect_lte_rrc_T_setup_05 },
  { 0, NULL, 0, NULL }
};

static int
dissect_lte_rrc_T_csi_ConfigIndex_r10(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_lte_rrc_T_csi_ConfigIndex_r10, T_csi_ConfigIndex_r10_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t T_setup_04_sequence[] = {
  { &hf_lte_rrc_cqi_PUCCH_ResourceIndex_r10, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_INTEGER_0_1184 },
  { &hf_lte_rrc_cqi_PUCCH_ResourceIndexP1_r10, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lte_rrc_INTEGER_0_1184 },
  { &hf_lte_rrc_cqi_pmi_ConfigIndex, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_INTEGER_0_1023 },
  { &hf_lte_rrc_cqi_FormatIndicatorPeriodic_r10, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_T_cqi_FormatIndicatorPeriodic_r10 },
  { &hf_lte_rrc_ri_ConfigIndex, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lte_rrc_INTEGER_0_1023 },
  { &hf_lte_rrc_simultaneousAckNackAndCQI, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_BOOLEAN },
  { &hf_lte_rrc_cqi_Mask_r9_01, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lte_rrc_T_cqi_Mask_r9_01 },
  { &hf_lte_rrc_csi_ConfigIndex_r10, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lte_rrc_T_csi_ConfigIndex_r10 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_T_setup_04(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_T_setup_04, T_setup_04_sequence);

  return offset;
}


static const value_string lte_rrc_CQI_ReportPeriodic_r10_vals[] = {
  {   0, "release" },
  {   1, "setup" },
  { 0, NULL }
};

static const per_choice_t CQI_ReportPeriodic_r10_choice[] = {
  {   0, &hf_lte_rrc_release     , ASN1_NO_EXTENSIONS     , dissect_lte_rrc_NULL },
  {   1, &hf_lte_rrc_setup_04    , ASN1_NO_EXTENSIONS     , dissect_lte_rrc_T_setup_04 },
  { 0, NULL, 0, NULL }
};

static int
dissect_lte_rrc_CQI_ReportPeriodic_r10(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_lte_rrc_CQI_ReportPeriodic_r10, CQI_ReportPeriodic_r10_choice,
                                 NULL);

  return offset;
}


static const value_string lte_rrc_T_pmi_RI_Report_r9_01_vals[] = {
  {   0, "setup" },
  { 0, NULL }
};


static int
dissect_lte_rrc_T_pmi_RI_Report_r9_01(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, FALSE, 0, NULL);

  return offset;
}



static int
dissect_lte_rrc_BIT_STRING_SIZE_40(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     40, 40, FALSE, NULL);

  return offset;
}



static int
dissect_lte_rrc_BIT_STRING_SIZE_20(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     20, 20, FALSE, NULL);

  return offset;
}



static int
dissect_lte_rrc_BIT_STRING_SIZE_70(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     70, 70, FALSE, NULL);

  return offset;
}



static int
dissect_lte_rrc_BIT_STRING_SIZE_60(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     60, 60, FALSE, NULL);

  return offset;
}


static const value_string lte_rrc_T_subframePatternTDD_r10_vals[] = {
  {   0, "subframeConfig1-5-r10" },
  {   1, "subframeConfig0-r10" },
  {   2, "subframeConfig6-r10" },
  { 0, NULL }
};

static const per_choice_t T_subframePatternTDD_r10_choice[] = {
  {   0, &hf_lte_rrc_subframeConfig1_5_r10, ASN1_EXTENSION_ROOT    , dissect_lte_rrc_BIT_STRING_SIZE_20 },
  {   1, &hf_lte_rrc_subframeConfig0_r10, ASN1_EXTENSION_ROOT    , dissect_lte_rrc_BIT_STRING_SIZE_70 },
  {   2, &hf_lte_rrc_subframeConfig6_r10, ASN1_EXTENSION_ROOT    , dissect_lte_rrc_BIT_STRING_SIZE_60 },
  { 0, NULL, 0, NULL }
};

static int
dissect_lte_rrc_T_subframePatternTDD_r10(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_lte_rrc_T_subframePatternTDD_r10, T_subframePatternTDD_r10_choice,
                                 NULL);

  return offset;
}


static const value_string lte_rrc_MeasSubframePattern_r10_vals[] = {
  {   0, "subframePatternFDD-r10" },
  {   1, "subframePatternTDD-r10" },
  { 0, NULL }
};

static const per_choice_t MeasSubframePattern_r10_choice[] = {
  {   0, &hf_lte_rrc_subframePatternFDD_r10, ASN1_EXTENSION_ROOT    , dissect_lte_rrc_BIT_STRING_SIZE_40 },
  {   1, &hf_lte_rrc_subframePatternTDD_r10, ASN1_EXTENSION_ROOT    , dissect_lte_rrc_T_subframePatternTDD_r10 },
  { 0, NULL, 0, NULL }
};

static int
dissect_lte_rrc_MeasSubframePattern_r10(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_lte_rrc_MeasSubframePattern_r10, MeasSubframePattern_r10_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t T_setup_02_sequence[] = {
  { &hf_lte_rrc_csi_MeasSubframeSet1_r10, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_MeasSubframePattern_r10 },
  { &hf_lte_rrc_csi_MeasSubframeSet2_r10, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_MeasSubframePattern_r10 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_T_setup_02(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_T_setup_02, T_setup_02_sequence);

  return offset;
}


static const value_string lte_rrc_T_csi_SubframePatternConfig_r10_vals[] = {
  {   0, "release" },
  {   1, "setup" },
  { 0, NULL }
};

static const per_choice_t T_csi_SubframePatternConfig_r10_choice[] = {
  {   0, &hf_lte_rrc_release     , ASN1_NO_EXTENSIONS     , dissect_lte_rrc_NULL },
  {   1, &hf_lte_rrc_setup_02    , ASN1_NO_EXTENSIONS     , dissect_lte_rrc_T_setup_02 },
  { 0, NULL, 0, NULL }
};

static int
dissect_lte_rrc_T_csi_SubframePatternConfig_r10(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_lte_rrc_T_csi_SubframePatternConfig_r10, T_csi_SubframePatternConfig_r10_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t CQI_ReportConfig_r10_sequence[] = {
  { &hf_lte_rrc_cqi_ReportAperiodic_r10, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lte_rrc_CQI_ReportAperiodic_r10 },
  { &hf_lte_rrc_nomPDSCH_RS_EPRE_Offset, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_INTEGER_M1_6 },
  { &hf_lte_rrc_cqi_ReportPeriodic_r10, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lte_rrc_CQI_ReportPeriodic_r10 },
  { &hf_lte_rrc_pmi_RI_Report_r9_01, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lte_rrc_T_pmi_RI_Report_r9_01 },
  { &hf_lte_rrc_csi_SubframePatternConfig_r10, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lte_rrc_T_csi_SubframePatternConfig_r10 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_CQI_ReportConfig_r10(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_CQI_ReportConfig_r10, CQI_ReportConfig_r10_sequence);

  return offset;
}


static const value_string lte_rrc_T_antennaPortsCount_r10_vals[] = {
  {   0, "an1" },
  {   1, "an2" },
  {   2, "an4" },
  {   3, "an8" },
  { 0, NULL }
};


static int
dissect_lte_rrc_T_antennaPortsCount_r10(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     4, NULL, FALSE, 0, NULL);

  return offset;
}



static int
dissect_lte_rrc_INTEGER_0_154(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 154U, NULL, FALSE);

  return offset;
}



static int
dissect_lte_rrc_INTEGER_M8_15(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            -8, 15U, NULL, FALSE);

  return offset;
}


static const per_sequence_t T_setup_07_sequence[] = {
  { &hf_lte_rrc_antennaPortsCount_r10, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_T_antennaPortsCount_r10 },
  { &hf_lte_rrc_resourceConfig_r10, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_INTEGER_0_31 },
  { &hf_lte_rrc_subframeConfig_r10, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_INTEGER_0_154 },
  { &hf_lte_rrc_p_C_r10     , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_INTEGER_M8_15 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_T_setup_07(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_T_setup_07, T_setup_07_sequence);

  return offset;
}


static const value_string lte_rrc_T_csi_RS_r10_vals[] = {
  {   0, "release" },
  {   1, "setup" },
  { 0, NULL }
};

static const per_choice_t T_csi_RS_r10_choice[] = {
  {   0, &hf_lte_rrc_release     , ASN1_NO_EXTENSIONS     , dissect_lte_rrc_NULL },
  {   1, &hf_lte_rrc_setup_07    , ASN1_NO_EXTENSIONS     , dissect_lte_rrc_T_setup_07 },
  { 0, NULL, 0, NULL }
};

static int
dissect_lte_rrc_T_csi_RS_r10(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_lte_rrc_T_csi_RS_r10, T_csi_RS_r10_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t T_setup_08_sequence[] = {
  { &hf_lte_rrc_zeroTxPowerResourceConfigList_r10, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_BIT_STRING_SIZE_16 },
  { &hf_lte_rrc_zeroTxPowerSubframeConfig_r10, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_INTEGER_0_154 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_T_setup_08(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_T_setup_08, T_setup_08_sequence);

  return offset;
}


static const value_string lte_rrc_T_zeroTxPowerCSI_RS_r10_vals[] = {
  {   0, "release" },
  {   1, "setup" },
  { 0, NULL }
};

static const per_choice_t T_zeroTxPowerCSI_RS_r10_choice[] = {
  {   0, &hf_lte_rrc_release     , ASN1_NO_EXTENSIONS     , dissect_lte_rrc_NULL },
  {   1, &hf_lte_rrc_setup_08    , ASN1_NO_EXTENSIONS     , dissect_lte_rrc_T_setup_08 },
  { 0, NULL, 0, NULL }
};

static int
dissect_lte_rrc_T_zeroTxPowerCSI_RS_r10(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_lte_rrc_T_zeroTxPowerCSI_RS_r10, T_zeroTxPowerCSI_RS_r10_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t CSI_RS_Config_r10_sequence[] = {
  { &hf_lte_rrc_csi_RS_r10  , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lte_rrc_T_csi_RS_r10 },
  { &hf_lte_rrc_zeroTxPowerCSI_RS_r10, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lte_rrc_T_zeroTxPowerCSI_RS_r10 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_CSI_RS_Config_r10(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_CSI_RS_Config_r10, CSI_RS_Config_r10_sequence);

  return offset;
}



static int
dissect_lte_rrc_INTEGER_0_549(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 549U, NULL, FALSE);

  return offset;
}


static const per_sequence_t T_n3PUCCH_AN_List_r10_sequence_of[1] = {
  { &hf_lte_rrc_n3PUCCH_AN_List_r10_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_INTEGER_0_549 },
};

static int
dissect_lte_rrc_T_n3PUCCH_AN_List_r10(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_lte_rrc_T_n3PUCCH_AN_List_r10, T_n3PUCCH_AN_List_r10_sequence_of,
                                                  1, 4, FALSE);

  return offset;
}


static const per_sequence_t T_n3PUCCH_AN_ListP1_r10_sequence_of[1] = {
  { &hf_lte_rrc_n3PUCCH_AN_ListP1_r10_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_INTEGER_0_549 },
};

static int
dissect_lte_rrc_T_n3PUCCH_AN_ListP1_r10(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_lte_rrc_T_n3PUCCH_AN_ListP1_r10, T_n3PUCCH_AN_ListP1_r10_sequence_of,
                                                  1, 4, FALSE);

  return offset;
}


static const per_sequence_t T_setup_13_sequence[] = {
  { &hf_lte_rrc_n3PUCCH_AN_ListP1_r10, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_T_n3PUCCH_AN_ListP1_r10 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_T_setup_13(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_T_setup_13, T_setup_13_sequence);

  return offset;
}


static const value_string lte_rrc_T_twoAntennaPortActivatedPUCCH_Format3_r10_vals[] = {
  {   0, "release" },
  {   1, "setup" },
  { 0, NULL }
};

static const per_choice_t T_twoAntennaPortActivatedPUCCH_Format3_r10_choice[] = {
  {   0, &hf_lte_rrc_release     , ASN1_NO_EXTENSIONS     , dissect_lte_rrc_NULL },
  {   1, &hf_lte_rrc_setup_13    , ASN1_NO_EXTENSIONS     , dissect_lte_rrc_T_setup_13 },
  { 0, NULL, 0, NULL }
};

static int
dissect_lte_rrc_T_twoAntennaPortActivatedPUCCH_Format3_r10(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_lte_rrc_T_twoAntennaPortActivatedPUCCH_Format3_r10, T_twoAntennaPortActivatedPUCCH_Format3_r10_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t T_format3_r10_sequence[] = {
  { &hf_lte_rrc_n3PUCCH_AN_List_r10, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lte_rrc_T_n3PUCCH_AN_List_r10 },
  { &hf_lte_rrc_twoAntennaPortActivatedPUCCH_Format3_r10, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lte_rrc_T_twoAntennaPortActivatedPUCCH_Format3_r10 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_T_format3_r10(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_T_format3_r10, T_format3_r10_sequence);

  return offset;
}


static const per_sequence_t N1PUCCH_AN_CS_r10_sequence_of[1] = {
  { &hf_lte_rrc_N1PUCCH_AN_CS_r10_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_INTEGER_0_2047 },
};

static int
dissect_lte_rrc_N1PUCCH_AN_CS_r10(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_lte_rrc_N1PUCCH_AN_CS_r10, N1PUCCH_AN_CS_r10_sequence_of,
                                                  1, 4, FALSE);

  return offset;
}


static const per_sequence_t SEQUENCE_SIZE_1_2_OF_N1PUCCH_AN_CS_r10_sequence_of[1] = {
  { &hf_lte_rrc_n1PUCCH_AN_CS_List_r10_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_N1PUCCH_AN_CS_r10 },
};

static int
dissect_lte_rrc_SEQUENCE_SIZE_1_2_OF_N1PUCCH_AN_CS_r10(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_lte_rrc_SEQUENCE_SIZE_1_2_OF_N1PUCCH_AN_CS_r10, SEQUENCE_SIZE_1_2_OF_N1PUCCH_AN_CS_r10_sequence_of,
                                                  1, 2, FALSE);

  return offset;
}


static const per_sequence_t T_setup_14_sequence[] = {
  { &hf_lte_rrc_n1PUCCH_AN_CS_List_r10, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_SEQUENCE_SIZE_1_2_OF_N1PUCCH_AN_CS_r10 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_T_setup_14(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_T_setup_14, T_setup_14_sequence);

  return offset;
}


static const value_string lte_rrc_T_n1PUCCH_AN_CS_r10_vals[] = {
  {   0, "release" },
  {   1, "setup" },
  { 0, NULL }
};

static const per_choice_t T_n1PUCCH_AN_CS_r10_choice[] = {
  {   0, &hf_lte_rrc_release     , ASN1_NO_EXTENSIONS     , dissect_lte_rrc_NULL },
  {   1, &hf_lte_rrc_setup_14    , ASN1_NO_EXTENSIONS     , dissect_lte_rrc_T_setup_14 },
  { 0, NULL, 0, NULL }
};

static int
dissect_lte_rrc_T_n1PUCCH_AN_CS_r10(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_lte_rrc_T_n1PUCCH_AN_CS_r10, T_n1PUCCH_AN_CS_r10_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t T_channelSelection_r10_sequence[] = {
  { &hf_lte_rrc_n1PUCCH_AN_CS_r10, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lte_rrc_T_n1PUCCH_AN_CS_r10 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_T_channelSelection_r10(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_T_channelSelection_r10, T_channelSelection_r10_sequence);

  return offset;
}


static const value_string lte_rrc_T_pucch_Format_r10_vals[] = {
  {   0, "format3-r10" },
  {   1, "channelSelection-r10" },
  { 0, NULL }
};

static const per_choice_t T_pucch_Format_r10_choice[] = {
  {   0, &hf_lte_rrc_format3_r10 , ASN1_NO_EXTENSIONS     , dissect_lte_rrc_T_format3_r10 },
  {   1, &hf_lte_rrc_channelSelection_r10, ASN1_NO_EXTENSIONS     , dissect_lte_rrc_T_channelSelection_r10 },
  { 0, NULL, 0, NULL }
};

static int
dissect_lte_rrc_T_pucch_Format_r10(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_lte_rrc_T_pucch_Format_r10, T_pucch_Format_r10_choice,
                                 NULL);

  return offset;
}


static const value_string lte_rrc_T_twoAntennaPortActivatedPUCCH_Format1a1b_r10_vals[] = {
  {   0, "true" },
  { 0, NULL }
};


static int
dissect_lte_rrc_T_twoAntennaPortActivatedPUCCH_Format1a1b_r10(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, FALSE, 0, NULL);

  return offset;
}


static const value_string lte_rrc_T_simultaneousPUCCH_PUSCH_r10_vals[] = {
  {   0, "true" },
  { 0, NULL }
};


static int
dissect_lte_rrc_T_simultaneousPUCCH_PUSCH_r10(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, FALSE, 0, NULL);

  return offset;
}


static const per_sequence_t PUCCH_ConfigDedicated_v1020_sequence[] = {
  { &hf_lte_rrc_pucch_Format_r10, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lte_rrc_T_pucch_Format_r10 },
  { &hf_lte_rrc_twoAntennaPortActivatedPUCCH_Format1a1b_r10, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lte_rrc_T_twoAntennaPortActivatedPUCCH_Format1a1b_r10 },
  { &hf_lte_rrc_simultaneousPUCCH_PUSCH_r10, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lte_rrc_T_simultaneousPUCCH_PUSCH_r10 },
  { &hf_lte_rrc_n1PUCCH_AN_RepP1_r10, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lte_rrc_INTEGER_0_2047 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_PUCCH_ConfigDedicated_v1020(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_PUCCH_ConfigDedicated_v1020, PUCCH_ConfigDedicated_v1020_sequence);

  return offset;
}


static const per_sequence_t T_betaOffsetMC_r10_sequence[] = {
  { &hf_lte_rrc_betaOffset_ACK_Index_MC_r10, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_INTEGER_0_15 },
  { &hf_lte_rrc_betaOffset_RI_Index_MC_r10, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_INTEGER_0_15 },
  { &hf_lte_rrc_betaOffset_CQI_Index_MC_r10, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_INTEGER_0_15 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_T_betaOffsetMC_r10(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_T_betaOffsetMC_r10, T_betaOffsetMC_r10_sequence);

  return offset;
}


static const value_string lte_rrc_T_groupHoppingDisabled_r10_vals[] = {
  {   0, "true" },
  { 0, NULL }
};


static int
dissect_lte_rrc_T_groupHoppingDisabled_r10(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, FALSE, 0, NULL);

  return offset;
}


static const value_string lte_rrc_T_dmrs_WithOCC_Activated_r10_vals[] = {
  {   0, "true" },
  { 0, NULL }
};


static int
dissect_lte_rrc_T_dmrs_WithOCC_Activated_r10(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, FALSE, 0, NULL);

  return offset;
}


static const per_sequence_t PUSCH_ConfigDedicated_v1020_sequence[] = {
  { &hf_lte_rrc_betaOffsetMC_r10, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lte_rrc_T_betaOffsetMC_r10 },
  { &hf_lte_rrc_groupHoppingDisabled_r10, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lte_rrc_T_groupHoppingDisabled_r10 },
  { &hf_lte_rrc_dmrs_WithOCC_Activated_r10, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lte_rrc_T_dmrs_WithOCC_Activated_r10 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_PUSCH_ConfigDedicated_v1020(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_PUSCH_ConfigDedicated_v1020, PUSCH_ConfigDedicated_v1020_sequence);

  return offset;
}


static const per_sequence_t SchedulingRequestConfig_v1020_sequence[] = {
  { &hf_lte_rrc_sr_PUCCH_ResourceIndexP1_r10, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lte_rrc_INTEGER_0_2047 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_SchedulingRequestConfig_v1020(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_SchedulingRequestConfig_v1020, SchedulingRequestConfig_v1020_sequence);

  return offset;
}


static const value_string lte_rrc_SRS_AntennaPort_vals[] = {
  {   0, "an1" },
  {   1, "an2" },
  {   2, "an4" },
  {   3, "spare1" },
  { 0, NULL }
};


static int
dissect_lte_rrc_SRS_AntennaPort(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     4, NULL, FALSE, 0, NULL);

  return offset;
}


static const per_sequence_t SoundingRS_UL_ConfigDedicated_v1020_sequence[] = {
  { &hf_lte_rrc_srs_AntennaPort_r10, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_SRS_AntennaPort },
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_SoundingRS_UL_ConfigDedicated_v1020(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_SoundingRS_UL_ConfigDedicated_v1020, SoundingRS_UL_ConfigDedicated_v1020_sequence);

  return offset;
}


static const value_string lte_rrc_T_srs_BandwidthAp_r10_vals[] = {
  {   0, "bw0" },
  {   1, "bw1" },
  {   2, "bw2" },
  {   3, "bw3" },
  { 0, NULL }
};


static int
dissect_lte_rrc_T_srs_BandwidthAp_r10(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     4, NULL, FALSE, 0, NULL);

  return offset;
}


static const value_string lte_rrc_T_cyclicShiftAp_r10_vals[] = {
  {   0, "cs0" },
  {   1, "cs1" },
  {   2, "cs2" },
  {   3, "cs3" },
  {   4, "cs4" },
  {   5, "cs5" },
  {   6, "cs6" },
  {   7, "cs7" },
  { 0, NULL }
};


static int
dissect_lte_rrc_T_cyclicShiftAp_r10(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     8, NULL, FALSE, 0, NULL);

  return offset;
}


static const per_sequence_t SRS_ConfigAp_r10_sequence[] = {
  { &hf_lte_rrc_srs_AntennaPortAp_r10, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_SRS_AntennaPort },
  { &hf_lte_rrc_srs_BandwidthAp_r10, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_T_srs_BandwidthAp_r10 },
  { &hf_lte_rrc_freqDomainPositionAp_r10, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_INTEGER_0_23 },
  { &hf_lte_rrc_transmissionCombAp_r10, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_INTEGER_0_1 },
  { &hf_lte_rrc_cyclicShiftAp_r10, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_T_cyclicShiftAp_r10 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_SRS_ConfigAp_r10(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_SRS_ConfigAp_r10, SRS_ConfigAp_r10_sequence);

  return offset;
}


static const per_sequence_t SEQUENCE_SIZE_1_3_OF_SRS_ConfigAp_r10_sequence_of[1] = {
  { &hf_lte_rrc_srs_ConfigApDCI_Format4_r10_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_SRS_ConfigAp_r10 },
};

static int
dissect_lte_rrc_SEQUENCE_SIZE_1_3_OF_SRS_ConfigAp_r10(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_lte_rrc_SEQUENCE_SIZE_1_3_OF_SRS_ConfigAp_r10, SEQUENCE_SIZE_1_3_OF_SRS_ConfigAp_r10_sequence_of,
                                                  1, 3, FALSE);

  return offset;
}


static const per_sequence_t T_setup_20_sequence[] = {
  { &hf_lte_rrc_srs_ConfigApDCI_Format0_r10, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lte_rrc_SRS_ConfigAp_r10 },
  { &hf_lte_rrc_srs_ConfigApDCI_Format1a2b2c_r10, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lte_rrc_SRS_ConfigAp_r10 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_T_setup_20(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_T_setup_20, T_setup_20_sequence);

  return offset;
}


static const value_string lte_rrc_T_srs_ActivateAp_r10_vals[] = {
  {   0, "release" },
  {   1, "setup" },
  { 0, NULL }
};

static const per_choice_t T_srs_ActivateAp_r10_choice[] = {
  {   0, &hf_lte_rrc_release     , ASN1_NO_EXTENSIONS     , dissect_lte_rrc_NULL },
  {   1, &hf_lte_rrc_setup_21    , ASN1_NO_EXTENSIONS     , dissect_lte_rrc_T_setup_20 },
  { 0, NULL, 0, NULL }
};

static int
dissect_lte_rrc_T_srs_ActivateAp_r10(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_lte_rrc_T_srs_ActivateAp_r10, T_srs_ActivateAp_r10_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t T_setup_19_sequence[] = {
  { &hf_lte_rrc_srs_ConfigIndexAp_r10, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_INTEGER_0_31 },
  { &hf_lte_rrc_srs_ConfigApDCI_Format4_r10, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lte_rrc_SEQUENCE_SIZE_1_3_OF_SRS_ConfigAp_r10 },
  { &hf_lte_rrc_srs_ActivateAp_r10, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lte_rrc_T_srs_ActivateAp_r10 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_T_setup_19(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_T_setup_19, T_setup_19_sequence);

  return offset;
}


static const value_string lte_rrc_SoundingRS_UL_ConfigDedicatedAperiodic_r10_vals[] = {
  {   0, "release" },
  {   1, "setup" },
  { 0, NULL }
};

static const per_choice_t SoundingRS_UL_ConfigDedicatedAperiodic_r10_choice[] = {
  {   0, &hf_lte_rrc_release     , ASN1_NO_EXTENSIONS     , dissect_lte_rrc_NULL },
  {   1, &hf_lte_rrc_setup_20    , ASN1_NO_EXTENSIONS     , dissect_lte_rrc_T_setup_19 },
  { 0, NULL, 0, NULL }
};

static int
dissect_lte_rrc_SoundingRS_UL_ConfigDedicatedAperiodic_r10(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_lte_rrc_SoundingRS_UL_ConfigDedicatedAperiodic_r10, SoundingRS_UL_ConfigDedicatedAperiodic_r10_choice,
                                 NULL);

  return offset;
}


static const value_string lte_rrc_T_deltaTxD_OffsetPUCCH_Format1_r10_vals[] = {
  {   0, "dB0" },
  {   1, "dB-2" },
  { 0, NULL }
};


static int
dissect_lte_rrc_T_deltaTxD_OffsetPUCCH_Format1_r10(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, FALSE, 0, NULL);

  return offset;
}


static const value_string lte_rrc_T_deltaTxD_OffsetPUCCH_Format1a1b_r10_vals[] = {
  {   0, "dB0" },
  {   1, "dB-2" },
  { 0, NULL }
};


static int
dissect_lte_rrc_T_deltaTxD_OffsetPUCCH_Format1a1b_r10(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, FALSE, 0, NULL);

  return offset;
}


static const value_string lte_rrc_T_deltaTxD_OffsetPUCCH_Format22a2b_r10_vals[] = {
  {   0, "dB0" },
  {   1, "dB-2" },
  { 0, NULL }
};


static int
dissect_lte_rrc_T_deltaTxD_OffsetPUCCH_Format22a2b_r10(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, FALSE, 0, NULL);

  return offset;
}


static const value_string lte_rrc_T_deltaTxD_OffsetPUCCH_Format3_r10_vals[] = {
  {   0, "dB0" },
  {   1, "dB-2" },
  { 0, NULL }
};


static int
dissect_lte_rrc_T_deltaTxD_OffsetPUCCH_Format3_r10(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, FALSE, 0, NULL);

  return offset;
}


static const per_sequence_t DeltaTxD_OffsetListPUCCH_r10_sequence[] = {
  { &hf_lte_rrc_deltaTxD_OffsetPUCCH_Format1_r10, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lte_rrc_T_deltaTxD_OffsetPUCCH_Format1_r10 },
  { &hf_lte_rrc_deltaTxD_OffsetPUCCH_Format1a1b_r10, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lte_rrc_T_deltaTxD_OffsetPUCCH_Format1a1b_r10 },
  { &hf_lte_rrc_deltaTxD_OffsetPUCCH_Format22a2b_r10, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lte_rrc_T_deltaTxD_OffsetPUCCH_Format22a2b_r10 },
  { &hf_lte_rrc_deltaTxD_OffsetPUCCH_Format3_r10, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lte_rrc_T_deltaTxD_OffsetPUCCH_Format3_r10 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_DeltaTxD_OffsetListPUCCH_r10(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_DeltaTxD_OffsetListPUCCH_r10, DeltaTxD_OffsetListPUCCH_r10_sequence);

  return offset;
}


static const per_sequence_t UplinkPowerControlDedicated_v1020_sequence[] = {
  { &hf_lte_rrc_deltaTxD_OffsetListPUCCH_r10, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lte_rrc_DeltaTxD_OffsetListPUCCH_r10 },
  { &hf_lte_rrc_pSRS_OffsetAp_r10, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lte_rrc_INTEGER_0_15 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_UplinkPowerControlDedicated_v1020(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_UplinkPowerControlDedicated_v1020, UplinkPowerControlDedicated_v1020_sequence);

  return offset;
}


static const per_sequence_t PhysicalConfigDedicated_eag_2_sequence[] = {
  { &hf_lte_rrc_antennaInfo_r10, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lte_rrc_T_antennaInfo_r10 },
  { &hf_lte_rrc_antennaInfoUL_r10, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lte_rrc_AntennaInfoUL_r10 },
  { &hf_lte_rrc_cif_Presence_r10, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lte_rrc_BOOLEAN },
  { &hf_lte_rrc_cqi_ReportConfig_r10, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lte_rrc_CQI_ReportConfig_r10 },
  { &hf_lte_rrc_csi_RS_Config_r10, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lte_rrc_CSI_RS_Config_r10 },
  { &hf_lte_rrc_pucch_ConfigDedicated_v1020, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lte_rrc_PUCCH_ConfigDedicated_v1020 },
  { &hf_lte_rrc_pusch_ConfigDedicated_v1020, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lte_rrc_PUSCH_ConfigDedicated_v1020 },
  { &hf_lte_rrc_schedulingRequestConfig_v1020, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lte_rrc_SchedulingRequestConfig_v1020 },
  { &hf_lte_rrc_soundingRS_UL_ConfigDedicated_v1020, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lte_rrc_SoundingRS_UL_ConfigDedicated_v1020 },
  { &hf_lte_rrc_soundingRS_UL_ConfigDedicatedAperiodic_r10, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lte_rrc_SoundingRS_UL_ConfigDedicatedAperiodic_r10 },
  { &hf_lte_rrc_uplinkPowerControlDedicated_v1020, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lte_rrc_UplinkPowerControlDedicated_v1020 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_PhysicalConfigDedicated_eag_2(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence_eag(tvb, offset, actx, tree, PhysicalConfigDedicated_eag_2_sequence);

  return offset;
}


static const per_sequence_t T_setup_11_sequence[] = {
  { &hf_lte_rrc_additionalSpectrumEmissionPCell_r10, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_AdditionalSpectrumEmission },
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_T_setup_11(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_T_setup_11, T_setup_11_sequence);

  return offset;
}


static const value_string lte_rrc_T_additionalSpectrumEmissionCA_r10_vals[] = {
  {   0, "release" },
  {   1, "setup" },
  { 0, NULL }
};

static const per_choice_t T_additionalSpectrumEmissionCA_r10_choice[] = {
  {   0, &hf_lte_rrc_release     , ASN1_NO_EXTENSIONS     , dissect_lte_rrc_NULL },
  {   1, &hf_lte_rrc_setup_11    , ASN1_NO_EXTENSIONS     , dissect_lte_rrc_T_setup_11 },
  { 0, NULL, 0, NULL }
};

static int
dissect_lte_rrc_T_additionalSpectrumEmissionCA_r10(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_lte_rrc_T_additionalSpectrumEmissionCA_r10, T_additionalSpectrumEmissionCA_r10_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t PhysicalConfigDedicated_eag_3_sequence[] = {
  { &hf_lte_rrc_additionalSpectrumEmissionCA_r10, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lte_rrc_T_additionalSpectrumEmissionCA_r10 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_PhysicalConfigDedicated_eag_3(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence_eag(tvb, offset, actx, tree, PhysicalConfigDedicated_eag_3_sequence);

  return offset;
}


static const per_sequence_t PhysicalConfigDedicated_sequence[] = {
  { &hf_lte_rrc_pdsch_ConfigDedicated, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lte_rrc_PDSCH_ConfigDedicated },
  { &hf_lte_rrc_pucch_ConfigDedicated, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lte_rrc_PUCCH_ConfigDedicated },
  { &hf_lte_rrc_pusch_ConfigDedicated, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lte_rrc_PUSCH_ConfigDedicated },
  { &hf_lte_rrc_uplinkPowerControlDedicated, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lte_rrc_UplinkPowerControlDedicated },
  { &hf_lte_rrc_tpc_PDCCH_ConfigPUCCH, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lte_rrc_TPC_PDCCH_Config },
  { &hf_lte_rrc_tpc_PDCCH_ConfigPUSCH, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lte_rrc_TPC_PDCCH_Config },
  { &hf_lte_rrc_cqi_ReportConfig, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lte_rrc_CQI_ReportConfig },
  { &hf_lte_rrc_soundingRS_UL_ConfigDedicated, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lte_rrc_SoundingRS_UL_ConfigDedicated },
  { &hf_lte_rrc_antennaInfo , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lte_rrc_T_antennaInfo },
  { &hf_lte_rrc_schedulingRequestConfig, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lte_rrc_SchedulingRequestConfig },
  { &hf_lte_rrc_dummy_eag_field, ASN1_NOT_EXTENSION_ROOT, ASN1_NOT_OPTIONAL, dissect_lte_rrc_PhysicalConfigDedicated_eag_1 },
  { &hf_lte_rrc_dummy_eag_field, ASN1_NOT_EXTENSION_ROOT, ASN1_NOT_OPTIONAL, dissect_lte_rrc_PhysicalConfigDedicated_eag_2 },
  { &hf_lte_rrc_dummy_eag_field, ASN1_NOT_EXTENSION_ROOT, ASN1_NOT_OPTIONAL, dissect_lte_rrc_PhysicalConfigDedicated_eag_3 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_PhysicalConfigDedicated(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_PhysicalConfigDedicated, PhysicalConfigDedicated_sequence);

  return offset;
}


static const value_string lte_rrc_T_t301_r9_vals[] = {
  {   0, "ms100" },
  {   1, "ms200" },
  {   2, "ms300" },
  {   3, "ms400" },
  {   4, "ms600" },
  {   5, "ms1000" },
  {   6, "ms1500" },
  {   7, "ms2000" },
  { 0, NULL }
};


static int
dissect_lte_rrc_T_t301_r9(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     8, NULL, FALSE, 0, NULL);

  return offset;
}


static const value_string lte_rrc_T_t310_r9_vals[] = {
  {   0, "ms0" },
  {   1, "ms50" },
  {   2, "ms100" },
  {   3, "ms200" },
  {   4, "ms500" },
  {   5, "ms1000" },
  {   6, "ms2000" },
  { 0, NULL }
};


static int
dissect_lte_rrc_T_t310_r9(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     7, NULL, FALSE, 0, NULL);

  return offset;
}


static const value_string lte_rrc_T_n310_r9_vals[] = {
  {   0, "n1" },
  {   1, "n2" },
  {   2, "n3" },
  {   3, "n4" },
  {   4, "n6" },
  {   5, "n8" },
  {   6, "n10" },
  {   7, "n20" },
  { 0, NULL }
};


static int
dissect_lte_rrc_T_n310_r9(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     8, NULL, FALSE, 0, NULL);

  return offset;
}


static const value_string lte_rrc_T_t311_r9_vals[] = {
  {   0, "ms1000" },
  {   1, "ms3000" },
  {   2, "ms5000" },
  {   3, "ms10000" },
  {   4, "ms15000" },
  {   5, "ms20000" },
  {   6, "ms30000" },
  { 0, NULL }
};


static int
dissect_lte_rrc_T_t311_r9(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     7, NULL, FALSE, 0, NULL);

  return offset;
}


static const value_string lte_rrc_T_n311_r9_vals[] = {
  {   0, "n1" },
  {   1, "n2" },
  {   2, "n3" },
  {   3, "n4" },
  {   4, "n5" },
  {   5, "n6" },
  {   6, "n8" },
  {   7, "n10" },
  { 0, NULL }
};


static int
dissect_lte_rrc_T_n311_r9(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     8, NULL, FALSE, 0, NULL);

  return offset;
}


static const per_sequence_t T_setup_15_sequence[] = {
  { &hf_lte_rrc_t301_r9     , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lte_rrc_T_t301_r9 },
  { &hf_lte_rrc_t310_r9     , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lte_rrc_T_t310_r9 },
  { &hf_lte_rrc_n310_r9     , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lte_rrc_T_n310_r9 },
  { &hf_lte_rrc_t311_r9     , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lte_rrc_T_t311_r9 },
  { &hf_lte_rrc_n311_r9     , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lte_rrc_T_n311_r9 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_T_setup_15(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_T_setup_15, T_setup_15_sequence);

  return offset;
}


static const value_string lte_rrc_RLF_TimersAndConstants_r9_vals[] = {
  {   0, "release" },
  {   1, "setup" },
  { 0, NULL }
};

static const per_choice_t RLF_TimersAndConstants_r9_choice[] = {
  {   0, &hf_lte_rrc_release     , ASN1_NO_EXTENSIONS     , dissect_lte_rrc_NULL },
  {   1, &hf_lte_rrc_setup_16    , ASN1_NO_EXTENSIONS     , dissect_lte_rrc_T_setup_15 },
  { 0, NULL, 0, NULL }
};

static int
dissect_lte_rrc_RLF_TimersAndConstants_r9(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_lte_rrc_RLF_TimersAndConstants_r9, RLF_TimersAndConstants_r9_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t RadioResourceConfigDedicated_eag_1_sequence[] = {
  { &hf_lte_rrc_rlf_TimersAndConstants_r9, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lte_rrc_RLF_TimersAndConstants_r9 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_RadioResourceConfigDedicated_eag_1(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence_eag(tvb, offset, actx, tree, RadioResourceConfigDedicated_eag_1_sequence);

  return offset;
}


static const value_string lte_rrc_MeasSubframePatternPCell_r10_vals[] = {
  {   0, "release" },
  {   1, "setup" },
  { 0, NULL }
};

static const per_choice_t MeasSubframePatternPCell_r10_choice[] = {
  {   0, &hf_lte_rrc_release     , ASN1_NO_EXTENSIONS     , dissect_lte_rrc_NULL },
  {   1, &hf_lte_rrc_setup_15    , ASN1_NO_EXTENSIONS     , dissect_lte_rrc_MeasSubframePattern_r10 },
  { 0, NULL, 0, NULL }
};

static int
dissect_lte_rrc_MeasSubframePatternPCell_r10(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_lte_rrc_MeasSubframePatternPCell_r10, MeasSubframePatternPCell_r10_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t RadioResourceConfigDedicated_eag_2_sequence[] = {
  { &hf_lte_rrc_measSubframePatternPCell_r10, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lte_rrc_MeasSubframePatternPCell_r10 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_RadioResourceConfigDedicated_eag_2(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence_eag(tvb, offset, actx, tree, RadioResourceConfigDedicated_eag_2_sequence);

  return offset;
}


static const per_sequence_t RadioResourceConfigDedicated_sequence[] = {
  { &hf_lte_rrc_srb_ToAddModList, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lte_rrc_SRB_ToAddModList },
  { &hf_lte_rrc_drb_ToAddModList, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lte_rrc_DRB_ToAddModList },
  { &hf_lte_rrc_drb_ToReleaseList, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lte_rrc_DRB_ToReleaseList },
  { &hf_lte_rrc_mac_MainConfig, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lte_rrc_T_mac_MainConfig },
  { &hf_lte_rrc_sps_Config  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lte_rrc_SPS_Config },
  { &hf_lte_rrc_physicalConfigDedicated, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lte_rrc_PhysicalConfigDedicated },
  { &hf_lte_rrc_dummy_eag_field, ASN1_NOT_EXTENSION_ROOT, ASN1_NOT_OPTIONAL, dissect_lte_rrc_RadioResourceConfigDedicated_eag_1 },
  { &hf_lte_rrc_dummy_eag_field, ASN1_NOT_EXTENSION_ROOT, ASN1_NOT_OPTIONAL, dissect_lte_rrc_RadioResourceConfigDedicated_eag_2 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_RadioResourceConfigDedicated(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_RadioResourceConfigDedicated, RadioResourceConfigDedicated_sequence);

  return offset;
}



static int
dissect_lte_rrc_NextHopChainingCount(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 7U, NULL, FALSE);

  return offset;
}


static const per_sequence_t T_nonCriticalExtension_20_sequence[] = {
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_T_nonCriticalExtension_20(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_T_nonCriticalExtension_20, T_nonCriticalExtension_20_sequence);

  return offset;
}


static const per_sequence_t RRCConnectionReestablishment_v8a0_IEs_sequence[] = {
  { &hf_lte_rrc_lateNonCriticalExtension, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lte_rrc_OCTET_STRING },
  { &hf_lte_rrc_nonCriticalExtension_43, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lte_rrc_T_nonCriticalExtension_20 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_RRCConnectionReestablishment_v8a0_IEs(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_RRCConnectionReestablishment_v8a0_IEs, RRCConnectionReestablishment_v8a0_IEs_sequence);

  return offset;
}


static const per_sequence_t RRCConnectionReestablishment_r8_IEs_sequence[] = {
  { &hf_lte_rrc_radioResourceConfigDedicated, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_RadioResourceConfigDedicated },
  { &hf_lte_rrc_nextHopChainingCount, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_NextHopChainingCount },
  { &hf_lte_rrc_nonCriticalExtension_42, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lte_rrc_RRCConnectionReestablishment_v8a0_IEs },
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_RRCConnectionReestablishment_r8_IEs(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_RRCConnectionReestablishment_r8_IEs, RRCConnectionReestablishment_r8_IEs_sequence);

  return offset;
}


static const value_string lte_rrc_T_c1_19_vals[] = {
  {   0, "rrcConnectionReestablishment-r8" },
  {   1, "spare7" },
  {   2, "spare6" },
  {   3, "spare5" },
  {   4, "spare4" },
  {   5, "spare3" },
  {   6, "spare2" },
  {   7, "spare1" },
  { 0, NULL }
};

static const per_choice_t T_c1_19_choice[] = {
  {   0, &hf_lte_rrc_rrcConnectionReestablishment_r8, ASN1_NO_EXTENSIONS     , dissect_lte_rrc_RRCConnectionReestablishment_r8_IEs },
  {   1, &hf_lte_rrc_spare7      , ASN1_NO_EXTENSIONS     , dissect_lte_rrc_NULL },
  {   2, &hf_lte_rrc_spare6      , ASN1_NO_EXTENSIONS     , dissect_lte_rrc_NULL },
  {   3, &hf_lte_rrc_spare5      , ASN1_NO_EXTENSIONS     , dissect_lte_rrc_NULL },
  {   4, &hf_lte_rrc_spare4      , ASN1_NO_EXTENSIONS     , dissect_lte_rrc_NULL },
  {   5, &hf_lte_rrc_spare3      , ASN1_NO_EXTENSIONS     , dissect_lte_rrc_NULL },
  {   6, &hf_lte_rrc_spare2      , ASN1_NO_EXTENSIONS     , dissect_lte_rrc_NULL },
  {   7, &hf_lte_rrc_spare1      , ASN1_NO_EXTENSIONS     , dissect_lte_rrc_NULL },
  { 0, NULL, 0, NULL }
};

static int
dissect_lte_rrc_T_c1_19(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_lte_rrc_T_c1_19, T_c1_19_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t T_criticalExtensionsFuture_16_sequence[] = {
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_T_criticalExtensionsFuture_16(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_T_criticalExtensionsFuture_16, T_criticalExtensionsFuture_16_sequence);

  return offset;
}


static const value_string lte_rrc_T_criticalExtensions_16_vals[] = {
  {   0, "c1" },
  {   1, "criticalExtensionsFuture" },
  { 0, NULL }
};

static const per_choice_t T_criticalExtensions_16_choice[] = {
  {   0, &hf_lte_rrc_c1_19       , ASN1_NO_EXTENSIONS     , dissect_lte_rrc_T_c1_19 },
  {   1, &hf_lte_rrc_criticalExtensionsFuture_16, ASN1_NO_EXTENSIONS     , dissect_lte_rrc_T_criticalExtensionsFuture_16 },
  { 0, NULL, 0, NULL }
};

static int
dissect_lte_rrc_T_criticalExtensions_16(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_lte_rrc_T_criticalExtensions_16, T_criticalExtensions_16_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t RRCConnectionReestablishment_sequence[] = {
  { &hf_lte_rrc_rrc_TransactionIdentifier, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_RRC_TransactionIdentifier },
  { &hf_lte_rrc_criticalExtensions_16, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_T_criticalExtensions_16 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_RRCConnectionReestablishment(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {

col_append_str(actx->pinfo->cinfo, COL_INFO, "RRCConnectionReestablishment ");

  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_RRCConnectionReestablishment, RRCConnectionReestablishment_sequence);

  return offset;
}


static const per_sequence_t T_nonCriticalExtension_22_sequence[] = {
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_T_nonCriticalExtension_22(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_T_nonCriticalExtension_22, T_nonCriticalExtension_22_sequence);

  return offset;
}


static const per_sequence_t RRCConnectionReestablishmentReject_v8a0_IEs_sequence[] = {
  { &hf_lte_rrc_lateNonCriticalExtension, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lte_rrc_OCTET_STRING },
  { &hf_lte_rrc_nonCriticalExtension_49, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lte_rrc_T_nonCriticalExtension_22 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_RRCConnectionReestablishmentReject_v8a0_IEs(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_RRCConnectionReestablishmentReject_v8a0_IEs, RRCConnectionReestablishmentReject_v8a0_IEs_sequence);

  return offset;
}


static const per_sequence_t RRCConnectionReestablishmentReject_r8_IEs_sequence[] = {
  { &hf_lte_rrc_nonCriticalExtension_48, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lte_rrc_RRCConnectionReestablishmentReject_v8a0_IEs },
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_RRCConnectionReestablishmentReject_r8_IEs(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_RRCConnectionReestablishmentReject_r8_IEs, RRCConnectionReestablishmentReject_r8_IEs_sequence);

  return offset;
}


static const per_sequence_t T_criticalExtensionsFuture_18_sequence[] = {
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_T_criticalExtensionsFuture_18(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_T_criticalExtensionsFuture_18, T_criticalExtensionsFuture_18_sequence);

  return offset;
}


static const value_string lte_rrc_T_criticalExtensions_18_vals[] = {
  {   0, "rrcConnectionReestablishmentReject-r8" },
  {   1, "criticalExtensionsFuture" },
  { 0, NULL }
};

static const per_choice_t T_criticalExtensions_18_choice[] = {
  {   0, &hf_lte_rrc_rrcConnectionReestablishmentReject_r8, ASN1_NO_EXTENSIONS     , dissect_lte_rrc_RRCConnectionReestablishmentReject_r8_IEs },
  {   1, &hf_lte_rrc_criticalExtensionsFuture_18, ASN1_NO_EXTENSIONS     , dissect_lte_rrc_T_criticalExtensionsFuture_18 },
  { 0, NULL, 0, NULL }
};

static int
dissect_lte_rrc_T_criticalExtensions_18(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_lte_rrc_T_criticalExtensions_18, T_criticalExtensions_18_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t RRCConnectionReestablishmentReject_sequence[] = {
  { &hf_lte_rrc_criticalExtensions_18, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_T_criticalExtensions_18 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_RRCConnectionReestablishmentReject(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {

col_append_str(actx->pinfo->cinfo, COL_INFO, "RRCConnectionReestablishmentReject ");

  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_RRCConnectionReestablishmentReject, RRCConnectionReestablishmentReject_sequence);

  return offset;
}



static int
dissect_lte_rrc_T_waitTime(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            1U, 16U, NULL, FALSE);

  proto_item_append_text(actx->created_item, "s");


  return offset;
}



static int
dissect_lte_rrc_T_extendedWaitTime_r10(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            1U, 1800U, NULL, FALSE);

  proto_item_append_text(actx->created_item, "s");


  return offset;
}


static const per_sequence_t T_nonCriticalExtension_23_sequence[] = {
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_T_nonCriticalExtension_23(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_T_nonCriticalExtension_23, T_nonCriticalExtension_23_sequence);

  return offset;
}


static const per_sequence_t RRCConnectionReject_v1020_IEs_sequence[] = {
  { &hf_lte_rrc_extendedWaitTime_r10, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lte_rrc_T_extendedWaitTime_r10 },
  { &hf_lte_rrc_nonCriticalExtension_52, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lte_rrc_T_nonCriticalExtension_23 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_RRCConnectionReject_v1020_IEs(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_RRCConnectionReject_v1020_IEs, RRCConnectionReject_v1020_IEs_sequence);

  return offset;
}


static const per_sequence_t RRCConnectionReject_v8a0_IEs_sequence[] = {
  { &hf_lte_rrc_lateNonCriticalExtension, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lte_rrc_OCTET_STRING },
  { &hf_lte_rrc_nonCriticalExtension_51, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lte_rrc_RRCConnectionReject_v1020_IEs },
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_RRCConnectionReject_v8a0_IEs(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_RRCConnectionReject_v8a0_IEs, RRCConnectionReject_v8a0_IEs_sequence);

  return offset;
}


static const per_sequence_t RRCConnectionReject_r8_IEs_sequence[] = {
  { &hf_lte_rrc_waitTime    , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_T_waitTime },
  { &hf_lte_rrc_nonCriticalExtension_50, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lte_rrc_RRCConnectionReject_v8a0_IEs },
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_RRCConnectionReject_r8_IEs(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_RRCConnectionReject_r8_IEs, RRCConnectionReject_r8_IEs_sequence);

  return offset;
}


static const value_string lte_rrc_T_c1_20_vals[] = {
  {   0, "rrcConnectionReject-r8" },
  {   1, "spare3" },
  {   2, "spare2" },
  {   3, "spare1" },
  { 0, NULL }
};

static const per_choice_t T_c1_20_choice[] = {
  {   0, &hf_lte_rrc_rrcConnectionReject_r8, ASN1_NO_EXTENSIONS     , dissect_lte_rrc_RRCConnectionReject_r8_IEs },
  {   1, &hf_lte_rrc_spare3      , ASN1_NO_EXTENSIONS     , dissect_lte_rrc_NULL },
  {   2, &hf_lte_rrc_spare2      , ASN1_NO_EXTENSIONS     , dissect_lte_rrc_NULL },
  {   3, &hf_lte_rrc_spare1      , ASN1_NO_EXTENSIONS     , dissect_lte_rrc_NULL },
  { 0, NULL, 0, NULL }
};

static int
dissect_lte_rrc_T_c1_20(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_lte_rrc_T_c1_20, T_c1_20_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t T_criticalExtensionsFuture_20_sequence[] = {
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_T_criticalExtensionsFuture_20(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_T_criticalExtensionsFuture_20, T_criticalExtensionsFuture_20_sequence);

  return offset;
}


static const value_string lte_rrc_T_criticalExtensions_20_vals[] = {
  {   0, "c1" },
  {   1, "criticalExtensionsFuture" },
  { 0, NULL }
};

static const per_choice_t T_criticalExtensions_20_choice[] = {
  {   0, &hf_lte_rrc_c1_20       , ASN1_NO_EXTENSIONS     , dissect_lte_rrc_T_c1_20 },
  {   1, &hf_lte_rrc_criticalExtensionsFuture_20, ASN1_NO_EXTENSIONS     , dissect_lte_rrc_T_criticalExtensionsFuture_20 },
  { 0, NULL, 0, NULL }
};

static int
dissect_lte_rrc_T_criticalExtensions_20(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_lte_rrc_T_criticalExtensions_20, T_criticalExtensions_20_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t RRCConnectionReject_sequence[] = {
  { &hf_lte_rrc_criticalExtensions_20, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_T_criticalExtensions_20 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_RRCConnectionReject(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {

col_append_str(actx->pinfo->cinfo, COL_INFO, "RRCConnectionReject ");

  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_RRCConnectionReject, RRCConnectionReject_sequence);

  return offset;
}


static const per_sequence_t T_nonCriticalExtension_25_sequence[] = {
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_T_nonCriticalExtension_25(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_T_nonCriticalExtension_25, T_nonCriticalExtension_25_sequence);

  return offset;
}


static const per_sequence_t RRCConnectionSetup_v8a0_IEs_sequence[] = {
  { &hf_lte_rrc_lateNonCriticalExtension, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lte_rrc_OCTET_STRING },
  { &hf_lte_rrc_nonCriticalExtension_58, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lte_rrc_T_nonCriticalExtension_25 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_RRCConnectionSetup_v8a0_IEs(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_RRCConnectionSetup_v8a0_IEs, RRCConnectionSetup_v8a0_IEs_sequence);

  return offset;
}


static const per_sequence_t RRCConnectionSetup_r8_IEs_sequence[] = {
  { &hf_lte_rrc_radioResourceConfigDedicated, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_RadioResourceConfigDedicated },
  { &hf_lte_rrc_nonCriticalExtension_57, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lte_rrc_RRCConnectionSetup_v8a0_IEs },
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_RRCConnectionSetup_r8_IEs(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_RRCConnectionSetup_r8_IEs, RRCConnectionSetup_r8_IEs_sequence);

  return offset;
}


static const value_string lte_rrc_T_c1_22_vals[] = {
  {   0, "rrcConnectionSetup-r8" },
  {   1, "spare7" },
  {   2, "spare6" },
  {   3, "spare5" },
  {   4, "spare4" },
  {   5, "spare3" },
  {   6, "spare2" },
  {   7, "spare1" },
  { 0, NULL }
};

static const per_choice_t T_c1_22_choice[] = {
  {   0, &hf_lte_rrc_rrcConnectionSetup_r8, ASN1_NO_EXTENSIONS     , dissect_lte_rrc_RRCConnectionSetup_r8_IEs },
  {   1, &hf_lte_rrc_spare7      , ASN1_NO_EXTENSIONS     , dissect_lte_rrc_NULL },
  {   2, &hf_lte_rrc_spare6      , ASN1_NO_EXTENSIONS     , dissect_lte_rrc_NULL },
  {   3, &hf_lte_rrc_spare5      , ASN1_NO_EXTENSIONS     , dissect_lte_rrc_NULL },
  {   4, &hf_lte_rrc_spare4      , ASN1_NO_EXTENSIONS     , dissect_lte_rrc_NULL },
  {   5, &hf_lte_rrc_spare3      , ASN1_NO_EXTENSIONS     , dissect_lte_rrc_NULL },
  {   6, &hf_lte_rrc_spare2      , ASN1_NO_EXTENSIONS     , dissect_lte_rrc_NULL },
  {   7, &hf_lte_rrc_spare1      , ASN1_NO_EXTENSIONS     , dissect_lte_rrc_NULL },
  { 0, NULL, 0, NULL }
};

static int
dissect_lte_rrc_T_c1_22(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_lte_rrc_T_c1_22, T_c1_22_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t T_criticalExtensionsFuture_23_sequence[] = {
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_T_criticalExtensionsFuture_23(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_T_criticalExtensionsFuture_23, T_criticalExtensionsFuture_23_sequence);

  return offset;
}


static const value_string lte_rrc_T_criticalExtensions_23_vals[] = {
  {   0, "c1" },
  {   1, "criticalExtensionsFuture" },
  { 0, NULL }
};

static const per_choice_t T_criticalExtensions_23_choice[] = {
  {   0, &hf_lte_rrc_c1_22       , ASN1_NO_EXTENSIONS     , dissect_lte_rrc_T_c1_22 },
  {   1, &hf_lte_rrc_criticalExtensionsFuture_23, ASN1_NO_EXTENSIONS     , dissect_lte_rrc_T_criticalExtensionsFuture_23 },
  { 0, NULL, 0, NULL }
};

static int
dissect_lte_rrc_T_criticalExtensions_23(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_lte_rrc_T_criticalExtensions_23, T_criticalExtensions_23_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t RRCConnectionSetup_sequence[] = {
  { &hf_lte_rrc_rrc_TransactionIdentifier, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_RRC_TransactionIdentifier },
  { &hf_lte_rrc_criticalExtensions_23, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_T_criticalExtensions_23 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_RRCConnectionSetup(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {

col_append_str(actx->pinfo->cinfo, COL_INFO, "RRCConnectionSetup ");

  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_RRCConnectionSetup, RRCConnectionSetup_sequence);

  return offset;
}


static const value_string lte_rrc_T_c1_03_vals[] = {
  {   0, "rrcConnectionReestablishment" },
  {   1, "rrcConnectionReestablishmentReject" },
  {   2, "rrcConnectionReject" },
  {   3, "rrcConnectionSetup" },
  { 0, NULL }
};

static const per_choice_t T_c1_03_choice[] = {
  {   0, &hf_lte_rrc_rrcConnectionReestablishment, ASN1_NO_EXTENSIONS     , dissect_lte_rrc_RRCConnectionReestablishment },
  {   1, &hf_lte_rrc_rrcConnectionReestablishmentReject, ASN1_NO_EXTENSIONS     , dissect_lte_rrc_RRCConnectionReestablishmentReject },
  {   2, &hf_lte_rrc_rrcConnectionReject, ASN1_NO_EXTENSIONS     , dissect_lte_rrc_RRCConnectionReject },
  {   3, &hf_lte_rrc_rrcConnectionSetup, ASN1_NO_EXTENSIONS     , dissect_lte_rrc_RRCConnectionSetup },
  { 0, NULL, 0, NULL }
};

static int
dissect_lte_rrc_T_c1_03(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_lte_rrc_T_c1_03, T_c1_03_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t T_messageClassExtension_03_sequence[] = {
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_T_messageClassExtension_03(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_T_messageClassExtension_03, T_messageClassExtension_03_sequence);

  return offset;
}


static const value_string lte_rrc_DL_CCCH_MessageType_vals[] = {
  {   0, "c1" },
  {   1, "messageClassExtension" },
  { 0, NULL }
};

static const per_choice_t DL_CCCH_MessageType_choice[] = {
  {   0, &hf_lte_rrc_c1_03       , ASN1_NO_EXTENSIONS     , dissect_lte_rrc_T_c1_03 },
  {   1, &hf_lte_rrc_messageClassExtension_03, ASN1_NO_EXTENSIONS     , dissect_lte_rrc_T_messageClassExtension_03 },
  { 0, NULL, 0, NULL }
};

static int
dissect_lte_rrc_DL_CCCH_MessageType(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_lte_rrc_DL_CCCH_MessageType, DL_CCCH_MessageType_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t DL_CCCH_Message_sequence[] = {
  { &hf_lte_rrc_message_04  , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_DL_CCCH_MessageType },
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_DL_CCCH_Message(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_DL_CCCH_Message, DL_CCCH_Message_sequence);

  return offset;
}



static int
dissect_lte_rrc_RAND_CDMA2000(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     32, 32, FALSE, NULL);

  return offset;
}



static int
dissect_lte_rrc_MobilityParametersCDMA2000(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_octet_string(tvb, offset, actx, tree, hf_index,
                                       NO_BOUND, NO_BOUND, FALSE, NULL);

  return offset;
}


static const per_sequence_t T_nonCriticalExtension_03_sequence[] = {
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_T_nonCriticalExtension_03(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_T_nonCriticalExtension_03, T_nonCriticalExtension_03_sequence);

  return offset;
}


static const per_sequence_t CSFBParametersResponseCDMA2000_v8a0_IEs_sequence[] = {
  { &hf_lte_rrc_lateNonCriticalExtension, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lte_rrc_OCTET_STRING },
  { &hf_lte_rrc_nonCriticalExtension_07, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lte_rrc_T_nonCriticalExtension_03 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_CSFBParametersResponseCDMA2000_v8a0_IEs(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_CSFBParametersResponseCDMA2000_v8a0_IEs, CSFBParametersResponseCDMA2000_v8a0_IEs_sequence);

  return offset;
}


static const per_sequence_t CSFBParametersResponseCDMA2000_r8_IEs_sequence[] = {
  { &hf_lte_rrc_rand        , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_RAND_CDMA2000 },
  { &hf_lte_rrc_mobilityParameters, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_MobilityParametersCDMA2000 },
  { &hf_lte_rrc_nonCriticalExtension_06, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lte_rrc_CSFBParametersResponseCDMA2000_v8a0_IEs },
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_CSFBParametersResponseCDMA2000_r8_IEs(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_CSFBParametersResponseCDMA2000_r8_IEs, CSFBParametersResponseCDMA2000_r8_IEs_sequence);

  return offset;
}


static const per_sequence_t T_criticalExtensionsFuture_03_sequence[] = {
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_T_criticalExtensionsFuture_03(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_T_criticalExtensionsFuture_03, T_criticalExtensionsFuture_03_sequence);

  return offset;
}


static const value_string lte_rrc_T_criticalExtensions_03_vals[] = {
  {   0, "csfbParametersResponseCDMA2000-r8" },
  {   1, "criticalExtensionsFuture" },
  { 0, NULL }
};

static const per_choice_t T_criticalExtensions_03_choice[] = {
  {   0, &hf_lte_rrc_csfbParametersResponseCDMA2000_r8, ASN1_NO_EXTENSIONS     , dissect_lte_rrc_CSFBParametersResponseCDMA2000_r8_IEs },
  {   1, &hf_lte_rrc_criticalExtensionsFuture_03, ASN1_NO_EXTENSIONS     , dissect_lte_rrc_T_criticalExtensionsFuture_03 },
  { 0, NULL, 0, NULL }
};

static int
dissect_lte_rrc_T_criticalExtensions_03(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_lte_rrc_T_criticalExtensions_03, T_criticalExtensions_03_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t CSFBParametersResponseCDMA2000_sequence[] = {
  { &hf_lte_rrc_rrc_TransactionIdentifier, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_RRC_TransactionIdentifier },
  { &hf_lte_rrc_criticalExtensions_03, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_T_criticalExtensions_03 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_CSFBParametersResponseCDMA2000(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {

col_append_str(actx->pinfo->cinfo, COL_INFO, "CSFBParametersResponseCDMA2000 ");

  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_CSFBParametersResponseCDMA2000, CSFBParametersResponseCDMA2000_sequence);

  return offset;
}



static int
dissect_lte_rrc_DedicatedInfoNAS(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  tvbuff_t *nas_eps_tvb=NULL;

  offset = dissect_per_octet_string(tvb, offset, actx, tree, hf_index,
                                       NO_BOUND, NO_BOUND, FALSE, &nas_eps_tvb);


	if ((nas_eps_tvb)&&(nas_eps_handle))
		call_dissector(nas_eps_handle,nas_eps_tvb,actx->pinfo, tree);


  return offset;
}



static int
dissect_lte_rrc_DedicatedInfoCDMA2000(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_octet_string(tvb, offset, actx, tree, hf_index,
                                       NO_BOUND, NO_BOUND, FALSE, NULL);

  return offset;
}


static const value_string lte_rrc_T_dedicatedInfoType_vals[] = {
  {   0, "dedicatedInfoNAS" },
  {   1, "dedicatedInfoCDMA2000-1XRTT" },
  {   2, "dedicatedInfoCDMA2000-HRPD" },
  { 0, NULL }
};

static const per_choice_t T_dedicatedInfoType_choice[] = {
  {   0, &hf_lte_rrc_dedicatedInfoNAS, ASN1_NO_EXTENSIONS     , dissect_lte_rrc_DedicatedInfoNAS },
  {   1, &hf_lte_rrc_dedicatedInfoCDMA2000_1XRTT, ASN1_NO_EXTENSIONS     , dissect_lte_rrc_DedicatedInfoCDMA2000 },
  {   2, &hf_lte_rrc_dedicatedInfoCDMA2000_HRPD, ASN1_NO_EXTENSIONS     , dissect_lte_rrc_DedicatedInfoCDMA2000 },
  { 0, NULL, 0, NULL }
};

static int
dissect_lte_rrc_T_dedicatedInfoType(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_lte_rrc_T_dedicatedInfoType, T_dedicatedInfoType_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t T_nonCriticalExtension_04_sequence[] = {
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_T_nonCriticalExtension_04(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_T_nonCriticalExtension_04, T_nonCriticalExtension_04_sequence);

  return offset;
}


static const per_sequence_t DLInformationTransfer_v8a0_IEs_sequence[] = {
  { &hf_lte_rrc_lateNonCriticalExtension, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lte_rrc_OCTET_STRING },
  { &hf_lte_rrc_nonCriticalExtension_09, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lte_rrc_T_nonCriticalExtension_04 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_DLInformationTransfer_v8a0_IEs(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_DLInformationTransfer_v8a0_IEs, DLInformationTransfer_v8a0_IEs_sequence);

  return offset;
}


static const per_sequence_t DLInformationTransfer_r8_IEs_sequence[] = {
  { &hf_lte_rrc_dedicatedInfoType, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_T_dedicatedInfoType },
  { &hf_lte_rrc_nonCriticalExtension_08, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lte_rrc_DLInformationTransfer_v8a0_IEs },
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_DLInformationTransfer_r8_IEs(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_DLInformationTransfer_r8_IEs, DLInformationTransfer_r8_IEs_sequence);

  return offset;
}


static const value_string lte_rrc_T_c1_08_vals[] = {
  {   0, "dlInformationTransfer-r8" },
  {   1, "spare3" },
  {   2, "spare2" },
  {   3, "spare1" },
  { 0, NULL }
};

static const per_choice_t T_c1_08_choice[] = {
  {   0, &hf_lte_rrc_dlInformationTransfer_r8, ASN1_NO_EXTENSIONS     , dissect_lte_rrc_DLInformationTransfer_r8_IEs },
  {   1, &hf_lte_rrc_spare3      , ASN1_NO_EXTENSIONS     , dissect_lte_rrc_NULL },
  {   2, &hf_lte_rrc_spare2      , ASN1_NO_EXTENSIONS     , dissect_lte_rrc_NULL },
  {   3, &hf_lte_rrc_spare1      , ASN1_NO_EXTENSIONS     , dissect_lte_rrc_NULL },
  { 0, NULL, 0, NULL }
};

static int
dissect_lte_rrc_T_c1_08(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_lte_rrc_T_c1_08, T_c1_08_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t T_criticalExtensionsFuture_04_sequence[] = {
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_T_criticalExtensionsFuture_04(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_T_criticalExtensionsFuture_04, T_criticalExtensionsFuture_04_sequence);

  return offset;
}


static const value_string lte_rrc_T_criticalExtensions_04_vals[] = {
  {   0, "c1" },
  {   1, "criticalExtensionsFuture" },
  { 0, NULL }
};

static const per_choice_t T_criticalExtensions_04_choice[] = {
  {   0, &hf_lte_rrc_c1_08       , ASN1_NO_EXTENSIONS     , dissect_lte_rrc_T_c1_08 },
  {   1, &hf_lte_rrc_criticalExtensionsFuture_04, ASN1_NO_EXTENSIONS     , dissect_lte_rrc_T_criticalExtensionsFuture_04 },
  { 0, NULL, 0, NULL }
};

static int
dissect_lte_rrc_T_criticalExtensions_04(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_lte_rrc_T_criticalExtensions_04, T_criticalExtensions_04_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t DLInformationTransfer_sequence[] = {
  { &hf_lte_rrc_rrc_TransactionIdentifier, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_RRC_TransactionIdentifier },
  { &hf_lte_rrc_criticalExtensions_04, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_T_criticalExtensions_04 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_DLInformationTransfer(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {

col_append_str(actx->pinfo->cinfo, COL_INFO, "DLInformationTransfer ");

  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_DLInformationTransfer, DLInformationTransfer_sequence);

  return offset;
}


static const value_string lte_rrc_CDMA2000_Type_vals[] = {
  {   0, "type1XRTT" },
  {   1, "typeHRPD" },
  { 0, NULL }
};


static int
dissect_lte_rrc_CDMA2000_Type(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, FALSE, 0, NULL);

  return offset;
}


static const value_string lte_rrc_T_dualRxTxRedirectIndicator_r10_vals[] = {
  {   0, "true" },
  { 0, NULL }
};


static int
dissect_lte_rrc_T_dualRxTxRedirectIndicator_r10(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, FALSE, 0, NULL);

  return offset;
}


static const per_sequence_t CarrierFreqCDMA2000_sequence[] = {
  { &hf_lte_rrc_bandClass   , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_BandclassCDMA2000 },
  { &hf_lte_rrc_arfcn       , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_ARFCN_ValueCDMA2000 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_CarrierFreqCDMA2000(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_CarrierFreqCDMA2000, CarrierFreqCDMA2000_sequence);

  return offset;
}


static const per_sequence_t T_nonCriticalExtension_05_sequence[] = {
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_T_nonCriticalExtension_05(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_T_nonCriticalExtension_05, T_nonCriticalExtension_05_sequence);

  return offset;
}


static const per_sequence_t HandoverFromEUTRAPreparationRequest_v1020_IEs_sequence[] = {
  { &hf_lte_rrc_dualRxTxRedirectIndicator_r10, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lte_rrc_T_dualRxTxRedirectIndicator_r10 },
  { &hf_lte_rrc_redirectCarrierCDMA2000_1XRTT_r10, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lte_rrc_CarrierFreqCDMA2000 },
  { &hf_lte_rrc_nonCriticalExtension_13, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lte_rrc_T_nonCriticalExtension_05 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_HandoverFromEUTRAPreparationRequest_v1020_IEs(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_HandoverFromEUTRAPreparationRequest_v1020_IEs, HandoverFromEUTRAPreparationRequest_v1020_IEs_sequence);

  return offset;
}


static const per_sequence_t HandoverFromEUTRAPreparationRequest_v920_IEs_sequence[] = {
  { &hf_lte_rrc_concurrPrepCDMA2000_HRPD_r9, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lte_rrc_BOOLEAN },
  { &hf_lte_rrc_nonCriticalExtension_12, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lte_rrc_HandoverFromEUTRAPreparationRequest_v1020_IEs },
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_HandoverFromEUTRAPreparationRequest_v920_IEs(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_HandoverFromEUTRAPreparationRequest_v920_IEs, HandoverFromEUTRAPreparationRequest_v920_IEs_sequence);

  return offset;
}


static const per_sequence_t HandoverFromEUTRAPreparationRequest_v890_IEs_sequence[] = {
  { &hf_lte_rrc_lateNonCriticalExtension, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lte_rrc_OCTET_STRING },
  { &hf_lte_rrc_nonCriticalExtension_11, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lte_rrc_HandoverFromEUTRAPreparationRequest_v920_IEs },
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_HandoverFromEUTRAPreparationRequest_v890_IEs(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_HandoverFromEUTRAPreparationRequest_v890_IEs, HandoverFromEUTRAPreparationRequest_v890_IEs_sequence);

  return offset;
}


static const per_sequence_t HandoverFromEUTRAPreparationRequest_r8_IEs_sequence[] = {
  { &hf_lte_rrc_cdma2000_Type, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_CDMA2000_Type },
  { &hf_lte_rrc_rand        , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lte_rrc_RAND_CDMA2000 },
  { &hf_lte_rrc_mobilityParameters, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lte_rrc_MobilityParametersCDMA2000 },
  { &hf_lte_rrc_nonCriticalExtension_10, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lte_rrc_HandoverFromEUTRAPreparationRequest_v890_IEs },
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_HandoverFromEUTRAPreparationRequest_r8_IEs(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_HandoverFromEUTRAPreparationRequest_r8_IEs, HandoverFromEUTRAPreparationRequest_r8_IEs_sequence);

  return offset;
}


static const value_string lte_rrc_T_c1_09_vals[] = {
  {   0, "handoverFromEUTRAPreparationRequest-r8" },
  {   1, "spare3" },
  {   2, "spare2" },
  {   3, "spare1" },
  { 0, NULL }
};

static const per_choice_t T_c1_09_choice[] = {
  {   0, &hf_lte_rrc_handoverFromEUTRAPreparationRequest_r8, ASN1_NO_EXTENSIONS     , dissect_lte_rrc_HandoverFromEUTRAPreparationRequest_r8_IEs },
  {   1, &hf_lte_rrc_spare3      , ASN1_NO_EXTENSIONS     , dissect_lte_rrc_NULL },
  {   2, &hf_lte_rrc_spare2      , ASN1_NO_EXTENSIONS     , dissect_lte_rrc_NULL },
  {   3, &hf_lte_rrc_spare1      , ASN1_NO_EXTENSIONS     , dissect_lte_rrc_NULL },
  { 0, NULL, 0, NULL }
};

static int
dissect_lte_rrc_T_c1_09(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_lte_rrc_T_c1_09, T_c1_09_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t T_criticalExtensionsFuture_05_sequence[] = {
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_T_criticalExtensionsFuture_05(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_T_criticalExtensionsFuture_05, T_criticalExtensionsFuture_05_sequence);

  return offset;
}


static const value_string lte_rrc_T_criticalExtensions_05_vals[] = {
  {   0, "c1" },
  {   1, "criticalExtensionsFuture" },
  { 0, NULL }
};

static const per_choice_t T_criticalExtensions_05_choice[] = {
  {   0, &hf_lte_rrc_c1_09       , ASN1_NO_EXTENSIONS     , dissect_lte_rrc_T_c1_09 },
  {   1, &hf_lte_rrc_criticalExtensionsFuture_05, ASN1_NO_EXTENSIONS     , dissect_lte_rrc_T_criticalExtensionsFuture_05 },
  { 0, NULL, 0, NULL }
};

static int
dissect_lte_rrc_T_criticalExtensions_05(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_lte_rrc_T_criticalExtensions_05, T_criticalExtensions_05_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t HandoverFromEUTRAPreparationRequest_sequence[] = {
  { &hf_lte_rrc_rrc_TransactionIdentifier, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_RRC_TransactionIdentifier },
  { &hf_lte_rrc_criticalExtensions_05, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_T_criticalExtensions_05 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_HandoverFromEUTRAPreparationRequest(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {

col_append_str(actx->pinfo->cinfo, COL_INFO, "HandoverFromEUTRAPreparationRequest ");

  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_HandoverFromEUTRAPreparationRequest, HandoverFromEUTRAPreparationRequest_sequence);

  return offset;
}


static const value_string lte_rrc_T_targetRAT_Type_vals[] = {
  {   0, "utra" },
  {   1, "geran" },
  {   2, "cdma2000-1XRTT" },
  {   3, "cdma2000-HRPD" },
  {   4, "spare4" },
  {   5, "spare3" },
  {   6, "spare2" },
  {   7, "spare1" },
  { 0, NULL }
};


static int
dissect_lte_rrc_T_targetRAT_Type(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     8, &lte_rrc_ho_target_rat_type_value, TRUE, 0, NULL);



  return offset;
}



static int
dissect_lte_rrc_T_targetRAT_MessageContainer(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  tvbuff_t *target_rat_msg_cont_tvb = NULL;
  offset = dissect_per_octet_string(tvb, offset, actx, tree, hf_index,
                                       NO_BOUND, NO_BOUND, FALSE, &target_rat_msg_cont_tvb);

  if(target_rat_msg_cont_tvb){
    guint8 byte;
    switch(lte_rrc_ho_target_rat_type_value){
    case 0:
      /* utra */
      if (rrc_irat_ho_to_utran_cmd_handle)
        call_dissector(rrc_irat_ho_to_utran_cmd_handle, target_rat_msg_cont_tvb, actx->pinfo, tree);
      break;
    case 1:
      /* geran */
      byte = tvb_get_guint8(target_rat_msg_cont_tvb, 0);
      if (byte == 0x06) {
        if (gsm_a_dtap_handle) {
          call_dissector(gsm_a_dtap_handle, target_rat_msg_cont_tvb, actx->pinfo, tree);
        }
      } else {
        if (gsm_rlcmac_dl_handle) {
          call_dissector(gsm_rlcmac_dl_handle, target_rat_msg_cont_tvb, actx->pinfo, tree);
        }
      }
      break;
    case 2:
      /* cdma2000-1XRTT */
      break;
    case 3:
      /* cdma2000-HRPD */
      break;
    default:
      break;
    }
  }


  return offset;
}



static int
dissect_lte_rrc_T_nas_SecurityParamFromEUTRA(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  tvbuff_t *nas_sec_param_from_eutra_tvb = NULL;
  guint32 length;
  proto_item *item;
  proto_tree *subtree;

  offset = dissect_per_octet_string(tvb, offset, actx, tree, hf_index,
                                       1, 1, FALSE, &nas_sec_param_from_eutra_tvb);

  length = tvb_length(nas_sec_param_from_eutra_tvb);
  item = proto_tree_add_text(tree, nas_sec_param_from_eutra_tvb, 0, length, "NAS security parameters from E-UTRA");
  subtree = proto_item_add_subtree(item, ett_lte_rrc_nas_SecurityParam);
  de_emm_sec_par_from_eutra(nas_sec_param_from_eutra_tvb, subtree, actx->pinfo, 0, length, NULL, 0);


  return offset;
}



static int
dissect_lte_rrc_SystemInfoListGERAN_item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  tvbuff_t *sys_info_list_tvb = NULL;
  offset = dissect_per_octet_string(tvb, offset, actx, tree, hf_index,
                                       1, 23, FALSE, &sys_info_list_tvb);

  if (sys_info_list_tvb) {
    switch (lte_rrc_si_or_psi_geran_val) {
    case 0:
      /* SI message */
      if (gsm_a_dtap_handle) {
        call_dissector(gsm_a_dtap_handle, sys_info_list_tvb ,actx->pinfo, tree);
      }
      break;
    case 1:
      /* PSI message */
      if (gsm_rlcmac_dl_handle) {
        call_dissector(gsm_rlcmac_dl_handle, sys_info_list_tvb ,actx->pinfo, tree);
      }
      break;
    default:
      break;
    }
  }


  return offset;
}


static const per_sequence_t SystemInfoListGERAN_sequence_of[1] = {
  { &hf_lte_rrc_SystemInfoListGERAN_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_SystemInfoListGERAN_item },
};

static int
dissect_lte_rrc_SystemInfoListGERAN(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_lte_rrc_SystemInfoListGERAN, SystemInfoListGERAN_sequence_of,
                                                  1, maxGERAN_SI, FALSE);

  return offset;
}


static const value_string lte_rrc_SI_OrPSI_GERAN_vals[] = {
  {   0, "si" },
  {   1, "psi" },
  { 0, NULL }
};

static const per_choice_t SI_OrPSI_GERAN_choice[] = {
  {   0, &hf_lte_rrc_si          , ASN1_NO_EXTENSIONS     , dissect_lte_rrc_SystemInfoListGERAN },
  {   1, &hf_lte_rrc_psi         , ASN1_NO_EXTENSIONS     , dissect_lte_rrc_SystemInfoListGERAN },
  { 0, NULL, 0, NULL }
};

static int
dissect_lte_rrc_SI_OrPSI_GERAN(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_lte_rrc_SI_OrPSI_GERAN, SI_OrPSI_GERAN_choice,
                                 &lte_rrc_si_or_psi_geran_val);



  return offset;
}


static const per_sequence_t Handover_sequence[] = {
  { &hf_lte_rrc_targetRAT_Type, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_T_targetRAT_Type },
  { &hf_lte_rrc_targetRAT_MessageContainer, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_T_targetRAT_MessageContainer },
  { &hf_lte_rrc_nas_SecurityParamFromEUTRA, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lte_rrc_T_nas_SecurityParamFromEUTRA },
  { &hf_lte_rrc_systemInformation_01, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lte_rrc_SI_OrPSI_GERAN },
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_Handover(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  lte_rrc_ho_target_rat_type_value = -1;
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_Handover, Handover_sequence);



  return offset;
}


static const value_string lte_rrc_T_t304_vals[] = {
  {   0, "ms100" },
  {   1, "ms200" },
  {   2, "ms500" },
  {   3, "ms1000" },
  {   4, "ms2000" },
  {   5, "ms4000" },
  {   6, "ms8000" },
  {   7, "spare1" },
  { 0, NULL }
};


static int
dissect_lte_rrc_T_t304(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     8, NULL, FALSE, 0, NULL);

  return offset;
}


static const per_sequence_t PhysCellIdGERAN_sequence[] = {
  { &hf_lte_rrc_networkColourCode, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_BIT_STRING_SIZE_3 },
  { &hf_lte_rrc_baseStationColourCode, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_BIT_STRING_SIZE_3 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_PhysCellIdGERAN(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_PhysCellIdGERAN, PhysCellIdGERAN_sequence);

  return offset;
}


static const per_sequence_t CarrierFreqGERAN_sequence[] = {
  { &hf_lte_rrc_arfcn_01    , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_ARFCN_ValueGERAN },
  { &hf_lte_rrc_bandIndicator, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_BandIndicatorGERAN },
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_CarrierFreqGERAN(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_CarrierFreqGERAN, CarrierFreqGERAN_sequence);

  return offset;
}


static const per_sequence_t T_geran_sequence[] = {
  { &hf_lte_rrc_physCellId  , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_PhysCellIdGERAN },
  { &hf_lte_rrc_carrierFreq , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_CarrierFreqGERAN },
  { &hf_lte_rrc_networkControlOrder, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lte_rrc_BIT_STRING_SIZE_2 },
  { &hf_lte_rrc_systemInformation_01, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lte_rrc_SI_OrPSI_GERAN },
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_T_geran(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_T_geran, T_geran_sequence);

  return offset;
}


static const value_string lte_rrc_T_targetRAT_Type_01_vals[] = {
  {   0, "geran" },
  { 0, NULL }
};

static const per_choice_t T_targetRAT_Type_01_choice[] = {
  {   0, &hf_lte_rrc_geran       , ASN1_EXTENSION_ROOT    , dissect_lte_rrc_T_geran },
  { 0, NULL, 0, NULL }
};

static int
dissect_lte_rrc_T_targetRAT_Type_01(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_lte_rrc_T_targetRAT_Type_01, T_targetRAT_Type_01_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t CellChangeOrder_sequence[] = {
  { &hf_lte_rrc_t304        , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_T_t304 },
  { &hf_lte_rrc_targetRAT_Type_01, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_T_targetRAT_Type_01 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_CellChangeOrder(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_CellChangeOrder, CellChangeOrder_sequence);

  return offset;
}


static const value_string lte_rrc_T_purpose_vals[] = {
  {   0, "handover" },
  {   1, "cellChangeOrder" },
  { 0, NULL }
};

static const per_choice_t T_purpose_choice[] = {
  {   0, &hf_lte_rrc_handover    , ASN1_NO_EXTENSIONS     , dissect_lte_rrc_Handover },
  {   1, &hf_lte_rrc_cellChangeOrder, ASN1_NO_EXTENSIONS     , dissect_lte_rrc_CellChangeOrder },
  { 0, NULL, 0, NULL }
};

static int
dissect_lte_rrc_T_purpose(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_lte_rrc_T_purpose, T_purpose_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t T_nonCriticalExtension_12_sequence[] = {
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_T_nonCriticalExtension_12(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_T_nonCriticalExtension_12, T_nonCriticalExtension_12_sequence);

  return offset;
}


static const per_sequence_t MobilityFromEUTRACommand_v8d0_IEs_sequence[] = {
  { &hf_lte_rrc_bandIndicator, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lte_rrc_BandIndicatorGERAN },
  { &hf_lte_rrc_nonCriticalExtension_24, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lte_rrc_T_nonCriticalExtension_12 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_MobilityFromEUTRACommand_v8d0_IEs(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_MobilityFromEUTRACommand_v8d0_IEs, MobilityFromEUTRACommand_v8d0_IEs_sequence);

  return offset;
}


static const per_sequence_t MobilityFromEUTRACommand_v8a0_IEs_sequence[] = {
  { &hf_lte_rrc_lateNonCriticalExtension, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lte_rrc_OCTET_STRING },
  { &hf_lte_rrc_nonCriticalExtension_23, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lte_rrc_MobilityFromEUTRACommand_v8d0_IEs },
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_MobilityFromEUTRACommand_v8a0_IEs(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_MobilityFromEUTRACommand_v8a0_IEs, MobilityFromEUTRACommand_v8a0_IEs_sequence);

  return offset;
}


static const per_sequence_t MobilityFromEUTRACommand_r8_IEs_sequence[] = {
  { &hf_lte_rrc_cs_FallbackIndicator, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_BOOLEAN },
  { &hf_lte_rrc_purpose     , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_T_purpose },
  { &hf_lte_rrc_nonCriticalExtension_22, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lte_rrc_MobilityFromEUTRACommand_v8a0_IEs },
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_MobilityFromEUTRACommand_r8_IEs(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_MobilityFromEUTRACommand_r8_IEs, MobilityFromEUTRACommand_r8_IEs_sequence);

  return offset;
}


static const value_string lte_rrc_T_mobilityCDMA2000_HRPD_r9_vals[] = {
  {   0, "handover" },
  {   1, "redirection" },
  { 0, NULL }
};


static int
dissect_lte_rrc_T_mobilityCDMA2000_HRPD_r9(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, FALSE, 0, NULL);

  return offset;
}


static const per_sequence_t E_CSFB_r9_sequence[] = {
  { &hf_lte_rrc_messageContCDMA2000_1XRTT_r9, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lte_rrc_OCTET_STRING },
  { &hf_lte_rrc_mobilityCDMA2000_HRPD_r9, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lte_rrc_T_mobilityCDMA2000_HRPD_r9 },
  { &hf_lte_rrc_messageContCDMA2000_HRPD_r9, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lte_rrc_OCTET_STRING },
  { &hf_lte_rrc_redirectCarrierCDMA2000_HRPD_r9, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lte_rrc_CarrierFreqCDMA2000 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_E_CSFB_r9(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_E_CSFB_r9, E_CSFB_r9_sequence);

  return offset;
}


static const value_string lte_rrc_T_purpose_01_vals[] = {
  {   0, "handover" },
  {   1, "cellChangeOrder" },
  {   2, "e-CSFB-r9" },
  { 0, NULL }
};

static const per_choice_t T_purpose_01_choice[] = {
  {   0, &hf_lte_rrc_handover    , ASN1_EXTENSION_ROOT    , dissect_lte_rrc_Handover },
  {   1, &hf_lte_rrc_cellChangeOrder, ASN1_EXTENSION_ROOT    , dissect_lte_rrc_CellChangeOrder },
  {   2, &hf_lte_rrc_e_CSFB_r9   , ASN1_EXTENSION_ROOT    , dissect_lte_rrc_E_CSFB_r9 },
  { 0, NULL, 0, NULL }
};

static int
dissect_lte_rrc_T_purpose_01(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_lte_rrc_T_purpose_01, T_purpose_01_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t T_nonCriticalExtension_13_sequence[] = {
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_T_nonCriticalExtension_13(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_T_nonCriticalExtension_13, T_nonCriticalExtension_13_sequence);

  return offset;
}


static const per_sequence_t MobilityFromEUTRACommand_v960_IEs_sequence[] = {
  { &hf_lte_rrc_bandIndicator, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lte_rrc_BandIndicatorGERAN },
  { &hf_lte_rrc_nonCriticalExtension_27, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lte_rrc_T_nonCriticalExtension_13 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_MobilityFromEUTRACommand_v960_IEs(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_MobilityFromEUTRACommand_v960_IEs, MobilityFromEUTRACommand_v960_IEs_sequence);

  return offset;
}


static const per_sequence_t MobilityFromEUTRACommand_v930_IEs_sequence[] = {
  { &hf_lte_rrc_lateNonCriticalExtension, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lte_rrc_OCTET_STRING },
  { &hf_lte_rrc_nonCriticalExtension_26, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lte_rrc_MobilityFromEUTRACommand_v960_IEs },
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_MobilityFromEUTRACommand_v930_IEs(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_MobilityFromEUTRACommand_v930_IEs, MobilityFromEUTRACommand_v930_IEs_sequence);

  return offset;
}


static const per_sequence_t MobilityFromEUTRACommand_r9_IEs_sequence[] = {
  { &hf_lte_rrc_cs_FallbackIndicator, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_BOOLEAN },
  { &hf_lte_rrc_purpose_01  , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_T_purpose_01 },
  { &hf_lte_rrc_nonCriticalExtension_25, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lte_rrc_MobilityFromEUTRACommand_v930_IEs },
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_MobilityFromEUTRACommand_r9_IEs(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_MobilityFromEUTRACommand_r9_IEs, MobilityFromEUTRACommand_r9_IEs_sequence);

  return offset;
}


static const value_string lte_rrc_T_c1_14_vals[] = {
  {   0, "mobilityFromEUTRACommand-r8" },
  {   1, "mobilityFromEUTRACommand-r9" },
  {   2, "spare2" },
  {   3, "spare1" },
  { 0, NULL }
};

static const per_choice_t T_c1_14_choice[] = {
  {   0, &hf_lte_rrc_mobilityFromEUTRACommand_r8, ASN1_NO_EXTENSIONS     , dissect_lte_rrc_MobilityFromEUTRACommand_r8_IEs },
  {   1, &hf_lte_rrc_mobilityFromEUTRACommand_r9, ASN1_NO_EXTENSIONS     , dissect_lte_rrc_MobilityFromEUTRACommand_r9_IEs },
  {   2, &hf_lte_rrc_spare2      , ASN1_NO_EXTENSIONS     , dissect_lte_rrc_NULL },
  {   3, &hf_lte_rrc_spare1      , ASN1_NO_EXTENSIONS     , dissect_lte_rrc_NULL },
  { 0, NULL, 0, NULL }
};

static int
dissect_lte_rrc_T_c1_14(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_lte_rrc_T_c1_14, T_c1_14_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t T_criticalExtensionsFuture_10_sequence[] = {
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_T_criticalExtensionsFuture_10(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_T_criticalExtensionsFuture_10, T_criticalExtensionsFuture_10_sequence);

  return offset;
}


static const value_string lte_rrc_T_criticalExtensions_10_vals[] = {
  {   0, "c1" },
  {   1, "criticalExtensionsFuture" },
  { 0, NULL }
};

static const per_choice_t T_criticalExtensions_10_choice[] = {
  {   0, &hf_lte_rrc_c1_14       , ASN1_NO_EXTENSIONS     , dissect_lte_rrc_T_c1_14 },
  {   1, &hf_lte_rrc_criticalExtensionsFuture_10, ASN1_NO_EXTENSIONS     , dissect_lte_rrc_T_criticalExtensionsFuture_10 },
  { 0, NULL, 0, NULL }
};

static int
dissect_lte_rrc_T_criticalExtensions_10(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_lte_rrc_T_criticalExtensions_10, T_criticalExtensions_10_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t MobilityFromEUTRACommand_sequence[] = {
  { &hf_lte_rrc_rrc_TransactionIdentifier, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_RRC_TransactionIdentifier },
  { &hf_lte_rrc_criticalExtensions_10, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_T_criticalExtensions_10 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_MobilityFromEUTRACommand(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {

col_append_str(actx->pinfo->cinfo, COL_INFO, "MobilityFromEUTRACommand ");

  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_MobilityFromEUTRACommand, MobilityFromEUTRACommand_sequence);

  return offset;
}



static int
dissect_lte_rrc_MeasObjectId(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            1U, maxObjectId, NULL, FALSE);

  return offset;
}


static const per_sequence_t MeasObjectToRemoveList_sequence_of[1] = {
  { &hf_lte_rrc_MeasObjectToRemoveList_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_MeasObjectId },
};

static int
dissect_lte_rrc_MeasObjectToRemoveList(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_lte_rrc_MeasObjectToRemoveList, MeasObjectToRemoveList_sequence_of,
                                                  1, maxObjectId, FALSE);

  return offset;
}



static int
dissect_lte_rrc_CellIndex(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            1U, maxCellMeas, NULL, FALSE);

  return offset;
}


static const per_sequence_t CellIndexList_sequence_of[1] = {
  { &hf_lte_rrc_CellIndexList_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_CellIndex },
};

static int
dissect_lte_rrc_CellIndexList(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_lte_rrc_CellIndexList, CellIndexList_sequence_of,
                                                  1, maxCellMeas, FALSE);

  return offset;
}



static int
dissect_lte_rrc_INTEGER_1_maxCellMeas(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            1U, maxCellMeas, NULL, FALSE);

  return offset;
}


static const per_sequence_t CellsToAddMod_sequence[] = {
  { &hf_lte_rrc_cellIndex   , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_INTEGER_1_maxCellMeas },
  { &hf_lte_rrc_physCellId_01, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_PhysCellId },
  { &hf_lte_rrc_cellIndividualOffset, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_Q_OffsetRange },
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_CellsToAddMod(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_CellsToAddMod, CellsToAddMod_sequence);

  return offset;
}


static const per_sequence_t CellsToAddModList_sequence_of[1] = {
  { &hf_lte_rrc_CellsToAddModList_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_CellsToAddMod },
};

static int
dissect_lte_rrc_CellsToAddModList(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_lte_rrc_CellsToAddModList, CellsToAddModList_sequence_of,
                                                  1, maxCellMeas, FALSE);

  return offset;
}


static const per_sequence_t BlackCellsToAddMod_sequence[] = {
  { &hf_lte_rrc_cellIndex   , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_INTEGER_1_maxCellMeas },
  { &hf_lte_rrc_physCellIdRange, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_PhysCellIdRange },
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_BlackCellsToAddMod(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_BlackCellsToAddMod, BlackCellsToAddMod_sequence);

  return offset;
}


static const per_sequence_t BlackCellsToAddModList_sequence_of[1] = {
  { &hf_lte_rrc_BlackCellsToAddModList_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_BlackCellsToAddMod },
};

static int
dissect_lte_rrc_BlackCellsToAddModList(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_lte_rrc_BlackCellsToAddModList, BlackCellsToAddModList_sequence_of,
                                                  1, maxCellMeas, FALSE);

  return offset;
}


static const value_string lte_rrc_MeasCycleSCell_r10_vals[] = {
  {   0, "sf160" },
  {   1, "sf256" },
  {   2, "sf320" },
  {   3, "sf512" },
  {   4, "sf640" },
  {   5, "sf1024" },
  {   6, "sf1280" },
  {   7, "spare1" },
  { 0, NULL }
};


static int
dissect_lte_rrc_MeasCycleSCell_r10(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     8, NULL, FALSE, 0, NULL);

  return offset;
}


static const per_sequence_t MeasSubframeCellList_r10_sequence_of[1] = {
  { &hf_lte_rrc_MeasSubframeCellList_r10_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_PhysCellIdRange },
};

static int
dissect_lte_rrc_MeasSubframeCellList_r10(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_lte_rrc_MeasSubframeCellList_r10, MeasSubframeCellList_r10_sequence_of,
                                                  1, maxCellMeas, FALSE);

  return offset;
}


static const per_sequence_t T_setup_27_sequence[] = {
  { &hf_lte_rrc_measSubframePatternNeigh_r10, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_MeasSubframePattern_r10 },
  { &hf_lte_rrc_measSubframeCellList_r10, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lte_rrc_MeasSubframeCellList_r10 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_T_setup_27(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_T_setup_27, T_setup_27_sequence);

  return offset;
}


static const value_string lte_rrc_MeasSubframePatternConfigNeigh_r10_vals[] = {
  {   0, "release" },
  {   1, "setup" },
  { 0, NULL }
};

static const per_choice_t MeasSubframePatternConfigNeigh_r10_choice[] = {
  {   0, &hf_lte_rrc_release     , ASN1_NO_EXTENSIONS     , dissect_lte_rrc_NULL },
  {   1, &hf_lte_rrc_setup_28    , ASN1_NO_EXTENSIONS     , dissect_lte_rrc_T_setup_27 },
  { 0, NULL, 0, NULL }
};

static int
dissect_lte_rrc_MeasSubframePatternConfigNeigh_r10(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_lte_rrc_MeasSubframePatternConfigNeigh_r10, MeasSubframePatternConfigNeigh_r10_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t MeasObjectEUTRA_eag_1_sequence[] = {
  { &hf_lte_rrc_measCycleSCell_r10, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lte_rrc_MeasCycleSCell_r10 },
  { &hf_lte_rrc_measSubframePatternConfigNeigh_r10, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lte_rrc_MeasSubframePatternConfigNeigh_r10 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_MeasObjectEUTRA_eag_1(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence_eag(tvb, offset, actx, tree, MeasObjectEUTRA_eag_1_sequence);

  return offset;
}


static const per_sequence_t MeasObjectEUTRA_sequence[] = {
  { &hf_lte_rrc_carrierFreq_01, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lte_rrc_ARFCN_ValueEUTRA },
  { &hf_lte_rrc_allowedMeasBandwidth, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lte_rrc_AllowedMeasBandwidth },
  { &hf_lte_rrc_presenceAntennaPort1, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lte_rrc_PresenceAntennaPort1 },
  { &hf_lte_rrc_neighCellConfig, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lte_rrc_NeighCellConfig },
  { &hf_lte_rrc_offsetFreq_01, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lte_rrc_Q_OffsetRange },
  { &hf_lte_rrc_cellsToRemoveList, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lte_rrc_CellIndexList },
  { &hf_lte_rrc_cellsToAddModList_01, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lte_rrc_CellsToAddModList },
  { &hf_lte_rrc_blackCellsToRemoveList, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lte_rrc_CellIndexList },
  { &hf_lte_rrc_blackCellsToAddModList, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lte_rrc_BlackCellsToAddModList },
  { &hf_lte_rrc_cellForWhichToReportCGI_01, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lte_rrc_PhysCellId },
  { &hf_lte_rrc_dummy_eag_field, ASN1_NOT_EXTENSION_ROOT, ASN1_NOT_OPTIONAL, dissect_lte_rrc_MeasObjectEUTRA_eag_1 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_MeasObjectEUTRA(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_MeasObjectEUTRA, MeasObjectEUTRA_sequence);

  return offset;
}



static int
dissect_lte_rrc_Q_OffsetRangeInterRAT(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            -15, 15U, NULL, FALSE);

  proto_item_append_text(actx->created_item, "dB");


  return offset;
}



static int
dissect_lte_rrc_PhysCellIdUTRA_FDD(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 511U, NULL, FALSE);

  return offset;
}


static const per_sequence_t CellsToAddModUTRA_FDD_sequence[] = {
  { &hf_lte_rrc_cellIndex   , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_INTEGER_1_maxCellMeas },
  { &hf_lte_rrc_physCellId_03, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_PhysCellIdUTRA_FDD },
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_CellsToAddModUTRA_FDD(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_CellsToAddModUTRA_FDD, CellsToAddModUTRA_FDD_sequence);

  return offset;
}


static const per_sequence_t CellsToAddModListUTRA_FDD_sequence_of[1] = {
  { &hf_lte_rrc_CellsToAddModListUTRA_FDD_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_CellsToAddModUTRA_FDD },
};

static int
dissect_lte_rrc_CellsToAddModListUTRA_FDD(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_lte_rrc_CellsToAddModListUTRA_FDD, CellsToAddModListUTRA_FDD_sequence_of,
                                                  1, maxCellMeas, FALSE);

  return offset;
}



static int
dissect_lte_rrc_PhysCellIdUTRA_TDD(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 127U, NULL, FALSE);

  return offset;
}


static const per_sequence_t CellsToAddModUTRA_TDD_sequence[] = {
  { &hf_lte_rrc_cellIndex   , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_INTEGER_1_maxCellMeas },
  { &hf_lte_rrc_physCellId_04, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_PhysCellIdUTRA_TDD },
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_CellsToAddModUTRA_TDD(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_CellsToAddModUTRA_TDD, CellsToAddModUTRA_TDD_sequence);

  return offset;
}


static const per_sequence_t CellsToAddModListUTRA_TDD_sequence_of[1] = {
  { &hf_lte_rrc_CellsToAddModListUTRA_TDD_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_CellsToAddModUTRA_TDD },
};

static int
dissect_lte_rrc_CellsToAddModListUTRA_TDD(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_lte_rrc_CellsToAddModListUTRA_TDD, CellsToAddModListUTRA_TDD_sequence_of,
                                                  1, maxCellMeas, FALSE);

  return offset;
}


static const value_string lte_rrc_T_cellsToAddModList_vals[] = {
  {   0, "cellsToAddModListUTRA-FDD" },
  {   1, "cellsToAddModListUTRA-TDD" },
  { 0, NULL }
};

static const per_choice_t T_cellsToAddModList_choice[] = {
  {   0, &hf_lte_rrc_cellsToAddModListUTRA_FDD, ASN1_NO_EXTENSIONS     , dissect_lte_rrc_CellsToAddModListUTRA_FDD },
  {   1, &hf_lte_rrc_cellsToAddModListUTRA_TDD, ASN1_NO_EXTENSIONS     , dissect_lte_rrc_CellsToAddModListUTRA_TDD },
  { 0, NULL, 0, NULL }
};

static int
dissect_lte_rrc_T_cellsToAddModList(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_lte_rrc_T_cellsToAddModList, T_cellsToAddModList_choice,
                                 NULL);

  return offset;
}


static const value_string lte_rrc_T_cellForWhichToReportCGI_vals[] = {
  {   0, "utra-FDD" },
  {   1, "utra-TDD" },
  { 0, NULL }
};

static const per_choice_t T_cellForWhichToReportCGI_choice[] = {
  {   0, &hf_lte_rrc_utra_FDD_01 , ASN1_NO_EXTENSIONS     , dissect_lte_rrc_PhysCellIdUTRA_FDD },
  {   1, &hf_lte_rrc_utra_TDD_01 , ASN1_NO_EXTENSIONS     , dissect_lte_rrc_PhysCellIdUTRA_TDD },
  { 0, NULL, 0, NULL }
};

static int
dissect_lte_rrc_T_cellForWhichToReportCGI(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_lte_rrc_T_cellForWhichToReportCGI, T_cellForWhichToReportCGI_choice,
                                 NULL);

  return offset;
}



static int
dissect_lte_rrc_INTEGER_2_512(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            2U, 512U, NULL, FALSE);

  return offset;
}


static const per_sequence_t PhysCellIdRangeUTRA_FDD_r9_sequence[] = {
  { &hf_lte_rrc_start_r9    , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_PhysCellIdUTRA_FDD },
  { &hf_lte_rrc_range_r9    , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lte_rrc_INTEGER_2_512 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_PhysCellIdRangeUTRA_FDD_r9(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_PhysCellIdRangeUTRA_FDD_r9, PhysCellIdRangeUTRA_FDD_r9_sequence);

  return offset;
}


static const per_sequence_t PhysCellIdRangeUTRA_FDDList_r9_sequence_of[1] = {
  { &hf_lte_rrc_PhysCellIdRangeUTRA_FDDList_r9_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_PhysCellIdRangeUTRA_FDD_r9 },
};

static int
dissect_lte_rrc_PhysCellIdRangeUTRA_FDDList_r9(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_lte_rrc_PhysCellIdRangeUTRA_FDDList_r9, PhysCellIdRangeUTRA_FDDList_r9_sequence_of,
                                                  1, maxPhysCellIdRange_r9, FALSE);

  return offset;
}


static const per_sequence_t CSG_AllowedReportingCells_r9_sequence[] = {
  { &hf_lte_rrc_physCellIdRangeUTRA_FDDList_r9, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lte_rrc_PhysCellIdRangeUTRA_FDDList_r9 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_CSG_AllowedReportingCells_r9(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_CSG_AllowedReportingCells_r9, CSG_AllowedReportingCells_r9_sequence);

  return offset;
}


static const per_sequence_t MeasObjectUTRA_eag_1_sequence[] = {
  { &hf_lte_rrc_csg_allowedReportingCells_v930, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lte_rrc_CSG_AllowedReportingCells_r9 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_MeasObjectUTRA_eag_1(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence_eag(tvb, offset, actx, tree, MeasObjectUTRA_eag_1_sequence);

  return offset;
}


static const per_sequence_t MeasObjectUTRA_sequence[] = {
  { &hf_lte_rrc_carrierFreq_02, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lte_rrc_ARFCN_ValueUTRA },
  { &hf_lte_rrc_offsetFreq  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lte_rrc_Q_OffsetRangeInterRAT },
  { &hf_lte_rrc_cellsToRemoveList, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lte_rrc_CellIndexList },
  { &hf_lte_rrc_cellsToAddModList_02, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lte_rrc_T_cellsToAddModList },
  { &hf_lte_rrc_cellForWhichToReportCGI_03, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lte_rrc_T_cellForWhichToReportCGI },
  { &hf_lte_rrc_dummy_eag_field, ASN1_NOT_EXTENSION_ROOT, ASN1_NOT_OPTIONAL, dissect_lte_rrc_MeasObjectUTRA_eag_1 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_MeasObjectUTRA(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_MeasObjectUTRA, MeasObjectUTRA_sequence);

  return offset;
}


static const per_sequence_t MeasObjectGERAN_sequence[] = {
  { &hf_lte_rrc_carrierFreqs, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lte_rrc_CarrierFreqsGERAN },
  { &hf_lte_rrc_offsetFreq  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lte_rrc_Q_OffsetRangeInterRAT },
  { &hf_lte_rrc_ncc_Permitted, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lte_rrc_BIT_STRING_SIZE_8 },
  { &hf_lte_rrc_cellForWhichToReportCGI_02, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lte_rrc_PhysCellIdGERAN },
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_MeasObjectGERAN(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_MeasObjectGERAN, MeasObjectGERAN_sequence);

  return offset;
}


static const per_sequence_t CellsToAddModCDMA2000_sequence[] = {
  { &hf_lte_rrc_cellIndex   , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_INTEGER_1_maxCellMeas },
  { &hf_lte_rrc_physCellId_02, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_PhysCellIdCDMA2000 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_CellsToAddModCDMA2000(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_CellsToAddModCDMA2000, CellsToAddModCDMA2000_sequence);

  return offset;
}


static const per_sequence_t CellsToAddModListCDMA2000_sequence_of[1] = {
  { &hf_lte_rrc_CellsToAddModListCDMA2000_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_CellsToAddModCDMA2000 },
};

static int
dissect_lte_rrc_CellsToAddModListCDMA2000(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_lte_rrc_CellsToAddModListCDMA2000, CellsToAddModListCDMA2000_sequence_of,
                                                  1, maxCellMeas, FALSE);

  return offset;
}


static const per_sequence_t MeasObjectCDMA2000_sequence[] = {
  { &hf_lte_rrc_cdma2000_Type, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lte_rrc_CDMA2000_Type },
  { &hf_lte_rrc_carrierFreq_04, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lte_rrc_CarrierFreqCDMA2000 },
  { &hf_lte_rrc_searchWindowSize, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lte_rrc_INTEGER_0_15 },
  { &hf_lte_rrc_offsetFreq  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lte_rrc_Q_OffsetRangeInterRAT },
  { &hf_lte_rrc_cellsToRemoveList, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lte_rrc_CellIndexList },
  { &hf_lte_rrc_cellsToAddModList, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lte_rrc_CellsToAddModListCDMA2000 },
  { &hf_lte_rrc_cellForWhichToReportCGI, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lte_rrc_PhysCellIdCDMA2000 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_MeasObjectCDMA2000(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_MeasObjectCDMA2000, MeasObjectCDMA2000_sequence);

  return offset;
}


static const value_string lte_rrc_T_measObject_vals[] = {
  {   0, "measObjectEUTRA" },
  {   1, "measObjectUTRA" },
  {   2, "measObjectGERAN" },
  {   3, "measObjectCDMA2000" },
  { 0, NULL }
};

static const per_choice_t T_measObject_choice[] = {
  {   0, &hf_lte_rrc_measObjectEUTRA, ASN1_EXTENSION_ROOT    , dissect_lte_rrc_MeasObjectEUTRA },
  {   1, &hf_lte_rrc_measObjectUTRA, ASN1_EXTENSION_ROOT    , dissect_lte_rrc_MeasObjectUTRA },
  {   2, &hf_lte_rrc_measObjectGERAN, ASN1_EXTENSION_ROOT    , dissect_lte_rrc_MeasObjectGERAN },
  {   3, &hf_lte_rrc_measObjectCDMA2000, ASN1_EXTENSION_ROOT    , dissect_lte_rrc_MeasObjectCDMA2000 },
  { 0, NULL, 0, NULL }
};

static int
dissect_lte_rrc_T_measObject(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_lte_rrc_T_measObject, T_measObject_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t MeasObjectToAddMod_sequence[] = {
  { &hf_lte_rrc_measObjectId, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_MeasObjectId },
  { &hf_lte_rrc_measObject  , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_T_measObject },
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_MeasObjectToAddMod(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_MeasObjectToAddMod, MeasObjectToAddMod_sequence);

  return offset;
}


static const per_sequence_t MeasObjectToAddModList_sequence_of[1] = {
  { &hf_lte_rrc_MeasObjectToAddModList_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_MeasObjectToAddMod },
};

static int
dissect_lte_rrc_MeasObjectToAddModList(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_lte_rrc_MeasObjectToAddModList, MeasObjectToAddModList_sequence_of,
                                                  1, maxObjectId, FALSE);

  return offset;
}



static int
dissect_lte_rrc_ReportConfigId(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            1U, maxReportConfigId, NULL, FALSE);

  return offset;
}


static const per_sequence_t ReportConfigToRemoveList_sequence_of[1] = {
  { &hf_lte_rrc_ReportConfigToRemoveList_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_ReportConfigId },
};

static int
dissect_lte_rrc_ReportConfigToRemoveList(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_lte_rrc_ReportConfigToRemoveList, ReportConfigToRemoveList_sequence_of,
                                                  1, maxReportConfigId, FALSE);

  return offset;
}



static int
dissect_lte_rrc_RSRP_Range(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 97U, NULL, FALSE);

  return offset;
}



static int
dissect_lte_rrc_Threshold_RSRP_Range(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_lte_rrc_RSRP_Range(tvb, offset, actx, tree, hf_index);

  return offset;
}



static int
dissect_lte_rrc_RSRQ_Range(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 34U, NULL, FALSE);

  return offset;
}



static int
dissect_lte_rrc_Threshold_RSRQ_Range(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_lte_rrc_RSRQ_Range(tvb, offset, actx, tree, hf_index);

  return offset;
}


static const value_string lte_rrc_ThresholdEUTRA_vals[] = {
  {   0, "threshold-RSRP" },
  {   1, "threshold-RSRQ" },
  { 0, NULL }
};

static const per_choice_t ThresholdEUTRA_choice[] = {
  {   0, &hf_lte_rrc_threshold_RSRP, ASN1_NO_EXTENSIONS     , dissect_lte_rrc_Threshold_RSRP_Range },
  {   1, &hf_lte_rrc_threshold_RSRQ, ASN1_NO_EXTENSIONS     , dissect_lte_rrc_Threshold_RSRQ_Range },
  { 0, NULL, 0, NULL }
};

static int
dissect_lte_rrc_ThresholdEUTRA(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_lte_rrc_ThresholdEUTRA, ThresholdEUTRA_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t T_eventA1_sequence[] = {
  { &hf_lte_rrc_a1_Threshold, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_ThresholdEUTRA },
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_T_eventA1(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_T_eventA1, T_eventA1_sequence);

  return offset;
}


static const per_sequence_t T_eventA2_sequence[] = {
  { &hf_lte_rrc_a2_Threshold, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_ThresholdEUTRA },
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_T_eventA2(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_T_eventA2, T_eventA2_sequence);

  return offset;
}



static int
dissect_lte_rrc_INTEGER_M30_30(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            -30, 30U, NULL, FALSE);

  return offset;
}


static const per_sequence_t T_eventA3_sequence[] = {
  { &hf_lte_rrc_a3_Offset   , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_INTEGER_M30_30 },
  { &hf_lte_rrc_reportOnLeave, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_BOOLEAN },
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_T_eventA3(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_T_eventA3, T_eventA3_sequence);

  return offset;
}


static const per_sequence_t T_eventA4_sequence[] = {
  { &hf_lte_rrc_a4_Threshold, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_ThresholdEUTRA },
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_T_eventA4(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_T_eventA4, T_eventA4_sequence);

  return offset;
}


static const per_sequence_t T_eventA5_sequence[] = {
  { &hf_lte_rrc_a5_Threshold1, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_ThresholdEUTRA },
  { &hf_lte_rrc_a5_Threshold2, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_ThresholdEUTRA },
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_T_eventA5(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_T_eventA5, T_eventA5_sequence);

  return offset;
}


static const per_sequence_t T_eventA6_r10_sequence[] = {
  { &hf_lte_rrc_a6_Offset_r10, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_INTEGER_M30_30 },
  { &hf_lte_rrc_a6_ReportOnLeave_r10, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_BOOLEAN },
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_T_eventA6_r10(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_T_eventA6_r10, T_eventA6_r10_sequence);

  return offset;
}


static const value_string lte_rrc_T_eventId_vals[] = {
  {   0, "eventA1" },
  {   1, "eventA2" },
  {   2, "eventA3" },
  {   3, "eventA4" },
  {   4, "eventA5" },
  {   5, "eventA6-r10" },
  { 0, NULL }
};

static const per_choice_t T_eventId_choice[] = {
  {   0, &hf_lte_rrc_eventA1     , ASN1_EXTENSION_ROOT    , dissect_lte_rrc_T_eventA1 },
  {   1, &hf_lte_rrc_eventA2     , ASN1_EXTENSION_ROOT    , dissect_lte_rrc_T_eventA2 },
  {   2, &hf_lte_rrc_eventA3     , ASN1_EXTENSION_ROOT    , dissect_lte_rrc_T_eventA3 },
  {   3, &hf_lte_rrc_eventA4     , ASN1_EXTENSION_ROOT    , dissect_lte_rrc_T_eventA4 },
  {   4, &hf_lte_rrc_eventA5     , ASN1_EXTENSION_ROOT    , dissect_lte_rrc_T_eventA5 },
  {   5, &hf_lte_rrc_eventA6_r10 , ASN1_NOT_EXTENSION_ROOT, dissect_lte_rrc_T_eventA6_r10 },
  { 0, NULL, 0, NULL }
};

static int
dissect_lte_rrc_T_eventId(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_lte_rrc_T_eventId, T_eventId_choice,
                                 NULL);

  return offset;
}



static int
dissect_lte_rrc_Hysteresis(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 30U, NULL, FALSE);

  return offset;
}


static const value_string lte_rrc_TimeToTrigger_vals[] = {
  {   0, "ms0" },
  {   1, "ms40" },
  {   2, "ms64" },
  {   3, "ms80" },
  {   4, "ms100" },
  {   5, "ms128" },
  {   6, "ms160" },
  {   7, "ms256" },
  {   8, "ms320" },
  {   9, "ms480" },
  {  10, "ms512" },
  {  11, "ms640" },
  {  12, "ms1024" },
  {  13, "ms1280" },
  {  14, "ms2560" },
  {  15, "ms5120" },
  { 0, NULL }
};


static int
dissect_lte_rrc_TimeToTrigger(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     16, NULL, FALSE, 0, NULL);

  return offset;
}


static const per_sequence_t T_event_sequence[] = {
  { &hf_lte_rrc_eventId     , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_T_eventId },
  { &hf_lte_rrc_hysteresis  , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_Hysteresis },
  { &hf_lte_rrc_timeToTrigger, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_TimeToTrigger },
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_T_event(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_T_event, T_event_sequence);

  return offset;
}


static const value_string lte_rrc_T_purpose_02_vals[] = {
  {   0, "reportStrongestCells" },
  {   1, "reportCGI" },
  { 0, NULL }
};


static int
dissect_lte_rrc_T_purpose_02(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, FALSE, 0, NULL);

  return offset;
}


static const per_sequence_t T_periodical_sequence[] = {
  { &hf_lte_rrc_purpose_02  , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_T_purpose_02 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_T_periodical(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_T_periodical, T_periodical_sequence);

  return offset;
}


static const value_string lte_rrc_T_triggerType_vals[] = {
  {   0, "event" },
  {   1, "periodical" },
  { 0, NULL }
};

static const per_choice_t T_triggerType_choice[] = {
  {   0, &hf_lte_rrc_event       , ASN1_NO_EXTENSIONS     , dissect_lte_rrc_T_event },
  {   1, &hf_lte_rrc_periodical  , ASN1_NO_EXTENSIONS     , dissect_lte_rrc_T_periodical },
  { 0, NULL, 0, NULL }
};

static int
dissect_lte_rrc_T_triggerType(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_lte_rrc_T_triggerType, T_triggerType_choice,
                                 NULL);

  return offset;
}


static const value_string lte_rrc_T_triggerQuantity_vals[] = {
  {   0, "rsrp" },
  {   1, "rsrq" },
  { 0, NULL }
};


static int
dissect_lte_rrc_T_triggerQuantity(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, FALSE, 0, NULL);

  return offset;
}


static const value_string lte_rrc_T_reportQuantity_vals[] = {
  {   0, "sameAsTriggerQuantity" },
  {   1, "both" },
  { 0, NULL }
};


static int
dissect_lte_rrc_T_reportQuantity(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, FALSE, 0, NULL);

  return offset;
}



static int
dissect_lte_rrc_INTEGER_1_maxCellReport(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            1U, maxCellReport, NULL, FALSE);

  return offset;
}


static const value_string lte_rrc_ReportInterval_vals[] = {
  {   0, "ms120" },
  {   1, "ms240" },
  {   2, "ms480" },
  {   3, "ms640" },
  {   4, "ms1024" },
  {   5, "ms2048" },
  {   6, "ms5120" },
  {   7, "ms10240" },
  {   8, "min1" },
  {   9, "min6" },
  {  10, "min12" },
  {  11, "min30" },
  {  12, "min60" },
  {  13, "spare3" },
  {  14, "spare2" },
  {  15, "spare1" },
  { 0, NULL }
};


static int
dissect_lte_rrc_ReportInterval(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     16, NULL, FALSE, 0, NULL);

  return offset;
}


static const value_string lte_rrc_T_reportAmount_vals[] = {
  {   0, "r1" },
  {   1, "r2" },
  {   2, "r4" },
  {   3, "r8" },
  {   4, "r16" },
  {   5, "r32" },
  {   6, "r64" },
  {   7, "infinity" },
  { 0, NULL }
};


static int
dissect_lte_rrc_T_reportAmount(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     8, NULL, FALSE, 0, NULL);

  return offset;
}


static const value_string lte_rrc_T_si_RequestForHO_r9_vals[] = {
  {   0, "setup" },
  { 0, NULL }
};


static int
dissect_lte_rrc_T_si_RequestForHO_r9(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, FALSE, 0, NULL);

  return offset;
}


static const value_string lte_rrc_T_ue_RxTxTimeDiffPeriodical_r9_vals[] = {
  {   0, "setup" },
  { 0, NULL }
};


static int
dissect_lte_rrc_T_ue_RxTxTimeDiffPeriodical_r9(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, FALSE, 0, NULL);

  return offset;
}


static const per_sequence_t ReportConfigEUTRA_eag_1_sequence[] = {
  { &hf_lte_rrc_si_RequestForHO_r9, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lte_rrc_T_si_RequestForHO_r9 },
  { &hf_lte_rrc_ue_RxTxTimeDiffPeriodical_r9, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lte_rrc_T_ue_RxTxTimeDiffPeriodical_r9 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_ReportConfigEUTRA_eag_1(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence_eag(tvb, offset, actx, tree, ReportConfigEUTRA_eag_1_sequence);

  return offset;
}


static const value_string lte_rrc_T_includeLocationInfo_r10_vals[] = {
  {   0, "true" },
  { 0, NULL }
};


static int
dissect_lte_rrc_T_includeLocationInfo_r10(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, FALSE, 0, NULL);

  return offset;
}


static const value_string lte_rrc_T_reportAddNeighMeas_r10_vals[] = {
  {   0, "setup" },
  { 0, NULL }
};


static int
dissect_lte_rrc_T_reportAddNeighMeas_r10(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, FALSE, 0, NULL);

  return offset;
}


static const per_sequence_t ReportConfigEUTRA_eag_2_sequence[] = {
  { &hf_lte_rrc_includeLocationInfo_r10, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lte_rrc_T_includeLocationInfo_r10 },
  { &hf_lte_rrc_reportAddNeighMeas_r10, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lte_rrc_T_reportAddNeighMeas_r10 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_ReportConfigEUTRA_eag_2(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence_eag(tvb, offset, actx, tree, ReportConfigEUTRA_eag_2_sequence);

  return offset;
}


static const per_sequence_t ReportConfigEUTRA_sequence[] = {
  { &hf_lte_rrc_triggerType , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lte_rrc_T_triggerType },
  { &hf_lte_rrc_triggerQuantity, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lte_rrc_T_triggerQuantity },
  { &hf_lte_rrc_reportQuantity, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lte_rrc_T_reportQuantity },
  { &hf_lte_rrc_maxReportCells, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lte_rrc_INTEGER_1_maxCellReport },
  { &hf_lte_rrc_reportInterval, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lte_rrc_ReportInterval },
  { &hf_lte_rrc_reportAmount, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lte_rrc_T_reportAmount },
  { &hf_lte_rrc_dummy_eag_field, ASN1_NOT_EXTENSION_ROOT, ASN1_NOT_OPTIONAL, dissect_lte_rrc_ReportConfigEUTRA_eag_1 },
  { &hf_lte_rrc_dummy_eag_field, ASN1_NOT_EXTENSION_ROOT, ASN1_NOT_OPTIONAL, dissect_lte_rrc_ReportConfigEUTRA_eag_2 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_ReportConfigEUTRA(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_ReportConfigEUTRA, ReportConfigEUTRA_sequence);

  return offset;
}



static int
dissect_lte_rrc_Threshold_utra_RSRP(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            -5, 91U, NULL, FALSE);

  return offset;
}



static int
dissect_lte_rrc_Threshold_utra_EcN0(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 49U, NULL, FALSE);

  return offset;
}


static const value_string lte_rrc_ThresholdUTRA_vals[] = {
  {   0, "utra-RSCP" },
  {   1, "utra-EcN0" },
  { 0, NULL }
};

static const per_choice_t ThresholdUTRA_choice[] = {
  {   0, &hf_lte_rrc_utra_RSCP_01, ASN1_NO_EXTENSIONS     , dissect_lte_rrc_Threshold_utra_RSRP },
  {   1, &hf_lte_rrc_utra_EcN0_01, ASN1_NO_EXTENSIONS     , dissect_lte_rrc_Threshold_utra_EcN0 },
  { 0, NULL, 0, NULL }
};

static int
dissect_lte_rrc_ThresholdUTRA(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_lte_rrc_ThresholdUTRA, ThresholdUTRA_choice,
                                 NULL);

  return offset;
}



static int
dissect_lte_rrc_ThresholdGERAN(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 63U, NULL, FALSE);

  return offset;
}



static int
dissect_lte_rrc_ThresholdCDMA2000(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 63U, NULL, FALSE);

  return offset;
}


static const value_string lte_rrc_T_b1_Threshold_vals[] = {
  {   0, "b1-ThresholdUTRA" },
  {   1, "b1-ThresholdGERAN" },
  {   2, "b1-ThresholdCDMA2000" },
  { 0, NULL }
};

static const per_choice_t T_b1_Threshold_choice[] = {
  {   0, &hf_lte_rrc_b1_ThresholdUTRA, ASN1_NO_EXTENSIONS     , dissect_lte_rrc_ThresholdUTRA },
  {   1, &hf_lte_rrc_b1_ThresholdGERAN, ASN1_NO_EXTENSIONS     , dissect_lte_rrc_ThresholdGERAN },
  {   2, &hf_lte_rrc_b1_ThresholdCDMA2000, ASN1_NO_EXTENSIONS     , dissect_lte_rrc_ThresholdCDMA2000 },
  { 0, NULL, 0, NULL }
};

static int
dissect_lte_rrc_T_b1_Threshold(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_lte_rrc_T_b1_Threshold, T_b1_Threshold_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t T_eventB1_sequence[] = {
  { &hf_lte_rrc_b1_Threshold, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_T_b1_Threshold },
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_T_eventB1(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_T_eventB1, T_eventB1_sequence);

  return offset;
}


static const value_string lte_rrc_T_b2_Threshold2_vals[] = {
  {   0, "b2-Threshold2UTRA" },
  {   1, "b2-Threshold2GERAN" },
  {   2, "b2-Threshold2CDMA2000" },
  { 0, NULL }
};

static const per_choice_t T_b2_Threshold2_choice[] = {
  {   0, &hf_lte_rrc_b2_Threshold2UTRA, ASN1_NO_EXTENSIONS     , dissect_lte_rrc_ThresholdUTRA },
  {   1, &hf_lte_rrc_b2_Threshold2GERAN, ASN1_NO_EXTENSIONS     , dissect_lte_rrc_ThresholdGERAN },
  {   2, &hf_lte_rrc_b2_Threshold2CDMA2000, ASN1_NO_EXTENSIONS     , dissect_lte_rrc_ThresholdCDMA2000 },
  { 0, NULL, 0, NULL }
};

static int
dissect_lte_rrc_T_b2_Threshold2(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_lte_rrc_T_b2_Threshold2, T_b2_Threshold2_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t T_eventB2_sequence[] = {
  { &hf_lte_rrc_b2_Threshold1, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_ThresholdEUTRA },
  { &hf_lte_rrc_b2_Threshold2, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_T_b2_Threshold2 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_T_eventB2(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_T_eventB2, T_eventB2_sequence);

  return offset;
}


static const value_string lte_rrc_T_eventId_01_vals[] = {
  {   0, "eventB1" },
  {   1, "eventB2" },
  { 0, NULL }
};

static const per_choice_t T_eventId_01_choice[] = {
  {   0, &hf_lte_rrc_eventB1     , ASN1_EXTENSION_ROOT    , dissect_lte_rrc_T_eventB1 },
  {   1, &hf_lte_rrc_eventB2     , ASN1_EXTENSION_ROOT    , dissect_lte_rrc_T_eventB2 },
  { 0, NULL, 0, NULL }
};

static int
dissect_lte_rrc_T_eventId_01(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_lte_rrc_T_eventId_01, T_eventId_01_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t T_event_01_sequence[] = {
  { &hf_lte_rrc_eventId_01  , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_T_eventId_01 },
  { &hf_lte_rrc_hysteresis  , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_Hysteresis },
  { &hf_lte_rrc_timeToTrigger, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_TimeToTrigger },
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_T_event_01(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_T_event_01, T_event_01_sequence);

  return offset;
}


static const value_string lte_rrc_T_purpose_03_vals[] = {
  {   0, "reportStrongestCells" },
  {   1, "reportStrongestCellsForSON" },
  {   2, "reportCGI" },
  { 0, NULL }
};


static int
dissect_lte_rrc_T_purpose_03(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     3, NULL, FALSE, 0, NULL);

  return offset;
}


static const per_sequence_t T_periodical_01_sequence[] = {
  { &hf_lte_rrc_purpose_03  , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_T_purpose_03 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_T_periodical_01(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_T_periodical_01, T_periodical_01_sequence);

  return offset;
}


static const value_string lte_rrc_T_triggerType_01_vals[] = {
  {   0, "event" },
  {   1, "periodical" },
  { 0, NULL }
};

static const per_choice_t T_triggerType_01_choice[] = {
  {   0, &hf_lte_rrc_event_01    , ASN1_NO_EXTENSIONS     , dissect_lte_rrc_T_event_01 },
  {   1, &hf_lte_rrc_periodical_01, ASN1_NO_EXTENSIONS     , dissect_lte_rrc_T_periodical_01 },
  { 0, NULL, 0, NULL }
};

static int
dissect_lte_rrc_T_triggerType_01(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_lte_rrc_T_triggerType_01, T_triggerType_01_choice,
                                 NULL);

  return offset;
}


static const value_string lte_rrc_T_reportAmount_01_vals[] = {
  {   0, "r1" },
  {   1, "r2" },
  {   2, "r4" },
  {   3, "r8" },
  {   4, "r16" },
  {   5, "r32" },
  {   6, "r64" },
  {   7, "infinity" },
  { 0, NULL }
};


static int
dissect_lte_rrc_T_reportAmount_01(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     8, NULL, FALSE, 0, NULL);

  return offset;
}


static const value_string lte_rrc_T_si_RequestForHO_r9_01_vals[] = {
  {   0, "setup" },
  { 0, NULL }
};


static int
dissect_lte_rrc_T_si_RequestForHO_r9_01(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, FALSE, 0, NULL);

  return offset;
}


static const per_sequence_t ReportConfigInterRAT_eag_1_sequence[] = {
  { &hf_lte_rrc_si_RequestForHO_r9_01, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lte_rrc_T_si_RequestForHO_r9_01 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_ReportConfigInterRAT_eag_1(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence_eag(tvb, offset, actx, tree, ReportConfigInterRAT_eag_1_sequence);

  return offset;
}


static const value_string lte_rrc_T_reportQuantityUTRA_FDD_r10_vals[] = {
  {   0, "both" },
  { 0, NULL }
};


static int
dissect_lte_rrc_T_reportQuantityUTRA_FDD_r10(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, FALSE, 0, NULL);

  return offset;
}


static const per_sequence_t ReportConfigInterRAT_eag_2_sequence[] = {
  { &hf_lte_rrc_reportQuantityUTRA_FDD_r10, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lte_rrc_T_reportQuantityUTRA_FDD_r10 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_ReportConfigInterRAT_eag_2(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence_eag(tvb, offset, actx, tree, ReportConfigInterRAT_eag_2_sequence);

  return offset;
}


static const per_sequence_t ReportConfigInterRAT_sequence[] = {
  { &hf_lte_rrc_triggerType_01, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lte_rrc_T_triggerType_01 },
  { &hf_lte_rrc_maxReportCells, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lte_rrc_INTEGER_1_maxCellReport },
  { &hf_lte_rrc_reportInterval, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lte_rrc_ReportInterval },
  { &hf_lte_rrc_reportAmount_01, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lte_rrc_T_reportAmount_01 },
  { &hf_lte_rrc_dummy_eag_field, ASN1_NOT_EXTENSION_ROOT, ASN1_NOT_OPTIONAL, dissect_lte_rrc_ReportConfigInterRAT_eag_1 },
  { &hf_lte_rrc_dummy_eag_field, ASN1_NOT_EXTENSION_ROOT, ASN1_NOT_OPTIONAL, dissect_lte_rrc_ReportConfigInterRAT_eag_2 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_ReportConfigInterRAT(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_ReportConfigInterRAT, ReportConfigInterRAT_sequence);

  return offset;
}


static const value_string lte_rrc_T_reportConfig_vals[] = {
  {   0, "reportConfigEUTRA" },
  {   1, "reportConfigInterRAT" },
  { 0, NULL }
};

static const per_choice_t T_reportConfig_choice[] = {
  {   0, &hf_lte_rrc_reportConfigEUTRA, ASN1_NO_EXTENSIONS     , dissect_lte_rrc_ReportConfigEUTRA },
  {   1, &hf_lte_rrc_reportConfigInterRAT, ASN1_NO_EXTENSIONS     , dissect_lte_rrc_ReportConfigInterRAT },
  { 0, NULL, 0, NULL }
};

static int
dissect_lte_rrc_T_reportConfig(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_lte_rrc_T_reportConfig, T_reportConfig_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t ReportConfigToAddMod_sequence[] = {
  { &hf_lte_rrc_reportConfigId, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_ReportConfigId },
  { &hf_lte_rrc_reportConfig, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_T_reportConfig },
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_ReportConfigToAddMod(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_ReportConfigToAddMod, ReportConfigToAddMod_sequence);

  return offset;
}


static const per_sequence_t ReportConfigToAddModList_sequence_of[1] = {
  { &hf_lte_rrc_ReportConfigToAddModList_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_ReportConfigToAddMod },
};

static int
dissect_lte_rrc_ReportConfigToAddModList(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_lte_rrc_ReportConfigToAddModList, ReportConfigToAddModList_sequence_of,
                                                  1, maxReportConfigId, FALSE);

  return offset;
}



static int
dissect_lte_rrc_MeasId(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            1U, maxMeasId, NULL, FALSE);

  return offset;
}


static const per_sequence_t MeasIdToRemoveList_sequence_of[1] = {
  { &hf_lte_rrc_MeasIdToRemoveList_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_MeasId },
};

static int
dissect_lte_rrc_MeasIdToRemoveList(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_lte_rrc_MeasIdToRemoveList, MeasIdToRemoveList_sequence_of,
                                                  1, maxMeasId, FALSE);

  return offset;
}


static const per_sequence_t MeasIdToAddMod_sequence[] = {
  { &hf_lte_rrc_measId      , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_MeasId },
  { &hf_lte_rrc_measObjectId, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_MeasObjectId },
  { &hf_lte_rrc_reportConfigId, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_ReportConfigId },
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_MeasIdToAddMod(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_MeasIdToAddMod, MeasIdToAddMod_sequence);

  return offset;
}


static const per_sequence_t MeasIdToAddModList_sequence_of[1] = {
  { &hf_lte_rrc_MeasIdToAddModList_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_MeasIdToAddMod },
};

static int
dissect_lte_rrc_MeasIdToAddModList(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_lte_rrc_MeasIdToAddModList, MeasIdToAddModList_sequence_of,
                                                  1, maxMeasId, FALSE);

  return offset;
}


static const per_sequence_t QuantityConfigEUTRA_sequence[] = {
  { &hf_lte_rrc_filterCoefficientRSRP, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lte_rrc_FilterCoefficient },
  { &hf_lte_rrc_filterCoefficientRSRQ, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lte_rrc_FilterCoefficient },
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_QuantityConfigEUTRA(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_QuantityConfigEUTRA, QuantityConfigEUTRA_sequence);

  return offset;
}


static const value_string lte_rrc_T_measQuantityUTRA_FDD_vals[] = {
  {   0, "cpich-RSCP" },
  {   1, "cpich-EcN0" },
  { 0, NULL }
};


static int
dissect_lte_rrc_T_measQuantityUTRA_FDD(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, FALSE, 0, NULL);

  return offset;
}


static const value_string lte_rrc_T_measQuantityUTRA_TDD_vals[] = {
  {   0, "pccpch-RSCP" },
  { 0, NULL }
};


static int
dissect_lte_rrc_T_measQuantityUTRA_TDD(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, FALSE, 0, NULL);

  return offset;
}


static const per_sequence_t QuantityConfigUTRA_sequence[] = {
  { &hf_lte_rrc_measQuantityUTRA_FDD, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_T_measQuantityUTRA_FDD },
  { &hf_lte_rrc_measQuantityUTRA_TDD, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_T_measQuantityUTRA_TDD },
  { &hf_lte_rrc_filterCoefficient, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lte_rrc_FilterCoefficient },
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_QuantityConfigUTRA(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_QuantityConfigUTRA, QuantityConfigUTRA_sequence);

  return offset;
}


static const value_string lte_rrc_T_measQuantityGERAN_vals[] = {
  {   0, "rssi" },
  { 0, NULL }
};


static int
dissect_lte_rrc_T_measQuantityGERAN(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, FALSE, 0, NULL);

  return offset;
}


static const per_sequence_t QuantityConfigGERAN_sequence[] = {
  { &hf_lte_rrc_measQuantityGERAN, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_T_measQuantityGERAN },
  { &hf_lte_rrc_filterCoefficient, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lte_rrc_FilterCoefficient },
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_QuantityConfigGERAN(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_QuantityConfigGERAN, QuantityConfigGERAN_sequence);

  return offset;
}


static const value_string lte_rrc_T_measQuantityCDMA2000_vals[] = {
  {   0, "pilotStrength" },
  {   1, "pilotPnPhaseAndPilotStrength" },
  { 0, NULL }
};


static int
dissect_lte_rrc_T_measQuantityCDMA2000(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, FALSE, 0, NULL);

  return offset;
}


static const per_sequence_t QuantityConfigCDMA2000_sequence[] = {
  { &hf_lte_rrc_measQuantityCDMA2000, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_T_measQuantityCDMA2000 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_QuantityConfigCDMA2000(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_QuantityConfigCDMA2000, QuantityConfigCDMA2000_sequence);

  return offset;
}


static const per_sequence_t QuantityConfigUTRA_v1020_sequence[] = {
  { &hf_lte_rrc_filterCoefficient2_FDD_r10, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lte_rrc_FilterCoefficient },
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_QuantityConfigUTRA_v1020(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_QuantityConfigUTRA_v1020, QuantityConfigUTRA_v1020_sequence);

  return offset;
}


static const per_sequence_t QuantityConfig_eag_1_sequence[] = {
  { &hf_lte_rrc_quantityConfigUTRA_v1020, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lte_rrc_QuantityConfigUTRA_v1020 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_QuantityConfig_eag_1(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence_eag(tvb, offset, actx, tree, QuantityConfig_eag_1_sequence);

  return offset;
}


static const per_sequence_t QuantityConfig_sequence[] = {
  { &hf_lte_rrc_quantityConfigEUTRA, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lte_rrc_QuantityConfigEUTRA },
  { &hf_lte_rrc_quantityConfigUTRA, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lte_rrc_QuantityConfigUTRA },
  { &hf_lte_rrc_quantityConfigGERAN, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lte_rrc_QuantityConfigGERAN },
  { &hf_lte_rrc_quantityConfigCDMA2000, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lte_rrc_QuantityConfigCDMA2000 },
  { &hf_lte_rrc_dummy_eag_field, ASN1_NOT_EXTENSION_ROOT, ASN1_NOT_OPTIONAL, dissect_lte_rrc_QuantityConfig_eag_1 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_QuantityConfig(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_QuantityConfig, QuantityConfig_sequence);

  return offset;
}


static const value_string lte_rrc_T_gapOffset_vals[] = {
  {   0, "gp0" },
  {   1, "gp1" },
  { 0, NULL }
};

static const per_choice_t T_gapOffset_choice[] = {
  {   0, &hf_lte_rrc_gp0         , ASN1_EXTENSION_ROOT    , dissect_lte_rrc_INTEGER_0_39 },
  {   1, &hf_lte_rrc_gp1         , ASN1_EXTENSION_ROOT    , dissect_lte_rrc_INTEGER_0_79 },
  { 0, NULL, 0, NULL }
};

static int
dissect_lte_rrc_T_gapOffset(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_lte_rrc_T_gapOffset, T_gapOffset_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t T_setup_26_sequence[] = {
  { &hf_lte_rrc_gapOffset   , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_T_gapOffset },
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_T_setup_26(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_T_setup_26, T_setup_26_sequence);

  return offset;
}


static const value_string lte_rrc_MeasGapConfig_vals[] = {
  {   0, "release" },
  {   1, "setup" },
  { 0, NULL }
};

static const per_choice_t MeasGapConfig_choice[] = {
  {   0, &hf_lte_rrc_release     , ASN1_NO_EXTENSIONS     , dissect_lte_rrc_NULL },
  {   1, &hf_lte_rrc_setup_27    , ASN1_NO_EXTENSIONS     , dissect_lte_rrc_T_setup_26 },
  { 0, NULL, 0, NULL }
};

static int
dissect_lte_rrc_MeasGapConfig(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_lte_rrc_MeasGapConfig, MeasGapConfig_choice,
                                 NULL);

  return offset;
}



static int
dissect_lte_rrc_S_Measure(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_lte_rrc_RSRP_Range(tvb, offset, actx, tree, hf_index);

  return offset;
}


static const per_sequence_t T_setup_25_sequence[] = {
  { &hf_lte_rrc_mobilityStateParameters, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_MobilityStateParameters },
  { &hf_lte_rrc_timeToTrigger_SF, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_SpeedStateScaleFactors },
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_T_setup_25(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_T_setup_25, T_setup_25_sequence);

  return offset;
}


static const value_string lte_rrc_T_speedStatePars_vals[] = {
  {   0, "release" },
  {   1, "setup" },
  { 0, NULL }
};

static const per_choice_t T_speedStatePars_choice[] = {
  {   0, &hf_lte_rrc_release     , ASN1_NO_EXTENSIONS     , dissect_lte_rrc_NULL },
  {   1, &hf_lte_rrc_setup_26    , ASN1_NO_EXTENSIONS     , dissect_lte_rrc_T_setup_25 },
  { 0, NULL, 0, NULL }
};

static int
dissect_lte_rrc_T_speedStatePars(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_lte_rrc_T_speedStatePars, T_speedStatePars_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t MeasConfig_sequence[] = {
  { &hf_lte_rrc_measObjectToRemoveList, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lte_rrc_MeasObjectToRemoveList },
  { &hf_lte_rrc_measObjectToAddModList, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lte_rrc_MeasObjectToAddModList },
  { &hf_lte_rrc_reportConfigToRemoveList, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lte_rrc_ReportConfigToRemoveList },
  { &hf_lte_rrc_reportConfigToAddModList, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lte_rrc_ReportConfigToAddModList },
  { &hf_lte_rrc_measIdToRemoveList, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lte_rrc_MeasIdToRemoveList },
  { &hf_lte_rrc_measIdToAddModList, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lte_rrc_MeasIdToAddModList },
  { &hf_lte_rrc_quantityConfig, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lte_rrc_QuantityConfig },
  { &hf_lte_rrc_measGapConfig, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lte_rrc_MeasGapConfig },
  { &hf_lte_rrc_s_Measure   , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lte_rrc_S_Measure },
  { &hf_lte_rrc_preRegistrationInfoHRPD, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lte_rrc_PreRegistrationInfoHRPD },
  { &hf_lte_rrc_speedStatePars, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lte_rrc_T_speedStatePars },
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_MeasConfig(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_MeasConfig, MeasConfig_sequence);

  return offset;
}


static const per_sequence_t CarrierFreqEUTRA_sequence[] = {
  { &hf_lte_rrc_dl_CarrierFreq, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_ARFCN_ValueEUTRA },
  { &hf_lte_rrc_ul_CarrierFreq, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lte_rrc_ARFCN_ValueEUTRA },
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_CarrierFreqEUTRA(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_CarrierFreqEUTRA, CarrierFreqEUTRA_sequence);

  return offset;
}


static const value_string lte_rrc_T_dl_Bandwidth_01_vals[] = {
  {   0, "n6" },
  {   1, "n15" },
  {   2, "n25" },
  {   3, "n50" },
  {   4, "n75" },
  {   5, "n100" },
  {   6, "spare10" },
  {   7, "spare9" },
  {   8, "spare8" },
  {   9, "spare7" },
  {  10, "spare6" },
  {  11, "spare5" },
  {  12, "spare4" },
  {  13, "spare3" },
  {  14, "spare2" },
  {  15, "spare1" },
  { 0, NULL }
};


static int
dissect_lte_rrc_T_dl_Bandwidth_01(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     16, NULL, FALSE, 0, NULL);

  return offset;
}


static const value_string lte_rrc_T_ul_Bandwidth_01_vals[] = {
  {   0, "n6" },
  {   1, "n15" },
  {   2, "n25" },
  {   3, "n50" },
  {   4, "n75" },
  {   5, "n100" },
  {   6, "spare10" },
  {   7, "spare9" },
  {   8, "spare8" },
  {   9, "spare7" },
  {  10, "spare6" },
  {  11, "spare5" },
  {  12, "spare4" },
  {  13, "spare3" },
  {  14, "spare2" },
  {  15, "spare1" },
  { 0, NULL }
};


static int
dissect_lte_rrc_T_ul_Bandwidth_01(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     16, NULL, FALSE, 0, NULL);

  return offset;
}


static const per_sequence_t CarrierBandwidthEUTRA_sequence[] = {
  { &hf_lte_rrc_dl_Bandwidth_01, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_T_dl_Bandwidth_01 },
  { &hf_lte_rrc_ul_Bandwidth_01, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lte_rrc_T_ul_Bandwidth_01 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_CarrierBandwidthEUTRA(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_CarrierBandwidthEUTRA, CarrierBandwidthEUTRA_sequence);

  return offset;
}


static const value_string lte_rrc_T_t304_01_vals[] = {
  {   0, "ms50" },
  {   1, "ms100" },
  {   2, "ms150" },
  {   3, "ms200" },
  {   4, "ms500" },
  {   5, "ms1000" },
  {   6, "ms2000" },
  {   7, "spare1" },
  { 0, NULL }
};


static int
dissect_lte_rrc_T_t304_01(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     8, NULL, FALSE, 0, NULL);

  return offset;
}


static const per_sequence_t PRACH_Config_sequence[] = {
  { &hf_lte_rrc_rootSequenceIndex, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_INTEGER_0_837 },
  { &hf_lte_rrc_prach_ConfigInfo, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lte_rrc_PRACH_ConfigInfo },
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_PRACH_Config(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_PRACH_Config, PRACH_Config_sequence);

  return offset;
}


static const value_string lte_rrc_T_antennaPortsCount_vals[] = {
  {   0, "an1" },
  {   1, "an2" },
  {   2, "an4" },
  {   3, "spare1" },
  { 0, NULL }
};


static int
dissect_lte_rrc_T_antennaPortsCount(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     4, NULL, FALSE, 0, NULL);

  return offset;
}


static const per_sequence_t AntennaInfoCommon_sequence[] = {
  { &hf_lte_rrc_antennaPortsCount, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_T_antennaPortsCount },
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_AntennaInfoCommon(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_AntennaInfoCommon, AntennaInfoCommon_sequence);

  return offset;
}


static const per_sequence_t RadioResourceConfigCommon_eag_1_sequence[] = {
  { &hf_lte_rrc_uplinkPowerControlCommon_v1020, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lte_rrc_UplinkPowerControlCommon_v1020 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_RadioResourceConfigCommon_eag_1(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence_eag(tvb, offset, actx, tree, RadioResourceConfigCommon_eag_1_sequence);

  return offset;
}


static const per_sequence_t RadioResourceConfigCommon_sequence[] = {
  { &hf_lte_rrc_rach_ConfigCommon, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lte_rrc_RACH_ConfigCommon },
  { &hf_lte_rrc_prach_Config_01, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lte_rrc_PRACH_Config },
  { &hf_lte_rrc_pdsch_ConfigCommon, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lte_rrc_PDSCH_ConfigCommon },
  { &hf_lte_rrc_pusch_ConfigCommon, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lte_rrc_PUSCH_ConfigCommon },
  { &hf_lte_rrc_phich_Config, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lte_rrc_PHICH_Config },
  { &hf_lte_rrc_pucch_ConfigCommon, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lte_rrc_PUCCH_ConfigCommon },
  { &hf_lte_rrc_soundingRS_UL_ConfigCommon, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lte_rrc_SoundingRS_UL_ConfigCommon },
  { &hf_lte_rrc_uplinkPowerControlCommon, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lte_rrc_UplinkPowerControlCommon },
  { &hf_lte_rrc_antennaInfoCommon, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lte_rrc_AntennaInfoCommon },
  { &hf_lte_rrc_p_Max       , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lte_rrc_P_Max },
  { &hf_lte_rrc_tdd_Config  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lte_rrc_TDD_Config },
  { &hf_lte_rrc_ul_CyclicPrefixLength, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lte_rrc_UL_CyclicPrefixLength },
  { &hf_lte_rrc_dummy_eag_field, ASN1_NOT_EXTENSION_ROOT, ASN1_NOT_OPTIONAL, dissect_lte_rrc_RadioResourceConfigCommon_eag_1 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_RadioResourceConfigCommon(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_RadioResourceConfigCommon, RadioResourceConfigCommon_sequence);

  return offset;
}


static const per_sequence_t RACH_ConfigDedicated_sequence[] = {
  { &hf_lte_rrc_ra_PreambleIndex, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_INTEGER_0_63 },
  { &hf_lte_rrc_ra_PRACH_MaskIndex, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_INTEGER_0_15 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_RACH_ConfigDedicated(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_RACH_ConfigDedicated, RACH_ConfigDedicated_sequence);

  return offset;
}


static const per_sequence_t MobilityControlInfo_sequence[] = {
  { &hf_lte_rrc_targetPhysCellId, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lte_rrc_PhysCellId },
  { &hf_lte_rrc_carrierFreq_03, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lte_rrc_CarrierFreqEUTRA },
  { &hf_lte_rrc_carrierBandwidth, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lte_rrc_CarrierBandwidthEUTRA },
  { &hf_lte_rrc_additionalSpectrumEmission, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lte_rrc_AdditionalSpectrumEmission },
  { &hf_lte_rrc_t304_01     , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lte_rrc_T_t304_01 },
  { &hf_lte_rrc_newUE_Identity, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lte_rrc_C_RNTI },
  { &hf_lte_rrc_radioResourceConfigCommon_01, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lte_rrc_RadioResourceConfigCommon },
  { &hf_lte_rrc_rach_ConfigDedicated, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lte_rrc_RACH_ConfigDedicated },
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_MobilityControlInfo(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_MobilityControlInfo, MobilityControlInfo_sequence);

  return offset;
}


static const per_sequence_t SEQUENCE_SIZE_1_maxDRB_OF_DedicatedInfoNAS_sequence_of[1] = {
  { &hf_lte_rrc_dedicatedInfoNASList_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_DedicatedInfoNAS },
};

static int
dissect_lte_rrc_SEQUENCE_SIZE_1_maxDRB_OF_DedicatedInfoNAS(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_lte_rrc_SEQUENCE_SIZE_1_maxDRB_OF_DedicatedInfoNAS, SEQUENCE_SIZE_1_maxDRB_OF_DedicatedInfoNAS_sequence_of,
                                                  1, maxDRB, FALSE);

  return offset;
}


static const value_string lte_rrc_T_cipheringAlgorithm_vals[] = {
  {   0, "eea0" },
  {   1, "eea1" },
  {   2, "eea2" },
  {   3, "spare5" },
  {   4, "spare4" },
  {   5, "spare3" },
  {   6, "spare2" },
  {   7, "spare1" },
  { 0, NULL }
};


static int
dissect_lte_rrc_T_cipheringAlgorithm(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     8, NULL, TRUE, 0, NULL);

  return offset;
}


static const value_string lte_rrc_T_integrityProtAlgorithm_vals[] = {
  {   0, "eia0-v920" },
  {   1, "eia1" },
  {   2, "eia2" },
  {   3, "spare5" },
  {   4, "spare4" },
  {   5, "spare3" },
  {   6, "spare2" },
  {   7, "spare1" },
  { 0, NULL }
};


static int
dissect_lte_rrc_T_integrityProtAlgorithm(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     8, NULL, TRUE, 0, NULL);

  return offset;
}


static const per_sequence_t SecurityAlgorithmConfig_sequence[] = {
  { &hf_lte_rrc_cipheringAlgorithm, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_T_cipheringAlgorithm },
  { &hf_lte_rrc_integrityProtAlgorithm, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_T_integrityProtAlgorithm },
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_SecurityAlgorithmConfig(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_SecurityAlgorithmConfig, SecurityAlgorithmConfig_sequence);

  return offset;
}


static const per_sequence_t T_intraLTE_sequence[] = {
  { &hf_lte_rrc_securityAlgorithmConfig, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lte_rrc_SecurityAlgorithmConfig },
  { &hf_lte_rrc_keyChangeIndicator, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_BOOLEAN },
  { &hf_lte_rrc_nextHopChainingCount, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_NextHopChainingCount },
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_T_intraLTE(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_T_intraLTE, T_intraLTE_sequence);

  return offset;
}



static int
dissect_lte_rrc_T_nas_SecurityParamToEUTRA(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  tvbuff_t *nas_sec_param_to_eutra_tvb = NULL;
  guint32 length;
  proto_item *item;
  proto_tree *subtree;

  offset = dissect_per_octet_string(tvb, offset, actx, tree, hf_index,
                                       6, 6, FALSE, &nas_sec_param_to_eutra_tvb);

  length = tvb_length(nas_sec_param_to_eutra_tvb);
  item = proto_tree_add_text(tree, nas_sec_param_to_eutra_tvb, 0, length, "NAS security parameters to E-UTRA");
  subtree = proto_item_add_subtree(item, ett_lte_rrc_nas_SecurityParam);
  de_emm_sec_par_to_eutra(nas_sec_param_to_eutra_tvb, subtree, actx->pinfo, 0, length, NULL, 0);


  return offset;
}


static const per_sequence_t T_interRAT_sequence[] = {
  { &hf_lte_rrc_securityAlgorithmConfig, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_SecurityAlgorithmConfig },
  { &hf_lte_rrc_nas_SecurityParamToEUTRA, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_T_nas_SecurityParamToEUTRA },
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_T_interRAT(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_T_interRAT, T_interRAT_sequence);

  return offset;
}


static const value_string lte_rrc_T_handoverType_vals[] = {
  {   0, "intraLTE" },
  {   1, "interRAT" },
  { 0, NULL }
};

static const per_choice_t T_handoverType_choice[] = {
  {   0, &hf_lte_rrc_intraLTE    , ASN1_NO_EXTENSIONS     , dissect_lte_rrc_T_intraLTE },
  {   1, &hf_lte_rrc_interRAT    , ASN1_NO_EXTENSIONS     , dissect_lte_rrc_T_interRAT },
  { 0, NULL, 0, NULL }
};

static int
dissect_lte_rrc_T_handoverType(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_lte_rrc_T_handoverType, T_handoverType_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t SecurityConfigHO_sequence[] = {
  { &hf_lte_rrc_handoverType, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lte_rrc_T_handoverType },
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_SecurityConfigHO(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_SecurityConfigHO, SecurityConfigHO_sequence);

  return offset;
}


static const value_string lte_rrc_T_proximityIndicationEUTRA_r9_vals[] = {
  {   0, "enabled" },
  { 0, NULL }
};


static int
dissect_lte_rrc_T_proximityIndicationEUTRA_r9(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, FALSE, 0, NULL);

  return offset;
}


static const value_string lte_rrc_T_proximityIndicationUTRA_r9_vals[] = {
  {   0, "enabled" },
  { 0, NULL }
};


static int
dissect_lte_rrc_T_proximityIndicationUTRA_r9(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, FALSE, 0, NULL);

  return offset;
}


static const per_sequence_t ReportProximityConfig_r9_sequence[] = {
  { &hf_lte_rrc_proximityIndicationEUTRA_r9, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lte_rrc_T_proximityIndicationEUTRA_r9 },
  { &hf_lte_rrc_proximityIndicationUTRA_r9, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lte_rrc_T_proximityIndicationUTRA_r9 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_ReportProximityConfig_r9(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_ReportProximityConfig_r9, ReportProximityConfig_r9_sequence);

  return offset;
}


static const per_sequence_t OtherConfig_r9_sequence[] = {
  { &hf_lte_rrc_reportProximityConfig_r9, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lte_rrc_ReportProximityConfig_r9 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_OtherConfig_r9(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_OtherConfig_r9, OtherConfig_r9_sequence);

  return offset;
}


static const value_string lte_rrc_T_fullConfig_r9_vals[] = {
  {   0, "true" },
  { 0, NULL }
};


static int
dissect_lte_rrc_T_fullConfig_r9(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, FALSE, 0, NULL);

  return offset;
}



static int
dissect_lte_rrc_SCellIndex_r10(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            1U, 7U, NULL, FALSE);

  return offset;
}


static const per_sequence_t SCellToReleaseList_r10_sequence_of[1] = {
  { &hf_lte_rrc_SCellToReleaseList_r10_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_SCellIndex_r10 },
};

static int
dissect_lte_rrc_SCellToReleaseList_r10(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_lte_rrc_SCellToReleaseList_r10, SCellToReleaseList_r10_sequence_of,
                                                  1, maxSCell_r10, FALSE);

  return offset;
}


static const per_sequence_t T_cellIdentification_r10_sequence[] = {
  { &hf_lte_rrc_physCellId_r10, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_PhysCellId },
  { &hf_lte_rrc_dl_CarrierFreq_r10, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_ARFCN_ValueEUTRA },
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_T_cellIdentification_r10(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_T_cellIdentification_r10, T_cellIdentification_r10_sequence);

  return offset;
}


static const value_string lte_rrc_T_dl_Bandwidth_r10_vals[] = {
  {   0, "n6" },
  {   1, "n15" },
  {   2, "n25" },
  {   3, "n50" },
  {   4, "n75" },
  {   5, "n100" },
  { 0, NULL }
};


static int
dissect_lte_rrc_T_dl_Bandwidth_r10(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     6, NULL, FALSE, 0, NULL);

  return offset;
}


static const per_sequence_t T_nonUL_Configuration_r10_01_sequence[] = {
  { &hf_lte_rrc_dl_Bandwidth_r10, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_T_dl_Bandwidth_r10 },
  { &hf_lte_rrc_antennaInfoCommon_r10, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_AntennaInfoCommon },
  { &hf_lte_rrc_mbsfn_SubframeConfigList_r10, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lte_rrc_MBSFN_SubframeConfigList },
  { &hf_lte_rrc_phich_Config_r10, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_PHICH_Config },
  { &hf_lte_rrc_pdsch_ConfigCommon_r10, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_PDSCH_ConfigCommon },
  { &hf_lte_rrc_tdd_Config_r10, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lte_rrc_TDD_Config },
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_T_nonUL_Configuration_r10_01(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_T_nonUL_Configuration_r10_01, T_nonUL_Configuration_r10_01_sequence);

  return offset;
}


static const value_string lte_rrc_T_ul_Bandwidth_r10_vals[] = {
  {   0, "n6" },
  {   1, "n15" },
  {   2, "n25" },
  {   3, "n50" },
  {   4, "n75" },
  {   5, "n100" },
  { 0, NULL }
};


static int
dissect_lte_rrc_T_ul_Bandwidth_r10(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     6, NULL, FALSE, 0, NULL);

  return offset;
}


static const per_sequence_t T_ul_FreqInfo_r10_sequence[] = {
  { &hf_lte_rrc_ul_CarrierFreq_r10, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lte_rrc_ARFCN_ValueEUTRA },
  { &hf_lte_rrc_ul_Bandwidth_r10, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lte_rrc_T_ul_Bandwidth_r10 },
  { &hf_lte_rrc_additionalSpectrumEmissionSCell_r10, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_AdditionalSpectrumEmission },
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_T_ul_FreqInfo_r10(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_T_ul_FreqInfo_r10, T_ul_FreqInfo_r10_sequence);

  return offset;
}



static int
dissect_lte_rrc_T_p0_NominalPUSCH_r10(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            -126, 24U, NULL, FALSE);

  proto_item_append_text(actx->created_item, "dBm");


  return offset;
}


static const value_string lte_rrc_T_alpha_r10_vals[] = {
  {   0, "al0" },
  {   1, "al04" },
  {   2, "al05" },
  {   3, "al06" },
  {   4, "al07" },
  {   5, "al08" },
  {   6, "al09" },
  {   7, "al1" },
  { 0, NULL }
};


static int
dissect_lte_rrc_T_alpha_r10(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     8, NULL, FALSE, 0, NULL);

  return offset;
}


static const per_sequence_t UplinkPowerControlCommonSCell_r10_sequence[] = {
  { &hf_lte_rrc_p0_NominalPUSCH_r10, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_T_p0_NominalPUSCH_r10 },
  { &hf_lte_rrc_alpha_r10   , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_T_alpha_r10 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_UplinkPowerControlCommonSCell_r10(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_UplinkPowerControlCommonSCell_r10, UplinkPowerControlCommonSCell_r10_sequence);

  return offset;
}


static const per_sequence_t PRACH_ConfigSCell_r10_sequence[] = {
  { &hf_lte_rrc_prach_ConfigIndex_r10, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_INTEGER_0_63 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_PRACH_ConfigSCell_r10(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_PRACH_ConfigSCell_r10, PRACH_ConfigSCell_r10_sequence);

  return offset;
}


static const per_sequence_t T_ul_Configuration_r10_01_sequence[] = {
  { &hf_lte_rrc_ul_FreqInfo_r10, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_T_ul_FreqInfo_r10 },
  { &hf_lte_rrc_p_Max_r10   , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lte_rrc_P_Max },
  { &hf_lte_rrc_uplinkPowerControlCommonSCell_r10, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_UplinkPowerControlCommonSCell_r10 },
  { &hf_lte_rrc_soundingRS_UL_ConfigCommon_r10, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_SoundingRS_UL_ConfigCommon },
  { &hf_lte_rrc_ul_CyclicPrefixLength_r10, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_UL_CyclicPrefixLength },
  { &hf_lte_rrc_prach_ConfigSCell_r10, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lte_rrc_PRACH_ConfigSCell_r10 },
  { &hf_lte_rrc_pusch_ConfigCommon_r10, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_PUSCH_ConfigCommon },
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_T_ul_Configuration_r10_01(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_T_ul_Configuration_r10_01, T_ul_Configuration_r10_01_sequence);

  return offset;
}


static const per_sequence_t RadioResourceConfigCommonSCell_r10_sequence[] = {
  { &hf_lte_rrc_nonUL_Configuration_r10_01, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lte_rrc_T_nonUL_Configuration_r10_01 },
  { &hf_lte_rrc_ul_Configuration_r10_01, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lte_rrc_T_ul_Configuration_r10_01 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_RadioResourceConfigCommonSCell_r10(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_RadioResourceConfigCommonSCell_r10, RadioResourceConfigCommonSCell_r10_sequence);

  return offset;
}


static const per_sequence_t T_own_r10_sequence[] = {
  { &hf_lte_rrc_cif_Presence_r10, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_BOOLEAN },
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_T_own_r10(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_T_own_r10, T_own_r10_sequence);

  return offset;
}



static int
dissect_lte_rrc_ServCellIndex_r10(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 7U, NULL, FALSE);

  return offset;
}


static const per_sequence_t T_other_r10_sequence[] = {
  { &hf_lte_rrc_schedulingCellId_r10, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_ServCellIndex_r10 },
  { &hf_lte_rrc_pdsch_Start_r10, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_INTEGER_1_4 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_T_other_r10(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_T_other_r10, T_other_r10_sequence);

  return offset;
}


static const value_string lte_rrc_T_schedulingCellInfo_r10_vals[] = {
  {   0, "own-r10" },
  {   1, "other-r10" },
  { 0, NULL }
};

static const per_choice_t T_schedulingCellInfo_r10_choice[] = {
  {   0, &hf_lte_rrc_own_r10     , ASN1_NO_EXTENSIONS     , dissect_lte_rrc_T_own_r10 },
  {   1, &hf_lte_rrc_other_r10   , ASN1_NO_EXTENSIONS     , dissect_lte_rrc_T_other_r10 },
  { 0, NULL, 0, NULL }
};

static int
dissect_lte_rrc_T_schedulingCellInfo_r10(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_lte_rrc_T_schedulingCellInfo_r10, T_schedulingCellInfo_r10_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t CrossCarrierSchedulingConfig_r10_sequence[] = {
  { &hf_lte_rrc_schedulingCellInfo_r10, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_T_schedulingCellInfo_r10 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_CrossCarrierSchedulingConfig_r10(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_CrossCarrierSchedulingConfig_r10, CrossCarrierSchedulingConfig_r10_sequence);

  return offset;
}


static const per_sequence_t T_nonUL_Configuration_r10_sequence[] = {
  { &hf_lte_rrc_antennaInfo_r10_01, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lte_rrc_AntennaInfoDedicated_r10 },
  { &hf_lte_rrc_crossCarrierSchedulingConfig_r10, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lte_rrc_CrossCarrierSchedulingConfig_r10 },
  { &hf_lte_rrc_csi_RS_Config_r10, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lte_rrc_CSI_RS_Config_r10 },
  { &hf_lte_rrc_pdsch_ConfigDedicated_r10, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lte_rrc_PDSCH_ConfigDedicated },
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_T_nonUL_Configuration_r10(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_T_nonUL_Configuration_r10, T_nonUL_Configuration_r10_sequence);

  return offset;
}


static const value_string lte_rrc_T_groupHoppingDisabled_r10_01_vals[] = {
  {   0, "true" },
  { 0, NULL }
};


static int
dissect_lte_rrc_T_groupHoppingDisabled_r10_01(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, FALSE, 0, NULL);

  return offset;
}


static const value_string lte_rrc_T_dmrs_WithOCC_Activated_r10_01_vals[] = {
  {   0, "true" },
  { 0, NULL }
};


static int
dissect_lte_rrc_T_dmrs_WithOCC_Activated_r10_01(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, FALSE, 0, NULL);

  return offset;
}


static const per_sequence_t PUSCH_ConfigDedicatedSCell_r10_sequence[] = {
  { &hf_lte_rrc_groupHoppingDisabled_r10_01, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lte_rrc_T_groupHoppingDisabled_r10_01 },
  { &hf_lte_rrc_dmrs_WithOCC_Activated_r10_01, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lte_rrc_T_dmrs_WithOCC_Activated_r10_01 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_PUSCH_ConfigDedicatedSCell_r10(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_PUSCH_ConfigDedicatedSCell_r10, PUSCH_ConfigDedicatedSCell_r10_sequence);

  return offset;
}



static int
dissect_lte_rrc_T_p0_UE_PUSCH_r10(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            -8, 7U, NULL, FALSE);

  proto_item_append_text(actx->created_item, "dB");


  return offset;
}


static const value_string lte_rrc_T_deltaMCS_Enabled_r10_vals[] = {
  {   0, "en0" },
  {   1, "en1" },
  { 0, NULL }
};


static int
dissect_lte_rrc_T_deltaMCS_Enabled_r10(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, FALSE, 0, NULL);

  return offset;
}


static const value_string lte_rrc_T_pathlossReferenceLinking_r10_vals[] = {
  {   0, "pCell" },
  {   1, "sCell" },
  { 0, NULL }
};


static int
dissect_lte_rrc_T_pathlossReferenceLinking_r10(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, FALSE, 0, NULL);

  return offset;
}


static const per_sequence_t UplinkPowerControlDedicatedSCell_r10_sequence[] = {
  { &hf_lte_rrc_p0_UE_PUSCH_r10, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_T_p0_UE_PUSCH_r10 },
  { &hf_lte_rrc_deltaMCS_Enabled_r10, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_T_deltaMCS_Enabled_r10 },
  { &hf_lte_rrc_accumulationEnabled_r10, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_BOOLEAN },
  { &hf_lte_rrc_pSRS_Offset_r10, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_INTEGER_0_15 },
  { &hf_lte_rrc_pSRS_OffsetAp_r10, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lte_rrc_INTEGER_0_15 },
  { &hf_lte_rrc_filterCoefficient_r10, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lte_rrc_FilterCoefficient },
  { &hf_lte_rrc_pathlossReferenceLinking_r10, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_T_pathlossReferenceLinking_r10 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_UplinkPowerControlDedicatedSCell_r10(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_UplinkPowerControlDedicatedSCell_r10, UplinkPowerControlDedicatedSCell_r10_sequence);

  return offset;
}


static const value_string lte_rrc_T_pmi_RI_Report_r10_vals[] = {
  {   0, "setup" },
  { 0, NULL }
};


static int
dissect_lte_rrc_T_pmi_RI_Report_r10(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, FALSE, 0, NULL);

  return offset;
}


static const per_sequence_t CQI_ReportConfigSCell_r10_sequence[] = {
  { &hf_lte_rrc_cqi_ReportModeAperiodic_r10, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lte_rrc_CQI_ReportModeAperiodic },
  { &hf_lte_rrc_nomPDSCH_RS_EPRE_Offset_r10, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_INTEGER_M1_6 },
  { &hf_lte_rrc_cqi_ReportPeriodicSCell_r10, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lte_rrc_CQI_ReportPeriodic_r10 },
  { &hf_lte_rrc_pmi_RI_Report_r10, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lte_rrc_T_pmi_RI_Report_r10 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_CQI_ReportConfigSCell_r10(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_CQI_ReportConfigSCell_r10, CQI_ReportConfigSCell_r10_sequence);

  return offset;
}


static const per_sequence_t T_ul_Configuration_r10_sequence[] = {
  { &hf_lte_rrc_antennaInfoUL_r10, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lte_rrc_AntennaInfoUL_r10 },
  { &hf_lte_rrc_pusch_ConfigDedicatedSCell_r10, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lte_rrc_PUSCH_ConfigDedicatedSCell_r10 },
  { &hf_lte_rrc_uplinkPowerControlDedicatedSCell_r10, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lte_rrc_UplinkPowerControlDedicatedSCell_r10 },
  { &hf_lte_rrc_cqi_ReportConfigSCell_r10, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lte_rrc_CQI_ReportConfigSCell_r10 },
  { &hf_lte_rrc_soundingRS_UL_ConfigDedicated_r10, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lte_rrc_SoundingRS_UL_ConfigDedicated },
  { &hf_lte_rrc_soundingRS_UL_ConfigDedicated_v1020, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lte_rrc_SoundingRS_UL_ConfigDedicated_v1020 },
  { &hf_lte_rrc_soundingRS_UL_ConfigDedicatedAperiodic_r10, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lte_rrc_SoundingRS_UL_ConfigDedicatedAperiodic_r10 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_T_ul_Configuration_r10(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_T_ul_Configuration_r10, T_ul_Configuration_r10_sequence);

  return offset;
}


static const per_sequence_t PhysicalConfigDedicatedSCell_r10_sequence[] = {
  { &hf_lte_rrc_nonUL_Configuration_r10, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lte_rrc_T_nonUL_Configuration_r10 },
  { &hf_lte_rrc_ul_Configuration_r10, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lte_rrc_T_ul_Configuration_r10 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_PhysicalConfigDedicatedSCell_r10(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_PhysicalConfigDedicatedSCell_r10, PhysicalConfigDedicatedSCell_r10_sequence);

  return offset;
}


static const per_sequence_t RadioResourceConfigDedicatedSCell_r10_sequence[] = {
  { &hf_lte_rrc_physicalConfigDedicatedSCell_r10, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lte_rrc_PhysicalConfigDedicatedSCell_r10 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_RadioResourceConfigDedicatedSCell_r10(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_RadioResourceConfigDedicatedSCell_r10, RadioResourceConfigDedicatedSCell_r10_sequence);

  return offset;
}


static const per_sequence_t SCellToAddMod_r10_sequence[] = {
  { &hf_lte_rrc_sCellIndex_r10, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lte_rrc_SCellIndex_r10 },
  { &hf_lte_rrc_cellIdentification_r10, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lte_rrc_T_cellIdentification_r10 },
  { &hf_lte_rrc_radioResourceConfigCommonSCell_r10, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lte_rrc_RadioResourceConfigCommonSCell_r10 },
  { &hf_lte_rrc_radioResourceConfigDedicatedSCell_r10, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lte_rrc_RadioResourceConfigDedicatedSCell_r10 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_SCellToAddMod_r10(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_SCellToAddMod_r10, SCellToAddMod_r10_sequence);

  return offset;
}


static const per_sequence_t SCellToAddModList_r10_sequence_of[1] = {
  { &hf_lte_rrc_SCellToAddModList_r10_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_SCellToAddMod_r10 },
};

static int
dissect_lte_rrc_SCellToAddModList_r10(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_lte_rrc_SCellToAddModList_r10, SCellToAddModList_r10_sequence_of,
                                                  1, maxSCell_r10, FALSE);

  return offset;
}


static const per_sequence_t T_nonCriticalExtension_18_sequence[] = {
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_T_nonCriticalExtension_18(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_T_nonCriticalExtension_18, T_nonCriticalExtension_18_sequence);

  return offset;
}


static const per_sequence_t RRCConnectionReconfiguration_v1020_IEs_sequence[] = {
  { &hf_lte_rrc_sCellToReleaseList_r10, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lte_rrc_SCellToReleaseList_r10 },
  { &hf_lte_rrc_sCellToAddModList_r10, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lte_rrc_SCellToAddModList_r10 },
  { &hf_lte_rrc_nonCriticalExtension_38, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lte_rrc_T_nonCriticalExtension_18 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_RRCConnectionReconfiguration_v1020_IEs(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_RRCConnectionReconfiguration_v1020_IEs, RRCConnectionReconfiguration_v1020_IEs_sequence);

  return offset;
}


static const per_sequence_t RRCConnectionReconfiguration_v920_IEs_sequence[] = {
  { &hf_lte_rrc_otherConfig_r9, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lte_rrc_OtherConfig_r9 },
  { &hf_lte_rrc_fullConfig_r9, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lte_rrc_T_fullConfig_r9 },
  { &hf_lte_rrc_nonCriticalExtension_37, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lte_rrc_RRCConnectionReconfiguration_v1020_IEs },
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_RRCConnectionReconfiguration_v920_IEs(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_RRCConnectionReconfiguration_v920_IEs, RRCConnectionReconfiguration_v920_IEs_sequence);

  return offset;
}


static const per_sequence_t RRCConnectionReconfiguration_v890_IEs_sequence[] = {
  { &hf_lte_rrc_lateNonCriticalExtension, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lte_rrc_OCTET_STRING },
  { &hf_lte_rrc_nonCriticalExtension_36, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lte_rrc_RRCConnectionReconfiguration_v920_IEs },
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_RRCConnectionReconfiguration_v890_IEs(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_RRCConnectionReconfiguration_v890_IEs, RRCConnectionReconfiguration_v890_IEs_sequence);

  return offset;
}


static const per_sequence_t RRCConnectionReconfiguration_r8_IEs_sequence[] = {
  { &hf_lte_rrc_measConfig  , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lte_rrc_MeasConfig },
  { &hf_lte_rrc_mobilityControlInfo, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lte_rrc_MobilityControlInfo },
  { &hf_lte_rrc_dedicatedInfoNASList, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lte_rrc_SEQUENCE_SIZE_1_maxDRB_OF_DedicatedInfoNAS },
  { &hf_lte_rrc_radioResourceConfigDedicated, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lte_rrc_RadioResourceConfigDedicated },
  { &hf_lte_rrc_securityConfigHO, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lte_rrc_SecurityConfigHO },
  { &hf_lte_rrc_nonCriticalExtension_35, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lte_rrc_RRCConnectionReconfiguration_v890_IEs },
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_RRCConnectionReconfiguration_r8_IEs(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_RRCConnectionReconfiguration_r8_IEs, RRCConnectionReconfiguration_r8_IEs_sequence);

  return offset;
}


static const value_string lte_rrc_T_c1_18_vals[] = {
  {   0, "rrcConnectionReconfiguration-r8" },
  {   1, "spare7" },
  {   2, "spare6" },
  {   3, "spare5" },
  {   4, "spare4" },
  {   5, "spare3" },
  {   6, "spare2" },
  {   7, "spare1" },
  { 0, NULL }
};

static const per_choice_t T_c1_18_choice[] = {
  {   0, &hf_lte_rrc_rrcConnectionReconfiguration_r8, ASN1_NO_EXTENSIONS     , dissect_lte_rrc_RRCConnectionReconfiguration_r8_IEs },
  {   1, &hf_lte_rrc_spare7      , ASN1_NO_EXTENSIONS     , dissect_lte_rrc_NULL },
  {   2, &hf_lte_rrc_spare6      , ASN1_NO_EXTENSIONS     , dissect_lte_rrc_NULL },
  {   3, &hf_lte_rrc_spare5      , ASN1_NO_EXTENSIONS     , dissect_lte_rrc_NULL },
  {   4, &hf_lte_rrc_spare4      , ASN1_NO_EXTENSIONS     , dissect_lte_rrc_NULL },
  {   5, &hf_lte_rrc_spare3      , ASN1_NO_EXTENSIONS     , dissect_lte_rrc_NULL },
  {   6, &hf_lte_rrc_spare2      , ASN1_NO_EXTENSIONS     , dissect_lte_rrc_NULL },
  {   7, &hf_lte_rrc_spare1      , ASN1_NO_EXTENSIONS     , dissect_lte_rrc_NULL },
  { 0, NULL, 0, NULL }
};

static int
dissect_lte_rrc_T_c1_18(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_lte_rrc_T_c1_18, T_c1_18_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t T_criticalExtensionsFuture_14_sequence[] = {
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_T_criticalExtensionsFuture_14(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_T_criticalExtensionsFuture_14, T_criticalExtensionsFuture_14_sequence);

  return offset;
}


static const value_string lte_rrc_T_criticalExtensions_14_vals[] = {
  {   0, "c1" },
  {   1, "criticalExtensionsFuture" },
  { 0, NULL }
};

static const per_choice_t T_criticalExtensions_14_choice[] = {
  {   0, &hf_lte_rrc_c1_18       , ASN1_NO_EXTENSIONS     , dissect_lte_rrc_T_c1_18 },
  {   1, &hf_lte_rrc_criticalExtensionsFuture_14, ASN1_NO_EXTENSIONS     , dissect_lte_rrc_T_criticalExtensionsFuture_14 },
  { 0, NULL, 0, NULL }
};

static int
dissect_lte_rrc_T_criticalExtensions_14(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_lte_rrc_T_criticalExtensions_14, T_criticalExtensions_14_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t RRCConnectionReconfiguration_sequence[] = {
  { &hf_lte_rrc_rrc_TransactionIdentifier, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_RRC_TransactionIdentifier },
  { &hf_lte_rrc_criticalExtensions_14, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_T_criticalExtensions_14 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_RRCConnectionReconfiguration(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {

col_append_str(actx->pinfo->cinfo, COL_INFO, "RRCConnectionReconfiguration ");

  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_RRCConnectionReconfiguration, RRCConnectionReconfiguration_sequence);

  return offset;
}


static const value_string lte_rrc_ReleaseCause_vals[] = {
  {   0, "loadBalancingTAUrequired" },
  {   1, "other" },
  {   2, "cs-FallbackHighPriority-v1020" },
  {   3, "spare1" },
  { 0, NULL }
};


static int
dissect_lte_rrc_ReleaseCause(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     4, NULL, FALSE, 0, NULL);

  return offset;
}


static const per_sequence_t CarrierFreqListUTRA_TDD_r10_sequence_of[1] = {
  { &hf_lte_rrc_CarrierFreqListUTRA_TDD_r10_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_ARFCN_ValueUTRA },
};

static int
dissect_lte_rrc_CarrierFreqListUTRA_TDD_r10(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_lte_rrc_CarrierFreqListUTRA_TDD_r10, CarrierFreqListUTRA_TDD_r10_sequence_of,
                                                  1, maxFreqUTRA_TDD_r10, FALSE);

  return offset;
}


static const value_string lte_rrc_RedirectedCarrierInfo_vals[] = {
  {   0, "eutra" },
  {   1, "geran" },
  {   2, "utra-FDD" },
  {   3, "utra-TDD" },
  {   4, "cdma2000-HRPD" },
  {   5, "cdma2000-1xRTT" },
  {   6, "utra-TDD-r10" },
  { 0, NULL }
};

static const per_choice_t RedirectedCarrierInfo_choice[] = {
  {   0, &hf_lte_rrc_eutra       , ASN1_EXTENSION_ROOT    , dissect_lte_rrc_ARFCN_ValueEUTRA },
  {   1, &hf_lte_rrc_geran_01    , ASN1_EXTENSION_ROOT    , dissect_lte_rrc_CarrierFreqsGERAN },
  {   2, &hf_lte_rrc_utra_FDD    , ASN1_EXTENSION_ROOT    , dissect_lte_rrc_ARFCN_ValueUTRA },
  {   3, &hf_lte_rrc_utra_TDD    , ASN1_EXTENSION_ROOT    , dissect_lte_rrc_ARFCN_ValueUTRA },
  {   4, &hf_lte_rrc_cdma2000_HRPD, ASN1_EXTENSION_ROOT    , dissect_lte_rrc_CarrierFreqCDMA2000 },
  {   5, &hf_lte_rrc_cdma2000_1xRTT, ASN1_EXTENSION_ROOT    , dissect_lte_rrc_CarrierFreqCDMA2000 },
  {   6, &hf_lte_rrc_utra_TDD_r10_01, ASN1_NOT_EXTENSION_ROOT, dissect_lte_rrc_CarrierFreqListUTRA_TDD_r10 },
  { 0, NULL, 0, NULL }
};

static int
dissect_lte_rrc_RedirectedCarrierInfo(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_lte_rrc_RedirectedCarrierInfo, RedirectedCarrierInfo_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t FreqPriorityEUTRA_sequence[] = {
  { &hf_lte_rrc_carrierFreq_01, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_ARFCN_ValueEUTRA },
  { &hf_lte_rrc_cellReselectionPriority, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_CellReselectionPriority },
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_FreqPriorityEUTRA(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_FreqPriorityEUTRA, FreqPriorityEUTRA_sequence);

  return offset;
}


static const per_sequence_t FreqPriorityListEUTRA_sequence_of[1] = {
  { &hf_lte_rrc_FreqPriorityListEUTRA_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_FreqPriorityEUTRA },
};

static int
dissect_lte_rrc_FreqPriorityListEUTRA(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_lte_rrc_FreqPriorityListEUTRA, FreqPriorityListEUTRA_sequence_of,
                                                  1, maxFreq, FALSE);

  return offset;
}


static const per_sequence_t FreqsPriorityGERAN_sequence[] = {
  { &hf_lte_rrc_carrierFreqs, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_CarrierFreqsGERAN },
  { &hf_lte_rrc_cellReselectionPriority, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_CellReselectionPriority },
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_FreqsPriorityGERAN(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_FreqsPriorityGERAN, FreqsPriorityGERAN_sequence);

  return offset;
}


static const per_sequence_t FreqsPriorityListGERAN_sequence_of[1] = {
  { &hf_lte_rrc_FreqsPriorityListGERAN_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_FreqsPriorityGERAN },
};

static int
dissect_lte_rrc_FreqsPriorityListGERAN(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_lte_rrc_FreqsPriorityListGERAN, FreqsPriorityListGERAN_sequence_of,
                                                  1, maxGNFG, FALSE);

  return offset;
}


static const per_sequence_t FreqPriorityUTRA_FDD_sequence[] = {
  { &hf_lte_rrc_carrierFreq_02, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_ARFCN_ValueUTRA },
  { &hf_lte_rrc_cellReselectionPriority, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_CellReselectionPriority },
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_FreqPriorityUTRA_FDD(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_FreqPriorityUTRA_FDD, FreqPriorityUTRA_FDD_sequence);

  return offset;
}


static const per_sequence_t FreqPriorityListUTRA_FDD_sequence_of[1] = {
  { &hf_lte_rrc_FreqPriorityListUTRA_FDD_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_FreqPriorityUTRA_FDD },
};

static int
dissect_lte_rrc_FreqPriorityListUTRA_FDD(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_lte_rrc_FreqPriorityListUTRA_FDD, FreqPriorityListUTRA_FDD_sequence_of,
                                                  1, maxUTRA_FDD_Carrier, FALSE);

  return offset;
}


static const per_sequence_t FreqPriorityUTRA_TDD_sequence[] = {
  { &hf_lte_rrc_carrierFreq_02, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_ARFCN_ValueUTRA },
  { &hf_lte_rrc_cellReselectionPriority, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_CellReselectionPriority },
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_FreqPriorityUTRA_TDD(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_FreqPriorityUTRA_TDD, FreqPriorityUTRA_TDD_sequence);

  return offset;
}


static const per_sequence_t FreqPriorityListUTRA_TDD_sequence_of[1] = {
  { &hf_lte_rrc_FreqPriorityListUTRA_TDD_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_FreqPriorityUTRA_TDD },
};

static int
dissect_lte_rrc_FreqPriorityListUTRA_TDD(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_lte_rrc_FreqPriorityListUTRA_TDD, FreqPriorityListUTRA_TDD_sequence_of,
                                                  1, maxUTRA_TDD_Carrier, FALSE);

  return offset;
}


static const per_sequence_t BandClassPriorityHRPD_sequence[] = {
  { &hf_lte_rrc_bandClass   , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_BandclassCDMA2000 },
  { &hf_lte_rrc_cellReselectionPriority, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_CellReselectionPriority },
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_BandClassPriorityHRPD(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_BandClassPriorityHRPD, BandClassPriorityHRPD_sequence);

  return offset;
}


static const per_sequence_t BandClassPriorityListHRPD_sequence_of[1] = {
  { &hf_lte_rrc_BandClassPriorityListHRPD_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_BandClassPriorityHRPD },
};

static int
dissect_lte_rrc_BandClassPriorityListHRPD(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_lte_rrc_BandClassPriorityListHRPD, BandClassPriorityListHRPD_sequence_of,
                                                  1, maxCDMA_BandClass, FALSE);

  return offset;
}


static const per_sequence_t BandClassPriority1XRTT_sequence[] = {
  { &hf_lte_rrc_bandClass   , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_BandclassCDMA2000 },
  { &hf_lte_rrc_cellReselectionPriority, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_CellReselectionPriority },
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_BandClassPriority1XRTT(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_BandClassPriority1XRTT, BandClassPriority1XRTT_sequence);

  return offset;
}


static const per_sequence_t BandClassPriorityList1XRTT_sequence_of[1] = {
  { &hf_lte_rrc_BandClassPriorityList1XRTT_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_BandClassPriority1XRTT },
};

static int
dissect_lte_rrc_BandClassPriorityList1XRTT(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_lte_rrc_BandClassPriorityList1XRTT, BandClassPriorityList1XRTT_sequence_of,
                                                  1, maxCDMA_BandClass, FALSE);

  return offset;
}


static const value_string lte_rrc_T_t320_vals[] = {
  {   0, "min5" },
  {   1, "min10" },
  {   2, "min20" },
  {   3, "min30" },
  {   4, "min60" },
  {   5, "min120" },
  {   6, "min180" },
  {   7, "spare1" },
  { 0, NULL }
};


static int
dissect_lte_rrc_T_t320(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     8, NULL, FALSE, 0, NULL);

  return offset;
}


static const per_sequence_t IdleModeMobilityControlInfo_sequence[] = {
  { &hf_lte_rrc_freqPriorityListEUTRA, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lte_rrc_FreqPriorityListEUTRA },
  { &hf_lte_rrc_freqPriorityListGERAN, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lte_rrc_FreqsPriorityListGERAN },
  { &hf_lte_rrc_freqPriorityListUTRA_FDD, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lte_rrc_FreqPriorityListUTRA_FDD },
  { &hf_lte_rrc_freqPriorityListUTRA_TDD, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lte_rrc_FreqPriorityListUTRA_TDD },
  { &hf_lte_rrc_bandClassPriorityListHRPD, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lte_rrc_BandClassPriorityListHRPD },
  { &hf_lte_rrc_bandClassPriorityList1XRTT, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lte_rrc_BandClassPriorityList1XRTT },
  { &hf_lte_rrc_t320        , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lte_rrc_T_t320 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_IdleModeMobilityControlInfo(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_IdleModeMobilityControlInfo, IdleModeMobilityControlInfo_sequence);

  return offset;
}


static const per_sequence_t CellInfoGERAN_r9_sequence[] = {
  { &hf_lte_rrc_physCellId_r9, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_PhysCellIdGERAN },
  { &hf_lte_rrc_carrierFreq_r9_01, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_CarrierFreqGERAN },
  { &hf_lte_rrc_systemInformation_r9, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_SystemInfoListGERAN },
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_CellInfoGERAN_r9(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  lte_rrc_si_or_psi_geran_val = 0; /* SI message */
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_CellInfoGERAN_r9, CellInfoGERAN_r9_sequence);



  return offset;
}


static const per_sequence_t CellInfoListGERAN_r9_sequence_of[1] = {
  { &hf_lte_rrc_CellInfoListGERAN_r9_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_CellInfoGERAN_r9 },
};

static int
dissect_lte_rrc_CellInfoListGERAN_r9(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_lte_rrc_CellInfoListGERAN_r9, CellInfoListGERAN_r9_sequence_of,
                                                  1, maxCellInfoGERAN_r9, FALSE);

  return offset;
}



static int
dissect_lte_rrc_T_utra_BCCH_Container_r9(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  tvbuff_t *utra_bcch_cont_tvb = NULL;
  offset = dissect_per_octet_string(tvb, offset, actx, tree, hf_index,
                                       NO_BOUND, NO_BOUND, FALSE, &utra_bcch_cont_tvb);

  if (utra_bcch_cont_tvb && rrc_sys_info_cont_handle)
    call_dissector(rrc_sys_info_cont_handle, utra_bcch_cont_tvb, actx->pinfo, tree);


  return offset;
}


static const per_sequence_t CellInfoUTRA_FDD_r9_sequence[] = {
  { &hf_lte_rrc_physCellId_r9_01, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_PhysCellIdUTRA_FDD },
  { &hf_lte_rrc_utra_BCCH_Container_r9, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_T_utra_BCCH_Container_r9 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_CellInfoUTRA_FDD_r9(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_CellInfoUTRA_FDD_r9, CellInfoUTRA_FDD_r9_sequence);

  return offset;
}


static const per_sequence_t CellInfoListUTRA_FDD_r9_sequence_of[1] = {
  { &hf_lte_rrc_CellInfoListUTRA_FDD_r9_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_CellInfoUTRA_FDD_r9 },
};

static int
dissect_lte_rrc_CellInfoListUTRA_FDD_r9(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_lte_rrc_CellInfoListUTRA_FDD_r9, CellInfoListUTRA_FDD_r9_sequence_of,
                                                  1, maxCellInfoUTRA_r9, FALSE);

  return offset;
}



static int
dissect_lte_rrc_T_utra_BCCH_Container_r9_01(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  tvbuff_t *utra_bcch_cont_tvb = NULL;
  offset = dissect_per_octet_string(tvb, offset, actx, tree, hf_index,
                                       NO_BOUND, NO_BOUND, FALSE, &utra_bcch_cont_tvb);

  if (utra_bcch_cont_tvb && rrc_sys_info_cont_handle)
    call_dissector(rrc_sys_info_cont_handle, utra_bcch_cont_tvb, actx->pinfo, tree);


  return offset;
}


static const per_sequence_t CellInfoUTRA_TDD_r9_sequence[] = {
  { &hf_lte_rrc_physCellId_r9_02, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_PhysCellIdUTRA_TDD },
  { &hf_lte_rrc_utra_BCCH_Container_r9_01, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_T_utra_BCCH_Container_r9_01 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_CellInfoUTRA_TDD_r9(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_CellInfoUTRA_TDD_r9, CellInfoUTRA_TDD_r9_sequence);

  return offset;
}


static const per_sequence_t CellInfoListUTRA_TDD_r9_sequence_of[1] = {
  { &hf_lte_rrc_CellInfoListUTRA_TDD_r9_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_CellInfoUTRA_TDD_r9 },
};

static int
dissect_lte_rrc_CellInfoListUTRA_TDD_r9(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_lte_rrc_CellInfoListUTRA_TDD_r9, CellInfoListUTRA_TDD_r9_sequence_of,
                                                  1, maxCellInfoUTRA_r9, FALSE);

  return offset;
}


static const per_sequence_t CellInfoUTRA_TDD_r10_sequence[] = {
  { &hf_lte_rrc_physCellId_r10_01, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_PhysCellIdUTRA_TDD },
  { &hf_lte_rrc_carrierFreq_r10_01, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_ARFCN_ValueUTRA },
  { &hf_lte_rrc_utra_BCCH_Container_r10, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_OCTET_STRING },
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_CellInfoUTRA_TDD_r10(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_CellInfoUTRA_TDD_r10, CellInfoUTRA_TDD_r10_sequence);

  return offset;
}


static const per_sequence_t CellInfoListUTRA_TDD_r10_sequence_of[1] = {
  { &hf_lte_rrc_CellInfoListUTRA_TDD_r10_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_CellInfoUTRA_TDD_r10 },
};

static int
dissect_lte_rrc_CellInfoListUTRA_TDD_r10(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_lte_rrc_CellInfoListUTRA_TDD_r10, CellInfoListUTRA_TDD_r10_sequence_of,
                                                  1, maxCellInfoUTRA_r9, FALSE);

  return offset;
}


static const value_string lte_rrc_T_cellInfoList_r9_vals[] = {
  {   0, "geran-r9" },
  {   1, "utra-FDD-r9" },
  {   2, "utra-TDD-r9" },
  {   3, "utra-TDD-r10" },
  { 0, NULL }
};

static const per_choice_t T_cellInfoList_r9_choice[] = {
  {   0, &hf_lte_rrc_geran_r9    , ASN1_EXTENSION_ROOT    , dissect_lte_rrc_CellInfoListGERAN_r9 },
  {   1, &hf_lte_rrc_utra_FDD_r9 , ASN1_EXTENSION_ROOT    , dissect_lte_rrc_CellInfoListUTRA_FDD_r9 },
  {   2, &hf_lte_rrc_utra_TDD_r9 , ASN1_EXTENSION_ROOT    , dissect_lte_rrc_CellInfoListUTRA_TDD_r9 },
  {   3, &hf_lte_rrc_utra_TDD_r10, ASN1_NOT_EXTENSION_ROOT, dissect_lte_rrc_CellInfoListUTRA_TDD_r10 },
  { 0, NULL, 0, NULL }
};

static int
dissect_lte_rrc_T_cellInfoList_r9(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_lte_rrc_T_cellInfoList_r9, T_cellInfoList_r9_choice,
                                 NULL);

  return offset;
}



static int
dissect_lte_rrc_T_extendedWaitTime_r10_01(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            1U, 1800U, NULL, FALSE);

  proto_item_append_text(actx->created_item, "s");


  return offset;
}


static const per_sequence_t T_nonCriticalExtension_24_sequence[] = {
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_T_nonCriticalExtension_24(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_T_nonCriticalExtension_24, T_nonCriticalExtension_24_sequence);

  return offset;
}


static const per_sequence_t RRCConnectionRelease_v1020_IEs_sequence[] = {
  { &hf_lte_rrc_extendedWaitTime_r10_01, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lte_rrc_T_extendedWaitTime_r10_01 },
  { &hf_lte_rrc_nonCriticalExtension_56, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lte_rrc_T_nonCriticalExtension_24 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_RRCConnectionRelease_v1020_IEs(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_RRCConnectionRelease_v1020_IEs, RRCConnectionRelease_v1020_IEs_sequence);

  return offset;
}


static const per_sequence_t RRCConnectionRelease_v920_IEs_sequence[] = {
  { &hf_lte_rrc_cellInfoList_r9, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lte_rrc_T_cellInfoList_r9 },
  { &hf_lte_rrc_nonCriticalExtension_55, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lte_rrc_RRCConnectionRelease_v1020_IEs },
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_RRCConnectionRelease_v920_IEs(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_RRCConnectionRelease_v920_IEs, RRCConnectionRelease_v920_IEs_sequence);

  return offset;
}


static const per_sequence_t RRCConnectionRelease_v890_IEs_sequence[] = {
  { &hf_lte_rrc_lateNonCriticalExtension, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lte_rrc_OCTET_STRING },
  { &hf_lte_rrc_nonCriticalExtension_54, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lte_rrc_RRCConnectionRelease_v920_IEs },
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_RRCConnectionRelease_v890_IEs(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_RRCConnectionRelease_v890_IEs, RRCConnectionRelease_v890_IEs_sequence);

  return offset;
}


static const per_sequence_t RRCConnectionRelease_r8_IEs_sequence[] = {
  { &hf_lte_rrc_releaseCause, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_ReleaseCause },
  { &hf_lte_rrc_redirectedCarrierInfo, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lte_rrc_RedirectedCarrierInfo },
  { &hf_lte_rrc_idleModeMobilityControlInfo, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lte_rrc_IdleModeMobilityControlInfo },
  { &hf_lte_rrc_nonCriticalExtension_53, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lte_rrc_RRCConnectionRelease_v890_IEs },
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_RRCConnectionRelease_r8_IEs(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_RRCConnectionRelease_r8_IEs, RRCConnectionRelease_r8_IEs_sequence);

  return offset;
}


static const value_string lte_rrc_T_c1_21_vals[] = {
  {   0, "rrcConnectionRelease-r8" },
  {   1, "spare3" },
  {   2, "spare2" },
  {   3, "spare1" },
  { 0, NULL }
};

static const per_choice_t T_c1_21_choice[] = {
  {   0, &hf_lte_rrc_rrcConnectionRelease_r8, ASN1_NO_EXTENSIONS     , dissect_lte_rrc_RRCConnectionRelease_r8_IEs },
  {   1, &hf_lte_rrc_spare3      , ASN1_NO_EXTENSIONS     , dissect_lte_rrc_NULL },
  {   2, &hf_lte_rrc_spare2      , ASN1_NO_EXTENSIONS     , dissect_lte_rrc_NULL },
  {   3, &hf_lte_rrc_spare1      , ASN1_NO_EXTENSIONS     , dissect_lte_rrc_NULL },
  { 0, NULL, 0, NULL }
};

static int
dissect_lte_rrc_T_c1_21(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_lte_rrc_T_c1_21, T_c1_21_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t T_criticalExtensionsFuture_21_sequence[] = {
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_T_criticalExtensionsFuture_21(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_T_criticalExtensionsFuture_21, T_criticalExtensionsFuture_21_sequence);

  return offset;
}


static const value_string lte_rrc_T_criticalExtensions_21_vals[] = {
  {   0, "c1" },
  {   1, "criticalExtensionsFuture" },
  { 0, NULL }
};

static const per_choice_t T_criticalExtensions_21_choice[] = {
  {   0, &hf_lte_rrc_c1_21       , ASN1_NO_EXTENSIONS     , dissect_lte_rrc_T_c1_21 },
  {   1, &hf_lte_rrc_criticalExtensionsFuture_21, ASN1_NO_EXTENSIONS     , dissect_lte_rrc_T_criticalExtensionsFuture_21 },
  { 0, NULL, 0, NULL }
};

static int
dissect_lte_rrc_T_criticalExtensions_21(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_lte_rrc_T_criticalExtensions_21, T_criticalExtensions_21_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t RRCConnectionRelease_sequence[] = {
  { &hf_lte_rrc_rrc_TransactionIdentifier, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_RRC_TransactionIdentifier },
  { &hf_lte_rrc_criticalExtensions_21, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_T_criticalExtensions_21 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_RRCConnectionRelease(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {

col_append_str(actx->pinfo->cinfo, COL_INFO, "RRCConnectionRelease ");

  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_RRCConnectionRelease, RRCConnectionRelease_sequence);

  return offset;
}


static const per_sequence_t SecurityConfigSMC_sequence[] = {
  { &hf_lte_rrc_securityAlgorithmConfig, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lte_rrc_SecurityAlgorithmConfig },
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_SecurityConfigSMC(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_SecurityConfigSMC, SecurityConfigSMC_sequence);

  return offset;
}


static const per_sequence_t T_nonCriticalExtension_27_sequence[] = {
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_T_nonCriticalExtension_27(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_T_nonCriticalExtension_27, T_nonCriticalExtension_27_sequence);

  return offset;
}


static const per_sequence_t SecurityModeCommand_v8a0_IEs_sequence[] = {
  { &hf_lte_rrc_lateNonCriticalExtension, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lte_rrc_OCTET_STRING },
  { &hf_lte_rrc_nonCriticalExtension_63, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lte_rrc_T_nonCriticalExtension_27 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_SecurityModeCommand_v8a0_IEs(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_SecurityModeCommand_v8a0_IEs, SecurityModeCommand_v8a0_IEs_sequence);

  return offset;
}


static const per_sequence_t SecurityModeCommand_r8_IEs_sequence[] = {
  { &hf_lte_rrc_securityConfigSMC, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_SecurityConfigSMC },
  { &hf_lte_rrc_nonCriticalExtension_62, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lte_rrc_SecurityModeCommand_v8a0_IEs },
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_SecurityModeCommand_r8_IEs(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_SecurityModeCommand_r8_IEs, SecurityModeCommand_r8_IEs_sequence);

  return offset;
}


static const value_string lte_rrc_T_c1_24_vals[] = {
  {   0, "securityModeCommand-r8" },
  {   1, "spare3" },
  {   2, "spare2" },
  {   3, "spare1" },
  { 0, NULL }
};

static const per_choice_t T_c1_24_choice[] = {
  {   0, &hf_lte_rrc_securityModeCommand_r8, ASN1_NO_EXTENSIONS     , dissect_lte_rrc_SecurityModeCommand_r8_IEs },
  {   1, &hf_lte_rrc_spare3      , ASN1_NO_EXTENSIONS     , dissect_lte_rrc_NULL },
  {   2, &hf_lte_rrc_spare2      , ASN1_NO_EXTENSIONS     , dissect_lte_rrc_NULL },
  {   3, &hf_lte_rrc_spare1      , ASN1_NO_EXTENSIONS     , dissect_lte_rrc_NULL },
  { 0, NULL, 0, NULL }
};

static int
dissect_lte_rrc_T_c1_24(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_lte_rrc_T_c1_24, T_c1_24_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t T_criticalExtensionsFuture_25_sequence[] = {
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_T_criticalExtensionsFuture_25(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_T_criticalExtensionsFuture_25, T_criticalExtensionsFuture_25_sequence);

  return offset;
}


static const value_string lte_rrc_T_criticalExtensions_25_vals[] = {
  {   0, "c1" },
  {   1, "criticalExtensionsFuture" },
  { 0, NULL }
};

static const per_choice_t T_criticalExtensions_25_choice[] = {
  {   0, &hf_lte_rrc_c1_24       , ASN1_NO_EXTENSIONS     , dissect_lte_rrc_T_c1_24 },
  {   1, &hf_lte_rrc_criticalExtensionsFuture_25, ASN1_NO_EXTENSIONS     , dissect_lte_rrc_T_criticalExtensionsFuture_25 },
  { 0, NULL, 0, NULL }
};

static int
dissect_lte_rrc_T_criticalExtensions_25(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_lte_rrc_T_criticalExtensions_25, T_criticalExtensions_25_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t SecurityModeCommand_sequence[] = {
  { &hf_lte_rrc_rrc_TransactionIdentifier, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_RRC_TransactionIdentifier },
  { &hf_lte_rrc_criticalExtensions_25, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_T_criticalExtensions_25 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_SecurityModeCommand(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {

col_append_str(actx->pinfo->cinfo, COL_INFO, "SecurityModeCommand ");

  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_SecurityModeCommand, SecurityModeCommand_sequence);

  return offset;
}


static const value_string lte_rrc_RAT_Type_vals[] = {
  {   0, "eutra" },
  {   1, "utra" },
  {   2, "geran-cs" },
  {   3, "geran-ps" },
  {   4, "cdma2000-1XRTT" },
  {   5, "spare3" },
  {   6, "spare2" },
  {   7, "spare1" },
  { 0, NULL }
};


static int
dissect_lte_rrc_RAT_Type(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     8, &lte_rrc_rat_type_value, TRUE, 0, NULL);




  return offset;
}


static const per_sequence_t UE_CapabilityRequest_sequence_of[1] = {
  { &hf_lte_rrc_UE_CapabilityRequest_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_RAT_Type },
};

static int
dissect_lte_rrc_UE_CapabilityRequest(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_lte_rrc_UE_CapabilityRequest, UE_CapabilityRequest_sequence_of,
                                                  1, maxRAT_Capabilities, FALSE);

  return offset;
}


static const per_sequence_t T_nonCriticalExtension_32_sequence[] = {
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_T_nonCriticalExtension_32(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_T_nonCriticalExtension_32, T_nonCriticalExtension_32_sequence);

  return offset;
}


static const per_sequence_t UECapabilityEnquiry_v8a0_IEs_sequence[] = {
  { &hf_lte_rrc_lateNonCriticalExtension, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lte_rrc_OCTET_STRING },
  { &hf_lte_rrc_nonCriticalExtension_74, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lte_rrc_T_nonCriticalExtension_32 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_UECapabilityEnquiry_v8a0_IEs(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_UECapabilityEnquiry_v8a0_IEs, UECapabilityEnquiry_v8a0_IEs_sequence);

  return offset;
}


static const per_sequence_t UECapabilityEnquiry_r8_IEs_sequence[] = {
  { &hf_lte_rrc_ue_CapabilityRequest, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_UE_CapabilityRequest },
  { &hf_lte_rrc_nonCriticalExtension_73, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lte_rrc_UECapabilityEnquiry_v8a0_IEs },
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_UECapabilityEnquiry_r8_IEs(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_UECapabilityEnquiry_r8_IEs, UECapabilityEnquiry_r8_IEs_sequence);

  return offset;
}


static const value_string lte_rrc_T_c1_25_vals[] = {
  {   0, "ueCapabilityEnquiry-r8" },
  {   1, "spare3" },
  {   2, "spare2" },
  {   3, "spare1" },
  { 0, NULL }
};

static const per_choice_t T_c1_25_choice[] = {
  {   0, &hf_lte_rrc_ueCapabilityEnquiry_r8, ASN1_NO_EXTENSIONS     , dissect_lte_rrc_UECapabilityEnquiry_r8_IEs },
  {   1, &hf_lte_rrc_spare3      , ASN1_NO_EXTENSIONS     , dissect_lte_rrc_NULL },
  {   2, &hf_lte_rrc_spare2      , ASN1_NO_EXTENSIONS     , dissect_lte_rrc_NULL },
  {   3, &hf_lte_rrc_spare1      , ASN1_NO_EXTENSIONS     , dissect_lte_rrc_NULL },
  { 0, NULL, 0, NULL }
};

static int
dissect_lte_rrc_T_c1_25(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_lte_rrc_T_c1_25, T_c1_25_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t T_criticalExtensionsFuture_29_sequence[] = {
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_T_criticalExtensionsFuture_29(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_T_criticalExtensionsFuture_29, T_criticalExtensionsFuture_29_sequence);

  return offset;
}


static const value_string lte_rrc_T_criticalExtensions_29_vals[] = {
  {   0, "c1" },
  {   1, "criticalExtensionsFuture" },
  { 0, NULL }
};

static const per_choice_t T_criticalExtensions_29_choice[] = {
  {   0, &hf_lte_rrc_c1_25       , ASN1_NO_EXTENSIONS     , dissect_lte_rrc_T_c1_25 },
  {   1, &hf_lte_rrc_criticalExtensionsFuture_29, ASN1_NO_EXTENSIONS     , dissect_lte_rrc_T_criticalExtensionsFuture_29 },
  { 0, NULL, 0, NULL }
};

static int
dissect_lte_rrc_T_criticalExtensions_29(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_lte_rrc_T_criticalExtensions_29, T_criticalExtensions_29_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t UECapabilityEnquiry_sequence[] = {
  { &hf_lte_rrc_rrc_TransactionIdentifier, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_RRC_TransactionIdentifier },
  { &hf_lte_rrc_criticalExtensions_29, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_T_criticalExtensions_29 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_UECapabilityEnquiry(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {

col_append_str(actx->pinfo->cinfo, COL_INFO, "UECapabilityEnquiry ");

  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_UECapabilityEnquiry, UECapabilityEnquiry_sequence);

  return offset;
}



static int
dissect_lte_rrc_INTEGER_0_33554431(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 33554431U, NULL, FALSE);

  return offset;
}


static const per_sequence_t DRB_CountMSB_Info_sequence[] = {
  { &hf_lte_rrc_drb_Identity, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_DRB_Identity },
  { &hf_lte_rrc_countMSB_Uplink, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_INTEGER_0_33554431 },
  { &hf_lte_rrc_countMSB_Downlink, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_INTEGER_0_33554431 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_DRB_CountMSB_Info(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_DRB_CountMSB_Info, DRB_CountMSB_Info_sequence);

  return offset;
}


static const per_sequence_t DRB_CountMSB_InfoList_sequence_of[1] = {
  { &hf_lte_rrc_DRB_CountMSB_InfoList_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_DRB_CountMSB_Info },
};

static int
dissect_lte_rrc_DRB_CountMSB_InfoList(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_lte_rrc_DRB_CountMSB_InfoList, DRB_CountMSB_InfoList_sequence_of,
                                                  1, maxDRB, FALSE);

  return offset;
}


static const per_sequence_t T_nonCriticalExtension_sequence[] = {
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_T_nonCriticalExtension(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_T_nonCriticalExtension, T_nonCriticalExtension_sequence);

  return offset;
}


static const per_sequence_t CounterCheck_v8a0_IEs_sequence[] = {
  { &hf_lte_rrc_lateNonCriticalExtension, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lte_rrc_OCTET_STRING },
  { &hf_lte_rrc_nonCriticalExtension_01, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lte_rrc_T_nonCriticalExtension },
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_CounterCheck_v8a0_IEs(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_CounterCheck_v8a0_IEs, CounterCheck_v8a0_IEs_sequence);

  return offset;
}


static const per_sequence_t CounterCheck_r8_IEs_sequence[] = {
  { &hf_lte_rrc_drb_CountMSB_InfoList, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_DRB_CountMSB_InfoList },
  { &hf_lte_rrc_nonCriticalExtension, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lte_rrc_CounterCheck_v8a0_IEs },
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_CounterCheck_r8_IEs(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_CounterCheck_r8_IEs, CounterCheck_r8_IEs_sequence);

  return offset;
}


static const value_string lte_rrc_T_c1_07_vals[] = {
  {   0, "counterCheck-r8" },
  {   1, "spare3" },
  {   2, "spare2" },
  {   3, "spare1" },
  { 0, NULL }
};

static const per_choice_t T_c1_07_choice[] = {
  {   0, &hf_lte_rrc_counterCheck_r8, ASN1_NO_EXTENSIONS     , dissect_lte_rrc_CounterCheck_r8_IEs },
  {   1, &hf_lte_rrc_spare3      , ASN1_NO_EXTENSIONS     , dissect_lte_rrc_NULL },
  {   2, &hf_lte_rrc_spare2      , ASN1_NO_EXTENSIONS     , dissect_lte_rrc_NULL },
  {   3, &hf_lte_rrc_spare1      , ASN1_NO_EXTENSIONS     , dissect_lte_rrc_NULL },
  { 0, NULL, 0, NULL }
};

static int
dissect_lte_rrc_T_c1_07(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_lte_rrc_T_c1_07, T_c1_07_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t T_criticalExtensionsFuture_sequence[] = {
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_T_criticalExtensionsFuture(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_T_criticalExtensionsFuture, T_criticalExtensionsFuture_sequence);

  return offset;
}


static const value_string lte_rrc_T_criticalExtensions_vals[] = {
  {   0, "c1" },
  {   1, "criticalExtensionsFuture" },
  { 0, NULL }
};

static const per_choice_t T_criticalExtensions_choice[] = {
  {   0, &hf_lte_rrc_c1_07       , ASN1_NO_EXTENSIONS     , dissect_lte_rrc_T_c1_07 },
  {   1, &hf_lte_rrc_criticalExtensionsFuture, ASN1_NO_EXTENSIONS     , dissect_lte_rrc_T_criticalExtensionsFuture },
  { 0, NULL, 0, NULL }
};

static int
dissect_lte_rrc_T_criticalExtensions(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_lte_rrc_T_criticalExtensions, T_criticalExtensions_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t CounterCheck_sequence[] = {
  { &hf_lte_rrc_rrc_TransactionIdentifier, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_RRC_TransactionIdentifier },
  { &hf_lte_rrc_criticalExtensions, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_T_criticalExtensions },
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_CounterCheck(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {

col_append_str(actx->pinfo->cinfo, COL_INFO, "CounterCheck ");

  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_CounterCheck, CounterCheck_sequence);

  return offset;
}


static const value_string lte_rrc_T_logMeasReportReq_r10_vals[] = {
  {   0, "true" },
  { 0, NULL }
};


static int
dissect_lte_rrc_T_logMeasReportReq_r10(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, FALSE, 0, NULL);

  return offset;
}


static const per_sequence_t T_nonCriticalExtension_34_sequence[] = {
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_T_nonCriticalExtension_34(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_T_nonCriticalExtension_34, T_nonCriticalExtension_34_sequence);

  return offset;
}


static const per_sequence_t UEInformationRequest_v1020_IEs_sequence[] = {
  { &hf_lte_rrc_logMeasReportReq_r10, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lte_rrc_T_logMeasReportReq_r10 },
  { &hf_lte_rrc_nonCriticalExtension_79, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lte_rrc_T_nonCriticalExtension_34 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_UEInformationRequest_v1020_IEs(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_UEInformationRequest_v1020_IEs, UEInformationRequest_v1020_IEs_sequence);

  return offset;
}


static const per_sequence_t UEInformationRequest_v930_IEs_sequence[] = {
  { &hf_lte_rrc_lateNonCriticalExtension, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lte_rrc_OCTET_STRING },
  { &hf_lte_rrc_nonCriticalExtension_78, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lte_rrc_UEInformationRequest_v1020_IEs },
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_UEInformationRequest_v930_IEs(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_UEInformationRequest_v930_IEs, UEInformationRequest_v930_IEs_sequence);

  return offset;
}


static const per_sequence_t UEInformationRequest_r9_IEs_sequence[] = {
  { &hf_lte_rrc_rach_ReportReq_r9, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_BOOLEAN },
  { &hf_lte_rrc_rlf_ReportReq_r9, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_BOOLEAN },
  { &hf_lte_rrc_nonCriticalExtension_77, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lte_rrc_UEInformationRequest_v930_IEs },
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_UEInformationRequest_r9_IEs(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_UEInformationRequest_r9_IEs, UEInformationRequest_r9_IEs_sequence);

  return offset;
}


static const value_string lte_rrc_T_c1_27_vals[] = {
  {   0, "ueInformationRequest-r9" },
  {   1, "spare3" },
  {   2, "spare2" },
  {   3, "spare1" },
  { 0, NULL }
};

static const per_choice_t T_c1_27_choice[] = {
  {   0, &hf_lte_rrc_ueInformationRequest_r9_01, ASN1_NO_EXTENSIONS     , dissect_lte_rrc_UEInformationRequest_r9_IEs },
  {   1, &hf_lte_rrc_spare3      , ASN1_NO_EXTENSIONS     , dissect_lte_rrc_NULL },
  {   2, &hf_lte_rrc_spare2      , ASN1_NO_EXTENSIONS     , dissect_lte_rrc_NULL },
  {   3, &hf_lte_rrc_spare1      , ASN1_NO_EXTENSIONS     , dissect_lte_rrc_NULL },
  { 0, NULL, 0, NULL }
};

static int
dissect_lte_rrc_T_c1_27(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_lte_rrc_T_c1_27, T_c1_27_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t T_criticalExtensionsFuture_31_sequence[] = {
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_T_criticalExtensionsFuture_31(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_T_criticalExtensionsFuture_31, T_criticalExtensionsFuture_31_sequence);

  return offset;
}


static const value_string lte_rrc_T_criticalExtensions_31_vals[] = {
  {   0, "c1" },
  {   1, "criticalExtensionsFuture" },
  { 0, NULL }
};

static const per_choice_t T_criticalExtensions_31_choice[] = {
  {   0, &hf_lte_rrc_c1_27       , ASN1_NO_EXTENSIONS     , dissect_lte_rrc_T_c1_27 },
  {   1, &hf_lte_rrc_criticalExtensionsFuture_31, ASN1_NO_EXTENSIONS     , dissect_lte_rrc_T_criticalExtensionsFuture_31 },
  { 0, NULL, 0, NULL }
};

static int
dissect_lte_rrc_T_criticalExtensions_31(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_lte_rrc_T_criticalExtensions_31, T_criticalExtensions_31_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t UEInformationRequest_r9_sequence[] = {
  { &hf_lte_rrc_rrc_TransactionIdentifier, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_RRC_TransactionIdentifier },
  { &hf_lte_rrc_criticalExtensions_31, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_T_criticalExtensions_31 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_UEInformationRequest_r9(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {

col_append_str(actx->pinfo->cinfo, COL_INFO, "UEInformationRequest-r9 ");

  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_UEInformationRequest_r9, UEInformationRequest_r9_sequence);

  return offset;
}


static const per_sequence_t TraceReference_r10_sequence[] = {
  { &hf_lte_rrc_plmn_Identity_r10, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_PLMN_Identity },
  { &hf_lte_rrc_traceId_r10 , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_OCTET_STRING_SIZE_3 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_TraceReference_r10(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_TraceReference_r10, TraceReference_r10_sequence);

  return offset;
}



static int
dissect_lte_rrc_AbsoluteTimeInfo_r10(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  tvbuff_t *abs_time_info_tvb = NULL;
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     48, 48, FALSE, &abs_time_info_tvb);


  if (abs_time_info_tvb) {
    const gchar *str;
    proto_tree *subtree;
    subtree = proto_item_add_subtree(actx->created_item, ett_lte_rrc_neighCellConfig);
    str = tvb_bcd_dig_to_ep_str(abs_time_info_tvb, 0, 6, NULL, FALSE);
    proto_tree_add_text(subtree, abs_time_info_tvb, 0, 6, "%c%c-%c%c-%c%c %c%c:%c%c:%c%c", str[0], str[1],
                        str[2], str[3], str[4], str[5], str[6], str[7], str[8], str[9], str[10], str[11]);
  } 

  return offset;
}


static const per_sequence_t CellGlobalIdEUTRA_sequence[] = {
  { &hf_lte_rrc_plmn_Identity, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_PLMN_Identity },
  { &hf_lte_rrc_cellIdentity, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_CellIdentity },
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_CellGlobalIdEUTRA(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_CellGlobalIdEUTRA, CellGlobalIdEUTRA_sequence);

  return offset;
}


static const per_sequence_t CellGlobalIdList_r10_sequence_of[1] = {
  { &hf_lte_rrc_CellGlobalIdList_r10_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_CellGlobalIdEUTRA },
};

static int
dissect_lte_rrc_CellGlobalIdList_r10(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_lte_rrc_CellGlobalIdList_r10, CellGlobalIdList_r10_sequence_of,
                                                  1, 32, FALSE);

  return offset;
}


static const per_sequence_t TrackingAreaCodeList_r10_sequence_of[1] = {
  { &hf_lte_rrc_TrackingAreaCodeList_r10_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_TrackingAreaCode },
};

static int
dissect_lte_rrc_TrackingAreaCodeList_r10(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_lte_rrc_TrackingAreaCodeList_r10, TrackingAreaCodeList_r10_sequence_of,
                                                  1, 8, FALSE);

  return offset;
}


static const value_string lte_rrc_AreaConfiguration_r10_vals[] = {
  {   0, "cellGlobalIdList-r10" },
  {   1, "trackingAreaCodeList-r10" },
  { 0, NULL }
};

static const per_choice_t AreaConfiguration_r10_choice[] = {
  {   0, &hf_lte_rrc_cellGlobalIdList_r10, ASN1_NO_EXTENSIONS     , dissect_lte_rrc_CellGlobalIdList_r10 },
  {   1, &hf_lte_rrc_trackingAreaCodeList_r10, ASN1_NO_EXTENSIONS     , dissect_lte_rrc_TrackingAreaCodeList_r10 },
  { 0, NULL, 0, NULL }
};

static int
dissect_lte_rrc_AreaConfiguration_r10(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_lte_rrc_AreaConfiguration_r10, AreaConfiguration_r10_choice,
                                 NULL);

  return offset;
}


static const value_string lte_rrc_LoggingDuration_r10_vals[] = {
  {   0, "min10" },
  {   1, "min20" },
  {   2, "min40" },
  {   3, "min60" },
  {   4, "min90" },
  {   5, "min120" },
  {   6, "spare2" },
  {   7, "spare1" },
  { 0, NULL }
};


static int
dissect_lte_rrc_LoggingDuration_r10(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     8, NULL, FALSE, 0, NULL);

  return offset;
}


static const value_string lte_rrc_LoggingInterval_r10_vals[] = {
  {   0, "ms1280" },
  {   1, "ms2560" },
  {   2, "ms5120" },
  {   3, "ms10240" },
  {   4, "ms20480" },
  {   5, "ms30720" },
  {   6, "ms40960" },
  {   7, "ms61440" },
  { 0, NULL }
};


static int
dissect_lte_rrc_LoggingInterval_r10(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     8, NULL, FALSE, 0, NULL);

  return offset;
}


static const per_sequence_t T_nonCriticalExtension_07_sequence[] = {
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_T_nonCriticalExtension_07(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_T_nonCriticalExtension_07, T_nonCriticalExtension_07_sequence);

  return offset;
}


static const per_sequence_t LoggedMeasurementConfiguration_r10_IEs_sequence[] = {
  { &hf_lte_rrc_traceReference_r10, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_TraceReference_r10 },
  { &hf_lte_rrc_traceRecordingSessionRef_r10, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_OCTET_STRING_SIZE_2 },
  { &hf_lte_rrc_tce_Id_r10  , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_OCTET_STRING_SIZE_1 },
  { &hf_lte_rrc_absoluteTimeInfo_r10, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_AbsoluteTimeInfo_r10 },
  { &hf_lte_rrc_areaConfiguration_r10, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lte_rrc_AreaConfiguration_r10 },
  { &hf_lte_rrc_loggingDuration_r10, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_LoggingDuration_r10 },
  { &hf_lte_rrc_loggingInterval_r10, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_LoggingInterval_r10 },
  { &hf_lte_rrc_nonCriticalExtension_15, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lte_rrc_T_nonCriticalExtension_07 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_LoggedMeasurementConfiguration_r10_IEs(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_LoggedMeasurementConfiguration_r10_IEs, LoggedMeasurementConfiguration_r10_IEs_sequence);

  return offset;
}


static const value_string lte_rrc_T_c1_11_vals[] = {
  {   0, "loggedMeasurementConfiguration-r10" },
  {   1, "spare3" },
  {   2, "spare2" },
  {   3, "spare1" },
  { 0, NULL }
};

static const per_choice_t T_c1_11_choice[] = {
  {   0, &hf_lte_rrc_loggedMeasurementConfiguration_r10_01, ASN1_NO_EXTENSIONS     , dissect_lte_rrc_LoggedMeasurementConfiguration_r10_IEs },
  {   1, &hf_lte_rrc_spare3      , ASN1_NO_EXTENSIONS     , dissect_lte_rrc_NULL },
  {   2, &hf_lte_rrc_spare2      , ASN1_NO_EXTENSIONS     , dissect_lte_rrc_NULL },
  {   3, &hf_lte_rrc_spare1      , ASN1_NO_EXTENSIONS     , dissect_lte_rrc_NULL },
  { 0, NULL, 0, NULL }
};

static int
dissect_lte_rrc_T_c1_11(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_lte_rrc_T_c1_11, T_c1_11_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t T_criticalExtensionsFuture_07_sequence[] = {
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_T_criticalExtensionsFuture_07(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_T_criticalExtensionsFuture_07, T_criticalExtensionsFuture_07_sequence);

  return offset;
}


static const value_string lte_rrc_T_criticalExtensions_07_vals[] = {
  {   0, "c1" },
  {   1, "criticalExtensionsFuture" },
  { 0, NULL }
};

static const per_choice_t T_criticalExtensions_07_choice[] = {
  {   0, &hf_lte_rrc_c1_11       , ASN1_NO_EXTENSIONS     , dissect_lte_rrc_T_c1_11 },
  {   1, &hf_lte_rrc_criticalExtensionsFuture_07, ASN1_NO_EXTENSIONS     , dissect_lte_rrc_T_criticalExtensionsFuture_07 },
  { 0, NULL, 0, NULL }
};

static int
dissect_lte_rrc_T_criticalExtensions_07(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_lte_rrc_T_criticalExtensions_07, T_criticalExtensions_07_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t LoggedMeasurementConfiguration_r10_sequence[] = {
  { &hf_lte_rrc_criticalExtensions_07, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_T_criticalExtensions_07 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_LoggedMeasurementConfiguration_r10(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {

col_append_str(actx->pinfo->cinfo, COL_INFO, "LoggedMeasurementConfiguration-r10 ");

  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_LoggedMeasurementConfiguration_r10, LoggedMeasurementConfiguration_r10_sequence);

  return offset;
}



static int
dissect_lte_rrc_T_systemInformationBlockType1_r10(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_octet_string_containing_pdu_new(tvb, offset, actx, tree, hf_index,
                                                                NO_BOUND, NO_BOUND, FALSE, dissect_SystemInformationBlockType1_PDU);

  return offset;
}


static const per_sequence_t RN_SystemInfo_r10_sequence[] = {
  { &hf_lte_rrc_systemInformationBlockType1_r10, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lte_rrc_T_systemInformationBlockType1_r10 },
  { &hf_lte_rrc_systemInformationBlockType2_r10, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lte_rrc_SystemInformationBlockType2 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_RN_SystemInfo_r10(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_RN_SystemInfo_r10, RN_SystemInfo_r10_sequence);

  return offset;
}


static const value_string lte_rrc_T_subframeConfigPattern_r10_vals[] = {
  {   0, "subframeConfigPatternFDD-r10" },
  {   1, "subframeConfigPatternTDD-r10" },
  { 0, NULL }
};

static const per_choice_t T_subframeConfigPattern_r10_choice[] = {
  {   0, &hf_lte_rrc_subframeConfigPatternFDD_r10, ASN1_NO_EXTENSIONS     , dissect_lte_rrc_BIT_STRING_SIZE_8 },
  {   1, &hf_lte_rrc_subframeConfigPatternTDD_r10, ASN1_NO_EXTENSIONS     , dissect_lte_rrc_INTEGER_0_31 },
  { 0, NULL, 0, NULL }
};

static int
dissect_lte_rrc_T_subframeConfigPattern_r10(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_lte_rrc_T_subframeConfigPattern_r10, T_subframeConfigPattern_r10_choice,
                                 NULL);

  return offset;
}


static const value_string lte_rrc_T_resourceAllocationType_r10_vals[] = {
  {   0, "type0" },
  {   1, "type1" },
  {   2, "type2Localized" },
  {   3, "type2Distributed" },
  {   4, "spare4" },
  {   5, "spare3" },
  {   6, "spare2" },
  {   7, "spare1" },
  { 0, NULL }
};


static int
dissect_lte_rrc_T_resourceAllocationType_r10(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     8, NULL, FALSE, 0, NULL);

  return offset;
}



static int
dissect_lte_rrc_BIT_STRING_SIZE_13(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     13, 13, FALSE, NULL);

  return offset;
}



static int
dissect_lte_rrc_BIT_STRING_SIZE_17(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     17, 17, FALSE, NULL);

  return offset;
}



static int
dissect_lte_rrc_BIT_STRING_SIZE_19(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     19, 19, FALSE, NULL);

  return offset;
}



static int
dissect_lte_rrc_BIT_STRING_SIZE_25(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     25, 25, FALSE, NULL);

  return offset;
}


static const value_string lte_rrc_T_type01_r10_vals[] = {
  {   0, "nrb6-r10" },
  {   1, "nrb15-r10" },
  {   2, "nrb25-r10" },
  {   3, "nrb50-r10" },
  {   4, "nrb75-r10" },
  {   5, "nrb100-r10" },
  { 0, NULL }
};

static const per_choice_t T_type01_r10_choice[] = {
  {   0, &hf_lte_rrc_nrb6_r10    , ASN1_NO_EXTENSIONS     , dissect_lte_rrc_BIT_STRING_SIZE_6 },
  {   1, &hf_lte_rrc_nrb15_r10   , ASN1_NO_EXTENSIONS     , dissect_lte_rrc_BIT_STRING_SIZE_8 },
  {   2, &hf_lte_rrc_nrb25_r10   , ASN1_NO_EXTENSIONS     , dissect_lte_rrc_BIT_STRING_SIZE_13 },
  {   3, &hf_lte_rrc_nrb50_r10   , ASN1_NO_EXTENSIONS     , dissect_lte_rrc_BIT_STRING_SIZE_17 },
  {   4, &hf_lte_rrc_nrb75_r10   , ASN1_NO_EXTENSIONS     , dissect_lte_rrc_BIT_STRING_SIZE_19 },
  {   5, &hf_lte_rrc_nrb100_r10  , ASN1_NO_EXTENSIONS     , dissect_lte_rrc_BIT_STRING_SIZE_25 },
  { 0, NULL, 0, NULL }
};

static int
dissect_lte_rrc_T_type01_r10(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_lte_rrc_T_type01_r10, T_type01_r10_choice,
                                 NULL);

  return offset;
}



static int
dissect_lte_rrc_BIT_STRING_SIZE_9(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     9, 9, FALSE, NULL);

  return offset;
}



static int
dissect_lte_rrc_BIT_STRING_SIZE_11(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     11, 11, FALSE, NULL);

  return offset;
}


static const value_string lte_rrc_T_type2_r10_vals[] = {
  {   0, "nrb6-r10" },
  {   1, "nrb15-r10" },
  {   2, "nrb25-r10" },
  {   3, "nrb50-r10" },
  {   4, "nrb75-r10" },
  {   5, "nrb100-r10" },
  { 0, NULL }
};

static const per_choice_t T_type2_r10_choice[] = {
  {   0, &hf_lte_rrc_nrb6_r10_01 , ASN1_NO_EXTENSIONS     , dissect_lte_rrc_BIT_STRING_SIZE_5 },
  {   1, &hf_lte_rrc_nrb15_r10_01, ASN1_NO_EXTENSIONS     , dissect_lte_rrc_BIT_STRING_SIZE_7 },
  {   2, &hf_lte_rrc_nrb25_r10_01, ASN1_NO_EXTENSIONS     , dissect_lte_rrc_BIT_STRING_SIZE_9 },
  {   3, &hf_lte_rrc_nrb50_r10_01, ASN1_NO_EXTENSIONS     , dissect_lte_rrc_BIT_STRING_SIZE_11 },
  {   4, &hf_lte_rrc_nrb75_r10_01, ASN1_NO_EXTENSIONS     , dissect_lte_rrc_BIT_STRING_SIZE_12 },
  {   5, &hf_lte_rrc_nrb100_r10_01, ASN1_NO_EXTENSIONS     , dissect_lte_rrc_BIT_STRING_SIZE_13 },
  { 0, NULL, 0, NULL }
};

static int
dissect_lte_rrc_T_type2_r10(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_lte_rrc_T_type2_r10, T_type2_r10_choice,
                                 NULL);

  return offset;
}


static const value_string lte_rrc_T_resourceBlockAssignment_r10_vals[] = {
  {   0, "type01-r10" },
  {   1, "type2-r10" },
  { 0, NULL }
};

static const per_choice_t T_resourceBlockAssignment_r10_choice[] = {
  {   0, &hf_lte_rrc_type01_r10  , ASN1_EXTENSION_ROOT    , dissect_lte_rrc_T_type01_r10 },
  {   1, &hf_lte_rrc_type2_r10   , ASN1_EXTENSION_ROOT    , dissect_lte_rrc_T_type2_r10 },
  { 0, NULL, 0, NULL }
};

static int
dissect_lte_rrc_T_resourceBlockAssignment_r10(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_lte_rrc_T_resourceBlockAssignment_r10, T_resourceBlockAssignment_r10_choice,
                                 NULL);

  return offset;
}


static const value_string lte_rrc_T_interleaving_r10_vals[] = {
  {   0, "crs" },
  { 0, NULL }
};


static int
dissect_lte_rrc_T_interleaving_r10(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, FALSE, 0, NULL);

  return offset;
}


static const value_string lte_rrc_T_noInterleaving_r10_vals[] = {
  {   0, "crs" },
  {   1, "dmrs" },
  { 0, NULL }
};


static int
dissect_lte_rrc_T_noInterleaving_r10(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, FALSE, 0, NULL);

  return offset;
}


static const value_string lte_rrc_T_demodulationRS_r10_vals[] = {
  {   0, "interleaving-r10" },
  {   1, "noInterleaving-r10" },
  { 0, NULL }
};

static const per_choice_t T_demodulationRS_r10_choice[] = {
  {   0, &hf_lte_rrc_interleaving_r10, ASN1_NO_EXTENSIONS     , dissect_lte_rrc_T_interleaving_r10 },
  {   1, &hf_lte_rrc_noInterleaving_r10, ASN1_NO_EXTENSIONS     , dissect_lte_rrc_T_noInterleaving_r10 },
  { 0, NULL, 0, NULL }
};

static int
dissect_lte_rrc_T_demodulationRS_r10(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_lte_rrc_T_demodulationRS_r10, T_demodulationRS_r10_choice,
                                 NULL);

  return offset;
}



static int
dissect_lte_rrc_INTEGER_1_3(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            1U, 3U, NULL, FALSE);

  return offset;
}


static const per_sequence_t T_n1PUCCH_AN_List_r10_sequence_of[1] = {
  { &hf_lte_rrc_n1PUCCH_AN_List_r10_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_INTEGER_0_2047 },
};

static int
dissect_lte_rrc_T_n1PUCCH_AN_List_r10(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_lte_rrc_T_n1PUCCH_AN_List_r10, T_n1PUCCH_AN_List_r10_sequence_of,
                                                  1, 4, FALSE);

  return offset;
}


static const per_sequence_t T_channelSelectionMultiplexingBundling_sequence[] = {
  { &hf_lte_rrc_n1PUCCH_AN_List_r10, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_T_n1PUCCH_AN_List_r10 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_T_channelSelectionMultiplexingBundling(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_T_channelSelectionMultiplexingBundling, T_channelSelectionMultiplexingBundling_sequence);

  return offset;
}


static const per_sequence_t T_fallbackForFormat3_sequence[] = {
  { &hf_lte_rrc_n1PUCCH_AN_P0_r10, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_INTEGER_0_2047 },
  { &hf_lte_rrc_n1PUCCH_AN_P1_r10, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lte_rrc_INTEGER_0_2047 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_T_fallbackForFormat3(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_T_fallbackForFormat3, T_fallbackForFormat3_sequence);

  return offset;
}


static const value_string lte_rrc_T_tdd_vals[] = {
  {   0, "channelSelectionMultiplexingBundling" },
  {   1, "fallbackForFormat3" },
  { 0, NULL }
};

static const per_choice_t T_tdd_choice[] = {
  {   0, &hf_lte_rrc_channelSelectionMultiplexingBundling, ASN1_NO_EXTENSIONS     , dissect_lte_rrc_T_channelSelectionMultiplexingBundling },
  {   1, &hf_lte_rrc_fallbackForFormat3, ASN1_NO_EXTENSIONS     , dissect_lte_rrc_T_fallbackForFormat3 },
  { 0, NULL, 0, NULL }
};

static int
dissect_lte_rrc_T_tdd(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_lte_rrc_T_tdd, T_tdd_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t T_fdd_sequence[] = {
  { &hf_lte_rrc_n1PUCCH_AN_P0_r10, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_INTEGER_0_2047 },
  { &hf_lte_rrc_n1PUCCH_AN_P1_r10, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lte_rrc_INTEGER_0_2047 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_T_fdd(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_T_fdd, T_fdd_sequence);

  return offset;
}


static const value_string lte_rrc_T_pucch_Config_r10_vals[] = {
  {   0, "tdd" },
  {   1, "fdd" },
  { 0, NULL }
};

static const per_choice_t T_pucch_Config_r10_choice[] = {
  {   0, &hf_lte_rrc_tdd         , ASN1_NO_EXTENSIONS     , dissect_lte_rrc_T_tdd },
  {   1, &hf_lte_rrc_fdd         , ASN1_NO_EXTENSIONS     , dissect_lte_rrc_T_fdd },
  { 0, NULL, 0, NULL }
};

static int
dissect_lte_rrc_T_pucch_Config_r10(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_lte_rrc_T_pucch_Config_r10, T_pucch_Config_r10_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t T_rpdcch_Config_r10_sequence[] = {
  { &hf_lte_rrc_resourceAllocationType_r10, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lte_rrc_T_resourceAllocationType_r10 },
  { &hf_lte_rrc_resourceBlockAssignment_r10, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lte_rrc_T_resourceBlockAssignment_r10 },
  { &hf_lte_rrc_demodulationRS_r10, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lte_rrc_T_demodulationRS_r10 },
  { &hf_lte_rrc_pdsch_Start_r10_01, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lte_rrc_INTEGER_1_3 },
  { &hf_lte_rrc_pucch_Config_r10, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lte_rrc_T_pucch_Config_r10 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_T_rpdcch_Config_r10(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_T_rpdcch_Config_r10, T_rpdcch_Config_r10_sequence);

  return offset;
}


static const per_sequence_t RN_SubframeConfig_r10_sequence[] = {
  { &hf_lte_rrc_subframeConfigPattern_r10, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lte_rrc_T_subframeConfigPattern_r10 },
  { &hf_lte_rrc_rpdcch_Config_r10, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lte_rrc_T_rpdcch_Config_r10 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_RN_SubframeConfig_r10(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_RN_SubframeConfig_r10, RN_SubframeConfig_r10_sequence);

  return offset;
}


static const per_sequence_t T_nonCriticalExtension_16_sequence[] = {
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_T_nonCriticalExtension_16(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_T_nonCriticalExtension_16, T_nonCriticalExtension_16_sequence);

  return offset;
}


static const per_sequence_t RNReconfiguration_r10_IEs_sequence[] = {
  { &hf_lte_rrc_rn_SystemInfo_r10, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lte_rrc_RN_SystemInfo_r10 },
  { &hf_lte_rrc_rn_SubframeConfig_r10, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lte_rrc_RN_SubframeConfig_r10 },
  { &hf_lte_rrc_lateNonCriticalExtension, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lte_rrc_OCTET_STRING },
  { &hf_lte_rrc_nonCriticalExtension_33, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lte_rrc_T_nonCriticalExtension_16 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_RNReconfiguration_r10_IEs(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_RNReconfiguration_r10_IEs, RNReconfiguration_r10_IEs_sequence);

  return offset;
}


static const value_string lte_rrc_T_c1_16_vals[] = {
  {   0, "rnReconfiguration-r10" },
  {   1, "spare3" },
  {   2, "spare2" },
  {   3, "spare1" },
  { 0, NULL }
};

static const per_choice_t T_c1_16_choice[] = {
  {   0, &hf_lte_rrc_rnReconfiguration_r10_01, ASN1_NO_EXTENSIONS     , dissect_lte_rrc_RNReconfiguration_r10_IEs },
  {   1, &hf_lte_rrc_spare3      , ASN1_NO_EXTENSIONS     , dissect_lte_rrc_NULL },
  {   2, &hf_lte_rrc_spare2      , ASN1_NO_EXTENSIONS     , dissect_lte_rrc_NULL },
  {   3, &hf_lte_rrc_spare1      , ASN1_NO_EXTENSIONS     , dissect_lte_rrc_NULL },
  { 0, NULL, 0, NULL }
};

static int
dissect_lte_rrc_T_c1_16(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_lte_rrc_T_c1_16, T_c1_16_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t T_criticalExtensionsFuture_12_sequence[] = {
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_T_criticalExtensionsFuture_12(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_T_criticalExtensionsFuture_12, T_criticalExtensionsFuture_12_sequence);

  return offset;
}


static const value_string lte_rrc_T_criticalExtensions_12_vals[] = {
  {   0, "c1" },
  {   1, "criticalExtensionsFuture" },
  { 0, NULL }
};

static const per_choice_t T_criticalExtensions_12_choice[] = {
  {   0, &hf_lte_rrc_c1_16       , ASN1_NO_EXTENSIONS     , dissect_lte_rrc_T_c1_16 },
  {   1, &hf_lte_rrc_criticalExtensionsFuture_12, ASN1_NO_EXTENSIONS     , dissect_lte_rrc_T_criticalExtensionsFuture_12 },
  { 0, NULL, 0, NULL }
};

static int
dissect_lte_rrc_T_criticalExtensions_12(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_lte_rrc_T_criticalExtensions_12, T_criticalExtensions_12_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t RNReconfiguration_r10_sequence[] = {
  { &hf_lte_rrc_rrc_TransactionIdentifier, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_RRC_TransactionIdentifier },
  { &hf_lte_rrc_criticalExtensions_12, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_T_criticalExtensions_12 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_RNReconfiguration_r10(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {

col_append_str(actx->pinfo->cinfo, COL_INFO, "RNReconfiguration-r10 ");

  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_RNReconfiguration_r10, RNReconfiguration_r10_sequence);

  return offset;
}


static const value_string lte_rrc_T_c1_04_vals[] = {
  {   0, "csfbParametersResponseCDMA2000" },
  {   1, "dlInformationTransfer" },
  {   2, "handoverFromEUTRAPreparationRequest" },
  {   3, "mobilityFromEUTRACommand" },
  {   4, "rrcConnectionReconfiguration" },
  {   5, "rrcConnectionRelease" },
  {   6, "securityModeCommand" },
  {   7, "ueCapabilityEnquiry" },
  {   8, "counterCheck" },
  {   9, "ueInformationRequest-r9" },
  {  10, "loggedMeasurementConfiguration-r10" },
  {  11, "rnReconfiguration-r10" },
  {  12, "spare4" },
  {  13, "spare3" },
  {  14, "spare2" },
  {  15, "spare1" },
  { 0, NULL }
};

static const per_choice_t T_c1_04_choice[] = {
  {   0, &hf_lte_rrc_csfbParametersResponseCDMA2000, ASN1_NO_EXTENSIONS     , dissect_lte_rrc_CSFBParametersResponseCDMA2000 },
  {   1, &hf_lte_rrc_dlInformationTransfer, ASN1_NO_EXTENSIONS     , dissect_lte_rrc_DLInformationTransfer },
  {   2, &hf_lte_rrc_handoverFromEUTRAPreparationRequest, ASN1_NO_EXTENSIONS     , dissect_lte_rrc_HandoverFromEUTRAPreparationRequest },
  {   3, &hf_lte_rrc_mobilityFromEUTRACommand, ASN1_NO_EXTENSIONS     , dissect_lte_rrc_MobilityFromEUTRACommand },
  {   4, &hf_lte_rrc_rrcConnectionReconfiguration, ASN1_NO_EXTENSIONS     , dissect_lte_rrc_RRCConnectionReconfiguration },
  {   5, &hf_lte_rrc_rrcConnectionRelease, ASN1_NO_EXTENSIONS     , dissect_lte_rrc_RRCConnectionRelease },
  {   6, &hf_lte_rrc_securityModeCommand, ASN1_NO_EXTENSIONS     , dissect_lte_rrc_SecurityModeCommand },
  {   7, &hf_lte_rrc_ueCapabilityEnquiry, ASN1_NO_EXTENSIONS     , dissect_lte_rrc_UECapabilityEnquiry },
  {   8, &hf_lte_rrc_counterCheck, ASN1_NO_EXTENSIONS     , dissect_lte_rrc_CounterCheck },
  {   9, &hf_lte_rrc_ueInformationRequest_r9, ASN1_NO_EXTENSIONS     , dissect_lte_rrc_UEInformationRequest_r9 },
  {  10, &hf_lte_rrc_loggedMeasurementConfiguration_r10, ASN1_NO_EXTENSIONS     , dissect_lte_rrc_LoggedMeasurementConfiguration_r10 },
  {  11, &hf_lte_rrc_rnReconfiguration_r10, ASN1_NO_EXTENSIONS     , dissect_lte_rrc_RNReconfiguration_r10 },
  {  12, &hf_lte_rrc_spare4      , ASN1_NO_EXTENSIONS     , dissect_lte_rrc_NULL },
  {  13, &hf_lte_rrc_spare3      , ASN1_NO_EXTENSIONS     , dissect_lte_rrc_NULL },
  {  14, &hf_lte_rrc_spare2      , ASN1_NO_EXTENSIONS     , dissect_lte_rrc_NULL },
  {  15, &hf_lte_rrc_spare1      , ASN1_NO_EXTENSIONS     , dissect_lte_rrc_NULL },
  { 0, NULL, 0, NULL }
};

static int
dissect_lte_rrc_T_c1_04(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_lte_rrc_T_c1_04, T_c1_04_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t T_messageClassExtension_04_sequence[] = {
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_T_messageClassExtension_04(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_T_messageClassExtension_04, T_messageClassExtension_04_sequence);

  return offset;
}


static const value_string lte_rrc_DL_DCCH_MessageType_vals[] = {
  {   0, "c1" },
  {   1, "messageClassExtension" },
  { 0, NULL }
};

static const per_choice_t DL_DCCH_MessageType_choice[] = {
  {   0, &hf_lte_rrc_c1_04       , ASN1_NO_EXTENSIONS     , dissect_lte_rrc_T_c1_04 },
  {   1, &hf_lte_rrc_messageClassExtension_04, ASN1_NO_EXTENSIONS     , dissect_lte_rrc_T_messageClassExtension_04 },
  { 0, NULL, 0, NULL }
};

static int
dissect_lte_rrc_DL_DCCH_MessageType(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_lte_rrc_DL_DCCH_MessageType, DL_DCCH_MessageType_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t DL_DCCH_Message_sequence[] = {
  { &hf_lte_rrc_message_05  , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_DL_DCCH_MessageType },
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_DL_DCCH_Message(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  actx->pinfo->link_dir = P2P_DIR_DL;

  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_DL_DCCH_Message, DL_DCCH_Message_sequence);

  return offset;
}



static int
dissect_lte_rrc_ShortMAC_I(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     16, 16, FALSE, NULL);

  return offset;
}


static const per_sequence_t ReestabUE_Identity_sequence[] = {
  { &hf_lte_rrc_c_RNTI      , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_C_RNTI },
  { &hf_lte_rrc_physCellId_01, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_PhysCellId },
  { &hf_lte_rrc_shortMAC_I  , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_ShortMAC_I },
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_ReestabUE_Identity(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_ReestabUE_Identity, ReestabUE_Identity_sequence);

  return offset;
}


static const value_string lte_rrc_ReestablishmentCause_vals[] = {
  {   0, "reconfigurationFailure" },
  {   1, "handoverFailure" },
  {   2, "otherFailure" },
  {   3, "spare1" },
  { 0, NULL }
};


static int
dissect_lte_rrc_ReestablishmentCause(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     4, NULL, FALSE, 0, NULL);

  return offset;
}


static const per_sequence_t RRCConnectionReestablishmentRequest_r8_IEs_sequence[] = {
  { &hf_lte_rrc_ue_Identity_01, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_ReestabUE_Identity },
  { &hf_lte_rrc_reestablishmentCause, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_ReestablishmentCause },
  { &hf_lte_rrc_spare_01    , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_BIT_STRING_SIZE_2 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_RRCConnectionReestablishmentRequest_r8_IEs(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_RRCConnectionReestablishmentRequest_r8_IEs, RRCConnectionReestablishmentRequest_r8_IEs_sequence);

  return offset;
}


static const per_sequence_t T_criticalExtensionsFuture_19_sequence[] = {
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_T_criticalExtensionsFuture_19(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_T_criticalExtensionsFuture_19, T_criticalExtensionsFuture_19_sequence);

  return offset;
}


static const value_string lte_rrc_T_criticalExtensions_19_vals[] = {
  {   0, "rrcConnectionReestablishmentRequest-r8" },
  {   1, "criticalExtensionsFuture" },
  { 0, NULL }
};

static const per_choice_t T_criticalExtensions_19_choice[] = {
  {   0, &hf_lte_rrc_rrcConnectionReestablishmentRequest_r8, ASN1_NO_EXTENSIONS     , dissect_lte_rrc_RRCConnectionReestablishmentRequest_r8_IEs },
  {   1, &hf_lte_rrc_criticalExtensionsFuture_19, ASN1_NO_EXTENSIONS     , dissect_lte_rrc_T_criticalExtensionsFuture_19 },
  { 0, NULL, 0, NULL }
};

static int
dissect_lte_rrc_T_criticalExtensions_19(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_lte_rrc_T_criticalExtensions_19, T_criticalExtensions_19_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t RRCConnectionReestablishmentRequest_sequence[] = {
  { &hf_lte_rrc_criticalExtensions_19, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_T_criticalExtensions_19 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_RRCConnectionReestablishmentRequest(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {

col_append_str(actx->pinfo->cinfo, COL_INFO, "RRCConnectionReestablishmentRequest ");

  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_RRCConnectionReestablishmentRequest, RRCConnectionReestablishmentRequest_sequence);

  return offset;
}


static const value_string lte_rrc_InitialUE_Identity_vals[] = {
  {   0, "s-TMSI" },
  {   1, "randomValue" },
  { 0, NULL }
};

static const per_choice_t InitialUE_Identity_choice[] = {
  {   0, &hf_lte_rrc_s_TMSI      , ASN1_NO_EXTENSIONS     , dissect_lte_rrc_S_TMSI },
  {   1, &hf_lte_rrc_randomValue , ASN1_NO_EXTENSIONS     , dissect_lte_rrc_BIT_STRING_SIZE_40 },
  { 0, NULL, 0, NULL }
};

static int
dissect_lte_rrc_InitialUE_Identity(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_lte_rrc_InitialUE_Identity, InitialUE_Identity_choice,
                                 NULL);

  return offset;
}


static const value_string lte_rrc_EstablishmentCause_vals[] = {
  {   0, "emergency" },
  {   1, "highPriorityAccess" },
  {   2, "mt-Access" },
  {   3, "mo-Signalling" },
  {   4, "mo-Data" },
  {   5, "delayTolerantAccess-v1020" },
  {   6, "spare2" },
  {   7, "spare1" },
  { 0, NULL }
};


static int
dissect_lte_rrc_EstablishmentCause(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     8, NULL, FALSE, 0, NULL);

  return offset;
}



static int
dissect_lte_rrc_BIT_STRING_SIZE_1(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     1, 1, FALSE, NULL);

  return offset;
}


static const per_sequence_t RRCConnectionRequest_r8_IEs_sequence[] = {
  { &hf_lte_rrc_ue_Identity_02, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_InitialUE_Identity },
  { &hf_lte_rrc_establishmentCause, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_EstablishmentCause },
  { &hf_lte_rrc_spare_02    , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_BIT_STRING_SIZE_1 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_RRCConnectionRequest_r8_IEs(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_RRCConnectionRequest_r8_IEs, RRCConnectionRequest_r8_IEs_sequence);

  return offset;
}


static const per_sequence_t T_criticalExtensionsFuture_22_sequence[] = {
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_T_criticalExtensionsFuture_22(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_T_criticalExtensionsFuture_22, T_criticalExtensionsFuture_22_sequence);

  return offset;
}


static const value_string lte_rrc_T_criticalExtensions_22_vals[] = {
  {   0, "rrcConnectionRequest-r8" },
  {   1, "criticalExtensionsFuture" },
  { 0, NULL }
};

static const per_choice_t T_criticalExtensions_22_choice[] = {
  {   0, &hf_lte_rrc_rrcConnectionRequest_r8, ASN1_NO_EXTENSIONS     , dissect_lte_rrc_RRCConnectionRequest_r8_IEs },
  {   1, &hf_lte_rrc_criticalExtensionsFuture_22, ASN1_NO_EXTENSIONS     , dissect_lte_rrc_T_criticalExtensionsFuture_22 },
  { 0, NULL, 0, NULL }
};

static int
dissect_lte_rrc_T_criticalExtensions_22(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_lte_rrc_T_criticalExtensions_22, T_criticalExtensions_22_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t RRCConnectionRequest_sequence[] = {
  { &hf_lte_rrc_criticalExtensions_22, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_T_criticalExtensions_22 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_RRCConnectionRequest(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {

col_append_str(actx->pinfo->cinfo, COL_INFO, "RRCConnectionRequest ");

  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_RRCConnectionRequest, RRCConnectionRequest_sequence);

  return offset;
}


static const value_string lte_rrc_T_c1_05_vals[] = {
  {   0, "rrcConnectionReestablishmentRequest" },
  {   1, "rrcConnectionRequest" },
  { 0, NULL }
};

static const per_choice_t T_c1_05_choice[] = {
  {   0, &hf_lte_rrc_rrcConnectionReestablishmentRequest, ASN1_NO_EXTENSIONS     , dissect_lte_rrc_RRCConnectionReestablishmentRequest },
  {   1, &hf_lte_rrc_rrcConnectionRequest, ASN1_NO_EXTENSIONS     , dissect_lte_rrc_RRCConnectionRequest },
  { 0, NULL, 0, NULL }
};

static int
dissect_lte_rrc_T_c1_05(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_lte_rrc_T_c1_05, T_c1_05_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t T_messageClassExtension_05_sequence[] = {
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_T_messageClassExtension_05(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_T_messageClassExtension_05, T_messageClassExtension_05_sequence);

  return offset;
}


static const value_string lte_rrc_UL_CCCH_MessageType_vals[] = {
  {   0, "c1" },
  {   1, "messageClassExtension" },
  { 0, NULL }
};

static const per_choice_t UL_CCCH_MessageType_choice[] = {
  {   0, &hf_lte_rrc_c1_05       , ASN1_NO_EXTENSIONS     , dissect_lte_rrc_T_c1_05 },
  {   1, &hf_lte_rrc_messageClassExtension_05, ASN1_NO_EXTENSIONS     , dissect_lte_rrc_T_messageClassExtension_05 },
  { 0, NULL, 0, NULL }
};

static int
dissect_lte_rrc_UL_CCCH_MessageType(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_lte_rrc_UL_CCCH_MessageType, UL_CCCH_MessageType_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t UL_CCCH_Message_sequence[] = {
  { &hf_lte_rrc_message_06  , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_UL_CCCH_MessageType },
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_UL_CCCH_Message(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_UL_CCCH_Message, UL_CCCH_Message_sequence);

  return offset;
}


static const per_sequence_t T_nonCriticalExtension_02_sequence[] = {
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_T_nonCriticalExtension_02(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_T_nonCriticalExtension_02, T_nonCriticalExtension_02_sequence);

  return offset;
}


static const per_sequence_t CSFBParametersRequestCDMA2000_v8a0_IEs_sequence[] = {
  { &hf_lte_rrc_lateNonCriticalExtension, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lte_rrc_OCTET_STRING },
  { &hf_lte_rrc_nonCriticalExtension_05, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lte_rrc_T_nonCriticalExtension_02 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_CSFBParametersRequestCDMA2000_v8a0_IEs(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_CSFBParametersRequestCDMA2000_v8a0_IEs, CSFBParametersRequestCDMA2000_v8a0_IEs_sequence);

  return offset;
}


static const per_sequence_t CSFBParametersRequestCDMA2000_r8_IEs_sequence[] = {
  { &hf_lte_rrc_nonCriticalExtension_04, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lte_rrc_CSFBParametersRequestCDMA2000_v8a0_IEs },
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_CSFBParametersRequestCDMA2000_r8_IEs(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_CSFBParametersRequestCDMA2000_r8_IEs, CSFBParametersRequestCDMA2000_r8_IEs_sequence);

  return offset;
}


static const per_sequence_t T_criticalExtensionsFuture_02_sequence[] = {
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_T_criticalExtensionsFuture_02(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_T_criticalExtensionsFuture_02, T_criticalExtensionsFuture_02_sequence);

  return offset;
}


static const value_string lte_rrc_T_criticalExtensions_02_vals[] = {
  {   0, "csfbParametersRequestCDMA2000-r8" },
  {   1, "criticalExtensionsFuture" },
  { 0, NULL }
};

static const per_choice_t T_criticalExtensions_02_choice[] = {
  {   0, &hf_lte_rrc_csfbParametersRequestCDMA2000_r8, ASN1_NO_EXTENSIONS     , dissect_lte_rrc_CSFBParametersRequestCDMA2000_r8_IEs },
  {   1, &hf_lte_rrc_criticalExtensionsFuture_02, ASN1_NO_EXTENSIONS     , dissect_lte_rrc_T_criticalExtensionsFuture_02 },
  { 0, NULL, 0, NULL }
};

static int
dissect_lte_rrc_T_criticalExtensions_02(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_lte_rrc_T_criticalExtensions_02, T_criticalExtensions_02_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t CSFBParametersRequestCDMA2000_sequence[] = {
  { &hf_lte_rrc_criticalExtensions_02, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_T_criticalExtensions_02 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_CSFBParametersRequestCDMA2000(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {

col_append_str(actx->pinfo->cinfo, COL_INFO, "CSFBParametersRequestCDMA2000 ");

  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_CSFBParametersRequestCDMA2000, CSFBParametersRequestCDMA2000_sequence);

  return offset;
}


static const per_sequence_t T_measResultPCell_sequence[] = {
  { &hf_lte_rrc_rsrpResult  , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_RSRP_Range },
  { &hf_lte_rrc_rsrqResult  , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_RSRQ_Range },
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_T_measResultPCell(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_T_measResultPCell, T_measResultPCell_sequence);

  return offset;
}


static const per_sequence_t PLMN_IdentityList2_sequence_of[1] = {
  { &hf_lte_rrc_PLMN_IdentityList2_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_PLMN_Identity },
};

static int
dissect_lte_rrc_PLMN_IdentityList2(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_lte_rrc_PLMN_IdentityList2, PLMN_IdentityList2_sequence_of,
                                                  1, 5, FALSE);

  return offset;
}


static const per_sequence_t T_cgi_Info_sequence[] = {
  { &hf_lte_rrc_cellGlobalId, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_CellGlobalIdEUTRA },
  { &hf_lte_rrc_trackingAreaCode, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_TrackingAreaCode },
  { &hf_lte_rrc_plmn_IdentityList_01, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lte_rrc_PLMN_IdentityList2 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_T_cgi_Info(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_T_cgi_Info, T_cgi_Info_sequence);

  return offset;
}


static const value_string lte_rrc_T_csg_MemberStatus_r9_vals[] = {
  {   0, "member" },
  { 0, NULL }
};


static int
dissect_lte_rrc_T_csg_MemberStatus_r9(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, FALSE, 0, NULL);

  return offset;
}


static const per_sequence_t AdditionalSI_Info_r9_sequence[] = {
  { &hf_lte_rrc_csg_MemberStatus_r9, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lte_rrc_T_csg_MemberStatus_r9 },
  { &hf_lte_rrc_csg_Identity_r9, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lte_rrc_CSG_Identity },
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_AdditionalSI_Info_r9(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_AdditionalSI_Info_r9, AdditionalSI_Info_r9_sequence);

  return offset;
}


static const per_sequence_t T_eag_1_01_sequence[] = {
  { &hf_lte_rrc_additionalSI_Info_r9, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lte_rrc_AdditionalSI_Info_r9 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_T_eag_1_01(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence_eag(tvb, offset, actx, tree, T_eag_1_01_sequence);

  return offset;
}


static const per_sequence_t T_measResult_sequence[] = {
  { &hf_lte_rrc_rsrpResult  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lte_rrc_RSRP_Range },
  { &hf_lte_rrc_rsrqResult  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lte_rrc_RSRQ_Range },
  { &hf_lte_rrc_dummy_eag_field, ASN1_NOT_EXTENSION_ROOT, ASN1_NOT_OPTIONAL, dissect_lte_rrc_T_eag_1_01 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_T_measResult(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_T_measResult, T_measResult_sequence);

  return offset;
}


static const per_sequence_t MeasResultEUTRA_sequence[] = {
  { &hf_lte_rrc_physCellId_01, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_PhysCellId },
  { &hf_lte_rrc_cgi_Info    , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lte_rrc_T_cgi_Info },
  { &hf_lte_rrc_measResult  , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_T_measResult },
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_MeasResultEUTRA(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_MeasResultEUTRA, MeasResultEUTRA_sequence);

  return offset;
}


static const per_sequence_t MeasResultListEUTRA_sequence_of[1] = {
  { &hf_lte_rrc_MeasResultListEUTRA_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_MeasResultEUTRA },
};

static int
dissect_lte_rrc_MeasResultListEUTRA(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_lte_rrc_MeasResultListEUTRA, MeasResultListEUTRA_sequence_of,
                                                  1, maxCellReport, FALSE);

  return offset;
}


static const value_string lte_rrc_T_physCellId_vals[] = {
  {   0, "fdd" },
  {   1, "tdd" },
  { 0, NULL }
};

static const per_choice_t T_physCellId_choice[] = {
  {   0, &hf_lte_rrc_fdd_01      , ASN1_NO_EXTENSIONS     , dissect_lte_rrc_PhysCellIdUTRA_FDD },
  {   1, &hf_lte_rrc_tdd_01      , ASN1_NO_EXTENSIONS     , dissect_lte_rrc_PhysCellIdUTRA_TDD },
  { 0, NULL, 0, NULL }
};

static int
dissect_lte_rrc_T_physCellId(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_lte_rrc_T_physCellId, T_physCellId_choice,
                                 NULL);

  return offset;
}



static int
dissect_lte_rrc_BIT_STRING_SIZE_28(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     28, 28, FALSE, NULL);

  return offset;
}


static const per_sequence_t CellGlobalIdUTRA_sequence[] = {
  { &hf_lte_rrc_plmn_Identity, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_PLMN_Identity },
  { &hf_lte_rrc_cellIdentity_01, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_BIT_STRING_SIZE_28 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_CellGlobalIdUTRA(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_CellGlobalIdUTRA, CellGlobalIdUTRA_sequence);

  return offset;
}


static const per_sequence_t T_cgi_Info_01_sequence[] = {
  { &hf_lte_rrc_cellGlobalId_01, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_CellGlobalIdUTRA },
  { &hf_lte_rrc_locationAreaCode, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lte_rrc_BIT_STRING_SIZE_16 },
  { &hf_lte_rrc_routingAreaCode, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lte_rrc_BIT_STRING_SIZE_8 },
  { &hf_lte_rrc_plmn_IdentityList_01, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lte_rrc_PLMN_IdentityList2 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_T_cgi_Info_01(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_T_cgi_Info_01, T_cgi_Info_01_sequence);

  return offset;
}



static int
dissect_lte_rrc_INTEGER_M5_91(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            -5, 91U, NULL, FALSE);

  return offset;
}



static int
dissect_lte_rrc_INTEGER_0_49(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 49U, NULL, FALSE);

  return offset;
}


static const per_sequence_t T_eag_1_02_sequence[] = {
  { &hf_lte_rrc_additionalSI_Info_r9, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lte_rrc_AdditionalSI_Info_r9 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_T_eag_1_02(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence_eag(tvb, offset, actx, tree, T_eag_1_02_sequence);

  return offset;
}


static const per_sequence_t T_measResult_01_sequence[] = {
  { &hf_lte_rrc_utra_RSCP   , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lte_rrc_INTEGER_M5_91 },
  { &hf_lte_rrc_utra_EcN0   , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lte_rrc_INTEGER_0_49 },
  { &hf_lte_rrc_dummy_eag_field, ASN1_NOT_EXTENSION_ROOT, ASN1_NOT_OPTIONAL, dissect_lte_rrc_T_eag_1_02 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_T_measResult_01(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_T_measResult_01, T_measResult_01_sequence);

  return offset;
}


static const per_sequence_t MeasResultUTRA_sequence[] = {
  { &hf_lte_rrc_physCellId_05, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_T_physCellId },
  { &hf_lte_rrc_cgi_Info_01 , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lte_rrc_T_cgi_Info_01 },
  { &hf_lte_rrc_measResult_01, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_T_measResult_01 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_MeasResultUTRA(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_MeasResultUTRA, MeasResultUTRA_sequence);

  return offset;
}


static const per_sequence_t MeasResultListUTRA_sequence_of[1] = {
  { &hf_lte_rrc_MeasResultListUTRA_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_MeasResultUTRA },
};

static int
dissect_lte_rrc_MeasResultListUTRA(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_lte_rrc_MeasResultListUTRA, MeasResultListUTRA_sequence_of,
                                                  1, maxCellReport, FALSE);

  return offset;
}


static const per_sequence_t CellGlobalIdGERAN_sequence[] = {
  { &hf_lte_rrc_plmn_Identity, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_PLMN_Identity },
  { &hf_lte_rrc_locationAreaCode, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_BIT_STRING_SIZE_16 },
  { &hf_lte_rrc_cellIdentity_02, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_BIT_STRING_SIZE_16 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_CellGlobalIdGERAN(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_CellGlobalIdGERAN, CellGlobalIdGERAN_sequence);

  return offset;
}


static const per_sequence_t T_cgi_Info_02_sequence[] = {
  { &hf_lte_rrc_cellGlobalId_02, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_CellGlobalIdGERAN },
  { &hf_lte_rrc_routingAreaCode, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lte_rrc_BIT_STRING_SIZE_8 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_T_cgi_Info_02(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_T_cgi_Info_02, T_cgi_Info_02_sequence);

  return offset;
}


static const per_sequence_t T_measResult_02_sequence[] = {
  { &hf_lte_rrc_rssi        , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lte_rrc_INTEGER_0_63 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_T_measResult_02(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_T_measResult_02, T_measResult_02_sequence);

  return offset;
}


static const per_sequence_t MeasResultGERAN_sequence[] = {
  { &hf_lte_rrc_carrierFreq , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_CarrierFreqGERAN },
  { &hf_lte_rrc_physCellId  , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_PhysCellIdGERAN },
  { &hf_lte_rrc_cgi_Info_02 , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lte_rrc_T_cgi_Info_02 },
  { &hf_lte_rrc_measResult_02, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_T_measResult_02 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_MeasResultGERAN(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_MeasResultGERAN, MeasResultGERAN_sequence);

  return offset;
}


static const per_sequence_t MeasResultListGERAN_sequence_of[1] = {
  { &hf_lte_rrc_MeasResultListGERAN_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_MeasResultGERAN },
};

static int
dissect_lte_rrc_MeasResultListGERAN(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_lte_rrc_MeasResultListGERAN, MeasResultListGERAN_sequence_of,
                                                  1, maxCellReport, FALSE);

  return offset;
}



static int
dissect_lte_rrc_BIT_STRING_SIZE_47(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     47, 47, FALSE, NULL);

  return offset;
}



static int
dissect_lte_rrc_BIT_STRING_SIZE_128(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     128, 128, FALSE, NULL);

  return offset;
}


static const value_string lte_rrc_CellGlobalIdCDMA2000_vals[] = {
  {   0, "cellGlobalId1XRTT" },
  {   1, "cellGlobalIdHRPD" },
  { 0, NULL }
};

static const per_choice_t CellGlobalIdCDMA2000_choice[] = {
  {   0, &hf_lte_rrc_cellGlobalId1XRTT, ASN1_NO_EXTENSIONS     , dissect_lte_rrc_BIT_STRING_SIZE_47 },
  {   1, &hf_lte_rrc_cellGlobalIdHRPD, ASN1_NO_EXTENSIONS     , dissect_lte_rrc_BIT_STRING_SIZE_128 },
  { 0, NULL, 0, NULL }
};

static int
dissect_lte_rrc_CellGlobalIdCDMA2000(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_lte_rrc_CellGlobalIdCDMA2000, CellGlobalIdCDMA2000_choice,
                                 NULL);

  return offset;
}



static int
dissect_lte_rrc_INTEGER_0_32767(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 32767U, NULL, FALSE);

  return offset;
}


static const per_sequence_t T_measResult_03_sequence[] = {
  { &hf_lte_rrc_pilotPnPhase, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lte_rrc_INTEGER_0_32767 },
  { &hf_lte_rrc_pilotStrength, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lte_rrc_INTEGER_0_63 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_T_measResult_03(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_T_measResult_03, T_measResult_03_sequence);

  return offset;
}


static const per_sequence_t MeasResultCDMA2000_sequence[] = {
  { &hf_lte_rrc_physCellId_02, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_PhysCellIdCDMA2000 },
  { &hf_lte_rrc_cgi_Info_03 , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lte_rrc_CellGlobalIdCDMA2000 },
  { &hf_lte_rrc_measResult_03, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_T_measResult_03 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_MeasResultCDMA2000(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_MeasResultCDMA2000, MeasResultCDMA2000_sequence);

  return offset;
}


static const per_sequence_t MeasResultListCDMA2000_sequence_of[1] = {
  { &hf_lte_rrc_MeasResultListCDMA2000_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_MeasResultCDMA2000 },
};

static int
dissect_lte_rrc_MeasResultListCDMA2000(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_lte_rrc_MeasResultListCDMA2000, MeasResultListCDMA2000_sequence_of,
                                                  1, maxCellReport, FALSE);

  return offset;
}


static const per_sequence_t MeasResultsCDMA2000_sequence[] = {
  { &hf_lte_rrc_preRegistrationStatusHRPD, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_BOOLEAN },
  { &hf_lte_rrc_measResultListCDMA2000, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_MeasResultListCDMA2000 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_MeasResultsCDMA2000(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_MeasResultsCDMA2000, MeasResultsCDMA2000_sequence);

  return offset;
}


static const value_string lte_rrc_T_measResultNeighCells_vals[] = {
  {   0, "measResultListEUTRA" },
  {   1, "measResultListUTRA" },
  {   2, "measResultListGERAN" },
  {   3, "measResultsCDMA2000" },
  { 0, NULL }
};

static const per_choice_t T_measResultNeighCells_choice[] = {
  {   0, &hf_lte_rrc_measResultListEUTRA, ASN1_EXTENSION_ROOT    , dissect_lte_rrc_MeasResultListEUTRA },
  {   1, &hf_lte_rrc_measResultListUTRA, ASN1_EXTENSION_ROOT    , dissect_lte_rrc_MeasResultListUTRA },
  {   2, &hf_lte_rrc_measResultListGERAN, ASN1_EXTENSION_ROOT    , dissect_lte_rrc_MeasResultListGERAN },
  {   3, &hf_lte_rrc_measResultsCDMA2000, ASN1_EXTENSION_ROOT    , dissect_lte_rrc_MeasResultsCDMA2000 },
  { 0, NULL, 0, NULL }
};

static int
dissect_lte_rrc_T_measResultNeighCells(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_lte_rrc_T_measResultNeighCells, T_measResultNeighCells_choice,
                                 NULL);

  return offset;
}



static int
dissect_lte_rrc_INTEGER_0_4095(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 4095U, NULL, FALSE);

  return offset;
}


static const per_sequence_t MeasResultForECID_r9_sequence[] = {
  { &hf_lte_rrc_ue_RxTxTimeDiffResult_r9, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_INTEGER_0_4095 },
  { &hf_lte_rrc_currentSFN_r9, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_BIT_STRING_SIZE_10 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_MeasResultForECID_r9(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_MeasResultForECID_r9, MeasResultForECID_r9_sequence);

  return offset;
}


static const per_sequence_t MeasResults_eag_1_sequence[] = {
  { &hf_lte_rrc_measResultForECID_r9, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lte_rrc_MeasResultForECID_r9 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_MeasResults_eag_1(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence_eag(tvb, offset, actx, tree, MeasResults_eag_1_sequence);

  return offset;
}



static int
dissect_lte_rrc_T_ellipsoid_Point_r10(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  tvbuff_t *ellipsoid_point_tvb = NULL;
  offset = dissect_per_octet_string(tvb, offset, actx, tree, hf_index,
                                       NO_BOUND, NO_BOUND, FALSE, &ellipsoid_point_tvb);

  if (ellipsoid_point_tvb) {
    dissect_lpp_Ellipsoid_Point_PDU(ellipsoid_point_tvb, actx->pinfo, tree); 
  }


  return offset;
}



static int
dissect_lte_rrc_T_ellipsoidPointWithAltitude_r10(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  tvbuff_t *ellipsoid_point_with_alt_tvb = NULL;
  offset = dissect_per_octet_string(tvb, offset, actx, tree, hf_index,
                                       NO_BOUND, NO_BOUND, FALSE, &ellipsoid_point_with_alt_tvb);

  if (ellipsoid_point_with_alt_tvb) {
    dissect_lpp_EllipsoidPointWithAltitude_PDU(ellipsoid_point_with_alt_tvb, actx->pinfo, tree); 
  }


  return offset;
}


static const value_string lte_rrc_T_locationCoordinates_r10_vals[] = {
  {   0, "ellipsoid-Point-r10" },
  {   1, "ellipsoidPointWithAltitude-r10" },
  { 0, NULL }
};

static const per_choice_t T_locationCoordinates_r10_choice[] = {
  {   0, &hf_lte_rrc_ellipsoid_Point_r10, ASN1_EXTENSION_ROOT    , dissect_lte_rrc_T_ellipsoid_Point_r10 },
  {   1, &hf_lte_rrc_ellipsoidPointWithAltitude_r10, ASN1_EXTENSION_ROOT    , dissect_lte_rrc_T_ellipsoidPointWithAltitude_r10 },
  { 0, NULL, 0, NULL }
};

static int
dissect_lte_rrc_T_locationCoordinates_r10(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_lte_rrc_T_locationCoordinates_r10, T_locationCoordinates_r10_choice,
                                 NULL);

  return offset;
}



static int
dissect_lte_rrc_T_horizontalVelocity_r10(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  tvbuff_t *horizontal_velocity_tvb = NULL;
  offset = dissect_per_octet_string(tvb, offset, actx, tree, hf_index,
                                       NO_BOUND, NO_BOUND, FALSE, &horizontal_velocity_tvb);

  if (horizontal_velocity_tvb) {
    dissect_lpp_HorizontalVelocity_PDU(horizontal_velocity_tvb, actx->pinfo, tree); 
  }


  return offset;
}



static int
dissect_lte_rrc_T_gnss_TOD_msec_r10(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  tvbuff_t *gnss_tod_msec_tvb = NULL;
  offset = dissect_per_octet_string(tvb, offset, actx, tree, hf_index,
                                       NO_BOUND, NO_BOUND, FALSE, &gnss_tod_msec_tvb);

  if (gnss_tod_msec_tvb) {
    asn1_ctx_t asn1_ctx;
    asn1_ctx_init(&asn1_ctx, ASN1_ENC_PER, FALSE, actx->pinfo);
    dissect_per_constrained_integer(gnss_tod_msec_tvb, 0, &asn1_ctx, tree, hf_index, 0U, 3599999U, NULL, FALSE);
  }


  return offset;
}


static const per_sequence_t LocationInfo_r10_sequence[] = {
  { &hf_lte_rrc_locationCoordinates_r10, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lte_rrc_T_locationCoordinates_r10 },
  { &hf_lte_rrc_horizontalVelocity_r10, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lte_rrc_T_horizontalVelocity_r10 },
  { &hf_lte_rrc_gnss_TOD_msec_r10, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lte_rrc_T_gnss_TOD_msec_r10 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_LocationInfo_r10(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_LocationInfo_r10, LocationInfo_r10_sequence);

  return offset;
}


static const per_sequence_t T_measResultSCell_r10_sequence[] = {
  { &hf_lte_rrc_rsrpResultSCell_r10, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_RSRP_Range },
  { &hf_lte_rrc_rsrqResultSCell_r10, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_RSRQ_Range },
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_T_measResultSCell_r10(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_T_measResultSCell_r10, T_measResultSCell_r10_sequence);

  return offset;
}


static const per_sequence_t T_measResultBestNeighCell_r10_sequence[] = {
  { &hf_lte_rrc_physCellId_r10, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_PhysCellId },
  { &hf_lte_rrc_rsrpResultNCell_r10, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_RSRP_Range },
  { &hf_lte_rrc_rsrqResultNCell_r10, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_RSRQ_Range },
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_T_measResultBestNeighCell_r10(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_T_measResultBestNeighCell_r10, T_measResultBestNeighCell_r10_sequence);

  return offset;
}


static const per_sequence_t MeasResultServFreq_r10_sequence[] = {
  { &hf_lte_rrc_servFreqId_r10, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lte_rrc_ServCellIndex_r10 },
  { &hf_lte_rrc_measResultSCell_r10, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lte_rrc_T_measResultSCell_r10 },
  { &hf_lte_rrc_measResultBestNeighCell_r10, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lte_rrc_T_measResultBestNeighCell_r10 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_MeasResultServFreq_r10(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_MeasResultServFreq_r10, MeasResultServFreq_r10_sequence);

  return offset;
}


static const per_sequence_t MeasResultServFreqList_r10_sequence_of[1] = {
  { &hf_lte_rrc_MeasResultServFreqList_r10_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_MeasResultServFreq_r10 },
};

static int
dissect_lte_rrc_MeasResultServFreqList_r10(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_lte_rrc_MeasResultServFreqList_r10, MeasResultServFreqList_r10_sequence_of,
                                                  1, maxServCell_r10, FALSE);

  return offset;
}


static const per_sequence_t MeasResults_eag_2_sequence[] = {
  { &hf_lte_rrc_locationInfo_r10, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lte_rrc_LocationInfo_r10 },
  { &hf_lte_rrc_measResultServFreqList_r10, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lte_rrc_MeasResultServFreqList_r10 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_MeasResults_eag_2(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence_eag(tvb, offset, actx, tree, MeasResults_eag_2_sequence);

  return offset;
}


static const per_sequence_t MeasResults_sequence[] = {
  { &hf_lte_rrc_measId      , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lte_rrc_MeasId },
  { &hf_lte_rrc_measResultPCell, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lte_rrc_T_measResultPCell },
  { &hf_lte_rrc_measResultNeighCells, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lte_rrc_T_measResultNeighCells },
  { &hf_lte_rrc_dummy_eag_field, ASN1_NOT_EXTENSION_ROOT, ASN1_NOT_OPTIONAL, dissect_lte_rrc_MeasResults_eag_1 },
  { &hf_lte_rrc_dummy_eag_field, ASN1_NOT_EXTENSION_ROOT, ASN1_NOT_OPTIONAL, dissect_lte_rrc_MeasResults_eag_2 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_MeasResults(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_MeasResults, MeasResults_sequence);

  return offset;
}


static const per_sequence_t T_nonCriticalExtension_11_sequence[] = {
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_T_nonCriticalExtension_11(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_T_nonCriticalExtension_11, T_nonCriticalExtension_11_sequence);

  return offset;
}


static const per_sequence_t MeasurementReport_v8a0_IEs_sequence[] = {
  { &hf_lte_rrc_lateNonCriticalExtension, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lte_rrc_OCTET_STRING },
  { &hf_lte_rrc_nonCriticalExtension_21, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lte_rrc_T_nonCriticalExtension_11 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_MeasurementReport_v8a0_IEs(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_MeasurementReport_v8a0_IEs, MeasurementReport_v8a0_IEs_sequence);

  return offset;
}


static const per_sequence_t MeasurementReport_r8_IEs_sequence[] = {
  { &hf_lte_rrc_measResults , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_MeasResults },
  { &hf_lte_rrc_nonCriticalExtension_20, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lte_rrc_MeasurementReport_v8a0_IEs },
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_MeasurementReport_r8_IEs(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_MeasurementReport_r8_IEs, MeasurementReport_r8_IEs_sequence);

  return offset;
}


static const value_string lte_rrc_T_c1_13_vals[] = {
  {   0, "measurementReport-r8" },
  {   1, "spare7" },
  {   2, "spare6" },
  {   3, "spare5" },
  {   4, "spare4" },
  {   5, "spare3" },
  {   6, "spare2" },
  {   7, "spare1" },
  { 0, NULL }
};

static const per_choice_t T_c1_13_choice[] = {
  {   0, &hf_lte_rrc_measurementReport_r8, ASN1_NO_EXTENSIONS     , dissect_lte_rrc_MeasurementReport_r8_IEs },
  {   1, &hf_lte_rrc_spare7      , ASN1_NO_EXTENSIONS     , dissect_lte_rrc_NULL },
  {   2, &hf_lte_rrc_spare6      , ASN1_NO_EXTENSIONS     , dissect_lte_rrc_NULL },
  {   3, &hf_lte_rrc_spare5      , ASN1_NO_EXTENSIONS     , dissect_lte_rrc_NULL },
  {   4, &hf_lte_rrc_spare4      , ASN1_NO_EXTENSIONS     , dissect_lte_rrc_NULL },
  {   5, &hf_lte_rrc_spare3      , ASN1_NO_EXTENSIONS     , dissect_lte_rrc_NULL },
  {   6, &hf_lte_rrc_spare2      , ASN1_NO_EXTENSIONS     , dissect_lte_rrc_NULL },
  {   7, &hf_lte_rrc_spare1      , ASN1_NO_EXTENSIONS     , dissect_lte_rrc_NULL },
  { 0, NULL, 0, NULL }
};

static int
dissect_lte_rrc_T_c1_13(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_lte_rrc_T_c1_13, T_c1_13_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t T_criticalExtensionsFuture_09_sequence[] = {
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_T_criticalExtensionsFuture_09(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_T_criticalExtensionsFuture_09, T_criticalExtensionsFuture_09_sequence);

  return offset;
}


static const value_string lte_rrc_T_criticalExtensions_09_vals[] = {
  {   0, "c1" },
  {   1, "criticalExtensionsFuture" },
  { 0, NULL }
};

static const per_choice_t T_criticalExtensions_09_choice[] = {
  {   0, &hf_lte_rrc_c1_13       , ASN1_NO_EXTENSIONS     , dissect_lte_rrc_T_c1_13 },
  {   1, &hf_lte_rrc_criticalExtensionsFuture_09, ASN1_NO_EXTENSIONS     , dissect_lte_rrc_T_criticalExtensionsFuture_09 },
  { 0, NULL, 0, NULL }
};

static int
dissect_lte_rrc_T_criticalExtensions_09(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_lte_rrc_T_criticalExtensions_09, T_criticalExtensions_09_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t MeasurementReport_sequence[] = {
  { &hf_lte_rrc_criticalExtensions_09, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_T_criticalExtensions_09 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_MeasurementReport(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {

col_append_str(actx->pinfo->cinfo, COL_INFO, "MeasurementReport ");

  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_MeasurementReport, MeasurementReport_sequence);

  return offset;
}


static const value_string lte_rrc_T_rlf_InfoAvailable_r10_vals[] = {
  {   0, "true" },
  { 0, NULL }
};


static int
dissect_lte_rrc_T_rlf_InfoAvailable_r10(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, FALSE, 0, NULL);

  return offset;
}


static const value_string lte_rrc_T_logMeasAvailable_r10_vals[] = {
  {   0, "true" },
  { 0, NULL }
};


static int
dissect_lte_rrc_T_logMeasAvailable_r10(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, FALSE, 0, NULL);

  return offset;
}


static const per_sequence_t T_nonCriticalExtension_19_sequence[] = {
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_T_nonCriticalExtension_19(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_T_nonCriticalExtension_19, T_nonCriticalExtension_19_sequence);

  return offset;
}


static const per_sequence_t RRCConnectionReconfigurationComplete_v1020_IEs_sequence[] = {
  { &hf_lte_rrc_rlf_InfoAvailable_r10, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lte_rrc_T_rlf_InfoAvailable_r10 },
  { &hf_lte_rrc_logMeasAvailable_r10, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lte_rrc_T_logMeasAvailable_r10 },
  { &hf_lte_rrc_nonCriticalExtension_41, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lte_rrc_T_nonCriticalExtension_19 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_RRCConnectionReconfigurationComplete_v1020_IEs(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_RRCConnectionReconfigurationComplete_v1020_IEs, RRCConnectionReconfigurationComplete_v1020_IEs_sequence);

  return offset;
}


static const per_sequence_t RRCConnectionReconfigurationComplete_v8a0_IEs_sequence[] = {
  { &hf_lte_rrc_lateNonCriticalExtension, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lte_rrc_OCTET_STRING },
  { &hf_lte_rrc_nonCriticalExtension_40, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lte_rrc_RRCConnectionReconfigurationComplete_v1020_IEs },
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_RRCConnectionReconfigurationComplete_v8a0_IEs(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_RRCConnectionReconfigurationComplete_v8a0_IEs, RRCConnectionReconfigurationComplete_v8a0_IEs_sequence);

  return offset;
}


static const per_sequence_t RRCConnectionReconfigurationComplete_r8_IEs_sequence[] = {
  { &hf_lte_rrc_nonCriticalExtension_39, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lte_rrc_RRCConnectionReconfigurationComplete_v8a0_IEs },
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_RRCConnectionReconfigurationComplete_r8_IEs(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_RRCConnectionReconfigurationComplete_r8_IEs, RRCConnectionReconfigurationComplete_r8_IEs_sequence);

  return offset;
}


static const per_sequence_t T_criticalExtensionsFuture_15_sequence[] = {
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_T_criticalExtensionsFuture_15(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_T_criticalExtensionsFuture_15, T_criticalExtensionsFuture_15_sequence);

  return offset;
}


static const value_string lte_rrc_T_criticalExtensions_15_vals[] = {
  {   0, "rrcConnectionReconfigurationComplete-r8" },
  {   1, "criticalExtensionsFuture" },
  { 0, NULL }
};

static const per_choice_t T_criticalExtensions_15_choice[] = {
  {   0, &hf_lte_rrc_rrcConnectionReconfigurationComplete_r8, ASN1_NO_EXTENSIONS     , dissect_lte_rrc_RRCConnectionReconfigurationComplete_r8_IEs },
  {   1, &hf_lte_rrc_criticalExtensionsFuture_15, ASN1_NO_EXTENSIONS     , dissect_lte_rrc_T_criticalExtensionsFuture_15 },
  { 0, NULL, 0, NULL }
};

static int
dissect_lte_rrc_T_criticalExtensions_15(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_lte_rrc_T_criticalExtensions_15, T_criticalExtensions_15_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t RRCConnectionReconfigurationComplete_sequence[] = {
  { &hf_lte_rrc_rrc_TransactionIdentifier, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_RRC_TransactionIdentifier },
  { &hf_lte_rrc_criticalExtensions_15, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_T_criticalExtensions_15 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_RRCConnectionReconfigurationComplete(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {

col_append_str(actx->pinfo->cinfo, COL_INFO, "RRCConnectionReconfigurationComplete ");

  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_RRCConnectionReconfigurationComplete, RRCConnectionReconfigurationComplete_sequence);

  return offset;
}


static const value_string lte_rrc_T_rlf_InfoAvailable_r9_vals[] = {
  {   0, "true" },
  { 0, NULL }
};


static int
dissect_lte_rrc_T_rlf_InfoAvailable_r9(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, FALSE, 0, NULL);

  return offset;
}


static const value_string lte_rrc_T_logMeasAvailable_r10_01_vals[] = {
  {   0, "true" },
  { 0, NULL }
};


static int
dissect_lte_rrc_T_logMeasAvailable_r10_01(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, FALSE, 0, NULL);

  return offset;
}


static const per_sequence_t T_nonCriticalExtension_21_sequence[] = {
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_T_nonCriticalExtension_21(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_T_nonCriticalExtension_21, T_nonCriticalExtension_21_sequence);

  return offset;
}


static const per_sequence_t RRCConnectionReestablishmentComplete_v1020_IEs_sequence[] = {
  { &hf_lte_rrc_logMeasAvailable_r10_01, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lte_rrc_T_logMeasAvailable_r10_01 },
  { &hf_lte_rrc_nonCriticalExtension_47, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lte_rrc_T_nonCriticalExtension_21 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_RRCConnectionReestablishmentComplete_v1020_IEs(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_RRCConnectionReestablishmentComplete_v1020_IEs, RRCConnectionReestablishmentComplete_v1020_IEs_sequence);

  return offset;
}


static const per_sequence_t RRCConnectionReestablishmentComplete_v8a0_IEs_sequence[] = {
  { &hf_lte_rrc_lateNonCriticalExtension, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lte_rrc_OCTET_STRING },
  { &hf_lte_rrc_nonCriticalExtension_46, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lte_rrc_RRCConnectionReestablishmentComplete_v1020_IEs },
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_RRCConnectionReestablishmentComplete_v8a0_IEs(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_RRCConnectionReestablishmentComplete_v8a0_IEs, RRCConnectionReestablishmentComplete_v8a0_IEs_sequence);

  return offset;
}


static const per_sequence_t RRCConnectionReestablishmentComplete_v920_IEs_sequence[] = {
  { &hf_lte_rrc_rlf_InfoAvailable_r9, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lte_rrc_T_rlf_InfoAvailable_r9 },
  { &hf_lte_rrc_nonCriticalExtension_45, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lte_rrc_RRCConnectionReestablishmentComplete_v8a0_IEs },
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_RRCConnectionReestablishmentComplete_v920_IEs(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_RRCConnectionReestablishmentComplete_v920_IEs, RRCConnectionReestablishmentComplete_v920_IEs_sequence);

  return offset;
}


static const per_sequence_t RRCConnectionReestablishmentComplete_r8_IEs_sequence[] = {
  { &hf_lte_rrc_nonCriticalExtension_44, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lte_rrc_RRCConnectionReestablishmentComplete_v920_IEs },
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_RRCConnectionReestablishmentComplete_r8_IEs(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_RRCConnectionReestablishmentComplete_r8_IEs, RRCConnectionReestablishmentComplete_r8_IEs_sequence);

  return offset;
}


static const per_sequence_t T_criticalExtensionsFuture_17_sequence[] = {
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_T_criticalExtensionsFuture_17(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_T_criticalExtensionsFuture_17, T_criticalExtensionsFuture_17_sequence);

  return offset;
}


static const value_string lte_rrc_T_criticalExtensions_17_vals[] = {
  {   0, "rrcConnectionReestablishmentComplete-r8" },
  {   1, "criticalExtensionsFuture" },
  { 0, NULL }
};

static const per_choice_t T_criticalExtensions_17_choice[] = {
  {   0, &hf_lte_rrc_rrcConnectionReestablishmentComplete_r8, ASN1_NO_EXTENSIONS     , dissect_lte_rrc_RRCConnectionReestablishmentComplete_r8_IEs },
  {   1, &hf_lte_rrc_criticalExtensionsFuture_17, ASN1_NO_EXTENSIONS     , dissect_lte_rrc_T_criticalExtensionsFuture_17 },
  { 0, NULL, 0, NULL }
};

static int
dissect_lte_rrc_T_criticalExtensions_17(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_lte_rrc_T_criticalExtensions_17, T_criticalExtensions_17_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t RRCConnectionReestablishmentComplete_sequence[] = {
  { &hf_lte_rrc_rrc_TransactionIdentifier, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_RRC_TransactionIdentifier },
  { &hf_lte_rrc_criticalExtensions_17, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_T_criticalExtensions_17 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_RRCConnectionReestablishmentComplete(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {

col_append_str(actx->pinfo->cinfo, COL_INFO, "RRCConnectionReestablishmentComplete ");

  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_RRCConnectionReestablishmentComplete, RRCConnectionReestablishmentComplete_sequence);

  return offset;
}


static const per_sequence_t RegisteredMME_sequence[] = {
  { &hf_lte_rrc_plmn_Identity, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lte_rrc_PLMN_Identity },
  { &hf_lte_rrc_mmegi       , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_BIT_STRING_SIZE_16 },
  { &hf_lte_rrc_mmec        , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_MMEC },
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_RegisteredMME(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_RegisteredMME, RegisteredMME_sequence);

  return offset;
}


static const value_string lte_rrc_T_gummei_Type_r10_vals[] = {
  {   0, "native" },
  {   1, "mapped" },
  { 0, NULL }
};


static int
dissect_lte_rrc_T_gummei_Type_r10(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, FALSE, 0, NULL);

  return offset;
}


static const value_string lte_rrc_T_rlf_InfoAvailable_r10_01_vals[] = {
  {   0, "true" },
  { 0, NULL }
};


static int
dissect_lte_rrc_T_rlf_InfoAvailable_r10_01(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, FALSE, 0, NULL);

  return offset;
}


static const value_string lte_rrc_T_logMeasAvailable_r10_02_vals[] = {
  {   0, "true" },
  { 0, NULL }
};


static int
dissect_lte_rrc_T_logMeasAvailable_r10_02(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, FALSE, 0, NULL);

  return offset;
}


static const value_string lte_rrc_T_rn_SubframeConfigReq_r10_vals[] = {
  {   0, "required" },
  {   1, "notRequired" },
  { 0, NULL }
};


static int
dissect_lte_rrc_T_rn_SubframeConfigReq_r10(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, FALSE, 0, NULL);

  return offset;
}


static const per_sequence_t T_nonCriticalExtension_26_sequence[] = {
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_T_nonCriticalExtension_26(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_T_nonCriticalExtension_26, T_nonCriticalExtension_26_sequence);

  return offset;
}


static const per_sequence_t RRCConnectionSetupComplete_v1020_IEs_sequence[] = {
  { &hf_lte_rrc_gummei_Type_r10, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lte_rrc_T_gummei_Type_r10 },
  { &hf_lte_rrc_rlf_InfoAvailable_r10_01, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lte_rrc_T_rlf_InfoAvailable_r10_01 },
  { &hf_lte_rrc_logMeasAvailable_r10_02, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lte_rrc_T_logMeasAvailable_r10_02 },
  { &hf_lte_rrc_rn_SubframeConfigReq_r10, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lte_rrc_T_rn_SubframeConfigReq_r10 },
  { &hf_lte_rrc_nonCriticalExtension_61, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lte_rrc_T_nonCriticalExtension_26 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_RRCConnectionSetupComplete_v1020_IEs(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_RRCConnectionSetupComplete_v1020_IEs, RRCConnectionSetupComplete_v1020_IEs_sequence);

  return offset;
}


static const per_sequence_t RRCConnectionSetupComplete_v8a0_IEs_sequence[] = {
  { &hf_lte_rrc_lateNonCriticalExtension, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lte_rrc_OCTET_STRING },
  { &hf_lte_rrc_nonCriticalExtension_60, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lte_rrc_RRCConnectionSetupComplete_v1020_IEs },
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_RRCConnectionSetupComplete_v8a0_IEs(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_RRCConnectionSetupComplete_v8a0_IEs, RRCConnectionSetupComplete_v8a0_IEs_sequence);

  return offset;
}


static const per_sequence_t RRCConnectionSetupComplete_r8_IEs_sequence[] = {
  { &hf_lte_rrc_selectedPLMN_Identity, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_INTEGER_1_6 },
  { &hf_lte_rrc_registeredMME, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lte_rrc_RegisteredMME },
  { &hf_lte_rrc_dedicatedInfoNAS, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_DedicatedInfoNAS },
  { &hf_lte_rrc_nonCriticalExtension_59, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lte_rrc_RRCConnectionSetupComplete_v8a0_IEs },
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_RRCConnectionSetupComplete_r8_IEs(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_RRCConnectionSetupComplete_r8_IEs, RRCConnectionSetupComplete_r8_IEs_sequence);

  return offset;
}


static const value_string lte_rrc_T_c1_23_vals[] = {
  {   0, "rrcConnectionSetupComplete-r8" },
  {   1, "spare3" },
  {   2, "spare2" },
  {   3, "spare1" },
  { 0, NULL }
};

static const per_choice_t T_c1_23_choice[] = {
  {   0, &hf_lte_rrc_rrcConnectionSetupComplete_r8, ASN1_NO_EXTENSIONS     , dissect_lte_rrc_RRCConnectionSetupComplete_r8_IEs },
  {   1, &hf_lte_rrc_spare3      , ASN1_NO_EXTENSIONS     , dissect_lte_rrc_NULL },
  {   2, &hf_lte_rrc_spare2      , ASN1_NO_EXTENSIONS     , dissect_lte_rrc_NULL },
  {   3, &hf_lte_rrc_spare1      , ASN1_NO_EXTENSIONS     , dissect_lte_rrc_NULL },
  { 0, NULL, 0, NULL }
};

static int
dissect_lte_rrc_T_c1_23(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_lte_rrc_T_c1_23, T_c1_23_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t T_criticalExtensionsFuture_24_sequence[] = {
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_T_criticalExtensionsFuture_24(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_T_criticalExtensionsFuture_24, T_criticalExtensionsFuture_24_sequence);

  return offset;
}


static const value_string lte_rrc_T_criticalExtensions_24_vals[] = {
  {   0, "c1" },
  {   1, "criticalExtensionsFuture" },
  { 0, NULL }
};

static const per_choice_t T_criticalExtensions_24_choice[] = {
  {   0, &hf_lte_rrc_c1_23       , ASN1_NO_EXTENSIONS     , dissect_lte_rrc_T_c1_23 },
  {   1, &hf_lte_rrc_criticalExtensionsFuture_24, ASN1_NO_EXTENSIONS     , dissect_lte_rrc_T_criticalExtensionsFuture_24 },
  { 0, NULL, 0, NULL }
};

static int
dissect_lte_rrc_T_criticalExtensions_24(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_lte_rrc_T_criticalExtensions_24, T_criticalExtensions_24_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t RRCConnectionSetupComplete_sequence[] = {
  { &hf_lte_rrc_rrc_TransactionIdentifier, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_RRC_TransactionIdentifier },
  { &hf_lte_rrc_criticalExtensions_24, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_T_criticalExtensions_24 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_RRCConnectionSetupComplete(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {

col_append_str(actx->pinfo->cinfo, COL_INFO, "RRCConnectionSetupComplete ");

  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_RRCConnectionSetupComplete, RRCConnectionSetupComplete_sequence);

  return offset;
}


static const per_sequence_t T_nonCriticalExtension_28_sequence[] = {
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_T_nonCriticalExtension_28(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_T_nonCriticalExtension_28, T_nonCriticalExtension_28_sequence);

  return offset;
}


static const per_sequence_t SecurityModeComplete_v8a0_IEs_sequence[] = {
  { &hf_lte_rrc_lateNonCriticalExtension, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lte_rrc_OCTET_STRING },
  { &hf_lte_rrc_nonCriticalExtension_65, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lte_rrc_T_nonCriticalExtension_28 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_SecurityModeComplete_v8a0_IEs(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_SecurityModeComplete_v8a0_IEs, SecurityModeComplete_v8a0_IEs_sequence);

  return offset;
}


static const per_sequence_t SecurityModeComplete_r8_IEs_sequence[] = {
  { &hf_lte_rrc_nonCriticalExtension_64, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lte_rrc_SecurityModeComplete_v8a0_IEs },
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_SecurityModeComplete_r8_IEs(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_SecurityModeComplete_r8_IEs, SecurityModeComplete_r8_IEs_sequence);

  return offset;
}


static const per_sequence_t T_criticalExtensionsFuture_26_sequence[] = {
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_T_criticalExtensionsFuture_26(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_T_criticalExtensionsFuture_26, T_criticalExtensionsFuture_26_sequence);

  return offset;
}


static const value_string lte_rrc_T_criticalExtensions_26_vals[] = {
  {   0, "securityModeComplete-r8" },
  {   1, "criticalExtensionsFuture" },
  { 0, NULL }
};

static const per_choice_t T_criticalExtensions_26_choice[] = {
  {   0, &hf_lte_rrc_securityModeComplete_r8, ASN1_NO_EXTENSIONS     , dissect_lte_rrc_SecurityModeComplete_r8_IEs },
  {   1, &hf_lte_rrc_criticalExtensionsFuture_26, ASN1_NO_EXTENSIONS     , dissect_lte_rrc_T_criticalExtensionsFuture_26 },
  { 0, NULL, 0, NULL }
};

static int
dissect_lte_rrc_T_criticalExtensions_26(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_lte_rrc_T_criticalExtensions_26, T_criticalExtensions_26_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t SecurityModeComplete_sequence[] = {
  { &hf_lte_rrc_rrc_TransactionIdentifier, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_RRC_TransactionIdentifier },
  { &hf_lte_rrc_criticalExtensions_26, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_T_criticalExtensions_26 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_SecurityModeComplete(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {

col_append_str(actx->pinfo->cinfo, COL_INFO, "SecurityModeComplete ");

  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_SecurityModeComplete, SecurityModeComplete_sequence);

  return offset;
}


static const per_sequence_t T_nonCriticalExtension_29_sequence[] = {
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_T_nonCriticalExtension_29(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_T_nonCriticalExtension_29, T_nonCriticalExtension_29_sequence);

  return offset;
}


static const per_sequence_t SecurityModeFailure_v8a0_IEs_sequence[] = {
  { &hf_lte_rrc_lateNonCriticalExtension, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lte_rrc_OCTET_STRING },
  { &hf_lte_rrc_nonCriticalExtension_67, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lte_rrc_T_nonCriticalExtension_29 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_SecurityModeFailure_v8a0_IEs(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_SecurityModeFailure_v8a0_IEs, SecurityModeFailure_v8a0_IEs_sequence);

  return offset;
}


static const per_sequence_t SecurityModeFailure_r8_IEs_sequence[] = {
  { &hf_lte_rrc_nonCriticalExtension_66, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lte_rrc_SecurityModeFailure_v8a0_IEs },
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_SecurityModeFailure_r8_IEs(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_SecurityModeFailure_r8_IEs, SecurityModeFailure_r8_IEs_sequence);

  return offset;
}


static const per_sequence_t T_criticalExtensionsFuture_27_sequence[] = {
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_T_criticalExtensionsFuture_27(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_T_criticalExtensionsFuture_27, T_criticalExtensionsFuture_27_sequence);

  return offset;
}


static const value_string lte_rrc_T_criticalExtensions_27_vals[] = {
  {   0, "securityModeFailure-r8" },
  {   1, "criticalExtensionsFuture" },
  { 0, NULL }
};

static const per_choice_t T_criticalExtensions_27_choice[] = {
  {   0, &hf_lte_rrc_securityModeFailure_r8, ASN1_NO_EXTENSIONS     , dissect_lte_rrc_SecurityModeFailure_r8_IEs },
  {   1, &hf_lte_rrc_criticalExtensionsFuture_27, ASN1_NO_EXTENSIONS     , dissect_lte_rrc_T_criticalExtensionsFuture_27 },
  { 0, NULL, 0, NULL }
};

static int
dissect_lte_rrc_T_criticalExtensions_27(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_lte_rrc_T_criticalExtensions_27, T_criticalExtensions_27_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t SecurityModeFailure_sequence[] = {
  { &hf_lte_rrc_rrc_TransactionIdentifier, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_RRC_TransactionIdentifier },
  { &hf_lte_rrc_criticalExtensions_27, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_T_criticalExtensions_27 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_SecurityModeFailure(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {

col_append_str(actx->pinfo->cinfo, COL_INFO, "SecurityModeFailure ");

  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_SecurityModeFailure, SecurityModeFailure_sequence);

  return offset;
}



static int
dissect_lte_rrc_T_ueCapabilityRAT_Container(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  tvbuff_t *ue_eutra_cap_tvb=NULL;
  offset = dissect_per_octet_string(tvb, offset, actx, tree, hf_index,
                                       NO_BOUND, NO_BOUND, FALSE, &ue_eutra_cap_tvb);



if(ue_eutra_cap_tvb){
	guint32 length;
	proto_item *item;
	proto_tree *subtree;
	guint8 byte;
	switch(lte_rrc_rat_type_value){
	case 0:
		/* eutra */
		dissect_lte_rrc_UE_EUTRA_Capability_PDU(ue_eutra_cap_tvb, actx->pinfo, tree);
		break;
	case 1:
		/* utra */
		dissect_rrc_InterRATHandoverInfo_PDU(ue_eutra_cap_tvb, actx->pinfo, tree);
		break;
	case 2:
		/* geran-cs */
		/* Mobile Station Classmark 2 is formatted as TLV with the two first bytes set to 0x33 0x03 */
		item = proto_tree_add_text(tree, ue_eutra_cap_tvb, 0, 5, "Mobile Station Classmark 2");
		subtree = proto_item_add_subtree(item, ett_lte_rrc_UE_CapabilityRAT_Container);
		byte = tvb_get_guint8(ue_eutra_cap_tvb, 0);
		if (byte != 0x33) {
			expert_add_info_format(actx->pinfo, item, PI_MALFORMED, PI_ERROR,
				"Unexpected type value (found 0x%02X)", byte);
		}
		byte = tvb_get_guint8(ue_eutra_cap_tvb, 1);
		if (byte != 0x03) {
			expert_add_info_format(actx->pinfo, item, PI_MALFORMED, PI_ERROR,
				"Unexpected length value (found %d)", byte);
		}
		de_ms_cm_2(ue_eutra_cap_tvb, subtree, actx->pinfo, 2, 3, NULL, 0);
		/* Mobile Station Classmark 3 is formatted as V */
		length = tvb_length(ue_eutra_cap_tvb)-5;
		item = proto_tree_add_text(tree, ue_eutra_cap_tvb, 5, length, "Mobile Station Classmark 3");
		subtree = proto_item_add_subtree(item, ett_lte_rrc_UE_CapabilityRAT_Container);
		de_ms_cm_3(ue_eutra_cap_tvb, subtree, actx->pinfo, 5, length, NULL, 0);
		break;
	case 3:
		/* geran-ps */
		/* MS Radio Access Capability is formatted as V */
		length = tvb_length(ue_eutra_cap_tvb);
		item = proto_tree_add_text(tree, ue_eutra_cap_tvb, 0, length, "MS Radio Access Capability");
		subtree = proto_item_add_subtree(item, ett_lte_rrc_UE_CapabilityRAT_Container);
		de_gmm_ms_radio_acc_cap(ue_eutra_cap_tvb, subtree, actx->pinfo, 0, length, NULL, 0);
		break;
	case 4:
		/* cdma2000-1XRTT */
		/* dissection of "A21 Mobile Subscription Information" could be added to packet-ansi_a.c */
		break;
	default:
		break;
	}
}

  return offset;
}


static const per_sequence_t UE_CapabilityRAT_Container_sequence[] = {
  { &hf_lte_rrc_rat_Type    , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_RAT_Type },
  { &hf_lte_rrc_ueCapabilityRAT_Container, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_T_ueCapabilityRAT_Container },
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_UE_CapabilityRAT_Container(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  lte_rrc_rat_type_value = -1;
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_UE_CapabilityRAT_Container, UE_CapabilityRAT_Container_sequence);



  return offset;
}


static const per_sequence_t UE_CapabilityRAT_ContainerList_sequence_of[1] = {
  { &hf_lte_rrc_UE_CapabilityRAT_ContainerList_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_UE_CapabilityRAT_Container },
};

static int
dissect_lte_rrc_UE_CapabilityRAT_ContainerList(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_lte_rrc_UE_CapabilityRAT_ContainerList, UE_CapabilityRAT_ContainerList_sequence_of,
                                                  0, maxRAT_Capabilities, FALSE);

  return offset;
}


static const per_sequence_t T_nonCriticalExtension_33_sequence[] = {
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_T_nonCriticalExtension_33(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_T_nonCriticalExtension_33, T_nonCriticalExtension_33_sequence);

  return offset;
}


static const per_sequence_t UECapabilityInformation_v8a0_IEs_sequence[] = {
  { &hf_lte_rrc_lateNonCriticalExtension, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lte_rrc_OCTET_STRING },
  { &hf_lte_rrc_nonCriticalExtension_76, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lte_rrc_T_nonCriticalExtension_33 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_UECapabilityInformation_v8a0_IEs(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_UECapabilityInformation_v8a0_IEs, UECapabilityInformation_v8a0_IEs_sequence);

  return offset;
}


static const per_sequence_t UECapabilityInformation_r8_IEs_sequence[] = {
  { &hf_lte_rrc_ue_CapabilityRAT_ContainerList, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_UE_CapabilityRAT_ContainerList },
  { &hf_lte_rrc_nonCriticalExtension_75, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lte_rrc_UECapabilityInformation_v8a0_IEs },
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_UECapabilityInformation_r8_IEs(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_UECapabilityInformation_r8_IEs, UECapabilityInformation_r8_IEs_sequence);

  return offset;
}


static const value_string lte_rrc_T_c1_26_vals[] = {
  {   0, "ueCapabilityInformation-r8" },
  {   1, "spare7" },
  {   2, "spare6" },
  {   3, "spare5" },
  {   4, "spare4" },
  {   5, "spare3" },
  {   6, "spare2" },
  {   7, "spare1" },
  { 0, NULL }
};

static const per_choice_t T_c1_26_choice[] = {
  {   0, &hf_lte_rrc_ueCapabilityInformation_r8, ASN1_NO_EXTENSIONS     , dissect_lte_rrc_UECapabilityInformation_r8_IEs },
  {   1, &hf_lte_rrc_spare7      , ASN1_NO_EXTENSIONS     , dissect_lte_rrc_NULL },
  {   2, &hf_lte_rrc_spare6      , ASN1_NO_EXTENSIONS     , dissect_lte_rrc_NULL },
  {   3, &hf_lte_rrc_spare5      , ASN1_NO_EXTENSIONS     , dissect_lte_rrc_NULL },
  {   4, &hf_lte_rrc_spare4      , ASN1_NO_EXTENSIONS     , dissect_lte_rrc_NULL },
  {   5, &hf_lte_rrc_spare3      , ASN1_NO_EXTENSIONS     , dissect_lte_rrc_NULL },
  {   6, &hf_lte_rrc_spare2      , ASN1_NO_EXTENSIONS     , dissect_lte_rrc_NULL },
  {   7, &hf_lte_rrc_spare1      , ASN1_NO_EXTENSIONS     , dissect_lte_rrc_NULL },
  { 0, NULL, 0, NULL }
};

static int
dissect_lte_rrc_T_c1_26(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_lte_rrc_T_c1_26, T_c1_26_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t T_criticalExtensionsFuture_30_sequence[] = {
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_T_criticalExtensionsFuture_30(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_T_criticalExtensionsFuture_30, T_criticalExtensionsFuture_30_sequence);

  return offset;
}


static const value_string lte_rrc_T_criticalExtensions_30_vals[] = {
  {   0, "c1" },
  {   1, "criticalExtensionsFuture" },
  { 0, NULL }
};

static const per_choice_t T_criticalExtensions_30_choice[] = {
  {   0, &hf_lte_rrc_c1_26       , ASN1_NO_EXTENSIONS     , dissect_lte_rrc_T_c1_26 },
  {   1, &hf_lte_rrc_criticalExtensionsFuture_30, ASN1_NO_EXTENSIONS     , dissect_lte_rrc_T_criticalExtensionsFuture_30 },
  { 0, NULL, 0, NULL }
};

static int
dissect_lte_rrc_T_criticalExtensions_30(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_lte_rrc_T_criticalExtensions_30, T_criticalExtensions_30_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t UECapabilityInformation_sequence[] = {
  { &hf_lte_rrc_rrc_TransactionIdentifier, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_RRC_TransactionIdentifier },
  { &hf_lte_rrc_criticalExtensions_30, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_T_criticalExtensions_30 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_UECapabilityInformation(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {

col_append_str(actx->pinfo->cinfo, COL_INFO, "UECapabilityInformation ");

  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_UECapabilityInformation, UECapabilityInformation_sequence);

  return offset;
}



static int
dissect_lte_rrc_BIT_STRING_SIZE_56(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     56, 56, FALSE, NULL);

  return offset;
}


static const per_sequence_t T_nonCriticalExtension_36_sequence[] = {
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_T_nonCriticalExtension_36(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_T_nonCriticalExtension_36, T_nonCriticalExtension_36_sequence);

  return offset;
}


static const per_sequence_t ULHandoverPreparationTransfer_v8a0_IEs_sequence[] = {
  { &hf_lte_rrc_lateNonCriticalExtension, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lte_rrc_OCTET_STRING },
  { &hf_lte_rrc_nonCriticalExtension_84, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lte_rrc_T_nonCriticalExtension_36 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_ULHandoverPreparationTransfer_v8a0_IEs(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_ULHandoverPreparationTransfer_v8a0_IEs, ULHandoverPreparationTransfer_v8a0_IEs_sequence);

  return offset;
}


static const per_sequence_t ULHandoverPreparationTransfer_r8_IEs_sequence[] = {
  { &hf_lte_rrc_cdma2000_Type, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_CDMA2000_Type },
  { &hf_lte_rrc_meid        , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lte_rrc_BIT_STRING_SIZE_56 },
  { &hf_lte_rrc_dedicatedInfo, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_DedicatedInfoCDMA2000 },
  { &hf_lte_rrc_nonCriticalExtension_83, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lte_rrc_ULHandoverPreparationTransfer_v8a0_IEs },
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_ULHandoverPreparationTransfer_r8_IEs(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_ULHandoverPreparationTransfer_r8_IEs, ULHandoverPreparationTransfer_r8_IEs_sequence);

  return offset;
}


static const value_string lte_rrc_T_c1_29_vals[] = {
  {   0, "ulHandoverPreparationTransfer-r8" },
  {   1, "spare3" },
  {   2, "spare2" },
  {   3, "spare1" },
  { 0, NULL }
};

static const per_choice_t T_c1_29_choice[] = {
  {   0, &hf_lte_rrc_ulHandoverPreparationTransfer_r8, ASN1_NO_EXTENSIONS     , dissect_lte_rrc_ULHandoverPreparationTransfer_r8_IEs },
  {   1, &hf_lte_rrc_spare3      , ASN1_NO_EXTENSIONS     , dissect_lte_rrc_NULL },
  {   2, &hf_lte_rrc_spare2      , ASN1_NO_EXTENSIONS     , dissect_lte_rrc_NULL },
  {   3, &hf_lte_rrc_spare1      , ASN1_NO_EXTENSIONS     , dissect_lte_rrc_NULL },
  { 0, NULL, 0, NULL }
};

static int
dissect_lte_rrc_T_c1_29(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_lte_rrc_T_c1_29, T_c1_29_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t T_criticalExtensionsFuture_33_sequence[] = {
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_T_criticalExtensionsFuture_33(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_T_criticalExtensionsFuture_33, T_criticalExtensionsFuture_33_sequence);

  return offset;
}


static const value_string lte_rrc_T_criticalExtensions_33_vals[] = {
  {   0, "c1" },
  {   1, "criticalExtensionsFuture" },
  { 0, NULL }
};

static const per_choice_t T_criticalExtensions_33_choice[] = {
  {   0, &hf_lte_rrc_c1_29       , ASN1_NO_EXTENSIONS     , dissect_lte_rrc_T_c1_29 },
  {   1, &hf_lte_rrc_criticalExtensionsFuture_33, ASN1_NO_EXTENSIONS     , dissect_lte_rrc_T_criticalExtensionsFuture_33 },
  { 0, NULL, 0, NULL }
};

static int
dissect_lte_rrc_T_criticalExtensions_33(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_lte_rrc_T_criticalExtensions_33, T_criticalExtensions_33_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t ULHandoverPreparationTransfer_sequence[] = {
  { &hf_lte_rrc_criticalExtensions_33, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_T_criticalExtensions_33 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_ULHandoverPreparationTransfer(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {

col_append_str(actx->pinfo->cinfo, COL_INFO, "ULHandoverPreparationTransfer ");

  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_ULHandoverPreparationTransfer, ULHandoverPreparationTransfer_sequence);

  return offset;
}


static const value_string lte_rrc_T_dedicatedInfoType_01_vals[] = {
  {   0, "dedicatedInfoNAS" },
  {   1, "dedicatedInfoCDMA2000-1XRTT" },
  {   2, "dedicatedInfoCDMA2000-HRPD" },
  { 0, NULL }
};

static const per_choice_t T_dedicatedInfoType_01_choice[] = {
  {   0, &hf_lte_rrc_dedicatedInfoNAS, ASN1_NO_EXTENSIONS     , dissect_lte_rrc_DedicatedInfoNAS },
  {   1, &hf_lte_rrc_dedicatedInfoCDMA2000_1XRTT, ASN1_NO_EXTENSIONS     , dissect_lte_rrc_DedicatedInfoCDMA2000 },
  {   2, &hf_lte_rrc_dedicatedInfoCDMA2000_HRPD, ASN1_NO_EXTENSIONS     , dissect_lte_rrc_DedicatedInfoCDMA2000 },
  { 0, NULL, 0, NULL }
};

static int
dissect_lte_rrc_T_dedicatedInfoType_01(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_lte_rrc_T_dedicatedInfoType_01, T_dedicatedInfoType_01_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t T_nonCriticalExtension_37_sequence[] = {
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_T_nonCriticalExtension_37(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_T_nonCriticalExtension_37, T_nonCriticalExtension_37_sequence);

  return offset;
}


static const per_sequence_t ULInformationTransfer_v8a0_IEs_sequence[] = {
  { &hf_lte_rrc_lateNonCriticalExtension, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lte_rrc_OCTET_STRING },
  { &hf_lte_rrc_nonCriticalExtension_86, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lte_rrc_T_nonCriticalExtension_37 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_ULInformationTransfer_v8a0_IEs(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_ULInformationTransfer_v8a0_IEs, ULInformationTransfer_v8a0_IEs_sequence);

  return offset;
}


static const per_sequence_t ULInformationTransfer_r8_IEs_sequence[] = {
  { &hf_lte_rrc_dedicatedInfoType_01, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_T_dedicatedInfoType_01 },
  { &hf_lte_rrc_nonCriticalExtension_85, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lte_rrc_ULInformationTransfer_v8a0_IEs },
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_ULInformationTransfer_r8_IEs(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_ULInformationTransfer_r8_IEs, ULInformationTransfer_r8_IEs_sequence);

  return offset;
}


static const value_string lte_rrc_T_c1_30_vals[] = {
  {   0, "ulInformationTransfer-r8" },
  {   1, "spare3" },
  {   2, "spare2" },
  {   3, "spare1" },
  { 0, NULL }
};

static const per_choice_t T_c1_30_choice[] = {
  {   0, &hf_lte_rrc_ulInformationTransfer_r8, ASN1_NO_EXTENSIONS     , dissect_lte_rrc_ULInformationTransfer_r8_IEs },
  {   1, &hf_lte_rrc_spare3      , ASN1_NO_EXTENSIONS     , dissect_lte_rrc_NULL },
  {   2, &hf_lte_rrc_spare2      , ASN1_NO_EXTENSIONS     , dissect_lte_rrc_NULL },
  {   3, &hf_lte_rrc_spare1      , ASN1_NO_EXTENSIONS     , dissect_lte_rrc_NULL },
  { 0, NULL, 0, NULL }
};

static int
dissect_lte_rrc_T_c1_30(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_lte_rrc_T_c1_30, T_c1_30_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t T_criticalExtensionsFuture_34_sequence[] = {
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_T_criticalExtensionsFuture_34(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_T_criticalExtensionsFuture_34, T_criticalExtensionsFuture_34_sequence);

  return offset;
}


static const value_string lte_rrc_T_criticalExtensions_34_vals[] = {
  {   0, "c1" },
  {   1, "criticalExtensionsFuture" },
  { 0, NULL }
};

static const per_choice_t T_criticalExtensions_34_choice[] = {
  {   0, &hf_lte_rrc_c1_30       , ASN1_NO_EXTENSIONS     , dissect_lte_rrc_T_c1_30 },
  {   1, &hf_lte_rrc_criticalExtensionsFuture_34, ASN1_NO_EXTENSIONS     , dissect_lte_rrc_T_criticalExtensionsFuture_34 },
  { 0, NULL, 0, NULL }
};

static int
dissect_lte_rrc_T_criticalExtensions_34(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_lte_rrc_T_criticalExtensions_34, T_criticalExtensions_34_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t ULInformationTransfer_sequence[] = {
  { &hf_lte_rrc_criticalExtensions_34, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_T_criticalExtensions_34 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_ULInformationTransfer(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {

col_append_str(actx->pinfo->cinfo, COL_INFO, "ULInformationTransfer ");

  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_ULInformationTransfer, ULInformationTransfer_sequence);

  return offset;
}



static int
dissect_lte_rrc_INTEGER_0_4294967295(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 4294967295U, NULL, FALSE);

  return offset;
}


static const per_sequence_t DRB_CountInfo_sequence[] = {
  { &hf_lte_rrc_drb_Identity, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_DRB_Identity },
  { &hf_lte_rrc_count_Uplink, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_INTEGER_0_4294967295 },
  { &hf_lte_rrc_count_Downlink, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_INTEGER_0_4294967295 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_DRB_CountInfo(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_DRB_CountInfo, DRB_CountInfo_sequence);

  return offset;
}


static const per_sequence_t DRB_CountInfoList_sequence_of[1] = {
  { &hf_lte_rrc_DRB_CountInfoList_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_DRB_CountInfo },
};

static int
dissect_lte_rrc_DRB_CountInfoList(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_lte_rrc_DRB_CountInfoList, DRB_CountInfoList_sequence_of,
                                                  0, maxDRB, FALSE);

  return offset;
}


static const per_sequence_t T_nonCriticalExtension_01_sequence[] = {
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_T_nonCriticalExtension_01(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_T_nonCriticalExtension_01, T_nonCriticalExtension_01_sequence);

  return offset;
}


static const per_sequence_t CounterCheckResponse_v8a0_IEs_sequence[] = {
  { &hf_lte_rrc_lateNonCriticalExtension, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lte_rrc_OCTET_STRING },
  { &hf_lte_rrc_nonCriticalExtension_03, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lte_rrc_T_nonCriticalExtension_01 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_CounterCheckResponse_v8a0_IEs(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_CounterCheckResponse_v8a0_IEs, CounterCheckResponse_v8a0_IEs_sequence);

  return offset;
}


static const per_sequence_t CounterCheckResponse_r8_IEs_sequence[] = {
  { &hf_lte_rrc_drb_CountInfoList, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_DRB_CountInfoList },
  { &hf_lte_rrc_nonCriticalExtension_02, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lte_rrc_CounterCheckResponse_v8a0_IEs },
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_CounterCheckResponse_r8_IEs(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_CounterCheckResponse_r8_IEs, CounterCheckResponse_r8_IEs_sequence);

  return offset;
}


static const per_sequence_t T_criticalExtensionsFuture_01_sequence[] = {
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_T_criticalExtensionsFuture_01(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_T_criticalExtensionsFuture_01, T_criticalExtensionsFuture_01_sequence);

  return offset;
}


static const value_string lte_rrc_T_criticalExtensions_01_vals[] = {
  {   0, "counterCheckResponse-r8" },
  {   1, "criticalExtensionsFuture" },
  { 0, NULL }
};

static const per_choice_t T_criticalExtensions_01_choice[] = {
  {   0, &hf_lte_rrc_counterCheckResponse_r8, ASN1_NO_EXTENSIONS     , dissect_lte_rrc_CounterCheckResponse_r8_IEs },
  {   1, &hf_lte_rrc_criticalExtensionsFuture_01, ASN1_NO_EXTENSIONS     , dissect_lte_rrc_T_criticalExtensionsFuture_01 },
  { 0, NULL, 0, NULL }
};

static int
dissect_lte_rrc_T_criticalExtensions_01(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_lte_rrc_T_criticalExtensions_01, T_criticalExtensions_01_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t CounterCheckResponse_sequence[] = {
  { &hf_lte_rrc_rrc_TransactionIdentifier, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_RRC_TransactionIdentifier },
  { &hf_lte_rrc_criticalExtensions_01, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_T_criticalExtensions_01 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_CounterCheckResponse(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {

col_append_str(actx->pinfo->cinfo, COL_INFO, "CounterCheckResponse ");

  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_CounterCheckResponse, CounterCheckResponse_sequence);

  return offset;
}



static int
dissect_lte_rrc_INTEGER_1_200(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            1U, 200U, NULL, FALSE);

  return offset;
}


static const per_sequence_t T_rach_Report_r9_sequence[] = {
  { &hf_lte_rrc_numberOfPreamblesSent_r9, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_INTEGER_1_200 },
  { &hf_lte_rrc_contentionDetected_r9, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_BOOLEAN },
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_T_rach_Report_r9(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_T_rach_Report_r9, T_rach_Report_r9_sequence);

  return offset;
}


static const per_sequence_t T_measResultLastServCell_r9_sequence[] = {
  { &hf_lte_rrc_rsrpResult_r9, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_RSRP_Range },
  { &hf_lte_rrc_rsrqResult_r9, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lte_rrc_RSRQ_Range },
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_T_measResultLastServCell_r9(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_T_measResultLastServCell_r9, T_measResultLastServCell_r9_sequence);

  return offset;
}


static const per_sequence_t MeasResult2EUTRA_r9_sequence[] = {
  { &hf_lte_rrc_carrierFreq_r9_02, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_ARFCN_ValueEUTRA },
  { &hf_lte_rrc_measResultList_r9, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_MeasResultListEUTRA },
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_MeasResult2EUTRA_r9(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_MeasResult2EUTRA_r9, MeasResult2EUTRA_r9_sequence);

  return offset;
}


static const per_sequence_t MeasResultList2EUTRA_r9_sequence_of[1] = {
  { &hf_lte_rrc_MeasResultList2EUTRA_r9_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_MeasResult2EUTRA_r9 },
};

static int
dissect_lte_rrc_MeasResultList2EUTRA_r9(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_lte_rrc_MeasResultList2EUTRA_r9, MeasResultList2EUTRA_r9_sequence_of,
                                                  1, maxFreq, FALSE);

  return offset;
}


static const per_sequence_t MeasResult2UTRA_r9_sequence[] = {
  { &hf_lte_rrc_carrierFreq_r9_03, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_ARFCN_ValueUTRA },
  { &hf_lte_rrc_measResultList_r9_01, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_MeasResultListUTRA },
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_MeasResult2UTRA_r9(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_MeasResult2UTRA_r9, MeasResult2UTRA_r9_sequence);

  return offset;
}


static const per_sequence_t MeasResultList2UTRA_r9_sequence_of[1] = {
  { &hf_lte_rrc_MeasResultList2UTRA_r9_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_MeasResult2UTRA_r9 },
};

static int
dissect_lte_rrc_MeasResultList2UTRA_r9(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_lte_rrc_MeasResultList2UTRA_r9, MeasResultList2UTRA_r9_sequence_of,
                                                  1, maxFreq, FALSE);

  return offset;
}


static const per_sequence_t MeasResult2CDMA2000_r9_sequence[] = {
  { &hf_lte_rrc_carrierFreq_r9_04, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_CarrierFreqCDMA2000 },
  { &hf_lte_rrc_measResultList_r9_02, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_MeasResultsCDMA2000 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_MeasResult2CDMA2000_r9(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_MeasResult2CDMA2000_r9, MeasResult2CDMA2000_r9_sequence);

  return offset;
}


static const per_sequence_t MeasResultList2CDMA2000_r9_sequence_of[1] = {
  { &hf_lte_rrc_MeasResultList2CDMA2000_r9_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_MeasResult2CDMA2000_r9 },
};

static int
dissect_lte_rrc_MeasResultList2CDMA2000_r9(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_lte_rrc_MeasResultList2CDMA2000_r9, MeasResultList2CDMA2000_r9_sequence_of,
                                                  1, maxFreq, FALSE);

  return offset;
}


static const per_sequence_t T_measResultNeighCells_r9_sequence[] = {
  { &hf_lte_rrc_measResultListEUTRA_r9, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lte_rrc_MeasResultList2EUTRA_r9 },
  { &hf_lte_rrc_measResultListUTRA_r9, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lte_rrc_MeasResultList2UTRA_r9 },
  { &hf_lte_rrc_measResultListGERAN_r9, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lte_rrc_MeasResultListGERAN },
  { &hf_lte_rrc_measResultsCDMA2000_r9, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lte_rrc_MeasResultList2CDMA2000_r9 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_T_measResultNeighCells_r9(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_T_measResultNeighCells_r9, T_measResultNeighCells_r9_sequence);

  return offset;
}


static const per_sequence_t T_pci_arfcn_r10_sequence[] = {
  { &hf_lte_rrc_physCellId_r10, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_PhysCellId },
  { &hf_lte_rrc_carrierFreq_r10, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_ARFCN_ValueEUTRA },
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_T_pci_arfcn_r10(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_T_pci_arfcn_r10, T_pci_arfcn_r10_sequence);

  return offset;
}


static const value_string lte_rrc_T_failedPCellId_r10_vals[] = {
  {   0, "cellGlobalId-r10" },
  {   1, "pci-arfcn-r10" },
  { 0, NULL }
};

static const per_choice_t T_failedPCellId_r10_choice[] = {
  {   0, &hf_lte_rrc_cellGlobalId_r10, ASN1_NO_EXTENSIONS     , dissect_lte_rrc_CellGlobalIdEUTRA },
  {   1, &hf_lte_rrc_pci_arfcn_r10, ASN1_NO_EXTENSIONS     , dissect_lte_rrc_T_pci_arfcn_r10 },
  { 0, NULL, 0, NULL }
};

static int
dissect_lte_rrc_T_failedPCellId_r10(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_lte_rrc_T_failedPCellId_r10, T_failedPCellId_r10_choice,
                                 NULL);

  return offset;
}



static int
dissect_lte_rrc_T_timeConnFailure_r10(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  guint32 timeConnFailure_val;
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 1023U, &timeConnFailure_val, FALSE);


  proto_item_append_text(actx->created_item, " (%dms)", 100*timeConnFailure_val);

  return offset;
}


static const value_string lte_rrc_T_connectionFailureType_r10_vals[] = {
  {   0, "rlf" },
  {   1, "hof" },
  { 0, NULL }
};


static int
dissect_lte_rrc_T_connectionFailureType_r10(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, FALSE, 0, NULL);

  return offset;
}


static const per_sequence_t RLF_Report_r9_eag_1_sequence[] = {
  { &hf_lte_rrc_locationInfo_r10, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lte_rrc_LocationInfo_r10 },
  { &hf_lte_rrc_failedPCellId_r10, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lte_rrc_T_failedPCellId_r10 },
  { &hf_lte_rrc_reestablishmentCellId_r10, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lte_rrc_CellGlobalIdEUTRA },
  { &hf_lte_rrc_timeConnFailure_r10, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lte_rrc_T_timeConnFailure_r10 },
  { &hf_lte_rrc_connectionFailureType_r10, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lte_rrc_T_connectionFailureType_r10 },
  { &hf_lte_rrc_previousPCellId_r10, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lte_rrc_CellGlobalIdEUTRA },
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_RLF_Report_r9_eag_1(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence_eag(tvb, offset, actx, tree, RLF_Report_r9_eag_1_sequence);

  return offset;
}


static const per_sequence_t RLF_Report_r9_sequence[] = {
  { &hf_lte_rrc_measResultLastServCell_r9, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lte_rrc_T_measResultLastServCell_r9 },
  { &hf_lte_rrc_measResultNeighCells_r9, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lte_rrc_T_measResultNeighCells_r9 },
  { &hf_lte_rrc_dummy_eag_field, ASN1_NOT_EXTENSION_ROOT, ASN1_NOT_OPTIONAL, dissect_lte_rrc_RLF_Report_r9_eag_1 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_RLF_Report_r9(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_RLF_Report_r9, RLF_Report_r9_sequence);

  return offset;
}



static int
dissect_lte_rrc_INTEGER_0_7200(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 7200U, NULL, FALSE);

  return offset;
}


static const per_sequence_t T_measResultServCell_r10_sequence[] = {
  { &hf_lte_rrc_rsrpResult_r10, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_RSRP_Range },
  { &hf_lte_rrc_rsrqResult_r10, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_RSRQ_Range },
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_T_measResultServCell_r10(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_T_measResultServCell_r10, T_measResultServCell_r10_sequence);

  return offset;
}


static const per_sequence_t MeasResultList2GERAN_r10_sequence_of[1] = {
  { &hf_lte_rrc_MeasResultList2GERAN_r10_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_MeasResultListGERAN },
};

static int
dissect_lte_rrc_MeasResultList2GERAN_r10(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_lte_rrc_MeasResultList2GERAN_r10, MeasResultList2GERAN_r10_sequence_of,
                                                  1, maxCellListGERAN, FALSE);

  return offset;
}


static const per_sequence_t T_measResultNeighCells_r10_sequence[] = {
  { &hf_lte_rrc_measResultListEUTRA_r10, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lte_rrc_MeasResultList2EUTRA_r9 },
  { &hf_lte_rrc_measResultListUTRA_r10, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lte_rrc_MeasResultList2UTRA_r9 },
  { &hf_lte_rrc_measResultListGERAN_r10, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lte_rrc_MeasResultList2GERAN_r10 },
  { &hf_lte_rrc_measResultListCDMA2000_r10, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lte_rrc_MeasResultList2CDMA2000_r9 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_T_measResultNeighCells_r10(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_T_measResultNeighCells_r10, T_measResultNeighCells_r10_sequence);

  return offset;
}


static const per_sequence_t LogMeasInfo_r10_sequence[] = {
  { &hf_lte_rrc_locationInfo_r10, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lte_rrc_LocationInfo_r10 },
  { &hf_lte_rrc_relativeTimeStamp_r10, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lte_rrc_INTEGER_0_7200 },
  { &hf_lte_rrc_servCellIdentity_r10, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lte_rrc_CellGlobalIdEUTRA },
  { &hf_lte_rrc_measResultServCell_r10, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lte_rrc_T_measResultServCell_r10 },
  { &hf_lte_rrc_measResultNeighCells_r10, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lte_rrc_T_measResultNeighCells_r10 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_LogMeasInfo_r10(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_LogMeasInfo_r10, LogMeasInfo_r10_sequence);

  return offset;
}


static const per_sequence_t LogMeasInfoList_r10_sequence_of[1] = {
  { &hf_lte_rrc_LogMeasInfoList_r10_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_LogMeasInfo_r10 },
};

static int
dissect_lte_rrc_LogMeasInfoList_r10(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_lte_rrc_LogMeasInfoList_r10, LogMeasInfoList_r10_sequence_of,
                                                  1, maxLogMeasReport_r10, FALSE);

  return offset;
}


static const value_string lte_rrc_T_logMeasAvailable_r10_03_vals[] = {
  {   0, "true" },
  { 0, NULL }
};


static int
dissect_lte_rrc_T_logMeasAvailable_r10_03(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, FALSE, 0, NULL);

  return offset;
}


static const per_sequence_t LogMeasReport_r10_sequence[] = {
  { &hf_lte_rrc_absoluteTimeStamp_r10, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lte_rrc_AbsoluteTimeInfo_r10 },
  { &hf_lte_rrc_traceReference_r10, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lte_rrc_TraceReference_r10 },
  { &hf_lte_rrc_traceRecordingSessionRef_r10, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lte_rrc_OCTET_STRING_SIZE_2 },
  { &hf_lte_rrc_tce_Id_r10  , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lte_rrc_OCTET_STRING_SIZE_1 },
  { &hf_lte_rrc_logMeasInfoList_r10, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lte_rrc_LogMeasInfoList_r10 },
  { &hf_lte_rrc_logMeasAvailable_r10_03, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lte_rrc_T_logMeasAvailable_r10_03 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_LogMeasReport_r10(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_LogMeasReport_r10, LogMeasReport_r10_sequence);

  return offset;
}


static const per_sequence_t T_nonCriticalExtension_35_sequence[] = {
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_T_nonCriticalExtension_35(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_T_nonCriticalExtension_35, T_nonCriticalExtension_35_sequence);

  return offset;
}


static const per_sequence_t UEInformationResponse_v1020_IEs_sequence[] = {
  { &hf_lte_rrc_logMeasReport_r10, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lte_rrc_LogMeasReport_r10 },
  { &hf_lte_rrc_nonCriticalExtension_82, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lte_rrc_T_nonCriticalExtension_35 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_UEInformationResponse_v1020_IEs(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_UEInformationResponse_v1020_IEs, UEInformationResponse_v1020_IEs_sequence);

  return offset;
}


static const per_sequence_t UEInformationResponse_v930_IEs_sequence[] = {
  { &hf_lte_rrc_lateNonCriticalExtension, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lte_rrc_OCTET_STRING },
  { &hf_lte_rrc_nonCriticalExtension_81, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lte_rrc_UEInformationResponse_v1020_IEs },
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_UEInformationResponse_v930_IEs(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_UEInformationResponse_v930_IEs, UEInformationResponse_v930_IEs_sequence);

  return offset;
}


static const per_sequence_t UEInformationResponse_r9_IEs_sequence[] = {
  { &hf_lte_rrc_rach_Report_r9, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lte_rrc_T_rach_Report_r9 },
  { &hf_lte_rrc_rlf_Report_r9, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lte_rrc_RLF_Report_r9 },
  { &hf_lte_rrc_nonCriticalExtension_80, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lte_rrc_UEInformationResponse_v930_IEs },
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_UEInformationResponse_r9_IEs(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_UEInformationResponse_r9_IEs, UEInformationResponse_r9_IEs_sequence);

  return offset;
}


static const value_string lte_rrc_T_c1_28_vals[] = {
  {   0, "ueInformationResponse-r9" },
  {   1, "spare3" },
  {   2, "spare2" },
  {   3, "spare1" },
  { 0, NULL }
};

static const per_choice_t T_c1_28_choice[] = {
  {   0, &hf_lte_rrc_ueInformationResponse_r9_01, ASN1_NO_EXTENSIONS     , dissect_lte_rrc_UEInformationResponse_r9_IEs },
  {   1, &hf_lte_rrc_spare3      , ASN1_NO_EXTENSIONS     , dissect_lte_rrc_NULL },
  {   2, &hf_lte_rrc_spare2      , ASN1_NO_EXTENSIONS     , dissect_lte_rrc_NULL },
  {   3, &hf_lte_rrc_spare1      , ASN1_NO_EXTENSIONS     , dissect_lte_rrc_NULL },
  { 0, NULL, 0, NULL }
};

static int
dissect_lte_rrc_T_c1_28(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_lte_rrc_T_c1_28, T_c1_28_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t T_criticalExtensionsFuture_32_sequence[] = {
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_T_criticalExtensionsFuture_32(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_T_criticalExtensionsFuture_32, T_criticalExtensionsFuture_32_sequence);

  return offset;
}


static const value_string lte_rrc_T_criticalExtensions_32_vals[] = {
  {   0, "c1" },
  {   1, "criticalExtensionsFuture" },
  { 0, NULL }
};

static const per_choice_t T_criticalExtensions_32_choice[] = {
  {   0, &hf_lte_rrc_c1_28       , ASN1_NO_EXTENSIONS     , dissect_lte_rrc_T_c1_28 },
  {   1, &hf_lte_rrc_criticalExtensionsFuture_32, ASN1_NO_EXTENSIONS     , dissect_lte_rrc_T_criticalExtensionsFuture_32 },
  { 0, NULL, 0, NULL }
};

static int
dissect_lte_rrc_T_criticalExtensions_32(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_lte_rrc_T_criticalExtensions_32, T_criticalExtensions_32_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t UEInformationResponse_r9_sequence[] = {
  { &hf_lte_rrc_rrc_TransactionIdentifier, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_RRC_TransactionIdentifier },
  { &hf_lte_rrc_criticalExtensions_32, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_T_criticalExtensions_32 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_UEInformationResponse_r9(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {

col_append_str(actx->pinfo->cinfo, COL_INFO, "UEInformationResponse-r9 ");

  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_UEInformationResponse_r9, UEInformationResponse_r9_sequence);

  return offset;
}


static const value_string lte_rrc_T_type_r9_vals[] = {
  {   0, "entering" },
  {   1, "leaving" },
  { 0, NULL }
};


static int
dissect_lte_rrc_T_type_r9(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, FALSE, 0, NULL);

  return offset;
}


static const value_string lte_rrc_T_carrierFreq_r9_vals[] = {
  {   0, "eutra-r9" },
  {   1, "utra-r9" },
  { 0, NULL }
};

static const per_choice_t T_carrierFreq_r9_choice[] = {
  {   0, &hf_lte_rrc_eutra_r9    , ASN1_EXTENSION_ROOT    , dissect_lte_rrc_ARFCN_ValueEUTRA },
  {   1, &hf_lte_rrc_utra_r9     , ASN1_EXTENSION_ROOT    , dissect_lte_rrc_ARFCN_ValueUTRA },
  { 0, NULL, 0, NULL }
};

static int
dissect_lte_rrc_T_carrierFreq_r9(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_lte_rrc_T_carrierFreq_r9, T_carrierFreq_r9_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t T_nonCriticalExtension_15_sequence[] = {
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_T_nonCriticalExtension_15(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_T_nonCriticalExtension_15, T_nonCriticalExtension_15_sequence);

  return offset;
}


static const per_sequence_t ProximityIndication_v930_IEs_sequence[] = {
  { &hf_lte_rrc_lateNonCriticalExtension, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lte_rrc_OCTET_STRING },
  { &hf_lte_rrc_nonCriticalExtension_32, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lte_rrc_T_nonCriticalExtension_15 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_ProximityIndication_v930_IEs(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_ProximityIndication_v930_IEs, ProximityIndication_v930_IEs_sequence);

  return offset;
}


static const per_sequence_t ProximityIndication_r9_IEs_sequence[] = {
  { &hf_lte_rrc_type_r9     , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_T_type_r9 },
  { &hf_lte_rrc_carrierFreq_r9, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_T_carrierFreq_r9 },
  { &hf_lte_rrc_nonCriticalExtension_31, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lte_rrc_ProximityIndication_v930_IEs },
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_ProximityIndication_r9_IEs(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_ProximityIndication_r9_IEs, ProximityIndication_r9_IEs_sequence);

  return offset;
}


static const value_string lte_rrc_T_c1_15_vals[] = {
  {   0, "proximityIndication-r9" },
  {   1, "spare3" },
  {   2, "spare2" },
  {   3, "spare1" },
  { 0, NULL }
};

static const per_choice_t T_c1_15_choice[] = {
  {   0, &hf_lte_rrc_proximityIndication_r9_01, ASN1_NO_EXTENSIONS     , dissect_lte_rrc_ProximityIndication_r9_IEs },
  {   1, &hf_lte_rrc_spare3      , ASN1_NO_EXTENSIONS     , dissect_lte_rrc_NULL },
  {   2, &hf_lte_rrc_spare2      , ASN1_NO_EXTENSIONS     , dissect_lte_rrc_NULL },
  {   3, &hf_lte_rrc_spare1      , ASN1_NO_EXTENSIONS     , dissect_lte_rrc_NULL },
  { 0, NULL, 0, NULL }
};

static int
dissect_lte_rrc_T_c1_15(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_lte_rrc_T_c1_15, T_c1_15_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t T_criticalExtensionsFuture_11_sequence[] = {
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_T_criticalExtensionsFuture_11(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_T_criticalExtensionsFuture_11, T_criticalExtensionsFuture_11_sequence);

  return offset;
}


static const value_string lte_rrc_T_criticalExtensions_11_vals[] = {
  {   0, "c1" },
  {   1, "criticalExtensionsFuture" },
  { 0, NULL }
};

static const per_choice_t T_criticalExtensions_11_choice[] = {
  {   0, &hf_lte_rrc_c1_15       , ASN1_NO_EXTENSIONS     , dissect_lte_rrc_T_c1_15 },
  {   1, &hf_lte_rrc_criticalExtensionsFuture_11, ASN1_NO_EXTENSIONS     , dissect_lte_rrc_T_criticalExtensionsFuture_11 },
  { 0, NULL, 0, NULL }
};

static int
dissect_lte_rrc_T_criticalExtensions_11(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_lte_rrc_T_criticalExtensions_11, T_criticalExtensions_11_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t ProximityIndication_r9_sequence[] = {
  { &hf_lte_rrc_criticalExtensions_11, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_T_criticalExtensions_11 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_ProximityIndication_r9(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {

col_append_str(actx->pinfo->cinfo, COL_INFO, "ProximityIndication-r9 ");

  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_ProximityIndication_r9, ProximityIndication_r9_sequence);

  return offset;
}


static const per_sequence_t T_nonCriticalExtension_17_sequence[] = {
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_T_nonCriticalExtension_17(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_T_nonCriticalExtension_17, T_nonCriticalExtension_17_sequence);

  return offset;
}


static const per_sequence_t RNReconfigurationComplete_r10_IEs_sequence[] = {
  { &hf_lte_rrc_lateNonCriticalExtension, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lte_rrc_OCTET_STRING },
  { &hf_lte_rrc_nonCriticalExtension_34, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lte_rrc_T_nonCriticalExtension_17 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_RNReconfigurationComplete_r10_IEs(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_RNReconfigurationComplete_r10_IEs, RNReconfigurationComplete_r10_IEs_sequence);

  return offset;
}


static const value_string lte_rrc_T_c1_17_vals[] = {
  {   0, "rnReconfigurationComplete-r10" },
  {   1, "spare3" },
  {   2, "spare2" },
  {   3, "spare1" },
  { 0, NULL }
};

static const per_choice_t T_c1_17_choice[] = {
  {   0, &hf_lte_rrc_rnReconfigurationComplete_r10_01, ASN1_NO_EXTENSIONS     , dissect_lte_rrc_RNReconfigurationComplete_r10_IEs },
  {   1, &hf_lte_rrc_spare3      , ASN1_NO_EXTENSIONS     , dissect_lte_rrc_NULL },
  {   2, &hf_lte_rrc_spare2      , ASN1_NO_EXTENSIONS     , dissect_lte_rrc_NULL },
  {   3, &hf_lte_rrc_spare1      , ASN1_NO_EXTENSIONS     , dissect_lte_rrc_NULL },
  { 0, NULL, 0, NULL }
};

static int
dissect_lte_rrc_T_c1_17(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_lte_rrc_T_c1_17, T_c1_17_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t T_criticalExtensionsFuture_13_sequence[] = {
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_T_criticalExtensionsFuture_13(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_T_criticalExtensionsFuture_13, T_criticalExtensionsFuture_13_sequence);

  return offset;
}


static const value_string lte_rrc_T_criticalExtensions_13_vals[] = {
  {   0, "c1" },
  {   1, "criticalExtensionsFuture" },
  { 0, NULL }
};

static const per_choice_t T_criticalExtensions_13_choice[] = {
  {   0, &hf_lte_rrc_c1_17       , ASN1_NO_EXTENSIONS     , dissect_lte_rrc_T_c1_17 },
  {   1, &hf_lte_rrc_criticalExtensionsFuture_13, ASN1_NO_EXTENSIONS     , dissect_lte_rrc_T_criticalExtensionsFuture_13 },
  { 0, NULL, 0, NULL }
};

static int
dissect_lte_rrc_T_criticalExtensions_13(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_lte_rrc_T_criticalExtensions_13, T_criticalExtensions_13_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t RNReconfigurationComplete_r10_sequence[] = {
  { &hf_lte_rrc_rrc_TransactionIdentifier, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_RRC_TransactionIdentifier },
  { &hf_lte_rrc_criticalExtensions_13, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_T_criticalExtensions_13 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_RNReconfigurationComplete_r10(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {

col_append_str(actx->pinfo->cinfo, COL_INFO, "RNReconfigurationComplete-r10 ");

  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_RNReconfigurationComplete_r10, RNReconfigurationComplete_r10_sequence);

  return offset;
}



static int
dissect_lte_rrc_INTEGER_0_maxMBSFN_Area_1(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, maxMBSFN_Area_1, NULL, FALSE);

  return offset;
}



static int
dissect_lte_rrc_INTEGER_0_maxServiceCount_1(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, maxServiceCount_1, NULL, FALSE);

  return offset;
}


static const per_sequence_t CountingResponseInfo_r10_sequence[] = {
  { &hf_lte_rrc_countingResponseService_r10, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lte_rrc_INTEGER_0_maxServiceCount_1 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_CountingResponseInfo_r10(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_CountingResponseInfo_r10, CountingResponseInfo_r10_sequence);

  return offset;
}


static const per_sequence_t CountingResponseList_r10_sequence_of[1] = {
  { &hf_lte_rrc_CountingResponseList_r10_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_CountingResponseInfo_r10 },
};

static int
dissect_lte_rrc_CountingResponseList_r10(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_lte_rrc_CountingResponseList_r10, CountingResponseList_r10_sequence_of,
                                                  1, maxServiceCount, FALSE);

  return offset;
}


static const per_sequence_t T_nonCriticalExtension_09_sequence[] = {
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_T_nonCriticalExtension_09(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_T_nonCriticalExtension_09, T_nonCriticalExtension_09_sequence);

  return offset;
}


static const per_sequence_t MBMSCountingResponse_r10_IEs_sequence[] = {
  { &hf_lte_rrc_mbsfn_AreaIndex_r10, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lte_rrc_INTEGER_0_maxMBSFN_Area_1 },
  { &hf_lte_rrc_countingResponseList_r10, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lte_rrc_CountingResponseList_r10 },
  { &hf_lte_rrc_lateNonCriticalExtension, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lte_rrc_OCTET_STRING },
  { &hf_lte_rrc_nonCriticalExtension_17, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lte_rrc_T_nonCriticalExtension_09 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_MBMSCountingResponse_r10_IEs(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_MBMSCountingResponse_r10_IEs, MBMSCountingResponse_r10_IEs_sequence);

  return offset;
}


static const value_string lte_rrc_T_c1_12_vals[] = {
  {   0, "countingResponse-r10" },
  {   1, "spare3" },
  {   2, "spare2" },
  {   3, "spare1" },
  { 0, NULL }
};

static const per_choice_t T_c1_12_choice[] = {
  {   0, &hf_lte_rrc_countingResponse_r10, ASN1_NO_EXTENSIONS     , dissect_lte_rrc_MBMSCountingResponse_r10_IEs },
  {   1, &hf_lte_rrc_spare3      , ASN1_NO_EXTENSIONS     , dissect_lte_rrc_NULL },
  {   2, &hf_lte_rrc_spare2      , ASN1_NO_EXTENSIONS     , dissect_lte_rrc_NULL },
  {   3, &hf_lte_rrc_spare1      , ASN1_NO_EXTENSIONS     , dissect_lte_rrc_NULL },
  { 0, NULL, 0, NULL }
};

static int
dissect_lte_rrc_T_c1_12(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_lte_rrc_T_c1_12, T_c1_12_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t T_criticalExtensionsFuture_08_sequence[] = {
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_T_criticalExtensionsFuture_08(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_T_criticalExtensionsFuture_08, T_criticalExtensionsFuture_08_sequence);

  return offset;
}


static const value_string lte_rrc_T_criticalExtensions_08_vals[] = {
  {   0, "c1" },
  {   1, "criticalExtensionsFuture" },
  { 0, NULL }
};

static const per_choice_t T_criticalExtensions_08_choice[] = {
  {   0, &hf_lte_rrc_c1_12       , ASN1_NO_EXTENSIONS     , dissect_lte_rrc_T_c1_12 },
  {   1, &hf_lte_rrc_criticalExtensionsFuture_08, ASN1_NO_EXTENSIONS     , dissect_lte_rrc_T_criticalExtensionsFuture_08 },
  { 0, NULL, 0, NULL }
};

static int
dissect_lte_rrc_T_criticalExtensions_08(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_lte_rrc_T_criticalExtensions_08, T_criticalExtensions_08_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t MBMSCountingResponse_r10_sequence[] = {
  { &hf_lte_rrc_criticalExtensions_08, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lte_rrc_T_criticalExtensions_08 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lte_rrc_MBMSCountingResponse_r10(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {

col_append_str(actx->pinfo->cinfo, COL_INFO, "MBMSCountingResponse-r10 ");

  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lte_rrc_MBMSCountingResponse_r10, MBMSCountingResponse_r10_sequence);

  return offset;
}


static const per_sequence_t RSTD_InterFreqInfo_r10_sequence[] = {
  { &hf_lte_rrc_carrierFreq_r10, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lte_rrc_ARFCN_ValueEUTRA },
  { &hf_lte_rrc_measPRS_Offset_r10, ASN1_EXTENSION_ROOT    , ASN1_