/******************************************************************************
** $Id: opcua_servicetable.c 21864 2007-05-21 18:08:47Z jake $
**
** Copyright (C) 2006-2007 ascolab GmbH. All Rights Reserved.
** Web: http://www.ascolab.com
** 
** This program is free software; you can redistribute it and/or
** modify it under the terms of the GNU General Public License
** as published by the Free Software Foundation; either version 2
** of the License, or (at your option) any later version.
** 
** This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
** WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
** 
** Project: OpcUa Wireshark Plugin
**
** Description: Service table and service dispatcher.
**
** This file was autogenerated on 8.5.2007 18:53:26.
** DON'T MODIFY THIS FILE!
**
******************************************************************************/

#ifdef HAVE_CONFIG_H
# include "config.h"
#endif

#include <glib.h>
#include <epan/packet.h>
#include "opcua_identifiers.h"
#include "opcua_serviceparser.h"

ParserEntry g_arParserTable[] = {
  { 1358, parseTestStackRequest }, 
  { 1363, parseTestStackResponse }, 
  { 1368, parseTestStackExRequest }, 
  { 1373, parseTestStackExResponse }, 
  { 1414, parseFindServersRequest }, 
  { 1419, parseFindServersResponse }, 
  { 1424, parseGetEndpointsRequest }, 
  { 1429, parseGetEndpointsResponse }, 
  { 1439, parseRegisterServerRequest }, 
  { 1444, parseRegisterServerResponse }, 
  { 1454, parseOpenSecureChannelRequest }, 
  { 1459, parseOpenSecureChannelResponse }, 
  { 1464, parseCloseSecureChannelRequest }, 
  { 1469, parseCloseSecureChannelResponse }, 
  { 1479, parseCreateSessionRequest }, 
  { 1484, parseCreateSessionResponse }, 
  { 1489, parseActivateSessionRequest }, 
  { 1494, parseActivateSessionResponse }, 
  { 1499, parseCloseSessionRequest }, 
  { 1504, parseCloseSessionResponse }, 
  { 1509, parseCancelRequest }, 
  { 1514, parseCancelResponse }, 
  { 1524, parseAddNodesRequest }, 
  { 1529, parseAddNodesResponse }, 
  { 1534, parseAddReferencesRequest }, 
  { 1539, parseAddReferencesResponse }, 
  { 1544, parseDeleteNodesRequest }, 
  { 1549, parseDeleteNodesResponse }, 
  { 1554, parseDeleteReferencesRequest }, 
  { 1559, parseDeleteReferencesResponse }, 
  { 1574, parseBrowsePropertiesRequest }, 
  { 1579, parseBrowsePropertiesResponse }, 
  { 1599, parseBrowseRequest }, 
  { 1604, parseBrowseResponse }, 
  { 1609, parseBrowseNextRequest }, 
  { 1614, parseBrowseNextResponse }, 
  { 1630, parseTranslateBrowsePathsToNodeIdsRequest }, 
  { 1635, parseTranslateBrowsePathsToNodeIdsResponse }, 
  { 1710, parseQueryFirstRequest }, 
  { 1715, parseQueryFirstResponse }, 
  { 1720, parseQueryNextRequest }, 
  { 1725, parseQueryNextResponse }, 
  { 1740, parseReadRequest }, 
  { 1745, parseReadResponse }, 
  { 1790, parseHistoryReadRequest }, 
  { 1795, parseHistoryReadResponse }, 
  { 1805, parseWriteRequest }, 
  { 1810, parseWriteResponse }, 
  { 1845, parseHistoryUpdateRequest }, 
  { 1850, parseHistoryUpdateResponse }, 
  { 1865, parseCallRequest }, 
  { 1870, parseCallResponse }, 
  { 1930, parseCreateMonitoredItemsRequest }, 
  { 1935, parseCreateMonitoredItemsResponse }, 
  { 1950, parseModifyMonitoredItemsRequest }, 
  { 1955, parseModifyMonitoredItemsResponse }, 
  { 1960, parseSetMonitoringModeRequest }, 
  { 1965, parseSetMonitoringModeResponse }, 
  { 1970, parseSetTriggeringRequest }, 
  { 1975, parseSetTriggeringResponse }, 
  { 1980, parseDeleteMonitoredItemsRequest }, 
  { 1985, parseDeleteMonitoredItemsResponse }, 
  { 1990, parseCreateSubscriptionRequest }, 
  { 1995, parseCreateSubscriptionResponse }, 
  { 2000, parseModifySubscriptionRequest }, 
  { 2005, parseModifySubscriptionResponse }, 
  { 2010, parseSetPublishingModeRequest }, 
  { 2015, parseSetPublishingModeResponse }, 
  { 2050, parsePublishRequest }, 
  { 2055, parsePublishResponse }, 
  { 2060, parseRepublishRequest }, 
  { 2065, parseRepublishResponse }, 
  { 2075, parseTransferSubscriptionsRequest }, 
  { 2080, parseTransferSubscriptionsResponse }, 
  { 2085, parseDeleteSubscriptionsRequest }, 
  { 2090, parseDeleteSubscriptionsResponse }

};
const int g_NumServices = sizeof(g_arParserTable) / sizeof(ParserEntry);

/** Service type table */
const value_string g_requesttypes[] = {
  { 1358, "TestStackRequest" },
  { 1363, "TestStackResponse" },
  { 1368, "TestStackExRequest" },
  { 1373, "TestStackExResponse" },
  { 1414, "FindServersRequest" },
  { 1419, "FindServersResponse" },
  { 1424, "GetEndpointsRequest" },
  { 1429, "GetEndpointsResponse" },
  { 1439, "RegisterServerRequest" },
  { 1444, "RegisterServerResponse" },
  { 1454, "OpenSecureChannelRequest" },
  { 1459, "OpenSecureChannelResponse" },
  { 1464, "CloseSecureChannelRequest" },
  { 1469, "CloseSecureChannelResponse" },
  { 1479, "CreateSessionRequest" },
  { 1484, "CreateSessionResponse" },
  { 1489, "ActivateSessionRequest" },
  { 1494, "ActivateSessionResponse" },
  { 1499, "CloseSessionRequest" },
  { 1504, "CloseSessionResponse" },
  { 1509, "CancelRequest" },
  { 1514, "CancelResponse" },
  { 1524, "AddNodesRequest" },
  { 1529, "AddNodesResponse" },
  { 1534, "AddReferencesRequest" },
  { 1539, "AddReferencesResponse" },
  { 1544, "DeleteNodesRequest" },
  { 1549, "DeleteNodesResponse" },
  { 1554, "DeleteReferencesRequest" },
  { 1559, "DeleteReferencesResponse" },
  { 1574, "BrowsePropertiesRequest" },
  { 1579, "BrowsePropertiesResponse" },
  { 1599, "BrowseRequest" },
  { 1604, "BrowseResponse" },
  { 1609, "BrowseNextRequest" },
  { 1614, "BrowseNextResponse" },
  { 1630, "TranslateBrowsePathsToNodeIdsRequest" },
  { 1635, "TranslateBrowsePathsToNodeIdsResponse" },
  { 1710, "QueryFirstRequest" },
  { 1715, "QueryFirstResponse" },
  { 1720, "QueryNextRequest" },
  { 1725, "QueryNextResponse" },
  { 1740, "ReadRequest" },
  { 1745, "ReadResponse" },
  { 1790, "HistoryReadRequest" },
  { 1795, "HistoryReadResponse" },
  { 1805, "WriteRequest" },
  { 1810, "WriteResponse" },
  { 1845, "HistoryUpdateRequest" },
  { 1850, "HistoryUpdateResponse" },
  { 1865, "CallRequest" },
  { 1870, "CallResponse" },
  { 1930, "CreateMonitoredItemsRequest" },
  { 1935, "CreateMonitoredItemsResponse" },
  { 1950, "ModifyMonitoredItemsRequest" },
  { 1955, "ModifyMonitoredItemsResponse" },
  { 1960, "SetMonitoringModeRequest" },
  { 1965, "SetMonitoringModeResponse" },
  { 1970, "SetTriggeringRequest" },
  { 1975, "SetTriggeringResponse" },
  { 1980, "DeleteMonitoredItemsRequest" },
  { 1985, "DeleteMonitoredItemsResponse" },
  { 1990, "CreateSubscriptionRequest" },
  { 1995, "CreateSubscriptionResponse" },
  { 2000, "ModifySubscriptionRequest" },
  { 2005, "ModifySubscriptionResponse" },
  { 2010, "SetPublishingModeRequest" },
  { 2015, "SetPublishingModeResponse" },
  { 2050, "PublishRequest" },
  { 2055, "PublishResponse" },
  { 2060, "RepublishRequest" },
  { 2065, "RepublishResponse" },
  { 2075, "TransferSubscriptionsRequest" },
  { 2080, "TransferSubscriptionsResponse" },
  { 2085, "DeleteSubscriptionsRequest" },
  { 2090, "DeleteSubscriptionsResponse" },
  { 0, NULL }
};

/** Dispatch all services to a special parser function. */
void dispatchService(proto_tree *tree, tvbuff_t *tvb, gint *pOffset, int ServiceId)
{
    int index = 0;

    while (index < g_NumServices)
    {
        if (g_arParserTable[index].iRequestId == ServiceId)
        {
            (*g_arParserTable[index].pParser)(tree, tvb, pOffset);
            break;
        }
        index++;
    }
}
