/* Version 0.94 */
/*
    Copyright 2008-2012
        Matthias Ehmann,
        Michael Gerhaeuser,
        Carsten Miller,
        Bianca Valentin,
        Alfred Wassermann,
        Peter Wilfahrt

    This file is part of JSXGraph.

    JSXGraph is free software: you can redistribute it and/or modify
    it under the terms of the GNU Lesser General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    JSXGraph is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU Lesser General Public License for more details.

    You should have received a copy of the GNU Lesser General Public License
    along with JSXGraph.  If not, see <http://www.gnu.org/licenses/>.
*/
    var JXG={};(function(){var e,f;JXG.countDrawings=0;JXG.countTime=0;JXG.require=function(g){};JXG.rendererFiles=[];JXG.rendererFiles.svg="SVGRenderer";JXG.rendererFiles.vml="VMLRenderer";JXG.rendererFiles.canvas="CanvasRenderer";JXG.baseFiles=null;JXG.requirePath="";for(e=0;e<document.getElementsByTagName("script").length;e++){f=document.getElementsByTagName("script")[e];if(f.src&&f.src.match(/loadjsxgraphInOneFile\.js(\?.*)?$/)){JXG.requirePath=f.src.replace(/loadjsxgraphInOneFile\.js(\?.*)?$/,"")}}JXG.serverBase=JXG.requirePath+"server/"})();JXG.extend=function(f,k,g,j){var i,h;g=g||false;j=j||false;for(i in k){if(!g||(g&&k.hasOwnProperty(i))){if(j){h=i.toLowerCase()}else{h=i}f[h]=k[i]}}};JXG.shortcut=function(f,e){return function(){return f[e].apply(this,arguments)}};JXG.extend(JXG,{supportsVML:function(){return !!document.namespaces},supportsSVG:function(){return document.implementation.hasFeature("http://www.w3.org/TR/SVG11/feature#BasicStructure","1.1")},supportsCanvas:function(){return !!document.createElement("canvas").getContext},isAndroid:function(){return navigator.userAgent.toLowerCase().search("android")>-1},isWebkitAndroid:function(){return this.isAndroid()&&navigator.userAgent.search(" AppleWebKit/")>-1},isApple:function(){return(navigator.userAgent.search(/iPad/)!=-1||navigator.userAgent.search(/iPhone/)!=-1)},isWebkitApple:function(){return this.isApple()&&(navigator.userAgent.search(/Mobile *.*Safari/)>-1)},clearVisPropOld:function(e){e.visPropOld={strokecolor:"",strokeopacity:"",strokewidth:"",fillcolor:"",fillopacity:"",shadow:false,firstarrow:false,lastarrow:false}},ieVersion:(function(){var g,e=3,h=document.createElement("div"),f=h.getElementsByTagName("i");while(h.innerHTML="<!--[if gt IE "+(++e)+"]><i></i><![endif]-->",f[0]){}return e>4?e:g}()),getReference:function(f,e){if(typeof(e)=="string"){if(JXG.exists(f.objects[e])){e=f.objects[e]}else{if(JXG.exists(f.elementsByName[e])){e=f.elementsByName[e]}else{if(JXG.exists(f.groups[e])){e=f.groups[e]}}}}return e},getRef:JXG.shortcut(JXG,"getReference"),isId:function(f,e){return typeof(e)=="string"&&!!f.objects[e]},isName:function(f,e){return typeof(e)=="string"&&!!f.elementsByName[e]},isGroup:function(f,e){return typeof(e)=="string"&&!!f.groups[e]},isString:function(e){return typeof e==="string"},isNumber:function(e){return typeof e==="number"},isFunction:function(e){return typeof e==="function"},isArray:function(e){return e!==null&&typeof e==="object"&&"splice" in e&&"join" in e},isPoint:function(e){if(typeof e=="object"){return(e.elementClass==JXG.OBJECT_CLASS_POINT)}return false},exists:(function(e){return function(f){return !(f===e||f===null)}})(),def:function(e,f){if(JXG.exists(e)){return e}else{return f}},str2Bool:function(e){if(!JXG.exists(e)){return true}if(typeof e=="boolean"){return e}return(e.toLowerCase()=="true")},_board:function(f,e){return JXG.JSXGraph.initBoard(f,e)},createEvalFunction:function(g,k,l){var h=[],e,j;for(e=0;e<l;e++){if(typeof k[e]=="string"){j=JXG.GeonextParser.geonext2JS(k[e],g);j=j.replace(/this\.board\./g,"board.");h[e]=new Function("","return "+(j)+";")}}return function(i){var f=k[i];if(typeof f=="string"){return h[i]()}else{if(typeof f=="function"){return f()}else{if(typeof f=="number"){return f}}}return 0}},createFunction:function(e,g,i,j){var h=null;if((!JXG.exists(j)||j)&&JXG.isString(e)){h=g.jc.snippet(e,true,i,true)}else{if(JXG.isFunction(e)){h=e}else{if(JXG.isNumber(e)){h=function(){return e}}else{if(JXG.isString(e)){h=function(){return e}}}}}if(h!==null){h.origin=e}return h},checkParents:function(g,p,o){var h,f,e,m,q=[],n=p.slice(0),l=function(j,i){var k=(typeof j).toLowerCase();if(k==="number"){return i&&((i.type&&i.type===j)||(i.elementClass&&i.elementClass===j))}else{switch(j.toLowerCase()){case"string":case"object":case"function":case"number":return(typeof i).toLowerCase()===j.toLowerCase();break;case"array":return JXG.isArray(i);break}}return false};for(h=0;h<o.length;h++){for(f=0;f<o[h].length&&p.length>=o[h].length;f++){e=0;while(e<n.length&&!l(o[h][f],n[e])){e++}if(e<n.length){q.push(n.splice(m-e-1,1)[0])}}if(n.length){n=p.slice(0);q=[]}else{return q}}},readOption:function(e,g,f){var h=e.elements[f];if(JXG.exists(e[g][f])){h=e[g][f]}return h},checkAttributes:function(e,g){var f;if(!JXG.exists(e)){e={}}for(f in g){if(!JXG.exists(e[f])){e[f]=g[f]}}return e},copyAttributes:function(g,h){var f,j,e,l,k;f=this.deepCopy(h.elements,null,true);e=arguments.length;if(e<4&&this.exists(arguments[2])&&this.exists(h.layer[arguments[2]])){f.layer=h.layer[arguments[2]]}l=h;k=true;for(j=2;j<e;j++){if(JXG.exists(l[arguments[j]])){l=l[arguments[j]]}else{k=false;break}}if(k){f=this.deepCopy(f,l,true)}l=g;k=true;for(j=3;j<e;j++){if(JXG.exists(l[arguments[j]])){l=l[arguments[j]]}else{k=false;break}}if(k){this.extend(f,l,null,true)}l=h;k=true;for(j=2;j<e;j++){if(JXG.exists(l[arguments[j]])){l=l[arguments[j]]}else{k=false;break}}if(k){f.label=JXG.deepCopy(l.label,f.label)}f.label=JXG.deepCopy(h.label,f.label);return f},getDimensions:function(j){var i,l,g,m,k,f,e,h;i=document.getElementById(j);if(!JXG.exists(i)){throw new Error("\nJSXGraph: HTML container element '"+(j)+"' not found.")}l=i.style.display;if(l!="none"&&l!=null){return{width:i.offsetWidth,height:i.offsetHeight}}g=i.style;m=g.visibility;k=g.position;f=g.display;g.visibility="hidden";g.position="absolute";g.display="block";e=i.clientWidth;h=i.clientHeight;g.display=f;g.position=k;g.visibility=m;return{width:e,height:h}},addEvent:function(i,h,g,e){var f=function(){return g.apply(e,arguments)};f.origin=g;e["x_internal"+h]=e["x_internal"+h]||[];e["x_internal"+h].push(f);if(JXG.exists(i)&&JXG.exists(i.addEventListener)){i.addEventListener(h,f,false)}else{i.attachEvent("on"+h,f)}},removeEvent:function(m,p,q,g){var f="JSXGraph: Can't remove event listener on"+p+": "+g["x_internal"+p],n,k=-1,h;if((!JXG.exists(g)||!JXG.exists(g["x_internal"+p]))&&!JXG.isArray(g["x_internal"+p])){return}h=g["x_internal"+p].length;for(n=0;n<h;n++){if(g["x_internal"+p][n].origin===q){k=n;break}}if(k===-1){return}try{if(JXG.exists(m.addEventListener)){m.removeEventListener(p,g["x_internal"+p][k],false)}else{m.detachEvent("on"+p,g["x_internal"+p][k])}JXG.removeElementFromArray(g["x_internal"+p],g["x_internal"+p][k])}catch(o){}},removeAllEvents:function(g,f,e){if(e["x_internal"+f]){while(e["x_internal"+f].length>0){JXG.removeEvent(g,f,e["x_internal"+f][0].origin,e)}}},bind:function(f,e){return function(){return f.apply(e,arguments)}},removeElementFromArray:function(e,g){var f;for(f=0;f<e.length;f++){if(e[f]===g){e.splice(f,1);return e}}return e},getPosition:function(h,g){var f=0,i=0;if(!h){h=window.event}if(JXG.exists(g)){h=h.targetTouches[g]}if(h.pageX||h.pageY){f=h.pageX;i=h.pageY}else{if(h.clientX||h.clientY){f=h.clientX+document.body.scrollLeft+document.documentElement.scrollLeft;i=h.clientY+document.body.scrollTop+document.documentElement.scrollTop}}return[f,i]},getOffset:function(h){var i=h,g=h,e=i.offsetLeft-i.scrollLeft,f=i.offsetTop-i.scrollTop;while(i=i.offsetParent){e+=i.offsetLeft;f+=i.offsetTop;if(i.offsetParent){e+=i.clientLeft-i.scrollLeft;f+=i.clientTop-i.scrollTop}g=g.parentNode;while(g!=i){e+=g.clientLeft-g.scrollLeft;f+=g.clientTop-g.scrollTop;g=g.parentNode}}return[e,f]},getStyle:function(g,f){var e;if(window.getComputedStyle){e=document.defaultView.getComputedStyle(g,null).getPropertyValue(f)}else{if(g.currentStyle&&JXG.ieVersion>=9){e=g.currentStyle[f]}else{if(g.style){f=f.replace(/-([a-z]|[0-9])/ig,function(h,i){return(i+"").toUpperCase()});e=g.style[f]}}}return e},keys:function(e,f){var g=[],h;for(h in e){if(f){if(e.hasOwnProperty(h)){g.push(h)}}else{g.push(h)}}return g},indexOf:function(g,f){var e;if(Array.indexOf){return g.indexOf(f)}for(e=0;e<g.length;e++){if(g[e]===f){return e}}return -1},escapeHTML:function(e){return e.replace(/&/g,"&amp;").replace(/</g,"&lt;").replace(/>/g,"&gt;")},unescapeHTML:function(e){return e.replace(/<\/?[^>]+>/gi,"").replace(/&amp;/g,"&").replace(/&lt;/g,"<").replace(/&gt;/g,">")},clone:function(f){var e={};e.prototype=f;return e},cloneAndCopy:function(h,g){var e=function(){},f;e.prototype=h;for(f in g){e[f]=g[f]}return e},deepCopy:function(l,k,h){var n,f,m,e,g;h=h||false;if(typeof l!=="object"||l==null){return l}if(this.isArray(l)){n=[];for(f=0;f<l.length;f++){m=l[f];if(typeof m=="object"){n[f]=this.deepCopy(m)}else{n[f]=m}}}else{n={};for(f in l){g=h?f.toLowerCase():f;m=l[f];if(typeof m=="object"){n[g]=this.deepCopy(m)}else{n[g]=m}}for(f in k){g=h?f.toLowerCase():f;m=k[f];if(typeof m=="object"){if(JXG.isArray(m)||!JXG.exists(n[g])){n[g]=this.deepCopy(m)}else{n[g]=this.deepCopy(n[g],m,h)}}else{n[g]=m}}}return n},toJSON:function(l,h){var g;if(!JXG.exists(h)){h=false}if(window.JSON&&window.JSON.stringify&&!h){try{g=JSON.stringify(l);return g}catch(k){}}switch(typeof l){case"object":if(l){var j=[];if(l instanceof Array){for(var f=0;f<l.length;f++){j.push(JXG.toJSON(l[f],h))}return"["+j.join(",")+"]"}else{for(var m in l){if(h){j.push(m+":"+JXG.toJSON(l[m],h))}else{j.push('"'+m+'":'+JXG.toJSON(l[m],h))}}return"{"+j.join(",")+"} "}}else{return"null"}case"string":return"'"+l.replace(/(["'])/g,"\\$1")+"'";case"number":case"boolean":return new String(l)}},capitalize:function(e){return e.charAt(0).toUpperCase()+e.substring(1).toLowerCase()},timedChunk:function(f,h,g,i){var e=f.concat();setTimeout(function(){var j=+new Date();do{h.call(g,e.shift())}while(e.length>0&&(+new Date()-j<300));if(e.length>0){setTimeout(arguments.callee,1)}else{i(f)}},1)},trimNumber:function(e){e=e.replace(/^0+/,"");e=e.replace(/0+$/,"");if(e[e.length-1]=="."||e[e.length-1]==","){e=e.slice(0,-1)}if(e[0]=="."||e[0]==","){e="0"+e}return e},trim:function(e){e=e.replace(/^\s+/,"");e=e.replace(/\s+$/,"");return e},evaluate:function(e){if(JXG.isFunction(e)){return e()}else{return e}},eliminateDuplicates:function(g){var h,f=g.length,e=[],j={};for(h=0;h<f;h++){j[g[h]]=0}for(h in j){if(j.hasOwnProperty(h)){e.push(h)}}return e},cmpArrays:function(f,e){var g;if(f===e){return true}if(f.length!==e.length){return false}for(g=0;g<f.length;g++){if((typeof f[g]!==typeof e[g])||(f[g]!==e[g])){return false}}return true},trunc:function(f,e){e=JXG.def(e,0);if(e==0){f=~~f}else{f=f.toFixed(e)}return f},debug:function(f){var e;for(e=0;e<arguments.length;e++){f=arguments[e];if(window.console&&console.log){console.log(f)}else{if(document.getElementById("debug")){document.getElementById("debug").innerHTML+=f+"<br/>"}}}},debugWST:function(f){var g;JXG.debug(f);if(window.console&&console.log){g=new Error();if(g&&g.stack){console.log("stacktrace");console.log(g.stack.split("\n").slice(1).join("\n"))}}}});JXG.addEvent(window,"load",function(){var k=document.getElementsByTagName("script"),o,m,l,f,n,g,q,p,h,e;for(m=0;m<k.length;m++){o=k[m].getAttribute("type",false);if(!JXG.exists(o)){continue}if(o.toLowerCase()==="text/jessiescript"||o.toLowerCase==="jessiescript"){g=k[m].getAttribute("width",false)||"500px";q=k[m].getAttribute("height",false)||"500px";p=k[m].getAttribute("boundingbox",false)||"-5, 5, 5, -5";p=p.split(",");if(p.length!==4){p=[-5,5,5,-5]}else{for(l=0;l<p.length;l++){p[l]=parseFloat(p[l])}}h=JXG.str2Bool(k[m].getAttribute("axis",false)||"false");e=JXG.str2Bool(k[m].getAttribute("grid",false)||"false");f=document.createElement("div");f.setAttribute("id","jessiescript_autgen_jxg_"+m);f.setAttribute("style","width:"+g+"; height:"+q+"; float:left");f.setAttribute("class","jxgbox");document.body.insertBefore(f,k[m]);n=JXG.JSXGraph.initBoard("jessiescript_autgen_jxg_"+m,{boundingbox:p,keepaspectratio:true,grid:e,axis:h});n.construct(k[m].innerHTML)}}},window);JXG.Math=(function(f,e,g){var h=function(j){var i,k;if(j.memo){return j.memo}i={};k=Array.prototype.join;return(j.memo=function(){var l=k.call(arguments);return(i[l]!==g)?i[l]:i[l]=j.apply(this,arguments)})};return{eps:0.000001,mod:function(j,i){return j-e.floor(j/i)*i},vector:function(m,l){var k,j;l=l||0;k=new Array(e.ceil(m));for(j=0;j<m;j++){k[j]=l}return k},matrix:function(s,k,q){var p,o,l;q=q||0;k=k||s;p=new Array(e.ceil(s));for(o=0;o<s;o++){p[o]=new Array(e.ceil(k));for(l=0;l<k;l++){p[o][l]=q}}return p},identity:function(o,j){var l,k;if((j===g)&&(typeof j!=="number")){j=o}l=this.matrix(o,j);for(k=0;k<e.min(o,j);k++){l[k][k]=1}return l},frustum:function(j,o,i,m,q,p){var k=f.Math.matrix(4,4);k[0][0]=(q*2)/(o-j);k[0][1]=0;k[0][2]=(o+j)/(o-j);k[0][3]=0;k[1][0]=0;k[1][1]=(q*2)/(m-i);k[1][2]=(m+i)/(m-i);k[1][3]=0;k[2][0]=0;k[2][1]=0;k[2][2]=-(p+q)/(p-q);k[2][3]=-(p*q*2)/(p-q);k[3][0]=0;k[3][1]=0;k[3][2]=-1;k[3][3]=0;return k},projection:function(i,k,o,m){var j=o*e.tan(i/2),l=j*k;return this.frustum(-l,l,-j,j,o,m)},matVecMult:function(r,q){var j=r.length,u=q.length,p=[],o,t,l;if(u===3){for(o=0;o<j;o++){p[o]=r[o][0]*q[0]+r[o][1]*q[1]+r[o][2]*q[2]}}else{for(o=0;o<j;o++){t=0;for(l=0;l<u;l++){t+=r[o][l]*q[l]}p[o]=t}}return p},matMatMult:function(o,l){var q=o.length,p=q>0?l[0].length:0,w=l.length,v=this.matrix(q,p),u,t,z,r;for(u=0;u<q;u++){for(t=0;t<p;t++){z=0;for(r=0;r<w;r++){z+=o[u][r]*l[r][t]}v[u][t]=z}}return v},transpose:function(r){var o,p,l,k,q;k=r.length;q=r.length>0?r[0].length:0;o=this.matrix(q,k);for(p=0;p<q;p++){for(l=0;l<k;l++){o[p][l]=r[l][p]}}return o},inverse:function(B){var v,u,t,D,C,l,z,q=B.length,o=[],m=[],w=[];for(v=0;v<q;v++){o[v]=[];for(u=0;u<q;u++){o[v][u]=B[v][u]}m[v]=v}for(u=0;u<q;u++){C=e.abs(o[u][u]);l=u;for(v=u+1;v<q;v++){if(e.abs(o[v][u])>C){C=e.abs(o[v][u]);l=v}}if(C<=f.Math.eps){return false}if(l>u){for(t=0;t<q;t++){z=o[u][t];o[u][t]=o[l][t];o[l][t]=z}z=m[u];m[u]=m[l];m[l]=z}D=1/o[u][u];for(v=0;v<q;v++){o[v][u]*=D}o[u][u]=D;for(t=0;t<q;t++){if(t!=u){for(v=0;v<q;v++){if(v!=u){o[v][t]-=o[v][u]*o[u][t]}}o[u][t]=-D*o[u][t]}}}for(v=0;v<q;v++){for(t=0;t<q;t++){w[m[t]]=o[v][t]}for(t=0;t<q;t++){o[v][t]=w[t]}}return o},innerProduct:function(k,j,o){var l,m=0;if((o===g)||(typeof o!=="number")){o=k.length}for(l=0;l<o;l++){m+=k[l]*j[l]}return m},crossProduct:function(j,i){return[j[1]*i[2]-j[2]*i[1],j[2]*i[0]-j[0]*i[2],j[0]*i[1]-j[1]*i[0]]},factorial:h(function(i){if(i<0){return NaN}i=e.floor(i);if(i===0||i===1){return 1}return i*arguments.callee(i-1)}),binomial:h(function(o,l){var j,m;if(l>o||l<0){return NaN}l=e.round(l);o=e.round(o);if(l===0||l===o){return 1}j=1;for(m=0;m<l;m++){j*=(o-m);j/=(m+1)}return j}),cosh:function(i){return(e.exp(i)+e.exp(-i))*0.5},sinh:function(i){return(e.exp(i)-e.exp(-i))*0.5},pow:function(j,i){if(j===0){if(i===0){return 1}else{return 0}}if(e.floor(i)===i){return e.pow(j,i)}else{if(j>0){return e.exp(i*e.log(e.abs(j)))}else{return NaN}}},squampow:function(k,j){var i;if(e.floor(j)===j){i=1;if(j<0){k=1/k;j*=-1}while(j!=0){if(j&1){i*=k}j>>=1;k*=k}return i}else{return this.pow(k,j)}},normalize:function(k){var i=2*k[3],l=k[4]/(i),m,j;k[5]=l;k[6]=-k[1]/i;k[7]=-k[2]/i;if(l===Infinity||isNaN(l)){m=e.sqrt(k[1]*k[1]+k[2]*k[2]);k[0]/=m;k[1]/=m;k[2]/=m;k[3]=0;k[4]=1}else{if(e.abs(l)>=1){k[0]=(k[6]*k[6]+k[7]*k[7]-l*l)/(2*l);k[1]=-k[6]/l;k[2]=-k[7]/l;k[3]=1/(2*l);k[4]=1}else{j=(l<=0)?(-1):(1);k[0]=j*(k[6]*k[6]+k[7]*k[7]-l*l)*0.5;k[1]=-j*k[6];k[2]=-j*k[7];k[3]=j/2;k[4]=j*l}}return k},toGL:function(k){var l,o,n;if(typeof Float32Array!=="undefined"){l=new Float32Array(16)}else{l=new Array(16)}if(k.length!==4&&k[0].length!==4){return l}for(o=0;o<4;o++){for(n=0;n<4;n++){l[o+4*n]=k[o][n]}}return l}}})(JXG,Math);JXG.Math.Numerics=(function(f,e){var g={rk4:{s:4,A:[[0,0,0,0],[0.5,0,0,0],[0,0.5,0,0],[0,0,1,0]],b:[1/6,1/3,1/3,1/6],c:[0,0.5,0.5,1]},heun:{s:2,A:[[0,0],[1,0]],b:[0.5,0.5],c:[0,1]},euler:{s:1,A:[[0]],b:[1],c:[0]}};return{Gauss:function(h,s){var u=f.Math.eps,l=h.length>0?h[0].length:0,q,t,r,p,o,m=function(v,n){var k=this[v];this[v]=this[n];this[n]=k};if((l!==s.length)||(l!==h.length)){throw new Error("JXG.Math.Numerics.Gauss: Dimensions don't match. A must be a square matrix and b must be of the same length as A.")}q=new Array(l);t=s.slice(0,l);for(r=0;r<l;r++){q[r]=h[r].slice(0,l)}for(p=0;p<l;p++){for(r=l-1;r>p;r--){if(e.abs(q[r][p])>u){if(e.abs(q[p][p])<u){m.apply(q,[r,p]);m.apply(t,[r,p])}else{q[r][p]/=q[p][p];t[r]-=q[r][p]*t[p];for(o=p+1;o<l;o++){q[r][o]-=q[r][p]*q[p][o]}}}}if(e.abs(q[p][p])<u){throw new Error("JXG.Math.Numerics.Gauss(): The given matrix seems to be singular.")}}this.backwardSolve(q,t,true);return t},backwardSolve:function(r,l,q){var k,h,s,p,o;if(q){k=l}else{k=l.slice(0,l.length)}h=r.length;s=r.length>0?r[0].length:0;for(p=h-1;p>=0;p--){for(o=s-1;o>p;o--){k[p]-=r[p][o]*k[o]}k[p]/=r[p][p]}return k},gaussBareiss:function(v){var m,u,A,q,o,h,l,r,w,z=f.Math.eps;l=v.length;if(l<=0){return 0}if(v[0].length<l){l=v[0].length}r=new Array(l);for(q=0;q<l;q++){r[q]=v[q].slice(0,l)}u=1;A=1;for(m=0;m<l-1;m++){h=r[m][m];if(e.abs(h)<z){for(q=0;q<l;q++){if(e.abs(r[q][m])>=z){break}}if(q==l){return 0}for(o=m;o<l;o++){w=r[q][o];r[q][o]=r[m][o];r[m][o]=w}A=-A;h=r[m][m]}for(q=m+1;q<l;q++){for(o=m+1;o<l;o++){w=h*r[q][o]-r[q][m]*r[m][o];r[q][o]=w/u}}u=h}return A*r[l-1][l-1]},det:function(h){return this.gaussBareiss(h)},Jacobi:function(C){var s,q,p,h,t,B,z,D=f.Math.eps,w=0,v,r,m=C.length,o=[[0,0,0],[0,0,0],[0,0,0]],l=[[0,0,0],[0,0,0],[0,0,0]],u=0;for(s=0;s<m;s++){for(q=0;q<m;q++){o[s][q]=0;l[s][q]=C[s][q];w+=e.abs(l[s][q])}o[s][s]=1}if(m==1){return[l,o]}if(w<=0){return[l,o]}w/=(m*m);do{v=0;r=0;for(q=1;q<m;q++){for(s=0;s<q;s++){h=e.abs(l[s][q]);if(h>r){r=h}v+=h;if(h>=D){h=e.atan2(2*l[s][q],l[s][s]-l[q][q])*0.5;t=e.sin(h);B=e.cos(h);for(p=0;p<m;p++){z=l[p][s];l[p][s]=B*z+t*l[p][q];l[p][q]=-t*z+B*l[p][q];z=o[p][s];o[p][s]=B*z+t*o[p][q];o[p][q]=-t*z+B*o[p][q]}l[s][s]=B*l[s][s]+t*l[q][s];l[q][q]=-t*l[s][q]+B*l[q][q];l[s][q]=0;for(p=0;p<m;p++){l[s][p]=l[p][s];l[q][p]=l[p][q]}}}}u++}while(e.abs(v)/w>D&&u<2000);return[l,o]},NewtonCotes:function(h,l,j){var m=0,q=j&&typeof j.number_of_nodes==="number"?j.number_of_nodes:28,o={trapez:true,simpson:true,milne:true},r=j&&j.integration_type&&o.hasOwnProperty(j.integration_type)&&o[j.integration_type]?j.integration_type:"milne",p=(h[1]-h[0])/q,n,k,s;switch(r){case"trapez":m=(l(h[0])+l(h[1]))*0.5;n=h[0];for(k=0;k<q-1;k++){n+=p;m+=l(n)}m*=p;break;case"simpson":if(q%2>0){throw new Error("JSXGraph:  INT_SIMPSON requires config.number_of_nodes dividable by 2.")}s=q/2;m=l(h[0])+l(h[1]);n=h[0];for(k=0;k<s-1;k++){n+=2*p;m+=2*l(n)}n=h[0]-p;for(k=0;k<s;k++){n+=2*p;m+=4*l(n)}m*=p/3;break;default:if(q%4>0){throw new Error("JSXGraph: Error in INT_MILNE: config.number_of_nodes must be a multiple of 4")}s=q*0.25;m=7*(l(h[0])+l(h[1]));n=h[0];for(k=0;k<s-1;k++){n+=4*p;m+=14*l(n)}n=h[0]-3*p;for(k=0;k<s;k++){n+=4*p;m+=32*(l(n)+l(n+2*p))}n=h[0]-2*p;for(k=0;k<s;k++){n+=4*p;m+=12*l(n)}m*=2*p/45}return m},I:function(h,i){return this.NewtonCotes(h,i,{number_of_nodes:16,integration_type:"milne"})},Newton:function(p,j,k){var l=0,n=f.Math.eps,o=p.apply(k,[j]),m=1,q;if(f.isArray(j)){j=j[0]}while(l<50&&e.abs(o)>n){q=this.D(p,k)(j);m+=2;if(e.abs(q)>n){j-=o/q}else{j+=(e.random()*0.2-1)}o=p.apply(k,[j]);m++;l++}return j},root:function(j,h,i){return this.fzero(j,h,i)},Neville:function(l){var i=[],h=function(m){return function(w,n){var p,v,z,A=f.Math.binomial,u=l.length,o=u-1,q=0,r=0;if(!n){z=1;for(p=0;p<u;p++){i[p]=A(o,p)*z;z*=(-1)}}v=w;for(p=0;p<u;p++){if(v===0){return l[p][m]()}else{z=i[p]/v;v--;q+=l[p][m]()*z;r+=z}}return q/r}},k=h("X"),j=h("Y");return[k,j,0,function(){return l.length-1}]},splineDef:function(s,r){var h=e.min(s.length,r.length),k,o,j,p=[],q=[],m=[],v=[],t=[],u=[];if(h===2){return[0,0]}for(o=0;o<h;o++){k={X:s[o],Y:r[o]};m.push(k)}m.sort(function(l,i){return l.X-i.X});for(o=0;o<h;o++){s[o]=m[o].X;r[o]=m[o].Y}for(o=0;o<h-1;o++){v.push(s[o+1]-s[o])}for(o=0;o<h-2;o++){t.push(6*(r[o+2]-r[o+1])/(v[o+1])-6*(r[o+1]-r[o])/(v[o]))}p.push(2*(v[0]+v[1]));q.push(t[0]);for(o=0;o<h-3;o++){j=v[o+1]/p[o];p.push(2*(v[o+1]+v[o+2])-j*v[o+1]);q.push(t[o+1]-j*q[o])}u[h-3]=q[h-3]/p[h-3];for(o=h-4;o>=0;o--){u[o]=(q[o]-(v[o+1]*u[o+1]))/p[o]}for(o=h-3;o>=0;o--){u[o+1]=u[o]}u[0]=0;u[h-1]=0;return u},splineEval:function(k,z,v,B){var m=e.min(z.length,v.length),p=1,o=false,A=[],r,q,w,u,t,s,h;if(f.isArray(k)){p=k.length;o=true}else{k=[k]}for(r=0;r<p;r++){if((k[r]<z[0])||(z[r]>z[m-1])){return NaN}for(q=1;q<m;q++){if(k[r]<=z[q]){break}}q--;w=v[q];u=(v[q+1]-v[q])/(z[q+1]-z[q])-(z[q+1]-z[q])/6*(B[q+1]+2*B[q]);t=B[q]/2;s=(B[q+1]-B[q])/(6*(z[q+1]-z[q]));h=k[r]-z[q];A.push(w+(u+(t+s*h)*h)*h)}if(o){return A}else{return A[0]}},generatePolynomialTerm:function(h,n,j,k){var m=[],l;for(l=n;l>=0;l--){m=m.concat(["(",h[l].toPrecision(k),")"]);if(l>1){m=m.concat(["*",j,"<sup>",l,"<","/sup> + "])}else{if(l===1){m=m.concat(["*",j," + "])}}}return m.join("")},lagrangePolynomial:function(j){var h=[],i=function(v,l){var o,m,r,u,w,p=0,q=0,t,n;r=j.length;if(!l){for(o=0;o<r;o++){h[o]=1;u=j[o].X();for(m=0;m<r;m++){if(m!=o){h[o]*=(u-j[m].X())}}h[o]=1/h[o]}t=[];for(n=0;n<r;n++){t.push([1])}}for(o=0;o<r;o++){u=j[o].X();if(v===u){return j[o].Y()}else{w=h[o]/(v-u);q+=w;p+=w*j[o].Y()}}return p/q};i.getTerm=function(){return""};return i},CatmullRomSpline:function(j){var i=[],l,m={},k={},h=function(n){return function(q,p){var o=j.length,r,u;if(o<2){return NaN}if(!p){m[n]=function(){return 2*j[0][n]()-j[1][n]()};k[n]=function(){return 2*j[o-1][n]()-j[o-2][n]()};l=[m].concat(j,[k]);i[n]=[];for(r=0;r<o-1;r++){i[n][r]=[2*l[r+1][n](),-l[r][n]()+l[r+2][n](),2*l[r][n]()-5*l[r+1][n]()+4*l[r+2][n]()-l[r+3][n](),-l[r][n]()+3*l[r+1][n]()-3*l[r+2][n]()+l[r+3][n]()]}}o+=2;if(isNaN(q)){return NaN}if(q<0){return l[1][n]()}else{if(q>=o-3){return l[o-2][n]()}}r=e.floor(q);if(r==q){return l[r][n]()}q-=r;u=i[n][r];return 0.5*(((u[3]*q+u[2])*q+u[1])*q+u[0])}};return[h("X"),h("Y"),0,function(){return j.length-1}]},regressionPolynomial:function(l,p,o){var h,i,n,m,j,q,k="";if(f.isPoint(l)&&typeof l.Value=="function"){i=function(){return l.Value()}}else{if(f.isFunction(l)){i=l}else{if(f.isNumber(l)){i=function(){return l}}else{throw new Error("JSXGraph: Can't create regressionPolynomial from degree of type'"+(typeof l)+"'.")}}}if(arguments.length==3&&f.isArray(p)&&f.isArray(o)){j=0}else{if(arguments.length==2&&f.isArray(p)&&p.length>0&&f.isPoint(p[0])){j=1}else{throw new Error("JSXGraph: Can't create regressionPolynomial. Wrong parameters.")}}q=function(F,r){var v,u,C,z,E,t,D,G,A,w=p.length;A=e.floor(i());if(!r){if(j===1){n=[];m=[];for(v=0;v<w;v++){n[v]=p[v].X();m[v]=p[v].Y()}}if(j===0){n=[];m=[];for(v=0;v<w;v++){if(f.isFunction(p[v])){n.push(p[v]())}else{n.push(p[v])}if(f.isFunction(o[v])){m.push(o[v]())}else{m.push(o[v])}}}C=[];for(u=0;u<w;u++){C.push([1])}for(v=1;v<=A;v++){for(u=0;u<w;u++){C[u][v]=C[u][v-1]*n[u]}}E=m;z=f.Math.transpose(C);t=f.Math.matMatMult(z,C);D=f.Math.matVecMult(z,E);h=f.Math.Numerics.Gauss(t,D);k=f.Math.Numerics.generatePolynomialTerm(h,A,"x",3)}G=h[A];for(v=A-1;v>=0;v--){G=(G*F+h[v])}return G};q.getTerm=function(){return k};return q},bezier:function(j){var h,i=function(k){return function(m,l){var p=e.floor(m)*3,o=m%1,n=1-o;if(!l){h=e.floor(j.length/3)}if(m<0){return j[0][k]()}if(m>=h){return j[j.length-1][k]()}if(isNaN(m)){return NaN}return n*n*(n*j[p][k]()+3*o*j[p+1][k]())+(3*n*j[p+2][k]()+o*j[p+3][k]())*o*o}};return[i("X"),i("Y"),0,function(){return e.floor(j.length/3)}]},bspline:function(k,h){var l,n=[],m=function(r,o){var p,q=[];for(p=0;p<r+o+1;p++){if(p<o){q[p]=0}else{if(p<=r){q[p]=p-o+1}else{q[p]=r-o+2}}}return q},j=function(A,C,o,p,B){var r,q,w,v,z,u=[];if(C[B]<=A&&A<C[B+1]){u[B]=1}else{u[B]=0}for(r=2;r<=p;r++){for(q=B-r+1;q<=B;q++){if(q<=B-r+1||q<0){w=0}else{w=u[q]}if(q>=B){v=0}else{v=u[q+1]}z=C[q+r-1]-C[q];if(z==0){u[q]=0}else{u[q]=(A-C[q])/z*w}z=C[q+r]-C[q+1];if(z!=0){u[q]+=(C[q+r]-A)/z*v}}}return u},i=function(o){return function(v,q){var p=k.length,A,u,w,z=p-1,r=h;if(z<=0){return NaN}if(z+2<=r){r=z+1}if(v<=0){return k[0][o]()}if(v>=z-r+2){return k[z][o]()}l=m(z,r);w=e.floor(v)+r-1;n=j(v,l,z,r,w);A=0;for(u=w-r+1;u<=w;u++){if(u<p&&u>=0){A+=k[u][o]()*n[u]}}return A}};return[i("X"),i("Y"),0,function(){return k.length-1}]},D:function(k,l){var j=0.00001,i=1/(j*2);if(arguments.length==1||(arguments.length>1&&!f.exists(arguments[1]))){return function(h,m){return(k(h+j,m)-k(h-j,m))*i}}else{return function(h,m){return(k.apply(l,[h+j,m])-k.apply(l,[h-j,m]))*i}}},riemann:function(s,o,t,l,p){var m=[],A=[],r,q=0,z,w=l,u,k,v,h;o=e.round(o);m[q]=w;A[q]=0;if(o>0){z=(p-l)/o;h=z*0.01;for(r=0;r<o;r++){if(t==="right"){u=s(w+z)}else{if(t==="middle"){u=s(w+z*0.5)}else{if((t==="left")||(t==="trapezodial")){u=s(w)}else{if(t==="lower"){u=s(w);for(k=w+h;k<=w+z;k+=h){v=s(k);if(v<u){u=v}}}else{u=s(w);for(k=w+h;k<=w+z;k+=h){v=s(k);if(v>u){u=v}}}}}}q++;m[q]=w;A[q]=u;q++;w+=z;if(t==="trapezodial"){u=s(w)}m[q]=w;A[q]=u;q++;m[q]=w;A[q]=0}}return[m,A]},riemannsum:function(p,l,r,k,m){var q=0,o,v,u=k,s,j,t,h;l=e.floor(l);if(l>0){v=(m-k)/l;h=v*0.01;for(o=0;o<l;o++){if(r==="right"){s=p(u+v)}else{if(r==="middle"){s=p(u+v*0.5)}else{if(r==="trapezodial"){s=0.5*(p(u+v)+p(u))}else{if(r==="left"){s=p(u)}else{if(r==="lower"){s=p(u);for(j=u+h;j<=u+v;j+=h){t=p(j);if(t<s){s=t}}}else{s=p(u);for(j=u+h;j<=u+v;j+=h){t=p(j);if(t>s){s=t}}}}}}}q+=v*s;u+=v}}return q},rungeKutta:function(m,H,p,n,G){var q=[],o=[],F=(p[1]-p[0])/n,v=p[0],J,E,D,B,A,C=H.length,w,u=[],z=0;if(f.isString(m)){m=g[m]||g.euler}w=m.s;for(J=0;J<C;J++){q[J]=H[J]}for(E=0;E<n;E++){u[z]=[];for(J=0;J<C;J++){u[z][J]=q[J]}z++;B=[];for(D=0;D<w;D++){for(J=0;J<C;J++){o[J]=0}for(A=0;A<D;A++){for(J=0;J<C;J++){o[J]+=(m.A[D][A])*F*B[A][J]}}for(J=0;J<C;J++){o[J]+=q[J]}B.push(G(v+m.c[D]*F,o))}for(J=0;J<C;J++){o[J]=0}for(A=0;A<w;A++){for(J=0;J<C;J++){o[J]+=m.b[A]*B[A][J]}}for(J=0;J<C;J++){q[J]=q[J]+F*o[J]}v+=F}return u},maxIterationsRoot:80,maxIterationsMinimize:500,fzero:function(I,J,O){var B=f.Math.eps,h=this.maxIterationsRoot,A=0,D=0,r=B,M,L,K,C,z,w,N,k,F,G,o,j,E,H,v,s,n,m,t,l;if(f.isArray(J)){if(J.length<2){throw new Error("JXG.Math.Numerics.fzero: length of array x0 has to be at least two.")}M=J[0];C=I.apply(O,[M]);D++;L=J[1];z=I.apply(O,[L]);D++}else{M=J;C=I.apply(O,[M]);D++;if(M==0){N=1}else{N=M}k=[0.9*N,1.1*N,N-1,N+1,0.5*N,1.5*N,-N,2*N,-10*N,10*N];G=k.length;for(F=0;F<G;F++){L=k[F];z=I.apply(O,[L]);D++;if(C*z<=0){break}}if(L<M){o=M;M=L;L=o;j=C;C=z;z=j}}if(C*z>0){if(f.isArray(J)){return this.fminbr(I,[M,L],O)}else{return this.Newton(I,M,O)}}K=M;w=C;while(A<h){E=L-M;if(e.abs(w)<e.abs(z)){M=L;L=K;K=M;C=z;z=w;w=C}H=2*r*e.abs(L)+B*0.5;n=(K-L)*0.5;if(e.abs(n)<=H&&e.abs(z)<=r){return L}if(e.abs(E)>=H&&e.abs(C)>e.abs(z)){t=K-L;if(M==K){m=z/C;v=t*m;s=1-m}else{s=C/w;m=z/w;l=z/C;v=l*(t*s*(s-m)-(L-M)*(m-1));s=(s-1)*(m-1)*(l-1)}if(v>0){s=-s}else{v=-v}if(v<(0.75*t*s-e.abs(H*s)*0.5)&&v<e.abs(E*s*0.5)){n=v/s}}if(e.abs(n)<H){if(n>0){n=H}else{n=-H}}M=L;C=z;L+=n;z=I.apply(O,[L]);D++;if((z>0&&w>0)||(z<0&&w<0)){K=M;w=C}A++}return L},fminbr:function(I,J,N){var M,K,m,s,o,i,k,j,A=(3-e.sqrt(5))*0.5,F=f.Math.eps,C=e.sqrt(f.Math.eps),h=this.maxIterationsMinimize,E=0,z,L,H,n,D,B,u,l,G=0;if(!f.isArray(J)||J.length<2){throw new Error("JXG.Math.Numerics.fminbr: length of array x0 has to be at least two.")}M=J[0];K=J[1];s=M+A*(K-M);k=I.apply(N,[s]);G++;m=s;o=s;i=k;j=k;while(E<h){z=K-M;L=(M+K)*0.5;H=C*e.abs(m)+F/3;if(e.abs(m-L)+z*0.5<=2*H){return m}n=A*(m<L?K-m:M-m);if(e.abs(m-o)>=H){u=(m-o)*(i-k);B=(m-s)*(i-j);D=(m-s)*B-(m-o)*u;B=2*(B-u);if(B>0){D=-D}else{B=-B}if(e.abs(D)<e.abs(n*B)&&D>B*(M-m+2*H)&&D<B*(K-m-2*H)){n=D/B}}if(e.abs(n)<H){if(n>0){n=H}else{n=-H}}u=m+n;l=I.apply(N,[u]);G++;if(l<=i){if(u<m){K=m}else{M=m}s=o;o=m;m=u;k=j;j=i;i=l}else{if(u<m){M=u}else{K=u}if(l<=j||o==m){s=o;o=u;k=j;j=l}else{if(l<=k||s==m||s==o){s=u;k=l}}}E++}return m},reuleauxPolygon:function(j,k){var n=e.PI*2,i=n/k,m=(k-1)/2,l,o=0,h=function(q,p){return function(s,v){if(!v){o=j[0].Dist(j[m]);l=f.Math.Geometry.rad([j[0].X()+1,j[0].Y()],j[0],j[(m)%k])}var u=(s%n+n)%n;var r=e.floor(u/i)%k;if(isNaN(r)){return r}u=u*0.5+r*i*0.5+l;return j[r][q]()+o*e[p](u)}};return[h("X","cos"),h("Y","sin"),0,e.PI*2]},RamerDouglasPeuker:function(q,j){var n=[],p,m,h,l=function(v,u,t,r,s){var k=o(v,u,t);if(k[0]>r){l(v,u,k[1],r,s);l(v,k[1],t,r,s)}else{s.push(v[t])}},o=function(H,w,v){var B=0,z=w,A,u,I,G,F,t,E,s,C,D,r;if(v-w<2){return[-1,0]}I=H[w].scrCoords;G=H[v].scrCoords;if(isNaN(I[1]+I[2]+G[1]+G[2])){return[NaN,v]}for(u=w+1;u<v;u++){F=H[u].scrCoords;t=F[1]-I[1];E=F[2]-I[2];s=G[1]-I[1];C=G[2]-I[2];D=s*s+C*C;if(D>=f.Math.eps){r=(t*s+E*C)/D;if(r<0){r=0}else{if(r>1){r=1}}t=t-r*s;E=E-r*C;A=t*t+E*E}else{r=0;A=t*t+E*E}if(A>B){B=A;z=u}}return[e.sqrt(B),z]};h=q.length;p=0;while(p<h&&isNaN(q[p].scrCoords[1]+q[p].scrCoords[2])){p++}m=h-1;while(m>p&&isNaN(q[m].scrCoords[1]+q[m].scrCoords[2])){m--}if(!(p>m||p==h)){n[0]=q[p];l(q,p,m,j,n)}return n}}})(JXG,Math);JXG.Math.Statistics={sum:function(f){var h,e=f.length,g=0;for(h=0;h<e;h++){g+=f[h]}return g},prod:function(f){var h,e=f.length,g=1;for(h=0;h<e;h++){g*=f[h]}return g},mean:function(e){if(e.length>0){return this.sum(e)/e.length}else{return 0}},median:function(f){var g,e;if(f.length>0){g=f.slice(0);g.sort(function(i,h){return i-h});e=g.length;if(e%2==1){return g[parseInt(e*0.5)]}else{return(g[e*0.5-1]+g[e*0.5])*0.5}}else{return 0}},variance:function(g){var f,j,h,e=g.length;if(e>1){f=this.mean(g);j=0;for(h=0;h<e;h++){j+=(g[h]-f)*(g[h]-f)}return j/(g.length-1)}else{return 0}},sd:function(e){return Math.sqrt(this.variance(e))},weightedMean:function(e,f){if(e.length!=f.length){throw new Error("JSXGraph error (Math.Statistics.weightedMean): Array dimension mismatch.")}if(e.length>0){return this.mean(this.multiply(e,f))}else{return 0}},max:function(e){return Math.max.apply(this,e)},min:function(e){return Math.min.apply(this,e)},range:function(e){return[this.min(e),this.max(e)]},abs:function(f){var h,e,g;if(JXG.isArray(f)){e=f.length;g=[];for(h=0;h<e;h++){g[h]=Math.abs(f[h])}}else{g=Math.abs(f)}return g},add:function(g,f){var j,e,h=[];if(JXG.isArray(g)&&JXG.isNumber(f)){e=g.length;for(j=0;j<e;j++){h[j]=g[j]+f}}else{if(JXG.isNumber(g)&&JXG.isArray(f)){e=f.length;for(j=0;j<e;j++){h[j]=g+f[j]}}else{if(JXG.isArray(g)&&JXG.isArray(f)){e=Math.min(g.length,f.length);for(j=0;j<e;j++){h[j]=g[j]+f[j]}}else{h=g+f}}}return h},div:function(g,f){var j,e,h=[];if(JXG.isArray(g)&&JXG.isNumber(f)){e=g.length;for(j=0;j<e;j++){h[j]=g[j]/f}}else{if(JXG.isNumber(g)&&JXG.isArray(f)){e=f.length;for(j=0;j<e;j++){h[j]=g/f[j]}}else{if(JXG.isArray(g)&&JXG.isArray(f)){e=Math.min(g.length,f.length);for(j=0;j<e;j++){h[j]=g[j]/f[j]}}else{h=g/f}}}return h},divide:JXG.shortcut(JXG.Math.Statistics,"div"),mod:function(g,f,l){var k,e,j=[],h=function(n,i){return n%i};l=JXG.def(l,false);if(l){h=JXG.Math.mod}if(JXG.isArray(g)&&JXG.isNumber(f)){e=g.length;for(k=0;k<e;k++){j[k]=h(g[k],f)}}else{if(JXG.isNumber(g)&&JXG.isArray(f)){e=f.length;for(k=0;k<e;k++){j[k]=h(g,f[k])}}else{if(JXG.isArray(g)&&JXG.isArray(f)){e=Math.min(g.length,f.length);for(k=0;k<e;k++){j[k]=h(g[k],f[k])}}else{j=h(g,f)}}}return j},multiply:function(g,f){var j,e,h=[];if(JXG.isArray(g)&&JXG.isNumber(f)){e=g.length;for(j=0;j<e;j++){h[j]=g[j]*f}}else{if(JXG.isNumber(g)&&JXG.isArray(f)){e=f.length;for(j=0;j<e;j++){h[j]=g*f[j]}}else{if(JXG.isArray(g)&&JXG.isArray(f)){e=Math.min(g.length,f.length);for(j=0;j<e;j++){h[j]=g[j]*f[j]}}else{h=g*f}}}return h},subtract:function(g,f){var j,e,h=[];if(JXG.isArray(g)&&JXG.isNumber(f)){e=g.length;for(j=0;j<e;j++){h[j]=g[j]-f}}else{if(JXG.isNumber(g)&&JXG.isArray(f)){e=f.length;for(j=0;j<e;j++){h[j]=g-f[j]}}else{if(JXG.isArray(g)&&JXG.isArray(f)){e=Math.min(g.length,f.length);for(j=0;j<e;j++){h[j]=g[j]-f[j]}}else{h=g-f}}}return h}};JXG.Math.Symbolic=function(e,f){return{generateSymbolicCoordinatesPartial:function(p,l,j,h){var g=function(k){var s;if(h==="underscore"){s=""+j+"_{"+k+"}"}else{if(h=="brace"){s=""+j+"["+k+"]"}else{s=""+j+""+k}}return s},n=l.ancestors,m=0,o,q,i;p.listOfFreePoints=[];p.listOfDependantPoints=[];for(q in n){o=0;if(e.isPoint(n[q])){for(i in n[q].ancestors){o++}if(o===0){n[q].symbolic.x=n[q].coords.usrCoords[1];n[q].symbolic.y=n[q].coords.usrCoords[2];p.listOfFreePoints.push(n[q])}else{m++;n[q].symbolic.x=g(m);m++;n[q].symbolic.y=g(m);p.listOfDependantPoints.push(n[q])}}}if(e.isPoint(l)){l.symbolic.x="x";l.symbolic.y="y"}return m},clearSymbolicCoordinates:function(h){var g=function(k){var j,i=(k&&k.length)||0;for(j=0;j<i;j++){if(e.isPoint(k[j])){k[j].symbolic.x="";k[j].symbolic.y=""}}};g(h.listOfFreePoints);g(h.listOfDependantPoints);delete (h.listOfFreePoints);delete (h.listOfDependantPoints)},generatePolynomials:function(o,j,l){var n=j.ancestors,p,m=[],r=[],q,g,h;if(l){this.generateSymbolicCoordinatesPartial(o,j,"u","brace")}n[j.id]=j;for(q in n){p=0;m=[];if(e.isPoint(n[q])){for(g in n[q].ancestors){p++}if(p>0){m=n[q].generatePolynomial();for(h=0;h<m.length;h++){r.push(m[h])}}}}if(l){this.clearSymbolicCoordinates(o)}return r},geometricLocusByGroebnerBase:function(o,C){var m=this.generateSymbolicCoordinatesPartial(o,C,"u","brace"),n,j,r,g={},w=new e.Coords(e.COORDS_BY_USR,[0,0],o),u=new e.Coords(e.COORDS_BY_USR,[o.canvasWidth,o.canvasHeight],o),l,k,F,I=1,v=0,t=0,p=0,G,z,H,q,B,D,h,E=function(J,K){var s;for(s=0;s<K.length;s++){if(K[s].id===J){return true}}return false},A=o.options.locus;if(e.Server.modules.geoloci===f){e.Server.loadModule("geoloci")}if(e.Server.modules.geoloci===f){throw new Error("JSXGraph: Unable to load JXG.Server module 'geoloci.py'.")}q=w.usrCoords[1];B=u.usrCoords[1];D=u.usrCoords[2];h=w.usrCoords[2];if(A.translateToOrigin&&(o.listOfFreePoints.length>0)){if((A.toOrigin!==f)&&(A.toOrigin!=null)&&E(A.toOrigin.id,o.listOfFreePoints)){l=A.toOrigin}else{l=o.listOfFreePoints[0]}v=l.symbolic.x;t=l.symbolic.y;for(F=0;F<o.listOfFreePoints.length;F++){o.listOfFreePoints[F].symbolic.x-=v;o.listOfFreePoints[F].symbolic.y-=t}q-=v;B-=v;D-=t;h-=t;if(A.translateTo10&&(o.listOfFreePoints.length>1)){if((A.to10!==f)&&(A.to10!=null)&&(A.to10.id!=A.toOrigin.id)&&E(A.to10.id,o.listOfFreePoints)){k=A.to10}else{if(o.listOfFreePoints[0].id==l.id){k=o.listOfFreePoints[1]}else{k=o.listOfFreePoints[0]}}p=e.Math.Geometry.rad([1,0],[0,0],[k.symbolic.x,k.symbolic.y]);G=Math.cos(-p);z=Math.sin(-p);for(F=0;F<o.listOfFreePoints.length;F++){H=o.listOfFreePoints[F].symbolic.x;o.listOfFreePoints[F].symbolic.x=G*o.listOfFreePoints[F].symbolic.x-z*o.listOfFreePoints[F].symbolic.y;o.listOfFreePoints[F].symbolic.y=z*H+G*o.listOfFreePoints[F].symbolic.y}k.symbolic.y=0;H=q;q=G*q-z*D;D=z*H+G*D;H=B;B=G*B-z*h;h=z*H+G*h;if(A.stretch&&(Math.abs(k.symbolic.x)>e.Math.eps)){I=k.symbolic.x;for(F=0;F<o.listOfFreePoints.length;F++){o.listOfFreePoints[F].symbolic.x/=I;o.listOfFreePoints[F].symbolic.y/=I}for(F in o.objects){if((o.objects[F].elementClass==e.OBJECT_CLASS_CIRCLE)&&(o.objects[F].method=="pointRadius")){g[F]=o.objects[F].radius;o.objects[F].radius/=I}}q/=I;B/=I;D/=I;h/=I;k.symbolic.x=1}}for(F=0;F<o.listOfFreePoints.length;F++){H=o.listOfFreePoints[F].symbolic.x;if(Math.abs(H)<e.Math.eps){o.listOfFreePoints[F].symbolic.x=0}if(Math.abs(H-Math.round(H))<e.Math.eps){o.listOfFreePoints[F].symbolic.x=Math.round(H)}H=o.listOfFreePoints[F].symbolic.y;if(Math.abs(H)<e.Math.eps){o.listOfFreePoints[F].symbolic.y=0}if(Math.abs(H-Math.round(H))<e.Math.eps){o.listOfFreePoints[F].symbolic.y=Math.round(H)}}}n=this.generatePolynomials(o,C);j=n.join(",");this.cbp=function(i){r=i};this.cb=e.bind(this.cbp,this);e.Server.modules.geoloci.lociCoCoA(q,B,D,h,m,j,I,p,v,t,this.cb,true);this.clearSymbolicCoordinates(o);for(F in g){o.objects[F].radius=g[F]}return r}}}(JXG);JXG.Math.Geometry={};JXG.extend(JXG.Math.Geometry,{angle:function(g,f,e){var j=[],i=[],h=[],l,k,n,m;if(g.coords==null){j[0]=g[0];j[1]=g[1]}else{j[0]=g.coords.usrCoords[1];j[1]=g.coords.usrCoords[2]}if(f.coords==null){i[0]=f[0];i[1]=f[1]}else{i[0]=f.coords.usrCoords[1];i[1]=f.coords.usrCoords[2]}if(e.coords==null){h[0]=e[0];h[1]=e[1]}else{h[0]=e.coords.usrCoords[1];h[1]=e.coords.usrCoords[2]}l=j[0]-i[0];k=j[1]-i[1];n=h[0]-i[0];m=h[1]-i[1];return Math.atan2(l*m-k*n,l*n+k*m)},trueAngle:function(e,g,f){return this.rad(e,g,f)*57.29577951308232},rad:function(h,g,f){var e,n,m,l,j,i,k;if(h.coords==null){e=h[0];n=h[1]}else{e=h.coords.usrCoords[1];n=h.coords.usrCoords[2]}if(g.coords==null){m=g[0];l=g[1]}else{m=g.coords.usrCoords[1];l=g.coords.usrCoords[2]}if(f.coords==null){j=f[0];i=f[1]}else{j=f.coords.usrCoords[1];i=f.coords.usrCoords[2]}k=Math.atan2(i-l,j-m)-Math.atan2(n-l,e-m);if(k<0){k+=6.283185307179586}return k},angleBisector:function(i,h,f,l){var g=i.coords.usrCoords,o=h.coords.usrCoords,j=f.coords.usrCoords,p=g[1]-o[1],n=g[2]-o[2],m=Math.sqrt(p*p+n*n),e,q,k;if(!JXG.exists(l)){l=i.board}p/=m;n/=m;e=Math.acos(p);if(n<0){e*=-1}if(e<0){e+=2*Math.PI}p=j[1]-o[1];n=j[2]-o[2];m=Math.sqrt(p*p+n*n);p/=m;n/=m;q=Math.acos(p);if(n<0){q*=-1}if(q<0){q+=2*Math.PI}k=(e+q)*0.5;if(e>q){k+=Math.PI}p=Math.cos(k)+o[1];n=Math.sin(k)+o[2];return new JXG.Coords(JXG.COORDS_BY_USER,[p,n],l)},reflection:function(p,m,g){var i=m.coords.usrCoords,q=p.point1.coords.usrCoords,h=p.point2.coords.usrCoords,f,l,e,j,n,k,o;if(!JXG.exists(g)){g=m.board}n=h[1]-q[1];k=h[2]-q[2];f=i[1]-q[1];l=i[2]-q[2];o=(n*l-k*f)/(n*n+k*k);e=i[1]+2*o*k;j=i[2]-2*o*n;return new JXG.Coords(JXG.COORDS_BY_USER,[e,j],g)},rotation:function(e,o,i,j){var l=o.coords.usrCoords,f=e.coords.usrCoords,h,n,k,p,g,m;if(!JXG.exists(j)){j=o.board}h=l[1]-f[1];n=l[2]-f[2];k=Math.cos(i);p=Math.sin(i);g=h*k-n*p+f[1];m=h*p+n*k+f[2];return new JXG.Coords(JXG.COORDS_BY_USER,[g,m],j)},perpendicular:function(r,p,j){var i=r.point1.coords.usrCoords,h=r.point2.coords.usrCoords,f=p.coords.usrCoords,n,m,l,q,k,g,e,o;if(!JXG.exists(j)){j=p.board}if(p==r.point1){n=i[1]+h[2]-i[2];m=i[2]-h[1]+i[1];l=true}else{if(p==r.point2){n=h[1]+i[2]-h[2];m=h[2]-i[1]+h[1];l=false}else{if(((Math.abs(i[1]-h[1])>JXG.Math.eps)&&(Math.abs(f[2]-(i[2]-h[2])*(f[1]-i[1])/(i[1]-h[1])-i[2])<JXG.Math.eps))||((Math.abs(i[1]-h[1])<=JXG.Math.eps)&&(Math.abs(i[1]-f[1])<JXG.Math.eps))){n=f[1]+h[2]-f[2];m=f[2]-h[1]+f[1];l=true;if(Math.abs(n-f[1])<JXG.Math.eps&&Math.abs(m-f[2])<JXG.Math.eps){n=f[1]+i[2]-f[2];m=f[2]-i[1]+f[1];l=false}}else{q=i[2]-h[2];k=i[1]-h[1];g=h[1]*q-h[2]*k;e=f[1]*k+f[2]*q;o=q*q+k*k;if(Math.abs(o)<JXG.Math.eps){o=JXG.Math.eps}n=(g*q+e*k)/o;m=(e*q-g*k)/o;l=true}}}return[new JXG.Coords(JXG.COORDS_BY_USER,[n,m],j),l]},circumcenterMidpoint:JXG.shortcut(JXG.Math.Geometry,"circumcenter"),circumcenter:function(l,j,i,h){var g=l.coords.usrCoords,f=j.coords.usrCoords,e=i.coords.usrCoords,p,o,n,m,k;if(!JXG.exists(h)){h=l.board}p=((g[1]-f[1])*(g[1]+f[1])+(g[2]-f[2])*(g[2]+f[2]))*0.5;o=((f[1]-e[1])*(f[1]+e[1])+(f[2]-e[2])*(f[2]+e[2]))*0.5;n=(g[1]-f[1])*(f[2]-e[2])-(f[1]-e[1])*(g[2]-f[2]);if(Math.abs(n)<JXG.Math.eps){n=JXG.Math.eps;return new JXG.Coords(JXG.COORDS_BY_USER,[Infinity,Infinity],h)}m=(p*(f[2]-e[2])-o*(g[2]-f[2]))/n;k=(o*(g[1]-f[1])-p*(f[1]-e[1]))/n;return new JXG.Coords(JXG.COORDS_BY_USER,[m,k],h)},distance:function(j,h){var g=0,f,e;if(j.length!=h.length){return NaN}e=j.length;for(f=0;f<e;f++){g+=(j[f]-h[f])*(j[f]-h[f])}return Math.sqrt(g)},affineDistance:function(f,e){var g;if(f.length!=e.length){return NaN}g=this.distance(f,e);if(g>JXG.Math.eps&&(Math.abs(f[0])<JXG.Math.eps||Math.abs(e[0])<JXG.Math.eps)){return Infinity}else{return g}},calcStraight:function(h,q,p){var f,e,n,l,r,g,o,v,m,k,u,t;r=h.visProp.straightfirst;g=h.visProp.straightlast;if(Math.abs(q.scrCoords[0])<JXG.Math.eps){r=true}if(Math.abs(p.scrCoords[0])<JXG.Math.eps){g=true}if(!r&&!g){return}o=[];o[0]=h.stdform[0]-h.stdform[1]*h.board.origin.scrCoords[1]/h.board.unitX+h.stdform[2]*h.board.origin.scrCoords[2]/h.board.unitY;o[1]=h.stdform[1]/h.board.unitX;o[2]=h.stdform[2]/(-h.board.unitY);if(isNaN(o[0]+o[1]+o[2])){return}v=[];v[0]=JXG.Math.crossProduct(o,[0,0,1]);v[1]=JXG.Math.crossProduct(o,[0,1,0]);v[2]=JXG.Math.crossProduct(o,[-h.board.canvasHeight,0,1]);v[3]=JXG.Math.crossProduct(o,[-h.board.canvasWidth,1,0]);for(m=0;m<4;m++){if(Math.abs(v[m][0])>JXG.Math.eps){for(k=2;k>0;k--){v[m][k]/=v[m][0]}v[m][0]=1}}f=false;e=false;if(!r&&q.scrCoords[1]>=0&&q.scrCoords[1]<=h.board.canvasWidth&&q.scrCoords[2]>=0&&q.scrCoords[2]<=h.board.canvasHeight){f=true}if(!g&&p.scrCoords[1]>=0&&p.scrCoords[1]<=h.board.canvasWidth&&p.scrCoords[2]>=0&&p.scrCoords[2]<=h.board.canvasHeight){e=true}if(Math.abs(v[1][0])<JXG.Math.eps){n=v[0];l=v[2]}else{if(Math.abs(v[0][0])<JXG.Math.eps){n=v[1];l=v[3]}else{if(v[1][2]<0){n=v[0];if(v[3][2]>h.board.canvasHeight){l=v[2]}else{l=v[3]}}else{if(v[1][2]>h.board.canvasHeight){n=v[2];if(v[3][2]<0){l=v[0]}else{l=v[3]}}else{n=v[1];if(v[3][2]<0){l=v[0]}else{if(v[3][2]>h.board.canvasHeight){l=v[2]}else{l=v[3]}}}}}}n=new JXG.Coords(JXG.COORDS_BY_SCREEN,n.slice(1),h.board);l=new JXG.Coords(JXG.COORDS_BY_SCREEN,l.slice(1),h.board);if(!f&&!e){if(!r&&g&&!this.isSameDirection(q,p,n)&&!this.isSameDirection(q,p,l)){return}else{if(r&&!g&&!this.isSameDirection(p,q,n)&&!this.isSameDirection(p,q,l)){return}}}if(!f){if(!e){if(this.isSameDir(q,p,n,l)){u=n;t=l}else{t=n;u=l}}else{if(this.isSameDir(q,p,n,l)){u=n}else{u=l}}}else{if(!e){if(this.isSameDir(q,p,n,l)){t=l}else{t=n}}}if(u){q.setCoordinates(JXG.COORDS_BY_USER,u.usrCoords.slice(1))}if(t){p.setCoordinates(JXG.COORDS_BY_USER,t.usrCoords.slice(1))}},isSameDir:function(k,j,g,f){var e=j.usrCoords[1]-k.usrCoords[1],l=j.usrCoords[2]-k.usrCoords[2],i=f.usrCoords[1]-g.usrCoords[1],h=f.usrCoords[2]-g.usrCoords[2];return e*i+l*h>=0},isSameDirection:function(l,i,g){var f,e,k,j,h=false;f=i.usrCoords[1]-l.usrCoords[1];e=i.usrCoords[2]-l.usrCoords[2];k=g.usrCoords[1]-l.usrCoords[1];j=g.usrCoords[2]-l.usrCoords[2];if(Math.abs(f)<JXG.Math.eps){f=0}if(Math.abs(e)<JXG.Math.eps){e=0}if(Math.abs(k)<JXG.Math.eps){k=0}if(Math.abs(j)<JXG.Math.eps){j=0}if(f>=0&&k>=0){if((e>=0&&j>=0)||(e<=0&&j<=0)){h=true}}else{if(f<=0&&k<=0){if((e>=0&&j>=0)||(e<=0&&j<=0)){h=true}}}return h},intersectLineLine:function(p,o,k){var j=p.point1.coords.usrCoords,h=p.point2.coords.usrCoords,g=o.point1.coords.usrCoords,e=o.point2.coords.usrCoords,i,f,n,m,l;if(!JXG.exists(k)){k=p.board}i=j[1]*h[2]-j[2]*h[1];f=g[1]*e[2]-g[2]*e[1];n=(h[2]-j[2])*(g[1]-e[1])-(j[1]-h[1])*(e[2]-g[2]);if(Math.abs(n)<JXG.Math.eps){n=JXG.Math.eps}m=(i*(g[1]-e[1])-f*(j[1]-h[1]))/n;l=(f*(h[2]-j[2])-i*(e[2]-g[2]))/n;return new JXG.Coords(JXG.COORDS_BY_USER,[m,l],k)},intersectCircleLine:function(k,u,m){var J=u.point1.coords.usrCoords,H=u.point2.coords.usrCoords,g=k.center.coords.usrCoords,B,e,I,G,z,E,C,n,A,v,j,i,D,q,o,f,t,p,F;if(!JXG.exists(m)){m=u.board}B=u.point1.Dist(u.point2);if(B>0){e=k.center.Dist(u.point1);I=k.center.Dist(u.point2);G=((e*e)+(B*B)-(I*I))/(2*B);z=(e*e)-(G*G);z=(z<0)?0:z;E=Math.sqrt(z);C=k.Radius();n=Math.sqrt((C*C)-E*E);A=H[1]-J[1];v=H[2]-J[2];j=g[1]+(E/B)*v;i=g[2]-(E/B)*A;e=(H[1]*v)-(H[2]*A);I=(j*A)+(i*v);D=(v*v)+(A*A);if(Math.abs(D)<JXG.Math.eps){D=JXG.Math.eps}q=((e*v)+(I*A))/D;o=((I*v)-(e*A))/D;f=n/B;t=new JXG.Coords(JXG.COORDS_BY_USER,[q+f*A,o+f*v],m);p=new JXG.Coords(JXG.COORDS_BY_USER,[q-f*A,o-f*v],m);F=k.center.coords.distance(JXG.COORDS_BY_USER,t);if((C<(F-1))||isNaN(F)){return[0]}else{return[2,t,p]}}return[0]},intersectCircleCircle:function(m,l,o){var f={},j=m.Radius(),i=l.Radius(),g=m.center.coords.usrCoords,e=l.center.coords.usrCoords,q,k,u,t,r,p,n;if(!JXG.exists(o)){o=m.board}q=j+i;k=Math.abs(j-i);u=m.center.coords.distance(JXG.COORDS_BY_USER,l.center.coords);if(u>q){return[0]}else{if(u<k){return[0]}else{if(u!=0){f[0]=1;t=e[1]-g[1];r=e[2]-g[2];p=(u*u-i*i+j*j)/(2*u);n=Math.sqrt(j*j-p*p);f[1]=new JXG.Coords(JXG.COORDS_BY_USER,[g[1]+(p/u)*t+(n/u)*r,g[2]+(p/u)*r-(n/u)*t],o);f[2]=new JXG.Coords(JXG.COORDS_BY_USER,[g[1]+(p/u)*t-(n/u)*r,g[2]+(p/u)*r+(n/u)*t],o)}else{return[0]}return f}}},meet:function(h,f,g,j){var e=JXG.Math.eps;if(Math.abs(h[3])<e&&Math.abs(f[3])<e){return this.meetLineLine(h,f,g,j)}else{if(Math.abs(h[3])>=e&&Math.abs(f[3])<e){return this.meetLineCircle(f,h,g,j)}else{if(Math.abs(h[3])<e&&Math.abs(f[3])>=e){return this.meetLineCircle(h,f,g,j)}else{return this.meetCircleCircle(h,f,g,j)}}}},meetLineLine:function(f,e,g,j){var h=JXG.Math.crossProduct(f,e);if(Math.abs(h[0])>JXG.Math.eps){h[1]/=h[0];h[2]/=h[0];h[0]=1}return new JXG.Coords(JXG.COORDS_BY_USER,h,j)},meetLineCircle:function(j,e,o,p){var u,s,r,q,l,h,g,f,m,v;if(e[4]<JXG.Math.eps){if(Math.abs(JXG.Math.innerProduct([1,e[6],e[7]],j,3))<JXG.Math.eps){return new JXG.Coords(JXG.COORDS_BY_USER,e.slice(6,8),p)}else{return new JXG.Coords(JXG.COORDS_BY_USER,[NaN,NaN],p)}}r=e[0];s=e.slice(1,3);u=e[3];q=j[0];l=j.slice(1,3);h=u;g=(s[0]*l[1]-s[1]*l[0]);f=u*q*q-(s[0]*l[0]+s[1]*l[1])*q+r;m=g*g-4*h*f;if(m>=0){m=Math.sqrt(m);v=[(-g+m)/(2*h),(-g-m)/(2*h)];return((o==0)?new JXG.Coords(JXG.COORDS_BY_USER,[-v[0]*(-l[1])-q*l[0],-v[0]*l[0]-q*l[1]],p):new JXG.Coords(JXG.COORDS_BY_USER,[-v[1]*(-l[1])-q*l[0],-v[1]*l[0]-q*l[1]],p))}else{return new JXG.Coords(JXG.COORDS_BY_USER,[0,0,0],p)}},meetCircleCircle:function(g,e,f,h){var j;if(g[4]<JXG.Math.eps){if(Math.abs(this.distance(g.slice(6,2),e.slice(6,8))-e[4])<JXG.Math.eps){return new JXG.Coords(JXG.COORDS_BY_USER,g.slice(6,8),h)}else{return new JXG.Coords(JXG.COORDS_BY_USER,[0,0,0],h)}}if(e[4]<JXG.Math.eps){if(Math.abs(this.distance(e.slice(6,2),g.slice(6,8))-g[4])<JXG.Math.eps){return new JXG.Coords(JXG.COORDS_BY_USER,e.slice(6,8),h)}else{return new JXG.Coords(JXG.COORDS_BY_USER,[0,0,0],h)}}j=[e[3]*g[0]-g[3]*e[0],e[3]*g[1]-g[3]*e[1],e[3]*g[2]-g[3]*e[2],0,1,Infinity,Infinity,Infinity];j=JXG.Math.normalize(j);return this.meetLineCircle(j,g,f,h)},meetCurveCurve:function(r,q,h,k,m){var l=0,o,n,B,z,v,u,g,t,s,p,A,w,j,i;if(!JXG.exists(m)){m=r.board}if(arguments.callee.t1memo){o=arguments.callee.t1memo;n=arguments.callee.t2memo}else{o=h;n=k}t=r.X(o)-q.X(n);s=r.Y(o)-q.Y(n);p=t*t+s*s;A=r.board.D(r.X,r);w=q.board.D(q.X,q);j=r.board.D(r.Y,r);i=q.board.D(q.Y,q);while(p>JXG.Math.eps&&l<10){B=A(o);z=-w(n);v=j(o);u=-i(n);g=B*u-z*v;o-=(u*t-z*s)/g;n-=(B*s-v*t)/g;t=r.X(o)-q.X(n);s=r.Y(o)-q.Y(n);p=t*t+s*s;l++}arguments.callee.t1memo=o;arguments.callee.t2memo=n;if(Math.abs(o)<Math.abs(n)){return(new JXG.Coords(JXG.COORDS_BY_USER,[r.X(o),r.Y(o)],m))}else{return(new JXG.Coords(JXG.COORDS_BY_USER,[q.X(n),q.Y(n)],m))}},meetCurveLine:function(s,r,f,k){var p,m,u,h,q,j,l,A,v,w,o,n,g,e;if(!JXG.exists(k)){k=s.board}for(u=0;u<=1;u++){if(arguments[u].elementClass==JXG.OBJECT_CLASS_CURVE){h=arguments[u]}else{if(arguments[u].elementClass==JXG.OBJECT_CLASS_LINE){q=arguments[u]}else{throw new Error("JSXGraph: Can't call meetCurveLine with parent class "+(arguments[u].elementClass)+".")}}}j=function(i){return q.stdform[0]+q.stdform[1]*h.X(i)+q.stdform[2]*h.Y(i)};if(arguments.callee.t1memo){o=arguments.callee.t1memo;p=JXG.Math.Numerics.root(j,o)}else{o=h.minX();n=h.maxX();p=JXG.Math.Numerics.root(j,[o,n])}arguments.callee.t1memo=p;g=h.X(p);e=h.Y(p);if(f==1){if(arguments.callee.t2memo){o=arguments.callee.t2memo;m=JXG.Math.Numerics.root(j,o)}if(!(Math.abs(m-p)>0.1&&Math.abs(g-h.X(m))>0.1&&Math.abs(e-h.Y(m))>0.1)){v=20;w=(h.maxX()-h.minX())/v;A=h.minX();for(u=0;u<v;u++){m=JXG.Math.Numerics.root(j,[A,A+w]);if(Math.abs(m-p)>0.1&&Math.abs(g-h.X(m))>0.1&&Math.abs(e-h.Y(m))>0.1){break}A+=w}}p=m;arguments.callee.t2memo=p}if(Math.abs(j(p))>JXG.Math.eps){l=0}else{l=1}return(new JXG.Coords(JXG.COORDS_BY_USER,[l,h.X(p),h.Y(p)],k))},projectPointToCircle:function(m,e,g){var j=m.coords.distance(JXG.COORDS_BY_USER,e.center.coords),f=m.coords.usrCoords,h=e.center.coords.usrCoords,l,k,i;if(!JXG.exists(g)){g=m.board}if(Math.abs(j)<JXG.Math.eps){j=JXG.Math.eps}i=e.Radius()/j;l=h[1]+i*(f[1]-h[1]);k=h[2]+i*(f[2]-h[2]);return new JXG.Coords(JXG.COORDS_BY_USER,[l,k],g)},projectPointToLine:function(e,f,h){var g=[0,f.stdform[1],f.stdform[2]];if(!JXG.exists(h)){h=e.board}g=JXG.Math.crossProduct(g,e.coords.usrCoords);return this.meetLineLine(g,f.stdform,0,h)},projectPointToCurve:function(g,j,i){if(!JXG.exists(i)){i=g.board}var f=g.X(),k=g.Y(),h=g.position||0,e=this.projectCoordsToCurve(f,k,h,j,i);g.position=e[1];return e[0]},projectCoordsToCurve:function(o,m,q,r,k){var C,A,f,z,e,l,v,B,s,h,u,p=1000000,n,F,D,g,E,w;if(!JXG.exists(k)){k=r.board}if(r.visProp.curvetype=="parameter"||r.visProp.curvetype=="polar"){n=function(G){var j=o-r.X(G),i=m-r.Y(G);return j*j+i*i};g=n(q);w=20;E=(r.maxX()-r.minX())/w;F=r.minX();for(u=0;u<w;u++){D=n(F);if(D<g){q=F;g=D}F+=E}q=JXG.Math.Numerics.root(JXG.Math.Numerics.D(n),q);if(q<r.minX()){q=r.maxX()+q-r.minX()}if(q>r.maxX()){q=r.minX()+q-r.maxX()}C=new JXG.Coords(JXG.COORDS_BY_USER,[r.X(q),r.Y(q)],k)}else{if(r.visProp.curvetype=="plot"){B=p;for(v=0;v<r.numberPoints;v++){A=o-r.X(v);f=m-r.Y(v);s=Math.sqrt(A*A+f*f);if(s<B){B=s;q=v}if(v==r.numberPoints-1){continue}z=r.X(v+1)-r.X(v);e=r.Y(v+1)-r.Y(v);l=z*z+e*e;if(l>=JXG.Math.eps){h=(A*z+f*e)/l;s=Math.sqrt(A*A+f*f-h*(A*z+f*e))}else{h=0;s=Math.sqrt(A*A+f*f)}if(h>=0&&h<=1&&s<B){q=v+h;B=s}}v=Math.floor(q);h=q-v;if(v<r.numberPoints-1){o=h*r.X(v+1)+(1-h)*r.X(v);m=h*r.Y(v+1)+(1-h)*r.Y(v)}else{o=r.X(v);m=r.Y(v)}C=new JXG.Coords(JXG.COORDS_BY_USER,[o,m],k)}else{q=o;o=q;m=r.Y(q);C=new JXG.Coords(JXG.COORDS_BY_USER,[o,m],k)}}return[r.updateTransform(C),q]},projectPointToTurtle:function(p,s,l){var r,u,o,n,g,q=0,k=0,h=1000000,m,e,f,j=s.objects.length;if(!JXG.exists(l)){l=p.board}for(g=0;g<j;g++){e=s.objects[g];if(e.elementClass==JXG.OBJECT_CLASS_CURVE){r=this.projectPointToCurve(p,e);m=this.distance(r.usrCoords,p.coords.usrCoords);if(m<h){o=r.usrCoords[1];n=r.usrCoords[2];u=p.position;h=m;f=e;k=q}q+=e.numberPoints}}r=new JXG.Coords(JXG.COORDS_BY_USER,[o,n],l);p.position=u+k;return f.updateTransform(r)},projectPointToPoint:function(e,f,g){return f.coords}});JXG.Math.Poly={};JXG.Math.Poly.Ring=function(e){this.vars=e};JXG.extend(JXG.Math.Poly.Ring.prototype,{});JXG.Math.Poly.Monomial=function(f,e,h){var g;if(!JXG.exists(f)){throw new Error("JSXGraph error: In JXG.Math.Poly.monomial missing parameter 'ring'.")}if(!JXG.isArray(h)){h=[]}h=h.slice(0,f.vars.length);for(g=h.length;g<f.vars.length;g++){h.push(0)}this.ring=f;this.coefficient=e||0;this.exponents=JXG.deepCopy(h)};JXG.extend(JXG.Math.Poly.Monomial.prototype,{copy:function(){return new JXG.Math.Poly.Monomial(this.ring,this.coefficient,this.exponents)},print:function(){var f=[],e;for(e=0;e<this.ring.vars.length;e++){f.push(this.ring.vars[e]+"^"+this.exponents[e])}return this.coefficient+"*"+f.join("*")}});JXG.Math.Poly.Polynomial=function(e,h){var g=function(){},f;if(!JXG.exists(e)){throw new Error("JSXGraph error: In JXG.Math.Poly.polynomial missing parameter 'ring'.")}if(JXG.exists(h)&&typeof h==="string"){f=g(h)}else{f=[]}this.ring=e;this.monomials=f};JXG.extend(JXG.Math.Poly.Polynomial.prototype,{findSignature:function(f){var e;for(e=0;e<this.monomials.length;e++){if(JXG.cmpArrays(this.monomials[e].exponents,f)){return e}}return -1},addSubMonomial:function(e,g){var f;f=this.findSignature(e.exponents);if(f>-1){this.monomials[f].coefficient+=g*e.coefficient}else{e.coefficient*=g;this.monomials.push(e)}},add:function(f){var e;if(JXG.exists(f)&&f.ring===this.ring){if(JXG.isArray(f.exponents)){this.addSubMonomial(f,1)}else{for(e=0;e<f.monomials.length;e++){this.addSubMonomial(f.monomials[e],1)}}}else{throw new Error("JSXGraph error: In JXG.Math.Poly.polynomial.add either summand is undefined or rings don't match.")}},sub:function(f){var e;if(JXG.exists(f)&&f.ring===this.ring){if(JXG.isArray(f.exponents)){this.addSubMonomial(f,-1)}else{for(e=0;e<f.monomials.length;e++){this.addSubMonomial(f.monomials[e],-1)}}}else{throw new Error("JSXGraph error: In JXG.Math.Poly.polynomial.sub either summand is undefined or rings don't match.")}},copy:function(){var e,f;f=new JXG.Math.Poly.Polynomial(this.ring);for(e=0;e<this.monomials.length;e++){f.monomials.push(this.monomials[e].copy())}return f},print:function(){var f=[],e;for(e=0;e<this.monomials.length;e++){f.push("("+this.monomials[e].print()+")")}return f.join("+")}});JXG.Complex=function(e,f){this.isComplex=true;if(typeof e=="undefined"){e=0}if(typeof f=="undefined"){f=0}if(e.isComplex){f=e.imaginary;e=e.real}this.real=e;this.imaginary=f;this.absval=0;this.angle=0};JXG.extend(JXG.Complex.prototype,{toString:function(){return""+this.real+" + "+this.imaginary+"i"},add:function(e){if(typeof e=="number"){this.real+=e}else{this.real+=e.real;this.imaginary+=e.imaginary}},sub:function(e){if(typeof e=="number"){this.real-=e}else{this.real-=e.real;this.imaginary-=e.imaginary}},mult:function(g){var f,e;if(typeof g=="number"){this.real*=g;this.imaginary*=g}else{f=this.real;e=this.imaginary;this.real=f*g.real-e*g.imaginary;this.imaginary=f*g.imaginary+e*g.real}},div:function(h){var f,e,g;if(typeof h=="number"){if(Math.abs(h)<Math.eps){this.real=Infinity;this.imaginary=Infinity;return}this.real/=h;this.imaginary/=h}else{if((Math.abs(h.real)<Math.eps)&&(Math.abs(h.imaginary)<Math.eps)){this.real=Infinity;this.imaginary=Infinity;return}f=h.real*h.real+h.imaginary*h.imaginary;g=this.real;e=this.imaginary;this.real=(g*h.real+e*h.imaginary)/f;this.imaginary=(e*h.real-g*h.imaginary)/f}},conj:function(){this.imaginary*=-1}});JXG.C={};JXG.C.add=function(f,e){var g=new JXG.Complex(f);g.add(e);return g};JXG.C.sub=function(f,e){var g=new JXG.Complex(f);g.sub(e);return g};JXG.C.mult=function(f,e){var g=new JXG.Complex(f);g.mult(e);return g};JXG.C.div=function(f,e){var g=new JXG.Complex(f);g.div(e);return g};JXG.C.conj=function(e){var f=new JXG.Complex(e);f.conj();return f};JXG.C.abs=function(e){var f=new JXG.Complex(e);f.conj();f.mult(e);return Math.sqrt(f.real)};JXG.AbstractRenderer=function(){this.vOffsetText=3;this.enhancedRendering=true;this.container=null;this.type=""};JXG.extend(JXG.AbstractRenderer.prototype,{_updateVisual:function(f,h,g){var e;if(g||this.enhancedRendering){h=h||{};if(!f.visProp.draft){if(!h.stroke){this.setObjectStrokeWidth(f,f.visProp.strokewidth);this.setObjectStrokeColor(f,f.visProp.strokecolor,f.visProp.strokeopacity)}if(!h.fill){this.setObjectFillColor(f,f.visProp.fillcolor,f.visProp.fillopacity)}if(!h.dash){this.setDashStyle(f,f.visProp)}if(!h.shadow){this.setShadow(f)}if(!h.gradient){this.setShadow(f)}}else{this.setDraft(f)}}},drawPoint:function(f){var e,g=JXG.Point.prototype.normalizeFace.call(this,f.visProp.face);if(g==="o"){e="ellipse"}else{if(g==="[]"){e="rect"}else{e="path"}}this.appendChildPrim(this.createPrim(e,f.id),f.visProp.layer);this.appendNodesToElement(f,e);this._updateVisual(f,{dash:true,shadow:true},true);this.updatePoint(f)},updatePoint:function(f){var e=f.visProp.size,g=JXG.Point.prototype.normalizeFace.call(this,f.visProp.face);if(!isNaN(f.coords.scrCoords[2]+f.coords.scrCoords[1])){this._updateVisual(f,{dash:false,shadow:false});e*=((!f.board||!f.board.options.point.zoom)?1:Math.sqrt(f.board.zoomX*f.board.zoomY));if(g==="o"){this.updateEllipsePrim(f.rendNode,f.coords.scrCoords[1],f.coords.scrCoords[2],e+1,e+1)}else{if(g==="[]"){this.updateRectPrim(f.rendNode,f.coords.scrCoords[1]-e,f.coords.scrCoords[2]-e,e*2,e*2)}else{this.updatePathPrim(f.rendNode,this.updatePathStringPoint(f,e,g),f.board)}}this.setShadow(f)}},changePointStyle:function(e){var f=this.getElementById(e.id);if(JXG.exists(f)){this.remove(f)}this.drawPoint(e);JXG.clearVisPropOld(e);if(!e.visProp.visible){this.hide(e)}if(e.visProp.draft){this.setDraft(e)}},drawLine:function(e){this.appendChildPrim(this.createPrim("line",e.id),e.visProp.layer);this.appendNodesToElement(e,"lines");this.updateLine(e)},updateLine:function(g){var f=new JXG.Coords(JXG.COORDS_BY_USER,g.point1.coords.usrCoords,g.board),e=new JXG.Coords(JXG.COORDS_BY_USER,g.point2.coords.usrCoords,g.board);JXG.Math.Geometry.calcStraight(g,f,e);this.updateLinePrim(g.rendNode,f.scrCoords[1],f.scrCoords[2],e.scrCoords[1],e.scrCoords[2],g.board);this.makeArrows(g);this._updateVisual(g,{fill:true})},drawTicks:function(e){var f=this.createPrim("path",e.id);this.appendChildPrim(f,e.visProp.layer);this.appendNodesToElement(e,"path")},updateTicks:function(e,h,f,i,g){},drawCurve:function(e){this.appendChildPrim(this.createPrim("path",e.id),e.visProp.layer);this.appendNodesToElement(e,"path");this._updateVisual(e,{shadow:true},true);this.updateCurve(e)},updateCurve:function(e){this._updateVisual(e);if(e.visProp.handdrawing){this.updatePathPrim(e.rendNode,this.updatePathStringBezierPrim(e),e.board)}else{this.updatePathPrim(e.rendNode,this.updatePathStringPrim(e),e.board)}this.makeArrows(e)},drawEllipse:function(e){this.appendChildPrim(this.createPrim("ellipse",e.id),e.visProp.layer);this.appendNodesToElement(e,"ellipse");this.updateEllipse(e)},updateEllipse:function(f){this._updateVisual(f);var e=f.Radius();if(e>0&&!isNaN(e+f.center.coords.scrCoords[1]+f.center.coords.scrCoords[2])&&e*f.board.unitX<20000){this.updateEllipsePrim(f.rendNode,f.center.coords.scrCoords[1],f.center.coords.scrCoords[2],(e*f.board.unitX),(e*f.board.unitY))}},drawPolygon:function(e){this.appendChildPrim(this.createPrim("polygon",e.id),e.visProp.layer);this.appendNodesToElement(e,"polygon");this.updatePolygon(e)},updatePolygon:function(e){this._updateVisual(e,{stroke:true,dash:true});this.updatePolygonPrim(e.rendNode,e)},displayCopyright:function(e,f){},drawInternalText:function(e){},updateInternalText:function(e){},drawText:function(e){var f,g;if(e.visProp.display==="html"){f=this.container.ownerDocument.createElement("div");f.style.position="absolute";f.className=e.visProp.cssclass;if(this.container.style.zIndex==""){g=0}else{g=parseInt(this.container.style.zIndex)}f.style.zIndex=g+e.board.options.layer.text;this.container.appendChild(f);f.setAttribute("id",this.container.id+"_"+e.id)}else{f=this.drawInternalText(e)}e.rendNode=f;e.htmlStr="";this.updateText(e)},updateText:function(e){var f=e.plaintext;if(e.visProp.visible){this.updateTextStyle(e);if(e.visProp.display==="html"){if(!isNaN(e.coords.scrCoords[1]+e.coords.scrCoords[2])){e.rendNode.style.left=parseInt(e.coords.scrCoords[1])+"px";e.rendNode.style.top=parseInt(e.coords.scrCoords[2]-parseInt(e.visProp.fontsize)+this.vOffsetText)+"px"}if(e.htmlStr!==f){e.rendNode.innerHTML=f;e.htmlStr=f;if(e.visProp.usemathjax){MathJax.Hub.Typeset(e.rendNode)}else{if(e.visProp.useasciimathml){AMprocessNode(e.rendNode,false)}}}this.transformImage(e,e.transformations)}else{this.updateInternalText(e)}}},updateTextStyle:function(g){var f=JXG.evaluate(g.visProp.fontsize);if(g.visProp.display==="html"||this.type!="canvas"){g.rendNode.className=g.visProp.cssclass;try{g.rendNode.style.fontSize=f+"px"}catch(h){g.rendNode.style.fontSize=f}}this.setObjectStrokeColor(g,g.visProp.strokecolor,g.visProp.strokeopacity)},drawImage:function(e){},updateImage:function(e){this.updateRectPrim(e.rendNode,e.coords.scrCoords[1],e.coords.scrCoords[2]-e.size[1],e.size[0],e.size[1]);this.updateImageURL(e);this.transformImage(e,e.transformations);this._updateVisual(e,{stroke:true,dash:true},true)},joinTransforms:function(o,p){var l=[[1,0,0],[0,1,0],[0,0,1]],h=o.board.origin.scrCoords[1],g=o.board.origin.scrCoords[2],f=o.board.unitX,e=o.board.unitY,s=[[1,0,0],[-h,1,0],[-g,0,1]],r=[[1,0,0],[0,1/f,0],[0,0,-1/e]],j=[[1,0,0],[0,f,0],[0,0,-e]],k=[[1,0,0],[h,1,0],[g,0,1]],n,q=p.length;for(n=0;n<q;n++){l=JXG.Math.matMatMult(s,l);l=JXG.Math.matMatMult(r,l);l=JXG.Math.matMatMult(p[n].matrix,l);l=JXG.Math.matMatMult(j,l);l=JXG.Math.matMatMult(k,l)}return l},transformImage:function(f,e){},updateImageURL:function(e){},appendChildPrim:function(e,f){},appendNodesToElement:function(e,f){},createPrim:function(e,f){return null},remove:function(e){},makeArrows:function(e){},updateEllipsePrim:function(f,e,i,h,g){},updateLinePrim:function(j,f,e,h,g,i){},updatePathPrim:function(g,e,f){},updatePathStringPoint:function(f,e,g){},updatePathStringPrim:function(e){},updatePathStringBezierPrim:function(e){},updatePolygonPrim:function(f,e){},updateRectPrim:function(i,e,j,f,g){},setPropertyPrim:function(f,e,g){},show:function(e){},hide:function(e){},setBuffering:function(f,e){},setDashStyle:function(e){},setDraft:function(e){if(!e.visProp.draft){return}var f=e.board.options.elements.draft.color,g=e.board.options.elements.draft.opacity;if(e.type===JXG.OBJECT_TYPE_POLYGON){this.setObjectFillColor(e,f,g)}else{if(e.elementClass===JXG.OBJECT_CLASS_POINT){this.setObjectFillColor(e,f,g)}else{this.setObjectFillColor(e,"none",0)}this.setObjectStrokeColor(e,f,g);this.setObjectStrokeWidth(e,e.board.options.elements.draft.strokeWidth)}},removeDraft:function(e){if(e.type===JXG.OBJECT_TYPE_POLYGON){this.setObjectFillColor(e,e.visProp.fillcolor,e.visProp.fillopacity)}else{if(e.type===JXG.OBJECT_CLASS_POINT){this.setObjectFillColor(e,e.visProp.fillcolor,e.visProp.fillopacity)}this.setObjectStrokeColor(e,e.visProp.strokecolor,e.visProp.strokeopacity);this.setObjectStrokeWidth(e,e.visProp.strokewidth)}},setGradient:function(e){},updateGradient:function(e){},setObjectFillColor:function(g,e,f){},setObjectStrokeColor:function(g,e,f){},setObjectStrokeWidth:function(e,f){},setShadow:function(e){},highlight:function(f){var e,g=f.visProp;if(!g.draft){if(f.type===JXG.OBJECT_TYPE_POLYGON){this.setObjectFillColor(f,g.highlightfillcolor,g.highlightfillopacity);for(e=0;e<f.borders.length;e++){this.setObjectStrokeColor(f.borders[e],f.borders[e].visProp.highlightstrokecolor,f.borders[e].visProp.highlightstrokeopacity)}}else{this.setObjectStrokeColor(f,g.highlightstrokecolor,g.highlightstrokeopacity);this.setObjectFillColor(f,g.highlightfillcolor,g.highlightfillopacity)}if(f.type===JXG.OBJECT_TYPE_TEXT){if(f.visProp.display==="html"){f.rendNode.className=f.visProp.highlightcssclass}}if(g.highlightstrokewidth){this.setObjectStrokeWidth(f,Math.max(g.highlightstrokewidth,g.strokewidth))}}return this},noHighlight:function(f){var e,g=f.visProp;if(!f.visProp.draft){if(f.type===JXG.OBJECT_TYPE_POLYGON){this.setObjectFillColor(f,g.fillcolor,g.fillopacity);for(e=0;e<f.borders.length;e++){this.setObjectStrokeColor(f.borders[e],f.borders[e].visProp.strokecolor,f.borders[e].visProp.strokeopacity)}}else{this.setObjectStrokeColor(f,g.strokecolor,g.strokeopacity);this.setObjectFillColor(f,g.fillcolor,g.fillopacity)}if(f.type===JXG.OBJECT_TYPE_TEXT){if(f.visProp.display==="html"){f.rendNode.className=f.visProp.cssclass}}this.setObjectStrokeWidth(f,g.strokewidth)}return this},suspendRedraw:function(){},unsuspendRedraw:function(){},drawZoomBar:function(f){var h,g,e=function(i,k){var j;j=h.createElement("span");g.appendChild(j);j.appendChild(document.createTextNode(i));JXG.addEvent(j,"click",k,f)};h=f.containerObj.ownerDocument;g=h.createElement("div");g.setAttribute("id",f.containerObj.id+"_navigationbar");g.style.color=f.options.navbar.strokeColor;g.style.backgroundColor=f.options.navbar.fillColor;g.style.padding=f.options.navbar.padding;g.style.position=f.options.navbar.position;g.style.fontSize=f.options.navbar.fontSize;g.style.cursor=f.options.navbar.cursor;g.style.zIndex=f.options.navbar.zIndex;f.containerObj.appendChild(g);g.style.right=f.options.navbar.right;g.style.bottom=f.options.navbar.bottom;e("\u00A0\u2013\u00A0",f.zoomOut);e("\u00A0o\u00A0",f.zoom100);e("\u00A0+\u00A0",f.zoomIn);e("\u00A0\u2190\u00A0",f.clickLeftArrow);e("\u00A0\u2193\u00A0",f.clickUpArrow);e("\u00A0\u2191\u00A0",f.clickDownArrow);e("\u00A0\u2192\u00A0",f.clickRightArrow)},getElementById:function(e){return document.getElementById(this.container.id+"_"+e)},resize:function(e,f){}});JXG.FileReader={parseFileContent:function(f,h,k,g){var i=false;if(!JXG.exists(g)){g=true}try{i=new XMLHttpRequest();if(k.toLowerCase()=="raw"){i.overrideMimeType("text/plain; charset=iso-8859-1")}else{i.overrideMimeType("text/xml; charset=iso-8859-1")}}catch(j){try{i=new ActiveXObject("Msxml2.XMLHTTP")}catch(j){try{i=new ActiveXObject("Microsoft.XMLHTTP")}catch(j){i=false}}}if(!i){alert("AJAX not activated!");return}i.open("GET",f,g);if(k.toLowerCase()==="raw"){this.cbp=function(){var e=i;if(e.readyState==4){h(e.responseText)}}}else{this.cbp=function(){var e=i;if(e.readyState==4){var l="";if(typeof e.responseStream!="undefined"&&(e.responseText.slice(0,2)=="PK"||JXG.Util.asciiCharCodeAt(e.responseText.slice(0,1),0)==31)){l=JXG.Util.Base64.decode(BinFileReader(e))}else{l=e.responseText}this.parseString(l,h,k,false)}}}this.cb=JXG.bind(this.cbp,this);i.onreadystatechange=this.cb;try{i.send(null)}catch(j){throw new Error("JSXGraph: A problem occurred while trying to read '"+f+"'.")}},cleanWhitespace:function(e){var f=e.firstChild;while(f!=null){if(f.nodeType==3&&!/\S/.test(f.nodeValue)){e.removeChild(f)}else{if(f.nodeType==1){this.cleanWhitespace(f)}}f=f.nextSibling}},stringToXMLTree:function(f){if(typeof DOMParser==="undefined"){DOMParser=function(){};DOMParser.prototype.parseFromString=function(i,j){if(typeof ActiveXObject!=="undefined"){var h=new ActiveXObject("MSXML.DomDocument");h.loadXML(i);return h}}}var g=new DOMParser(),e=g.parseFromString(f,"text/xml");this.cleanWhitespace(e);return e},parseString:function(k,h,j,f){var e,i,g;j=j.toLowerCase();switch(j){case"cdy":case"cinderella":if(f){k=JXG.Util.Base64.decode(k)}k=JXG.CinderellaReader.readCinderella(k,h);h.xmlString=k;break;case"tracenpoche":h.xmlString=JXG.TracenpocheReader.readTracenpoche(k,h);break;case"graph":k=JXG.GraphReader.readGraph(k,h,false);break;case"digraph":k=JXG.GraphReader.readGraph(k,updateboard,true);break;case"geonext":k=JXG.GeonextReader.prepareString(k);g=true;break;case"geogebra":f=k.slice(0,2)!=="PK";k=JXG.GeogebraReader.prepareString(k,f);g=true;break;case"intergeo":if(f){k=JXG.Util.Base64.decode(k)}k=JXG.IntergeoReader.prepareString(k);g=true;break}if(g){h.xmlString=k;e=this.stringToXMLTree(k);this.readElements(e,h,j)}},readElements:function(e,f,g){if(g.toLowerCase()=="geonext"){f.suspendUpdate();if(e.getElementsByTagName("GEONEXT").length!=0){JXG.GeonextReader.readGeonext(e,f)}f.unsuspendUpdate()}else{if(e.getElementsByTagName("geogebra").length!=0){JXG.GeogebraReader.readGeogebra(e,f)}else{if(g.toLowerCase()=="intergeo"){JXG.IntergeoReader.readIntergeo(e,f)}}}}};if(/msie/i.test(navigator.userAgent)&&!/opera/i.test(navigator.userAgent&&document&&document.write)){document.write('<script type="text/vbscript">\nFunction Base64Encode(inData)\n  Const Base64 = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/"\n  Dim cOut, sOut, I\n  For I = 1 To LenB(inData) Step 3\n    Dim nGroup, pOut, sGroup\n    nGroup = &H10000 * AscB(MidB(inData, I, 1)) + _\n      &H100 * MyASC(MidB(inData, I + 1, 1)) + MyASC(MidB(inData, I + 2, 1))\n    nGroup = Oct(nGroup)\n    nGroup = String(8 - Len(nGroup), "0") & nGroup\n    pOut = Mid(Base64, CLng("&o" & Mid(nGroup, 1, 2)) + 1, 1) + _\n      Mid(Base64, CLng("&o" & Mid(nGroup, 3, 2)) + 1, 1) + _\n      Mid(Base64, CLng("&o" & Mid(nGroup, 5, 2)) + 1, 1) + _\n      Mid(Base64, CLng("&o" & Mid(nGroup, 7, 2)) + 1, 1)\n    sOut = sOut + pOut\n  Next\n  Select Case LenB(inData) Mod 3\n    Case 1: \'8 bit final\n      sOut = Left(sOut, Len(sOut) - 2) + "=="\n    Case 2: \'16 bit final\n      sOut = Left(sOut, Len(sOut) - 1) + "="\n  End Select\n  Base64Encode = sOut\nEnd Function\n\nFunction MyASC(OneChar)\n  If OneChar = "" Then MyASC = 0 Else MyASC = AscB(OneChar)\nEnd Function\n\nFunction BinFileReader(xhr)\n    Dim byteString\n    Dim b64String\n    Dim i\n    byteString = xhr.responseBody\n    ReDim byteArray(LenB(byteString))\n    For i = 1 To LenB(byteString)\n        byteArray(i-1) = AscB(MidB(byteString, i, 1))\n    Next\n    b64String = Base64Encode(byteString)\n    BinFileReader = b64String\nEnd Function\n<\/script>\n')}JXG.GeonextParser={};JXG.GeonextParser.replacePow=function(g){var l,o,m,k,n,h,e,f,j,r,q;g=g.replace(/(\s*)\^(\s*)/g,"^");j=g.indexOf("^");while(j>=0){f=g.slice(0,j);r=g.slice(j+1);if(f.charAt(f.length-1)==")"){l=1;o=f.length-2;while(o>=0&&l>0){m=f.charAt(o);if(m==")"){l++}else{if(m=="("){l--}}o--}if(l==0){k="";h=f.substring(0,o+1);e=o;while(e>=0&&h.substr(e,1).match(/([\w\.]+)/)){k=RegExp.$1+k;e--}k+=f.substring(o+1,f.length);k=k.replace(/([\(\)\+\*\%\^\-\/\]\[])/g,"\\$1")}else{throw new Error("JSXGraph: Missing '(' in expression")}}else{k="[\\w\\.]+"}if(r.match(/^([\w\.]*\()/)){l=1;o=RegExp.$1.length;while(o<r.length&&l>0){m=r.charAt(o);if(m==")"){l--}else{if(m=="("){l++}}o++}if(l==0){n=r.substring(0,o);n=n.replace(/([\(\)\+\*\%\^\-\/\[\]])/g,"\\$1")}else{throw new Error("JSXGraph: Missing ')' in expression")}}else{n="[\\w\\.]+"}q=new RegExp("("+k+")\\^("+n+")");g=g.replace(q,"JXG.Math.pow($1,$2)");j=g.indexOf("^")}return g};JXG.GeonextParser.replaceIf=function(f){var t="",g,r,j=null,e=null,m=null,h,q,k,n,l,o,p;h=f.indexOf("If(");if(h<0){return f}f=f.replace(/""/g,"0");while(h>=0){g=f.slice(0,h);r=f.slice(h+3);k=1;q=0;n=-1;l=-1;while(q<r.length&&k>0){o=r.charAt(q);if(o==")"){k--}else{if(o=="("){k++}else{if(o==","&&k==1){if(n<0){n=q}else{l=q}}}}q++}p=r.slice(0,q-1);r=r.slice(q);if(n<0){return""}if(l<0){return""}j=p.slice(0,n);e=p.slice(n+1,l);m=p.slice(l+1);j=this.replaceIf(j);e=this.replaceIf(e);m=this.replaceIf(m);t+=g+"(("+j+")?("+e+"):("+m+"))";f=r;j=null;e=null;h=f.indexOf("If(")}t+=r;return t};JXG.GeonextParser.replaceSub=function(g){if(g.indexOf){}else{return g}var f=g.indexOf("_{"),e;while(f>=0){g=g.substr(0,f)+g.substr(f).replace(/_\{/,"<sub>");e=g.substr(f).indexOf("}");if(e>=0){g=g.substr(0,e)+g.substr(e).replace(/\}/,"</sub>")}f=g.indexOf("_{")}f=g.indexOf("_");while(f>=0){g=g.substr(0,f)+g.substr(f).replace(/_(.?)/,"<sub>$1</sub>");f=g.indexOf("_")}return g};JXG.GeonextParser.replaceSup=function(g){if(g.indexOf){}else{return g}var f=g.indexOf("^{"),e;while(f>=0){g=g.substr(0,f)+g.substr(f).replace(/\^\{/,"<sup>");e=g.substr(f).indexOf("}");if(e>=0){g=g.substr(0,e)+g.substr(e).replace(/\}/,"</sup>")}f=g.indexOf("^{")}f=g.indexOf("^");while(f>=0){g=g.substr(0,f)+g.substr(f).replace(/\^(.?)/,"<sup>$1</sup>");f=g.indexOf("^")}return g};JXG.GeonextParser.replaceNameById=function(h,k){var m=0,e,l,j,g,f=["X","Y","L","V"];for(g=0;g<f.length;g++){m=h.indexOf(f[g]+"(");while(m>=0){if(m>=0){e=h.indexOf(")",m+2);if(e>=0){l=h.slice(m+2,e);l=l.replace(/\\(['"])?/g,"$1");j=k.elementsByName[l];h=h.slice(0,m+2)+j.id+h.slice(e)}}e=h.indexOf(")",m+2);m=h.indexOf(f[g]+"(",e)}}m=h.indexOf("Dist(");while(m>=0){if(m>=0){e=h.indexOf(",",m+5);if(e>=0){l=h.slice(m+5,e);l=l.replace(/\\(['"])?/g,"$1");j=k.elementsByName[l];h=h.slice(0,m+5)+j.id+h.slice(e)}}e=h.indexOf(",",m+5);m=h.indexOf(",",e);e=h.indexOf(")",m+1);if(e>=0){l=h.slice(m+1,e);l=l.replace(/\\(['"])?/g,"$1");j=k.elementsByName[l];h=h.slice(0,m+1)+j.id+h.slice(e)}e=h.indexOf(")",m+1);m=h.indexOf("Dist(",e)}f=["Deg","Rad"];for(g=0;g<f.length;g++){m=h.indexOf(f[g]+"(");while(m>=0){if(m>=0){e=h.indexOf(",",m+4);if(e>=0){l=h.slice(m+4,e);l=l.replace(/\\(['"])?/g,"$1");j=k.elementsByName[l];h=h.slice(0,m+4)+j.id+h.slice(e)}}e=h.indexOf(",",m+4);m=h.indexOf(",",e);e=h.indexOf(",",m+1);if(e>=0){l=h.slice(m+1,e);l=l.replace(/\\(['"])?/g,"$1");j=k.elementsByName[l];h=h.slice(0,m+1)+j.id+h.slice(e)}e=h.indexOf(",",m+1);m=h.indexOf(",",e);e=h.indexOf(")",m+1);if(e>=0){l=h.slice(m+1,e);l=l.replace(/\\(['"])?/g,"$1");j=k.elementsByName[l];h=h.slice(0,m+1)+j.id+h.slice(e)}e=h.indexOf(")",m+1);m=h.indexOf(f[g]+"(",e)}}return h};JXG.GeonextParser.replaceIdByObj=function(e){var f=/(X|Y|L)\(([\w_]+)\)/g;e=e.replace(f,'this.board.objects["$2"].$1()');f=/(V)\(([\w_]+)\)/g;e=e.replace(f,'this.board.objects["$2"].Value()');f=/(Dist)\(([\w_]+),([\w_]+)\)/g;e=e.replace(f,'this.board.objects["$2"].Dist(this.board.objects["$3"])');f=/(Deg)\(([\w_]+),([ \w\[\w_]+),([\w_]+)\)/g;e=e.replace(f,'JXG.Math.Geometry.trueAngle(this.board.objects["$2"],this.board.objects["$3"],this.board.objects["$4"])');f=/Rad\(([\w_]+),([\w_]+),([\w_]+)\)/g;e=e.replace(f,'JXG.Math.Geometry.rad(this.board.objects["$1"],this.board.objects["$2"],this.board.objects["$3"])');return e};JXG.GeonextParser.geonext2JS=function(f,h){var j,g,e,l=["Abs","ACos","ASin","ATan","Ceil","Cos","Exp","Factorial","Floor","Log","Max","Min","Random","Round","Sin","Sqrt","Tan","Trunc"],k=["Math.abs","Math.acos","Math.asin","Math.atan","Math.ceil","Math.cos","Math.exp","JXG.Math.factorial","Math.floor","Math.log","Math.max","Math.min","Math.random","this.board.round","Math.sin","Math.sqrt","Math.tan","Math.ceil"];f=f.replace(/&lt;/g,"<");f=f.replace(/&gt;/g,">");f=f.replace(/&amp;/g,"&");g=f;g=this.replaceNameById(g,h);g=this.replaceIf(g);g=this.replacePow(g);g=this.replaceIdByObj(g);for(e=0;e<l.length;e++){j=new RegExp(["(\\W|^)(",l[e],")"].join(""),"ig");g=g.replace(j,["$1",k[e]].join(""))}g=g.replace(/True/g,"true");g=g.replace(/False/g,"false");g=g.replace(/fasle/g,"false");g=g.replace(/Pi/g,"Math.PI");return g};JXG.GeonextParser.findDependencies=function(i,f,h){if(typeof h=="undefined"){h=i.board}var j=h.elementsByName,g,k,e;for(g in j){if(g!=i.name){if(j[g].type==JXG.OBJECT_TYPE_TEXT){if(!j[g].visProp.islabel){e=g.replace(/\[/g,"\\[");e=e.replace(/\]/g,"\\]");k=new RegExp("\\(([\\w\\[\\]'_ ]+,)*("+e+")(,[\\w\\[\\]'_ ]+)*\\)","g");if(f.search(k)>=0){j[g].addChild(i)}}}else{e=g.replace(/\[/g,"\\[");e=e.replace(/\]/g,"\\]");k=new RegExp("\\(([\\w\\[\\]'_ ]+,)*("+e+")(,[\\w\\[\\]'_ ]+)*\\)","g");if(f.search(k)>=0){j[g].addChild(i)}}}}};JXG.GeonextParser.gxt2jc=function(e,g){var f,i=["Sqrt"],h=["sqrt"];e=e.replace(/&lt;/g,"<");e=e.replace(/&gt;/g,">");e=e.replace(/&amp;/g,"&");f=e;f=this.replaceNameById2(f,g);f=f.replace(/True/g,"true");f=f.replace(/False/g,"false");f=f.replace(/fasle/g,"false");return f};JXG.GeonextParser.replaceNameById2=function(h,k){var m=0,e,l,j,g,f=["X","Y","L","V"];for(g=0;g<f.length;g++){m=h.indexOf(f[g]+"(");while(m>=0){if(m>=0){e=h.indexOf(")",m+2);if(e>=0){l=h.slice(m+2,e);l=l.replace(/\\(['"])?/g,"$1");j=k.elementsByName[l];h=h.slice(0,m+2)+"$('"+j.id+"')"+h.slice(e)}}e=h.indexOf(")",m+2);m=h.indexOf(f[g]+"(",e)}}m=h.indexOf("Dist(");while(m>=0){if(m>=0){e=h.indexOf(",",m+5);if(e>=0){l=h.slice(m+5,e);l=l.replace(/\\(['"])?/g,"$1");j=k.elementsByName[l];h=h.slice(0,m+5)+"$('"+j.id+"')"+h.slice(e)}}e=h.indexOf(",",m+5);m=h.indexOf(",",e);e=h.indexOf(")",m+1);if(e>=0){l=h.slice(m+1,e);l=l.replace(/\\(['"])?/g,"$1");j=k.elementsByName[l];h=h.slice(0,m+1)+"$('"+j.id+"')"+h.slice(e)}e=h.indexOf(")",m+1);m=h.indexOf("Dist(",e)}f=["Deg","Rad"];for(g=0;g<f.length;g++){m=h.indexOf(f[g]+"(");while(m>=0){if(m>=0){e=h.indexOf(",",m+4);if(e>=0){l=h.slice(m+4,e);l=l.replace(/\\(['"])?/g,"$1");j=k.elementsByName[l];h=h.slice(0,m+4)+"$('"+j.id+"')"+h.slice(e)}}e=h.indexOf(",",m+4);m=h.indexOf(",",e);e=h.indexOf(",",m+1);if(e>=0){l=h.slice(m+1,e);l=l.replace(/\\(['"])?/g,"$1");j=k.elementsByName[l];h=h.slice(0,m+1)+"$('"+j.id+"')"+h.slice(e)}e=h.indexOf(",",m+1);m=h.indexOf(",",e);e=h.indexOf(")",m+1);if(e>=0){l=h.slice(m+1,e);l=l.replace(/\\(['"])?/g,"$1");j=k.elementsByName[l];h=h.slice(0,m+1)+"$('"+j.id+"')"+h.slice(e)}e=h.indexOf(")",m+1);m=h.indexOf(f[g]+"(",e)}}return h};JXG.Board=function(e,j,f,o,n,m,l,k,g,h,i){this.BOARD_MODE_NONE=0;this.BOARD_MODE_DRAG=1;this.BOARD_MODE_MOVE_ORIGIN=2;this.BOARD_QUALITY_LOW=1;this.BOARD_QUALITY_HIGH=2;this.BOARD_MODE_ZOOM=17;this.BOARD_MODE_CONSTRUCT=16;this.CONSTRUCTION_TYPE_POINT=1129599060;this.CONSTRUCTION_TYPE_CIRCLE=1129595724;this.CONSTRUCTION_TYPE_LINE=1129598030;this.CONSTRUCTION_TYPE_GLIDER=1129596740;this.CONSTRUCTION_TYPE_MIDPOINT=1129598288;this.CONSTRUCTION_TYPE_PERPENDICULAR=1129599044;this.CONSTRUCTION_TYPE_PARALLEL=1129599052;this.CONSTRUCTION_TYPE_INTERSECTION=1129597267;this.container=e;this.containerObj=document.getElementById(this.container);if(this.containerObj==null){throw new Error("\nJSXGraph: HTML container element '"+(e)+"' not found.")}this.renderer=j;this.grids=[];this.options=JXG.deepCopy(JXG.Options);this.dimension=2;this.jc=new JXG.JessieCode();this.jc.board=this;this.origin={};this.origin.usrCoords=[1,0,0];this.origin.scrCoords=[1,o[0],o[1]];this.zoomX=n;this.zoomY=m;this.unitX=l*this.zoomX;this.unitY=k*this.zoomY;this.canvasWidth=g;this.canvasHeight=h;if(JXG.exists(f)&&f!==""&&!JXG.exists(document.getElementById(f))){this.id=f}else{this.id=this.generateId()}this.hooks=[];this.dependentBoards=[];this.inUpdate=false;this.objects={};this.groups={};this.animationObjects={};this.highlightedObjects={};this.numObjects=0;this.elementsByName={};this.mode=this.BOARD_MODE_NONE;this.updateQuality=this.BOARD_QUALITY_HIGH;this.isSuspendedRedraw=false;this.calculateSnapSizes();this.drag_dx=0;this.drag_dy=0;this.mouse=null;this.touches=[];this.xmlString="";this.cPos=[];this.touchMoveLast=0;this.downObjects=[];this.showCopyright=false;if((i!=null&&i)||(i==null&&this.options.showCopyright)){this.showCopyright=true;this.renderer.displayCopyright(JXG.JSXGraph.licenseText,this.options.text.fontSize)}this.needsFullUpdate=false;this.reducedUpdate=false;this.currentCBDef="none";this.geonextCompatibilityMode=false;if(this.options.text.useASCIIMathML&&translateASCIIMath){init()}else{this.options.text.useASCIIMathML=false}this.hasMouseHandlers=false;this.hasTouchHandlers=false;this.addEventHandlers()};JXG.extend(JXG.Board.prototype,{generateName:function(g){if(g.type==JXG.OBJECT_TYPE_TICKS){return""}var m,k=3,f="",n="",o=[],e="",l,h;if(g.elementClass==JXG.OBJECT_CLASS_POINT){m=["","A","B","C","D","E","F","G","H","I","J","K","L","M","N","O","P","Q","R","S","T","U","V","W","X","Y","Z"]}else{m=["","a","b","c","d","e","f","g","h","i","j","k","l","m","n","o","p","q","r","s","t","u","v","w","x","y","z"]}switch(g.type){case JXG.OBJECT_TYPE_POLYGON:f="P_{";n="}";break;case JXG.OBJECT_TYPE_CIRCLE:f="k_{";n="}";break;case JXG.OBJECT_TYPE_ANGLE:f="W_{";n="}";break;default:if(g.elementClass!=JXG.OBJECT_CLASS_POINT&&g.elementClass!=JXG.OBJECT_CLASS_LINE){f="s_{";n="}"}}for(l=0;l<k;l++){o[l]=0}while(o[k-1]<m.length){for(o[0]=1;o[0]<m.length;o[0]++){e=f;for(l=k;l>0;l--){e+=m[o[l-1]]}if(this.elementsByName[e+n]==null){return e+n}}o[0]=m.length;for(l=1;l<k;l++){if(o[l-1]==m.length){o[l-1]=1;o[l]++}}}return""},generateId:function(){var e=1;while(JXG.JSXGraph.boards["jxgBoard"+e]!=null){e=Math.round(Math.random()*65535)}return("jxgBoard"+e)},setId:function(h,g){var f=this.numObjects++,e=h.id;if(e==""||!JXG.exists(e)){e=this.id+g+f}h.id=e;this.objects[e]=h;return e},finalizeAdding:function(e){if(!e.visProp.visible){this.renderer.hide(e)}},finalizeLabel:function(e){if(e.hasLabel&&!e.label.content.visProp.islabel&&!e.label.content.visProp.visible){this.renderer.hide(e.label.content)}},getCoordsTopLeftCorner:function(){var h=this.containerObj,f=JXG.getOffset(h),g=document.documentElement.ownerDocument,e=function(i){var j=parseInt(JXG.getStyle(h,i));return isNaN(j)?0:j};if(this.mode===JXG.BOARD_MODE_DRAG||this.mode===JXG.BOARD_MODE_MOVE_ORIGIN){return this.cPos}if(!h.currentStyle&&g.defaultView){h=document.documentElement;f[0]+=e("margin-left");f[1]+=e("margin-top");f[0]+=e("border-left-width");f[1]+=e("border-top-width");f[0]+=e("padding-left");f[1]+=e("padding-top");h=this.containerObj}f[0]+=e("border-left-width");f[1]+=e("border-top-width");if(this.renderer.type!=="vml"){f[0]+=e("padding-left");f[1]+=e("padding-top")}this.cPos=f;return f},getMousePosition:function(j,g){var h=this.getCoordsTopLeftCorner(),f;f=JXG.getPosition(j,g);return[f[0]-h[0],f[1]-h[1]]},initMoveOrigin:function(e,f){this.drag_dx=e-this.origin.scrCoords[1];this.drag_dy=f-this.origin.scrCoords[2];this.mode=this.BOARD_MODE_MOVE_ORIGIN},initMoveObject:function(f,k){var j,h,i=[],g,e={visProp:{layer:-10000}};for(h in this.objects){j=this.objects[h];g=j.hasPoint&&j.hasPoint(f,k);if(j.visProp.visible&&g){j.triggerEventHandlers("down");this.downObjects.push(j)}if(((this.geonextCompatibilityMode&&(j.elementClass==JXG.OBJECT_CLASS_POINT||j.type==JXG.OBJECT_TYPE_TEXT))||!this.geonextCompatibilityMode)&&j.isDraggable&&j.visProp.visible&&(!j.visProp.fixed)&&(!j.visProp.frozen)&&g){if(j.visProp.layer>=e.visProp.layer){if(JXG.exists(e.label)&&j==e.label.content){continue}e=j;i[0]=e}}}if(i.length>0){this.mode=this.BOARD_MODE_DRAG}if(this.options.takeFirst){i.length=1}return i},moveObject:function(e,j,i){var f=new JXG.Coords(JXG.COORDS_BY_SCREEN,this.getScrCoordsOfMouse(e,j),this),g=i.obj,h;if(g.type!=JXG.OBJECT_TYPE_GLIDER){if(!isNaN(i.targets[0].Xprev+i.targets[0].Yprev)){g.setPositionDirectly(JXG.COORDS_BY_SCREEN,f.scrCoords[1],f.scrCoords[2],i.targets[0].Xprev,i.targets[0].Yprev)}i.targets[0].Xprev=f.scrCoords[1];i.targets[0].Yprev=f.scrCoords[2];this.update(g)}else{if(g.type==JXG.OBJECT_TYPE_GLIDER){h=g.coords;g.setPositionDirectly(JXG.COORDS_BY_USER,f.usrCoords[1],f.usrCoords[2]);if(g.slideObject.elementClass==JXG.OBJECT_CLASS_CIRCLE){g.coords=JXG.Math.Geometry.projectPointToCircle(g,g.slideObject,this)}else{if(g.slideObject.elementClass==JXG.OBJECT_CLASS_LINE){g.coords=JXG.Math.Geometry.projectPointToLine(g,g.slideObject,this)}}if(g.group.length!=0){g.group[g.group.length-1].dX=g.coords.scrCoords[1]-h.scrCoords[1];g.group[g.group.length-1].dY=g.coords.scrCoords[2]-h.scrCoords[2];g.group[g.group.length-1].update(this)}else{this.update(g)}}}g.triggerEventHandlers("drag");this.updateInfobox(g);g.highlight()},moveLine:function(f,e,u){var B,i,C,A,t,s,j,r,k,v,z,w,g,h,q,p,n,m,l;if(JXG.exists(u)&&JXG.exists(u.obj)){w=u.obj}else{return}if(w.elementClass!=JXG.OBJECT_CLASS_LINE){return}B=new JXG.Coords(JXG.COORDS_BY_SCREEN,this.getScrCoordsOfMouse(f[0],f[1]),this);i=new JXG.Coords(JXG.COORDS_BY_SCREEN,this.getScrCoordsOfMouse(e[0],e[1]),this);if(JXG.exists(u.targets[0])&&JXG.exists(u.targets[1])&&!isNaN(u.targets[0].Xprev+u.targets[0].Yprev+u.targets[1].Xprev+u.targets[1].Yprev)){C=B.usrCoords;A=i.usrCoords;t=(new JXG.Coords(JXG.COORDS_BY_SCREEN,[u.targets[0].Xprev,u.targets[0].Yprev],this)).usrCoords;s=(new JXG.Coords(JXG.COORDS_BY_SCREEN,[u.targets[1].Xprev,u.targets[1].Yprev],this)).usrCoords;r=[1,(t[1]+s[1])*0.5,(t[2]+s[2])*0.5];j=[1,(C[1]+A[1])*0.5,(C[2]+A[2])*0.5];v=JXG.Math.crossProduct(t,s);k=JXG.Math.crossProduct(C,A);g=JXG.Math.crossProduct(v,k);if(Math.abs(g[0])<JXG.Math.eps){return;q=this.create("transform",[j[1]-r[1],j[2]-r[2]],{type:"translate"})}else{g[1]/=g[0];g[2]/=g[0];h=JXG.Math.Geometry.rad(r.slice(1),g.slice(1),j.slice(1));q=this.create("transform",[h,g[1],g[2]],{type:"rotate"})}q.update();r=JXG.Math.matVecMult(q.matrix,r);r[1]/=r[0];r[2]/=r[0];p=this.create("transform",[j[1]-r[1],j[2]-r[2]],{type:"translate"});p.update();r=JXG.Math.matVecMult(p.matrix,r);z=JXG.Math.Geometry.distance(C,A)/JXG.Math.Geometry.distance(t,s);n=this.create("transform",[-j[1],-j[2]],{type:"translate"});m=this.create("transform",[z,z],{type:"scale"});l=this.create("transform",[j[1],j[2]],{type:"translate"});q.melt(p).melt(n).melt(m).melt(l);q.applyOnce([w.point1,w.point2]);this.update(w.point1);w.highlight()}w.triggerEventHandlers("drag");u.targets[0].Xprev=B.scrCoords[1];u.targets[0].Yprev=B.scrCoords[2];u.targets[1].Xprev=i.scrCoords[1];u.targets[1].Yprev=i.scrCoords[2]},highlightElements:function(e,h){var f,g;for(f in this.objects){g=this.objects[f];if(g.visProp.highlight&&JXG.exists(g.hasPoint)&&g.visProp.visible&&g.hasPoint(e,h)){this.updateInfobox(g);if(!JXG.exists(this.highlightedObjects[f])){this.highlightedObjects[f]=g;g.highlight()}if(g.mouseover){g.triggerEventHandlers("move")}else{g.triggerEventHandlers("over");g.mouseover=true}}}for(f in this.objects){g=this.objects[f];if(g.mouseover){if(!this.highlightedObjects[f]){g.triggerEventHandlers("out");g.mouseover=false}}}},initXYstart:function(f){var e=[];if(f.type==JXG.OBJECT_TYPE_LINE){e.push(f.point1.coords.usrCoords.slice(1));e.push(f.point2.coords.usrCoords.slice(1))}else{if(f.type==JXG.OBJECT_TYPE_CIRCLE){e.push(f.midpoint.coords.usrCoords.slice(1))}else{if(f.type==JXG.OBJECT_TYPE_GLIDER){e.push([f.position,f.position])}else{e.push(f.coords.usrCoords.slice(1))}}}return e},addEventHandlers:function(){this.addMouseEventHandlers();this.addTouchEventHandlers()},addMouseEventHandlers:function(){if(!this.hasMouseHandlers){JXG.addEvent(this.containerObj,"mousedown",this.mouseDownListener,this);JXG.addEvent(this.containerObj,"mousemove",this.mouseMoveListener,this);JXG.addEvent(document,"mouseup",this.mouseUpListener,this);JXG.addEvent(this.containerObj,"mousewheel",this.mouseWheelListener,this);JXG.addEvent(this.containerObj,"DOMMouseScroll",this.mouseWheelListener,this);this.hasMouseHandlers=true;this.containerObj.oncontextmenu=function(f){if(JXG.exists(f)){f.preventDefault()}return false}}},addTouchEventHandlers:function(){if(!this.hasTouchHandlers){JXG.addEvent(this.containerObj,"touchstart",this.touchStartListener,this);JXG.addEvent(this.containerObj,"touchmove",this.touchMoveListener,this);JXG.addEvent(document,"touchend",this.touchEndListener,this);JXG.addEvent(this.containerObj,"gesturechange",this.gestureChangeListener,this);this.hasTouchHandlers=true}},removeMouseEventHandlers:function(){if(this.hasMouseHandlers){JXG.removeEvent(this.containerObj,"mousedown",this.mouseDownListener,this);JXG.removeEvent(this.containerObj,"mousemove",this.mouseMoveListener,this);JXG.removeEvent(document,"mouseup",this.mouseUpListener,this);JXG.removeEvent(this.containerObj,"mousewheel",this.mouseWheelListener,this);JXG.removeEvent(this.containerObj,"DOMMouseScroll",this.mouseWheelListener,this);this.hasMouseHandlers=false}},removeTouchEventHandlers:function(){if(this.hasTouchHandlers){JXG.removeEvent(this.containerObj,"touchstart",this.touchStartListener,this);JXG.removeEvent(this.containerObj,"touchmove",this.touchMoveListener,this);JXG.removeEvent(document,"touchend",this.touchEndListener,this);JXG.removeEvent(this.containerObj,"gesturechange",this.gestureChangeListener,this);this.hasTouchHandlers=false}},removeEventHandlers:function(){this.removeMouseEventHandlers();this.removeTouchEventHandlers()},clickLeftArrow:function(){this.moveOrigin(this.origin.scrCoords[1]+this.canvasWidth*0.1,this.origin.scrCoords[2]);return this},clickRightArrow:function(){this.moveOrigin(this.origin.scrCoords[1]-this.canvasWidth*0.1,this.origin.scrCoords[2]);return this},clickUpArrow:function(){this.moveOrigin(this.origin.scrCoords[1],this.origin.scrCoords[2]-this.canvasHeight*0.1);return this},clickDownArrow:function(){this.moveOrigin(this.origin.scrCoords[1],this.origin.scrCoords[2]+this.canvasHeight*0.1);return this},gestureStartListener:function(e){if(!this.options.zoom.wheel){return true}e.preventDefault();if(this.mode===this.BOARD_MODE_NONE){this.mode=this.BOARD_MODE_ZOOM;this.prevScale=e.scale;this.oldZoomX=this.zoomX;this.oldZoomY=this.zoomY}return false},gestureChangeListener:function(e){var f;if(!this.options.zoom.wheel){return true}e.preventDefault();if(this.mode===this.BOARD_MODE_NONE){f=new JXG.Coords(JXG.COORDS_BY_SCREEN,this.getMousePosition(e),this);if(this.prevScale<e.scale){this.zoomIn(f.usrCoords[1],f.usrCoords[2])}else{this.zoomOut(f.usrCoords[1],f.usrCoords[2])}this.prevScale=e.scale}return false},gestureEndListener:function(e){if(!this.options.zoom.wheel){return true}e.preventDefault();if(this.mode===this.BOARD_MODE_ZOOM){this.mode=this.BOARD_MODE_NONE}return false},touchStartListener:function(s){var o,r,e,m,h,g,v=this.options.precision.touch,n,u=[],t,p;if(this.hasMouseHandlers){this.removeMouseEventHandlers()}s.stopPropagation();if(document.selection&&typeof document.selection.empty=="function"){document.selection.empty()}else{if(window.getSelection){window.getSelection().removeAllRanges()}}if(this.options.pan&&this.mode===this.BOARD_MODE_NONE&&(s.targetTouches.length==2)&&(JXG.Math.Geometry.distance([s.targetTouches[0].screenX,s.targetTouches[0].screenY],[s.targetTouches[1].screenX,s.targetTouches[1].screenY])<80)){r=this.getMousePosition(s,0);this.initMoveOrigin(r[0],r[1]);this.updateHooks(["touchstart","down"],s);return false}this.options.precision.hasPoint=this.options.precision.touch;for(o=0;o<s.targetTouches.length;o++){s.targetTouches[o].jxg_isused=false}for(o=0;o<this.touches.length;o++){for(m=0;m<this.touches[o].targets.length;m++){this.touches[o].targets[m].num=-1;for(h=0;h<s.targetTouches.length;h++){if(Math.abs(Math.pow(s.targetTouches[h].screenX-this.touches[o].targets[m].X,2)+Math.pow(s.targetTouches[h].screenY-this.touches[o].targets[m].Y,2))<v*v){this.touches[o].targets[m].num=h;this.touches[o].targets[m].X=s.targetTouches[h].screenX;this.touches[o].targets[m].Y=s.targetTouches[h].screenY;s.targetTouches[h].jxg_isused=true;break}}if(this.touches[o].targets[m].num===-1){JXG.debug("i couldn't find a targettouches for target no "+m+" on "+this.touches[o].obj.name+" ("+this.touches[o].obj.id+"). Removed the target.");this.touches[o].targets.splice(o,1)}}}for(o=0;o<s.targetTouches.length;o++){if(!s.targetTouches[o].jxg_isused){r=this.getMousePosition(s,o);e=this.initMoveObject(r[0],r[1]);if(e.length!=0){n=e[e.length-1];if(JXG.isPoint(n)||n.type===JXG.OBJECT_TYPE_TEXT){p=[{num:o,X:s.targetTouches[o].screenX,Y:s.targetTouches[o].screenY,Xprev:NaN,Yprev:NaN,Xstart:[],Ystart:[]}];u=this.initXYstart(n);for(g=0;g<u.length;g++){p[0].Xstart.push(u[g][0]);p[0].Ystart.push(u[g][1])}this.touches.push({obj:n,targets:p})}else{if(n.elementClass===JXG.OBJECT_CLASS_LINE){t=false;for(m=0;m<this.touches.length;m++){if(n.id===this.touches[m].obj.id){t=true;if(this.touches[m].targets.length===1){var q={num:o,X:s.targetTouches[o].screenX,Y:s.targetTouches[o].screenY,Xprev:NaN,Yprev:NaN,Xstart:[],Ystart:[]};u=this.initXYstart(n);for(g=0;g<u.length;g++){q.Xstart.push(u[g][0]);q.Ystart.push(u[g][1])}this.touches[m].targets.push(q)}s.targetTouches[o].jxg_isused=true}}if(!t){p=[{num:o,X:s.targetTouches[o].screenX,Y:s.targetTouches[o].screenY,Xprev:NaN,Yprev:NaN,Xstart:[],Ystart:[]}];u=this.initXYstart(n);for(g=0;g<u.length;g++){p[0].Xstart.push(u[g][0]);p[0].Ystart.push(u[g][1])}this.touches.push({obj:n,targets:p})}}else{if(n.elementClass===JXG.OBJECT_CLASS_CIRCLE){t=false;for(m=0;m<this.touches.length;m++){if(n.id===this.touches[m].obj.id){t=true;s.targetTouches[o].jxg_isused=true;break}}if(!t){p=[{num:o,X:s.targetTouches[o].screenX,Y:s.targetTouches[o].screenY,Xprev:NaN,Yprev:NaN,Xstart:[],Ystart:[]}];u=this.initXYstart(n);for(g=0;g<u.length;g++){p[0].Xstart.push(u[g][0]);p[0].Ystart.push(u[g][1])}this.touches.push({obj:n,targets:p})}}}}}s.targetTouches[o].jxg_isused=true}}if(JXG.isWebkitAndroid()){var f=new Date();this.touchMoveLast=f.getTime()-200}this.options.precision.hasPoint=this.options.precision.mouse;this.updateHooks(["touchstart","down"],s);return false},touchMoveListener:function(e){var g,f,k;e.preventDefault();e.stopPropagation();if(JXG.isWebkitAndroid()){var h=new Date();h=h.getTime();if(h-this.touchMoveLast<80){this.updateQuality=this.BOARD_QUALITY_HIGH;this.updateHooks(["touchmove","move"],e,this.mode);return false}else{this.touchMoveLast=h}}this.dehighlightAll();if(this.mode!=this.BOARD_MODE_DRAG){this.renderer.hide(this.infobox)}this.options.precision.hasPoint=this.options.precision.touch;if(this.mode==this.BOARD_MODE_MOVE_ORIGIN){k=this.getMousePosition(e,0);this.moveOrigin(k[0],k[1])}else{if(this.mode==this.BOARD_MODE_DRAG){for(g=0;g<this.touches.length;g++){if(this.touches[g].targets.length===1){this.touches[g].targets[0].X=e.targetTouches[this.touches[g].targets[0].num].screenX;this.touches[g].targets[0].Y=e.targetTouches[this.touches[g].targets[0].num].screenY;k=this.getMousePosition(e,this.touches[g].targets[0].num);this.moveObject(k[0],k[1],this.touches[g])}else{if(this.touches[g].targets.length===2&&this.touches[g].targets[0].num>-1&&this.touches[g].targets[1].num>-1){this.touches[g].targets[0].X=e.targetTouches[this.touches[g].targets[0].num].screenX;this.touches[g].targets[0].Y=e.targetTouches[this.touches[g].targets[0].num].screenY;this.touches[g].targets[1].X=e.targetTouches[this.touches[g].targets[1].num].screenX;this.touches[g].targets[1].Y=e.targetTouches[this.touches[g].targets[1].num].screenY;this.moveLine(this.getMousePosition(e,this.touches[g].targets[0].num),this.getMousePosition(e,this.touches[g].targets[1].num),this.touches[g])}}}}else{for(g=0;g<e.targetTouches.length;g++){k=this.getMousePosition(e,g);this.highlightElements(k[0],k[1])}}}if(this.mode!=this.BOARD_MODE_DRAG){this.renderer.hide(this.infobox)}this.options.precision.hasPoint=this.options.precision.mouse;this.updateHooks(["touchmove","move"],e,this.mode);return false},touchEndListener:function(g){var m,l,h,f=this.options.precision.touch,n=[],o,e;this.updateHooks(["touchend","up"],g);this.renderer.hide(this.infobox);if(g.targetTouches.length>0){for(m=0;m<this.touches.length;m++){n[m]=this.touches[m]}this.touches.length=0;for(m=0;m<g.targetTouches.length;m++){g.targetTouches[m].jxg_isused=false}for(m=0;m<n.length;m++){o=false;e=0;for(l=0;l<n[m].targets.length;l++){n[m].targets[l].found=false;for(h=0;h<g.targetTouches.length;h++){if(Math.abs(Math.pow(g.targetTouches[h].screenX-n[m].targets[l].X,2)+Math.pow(g.targetTouches[h].screenY-n[m].targets[l].Y,2))<f*f){n[m].targets[l].found=true;n[m].targets[l].num=h;n[m].targets[l].X=g.targetTouches[h].screenX;n[m].targets[l].Y=g.targetTouches[h].screenY;e++;break}}}if(JXG.isPoint(n[m].obj)){o=n[m].targets[0].found}else{if(n[m].obj.elementClass===JXG.OBJECT_CLASS_LINE){o=n[m].targets[0].found||n[m].targets[1].found}else{if(n[m].obj.elementClass===JXG.OBJECT_CLASS_CIRCLE){o=e===1||e===3}}}if(o){this.touches.push({obj:n[m].obj,targets:[]});for(l=0;l<n[m].targets.length;l++){if(n[m].targets[l].found){this.touches[this.touches.length-1].targets.push({num:n[m].targets[l].num,X:n[m].targets[l].screenX,Y:n[m].targets[l].screenY,Xprev:NaN,Yprev:NaN,Xstart:n[m].targets[l].Xstart,Ystart:n[m].targets[l].Ystart})}}}}}else{this.updateQuality=this.BOARD_QUALITY_HIGH;this.mode=this.BOARD_MODE_NONE;if(this.mode!==this.BOARD_MODE_MOVE_ORIGIN){this.update()}this.touches.length=0}for(m=0;m<this.downObjects.length;m++){o=false;for(l=0;l<this.touches.length;l++){if(this.touches.obj.id==this.downObjects[m].id){o=true}}if(!o){this.downObjects[m].triggerEventHandlers("up");this.downObjects.splice(m,1)}}},mouseDownListener:function(j){var k,g,h,f,e;if(document.selection&&typeof document.selection.empty=="function"){document.selection.empty()}else{if(window.getSelection){window.getSelection().removeAllRanges()}}k=this.getMousePosition(j);if(this.options.pan&&j.shiftKey){this.initMoveOrigin(k[0],k[1]);f=false}else{g=this.initMoveObject(k[0],k[1]);if(g.length==0){this.mode=this.BOARD_MODE_NONE;f=true}else{this.mouse={obj:null,targets:[{X:k[0],Y:k[1],Xprev:NaN,Yprev:NaN}]};this.mouse.obj=g[g.length-1];this.mouse.targets[0].Xstart=[];this.mouse.targets[0].Ystart=[];h=this.initXYstart(this.mouse.obj);for(e=0;e<h.length;e++){this.mouse.targets[0].Xstart.push(h[e][0]);this.mouse.targets[0].Ystart.push(h[e][1])}if(j&&j.preventDefault){j.preventDefault()}else{if(window.event){window.event.returnValue=false}}}}this.updateHooks(["mousedown","down"],j);return f},mouseUpListener:function(f){var e;this.updateHooks(["mouseup","up"],f);this.updateQuality=this.BOARD_QUALITY_HIGH;this.mode=this.BOARD_MODE_NONE;if(this.mode!==this.BOARD_MODE_MOVE_ORIGIN){this.update();for(e=0;e<this.downObjects.length;e++){this.downObjects[e].triggerEventHandlers("up")}this.downObjects.length=0}this.mouse=null},mouseMoveListener:function(e){var f;f=this.getMousePosition(e);this.updateQuality=this.BOARD_QUALITY_LOW;this.dehighlightAll();if(this.mode!=this.BOARD_MODE_DRAG){this.renderer.hide(this.infobox)}if(this.mode==this.BOARD_MODE_MOVE_ORIGIN){this.moveOrigin(f[0]-this.drag_dx,f[1]-this.drag_dy)}else{if(this.mode==this.BOARD_MODE_DRAG){this.moveObject(f[0],f[1],this.mouse)}else{this.highlightElements(f[0],f[1])}}this.updateQuality=this.BOARD_QUALITY_HIGH;this.updateHooks(["mousemove","move"],e,this.mode)},mouseWheelListener:function(e){if(!this.options.zoom.wheel){return true}e=e?e:window.event;var f=e.detail?e.detail*(-1):e.wheelDelta/40,g=new JXG.Coords(JXG.COORDS_BY_SCREEN,this.getMousePosition(e),this);if(f>0){this.zoomIn(g.usrCoords[1],g.usrCoords[2])}else{this.zoomOut(g.usrCoords[1],g.usrCoords[2])}e.preventDefault();return false},updateInfobox:function(f){var e,i,g,h;if(!f.visProp.showinfobox){return this}if(f.elementClass==JXG.OBJECT_CLASS_POINT){g=f.coords.usrCoords[1];h=f.coords.usrCoords[2];this.infobox.setCoords(g+this.infobox.distanceX/(this.unitX),h+this.infobox.distanceY/(this.unitY));if(typeof(f.infoboxText)!="string"){e=Math.abs(g);if(e>0.1){e=g.toFixed(2)}else{if(e>=0.01){e=g.toFixed(4)}else{if(e>=0.0001){e=g.toFixed(6)}else{e=g}}}i=Math.abs(h);if(i>0.1){i=h.toFixed(2)}else{if(i>=0.01){i=h.toFixed(4)}else{if(i>=0.0001){i=h.toFixed(6)}else{i=h}}}this.highlightInfobox(e,i,f)}else{this.highlightCustomInfobox(f.infoboxText,f)}this.renderer.show(this.infobox);this.renderer.updateText(this.infobox)}return this},highlightCustomInfobox:function(e){this.infobox.setText('<span style="color:#bbbbbb;">'+e+"</span>");return this},highlightInfobox:function(e,g,f){this.highlightCustomInfobox("("+e+", "+g+")");return this},dehighlightAll:function(){var f,g,e=false;for(f in this.highlightedObjects){g=this.highlightedObjects[f];g.noHighlight();e=true}this.highlightedObjects={};if(this.options.renderer=="canvas"&&e){this.prepareUpdate();this.renderer.suspendRedraw(this);this.updateRenderer();this.renderer.unsuspendRedraw()}return this},getScrCoordsOfMouse:function(e,g){if(this.options.grid.snapToGrid){var f=new JXG.Coords(JXG.COORDS_BY_SCREEN,[e,g],this);f.setCoordinates(JXG.COORDS_BY_USER,[Math.round((f.usrCoords[1])*this.options.grid.snapSizeX)/this.options.grid.snapSizeX,Math.round((f.usrCoords[2])*this.options.grid.snapSizeY)/this.options.grid.snapSizeY]);return[f.scrCoords[1],f.scrCoords[2]]}else{return[e,g]}},getUsrCoordsOfMouse:function(i){var g=this.getCoordsTopLeftCorner(),f=JXG.getPosition(i),e=f[0]-g[0],j=f[1]-g[1],h=new JXG.Coords(JXG.COORDS_BY_SCREEN,[e,j],this);return h.usrCoords.slice(1)},getAllUnderMouse:function(f){var e=this.getAllObjectsUnderMouse();e.push(this.getUsrCoordsOfMouse(f));return e},getAllObjectsUnderMouse:function(k){var j=this.getCoordsTopLeftCorner(),e=JXG.getPosition(k),g=e[0]-j[0],f=e[1]-j[1],h=[];for(var i in this.objects){if(this.objects[i].visProp.visible&&this.objects[i].hasPoint&&this.objects[i].hasPoint(g,f)){h.push(this.objects[i])}}return h},moveOrigin:function(e,h){var g,f;if(JXG.exists(e)&&JXG.exists(h)){this.origin.scrCoords[1]=e;this.origin.scrCoords[2]=h}for(f in this.objects){g=this.objects[f];if(!g.visProp.frozen&&(g.elementClass==JXG.OBJECT_CLASS_POINT||g.elementClass==JXG.OBJECT_CLASS_CURVE||g.type==JXG.OBJECT_TYPE_AXIS||g.type==JXG.OBJECT_TYPE_TEXT)){if(g.elementClass!=JXG.OBJECT_CLASS_CURVE&&g.type!=JXG.OBJECT_TYPE_AXIS){g.coords.usr2screen()}}}this.clearTraces();this.fullUpdate();return this},addConditions:function(p){var f="var el, x, y, c, rgbo;\n",o=p.indexOf("<data>"),n=p.indexOf("</data>"),l,k,h,r,e,g;if(o<0){return}while(o>=0){l=p.slice(o+6,n);k=l.indexOf("=");h=l.slice(0,k);r=l.slice(k+1);k=h.indexOf(".");e=h.slice(0,k);g=this.elementsByName[JXG.unescapeHTML(e)];var q=h.slice(k+1).replace(/\s+/g,"").toLowerCase();r=JXG.GeonextParser.geonext2JS(r,this);r=r.replace(/this\.board\./g,"this.");if(!JXG.exists(this.elementsByName[e])){JXG.debug("debug conditions: |"+e+"| undefined")}f+='el = this.objects["'+g.id+'"];\n';switch(q){case"x":f+="var y=el.coords.usrCoords[2];\n";f+="el.setPositionDirectly(JXG.COORDS_BY_USER,"+(r)+",y);\n";f+="el.prepareUpdate().update();\n";break;case"y":f+="var x=el.coords.usrCoords[1];\n";f+="el.coords=new JXG.Coords(JXG.COORDS_BY_USER,[x,"+(r)+"],this);\n";f+="el.setPositionDirectly(JXG.COORDS_BY_USER,x,"+(r)+");\n";f+="el.prepareUpdate().update();\n";break;case"visible":f+="var c="+(r)+";\n";f+="el.visProp.visible = c;\n";f+="if (c) {el.showElement();} else {el.hideElement();}\n";break;case"position":f+="el.position = "+(r)+";\n";f+="el.prepareUpdate().update(true);\n";break;case"stroke":f+="rgbo = JXG.rgba2rgbo("+(r)+");\n";f+="el.visProp.strokecolor = rgbo[0];\n";f+="el.visProp.strokeopacity = rgbo[1];\n";break;case"style":f+="el.setStyle("+(r)+");\n";break;case"strokewidth":f+="el.strokeWidth = "+(r)+";\n";break;case"fill":f+="var rgbo = JXG.rgba2rgbo("+(r)+");\n";f+="el.visProp.fillcolor = rgbo[0];\n";f+="el.visProp.fillopacity = rgbo[1];\n";break;case"label":break;default:JXG.debug("property '"+q+"' in conditions not yet implemented:"+r);break}p=p.slice(n+7);o=p.indexOf("<data>");n=p.indexOf("</data>")}f+="this.prepareUpdate().updateElements();\n";f+="return true;\n";this.updateConditions=new Function(f);this.updateConditions()},updateConditions:function(){return false},calculateSnapSizes:function(){var g=new JXG.Coords(JXG.COORDS_BY_USER,[0,0],this),f=new JXG.Coords(JXG.COORDS_BY_USER,[this.options.grid.gridX,this.options.grid.gridY],this),e=g.scrCoords[1]-f.scrCoords[1],h=g.scrCoords[2]-f.scrCoords[2];this.options.grid.snapSizeX=this.options.grid.gridX;while(Math.abs(e)>25){this.options.grid.snapSizeX*=2;e/=2}this.options.grid.snapSizeY=this.options.grid.gridY;while(Math.abs(h)>25){this.options.grid.snapSizeY*=2;h/=2}return this},applyZoom:function(){var f,e;for(e in this.objects){f=this.objects[e];if(!f.visProp.frozen&&(f.elementClass==JXG.OBJECT_CLASS_POINT||f.elementClass==JXG.OBJECT_CLASS_CURVE||f.type==JXG.OBJECT_TYPE_AXIS||f.type==JXG.OBJECT_TYPE_TEXT)){if(f.elementClass!=JXG.OBJECT_CLASS_CURVE&&f.type!=JXG.OBJECT_TYPE_AXIS){f.coords.usr2screen()}}}this.calculateSnapSizes();this.clearTraces();this.fullUpdate();return this},zoomIn:function(m,k){var h=this.getBoundingBox(),l=this.options.zoom.factorX,j=this.options.zoom.factorY,f=(h[2]-h[0])*(1-1/l),e=(h[1]-h[3])*(1-1/j),g=0.5,i=0.5;if(typeof m==="number"&&typeof k==="number"){g=(m-h[0])/(h[2]-h[0]);i=(h[1]-k)/(h[1]-h[3])}this.setBoundingBox([h[0]+f*g,h[1]-e*i,h[2]-f*(1-g),h[3]+e*(1-i)],false);this.zoomX*=l;this.zoomY*=j;this.applyZoom();return this},zoomOut:function(m,k){var h=this.getBoundingBox(),l=this.options.zoom.factorX,j=this.options.zoom.factorY,f=(h[2]-h[0])*(1-l),e=(h[1]-h[3])*(1-j),g=0.5,i=0.5;if(typeof m==="number"&&typeof k==="number"){g=(m-h[0])/(h[2]-h[0]);i=(h[1]-k)/(h[1]-h[3])}this.setBoundingBox([h[0]+f*g,h[1]-e*i,h[2]-f*(1-g),h[3]+e*(1-i)],false);this.zoomX/=l;this.zoomY/=j;this.applyZoom();return this},zoom100:function(){var g=this.getBoundingBox(),f=(g[2]-g[0])*(1-this.zoomX)*0.5,e=(g[1]-g[3])*(1-this.zoomY)*0.5;this.setBoundingBox([g[0]+f,g[1]-e,g[2]-f,g[3]+e],false);this.zoomX=1;this.zoomY=1;this.applyZoom();return this},zoomAllPoints:function(){var e=0,k=0,l=0,j=0,i,h,g,f;for(i in this.objects){if(JXG.isPoint(this.objects[i])&&this.objects[i].visProp.visible){if(this.objects[i].coords.usrCoords[1]<e){e=this.objects[i].coords.usrCoords[1]}else{if(this.objects[i].coords.usrCoords[1]>k){k=this.objects[i].coords.usrCoords[1]}}if(this.objects[i].coords.usrCoords[2]>j){j=this.objects[i].coords.usrCoords[2]}else{if(this.objects[i].coords.usrCoords[2]<l){l=this.objects[i].coords.usrCoords[2]}}}}h=50;g=h/(this.unitX);f=h/(this.unitY);this.zoomX=1;this.zoomY=1;this.setBoundingBox([e-g,j+f,k+g,l-f],true);this.applyZoom();return this},zoomElements:function(m){var k,h,n,l,g=[0,0,0,0],f=[1,-1,-1,1];if(!JXG.isArray(m)||m.length===0){return this}for(k=0;k<m.length;k++){n=JXG.getRef(this,m[k]);l=n.bounds();if(JXG.isArray(l)){if(JXG.isArray(g)){for(h=0;h<4;h++){if(f[h]*l[h]<f[h]*g[h]){g[h]=l[h]}}}else{g=l}}}if(JXG.isArray(g)){for(h=0;h<4;h++){g[h]-=f[h]}this.zoomX=1;this.zoomY=1;this.setBoundingBox(g,true)}return this},setZoom:function(h,g){var f=this.options.zoom.factorX,e=this.options.zoom.factorY;this.options.zoom.factorX=h/this.zoomX;this.options.zoom.factorY=g/this.zoomY;this.zoomIn();this.options.zoom.factorX=f;this.options.zoom.factorY=e;return this},removeObject:function(f){var h,g;if(JXG.isArray(f)){for(g=0;g<f.length;g++){this.removeObject(f[g])}}f=JXG.getReference(this,f);if(!JXG.exists(f)){return this}try{for(h in f.childElements){f.childElements[h].board.removeObject(f.childElements[h])}for(h in this.objects){if(JXG.exists(this.objects[h].childElements)){delete (this.objects[h].childElements[f.id])}}delete (this.objects[f.id]);delete (this.elementsByName[f.name]);if(f.visProp.trace){f.clearTrace()}if(JXG.exists(f.remove)){f.remove()}}catch(j){JXG.debug(f.id+": Could not be removed: "+j)}return this},removeAncestors:function(e){for(var f in e.ancestors){this.removeAncestors(e.ancestors[f])}this.removeObject(e);return this},initGeonextBoard:function(){var i,h,g,f,e;i=this.create("point",[0,0],{id:this.id+"g00e0",name:"Ursprung",withLabel:false,visible:false,fixed:true});h=this.create("point",[1,0],{id:this.id+"gX0e0",name:"Punkt_1_0",withLabel:false,visible:false,fixed:true});g=this.create("point",[0,1],{id:this.id+"gY0e0",name:"Punkt_0_1",withLabel:false,visible:false,fixed:true});f=this.create("line",[i,h],{id:this.id+"gXLe0",name:"X-Achse",withLabel:false,visible:false});e=this.create("line",[i,g],{id:this.id+"gYLe0",name:"Y-Achse",withLabel:false,visible:false});return this},initInfobox:function(){this.infobox=this.create("text",[0,0,"0,0"],{id:this.id+"_infobox",display:"html",fixed:true});this.infobox.distanceX=-20;this.infobox.distanceY=25;this.infobox.dump=false;this.renderer.hide(this.infobox);return this},resizeContainer:function(e,f){this.canvasWidth=parseFloat(e);this.canvasHeight=parseFloat(f);this.containerObj.style.width=(this.canvasWidth)+"px";this.containerObj.style.height=(this.canvasHeight)+"px";this.renderer.resize(this.canvasWidth,this.canvasHeight);return this},showDependencies:function(){var h,g,k,j,e;g="<p>\n";for(h in this.objects){e=0;for(k in this.objects[h].childElements){e++}if(e>=0){g+="<b>"+this.objects[h].id+":</b> "}for(k in this.objects[h].childElements){g+=this.objects[h].childElements[k].id+"("+this.objects[h].childElements[k].name+"), "}g+="<p>\n"}g+="</p>\n";j=window.open();j.document.open();j.document.write(g);j.document.close();return this},showXML:function(){var e=window.open("");e.document.open();e.document.write("<pre>"+JXG.escapeHTML(this.xmlString)+"</pre>");e.document.close();return this},prepareUpdate:function(){var e,f;for(e in this.objects){f=this.objects[e];if(!this.needsFullUpdate&&!f.needsRegularUpdate){continue}f.needsUpdate=true}return this},updateElements:function(f){var e,g;f=JXG.getRef(this,f);for(e in this.objects){g=this.objects[e];if(f==null||g.id!=f.id){g.update(true)}else{g.update(false)}}return this},updateRenderer:function(f){var e,g;if(this.options.renderer=="canvas"){this.updateRendererCanvas(f)}else{for(e in this.objects){g=this.objects[e];g.updateRenderer()}}return this},updateRendererCanvas:function(j){var e,m,h,g=this.options.layer,l=this.options.layer.numlayers,n=Number.NEGATIVE_INFINITY,k,f;for(h=0;h<l;h++){k=Number.POSITIVE_INFINITY;for(f in g){if(g[f]>n&&g[f]<k){k=g[f]}}n=k;for(e in this.objects){m=this.objects[e];if(m.visProp.layer===k){m.prepareUpdate().updateRenderer()}}}return this},addHook:function(g,e,f){if(!JXG.exists(e)){e="update"}f=f||this;this.hooks.push({fn:g,mode:e,context:f});if(e=="update"){g.apply(f,[this])}return(this.hooks.length-1)},removeHook:function(e){this.hooks[e]=null;return this},updateHooks:function(f){var l,k,e,h,g=arguments.length>1?Array.prototype.slice.call(arguments,1):[];if(!JXG.exists(f)){f=["update"]}if(!JXG.isArray(f)){f=[f]}e=f.length;h=this.hooks.length;for(k=0;k<e;k++){for(l=0;l<h;l++){if((this.hooks[l]!=null)&&(this.hooks[l].mode==f[k])){this.hooks[l].fn.apply(this.hooks[l].context,g)}}}return this},addChild:function(e){this.dependentBoards.push(e);this.update();return this},removeChild:function(f){var e;for(e=this.dependentBoards.length-1;e>=0;e--){if(this.dependentBoards[e]==f){this.dependentBoards.splice(e,1)}}return this},update:function(h){var g,f,j,e;if(this.inUpdate||this.isSuspendedUpdate){return this}this.inUpdate=true;this.prepareUpdate(h).updateElements(h).updateConditions();this.renderer.suspendRedraw(this);this.updateRenderer(h);this.renderer.unsuspendRedraw();this.updateHooks();f=this.dependentBoards.length;for(g=0;g<f;g++){j=this.dependentBoards[g].id;e=JXG.JSXGraph.boards[j];if(e!=this){e.updateQuality=this.updateQuality;e.prepareUpdate().updateElements().updateConditions();e.renderer.suspendRedraw();e.updateRenderer();e.renderer.unsuspendRedraw();e.updateHooks()}}this.inUpdate=false;return this},fullUpdate:function(){this.needsFullUpdate=true;this.update();this.needsFullUpdate=false;return this},addGrid:function(){this.create("grid",[]);return this},removeGrids:function(){var e;for(e=0;e<this.grids.length;e++){this.removeObject(this.grids[e])}this.grids.length=0;this.update();return this},create:function(f,g,e){var j,h;f=f.toLowerCase();if(!JXG.exists(g)){g=[]}if(!JXG.exists(e)){e={}}for(h=0;h<g.length;h++){if(f!="text"||h!=2){g[h]=JXG.getReference(this,g[h])}}if(JXG.JSXGraph.elements[f]!=null){if(typeof JXG.JSXGraph.elements[f]=="function"){j=JXG.JSXGraph.elements[f](this,g,e)}else{j=JXG.JSXGraph.elements[f].creator(this,g,e)}}else{throw new Error("JSXGraph: JXG.createElement: Unknown element type given: "+f)}if(!JXG.exists(j)){JXG.debug("JSXGraph: JXG.createElement: failure creating "+f);return j}if(j.prepareUpdate&&j.update&&j.updateRenderer){j.prepareUpdate().update().updateRenderer()}return j},createElement:JXG.shortcut(JXG.Board.prototype,"create"),clearTraces:function(){var e;for(e in this.objects){this.objects[e].clearTrace()}this.numTraces=0;return this},suspendUpdate:function(){this.isSuspendedUpdate=true;return this},unsuspendUpdate:function(){this.isSuspendedUpdate=false;this.update();return this},setBoundingBox:function(j,f){if(!JXG.isArray(j)){return this}var g,e,i=JXG.getDimensions(this.container);this.canvasWidth=parseInt(i.width);this.canvasHeight=parseInt(i.height);e=this.canvasWidth;g=this.canvasHeight;if(f){this.unitX=e/(j[2]-j[0]);this.unitY=g/(j[1]-j[3]);if(Math.abs(this.unitX)<Math.abs(this.unitY)){this.unitY=Math.abs(this.unitX)*this.unitY/Math.abs(this.unitY)}else{this.unitX=Math.abs(this.unitY)*this.unitX/Math.abs(this.unitX)}}else{this.unitX=e/(j[2]-j[0]);this.unitY=g/(j[1]-j[3])}this.moveOrigin(-this.unitX*j[0],this.unitY*j[1]);return this},getBoundingBox:function(){var f=new JXG.Coords(JXG.COORDS_BY_SCREEN,[0,0],this),e=new JXG.Coords(JXG.COORDS_BY_SCREEN,[this.canvasWidth,this.canvasHeight],this);return[f.usrCoords[1],f.usrCoords[2],e.usrCoords[1],e.usrCoords[2]]},addAnimation:function(e){this.animationObjects[e.id]=e;if(!this.animationIntervalCode){this.animationIntervalCode=window.setInterval("JXG.JSXGraph.boards['"+this.id+"'].animate();",35)}return this},stopAllAnimation:function(){var e;for(e in this.animationObjects){if(this.animationObjects[e]===null){continue}this.animationObjects[e]=null;delete (this.animationObjects[e])}window.clearInterval(this.animationIntervalCode);delete (this.animationIntervalCode);return this},animate:function(){var k=0,h,g,m,e,f,l,j=null,i;for(h in this.animationObjects){if(this.animationObjects[h]===null){continue}k++;g=this.animationObjects[h];if(g.animationPath){if(JXG.isFunction(g.animationPath)){m=g.animationPath(new Date().getTime()-g.animationStart)}else{m=g.animationPath.pop()}if((!JXG.exists(m))||(!JXG.isArray(m)&&isNaN(m))){delete (g.animationPath)}else{g.setPositionDirectly(JXG.COORDS_BY_USER,m[0],m[1]);g.prepareUpdate().update().updateRenderer();j=g}}if(g.animationData){l=0;for(e in g.animationData){f=g.animationData[e].pop();if(!JXG.exists(f)){delete (g.animationData[f])}else{l++;g.setProperty(e+":"+f)}}if(l==0){delete (g.animationData)}}if(!JXG.exists(g.animationData)&&!JXG.exists(g.animationPath)){this.animationObjects[h]=null;delete (this.animationObjects[h]);if(JXG.exists(g.animationCallback)){i=g.animationCallback;g.animationCallback=null;i()}}}if(k==0){window.clearInterval(this.animationIntervalCode);delete (this.animationIntervalCode)}else{this.update(j)}return this},emulateColorblindness:function(f){var g,h,i=this;if(!JXG.exists(f)){f="none"}if(this.currentCBDef==f){return this}for(g in i.objects){h=i.objects[g];if(f!="none"){if(this.currentCBDef=="none"){h.visPropOriginal={strokecolor:h.visProp.strokecolor,fillcolor:h.visProp.fillcolor,highlightstrokecolor:h.visProp.highlightstrokecolor,highlightfillcolor:h.visProp.highlightfillcolor}}h.setProperty({strokecolor:JXG.rgb2cb(h.visPropOriginal.strokecolor,f),fillcolor:JXG.rgb2cb(h.visPropOriginal.fillcolor,f),highlightstrokecolor:JXG.rgb2cb(h.visPropOriginal.highlightstrokecolor,f),highlightfillcolor:JXG.rgb2cb(h.visPropOriginal.highlightfillcolor,f)})}else{if(JXG.exists(h.visPropOriginal)){JXG.extend(h.visProp,h.visPropOriginal)}}}this.currentCBDef=f;this.update();return this},getPartialConstruction:function(e){var g,f;for(f=1;f<arguments.length;f++){g.push(arguments[f])}},createRoulette:function(i,h,m,j,l,f,k){var g=this;var e=function(){var t=0,z=0,w=0,v=m,u=JXG.Math.Numerics.root(function(H){var J=i.X(v),I=i.Y(v),G=h.X(H),F=h.Y(H);return(J-G)*(J-G)+(I-F)*(I-F)},[0,Math.PI*2]),q=0,n=0,C,D=g.create("transform",[function(){return t}],{type:"rotate"}),p=g.create("transform",[function(){return t},function(){return i.X(v)},function(){return i.Y(v)}],{type:"rotate"}),s=g.create("transform",[function(){return z},function(){return w}],{type:"translate"}),A=function(O,Q,P){var N=JXG.Math.Numerics.D(O.X)(Q),H=JXG.Math.Numerics.D(O.Y)(Q),M=JXG.Math.Numerics.D(O.X)(P),G=JXG.Math.Numerics.D(O.Y)(P),J=JXG.Math.Numerics.D(O.X)((Q+P)*0.5),L=JXG.Math.Numerics.D(O.Y)((Q+P)*0.5),K=Math.sqrt(N*N+H*H),I=Math.sqrt(M*M+G*G),F=Math.sqrt(J*J+L*L);return(K+4*F+I)*(P-Q)/6},E=function(F){return C-A(h,u,F)},B=Math.PI/18,o=B*9,r=null;this.rolling=function(){q=v+l*j;C=A(i,v,q);n=JXG.Math.Numerics.root(E,u);var G=new JXG.Complex(i.X(q),i.Y(q));var H=new JXG.Complex(h.X(n),h.Y(n));var I=new JXG.Complex(JXG.Math.Numerics.D(i.X)(q),JXG.Math.Numerics.D(i.Y)(q));var F=new JXG.Complex(JXG.Math.Numerics.D(h.X)(n),JXG.Math.Numerics.D(h.Y)(n));var J=JXG.C.div(I,F);t=Math.atan2(J.imaginary,J.real);J.div(JXG.C.abs(J));J.mult(H);z=G.real-J.real;w=G.imaginary-J.imaginary;if(t<-B&&t>-o){t=-B;p.applyOnce(k)}else{if(t>B&&t<o){t=B;p.applyOnce(k)}else{D.applyOnce(k);s.applyOnce(k);v=q;u=n}}g.update()};this.start=function(){if(f>0){r=setInterval(this.rolling,f)}return this};this.stop=function(){clearInterval(r);return this};return this};return new e()}});JXG.Options={showCopyright:true,showNavigation:true,takeSizeFromFile:false,renderer:"svg",takeFirst:false,pan:true,zoom:{factorX:1.25,factorY:1.25,wheel:false},jc:{enabled:true,compile:true},navbar:{strokeColor:"#aaaaaa",fillColor:"#f5f5f5",padding:"2px",position:"absolute",fontSize:"10px",cursor:"pointer",zIndex:"100",right:"5px",bottom:"5px"},elements:{strokeColor:"#0000ff",highlightStrokeColor:"#C3D9FF",fillColor:"red",highlightFillColor:"none",strokeOpacity:1,highlightStrokeOpacity:1,fillOpacity:1,highlightFillOpacity:1,strokeWidth:2,highlightStrokeWidth:2,fixed:false,frozen:false,withLabel:false,visible:true,layer:0,dash:0,shadow:false,trace:false,traceAttributes:{},highlight:true,needsRegularUpdate:true,draft:{draft:false,strokeColor:"#565656",fillColor:"#565656",strokeOpacity:0.8,fillOpacity:0.8,strokeWidth:1}},ticks:{drawLabels:false,drawZero:false,insertTicks:false,minTicksDistance:50,minorHeight:4,majorHeight:10,minorTicks:4,ticksDistance:1,strokeOpacity:1,strokeWidth:1,strokeColor:"black",highlightStrokeColor:"#888888"},precision:{touch:30,mouse:4,epsilon:0.0001,hasPoint:4},layer:{numlayers:20,text:9,point:9,arc:8,line:7,circle:6,curve:5,turtle:5,polygon:3,sector:3,angle:3,integral:3,axis:2,grid:1,image:0,trace:0},angle:{withLabel:true,radius:1,type:"auto",fillColor:"#FF7F00",highlightFillColor:"#FF7F00",strokeColor:"#FF7F00",fillOpacity:0.3,highlightFillOpacity:0.3,radiuspoint:{withLabel:false,visible:false,name:""},pointsquare:{withLabel:false,visible:false,name:""},dot:{visible:false,strokeColor:"none",fillColor:"black",size:2,face:"o",withLabel:false,name:""},label:{strokeColor:"#0000FF"}},arc:{firstArrow:false,lastArrow:false,fillColor:"none",highlightFillColor:"none",strokeColor:"#0000ff",highlightStrokeColor:"#C3D9FF",useDirection:false},axis:{needsRegularUpdate:false,strokeWidth:1,strokeColor:"#666666",highlightStrokeWidth:1,highlightStrokeColor:"#888888",withTicks:true,straightFirst:true,straightLast:true,lastArrow:true,withLabel:false,ticks:{needsRegularUpdate:false,strokeWidth:1,strokeColor:"#666666",highlightStrokeColor:"#888888",drawLabels:true,drawZero:false,insertTicks:true,minTicksDistance:10,minorHeight:4,majorHeight:-1,minorTicks:4,ticksDistance:1,strokeOpacity:0.25},point1:{needsRegularUpdate:false},point2:{needsRegularUpdate:false},label:{position:"lft",offsets:[10,-20]}},bisector:{strokeColor:"#000000",point:{visible:false,fixed:false,withLabel:false,name:""}},bisectorlines:{line1:{strokeColor:"red"},line2:{strokeColor:"black"}},chart:{chartStyle:"line",colors:["#B02B2C","#3F4C6B","#C79810","#D15600","#FFFF88","#C3D9FF","#4096EE","#008C00"],highlightcolors:null,fillcolor:null,highlightonsector:false,highlightbysize:false},circle:{fillColor:"none",highlightFillColor:"none",strokeColor:"#0000ff",highlightStrokeColor:"#C3D9FF",center:{visible:false,withLabel:false,fixed:false,name:""},label:{position:"ulft"}},circumcircle:{fillColor:"none",highlightFillColor:"none",strokeColor:"#0000ff",highlightStrokeColor:"#C3D9FF",center:{visible:false,fixed:false,withLabel:false,name:""}},circumcirclearc:{fillColor:"none",highlightFillColor:"none",strokeColor:"#0000ff",highlightStrokeColor:"#C3D9FF",center:{visible:false,withLabel:false,fixed:false,name:""}},circumcirclesector:{useDirection:true,fillColor:"#00FF00",highlightFillColor:"#00FF00",fillOpacity:0.3,highlightFillOpacity:0.3,strokeColor:"#0000ff",highlightStrokeColor:"#C3D9FF",point:{visible:false,fixed:false,withLabel:false,name:""}},conic:{fillColor:"none",highlightFillColor:"none",strokeColor:"#0000ff",highlightStrokeColor:"#C3D9FF",foci:{fixed:false,visible:false,withLabel:false,name:""}},curve:{strokeWidth:1,strokeColor:"#0000ff",fillColor:"none",handDrawing:false,curveType:null,RDPsmoothing:false,numberPointsHigh:1600,numberPointsLow:400,doAdvancedPlot:true,label:{position:"lft"}},glider:{},grid:{needsRegularUpdate:false,hasGrid:false,gridX:1,gridY:1,strokeColor:"#C0C0C0",strokeOpacity:"0.5",strokeWidth:1,dash:0,snapToGrid:false,snapSizeX:10,snapSizeY:10},image:{imageString:null,fillOpacity:1},incircle:{fillColor:"none",highlightFillColor:"none",strokeColor:"#0000ff",highlightStrokeColor:"#C3D9FF",center:{visible:false,fixed:false,withLabel:false,name:""}},integral:{withLabel:true,strokeWidth:0,strokeOpacity:0,fillOpacity:0.8,curveLeft:{visible:true,layer:9},baseLeft:{visible:false,fixed:false,withLabel:false,name:""},curveRight:{visible:true,layer:9},baseRight:{visible:false,fixed:false,withLabel:false,name:""},label:{fontSize:20}},label:{strokeColor:"black",fixed:true,position:"urt",offsets:[10,10]},legend:{style:"vertical",labels:["1","2","3","4","5","6","7","8"],colors:["#B02B2C","#3F4C6B","#C79810","#D15600","#FFFF88","#C3D9FF","#4096EE","#008C00"]},line:{firstArrow:false,lastArrow:false,straightFirst:true,straightLast:true,fillColor:"none",highlightFillColor:"none",strokeColor:"#0000ff",highlightStrokeColor:"#888888",withTicks:false,point1:{visible:false,withLabel:false,fixed:false,name:""},point2:{visible:false,withLabel:false,fixed:false,name:""},ticks:{drawLabels:true,drawZero:false,insertTicks:false,minTicksDistance:50,maxTicksDistance:300,minorHeight:4,majorHeight:-1,minorTicks:4,defaultDistance:1,strokeOpacity:0.3},label:{position:"llft"}},locus:{translateToOrigin:false,translateTo10:false,stretch:false,toOrigin:null,to10:null},normal:{strokeColor:"#000000",point:{visible:false,fixed:false,withLabel:false,name:""}},orthogonalprojection:{},parallel:{strokeColor:"#000000",point:{visible:false,fixed:false,withLabel:false,name:""}},perpendicular:{strokeColor:"#000000",straightFirst:true,straightLast:true},perpendicularsegment:{strokeColor:"#000000",straightFirst:false,straightLast:false,point:{visible:false,fixed:true,withLabel:false,name:""}},point:{withLabel:true,style:5,face:"o",size:3,fillColor:"#ff0000",highlightFillColor:"#EEEEEE",strokeWidth:2,strokeColor:"#ff0000",highlightStrokeColor:"#C3D9FF",zoom:false,showInfobox:true,draft:false,attractors:[],attractorDistance:0,snatchDistance:0,snapToGrid:false,snapSizeX:1,snapSizeY:1,snapToPoints:false},polygon:{hasInnerPoints:false,fillColor:"#00FF00",highlightFillColor:"#00FF00",fillOpacity:0.3,highlightFillOpacity:0.3,withLines:true,borders:{withLabel:false,strokeWidth:1,highlightStrokeWidth:1,layer:5},vertices:{withLabel:true,strokeColor:"#ff0000",fillColor:"#ff0000",fixed:true},label:{offsets:[0,0]}},riemannsum:{withLabel:false,fillOpacity:0.3,fillColor:"#ffff00"},sector:{fillColor:"#00FF00",highlightFillColor:"#00FF00",fillOpacity:0.3,highlightFillOpacity:0.3},semicircle:{midpoint:{visible:false,withLabel:false,fixed:false,name:""}},slider:{snapWidth:-1,precision:2,firstArrow:false,lastArrow:false,withTicks:true,withLabel:true,layer:9,showInfobox:false,name:"",visible:true,strokeColor:"#000000",highlightStrokeColor:"#888888",fillColor:"#ffffff",highlightFillColor:"none",size:6,point1:{needsRegularUpdate:false,showInfobox:false,withLabel:false,visible:false,fixed:true,name:""},point2:{needsRegularUpdate:false,showInfobox:false,withLabel:false,visible:false,fixed:true,name:""},baseline:{needsRegularUpdate:false,name:"",strokeWidth:1,strokeColor:"#000000",highlightStrokeColor:"#888888"},ticks:{needsRegularUpdate:false,drawLabels:false,drawZero:true,insertTicks:true,minorHeight:4,majorHeight:10,minorTicks:0,defaultDistance:1,strokeOpacity:1,strokeWidth:1,strokeColor:"#000000"},highline:{strokeWidth:3,name:"",strokeColor:"#000000",highlightStrokeColor:"#888888"},label:{strokeColor:"#000000"}},text:{fontSize:12,digits:2,isLabel:false,strokeColor:"#000000",useASCIIMathML:false,useMathJax:false,display:"html",cssClass:"JXGtext",highlightCssClass:"JXGtext",withLabel:false},tracecurve:{strokeColor:"#000000",fillColor:"none",numberPoints:100},turtle:{strokeWidth:1,fillColor:"none",strokeColor:"#000000",arrow:{strokeWidth:2,withLabel:false,strokeColor:"#ff0000"}},shortcuts:{color:["strokeColor","fillColor"],opacity:["strokeOpacity","fillOpacity"],highlightColor:["highlightStrokeColor","highlightFillColor"],highlightOpacity:["highlightStrokeOpacity","highlightFillOpacity"],strokeWidth:["strokeWidth","highlightStrokeWidth"]}};JXG.Validator=(function(){var l=function(i){return/^[0-9]+px$/.test(i)},n=function(i){return(i in {html:0,internal:0})},o=function(i){return JXG.isString(i)},m=function(i){return JXG.exists(JXG.Point.prototype.normalizeFace.call(this,i))},q=function(i){return(Math.abs(i-Math.round(i))<JXG.Math.eps)},r=function(i){return q(i)&&i>0},j=function(i){return i.length>=2&&q(i[0])&&q(i[1])},e=function(i){return(i in {vml:0,svg:0,canvas:0})},k=function(i){return i>0},h=function(i){return !(i<0)},g,p={},f={attractorDistance:h,color:o,defaultDistance:JXG.isNumber,display:n,doAdvancedPlot:false,draft:false,drawLabels:false,drawZero:false,face:m,factor:JXG.isNumber,fillColor:o,fillOpacity:JXG.isNumber,firstArrow:false,fontSize:q,dash:q,gridX:JXG.isNumber,gridY:JXG.isNumber,hasGrid:false,highlightFillColor:o,highlightFillOpacity:JXG.isNumber,highlightStrokeColor:o,highlightStrokeOpacity:JXG.isNumber,insertTicks:false,lastArrow:false,majorHeight:q,maxTicksDistance:r,minorHeight:q,minorTicks:r,minTicksDistance:r,numberPointsHigh:r,numberPointsLow:r,opacity:JXG.isNumber,radius:JXG.isNumber,RDPsmoothing:false,renderer:e,right:l,showCopyright:false,showInfobox:false,showNavigation:false,size:q,snapSizeX:k,snapSizeY:k,snapWidth:JXG.isNumber,snapToGrid:false,snatchDistance:h,straightFirst:false,straightLast:false,stretch:false,strokeColor:o,strokeOpacity:JXG.isNumber,strokeWidth:q,takeFirst:false,takeSizeFromFile:false,to10:false,toOrigin:false,translateTo10:false,translateToOrigin:false,useASCIIMathML:false,useDirection:false,useMathJax:false,withLabel:false,withTicks:false,zoom:false};for(g in f){p[g.toLowerCase()]=f[g]}return p})();JXG.useStandardOptions=function(i){var k=JXG.Options,h=i.hasGrid,g,f,j,e;i.options.grid.hasGrid=k.grid.hasGrid;i.options.grid.gridX=k.grid.gridX;i.options.grid.gridY=k.grid.gridY;i.options.grid.gridColor=k.grid.gridColor;i.options.grid.gridOpacity=k.grid.gridOpacity;i.options.grid.gridDash=k.grid.gridDash;i.options.grid.snapToGrid=k.grid.snapToGrid;i.options.grid.snapSizeX=k.grid.SnapSizeX;i.options.grid.snapSizeY=k.grid.SnapSizeY;i.takeSizeFromFile=k.takeSizeFromFile;e=function(l,m){l.visProp.fillcolor=m.fillColor;l.visProp.highlightfillcolor=m.highlightFillColor;l.visProp.strokecolor=m.strokeColor;l.visProp.highlightstrokecolor=m.highlightStrokeColor};for(g in i.objects){j=i.objects[g];if(j.elementClass==JXG.OBJECT_CLASS_POINT){e(j,k.point)}else{if(j.elementClass==JXG.OBJECT_CLASS_LINE){e(j,k.line);for(f in j.ticks){f.majorTicks=k.line.ticks.majorTicks;f.minTicksDistance=k.line.ticks.minTicksDistance;f.visProp.minorheight=k.line.ticks.minorHeight;f.visProp.majorheight=k.line.ticks.majorHeight}}else{if(j.elementClass==JXG.OBJECT_CLASS_CIRCLE){e(j,k.circle)}else{if(j.type==JXG.OBJECT_TYPE_ANGLE){e(j,k.angle)}else{if(j.type==JXG.OBJECT_TYPE_ARC){e(j,k.arc)}else{if(j.type==JXG.OBJECT_TYPE_POLYGON){e(j,k.polygon)}else{if(j.type==JXG.OBJECT_TYPE_CONIC){e(j,k.conic)}else{if(j.type==JXG.OBJECT_TYPE_CURVE){e(j,k.curve)}else{if(j.type==JXG.OBJECT_TYPE_SECTOR){j.arc.visProp.fillcolor=k.sector.fillColor;j.arc.visProp.highlightfillcolor=k.sector.highlightFillColor;j.arc.visProp.fillopacity=k.sector.fillOpacity;j.arc.visProp.highlightfillopacity=k.sector.highlightFillOpacity}}}}}}}}}}i.fullUpdate();if(h&&!i.hasGrid){i.removeGrids(i)}else{if(!h&&i.hasGrid){i.create("grid",[])}}};JXG.useBlackWhiteOptions=function(e){var f=JXG.Options;f.point.fillColor=JXG.rgb2bw(f.point.fillColor);f.point.highlightFillColor=JXG.rgb2bw(f.point.highlightFillColor);f.point.strokeColor=JXG.rgb2bw(f.point.strokeColor);f.point.highlightStrokeColor=JXG.rgb2bw(f.point.highlightStrokeColor);f.line.fillColor=JXG.rgb2bw(f.line.fillColor);f.line.highlightFillColor=JXG.rgb2bw(f.line.highlightFillColor);f.line.strokeColor=JXG.rgb2bw(f.line.strokeColor);f.line.highlightStrokeColor=JXG.rgb2bw(f.line.highlightStrokeColor);f.circle.fillColor=JXG.rgb2bw(f.circle.fillColor);f.circle.highlightFillColor=JXG.rgb2bw(f.circle.highlightFillColor);f.circle.strokeColor=JXG.rgb2bw(f.circle.strokeColor);f.circle.highlightStrokeColor=JXG.rgb2bw(f.circle.highlightStrokeColor);f.arc.fillColor=JXG.rgb2bw(f.arc.fillColor);f.arc.highlightFillColor=JXG.rgb2bw(f.arc.highlightFillColor);f.arc.strokeColor=JXG.rgb2bw(f.arc.strokeColor);f.arc.highlightStrokeColor=JXG.rgb2bw(f.arc.highlightStrokeColor);f.polygon.fillColor=JXG.rgb2bw(f.polygon.fillColor);f.polygon.highlightFillColor=JXG.rgb2bw(f.polygon.highlightFillColor);f.sector.fillColor=JXG.rgb2bw(f.sector.fillColor);f.sector.highlightFillColor=JXG.rgb2bw(f.sector.highlightFillColor);f.curve.strokeColor=JXG.rgb2bw(f.curve.strokeColor);f.grid.gridColor=JXG.rgb2bw(f.grid.gridColor);JXG.useStandardOptions(e)};JXG.JSXGraph={licenseText:"JSXGraph v0.94 Copyright (C) see http://jsxgraph.org",boards:{},elements:{},rendererType:(function(){var g,e;if(JXG.supportsSVG()){JXG.Options.renderer="svg"}else{if(JXG.supportsVML()){JXG.Options.renderer="vml";function f(){document.body.scrollLeft;document.body.scrollTop}document.onmousemove=f}else{JXG.Options.renderer="canvas"}}e=JXG.rendererFiles[JXG.Options.renderer].split(",");for(g=0;g<e.length;g++){(function(h){JXG.require(JXG.requirePath+h+".js")})(e[g])}return JXG.Options.renderer})(),initBoard:function(p,m){var u,t,s,i,g,q,v,j,e,k,o,n,A,r,l,f,z;j=JXG.getDimensions(p);if(typeof m=="undefined"){m={}}if(typeof m.boundingbox!="undefined"){e=m.boundingbox;q=parseInt(j.width);v=parseInt(j.height);if(m.keepaspectratio){i=q/(e[2]-e[0]);g=v/(-e[3]+e[1]);if(Math.abs(i)<Math.abs(g)){g=Math.abs(i)*g/Math.abs(g)}else{i=Math.abs(g)*i/Math.abs(i)}}else{i=q/(e[2]-e[0]);g=v/(-e[3]+e[1])}t=-i*e[0];s=g*e[1]}else{t=((typeof m.originX)=="undefined"?150:m.originX);s=((typeof m.originY)=="undefined"?150:m.originY);i=((typeof m.unitX)=="undefined"?50:m.unitX);g=((typeof m.unitY)=="undefined"?50:m.unitY)}k=((typeof m.zoomfactor)=="undefined"?1:m.zoom);o=k*((typeof m.zoomX)=="undefined"?1:m.zoomX);n=k*((typeof m.zoomY)=="undefined"?1:m.zoomY);A=((typeof m.showCopyright)=="undefined"?JXG.Options.showCopyright:m.showCopyright);f=((typeof m.zoom)=="undefined"?JXG.Options.zoom.wheel:m.zoom);z=((typeof m.pan)=="undefined"?JXG.Options.pan:m.pan);if(JXG.Options.renderer=="svg"){u=new JXG.SVGRenderer(document.getElementById(p))}else{if(JXG.Options.renderer=="vml"){u=new JXG.VMLRenderer(document.getElementById(p))}else{if(JXG.Options.renderer=="silverlight"){u=new JXG.SilverlightRenderer(document.getElementById(p),j.width,j.height)}else{u=new JXG.CanvasRenderer(document.getElementById(p))}}}l=new JXG.Board(p,u,"",[t,s],o,n,i,g,j.width,j.height,A);this.boards[l.id]=l;l.keepaspectratio=m.keepaspectratio;l.options.zoom.wheel=f;l.options.pan=z;l.suspendUpdate();l.initInfobox();if(m.axis){l.defaultAxes={};l.defaultAxes.x=l.create("axis",[[0,0],[1,0]],{ticks:{drawZero:true}});l.defaultAxes.y=l.create("axis",[[0,0],[0,1]],{ticks:{drawZero:l.options.axis.ticks.drawZero}})}if(m.grid){l.create("grid",[])}if(typeof m.shownavigation!="undefined"){m.showNavigation=m.shownavigation}r=((typeof m.showNavigation)=="undefined"?l.options.showNavigation:m.showNavigation);if(r){l.renderer.drawZoomBar(l)}l.unsuspendUpdate();return l},loadBoardFromFile:function(h,e,j){var i,f,g;if(JXG.Options.renderer=="svg"){i=new JXG.SVGRenderer(document.getElementById(h))}else{if(JXG.Options.renderer=="vml"){i=new JXG.VMLRenderer(document.getElementById(h))}else{if(JXG.Options.renderer=="silverlight"){i=new JXG.SilverlightRenderer(document.getElementById(h),g.width,g.height)}else{i=new JXG.CanvasRenderer(document.getElementById(h))}}}g=JXG.getDimensions(h);f=new JXG.Board(h,i,"",[150,150],1,1,50,50,g.width,g.height);f.initInfobox();JXG.FileReader.parseFileContent(e,f,j);if(f.options.showNavigation){f.renderer.drawZoomBar(f)}this.boards[f.id]=f;return f},loadBoardFromString:function(h,e,j){var i,g,f;if(JXG.Options.renderer=="svg"){i=new JXG.SVGRenderer(document.getElementById(h))}else{if(JXG.Options.renderer=="vml"){i=new JXG.VMLRenderer(document.getElementById(h))}else{if(JXG.Options.renderer=="silverlight"){i=new JXG.SilverlightRenderer(document.getElementById(h),g.width,g.height)}else{i=new JXG.CanvasRenderer(document.getElementById(h))}}}g=JXG.getDimensions(h);f=new JXG.Board(h,i,"",[150,150],1,1,50,50,g.width,g.height);f.initInfobox();JXG.FileReader.parseString(e,f,j,true);if(f.options.showNavigation){f.renderer.drawZoomBar(f)}this.boards[f.id]=f;return f},freeBoard:function(g){var f,e;if(typeof(g)=="string"){g=this.boards[g]}g.removeEventHandlers();for(f in g.objects){g.removeObject(g.objects[f])}while(g.containerObj.firstChild){g.containerObj.removeChild(g.containerObj.firstChild)}for(f in g.objects){delete (g.objects[f])}delete (g.renderer);delete (g.algebra);g.jc.creator.clearCache();delete (g.jc);delete (this.boards[g.id])},registerElement:function(e,f){e=e.toLowerCase();this.elements[e]=f;if(JXG.Board.prototype["_"+e]){throw new Error("JSXGraph: Can't create wrapper method in JXG.Board because member '_"+e+"' already exists'")}JXG.Board.prototype["_"+e]=function(h,g){return this.create(e,h,g)}},unregisterElement:function(e){delete (this.elements[e.toLowerCase()]);delete (JXG.Board.prototype["_"+e.toLowerCase()])}};JXG.OBJECT_TYPE_ARC=1;JXG.OBJECT_TYPE_ARROW=2;JXG.OBJECT_TYPE_AXIS=3;JXG.OBJECT_TYPE_AXISPOINT=4;JXG.OBJECT_TYPE_TICKS=5;JXG.OBJECT_TYPE_CIRCLE=6;JXG.OBJECT_TYPE_CONIC=7;JXG.OBJECT_TYPE_CURVE=8;JXG.OBJECT_TYPE_GLIDER=9;JXG.OBJECT_TYPE_IMAGE=10;JXG.OBJECT_TYPE_LINE=11;JXG.OBJECT_TYPE_POINT=12;JXG.OBJECT_TYPE_SLIDER=13;JXG.OBJECT_TYPE_CAS=14;JXG.OBJECT_TYPE_GXTCAS=15;JXG.OBJECT_TYPE_POLYGON=16;JXG.OBJECT_TYPE_SECTOR=17;JXG.OBJECT_TYPE_TEXT=18;JXG.OBJECT_TYPE_ANGLE=19;JXG.OBJECT_TYPE_INTERSECTION=20;JXG.OBJECT_TYPE_TURTLE=21;JXG.OBJECT_TYPE_VECTOR=22;JXG.OBJECT_TYPE_OPROJECT=23;JXG.OBJECT_CLASS_POINT=1;JXG.OBJECT_CLASS_LINE=2;JXG.OBJECT_CLASS_CIRCLE=3;JXG.OBJECT_CLASS_CURVE=4;JXG.OBJECT_CLASS_AREA=5;JXG.OBJECT_CLASS_OTHER=6;JXG.GeometryElement=function(i,e,h,j){var f,g;this.needsUpdate=true;this.isDraggable=false;this.isReal=true;this.childElements={};this.hasLabel=false;this.highlighted=false;this.notExistingParents={};this.traces={};this.numTraces=0;this.transformations=[];this.baseElement=null;this.descendants={};this.ancestors={};this.symbolic={};this.elType="";this.dump=true;this.subs={};this.stdform=[1,0,0,0,1,1,0,0];this.methodMap={setLabel:"setLabelText",getName:"getName"};this.quadraticform=[[1,0,0],[0,1,0],[0,0,1]];this.visProp={};this.eventHandlers={};this.mouseover=false;if(arguments.length>0){this.board=i;this.type=h;this.elementClass=j||JXG.OBJECT_CLASS_OTHER;this.id=e.id;f=e.name;if(!JXG.exists(f)){f=this.board.generateName(this)}this.board.elementsByName[f]=this;this.name=f;this.needsRegularUpdate=e.needsregularupdate;JXG.clearVisPropOld(this);e=this.resolveShortcuts(e);for(g in e){this._set(g,e[g])}this.visProp.draft=e.draft&&e.draft.draft;this.visProp.gradientangle="270";this.visProp.gradientsecondopacity=this.visProp.fillopacity;this.visProp.gradientpositionx=0.5;this.visProp.gradientpositiony=0.5}};JXG.extend(JXG.GeometryElement.prototype,{addChild:function(g){var f,e;this.childElements[g.id]=g;this.addDescendants(g);g.ancestors[this.id]=this;for(f in this.descendants){this.descendants[f].ancestors[this.id]=this;for(e in this.ancestors){this.descendants[f].ancestors[this.ancestors[e].id]=this.ancestors[e]}}for(f in this.ancestors){for(e in this.descendants){this.ancestors[f].descendants[this.descendants[e].id]=this.descendants[e]}}return this},addDescendants:function(f){var e;this.descendants[f.id]=f;for(e in f.childElements){this.addDescendants(f.childElements[e])}return this},countChildren:function(){var g,e=0,f;f=this.childElements;for(g in f){if(f.hasOwnProperty(g)&&g.indexOf("Label")<0){e++}}return e},getName:function(){return this.name},draggable:function(){return this.isDraggable&&!this.visProp.fixed&&!this.visProp.frozen&&this.type!=JXG.OBJECT_TYPE_GLIDER},generatePolynomial:function(){return[]},animate:function(h,g,q){q=q||{};var e,f,k=35,l=Math.ceil(g/(k*1)),j,n=this;this.animationData={};var o=function(w,v,t){var u,s,r,p,i;u=JXG.rgb2hsv(w);s=JXG.rgb2hsv(v);r=(s[0]-u[0])/(1*l);p=(s[1]-u[1])/(1*l);i=(s[2]-u[2])/(1*l);n.animationData[t]=new Array(l);for(j=0;j<l;j++){n.animationData[t][l-j-1]=JXG.hsv2rgb(u[0]+(j+1)*r,u[1]+(j+1)*p,u[2]+(j+1)*i)}},m=function(t,i,r){t=parseFloat(t);i=parseFloat(i);if(isNaN(t)||isNaN(i)){return}var p=(i-t)/(1*l);n.animationData[r]=new Array(l);for(j=0;j<l;j++){n.animationData[r][l-j-1]=t+(j+1)*p}};for(e in h){f=e.toLowerCase();switch(f){case"strokecolor":case"fillcolor":o(this.visProp[f],h[e],f);break;case"strokeopacity":case"strokewidth":case"fillopacity":m(this.visProp[f],h[e],f);break}}this.animationCallback=q.callback;this.board.addAnimation(this);return this},update:function(){if(this.visProp.trace){this.cloneToBackground(true)}return this},updateRenderer:function(){return this},hideElement:function(){this.visProp.visible=false;this.board.renderer.hide(this);if(this.label!=null&&this.hasLabel){this.label.hiddenByParent=true;if(this.label.content.visProp.visible){this.board.renderer.hide(this.label.content)}}return this},showElement:function(){this.visProp.visible=true;this.board.renderer.show(this);if(this.label!=null&&this.hasLabel&&this.label.hiddenByParent){this.label.hiddenByParent=false;if(this.label.content.visProp.visible){this.board.renderer.show(this.label.content)}}return this},_set:function(f,e){f=f.toLocaleLowerCase();if(this.visProp.hasOwnProperty(f)&&f.indexOf("color")>=0&&JXG.isString(e)&&e.length==9&&e.charAt(0)==="#"){e=JXG.rgba2rgbo(e);this.visProp[f]=e[0];this.visProp[f.replace("color","opacity")]=e[1]}else{this.visProp[f]=e}},resolveShortcuts:function(g){var f,e;for(f in JXG.Options.shortcuts){if(JXG.exists(g[f])){for(e=0;e<JXG.Options.shortcuts[f].length;e++){if(!JXG.exists(g[JXG.Options.shortcuts[f][e]])){g[JXG.Options.shortcuts[f][e]]=g[f]}}}}return g},setLabelText:function(e){e=e.replace(/</g,"&lt;").replace(/>/g,"&gt;");if(this.label!==null){this.label.content.setText(e)}return this},setAttribute:JXG.shortcut(JXG.GeometryElement.prototype,"setProperty"),setProperty:function(){var j,h,k,e,f,l,g={};for(j=0;j<arguments.length;j++){e=arguments[j];if(JXG.isString(e)){l=e.split(":");g[JXG.trim(l[0])]=JXG.trim(l[1])}else{if(!JXG.isArray(e)){JXG.extend(g,e)}else{g[e[0]]=e[1]}}}g=this.resolveShortcuts(g);for(j in g){h=j.replace(/\s+/g,"").toLowerCase();k=g[j];switch(h){case"name":delete this.board.elementsByName[this.name];this.name=k;this.board.elementsByName[this.name]=this;break;case"needsregularupdate":this.needsRegularUpdate=!(k=="false"||k==false);this.board.renderer.setBuffering(this,this.needsRegularUpdate?"auto":"static");break;case"labelcolor":k=JXG.rgba2rgbo(k);f=k[1];k=k[0];if(f==0){if(this.label!=null&&this.hasLabel){this.label.content.hideElement()}}if(this.label!=null&&this.hasLabel){this.label.color=k;this.board.renderer.setObjectStrokeColor(this.label.content,k,f)}if(this.type==JXG.OBJECT_TYPE_TEXT){this.visProp.strokecolor=k;this.visProp.strokeopacity=f;this.board.renderer.setObjectStrokeColor(this,this.visProp.strokecolor,this.visProp.strokeopacity)}break;case"infoboxtext":if(typeof(k)=="string"){this.infoboxText=k}else{this.infoboxText=false}break;case"visible":if(k=="false"||k==false){this.visProp.visible=false;this.hideElement()}else{if(k=="true"||k==true){this.visProp.visible=true;this.showElement()}}break;case"face":if(this.elementClass==JXG.OBJECT_CLASS_POINT){this.visProp.face=k;this.board.renderer.changePointStyle(this)}break;case"trace":if(k=="false"||k==false){this.clearTrace();this.visProp.trace=false}else{this.visProp.trace=true}break;case"gradient":this.visProp.gradient=k;this.board.renderer.setGradient(this);break;case"gradientsecondcolor":k=JXG.rgba2rgbo(k);this.visProp.gradientsecondcolor=k[0];this.visProp.gradientsecondopacity=k[1];this.board.renderer.updateGradient(this);break;case"gradientsecondopacity":this.visProp.gradientsecondopacity=k;this.board.renderer.updateGradient(this);break;case"withlabel":this.visProp.withlabel=k;if(!k){if(this.label&&this.label.content&&this.hasLabel){this.label.content.hideElement()}}else{if(this.label&&this.label.content){if(this.visProp.visible){this.label.content.showElement()}}else{this.createLabel();if(!this.visProp.visible){this.label.content.hideElement()}}}this.hasLabel=k;break;default:if(JXG.exists(this.visProp[h])&&(!JXG.Validator[h]||(JXG.Validator[h]&&JXG.Validator[h](k))||(JXG.Validator[h]&&JXG.isFunction(k)&&JXG.Validator[h](k())))){k=k.toLowerCase&&k.toLowerCase()==="false"?false:k;this._set(h,k)}break}}if(this.type==JXG.OBJECT_TYPE_AXIS){this.board.fullUpdate()}this.board.update(this);return this},getAttribute:JXG.shortcut(JXG.GeometryElement.prototype,"getProperty"),getProperty:function(f){var e;f=f.toLowerCase();switch(f){case"needsregularupdate":e=this.needsRegularUpdate;break;case"labelcolor":e=this.label.color;break;case"infoboxtext":e=this.infoboxText;break;case"withlabel":e=this.hasLabel;break;default:e=this.visProp[f];break}return e},setDash:function(e){this.setProperty({dash:e});return this},prepareUpdate:function(){this.needsUpdate=true;return this},remove:function(){this.board.renderer.remove(this.board.renderer.getElementById(this.id));if(this.hasLabel){this.board.renderer.remove(this.board.renderer.getElementById(this.label.content.id))}return this},getTextAnchor:function(){return new JXG.Coords(JXG.COORDS_BY_USER,[0,0],this.board)},getLabelAnchor:function(){return new JXG.Coords(JXG.COORDS_BY_USER,[0,0],this.board)},setStraight:function(e,f){return this},setArrow:function(f,e){this.visProp.firstarrow=f;this.visProp.lastarrow=e;this.prepareUpdate().update();return this},createGradient:function(){if(this.visProp.gradient==="linear"||this.visProp.gradient==="radial"){this.board.renderer.setGradient(this)}},createLabel:function(){var e={};e=JXG.deepCopy(this.visProp.label,null);e.id=this.id+"Label";e.isLabel=true;e.visible=this.visProp.visible;e.anchor=this;this.nameHTML=JXG.GeonextParser.replaceSup(JXG.GeonextParser.replaceSub(this.name));this.label={};if(this.visProp.withlabel){this.label.relativeCoords=[0,0];this.label.content=JXG.createText(this.board,[this.label.relativeCoords[0],-this.label.relativeCoords[1],this.nameHTML],e);this.label.content.dump=false;this.label.color=this.label.content.visProp.strokecolor;if(!this.visProp.visible){this.label.hiddenByParent=true;this.label.content.visProp.visible=false}this.hasLabel=true}return this},highlight:function(){if(!this.highlighted){this.highlighted=true;this.board.renderer.highlight(this)}return this},noHighlight:function(){if(this.highlighted){this.highlighted=false;this.board.renderer.noHighlight(this)}return this},clearTrace:function(){var e;for(e in this.traces){this.board.renderer.remove(this.traces[e])}this.numTraces=0;return this},cloneToBackground:function(){return this},bounds:function(){},normalize:function(){this.stdform=JXG.Math.normalize(this.stdform);return this},toJSON:function(){var f='{"name":'+this.name;f+=', "id":'+this.id;var g=[];for(var e in this.visProp){if(this.visProp[e]!=null){g.push('"'+e+'":'+this.visProp[e])}}f+=', "visProp":{'+g.toString()+"}";f+="}";return f},highlightStrokeColor:function(e){this.setProperty({highlightStrokeColor:e});return this},strokeColor:function(e){this.setProperty({strokeColor:e});return this},strokeWidth:function(e){this.setProperty({strokeWidth:e});return this},fillColor:function(e){this.setProperty({fillColor:e});return this},highlightFillColor:function(e){this.setProperty({highlightFillColor:e});return this},labelColor:function(e){this.setProperty({labelColor:e});return this},dash:function(e){this.setProperty({dash:e});return this},visible:function(e){this.setProperty({visible:e});return this},shadow:function(e){this.setProperty({shadow:e});return this},getType:function(){return this.elType},getParents:function(){return this.parents},getAttributes:function(){var e=JXG.deepCopy(this.visProp),f=["attractors","attractordistance","snatchdistance","traceattributes","frozen","shadow","gradientangle","gradientsecondopacity","gradientpositionx","gradientpositiony","needsregularupdate","zoom","layer","labeloffsets"],g;e.id=this.id;e.name=this.name;for(g=0;g<f.length;g++){delete e[f[g]]}return e},hasPoint:function(e,f){return false},triggerEventHandlers:function(f){var e;if(JXG.isArray(this.eventHandlers[f])){for(e=0;e<this.eventHandlers[f].length;e++){this.eventHandlers[f][e].call(this)}}},on:function(f,e){if(!JXG.isArray(this.eventHandlers[f])){this.eventHandlers[f]=[]}this.eventHandlers[f].push(e)},addEvent:JXG.shortcut(JXG.GeometryElement.prototype,"on"),off:function(g,f){var e;if(!g||!JXG.isArray(this.eventHandlers[g])){return}if(f){e=JXG.indexOf(this.eventHandlers[g],f);if(e>-1){this.eventHandlers[g].splice(e,1)}}else{this.eventHandlers[g].length=0}},removeEvent:JXG.shortcut(JXG.GeometryElement.prototype,"off")});JXG.COORDS_BY_USER=1;JXG.COORDS_BY_SCREEN=2;JXG.Coords=function(g,f,e){this.board=e;this.usrCoords=[];this.scrCoords=[];this.setCoordinates(g,f)};JXG.extend(JXG.Coords.prototype,{normalizeUsrCoords:function(){var e=JXG.Math.eps;if(Math.abs(this.usrCoords[0])>e){this.usrCoords[1]/=this.usrCoords[0];this.usrCoords[2]/=this.usrCoords[0];this.usrCoords[0]=1}},usr2screen:function(i){var h=Math.round,e=this.board,g=this.usrCoords,f=e.origin.scrCoords;if(i===null||i){this.scrCoords[0]=h(g[0]);this.scrCoords[1]=h(g[0]*f[1]+g[1]*e.unitX);this.scrCoords[2]=h(g[0]*f[2]-g[2]*e.unitY)}else{this.scrCoords[0]=g[0];this.scrCoords[1]=g[0]*f[1]+g[1]*e.unitX;this.scrCoords[2]=g[0]*f[2]-g[2]*e.unitY}},screen2usr:function(){var g=this.board.origin.scrCoords,f=this.scrCoords,e=this.board;this.usrCoords[0]=1;this.usrCoords[1]=(f[1]-g[1])/e.unitX;this.usrCoords[2]=(g[2]-f[2])/e.unitY},distance:function(g,k){var h=0,l,e=this.usrCoords,j=this.scrCoords,i;if(g===JXG.COORDS_BY_USER){l=k.usrCoords;i=e[0]-l[0];h=i*i;if(h>JXG.Math.eps){return Number.POSITIVE_INFINITY}i=e[1]-l[1];h+=i*i;i=e[2]-l[2];h+=i*i}else{l=k.scrCoords;i=j[1]-l[1];h+=i*i;i=j[2]-l[2];h+=i*i}return Math.sqrt(h)},setCoordinates:function(f,i,g){var e=this.usrCoords,h=this.scrCoords;if(f===JXG.COORDS_BY_USER){if(i.length===2){e[0]=1;e[1]=i[0];e[2]=i[1]}else{e[0]=i[0];e[1]=i[1];e[2]=i[2];this.normalizeUsrCoords()}this.usr2screen(g)}else{h[1]=i[0];h[2]=i[1];this.screen2usr()}return this}});JXG.Point=function(f,g,e){this.constructor(f,e,JXG.OBJECT_TYPE_POINT,JXG.OBJECT_CLASS_POINT);if(g==null){g=[0,0]}this.coords=new JXG.Coords(JXG.COORDS_BY_USER,g,this.board);this.initialCoords=new JXG.Coords(JXG.COORDS_BY_USER,g,this.board);this.position=null;this.onPolygon=false;this.slideObject=null;this.Xjc=null;this.Yjc=null;this.methodMap=JXG.deepCopy(this.methodMap,{move:"moveTo",glide:"makeGlider",X:"X",Y:"Y",free:"free",setPosition:"setGliderPosition"});this.group=[];this.elType="point";this.id=this.board.setId(this,"P");this.board.renderer.drawPoint(this);this.board.finalizeAdding(this);this.createLabel()};JXG.Point.prototype=new JXG.GeometryElement();JXG.extend(JXG.Point.prototype,{hasPoint:function(f,h){var e=this.coords.scrCoords,g;g=parseFloat(this.visProp.size);if(g<this.board.options.precision.hasPoint){g=this.board.options.precision.hasPoint}return((Math.abs(e[1]-f)<g+2)&&(Math.abs(e[2]-h))<g+2)},updateConstraint:function(){return this},update:function(e){if(!this.needsUpdate){return this}if(typeof e=="undefined"){e=false}if(this.type==JXG.OBJECT_TYPE_GLIDER){if(e){this.updateGliderFromParent()}else{this.updateGlider()}}if(this.type==JXG.OBJECT_TYPE_CAS||this.type==JXG.OBJECT_TYPE_AXISPOINT){this.updateConstraint()}this.updateTransform();if(this.visProp.trace){this.cloneToBackground(true)}return this},updateGlider:function(){var h,e,g,k,f,j,m,l;if(this.slideObject.elementClass==JXG.OBJECT_CLASS_CIRCLE){this.coords=JXG.Math.Geometry.projectPointToCircle(this,this.slideObject,this.board);this.position=JXG.Math.Geometry.rad([this.slideObject.center.X()+1,this.slideObject.center.Y()],this.slideObject.center,this)}else{if(this.slideObject.elementClass==JXG.OBJECT_CLASS_LINE){if(this.onPolygon){e=this.slideObject.point1.coords.usrCoords;g=this.slideObject.point2.coords.usrCoords;h=1;k=g[h]-e[h];if(Math.abs(k)<JXG.Math.eps){h=2;k=g[h]-e[h]}m=JXG.Math.Geometry.projectPointToLine(this,this.slideObject,this.board);l=(m.usrCoords[h]-e[h])/k;j=this.slideObject.parentPolygon;if(l<0){for(h=0;h<j.borders.length;h++){if(this.slideObject==j.borders[h]){this.slideObject=j.borders[(h-1+j.borders.length)%j.borders.length];break}}}else{if(l>1){for(h=0;h<j.borders.length;h++){if(this.slideObject==j.borders[h]){this.slideObject=j.borders[(h+1+j.borders.length)%j.borders.length];break}}}}}e=this.slideObject.point1.coords;g=this.slideObject.point2.coords;k=e.distance(JXG.COORDS_BY_USER,g);e=e.usrCoords.slice(0);g=g.usrCoords.slice(0);if(k<JXG.Math.eps){this.coords.setCoordinates(JXG.COORDS_BY_USER,e);this.position=0}else{if(k==Number.POSITIVE_INFINITY){k=1/JXG.Math.eps;if(Math.abs(g[0])<JXG.Math.eps){k/=JXG.Math.Geometry.distance([0,0,0],g);g=[1,e[1]+g[1]*k,e[2]+g[2]*k]}else{k/=JXG.Math.Geometry.distance([0,0,0],e);e=[1,g[1]+e[1]*k,g[2]+e[2]*k]}}h=1;k=g[h]-e[h];if(Math.abs(k)<JXG.Math.eps){h=2;k=g[h]-e[h]}this.coords=JXG.Math.Geometry.projectPointToLine(this,this.slideObject,this.board);this.position=(this.coords.usrCoords[h]-e[h])/k}if(this.visProp.snapwidth>0&&Math.abs(this._smax-this._smin)>=JXG.Math.eps){if(this.position<0){this.position=0}if(this.position>1){this.position=1}f=this.position*(this._smax-this._smin)+this._smin;f=Math.round(f/this.visProp.snapwidth)*this.visProp.snapwidth;this.position=(f-this._smin)/(this._smax-this._smin);this.update(true)}e=this.slideObject.point1.coords.usrCoords;if(!this.slideObject.visProp.straightfirst&&Math.abs(e[0])>JXG.Math.eps&&this.position<0){this.coords.setCoordinates(JXG.COORDS_BY_USER,e);this.position=0}g=this.slideObject.point2.coords.usrCoords;if(!this.slideObject.visProp.straightlast&&Math.abs(g[0])>JXG.Math.eps&&this.position>1){this.coords.setCoordinates(JXG.COORDS_BY_USER,g);this.position=1}}else{if(this.slideObject.type==JXG.OBJECT_TYPE_TURTLE){this.updateConstraint();this.coords=JXG.Math.Geometry.projectPointToTurtle(this,this.slideObject,this.board)}else{if(this.slideObject.elementClass==JXG.OBJECT_CLASS_CURVE){this.updateConstraint();this.coords=JXG.Math.Geometry.projectPointToCurve(this,this.slideObject,this.board)}else{if(this.slideObject.elementClass==JXG.OBJECT_CLASS_POINT){this.coords=JXG.Math.Geometry.projectPointToPoint(this,this.slideObject,this.board)}}}}}},updateGliderFromParent:function(){var e,f,g,h;if(this.slideObject.elementClass==JXG.OBJECT_CLASS_CIRCLE){g=this.slideObject.Radius();this.coords.setCoordinates(JXG.COORDS_BY_USER,[this.slideObject.center.X()+g*Math.cos(this.position),this.slideObject.center.Y()+g*Math.sin(this.position)])}else{if(this.slideObject.elementClass==JXG.OBJECT_CLASS_LINE){e=this.slideObject.point1.coords;f=this.slideObject.point2.coords;h=e.distance(JXG.COORDS_BY_USER,f);e=e.usrCoords.slice(0);f=f.usrCoords.slice(0);if(h==Number.POSITIVE_INFINITY){h=1/JXG.Math.eps;if(Math.abs(f[0])<JXG.Math.eps){h/=JXG.Math.Geometry.distance([0,0,0],f);f=[1,e[1]+f[1]*h,e[2]+f[2]*h]}else{h/=JXG.Math.Geometry.distance([0,0,0],e);e=[1,f[1]+e[1]*h,f[2]+e[2]*h]}}this.coords.setCoordinates(JXG.COORDS_BY_USER,[e[1]+this.position*(f[1]-e[1]),e[2]+this.position*(f[2]-e[2])])}else{if(this.slideObject.type==JXG.OBJECT_TYPE_TURTLE){this.coords.setCoordinates(JXG.COORDS_BY_USER,[this.slideObject.Z(this.position),this.slideObject.X(this.position),this.slideObject.Y(this.position)]);this.updateConstraint();this.coords=JXG.Math.Geometry.projectPointToTurtle(this,this.slideObject,this.board)}else{if(this.slideObject.elementClass==JXG.OBJECT_CLASS_CURVE){this.coords.setCoordinates(JXG.COORDS_BY_USER,[this.slideObject.Z(this.position),this.slideObject.X(this.position),this.slideObject.Y(this.position)]);this.updateConstraint();this.coords=JXG.Math.Geometry.projectPointToCurve(this,this.slideObject,this.board)}else{if(this.slideObject.elementClass==JXG.OBJECT_CLASS_POINT){this.coords=JXG.Math.Geometry.projectPointToPoint(this,this.slideObject,this.board)}}}}}},updateRenderer:function(){if(!this.needsUpdate){return this}if(this.visProp.visible){var e=this.isReal;this.isReal=(!isNaN(this.coords.usrCoords[1]+this.coords.usrCoords[2]));this.isReal=(Math.abs(this.coords.usrCoords[0])>JXG.Math.eps)?this.isReal:false;if(this.isReal){if(e!=this.isReal){this.board.renderer.show(this);if(this.hasLabel&&this.label.content.visProp.visible){this.board.renderer.show(this.label.content)}}this.board.renderer.updatePoint(this)}else{if(e!=this.isReal){this.board.renderer.hide(this);if(this.hasLabel&&this.label.content.visProp.visible){this.board.renderer.hide(this.label.content)}}}}if(this.hasLabel&&this.visProp.visible&&this.label.content&&this.label.content.visProp.visible&&this.isReal){this.label.content.update();this.board.renderer.updateText(this.label.content)}this.needsUpdate=false;return this},X:function(){return this.coords.usrCoords[1]},Y:function(){return this.coords.usrCoords[2]},Z:function(){return this.coords.usrCoords[0]},XEval:function(){return this.coords.usrCoords[1]},YEval:function(){return this.coords.usrCoords[2]},ZEval:function(){return this.coords.usrCoords[0]},bounds:function(){return this.coords.usrCoords.slice(1).concat(this.coords.usrCoords.slice(1))},Dist:function(g){var h,j=g.coords.usrCoords,e=this.coords.usrCoords,i;i=e[0]-j[0];h=i*i;i=e[1]-j[1];h+=i*i;i=e[2]-j[2];h+=i*i;return Math.sqrt(h)},handleSnapToGrid:function(){var e,h,g=this.visProp.snapsizex,f=this.visProp.snapsizey;if(this.visProp.snaptogrid){e=this.coords.usrCoords[1];h=this.coords.usrCoords[2];if(g<=0&&this.board.defaultAxes&&this.board.defaultAxes.x.defaultTicks){g=this.board.defaultAxes.x.defaultTicks.ticksDelta*(this.board.defaultAxes.x.defaultTicks.visProp.minorticks+1)}if(f<=0&&this.board.defaultAxes&&this.board.defaultAxes.y.defaultTicks){f=this.board.defaultAxes.y.defaultTicks.ticksDelta*(this.board.defaultAxes.y.defaultTicks.visProp.minorticks+1)}if(g>0&&f>0){this.coords=new JXG.Coords(JXG.COORDS_BY_USER,[Math.round(e/g)*g,Math.round(h/f)*f],this.board)}}return this},handleSnapToPoints:function(){var g,j,e,h=0,f=Infinity,i=null;if(this.visProp.snaptopoints){for(g in this.board.objects){j=this.board.objects[g];if(j.elementClass==JXG.OBJECT_CLASS_POINT&&j!==this&&j.visProp.visible){e=JXG.Math.Geometry.projectPointToPoint(this,j,this.board);h=e.distance(JXG.COORDS_BY_USER,this.coords);if(h<this.visProp.attractordistance&&h<f){f=h;i=e}}}if(i!=null){this.coords.setCoordinates(JXG.COORDS_BY_USER,i.usrCoords)}}return this},handleAttractors:function(){var e=this.visProp.attractors.length,j,g,h,f,k=0;if(this.visProp.attractordistance==0){return}j=false;for(g=0;g<e;g++){h=JXG.getRef(this.board,this.visProp.attractors[g]);if(!JXG.exists(h)||h===this){continue}if(h.elementClass==JXG.OBJECT_CLASS_POINT){f=JXG.Math.Geometry.projectPointToPoint(this,h,this.board)}else{if(h.elementClass==JXG.OBJECT_CLASS_LINE){f=JXG.Math.Geometry.projectPointToLine(this,h,this.board)}else{if(h.elementClass==JXG.OBJECT_CLASS_CIRCLE){f=JXG.Math.Geometry.projectPointToCircle(this,h,this.board)}else{if(h.elementClass==JXG.OBJECT_CLASS_CURVE){f=JXG.Math.Geometry.projectPointToCurve(this,h,this.board)}else{if(h.type==JXG.OBJECT_TYPE_TURTLE){f=JXG.Math.Geometry.projectPointToTurtle(this,h,this.board)}}}}}k=f.distance(JXG.COORDS_BY_USER,this.coords);if(k<this.visProp.attractordistance){j=true;if(!(this.type==JXG.OBJECT_TYPE_GLIDER&&this.slideObject==h)){this.makeGlider(h)}break}else{if(h==this.slideObject&&k>=this.visProp.snatchdistance){this.type=JXG.OBJECT_TYPE_POINT}}}return this},setPositionDirectly:function(e,l,j){var h,o,n,g,f,k=this.coords,m;this.coords=new JXG.Coords(e,[l,j],this.board);this.handleSnapToGrid();this.handleSnapToPoints();this.handleAttractors();if(this.group.length!=0){o=this.coords.usrCoords[1]-k.usrCoords[1];n=this.coords.usrCoords[2]-k.usrCoords[2];for(h=0;h<this.group.length;h++){for(g in this.group[h].objects){f=this.group[h].objects[g];f.initialCoords=new JXG.Coords(JXG.COORDS_BY_USER,[f.initialCoords.usrCoords[1]+o,f.initialCoords.usrCoords[2]+n],this.board)}}this.group[this.group.length-1].dX=this.coords.scrCoords[1]-k.scrCoords[1];this.group[this.group.length-1].dY=this.coords.scrCoords[2]-k.scrCoords[2];this.group[this.group.length-1].update(this)}else{for(h=this.transformations.length-1;h>=0;h--){if(e==JXG.COORDS_BY_SCREEN){m=(new JXG.Coords(e,[l,j],this.board)).usrCoords}else{m=[1,l,j]}this.initialCoords=new JXG.Coords(JXG.COORDS_BY_USER,JXG.Math.matVecMult(JXG.Math.inverse(this.transformations[h].matrix),m),this.board)}this.update()}return this},setPositionByTransform:function(h,e,g){var f=this.board.create("transform",[e,g],{type:"translate"});if(this.transformations.length>0&&this.transformations[this.transformations.length-1].isNumericMatrix){this.transformations[this.transformations.length-1].melt(f)}else{this.addTransform(this,f)}if(this.group.length==0){this.update()}return this},setPosition:function(g,e,f){this.setPositionDirectly(g,e,f);return this},setGliderPosition:function(e){if(this.type=JXG.OBJECT_TYPE_GLIDER){this.position=e;this.board.update()}return this},makeGlider:function(e){this.slideObject=JXG.getRef(this.board,e);this.type=JXG.OBJECT_TYPE_GLIDER;this.elType="glider";this.visProp.snapwidth=-1;this.slideObject.addChild(this);this.isDraggable=true;this.generatePolynomial=function(){return this.slideObject.generatePolynomial(this)};this.updateGlider();return this},free:function(){var e;if(this.type!==JXG.OBJECT_TYPE_GLIDER){if(!this.isDraggable){this.isDraggable=true;this.type=JXG.OBJECT_TYPE_POINT;this.XEval=function(){return this.coords.usrCoords[1]};this.YEval=function(){return this.coords.usrCoords[2]};this.ZEval=function(){return this.coords.usrCoords[0]};this.Xjc=null;this.Yjc=null}else{return}}for(e in this.ancestors){delete this.ancestors[e].descendants[this.id];delete this.ancestors[e].childElements[this.id]}this.ancestors=[];this.slideObject=null;this.elType="point";this.type=JXG.OBJECT_TYPE_POINT},addConstraint:function(j){this.type=JXG.OBJECT_TYPE_CAS;var l=[],e,h,f,g,k=["X","Y"];this.isDraggable=false;for(h=0;h<j.length;h++){f=j[h];if(typeof f=="string"){l[h]=this.board.jc.snippet(f,true,null,true);if(j.length===2){this[k[h]+"jc"]=j[h]}}else{if(typeof f=="function"){l[h]=f}else{if(typeof f=="number"){l[h]=function(i){return function(){return i}}(f)}else{if(typeof f=="object"&&typeof f.Value=="function"){l[h]=(function(i){return function(){return i.Value()}})(f)}}}}l[h].origin=f}if(j.length==1){this.updateConstraint=function(){var i=l[0]();if(JXG.isArray(i)){this.coords.setCoordinates(JXG.COORDS_BY_USER,i)}else{this.coords=i}}}else{if(j.length==2){this.XEval=l[0];this.YEval=l[1];e="this.coords.setCoordinates(JXG.COORDS_BY_USER,[this.XEval(),this.YEval()]);";this.updateConstraint=new Function("",e)}else{this.ZEval=l[0];this.XEval=l[1];this.YEval=l[2];e="this.coords.setCoordinates(JXG.COORDS_BY_USER,[this.ZEval(),this.XEval(),this.YEval()]);";this.updateConstraint=new Function("",e)}}if(!this.board.isSuspendedUpdate){this.prepareUpdate().update().updateRenderer()}return this},updateTransform:function(){if(this.transformations.length==0||this.baseElement==null){return this}var f,e;if(this===this.baseElement){f=this.transformations[0].apply(this.baseElement,"self")}else{f=this.transformations[0].apply(this.baseElement)}this.coords.setCoordinates(JXG.COORDS_BY_USER,f);for(e=1;e<this.transformations.length;e++){this.coords.setCoordinates(JXG.COORDS_BY_USER,this.transformations[e].apply(this))}return this},addTransform:function(h,f){var g,j=JXG.isArray(f)?f:[f],e=j.length;if(this.transformations.length===0){this.baseElement=h}for(g=0;g<e;g++){this.transformations.push(j[g])}return this},startAnimation:function(e,f){if((this.type==JXG.OBJECT_TYPE_GLIDER)&&(typeof this.intervalCode=="undefined")){this.intervalCode=window.setInterval("JXG.JSXGraph.boards['"+this.board.id+"'].objects['"+this.id+"']._anim("+e+", "+f+")",250);if(typeof this.intervalCount=="undefined"){this.intervalCount=0}}return this},stopAnimation:function(){if(typeof this.intervalCode!="undefined"){window.clearInterval(this.intervalCode);delete (this.intervalCode)}return this},moveAlong:function(n,f,o){o=o||{};var m=[],j=35,k=function(q,p){return function(){return n[q][p]}},e=[],h,g,l=f/j;if(JXG.isArray(n)){for(h=0;h<n.length;h++){if(JXG.isPoint(n[h])){e[h]=n[h]}else{e[h]={elementClass:JXG.OBJECT_CLASS_POINT,X:k(h,0),Y:k(h,1)}}}f=f||0;if(f===0){this.setPosition(JXG.COORDS_BY_USER,e[e.length-1].X(),e[e.length-1].Y());return this.board.update(this)}g=JXG.Math.Numerics.Neville(e);for(h=0;h<l;h++){m[h]=[];m[h][0]=g[0]((l-h)/l*g[3]());m[h][1]=g[1]((l-h)/l*g[3]())}this.animationPath=m}else{if(JXG.isFunction(n)){this.animationPath=n;this.animationStart=new Date().getTime()}}this.animationCallback=o.callback;this.board.addAnimation(this);return this},moveTo:function(l,g,q){if(typeof g=="undefined"||g==0){this.setPosition(JXG.COORDS_BY_USER,l[0],l[1]);return this.board.update(this)}q=q||{};var m=35,n=Math.ceil(g/(m*1)),o=new Array(n+1),f=this.coords.usrCoords[1],e=this.coords.usrCoords[2],j=(l[0]-f),h=(l[1]-e),k,p=function(r){if(q.effect&&q.effect=="<>"){return Math.pow(Math.sin((r/(n*1))*Math.PI/2),2)}return r/n};if(Math.abs(j)<JXG.Math.eps&&Math.abs(h)<JXG.Math.eps){return this}for(k=n;k>=0;k--){o[n-k]=[f+j*p(k),e+h*p(k)]}this.animationPath=o;this.animationCallback=q.callback;this.board.addAnimation(this);return this},visit:function(n,g,s){if(typeof s=="number"){s={repeat:s}}else{s=s||{};if(typeof s.repeat=="undefined"){s.repeat=1}}var o=35,p=Math.ceil(g/(o*s.repeat)),q=new Array(s.repeat*(p+1)),f=this.coords.usrCoords[1],e=this.coords.usrCoords[2],l=(n[0]-f),h=(n[1]-e),m,k,r=function(t){var j=(t<p/2?2*t/p:2*(p-t)/p);if(s.effect&&s.effect=="<>"){return Math.pow(Math.sin((j)*Math.PI/2),2)}return j};for(k=0;k<s.repeat;k++){for(m=p;m>=0;m--){q[k*(p+1)+p-m]=[f+l*r(m),e+h*r(m)]}}this.animationPath=q;this.animationCallback=s.callback;this.board.addAnimation(this);return this},_anim:function(o,j){var f,m,k,i,h,g,n=1,e,l;this.intervalCount++;if(this.intervalCount>j){this.intervalCount=0}if(this.slideObject.elementClass==JXG.OBJECT_CLASS_LINE){f=this.slideObject.point1.coords.distance(JXG.COORDS_BY_SCREEN,this.slideObject.point2.coords);m=this.slideObject.getSlope();if(m!="INF"){h=Math.atan(m);k=Math.round((this.intervalCount/j)*f*Math.cos(h));i=Math.round((this.intervalCount/j)*f*Math.sin(h))}else{k=0;i=Math.round((this.intervalCount/j)*f)}if(o<0){g=this.slideObject.point2;if(this.slideObject.point2.coords.scrCoords[1]-this.slideObject.point1.coords.scrCoords[1]>0){n=-1}else{if(this.slideObject.point2.coords.scrCoords[1]-this.slideObject.point1.coords.scrCoords[1]==0){if(this.slideObject.point2.coords.scrCoords[2]-this.slideObject.point1.coords.scrCoords[2]>0){n=-1}}}}else{g=this.slideObject.point1;if(this.slideObject.point1.coords.scrCoords[1]-this.slideObject.point2.coords.scrCoords[1]>0){n=-1}else{if(this.slideObject.point1.coords.scrCoords[1]-this.slideObject.point2.coords.scrCoords[1]==0){if(this.slideObject.point1.coords.scrCoords[2]-this.slideObject.point2.coords.scrCoords[2]>0){n=-1}}}}this.coords.setCoordinates(JXG.COORDS_BY_SCREEN,[g.coords.scrCoords[1]+n*k,g.coords.scrCoords[2]+n*i])}else{if(this.slideObject.elementClass==JXG.OBJECT_CLASS_CURVE){if(o>0){e=Math.round(this.intervalCount/j*this.board.canvasWidth)}else{e=Math.round((j-this.intervalCount)/j*this.board.canvasWidth)}this.coords.setCoordinates(JXG.COORDS_BY_SCREEN,[e,0]);this.coords=JXG.Math.Geometry.projectPointToCurve(this,this.slideObject,this.board)}else{if(this.slideObject.elementClass==JXG.OBJECT_CLASS_CIRCLE){if(o<0){h=this.intervalCount/j*2*Math.PI}else{h=(j-this.intervalCount)/j*2*Math.PI}l=this.slideObject.Radius();this.coords.setCoordinates(JXG.COORDS_BY_USER,[this.slideObject.center.coords.usrCoords[1]+l*Math.cos(h),this.slideObject.center.coords.usrCoords[2]+l*Math.sin(h)])}}}this.board.update(this);return this},setStyle:function(e){var f=["cross","cross","cross","circle","circle","circle","circle","square","square","square","plus","plus","plus"],g=[2,3,4,1,2,3,4,2,3,4,2,3,4];this.visProp.face=f[e];this.visProp.size=g[e];this.board.renderer.changePointStyle(this);return this},normalizeFace:function(e){var f={cross:"x",x:"x",circle:"o",o:"o",square:"[]","[]":"[]",plus:"+","+":"+",diamond:"<>","<>":"<>",triangleup:"^",a:"^","^":"^",triangledown:"v",v:"v",triangleleft:"<","<":"<",triangleright:">",">":">"};return f[e]},remove:function(){if(this.hasLabel){this.board.renderer.remove(this.board.renderer.getElementById(this.label.content.id))}this.board.renderer.remove(this.board.renderer.getElementById(this.id))},getTextAnchor:function(){return this.coords},getLabelAnchor:function(){return this.coords},face:function(e){this.setProperty({face:e})},size:function(e){this.setProperty({size:e})},cloneToBackground:function(){var e={};e.id=this.id+"T"+this.numTraces;this.numTraces++;e.coords=this.coords;e.visProp=JXG.deepCopy(this.visProp,this.visProp.traceattributes,true);e.visProp.layer=this.board.options.layer.trace;e.elementClass=JXG.OBJECT_CLASS_POINT;e.board=this.board;JXG.clearVisPropOld(e);this.board.renderer.drawPoint(e);this.traces[e.id]=e.rendNode;return this},getParents:function(){var e=[this.Z(),this.X(),this.Y()];if(this.parents){e=this.parents}if(this.type==JXG.OBJECT_TYPE_GLIDER){e=[this.X(),this.Y(),this.slideObject.id]}return e}});JXG.createPoint=function(l,h,g){var k,f=false,j,e;e=JXG.copyAttributes(g,l.options,"point");for(j=0;j<h.length;j++){if(typeof h[j]=="function"||typeof h[j]=="string"){f=true}}if(!f){if((JXG.isNumber(h[0]))&&(JXG.isNumber(h[1]))){k=new JXG.Point(l,h,e);if(JXG.exists(e.slideobject)){k.makeGlider(e.slideobject)}else{k.baseElement=k}k.isDraggable=true}else{if((typeof h[0]=="object")&&(typeof h[1]=="object")){k=new JXG.Point(l,[0,0],e);k.addTransform(h[0],h[1]);k.isDraggable=false;k.parents=[h[0].id,h[1].id]}else{throw new Error("JSXGraph: Can't create point with parent types '"+(typeof h[0])+"' and '"+(typeof h[1])+"'.\nPossible parent types: [x,y], [z,x,y], [point,transformation]")}}}else{k=new JXG.Point(l,[NaN,NaN],e);k.addConstraint(h)}return k};JXG.createGlider=function(i,g,f){var h,e=JXG.copyAttributes(f,i.options,"point");if(g.length===1){h=i.create("point",[0,0],e)}else{h=i.create("point",g.slice(0,2),e)}h.makeGlider(g[g.length-1]);return h};JXG.createIntersectionPoint=function(h,f,e){var g;if(f.length>=3){if(f.length==3){f.push(null)}g=h.create("point",[h.intersection(f[0],f[1],f[2],f[3])],e)}f[0].addChild(g);f[1].addChild(g);g.elType="intersection";g.parents=[f[0].id,f[1].id,f[2]];if(f[3]!=null){g.parents.push(f[3])}g.generatePolynomial=function(){var i=f[0].generatePolynomial(g);var j=f[1].generatePolynomial(g);if((i.length==0)||(j.length==0)){return[]}else{return[i[0],j[0]]}};return g};JXG.createOtherIntersectionPoint=function(h,f,e){var g;if(f.length!=3||!JXG.isPoint(f[2])||(f[0].elementClass!=JXG.OBJECT_CLASS_LINE&&f[0].elementClass!=JXG.OBJECT_CLASS_CIRCLE)||(f[1].elementClass!=JXG.OBJECT_CLASS_LINE&&f[1].elementClass!=JXG.OBJECT_CLASS_CIRCLE)){throw new Error("JSXGraph: Can't create 'other intersection point' with parent types '"+(typeof f[0])+"',  '"+(typeof f[1])+"'and  '"+(typeof f[2])+"'.\nPossible parent types: [circle|line,circle|line,point]")}else{g=h.create("point",[h.otherIntersection(f[0],f[1],f[2])],e)}g.elType="otherintersection";g.parents=[f[0].id,f[1].id,f[2]];f[0].addChild(g);f[1].addChild(g);g.generatePolynomial=function(){var i=f[0].generatePolynomial(g);var j=f[1].generatePolynomial(g);if((i.length==0)||(j.length==0)){return[]}else{return[i[0],j[0]]}};return g};JXG.JSXGraph.registerElement("point",JXG.createPoint);JXG.JSXGraph.registerElement("glider",JXG.createGlider);JXG.JSXGraph.registerElement("intersection",JXG.createIntersectionPoint);JXG.JSXGraph.registerElement("otherintersection",JXG.createOtherIntersectionPoint);JXG.Line=function(f,h,g,e){this.constructor(f,e,JXG.OBJECT_TYPE_LINE,JXG.OBJECT_CLASS_LINE);this.point1=JXG.getReference(this.board,h);this.point2=JXG.getReference(this.board,g);this.ticks=[];this.defaultTicks=null;this.parentPolygon=null;this.id=this.board.setId(this,"L");this.board.renderer.drawLine(this);this.board.finalizeAdding(this);this.elType="line";this.createLabel();this.point1.addChild(this);this.point2.addChild(this);this.updateStdform()};JXG.Line.prototype=new JXG.GeometryElement;JXG.extend(JXG.Line.prototype,{hasPoint:function(l,k){var h=[],o,n=[1,l,k],m,p,g,f,j,e;h[0]=this.stdform[0]-this.stdform[1]*this.board.origin.scrCoords[1]/this.board.unitX+this.stdform[2]*this.board.origin.scrCoords[2]/this.board.unitY;h[1]=this.stdform[1]/this.board.unitX;h[2]=this.stdform[2]/(-this.board.unitY);m=[0,h[1],h[2]];m=JXG.Math.crossProduct(m,n);m=JXG.Math.crossProduct(m,h);m[1]/=m[0];m[2]/=m[0];m[0]=1;o=(n[1]-m[1])*(n[1]-m[1])+(n[2]-m[2])*(n[2]-m[2]);if(isNaN(o)||o>this.board.options.precision.hasPoint*this.board.options.precision.hasPoint){return false}if(this.visProp.straightfirst&&this.visProp.straightlast){return true}else{p=this.point1.coords;g=this.point2.coords;m=(new JXG.Coords(JXG.COORDS_BY_SCREEN,m.slice(1),this.board)).usrCoords;f=p.distance(JXG.COORDS_BY_USER,g);p=p.usrCoords.slice(0);g=g.usrCoords.slice(0);if(f<JXG.Math.eps){j=0}else{if(f==Number.POSITIVE_INFINITY){f=1/JXG.Math.eps;if(Math.abs(g[0])<JXG.Math.eps){f/=JXG.Math.Geometry.distance([0,0,0],g);g=[1,p[1]+g[1]*f,p[2]+g[2]*f]}else{f/=JXG.Math.Geometry.distance([0,0,0],p);p=[1,g[1]+p[1]*f,g[2]+p[2]*f]}}e=1;f=g[e]-p[e];if(Math.abs(f)<JXG.Math.eps){e=2;f=g[e]-p[e]}j=(m[e]-p[e])/f}if(!this.visProp.straightfirst&&j<0){return false}if(!this.visProp.straightlast&&j>1){return false}return true}},update:function(){var h,f,e,j,g,m,l,k,i;if(!this.needsUpdate){return this}if(this.constrained){if(typeof this.funps!="undefined"){h=this.funps();if(h&&h.length&&h.length===2){this.point1=h[0];this.point2=h[1]}}else{if(typeof this.funp1==="function"){h=this.funp1();if(JXG.isPoint(h)){this.point1=h}else{if(h&&h.length&&h.length===2){this.point1.setPositionDirectly(JXG.COORDS_BY_USER,h[0],h[1])}}}if(typeof this.funp2==="function"){h=this.funp2();if(JXG.isPoint(h)){this.point2=h}else{if(h&&h.length&&h.length===2){this.point2.setPositionDirectly(JXG.COORDS_BY_USER,h[0],h[1])}}}}}this.updateSegmentFixedLength();this.updateStdform();if(this.visProp.trace){this.cloneToBackground(true)}return this},updateSegmentFixedLength:function(){if(!this.hasFixedLength){return this}d=this.point1.Dist(this.point2);dnew=this.fixedLength();d1=this.fixedLengthOldCoords[0].distance(JXG.COORDS_BY_USER,this.point1.coords);d2=this.fixedLengthOldCoords[1].distance(JXG.COORDS_BY_USER,this.point2.coords);if(d1>JXG.Math.eps||d2>JXG.Math.eps||d!=dnew){drag1=this.point1.isDraggable&&(this.point1.type!=JXG.OBJECT_TYPE_GLIDER)&&!this.point1.visProp.fixed;drag2=this.point2.isDraggable&&(this.point2.type!=JXG.OBJECT_TYPE_GLIDER)&&!this.point2.visProp.fixed;if(d>JXG.Math.eps){if((d1>d2&&drag2)||(d1<=d2&&drag2&&!drag1)){this.point2.setPositionDirectly(JXG.COORDS_BY_USER,this.point1.X()+(this.point2.X()-this.point1.X())*dnew/d,this.point1.Y()+(this.point2.Y()-this.point1.Y())*dnew/d);this.point2.prepareUpdate().updateRenderer()}else{if((d1<=d2&&drag1)||(d1>d2&&drag1&&!drag2)){this.point1.setPositionDirectly(JXG.COORDS_BY_USER,this.point2.X()+(this.point1.X()-this.point2.X())*dnew/d,this.point2.Y()+(this.point1.Y()-this.point2.Y())*dnew/d);this.point1.prepareUpdate().updateRenderer()}}}else{x=Math.random()-0.5;y=Math.random()-0.5;d=Math.sqrt(x*x+y*y);if(drag2){this.point2.setPositionDirectly(JXG.COORDS_BY_USER,this.point1.X()+x*dnew/d,this.point1.Y()+y*dnew/d);this.point2.prepareUpdate().updateRenderer()}else{if(drag1){this.point1.setPositionDirectly(JXG.COORDS_BY_USER,this.point2.X()+x*dnew/d,this.point2.Y()+y*dnew/d);this.point1.prepareUpdate().updateRenderer()}}}this.fixedLengthOldCoords[0].setCoordinates(JXG.COORDS_BY_USER,this.point1.coords.usrCoords);this.fixedLengthOldCoords[1].setCoordinates(JXG.COORDS_BY_USER,this.point2.coords.usrCoords)}return this},updateStdform:function(){var e=JXG.Math.crossProduct(this.point1.coords.usrCoords,this.point2.coords.usrCoords);this.stdform[0]=e[0];this.stdform[1]=e[1];this.stdform[2]=e[2];this.stdform[3]=0;this.normalize()},updateRenderer:function(){var e;if(this.needsUpdate&&this.visProp.visible){e=this.isReal;this.isReal=(!isNaN(this.point1.coords.usrCoords[1]+this.point1.coords.usrCoords[2]+this.point2.coords.usrCoords[1]+this.point2.coords.usrCoords[2])&&(JXG.Math.innerProduct(this.stdform,this.stdform,3)>=JXG.Math.eps*JXG.Math.eps));if(this.isReal){if(e!=this.isReal){this.board.renderer.show(this);if(this.hasLabel&&this.label.content.visProp.visible){this.board.renderer.show(this.label.content)}}this.board.renderer.updateLine(this)}else{if(e!=this.isReal){this.board.renderer.hide(this);if(this.hasLabel&&this.label.content.visProp.visible){this.board.renderer.hide(this.label.content)}}}this.needsUpdate=false}if(this.hasLabel&&this.label.content.visProp.visible&&this.isReal){this.label.content.update();this.board.renderer.updateText(this.label.content)}return this},generatePolynomial:function(i){var h=this.point1.symbolic.x,g=this.point1.symbolic.y,k=this.point2.symbolic.x,j=this.point2.symbolic.y,f=i.symbolic.x,e=i.symbolic.y;return[["(",g,")*(",f,")-(",g,")*(",k,")+(",e,")*(",k,")-(",h,")*(",e,")+(",h,")*(",j,")-(",f,")*(",j,")"].join("")]},getRise:function(){if(Math.abs(this.stdform[2])>=JXG.Math.eps){return -this.stdform[0]/this.stdform[2]}else{return Infinity}},getSlope:function(){if(Math.abs(this.stdform[2])>=JXG.Math.eps){return -this.stdform[1]/this.stdform[2]}else{return Infinity}},getAngle:function(){return Math.atan2(this.point2.Y()-this.point1.Y(),this.point2.X()-this.point1.X())},setStraight:function(e,f){this.visProp.straightfirst=e;this.visProp.straightlast=f;this.board.renderer.updateLine(this);return this},getTextAnchor:function(){return new JXG.Coords(JXG.COORDS_BY_USER,[0.5*(this.point2.X()+this.point1.X()),0.5*(this.point2.Y()+this.point1.Y())],this.board)},setLabelRelativeCoords:function(e){if(JXG.exists(this.label.content)){this.label.content.relativeCoords=new JXG.Coords(JXG.COORDS_BY_SCREEN,[e[0],-e[1]],this.board)}},getLabelAnchor:function(){var g,f,e,j,i=0,h=0,g=new JXG.Coords(JXG.COORDS_BY_USER,this.point1.coords.usrCoords,this.board);f=new JXG.Coords(JXG.COORDS_BY_USER,this.point2.coords.usrCoords,this.board);if(this.visProp.straightfirst||this.visProp.straightlast){JXG.Math.Geometry.calcStraight(this,g,f)}g=g.scrCoords;f=f.scrCoords;switch(this.label.content.visProp.position){case"lft":case"llft":case"ulft":if(g[1]<=f[1]){e=g[1];j=g[2]}else{e=f[1];j=f[2]}break;case"rt":case"lrt":case"urt":if(g[1]>f[1]){e=g[1];j=g[2]}else{e=f[1];j=f[2]}break;default:e=0.5*(g[1]+f[1]);j=0.5*(g[2]+f[2])}if(this.visProp.straightfirst||this.visProp.straightlast){if(JXG.exists(this.label.content)){i=parseFloat(this.label.content.visProp.offsets[0]);h=parseFloat(this.label.content.visProp.offsets[1])}if(Math.abs(e)<JXG.Math.eps){if(this.visProp.label.position=="ulft"||this.visProp.label.position=="llft"||this.visProp.label.position=="lft"){e+=2*i}}if(Math.abs(e-this.board.canvasWidth)<JXG.Math.eps){if(this.visProp.label.position=="urt"||this.visProp.label.position=="lrt"||this.visProp.label.position=="rt"){e-=2.5*i}}if(Math.abs(j-this.board.canvasHeight)<JXG.Math.eps){if(this.visProp.label.position=="llft"||this.visProp.label.position=="lrt"||this.visProp.label.position=="bot"){j-=3*h}}if(Math.abs(j)<JXG.Math.eps){if(this.visProp.label.position=="ulft"||this.visProp.label.position=="urt"||this.visProp.label.position=="top"){j+=2*h}}}return new JXG.Coords(JXG.COORDS_BY_SCREEN,[e,j],this.board)},cloneToBackground:function(){var h={},f,e,g;h.id=this.id+"T"+this.numTraces;h.elementClass=JXG.OBJECT_CLASS_LINE;this.numTraces++;h.point1=this.point1;h.point2=this.point2;h.stdform=this.stdform;h.board=this.board;h.visProp=JXG.deepCopy(this.visProp,this.visProp.traceattributes,true);h.visProp.layer=this.board.options.layer.trace;JXG.clearVisPropOld(h);e=this.getSlope();f=this.getRise();h.getSlope=function(){return e};h.getRise=function(){return f};g=this.board.renderer.enhancedRendering;this.board.renderer.enhancedRendering=true;this.board.renderer.drawLine(h);this.board.renderer.enhancedRendering=g;this.traces[h.id]=h.rendNode;delete h;return this},addTransform:function(f){var g,h=JXG.isArray(f)?f:[f],e=h.length;for(g=0;g<e;g++){this.point1.transformations.push(h[g]);this.point2.transformations.push(h[g])}return this},setPosition:function(h,e,g){var f=this.board.create("transform",[e,g],{type:"translate"});if(this.point1.transformations.length>0&&this.point1.transformations[this.point1.transformations.length-1].isNumericMatrix){this.point1.transformations[this.point1.transformations.length-1].melt(f)}else{this.point1.addTransform(this.point1,f)}if(this.point2.transformations.length>0&&this.point2.transformations[this.point2.transformations.length-1].isNumericMatrix){this.point2.transformations[this.point2.transformations.length-1].melt(f)}else{this.point2.addTransform(this.point2,f)}return this},setPositionDirectly:function(l,e,k,j,i){var g=e-j,f=k-i;if(!this.point1.draggable()||!this.point2.draggable()){return this}g/=this.board.unitX;f/=-this.board.unitY;var h=this.board.create("transform",[g,f,0],{type:"translate"});h.applyOnce([this.point1,this.point2]);return this},X:function(g){var f=this.stdform[2],e;e=(Math.abs(this.point1.coords.usrCoords[0])>JXG.Math.eps)?this.point1.coords.usrCoords[1]:this.point2.coords.usrCoords[1];g=(g-0.5)*2;if(g<0){g*=(-1);return(1-g)*e+g*f}else{return(1-g)*e-g*f}},Y:function(f){var e=this.stdform[1],g;g=(Math.abs(this.point1.coords.usrCoords[0])>JXG.Math.eps)?this.point1.coords.usrCoords[2]:this.point2.coords.usrCoords[2];f=(f-0.5)*2;if(f<0){f*=(-1);return(1-f)*g-f*e}else{return(1-f)*g+f*e}},Z:function(e){var f=(Math.abs(this.point1.coords.usrCoords[0])>JXG.Math.eps)?this.point1.coords.usrCoords[0]:this.point2.coords.usrCoords[0];e=(e-0.5)*2;if(e<0){e*=(-1)}return(1-e)*f},L:function(){return this.point1.Dist(this.point2)},minX:function(){return 0},maxX:function(){return 1},bounds:function(){var e=this.point1.coords.usrCoords,f=this.point2.coords.usrCoords;return[Math.min(e[1],f[1]),Math.max(e[2],f[2]),Math.max(e[1],f[1]),Math.min(e[2],f[2])]},addTicks:function(e){if(e.id==""||typeof e.id=="undefined"){e.id=this.id+"_ticks_"+(this.ticks.length+1)}this.board.renderer.drawTicks(e);this.ticks.push(e);return e.id},removeAllTicks:function(){var f,e;for(e=this.ticks.length;e>0;e--){this.removeTicks(this.ticks[e-1])}this.ticks=new Array();this.board.update()},removeTicks:function(g){var f,e;if(this.defaultTicks!=null&&this.defaultTicks==g){this.defaultTicks=null}for(f=this.ticks.length;f>0;f--){if(this.ticks[f-1]==g){this.board.removeObject(this.ticks[f-1]);for(e=0;e<this.ticks[f-1].ticks.length;e++){if(this.ticks[f-1].labels[e]!=null){this.board.removeObject(this.ticks[f-1].labels[e])}}delete (this.ticks[f-1]);break}}}});JXG.createLine=function(l,o,j){var g,q,p,k,m,n=[],h=false,f;if(o.length==2){if(JXG.isArray(o[0])&&o[0].length>1){m=JXG.copyAttributes(j,l.options,"line","point1");q=l.create("point",o[0],m)}else{if(JXG.isString(o[0])||o[0].elementClass==JXG.OBJECT_CLASS_POINT){q=JXG.getReference(l,o[0])}else{if((typeof o[0]=="function")&&(o[0]().elementClass==JXG.OBJECT_CLASS_POINT)){q=o[0]();h=true}else{if((typeof o[0]=="function")&&(o[0]().length&&o[0]().length===2)){m=JXG.copyAttributes(j,l.options,"line","point1");q=JXG.createPoint(l,o[0](),m);h=true}else{throw new Error("JSXGraph: Can't create line with parent types '"+(typeof o[0])+"' and '"+(typeof o[1])+"'.\nPossible parent types: [point,point], [[x1,y1],[x2,y2]], [a,b,c]")}}}}if(JXG.isArray(o[1])&&o[1].length>1){m=JXG.copyAttributes(j,l.options,"line","point2");p=l.create("point",o[1],m)}else{if(JXG.isString(o[1])||o[1].elementClass==JXG.OBJECT_CLASS_POINT){p=JXG.getReference(l,o[1])}else{if((typeof o[1]=="function")&&(o[1]().elementClass==JXG.OBJECT_CLASS_POINT)){p=o[1]();h=true}else{if((typeof o[1]=="function")&&(o[1]().length&&o[1]().length===2)){m=JXG.copyAttributes(j,l.options,"line","point2");p=JXG.createPoint(l,o[1](),m);h=true}else{throw new Error("JSXGraph: Can't create line with parent types '"+(typeof o[0])+"' and '"+(typeof o[1])+"'.\nPossible parent types: [point,point], [[x1,y1],[x2,y2]], [a,b,c]")}}}}m=JXG.copyAttributes(j,l.options,"line");g=new JXG.Line(l,q,p,m);if(h){g.constrained=true;g.funp1=o[0];g.funp2=o[1]}else{g.isDraggable=true}if(!g.constrained){g.parents=[q.id,p.id]}}else{if(o.length==3){f=true;for(k=0;k<3;k++){if(typeof o[k]=="number"){n[k]=function(i){return function(){return i}}(o[k])}else{if(typeof o[k]=="function"){n[k]=o[k];f=false}else{throw new Error("JSXGraph: Can't create line with parent types '"+(typeof o[0])+"' and '"+(typeof o[1])+"' and '"+(typeof o[2])+"'.\nPossible parent types: [point,point], [[x1,y1],[x2,y2]], [a,b,c]")}}}m=JXG.copyAttributes(j,l.options,"line","point1");if(f){q=l.create("point",[n[2]()*n[2]()+n[1]()*n[1](),n[2]()-n[1]()*n[0]()+n[2](),-n[1]()-n[2]()*n[0]()-n[1]()],m)}else{q=l.create("point",[function(){return(0+n[2]()*n[2]()+n[1]()*n[1]())*0.5},function(){return(n[2]()-n[1]()*n[0]()+n[2]())*0.5},function(){return(-n[1]()-n[2]()*n[0]()-n[1]())*0.5}],m)}m=JXG.copyAttributes(j,l.options,"line","point2");if(f){p=l.create("point",[n[2]()*n[2]()+n[1]()*n[1](),-n[1]()*n[0]()+n[2](),-n[2]()*n[0]()-n[1]()],m)}else{p=l.create("point",[function(){return n[2]()*n[2]()+n[1]()*n[1]()},function(){return -n[1]()*n[0]()+n[2]()},function(){return -n[2]()*n[0]()-n[1]()}],m)}q.prepareUpdate().update();p.prepareUpdate().update();m=JXG.copyAttributes(j,l.options,"line");g=new JXG.Line(l,q,p,m);g.isDraggable=f;if(f){g.parents=[n[0](),n[1](),n[2]()]}}else{if((o.length==1)&&(typeof o[0]=="function")&&(o[0]().length==2)&&(o[0]()[0].elementClass==JXG.OBJECT_CLASS_POINT)&&(o[0]()[1].elementClass==JXG.OBJECT_CLASS_POINT)){var e=o[0]();m=JXG.copyAttributes(j,l.options,"line");g=new JXG.Line(l,e[0],e[1],m);g.constrained=true;g.funps=o[0]}else{if((o.length==1)&&(typeof o[0]=="function")&&(o[0]().length==3)&&(typeof o[0]()[0]==="number")&&(typeof o[0]()[1]==="number")&&(typeof o[0]()[2]==="number")){e=o[0];m=JXG.copyAttributes(j,l.options,"line","point1");q=l.create("point",[function(){var i=e();return[(0+i[2]*i[2]+i[1]*i[1])*0.5,(i[2]-i[1]*i[0]+i[2])*0.5,(-i[1]-i[2]*i[0]-i[1])*0.5]}],m);m=JXG.copyAttributes(j,l.options,"line","point2");p=l.create("point",[function(){var i=e();return[i[2]*i[2]+i[1]*i[1],-i[1]*i[0]+i[2],-i[2]*i[0]-i[1]]}],m);m=JXG.copyAttributes(j,l.options,"line");g=new JXG.Line(l,q,p,m);g.constrained=true;g.funps=o[0]}else{throw new Error("JSXGraph: Can't create line with parent types '"+(typeof o[0])+"' and '"+(typeof o[1])+"'.\nPossible parent types: [point,point], [[x1,y1],[x2,y2]], [a,b,c]")}}}}return g};JXG.JSXGraph.registerElement("line",JXG.createLine);JXG.createSegment=function(j,f,e){var h,g;e.straightFirst=false;e.straightLast=false;h=j.create("line",f.slice(0,2),e);if(f.length==3){h.hasFixedLength=true;if(JXG.isNumber(f[2])){h.fixedLength=function(){return f[2]}}else{if(JXG.isFunction(f[2])){h.fixedLength=f[2]}else{throw new Error("JSXGraph: Can't create segment with third parent type '"+(typeof f[2])+"'.\nPossible third parent types: number or function")}}h.fixedLengthOldCoords=[];h.fixedLengthOldCoords[0]=new JXG.Coords(JXG.COORDS_BY_USER,h.point1.coords.usrCoords.slice(1,3),j);h.fixedLengthOldCoords[1]=new JXG.Coords(JXG.COORDS_BY_USER,h.point2.coords.usrCoords.slice(1,3),j)}h.elType="segment";return h};JXG.JSXGraph.registerElement("segment",JXG.createSegment);JXG.createArrow=function(h,f,e){var g;g=h.create("line",f,e).setStraight(false,false);g.setArrow(false,true);g.type=JXG.OBJECT_TYPE_VECTOR;g.elType="arrow";return g};JXG.JSXGraph.registerElement("arrow",JXG.createArrow);JXG.createAxis=function(j,g,f){var e,i,k;if((JXG.isArray(g[0])||JXG.isPoint(g[0]))&&(JXG.isArray(g[1])||JXG.isPoint(g[1]))){e=JXG.copyAttributes(f,j.options,"axis");i=j.create("line",g,e);i.type=JXG.OBJECT_TYPE_AXIS;i.isDraggable=false;i.point1.isDraggable=false;i.point2.isDraggable=false;for(var h in i.ancestors){i.ancestors[h].type=JXG.OBJECT_TYPE_AXISPOINT}e=JXG.copyAttributes(f,j.options,"axis","ticks");if(JXG.exists(e.ticksdistance)){k=e.ticksdistance}else{if(JXG.isArray(e.ticks)){k=e.ticks}else{k=1}}i.defaultTicks=j.create("ticks",[i,k],e);i.defaultTicks.dump=false;i.elType="axis";i.subs={ticks:i.defaultTicks}}else{throw new Error("JSXGraph: Can't create point with parent types '"+(typeof g[0])+"' and '"+(typeof g[1])+"'.\nPossible parent types: [point,point], [[x1,y1],[x2,y2]]")}return i};JXG.JSXGraph.registerElement("axis",JXG.createAxis);JXG.createTangent=function(q,s,l){var e,r,n,o,m,k,h,t;if(s.length==1){e=s[0];r=e.slideObject}else{if(s.length==2){if(JXG.isPoint(s[0])){e=s[0];r=s[1]}else{if(JXG.isPoint(s[1])){r=s[0];e=s[1]}else{throw new Error("JSXGraph: Can't create tangent with parent types '"+(typeof s[0])+"' and '"+(typeof s[1])+"'.\nPossible parent types: [glider], [point,line|curve|circle|conic]")}}}else{throw new Error("JSXGraph: Can't create tangent with parent types '"+(typeof s[0])+"' and '"+(typeof s[1])+"'.\nPossible parent types: [glider], [point,line|curve|circle|conic]")}}if(r.elementClass==JXG.OBJECT_CLASS_LINE){t=q.create("line",[r.point1,r.point2],l)}else{if(r.elementClass==JXG.OBJECT_CLASS_CURVE&&!(r.type==JXG.OBJECT_TYPE_CONIC)){if(r.visProp.curvetype!="plot"){n=r.X;o=r.Y;t=q.create("line",[function(){return -e.X()*q.D(o)(e.position)+e.Y()*q.D(n)(e.position)},function(){return q.D(o)(e.position)},function(){return -q.D(n)(e.position)}],l);e.addChild(t);t.glider=e}else{t=q.create("line",[function(){m=Math.floor(e.position);if(m==r.numberPoints-1){m--}if(m<0){return 1}return r.Y(m)*r.X(m+1)-r.X(m)*r.Y(m+1)},function(){m=Math.floor(e.position);if(m==r.numberPoints-1){m--}if(m<0){return 0}return r.Y(m+1)-r.Y(m)},function(){m=Math.floor(e.position);if(m==r.numberPoints-1){m--}if(m<0){return 0}return r.X(m)-r.X(m+1)}],l);e.addChild(t);t.glider=e}}else{if(r.type==JXG.OBJECT_TYPE_TURTLE){t=q.create("line",[function(){m=Math.floor(e.position);for(k=0;k<r.objects.length;k++){h=r.objects[k];if(h.type==JXG.OBJECT_TYPE_CURVE){if(m<h.numberPoints){break}m-=h.numberPoints}}if(m==h.numberPoints-1){m--}if(m<0){return 1}return h.Y(m)*h.X(m+1)-h.X(m)*h.Y(m+1)},function(){m=Math.floor(e.position);for(k=0;k<r.objects.length;k++){h=r.objects[k];if(h.type==JXG.OBJECT_TYPE_CURVE){if(m<h.numberPoints){break}m-=h.numberPoints;moveTo(funps)}}if(m==h.numberPoints-1){m--}if(m<0){return 0}return h.Y(m+1)-h.Y(m)},function(){m=Math.floor(e.position);for(k=0;k<r.objects.length;k++){h=r.objects[k];if(h.type==JXG.OBJECT_TYPE_CURVE){if(m<h.numberPoints){break}m-=h.numberPoints}}if(m==h.numberPoints-1){m--}if(m<0){return 0}return h.X(m)-h.X(m+1)}],l);e.addChild(t);t.glider=e}else{if(r.elementClass==JXG.OBJECT_CLASS_CIRCLE||r.type==JXG.OBJECT_TYPE_CONIC){t=q.create("line",[function(){return JXG.Math.matVecMult(r.quadraticform,e.coords.usrCoords)[0]},function(){return JXG.Math.matVecMult(r.quadraticform,e.coords.usrCoords)[1]},function(){return JXG.Math.matVecMult(r.quadraticform,e.coords.usrCoords)[2]}],l);e.addChild(t);t.glider=e}}}}t.elType="tangent";t.parents=[];for(m=0;m<s.length;m++){t.parents.push(s[m].id)}return t};JXG.JSXGraph.registerElement("tangent",JXG.createTangent);JXG.JSXGraph.registerElement("polar",JXG.createTangent);JXG.Group=function(j,m,e){var k,h,f,l,g;this.board=j;this.objects={};k=this.board.numObjects;this.board.numObjects++;if((m=="")||!JXG.exists(m)){this.id=this.board.id+"Group"+k}else{this.id=m}this.board.groups[this.id]=this;this.type=JXG.OBJECT_TYPE_POINT;this.elementClass=JXG.OBJECT_CLASS_POINT;if((e=="")||!JXG.exists(e)){this.name="group_"+this.board.generateName(this)}else{this.name=e}delete (this.type);if((arguments.length==4)&&(JXG.isArray(arguments[3]))){h=arguments[3]}else{h=[];for(f=3;f<arguments.length;f++){h.push(arguments[f])}}for(f=0;f<h.length;f++){l=JXG.getReference(this.board,h[f]);if((!l.visProp.fixed)&&((l.type==JXG.OBJECT_TYPE_POINT)||(l.type==JXG.OBJECT_TYPE_GLIDER))){if(l.group.length!=0){this.addGroup(l.group[l.group.length-1])}else{this.addPoint(l)}}}for(g in this.objects){this.objects[g].group.push(this)}this.dX=0;this.dY=0};JXG.extend(JXG.Group.prototype,{ungroup:function(){var e;for(e in this.objects){if(this.objects[e].group[this.objects[e].group.length-1]==this){this.objects[e].group.pop()}delete (this.objects[e])}},update:function(e){var g=null,f;for(f in this.objects){g=this.objects[f];if(g.id!=e.id){g.coords=new JXG.Coords(JXG.COORDS_BY_SCREEN,[g.coords.scrCoords[1]+this.dX,g.coords.scrCoords[2]+this.dY],g.board)}}for(f in this.objects){if(JXG.exists(this.board.objects[f])){this.objects[f].update(false)}else{delete (this.objects[f])}}return this},addPoint:function(e){this.objects[e.id]=e},addPoints:function(e){var f;for(f in e){this.objects[f.id]=f}},addGroup:function(f){var e;for(e in f.objects){this.addPoint(f.objects[e])}},setProperty:function(){var e;for(e in this.objects){this.objects[e].setProperty.apply(this.objects[e],arguments)}}});JXG.createGroup=function(j,f,e){var h,k=new JXG.Group(j,e.id,e.name,f);k.elType="group";k.parents=[];for(h=0;h<f.length;h++){k.parents.push(f[h].id)}return k};JXG.JSXGraph.registerElement("group",JXG.createGroup);JXG.Circle=function(h,i,g,f,e){this.constructor(h,e,JXG.OBJECT_TYPE_CIRCLE,JXG.OBJECT_CLASS_CIRCLE);this.method=i;this.midpoint=JXG.getReference(this.board,g);this.center=JXG.getReference(this.board,g);this.point2=null;this.radius=0;this.line=null;this.circle=null;if(i=="twoPoints"){this.point2=JXG.getReference(h,f);this.radius=this.Radius()}else{if(i=="pointRadius"){this.gxtterm=f;this.generateTerm(f);this.updateRadius()}else{if(i=="pointLine"){this.line=JXG.getReference(h,f);this.radius=this.line.point1.coords.distance(JXG.COORDS_BY_USER,this.line.point2.coords)}else{if(i=="pointCircle"){this.circle=JXG.getReference(h,f);this.radius=this.circle.Radius()}}}}this.id=this.board.setId(this,"C");this.board.renderer.drawEllipse(this);this.board.finalizeAdding(this);this.createGradient();this.elType="circle";this.createLabel();this.center.addChild(this);if(i=="pointRadius"){this.notifyParents(f)}else{if(i=="pointLine"){this.line.addChild(this)}else{if(i=="pointCircle"){this.circle.addChild(this)}else{if(i=="twoPoints"){this.point2.addChild(this)}}}}this.methodMap=JXG.deepCopy(this.methodMap,{setRadius:"setRadius"})};JXG.Circle.prototype=new JXG.GeometryElement;JXG.extend(JXG.Circle.prototype,{hasPoint:function(e,k){var f=this.board.options.precision.hasPoint/(this.board.unitX),h=this.center.coords.usrCoords,i=new JXG.Coords(JXG.COORDS_BY_SCREEN,[e,k],this.board),g=this.Radius();var j=Math.sqrt((h[1]-i.usrCoords[1])*(h[1]-i.usrCoords[1])+(h[2]-i.usrCoords[2])*(h[2]-i.usrCoords[2]));return(Math.abs(j-g)<f)},generatePolynomial:function(k){var i=this.center.symbolic.x;var h=this.center.symbolic.y;var g=k.symbolic.x;var f=k.symbolic.y;var e=this.generateRadiusSquared();if(e==""){return[]}var j="(("+g+")-("+i+"))^2 + (("+f+")-("+h+"))^2 - ("+e+")";return[j]},generateRadiusSquared:function(){var f="";if(this.method=="twoPoints"){var h=this.center.symbolic.x;var g=this.center.symbolic.y;var j=this.point2.symbolic.x;var i=this.point2.symbolic.y;f="(("+j+")-("+h+"))^2 + (("+i+")-("+g+"))^2"}else{if(this.method=="pointRadius"){if(typeof(this.radius)=="number"){f=""+this.radius*this.radius}}else{if(this.method=="pointLine"){var j=this.line.point1.symbolic.x;var i=this.line.point1.symbolic.y;var e=this.line.point2.symbolic.x;var k=this.line.point2.symbolic.y;f="(("+j+")-("+e+"))^2 + (("+i+")-("+k+"))^2"}else{if(this.method=="pointCircle"){f=this.circle.Radius()}}}}return f},update:function(){if(this.needsUpdate){if(this.visProp.trace){this.cloneToBackground(true)}if(this.method=="pointLine"){this.radius=this.line.point1.coords.distance(JXG.COORDS_BY_USER,this.line.point2.coords)}else{if(this.method=="pointCircle"){this.radius=this.circle.Radius()}else{if(this.method=="pointRadius"){this.radius=this.updateRadius()}}}this.updateStdform();this.updateQuadraticform()}return this},updateQuadraticform:function(){var e=this.center,h=e.X(),g=e.Y(),f=this.Radius();this.quadraticform=[[h*h+g*g-f*f,-h,-g],[-h,1,0],[-g,0,1]]},updateStdform:function(){this.stdform[3]=0.5;this.stdform[4]=this.Radius();this.stdform[1]=-this.center.coords.usrCoords[1];this.stdform[2]=-this.center.coords.usrCoords[2];this.normalize()},updateRenderer:function(){if(this.needsUpdate&&this.visProp.visible){var e=this.isReal;this.isReal=(isNaN(this.center.coords.usrCoords[1]+this.center.coords.usrCoords[2]+this.Radius()))?false:true;if(this.isReal){if(e!=this.isReal){this.board.renderer.show(this);if(this.hasLabel&&this.label.content.visProp.visible){this.board.renderer.show(this.label.content)}}this.board.renderer.updateEllipse(this)}else{if(e!=this.isReal){this.board.renderer.hide(this);if(this.hasLabel&&this.label.content.visProp.visible){this.board.renderer.hide(this.label.content)}}}this.needsUpdate=false}if(this.hasLabel&&this.label.content.visProp.visible&&this.isReal){this.label.content.update();this.board.renderer.updateText(this.label.content)}},generateTerm:function(e){if(typeof e=="string"){this.updateRadius=this.board.jc.snippet(e,true,null,true)}else{if(typeof e=="number"){this.updateRadius=function(){return e}}else{this.updateRadius=e}}},notifyParents:function(f){var e=null;var g=this.board.elementsByName;if(typeof f=="string"){JXG.GeonextParser.findDependencies(this,f+"",this.board)}},setRadius:function(e){this.generateTerm(e);this.board.update();return this},Radius:function(){if(this.method=="twoPoints"){if(JXG.Math.Geometry.distance(this.point2.coords.usrCoords,[0,0,0])==0||JXG.Math.Geometry.distance(this.center.coords.usrCoords,[0,0,0])==0){return NaN}else{return this.center.Dist(this.point2)}}else{if(this.method=="pointLine"||this.method=="pointCircle"){return this.radius}else{if(this.method=="pointRadius"){return this.updateRadius()}}}},getRadius:function(){return this.Radius()},getTextAnchor:function(){return this.center.coords},getLabelAnchor:function(){var f=this.Radius(),h=this.center.coords.usrCoords,e,g;switch(this.visProp.label.position){case"lft":e=h[1]-f;g=h[2];break;case"llft":e=h[1]-Math.sqrt(0.5)*f;g=h[2]-Math.sqrt(0.5)*f;break;case"rt":e=h[1]+f;g=h[2];break;case"lrt":e=h[1]+Math.sqrt(0.5)*f;g=h[2]-Math.sqrt(0.5)*f;break;case"urt":e=h[1]+Math.sqrt(0.5)*f;g=h[2]+Math.sqrt(0.5)*f;break;case"top":e=h[1];g=h[2]+f;break;case"bot":e=h[1];g=h[2]-f;break;case"ulft":default:e=h[1]-Math.sqrt(0.5)*f;g=h[2]+Math.sqrt(0.5)*f;break}return new JXG.Coords(JXG.COORDS_BY_USER,[e,g],this.board)},cloneToBackground:function(){var g={},e,f;g.id=this.id+"T"+this.numTraces;g.elementClass=JXG.OBJECT_CLASS_CIRCLE;this.numTraces++;g.center={};g.center.coords=this.center.coords;e=this.Radius();g.Radius=function(){return e};g.getRadius=function(){return e};g.board=this.board;g.visProp=JXG.deepCopy(this.visProp,this.visProp.traceattributes,true);g.visProp.layer=this.board.options.layer.trace;JXG.clearVisPropOld(g);f=this.board.renderer.enhancedRendering;this.board.renderer.enhancedRendering=true;this.board.renderer.drawEllipse(g);this.board.renderer.enhancedRendering=f;this.traces[g.id]=g.rendNode;return this},addTransform:function(f){var g,h=JXG.isArray(f)?f:[f],e=h.length;for(g=0;g<e;g++){this.center.transformations.push(h[g]);if(this.method==="twoPoints"){this.point2.transformations.push(h[g])}}return this},setPosition:function(h,e,g){var f=this.board.create("transform",[e,g],{type:"translate"});this.addTransform(f);return this},setPositionDirectly:function(e,o,n,j,h){var r=o-j,q=n-h,m,l,k=this.parents.length,g,f;for(g=0;g<k;g++){if(!JXG.getRef(this.board,this.parents[g]).draggable()){return this}}for(g=0;g<k;g++){f=JXG.getRef(this.board,this.parents[g]);if(e==JXG.COORDS_BY_SCREEN){m=f.coords.scrCoords[1]+r;l=f.coords.scrCoords[2]+q}else{m=f.coords.usrCoords[1]+r;l=f.coords.usrCoords[2]+q}f.setPositionDirectly(e,m,l)}this.update();return this},X:function(e){return this.Radius()*Math.cos(e*2*Math.PI)+this.center.coords.usrCoords[1]},Y:function(e){return this.Radius()*Math.sin(e*2*Math.PI)+this.center.coords.usrCoords[2]},Z:function(e){return 1},minX:function(){return 0},maxX:function(){return 1},Area:function(){var e=this.Radius();return e*e*Math.PI},bounds:function(){var e=this.center.coords.usrCoords,f=this.Radius();return[e[1]-f,e[2]+f,e[1]+f,e[2]-f]}});JXG.createCircle=function(l,g,f){var k,m,j,e,h=true;m=[];for(j=0;j<g.length;j++){if(JXG.isPoint(g[j])){m[j]=g[j]}else{if(g[j].length>1){e=JXG.copyAttributes(f,l.options,"circle","center");m[j]=l.create("point",g[j],e)}else{m[j]=g[j]}}}e=JXG.copyAttributes(f,l.options,"circle");if(g.length==2&&JXG.isPoint(m[0])&&JXG.isPoint(m[1])){k=new JXG.Circle(l,"twoPoints",m[0],m[1],e)}else{if((JXG.isNumber(m[0])||JXG.isFunction(m[0])||JXG.isString(m[0]))&&JXG.isPoint(m[1])){k=new JXG.Circle(l,"pointRadius",m[1],m[0],e)}else{if((JXG.isNumber(m[1])||JXG.isFunction(m[1])||JXG.isString(m[1]))&&JXG.isPoint(m[0])){k=new JXG.Circle(l,"pointRadius",m[0],m[1],e)}else{if((m[0].elementClass==JXG.OBJECT_CLASS_CIRCLE)&&JXG.isPoint(m[1])){k=new JXG.Circle(l,"pointCircle",m[1],m[0],e)}else{if((m[1].elementClass==JXG.OBJECT_CLASS_CIRCLE)&&JXG.isPoint(m[0])){k=new JXG.Circle(l,"pointCircle",m[0],m[1],e)}else{if((m[0].elementClass==JXG.OBJECT_CLASS_LINE)&&JXG.isPoint(m[1])){k=new JXG.Circle(l,"pointLine",m[1],m[0],e)}else{if((m[1].elementClass==JXG.OBJECT_CLASS_LINE)&&JXG.isPoint(m[0])){k=new JXG.Circle(l,"pointLine",m[0],m[1],e)}else{if(g.length==3&&JXG.isPoint(m[0])&&JXG.isPoint(m[1])&&JXG.isPoint(m[2])){k=JXG.createCircumcircle(l,m,f)}else{throw new Error("JSXGraph: Can't create circle with parent types '"+(typeof g[0])+"' and '"+(typeof g[1])+"'.\nPossible parent types: [point,point], [point,number], [point,function], [point,circle], [point,point,point]")}}}}}}}}k.isDraggable=h;k.parents=[];for(j=0;j<g.length;j++){if(g[j].id){k.parents.push(g[j].id)}}k.elType="circle";return k};JXG.JSXGraph.registerElement("circle",JXG.createCircle);JXG.createEllipse=function(o,q,j){var s=[],f,e,l,m,k=JXG.copyAttributes(j,o.options,"conic","foci"),n=JXG.copyAttributes(j,o.options,"conic");for(l=0;l<2;l++){if(q[l].length>1){s[l]=o.create("point",q[l],k)}else{if(JXG.isPoint(q[l])){s[l]=JXG.getReference(o,q[l])}else{if((typeof q[l]=="function")&&(q[l]().elementClass===JXG.OBJECT_CLASS_POINT)){s[l]=q[l]()}else{if(JXG.isString(q[l])){s[l]=JXG.getReference(o,q[l])}else{throw new Error("JSXGraph: Can't create Ellipse with parent types '"+(typeof q[0])+"' and '"+(typeof q[1])+"'.\nPossible parent types: [point,point,point], [point,point,number|function]")}}}}}if(JXG.isNumber(q[2])){e=JXG.createFunction(q[2],o)}else{if((typeof q[2]=="function")&&(JXG.isNumber(q[2]()))){e=q[2]}else{if(JXG.isPoint(q[2])){f=JXG.getReference(o,q[2])}else{if(q[2].length>1){f=o.create("point",q[2],k)}else{if((typeof q[2]=="function")&&(q[2]().elementClass==JXG.OBJECT_CLASS_POINT)){f=q[2]()}else{if(JXG.isString(q[2])){f=JXG.getReference(o,q[2])}else{throw new Error("JSXGraph: Can't create Ellipse with parent types '"+(typeof q[0])+"' and '"+(typeof q[1])+"' and '"+(typeof q[2])+"'.\nPossible parent types: [point,point,point], [point,point,number|function]")}}}}e=function(){return f.Dist(s[0])+f.Dist(s[1])}}}if(typeof q[4]=="undefined"){q[4]=1.0001*Math.PI}if(typeof q[3]=="undefined"){q[3]=-1.0001*Math.PI}var p=o.create("point",[function(){return(s[0].X()+s[1].X())*0.5},function(){return(s[0].Y()+s[1].Y())*0.5}],k);var r=function(){var i=s[0].X(),C=s[0].Y(),z=s[1].X(),w=s[1].Y(),B,A,v;var u=(z-i>0)?1:-1;if(Math.abs(z-i)>1e-7){B=Math.atan2(w-C,z-i)+((u<0)?Math.PI:0)}else{B=((w-C>0)?0.5:-0.5)*Math.PI}A=Math.cos(B);v=Math.sin(B);var t=[[1,0,0],[p.X(),A,-v],[p.Y(),v,A]];return t};var g=o.create("curve",[function(i){return 0},function(i){return 0},q[3],q[4]],n);var h=function(v,t){var B=e()*0.5,i=B*B,u=s[1].Dist(s[0])*0.5,w=i-u*u,A=Math.sqrt(w),z=[[1,0,0],[0,1,0],[0,0,1]],D,C;if(!t){m=r();D=p.X();C=p.Y();z[0][0]=m[0][0];z[0][1]=0;z[0][2]=0;z[1][0]=D*(1-m[1][1])+C*m[1][2];z[1][1]=m[1][1];z[1][2]=m[2][1];z[2][0]=C*(1-m[1][1])-D*m[1][2];z[2][1]=m[1][2];z[2][2]=m[2][2];g.quadraticform=JXG.Math.matMatMult(JXG.Math.transpose(z),JXG.Math.matMatMult([[-1+D*D/(B*B)+C*C/w,-D/i,-D/w],[-D/i,1/i,0],[-C/w,0,1/w]],z))}return JXG.Math.matVecMult(m,[1,B*Math.cos(v),A*Math.sin(v)])};g.X=function(i,t){return h(i,t)[1]};g.Y=function(i,t){return h(i,t)[2]};g.midpoint=p;g.type=JXG.OBJECT_TYPE_CONIC;return g};JXG.createHyperbola=function(o,q,j){var s=[],f,e,l,m,k=JXG.copyAttributes(j,o.options,"conic","foci"),n=JXG.copyAttributes(j,o.options,"conic");for(l=0;l<2;l++){if(q[l].length>1){s[l]=o.create("point",q[l],attr_focu)}else{if(JXG.isPoint(q[l])){s[l]=JXG.getReference(o,q[l])}else{if((typeof q[l]=="function")&&(q[l]().elementClass==JXG.OBJECT_CLASS_POINT)){s[l]=q[l]()}else{if(JXG.isString(q[l])){s[l]=JXG.getReference(o,q[l])}else{throw new Error("JSXGraph: Can't create Hyperbola with parent types '"+(typeof q[0])+"' and '"+(typeof q[1])+"'.\nPossible parent types: [point,point,point], [point,point,number|function]")}}}}}if(JXG.isNumber(q[2])){e=JXG.createFunction(q[2],o)}else{if((typeof q[2]=="function")&&(JXG.isNumber(q[2]()))){e=q[2]}else{if(JXG.isPoint(q[2])){f=JXG.getReference(o,q[2])}else{if(q[2].length>1){f=o.create("point",q[2],k)}else{if((typeof q[2]=="function")&&(q[2]().elementClass==JXG.OBJECT_CLASS_POINT)){f=q[2]()}else{if(JXG.isString(q[2])){f=JXG.getReference(o,q[2])}else{throw new Error("JSXGraph: Can't create Hyperbola with parent types '"+(typeof q[0])+"' and '"+(typeof q[1])+"' and '"+(typeof q[2])+"'.\nPossible parent types: [point,point,point], [point,point,number|function]")}}}}e=function(){return f.Dist(s[0])-f.Dist(s[1])}}}if(typeof q[4]=="undefined"){q[4]=1.0001*Math.PI}if(typeof q[3]=="undefined"){q[3]=-1.0001*Math.PI}var p=o.create("point",[function(){return(s[0].X()+s[1].X())*0.5},function(){return(s[0].Y()+s[1].Y())*0.5}],k);var r=function(){var u=s[0].X(),t=s[0].Y(),A=s[1].X(),w=s[1].Y(),v;var z=(A-u>0)?1:-1;if(Math.abs(A-u)>1e-7){v=Math.atan2(w-t,A-u)+((z<0)?Math.PI:0)}else{v=((w-t>0)?0.5:-0.5)*Math.PI}var i=[[1,0,0],[p.X(),Math.cos(v),-Math.sin(v)],[p.Y(),Math.sin(v),Math.cos(v)]];return i};var g=o.create("curve",[function(i){return 0},function(i){return 0},q[3],q[4]],n);var h=function(v,t){var B=e()*0.5,i=B*B,u=s[1].Dist(s[0])*0.5,A=Math.sqrt(-B*B+u*u),w=A*A,z=[[1,0,0],[0,1,0],[0,0,1]],D,C;if(!t){m=r();D=p.X();C=p.Y();z[0][0]=m[0][0];z[0][1]=0;z[0][2]=0;z[1][0]=D*(1-m[1][1])+C*m[1][2];z[1][1]=m[1][1];z[1][2]=m[2][1];z[2][0]=C*(1-m[1][1])-D*m[1][2];z[2][1]=m[1][2];z[2][2]=m[2][2];g.quadraticform=JXG.Math.matMatMult(JXG.Math.transpose(z),JXG.Math.matMatMult([[-1+D*D/i+C*C/w,-D/i,C/w],[-D/i,1/i,0],[C/w,0,-1/w]],z))}return JXG.Math.matVecMult(m,[1,B/Math.cos(v),A*Math.tan(v)])};g.X=function(i,t){return h(i,t)[1]};g.Y=function(i,t){return h(i,t)[2]};g.midpoint=p;g.type=JXG.OBJECT_TYPE_CONIC;return g};JXG.createParabola=function(n,p,h){var m=p[0],f=p[1],j,i=JXG.copyAttributes(h,n.options,"conic","foci"),k=JXG.copyAttributes(h,n.options,"conic");if(p[0].length>1){m=n.create("point",p[0],i)}else{if(JXG.isPoint(p[0])){m=JXG.getReference(n,p[0])}else{if((typeof p[0]=="function")&&(p[0]().elementClass==JXG.OBJECT_CLASS_POINT)){m=p[0]()}else{if(JXG.isString(p[0])){m=JXG.getReference(n,p[0])}else{throw new Error("JSXGraph: Can't create Parabola with parent types '"+(typeof p[0])+"' and '"+(typeof p[1])+"'.\nPossible parent types: [point,line]")}}}}if(typeof p[3]=="undefined"){p[3]=10}if(typeof p[2]=="undefined"){p[2]=-10}var o=n.create("point",[function(){var l=[0,f.stdform[1],f.stdform[2]];l=JXG.Math.crossProduct(l,m.coords.usrCoords);return JXG.Math.Geometry.meetLineLine(l,f.stdform,0,n).usrCoords}],i);var q=function(){var s=Math.atan(f.getSlope()),r=(o.X()+m.X())*0.5,t=(o.Y()+m.Y())*0.5;s+=(m.Y()-o.Y()<0||(m.Y()==o.Y()&&m.X()>o.X()))?Math.PI:0;var l=[[1,0,0],[r*(1-Math.cos(s))+t*Math.sin(s),Math.cos(s),-Math.sin(s)],[t*(1-Math.cos(s))-r*Math.sin(s),Math.sin(s),Math.cos(s)]];return l};var e=n.create("curve",[function(l){return 0},function(l){return 0},p[2],p[3]],k);var g=function(u,v){var w=o.Dist(m)*0.5,s=[[1,0,0],[0,1,0],[0,0,1]],r=(o.X()+m.X())*0.5,l=(o.Y()+m.Y())*0.5;if(!v){j=q();s[0][0]=j[0][0];s[0][1]=0;s[0][2]=0;s[1][0]=r*(1-j[1][1])+l*j[1][2];s[1][1]=j[1][1];s[1][2]=j[2][1];s[2][0]=l*(1-j[1][1])-r*j[1][2];s[2][1]=j[1][2];s[2][2]=j[2][2];e.quadraticform=JXG.Math.matMatMult(JXG.Math.transpose(s),JXG.Math.matMatMult([[-l*4*w-r*r,r,2*w],[r,-1,0],[2*w,0,0]],s))}return JXG.Math.matVecMult(j,[1,u+r,u*u/(w*4)+l])};e.X=function(l,r){return g(l,r)[1]};e.Y=function(l,r){return g(l,r)[2]};e.type=JXG.OBJECT_TYPE_CONIC;return e};JXG.createConic=function(f,z,h){var k=[[1,0,0],[0,1,0],[0,0,1]],E,C,B,A,g=[[1,0,0],[0,1,0],[0,0,1]],q,o,u=[],v,s,D,n=[],t=JXG.copyAttributes(h,f.options,"conic","foci"),r=JXG.copyAttributes(h,f.options,"conic");if(z.length==5){D=true}else{if(z.length==6){D=false}else{throw new Error("JSXGraph: Can't create generic Conic with "+parent.length+" parameters.")}}if(D){for(v=0;v<5;v++){if(z[v].length>1){u[v]=f.create("point",z[v],t)}else{if(JXG.isPoint(z[v])){u[v]=JXG.getReference(f,z[v])}else{if((typeof z[v]=="function")&&(z[v]().elementClass==JXG.OBJECT_CLASS_POINT)){u[v]=z[v]()}else{if(JXG.isString(z[v])){u[v]=JXG.getReference(f,z[v])}else{throw new Error("JSXGraph: Can't create Conic section with parent types '"+(typeof z[v])+"'.\nPossible parent types: [point,point,point,point,point], [a00,a11,a22,a01,a02,a12]")}}}}}}else{s=[[0,0,0],[0,0,0],[0,0,0]];s[0][0]=(JXG.isFunction(z[2]))?function(){return z[2]()}:function(){return z[2]};s[0][1]=(JXG.isFunction(z[4]))?function(){return z[4]()}:function(){return z[4]};s[0][2]=(JXG.isFunction(z[5]))?function(){return z[5]()}:function(){return z[5]};s[1][1]=(JXG.isFunction(z[0]))?function(){return z[0]()}:function(){return z[0]};s[1][2]=(JXG.isFunction(z[3]))?function(){return z[3]()}:function(){return z[3]};s[2][2]=(JXG.isFunction(z[1]))?function(){return z[1]()}:function(){return z[1]}}var j=function(p){var G,F;for(G=0;G<3;G++){for(F=G;F<3;F++){p[G][F]+=p[F][G]}}for(G=0;G<3;G++){for(F=0;F<G;F++){p[G][F]=p[F][G]}}return p};var m=function(F,p){var I,G,H=[[0,0,0],[0,0,0],[0,0,0]];for(I=0;I<3;I++){for(G=0;G<3;G++){H[I][G]=F[I]*p[G]}}return j(H)};var w=function(I,G,H){var L,M,F,N=[[0,0,0],[0,0,0],[0,0,0]],K,J;F=JXG.Math.matVecMult(G,H);L=JXG.Math.innerProduct(H,F);F=JXG.Math.matVecMult(I,H);M=JXG.Math.innerProduct(H,F);for(K=0;K<3;K++){for(J=0;J<3;J++){N[K][J]=L*I[K][J]-M*G[K][J]}}return N};var l=f.create("curve",[function(i){return 0},function(i){return 0},0,2*Math.PI],r);var e=function(I,J){var H,G,p,F;if(!J){if(D){for(H=0;H<5;H++){n[H]=u[H].coords.usrCoords}q=m(JXG.Math.crossProduct(n[0],n[1]),JXG.Math.crossProduct(n[2],n[3]));o=m(JXG.Math.crossProduct(n[0],n[2]),JXG.Math.crossProduct(n[1],n[3]));g=w(q,o,n[4])}else{for(H=0;H<3;H++){for(G=H;G<3;G++){g[H][G]=s[H][G]();if(G>H){g[G][H]=g[H][G]}}}}l.quadraticform=g;E=JXG.Math.Numerics.Jacobi(g);if(E[0][0][0]<0){E[0][0][0]*=(-1);E[0][1][1]*=(-1);E[0][2][2]*=(-1)}for(H=0;H<3;H++){p=0;for(G=0;G<3;G++){p+=E[1][G][H]*E[1][G][H]}p=Math.sqrt(p);for(G=0;G<3;G++){}}k=E[1];A=Math.sqrt(Math.abs(E[0][0][0]));C=Math.sqrt(Math.abs(E[0][1][1]));B=Math.sqrt(Math.abs(E[0][2][2]))}if(E[0][1][1]<=0&&E[0][2][2]<=0){F=JXG.Math.matVecMult(k,[1/A,Math.cos(I)/C,Math.sin(I)/B])}else{if(E[0][1][1]<=0&&E[0][2][2]>0){F=JXG.Math.matVecMult(k,[Math.cos(I)/A,1/C,Math.sin(I)/B])}else{if(E[0][2][2]<0){F=JXG.Math.matVecMult(k,[Math.sin(I)/A,Math.cos(I)/C,1/B])}}}F[1]/=F[0];F[2]/=F[0];F[0]=1;return F};l.X=function(i,p){return e(i,p)[1]};l.Y=function(i,p){return e(i,p)[2]};l.midpoint=f.create("point",[function(){var i=l.quadraticform;return[i[1][1]*i[2][2]-i[1][2]*i[1][2],i[1][2]*i[0][2]-i[2][2]*i[0][1],i[0][1]*i[1][2]-i[1][1]*i[0][2]]}],t);l.type=JXG.OBJECT_TYPE_CONIC;return l};JXG.JSXGraph.registerElement("ellipse",JXG.createEllipse);JXG.JSXGraph.registerElement("hyperbola",JXG.createHyperbola);JXG.JSXGraph.registerElement("parabola",JXG.createParabola);JXG.JSXGraph.registerElement("conic",JXG.createConic);JXG.Polygon=function(j,g,f){this.constructor(j,f,JXG.OBJECT_TYPE_POLYGON,JXG.OBJECT_CLASS_AREA);var h,m,e,k=JXG.copyAttributes(f,j.options,"polygon","borders");this.withLines=f.withlines;this.attr_line=k;this.vertices=[];for(h=0;h<g.length;h++){m=JXG.getRef(this.board,g[h]);this.vertices[h]=m}if(this.vertices[this.vertices.length-1]!=this.vertices[0]){this.vertices.push(this.vertices[0])}this.borders=[];if(this.withLines){for(h=0;h<this.vertices.length-1;h++){k.id=k.ids&&k.ids[h];k.strokecolor=JXG.isArray(k.colors)&&k.colors[h%k.colors.length]||k.strokecolor;if(k.strokecolor===false){k.strokecolor="none"}e=JXG.createSegment(j,[this.vertices[h],this.vertices[h+1]],k);e.dump=false;this.borders[h]=e;e.parentPolygon=this}}for(h=0;h<this.vertices.length-1;h++){m=JXG.getReference(this.board,this.vertices[h]);m.addChild(this)}this.createLabel();this.id=this.board.setId(this,"Py");this.board.renderer.drawPolygon(this);this.board.finalizeAdding(this);this.methodMap.borders="borders";this.methodMap.vertices="vertices";this.elType="polygon"};JXG.Polygon.prototype=new JXG.GeometryElement;JXG.extend(JXG.Polygon.prototype,{hasPoint:function(f,l){var h,g,e,k=false;if(this.visProp.hasinnerpoints){e=this.vertices.length;for(h=0,g=e-2;h<e-1;g=h++){if(((this.vertices[h].coords.scrCoords[2]>l)!=(this.vertices[g].coords.scrCoords[2]>l))&&(f<(this.vertices[g].coords.scrCoords[1]-this.vertices[h].coords.scrCoords[1])*(l-this.vertices[h].coords.scrCoords[2])/(this.vertices[g].coords.scrCoords[2]-this.vertices[h].coords.scrCoords[2])+this.vertices[h].coords.scrCoords[1])){k=!k}}}else{e=this.borders.length;for(h=0;h<e;h++){if(this.borders[h].hasPoint(f,l)){k=true;break}}}return k},updateRenderer:function(){if(this.needsUpdate){this.board.renderer.updatePolygon(this);this.needsUpdate=false}if(this.hasLabel&&this.label.content.visProp.visible){this.label.content.update();this.board.renderer.updateText(this.label.content)}},getTextAnchor:function(){var g=this.vertices[0].X(),f=this.vertices[0].Y(),e=g,j=f,h;for(h=0;h<this.vertices.length;h++){if(this.vertices[h].X()<g){g=this.vertices[h].X()}if(this.vertices[h].X()>e){e=this.vertices[h].X()}if(this.vertices[h].Y()>f){f=this.vertices[h].Y()}if(this.vertices[h].Y()<j){j=this.vertices[h].Y()}}return new JXG.Coords(JXG.COORDS_BY_USER,[(g+e)*0.5,(f+j)*0.5],this.board)},getLabelAnchor:JXG.shortcut(JXG.Polygon.prototype,"getTextAnchor"),cloneToBackground:function(){var f={},e;f.id=this.id+"T"+this.numTraces;this.numTraces++;f.vertices=this.vertices;f.visProp=JXG.deepCopy(this.visProp,this.visProp.traceattributes,true);f.visProp.layer=this.board.options.layer.trace;f.board=this.board;JXG.clearVisPropOld(f);e=this.board.renderer.enhancedRendering;this.board.renderer.enhancedRendering=true;this.board.renderer.drawPolygon(f);this.board.renderer.enhancedRendering=e;this.traces[f.id]=f.rendNode;return this},hideElement:function(){var e;this.visProp.visible=false;this.board.renderer.hide(this);for(e=0;e<this.borders.length;e++){this.borders[e].hideElement()}if(this.hasLabel&&JXG.exists(this.label)){this.label.hiddenByParent=true;if(this.label.content.visProp.visible){this.board.renderer.hide(this.label.content)}}},showElement:function(){var e;this.visProp.visible=true;this.board.renderer.show(this);for(e=0;e<this.borders.length;e++){this.borders[e].showElement()}if(this.hasLabel&&JXG.exists(this.label)){if(this.label.content.visProp.visible){this.board.renderer.show(this.label.content)}}},Area:function(){var f=0,e;for(e=0;e<this.vertices.length-1;e++){f+=(this.vertices[e].X()*this.vertices[e+1].Y()-this.vertices[e+1].X()*this.vertices[e].Y())}f/=2;return Math.abs(f)},remove:function(){var e;for(e=0;e<this.borders.length;e++){this.board.removeObject(this.borders[e])}this.board.renderer.remove(this.rendNode)},findPoint:function(f){var e;if(!JXG.isPoint(f)){return -1}for(e=0;e<this.vertices.length;e++){if(this.vertices[e].id===f.id){return e}}return -1},addPoints:function(){var e=Array.prototype.slice.call(arguments);return this.insertPoints.apply(this,[this.vertices.length-2].concat(e))},insertPoints:function(){var e,g,h=[],f;if(arguments.length===0){return this}e=arguments[0];if(e<0||e>this.vertices.length-2){return this}for(g=1;g<arguments.length;g++){if(JXG.isPoint(arguments[g])){h.push(arguments[g])}}f=this.vertices.slice(0,e+1).concat(h);this.vertices=f.concat(this.vertices.slice(e+1));if(this.withLines){f=this.borders.slice(0,e);this.board.removeObject(this.borders[e]);for(g=0;g<h.length;g++){f.push(JXG.createSegment(this.board,[this.vertices[e+g],this.vertices[e+g+1]],this.attr_line))}f.push(JXG.createSegment(this.board,[this.vertices[e+h.length],this.vertices[e+h.length+1]],this.attr_line));this.borders=f.concat(this.borders.slice(e))}this.board.update();return this},removePoints:function(){var l,h,f,k=[],m=[],e=[],g=[];this.vertices=this.vertices.slice(0,this.vertices.length-1);for(l=0;l<arguments.length;l++){if(JXG.isPoint(arguments[l])){f=this.findPoint(arguments[l])}if(JXG.isNumber(f)&&f>-1&&f<this.vertices.length&&JXG.indexOf(e,f)===-1){e.push(f)}}e=e.sort();k=this.vertices.slice();m=this.borders.slice();if(this.withLines){g.push([e[e.length-1]])}for(l=e.length-1;l>-1;l--){k[e[l]]=-1;if(this.withLines&&(e[l]-1>e[l-1])){g[g.length-1][1]=e[l];g.push([e[l-1]])}}if(this.withLines){g[g.length-1][1]=e[0]}this.vertices=[];for(l=0;l<k.length;l++){if(JXG.isPoint(k[l])){this.vertices.push(k[l])}}if(this.vertices[this.vertices.length-1].id!==this.vertices[0].id){this.vertices.push(this.vertices[0])}if(this.withLines){for(l=0;l<g.length;l++){for(h=g[l][1]-1;h<g[l][0]+1;h++){if(h<0){h=0;this.board.removeObject(this.borders[m.length-1]);m[m.length-1]=-1}else{if(h>m.length-1){h=m.length-1}}this.board.removeObject(this.borders[h]);m[h]=-1}if(g[l][1]!==0&&g[l][0]!==k.length-1){m[g[l][0]-1]=JXG.createSegment(this.board,[k[Math.max(g[l][1]-1,0)],k[Math.min(g[l][0]+1,this.vertices.length-1)]],this.attr_line)}}this.borders=[];for(l=0;l<m.length;l++){if(m[l]!==-1){this.borders.push(m[l])}}if(g[0][1]===5||g[g.length-1][1]===0){this.borders.push(JXG.createSegment(this.board,[this.vertices[0],this.vertices[this.vertices.length-2]],this.attr_line))}}this.board.update();return this},getParents:function(){var f=[],e;for(e=0;e<this.vertices.length;e++){f.push(this.vertices[e].id)}return f},getAttributes:function(){var e=JXG.GeometryElement.prototype.getAttributes.call(this),f;if(this.withLines){e.lines=e.lines||{};e.lines.ids=[];e.lines.colors=[];for(f=0;f<this.borders.length;f++){e.lines.ids.push(this.borders[f].id);e.lines.colors.push(this.borders[f].visProp.strokecolor)}}return e}});JXG.createPolygon=function(k,g,f){var j,h,e=JXG.copyAttributes(f,k.options,"polygon");for(h=0;h<g.length;h++){g[h]=JXG.getReference(k,g[h]);if(!JXG.isPoint(g[h])){throw new Error("JSXGraph: Can't create polygon with parent types other than 'point'.")}}j=new JXG.Polygon(k,g,e);return j};JXG.createRegularPolygon=function(o,s,j){var g,k,h,e=[],f,r,l,q,m;if(JXG.isNumber(s[s.length-1])&&s.length!=3){throw new Error("JSXGraph: A regular polygon needs two points and a number as input.")}l=s.length;h=s[l-1];if((!JXG.isNumber(h)&&!JXG.isPoint(JXG.getReference(o,h)))||h<3){throw new Error("JSXGraph: The third parameter has to be number greater than 2 or a point.")}if(JXG.isPoint(JXG.getReference(o,h))){h=l;q=true}else{l--;q=false}for(k=0;k<l;k++){s[k]=JXG.getReference(o,s[k]);if(!JXG.isPoint(s[k])){throw new Error("JSXGraph: Can't create regular polygon if the first two parameters aren't points.")}}e[0]=s[0];e[1]=s[1];m=JXG.copyAttributes(j,o.options,"polygon","vertices");for(k=2;k<h;k++){f=o.create("transform",[Math.PI*(2-(h-2)/h),e[k-1]],{type:"rotate"});if(q){e[k]=s[k];e[k].addTransform(s[k-2],f)}else{if(JXG.isArray(m.ids)&&m.ids.length>=h-2){m.id=m.ids[k-2]}e[k]=o.create("point",[e[k-2],f],m);e[k].type=JXG.OBJECT_TYPE_CAS}}m=JXG.copyAttributes(j,o.options,"polygon");g=o.create("polygon",e,m);g.elType="regularpolygon";return g};JXG.JSXGraph.registerElement("polygon",JXG.createPolygon);JXG.JSXGraph.registerElement("regularpolygon",JXG.createRegularPolygon);JXG.Curve=function(g,f,e){this.constructor(g,e,JXG.OBJECT_TYPE_CURVE,JXG.OBJECT_CLASS_CURVE);this.points=[];this.numberPoints=this.visProp.numberpointshigh;this.dataX=null;this.dataY=null;if(f[0]!=null){this.varname=f[0]}else{this.varname="x"}this.xterm=f[1];this.yterm=f[2];this.generateTerm(this.varname,this.xterm,this.yterm,f[3],f[4]);this.updateCurve();this.id=this.board.setId(this,"G");this.board.renderer.drawCurve(this);this.board.finalizeAdding(this);this.createGradient();this.elType="curve";this.createLabel();if(typeof this.xterm=="string"){this.notifyParents(this.xterm)}if(typeof this.yterm=="string"){this.notifyParents(this.yterm)}};JXG.Curve.prototype=new JXG.GeometryElement;JXG.extend(JXG.Curve.prototype,{minX:function(){if(this.visProp.curvetype=="polar"){return 0}else{var e=new JXG.Coords(JXG.COORDS_BY_SCREEN,[0,0],this.board);return e.usrCoords[1]}},maxX:function(){var e;if(this.visProp.curvetype=="polar"){return 2*Math.PI}else{e=new JXG.Coords(JXG.COORDS_BY_SCREEN,[this.board.canvasWidth,0],this.board);return e.usrCoords[1]}},Z:function(e){return 1},hasPoint:function(r,q){var s,A=Infinity,I,m,C,B,v,u,w,f,J,z,o,G,l,F,h,n,p,E=this.visProp.numberpointslow,H=(this.maxX()-this.minX())/E,e=this.board.options.precision.hasPoint/this.board.unitX,g,D,k=true;e=e*e;g=new JXG.Coords(JXG.COORDS_BY_SCREEN,[r,q],this.board);r=g.usrCoords[1];q=g.usrCoords[2];if(this.visProp.curvetype=="parameter"||this.visProp.curvetype=="polar"||this.visProp.curvetype=="functiongraph"){D=this.transformations.length;for(C=0,s=this.minX();C<E;C++){v=this.X(s,k);u=this.Y(s,k);for(B=0;B<D;B++){m=this.transformations[B];m.update();I=JXG.Math.matVecMult(m.matrix,[1,v,u]);v=I[1];u=I[2]}A=(r-v)*(r-v)+(q-u)*(q-u);if(A<e){return true}s+=H}}else{if(this.visProp.curvetype=="plot"){D=this.numberPoints;for(C=0;C<D-1;C++){w=this.X(C);f=this.X(C+1);J=this.Y(C);z=this.Y(C+1);for(B=0;B<this.transformations.length;B++){m=this.transformations[B];m.update();I=JXG.Math.matVecMult(m.matrix,[1,w,J]);w=I[1];J=I[2];I=JXG.Math.matVecMult(m.matrix,[1,f,z]);f=I[1];z=I[2]}F=f-w;h=z-J;G=r-w;l=q-J;p=F*F+h*h;if(p>=JXG.Math.eps){n=G*F+l*h;o=n/p;A=G*G+l*l-o*n}else{o=0;A=G*G+l*l}if(o>=0&&o<=1&&A<e){return true}}return false}}return(A<e)},allocatePoints:function(){var f,e;e=this.numberPoints;if(this.points.length<this.numberPoints){for(f=this.points.length;f<e;f++){this.points[f]=new JXG.Coords(JXG.COORDS_BY_USER,[0,0],this.board)}}},update:function(){if(this.needsUpdate&&!this.board.needsFullUpdate&&this.Y&&this.Y.toJS){if(this.Y.toJS()==this.YtoJS){return this}this.YtoJS=this.Y.toJS()}if(this.needsUpdate){if(this.visProp.trace){this.cloneToBackground(true)}this.updateCurve()}return this},updateRenderer:function(){if(this.needsUpdate){this.board.renderer.updateCurve(this);this.needsUpdate=false;if(this.hasLabel&&this.label.content.visProp.visible){this.label.content.update();this.board.renderer.updateText(this.label.content)}}return this},updateDataArray:function(){},updateCurve:function(){var f,g,l,e,k,h,j=false;this.updateDataArray();g=this.minX();l=this.maxX();if(this.dataX!=null){this.numberPoints=this.dataX.length;f=this.numberPoints;this.allocatePoints();for(h=0;h<f;h++){e=h;if(this.dataY!=null){k=h}else{k=this.X(e)}this.points[h].setCoordinates(JXG.COORDS_BY_USER,[this.X(e,j),this.Y(k,j)],false);this.updateTransform(this.points[h]);j=true}}else{if(this.visProp.doadvancedplot){this.updateParametricCurve(g,l,f)}else{if(this.board.updateQuality==this.board.BOARD_QUALITY_HIGH){this.numberPoints=this.visProp.numberpointshigh}else{this.numberPoints=this.visProp.numberpointslow}this.allocatePoints();this.updateParametricCurveNaive(g,l,this.numberPoints)}}return this},updateParametricCurveNaive:function(g,l,f){var j,h,k=false,e=(l-g)/f;for(j=0;j<f;j++){h=g+j*e;this.points[j].setCoordinates(JXG.COORDS_BY_USER,[this.X(h,k),this.Y(h,k)],false);this.updateTransform(this.points[j]);k=true}return this},updateParametricCurve:function(E,e){var v,p,o,g=false,z=new JXG.Coords(JXG.COORDS_BY_USER,[0,0],this.board),n,m,B,f,q,G,F,s,k,w=[],h=[],D=[],A=[],r=false,u=0,C,l=function(M,L,N){var t=N[1]-M[1],K=N[2]-M[2],j=L[0]-M[1],I=L[1]-M[2],J=j*j+I*I,i,H;if(J>=JXG.Math.eps){i=(t*j+K*I)/J;if(i>0){if(i<=1){t-=i*j;K-=i*I}else{t-=j;K-=I}}}H=t*t+K*K;return Math.sqrt(H)};if(this.board.updateQuality==this.board.BOARD_QUALITY_LOW){F=15;s=10;k=10}else{F=21;s=0.7;k=0.7}A[0]=e-E;for(v=1;v<F;v++){A[v]=A[v-1]*0.5}v=1;w[0]=1;h[0]=0;p=E;z.setCoordinates(JXG.COORDS_BY_USER,[this.X(p,g),this.Y(p,g)],false);g=true;B=z.scrCoords[1];f=z.scrCoords[2];o=p;p=e;z.setCoordinates(JXG.COORDS_BY_USER,[this.X(p,g),this.Y(p,g)],false);n=z.scrCoords[1];m=z.scrCoords[2];D[0]=[n,m];q=1;G=0;this.points=[];this.points[u++]=new JXG.Coords(JXG.COORDS_BY_SCREEN,[B,f],this.board);do{r=this.isDistOK(n-B,m-f,s,k)||this.isSegmentOutside(B,f,n,m);while(G<F&&(!r||G<3)&&(this.isSegmentDefined(B,f,n,m)||G<=7)){w[q]=v;h[q]=G;D[q]=[n,m];q++;v=2*v-1;G++;p=E+v*A[G];z.setCoordinates(JXG.COORDS_BY_USER,[this.X(p,g),this.Y(p,g)],false);n=z.scrCoords[1];m=z.scrCoords[2];r=this.isDistOK(n-B,m-f,s,k)||this.isSegmentOutside(B,f,n,m)}if(u>1){C=l(this.points[u-2].scrCoords,[n,m],this.points[u-1].scrCoords);if(C<0.015){u--}}this.points[u]=new JXG.Coords(JXG.COORDS_BY_SCREEN,[n,m],this.board);this.updateTransform(this.points[u]);u++;B=n;f=m;o=p;q--;n=D[q][0];m=D[q][1];G=h[q]+1;v=w[q]*2}while(q>0&&u<500000);this.numberPoints=this.points.length;return this},isSegmentOutside:function(f,h,e,g){return(h<0&&g<0)||(h>this.board.canvasHeight&&g>this.board.canvasHeight)||(f<0&&e<0)||(f>this.board.canvasWidth&&e>this.board.canvasWidth)},isDistOK:function(g,e,h,f){return(Math.abs(g)<h&&Math.abs(e)<f)&&!isNaN(g+e)},isSegmentDefined:function(f,h,e,g){return !(isNaN(f+h)&&isNaN(e+g))},updateTransform:function(h){var g,j,f,e=this.transformations.length;for(f=0;f<e;f++){g=this.transformations[f];g.update();j=JXG.Math.matVecMult(g.matrix,h.usrCoords);h.setCoordinates(JXG.COORDS_BY_USER,[j[1],j[2]])}return h},addTransform:function(f){var g,h=JXG.isArray(f)?f:[f],e=h.length;for(g=0;g<e;g++){this.transformations.push(h[g])}return this},setPosition:function(h,e,g){var f=this.board.create("transform",[e,g],{type:"translate"});if(this.transformations.length>0&&this.transformations[this.transformations.length-1].isNumericMatrix){this.transformations[this.transformations.length-1].melt(f)}else{this.addTransform(f)}return this},generateTerm:function(f,j,g,e,k){var i,h;if(JXG.isArray(j)){this.dataX=j;this.X=function(n){var m=parseInt(Math.floor(n)),l,o;if(n<0){m=0}else{if(n>this.dataX.length-2){m=this.dataX.length-2}}if(m==n){return this.dataX[m]}else{l=this.dataX[m];o=this.dataX[m+1];return l+(o-l)*(n-m)}};this.visProp.curvetype="plot";this.numberPoints=this.dataX.length}else{this.X=JXG.createFunction(j,this.board,f);if(JXG.isString(j)){this.visProp.curvetype="functiongraph"}else{if(JXG.isFunction(j)||JXG.isNumber(j)){this.visProp.curvetype="parameter"}}}if(JXG.isArray(g)){this.dataY=g;this.Y=function(n){var m=parseInt(Math.floor(n)),l,o;if(n<0){m=0}else{if(n>this.dataY.length-2){m=this.dataY.length-2}}if(m==n){if(JXG.isFunction(this.dataY[m])){return this.dataY[m]()}else{return this.dataY[m]}}else{if(JXG.isFunction(this.dataY[m])){l=this.dataY[m]()}else{l=this.dataY[m]}if(JXG.isFunction(this.dataY[m+1])){o=this.dataY[m+1]()}else{o=this.dataY[m+1]}return l+(o-l)*(n-m)}}}else{this.Y=JXG.createFunction(g,this.board,f)}if(JXG.isFunction(j)&&JXG.isArray(g)){i=JXG.createFunction(g[0],this.board,"");h=JXG.createFunction(g[1],this.board,"");this.X=function(l){return(j)(l)*Math.cos(l)+i()};this.Y=function(l){return(j)(l)*Math.sin(l)+h()};this.visProp.curvetype="polar"}if(e!=null){this.minX=JXG.createFunction(e,this.board,"")}if(k!=null){this.maxX=JXG.createFunction(k,this.board,"")}},notifyParents:function(e){JXG.GeonextParser.findDependencies(this,e,this.board)},getLabelAnchor:function(){var k,e,j,g=0.05*this.board.canvasWidth,f=0.05*this.board.canvasHeight,i=0.95*this.board.canvasWidth,h=0.95*this.board.canvasHeight;switch(this.visProp.label.position){case"ulft":e=g;j=f;break;case"llft":e=g;j=h;break;case"rt":e=i;j=0.5*h;break;case"lrt":e=i;j=h;break;case"urt":e=i;j=f;break;case"top":e=0.5*i;j=f;break;case"bot":e=0.5*i;j=h;break;case"lft":default:e=g;j=0.5*h;break}k=new JXG.Coords(JXG.COORDS_BY_SCREEN,[e,j],this.board);return JXG.Math.Geometry.projectCoordsToCurve(k.usrCoords[1],k.usrCoords[2],0,this,this.board)[0]},cloneToBackground:function(){var f={},e;f.id=this.id+"T"+this.numTraces;f.elementClass=JXG.OBJECT_CLASS_CURVE;this.numTraces++;f.points=this.points.slice(0);f.numberPoints=this.numberPoints;f.board=this.board;f.visProp=JXG.deepCopy(this.visProp,this.visProp.traceattributes,true);f.visProp.layer=this.board.options.layer.trace;f.visProp.curvetype=this.visProp.curvetype;JXG.clearVisPropOld(f);e=this.board.renderer.enhancedRendering;this.board.renderer.enhancedRendering=true;this.board.renderer.drawCurve(f);this.board.renderer.enhancedRendering=e;this.traces[f.id]=f.rendNode;return this},bounds:function(){var m=this.visProp.numberpointslow,k=(this.maxX()-this.minX())/m,f,e,q,p,l,h,o,n,g=[this.minX(),0,this.maxX(),0];if(this.visProp.curvetype=="parameter"||this.visProp.curvetype=="polar"||this.visProp.curvetype=="functiongraph"){h=this.transformations.length;p=this.minX();for(f=0;f<m;f++){o=this.X(p,true);n=this.Y(p,true);for(e=0;e<h;e++){q=this.transformations[e];q.update();l=JXG.Math.matVecMult(q.matrix,[1,o,n]);o=l[1];n=l[2]}if(g[1]<n){g[1]=n}if(g[3]>n){g[3]=n}p+=k}}else{if(this.visProp.curvetype=="plot"){h=this.numberPoints;for(f=0;f<h;f++){n=this.Y(f);if(g[1]<n){g[1]=n}if(g[3]>n){g[3]=n}}}}return g}});JXG.createCurve=function(h,g,f){var e=JXG.copyAttributes(f,h.options,"curve");return new JXG.Curve(h,["x"].concat(g),e)};JXG.JSXGraph.registerElement("curve",JXG.createCurve);JXG.createFunctiongraph=function(i,g,f){var e,h=["x","x"].concat(g);e=JXG.copyAttributes(f,i.options,"curve");e.curvetype="functiongraph";return new JXG.Curve(i,h,e)};JXG.JSXGraph.registerElement("functiongraph",JXG.createFunctiongraph);JXG.JSXGraph.registerElement("plot",JXG.createFunctiongraph);JXG.createSpline=function(g,f,e){var h;h=function(){var k,i=[],l=[];var j=function(p,o){var n,m;if(!o){i=[];l=[];if(f.length==2&&JXG.isArray(f[0])&&JXG.isArray(f[1])&&f[0].length==f[1].length){for(n=0;n<f[0].length;n++){if(typeof f[0][n]=="function"){i.push(f[0][n]())}else{i.push(f[0][n])}if(typeof f[1][n]=="function"){l.push(f[1][n]())}else{l.push(f[1][n])}}}else{for(n=0;n<f.length;n++){if(JXG.isPoint(f[n])){i.push(f[n].X());l.push(f[n].Y())}else{if(JXG.isArray(f[n])&&f[n].length==2){for(n=0;n<f.length;n++){if(typeof f[n][0]=="function"){i.push(f[n][0]())}else{i.push(f[n][0])}if(typeof f[n][1]=="function"){l.push(f[n][1]())}else{l.push(f[n][1])}}}}}}k=JXG.Math.Numerics.splineDef(i,l)}return JXG.Math.Numerics.splineEval(p,i,l,k)};return j};return g.create("curve",["x",h()],e)};JXG.JSXGraph.registerElement("spline",JXG.createSpline);JXG.createRiemannsum=function(j,o,g){var e,m,h,k,l,i;i=JXG.copyAttributes(g,j.options,"riemannsum");i.curvetype="plot";h=o[0];e=JXG.createFunction(o[1],j,"");if(e==null){throw new Error("JSXGraph: JXG.createRiemannsum: argument '2' n has to be number or function.\nPossible parent types: [function,n:number|function,type,start:number|function,end:number|function]")}m=JXG.createFunction(o[2],j,"",false);if(m==null){throw new Error("JSXGraph: JXG.createRiemannsum: argument 3 'type' has to be string or function.\nPossible parent types: [function,n:number|function,type,start:number|function,end:number|function]")}k=[[0],[0]].concat(o.slice(3));l=j.create("curve",k,i);l.updateDataArray=function(){var f=JXG.Math.Numerics.riemann(h,e(),m(),this.minX(),this.maxX());this.dataX=f[0];this.dataY=f[1]};return l};JXG.JSXGraph.registerElement("riemannsum",JXG.createRiemannsum);JXG.createTracecurve=function(h,g,f){var k,j,i,e;if(g.length!=2){throw new Error("JSXGraph: Can't create trace curve with given parent'\nPossible parent types: [glider, point]")}j=JXG.getRef(this.board,g[0]);i=JXG.getRef(this.board,g[1]);if(j.type!=JXG.OBJECT_TYPE_GLIDER||!JXG.isPoint(i)){throw new Error("JSXGraph: Can't create trace curve with parent types '"+(typeof g[0])+"' and '"+(typeof g[1])+"'.\nPossible parent types: [glider, point]")}e=JXG.copyAttributes(f,h.options,"tracecurve");e.curvetype="plot";k=h.create("curve",[[0],[0]],e);k.updateDataArray=function(){var p,o,D,m,s,w,u,C,l=e.numberpoints,z,n=j.position,r=j.slideObject,q=r.minX(),B=r.maxX(),A;o=(B-q)/l;this.dataX=[];this.dataY=[];if(r.elementClass!=JXG.OBJECT_CLASS_CURVE){l++}for(p=0;p<l;p++){D=q+p*o;w=r.X(D)/r.Z(D);u=r.Y(D)/r.Z(D);j.setPositionDirectly(JXG.COORDS_BY_USER,w,u);z=false;for(m in this.board.objects){s=this.board.objects[m];if(s==j){z=true}if(!z){continue}if(!s.needsRegularUpdate){continue}A=s.visProp.trace;s.visProp.trace=false;s.needsUpdate=true;s.update(true);s.visProp.trace=A;if(s==i){break}}this.dataX[p]=i.X();this.dataY[p]=i.Y()}j.position=n;z=false;for(m in this.board.objects){s=this.board.objects[m];if(s==j){z=true}if(!z){continue}if(!s.needsRegularUpdate){continue}A=s.visProp.trace;s.visProp.trace=false;s.needsUpdate=true;s.update(true);s.visProp.trace=A;if(s==i){break}}};return k};JXG.JSXGraph.registerElement("tracecurve",JXG.createTracecurve);JXG.createArc=function(k,g,f){var j,e,h;if(!(g=JXG.checkParents("arc",g,[[JXG.OBJECT_CLASS_POINT,JXG.OBJECT_CLASS_POINT,JXG.OBJECT_CLASS_POINT],[JXG.OBJECT_CLASS_POINT,JXG.OBJECT_CLASS_POINT,JXG.OBJECT_CLASS_POINT,JXG.OBJECT_CLASS_POINT]]))){throw new Error("JSXGraph: Can't create Arc with parent types '"+(typeof g[0])+"' and '"+(typeof g[1])+"' and '"+(typeof g[2])+"'.\nPossible parent types: [point,point,point]")}e=JXG.copyAttributes(f,k.options,"arc");j=k.create("curve",[[0],[0]],e);j.elType="arc";j.parents=[];for(h=0;h<g.length;h++){if(g[h].id){j.parents.push(g[h].id)}}j.type=JXG.OBJECT_TYPE_ARC;j.center=JXG.getReference(k,g[0]);j.radiuspoint=JXG.getReference(k,g[1]);j.point2=j.radiuspoint;j.anglepoint=JXG.getReference(k,g[2]);j.point3=j.anglepoint;j.center.addChild(j);j.radiuspoint.addChild(j);j.anglepoint.addChild(j);j.useDirection=e.usedirection;j.updateDataArray=function(){var z=this.radiuspoint,w=this.center,u=this.anglepoint,H,p,J,E,l=JXG.Math.Geometry.rad(z,w,u),F,D=Math.ceil(l/Math.PI*90)+1,I=l/D,r=w.X(),q=w.Y(),s,o,m,t,G;if(this.useDirection){m=g[1].coords.usrCoords;t=g[3].coords.usrCoords;G=g[2].coords.usrCoords;o=(m[1]-G[1])*(m[2]-t[2])-(m[2]-G[2])*(m[1]-t[1]);if(o<0){this.radiuspoint=g[1];this.anglepoint=g[2]}else{this.radiuspoint=g[2];this.anglepoint=g[1]}}this.dataX=[z.X()];this.dataY=[z.Y()];for(H=I,F=1;F<=D;F++,H+=I){p=Math.cos(H);J=Math.sin(H);E=[[1,0,0],[r*(1-p)+q*J,p,-J],[q*(1-p)-r*J,J,p]];s=JXG.Math.matVecMult(E,z.coords.usrCoords);this.dataX.push(s[1]/s[0]);this.dataY.push(s[2]/s[0])}this.updateStdform();this.updateQuadraticform()};j.Radius=function(){return this.radiuspoint.Dist(this.center)};j.getRadius=function(){return this.Radius()};j.hasPoint=function(i,s){var m=this.board.options.precision.hasPoint/(this.board.unitX),q=new JXG.Coords(JXG.COORDS_BY_SCREEN,[i,s],this.board),n=this.Radius(),p=this.center.coords.distance(JXG.COORDS_BY_USER,q),l=(Math.abs(p-n)<m),o;if(l){o=JXG.Math.Geometry.rad(this.radiuspoint,this.center,q.usrCoords.slice(1));if(o>JXG.Math.Geometry.rad(this.radiuspoint,this.center,this.anglepoint)){l=false}}return l};j.hasPointSector=function(i,q){var p=new JXG.Coords(JXG.COORDS_BY_SCREEN,[i,q],this.board),m=this.Radius(),o=this.center.coords.distance(JXG.COORDS_BY_USER,p),l=(o<m),n;if(l){n=JXG.Math.Geometry.rad(this.radiuspoint,this.center,p.usrCoords.slice(1));if(n>JXG.Math.Geometry.rad(this.radiuspoint,this.center,this.anglepoint)){l=false}}return l};j.getTextAnchor=function(){return this.center.coords};j.getLabelAnchor=function(){var m=JXG.Math.Geometry.rad(this.radiuspoint,this.center,this.anglepoint),u=10/(this.board.unitX),s=10/(this.board.unitY),q=this.point2.coords.usrCoords,i=this.center.coords.usrCoords,l=q[1]-i[1],t=q[2]-i[2],r,o,n,p;if(this.label.content!=null){this.label.content.relativeCoords=new JXG.Coords(JXG.COORDS_BY_SCREEN,[0,0],this.board)}r=new JXG.Coords(JXG.COORDS_BY_USER,[i[1]+Math.cos(m*0.5)*l-Math.sin(m*0.5)*t,i[2]+Math.sin(m*0.5)*l+Math.cos(m*0.5)*t],this.board);o=r.usrCoords[1]-i[1];n=r.usrCoords[2]-i[2];p=Math.sqrt(o*o+n*n);o=o*(p+u)/p;n=n*(p+s)/p;return new JXG.Coords(JXG.COORDS_BY_USER,[i[1]+o,i[2]+n],this.board)};j.updateQuadraticform=function(){var i=this.center,o=i.X(),n=i.Y(),l=this.Radius();this.quadraticform=[[o*o+n*n-l*l,-o,-n],[-o,1,0],[-n,0,1]]};j.updateStdform=function(){this.stdform[3]=0.5;this.stdform[4]=this.Radius();this.stdform[1]=-this.center.coords.usrCoords[1];this.stdform[2]=-this.center.coords.usrCoords[2];this.normalize()};j.prepareUpdate().update();return j};JXG.JSXGraph.registerElement("arc",JXG.createArc);JXG.createSemicircle=function(i,g,f){var h,j,e;if((JXG.isPoint(g[0]))&&(JXG.isPoint(g[1]))){e=JXG.copyAttributes(f,i.options,"semicircle","midpoint");j=i.create("midpoint",[g[0],g[1]],e);j.dump=false;e=JXG.copyAttributes(f,i.options,"semicircle");h=i.create("arc",[j,g[1],g[0]],e);h.elType="semicircle";h.parents=[g[0].id,g[1].id];h.subs={midpoint:j};h.midpoint=j}else{throw new Error("JSXGraph: Can't create Semicircle with parent types '"+(typeof g[0])+"' and '"+(typeof g[1])+"'.\nPossible parent types: [point,point]")}return h};JXG.JSXGraph.registerElement("semicircle",JXG.createSemicircle);JXG.createCircumcircleArc=function(i,g,f){var h,j,e;if((JXG.isPoint(g[0]))&&(JXG.isPoint(g[1]))&&(JXG.isPoint(g[2]))){e=JXG.copyAttributes(f,i.options,"circumcirclearc","center");j=i.create("circumcenter",[g[0],g[1],g[2]],e);j.dump=false;e=JXG.copyAttributes(f,i.options,"circumcirclearc");e.usedirection=true;h=i.create("arc",[j,g[0],g[2],g[1]],e);h.elType="circumcirclearc";h.parents=[g[0].id,g[1].id,g[2].id];h.subs={center:j};h.center=j}else{throw new Error("JSXGraph: create Circumcircle Arc with parent types '"+(typeof g[0])+"' and '"+(typeof g[1])+"' and '"+(typeof g[2])+"'.\nPossible parent types: [point,point,point]")}return h};JXG.JSXGraph.registerElement("circumcirclearc",JXG.createCircumcircleArc);JXG.createSector=function(i,g,f){var h,e;if(!(JXG.isPoint(g[0])&&JXG.isPoint(g[1])&&JXG.isPoint(g[2]))){throw new Error("JSXGraph: Can't create Sector with parent types '"+(typeof g[0])+"' and '"+(typeof g[1])+"' and '"+(typeof g[2])+"'.")}e=JXG.copyAttributes(f,i.options,"sector");h=i.create("curve",[[0],[0]],e);h.type=JXG.OBJECT_TYPE_SECTOR;h.elType="sector";h.parents=[g[0].id,g[1].id,g[2].id];h.point1=JXG.getReference(i,g[0]);h.point2=JXG.getReference(i,g[1]);h.point3=JXG.getReference(i,g[2]);h.point1.addChild(h);h.point2.addChild(h);h.point3.addChild(h);h.useDirection=f.usedirection;h.updateDataArray=function(){var u=this.point2,t=this.point1,s=this.point3,F,m,H,z,j=JXG.Math.Geometry.rad(u,t,s),D,w=Math.ceil(j/Math.PI*90)+1,G=j/w,p=t.X(),o=t.Y(),q,l,k,r,E;if(this.useDirection){k=g[1].coords.usrCoords,r=g[3].coords.usrCoords,E=g[2].coords.usrCoords;l=(k[1]-E[1])*(k[2]-r[2])-(k[2]-E[2])*(k[1]-r[1]);if(l<0){this.point2=g[1];this.point3=g[2]}else{this.point2=g[2];this.point3=g[1]}}this.dataX=[t.X(),u.X()];this.dataY=[t.Y(),u.Y()];for(F=G,D=1;D<=w;D++,F+=G){m=Math.cos(F);H=Math.sin(F);z=[[1,0,0],[p*(1-m)+o*H,m,-H],[o*(1-m)-p*H,H,m]];q=JXG.Math.matVecMult(z,u.coords.usrCoords);this.dataX.push(q[1]/q[0]);this.dataY.push(q[2]/q[0])}this.dataX.push(t.X());this.dataY.push(t.Y())};h.Radius=function(){return this.point2.Dist(this.point1)};h.getRadius=function(){return this.Radius()};h.hasPointSector=function(j,p){var o=new JXG.Coords(JXG.COORDS_BY_SCREEN,[j,p],this.board),l=this.Radius(),n=this.point1.coords.distance(JXG.COORDS_BY_USER,o),k=(n<l),m;if(k){m=JXG.Math.Geometry.rad(this.point2,this.point1,o.usrCoords.slice(1));if(m>JXG.Math.Geometry.rad(this.point2,this.point1,this.point3)){k=false}}return k};h.getTextAnchor=function(){return this.point1.coords};h.getLabelAnchor=function(){var l=JXG.Math.Geometry.rad(this.point2,this.point1,this.point3),t=10/(this.board.unitX),r=10/(this.board.unitY),p=this.point2.coords.usrCoords,j=this.point1.coords.usrCoords,k=p[1]-j[1],s=p[2]-j[2],q,n,m,o;if(this.label.content!=null){this.label.content.relativeCoords=new JXG.Coords(JXG.COORDS_BY_SCREEN,[0,0],this.board)}q=new JXG.Coords(JXG.COORDS_BY_USER,[j[1]+Math.cos(l*0.5)*k-Math.sin(l*0.5)*s,j[2]+Math.sin(l*0.5)*k+Math.cos(l*0.5)*s],this.board);n=q.usrCoords[1]-j[1];m=q.usrCoords[2]-j[2];o=Math.sqrt(n*n+m*m);n=n*(o+t)/o;m=m*(o+r)/o;return new JXG.Coords(JXG.COORDS_BY_USER,[j[1]+n,j[2]+m],this.board)};h.prepareUpdate().update();return h};JXG.JSXGraph.registerElement("sector",JXG.createSector);JXG.createCircumcircleSector=function(i,g,f){var h,j,e;if((JXG.isPoint(g[0]))&&(JXG.isPoint(g[1]))&&(JXG.isPoint(g[2]))){e=JXG.copyAttributes(f,i.options,"circumcirclesector","center");j=i.create("circumcenter",[g[0],g[1],g[2]],e);j.dump=false;e=JXG.copyAttributes(f,i.options,"circumcirclesector");h=i.create("sector",[j,g[0],g[2],g[1]],e);h.elType="circumcirclesector";h.parents=[g[0].id,g[1].id,g[2].id];h.center=j;h.subs={center:j}}else{throw new Error("JSXGraph: Can't create circumcircle sector with parent types '"+(typeof g[0])+"' and '"+(typeof g[1])+"' and '"+(typeof g[2])+"'.")}return h};JXG.JSXGraph.registerElement("circumcirclesector",JXG.createCircumcircleSector);JXG.createAngle=function(r,v,n){var h,g,f,z,s,m,u=["&alpha;","&beta;","&gamma;","&delta;","&epsilon;","&zeta;","&eta","&theta;","&iota;","&kappa;","&lambda;","&mu;","&nu;","&xi;","&omicron;","&pi;","&rho;","&sigmaf;","&sigma;","&tau;","&upsilon;","&phi;","&chi;","&psi;","&omega;"],o=0,l,t,k,w,A,e;if((JXG.isPoint(v[0]))&&(JXG.isPoint(v[1]))&&(JXG.isPoint(v[2]))){s=JXG.copyAttributes(n,r.options,"angle");z=s.name;if(typeof z=="undefined"||z==""){while(o<u.length){l=o;t=u[o];for(h in r.objects){if(r.objects[h].type==JXG.OBJECT_TYPE_ANGLE){if(r.objects[h].name==t){o++;break}}}if(o==l){z=t;o=u.length+1}}if(o==u.length){k="&alpha;_{";w="}";A=false;l=0;while(!A){for(h in r.objects){if(r.objects[h].type==JXG.OBJECT_TYPE_ANGLE){if(r.objects[h].name==(k+l+w)){A=true;break}}}if(A){A=false}else{A=true;z=(k+l+w)}}}s.name=z}m=JXG.copyAttributes(n,r.options,"angle","radiuspoint");g=r.create("point",[function(){var i=v[0],j=v[1],p=JXG.evaluate(s.radius),q=j.Dist(i);return[j.X()+(i.X()-j.X())*p/q,j.Y()+(i.Y()-j.Y())*p/q]}],m);g.dump=false;m=JXG.copyAttributes(n,r.options,"angle","pointsquare");f=r.create("point",[function(){var i=v[2],j=v[1],p=JXG.evaluate(s.radius),q=j.Dist(i);return[j.X()+(i.X()-j.X())*p/q,j.Y()+(i.Y()-j.Y())*p/q]}],m);f.dump=false;h=r.create("sector",[v[1],g,v[2]],s);h.elType="angle";h.parents=[v[0].id,v[1].id,v[2].id];h.subs={point:g,pointsquare:f};h.updateDataArraySquare=function(){var q=v[1],p,j,i,B;p=JXG.Math.crossProduct(f.coords.usrCoords,q.coords.usrCoords);j=[-g.X()*p[1]-g.Y()*p[2],g.Z()*p[1],g.Z()*p[2]];p=JXG.Math.crossProduct(g.coords.usrCoords,q.coords.usrCoords);i=[-f.X()*p[1]-f.Y()*p[2],f.Z()*p[1],f.Z()*p[2]];B=JXG.Math.crossProduct(j,i);B[1]/=B[0];B[2]/=B[0];this.dataX=[q.X(),g.X(),B[1],f.X(),q.X()];this.dataY=[q.Y(),g.Y(),B[2],f.Y(),q.Y()]};h.updateDataArraySector=h.updateDataArray;h.updateDataArray=function(){var i=JXG.Math.Geometry.rad(v[0],v[1],v[2]);if(this.visProp.type=="square"){this.updateDataArraySquare()}else{if(this.visProp.type=="sector"){this.updateDataArraySector();if(Math.abs(i-Math.PI*0.5)<0.0025){if(this.dot.visProp.visible===false){this.dot.setProperty({visible:true})}}else{if(this.dot.visProp.visible){this.dot.setProperty({visible:false})}}}else{if(Math.abs(i-Math.PI*0.5)<0.0025){this.updateDataArraySquare()}else{this.updateDataArraySector()}}}};h.radiuspoint=g;h.point=g;h.pointsquare=f;e=JXG.copyAttributes(n,r.options,"angle","dot");h.dot=r.create("point",[function(){if(JXG.exists(h.dot)&&h.dot.visProp.visible===false){return[0,0]}var j=g.coords.usrCoords,i=r.create("transform",[-v[1].X(),-v[1].Y()],{type:"translate"});i.melt(r.create("transform",[0.5,0.5],{type:"scale"}));i.melt(r.create("transform",[JXG.Math.Geometry.rad(v[0],v[1],v[2])/2,0,0],{type:"rotate"}));i.melt(r.create("transform",[v[1].X(),v[1].Y()],{type:"translate"}));i.update();return JXG.Math.matVecMult(i.matrix,j)}],e);h.dot.dump=false;h.subs.dot=h.dot;for(o=0;o<3;o++){JXG.getRef(r,v[o]).addChild(g);JXG.getRef(r,v[o]).addChild(h.dot)}h.type=JXG.OBJECT_TYPE_ANGLE;JXG.getRef(r,v[0]).addChild(h);h.getLabelAnchor=function(){var p=JXG.Math.Geometry.rad(this.point2,this.point1,this.point3),H=13/(this.board.unitX),F=13/(this.board.unitY),D=this.point2.coords.usrCoords,i=this.point1.coords.usrCoords,j=D[1]-i[1],G=D[2]-i[2],E,B,q,C;if(this.label.content!=null){this.label.content.relativeCoords=new JXG.Coords(JXG.COORDS_BY_SCREEN,[0,0],this.board)}E=new JXG.Coords(JXG.COORDS_BY_USER,[i[1]+Math.cos(p*0.5*1.125)*j-Math.sin(p*0.5*1.125)*G,i[2]+Math.sin(p*0.5*1.125)*j+Math.cos(p*0.5*1.125)*G],this.board);B=E.usrCoords[1]-i[1];q=E.usrCoords[2]-i[2];C=Math.sqrt(B*B+q*q);B=B*(C+H)/C;q=q*(C+F)/C;return new JXG.Coords(JXG.COORDS_BY_USER,[i[1]+B,i[2]+q],this.board)};h.Value=function(){return JXG.Math.Geometry.rad(this.point2,this.point1,this.point3)};h.methodMap=JXG.deepCopy(h.methodMap,{Value:"Value"})}else{throw new Error("JSXGraph: Can't create angle with parent types '"+(typeof v[0])+"' and '"+(typeof v[1])+"' and '"+(typeof v[2])+"'.")}return h};JXG.JSXGraph.registerElement("angle",JXG.createAngle);JXG.Composition=function(i){var h=["setProperty","prepareUpdate","updateRenderer","update","highlight","noHighlight"],f=function(e){return function(){var k;for(k in g.elements){if(JXG.exists(g.elements[k][e])){g.elements[k][e].apply(g.elements[k],arguments)}}return g}},g=this,j;for(j=0;j<h.length;j++){this[h[j]]=f(h[j])}this.elements={};for(j in i){if(i.hasOwnProperty(j)){this.add(j,i[j])}}this.dump=true;this.subs={}};JXG.extend(JXG.Composition.prototype,{add:function(f,e){if(!JXG.exists(this[f])&&JXG.exists(e)){if(JXG.exists(e.id)){this.elements[e.id]=e}else{this.elements[f]=e}this[f]=e;return true}return false},remove:function(h){var f=false,g;for(g in this.elements){if(this.elements[g].id===this[h].id){f=true;break}}if(f){delete this.elements[this[h].id];delete this[h]}return f},getParents:function(){return this.parents},getType:function(){return this.elType},getAttributes:function(){var f={},g;for(g in this.subs){f[g]=this.subs[g].visProp}return this.attr}});JXG.createOrthogonalProjection=function(i,g,f){var e,j,h,k;if(JXG.isPoint(g[0])&&g[1].elementClass==JXG.OBJECT_CLASS_LINE){j=g[0];e=g[1]}else{if(JXG.isPoint(g[1])&&g[0].elementClass==JXG.OBJECT_CLASS_LINE){j=g[1];e=g[0]}else{throw new Error("JSXGraph: Can't create perpendicular point with parent types '"+(typeof g[0])+"' and '"+(typeof g[1])+"'.\nPossible parent types: [point,line]")}}attr=JXG.copyAttributes(f,i.options,"orthogonalprojection");h=i.create("point",[function(){return JXG.Math.Geometry.projectPointToLine(j,e,i)}],f);j.addChild(h);e.addChild(h);h.elType="orthogonalprojection";h.parents=[j.id,h.id];h.update();h.generatePolynomial=function(){var m=e.point1.symbolic.x;var l=e.point1.symbolic.y;var s=e.point2.symbolic.x;var r=e.point2.symbolic.y;var u=j.symbolic.x;var t=j.symbolic.y;var p=h.symbolic.x;var n=h.symbolic.y;var q="("+l+")*("+p+")-("+l+")*("+s+")+("+n+")*("+s+")-("+m+")*("+n+")+("+m+")*("+r+")-("+p+")*("+r+")";var o="("+t+")*("+l+")-("+t+")*("+r+")-("+n+")*("+l+")+("+n+")*("+r+")+("+u+")*("+m+")-("+u+")*("+s+")-("+p+")*("+m+")+("+p+")*("+s+")";return[q,o]};return h};JXG.createPerpendicular=function(j,i,h){var k,f,g,e;i[0]=JXG.getReference(j,i[0]);i[1]=JXG.getReference(j,i[1]);if(JXG.isPoint(i[0])&&i[1].elementClass==JXG.OBJECT_CLASS_LINE){f=i[1];k=i[0]}else{if(JXG.isPoint(i[1])&&i[0].elementClass==JXG.OBJECT_CLASS_LINE){f=i[0];k=i[1]}else{throw new Error("JSXGraph: Can't create perpendicular with parent types '"+(typeof i[0])+"' and '"+(typeof i[1])+"'.\nPossible parent types: [line,point]")}}e=JXG.copyAttributes(h,j.options,"perpendicular");g=JXG.createLine(j,[function(){return f.stdform[2]*k.X()-f.stdform[1]*k.Y()},function(){return -f.stdform[2]*k.Z()},function(){return f.stdform[1]*k.Z()}],e);g.elType="perpendicular";g.parents=[f.id,k.id];return g};JXG.createPerpendicularPoint=function(i,g,f){var e,j,h;if(JXG.isPoint(g[0])&&g[1].elementClass==JXG.OBJECT_CLASS_LINE){j=g[0];e=g[1]}else{if(JXG.isPoint(g[1])&&g[0].elementClass==JXG.OBJECT_CLASS_LINE){j=g[1];e=g[0]}else{throw new Error("JSXGraph: Can't create perpendicular point with parent types '"+(typeof g[0])+"' and '"+(typeof g[1])+"'.\nPossible parent types: [point,line]")}}h=i.create("point",[function(){return JXG.Math.Geometry.perpendicular(e,j,i)[0]}],f);j.addChild(h);e.addChild(h);h.elType="perpendicularpoint";h.parents=[j.id,e.id];h.update();h.generatePolynomial=function(){var l=e.point1.symbolic.x;var k=e.point1.symbolic.y;var r=e.point2.symbolic.x;var q=e.point2.symbolic.y;var t=j.symbolic.x;var s=j.symbolic.y;var o=h.symbolic.x;var m=h.symbolic.y;var p="("+k+")*("+o+")-("+k+")*("+r+")+("+m+")*("+r+")-("+l+")*("+m+")+("+l+")*("+q+")-("+o+")*("+q+")";var n="("+s+")*("+k+")-("+s+")*("+q+")-("+m+")*("+k+")+("+m+")*("+q+")+("+t+")*("+l+")-("+t+")*("+r+")-("+o+")*("+l+")+("+o+")*("+r+")";return[p,n]};return h};JXG.createPerpendicularSegment=function(k,i,h){var m,f,g,j,e;i[0]=JXG.getReference(k,i[0]);i[1]=JXG.getReference(k,i[1]);if(JXG.isPoint(i[0])&&i[1].elementClass==JXG.OBJECT_CLASS_LINE){f=i[1];m=i[0]}else{if(JXG.isPoint(i[1])&&i[0].elementClass==JXG.OBJECT_CLASS_LINE){f=i[0];m=i[1]}else{throw new Error("JSXGraph: Can't create perpendicular with parent types '"+(typeof i[0])+"' and '"+(typeof i[1])+"'.\nPossible parent types: [line,point]")}}e=JXG.copyAttributes(h,k.options,"perpendicularsegment","point");j=JXG.createPerpendicularPoint(k,[f,m],e);j.dump=false;if(!JXG.exists(h.layer)){h.layer=k.options.layer.line}e=JXG.copyAttributes(h,k.options,"perpendicularsegment");g=JXG.createLine(k,[function(){return(JXG.Math.Geometry.perpendicular(f,m,k)[1]?[j,m]:[m,j])}],e);g.point=j;g.elType="perpendicularsegment";g.parents=[m.id,f.id];g.subs={point:j};return g};JXG.createMidpoint=function(j,h,g){var f,e,i;if(h.length==2&&JXG.isPoint(h[0])&&JXG.isPoint(h[1])){f=h[0];e=h[1]}else{if(h.length==1&&h[0].elementClass==JXG.OBJECT_CLASS_LINE){f=h[0].point1;e=h[0].point2}else{throw new Error("JSXGraph: Can't create midpoint.\nPossible parent types: [point,point], [line]")}}i=j.create("point",[function(){var k=f.coords.usrCoords[1]+e.coords.usrCoords[1];if(isNaN(k)||Math.abs(f.coords.usrCoords[0])<JXG.Math.eps||Math.abs(e.coords.usrCoords[0])<JXG.Math.eps){return NaN}else{return k*0.5}},function(){var k=f.coords.usrCoords[2]+e.coords.usrCoords[2];if(isNaN(k)||Math.abs(f.coords.usrCoords[0])<JXG.Math.eps||Math.abs(e.coords.usrCoords[0])<JXG.Math.eps){return NaN}else{return k*0.5}}],g);f.addChild(i);e.addChild(i);i.elType="midpoint";i.parents=[f.id,e.id];i.prepareUpdate().update();i.generatePolynomial=function(){var m=f.symbolic.x;var l=f.symbolic.y;var o=e.symbolic.x;var n=e.symbolic.y;var q=i.symbolic.x;var p=i.symbolic.y;var k="("+l+")*("+q+")-("+l+")*("+o+")+("+p+")*("+o+")-("+m+")*("+p+")+("+m+")*("+n+")-("+q+")*("+n+")";var r="("+m+")^2 - 2*("+m+")*("+q+")+("+l+")^2-2*("+l+")*("+p+")-("+o+")^2+2*("+o+")*("+q+")-("+n+")^2+2*("+n+")*("+p+")";return[k,r]};return i};JXG.createParallelPoint=function(i,h,g){var f,e,k,j;if(h.length==3&&h[0].elementClass==JXG.OBJECT_CLASS_POINT&&h[1].elementClass==JXG.OBJECT_CLASS_POINT&&h[2].elementClass==JXG.OBJECT_CLASS_POINT){f=h[0];e=h[1];k=h[2]}else{if(h[0].elementClass==JXG.OBJECT_CLASS_POINT&&h[1].elementClass==JXG.OBJECT_CLASS_LINE){k=h[0];f=h[1].point1;e=h[1].point2}else{if(h[1].elementClass==JXG.OBJECT_CLASS_POINT&&h[0].elementClass==JXG.OBJECT_CLASS_LINE){k=h[1];f=h[0].point1;e=h[0].point2}else{throw new Error("JSXGraph: Can't create parallel point with parent types '"+(typeof h[0])+"', '"+(typeof h[1])+"' and '"+(typeof h[2])+"'.\nPossible parent types: [line,point], [point,point,point]")}}}j=i.create("point",[function(){return k.coords.usrCoords[1]+e.coords.usrCoords[1]-f.coords.usrCoords[1]},function(){return k.coords.usrCoords[2]+e.coords.usrCoords[2]-f.coords.usrCoords[2]}],g);f.addChild(j);e.addChild(j);k.addChild(j);j.elType="parallelpoint";j.parents=[f.id,e.id,k.id];j.prepareUpdate().update();j.generatePolynomial=function(){var m=f.symbolic.x;var l=f.symbolic.y;var u=e.symbolic.x;var t=e.symbolic.y;var o=k.symbolic.x;var n=k.symbolic.y;var r=j.symbolic.x;var p=j.symbolic.y;var s="("+t+")*("+r+")-("+t+")*("+o+")-("+l+")*("+r+")+("+l+")*("+o+")-("+p+")*("+u+")+("+p+")*("+m+")+("+n+")*("+u+")-("+n+")*("+m+")";var q="("+p+")*("+m+")-("+p+")*("+o+")-("+t+")*("+m+")+("+t+")*("+o+")-("+r+")*("+l+")+("+r+")*("+n+")+("+u+")*("+l+")-("+u+")*("+n+")";return[s,q]};return j};JXG.createParallel=function(k,i,h){var l,g,j,f,e;l=null;if(i.length==3){l=i[2];f=function(){return JXG.Math.crossProduct(i[0].coords.usrCoords,i[1].coords.usrCoords)}}else{if(i[0].elementClass==JXG.OBJECT_CLASS_POINT){l=i[0];f=function(){return i[1].stdform}}else{if(i[1].elementClass==JXG.OBJECT_CLASS_POINT){l=i[1];f=function(){return i[0].stdform}}}}if(!JXG.exists(h.layer)){h.layer=k.options.layer.line}e=JXG.copyAttributes(h,k.options,"parallel","point");g=k.create("point",[function(){return JXG.Math.crossProduct([1,0,0],f())}],e);g.isDraggable=true;e=JXG.copyAttributes(h,k.options,"parallel");j=k.create("line",[l,g],e);j.elType="parallel";j.parents=[i[0].id,i[1].id];if(i.length===3){j.parents.push(i[2].id)}j.point=g;return j};JXG.createArrowParallel=function(h,g,f){var j;try{j=JXG.createParallel(h,g,f).setStraight(false,false).setArrow(false,true);j.elType="arrowparallel";return j}catch(i){throw new Error("JSXGraph: Can't create arrowparallel with parent types '"+(typeof g[0])+"' and '"+(typeof g[1])+"'.\nPossible parent types: [line,point], [point,point,point]")}};JXG.createNormal=function(q,t,k){var e,s,j,m,r,h,u;if(t.length==1){e=t[0];s=e.slideObject}else{if(t.length==2){if(JXG.isPoint(t[0])){e=t[0];s=t[1]}else{if(JXG.isPoint(t[1])){s=t[0];e=t[1]}else{throw new Error("JSXGraph: Can't create normal with parent types '"+(typeof t[0])+"' and '"+(typeof t[1])+"'.\nPossible parent types: [point,line], [point,circle], [glider]")}}}else{throw new Error("JSXGraph: Can't create normal with parent types '"+(typeof t[0])+"' and '"+(typeof t[1])+"'.\nPossible parent types: [point,line], [point,circle], [glider]")}}r=JXG.copyAttributes(k,q.options,"normal");if(s.elementClass==JXG.OBJECT_CLASS_LINE){u=JXG.copyAttributes(k,q.options,"normal","point");h=q.create("point",[function(){var f=JXG.Math.crossProduct([1,0,0],s.stdform);return[f[0],-f[2],f[1]]}],u);h.isDraggable=true;j=q.create("line",[e,h],r);j.point=h}else{if(s.elementClass==JXG.OBJECT_CLASS_CIRCLE){j=q.create("line",[s.midpoint,e],r)}else{if(s.elementClass==JXG.OBJECT_CLASS_CURVE){if(s.visProp.curvetype!="plot"){var n=s.X;var o=s.Y;j=q.create("line",[function(){return -e.X()*q.D(n)(e.position)-e.Y()*q.D(o)(e.position)},function(){return q.D(n)(e.position)},function(){return q.D(o)(e.position)}],r)}else{j=q.create("line",[function(){var g=Math.floor(e.position);var f=e.position-g;if(g==s.numberPoints-1){g--;f=1}if(g<0){return 1}return(s.Y(g)+f*(s.Y(g+1)-s.Y(g)))*(s.Y(g)-s.Y(g+1))-(s.X(g)+f*(s.X(g+1)-s.X(g)))*(s.X(g+1)-s.X(g))},function(){var f=Math.floor(e.position);if(f==s.numberPoints-1){f--}if(f<0){return 0}return s.X(f+1)-s.X(f)},function(){var f=Math.floor(e.position);if(f==s.numberPoints-1){f--}if(f<0){return 0}return s.Y(f+1)-s.Y(f)}],r)}}else{if(s.type==JXG.OBJECT_TYPE_TURTLE){j=q.create("line",[function(){var l=Math.floor(e.position);var f=e.position-l;var p,g;for(g=0;g<s.objects.length;g++){p=s.objects[g];if(p.type==JXG.OBJECT_TYPE_CURVE){if(l<p.numberPoints){break}l-=p.numberPoints}}if(l==p.numberPoints-1){l--;f=1}if(l<0){return 1}return(p.Y(l)+f*(p.Y(l+1)-p.Y(l)))*(p.Y(l)-p.Y(l+1))-(p.X(l)+f*(p.X(l+1)-p.X(l)))*(p.X(l+1)-p.X(l))},function(){var g=Math.floor(e.position);var l,f;for(f=0;f<s.objects.length;f++){l=s.objects[f];if(l.type==JXG.OBJECT_TYPE_CURVE){if(g<l.numberPoints){break}g-=l.numberPoints}}if(g==l.numberPoints-1){g--}if(g<0){return 0}return l.X(g+1)-l.X(g)},function(){var g=Math.floor(e.position);var l,f;for(f=0;f<s.objects.length;f++){l=s.objects[f];if(l.type==JXG.OBJECT_TYPE_CURVE){if(g<l.numberPoints){break}g-=l.numberPoints}}if(g==l.numberPoints-1){g--}if(g<0){return 0}return l.Y(g+1)-l.Y(g)}],r)}else{throw new Error("JSXGraph: Can't create normal with parent types '"+(typeof t[0])+"' and '"+(typeof t[1])+"'.\nPossible parent types: [point,line], [point,circle], [glider]")}}}}j.parents=[];for(m=0;m<t.length;m++){j.parents.push(t[m].id)}j.elType="normal";return j};JXG.createBisector=function(k,h,g){var m,f,j,e;if(h[0].elementClass==JXG.OBJECT_CLASS_POINT&&h[1].elementClass==JXG.OBJECT_CLASS_POINT&&h[2].elementClass==JXG.OBJECT_CLASS_POINT){e=JXG.copyAttributes(g,k.options,"bisector","point");m=k.create("point",[function(){return JXG.Math.Geometry.angleBisector(h[0],h[1],h[2],k)}],e);m.dump=false;for(j=0;j<3;j++){h[j].addChild(m)}if(!JXG.exists(g.layer)){g.layer=k.options.layer.line}e=JXG.copyAttributes(g,k.options,"bisector");f=JXG.createLine(k,[h[1],m],e);f.point=m;f.elType="bisector";f.parents=[h[0].id,h[1].id,h[2].id];f.subs={point:m};return f}else{throw new Error("JSXGraph: Can't create angle bisector with parent types '"+(typeof h[0])+"' and '"+(typeof h[1])+"'.\nPossible parent types: [point,point,point]")}};JXG.createAngularBisectorsOfTwoLines=function(j,l,h){var g=JXG.getReference(j,l[0]),f=JXG.getReference(j,l[1]),e,m,k,i;if(g.elementClass!=JXG.OBJECT_CLASS_LINE||f.elementClass!=JXG.OBJECT_CLASS_LINE){throw new Error("JSXGraph: Can't create angle bisectors of two lines with parent types '"+(typeof l[0])+"' and '"+(typeof l[1])+"'.\nPossible parent types: [line,line]")}if(!JXG.exists(h.layer)){h.layer=j.options.layer.line}k=JXG.copyAttributes(h,j.options,"bisectorlines","line1");e=j.create("line",[function(){var o=Math.sqrt(g.stdform[1]*g.stdform[1]+g.stdform[2]*g.stdform[2]);var n=Math.sqrt(f.stdform[1]*f.stdform[1]+f.stdform[2]*f.stdform[2]);return g.stdform[0]/o-f.stdform[0]/n},function(){var o=Math.sqrt(g.stdform[1]*g.stdform[1]+g.stdform[2]*g.stdform[2]);var n=Math.sqrt(f.stdform[1]*f.stdform[1]+f.stdform[2]*f.stdform[2]);return g.stdform[1]/o-f.stdform[1]/n},function(){var o=Math.sqrt(g.stdform[1]*g.stdform[1]+g.stdform[2]*g.stdform[2]);var n=Math.sqrt(f.stdform[1]*f.stdform[1]+f.stdform[2]*f.stdform[2]);return g.stdform[2]/o-f.stdform[2]/n}],k);if(!JXG.exists(h.layer)){h.layer=j.options.layer.line}k=JXG.copyAttributes(h,j.options,"bisectorlines","line2");m=j.create("line",[function(){var o=Math.sqrt(g.stdform[1]*g.stdform[1]+g.stdform[2]*g.stdform[2]);var n=Math.sqrt(f.stdform[1]*f.stdform[1]+f.stdform[2]*f.stdform[2]);return g.stdform[0]/o+f.stdform[0]/n},function(){var o=Math.sqrt(g.stdform[1]*g.stdform[1]+g.stdform[2]*g.stdform[2]);var n=Math.sqrt(f.stdform[1]*f.stdform[1]+f.stdform[2]*f.stdform[2]);return g.stdform[1]/o+f.stdform[1]/n},function(){var o=Math.sqrt(g.stdform[1]*g.stdform[1]+g.stdform[2]*g.stdform[2]);var n=Math.sqrt(f.stdform[1]*f.stdform[1]+f.stdform[2]*f.stdform[2]);return g.stdform[2]/o+f.stdform[2]/n}],k);i=new JXG.Composition({line1:e,line2:m});e.dump=false;m.dump=false;i.elType="bisectorlines";i.parents=[g.id,f.id];i.subs={line1:e,line2:m};return i};JXG.createCircumcircleMidpoint=function(h,f,e){var j,g;if(f[0].elementClass==JXG.OBJECT_CLASS_POINT&&f[1].elementClass==JXG.OBJECT_CLASS_POINT&&f[2].elementClass==JXG.OBJECT_CLASS_POINT){j=JXG.createPoint(h,[function(){return JXG.Math.Geometry.circumcenterMidpoint(f[0],f[1],f[2],h)}],e);for(g=0;g<3;g++){f[g].addChild(j)}j.elType="circumcenter";j.parents=[f[0].id,f[1].id,f[2].id];j.generatePolynomial=function(){var k=a.symbolic.x;var i=a.symbolic.y;var s=b.symbolic.x;var r=b.symbolic.y;var m=c.symbolic.x;var l=c.symbolic.y;var p=j.symbolic.x;var n=j.symbolic.y;var q=["((",p,")-(",k,"))^2+((",n,")-(",i,"))^2-((",p,")-(",s,"))^2-((",n,")-(",r,"))^2"].join("");var o=["((",p,")-(",k,"))^2+((",n,")-(",i,"))^2-((",p,")-(",m,"))^2-((",n,")-(",l,"))^2"].join("");return[q,o]};return j}else{throw new Error("JSXGraph: Can't create circumcircle midpoint with parent types '"+(typeof f[0])+"', '"+(typeof f[1])+"' and '"+(typeof f[2])+"'.\nPossible parent types: [point,point,point]")}};JXG.createIncenter=function(h,g,f){var i,l,e,k,j;if(g.length>=3&&JXG.isPoint(g[0])&&JXG.isPoint(g[1])&&JXG.isPoint(g[2])){e=g[0];k=g[1];j=g[2];i=h.create("point",[function(){var n,m,o;n=Math.sqrt((k.X()-j.X())*(k.X()-j.X())+(k.Y()-j.Y())*(k.Y()-j.Y()));m=Math.sqrt((e.X()-j.X())*(e.X()-j.X())+(e.Y()-j.Y())*(e.Y()-j.Y()));o=Math.sqrt((k.X()-e.X())*(k.X()-e.X())+(k.Y()-e.Y())*(k.Y()-e.Y()));return new JXG.Coords(JXG.COORDS_BY_USER,[(n*e.X()+m*k.X()+o*j.X())/(n+m+o),(n*e.Y()+m*k.Y()+o*j.Y())/(n+m+o)],h)}],f);i.elType="incenter";i.parents=[g[0].id,g[1].id,g[2].id]}else{throw new Error("JSXGraph: Can't create incenter with parent types '"+(typeof g[0])+"', '"+(typeof g[1])+"' and '"+(typeof g[2])+"'.\nPossible parent types: [point,point,point]")}return i};JXG.createCircumcircle=function(i,h,g){var k,l,f;try{f=JXG.copyAttributes(g,i.options,"circumcircle","center");k=JXG.createCircumcircleMidpoint(i,h,f);k.dump=false;if(!JXG.exists(g.layer)){g.layer=i.options.layer.circle}f=JXG.copyAttributes(g,i.options,"circumcircle");l=JXG.createCircle(i,[k,h[0]],f);l.elType="circumcircle";l.parents=[h[0].id,h[1].id,h[2].id];l.subs={center:k}}catch(j){throw new Error("JSXGraph: Can't create circumcircle with parent types '"+(typeof h[0])+"', '"+(typeof h[1])+"' and '"+(typeof h[2])+"'.\nPossible parent types: [point,point,point]")}return l};JXG.createIncircle=function(j,i,g){var l,m,f,h;try{f=JXG.copyAttributes(g,j.options,"incircle","center");l=JXG.createIncenter(j,i,f);l.dump=false;if(!JXG.exists(g.layer)){g.layer=j.options.layer.circle}f=JXG.copyAttributes(g,j.options,"incircle");m=JXG.createCircle(j,[l,function(){var n=Math.sqrt((i[1].X()-i[2].X())*(i[1].X()-i[2].X())+(i[1].Y()-i[2].Y())*(i[1].Y()-i[2].Y())),e=Math.sqrt((i[0].X()-i[2].X())*(i[0].X()-i[2].X())+(i[0].Y()-i[2].Y())*(i[0].Y()-i[2].Y())),p=Math.sqrt((i[1].X()-i[0].X())*(i[1].X()-i[0].X())+(i[1].Y()-i[0].Y())*(i[1].Y()-i[0].Y())),o=(n+e+p)/2;return Math.sqrt(((o-n)*(o-e)*(o-p))/o)}],f);m.elType="incircle";m.parents=[i[0].id,i[1].id,i[2].id];m.center=l;m.subs={center:l}}catch(k){throw new Error("JSXGraph: Can't create circumcircle with parent types '"+(typeof i[0])+"', '"+(typeof i[1])+"' and '"+(typeof i[2])+"'.\nPossible parent types: [point,point,point]")}return m};JXG.createReflection=function(h,g,f){var e,j,i;if(g[0].elementClass==JXG.OBJECT_CLASS_POINT&&g[1].elementClass==JXG.OBJECT_CLASS_LINE){j=g[0];e=g[1]}else{if(g[1].elementClass==JXG.OBJECT_CLASS_POINT&&g[0].elementClass==JXG.OBJECT_CLASS_LINE){j=g[1];e=g[0]}else{throw new Error("JSXGraph: Can't create reflection point with parent types '"+(typeof g[0])+"' and '"+(typeof g[1])+"'.\nPossible parent types: [line,point]")}}i=JXG.createPoint(h,[function(){return JXG.Math.Geometry.reflection(e,j,h)}],f);j.addChild(i);e.addChild(i);i.elType="reflection";i.parents=[g[0].id,g[1].id];i.prepareUpdate().update();i.generatePolynomial=function(){var l=e.point1.symbolic.x;var k=e.point1.symbolic.y;var r=e.point2.symbolic.x;var q=e.point2.symbolic.y;var t=j.symbolic.x;var s=j.symbolic.y;var n=i.symbolic.x;var m=i.symbolic.y;var p=["((",m,")-(",s,"))*((",k,")-(",q,"))+((",l,")-(",r,"))*((",n,")-(",t,"))"].join("");var o=["((",n,")-(",l,"))^2+((",m,")-(",k,"))^2-((",t,")-(",l,"))^2-((",s,")-(",k,"))^2"].join("");return[p,o]};return i};JXG.createMirrorPoint=function(h,f,e){var j,g;if(JXG.isPoint(f[0])&&JXG.isPoint(f[1])){j=JXG.createPoint(h,[function(){return JXG.Math.Geometry.rotation(f[0],f[1],Math.PI,h)}],e);for(g=0;g<2;g++){f[g].addChild(j)}j.elType="mirrorpoint";j.parents=[f[0].id,f[1].id]}else{throw new Error("JSXGraph: Can't create mirror point with parent types '"+(typeof f[0])+"' and '"+(typeof f[1])+"'.\nPossible parent types: [point,point]")}j.prepareUpdate().update();return j};JXG.createIntegral=function(j,A,n){var z,s,v,h=0,g=0,f,e,m,l,r=1,w,o,i,B,k,q,u;if(JXG.isArray(A[0])&&A[1].elementClass==JXG.OBJECT_CLASS_CURVE){z=A[0];s=A[1]}else{if(JXG.isArray(A[1])&&A[0].elementClass==JXG.OBJECT_CLASS_CURVE){z=A[1];s=A[0]}else{throw new Error("JSXGraph: Can't create integral with parent types '"+(typeof A[0])+"' and '"+(typeof A[1])+"'.\nPossible parent types: [[number|function,number|function],curve]")}}h=z[0];g=z[1];if(JXG.isFunction(h)){f=h;e=function(){return s.Y(f())};h=f()}else{f=h;e=s.Y(h)}if(JXG.isFunction(h)){m=g;l=function(){return s.Y(m())};g=m()}else{m=g;l=s.Y(g)}if(g<h){r=-1}v=JXG.copyAttributes(n,j.options,"integral","curveLeft");w=j.create("glider",[f,e,s],v);if(JXG.isFunction(f)){w.hideElement()}v=JXG.copyAttributes(n,j.options,"integral","baseLeft");o=j.create("point",[function(){return w.X()},0],v);v=JXG.copyAttributes(n,j.options,"integral","curveRight");i=j.create("glider",[m,l,s],v);if(JXG.isFunction(m)){i.hideElement()}v=JXG.copyAttributes(n,j.options,"integral","baseRight");B=j.create("point",[function(){return i.X()},0],v);v=JXG.copyAttributes(n,j.options,"integral");if(v.withLabel!==false){v=JXG.copyAttributes(n,j.options,"integral","label");q=j.create("text",[function(){return i.X()+0.2},function(){return i.Y()-0.8},function(){var p=JXG.Math.Numerics.I([o.X(),B.X()],s.Y);return"&int; = "+(p).toFixed(4)}],v);q.dump=false;w.addChild(q);i.addChild(q)}v=JXG.copyAttributes(n,j.options,"integral");u=j.create("curve",[[0],[0]],v);w.dump=false;o.dump=false;i.dump=false;B.dump=false;u.elType="integral";u.parents=[s.id,z];u.subs={curveLeft:w,baseLeft:o,curveRight:i,baseRight:B};if(v.withLabel){u.subs.label=q}u.updateDataArray=function(){var p,E,C,D,t;if(o.X()<B.X()){D=o.X();t=B.X()}else{D=B.X();t=o.X()}p=[D,D];E=[0,s.Y(D)];for(C=0;C<s.numberPoints;C++){if((D<=s.points[C].usrCoords[1])&&(s.points[C].usrCoords[1]<=t)){p.push(s.points[C].usrCoords[1]);E.push(s.points[C].usrCoords[2])}}p.push(t);E.push(s.Y(t));p.push(t);E.push(0);p.push(D);E.push(0);this.dataX=p;this.dataY=E};w.addChild(u);i.addChild(u);u.baseLeft=o;u.baseRight=B;u.curveLeft=w;u.curveRight=i;u.label={content:q};return u};JXG.createLocus=function(g,f,e){var i,h;if(JXG.isArray(f)&&f.length==1&&f[0].elementClass==JXG.OBJECT_CLASS_POINT){h=f[0]}else{throw new Error("JSXGraph: Can't create locus with parent of type other than point.\nPossible parent types: [point]")}i=g.create("curve",[[null],[null]],e);i.dontCallServer=false;i.elType="locus";i.parents=[h.id];i.updateDataArray=function(){if(i.board.mode>0){return}var k=JXG.Math.Symbolic.generatePolynomials(g,h,true).join("|");if(k===i.spe){return}i.spe=k;var j=function(n,p,m,o){i.dataX=n;i.dataY=p;i.eq=m;i.ctime=o;i.generatePolynomial=(function(q){return function(s){var r="("+s.symbolic.x+")",v="("+s.symbolic.y+")",u=[],t;for(t=0;t<q.length;t++){u[t]=q[t].replace(/\*\*/g,"^").replace(/x/g,r).replace(/y/g,v)}return u}})(m)},l=JXG.Math.Symbolic.geometricLocusByGroebnerBase(g,h,j);j(l.datax,l.datay,l.polynomial,l.exectime)};return i};JXG.createGrid=function(h,g,f){var i,e;e=JXG.copyAttributes(f,h.options,"grid");i=h.create("curve",[[null],[null]],e);i.elType="grid";i.parents=[];i.updateDataArray=function(){var j=this.visProp.gridx,n=this.visProp.gridy,m=new JXG.Coords(JXG.COORDS_BY_SCREEN,[0,0],h),l=new JXG.Coords(JXG.COORDS_BY_SCREEN,[h.canvasWidth,h.canvasHeight],h),k;h.options.grid.hasGrid=true;m.setCoordinates(JXG.COORDS_BY_USER,[Math.floor(m.usrCoords[1]/j)*j,Math.ceil(m.usrCoords[2]/n)*n]);l.setCoordinates(JXG.COORDS_BY_USER,[Math.ceil(l.usrCoords[1]/j)*j,Math.floor(l.usrCoords[2]/n)*n]);i.dataX=[];i.dataY=[];for(k=m.usrCoords[2];k>l.usrCoords[2]-n;k-=n){i.dataX.push(m.usrCoords[1],l.usrCoords[1],NaN);i.dataY.push(k,k,NaN)}for(k=m.usrCoords[1];k<l.usrCoords[1]+j;k+=j){i.dataX.push(k,k,NaN);i.dataY.push(m.usrCoords[2],l.usrCoords[2],NaN)}};i.hasPoint=function(){return false};h.grids.push(i);return i};JXG.JSXGraph.registerElement("arrowparallel",JXG.createArrowParallel);JXG.JSXGraph.registerElement("bisector",JXG.createBisector);JXG.JSXGraph.registerElement("bisectorlines",JXG.createAngularBisectorsOfTwoLines);JXG.JSXGraph.registerElement("circumcircle",JXG.createCircumcircle);JXG.JSXGraph.registerElement("circumcirclemidpoint",JXG.createCircumcircleMidpoint);JXG.JSXGraph.registerElement("circumcenter",JXG.createCircumcircleMidpoint);JXG.JSXGraph.registerElement("incenter",JXG.createIncenter);JXG.JSXGraph.registerElement("incircle",JXG.createIncircle);JXG.JSXGraph.registerElement("integral",JXG.createIntegral);JXG.JSXGraph.registerElement("midpoint",JXG.createMidpoint);JXG.JSXGraph.registerElement("mirrorpoint",JXG.createMirrorPoint);JXG.JSXGraph.registerElement("normal",JXG.createNormal);JXG.JSXGraph.registerElement("orthogonalprojection",JXG.createOrthogonalProjection);JXG.JSXGraph.registerElement("parallel",JXG.createParallel);JXG.JSXGraph.registerElement("parallelpoint",JXG.createParallelPoint);JXG.JSXGraph.registerElement("perpendicular",JXG.createPerpendicular);JXG.JSXGraph.registerElement("perpendicularpoint",JXG.createPerpendicularPoint);JXG.JSXGraph.registerElement("perpendicularsegment",JXG.createPerpendicularSegment);JXG.JSXGraph.registerElement("reflection",JXG.createReflection);JXG.JSXGraph.registerElement("locus",JXG.createLocus);JXG.JSXGraph.registerElement("grid",JXG.createGrid);JXG.Text=function(j,k,l,f){this.constructor(j,f,JXG.OBJECT_TYPE_TEXT,JXG.OBJECT_CLASS_OTHER);var h;this.content=k;this.plaintext="";this.isDraggable=false;if((this.element=JXG.getRef(this.board,f.anchor))){var g;if(this.visProp.islabel){this.relativeCoords=new JXG.Coords(JXG.COORDS_BY_SCREEN,[parseFloat(l[0]),parseFloat(l[1])],this.board)}else{this.relativeCoords=new JXG.Coords(JXG.COORDS_BY_USER,[parseFloat(l[0]),parseFloat(l[1])],this.board)}this.element.addChild(this);this.coords=new JXG.Coords(JXG.COORDS_BY_SCREEN,[0,0],this.board);this.isDraggable=true}else{if(JXG.isNumber(l[0])&&JXG.isNumber(l[1])){this.isDraggable=true}this.X=JXG.createFunction(l[0],this.board,null,true);this.Y=JXG.createFunction(l[1],this.board,null,true);this.coords=new JXG.Coords(JXG.COORDS_BY_USER,[this.X(),this.Y()],this.board);var e="this.coords.setCoordinates(JXG.COORDS_BY_USER,[this.X(),this.Y()]);";this.updateCoords=new Function("",e)}if(typeof this.content==="function"){this.updateText=function(){this.plaintext=this.content()}}else{if(JXG.isNumber(this.content)){this.content=(this.content).toFixed(this.visProp.digits)}else{if(this.visProp.useasciimathml){this.content="'`"+this.content+"`'"}else{this.content=this.generateTerm(this.content)}}this.updateText=new Function("this.plaintext = "+this.content+";")}this.updateText();this.id=this.board.setId(this,"T");this.board.renderer.drawText(this);if(!this.visProp.visible){this.board.renderer.hide(this)}if(typeof this.content==="string"){this.notifyParents(this.content)}this.size=[1,1];this.elType="text";this.methodMap=JXG.deepCopy(this.methodMap,{setText:"setTextJessieCode",free:"free",move:"setCoords"});return this};JXG.Text.prototype=new JXG.GeometryElement();JXG.extend(JXG.Text.prototype,{hasPoint:function(e,i){var g=e-this.coords.scrCoords[1],f=this.coords.scrCoords[2]-i,h=this.board.options.precision.hasPoint;return g>=-h&&g<=2*h&&f>=-h&&f<=2*h},setTextJessieCode:function(f){var e;this.visProp.castext=f;if(typeof f==="function"){e=function(){return f().replace(/</g,"&lt;").replace(/>/g,"&gt;")}}else{if(JXG.isNumber(f)){e=f}else{e=f.replace(/</g,"&lt;").replace(/>/g,"&gt;")}}return this.setText(e)},setText:function(e){if(typeof e==="function"){this.updateText=function(){this.plaintext=e()}}else{if(JXG.isNumber(e)){this.content=(e).toFixed(this.visProp.digits)}else{if(this.visProp.useasciimathml){this.content="'`"+e+"`'"}else{this.content=this.generateTerm(e)}}this.updateText=new Function("this.plaintext = "+this.content+";")}this.updateText();this.updateSize();this.needsUpdate=true;this.update();this.updateRenderer();return this},updateSize:function(){if(this.visProp.display=="html"&&this.board.renderer.type!="vml"){this.size=[this.rendNode.offsetWidth,this.rendNode.offsetHeight]}else{if(this.visProp.display=="internal"&&this.board.renderer.type=="svg"){this.size=[this.rendNode.getBBox().width,this.rendNode.getBBox().height]}else{if(this.board.renderer.type=="vml"||(this.visProp.display=="internal"&&this.board.renderer.type=="canvas")){this.size=[parseFloat(this.visProp.fontsize)*this.plaintext.length*0.45,parseFloat(this.visProp.fontsize)*0.9]}}}return this},getSize:function(){return this.size},setCoords:function(e,f){if(JXG.isArray(e)&&e.length>1){f=e[1];e=e[0]}this.X=function(){return e};this.Y=function(){return f};this.coords=new JXG.Coords(JXG.COORDS_BY_USER,[e,f],this.board);this.board.update();return this},free:function(){this.X=JXG.createFunction(this.X(),this.board,"");this.Y=JXG.createFunction(this.Y(),this.board,"");this.isDraggable=true},update:function(){var e,g,f;if(this.needsUpdate){if(this.relativeCoords){if(this.visProp.islabel){g=parseFloat(this.visProp.offsets[0]);f=-parseFloat(this.visProp.offsets[1]);e=this.element.getLabelAnchor();this.coords.setCoordinates(JXG.COORDS_BY_SCREEN,[g+this.relativeCoords.scrCoords[1]+e.scrCoords[1],f+this.relativeCoords.scrCoords[2]+e.scrCoords[2]])}else{e=this.element.getTextAnchor();this.coords.setCoordinates(JXG.COORDS_BY_USER,[this.relativeCoords.usrCoords[1]+e.usrCoords[1],this.relativeCoords.usrCoords[2]+e.usrCoords[2]])}}else{this.updateCoords()}this.updateText();this.updateTransform()}return this},updateRenderer:function(){if(this.needsUpdate){this.board.renderer.updateText(this);this.needsUpdate=false}return this},updateTransform:function(){if(this.transformations.length==0){return}for(var e=0;e<this.transformations.length;e++){this.transformations[e].update()}return this},generateTerm:function(k){var h,l='""',g;k=k||"";k=k.replace(/\r/g,"");k=k.replace(/\n/g,"");k=k.replace(/\"/g,'\\"');k=k.replace(/\'/g,"\\'");k=k.replace(/&amp;arc;/g,"&ang;");k=k.replace(/<arc\s*\/>/g,"&ang;");k=k.replace(/<sqrt\s*\/>/g,"&radic;");var f;f=k.indexOf("<value>");var e=k.indexOf("</value>");if(f>=0){while(f>=0){l+=' + "'+JXG.GeonextParser.replaceSub(JXG.GeonextParser.replaceSup(k.slice(0,f)))+'"';g=k.slice(f+7,e);h=JXG.GeonextParser.geonext2JS(g,this.board);h=h.replace(/\\"/g,'"');h=h.replace(/\\'/g,"'");if(h.indexOf("toFixed")<0){if(JXG.isNumber((JXG.bind(new Function("return "+h+";"),this))())){l+="+("+h+").toFixed("+(this.visProp.digits)+")"}else{l+="+("+h+")"}}else{l+="+("+h+")"}k=k.slice(e+8);f=k.indexOf("<value>");e=k.indexOf("</value>")}}l+=' + "'+JXG.GeonextParser.replaceSub(JXG.GeonextParser.replaceSup(k))+'"';l=l.replace(/<overline>/g,"<span style=text-decoration:overline>");l=l.replace(/<\/overline>/g,"</span>");l=l.replace(/<arrow>/g,"<span style=text-decoration:overline>");l=l.replace(/<\/arrow>/g,"</span>");l=l.replace(/&amp;/g,"&");return l},notifyParents:function(g){var f=null;do{var e=/<value>([\w\s\*\/\^\-\+\(\)\[\],<>=!]+)<\/value>/;f=e.exec(g);if(f!=null){JXG.GeonextParser.findDependencies(this,f[1],this.board);g=g.substr(f.index);g=g.replace(e,"")}}while(f!=null);return this},bounds:function(){var e=this.coords.usrCoords;return this.visProp.islabel?[0,0,0,0]:[e[1],e[2]+this.size[1],e[1]+this.size[0],e[2]]},setPositionDirectly:function(e,l,j,h,g){var f,o,n,m,k;if(this.relativeCoords){if(this.visProp.islabel){if(e==JXG.COORDS_BY_USER){k=new JXG.Coords(JXG.COORDS_BY_USER,[h,g],this.board);m=new JXG.Coords(JXG.COORDS_BY_USER,[l,j],this.board);o=m.scrCoords[1]-k.scrCoords[1];n=m.scrCoords[2]-k.scrCoords[2]}else{o=l-h;n=j-g}this.relativeCoords.scrCoords[1]+=o;this.relativeCoords.scrCoords[2]+=n}else{if(e==JXG.COORDS_BY_SCREEN){k=new JXG.Coords(JXG.COORDS_BY_SCREEN,[h,g],this.board);m=new JXG.Coords(JXG.COORDS_BY_SCREEN,[l,j],this.board);o=m.usrCoords[1]-k.usrCoords[1];n=m.usrCoords[2]-k.usrCoords[2]}else{o=l-h;n=j-g}this.relativeCoords.usrCoords[1]+=o;this.relativeCoords.usrCoords[2]+=n}}else{if(e==JXG.COORDS_BY_SCREEN){m=new JXG.Coords(JXG.COORDS_BY_SCREEN,[l,j],this.board);l=m.usrCoords[1];j=m.usrCoords[2]}this.X=JXG.createFunction(l,this.board,"");this.Y=JXG.createFunction(j,this.board,"")}return this}});JXG.createText=function(i,g,f){var e,h;e=JXG.copyAttributes(f,i.options,"text");e.anchor=e.parent||e.anchor;h=new JXG.Text(i,g[g.length-1],g,e);if(typeof g[g.length-1]!=="function"){h.parents=g}return h};JXG.JSXGraph.registerElement("text",JXG.createText);JXG.Image=function(h,f,i,g,e){this.constructor(h,e,JXG.OBJECT_TYPE_IMAGE,JXG.OBJECT_CLASS_OTHER);this.initialCoords=new JXG.Coords(JXG.COORDS_BY_USER,i,this.board);if(!JXG.isFunction(i[0])&&!JXG.isFunction(i[1])){this.isDraggable=true}this.X=JXG.createFunction(i[0],this.board,"");this.Y=JXG.createFunction(i[1],this.board,"");this.W=JXG.createFunction(g[0],this.board,"");this.H=JXG.createFunction(g[1],this.board,"");this.coords=new JXG.Coords(JXG.COORDS_BY_USER,[this.X(),this.Y()],this.board);this.updateCoords=new Function("","this.coords.setCoordinates(JXG.COORDS_BY_USER,[this.X(),this.Y()]);");this.updateSize=new Function("","this.coords.setCoordinates(JXG.COORDS_BY_USER,[this.W(),this.H()]);");this.usrSize=[this.W(),this.H()];this.size=[this.usrSize[0]*h.unitX,this.usrSize[1]*h.unitY];this.url=f;this.parent=JXG.getRef(e.anchor);this.id=this.board.setId(this,"Im");this.board.renderer.drawImage(this);if(!this.visProp.visible){this.board.renderer.hide(this)}};JXG.Image.prototype=new JXG.GeometryElement;JXG.extend(JXG.Image.prototype,{hasPoint:function(e,i){var g=e-this.coords.scrCoords[1],f=this.coords.scrCoords[2]-i,h=this.board.options.precision.hasPoint;if(g>=-h&&g<=2*h&&f>=-h&&f<=h){return true}else{return false}},update:function(){if(this.needsUpdate){this.updateCoords();this.usrSize=[this.W(),this.H()];this.size=[this.usrSize[0]*this.board.unitX,this.usrSize[1]*this.board.unitY];this.updateTransform()}return this},updateRenderer:function(){if(this.needsUpdate){this.board.renderer.updateImage(this);this.needsUpdate=false}return this},updateTransform:function(){if(this.transformations.length==0){return}for(var e=0;e<this.transformations.length;e++){this.transformations[e].update()}},addTransform:function(e){if(JXG.isArray(e)){for(var f=0;f<e.length;f++){this.transformations.push(e[f])}}else{this.transformations.push(e)}},setPositionDirectly:function(l,e,k,i,h){var j,g,f;if(l==JXG.COORDS_BY_SCREEN){j=new JXG.Coords(JXG.COORDS_BY_SCREEN,[e,k],this.board);e=j.usrCoords[1];k=j.usrCoords[2]}this.X=JXG.createFunction(e,this.board,"");this.Y=JXG.createFunction(k,this.board,"");return this}});JXG.createImage=function(i,h,f){var g,e;e=JXG.copyAttributes(f,i.options,"image");return new JXG.Image(i,h[0],h[1],h[2],e)};JXG.JSXGraph.registerElement("image",JXG.createImage);JXG.createSlider=function(p,E,q){var k,j,D,l,F,r,g,f,B,G,m,i,h,e,A,w,s,o,v,u,z,C;k=E[0];j=E[1];D=E[2][0];l=E[2][1];F=E[2][2];r=F-D;z=JXG.copyAttributes(q,p.options,"slider");v=z.withticks;o=z.withlabel;u=z.snapwidth;C=z.precision;z=JXG.copyAttributes(q,p.options,"slider","point1");g=p.create("point",k,z);z=JXG.copyAttributes(q,p.options,"slider","point2");f=p.create("point",j,z);p.create("group",[g,f]);z=JXG.copyAttributes(q,p.options,"slider","baseline");B=p.create("segment",[g,f],z);B.updateStdform();if(v){z=JXG.copyAttributes(q,p.options,"slider","ticks");G=2;m=p.create("ticks",[B,f.Dist(g)/G],z)}i=k[0]+(j[0]-k[0])*(l-D)/(F-D);h=k[1]+(j[1]-k[1])*(l-D)/(F-D);z=JXG.copyAttributes(q,p.options,"slider");z.withLabel=false;e=p.create("glider",[i,h,B],z);e.setProperty({snapwidth:u});z=JXG.copyAttributes(q,p.options,"slider","highline");A=p.create("segment",[g,e],z);e.Value=function(){return e.visProp.snapwidth===-1?this.position*r+D:Math.round((this.position*r+D)/this.visProp.snapwidth)*this.visProp.snapwidth};e.methodMap=JXG.deepCopy(e.methodMap,{Value:"Value"});e._smax=F;e._smin=D;if(o){if(q.name&&q.name!=""){w=q.name+" = "}else{w=""}z=JXG.copyAttributes(q,p.options,"slider","label");s=p.create("text",[function(){return(f.X()-g.X())*0.05+f.X()},function(){return(f.Y()-g.Y())*0.05+f.Y()},function(){return w+(e.Value()).toFixed(C)}],z);e.label.content=s}e.point1=g;e.point2=f;e.baseline=B;e.highline=A;if(v){e.ticks=m}e.remove=function(){if(o){p.removeObject(s)}p.removeObject(A);if(v){B.removeTicks(m)}p.removeObject(B);p.removeObject(f);p.removeObject(g);JXG.Point.prototype.remove.call(e)};g.dump=false;f.dump=false;B.dump=false;A.dump=false;e.elType="slider";e.parents=E;e.subs={point1:g,point2:f,baseLine:B,highLine:A};if(v){m.dump=false;e.subs.ticks=m}return e};JXG.JSXGraph.registerElement("slider",JXG.createSlider);JXG.Chart=function(j,m,f){this.constructor(j,f);var n,l,g,k,e,h;if(!JXG.isArray(m)||m.length===0){throw new Error("JSXGraph: Can't create a chart without data")}this.elements=[];if(JXG.isNumber(m[0])){l=m;n=[];for(g=0;g<l.length;g++){n[g]=g+1}}else{if(m.length===1&&JXG.isArray(m[0])){l=m[0];n=[];h=JXG.evaluate(l).length;for(g=0;g<h;g++){n[g]=g+1}}else{if(m.length===2){h=Math.min(m[0].length,m[1].length);n=m[0].slice(0,h);l=m[1].slice(0,h)}}}if(JXG.isArray(l)&&l.length===0){throw new Error("JSXGraph: Can't create charts without data.")}e=f.chartstyle.replace(/ /g,"").split(",");for(g=0;g<e.length;g++){switch(e[g]){case"bar":k=this.drawBar(j,n,l,f);break;case"line":k=this.drawLine(j,n,l,f);break;case"fit":k=this.drawFit(j,n,l,f);break;case"spline":k=this.drawSpline(j,n,l,f);break;case"pie":k=this.drawPie(j,l,f);break;case"point":k=this.drawPoints(j,n,l,f);break;case"radar":k=this.drawRadar(j,m,f);break}this.elements.push(k)}this.id=this.board.setId(this,"Chart");return this.elements};JXG.Chart.prototype=new JXG.GeometryElement;JXG.extend(JXG.Chart.prototype,{drawLine:function(g,e,h,f){f.fillcolor="none";f.highlightfillcolor="none";return g.create("curve",[e,h],f)},drawSpline:function(g,e,h,f){f.fillColor="none";f.highlightfillcolor="none";return g.create("spline",[e,h],f)},drawFit:function(g,e,i,f){var h=f.degree;h=(!JXG.exists(h)||parseInt(h)==NaN||parseInt(h)<1)?1:parseInt(h),f.fillcolor="none";f.highlightfillcolor="none";return g.create("functiongraph",[JXG.Math.Numerics.regressionPolynomial(h,e,i)],f)},drawBar:function(f,m,j,g){var v,h=[],s,u,e,r,o,q,n,l,z,k,t=[],A={fixed:true,withLabel:false,visible:false,name:""};if(!JXG.exists(g.fillopacity)){g.fillopacity=0.6}if(g&&g.width){o=g.width}else{if(m.length<=1){o=1}else{o=m[1]-m[0];for(v=1;v<m.length-1;v++){o=(m[v+1]-m[v]<o)?m[v+1]-m[v]:o}}o*=0.8}u=g.fillcolor;e=parseFloat(f.options.text.fontSize);for(v=0;v<m.length;v++){if(isNaN(JXG.evaluate(m[v]))||isNaN(j[v])){}if(JXG.isFunction(m[v])){q=function(){return m[v]()-o*0.5};n=function(){return m[v]()};l=function(){return m[v]()+o*0.5}}else{q=m[v]-o*0.5;n=m[v];l=m[v]+o*0.5}z=j[v];if(g.dir=="horizontal"){t[0]=f.create("point",[0,q],A);t[1]=f.create("point",[z,q],A);t[2]=f.create("point",[z,l],A);t[3]=f.create("point",[0,l],A);if(JXG.exists(g.labels)&&JXG.exists(g.labels[v])){s=g.labels[v].toString().length;s=2*s*e/f.unitX;if(z>=0){z+=e*0.5/f.unitX}else{z-=e*s/f.unitX}n-=e*0.2/f.unitY;r=f.create("text",[z,n,g.labels[v]],g)}}else{t[0]=f.create("point",[q,0],A);t[1]=f.create("point",[q,z],A);t[2]=f.create("point",[l,z],A);t[3]=f.create("point",[l,0],A);if(JXG.exists(g.labels)&&JXG.exists(g.labels[v])){s=g.labels[v].toString().length;s=0.6*s*e/f.unitX;if(z>=0){z+=e*0.5/f.unitY}else{z-=e*1/f.unitY}r=f.create("text",[n-s*0.5,z,g.labels[v]],g)}}g.withlines=false;if(JXG.exists(g.colors)&&JXG.isArray(g.colors)){k=g.colors;g.fillcolor=k[v%k.length]}h[v]=f.create("polygon",t,g);if(JXG.exists(g.labels)&&JXG.exists(g.labels[v])){h[v].text=r}}return h},drawPoints:function(k,e,l,g){var h,j=[],f=g.infoboxarray;g.fixed=true;g.name="";for(h=0;h<e.length;h++){g.infoboxtext=f?f[h%f.length]:false;j[h]=k.create("point",[e[h],l[h]],g)}return j},drawPie:function(t,u,l){var m,h=[],j=[],A=JXG.Math.Statistics.sum(u),w=l.colors,n=l.highlightcolors,g=l.labels,f=l.radius||4,o=f,v=l.center||[0,0],z=v[0],q=v[1],e,k={fixed:true,withLabel:false,visible:false,name:""};if(!JXG.isArray(g)){g=[];for(m=0;m<u.length;m++){g[m]=""}}if(!JXG.isFunction(f)){o=function(){return f}}l.highlightonsector=l.highlightonsector||false;l.straightfirst=false;l.straightlast=false;e=t.create("point",[z,q],k);h[0]=t.create("point",[function(){return o()+z},function(){return q}],k);for(m=0;m<u.length;m++){h[m+1]=t.create("point",[(function(i){return function(){var C,B=0,r,p;for(r=0;r<=i;r++){B+=parseFloat(JXG.evaluate(u[r]))}C=B;for(r=i+1;r<u.length;r++){C+=parseFloat(JXG.evaluate(u[r]))}p=(C!=0)?(2*Math.PI*B/C):0;return o()*Math.cos(p)+z}})(m),(function(i){return function(){var C,B=0,r,p;for(r=0;r<=i;r++){B+=parseFloat(JXG.evaluate(u[r]))}C=B;for(r=i+1;r<u.length;r++){C+=parseFloat(JXG.evaluate(u[r]))}p=(C!=0)?(2*Math.PI*B/C):0;return o()*Math.sin(p)+q}})(m)],k);l.name=g[m];l.withlabel=l.name!="";l.fillcolor=w&&w[m%w.length];l.labelcolor=w&&w[m%w.length];l.highlightfillcolor=n&&n[m%n.length];j[m]=t.create("sector",[e,h[m],h[m+1]],l);if(l.highlightonsector){j[m].hasPoint=j[m].hasPointSector}if(l.highlightbysize){j[m].highlight=function(){if(!this.highlighted){this.highlighted=true;this.board.renderer.highlight(this);var p=-this.point1.coords.usrCoords[1]+this.point2.coords.usrCoords[1],i=-this.point1.coords.usrCoords[2]+this.point2.coords.usrCoords[2];if(this.label.content!=null){this.label.content.rendNode.style.fontSize=(2*this.label.content.visProp.fontsize)+"px";this.label.content.prepareUpdate().update().updateRenderer()}this.point2.coords=new JXG.Coords(JXG.COORDS_BY_USER,[this.point1.coords.usrCoords[1]+p*1.1,this.point1.coords.usrCoords[2]+i*1.1],this.board);this.prepareUpdate().update().updateRenderer()}};j[m].noHighlight=function(){if(this.highlighted){this.highlighted=false;this.board.renderer.noHighlight(this);var p=-this.point1.coords.usrCoords[1]+this.point2.coords.usrCoords[1],i=-this.point1.coords.usrCoords[2]+this.point2.coords.usrCoords[2];if(this.label.content!=null){this.label.content.rendNode.style.fontSize=(this.label.content.visProp.fontsize*2)+"px";this.label.content.prepareUpdate().update().updateRenderer()}this.point2.coords=new JXG.Coords(JXG.COORDS_BY_USER,[this.point1.coords.usrCoords[1]+p/1.1,this.point1.coords.usrCoords[2]+i/1.1],this.board);this.prepareUpdate().update().updateRenderer()}}}}return{sectors:j,points:h,midpoint:e}},drawRadar:function(o,S,N){var ab,Z,ac,P,ae,I,E=S.length,M,u,g,O,F,B,G,D,h,aa,v,s,w,R,z,X,T,H,e,n,f,W,m,Q,r,V,ah,A,l,q,K,U,ag,C,k;if(E<=0){JXG.debug("No data");return}ac=N.paramarray;if(!JXG.exists(ac)){JXG.debug("Need paramArray attribute");return}P=ac.length;if(P<=1){JXG.debug("Need more than 1 param");return}for(ab=0;ab<E;ab++){if(P!=S[ab].length){JXG.debug("Use data length equal to number of params ("+S[ab].length+" != "+P+")");return}}ae=new Array(P);I=new Array(P);for(Z=0;Z<P;Z++){ae[Z]=S[0][Z];I[Z]=ae[Z]}for(ab=1;ab<E;ab++){for(Z=0;Z<P;Z++){if(S[ab][Z]>ae[Z]){ae[Z]=S[ab][Z]}if(S[ab][Z]<I[Z]){I[Z]=S[ab][Z]}}}M=new Array(E);u=new Array(E);for(ab=0;ab<E;ab++){M[ab]="";u[ab]=[]}g=new Array(P);O=new Array(P);F=N.startshiftratio||0;B=N.endshiftratio||0;for(ab=0;ab<P;ab++){g[ab]=(ae[ab]-I[ab])*F;O[ab]=(ae[ab]-I[ab])*B}G=N.startshiftarray||g;D=N.endshiftarray||O;h=N.startarray||I;if(JXG.exists(N.start)){for(ab=0;ab<P;ab++){h[ab]=N.start}}aa=N.endarray||ae;if(JXG.exists(N.end)){for(ab=0;ab<P;ab++){aa[ab]=N.end}}if(G.length!=P){JXG.debug("Start shifts length is not equal to number of parameters");return}if(D.length!=P){JXG.debug("End shifts length is not equal to number of parameters");return}if(h.length!=P){JXG.debug("Starts length is not equal to number of parameters");return}if(aa.length!=P){JXG.debug("Ends length is not equal to number of parameters");return}v=N.labelarray||M;s=N.colors;w=N.highlightcolors;R=N.radius||10;z={};if(!JXG.exists(N.highlightonsector)){N.highlightonsector=false}z.name=N.name;z.id=N.id;z.strokewidth=N.strokewidth||1;z.polystrokewidth=N.polystrokewidth||2*z.strokewidth;z.strokecolor=N.strokecolor||"black";z.straightfirst=false;z.straightlast=false;z.fillcolor=N.fillColor||"#FFFF88";z.fillopacity=N.fillOpacity||0.4;z.highlightfillcolor=N.highlightFillColor||"#FF7400";z.highlightstrokecolor=N.highlightStrokeColor||"black";z.gradient=N.gradient||"none";X=N.center||[0,0];T=X[0];H=X[1];e=o.create("point",[T,H],{name:"",fixed:true,withlabel:false,visible:false});n=Math.PI/2-Math.PI/P;if(N.startangle||N.startangle===0){n=N.startangle}f=n;W=[];m=[];var Y=function(){var j,i,t,p,ai=this.visProp.label.offsets.slice(0);j=this.point1.X();i=this.point2.X();t=this.point1.Y();p=this.point2.Y();if(i<j){ai[0]=-ai[0]}if(p<t){ai[1]=-ai[1]}this.setLabelRelativeCoords(ai);return new JXG.Coords(JXG.COORDS_BY_USER,[this.point2.X(),this.point2.Y()],this.board)};var L=function(ak,p){var j;var aj;var ai;j=o.create("transform",[-(h[p]-G[p]),0],{type:"translate"});aj=o.create("transform",[R/((aa[p]+D[p])-(h[p]-G[p])),1],{type:"scale"});j.melt(aj);ai=o.create("transform",[ak],{type:"rotate"});j.melt(ai);return j};for(ab=0;ab<P;ab++){f+=2*Math.PI/P;r=R*Math.cos(f)+T;V=R*Math.sin(f)+H;W[ab]=o.create("point",[r,V],{name:"",fixed:true,withlabel:false,visible:false});m[ab]=o.create("line",[e,W[ab]],{name:ac[ab],strokeColor:z.strokecolor,strokeWidth:z.strokewidth,strokeOpacity:1,straightFirst:false,straightLast:false,withLabel:true,highlightStrokeColor:z.highlightstrokecolor});m[ab].getLabelAnchor=Y;Q=L(f,ab);for(Z=0;Z<S.length;Z++){var af=S[Z][ab];u[Z][ab]=o.create("point",[af,0],{name:"",fixed:true,withlabel:false,visible:false});u[Z][ab].addTransform(u[Z][ab],Q)}}ah=new Array(E);for(ab=0;ab<E;ab++){z.labelcolor=s&&s[ab%s.length];z.strokecolor=s&&s[ab%s.length];z.fillcolor=s&&s[ab%s.length];ah[ab]=o.create("polygon",u[ab],{withLines:true,withLabel:false,fillColor:z.fillcolor,fillOpacity:z.fillopacity,highlightFillColor:z.highlightfillcolor});for(Z=0;Z<P;Z++){ah[ab].borders[Z].setProperty("strokecolor:"+s[ab%s.length]);ah[ab].borders[Z].setProperty("strokewidth:"+z.polystrokewidth)}}A=N.legendposition||"none";switch(A){case"right":var J=N.legendleftoffset||2;var ad=N.legendtopoffset||1;this.legend=o.create("legend",[T+R+J,H+R-ad],{labelArray:v,colorArray:s});break;case"none":break;default:JXG.debug("Unknown legend position")}l=[];if(N.showcircles!=false){q=[];for(ab=0;ab<6;ab++){q[ab]=20*ab}q[0]="0";K=N.circlelabelarray||q;U=K.length;if(U<2){alert("Too less circles");return}ag=[];C=n+Math.PI/P;Q=L(C,0);z.fillcolor="none";z.highlightfillcolor="none";z.strokecolor=N.strokecolor||"black";z.strokewidth=N.circlestrokewidth||0.5;z.layer=0;k=(aa[0]-h[0])/(U-1);for(ab=0;ab<U;ab++){ag[ab]=o.create("point",[h[0]+ab*k,0],{name:K[ab],size:0,fixed:true,withLabel:true,visible:true});ag[ab].addTransform(ag[ab],Q);l[ab]=o.create("circle",[e,ag[ab]],z)}}this.rendNode=ah[0].rendNode;return{circles:l,lines:m,points:u,midpoint:e,polygons:ah}},updateRenderer:function(){return this},update:function(){if(this.needsUpdate){this.updateDataArray()}return this},updateDataArray:function(){}});JXG.createChart=function(h,v,k){if((v.length==1)&&(typeof v[0]=="string")){var u=document.getElementById(v[0]),C,g,r,q,f,t=[],m,l,B,A,D,o,e,p,z,s,n;if(JXG.exists(u)){n=JXG.copyAttributes(k,h.options,"chart");u=(new JXG.DataSource()).loadFromTable(v[0],n.withheaders,n.withheaders);C=u.data;f=u.columnHeaders;g=u.rowHeaders;A=n.width;D=n.name;o=n.strokecolor;e=n.fillcolor;p=n.highlightstrokecolor;z=n.highlightfillcolor;h.suspendUpdate();s=C.length;B=[];if(n.rows&&JXG.isArray(n.rows)){for(r=0;r<s;r++){for(q=0;q<n.rows.length;q++){if((n.rows[q]==r)||(n.withheaders&&n.rows[q]==g[r])){B.push(C[r]);break}}}}else{B=C}s=B.length;for(r=0;r<s;r++){l=[];if(n.chartstyle&&n.chartstyle.indexOf("bar")!=-1){if(A){m=A}else{m=0.8}l.push(1-m/2+(r+0.5)*m/(1*s));for(q=1;q<B[r].length;q++){l.push(l[q-1]+1)}n.width=m/(1*s)}if(D&&D.length==s){n.name=D[r]}else{if(n.withheaders){n.name=f[r]}}if(o&&o.length==s){n.strokecolor=o[r]}else{n.strokecolor=JXG.hsv2rgb(((r+1)/(1*s))*360,0.9,0.6)}if(e&&e.length==s){n.fillcolor=e[r]}else{n.fillcolor=JXG.hsv2rgb(((r+1)/(1*s))*360,0.9,1)}if(p&&p.length==s){n.highlightstrokecolor=p[r]}else{n.highlightstrokecolor=JXG.hsv2rgb(((r+1)/(1*s))*360,0.9,1)}if(z&&z.length==s){n.highlightfillcolor=z[r]}else{n.highlightfillcolor=JXG.hsv2rgb(((r+1)/(1*s))*360,0.9,0.6)}if(n.chartstyle&&n.chartstyle.indexOf("bar")!=-1){t.push(new JXG.Chart(h,[l,B[r]],n))}else{t.push(new JXG.Chart(h,[B[r]],n))}}h.unsuspendUpdate()}return t}else{n=JXG.copyAttributes(k,h.options,"chart");return new JXG.Chart(h,v,n)}};JXG.JSXGraph.registerElement("chart",JXG.createChart);JXG.Legend=function(g,h,f){var e;this.constructor();e=JXG.copyAttributes(f,g.options,"legend");this.board=g;this.coords=new JXG.Coords(JXG.COORDS_BY_USER,h,this.board);this.myAtts={};this.label_array=e.labelarray||e.labels;this.color_array=e.colorarray||e.colors;this.lines=[];this.myAtts.strokewidth=e.strokewidth||5;this.myAtts.straightfirst=false;this.myAtts.straightlast=false;this.myAtts.withlabel=true;this.myAtts.fixed=true;this.style=e.legendstyle||e.style;switch(this.style){case"vertical":this.drawVerticalLegend(g,e);break;default:throw new Error("JSXGraph: Unknown legend style: "+this.style);break}};JXG.Legend.prototype=new JXG.GeometryElement;JXG.Legend.prototype.drawVerticalLegend=function(j,g){var f=g.linelength||1,e=(g.rowheight||20)/this.board.unitY,h;for(h=0;h<this.label_array.length;h++){this.myAtts.strokecolor=this.color_array[h];this.myAtts.highlightstrokecolor=this.color_array[h];this.myAtts.name=this.label_array[h];this.myAtts.label={offsets:[10,0]};this.lines[h]=j.create("line",[[this.coords.usrCoords[1],this.coords.usrCoords[2]-h*e],[this.coords.usrCoords[1]+f,this.coords.usrCoords[2]-h*e]],this.myAtts);this.lines[h].getLabelAnchor=function(){this.setLabelRelativeCoords(this.visProp.label.offsets);return new JXG.Coords(JXG.COORDS_BY_USER,[this.point2.X(),this.point2.Y()],this.board)}}};JXG.createLegend=function(g,f,e){var h=[0,0];if(JXG.exists(f)){if(f.length==2){h=f}}return new JXG.Legend(g,h,e)};JXG.JSXGraph.registerElement("legend",JXG.createLegend);JXG.Transformation=function(f,e,g){this.elementClass=JXG.OBJECT_CLASS_OTHER;this.matrix=[[1,0,0],[0,1,0],[0,0,1]];this.board=f;this.isNumericMatrix=false;this.setMatrix(f,e,g)};JXG.Transformation.prototype={};JXG.extend(JXG.Transformation.prototype,{update:function(){return this},setMatrix:function(g,f,h){var e;this.isNumericMatrix=true;for(e=0;e<h.length;e++){if(typeof h[e]!="number"){this.isNumericMatrix=false;break}}if(f=="translate"){this.evalParam=JXG.createEvalFunction(g,h,2);this.update=function(){this.matrix[1][0]=this.evalParam(0);this.matrix[2][0]=this.evalParam(1)}}else{if(f=="scale"){this.evalParam=JXG.createEvalFunction(g,h,2);this.update=function(){this.matrix[1][1]=this.evalParam(0);this.matrix[2][2]=this.evalParam(1)}}else{if(f=="reflect"){if(h.length<4){h[0]=JXG.getReference(g,h[0])}if(h.length==2){h[1]=JXG.getReference(g,h[1])}if(h.length==4){this.evalParam=JXG.createEvalFunction(g,h,4)}this.update=function(){var i,m,j,l,k;if(h.length==1){i=h[0].point2.X()-h[0].point1.X();m=h[0].point2.Y()-h[0].point1.Y();j=h[0].point1.X();l=h[0].point1.Y()}else{if(h.length==2){i=h[1].X()-h[0].X();m=h[1].Y()-h[0].Y();j=h[0].X();l=h[0].Y()}else{if(h.length==4){i=this.evalParam(2)-this.evalParam(0);m=this.evalParam(3)-this.evalParam(1);j=this.evalParam(0);l=this.evalParam(1)}}}k=i*i+m*m;this.matrix[1][1]=(i*i-m*m)/k;this.matrix[1][2]=2*i*m/k;this.matrix[2][1]=2*i*m/k;this.matrix[2][2]=(-i*i+m*m)/k;this.matrix[1][0]=j*(1-this.matrix[1][1])-l*this.matrix[1][2];this.matrix[2][0]=l*(1-this.matrix[2][2])-j*this.matrix[2][1]}}else{if(f=="rotate"){if(h.length==3){this.evalParam=JXG.createEvalFunction(g,h,3)}else{if(h.length<=2){this.evalParam=JXG.createEvalFunction(g,h,1);if(h.length==2){h[1]=JXG.getReference(g,h[1])}}}this.update=function(){var k=this.evalParam(0),i,m,l=Math.cos(k),j=Math.sin(k);this.matrix[1][1]=l;this.matrix[1][2]=-j;this.matrix[2][1]=j;this.matrix[2][2]=l;if(h.length>1){if(h.length==3){i=this.evalParam(1);m=this.evalParam(2)}else{i=h[1].X();m=h[1].Y()}this.matrix[1][0]=i*(1-l)+m*j;this.matrix[2][0]=m*(1-l)-i*j}}}else{if(f=="shear"){this.evalParam=JXG.createEvalFunction(g,h,1);this.update=function(){var i=this.evalParam(0);this.matrix[1][1]=Math.tan(i)}}else{if(f=="generic"){this.evalParam=JXG.createEvalFunction(g,h,9);this.update=function(){this.matrix[0][0]=this.evalParam(0);this.matrix[0][1]=this.evalParam(1);this.matrix[0][2]=this.evalParam(2);this.matrix[1][0]=this.evalParam(3);this.matrix[1][1]=this.evalParam(4);this.matrix[1][2]=this.evalParam(5);this.matrix[2][0]=this.evalParam(6);this.matrix[2][1]=this.evalParam(7);this.matrix[2][2]=this.evalParam(8)}}}}}}}},apply:function(e){this.update();if(arguments[1]!=null){return JXG.Math.matVecMult(this.matrix,e.initialCoords.usrCoords)}else{return JXG.Math.matVecMult(this.matrix,e.coords.usrCoords)}},applyOnce:function(g){var h,e,f;if(!JXG.isArray(g)){this.update();h=JXG.Math.matVecMult(this.matrix,g.coords.usrCoords);g.coords.setCoordinates(JXG.COORDS_BY_USER,h)}else{e=g.length;for(f=0;f<e;f++){this.update();h=JXG.Math.matVecMult(this.matrix,g[f].coords.usrCoords);g[f].coords.setCoordinates(JXG.COORDS_BY_USER,h)}}},bindTo:function(g){var f,e;if(JXG.isArray(g)){e=g.length;for(f=0;f<e;f++){g[f].transformations.push(this)}}else{g.transformations.push(this)}},setProperty:function(e){},melt:function(n){var m=[],l,e,h,f,o,g;e=n.matrix.length;h=this.matrix[0].length;for(l=0;l<e;l++){m[l]=[]}this.update();n.update();for(l=0;l<e;l++){for(g=0;g<h;g++){o=0;for(f=0;f<e;f++){o+=n.matrix[l][f]*this.matrix[f][g]}m[l][g]=o}}this.update=function(){var i=this.matrix.length,j=this.matrix[0].length;for(l=0;l<i;l++){for(g=0;g<j;g++){this.matrix[l][g]=m[l][g]}}};return this}});JXG.createTransform=function(g,f,e){return new JXG.Transformation(g,e.type,f)};JXG.JSXGraph.registerElement("transform",JXG.createTransform);JXG.Turtle=function(i,h,f){this.constructor(i,f,JXG.OBJECT_TYPE_TURTLE,JXG.OBJECT_CLASS_OTHER);var e,j,g;this.turtleIsHidden=false;this.board=i;this.visProp.curveType="plot";this._attributes=JXG.copyAttributes(this.visProp,i.options,"turtle");delete (this._attributes.id);e=0;j=0;g=90;if(h.length!=0){if(h.length==3){e=h[0];j=h[1];g=h[2]}else{if(h.length==2){if(JXG.isArray(h[0])){e=h[0][0];j=h[0][1];g=h[1]}else{e=h[0];j=h[1]}}else{e=h[0][0];j=h[0][1]}}}this.init(e,j,g);return this};JXG.Turtle.prototype=new JXG.GeometryElement;JXG.extend(JXG.Turtle.prototype,{init:function(e,g,f){this.arrowLen=20/Math.sqrt(this.board.unitX*this.board.unitX+this.board.unitY*this.board.unitY);this.pos=[e,g];this.isPenDown=true;this.dir=90;this.stack=[];this.objects=[];this.curve=this.board.create("curve",[[this.pos[0]],[this.pos[1]]],this._attributes);this.objects.push(this.curve);this.turtle=this.board.create("point",this.pos,{fixed:true,name:" ",visible:false,withLabel:false});this.objects.push(this.turtle);this.turtle2=this.board.create("point",[this.pos[0],this.pos[1]+this.arrowLen],{fixed:true,name:" ",visible:false,withLabel:false});this.objects.push(this.turtle2);this.visProp.arrow.lastArrow=true;this.visProp.arrow.straightFirst=false;this.visProp.arrow.straightLast=false;this.arrow=this.board.create("line",[this.turtle,this.turtle2],this.visProp.arrow);this.objects.push(this.arrow);this.right(90-f);this.board.update()},forward:function(e){if(e===0){return this}var g=e*Math.cos(this.dir*Math.PI/180),f=e*Math.sin(this.dir*Math.PI/180);if(!this.turtleIsHidden){var h=this.board.create("transform",[g,f],{type:"translate"});h.applyOnce(this.turtle);h.applyOnce(this.turtle2)}if(this.isPenDown){if(this.curve.dataX.length>=8192){this.curve=this.board.create("curve",[[this.pos[0]],[this.pos[1]]],this._attributes);this.objects.push(this.curve)}}this.pos[0]+=g;this.pos[1]+=f;if(this.isPenDown){this.curve.dataX.push(this.pos[0]);this.curve.dataY.push(this.pos[1])}this.board.update();return this},back:function(e){return this.forward(-e)},right:function(f){this.dir-=f;this.dir%=360;if(!this.turtleIsHidden){var e=this.board.create("transform",[-f*Math.PI/180,this.turtle],{type:"rotate"});e.applyOnce(this.turtle2)}this.board.update();return this},left:function(e){return this.right(-e)},penUp:function(){this.isPenDown=false;return this},penDown:function(){this.isPenDown=true;this.curve=this.board.create("curve",[[this.pos[0]],[this.pos[1]]],this._attributes);this.objects.push(this.curve);return this},clean:function(){for(var e=0;e<this.objects.length;e++){var f=this.objects[e];if(f.type==JXG.OBJECT_TYPE_CURVE){this.board.removeObject(f.id);this.objects.splice(e,1)}}this.curve=this.board.create("curve",[[this.pos[0]],[this.pos[1]]],this._attributes);this.objects.push(this.curve);this.board.update();return this},clearScreen:function(){for(var e=0;e<this.objects.length;e++){var f=this.objects[e];this.board.removeObject(f.id)}this.init(0,0,90);return this},setPos:function(e,g){if(JXG.isArray(e)){this.pos=e}else{this.pos=[e,g]}if(!this.turtleIsHidden){this.turtle.setPositionDirectly(JXG.COORDS_BY_USER,e,g);this.turtle2.setPositionDirectly(JXG.COORDS_BY_USER,e,g+this.arrowLen);var f=this.board.create("transform",[-(this.dir-90)*Math.PI/180,this.turtle],{type:"rotate"});f.applyOnce(this.turtle2)}this.curve=this.board.create("curve",[[this.pos[0]],[this.pos[1]]],this._attributes);this.objects.push(this.curve);this.board.update();return this},setPenSize:function(e){this.curve=this.board.create("curve",[[this.pos[0]],[this.pos[1]]],this.copyAttr("strokeWidth",e));this.objects.push(this.curve);return this},setPenColor:function(e){this.curve=this.board.create("curve",[[this.pos[0]],[this.pos[1]]],this.copyAttr("strokeColor",e));this.objects.push(this.curve);return this},setHighlightPenColor:function(e){this.curve=this.board.create("curve",[[this.pos[0]],[this.pos[1]]],this.copyAttr("highlightStrokeColor",e));this.objects.push(this.curve);return this},setProperty:function(f){var h,j,e=this.objects.length,g;for(h=0;h<e;h++){j=this.objects[h];if(j.type==JXG.OBJECT_TYPE_CURVE){j.setProperty(f)}}g=this.visProp.id;this.visProp=JXG.deepCopy(this.curve.visProp);this.visProp.id=g;this._attributes=JXG.deepCopy(this.visProp);delete (this._attributes.id);return this},copyAttr:function(e,f){this._attributes[e.toLowerCase()]=f;return this._attributes},showTurtle:function(){this.turtleIsHidden=false;this.arrow.setProperty("visible:true");this.setPos(this.pos[0],this.pos[1]);this.board.update();return this},hideTurtle:function(){this.turtleIsHidden=true;this.arrow.setProperty("visible:false");this.setPos(this.pos[0],this.pos[1]);this.board.update();return this},home:function(){this.pos=[0,0];this.setPos(this.pos[0],this.pos[1]);return this},pushTurtle:function(){this.stack.push([this.pos[0],this.pos[1],this.dir]);return this},popTurtle:function(){var e=this.stack.pop();this.pos[0]=e[0];this.pos[1]=e[1];this.dir=e[2];this.setPos(this.pos[0],this.pos[1]);return this},lookTo:function(i){if(JXG.isArray(i)){var f=this.pos[0];var e=this.pos[1];var j=i[0];var h=i[1];var g;g=Math.atan2(h-e,j-f);this.right(this.dir-(g*180/Math.PI))}else{if(JXG.isNumber(i)){this.right(this.dir-(i))}}return this},moveTo:function(h){if(JXG.isArray(h)){var f=h[0]-this.pos[0];var e=h[1]-this.pos[1];if(!this.turtleIsHidden){var g=this.board.create("transform",[f,e],{type:"translate"});g.applyOnce(this.turtle);g.applyOnce(this.turtle2)}if(this.isPenDown){if(this.curve.dataX.length>=8192){this.curve=this.board.create("curve",[[this.pos[0]],[this.pos[1]]],this._attributes);this.objects.push(this.curve)}}this.pos[0]=h[0];this.pos[1]=h[1];if(this.isPenDown){this.curve.dataX.push(this.pos[0]);this.curve.dataY.push(this.pos[1])}this.board.update()}return this},fd:function(e){return this.forward(e)},bk:function(e){return this.back(e)},lt:function(e){return this.left(e)},rt:function(e){return this.right(e)},pu:function(){return this.penUp()},pd:function(){return this.penDown()},ht:function(){return this.hideTurtle()},st:function(){return this.showTurtle()},cs:function(){return this.clearScreen()},push:function(){return this.pushTurtle()},pop:function(){return this.popTurtle()},evalAt:function(k,m){var h,g,l,f,e=this.objects.length;for(h=0,g=0;h<e;h++){l=this.objects[h];if(l.elementClass==JXG.OBJECT_CLASS_CURVE){if(g<=k&&k<g+l.numberPoints){f=(k-g);return l[m](f)}g+=l.numberPoints}}return this[m]()},X:function(e){if(typeof e=="undefined"){return this.pos[0]}else{return this.evalAt(e,"X")}},Y:function(e){if(typeof e=="undefined"){return this.pos[1]}else{return this.evalAt(e,"Y")}},Z:function(e){return 1},minX:function(){return 0},maxX:function(){var h=0,f,e=this.objects.length,g;for(f=0;f<e;f++){g=this.objects[f];if(g.elementClass==JXG.OBJECT_CLASS_CURVE){h+=this.objects[f].numberPoints}}return h},hasPoint:function(e,h){var f,g;for(f=0;f<this.objects.length;f++){g=this.objects[f];if(g.type==JXG.OBJECT_TYPE_CURVE){if(g.hasPoint(e,h)){return true}}}return false}});JXG.createTurtle=function(h,g,f){var e;g=g||[];e=JXG.copyAttributes(f,h.options,"turtle");return new JXG.Turtle(h,g,e)};JXG.JSXGraph.registerElement("turtle",JXG.createTurtle);JXG.rgbParser=function(){if(arguments.length==0){return[0,0,0]}if(arguments.length>=3){arguments[0]=[arguments[0],arguments[1],arguments[2]];arguments.length=1}var o=arguments[0];if(JXG.isArray(o)){var f=false,k;for(k=0;k<3;k++){f|=/\./.test(arguments[0][k].toString())}for(k=0;k<3;k++){f&=(arguments[0][k]>=0)&(arguments[0][k]<=1)}if(f){return[Math.ceil(arguments[0][0]*255),Math.ceil(arguments[0][1]*255),Math.ceil(arguments[0][2]*255)]}else{arguments[0].length=3;return arguments[0]}}else{if(typeof arguments[0]=="string"){o=arguments[0]}}var e,m,p;if(o.charAt(0)=="#"){o=o.substr(1,6)}o=o.replace(/ /g,"");o=o.toLowerCase();var j={aliceblue:"f0f8ff",antiquewhite:"faebd7",aqua:"00ffff",aquamarine:"7fffd4",azure:"f0ffff",beige:"f5f5dc",bisque:"ffe4c4",black:"000000",blanchedalmond:"ffebcd",blue:"0000ff",blueviolet:"8a2be2",brown:"a52a2a",burlywood:"deb887",cadetblue:"5f9ea0",chartreuse:"7fff00",chocolate:"d2691e",coral:"ff7f50",cornflowerblue:"6495ed",cornsilk:"fff8dc",crimson:"dc143c",cyan:"00ffff",darkblue:"00008b",darkcyan:"008b8b",darkgoldenrod:"b8860b",darkgray:"a9a9a9",darkgreen:"006400",darkkhaki:"bdb76b",darkmagenta:"8b008b",darkolivegreen:"556b2f",darkorange:"ff8c00",darkorchid:"9932cc",darkred:"8b0000",darksalmon:"e9967a",darkseagreen:"8fbc8f",darkslateblue:"483d8b",darkslategray:"2f4f4f",darkturquoise:"00ced1",darkviolet:"9400d3",deeppink:"ff1493",deepskyblue:"00bfff",dimgray:"696969",dodgerblue:"1e90ff",feldspar:"d19275",firebrick:"b22222",floralwhite:"fffaf0",forestgreen:"228b22",fuchsia:"ff00ff",gainsboro:"dcdcdc",ghostwhite:"f8f8ff",gold:"ffd700",goldenrod:"daa520",gray:"808080",green:"008000",greenyellow:"adff2f",honeydew:"f0fff0",hotpink:"ff69b4",indianred:"cd5c5c",indigo:"4b0082",ivory:"fffff0",khaki:"f0e68c",lavender:"e6e6fa",lavenderblush:"fff0f5",lawngreen:"7cfc00",lemonchiffon:"fffacd",lightblue:"add8e6",lightcoral:"f08080",lightcyan:"e0ffff",lightgoldenrodyellow:"fafad2",lightgrey:"d3d3d3",lightgreen:"90ee90",lightpink:"ffb6c1",lightsalmon:"ffa07a",lightseagreen:"20b2aa",lightskyblue:"87cefa",lightslateblue:"8470ff",lightslategray:"778899",lightsteelblue:"b0c4de",lightyellow:"ffffe0",lime:"00ff00",limegreen:"32cd32",linen:"faf0e6",magenta:"ff00ff",maroon:"800000",mediumaquamarine:"66cdaa",mediumblue:"0000cd",mediumorchid:"ba55d3",mediumpurple:"9370d8",mediumseagreen:"3cb371",mediumslateblue:"7b68ee",mediumspringgreen:"00fa9a",mediumturquoise:"48d1cc",mediumvioletred:"c71585",midnightblue:"191970",mintcream:"f5fffa",mistyrose:"ffe4e1",moccasin:"ffe4b5",navajowhite:"ffdead",navy:"000080",oldlace:"fdf5e6",olive:"808000",olivedrab:"6b8e23",orange:"ffa500",orangered:"ff4500",orchid:"da70d6",palegoldenrod:"eee8aa",palegreen:"98fb98",paleturquoise:"afeeee",palevioletred:"d87093",papayawhip:"ffefd5",peachpuff:"ffdab9",peru:"cd853f",pink:"ffc0cb",plum:"dda0dd",powderblue:"b0e0e6",purple:"800080",red:"ff0000",rosybrown:"bc8f8f",royalblue:"4169e1",saddlebrown:"8b4513",salmon:"fa8072",sandybrown:"f4a460",seagreen:"2e8b57",seashell:"fff5ee",sienna:"a0522d",silver:"c0c0c0",skyblue:"87ceeb",slateblue:"6a5acd",slategray:"708090",snow:"fffafa",springgreen:"00ff7f",steelblue:"4682b4",tan:"d2b48c",teal:"008080",thistle:"d8bfd8",tomato:"ff6347",turquoise:"40e0d0",violet:"ee82ee",violetred:"d02090",wheat:"f5deb3",white:"ffffff",whitesmoke:"f5f5f5",yellow:"ffff00",yellowgreen:"9acd32"};for(var q in j){if(o==q){o=j[q]}}var n=[{re:/^rgb\((\d{1,3}),\s*(\d{1,3}),\s*(\d{1,3})\)$/,example:["rgb(123, 234, 45)","rgb(255,234,245)"],process:function(g){return[parseInt(g[1]),parseInt(g[2]),parseInt(g[3])]}},{re:/^(\w{2})(\w{2})(\w{2})$/,example:["#00ff00","336699"],process:function(g){return[parseInt(g[1],16),parseInt(g[2],16),parseInt(g[3],16)]}},{re:/^(\w{1})(\w{1})(\w{1})$/,example:["#fb0","f0f"],process:function(g){return[parseInt(g[1]+g[1],16),parseInt(g[2]+g[2],16),parseInt(g[3]+g[3],16)]}}];for(var k=0;k<n.length;k++){var t=n[k].re,h=n[k].process,s=t.exec(o),l;if(s){l=h(s);e=l[0];m=l[1];p=l[2]}}e=(e<0||isNaN(e))?0:((e>255)?255:e);m=(m<0||isNaN(m))?0:((m>255)?255:m);p=(p<0||isNaN(p))?0:((p>255)?255:p);return[e,m,p]};JXG.rgb2css=function(){var h,f,e;h=JXG.rgbParser.apply(JXG.rgbParser,arguments);f=h[1];e=h[2];h=h[0];return"rgb("+h+", "+f+", "+e+")"};JXG.rgb2hex=function(){var h,f,e;h=JXG.rgbParser.apply(JXG.rgbParser,arguments);f=h[1];e=h[2];h=h[0];h=h.toString(16);f=f.toString(16);e=e.toString(16);if(h.length==1){h="0"+h}if(f.length==1){f="0"+f}if(e.length==1){e="0"+e}return"#"+h+f+e};JXG.hex2rgb=function(i){var h,f,e;if(i.charAt(0)=="#"){i=i.slice(1)}h=parseInt(i.substr(0,2),16);f=parseInt(i.substr(2,2),16);e=parseInt(i.substr(4,2),16);return"rgb("+h+", "+f+", "+e+")"};JXG.hsv2rgb=function(r,l,k){var m,s,h,o,n,j,g,e,u;r=((r%360)+360)%360;if(l==0){if(isNaN(r)||r<JXG.Math.eps){m=k;s=k;h=k}else{return"#ffffff"}}else{if(r>=360){j=0}else{j=r}j=j/60;n=Math.floor(j);o=j-n;g=k*(1-l);e=k*(1-(l*o));u=k*(1-(l*(1-o)));switch(n){case 0:m=k;s=u;h=g;break;case 1:m=e;s=k;h=g;break;case 2:m=g;s=k;h=u;break;case 3:m=g;s=e;h=k;break;case 4:m=u;s=g;h=k;break;case 5:m=k;s=g;h=e;break}}m=Math.round(m*255).toString(16);m=(m.length==2)?m:((m.length==1)?"0"+m:"00");s=Math.round(s*255).toString(16);s=(s.length==2)?s:((s.length==1)?"0"+s:"00");h=Math.round(h*255).toString(16);h=(h.length==2)?h:((h.length==1)?"0"+h:"00");return["#",m,s,h].join("")};JXG.rgb2hsv=function(){var e,n,q,o,f,j,i,t,m,w,u,p,k,l;e=JXG.rgbParser.apply(JXG.rgbParser,arguments);n=e[1];q=e[2];e=e[0];l=JXG.Math.Statistics;o=e/255;f=n/255;j=q/255;p=l.max([e,n,q]);k=l.min([e,n,q]);i=p/255;t=k/255;u=i;w=0;if(u>0){w=(u-t)/(u*1)}m=1/(i-t);if(w>0){if(p==e){m=(f-j)*m}else{if(p==n){m=2+(j-o)*m}else{m=4+(o-f)*m}}}m*=60;if(m<0){m+=360}if(p==k){m=0}return[m,w,u]};JXG.rgb2LMS=function(){var o,n,f,h,e,k,j,i=[[0.05059983,0.08585369,0.0095242],[0.01893033,0.08925308,0.01370054],[0.00292202,0.00975732,0.07145979]];o=JXG.rgbParser.apply(JXG.rgbParser,arguments);n=o[1];f=o[2];o=o[0];o=Math.pow(o,0.476190476);n=Math.pow(n,0.476190476);f=Math.pow(f,0.476190476);h=o*i[0][0]+n*i[0][1]+f*i[0][2];e=o*i[1][0]+n*i[1][1]+f*i[1][2];k=o*i[2][0]+n*i[2][1]+f*i[2][2];j=[h,e,k];j.l=h;j.m=e;j.s=k;return j};JXG.LMS2rgb=function(h,f,p){var e,i,k,j,n=[[30.830854,-29.832659,1.610474],[-6.481468,17.715578,-2.532642],[-0.37569,-1.199062,14.273846]];e=h*n[0][0]+f*n[0][1]+p*n[0][2];i=h*n[1][0]+f*n[1][1]+p*n[1][2];k=h*n[2][0]+f*n[2][1]+p*n[2][2];var o=function(l){var m=127,g=64;while(g>0){if(Math.pow(m,0.476190476)>l){m-=g}else{if(Math.pow(m+1,0.476190476)>l){return m}m+=g}g/=2}if(m==254&&13.994955247<l){return 255}return m};e=o(e);i=o(i);k=o(k);j=[e,i,k];j.r=e;j.g=i;j.b=k;return j};JXG.rgba2rgbo=function(f){var e;if(f.length==9&&f.charAt(0)=="#"){e=parseInt(f.substr(7,2).toUpperCase(),16)/255;f=f.substr(0,7)}else{e=1}return[f,e]};JXG.rgbo2rgba=function(e,g){var f;if(e=="none"){return e}f=Math.round(g*255).toString(16);if(f.length==1){f="0"+f}return e+f};JXG.rgb2bw=function(g){if(g=="none"){return g}var f,i="0123456789ABCDEF",h,e;e=JXG.rgbParser(g);f=0.3*e[0]+0.59*e[1]+0.11*e[2];h=i.charAt((f>>4)&15)+i.charAt(f&15);g="#"+h+""+h+""+h;return g};JXG.rgb2cb=function(j,q){if(j=="none"){return j}var t,i,h,w,r,o,g,v,n,f,u,k,p;r=JXG.rgb2LMS(j);i=r.l;h=r.m;w=r.s;q=q.toLowerCase();switch(q){case"protanopia":g=-0.06150039994295001;v=0.08277001656812001;n=-0.013200141220000003;f=0.05858939668799999;u=-0.07934519995360001;k=0.013289415272000003;p=0.6903216543277437;o=w/h;if(o<p){i=-(v*h+n*w)/g}else{i=-(u*h+k*w)/f}break;case"tritanopia":g=-0.00058973116217;v=0.007690316482;n=-0.01011703519052;f=0.025495080838999994;u=-0.0422740347;k=0.017005316784;p=0.8349489908460004;o=h/i;if(o<p){w=-(g*i+v*h)/n}else{w=-(f*i+u*h)/k}break;default:g=-0.06150039994295001;v=0.08277001656812001;n=-0.013200141220000003;f=0.05858939668799999;u=-0.07934519995360001;k=0.013289415272000003;p=0.5763833686400911;o=w/i;if(o<p){h=-(g*i+n*w)/v}else{h=-(f*i+k*w)/u}break}t=JXG.LMS2rgb(i,h,w);var e="0123456789ABCDEF";o=e.charAt((t.r>>4)&15)+e.charAt(t.r&15);j="#"+o;o=e.charAt((t.g>>4)&15)+e.charAt(t.g&15);j+=o;o=e.charAt((t.b>>4)&15)+e.charAt(t.b&15);j+=o;return j};JXG.extend(JXG.Board.prototype,{angle:function(e,g,f){return JXG.Math.Geometry.angle(e,g,f)},rad:function(e,g,f){return JXG.Math.Geometry.rad(e,g,f)},distance:function(f,e){return JXG.Math.Geometry.distance(f,e)},pow:function(f,e){return JXG.Math.pow(f,e)},round:function(e,f){return(e).toFixed(f)},cosh:function(e){return JXG.Math.cosh(e)},sinh:function(e){return JXG.Math.sinh(e)},sgn:function(e){return(e==0?0:e/(Math.abs(e)))},D:function(e,g){return JXG.Math.Numerics.D(e,g)},I:function(e,g){return JXG.Math.Numerics.I(e,g)},root:function(g,e,h){return JXG.Math.Numerics.root(g,e,h)},lagrangePolynomial:function(e){return JXG.Math.Numerics.lagrangePolynomial(e)},neville:function(e){return JXG.Math.Numerics.Neville(e)},riemannsum:function(h,j,g,i,e){return JXG.Math.Numerics.riemannsum(h,j,g,i,e)},abs:Math.abs,acos:Math.acos,asin:Math.asin,atan:Math.atan,ceil:Math.ceil,cos:Math.cos,exp:Math.exp,floor:Math.floor,log:Math.log,max:Math.max,min:Math.min,random:Math.random,sin:Math.sin,sqrt:Math.sqrt,tan:Math.tan,trunc:Math.ceil,factorial:function(e){return JXG.Math.factorial(e)},binomial:function(f,e){return JXG.Math.binomial(f,e)},getElement:function(e){return JXG.getReference(this,e)},intersectionOptions:["point",[[JXG.OBJECT_CLASS_LINE,JXG.OBJECT_CLASS_LINE],[JXG.OBJECT_CLASS_LINE,JXG.OBJECT_CLASS_CIRCLE],[JXG.OBJECT_CLASS_CIRCLE,JXG.OBJECT_CLASS_CIRCLE]]],intersection:function(h,f,g,e){h=JXG.getReference(this,h);f=JXG.getReference(this,f);if(h.elementClass==JXG.OBJECT_CLASS_CURVE&&f.elementClass==JXG.OBJECT_CLASS_CURVE){return function(){return JXG.Math.Geometry.meetCurveCurve(h,f,g,e,h.board)}}else{if((h.type==JXG.OBJECT_TYPE_ARC&&f.elementClass==JXG.OBJECT_CLASS_LINE)||(f.type==JXG.OBJECT_TYPE_ARC&&h.elementClass==JXG.OBJECT_CLASS_LINE)){return function(){return JXG.Math.Geometry.meet(h.stdform,f.stdform,g,h.board)}}else{if((h.elementClass==JXG.OBJECT_CLASS_CURVE&&f.elementClass==JXG.OBJECT_CLASS_LINE)||(f.elementClass==JXG.OBJECT_CLASS_CURVE&&h.elementClass==JXG.OBJECT_CLASS_LINE)){return function(){return JXG.Math.Geometry.meetCurveLine(h,f,g,h.board)}}else{return function(){return JXG.Math.Geometry.meet(h.stdform,f.stdform,g,h.board)}}}}},intersectionFunc:function(h,f,g,e){return this.intersection(h,f,g,e)},otherIntersection:function(f,e,g){f=JXG.getReference(this,f);e=JXG.getReference(this,e);return function(){var h=JXG.Math.Geometry.meet(f.stdform,e.stdform,0,f.board);if(Math.abs(g.X()-h.usrCoords[1])>JXG.Math.eps||Math.abs(g.Y()-h.usrCoords[2])>JXG.Math.eps||Math.abs(g.Z()-h.usrCoords[0])>JXG.Math.eps){return h}else{return JXG.Math.Geometry.meet(f.stdform,e.stdform,1,f.board)}}},pointFunc:function(){return[null]},pointOptions:["point",[[JXG.OBJECT_CLASS_POINT]]],lineFunc:function(){return arguments},lineOptions:["line",[[JXG.OBJECT_CLASS_POINT,JXG.OBJECT_CLASS_POINT]]],linesegmentFunc:function(){return arguments},linesegmentOptions:["line",[[JXG.OBJECT_CLASS_POINT,JXG.OBJECT_CLASS_POINT]]],linesegmentAtts:{straightFirst:false,straightLast:false},arrowFunc:function(){return arguments},arrowOptions:["arrow",[[JXG.OBJECT_CLASS_POINT,JXG.OBJECT_CLASS_POINT]]],circleFunc:function(){return arguments},circleOptions:["circle",[[JXG.OBJECT_CLASS_POINT,JXG.OBJECT_CLASS_POINT],[JXG.OBJECT_CLASS_POINT,JXG.OBJECT_CLASS_LINE],[JXG.OBJECT_CLASS_POINT,JXG.OBJECT_CLASS_CIRCLE]]],arrowparallelOptions:["arrowparallel",[[JXG.OBJECT_CLASS_POINT,JXG.OBJECT_CLASS_LINE]]],arrowparallelFunc:function(){return arguments},bisectorOptions:["bisector",[[JXG.OBJECT_CLASS_POINT,JXG.OBJECT_CLASS_POINT,JXG.OBJECT_CLASS_POINT]]],bisectorFunc:function(){return arguments},circumcircleOptions:["circumcircle",[[JXG.OBJECT_CLASS_POINT,JXG.OBJECT_CLASS_POINT,JXG.OBJECT_CLASS_POINT]]],circumcircleFunc:function(){return arguments},circumcirclemidpointOptions:["circumcirclemidpoint",[[JXG.OBJECT_CLASS_POINT,JXG.OBJECT_CLASS_POINT,JXG.OBJECT_CLASS_POINT]]],circumcirclemidpointFunc:function(){return arguments},integralOptions:["integral",[[]]],integralFunc:function(){return arguments},midpointOptions:["midpoint",[[JXG.OBJECT_CLASS_POINT,JXG.OBJECT_CLASS_POINT],[JXG.OBJECT_CLASS_LINE]]],midpointFunc:function(){return arguments},mirrorpointOptions:["mirrorpoint",[[JXG.OBJECT_CLASS_POINT,JXG.OBJECT_CLASS_POINT]]],mirrorpointFunc:function(){return arguments},normalOptions:["normal",[[JXG.OBJECT_CLASS_POINT,JXG.OBJECT_CLASS_LINE]]],normalFunc:function(){return arguments},parallelOptions:["parallel",[[JXG.OBJECT_CLASS_POINT,JXG.OBJECT_CLASS_LINE]]],parallelFunc:function(){return arguments},parallelpointOptions:["parallelpoint",[[JXG.OBJECT_CLASS_POINT,JXG.OBJECT_CLASS_POINT,JXG.OBJECT_CLASS_POINT]]],parallelpointFunc:function(){return arguments},perpendicularOptions:["perpendicular",[[JXG.OBJECT_CLASS_POINT,JXG.OBJECT_CLASS_LINE]]],perpendicularFunc:function(){return arguments},perpendicularpointOptions:["perpendicularpoint",[[JXG.OBJECT_CLASS_POINT,JXG.OBJECT_CLASS_LINE]]],perpendicularpointFunc:function(){return arguments},reflectionOptions:["reflection",[[JXG.OBJECT_CLASS_POINT,JXG.OBJECT_CLASS_LINE]]],reflectionFunc:function(){return arguments}});JXG.Point.prototype.setPositionX=function(g,e){var f=(g==JXG.COORDS_BY_USER)?this.coords.usrCoords[2]:this.coords.scrCoords[2];this.setPosition(g,e,f)};JXG.Point.prototype.setPositionY=function(g,f){var e=(g==JXG.COORDS_BY_USER)?this.coords.usrCoords[1]:this.coords.scrCoords[1];this.setPosition(g,e,f)};JXG.Ticks=function(e,g,f){this.constructor(e.board,f,JXG.OBJECT_TYPE_TICKS,JXG.OBJECT_CLASS_OTHER);this.line=e;this.board=this.line.board;this.ticksFunction=null;this.fixedTicks=null;this.equidistant=false;if(JXG.isFunction(g)){this.ticksFunction=g;throw new Error("Function arguments are no longer supported.")}else{if(JXG.isArray(g)){this.fixedTicks=g}else{if(Math.abs(g)<JXG.Math.eps){g=f.defaultdistance}this.ticksFunction=function(h){return g};this.equidistant=true}}this.minTicksDistance=f.minticksdistance;this.maxTicksDistance=f.maxticksdistance;this.labels=[];this.id=this.line.addTicks(this);this.board.setId(this,"Ti")};JXG.Ticks.prototype=new JXG.GeometryElement();JXG.extend(JXG.Ticks.prototype,{hasPoint:function(e,f){return false},calculateTicksCoordinates:function(){var h=this.line.point1,f=this.line.point2,r=h.Dist(f),L=(f.coords.usrCoords[1]-h.coords.usrCoords[1])/r,J=(f.coords.usrCoords[2]-h.coords.usrCoords[2])/r,n=h.coords.distance(JXG.COORDS_BY_SCREEN,new JXG.Coords(JXG.COORDS_BY_USER,[h.coords.usrCoords[1]+L,h.coords.usrCoords[2]+J],this.board)),D=(this.equidistant?this.ticksFunction(1):1),u=5,z,e,C,q,E,H=0,G=0,k,o=2,v=-1,I,F,l,M,s=JXG.Math.eps,m,w,B,p=this.visProp.majorheight/2,j=this.visProp.minorheight/2,K,g,t,A;if(this.visProp.minorheight<0){this.minStyle="infinite"}else{this.minStyle="finite"}if(this.visProp.majorheight<0){this.majStyle="infinite"}else{this.majStyle="finite"}if(this.line.visProp.straightfirst){w=Number.NEGATIVE_INFINITY}else{w=0+s}if(this.line.visProp.straightlast){B=Number.POSITIVE_INFINITY}else{B=r-s}K=this.line.stdform[1];g=this.line.stdform[2];t=K;A=g;F=Math.sqrt(K*K+g*g);K*=p/F;g*=p/F;t*=j/F;A*=j/F;this.removeTickLabels();this.ticks=[];this.labels=[];if(!this.equidistant){for(C=0;C<this.fixedTicks.length;C++){H=h.coords.usrCoords[1]+this.fixedTicks[C]*L;G=h.coords.usrCoords[2]+this.fixedTicks[C]*J;z=new JXG.Coords(JXG.COORDS_BY_USER,[H,G],this.board);k=this._tickEndings(z,K,g,t,A,true);if(k.length==2&&this.fixedTicks[C]>=w&&this.fixedTicks[C]<B){this.ticks.push(k)}this.labels.push(this._makeLabel(this.fixedTicks[C],z,this.board,this.visProp.drawlabels,this.id,C))}return}if(this.visProp.insertticks&&this.minTicksDistance>JXG.Math.eps){D=this._adjustTickDistance(D,n,u,h.coords,L,J);this.ticksDelta=D}if(!this.visProp.insertticks){D/=this.visProp.minorticks+1}l=this.board.getBoundingBox();H=(l[0]+l[2])*0.5;G=(l[1]+l[3])*0.5;M=[H*this.line.stdform[2]-G*this.line.stdform[1],-this.line.stdform[2],this.line.stdform[1]];I=JXG.Math.crossProduct(this.line.stdform,M);I[1]/=I[0];I[2]/=I[0];I[0]=1;z=new JXG.Coords(JXG.COORDS_BY_USER,I.slice(1),this.board);F=h.coords.distance(JXG.COORDS_BY_USER,z);if((f.X()-h.X())*(I[1]-h.X())<0||(f.Y()-h.Y())*(I[2]-h.Y())<0){F*=-1}q=Math.round(F/D)*D;if(Math.abs(q)>JXG.Math.eps){v=Math.abs(q)/q}I[1]=h.coords.usrCoords[1]+L*q;I[2]=h.coords.usrCoords[2]+J*q;e=q;q=0;H=I[1];G=I[2];C=0;do{z=new JXG.Coords(JXG.COORDS_BY_USER,[H,G],this.board);if(Math.round((v*q+e)/D)%(this.visProp.minorticks+1)===0){z.major=true}else{z.major=false}k=this._tickEndings(z,K,g,t,A,z.major);if(k.length==2){m=v*q+e;if((Math.abs(m)<=s&&this.visProp.drawzero)||(m>w&&m<B)){this.ticks.push(k);if(z.major){this.labels.push(this._makeLabel(m,z,this.board,this.visProp.drawlabels,this.id,C))}else{this.labels.push(null)}C++}if(o==2){v*=(-1)}if(v==1||o==1){q+=D}}else{v*=(-1);o--}H=I[1]+v*L*q;G=I[2]+v*J*q}while(o>0)},_adjustTickDistance:function(j,k,i,h,g,f){var e,l;while(k>4*this.minTicksDistance){j/=10;e=h.usrCoords[1]+g*j;l=h.usrCoords[2]+f*j;k=h.distance(JXG.COORDS_BY_SCREEN,new JXG.Coords(JXG.COORDS_BY_USER,[e,l],this.board))}while(k<this.minTicksDistance){j*=i;i=(i==5?2:5);e=h.usrCoords[1]+g*j;l=h.usrCoords[2]+f*j;k=h.distance(JXG.COORDS_BY_SCREEN,new JXG.Coords(JXG.COORDS_BY_USER,[e,l],this.board))}return j},_tickEndings:function(v,C,f,q,u,r){var w,B,g=this.board.canvasWidth,n=this.board.canvasHeight,k=[-1000*g,-1000*n],j=[-1000*g,-1000*n],m,l,t,e,A,p,z,h=0,o=false;B=v.scrCoords;if(r){m=C;l=f;z=this.majStyle}else{m=q;l=u;z=this.minStyle}t=m*this.board.unitX;e=l*this.board.unitY;if(Math.abs(m)<JXG.Math.eps){k[0]=B[1];k[1]=B[1];j[0]=0;j[1]=n}else{if(Math.abs(l)<JXG.Math.eps){k[0]=0;k[1]=g;j[0]=B[2];j[1]=B[2]}else{h=0;p=JXG.Math.crossProduct([0,0,1],[-e*B[1]-t*B[2],e,t]);p[1]/=p[0];if(p[1]>=0&&p[1]<=g){k[h]=p[1];j[h]=0;h++}p=JXG.Math.crossProduct([0,1,0],[-e*B[1]-t*B[2],e,t]);p[2]/=p[0];if(p[2]>=0&&p[2]<=n){k[h]=0;j[h]=p[2];h++}if(h<2){p=JXG.Math.crossProduct([n*n,0,-n],[-e*B[1]-t*B[2],e,t]);p[1]/=p[0];if(p[1]>=0&&p[1]<=g){k[h]=p[1];j[h]=n;h++}}if(h<2){p=JXG.Math.crossProduct([g*g,-g,0],[-e*B[1]-t*B[2],e,t]);p[2]/=p[0];if(p[2]>=0&&p[2]<=n){k[h]=g;j[h]=p[2]}}}}if((k[0]>=0&&k[0]<=g&&j[0]>=0&&j[0]<=n)||(k[1]>=0&&k[1]<=g&&j[1]>=0&&j[1]<=n)){o=true}else{o=false}if(z=="finite"){A=Math.sqrt(this.board.unitX*this.board.unitX+this.board.unitY*this.board.unitY);k[0]=B[1]+m*this.board.unitX/A;j[0]=B[2]-l*this.board.unitY/A;k[1]=B[1]-m*this.board.unitX/A;j[1]=B[2]+l*this.board.unitY/A}if(o){return[k,j]}else{return[]}},_makeLabel:function(m,e,j,g,l,h){var k,f;if(!g){return null}k=m.toString();if(Math.abs(m)<JXG.Math.eps){k="0"}if(k.length>5||k.indexOf("e")!=-1){k=m.toPrecision(3).toString()}if(k.indexOf(".")>-1){k=k.replace(/0+$/,"");k=k.replace(/\.$/,"")}f=JXG.createText(j,[e.usrCoords[1],e.usrCoords[2],k],{id:l+h+"Label",isLabel:true,layer:j.options.layer.line,highlightStrokeColor:j.options.text.strokeColor,highlightStrokeWidth:j.options.text.strokeWidth,highlightStrokeOpacity:j.options.text.strokeOpacity});f.isDraggable=false;f.dump=false;f.distanceX=4;f.distanceY=-parseInt(f.visProp.fontsize)+3;f.setCoords(e.usrCoords[1]+f.distanceX/(j.unitX),e.usrCoords[2]+f.distanceY/(j.unitY));f.visProp.visible=g;f.prepareUpdate().update().updateRenderer();return f},removeTickLabels:function(){var e;if(this.ticks!=null){if((this.board.needsFullUpdate||this.needsRegularUpdate)&&!(this.board.options.renderer=="canvas"&&this.board.options.text.display=="internal")){for(e=0;e<this.ticks.length;e++){if(this.labels[e]!=null&&this.labels[e].visProp.visible){this.board.removeObject(this.labels[e])}}}}},update:function(){if(this.needsUpdate){this.calculateTicksCoordinates()}return this},updateRenderer:function(){if(this.needsUpdate){if(this.ticks){this.board.renderer.updateTicks(this,this.dxMaj,this.dyMaj,this.dxMin,this.dyMin,this.minStyle,this.majStyle)}this.needsUpdate=false}return this},hideElement:function(){var e;this.visProp.visible=false;this.board.renderer.hide(this);for(e=0;e<this.labels.length;e++){if(JXG.exists(this.labels[e])){this.labels[e].hideElement()}}return this},showElement:function(){var e;this.visProp.visible=true;this.board.renderer.show(this);for(e=0;e<this.labels.length;e++){if(JXG.exists(this.labels[e])){this.labels[e].showElement()}}return this}});JXG.createTicks=function(i,g,f){var h,j,e=JXG.copyAttributes(f,i.options,"ticks");if(g.length<2){j=f.ticksDistance}else{j=g[1]}if((g[0].elementClass==JXG.OBJECT_CLASS_LINE)&&(JXG.isFunction(g[1])||JXG.isArray(g[1])||JXG.isNumber(g[1]))){h=new JXG.Ticks(g[0],j,e)}else{throw new Error("JSXGraph: Can't create Ticks with parent types '"+(typeof g[0])+"' and '"+(typeof g[1])+"'.")}return h};JXG.JSXGraph.registerElement("ticks",JXG.createTicks);JXG.Util={};JXG.Util.Unzip=function(W){var q=[],J="",H=false,E,K=0,T=[],u,l=new Array(32768),ab=0,O=false,Y,L,aa=[0,128,64,192,32,160,96,224,16,144,80,208,48,176,112,240,8,136,72,200,40,168,104,232,24,152,88,216,56,184,120,248,4,132,68,196,36,164,100,228,20,148,84,212,52,180,116,244,12,140,76,204,44,172,108,236,28,156,92,220,60,188,124,252,2,130,66,194,34,162,98,226,18,146,82,210,50,178,114,242,10,138,74,202,42,170,106,234,26,154,90,218,58,186,122,250,6,134,70,198,38,166,102,230,22,150,86,214,54,182,118,246,14,142,78,206,46,174,110,238,30,158,94,222,62,190,126,254,1,129,65,193,33,161,97,225,17,145,81,209,49,177,113,241,9,137,73,201,41,169,105,233,25,153,89,217,57,185,121,249,5,133,69,197,37,165,101,229,21,149,85,213,53,181,117,245,13,141,77,205,45,173,109,237,29,157,93,221,61,189,125,253,3,131,67,195,35,163,99,227,19,147,83,211,51,179,115,243,11,139,75,203,43,171,107,235,27,155,91,219,59,187,123,251,7,135,71,199,39,167,103,231,23,151,87,215,55,183,119,247,15,143,79,207,47,175,111,239,31,159,95,223,63,191,127,255],ae=[3,4,5,6,7,8,9,10,11,13,15,17,19,23,27,31,35,43,51,59,67,83,99,115,131,163,195,227,258,0,0],V=[0,0,0,0,0,0,0,0,1,1,1,1,2,2,2,2,3,3,3,3,4,4,4,4,5,5,5,5,0,99,99],P=[1,2,3,4,5,7,9,13,17,25,33,49,65,97,129,193,257,385,513,769,1025,1537,2049,3073,4097,6145,8193,12289,16385,24577],D=[0,0,0,0,1,1,2,2,3,3,4,4,5,5,6,6,7,7,8,8,9,9,10,10,11,11,12,12,13,13],r=[16,17,18,0,8,7,9,6,10,5,11,4,12,3,13,2,14,1,15],A=W,f=0,k=0,af=1,e=0,ad=256,j=[],n;function h(){e+=8;if(f<A.length){return A[f++]}else{return -1}}function s(){af=1}function Z(){var ah;e++;ah=(af&1);af>>=1;if(af==0){af=h();ah=(af&1);af=(af>>1)|128}return ah}function X(ah){var aj=0,ai=ah;while(ai--){aj=(aj<<1)|Z()}if(ah){aj=aa[aj]>>(8-ah)}return aj}function g(){ab=0}function B(ah){L++;l[ab++]=ah;q.push(String.fromCharCode(ah));if(ab==32768){ab=0}}function p(){this.b0=0;this.b1=0;this.jump=null;this.jumppos=-1}var i=288;var z=new Array(i);var R=new Array(32);var M=0;var ac=null;var t=null;var Q=new Array(64);var N=new Array(64);var C=0;var G=new Array(17);G[0]=0;var S;var w;function m(){while(1){if(G[C]>=w){return -1}if(S[G[C]]==C){return G[C]++}G[C]++}}function I(){var ai=ac[M];var ah;if(H){document.write("<br>len:"+C+" treepos:"+M)}if(C==17){return -1}M++;C++;ah=m();if(H){document.write("<br>IsPat "+ah)}if(ah>=0){ai.b0=ah;if(H){document.write("<br>b0 "+ai.b0)}}else{ai.b0=32768;if(H){document.write("<br>b0 "+ai.b0)}if(I()){return -1}}ah=m();if(ah>=0){ai.b1=ah;if(H){document.write("<br>b1 "+ai.b1)}ai.jump=null}else{ai.b1=32768;if(H){document.write("<br>b1 "+ai.b1)}ai.jump=ac[M];ai.jumppos=M;if(I()){return -1}}C--;return 0}function o(al,aj,am,ai){var ak;if(H){document.write("currentTree "+al+" numval "+aj+" lengths "+am+" show "+ai)}ac=al;M=0;S=am;w=aj;for(ak=0;ak<17;ak++){G[ak]=0}C=0;if(I()){if(H){alert("invalid huffman tree\n")}return -1}if(H){document.write("<br>Tree: "+ac.length);for(var ah=0;ah<32;ah++){document.write("Places["+ah+"].b0="+ac[ah].b0+"<br>");document.write("Places["+ah+"].b1="+ac[ah].b1+"<br>")}}return 0}function F(ak){var ai,aj,am=0,al=ak[am],ah;while(1){ah=Z();if(H){document.write("b="+ah)}if(ah){if(!(al.b1&32768)){if(H){document.write("ret1")}return al.b1}al=al.jump;ai=ak.length;for(aj=0;aj<ai;aj++){if(ak[aj]===al){am=aj;break}}}else{if(!(al.b0&32768)){if(H){document.write("ret2")}return al.b0}am++;al=ak[am]}}if(H){document.write("ret3")}return -1}function ag(){var al,ay,ai,aw,ax;do{al=Z();ai=X(2);switch(ai){case 0:if(H){alert("Stored\n")}break;case 1:if(H){alert("Fixed Huffman codes\n")}break;case 2:if(H){alert("Dynamic Huffman codes\n")}break;case 3:if(H){alert("Reserved block type!!\n")}break;default:if(H){alert("Unexpected value %d!\n",ai)}break}if(ai==0){var au,ah;s();au=h();au|=(h()<<8);ah=h();ah|=(h()<<8);if(((au^~ah)&65535)){document.write("BlockLen checksum mismatch\n")}while(au--){ay=h();B(ay)}}else{if(ai==1){var av;while(1){av=(aa[X(7)]>>1);if(av>23){av=(av<<1)|Z();if(av>199){av-=128;av=(av<<1)|Z()}else{av-=48;if(av>143){av=av+136}}}else{av+=256}if(av<256){B(av)}else{if(av==256){break}else{var ax,aq;av-=256+1;ax=X(V[av])+ae[av];av=aa[X(5)]>>3;if(D[av]>8){aq=X(8);aq|=(X(D[av]-8)<<8)}else{aq=X(D[av])}aq+=P[av];for(av=0;av<ax;av++){var ay=l[(ab-aq)&32767];B(ay)}}}}}else{if(ai==2){var av,ar,aj,ao,ap;var an=new Array(288+32);aj=257+X(5);ao=1+X(5);ap=4+X(4);for(av=0;av<19;av++){an[av]=0}for(av=0;av<ap;av++){an[r[av]]=X(3)}ax=R.length;for(aw=0;aw<ax;aw++){R[aw]=new p()}if(o(R,19,an,0)){g();return 1}if(H){document.write("<br>distanceTree");for(var az=0;az<R.length;az++){document.write("<br>"+R[az].b0+" "+R[az].b1+" "+R[az].jump+" "+R[az].jumppos)}}ar=aj+ao;aw=0;var ak=-1;if(H){document.write("<br>n="+ar+" bits: "+e+"<br>")}while(aw<ar){ak++;av=F(R);if(H){document.write("<br>"+ak+" i:"+aw+" decode: "+av+"    bits "+e+"<br>")}if(av<16){an[aw++]=av}else{if(av==16){var at;av=3+X(2);if(aw+av>ar){g();return 1}at=aw?an[aw-1]:0;while(av--){an[aw++]=at}}else{if(av==17){av=3+X(3)}else{av=11+X(7)}if(aw+av>ar){g();return 1}while(av--){an[aw++]=0}}}}ax=z.length;for(aw=0;aw<ax;aw++){z[aw]=new p()}if(o(z,aj,an,0)){g();return 1}ax=z.length;for(aw=0;aw<ax;aw++){R[aw]=new p()}var am=new Array();for(aw=aj;aw<an.length;aw++){am[aw-aj]=an[aw]}if(o(R,ao,am,0)){g();return 1}if(H){document.write("<br>literalTree")}while(1){av=F(z);if(av>=256){var ax,aq;av-=256;if(av==0){break}av--;ax=X(V[av])+ae[av];av=F(R);if(D[av]>8){aq=X(8);aq|=(X(D[av]-8)<<8)}else{aq=X(D[av])}aq+=P[av];while(ax--){var ay=l[(ab-aq)&32767];B(ay)}}else{B(av)}}}}}}while(!al);g();s();return 0}JXG.Util.Unzip.prototype.unzipFile=function(ah){var ai;this.unzip();for(ai=0;ai<T.length;ai++){if(T[ai][1]==ah){return T[ai][0]}}};JXG.Util.Unzip.prototype.unzip=function(){if(H){alert(A)}v();return T};function v(){if(H){alert("NEXTFILE")}q=[];var al=[];O=false;al[0]=h();al[1]=h();if(H){alert("type: "+al[0]+" "+al[1])}if(al[0]==parseInt("78",16)&&al[1]==parseInt("da",16)){if(H){alert("GEONExT-GZIP")}ag();if(H){alert(q.join(""))}T[K]=new Array(2);T[K][0]=q.join("");T[K][1]="geonext.gxt";K++}if(al[0]==parseInt("1f",16)&&al[1]==parseInt("8b",16)){if(H){alert("GZIP")}U();if(H){alert(q.join(""))}T[K]=new Array(2);T[K][0]=q.join("");T[K][1]="file";K++}if(al[0]==parseInt("50",16)&&al[1]==parseInt("4b",16)){O=true;al[2]=h();al[3]=h();if(al[2]==parseInt("3",16)&&al[3]==parseInt("4",16)){al[0]=h();al[1]=h();if(H){alert("ZIP-Version: "+al[1]+" "+al[0]/10+"."+al[0]%10)}E=h();E|=(h()<<8);if(H){alert("gpflags: "+E)}var ah=h();ah|=(h()<<8);if(H){alert("method: "+ah)}h();h();h();h();var am=h();am|=(h()<<8);am|=(h()<<16);am|=(h()<<24);var ak=h();ak|=(h()<<8);ak|=(h()<<16);ak|=(h()<<24);var ap=h();ap|=(h()<<8);ap|=(h()<<16);ap|=(h()<<24);if(H){alert("local CRC: "+am+"\nlocal Size: "+ap+"\nlocal CompSize: "+ak)}var ai=h();ai|=(h()<<8);var ao=h();ao|=(h()<<8);if(H){alert("filelen "+ai)}aj=0;j=[];while(ai--){var an=h();if(an=="/"|an==":"){aj=0}else{if(aj<ad-1){j[aj++]=String.fromCharCode(an)}}}if(H){alert("nameBuf: "+j)}if(!n){n=j}var aj=0;while(aj<ao){an=h();aj++}Y=4294967295;L=0;if(ap=0&&fileOut.charAt(n.length-1)=="/"){if(H){alert("skipdir")}}if(ah==8){ag();if(H){alert(q.join(""))}T[K]=new Array(2);T[K][0]=q.join("");T[K][1]=j.join("");K++}U()}}}function U(){var am,aj=[],ak,ai,al,ah,an;if((E&8)){aj[0]=h();aj[1]=h();aj[2]=h();aj[3]=h();if(aj[0]==parseInt("50",16)&&aj[1]==parseInt("4b",16)&&aj[2]==parseInt("07",16)&&aj[3]==parseInt("08",16)){am=h();am|=(h()<<8);am|=(h()<<16);am|=(h()<<24)}else{am=aj[0]|(aj[1]<<8)|(aj[2]<<16)|(aj[3]<<24)}ak=h();ak|=(h()<<8);ak|=(h()<<16);ak|=(h()<<24);ai=h();ai|=(h()<<8);ai|=(h()<<16);ai|=(h()<<24);if(H){alert("CRC:")}}if(O){v()}aj[0]=h();if(aj[0]!=8){if(H){alert("Unknown compression method!")}return 0}E=h();if(H){if((E&~(parseInt("1f",16)))){alert("Unknown flags set!")}}h();h();h();h();h();al=h();if((E&4)){aj[0]=h();aj[2]=h();C=aj[0]+256*aj[1];if(H){alert("Extra field size: "+C)}for(ah=0;ah<C;ah++){h()}}if((E&8)){ah=0;j=[];while(an=h()){if(an=="7"||an==":"){ah=0}if(ah<ad-1){j[ah++]=an}}if(H){alert("original file name: "+j)}}if((E&16)){while(an=h()){}}if((E&2)){h();h()}ag();am=h();am|=(h()<<8);am|=(h()<<16);am|=(h()<<24);ai=h();ai|=(h()<<8);ai|=(h()<<16);ai|=(h()<<24);if(O){v()}}};JXG.Util.Base64={_keyStr:"ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/=",encode:function(g){var e=[],o,m,k,n,l,j,h,f=0;g=JXG.Util.Base64._utf8_encode(g);while(f<g.length){o=g.charCodeAt(f++);m=g.charCodeAt(f++);k=g.charCodeAt(f++);n=o>>2;l=((o&3)<<4)|(m>>4);j=((m&15)<<2)|(k>>6);h=k&63;if(isNaN(m)){j=h=64}else{if(isNaN(k)){h=64}}e.push([this._keyStr.charAt(n),this._keyStr.charAt(l),this._keyStr.charAt(j),this._keyStr.charAt(h)].join(""))}return e.join("")},decode:function(h,g){var e=[],p,n,l,o,m,k,j,f=0;h=h.replace(/[^A-Za-z0-9\+\/\=]/g,"");while(f<h.length){o=this._keyStr.indexOf(h.charAt(f++));m=this._keyStr.indexOf(h.charAt(f++));k=this._keyStr.indexOf(h.charAt(f++));j=this._keyStr.indexOf(h.charAt(f++));p=(o<<2)|(m>>4);n=((m&15)<<4)|(k>>2);l=((k&3)<<6)|j;e.push(String.fromCharCode(p));if(k!=64){e.push(String.fromCharCode(n))}if(j!=64){e.push(String.fromCharCode(l))}}e=e.join("");if(g){e=JXG.Util.Base64._utf8_decode(e)}return e},_utf8_encode:function(f){f=f.replace(/\r\n/g,"\n");var e="";for(var h=0;h<f.length;h++){var g=f.charCodeAt(h);if(g<128){e+=String.fromCharCode(g)}else{if((g>127)&&(g<2048)){e+=String.fromCharCode((g>>6)|192);e+=String.fromCharCode((g&63)|128)}else{e+=String.fromCharCode((g>>12)|224);e+=String.fromCharCode(((g>>6)&63)|128);e+=String.fromCharCode((g&63)|128)}}}return e},_utf8_decode:function(e){var g=[],j=0,k=0,h=0,f=0;while(j<e.length){k=e.charCodeAt(j);if(k<128){g.push(String.fromCharCode(k));j++}else{if((k>191)&&(k<224)){h=e.charCodeAt(j+1);g.push(String.fromCharCode(((k&31)<<6)|(h&63)));j+=2}else{h=e.charCodeAt(j+1);f=e.charCodeAt(j+2);g.push(String.fromCharCode(((k&15)<<12)|((h&63)<<6)|(f&63)));j+=3}}}return g.join("")},_destrip:function(k,h){var f=[],j,g,e=[];if(h==null){h=76}k.replace(/ /g,"");j=k.length/h;for(g=0;g<j;g++){f[g]=k.substr(g*h,h)}if(j!=k.length/h){f[f.length]=k.substr(j*h,k.length-(j*h))}for(g=0;g<f.length;g++){e.push(f[g])}return e.join("\n")},decodeAsArray:function(f){var h=this.decode(f),e=[],g;for(g=0;g<h.length;g++){e[g]=h.charCodeAt(g)}return e},decodeGEONExT:function(e){return decodeAsArray(destrip(e),false)}};JXG.Util.asciiCharCodeAt=function(f,e){var g=f.charCodeAt(e);if(g>255){switch(g){case 8364:g=128;break;case 8218:g=130;break;case 402:g=131;break;case 8222:g=132;break;case 8230:g=133;break;case 8224:g=134;break;case 8225:g=135;break;case 710:g=136;break;case 8240:g=137;break;case 352:g=138;break;case 8249:g=139;break;case 338:g=140;break;case 381:g=142;break;case 8216:g=145;break;case 8217:g=146;break;case 8220:g=147;break;case 8221:g=148;break;case 8226:g=149;break;case 8211:g=150;break;case 8212:g=151;break;case 732:g=152;break;case 8482:g=153;break;case 353:g=154;break;case 8250:g=155;break;case 339:g=156;break;case 382:g=158;break;case 376:g=159;break;default:break}}return g};JXG.Util.utf8Decode=function(e){var g=[];var j=0;var l=0,k=0,h=0,f;if(!JXG.exists(e)){return""}while(j<e.length){l=e.charCodeAt(j);if(l<128){g.push(String.fromCharCode(l));j++}else{if((l>191)&&(l<224)){h=e.charCodeAt(j+1);g.push(String.fromCharCode(((l&31)<<6)|(h&63)));j+=2}else{h=e.charCodeAt(j+1);f=e.charCodeAt(j+2);g.push(String.fromCharCode(((l&15)<<12)|((h&63)<<6)|(f&63)));j+=3}}}return g.join("")};JXG.Util.genUUID=function(){var j="0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz".split(""),g=new Array(36),f=0,h;for(var e=0;e<36;e++){if(e==8||e==13||e==18||e==23){g[e]="-"}else{if(e==14){g[e]="4"}else{if(f<=2){f=33554432+(Math.random()*16777216)|0}h=f&15;f=f>>4;g[e]=j[(e==19)?(h&3)|8:h]}}}return g.join("")};JXG.PsTricks={convert:function(h){var j=new JXG.Coords(JXG.COORDS_BY_SCREEN,[0,0],h),k=new JXG.Coords(JXG.COORDS_BY_SCREEN,[h.canvasWidth,h.canvasHeight],h),f,g,e=[];e.push("\\begin{pspicture*}("+j.usrCoords[1]+","+k.usrCoords[2]+")("+k.usrCoords[1]+","+j.usrCoords[2]+")\n");for(f in h.objects){g=h.objects[f];if(g.visProp.visible){switch(g.elementClass){case JXG.OBJECT_CLASS_CIRCLE:e.push(this.addCircle(g));break;case JXG.OBJECT_CLASS_LINE:e.push(this.addLine(g));break;case JXG.OBJECT_CLASS_POINT:e.push(this.addPoint(g));break;default:switch(g.type){case JXG.OBJECT_TYPE_ARC:e.push(this.addArc(g));break;case JXG.OBJECT_TYPE_SECTOR:e.push(this.addArc(g));e.push(this.addSector(g));break;case JXG.OBJECT_TYPE_POLYGON:e.push(this.addPolygon(g));break;case JXG.OBJECT_TYPE_ANGLE:e.push(this.addAngle(g));break}break}}}e.push("\\end{pspicture*}");return e.join("\n")},setArrows:function(f){var e="";if(f.visProp.firstarrow&&f.visProp.lastarrow){e="{<->}"}else{if(f.visProp.firstarrow){e="{<-}"}else{if(f.visProp.lastarrow){e="{->}"}}}return e},drawWedge:function(g,h,i,f,k,j){var e="";if(g!="none"&&h>0){e+="\\pswedge[linestyle=none, fillstyle=solid, fillcolor="+this.parseColor(g)+", opacity="+h.toFixed(5)+"]";e+="("+i.join(",")+"){"+f+"}{"+k+"}{"+j+"}\n"}return e},addPoint:function(g){var e="\\psdot[linecolor="+this.parseColor(g.visProp.strokecolor)+",dotstyle=",h=g.normalizeFace(g.visProp.face)||"o",f=g.visProp.size>4?4:g.visProp.size,i=[0,0,"2pt 2","5pt 2","5pt 3"];if(h=="x"){e+="x, dotsize="+i[f]}else{if(h=="o"){e+="*, dotsize=";if(f==1){e+="2pt 2"}else{if(f==2){e+="4pt 2"}else{if(f==3){e+="6pt 2"}else{if(f==4){e+="6pt 3"}}}}}else{if(h=="[]"){e+="square*, dotsize="+i[f]}else{if(h=="+"){e+="+, dotsize="+i[f]}}}}e+="]("+g.coords.usrCoords.slice(1).join(",")+")\n";e+="\\rput("+(g.coords.usrCoords[1]+15/g.board.unitY)+","+(g.coords.usrCoords[2]+15/g.board.unitY)+"){\\small $"+g.name+"$}\n";return e},addLine:function(h){var g=new JXG.Coords(JXG.COORDS_BY_USER,h.point1.coords.usrCoords,h.board),f=new JXG.Coords(JXG.COORDS_BY_USER,h.point2.coords.usrCoords,h.board),e="\\psline[linecolor="+this.parseColor(h.visProp.strokecolor)+", linewidth="+h.visProp.strokewidth+"px]";if(h.visProp.straightfirst||h.visProp.straightlast){JXG.Math.Geometry.calcStraight(h,g,f)}e+=this.setArrows(h);e+="("+g.usrCoords.slice(1).join(",")+")("+f.usrCoords.slice(2).join(",")+")\n";return e},addCircle:function(g){var f=g.Radius(),e="\\pscircle[linecolor="+this.parseColor(g.visProp.strokecolor)+", linewidth="+g.visProp.strokewidth+"px";if(g.visProp.fillcolor!="none"&&g.visProp.fillopacity!=0){e+=", fillstyle=solid, fillcolor="+this.parseColor(g.visProp.fillcolor)+", opacity="+g.visProp.fillopacity.toFixed(5)}e+="]("+g.center.coords.usrCoords.slice(1).join("1")+"){"+f+"}\n";return e},addPolygon:function(g){var e="\\pspolygon[linestyle=none, fillstyle=solid, fillcolor="+this.parseColor(g.visProp.fillcolor)+", opacity="+g.visProp.fillopacity.toFixed(5)+"]",f;for(f=0;f<g.vertices.length;f++){e+="("+g.vertices[f].coords.usrCoords.slice(1).join(",")+")"}e+="\n";return e},addArc:function(g){var f=g.Radius(),i={coords:new JXG.Coords(JXG.COORDS_BY_USER,[g.board.canvasWidth/(g.board.unitY),g.center.coords.usrCoords[2]],g.board)},h=JXG.Math.Geometry.trueAngle(i,g.center,g.point2).toFixed(4),j=JXG.Math.Geometry.trueAngle(i,g.center,g.point3).toFixed(4),e="\\psarc[linecolor="+this.parseColor(g.visProp.strokecolor)+", linewidth="+g.visProp.strokewidth+"px]";e+=this.setArrows(g);e+="("+g.center.coords.usrCoords.slice(1).join(",")+"){"+f+"}{"+h+"}{"+j+"}\n";return e},addSector:function(f){var e=f.Radius(),h={coords:new JXG.Coords(JXG.COORDS_BY_USER,[f.board.canvasWidth/(f.board.unitY),f.point1.coords.usrCoords[2]],f.board)},g=JXG.Math.Geometry.trueAngle(h,f.point1,f.point2).toFixed(4),i=JXG.Math.Geometry.trueAngle(h,f.point1,f.point3).toFixed(4);return this.drawWedge(f.visProp.fillcolor,f.visProp.fillopacity,f.point1.coords.usrCoords.slice(1),e,g,i)},addAngle:function(g){var f=g.radius,i={coords:new JXG.Coords(JXG.COORDS_BY_USER,[g.board.canvasWidth/(g.board.unitY),g.point2.coords.usrCoords[2]],g.board)},h=JXG.Math.Geometry.trueAngle(i,g.point2,g.point1).toFixed(4),j=JXG.Math.Geometry.trueAngle(i,g.point2,g.point3).toFixed(4),e;e=this.drawWedge(g.visProp.fillcolor,g.visProp.fillopacity,g.point2.coords.usrCoords.slice(1),f,h,j);e+="\\psarc[linecolor="+this.parseColor(g.visProp.strokecolor)+", linewidth="+g.visProp.strokewidth+"px]";e+="("+g.point2.coords.usrCoords.slice(1).join(",")+"){"+f+"}{"+h+"}{"+j+"}\n";return e},parseColor:function(f){var e=JXG.rgbParser(f);return"{[rgb]{"+e[0]/255+","+e[1]/255+","+e[2]/255+"}}"}};JXG.Server=function(){};JXG.Server.modules=function(){};JXG.Server.runningCalls={};JXG.Server.handleError=function(e){alert("error occured, server says: "+e.message)};JXG.Server.callServer=function(i,p,j,n){var o,f,m,h,e,l,g;n=n||false;h="";for(g in j){h+="&"+escape(g)+"="+escape(j[g])}l=JXG.toJSON(j);do{e=i+Math.floor(Math.random()*4096)}while(typeof this.runningCalls[e]!="undefined");this.runningCalls[e]={action:i};if(typeof j.module!="undefined"){this.runningCalls[e].module=j.module}o=JXG.serverBase+"JXGServer.py";f="action="+escape(i)+"&id="+e+"&dataJSON="+escape(JXG.Util.Base64.encode(l));this.cbp=function(v){var z,r,s,u,w,k,t,q;z=(new JXG.Util.Unzip(JXG.Util.Base64.decodeAsArray(v))).unzip();if(JXG.isArray(z)&&z.length>0){z=z[0][0]}if(typeof z!="string"){return}r=window.JSON&&window.JSON.parse?window.JSON.parse(z):(new Function("return "+z))();if(r.type=="error"){this.handleError(r)}else{if(r.type=="response"){k=r.id;for(t=0;t<r.fields.length;t++){s=r.fields[t];u=s.namespace+(typeof((new Function("return "+s.namespace))())=="object"?".":".prototype.")+s.name+" = "+s.value;(new Function(u))()}for(t=0;t<r.handler.length;t++){s=r.handler[t];w=[];for(q=0;q<s.parameters.length;q++){w[q]='"'+s.parameters[q]+'": '+s.parameters[q]}u="if(typeof JXG.Server.modules."+this.runningCalls[k].module+' == "undefined")JXG.Server.modules.'+this.runningCalls[k].module+" = {};";u+="JXG.Server.modules."+this.runningCalls[k].module+"."+s.name+"_cb = "+s.callback+";";u+="JXG.Server.modules."+this.runningCalls[k].module+"."+s.name+" = function ("+s.parameters.join(",")+', __JXGSERVER_CB__, __JXGSERVER_SYNC) {if(typeof __JXGSERVER_CB__ == "undefined") __JXGSERVER_CB__ = JXG.Server.modules.'+this.runningCalls[k].module+"."+s.name+"_cb;var __JXGSERVER_PAR__ = {"+w.join(",")+', "module": "'+this.runningCalls[k].module+'", "handler": "'+s.name+'" };JXG.Server.callServer("exec", __JXGSERVER_CB__, __JXGSERVER_PAR__, __JXGSERVER_SYNC);};';(new Function(u))()}delete this.runningCalls[k];p(r.data)}}};this.cb=JXG.bind(this.cbp,this);if(window.XMLHttpRequest){m=new XMLHttpRequest();m.overrideMimeType("text/plain; charset=iso-8859-1")}else{m=new ActiveXObject("Microsoft.XMLHTTP")}if(m){m.open("POST",o,!n);m.setRequestHeader("Content-type","application/x-www-form-urlencoded");if(!n){m.onreadystatechange=(function(k){return function(){switch(m.readyState){case 4:if(m.status!=200){}else{k(m.responseText)}break;default:return false;break}}})(this.cb)}m.send(f);if(n){this.cb(m.responseText)}}else{return false}};JXG.Server.loadModule_cb=function(f){var e;for(e=0;e<f.length;e++){alert(f[e].name+": "+f[e].value)}};JXG.Server.loadModule=function(e){return JXG.Server.callServer("load",JXG.Server.loadModule_cb,{module:e},true)};JXG.Server.load=JXG.Server.loadModule;JXG.DataSource=function(){this.data=[];this.columnHeaders=[];this.rowHeaders=[];return this};JXG.extend(JXG.DataSource.prototype,{loadFromArray:function(k,l,h){var g,f,e;if(typeof l=="undefined"){l=false}if(typeof h=="undefined"){h=false}if(JXG.isArray(l)){this.columnHeaders=l;l=false}if(JXG.isArray(h)){this.rowHeaders=h;h=false}this.data=[];if(l){this.columnHeaders=[]}if(h){this.rowHeaders=[]}if(typeof k!="undefined"){this.data=new Array(k.length);for(g=0;g<k.length;g++){this.data[g]=new Array(k[g].length);for(f=0;f<k[g].length;f++){e=k[g][f];if(""+parseFloat(e)==e){this.data[g][f]=parseFloat(e)}else{if(e!="-"){this.data[g][f]=e}else{this.data[g][f]=NaN}}}}if(l){this.columnHeaders=this.data[0].slice(1);this.data=this.data.slice(1)}if(h){this.rowHeaders=new Array();for(g=0;g<this.data.length;g++){this.rowHeaders.push(this.data[g][0]);this.data[g]=this.data[g].slice(1)}}}return this},loadFromTable:function(n,g,l){var o,k,h,f,m,e;if(typeof g=="undefined"){g=false}if(typeof l=="undefined"){l=false}if(JXG.isArray(g)){this.columnHeaders=g;g=false}if(JXG.isArray(l)){this.rowHeaders=l;l=false}this.data=[];if(g){this.columnHeaders=[]}if(l){this.rowHeaders=[]}n=document.getElementById(n);if(typeof n!="undefined"){o=n.getElementsByTagName("tr");this.data=new Array(o.length);for(k=0;k<o.length;k++){f=o[k].getElementsByTagName("td");this.data[k]=new Array(f.length);for(h=0;h<f.length;h++){m=f[h].innerHTML;if(""+parseFloat(m)==m){this.data[k][h]=parseFloat(m)}else{if(m!="-"){this.data[k][h]=m}else{this.data[k][h]=NaN}}}}if(g){this.columnHeaders=this.data[0].slice(1);this.data=this.data.slice(1)}if(l){this.rowHeaders=new Array();for(k=0;k<this.data.length;k++){this.rowHeaders.push(this.data[k][0]);this.data[k]=this.data[k].slice(1)}}}return this},addColumn:function(e,g,f){},addRow:function(e,g,f){},getColumn:function(f){var e=new Array(this.data.length),g;if(typeof f=="string"){for(g=0;g<this.columnHeaders.length;g++){if(f==this.columnHeaders[g]){f=g;break}}}for(g=0;g<this.data.length;g++){if(this.data[g].length>f){e[g]=parseFloat(this.data[g][f])}}return e},getRow:function(g){var e,f;if(typeof g=="string"){for(f=0;f<this.rowHeaders.length;f++){if(g==this.rowHeaders[f]){g=f;break}}}e=new Array(this.data[g].length);for(f=0;f<this.data[g].length;f++){e[f]=this.data[g][f]}return e}});JXG.JessieCode=function(g,f){var e;this.sstack=[{}];this.scope=0;this.pstack=[[]];this.pscope=0;this.propstack=[{}];this.propscope=0;this.propobj=0;this.lhs=[];this.isLHS=false;this.warnLog="jcwarn";this.builtIn=this.defineBuiltIn();this.board=null;this.countLines=true;this.parCurLine=1;this.parCurColumn=0;this.maxRuntime=10000;if(typeof g==="string"){this.parse(g)}};JXG.extend(JXG.JessieCode.prototype,{node:function(f,g,e){return{type:f,value:g,children:e}},createNode:function(g,h,f){var j=this.node(g,h,[]),e;for(e=2;e<arguments.length;e++){j.children.push(arguments[e])}j.line=this.parCurLine;j.col=this.parCurColumn;return j},getElementById:function(e){return this.board.objects[e]},creator:(function(){var f={},e;e=function(h){var g;if(typeof f[this.board.id+h]==="function"){return f[this.board.id+h]}else{g=(function(i){return function(l,k){var j;if(JXG.exists(k)){j=k}else{j={name:(i.lhs[i.scope]!==0?i.lhs[i.scope]:"")}}return i.board.create(h,l,j)}})(this);g.creator=true;f[this.board.id+h]=g;return g}};e.clearCache=function(){f={}};return e})(),letvar:function(f,e){if(this.builtIn[f]){this._warn('"'+f+'" is a predefined value.')}this.sstack[this.scope][f]=e},isLocalVariable:function(f){var e;for(e=this.scope;e>-1;e--){if(JXG.exists(this.sstack[e][f])){return e}}return -1},isCreator:function(e){return !!JXG.JSXGraph.elements[e]},isMathMethod:function(e){return e!=="E"&&!!Math[e]},isBuiltIn:function(e){return !!this.builtIn[e]},getvar:function(h,e){var g,f;e=JXG.def(e,false);g=this.isLocalVariable(h);if(g>-1){return this.sstack[g][h]}if(this.isCreator(h)){return this.creator(h)}if(this.isMathMethod(h)){return Math[h]}if(this.isBuiltIn(h)){return this.builtIn[h]}if(!e){g=JXG.getRef(this.board,h);if(g!==h){return g}}return f},getvarJS:function(g,e){var f;e=JXG.def(e,false);if(JXG.indexOf(this.pstack[this.pscope],g)>-1){return g}f=this.isLocalVariable(g);if(f>-1){return"$jc$.sstack["+f+"]['"+g+"']"}if(this.isCreator(g)){return"(function () { var a = Array.prototype.slice.call(arguments, 0); return $jc$.board.create.apply(this, ['"+g+"'].concat(a)); })"}if(this.isMathMethod(g)){return"Math."+g}if(this.isBuiltIn(g)){return this.builtIn[g].src}if(!e){if(JXG.isId(this.board,g)){return"$jc$.board.objects['"+g+"']"}else{if(JXG.isName(this.board,g)){return"$jc$.board.elementsByName['"+g+"']"}else{if(JXG.isGroup(this.board,g)){return"$jc$.board.groups['"+g+"']"}}}}return""},setProp:function(i,h,g){var f={},e,j;if(i.elementClass===JXG.OBJECT_CLASS_POINT&&(h==="X"||h==="Y")){h=h.toLowerCase();if(i.isDraggable&&typeof g==="number"){e=h==="x"?g:i.X();j=h==="y"?g:i.Y();i.setPosition(JXG.COORDS_BY_USER,e,j)}else{if(i.isDraggable&&(typeof g==="function"||typeof g==="string")){e=h==="x"?g:i.coords.usrCoords[1];j=h==="y"?g:i.coords.usrCoords[2];i.addConstraint([e,j])}else{if(!i.isDraggable){e=h==="x"?g:i.XEval.origin;j=h==="y"?g:i.YEval.origin;i.addConstraint([e,j])}}}this.board.update()}else{if(i.type===JXG.OBJECT_TYPE_TEXT&&(h==="X"||h==="Y")){if(typeof g==="number"){i[h]=function(){return g}}else{if(typeof g==="function"){i.isDraggable=false;i[h]=g}else{if(typeof g==="string"){i.isDraggable=false;i[h]=JXG.createFunction(g,this.board,null,true);i[h+"jc"]=g}}}i[h].origin=g;this.board.update()}else{if(i.type&&i.elementClass&&i.visProp){f[h]=g;i.setProperty(f)}else{i[h]=g}}}},utf8_encode:function(f){var e=[],h,g;for(h=0;h<f.length;h++){g=f.charCodeAt(h);if(g<128){e.push(String.fromCharCode(g))}else{e.push("&#x"+g.toString(16)+";")}}return e.join("")},parse:function(e,o){var p=0,q=[],f=[],n=this,s,l=["Abs","ACos","ASin","ATan","Ceil","Cos","Exp","Factorial","Floor","Log","Max","Min","Random","Round","Sin","Sqrt","Tan","Trunc","If","Deg","Rad","Dist"],r,m=e.replace(/\r\n/g,"\n").split("\n"),k,h,g=[];if(!JXG.exists(o)){o=false}for(k=0;k<m.length;k++){if(!(JXG.trim(m[k])[0]==="/"&&JXG.trim(m[k])[1]==="/")){if(o){for(h=0;h<l.length;h++){r=new RegExp(l[h]+"\\(","g");m[k]=m[k].replace(r,l[h].toLowerCase()+"(")}}g.push(m[k])}}e=g.join("\n");e=this.utf8_encode(e);if((p=this._parse(e,q,f))>0){for(k=0;k<p;k++){this.line=q[k].line;this._error("Parse error in line "+q[k].line+" near >"+e.substr(q[k].offset,30)+'<, expecting "'+f[k].join()+'"')}}},snippet:function(j,g,f,i){var k,l,h,e;k="jxg__tmp__intern_"+JXG.Util.genUUID().replace(/\-/g,"");if(!JXG.exists(g)){g=true}if(!JXG.exists(f)){f=""}if(!JXG.exists(i)){i=false}h=this.sstack[0][k];this.countLines=false;l=k+" = "+(g?" function ("+f+") { return ":"")+j+(g?"; }":"")+";";this.parse(l,i);e=this.sstack[0][k];if(JXG.exists(h)){this.sstack[0][k]=h}else{delete this.sstack[0][k]}this.countLines=true;return e},replaceIDs:function(g){var f,e;if(g.replaced){e=this.board.objects[g.children[1].children[0].value];if(JXG.exists(e)&&JXG.exists(e)&&e.name!==""){g.type="node_var";g.value=e.name;g.children.length=0;delete g.replaced}}if(g.children){for(f=g.children.length;f>0;f--){if(JXG.exists(g.children[f-1])){g.children[f-1]=this.replaceIDs(g.children[f-1])}}}return g},replaceNames:function(g){var f,e;e=g.value;if(g.type=="node_op"&&e=="op_lhs"&&g.children.length===1){this.isLHS=true}else{if(g.type=="node_var"){if(this.isLHS){this.letvar(e,true)}else{if(!JXG.exists(this.getvar(e,true))&&JXG.exists(this.board.elementsByName[e])){g=this.createReplacementNode(g)}}}}if(g.children){for(f=g.children.length;f>0;f--){if(JXG.exists(g.children[f-1])){g.children[f-1]=this.replaceNames(g.children[f-1])}}}if(g.type=="node_op"&&g.value=="op_lhs"&&g.children.length===1){this.isLHS=false}return g},createReplacementNode:function(g){var e=g.value,f=this.board.elementsByName[e];g=this.createNode("node_op","op_execfun",this.createNode("node_var","$"),this.createNode("node_op","op_param",this.createNode("node_str",f.id)));g.replaced=true;return g},collectDependencies:function(j,f){var h,g,k;g=j.value;if(j.type=="node_var"){k=this.getvar(g);if(k&&k.visProp&&k.type&&k.elementClass&&k.id){f[k.id]=k}}if(j.type=="node_op"&&j.value=="op_execfun"&&j.children.length>1&&j.children[0].value=="$"&&j.children[1].children.length>0){k=j.children[1].children[0].value;f[k]=this.board.objects[k]}if(j.children){for(h=j.children.length;h>0;h--){if(JXG.exists(j.children[h-1])){this.collectDependencies(j.children[h-1],f)}}}},resolveProperty:function(h,f,g){g=JXG.def(g,false);if(h&&h.type&&h.elementClass&&h.methodMap){if(f==="label"){h=h.label;f="content"}else{if(JXG.exists(h.subs[f])){h=h.subs}else{if(JXG.exists(h.methodMap[f])){f=h.methodMap[f]}else{h=h.visProp;f=f.toLowerCase()}}}}if(!JXG.exists(h)){this._error(h+" is not an object.")}if(!JXG.exists(h[f])){this._error("unknown property "+f+".")}if(g&&typeof h[f]==="function"){return function(){return h[f].apply(h,arguments)}}return h[f]},execute:function(node){var ret,v,i,e,parents=[];ret=0;if(this.cancel){this._error("Max runtime exceeded")}if(!node){return ret}this.line=node.line;switch(node.type){case"node_op":switch(node.value){case"op_none":if(node.children[0]){this.execute(node.children[0])}if(node.children[1]){ret=this.execute(node.children[1])}break;case"op_assign":v=this.execute(node.children[0]);this.lhs[this.scope]=v[1];if(v[0].type&&v[0].elementClass&&v[0].methodMap&&v[1]==="label"){this._error("Left-hand side of assignment is read-only.")}if(v[0]!==this.sstack[this.scope]||(JXG.isArray(v[0])&&typeof v[1]==="number")){this.setProp(v[0],v[1],this.execute(node.children[1]))}else{this.letvar(v[1],this.execute(node.children[1]))}this.lhs[this.scope]=0;break;case"op_noassign":ret=this.execute(node.children[0]);break;case"op_if":if(this.execute(node.children[0])){ret=this.execute(node.children[1])}break;case"op_if_else":if(this.execute(node.children[0])){ret=this.execute(node.children[1])}else{ret=this.execute(node.children[2])}break;case"op_while":while(this.execute(node.children[0])){this.execute(node.children[1])}break;case"op_do":do{this.execute(node.children[0])}while(this.execute(node.children[1]));break;case"op_for":i=new Date().getTime();for(this.execute(node.children[0]);this.execute(node.children[1]);this.execute(node.children[2])){if(new Date().getTime()-i>this.maxRuntime||this.cancel){this._error("for: max runtime exceeded");break}this.execute(node.children[3])}break;case"op_param":if(node.children[1]){this.execute(node.children[1])}ret=node.children[0];this.pstack[this.pscope].push(ret);break;case"op_paramdef":if(node.children[1]){this.execute(node.children[1])}ret=node.children[0];this.pstack[this.pscope].push(ret);break;case"op_proplst":if(node.children[0]){this.execute(node.children[0])}if(node.children[1]){this.execute(node.children[1])}break;case"op_proplst_val":this.propstack.push({});this.propscope++;this.execute(node.children[0]);ret=this.propstack[this.propscope];this.propstack.pop();this.propscope--;break;case"op_prop":this.propstack[this.propscope][node.children[0]]=this.execute(node.children[1]);break;case"op_array":var l;this.pstack.push([]);this.pscope++;this.execute(node.children[0]);ret=[];l=this.pstack[this.pscope].length;for(i=0;i<l;i++){ret.push(this.execute(this.pstack[this.pscope][i]))}this.pstack.pop();this.pscope--;break;case"op_extvalue":var undef;ret=this.execute(node.children[0]);i=this.execute(node.children[1]);if(typeof i==="number"&&Math.abs(Math.round(i)-i)<JXG.Math.eps){ret=ret[i]}else{ret=undef}break;case"op_return":if(this.scope===0){this._error("Unexpected return.")}else{return this.execute(node.children[0])}break;case"op_function":this.pstack.push([]);this.pscope++;this.execute(node.children[0]);if(this.board.options.jc.compile){this.sstack.push({});this.scope++;this.isLHS=false;for(i=0;i<this.pstack[this.pscope].length;i++){this.sstack[this.scope][this.pstack[this.pscope][i]]=this.pstack[this.pscope][i]}this.replaceNames(node.children[1]);ret=(function($jc$){var p=$jc$.pstack[$jc$.pscope].join(", "),str="var f = function ("+p+") {\n$jc$.sstack.push([]);\n$jc$.scope++;\nvar r = (function () {\n"+$jc$.compile(node.children[1],true)+"})();\n$jc$.sstack.pop();\n$jc$.scope--;\nreturn r;\n}; f;";return eval(str)})(this);this.sstack.pop();this.scope--}else{ret=(function(_pstack,that){return function(){var r;that.sstack.push({});that.scope++;for(r=0;r<_pstack.length;r++){that.sstack[that.scope][_pstack[r]]=arguments[r]}r=that.execute(node.children[1]);that.sstack.pop();that.scope--;return r}})(this.pstack[this.pscope],this)}ret.toJS=ret.toString;ret.toString=(function(_that){return function(){return _that.compile(_that.replaceIDs(JXG.deepCopy(node)))}})(this);ret.deps={};this.collectDependencies(node.children[1],ret.deps);this.pstack.pop();this.pscope--;break;case"op_execfun":var fun,attr,sc;this.pstack.push([]);this.pscope++;this.execute(node.children[1]);if(typeof node.children[2]!=="undefined"){attr=this.execute(node.children[2])}fun=this.execute(node.children[0]);if(fun.sc){sc=fun.sc}else{sc=this}for(i=0;i<this.pstack[this.pscope].length;i++){parents[i]=this.execute(this.pstack[this.pscope][i])}if(typeof fun==="function"&&!fun.creator){ret=fun.apply(sc,parents)}else{if(typeof fun==="function"&&!!fun.creator){ret=fun(parents,attr);ret.jcLine=this.line}else{this._error("Function '"+fun+"' is undefined.")}}this.pstack.pop();this.pscope--;break;case"op_property":e=this.execute(node.children[0]);v=node.children[1];ret=this.resolveProperty(e,v,false);ret.sc=e;break;case"op_lhs":v=node.children[0];if(v.children&&v.type&&v.value){v=this.execute(v)}if(node.children.length===1){e=this.sstack[this.scope]}else{e=this.execute(node.children[1]);if(e.type&&e.elementClass&&v.toLowerCase&&v.toLowerCase()!=="x"&&v.toLowerCase()!=="y"){v=v.toLowerCase()}}ret=[e,v];break;case"op_use":var found=false;for(var b in JXG.JSXGraph.boards){if(JXG.JSXGraph.boards[b].container===node.children[0].toString()){this.board=JXG.JSXGraph.boards[b];found=true}}if(!found){this._error("Board '"+node.children[0].toString()+"' not found!")}break;case"op_delete":v=this.getvar(node.children[0]);if(typeof v==="object"&&JXG.exists(v.type)&&JXG.exists(v.elementClass)){this.board.removeObject(v)}break;case"op_equ":ret=this.execute(node.children[0])==this.execute(node.children[1]);break;case"op_neq":ret=this.execute(node.children[0])!=this.execute(node.children[1]);break;case"op_approx":ret=Math.abs(this.execute(node.children[0])-this.execute(node.children[1]))<JXG.Math.eps;break;case"op_grt":ret=this.execute(node.children[0])>this.execute(node.children[1]);break;case"op_lot":ret=this.execute(node.children[0])<this.execute(node.children[1]);break;case"op_gre":ret=this.execute(node.children[0])>=this.execute(node.children[1]);break;case"op_loe":ret=this.execute(node.children[0])<=this.execute(node.children[1]);break;case"op_or":ret=this.execute(node.children[0])||this.execute(node.children[1]);break;case"op_and":ret=this.execute(node.children[0])&&this.execute(node.children[1]);break;case"op_not":ret=!this.execute(node.children[0]);break;case"op_add":ret=JXG.Math.Statistics.add(this.execute(node.children[0]),this.execute(node.children[1]));break;case"op_sub":ret=JXG.Math.Statistics.subtract(this.execute(node.children[0]),this.execute(node.children[1]));break;case"op_div":ret=JXG.Math.Statistics.div(this.execute(node.children[0]),this.execute(node.children[1]));break;case"op_mod":ret=JXG.Math.Statistics.mod(this.execute(node.children[0]),this.execute(node.children[1]),true);break;case"op_mul":ret=this.mul(this.execute(node.children[0]),this.execute(node.children[1]));break;case"op_exp":ret=Math.pow(this.execute(node.children[0]),this.execute(node.children[1]));break;case"op_neg":ret=this.execute(node.children[0])*-1;break}break;case"node_var":ret=this.getvar(node.value);break;case"node_const":ret=Number(node.value);break;case"node_const_bool":ret=node.value.toLowerCase()!=="false";break;case"node_str":ret=node.value;break}return ret},compile:function(j,l){var g,h,k,f;g="";if(!JXG.exists(l)){l=false}if(!j){return g}switch(j.type){case"node_op":switch(j.value){case"op_none":if(j.children[0]){g=this.compile(j.children[0],l)}if(j.children[1]){g+=this.compile(j.children[1],l)}break;case"op_assign":k=this.compile(j.children[0],l);if(l){if(JXG.isArray(k)){g="$jc$.setProp("+k[0]+", '"+k[1]+"', "+this.compile(j.children[1],l)+");\n"}else{if(this.isLocalVariable(k)!==this.scope){this.sstack[this.scope][k]=true}g="$jc$.sstack["+this.scope+"]['"+k+"'] = "+this.compile(j.children[1],l)+";\n"}}else{g=k+" = "+this.compile(j.children[1],l)+";\n"}break;case"op_noassign":g=this.compile(j.children[0],l);break;case"op_if":g=" if ("+this.compile(j.children[0],l)+") "+this.compile(j.children[1],l);break;case"op_if_else":g=" if ("+this.compile(j.children[0],l)+")"+this.compile(j.children[1],l);g+=" else "+this.compile(j.children[2],l);break;case"op_while":g=" while ("+this.compile(j.children[0],l)+") {\n"+this.compile(j.children[1],l)+"}\n";break;case"op_do":g=" do {\n"+this.compile(j.children[0],l)+"} while ("+this.compile(j.children[1],l)+");\n";break;case"op_for":g=" for ("+this.compile(j.children[0],l)+"; "+this.compile(j.children[1],l)+"; "+this.compile(j.children[2],l)+") {\n"+this.compile(j.children[3],l)+"\n}\n";break;case"op_param":if(j.children[1]){g=this.compile(j.children[1],l)+", "}g+=this.compile(j.children[0],l);break;case"op_paramdef":if(j.children[1]){g=this.compile(j.children[1],l)+", "}g+=j.children[0];break;case"op_proplst":if(j.children[0]){g=this.compile(j.children[0],l)+", "}g+=this.compile(j.children[1],l);break;case"op_prop":g=j.children[0]+": "+this.compile(j.children[1],l);break;case"op_proplst_val":g=(l?"{":"<<")+this.compile(j.children[0],l)+(l?"}":">>");break;case"op_array":g="["+this.compile(j.children[0],l)+"]";break;case"op_extvalue":g=this.compile(j.children[0],l)+"["+this.compile(j.children[1],l)+"]";break;case"op_return":g=" return "+this.compile(j.children[0],l)+";\n";break;case"op_function":g=" function ("+this.compile(j.children[0],l)+") {\n"+this.compile(j.children[1],l)+"}";break;case"op_execfun":if(j.children[2]){k=(l?"{":"<<")+this.compile(j.children[2],l)+(l?"}":">>")}g=this.compile(j.children[0],l)+"("+this.compile(j.children[1],l)+(j.children[2]?", "+k:"")+")";if(l&&j.children[0].value==="$"){g="$jc$.board.objects["+this.compile(j.children[1],l)+"]"}break;case"op_property":if(l&&j.children[1]!=="X"&&j.children[1]!=="Y"){g="$jc$.resolveProperty("+this.compile(j.children[0],l)+", '"+j.children[1]+"', true)"}else{g=this.compile(j.children[0],l)+"."+j.children[1]}break;case"op_lhs":if(j.children.length===1){g=j.children[0]}else{if(j.children[2]==="dot"){if(l){g=[this.compile(j.children[1],l),j.children[0]]}else{g=this.compile(j.children[1],l)+"."+j.children[0]}}else{if(j.children[2]==="bracket"){if(l){g=[this.compile(j.children[1],l),this.compile(j.children[0],l)]}else{g=this.compile(j.children[1],l)+"["+this.compile(j.children[0],l)+"]"}}}}break;case"op_use":if(l){g="$jc$.board = JXG.JSXGraph.boards['"+j.children[0]+"']"}else{g="use "+j.children[0]+";"}break;case"op_delete":g="delete "+j.children[0];break;case"op_equ":g="("+this.compile(j.children[0],l)+" == "+this.compile(j.children[1],l)+")";break;case"op_neq":g="("+this.compile(j.children[0],l)+" != "+this.compile(j.children[1],l)+")";break;case"op_approx":g="("+this.compile(j.children[0],l)+" ~= "+this.compile(j.children[1],l)+")";break;case"op_grt":g="("+this.compile(j.children[0],l)+" > "+this.compile(j.children[1],l)+")";break;case"op_lot":g="("+this.compile(j.children[0],l)+" < "+this.compile(j.children[1],l)+")";break;case"op_gre":g="("+this.compile(j.children[0],l)+" >= "+this.compile(j.children[1],l)+")";break;case"op_loe":g="("+this.compile(j.children[0],l)+" <= "+this.compile(j.children[1],l)+")";break;case"op_or":g="("+this.compile(j.children[0],l)+" || "+this.compile(j.children[1],l)+")";break;case"op_and":g="("+this.compile(j.children[0],l)+" && "+this.compile(j.children[1],l)+")";break;case"op_not":g="!("+this.compile(j.children[0],l)+")";break;case"op_add":if(l){g="JXG.Math.Statistics.add("+this.compile(j.children[0],l)+", "+this.compile(j.children[1],l)+")"}else{g="("+this.compile(j.children[0],l)+" + "+this.compile(j.children[1],l)+")"}break;case"op_sub":if(l){g="JXG.Math.Statistics.subtract("+this.compile(j.children[0],l)+", "+this.compile(j.children[1],l)+")"}else{g="("+this.compile(j.children[0],l)+" - "+this.compile(j.children[1],l)+")"}break;case"op_div":if(l){g="JXG.Math.Statistics.div("+this.compile(j.children[0],l)+", "+this.compile(j.children[1],l)+")"}else{g="("+this.compile(j.children[0],l)+" / "+this.compile(j.children[1],l)+")"}break;case"op_mod":if(l){g="JXG.Math.mod("+this.compile(j.children[0],l)+", "+this.compile(j.children[1],l)+", true)"}else{g="("+this.compile(j.children[0],l)+" % "+this.compile(j.children[1],l)+")"}break;case"op_mul":if(l){g="$jc$.mul("+this.compile(j.children[0],l)+", "+this.compile(j.children[1],l)+")"}else{g="("+this.compile(j.children[0],l)+" * "+this.compile(j.children[1],l)+")"}break;case"op_exp":if(l){g="Math.pow("+this.compile(j.children[0],l)+", "+this.compile(j.children[1],l)+")"}else{g="("+this.compile(j.children[0],l)+"^"+this.compile(j.children[1],l)+")"}break;case"op_neg":g="(-"+this.compile(j.children[0],l)+")";break}break;case"node_var":if(l){g=this.getvarJS(j.value)}else{g=j.value}break;case"node_const":g=j.value;break;case"node_const_bool":g=j.value;break;case"node_str":g="'"+j.value.replace(/'/g,"\\'")+"'";break}if(j.needsBrackets){g="{\n"+g+"}\n"}return g},X:function(f){return f.X()},Y:function(f){return f.Y()},V:function(f){return f.Value()},L:function(f){return f.L()},dist:function(f,e){if(!JXG.exists(f)||!JXG.exists(f.Dist)){this._error("Error: Can't calculate distance.")}return f.Dist(e)},mul:function(f,e){if(JXG.isArray(f)*JXG.isArray(e)){return JXG.Math.innerProduct(f,e,Math.min(f.length,e.length))}else{return JXG.Math.Statistics.multiply(f,e)}},defineBuiltIn:function(){var e=this,f={PI:Math.PI,EULER:Math.E,X:e.X,Y:e.Y,V:e.V,L:e.L,dist:e.dist,rad:JXG.Math.Geometry.rad,deg:JXG.Math.Geometry.trueAngle,factorial:JXG.Math.factorial,trunc:JXG.trunc,"$":e.getElementById};f.rad.sc=JXG.Math.Geometry;f.deg.sc=JXG.Math.Geometry;f.factorial.sc=JXG.Math;f.PI.src="Math.PI";f.EULER.src="Math.E";f.X.src="$jc$.X";f.Y.src="$jc$.Y";f.V.src="$jc$.V";f.L.src="$jc$.L";f.dist.src="$jc$.dist";f.rad.src="JXG.Math.Geometry.rad";f.deg.src="JXG.Math.Geometry.trueAngle";f.factorial.src="JXG.Math.factorial";f.trunc.src="JXG.trunc";f["$"].src="(function (n) { return JXG.getRef($jc$.board, n); })";return f},_debug:function(e){if(typeof console!=="undefined"){console.log(e)}else{if(document.getElementById("debug")!==null){document.getElementById("debug").innerHTML+=e+"<br />"}}},_error:function(g){var f=new Error("Error("+this.line+"): "+g);f.line=this.line;throw f},_warn:function(e){if(typeof console!=="undefined"){console.log("Warning("+this.line+"): "+e)}else{if(document.getElementById(this.warnLog)!==null){document.getElementById(this.warnLog).innerHTML+="Warning("+this.line+"): "+e+"<br />"}}}});JXG.extend(JXG.JessieCode.prototype,{_lex:function(e){var i,f=-1,h=0,k=0,j,g;while(1){i=0;f=-1;h=0;k=0;j=e.offset+1+(h-k);do{j--;i=0;f=-2;k=j;if(e.src.length<=k){return 66}do{g=e.src.charCodeAt(j);switch(i){case 0:if((g>=9&&g<=10)||g==13||g==32){i=1}else{if(g==33){i=2}else{if(g==35){i=3}else{if(g==36||(g>=65&&g<=67)||(g>=71&&g<=72)||(g>=74&&g<=81)||g==83||g==86||(g>=88&&g<=90)||g==95||(g>=97&&g<=99)||(g>=103&&g<=104)||(g>=106&&g<=113)||g==115||g==118||(g>=120&&g<=122)){i=4}else{if(g==37){i=5}else{if(g==40){i=6}else{if(g==41){i=7}else{if(g==42){i=8}else{if(g==43){i=9}else{if(g==44){i=10}else{if(g==45){i=11}else{if(g==46){i=12}else{if(g==47){i=13}else{if((g>=48&&g<=57)){i=14}else{if(g==58){i=15}else{if(g==59){i=16}else{if(g==60){i=17}else{if(g==61){i=18}else{if(g==62){i=19}else{if(g==91){i=20}else{if(g==93){i=21}else{if(g==94){i=22}else{if(g==123){i=23}else{if(g==124){i=24}else{if(g==125){i=25}else{if(g==38){i=48}else{if(g==68||g==100){i=49}else{if(g==39){i=51}else{if(g==73||g==105){i=52}else{if(g==126){i=53}else{if(g==70||g==102){i=64}else{if(g==85||g==117){i=65}else{if(g==69||g==101){i=73}else{if(g==84||g==116){i=74}else{if(g==87||g==119){i=80}else{if(g==82||g==114){i=84}else{i=-1}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}break;case 1:i=-1;f=2;h=j;break;case 2:if(g==61){i=26}else{i=-1}f=31;h=j;break;case 3:i=-1;f=41;h=j;break;case 4:if((g>=48&&g<=57)||(g>=65&&g<=90)||g==95||(g>=97&&g<=122)){i=4}else{i=-1}f=45;h=j;break;case 5:i=-1;f=35;h=j;break;case 6:i=-1;f=38;h=j;break;case 7:i=-1;f=39;h=j;break;case 8:i=-1;f=36;h=j;break;case 9:i=-1;f=32;h=j;break;case 10:i=-1;f=40;h=j;break;case 11:i=-1;f=33;h=j;break;case 12:if((g>=48&&g<=57)){i=29}else{i=-1}f=44;h=j;break;case 13:i=-1;f=34;h=j;break;case 14:if((g>=48&&g<=57)){i=14}else{if(g==46){i=29}else{i=-1}}f=47;h=j;break;case 15:i=-1;f=42;h=j;break;case 16:i=-1;f=20;h=j;break;case 17:if(g==60){i=30}else{if(g==61){i=31}else{i=-1}}f=28;h=j;break;case 18:if(g==61){i=32}else{i=-1}f=21;h=j;break;case 19:if(g==61){i=33}else{if(g==62){i=34}else{i=-1}}f=27;h=j;break;case 20:i=-1;f=16;h=j;break;case 21:i=-1;f=17;h=j;break;case 22:i=-1;f=37;h=j;break;case 23:i=-1;f=18;h=j;break;case 24:if(g==124){i=37}else{i=-1}f=43;h=j;break;case 25:i=-1;f=19;h=j;break;case 26:i=-1;f=23;h=j;break;case 27:i=-1;f=30;h=j;break;case 28:i=-1;f=46;h=j;break;case 29:if((g>=48&&g<=57)){i=29}else{i=-1}f=48;h=j;break;case 30:i=-1;f=14;h=j;break;case 31:i=-1;f=25;h=j;break;case 32:i=-1;f=22;h=j;break;case 33:i=-1;f=26;h=j;break;case 34:i=-1;f=15;h=j;break;case 35:if((g>=48&&g<=57)||(g>=65&&g<=90)||g==95||(g>=97&&g<=122)){i=4}else{i=-1}f=6;h=j;break;case 36:if((g>=48&&g<=57)||(g>=65&&g<=90)||g==95||(g>=97&&g<=122)){i=4}else{i=-1}f=3;h=j;break;case 37:i=-1;f=29;h=j;break;case 38:i=-1;f=24;h=j;break;case 39:if((g>=48&&g<=57)||(g>=65&&g<=90)||g==95||(g>=97&&g<=122)){i=4}else{i=-1}f=7;h=j;break;case 40:if((g>=48&&g<=57)||(g>=65&&g<=90)||g==95||(g>=97&&g<=122)){i=4}else{i=-1}f=9;h=j;break;case 41:if((g>=48&&g<=57)||(g>=65&&g<=90)||g==95||(g>=97&&g<=122)){i=4}else{i=-1}f=4;h=j;break;case 42:if((g>=48&&g<=57)||(g>=65&&g<=90)||g==95||(g>=97&&g<=122)){i=4}else{i=-1}f=12;h=j;break;case 43:if((g>=48&&g<=57)||(g>=65&&g<=90)||g==95||(g>=97&&g<=122)){i=4}else{i=-1}f=13;h=j;break;case 44:if((g>=48&&g<=57)||(g>=65&&g<=90)||g==95||(g>=97&&g<=122)){i=4}else{i=-1}f=5;h=j;break;case 45:if((g>=48&&g<=57)||(g>=65&&g<=90)||g==95||(g>=97&&g<=122)){i=4}else{i=-1}f=11;h=j;break;case 46:if((g>=48&&g<=57)||(g>=65&&g<=90)||g==95||(g>=97&&g<=122)){i=4}else{i=-1}f=10;h=j;break;case 47:if((g>=48&&g<=57)||(g>=65&&g<=90)||g==95||(g>=97&&g<=122)){i=4}else{i=-1}f=8;h=j;break;case 48:if(g==38){i=27}else{i=-1}break;case 49:if((g>=48&&g<=57)||(g>=65&&g<=68)||(g>=70&&g<=78)||(g>=80&&g<=90)||g==95||(g>=97&&g<=100)||(g>=102&&g<=110)||(g>=112&&g<=122)){i=4}else{if(g==79||g==111){i=35}else{if(g==69||g==101){i=81}else{i=-1}}}f=45;h=j;break;case 50:if(g==39){i=28}else{if((g>=0&&g<=38)||(g>=40&&g<=91)||(g>=93&&g<=254)){i=51}else{if(g==92){i=55}else{i=-1}}}f=46;h=j;break;case 51:if(g==39){i=28}else{if((g>=0&&g<=38)||(g>=40&&g<=91)||(g>=93&&g<=254)){i=51}else{if(g==92){i=55}else{i=-1}}}break;case 52:if((g>=48&&g<=57)||(g>=65&&g<=69)||(g>=71&&g<=90)||g==95||(g>=97&&g<=101)||(g>=103&&g<=122)){i=4}else{if(g==70||g==102){i=36}else{i=-1}}f=45;h=j;break;case 53:if(g==61){i=38}else{i=-1}break;case 54:if((g>=48&&g<=57)||(g>=65&&g<=81)||(g>=83&&g<=90)||g==95||(g>=97&&g<=113)||(g>=115&&g<=122)){i=4}else{if(g==82||g==114){i=39}else{i=-1}}f=45;h=j;break;case 55:if(g==39){i=50}else{if((g>=0&&g<=38)||(g>=40&&g<=91)||(g>=93&&g<=254)){i=51}else{if(g==92){i=55}else{i=-1}}}break;case 56:if((g>=48&&g<=57)||(g>=65&&g<=68)||(g>=70&&g<=90)||g==95||(g>=97&&g<=100)||(g>=102&&g<=122)){i=4}else{if(g==69||g==101){i=40}else{i=-1}}f=45;h=j;break;case 57:if((g>=48&&g<=57)||(g>=65&&g<=68)||(g>=70&&g<=90)||g==95||(g>=97&&g<=100)||(g>=102&&g<=122)){i=4}else{if(g==69||g==101){i=41}else{i=-1}}f=45;h=j;break;case 58:if((g>=48&&g<=57)||(g>=65&&g<=68)||(g>=70&&g<=90)||g==95||(g>=97&&g<=100)||(g>=102&&g<=122)){i=4}else{if(g==69||g==101){i=42}else{i=-1}}f=45;h=j;break;case 59:if((g>=48&&g<=57)||(g>=65&&g<=68)||(g>=70&&g<=90)||g==95||(g>=97&&g<=100)||(g>=102&&g<=122)){i=4}else{if(g==69||g==101){i=43}else{i=-1}}f=45;h=j;break;case 60:if((g>=48&&g<=57)||(g>=65&&g<=68)||(g>=70&&g<=90)||g==95||(g>=97&&g<=100)||(g>=102&&g<=122)){i=4}else{if(g==69||g==101){i=44}else{i=-1}}f=45;h=j;break;case 61:if((g>=48&&g<=57)||(g>=65&&g<=68)||(g>=70&&g<=90)||g==95||(g>=97&&g<=100)||(g>=102&&g<=122)){i=4}else{if(g==69||g==101){i=45}else{i=-1}}f=45;h=j;break;case 62:if((g>=48&&g<=57)||(g>=65&&g<=77)||(g>=79&&g<=90)||g==95||(g>=97&&g<=109)||(g>=111&&g<=122)){i=4}else{if(g==78||g==110){i=46}else{i=-1}}f=45;h=j;break;case 63:if((g>=48&&g<=57)||(g>=65&&g<=77)||(g>=79&&g<=90)||g==95||(g>=97&&g<=109)||(g>=111&&g<=122)){i=4}else{if(g==78||g==110){i=47}else{i=-1}}f=45;h=j;break;case 64:if((g>=48&&g<=57)||(g>=66&&g<=78)||(g>=80&&g<=84)||(g>=86&&g<=90)||g==95||(g>=98&&g<=110)||(g>=112&&g<=116)||(g>=118&&g<=122)){i=4}else{if(g==79||g==111){i=54}else{if(g==65||g==97){i=75}else{if(g==85||g==117){i=86}else{i=-1}}}}f=45;h=j;break;case 65:if((g>=48&&g<=57)||(g>=65&&g<=82)||(g>=84&&g<=90)||g==95||(g>=97&&g<=114)||(g>=116&&g<=122)){i=4}else{if(g==83||g==115){i=56}else{i=-1}}f=45;h=j;break;case 66:if((g>=48&&g<=57)||(g>=65&&g<=82)||(g>=84&&g<=90)||g==95||(g>=97&&g<=114)||(g>=116&&g<=122)){i=4}else{if(g==83||g==115){i=57}else{i=-1}}f=45;h=j;break;case 67:if((g>=48&&g<=57)||(g>=65&&g<=84)||(g>=86&&g<=90)||g==95||(g>=97&&g<=116)||(g>=118&&g<=122)){i=4}else{if(g==85||g==117){i=58}else{i=-1}}f=45;h=j;break;case 68:if((g>=48&&g<=57)||(g>=65&&g<=82)||(g>=84&&g<=90)||g==95||(g>=97&&g<=114)||(g>=116&&g<=122)){i=4}else{if(g==83||g==115){i=59}else{i=-1}}f=45;h=j;break;case 69:if((g>=48&&g<=57)||(g>=65&&g<=75)||(g>=77&&g<=90)||g==95||(g>=97&&g<=107)||(g>=109&&g<=122)){i=4}else{if(g==76||g==108){i=60}else{i=-1}}f=45;h=j;break;case 70:if((g>=48&&g<=57)||(g>=65&&g<=83)||(g>=85&&g<=90)||g==95||(g>=97&&g<=115)||(g>=117&&g<=122)){i=4}else{if(g==84||g==116){i=61}else{i=-1}}f=45;h=j;break;case 71:if((g>=48&&g<=57)||(g>=65&&g<=81)||(g>=83&&g<=90)||g==95||(g>=97&&g<=113)||(g>=115&&g<=122)){i=4}else{if(g==82||g==114){i=62}else{i=-1}}f=45;h=j;break;case 72:if((g>=48&&g<=57)||(g>=65&&g<=78)||(g>=80&&g<=90)||g==95||(g>=97&&g<=110)||(g>=112&&g<=122)){i=4}else{if(g==79||g==111){i=63}else{i=-1}}f=45;h=j;break;case 73:if((g>=48&&g<=57)||(g>=65&&g<=75)||(g>=77&&g<=90)||g==95||(g>=97&&g<=107)||(g>=109&&g<=122)){i=4}else{if(g==76||g==108){i=66}else{i=-1}}f=45;h=j;break;case 74:if((g>=48&&g<=57)||(g>=65&&g<=81)||(g>=83&&g<=90)||g==95||(g>=97&&g<=113)||(g>=115&&g<=122)){i=4}else{if(g==82||g==114){i=67}else{i=-1}}f=45;h=j;break;case 75:if((g>=48&&g<=57)||(g>=65&&g<=75)||(g>=77&&g<=90)||g==95||(g>=97&&g<=107)||(g>=109&&g<=122)){i=4}else{if(g==76||g==108){i=68}else{i=-1}}f=45;h=j;break;case 76:if((g>=48&&g<=57)||(g>=65&&g<=72)||(g>=74&&g<=90)||g==95||(g>=97&&g<=104)||(g>=106&&g<=122)){i=4}else{if(g==73||g==105){i=69}else{i=-1}}f=45;h=j;break;case 77:if((g>=48&&g<=57)||(g>=65&&g<=68)||(g>=70&&g<=90)||g==95||(g>=97&&g<=100)||(g>=102&&g<=122)){i=4}else{if(g==69||g==101){i=70}else{i=-1}}f=45;h=j;break;case 78:if((g>=48&&g<=57)||(g>=65&&g<=84)||(g>=86&&g<=90)||g==95||(g>=97&&g<=116)||(g>=118&&g<=122)){i=4}else{if(g==85||g==117){i=71}else{i=-1}}f=45;h=j;break;case 79:if((g>=48&&g<=57)||(g>=65&&g<=72)||(g>=74&&g<=90)||g==95||(g>=97&&g<=104)||(g>=106&&g<=122)){i=4}else{if(g==73||g==105){i=72}else{i=-1}}f=45;h=j;break;case 80:if((g>=48&&g<=57)||(g>=65&&g<=71)||(g>=73&&g<=90)||g==95||(g>=97&&g<=103)||(g>=105&&g<=122)){i=4}else{if(g==72||g==104){i=76}else{i=-1}}f=45;h=j;break;case 81:if((g>=48&&g<=57)||(g>=65&&g<=75)||(g>=77&&g<=90)||g==95||(g>=97&&g<=107)||(g>=109&&g<=122)){i=4}else{if(g==76||g==108){i=77}else{i=-1}}f=45;h=j;break;case 82:if((g>=48&&g<=57)||(g>=65&&g<=83)||(g>=85&&g<=90)||g==95||(g>=97&&g<=115)||(g>=117&&g<=122)){i=4}else{if(g==84||g==116){i=78}else{i=-1}}f=45;h=j;break;case 83:if((g>=48&&g<=57)||(g>=65&&g<=83)||(g>=85&&g<=90)||g==95||(g>=97&&g<=115)||(g>=117&&g<=122)){i=4}else{if(g==84||g==116){i=79}else{i=-1}}f=45;h=j;break;case 84:if((g>=48&&g<=57)||(g>=65&&g<=68)||(g>=70&&g<=90)||g==95||(g>=97&&g<=100)||(g>=102&&g<=122)){i=4}else{if(g==69||g==101){i=82}else{i=-1}}f=45;h=j;break;case 85:if((g>=48&&g<=57)||(g>=65&&g<=66)||(g>=68&&g<=90)||g==95||(g>=97&&g<=98)||(g>=100&&g<=122)){i=4}else{if(g==67||g==99){i=83}else{i=-1}}f=45;h=j;break;case 86:if((g>=48&&g<=57)||(g>=65&&g<=77)||(g>=79&&g<=90)||g==95||(g>=97&&g<=109)||(g>=111&&g<=122)){i=4}else{if(g==78||g==110){i=85}else{i=-1}}f=45;h=j;break}if(i>-1){if(g==10){e.line++;e.column=0;if(this.countLines){this.parCurLine=e.line;this.parCurColumn=e.column}}e.column++}j++}while(i>-1)}while(2>-1&&f==2);if(f>-1){e.att=e.src.substr(k,h-k);e.offset=h;if(f==46){e.att=e.att.substr(1,e.att.length-2);e.att=e.att.replace(/\\\'/g,"'")}}else{e.att=new String();f=-1}break}return f},_parse:function(e,k,h){var t=[],s=[],l=0,q,o,n,g={la:0,act:0,offset:0,src:e,att:"",line:1,column:1,error_step:0};var m=new Array(new Array(0,1),new Array(49,2),new Array(49,0),new Array(51,2),new Array(51,0),new Array(52,3),new Array(52,1),new Array(52,0),new Array(54,3),new Array(54,1),new Array(54,0),new Array(55,3),new Array(56,3),new Array(56,1),new Array(56,0),new Array(58,3),new Array(50,3),new Array(50,5),new Array(50,3),new Array(50,5),new Array(50,9),new Array(50,3),new Array(50,2),new Array(50,2),new Array(50,2),new Array(50,2),new Array(50,3),new Array(50,1),new Array(57,3),new Array(57,4),new Array(57,1),new Array(53,3),new Array(53,3),new Array(53,3),new Array(53,3),new Array(53,3),new Array(53,3),new Array(53,3),new Array(53,1),new Array(61,3),new Array(61,3),new Array(61,2),new Array(61,1),new Array(60,3),new Array(60,3),new Array(60,1),new Array(62,3),new Array(62,3),new Array(62,3),new Array(62,1),new Array(63,3),new Array(63,1),new Array(64,2),new Array(64,2),new Array(64,1),new Array(59,4),new Array(59,4),new Array(59,5),new Array(59,3),new Array(59,1),new Array(65,1),new Array(65,1),new Array(65,1),new Array(65,3),new Array(65,1),new Array(65,7),new Array(65,3),new Array(65,3),new Array(65,1),new Array(65,1));var j=new Array(new Array(),new Array(3,3,5,4,6,5,7,6,9,7,11,8,10,9,18,12,20,13,45,17,31,18,47,22,48,23,38,24,46,25,8,26,14,27,16,28,12,29,13,30,33,33,32,34),new Array(),new Array(31,18,33,33,32,34,47,22,48,23,45,37,38,24,46,25,8,26,14,27,16,28,12,29,13,30),new Array(31,18,33,33,32,34,47,22,48,23,45,37,38,24,46,25,8,26,14,27,16,28,12,29,13,30),new Array(3,3,5,4,6,5,7,6,9,7,11,8,10,9,18,12,20,13,45,17,31,18,47,22,48,23,38,24,46,25,8,26,14,27,16,28,12,29,13,30,33,33,32,34),new Array(38,40),new Array(45,41),new Array(45,42),new Array(3,3,5,4,6,5,7,6,9,7,11,8,10,9,18,12,20,13,45,17,31,18,47,22,48,23,38,24,46,25,8,26,14,27,16,28,12,29,13,30,33,33,32,34),new Array(20,44),new Array(24,45,23,46,26,47,25,48,27,49,28,50,22,51,20,52),new Array(),new Array(),new Array(21,54),new Array(30,55,29,56),new Array(44,57,38,58,16,59),new Array(21,-30),new Array(31,18,33,33,32,34,47,22,48,23,45,37,38,24,46,25,8,26,14,27,16,28,12,29,13,30),new Array(32,61,33,62),new Array(),new Array(35,63,34,64,36,65),new Array(),new Array(),new Array(31,18,33,33,32,34,47,22,48,23,45,37,38,24,46,25,8,26,14,27,16,28,12,29,13,30),new Array(),new Array(38,67),new Array(45,70),new Array(31,18,33,33,32,34,47,22,48,23,45,37,38,24,46,25,8,26,14,27,16,28,12,29,13,30),new Array(),new Array(),new Array(),new Array(37,73),new Array(47,22,48,23,45,37,38,24,46,25,8,26,14,27,16,28,12,29,13,30),new Array(47,22,48,23,45,37,38,24,46,25,8,26,14,27,16,28,12,29,13,30),new Array(24,45,23,46,26,47,25,48,27,49,28,50,22,51,3,3,5,4,6,5,7,6,9,7,11,8,10,9,18,12,20,13,45,17,31,18,47,22,48,23,38,24,46,25,8,26,14,27,16,28,12,29,13,30,33,33,32,34),new Array(44,77,38,58,16,78),new Array(),new Array(24,45,23,46,26,47,25,48,27,49,28,50,22,51,3,3,5,4,6,5,7,6,9,7,11,8,10,9,18,12,20,13,45,17,31,18,47,22,48,23,38,24,46,25,8,26,14,27,16,28,12,29,13,30,33,33,32,34),new Array(5,80),new Array(45,17,47,22,48,23,38,24,46,25,8,26,14,27,16,28,12,29,13,30),new Array(20,83),new Array(),new Array(),new Array(),new Array(31,18,33,33,32,34,47,22,48,23,45,37,38,24,46,25,8,26,14,27,16,28,12,29,13,30),new Array(31,18,33,33,32,34,47,22,48,23,45,37,38,24,46,25,8,26,14,27,16,28,12,29,13,30),new Array(31,18,33,33,32,34,47,22,48,23,45,37,38,24,46,25,8,26,14,27,16,28,12,29,13,30),new Array(31,18,33,33,32,34,47,22,48,23,45,37,38,24,46,25,8,26,14,27,16,28,12,29,13,30),new Array(31,18,33,33,32,34,47,22,48,23,45,37,38,24,46,25,8,26,14,27,16,28,12,29,13,30),new Array(31,18,33,33,32,34,47,22,48,23,45,37,38,24,46,25,8,26,14,27,16,28,12,29,13,30),new Array(31,18,33,33,32,34,47,22,48,23,45,37,38,24,46,25,8,26,14,27,16,28,12,29,13,30),new Array(),new Array(19,91,3,3,5,4,6,5,7,6,9,7,11,8,10,9,18,12,20,13,45,17,31,18,47,22,48,23,38,24,46,25,8,26,14,27,16,28,12,29,13,30,33,33,32,34),new Array(31,18,33,33,32,34,47,22,48,23,45,37,38,24,46,25,8,26,14,27,16,28,12,29,13,30),new Array(33,33,32,34,47,22,48,23,45,37,38,24,46,25,8,26,14,27,16,28,12,29,13,30),new Array(33,33,32,34,47,22,48,23,45,37,38,24,46,25,8,26,14,27,16,28,12,29,13,30),new Array(45,96),new Array(31,18,33,33,32,34,47,22,48,23,45,37,38,24,46,25,8,26,14,27,16,28,12,29,13,30),new Array(33,33,32,34,47,22,48,23,45,37,38,24,46,25,8,26,14,27,16,28,12,29,13,30),new Array(30,55,29,56),new Array(33,33,32,34,47,22,48,23,45,37,38,24,46,25,8,26,14,27,16,28,12,29,13,30),new Array(33,33,32,34,47,22,48,23,45,37,38,24,46,25,8,26,14,27,16,28,12,29,13,30),new Array(33,33,32,34,47,22,48,23,45,37,38,24,46,25,8,26,14,27,16,28,12,29,13,30),new Array(33,33,32,34,47,22,48,23,45,37,38,24,46,25,8,26,14,27,16,28,12,29,13,30),new Array(33,33,32,34,47,22,48,23,45,37,38,24,46,25,8,26,14,27,16,28,12,29,13,30),new Array(39,104,24,45,23,46,26,47,25,48,27,49,28,50,22,51),new Array(45,106),new Array(15,107,40,108),new Array(),new Array(42,109),new Array(17,110,40,111),new Array(24,45,23,46,26,47,25,48,27,49,28,50,22,51),new Array(33,33,32,34,47,22,48,23,45,37,38,24,46,25,8,26,14,27,16,28,12,29,13,30),new Array(44,77,38,58,16,78),new Array(44,77,38,58,16,78),new Array(4,113),new Array(45,114),new Array(33,33,32,34,47,22,48,23,45,37,38,24,46,25,8,26,14,27,16,28,12,29,13,30),new Array(),new Array(31,18,33,33,32,34,47,22,48,23,45,37,38,24,46,25,8,26,14,27,16,28,12,29,13,30),new Array(20,117),new Array(44,57,38,58,16,59),new Array(),new Array(30,55,29,56),new Array(30,55,29,56),new Array(30,55,29,56),new Array(30,55,29,56),new Array(30,55,29,56),new Array(30,55,29,56),new Array(30,55,29,56),new Array(),new Array(),new Array(24,45,23,46,26,47,25,48,27,49,28,50,22,51),new Array(32,61,33,62),new Array(32,61,33,62),new Array(21,-28),new Array(39,118,40,111),new Array(17,119,32,61,33,62),new Array(35,63,34,64,36,65),new Array(35,63,34,64,36,65),new Array(),new Array(),new Array(),new Array(),new Array(39,120,40,121),new Array(),new Array(),new Array(45,70),new Array(31,18,33,33,32,34,47,22,48,23,45,37,38,24,46,25,8,26,14,27,16,28,12,29,13,30),new Array(),new Array(31,18,33,33,32,34,47,22,48,23,45,37,38,24,46,25,8,26,14,27,16,28,12,29,13,30),new Array(),new Array(3,3,5,4,6,5,7,6,9,7,11,8,10,9,18,12,20,13,45,17,31,18,47,22,48,23,38,24,46,25,8,26,14,27,16,28,12,29,13,30,33,33,32,34),new Array(),new Array(17,126,32,61,33,62),new Array(24,45,23,46,26,47,25,48,27,49,28,50,22,51,20,127),new Array(31,18,33,33,32,34,47,22,48,23,45,37,38,24,46,25,8,26,14,27,16,28,12,29,13,30),new Array(47,22,48,23,45,37,38,24,46,25,8,26,14,27,16,28,12,29,13,30),new Array(21,-29),new Array(18,130),new Array(45,131),new Array(),new Array(24,45,23,46,26,47,25,48,27,49,28,50,22,51),new Array(24,45,23,46,26,47,25,48,27,49,28,50,22,51),new Array(),new Array(),new Array(),new Array(24,45,23,46,26,47,25,48,27,49,28,50,22,51,20,132),new Array(44,77,38,58,16,78),new Array(),new Array(),new Array(45,17,47,22,48,23,38,24,46,25,8,26,14,27,16,28,12,29,13,30),new Array(19,135,3,3,5,4,6,5,7,6,9,7,11,8,10,9,18,12,20,13,45,17,31,18,47,22,48,23,38,24,46,25,8,26,14,27,16,28,12,29,13,30,33,33,32,34),new Array(39,136),new Array(),new Array(3,3,5,4,6,5,7,6,9,7,11,8,10,9,18,12,20,13,45,17,31,18,47,22,48,23,38,24,46,25,8,26,14,27,16,28,12,29,13,30,33,33,32,34),new Array());var f=new Array(new Array(49,1),new Array(50,2,58,10,53,11,57,14,61,15,59,16,60,19,65,20,62,21,63,31,64,32),new Array(),new Array(53,35,61,15,60,19,62,21,63,31,64,32,59,36,65,20),new Array(53,38,61,15,60,19,62,21,63,31,64,32,59,36,65,20),new Array(50,39,58,10,53,11,57,14,61,15,59,16,60,19,65,20,62,21,63,31,64,32),new Array(),new Array(),new Array(),new Array(50,43,58,10,53,11,57,14,61,15,59,16,60,19,65,20,62,21,63,31,64,32),new Array(),new Array(),new Array(51,53),new Array(),new Array(),new Array(),new Array(),new Array(),new Array(61,60,60,19,62,21,63,31,64,32,59,36,65,20),new Array(),new Array(),new Array(),new Array(),new Array(),new Array(53,66,61,15,60,19,62,21,63,31,64,32,59,36,65,20),new Array(),new Array(),new Array(54,68,55,69),new Array(52,71,53,72,61,15,60,19,62,21,63,31,64,32,59,36,65,20),new Array(),new Array(),new Array(),new Array(),new Array(59,74,65,20),new Array(59,75,65,20),new Array(50,76,58,10,53,11,57,14,61,15,59,16,60,19,65,20,62,21,63,31,64,32),new Array(),new Array(),new Array(50,79,58,10,53,11,57,14,61,15,59,16,60,19,65,20,62,21,63,31,64,32),new Array(),new Array(58,81,57,14,59,82,65,20),new Array(),new Array(),new Array(),new Array(),new Array(61,84,60,19,62,21,63,31,64,32,59,36,65,20),new Array(61,85,60,19,62,21,63,31,64,32,59,36,65,20),new Array(61,86,60,19,62,21,63,31,64,32,59,36,65,20),new Array(61,87,60,19,62,21,63,31,64,32,59,36,65,20),new Array(61,88,60,19,62,21,63,31,64,32,59,36,65,20),new Array(61,89,60,19,62,21,63,31,64,32,59,36,65,20),new Array(61,90,60,19,62,21,63,31,64,32,59,36,65,20),new Array(),new Array(50,92,58,10,53,11,57,14,61,15,59,16,60,19,65,20,62,21,63,31,64,32),new Array(53,93,61,15,60,19,62,21,63,31,64,32,59,36,65,20),new Array(60,94,62,21,63,31,64,32,59,36,65,20),new Array(60,95,62,21,63,31,64,32,59,36,65,20),new Array(),new Array(52,97,53,72,61,15,60,19,62,21,63,31,64,32,59,36,65,20),new Array(60,98,62,21,63,31,64,32,59,36,65,20),new Array(),new Array(62,99,63,31,64,32,59,36,65,20),new Array(62,100,63,31,64,32,59,36,65,20),new Array(63,101,64,32,59,36,65,20),new Array(63,102,64,32,59,36,65,20),new Array(63,103,64,32,59,36,65,20),new Array(),new Array(56,105),new Array(),new Array(),new Array(),new Array(),new Array(),new Array(63,112,64,32,59,36,65,20),new Array(),new Array(),new Array(),new Array(),new Array(60,115,62,21,63,31,64,32,59,36,65,20),new Array(),new Array(53,116,61,15,60,19,62,21,63,31,64,32,59,36,65,20),new Array(),new Array(),new Array(),new Array(),new Array(),new Array(),new Array(),new Array(),new Array(),new Array(),new Array(),new Array(),new Array(),new Array(),new Array(),new Array(),new Array(),new Array(),new Array(),new Array(),new Array(),new Array(),new Array(),new Array(),new Array(),new Array(),new Array(),new Array(55,122),new Array(53,123,61,15,60,19,62,21,63,31,64,32,59,36,65,20),new Array(),new Array(53,124,61,15,60,19,62,21,63,31,64,32,59,36,65,20),new Array(),new Array(50,125,58,10,53,11,57,14,61,15,59,16,60,19,65,20,62,21,63,31,64,32),new Array(),new Array(),new Array(),new Array(53,128,61,15,60,19,62,21,63,31,64,32,59,36,65,20),new Array(59,129,65,20),new Array(),new Array(),new Array(),new Array(),new Array(),new Array(),new Array(),new Array(),new Array(),new Array(),new Array(),new Array(51,133),new Array(),new Array(58,134,57,14,59,82,65,20),new Array(50,92,58,10,53,11,57,14,61,15,59,16,60,19,65,20,62,21,63,31,64,32),new Array(),new Array(),new Array(50,137,58,10,53,11,57,14,61,15,59,16,60,19,65,20,62,21,63,31,64,32),new Array());var r=new Array(2,0,1,-1,-1,-1,-1,-1,-1,-1,-1,-1,4,27,-1,38,54,62,-1,42,59,45,60,61,-1,64,-1,10,7,68,69,49,51,-1,-1,-1,54,62,-1,-1,-1,-1,22,23,24,-1,-1,-1,-1,-1,-1,-1,25,-1,-1,-1,-1,-1,7,-1,41,-1,-1,-1,-1,-1,-1,14,-1,9,-1,-1,6,-1,52,53,16,-1,-1,18,-1,-1,-1,21,37,36,35,34,33,32,31,26,3,15,40,39,58,-1,-1,44,43,48,47,46,63,-1,13,66,-1,-1,67,-1,50,-1,58,-1,-1,-1,56,55,-1,-1,8,11,5,17,55,19,-1,57,4,12,-1,-1,-1,65,-1,20);var p=new Array("Program'","ERROR_RESYNC","WHITESPACE","IF","ELSE","WHILE","DO","FOR","FUNCTION","USE","RETURN","DELETE","TRUE","FALSE","<<",">>","[","]","{","}",";","=","==","!=","~=","<=",">=",">","<","||","&&","!","+","-","/","%","*","^","(",")",",","#",":","|",".","Identifier","String","Integer","Float","Program","Stmt","Stmt_List","Param_List","Expression","Prop_List","Prop","Param_Def_List","Lhs","Assign","ExtValue","AddSubExp","LogExp","MulDivExp","ExpExp","NegExp","Value","$");if(!k){k=[]}if(!h){h=[]}t.push(0);s.push(0);g.la=this._lex(g);while(true){g.act=139;for(n=0;n<j[t[t.length-1]].length;n+=2){if(j[t[t.length-1]][n]==g.la){g.act=j[t[t.length-1]][n+1];break}}if(g.act==139){if((g.act=r[t[t.length-1]])<0){g.act=139}else{g.act*=-1}}if(g.act==139){if(g.error_step==0){l++;k.push({offset:g.offset-g.att.length,line:g.line});h.push([]);for(n=0;n<j[t[t.length-1]].length;n+=2){h[h.length-1].push(p[j[t[t.length-1]][n]])}}while(t.length>1&&g.act==139){t.pop();s.pop();for(n=0;n<j[t[t.length-1]].length;n+=2){if(j[t[t.length-1]][n]==1){g.act=j[t[t.length-1]][n+1];t.push(g.act);s.push("");break}}}if(t.length>1&&g.act!=139){while(g.la!=66){g.act=139;for(n=0;n<j[t[t.length-1]].length;n+=2){if(j[t[t.length-1]][n]==g.la){g.act=j[t[t.length-1]][n+1];break}}if(g.act!=139){break}while((g.la=this._lex(g))<0){g.offset++}}while(g.la!=66&&g.act==139){}}if(g.act==139||g.la==66){break}g.error_step=3}if(g.act>0){t.push(g.act);s.push(g.att);g.la=this._lex(g);if(g.error_step>0){g.error_step--}}else{q=g.act*-1;o=void (0);switch(q){case 0:o=s[s.length-1];break;case 1:this.execute(s[s.length-1]);break;case 2:o=s[s.length-0];break;case 3:o=this.createNode("node_op","op_none",s[s.length-2],s[s.length-1]);break;case 4:o=s[s.length-0];break;case 5:o=this.createNode("node_op","op_param",s[s.length-1],s[s.length-3]);break;case 6:o=this.createNode("node_op","op_param",s[s.length-1]);break;case 7:o=s[s.length-0];break;case 8:o=this.createNode("node_op","op_proplst",s[s.length-3],s[s.length-1]);break;case 9:o=s[s.length-1];break;case 10:o=s[s.length-0];break;case 11:o=this.createNode("node_op","op_prop",s[s.length-3],s[s.length-1]);break;case 12:o=this.createNode("node_op","op_paramdef",s[s.length-1],s[s.length-3]);break;case 13:o=this.createNode("node_op","op_paramdef",s[s.length-1]);break;case 14:o=s[s.length-0];break;case 15:o=this.createNode("node_op","op_assign",s[s.length-3],s[s.length-1]);break;case 16:o=this.createNode("node_op","op_if",s[s.length-2],s[s.length-1]);break;case 17:o=this.createNode("node_op","op_if_else",s[s.length-4],s[s.length-3],s[s.length-1]);break;case 18:o=this.createNode("node_op","op_while",s[s.length-2],s[s.length-1]);break;case 19:o=this.createNode("node_op","op_do",s[s.length-4],s[s.length-2]);break;case 20:o=this.createNode("node_op","op_for",s[s.length-7],s[s.length-5],s[s.length-3],s[s.length-1]);break;case 21:o=this.createNode("node_op","op_use",s[s.length-2]);break;case 22:o=this.createNode("node_op","op_delete",s[s.length-1]);break;case 23:o=this.createNode("node_op","op_return",s[s.length-1]);break;case 24:o=s[s.length-2];break;case 25:o=this.createNode("node_op","op_noassign",s[s.length-2]);break;case 26:o=s[s.length-2];o.needsBrackets=true;break;case 27:o=this.createNode("node_op","op_none");break;case 28:o=this.createNode("node_op","op_lhs",s[s.length-1],s[s.length-3],"dot");break;case 29:o=this.createNode("node_op","op_lhs",s[s.length-2],s[s.length-4],"bracket");break;case 30:o=this.createNode("node_op","op_lhs",s[s.length-1]);break;case 31:o=this.createNode("node_op","op_equ",s[s.length-3],s[s.length-1]);break;case 32:o=this.createNode("node_op","op_lot",s[s.length-3],s[s.length-1]);break;case 33:o=this.createNode("node_op","op_grt",s[s.length-3],s[s.length-1]);break;case 34:o=this.createNode("node_op","op_loe",s[s.length-3],s[s.length-1]);break;case 35:o=this.createNode("node_op","op_gre",s[s.length-3],s[s.length-1]);break;case 36:o=this.createNode("node_op","op_neq",s[s.length-3],s[s.length-1]);break;case 37:o=this.createNode("node_op","op_approx",s[s.length-3],s[s.length-1]);break;case 38:o=s[s.length-1];break;case 39:o=this.createNode("node_op","op_or",s[s.length-3],s[s.length-1]);break;case 40:o=this.createNode("node_op","op_and",s[s.length-3],s[s.length-1]);break;case 41:o=this.createNode("node_op","op_not",s[s.length-1]);break;case 42:o=s[s.length-1];break;case 43:o=this.createNode("node_op","op_sub",s[s.length-3],s[s.length-1]);break;case 44:o=this.createNode("node_op","op_add",s[s.length-3],s[s.length-1]);break;case 45:o=s[s.length-1];break;case 46:o=this.createNode("node_op","op_mul",s[s.length-3],s[s.length-1]);break;case 47:o=this.createNode("node_op","op_div",s[s.length-3],s[s.length-1]);break;case 48:o=this.createNode("node_op","op_mod",s[s.length-3],s[s.length-1]);break;case 49:o=s[s.length-1];break;case 50:o=this.createNode("node_op","op_exp",s[s.length-3],s[s.length-1]);break;case 51:o=s[s.length-1];break;case 52:o=this.createNode("node_op","op_neg",s[s.length-1]);break;case 53:o=s[s.length-1];break;case 54:o=s[s.length-1];break;case 55:o=this.createNode("node_op","op_extvalue",s[s.length-4],s[s.length-2]);break;case 56:o=this.createNode("node_op","op_execfun",s[s.length-4],s[s.length-2]);break;case 57:o=this.createNode("node_op","op_execfun",s[s.length-5],s[s.length-3],s[s.length-1]);break;case 58:o=this.createNode("node_op","op_property",s[s.length-3],s[s.length-1]);break;case 59:o=s[s.length-1];break;case 60:o=this.createNode("node_const",s[s.length-1]);break;case 61:o=this.createNode("node_const",s[s.length-1]);break;case 62:o=this.createNode("node_var",s[s.length-1]);break;case 63:o=s[s.length-2];break;case 64:o=this.createNode("node_str",s[s.length-1]);break;case 65:o=this.createNode("node_op","op_function",s[s.length-5],s[s.length-2]);break;case 66:o=this.createNode("node_op","op_proplst_val",s[s.length-2]);break;case 67:o=this.createNode("node_op","op_array",s[s.length-2]);break;case 68:o=this.createNode("node_const_bool",s[s.length-1]);break;case 69:o=this.createNode("node_const_bool",s[s.length-1]);break}for(n=0;n<m[q][1];n++){t.pop();s.pop()}g.act=139;for(n=0;n<f[t[t.length-1]].length;n+=2){if(f[t[t.length-1]][n]==m[q][0]){g.act=f[t[t.length-1]][n+1];break}}if(q==0){break}t.push(g.act);s.push(o)}}return l}});JXG.Dump={addMarkers:function(j,m,g){var k,f,h;if(!JXG.isArray(m)){m=[m]}if(!JXG.isArray(g)){g=[g]}f=Math.min(m.length,g.length);m.length=f;g.length=f;for(k in j.objects){for(h=0;h<f;h++){j.objects[k][m[h]]=g[h]}}},deleteMarkers:function(h,k){var j,f,g;if(!JXG.isArray(k)){k=[k]}f=k.length;k.length=f;for(j in h.objects){for(g=0;g<f;g++){delete h.objects[j][k[g]]}}},str:function(e){if(typeof e==="string"&&e.substr(0,7)!=="function"){e="'"+e+"'"}return e},minimizeObject:function(e){var j,g,k=JXG.deepCopy(e),h=[],f;for(f=1;f<arguments.length;f++){h.push(arguments[f])}for(f=0;f<h.length;f++){for(j in h[f]){g=j.toLowerCase();if(typeof h[f][j]!=="object"&&h[f][j]==k[g]){delete k[g]}}}return k},prepareAttributes:function(g,h){var e,f;e=this.minimizeObject(h.getAttributes(),g.options[h.elType],g.options.elements);for(f in h.subs){e[f]=this.minimizeObject(h.subs[f].getAttributes(),g.options[h.elType][f],g.options[h.subs[f].elType],g.options.elements);e[f].id=h.subs[f].id;e[f].name=h.subs[f].name}e.id=h.id;e.name=h.name;return e},dump:function(k){var m,l,h,j,g=[],f;this.addMarkers(k,"dumped",false);for(m in k.objects){l=k.objects[m];h={};if(!l.dumped&&l.dump){h.type=l.getType();h.parents=l.getParents();if(h.type==="point"&&h.parents[0]==1){h.parents=h.parents.slice(1)}for(j=0;j<h.parents.length;j++){if(typeof h.parents[j]==="string"){h.parents[j]="'"+h.parents[j]+"'"}}h.attributes=this.prepareAttributes(k,l);g.push(h)}}this.deleteMarkers(k,"dumped");return g},toJSAN:function(h){var f,e;switch(typeof h){case"object":if(h){var g=[];if(h instanceof Array){for(e=0;e<h.length;e++){g.push(this.toJSAN(h[e]))}return"["+g.join(",")+"]"}else{for(var j in h){g.push(j+": "+this.toJSAN(h[j]))}return"<<"+g.join(", ")+">> "}}else{return"null"}case"string":return"'"+h.replace(/(["'])/g,"\\$1")+"'";case"number":case"boolean":return new String(h);case"null":return"null"}},toJessie:function(g){var h=this.dump(g),e=[],f;for(f=0;f<h.length;f++){if(h[f].attributes.name.length>0){e.push("// "+h[f].attributes.name)}e.push("s"+f+" = "+h[f].type+"("+h[f].parents.join(", ")+") "+this.toJSAN(h[f].attributes).replace(/\n/,"\\n")+";");e.push("")}return e.join("\n")},toJavaScript:function(g){var h=this.dump(g),e=[],f;for(f=0;f<h.length;f++){e.push('board.create("'+h[f].type+'", ['+h[f].parents.join(", ")+"], "+JXG.toJSON(h[f].attributes)+");")}return e.join("\n")}};JXG.SVGRenderer=function(e){var f;this.type="svg";this.svgRoot=null;this.svgNamespace="http://www.w3.org/2000/svg";this.xlinkNamespace="http://www.w3.org/1999/xlink";this.container=e;this.container.style.MozUserSelect="none";this.container.style.overflow="hidden";if(this.container.style.position===""){this.container.style.position="relative"}this.svgRoot=this.container.ownerDocument.createElementNS(this.svgNamespace,"svg");this.svgRoot.style.overflow="hidden";this.svgRoot.style.width=JXG.getStyle(this.container,"width");this.svgRoot.style.height=JXG.getStyle(this.container,"height");this.container.appendChild(this.svgRoot);this.defs=this.container.ownerDocument.createElementNS(this.svgNamespace,"defs");this.svgRoot.appendChild(this.defs);this.filter=this.container.ownerDocument.createElementNS(this.svgNamespace,"filter");this.filter.setAttributeNS(null,"id",this.container.id+"_f1");this.filter.setAttributeNS(null,"width","300%");this.filter.setAttributeNS(null,"height","300%");this.filter.setAttributeNS(null,"filterUnits","userSpaceOnUse");this.feOffset=this.container.ownerDocument.createElementNS(this.svgNamespace,"feOffset");this.feOffset.setAttributeNS(null,"result","offOut");this.feOffset.setAttributeNS(null,"in","SourceAlpha");this.feOffset.setAttributeNS(null,"dx","5");this.feOffset.setAttributeNS(null,"dy","5");this.filter.appendChild(this.feOffset);this.feGaussianBlur=this.container.ownerDocument.createElementNS(this.svgNamespace,"feGaussianBlur");this.feGaussianBlur.setAttributeNS(null,"result","blurOut");this.feGaussianBlur.setAttributeNS(null,"in","offOut");this.feGaussianBlur.setAttributeNS(null,"stdDeviation","3");this.filter.appendChild(this.feGaussianBlur);this.feBlend=this.container.ownerDocument.createElementNS(this.svgNamespace,"feBlend");this.feBlend.setAttributeNS(null,"in","SourceGraphic");this.feBlend.setAttributeNS(null,"in2","blurOut");this.feBlend.setAttributeNS(null,"mode","normal");this.filter.appendChild(this.feBlend);this.defs.appendChild(this.filter);this.layer=[];for(f=0;f<JXG.Options.layer.numlayers;f++){this.layer[f]=this.container.ownerDocument.createElementNS(this.svgNamespace,"g");this.svgRoot.appendChild(this.layer[f])}this.dashArray=["2, 2","5, 5","10, 10","20, 20","20, 10, 10, 10","20, 5, 10, 5"]};JXG.SVGRenderer.prototype=new JXG.AbstractRenderer();JXG.extend(JXG.SVGRenderer.prototype,{_createArrowHead:function(g,i){var h=g.id+"Triangle",f,e;if(JXG.exists(i)){h+=i}f=this.createPrim("marker",h);f.setAttributeNS(null,"viewBox","0 0 10 6");f.setAttributeNS(null,"refY","3");f.setAttributeNS(null,"markerUnits","userSpaceOnUse");f.setAttributeNS(null,"markerHeight","12");f.setAttributeNS(null,"markerWidth","10");f.setAttributeNS(null,"orient","auto");f.setAttributeNS(null,"stroke",g.visProp.strokecolor);f.setAttributeNS(null,"stroke-opacity",g.visProp.strokeopacity);f.setAttributeNS(null,"fill",g.visProp.strokecolor);f.setAttributeNS(null,"fill-opacity",g.visProp.strokeopacity);e=this.container.ownerDocument.createElementNS(this.svgNamespace,"path");if(i==="End"){f.setAttributeNS(null,"refX","0");e.setAttributeNS(null,"d","M 0 3 L 10 6 L 10 0 z")}else{f.setAttributeNS(null,"refX","10");e.setAttributeNS(null,"d","M 0 0 L 10 3 L 0 6 z")}f.appendChild(e);return f},_setArrowAtts:function(g,e,f){if(g){g.setAttributeNS(null,"stroke",e);g.setAttributeNS(null,"stroke-opacity",f);g.setAttributeNS(null,"fill",e);g.setAttributeNS(null,"fill-opacity",f)}},updateTicks:function(j,l,f,o,g,e,k){var m="",n,q,h,s,r,p=j.ticks.length;for(n=0;n<p;n++){q=j.ticks[n];s=q[0];r=q[1];if(typeof s[0]!="undefined"&&typeof s[1]!="undefined"){m+="M "+(s[0])+" "+(r[0])+" L "+(s[1])+" "+(r[1])+" "}}for(n=0;n<p;n++){q=j.ticks[n].scrCoords;if(j.ticks[n].major&&(j.board.needsFullUpdate||j.needsRegularUpdate)&&j.labels[n]&&j.labels[n].visProp.visible){this.updateText(j.labels[n])}}h=this.getElementById(j.id);if(!JXG.exists(h)){h=this.createPrim("path",j.id);this.appendChildPrim(h,j.visProp.layer);this.appendNodesToElement(j,"path")}h.setAttributeNS(null,"stroke",j.visProp.strokecolor);h.setAttributeNS(null,"stroke-opacity",j.visProp.strokeopacity);h.setAttributeNS(null,"stroke-width",j.visProp.strokewidth);this.updatePathPrim(h,m,j.board)},displayCopyright:function(g,h){var f=this.createPrim("text","licenseText"),e;f.setAttributeNS(null,"x","20px");f.setAttributeNS(null,"y",(2+h)+"px");f.setAttributeNS(null,"style","font-family:Arial,Helvetica,sans-serif; font-size:"+h+"px; fill:#356AA0;  opacity:0.3;");e=document.createTextNode(g);f.appendChild(e);this.appendChildPrim(f,0)},drawInternalText:function(e){var f=this.createPrim("text",e.id);f.setAttributeNS(null,"class",e.visProp.cssclass);e.rendNodeText=document.createTextNode("");f.appendChild(e.rendNodeText);this.appendChildPrim(f,e.visProp.layer);return f},updateInternalText:function(e){var f=e.plaintext;if(!isNaN(e.coords.scrCoords[1]+e.coords.scrCoords[2])){e.rendNode.setAttributeNS(null,"x",e.coords.scrCoords[1]+"px");e.rendNode.setAttributeNS(null,"y",(e.coords.scrCoords[2]+this.vOffsetText*0.5)+"px")}if(e.htmlStr!==f){e.rendNodeText.data=f;e.htmlStr=f}this.transformImage(e,e.transformations)},drawImage:function(e){var f=this.createPrim("image",e.id);f.setAttributeNS(null,"preserveAspectRatio","none");this.appendChildPrim(f,e.visProp.layer);e.rendNode=f;this.updateImage(e)},transformImage:function(i,g){var j=i.rendNode,f,k="",h,e=g.length;if(e>0){f=this.joinTransforms(i,g);h=[f[1][1],f[2][1],f[1][2],f[2][2],f[1][0],f[2][0]].join(",");k+=" matrix("+h+") ";j.setAttributeNS(null,"transform",k)}},updateImageURL:function(f){var e=JXG.evaluate(f.url);f.rendNode.setAttributeNS(this.xlinkNamespace,"xlink:href",e)},appendChildPrim:function(e,f){if(!JXG.exists(f)){f=0}else{if(f>=JXG.Options.layer.numlayers){f=JXG.Options.layer.numlayers-1}}this.layer[f].appendChild(e)},appendNodesToElement:function(e){e.rendNode=this.getElementById(e.id)},createPrim:function(e,g){var f=this.container.ownerDocument.createElementNS(this.svgNamespace,e);f.setAttributeNS(null,"id",this.container.id+"_"+g);f.style.position="absolute";if(e==="path"){f.setAttributeNS(null,"stroke-linecap","butt");f.setAttributeNS(null,"stroke-linejoin","round")}return f},remove:function(e){if(JXG.exists(e)&&JXG.exists(e.parentNode)){e.parentNode.removeChild(e)}},makeArrows:function(f){var e;if(f.visPropOld.firstarrow===f.visProp.firstarrow&&f.visPropOld.lastarrow===f.visProp.lastarrow){return}if(f.visProp.firstarrow){e=f.rendNodeTriangleStart;if(!JXG.exists(e)){e=this._createArrowHead(f,"End");this.defs.appendChild(e);f.rendNodeTriangleStart=e;f.rendNode.setAttributeNS(null,"marker-start","url(#"+this.container.id+"_"+f.id+"TriangleEnd)")}}else{e=f.rendNodeTriangleStart;if(JXG.exists(e)){this.remove(e)}}if(f.visProp.lastarrow){e=f.rendNodeTriangleEnd;if(!JXG.exists(e)){e=this._createArrowHead(f,"Start");this.defs.appendChild(e);f.rendNodeTriangleEnd=e;f.rendNode.setAttributeNS(null,"marker-end","url(#"+this.container.id+"_"+f.id+"TriangleStart)")}}else{e=f.rendNodeTriangleEnd;if(JXG.exists(e)){this.remove(e)}}f.visPropOld.firstarrow=f.visProp.firstarrow;f.visPropOld.lastarrow=f.visProp.lastarrow},updateEllipsePrim:function(f,e,i,h,g){f.setAttributeNS(null,"cx",e);f.setAttributeNS(null,"cy",i);f.setAttributeNS(null,"rx",Math.abs(h));f.setAttributeNS(null,"ry",Math.abs(g))},updateLinePrim:function(i,f,e,h,g){if(!isNaN(f+e+h+g)){i.setAttributeNS(null,"x1",f);i.setAttributeNS(null,"y1",e);i.setAttributeNS(null,"x2",h);i.setAttributeNS(null,"y2",g)}},updatePathPrim:function(e,f){if(f==""){f="M 0 0"}e.setAttributeNS(null,"d",f)},updatePathStringPoint:function(i,f,h){var g="",k=i.coords.scrCoords,j=f*Math.sqrt(3)*0.5,e=f*0.5;if(h==="x"){g=" M "+(k[1]-f)+" "+(k[2]-f)+" L "+(k[1]+f)+" "+(k[2]+f)+" M "+(k[1]+f)+" "+(k[2]-f)+" L "+(k[1]-f)+" "+(k[2]+f)}else{if(h==="+"){g=" M "+(k[1]-f)+" "+(k[2])+" L "+(k[1]+f)+" "+(k[2])+" M "+(k[1])+" "+(k[2]-f)+" L "+(k[1])+" "+(k[2]+f)}else{if(h==="<>"){g=" M "+(k[1]-f)+" "+(k[2])+" L "+(k[1])+" "+(k[2]+f)+" L "+(k[1]+f)+" "+(k[2])+" L "+(k[1])+" "+(k[2]-f)+" Z "}else{if(h==="^"){g=" M "+(k[1])+" "+(k[2]-f)+" L "+(k[1]-j)+" "+(k[2]+e)+" L "+(k[1]+j)+" "+(k[2]+e)+" Z "}else{if(h==="v"){g=" M "+(k[1])+" "+(k[2]+f)+" L "+(k[1]-j)+" "+(k[2]-e)+" L "+(k[1]+j)+" "+(k[2]-e)+" Z "}else{if(h===">"){g=" M "+(k[1]+f)+" "+(k[2])+" L "+(k[1]-e)+" "+(k[2]-j)+" L "+(k[1]-e)+" "+(k[2]+j)+" Z "}else{if(h==="<"){g=" M "+(k[1]-f)+" "+(k[2])+" L "+(k[1]+e)+" "+(k[2]-j)+" L "+(k[1]+e)+" "+(k[2]+j)+" Z "}}}}}}}return g},updatePathStringPrim:function(e){var g=" M ",h=" L ",f=g,n=5000,k="",j,m,o=(e.visProp.curvetype!=="plot"),l;if(e.numberPoints<=0){return""}if(o&&e.board.options.curve.RDPsmoothing){e.points=JXG.Math.Numerics.RamerDouglasPeuker(e.points,0.5)}l=Math.min(e.points.length,e.numberPoints);for(j=0;j<l;j++){m=e.points[j].scrCoords;if(isNaN(m[1])||isNaN(m[2])){f=g}else{if(m[1]>n){m[1]=n}else{if(m[1]<-n){m[1]=-n}}if(m[2]>n){m[2]=n}else{if(m[2]<-n){m[2]=-n}}k+=[f,m[1]," ",m[2]].join("");f=h}}return k},updatePathStringBezierPrim:function(g){var l=" M ",m=" C ",k=l,u=5000,p="",o,n,s,h,e,r=g.visProp.strokewidth,t=(g.visProp.curvetype!=="plot"),q;if(g.numberPoints<=0){return""}if(t&&g.board.options.curve.RDPsmoothing){g.points=JXG.Math.Numerics.RamerDouglasPeuker(g.points,0.5)}q=Math.min(g.points.length,g.numberPoints);for(n=1;n<3;n++){k=l;for(o=0;o<q;o++){s=g.points[o].scrCoords;if(isNaN(s[1])||isNaN(s[2])){k=l}else{if(s[1]>u){s[1]=u}else{if(s[1]<-u){s[1]=-u}}if(s[2]>u){s[2]=u}else{if(s[2]<-u){s[2]=-u}}if(k==l){p+=[k,s[1]+0*r*(2*n*Math.random()-n)," ",s[2]+0*r*(2*n*Math.random()-n)].join("")}else{p+=[k,(h+(s[1]-h)*0.333+r*(2*n*Math.random()-n))," ",(e+(s[2]-e)*0.333+r*(2*n*Math.random()-n))," ",(h+2*(s[1]-h)*0.333+r*(2*n*Math.random()-n))," ",(e+2*(s[2]-e)*0.333+r*(2*n*Math.random()-n))," ",s[1]," ",s[2]].join("")}k=m;h=s[1];e=s[2]}}}return p},updatePolygonPrim:function(j,h){var k="",f,g,e=h.vertices.length;j.setAttributeNS(null,"stroke","none");for(g=0;g<e-1;g++){if(h.vertices[g].isReal){f=h.vertices[g].coords.scrCoords;k=k+f[1]+","+f[2]}else{j.setAttributeNS(null,"points","");return}if(g<e-2){k+=" "}}if(k.indexOf("NaN")==-1){j.setAttributeNS(null,"points",k)}},updateRectPrim:function(i,e,j,f,g){i.setAttributeNS(null,"x",e);i.setAttributeNS(null,"y",j);i.setAttributeNS(null,"width",f);i.setAttributeNS(null,"height",g)},setPropertyPrim:function(f,e,g){if(e==="stroked"){return}f.setAttributeNS(null,e,g)},show:function(e){var f;if(e&&e.rendNode){f=e.rendNode;f.setAttributeNS(null,"display","inline");f.style.visibility="inherit"}},hide:function(e){var f;if(e&&e.rendNode){f=e.rendNode;f.setAttributeNS(null,"display","none");f.style.visibility="hidden"}},setBuffering:function(f,e){f.rendNode.setAttribute("buffered-rendering",e)},setDashStyle:function(e){var g=e.visProp.dash,f=e.rendNode;if(e.visProp.dash>0){f.setAttributeNS(null,"stroke-dasharray",this.dashArray[g-1])}else{if(f.hasAttributeNS(null,"stroke-dasharray")){f.removeAttributeNS(null,"stroke-dasharray")}}},setGradient:function(g){var o=g.rendNode,h,j,i,n,m,f,e,l,k;j=JXG.evaluate(g.visProp.fillopacity);j=(j>0)?j:0;h=JXG.evaluate(g.visProp.fillcolor);if(g.visProp.gradient==="linear"){i=this.createPrim("linearGradient",g.id+"_gradient");f="0%";e="100%";l="0%";k="0%";i.setAttributeNS(null,"x1",f);i.setAttributeNS(null,"x2",e);i.setAttributeNS(null,"y1",l);i.setAttributeNS(null,"y2",k);n=this.createPrim("stop",g.id+"_gradient1");n.setAttributeNS(null,"offset","0%");n.setAttributeNS(null,"style","stop-color:"+h+";stop-opacity:"+j);m=this.createPrim("stop",g.id+"_gradient2");m.setAttributeNS(null,"offset","100%");m.setAttributeNS(null,"style","stop-color:"+g.visProp.gradientsecondcolor+";stop-opacity:"+g.visProp.gradientsecondopacity);i.appendChild(n);i.appendChild(m);this.defs.appendChild(i);o.setAttributeNS(null,"style","fill:url(#"+this.container.id+"_"+g.id+"_gradient)");g.gradNode1=n;g.gradNode2=m}else{if(g.visProp.gradient==="radial"){i=this.createPrim("radialGradient",g.id+"_gradient");i.setAttributeNS(null,"cx","50%");i.setAttributeNS(null,"cy","50%");i.setAttributeNS(null,"r","50%");i.setAttributeNS(null,"fx",g.visProp.gradientpositionx*100+"%");i.setAttributeNS(null,"fy",g.visProp.gradientpositiony*100+"%");n=this.createPrim("stop",g.id+"_gradient1");n.setAttributeNS(null,"offset","0%");n.setAttributeNS(null,"style","stop-color:"+g.visProp.gradientsecondcolor+";stop-opacity:"+g.visProp.gradientsecondopacity);m=this.createPrim("stop",g.id+"_gradient2");m.setAttributeNS(null,"offset","100%");m.setAttributeNS(null,"style","stop-color:"+h+";stop-opacity:"+j);i.appendChild(n);i.appendChild(m);this.defs.appendChild(i);o.setAttributeNS(null,"style","fill:url(#"+this.container.id+"_"+g.id+"_gradient)");g.gradNode1=n;g.gradNode2=m}else{o.removeAttributeNS(null,"style")}}},updateGradient:function(h){var f=h.gradNode1,e=h.gradNode2,g,i;if(!JXG.exists(f)||!JXG.exists(e)){return}i=JXG.evaluate(h.visProp.fillopacity);i=(i>0)?i:0;g=JXG.evaluate(h.visProp.fillcolor);if(h.visProp.gradient==="linear"){f.setAttributeNS(null,"style","stop-color:"+g+";stop-opacity:"+i);e.setAttributeNS(null,"style","stop-color:"+h.visProp.gradientsecondcolor+";stop-opacity:"+h.visProp.gradientsecondopacity)}else{if(h.visProp.gradient==="radial"){f.setAttributeNS(null,"style","stop-color:"+h.visProp.gradientsecondcolor+";stop-opacity:"+h.visProp.gradientsecondopacity);e.setAttributeNS(null,"style","stop-color:"+g+";stop-opacity:"+i)}}},setObjectFillColor:function(f,i,k){var g,h=JXG.evaluate(i),l,m,e=JXG.evaluate(k),j;e=(e>0)?e:0;if(f.visPropOld.fillcolor===h&&f.visPropOld.fillopacity===e){return}if(JXG.exists(h)&&h!==false){if(h.length!=9){l=h;j=e}else{m=JXG.rgba2rgbo(h);l=m[0];j=e*m[1]}g=f.rendNode;g.setAttributeNS(null,"fill",l);if(f.type===JXG.OBJECT_TYPE_IMAGE){g.setAttributeNS(null,"opacity",j)}else{g.setAttributeNS(null,"fill-opacity",j)}if(JXG.exists(f.visProp.gradient)){this.updateGradient(f)}}f.visPropOld.fillcolor=h;f.visPropOld.fillopacity=e},setObjectStrokeColor:function(f,i,j){var h=JXG.evaluate(i),l,m,e=JXG.evaluate(j),k,g;e=(e>0)?e:0;if(f.visPropOld.strokecolor===h&&f.visPropOld.strokeopacity===e){return}if(JXG.exists(h)&&h!==false){if(h.length!=9){l=h;k=e}else{m=JXG.rgba2rgbo(h);l=m[0];k=e*m[1]}g=f.rendNode;if(f.type===JXG.OBJECT_TYPE_TEXT){if(f.visProp.display==="html"){g.style.color=l;g.style.opacity=k}else{g.setAttributeNS(null,"style","fill:"+l);g.setAttributeNS(null,"style","fill-opacity:"+k)}}else{g.setAttributeNS(null,"stroke",l);g.setAttributeNS(null,"stroke-opacity",k)}if(f.type===JXG.OBJECT_TYPE_ARROW){this._setArrowAtts(f.rendNodeTriangle,l,k)}else{if(f.elementClass===JXG.OBJECT_CLASS_CURVE||f.elementClass===JXG.OBJECT_CLASS_LINE){if(f.visProp.firstarrow){this._setArrowAtts(f.rendNodeTriangleStart,l,k)}if(f.visProp.lastarrow){this._setArrowAtts(f.rendNodeTriangleEnd,l,k)}}}}f.visPropOld.strokecolor=h;f.visPropOld.strokeopacity=e},setObjectStrokeWidth:function(g,f){var e=JXG.evaluate(f),h;if(g.visPropOld.strokewidth===e){return}h=g.rendNode;this.setPropertyPrim(h,"stroked","true");if(JXG.exists(e)){this.setPropertyPrim(h,"stroke-width",e+"px")}g.visPropOld.strokewidth=e},setShadow:function(e){if(e.visPropOld.shadow===e.visProp.shadow){return}if(JXG.exists(e.rendNode)){if(e.visProp.shadow){e.rendNode.setAttributeNS(null,"filter","url(#"+this.container.id+"_f1)")}else{e.rendNode.removeAttributeNS(null,"filter")}}e.visPropOld.shadow=e.visProp.shadow},suspendRedraw:function(){},unsuspendRedraw:function(){},resize:function(e,f){this.svgRoot.style.width=parseFloat(e)+"px";this.svgRoot.style.height=parseFloat(f)+"px"}});JXG.VMLRenderer=function(f){this.type="vml";this.container=f;this.container.style.overflow="hidden";this.container.onselectstart=function(){return false};this.resolution=10;if(!JXG.exists(JXG.vmlStylesheet)){f.ownerDocument.namespaces.add("jxgvml","urn:schemas-microsoft-com:vml");JXG.vmlStylesheet=this.container.ownerDocument.createStyleSheet();JXG.vmlStylesheet.addRule(".jxgvml","behavior:url(#default#VML)")}try{!f.ownerDocument.namespaces.jxgvml&&f.ownerDocument.namespaces.add("jxgvml","urn:schemas-microsoft-com:vml");this.createNode=function(e){return f.ownerDocument.createElement("<jxgvml:"+e+' class="jxgvml">')}}catch(g){this.createNode=function(e){return f.ownerDocument.createElement("<"+e+' xmlns="urn:schemas-microsoft.com:vml" class="jxgvml">')}}this.dashArray=["Solid","1 1","ShortDash","Dash","LongDash","ShortDashDot","LongDashDot"]};JXG.VMLRenderer.prototype=new JXG.AbstractRenderer();JXG.extend(JXG.VMLRenderer.prototype,{_setAttr:function(h,g,j,f){try{if(document.documentMode===8){h[g]=j}else{h.setAttribute(g,j,f)}}catch(i){JXG.debug("_setAttr: "+g+" "+j+"<br>\n")}},updateTicks:function(j,k,f,l,h){var g=[],m,n,o,p,e=this.resolution;n=j.ticks.length;for(m=0;m<n;m++){o=j.ticks[m];x=o[0];y=o[1];if(typeof x[0]!="undefined"&&typeof x[1]!="undefined"){g.push(" m "+Math.round(e*x[0])+", "+Math.round(e*y[0])+" l "+Math.round(e*x[1])+", "+Math.round(e*y[1])+" ")}}for(m=0;m<n;m++){o=j.ticks[m].scrCoords;if(j.ticks[m].major&&(j.board.needsFullUpdate||j.needsRegularUpdate)&&j.labels[m]&&j.labels[m].visProp.visible){this.updateText(j.labels[m])}}if(!JXG.exists(j)){p=this.createPrim("path",j.id);this.appendChildPrim(p,j.visProp.layer);this.appendNodesToElement(j,"path")}this._setAttr(j.rendNode,"stroked","true");this._setAttr(j.rendNode,"strokecolor",j.visProp.strokecolor,1);this._setAttr(j.rendNode,"strokeweight",j.visProp.strokewidth);this._setAttr(j.rendNodeStroke,"opacity",(j.visProp.strokeopacity*100)+"%");this.updatePathPrim(j.rendNode,g,j.board)},displayCopyright:function(g,h){var f,e;f=this.createNode("textbox");f.style.position="absolute";this._setAttr(f,"id",this.container.id+"_licenseText");f.style.left=20;f.style.top=2;f.style.fontSize=h;f.style.color="#356AA0";f.style.fontFamily="Arial,Helvetica,sans-serif";this._setAttr(f,"opacity","30%");f.style.filter="alpha(opacity = 30)";e=document.createTextNode(g);f.appendChild(e);this.appendChildPrim(f,0)},drawInternalText:function(e){var f;f=this.createNode("textbox");f.style.position="absolute";e.rendNodeText=document.createTextNode("");f.appendChild(e.rendNodeText);this.appendChildPrim(f,9);return f},updateInternalText:function(e){var f=e.plaintext;if(!isNaN(e.coords.scrCoords[1]+e.coords.scrCoords[2])){e.rendNode.style.left=parseInt(e.coords.scrCoords[1])+"px";e.rendNode.style.top=parseInt(e.coords.scrCoords[2]-parseInt(e.visProp.fontsize)+this.vOffsetText)+"px"}if(e.htmlStr!==f){e.rendNodeText.data=f;e.htmlStr=f}this.transformImage(e,e.transformations)},drawImage:function(e){var f;f=this.container.ownerDocument.createElement("img");f.style.position="absolute";this._setAttr(f,"id",this.container.id+"_"+e.id);this.container.appendChild(f);this.appendChildPrim(f,e.visProp.layer);f.style.filter="progid:DXImageTransform.Microsoft.Matrix(M11='1.0', sizingMethod='auto expand')";e.rendNode=f;this.updateImage(e)},transformImage:function(h,u){var k=h.rendNode,l,g=[],v,q=u.length,f,e,n,j,o,r;if(h.type===JXG.OBJECT_TYPE_TEXT){h.updateSize()}if(q>0){r=h.rendNode.style.filter.toString();if(!r.match(/DXImageTransform/)){k.style.filter="progid:DXImageTransform.Microsoft.Matrix(M11='1.0', sizingMethod='auto expand') "+r}l=this.joinTransforms(h,u);g[0]=JXG.Math.matVecMult(l,h.coords.scrCoords);g[0][1]/=g[0][0];g[0][2]/=g[0][0];g[1]=JXG.Math.matVecMult(l,[1,h.coords.scrCoords[1]+h.size[0],h.coords.scrCoords[2]]);g[1][1]/=g[1][0];g[1][2]/=g[1][0];g[2]=JXG.Math.matVecMult(l,[1,h.coords.scrCoords[1]+h.size[0],h.coords.scrCoords[2]-h.size[1]]);g[2][1]/=g[2][0];g[2][2]/=g[2][0];g[3]=JXG.Math.matVecMult(l,[1,h.coords.scrCoords[1],h.coords.scrCoords[2]-h.size[1]]);g[3][1]/=g[3][0];g[3][2]/=g[3][0];f=g[0][1];n=g[0][1];e=g[0][2];j=g[0][2];for(o=1;o<4;o++){f=Math.max(f,g[o][1]);n=Math.min(n,g[o][1]);e=Math.max(e,g[o][2]);j=Math.min(j,g[o][2])}k.style.left=parseInt(n)+"px";k.style.top=parseInt(j)+"px";k.filters.item(0).M11=l[1][1];k.filters.item(0).M12=l[1][2];k.filters.item(0).M21=l[2][1];k.filters.item(0).M22=l[2][2]}},updateImageURL:function(f){var e=JXG.evaluate(f.url);this._setAttr(f.rendNode,"src",e)},appendChildPrim:function(e,f){if(!JXG.exists(f)){f=0}e.style.zIndex=f;this.container.appendChild(e)},appendNodesToElement:function(e,f){if(f==="shape"||f==="path"||f==="polygon"){e.rendNodePath=this.getElementById(e.id+"_path")}e.rendNodeFill=this.getElementById(e.id+"_fill");e.rendNodeStroke=this.getElementById(e.id+"_stroke");e.rendNodeShadow=this.getElementById(e.id+"_shadow");e.rendNode=this.getElementById(e.id)},createPrim:function(f,k){var g,e=this.createNode("fill"),j=this.createNode("stroke"),i=this.createNode("shadow"),h;this._setAttr(e,"id",this.container.id+"_"+k+"_fill");this._setAttr(j,"id",this.container.id+"_"+k+"_stroke");this._setAttr(i,"id",this.container.id+"_"+k+"_shadow");if(f==="circle"||f==="ellipse"){g=this.createNode("oval");g.appendChild(e);g.appendChild(j);g.appendChild(i)}else{if(f==="polygon"||f==="path"||f==="shape"||f==="line"){g=this.createNode("shape");g.appendChild(e);g.appendChild(j);g.appendChild(i);h=this.createNode("path");this._setAttr(h,"id",this.container.id+"_"+k+"_path");g.appendChild(h)}else{g=this.createNode(f);g.appendChild(e);g.appendChild(j);g.appendChild(i)}}g.style.position="absolute";g.style.left="0px";g.style.top="0px";this._setAttr(g,"id",this.container.id+"_"+k);return g},remove:function(e){if(JXG.exists(e)){e.removeNode(true)}},makeArrows:function(f){var e;if(f.visPropOld.firstarrow===f.visProp.firstarrow&&f.visPropOld.lastarrow===f.visProp.lastarrow){return}if(f.visProp.firstarrow){e=f.rendNodeStroke;this._setAttr(e,"startarrow","block");this._setAttr(e,"startarrowlength","long")}else{e=f.rendNodeStroke;if(JXG.exists(e)){this._setAttr(e,"startarrow","none")}}if(f.visProp.lastarrow){e=f.rendNodeStroke;this._setAttr(e,"id",this.container.id+"_"+f.id+"stroke");this._setAttr(e,"endarrow","block");this._setAttr(e,"endarrowlength","long")}else{e=f.rendNodeStroke;if(JXG.exists(e)){this._setAttr(e,"endarrow","none")}}f.visPropOld.firstarrow=f.visProp.firstarrow;f.visPropOld.lastarrow=f.visProp.lastarrow},updateEllipsePrim:function(f,e,i,h,g){f.style.left=parseInt(e-h)+"px";f.style.top=parseInt(i-g)+"px";f.style.width=parseInt(Math.abs(h)*2)+"px";f.style.height=parseInt(Math.abs(g)*2)+"px"},updateLinePrim:function(l,f,e,h,g,j){var i,k=this.resolution;if(!isNaN(f+e+h+g)){i=["m ",parseInt(k*f),", ",parseInt(k*e)," l ",parseInt(k*h),", ",parseInt(k*g)];this.updatePathPrim(l,i,j)}},updatePathPrim:function(g,h,f){var e=f.canvasWidth,i=f.canvasHeight;if(h.length<=0){h=["m 0,0"]}g.style.width=e;g.style.height=i;this._setAttr(g,"coordsize",[parseInt(this.resolution*e),parseInt(this.resolution*i)].join(","));this._setAttr(g,"path",h.join(""))},updatePathStringPoint:function(f,l,i){var k=[],g=Math.round,h=f.coords.scrCoords,j=l*Math.sqrt(3)*0.5,m=l*0.5,e=this.resolution;if(i==="x"){k.push([" m ",g(e*(h[1]-l)),", ",g(e*(h[2]-l))," l ",g(e*(h[1]+l)),", ",g(e*(h[2]+l))," m ",g(e*(h[1]+l)),", ",g(e*(h[2]-l))," l ",g(e*(h[1]-l)),", ",g(e*(h[2]+l))].join(""))}else{if(i==="+"){k.push([" m ",g(e*(h[1]-l)),", ",g(e*(h[2]))," l ",g(e*(h[1]+l)),", ",g(e*(h[2]))," m ",g(e*(h[1])),", ",g(e*(h[2]-l))," l ",g(e*(h[1])),", ",g(e*(h[2]+l))].join(""))}else{if(i==="<>"){k.push([" m ",g(e*(h[1]-l)),", ",g(e*(h[2]))," l ",g(e*(h[1])),", ",g(e*(h[2]+l))," l ",g(e*(h[1]+l)),", ",g(e*(h[2]))," l ",g(e*(h[1])),", ",g(e*(h[2]-l))," x e "].join(""))}else{if(i==="^"){k.push([" m ",g(e*(h[1])),", ",g(e*(h[2]-l))," l ",g(e*(h[1]-j)),", ",g(e*(h[2]+m))," l ",g(e*(h[1]+j)),", ",g(e*(h[2]+m))," x e "].join(""))}else{if(i==="v"){k.push([" m ",g(e*(h[1])),", ",g(e*(h[2]+l))," l ",g(e*(h[1]-j)),", ",g(e*(h[2]-m))," l ",g(e*(h[1]+j)),", ",g(e*(h[2]-m))," x e "].join(""))}else{if(i===">"){k.push([" m ",g(e*(h[1]+l)),", ",g(e*(h[2]))," l ",g(e*(h[1]-m)),", ",g(e*(h[2]-j))," l ",g(e*(h[1]-m)),", ",g(e*(h[2]+j))," l ",g(e*(h[1]+l)),", ",g(e*(h[2]))].join(""))}else{if(i==="<"){k.push([" m ",g(e*(h[1]-l)),", ",g(e*(h[2]))," l ",g(e*(h[1]+m)),", ",g(e*(h[2]-j))," l ",g(e*(h[1]+m)),", ",g(e*(h[2]+j))," x e "].join(""))}}}}}}}return k},updatePathStringPrim:function(f){var m=[],l,o,e=this.resolution,k=Math.round,h=" m ",j=" l ",g=h,p=(f.visProp.curvetype!=="plot"),n=Math.min(f.numberPoints,8192);if(f.numberPoints<=0){return""}if(p&&f.board.options.curve.RDPsmoothing){f.points=JXG.Math.Numerics.RamerDouglasPeuker(f.points,1)}n=Math.min(n,f.points.length);for(l=0;l<n;l++){o=f.points[l].scrCoords;if(isNaN(o[1])||isNaN(o[2])){g=h}else{if(o[1]>20000){o[1]=20000}else{if(o[1]<-20000){o[1]=-20000}}if(o[2]>20000){o[2]=20000}else{if(o[2]<-20000){o[2]=-20000}}m.push([g,k(e*o[1]),", ",k(e*o[2])].join(""));g=j}}m.push(" e");return m},updatePathStringBezierPrim:function(h){var s=[],q,p,v,l,g,u=h.visProp.strokewidth,e=this.resolution,o=Math.round,m=" m ",n=" c ",k=m,w=(h.visProp.curvetype!=="plot"),t=Math.min(h.numberPoints,8192);if(h.numberPoints<=0){return""}if(w&&h.board.options.curve.RDPsmoothing){h.points=JXG.Math.Numerics.RamerDouglasPeuker(h.points,1)}t=Math.min(t,h.points.length);for(p=1;p<3;p++){k=m;for(q=0;q<t;q++){v=h.points[q].scrCoords;if(isNaN(v[1])||isNaN(v[2])){k=m}else{if(v[1]>20000){v[1]=20000}else{if(v[1]<-20000){v[1]=-20000}}if(v[2]>20000){v[2]=20000}else{if(v[2]<-20000){v[2]=-20000}}if(k==m){s.push([k,o(e*(v[1]+0*u*(2*p*Math.random()-p)))," ",o(e*(v[2]+0*u*(2*p*Math.random()-p)))].join(""))}else{s.push([k,o(e*(l+(v[1]-l)*0.333+u*(2*p*Math.random()-p)))," ",o(e*(g+(v[2]-g)*0.333+u*(2*p*Math.random()-p)))," ",o(e*(l+2*(v[1]-l)*0.333+u*(2*p*Math.random()-p)))," ",o(e*(g+2*(v[2]-g)*0.333+u*(2*p*Math.random()-p)))," ",o(e*v[1])," ",o(e*v[2])].join(""))}k=n;l=v[1];g=v[2]}}}s.push(" e");return s},updatePolygonPrim:function(j,g){var f,e=g.vertices.length,h=this.resolution,k,l=[];this._setAttr(j,"stroked","false");k=g.vertices[0].coords.scrCoords;if(isNaN(k[1]+k[2])){return}l.push(["m ",parseInt(h*k[1]),",",parseInt(h*k[2])," l "].join(""));for(f=1;f<e-1;f++){if(g.vertices[f].isReal){k=g.vertices[f].coords.scrCoords;if(isNaN(k[1]+k[2])){return}l.push(parseInt(h*k[1])+","+parseInt(h*k[2]))}else{this.updatePathPrim(j,"",g.board);return}if(f<e-2){l.push(", ")}}l.push(" x e");this.updatePathPrim(j,l,g.board)},updateRectPrim:function(i,e,j,f,g){i.style.left=parseInt(e)+"px";i.style.top=parseInt(j)+"px";if(f>=0){i.style.width=f+"px"}if(g>=0){i.style.height=g+"px"}},setPropertyPrim:function(h,g,i){var f="",e;switch(g){case"stroke":f="strokecolor";break;case"stroke-width":f="strokeweight";break;case"stroke-dasharray":f="dashstyle";break}if(f!==""){e=JXG.evaluate(i);this._setAttr(h,f,e)}},show:function(e){if(e&&e.rendNode){e.rendNode.style.visibility="inherit"}},hide:function(e){if(e&&e.rendNode){e.rendNode.style.visibility="hidden"}},setDashStyle:function(f,e){var g;if(e.dash>=0){g=f.rendNodeStroke;this._setAttr(g,"dashstyle",this.dashArray[e.dash])}},setGradient:function(f){var e=f.rendNodeFill;if(f.visProp.gradient==="linear"){this._setAttr(e,"type","gradient");this._setAttr(e,"color2",f.visProp.gradientsecondcolor);this._setAttr(e,"opacity2",f.visProp.gradientsecondopacity);this._setAttr(e,"angle",f.visProp.gradientangle)}else{if(f.visProp.gradient==="radial"){this._setAttr(e,"type","gradientradial");this._setAttr(e,"color2",f.visProp.gradientsecondcolor);this._setAttr(e,"opacity2",f.visProp.gradientsecondopacity);this._setAttr(e,"focusposition",f.visProp.gradientpositionx*100+"%,"+f.visProp.gradientpositiony*100+"%");this._setAttr(e,"focussize","0,0")}else{this._setAttr(e,"type","solid")}}},setObjectFillColor:function(f,i,j){var h=JXG.evaluate(i),l,m,e=JXG.evaluate(j),k,g=f.rendNode,n;e=(e>0)?e:0;if(f.visPropOld.fillcolor===h&&f.visPropOld.fillopacity===e){return}if(JXG.exists(h)&&h!==false){if(h.length!=9){l=h;k=e}else{m=JXG.rgba2rgbo(h);l=m[0];k=e*m[1]}if(l==="none"||l===false){this._setAttr(f.rendNode,"filled","false")}else{this._setAttr(f.rendNode,"filled","true");this._setAttr(f.rendNode,"fillcolor",l);if(JXG.exists(k)&&f.rendNodeFill){this._setAttr(f.rendNodeFill,"opacity",(k*100)+"%")}}if(f.type===JXG.OBJECT_TYPE_IMAGE){n=f.rendNode.style.filter.toString();if(n.match(/alpha/)){f.rendNode.style.filter=n.replace(/alpha\(opacity *= *[0-9\.]+\)/,"alpha(opacity = "+(k*100)+")")}else{f.rendNode.style.filter+=" alpha(opacity = "+(k*100)+")"}}}f.visPropOld.fillcolor=h;f.visPropOld.fillopacity=e},setObjectStrokeColor:function(g,j,k){var i=JXG.evaluate(j),m,n,f=JXG.evaluate(k),l,h=g.rendNode,e;f=(f>0)?f:0;if(g.visPropOld.strokecolor===i&&g.visPropOld.strokeopacity===f){return}if(JXG.exists(i)&&i!==false){if(i.length!=9){m=i;l=f}else{n=JXG.rgba2rgbo(i);m=n[0];l=f*n[1]}if(g.type===JXG.OBJECT_TYPE_TEXT){l=Math.round(l*100);h.style.filter=" alpha(opacity = "+l+")";h.style.color=m}else{if(m!==false){this._setAttr(h,"stroked","true");this._setAttr(h,"strokecolor",m)}e=g.rendNodeStroke;if(JXG.exists(l)&&g.type!==JXG.OBJECT_TYPE_IMAGE){this._setAttr(e,"opacity",(l*100)+"%")}}}g.visPropOld.strokecolor=i;g.visPropOld.strokeopacity=f},setObjectStrokeWidth:function(g,f){var e=JXG.evaluate(f),h;if(g.visPropOld.strokewidth===e){return}h=g.rendNode;this.setPropertyPrim(h,"stroked","true");if(JXG.exists(e)){this.setPropertyPrim(h,"stroke-width",e)}g.visPropOld.strokewidth=e},setShadow:function(e){var f=e.rendNodeShadow;if(!f||e.visPropOld.shadow===e.visProp.shadow){return}if(e.visProp.shadow){this._setAttr(f,"On","True");this._setAttr(f,"Offset","3pt,3pt");this._setAttr(f,"Opacity","60%");this._setAttr(f,"Color","#aaaaaa")}else{this._setAttr(f,"On","False")}e.visPropOld.shadow=e.visProp.shadow},suspendRedraw:function(){this.container.style.display="none"},unsuspendRedraw:function(){this.container.style.display=""}});JXG.CanvasRenderer=function(e){var f;this.type="canvas";this.canvasRoot=null;this.suspendHandle=null;this.canvasId=JXG.Util.genUUID();this.canvasNamespace=null;this.container=e;this.container.style.MozUserSelect="none";this.container.style.overflow="hidden";if(this.container.style.position===""){this.container.style.position="relative"}this.container.innerHTML=['<canvas id="',this.canvasId,'" width="',JXG.getStyle(this.container,"width"),'" height="',JXG.getStyle(this.container,"height"),'"><',"/canvas>"].join("");this.canvasRoot=document.getElementById(this.canvasId);this.context=this.canvasRoot.getContext("2d");this.dashArray=[[2,2],[5,5],[10,10],[20,20],[20,10,10,10],[20,5,10,5]]};JXG.CanvasRenderer.prototype=new JXG.AbstractRenderer();JXG.extend(JXG.CanvasRenderer.prototype,{_drawFilledPolygon:function(f){var h,e=f.length,g=this.context;if(e>0){g.beginPath();g.moveTo(f[0][0],f[0][1]);for(h=0;h<e;h++){if(h>0){g.lineTo(f[h][0],f[h][1])}}g.lineTo(f[0][0],f[0][1]);g.fill()}},_fill:function(f){var e=this.context;e.save();if(this._setColor(f,"fill")){e.fill()}e.restore()},_rotatePoint:function(f,e,g){return[(e*Math.cos(f))-(g*Math.sin(f)),(e*Math.sin(f))+(g*Math.cos(f))]},_rotateShape:function(f,h){var g,j=[],e=f.length;if(e<=0){return f}for(g=0;g<e;g++){j.push(this._rotatePoint(h,f[g][0],f[g][1]))}return j},_setColor:function(j,n,e){var k=true,h=false,q=j.visProp,f,i,p,m,g,l;n=n||"stroke";e=e||n;if(!JXG.exists(j.board)||!JXG.exists(j.board.highlightedObjects)){h=true}if(!h&&JXG.exists(j.board.highlightedObjects[j.id])){f="highlight"}else{f=""}i=JXG.evaluate(q[f+n+"color"]);if(i!=="none"&&i!==false){g=JXG.evaluate(q[f+n+"opacity"]);g=(g>0)?g:0;if(i.length!=9){m=i;l=g}else{p=JXG.rgba2rgbo(i);m=p[0];l=g*p[1]}this.context.globalAlpha=l;this.context[e+"Style"]=m}else{k=false}if(n==="stroke"){this.context.lineWidth=parseFloat(q.strokewidth)}return k},_stroke:function(f){var e=this.context;e.save();if(f.visProp.dash>0){if(e.setLineDash){e.setLineDash(this.dashArray[f.visProp.dash])}}else{this.context.lineDashArray=[]}if(this._setColor(f,"stroke")){e.stroke()}e.restore()},_translateShape:function(g,f,k){var h,j=[],e=g.length;if(e<=0){return g}for(h=0;h<e;h++){j.push([g[h][0]+f,g[h][1]+k])}return j},drawPoint:function(j){var k=j.visProp.face,i=j.visProp.size,m=j.coords.scrCoords,l=i*Math.sqrt(3)*0.5,e=i*0.5,g=parseFloat(j.visProp.strokewidth)/2,h=this.context;if(i<=0||!j.visProp.visible){return}switch(k){case"cross":case"x":h.beginPath();h.moveTo(m[1]-i,m[2]-i);h.lineTo(m[1]+i,m[2]+i);h.moveTo(m[1]+i,m[2]-i);h.lineTo(m[1]-i,m[2]+i);h.closePath();this._stroke(j);break;case"circle":case"o":h.beginPath();h.arc(m[1],m[2],i+1+g,0,2*Math.PI,false);h.closePath();this._fill(j);this._stroke(j);break;case"square":case"[]":if(i<=0){break}h.save();if(this._setColor(j,"stroke","fill")){h.fillRect(m[1]-i-g,m[2]-i-g,i*2+3*g,i*2+3*g)}h.restore();h.save();this._setColor(j,"fill");h.fillRect(m[1]-i+g,m[2]-i+g,i*2-g,i*2-g);h.restore();break;case"plus":case"+":h.beginPath();h.moveTo(m[1]-i,m[2]);h.lineTo(m[1]+i,m[2]);h.moveTo(m[1],m[2]-i);h.lineTo(m[1],m[2]+i);h.closePath();this._stroke(j);break;case"diamond":case"<>":h.beginPath();h.moveTo(m[1]-i,m[2]);h.lineTo(m[1],m[2]+i);h.lineTo(m[1]+i,m[2]);h.lineTo(m[1],m[2]-i);h.closePath();this._fill(j);this._stroke(j);break;case"triangleup":case"a":case"^":h.beginPath();h.moveTo(m[1],m[2]-i);h.lineTo(m[1]-l,m[2]+e);h.lineTo(m[1]+l,m[2]+e);h.closePath();this._fill(j);this._stroke(j);break;case"triangledown":case"v":h.beginPath();h.moveTo(m[1],m[2]+i);h.lineTo(m[1]-l,m[2]-e);h.lineTo(m[1]+l,m[2]-e);h.closePath();this._fill(j);this._stroke(j);break;case"triangleleft":case"<":h.beginPath();h.moveTo(m[1]-i,m[2]);h.lineTo(m[1]+e,m[2]-l);h.lineTo(m[1]+e,m[2]+l);h.closePath();this.fill(j);this._stroke(j);break;case"triangleright":case">":h.beginPath();h.moveTo(m[1]+i,m[2]);h.lineTo(m[1]-e,m[2]-l);h.lineTo(m[1]-e,m[2]+l);h.closePath();this._fill(j);this._stroke(j);break}},updatePoint:function(e){this.drawPoint(e)},drawLine:function(e){var g=new JXG.Coords(JXG.COORDS_BY_USER,e.point1.coords.usrCoords,e.board),f=new JXG.Coords(JXG.COORDS_BY_USER,e.point2.coords.usrCoords,e.board);JXG.Math.Geometry.calcStraight(e,g,f);this.context.beginPath();this.context.moveTo(g.scrCoords[1],g.scrCoords[2]);this.context.lineTo(f.scrCoords[1],f.scrCoords[2]);this._stroke(e);this.makeArrows(e,g,f)},updateLine:function(e){this.drawLine(e)},drawTicks:function(){},updateTicks:function(h,j,f,k,g){var l,n,m=h.ticks.length,e=this.context;e.beginPath();for(l=0;l<m;l++){n=h.ticks[l];x=n[0];y=n[1];e.moveTo(x[0],y[0]);e.lineTo(x[1],y[1])}for(l=0;l<m;l++){n=h.ticks[l].scrCoords;if(h.ticks[l].major&&(h.board.needsFullUpdate||h.needsRegularUpdate)&&h.labels[l]&&h.labels[l].visProp.visible){this.updateText(h.labels[l])}}this._stroke(h)},drawCurve:function(e){if(e.visProp.handdrawing){this.updatePathStringBezierPrim(e)}else{this.updatePathStringPrim(e)}},updateCurve:function(e){this.drawCurve(e)},drawEllipse:function(g){var f=g.center.coords.scrCoords[1],e=g.center.coords.scrCoords[2],o=g.board.unitX,n=g.board.unitY,u=2*g.Radius(),t=2*g.Radius(),r=u*o,m=t*n,j=f-r/2,i=e-m/2,v=(r/2)*0.5522848,s=(m/2)*0.5522848,q=j+r,p=i+m,l=j+r/2,k=i+m/2,h=this.context;if(u>0&&t>0&&!isNaN(f+e)){h.beginPath();h.moveTo(j,k);h.bezierCurveTo(j,k-s,l-v,i,l,i);h.bezierCurveTo(l+v,i,q,k-s,q,k);h.bezierCurveTo(q,k+s,l+v,p,l,p);h.bezierCurveTo(l-v,p,j,k+s,j,k);h.closePath();this._fill(g);this._stroke(g)}},updateEllipse:function(e){return this.drawEllipse(e)},displayCopyright:function(g,f){var e=this.context;e.save();e.font=f+"px Arial";e.fillStyle="#aaa";e.lineWidth=0.5;e.fillText(g,10,2+f);e.restore()},drawInternalText:function(g){var e,f=this.context;f.save();if(this._setColor(g,"stroke","fill")&&!isNaN(g.coords.scrCoords[1]+g.coords.scrCoords[2])){if(g.visProp.fontsize){if(typeof g.visProp.fontsize==="function"){e=g.visProp.fontsize();f.font=(e>0?e:0)+"px Arial"}else{f.font=(g.visProp.fontsize)+"px Arial"}}this.transformImage(g,g.transformations);f.fillText(g.plaintext,g.coords.scrCoords[1],g.coords.scrCoords[2])}f.restore();return null},updateInternalText:function(e){this.drawInternalText(e)},setObjectStrokeColor:function(f,i,j){var h=JXG.evaluate(i),l,m,e=JXG.evaluate(j),k,g;e=(e>0)?e:0;if(f.visPropOld.strokecolor===h&&f.visPropOld.strokeopacity===e){return}if(JXG.exists(h)&&h!==false){if(h.length!=9){l=h;k=e}else{m=JXG.rgba2rgbo(h);l=m[0];k=e*m[1]}g=f.rendNode;if(f.type===JXG.OBJECT_TYPE_TEXT&&f.visProp.display==="html"){g.style.color=l;g.style.opacity=k}}f.visPropOld.strokecolor=h;f.visPropOld.strokeopacity=e},drawImage:function(e){e.rendNode=new Image();e._src="";this.updateImage(e)},updateImage:function(f){var e=this.context,g=JXG.evaluate(f.visProp.fillopacity),h=JXG.bind(function(){f.imgIsLoaded=true;if(f.size[0]<=0||f.size[1]<=0){return}e.save();e.globalAlpha=g;this.transformImage(f,f.transformations);e.drawImage(f.rendNode,f.coords.scrCoords[1],f.coords.scrCoords[2]-f.size[1],f.size[0],f.size[1]);e.restore()},this);if(this.updateImageURL(f)){f.rendNode.onload=h}else{if(f.imgIsLoaded){h()}}},transformImage:function(i,h){var f,e=h.length,g=this.context;if(e>0){f=this.joinTransforms(i,h);if(Math.abs(JXG.Math.Numerics.det(f))>=JXG.Math.eps){g.transform(f[1][1],f[2][1],f[1][2],f[2][2],f[1][0],f[2][0])}}},updateImageURL:function(f){var e;e=JXG.evaluate(f.url);if(f._src!==e){f.imgIsLoaded=false;f.rendNode.src=e;f._src=e;return true}return false},remove:function(e){if(JXG.exists(e)&&JXG.exists(e.parentNode)){e.parentNode.removeChild(e)}},makeArrows:function(i,m,k){var g=[[2,0],[-10,-4],[-10,4]],o=[[-2,0],[10,-4],[10,4]],h,n,e,l,j,f=this.context;if(i.visProp.strokecolor!=="none"&&(i.visProp.lastarrow||i.visProp.firstarrow)){if(i.elementClass===JXG.OBJECT_CLASS_LINE){h=m.scrCoords[1];n=m.scrCoords[2];e=k.scrCoords[1];l=k.scrCoords[2]}else{return}f.save();if(this._setColor(i,"stroke","fill")){j=Math.atan2(l-n,e-h);if(i.visProp.lastarrow){this._drawFilledPolygon(this._translateShape(this._rotateShape(g,j),e,l))}if(i.visProp.firstarrow){this._drawFilledPolygon(this._translateShape(this._rotateShape(o,j),h,n))}}f.restore()}},updatePathStringPrim:function(f){var h="M",j="L",g=h,n=5000,k,m,o=(f.visProp.curvetype!=="plot"),l,e=this.context;if(f.numberPoints<=0){return}if(o&&f.board.options.curve.RDPsmoothing){f.points=JXG.Math.Numerics.RamerDouglasPeuker(f.points,0.5)}l=Math.min(f.points.length,f.numberPoints);e.beginPath();for(k=0;k<l;k++){m=f.points[k].scrCoords;if(isNaN(m[1])||isNaN(m[2])){g=h}else{if(m[1]>n){m[1]=n}else{if(m[1]<-n){m[1]=-n}}if(m[2]>n){m[2]=n}else{if(m[2]<-n){m[2]=-n}}if(g===h){e.moveTo(m[1],m[2])}else{e.lineTo(m[1],m[2])}g=j}}this._fill(f);this._stroke(f)},updatePathStringBezierPrim:function(h){var m="M",n="C",l=m,u=5000,p,o,s,k,g,r=h.visProp.strokewidth,t=(h.visProp.curvetype!=="plot"),q,e=this.context;if(h.numberPoints<=0){return}if(t&&h.board.options.curve.RDPsmoothing){h.points=JXG.Math.Numerics.RamerDouglasPeuker(h.points,0.5)}q=Math.min(h.points.length,h.numberPoints);e.beginPath();for(o=1;o<3;o++){l=m;for(p=0;p<q;p++){s=h.points[p].scrCoords;if(isNaN(s[1])||isNaN(s[2])){l=m}else{if(s[1]>u){s[1]=u}else{if(s[1]<-u){s[1]=-u}}if(s[2]>u){s[2]=u}else{if(s[2]<-u){s[2]=-u}}if(l==m){e.moveTo(s[1]+0*r*(2*o*Math.random()-o),s[2]+0*r*(2*o*Math.random()-o))}else{e.bezierCurveTo((k+(s[1]-k)*0.333+r*(2*o*Math.random()-o)),(g+(s[2]-g)*0.333+r*(2*o*Math.random()-o)),(k+2*(s[1]-k)*0.333+r*(2*o*Math.random()-o)),(g+2*(s[2]-g)*0.333+r*(2*o*Math.random()-o)),s[1],s[2])}l=n;k=s[1];g=s[2]}}}this._fill(h);this._stroke(h)},updatePolygonPrim:function(k,j){var f,h,e=j.vertices.length,g=this.context;if(e<=0){return}g.beginPath();f=j.vertices[0].coords.scrCoords;g.moveTo(f[1],f[2]);for(h=1;h<e;h++){f=j.vertices[h].coords.scrCoords;g.lineTo(f[1],f[2])}g.closePath();this._fill(j)},show:function(e){if(JXG.exists(e.rendNode)){e.rendNode.style.visibility="inherit"}},hide:function(e){if(JXG.exists(e.rendNode)){e.rendNode.style.visibility="hidden"}},setGradient:function(f){var e,g;g=JXG.evaluate(f.visProp.fillopacity);g=(g>0)?g:0;e=JXG.evaluate(f.visProp.fillcolor)},setShadow:function(e){if(e.visPropOld.shadow===e.visProp.shadow){return}e.visPropOld.shadow=e.visProp.shadow},highlight:function(e){e.board.prepareUpdate();e.board.renderer.suspendRedraw(e.board);e.board.updateRenderer();e.board.renderer.unsuspendRedraw();return this},noHighlight:function(e){e.board.prepareUpdate();e.board.renderer.suspendRedraw(e.board);e.board.updateRenderer();e.board.renderer.unsuspendRedraw();return this},suspendRedraw:function(e){this.context.save();this.context.clearRect(0,0,this.canvasRoot.width,this.canvasRoot.height);if(e&&e.showCopyright){this.displayCopyright(JXG.JSXGraph.licenseText,12)}},unsuspendRedraw:function(){this.context.restore()},resize:function(e,f){this.canvasRoot.style.width=parseFloat(e)+"px";this.canvasRoot.style.height=parseFloat(f)+"px";this.canvasRoot.setAttribute("width",parseFloat(e)+"px");this.canvasRoot.setAttribute("height",parseFloat(f)+"px")}});