/*
 * Decompiled with CFR 0.152.
 */
package fr.ove.openmath.jome.ctrlview.bidim;

import fr.ove.openmath.jome.behaviour.Iconifiable;
import fr.ove.openmath.jome.behaviour.Selectable;
import fr.ove.openmath.jome.ctrlview.bidim.Colorizable;
import fr.ove.openmath.jome.ctrlview.bidim.DisplayAllocator;
import fr.ove.openmath.jome.ctrlview.bidim.DisplayLayout;
import fr.ove.openmath.jome.ctrlview.bidim.Displayable;
import fr.ove.openmath.jome.ctrlview.bidim.GraphicContext;
import fr.ove.openmath.jome.ctrlview.bidim.OneFormulaLayout;
import fr.ove.openmath.jome.ctrlview.bidim.SubstitutedDisplayManager;
import fr.ove.openmath.jome.ctrlview.bidim.selection.events.SelectionEvent;
import fr.ove.openmath.jome.ctrlview.bidim.selection.events.SelectionEventListener;
import fr.ove.openmath.jome.ctrlview.events.ControlEvent;
import fr.ove.openmath.jome.ctrlview.events.ControlListener;
import fr.ove.openmath.jome.model.FormulaTreeStructure;
import fr.ove.openmath.jome.model.events.ModelListenerController;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.util.Enumeration;
import java.util.Vector;

public abstract class Display
extends Container
implements Displayable,
Colorizable,
Selectable,
Iconifiable,
ModelListenerController {
    private int ascent;
    private int descent;
    private int shiftX = 0;
    private int shiftY = 0;
    protected boolean isSelected = false;
    private int level = 0;
    private boolean updateLevel = true;
    private boolean weDrawBounds = false;
    private GraphicContext graphicContext;
    private boolean computeAttributes = true;
    private int rank = 0;
    private static SelectionEventListener selectionManager = null;
    private ControlListener listener;
    protected boolean dragNDrop;
    private boolean isSymbolOperatorDisplay = false;
    private boolean doRemoveFromListListeners = true;
    private static DisplayAllocator displayAllocator = null;

    public Display(GraphicContext graphicContext) {
        this.graphicContext = new GraphicContext(graphicContext);
        this.setFont(graphicContext.getFont());
        this.setForeground(graphicContext.getForegroundColor());
        this.setBackground(graphicContext.getBackgroundColor());
        this.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent mouseEvent) {
                SelectionEvent selectionEvent = new SelectionEvent(Display.this);
                if (mouseEvent.isControlDown()) {
                    if (!Display.this.isSelected) {
                        DisplayLayout displayLayout = (DisplayLayout)Display.this.getLayout();
                        if (displayLayout instanceof OneFormulaLayout) {
                            Display display = (Display)Display.this.getComponent(0);
                            if (display.isSelected()) {
                                displayLayout.deselectDisplay();
                            } else {
                                displayLayout.selectDisplay();
                                Display.this.setCursor(new Cursor(12));
                            }
                        } else {
                            displayLayout.selectDisplay();
                            Display.this.setCursor(new Cursor(12));
                        }
                        Display.this.repaint();
                    } else {
                        ((DisplayLayout)Display.this.getLayout()).deselectDisplay();
                        Display.this.setCursor(new Cursor(0));
                        Display.this.repaint();
                    }
                } else if (mouseEvent.isShiftDown()) {
                    Display.this.iconify();
                } else if (mouseEvent.isAltDown()) {
                    Display.this.uniconify();
                }
            }

            public void mouseEntered(MouseEvent mouseEvent) {
                if (Display.this.isSelected) {
                    Display.this.setCursor(new Cursor(12));
                } else {
                    Display.this.setCursor(new Cursor(0));
                }
            }

            public void mouseReleased(MouseEvent mouseEvent) {
                int n = mouseEvent.getX();
                if (Display.this.dragNDrop) {
                    Display.this.moveSelectedDisplays(n);
                    Display.this.dragNDrop = false;
                    Display.this.repaint();
                }
            }
        });
        this.addMouseMotionListener(new MouseMotionAdapter(){

            public void mouseDragged(MouseEvent mouseEvent) {
                if (Display.this.isSelected) {
                    Display.this.dragNDrop = true;
                    Display.this.setCursor(new Cursor(13));
                }
            }

            public void mouseMoved(MouseEvent mouseEvent) {
                if (Display.this.isSelected) {
                    Display.this.setCursor(new Cursor(12));
                } else {
                    Display.this.setCursor(new Cursor(0));
                }
            }
        });
    }

    public boolean isDisplay(FormulaTreeStructure formulaTreeStructure) {
        Vector vector = formulaTreeStructure.getListeners();
        return vector.contains(this);
    }

    public void setIsSymbolOperatorDisplay(boolean bl) {
        this.isSymbolOperatorDisplay = bl;
    }

    public boolean isSymbolOperatorDisplay() {
        return this.isSymbolOperatorDisplay;
    }

    public void drawBounds() {
        this.weDrawBounds = true;
    }

    public void dontDrawBounds() {
        this.weDrawBounds = false;
    }

    public boolean weDrawBounds() {
        return this.weDrawBounds;
    }

    public void setLevel(int n) {
        this.level = n;
    }

    public int getLevel() {
        return this.level;
    }

    public void incLevel() {
        ++this.level;
    }

    public void decLevel() {
        --this.level;
    }

    public void setUpdateLevel(boolean bl) {
        this.updateLevel = bl;
        if (bl) {
            int n = this.getComponentCount();
            for (int i = 0; i < n; ++i) {
                ((Display)this.getComponent(i)).setUpdateLevel(bl);
            }
        }
    }

    public boolean getUpdateLevel() {
        return this.updateLevel;
    }

    public void updateAncestorsLevel() {
        Container container = this.getParent();
        while (container instanceof Display) {
            ((Display)container).setUpdateLevel(true);
            container = container.getParent();
        }
    }

    public void updateChildrenLevel() {
        int n = this.getComponentCount();
        for (int i = 0; i < n; ++i) {
            Display display = (Display)this.getComponent(i);
            display.setUpdateLevel(true);
            display.updateChildrenLevel();
        }
    }

    public void setComputeAttributes(boolean bl) {
        this.computeAttributes = bl;
    }

    public boolean getComputeAttributes() {
        return this.computeAttributes;
    }

    public void computeAncestorsAttributes() {
        this.computeAttributes = true;
        Container container = this.getParent();
        while (container instanceof Display) {
            ((Display)container).setComputeAttributes(true);
            container = container.getParent();
        }
    }

    public void computeChildrenAttributes() {
        this.computeAttributes = true;
        int n = this.getComponentCount();
        for (int i = 0; i < n; ++i) {
            ((Display)this.getComponent(i)).computeChildrenAttributes();
        }
    }

    public void setRank(int n) {
        this.rank = n;
    }

    public int getRank() {
        return this.rank;
    }

    public void adjustRank() {
        int n = this.getComponentCount();
        for (int i = 0; i < n; ++i) {
            ((Display)this.getComponent(i)).setRank(i);
        }
    }

    public void removeAllDisplays() {
        int n = 0;
        for (int i = this.getComponentCount(); n < i; --i) {
            Display display = (Display)this.getComponent(n);
            if (display.isSymbolOperatorDisplay) {
                this.remove(n);
                continue;
            }
            super.remove(n);
        }
    }

    public void scaleDisplay() {
        this.setTheFont(this.graphicContext.scaleFont(this.level));
        this.setComputeAttributes(true);
        int n = this.getComponentCount();
        for (int i = 0; i < n; ++i) {
            ((Display)this.getComponent(i)).scaleDisplay();
        }
        FormulaTreeStructure formulaTreeStructure = (FormulaTreeStructure)this.getListener();
        if (formulaTreeStructure != null && formulaTreeStructure.isIcon()) {
            SubstitutedDisplayManager substitutedDisplayManager = (SubstitutedDisplayManager)((Object)this.getLayout());
            n = substitutedDisplayManager.getNbSubstitutedDisplay();
            for (int i = 0; i < n; ++i) {
                substitutedDisplayManager.getSubstitutedDisplay(i).scaleDisplay();
            }
        }
    }

    public void moveSelectedDisplays(int n) {
        SelectionEvent selectionEvent = new SelectionEvent(this);
        Integer n2 = null;
        selectionEvent.setAction(3, n2);
        this.fireSelectionEvent(selectionEvent);
        n2 = (Integer)selectionEvent.getArgument();
        if (n2 != 0) {
            int n3;
            Display display;
            Vector vector = null;
            selectionEvent.setAction(4, vector);
            this.fireSelectionEvent(selectionEvent);
            vector = (Vector)selectionEvent.getArgument();
            Display display2 = (Display)vector.elementAt(0);
            FormulaTreeStructure formulaTreeStructure = (FormulaTreeStructure)display2.getListener();
            formulaTreeStructure = (FormulaTreeStructure)formulaTreeStructure.getFather();
            if (!formulaTreeStructure.getAreOperandsMovable()) {
                return;
            }
            display2 = (Display)display2.getParent();
            for (display = this; display != display2; display = (Display)display.getParent()) {
                n += display.getX();
            }
            if (n <= 0) {
                display = (Display)display2.getComponentAt(1, display2.getAscent());
                n3 = display.computeInsertionPosition(1);
            } else if (n >= display2.getWidth()) {
                display = (Display)display2.getComponentAt(display2.getWidth() - 1, display2.getAscent());
                n3 = display.computeInsertionPosition(display2.getWidth() - 1 - display.getX());
            } else {
                display = (Display)display2.getComponentAt(n, display2.getAscent());
                n3 = display.computeInsertionPosition(n - display.getX());
            }
            Vector<ControlListener> vector2 = new Vector<ControlListener>();
            Enumeration enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                display = (Display)enumeration.nextElement();
                if (display.isSymbolOperatorDisplay()) continue;
                display.deselect();
                vector2.addElement(display.getListener());
            }
            formulaTreeStructure.moveOperands(vector2, n3);
            selectionEvent.setAction(0, null);
            this.fireSelectionEvent(selectionEvent);
        }
    }

    public int computeInsertionPosition(int n) {
        int n2 = n <= this.getWidth() / 2 ? ((FormulaTreeStructure)this.listener).getRank() : ((FormulaTreeStructure)this.listener).getRank() + 1;
        return n2;
    }

    public void setDisplayAllocator(DisplayAllocator displayAllocator) {
        Display.displayAllocator = displayAllocator;
    }

    public DisplayAllocator getDisplayAllocator() {
        return displayAllocator;
    }

    public void buildDisplay() {
        FormulaTreeStructure formulaTreeStructure = (FormulaTreeStructure)this.getListener();
        if (formulaTreeStructure != null) {
            int n = formulaTreeStructure.getNbChildren();
            for (int i = 0; i < n; ++i) {
                FormulaTreeStructure formulaTreeStructure2 = (FormulaTreeStructure)formulaTreeStructure.getChild(i);
                Display display = displayAllocator.allocateDisplay(this.graphicContext, formulaTreeStructure2);
                this.add(display);
                display.buildDisplay();
            }
        }
    }

    public Display buildDisplay(int n) {
        Display display = null;
        FormulaTreeStructure formulaTreeStructure = (FormulaTreeStructure)this.getListener();
        if (formulaTreeStructure != null) {
            int n2 = formulaTreeStructure.getNbChildren();
            if (n >= 0 && n < n2) {
                FormulaTreeStructure formulaTreeStructure2 = (FormulaTreeStructure)formulaTreeStructure.getChild(n);
                display = displayAllocator.allocateDisplay(this.graphicContext, formulaTreeStructure2);
                display.setLevel(this.getLevel());
                display.addControlListener(formulaTreeStructure2);
                formulaTreeStructure2.addModelListener(display);
                this.add(display);
                display.buildDisplay();
            }
        }
        return display;
    }

    public void add(Display display) {
        super.add((Component)display, (Object)display);
        display.setRank(this.getComponentCount() - 1);
    }

    public void remove(int n) {
        try {
            Display display = (Display)this.getComponent(n);
            if (display.doRemoveFromListListeners()) {
                display.removeFromListListeners();
            }
            super.remove(n);
            this.adjustRank();
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            System.out.println("Trying to remove display with a wrong index");
            arrayIndexOutOfBoundsException.printStackTrace();
        }
    }

    public void removeAll() {
        int n = 0;
        while (n < this.getComponentCount()) {
            this.remove(n);
        }
        this.computeAncestorsAttributes();
    }

    protected void setDoRemoveFromListListeners(boolean bl) {
        this.doRemoveFromListListeners = bl;
    }

    protected boolean doRemoveFromListListeners() {
        return this.doRemoveFromListListeners;
    }

    protected void removeFromListListeners(boolean bl) {
        int n = this.getComponentCount();
        for (int i = 0; i < n; ++i) {
            ((Display)this.getComponent((int)i)).doRemoveFromListListeners = bl;
        }
    }

    private void removeFromListListeners() {
        FormulaTreeStructure formulaTreeStructure = (FormulaTreeStructure)this.getListener();
        formulaTreeStructure.removeModelListener(this);
        this.removeControlListener(formulaTreeStructure);
        int n = this.getComponentCount();
        for (int i = 0; i < n; ++i) {
            ((Display)this.getComponent(i)).removeFromListListeners();
        }
    }

    public void setFont(Font font) {
        this.setTheFont(font);
        this.graphicContext.setFont(font);
        int n = this.getComponentCount();
        for (int i = 0; i < n; ++i) {
            ((Display)this.getComponent(i)).setFont(font);
        }
        this.scaleDisplay();
        this.invalidate();
        FormulaTreeStructure formulaTreeStructure = (FormulaTreeStructure)this.getListener();
        if (formulaTreeStructure != null && formulaTreeStructure.isIcon()) {
            SubstitutedDisplayManager substitutedDisplayManager = (SubstitutedDisplayManager)((Object)this.getLayout());
            n = substitutedDisplayManager.getNbSubstitutedDisplay();
            for (int i = 0; i < n; ++i) {
                substitutedDisplayManager.getSubstitutedDisplay(i).setFont(font);
            }
        }
    }

    protected void setTheFont(Font font) {
        super.setFont(font);
    }

    public void substitute(String string) {
        SelectionEvent selectionEvent = new SelectionEvent(this);
        Integer n = null;
        selectionEvent.setAction(3, n);
        this.fireSelectionEvent(selectionEvent);
        n = (Integer)selectionEvent.getArgument();
        if (n != 0) {
            Vector vector = null;
            selectionEvent.setAction(4, vector);
            this.fireSelectionEvent(selectionEvent);
            vector = (Vector)selectionEvent.getArgument();
            Vector<Object> vector2 = new Vector<Object>();
            for (int i = 0; i < n; ++i) {
                Display display = (Display)vector.elementAt(i);
                if (display.isSymbolOperatorDisplay()) continue;
                display.deselect();
                FormulaTreeStructure formulaTreeStructure = (FormulaTreeStructure)display.getListener();
                vector2.addElement(formulaTreeStructure);
            }
            selectionEvent.setAction(0, null);
            this.fireSelectionEvent(selectionEvent);
            vector2.insertElementAt(string, 0);
            ControlEvent controlEvent = new ControlEvent(this);
            controlEvent.setAction(5, vector2);
            this.fireControlEvent(controlEvent);
        }
    }

    public void setAscent(int n) {
        this.ascent = n;
    }

    public int getAscent() {
        return this.ascent;
    }

    public void setDescent(int n) {
        this.descent = n;
    }

    public int getDescent() {
        return this.descent;
    }

    public void setShiftX(int n) {
        this.shiftX = n;
    }

    public int getShiftX() {
        return this.shiftX;
    }

    public void setShiftY(int n) {
        this.shiftY = n;
    }

    public int getShiftY() {
        return this.shiftY;
    }

    public void setAttributes(int n, int n2, int n3, int n4) {
        this.ascent = n;
        this.descent = n2;
        this.shiftX = n3;
        this.shiftY = n4;
    }

    public void setGraphicContext(GraphicContext graphicContext) {
        this.graphicContext = graphicContext;
    }

    public GraphicContext getGraphicContext() {
        return this.graphicContext;
    }

    public void setX(int n) {
        this.setLocation(n, this.getLocation().y);
    }

    public int getX() {
        return this.getLocation().x;
    }

    public void setY(int n) {
        this.setLocation(this.getLocation().x, n);
    }

    public int getY() {
        return this.getLocation().y;
    }

    public void setWidth(int n) {
        this.setSize(n, this.getSize().height);
    }

    public int getWidth() {
        return this.getSize().width;
    }

    public void setHeight(int n) {
        this.setSize(this.getSize().width, n);
    }

    public int getHeight() {
        return this.getSize().height;
    }

    public void select() {
        if (!this.isSelected) {
            this.isSelected = true;
            int n = this.getComponentCount();
            for (int i = 0; i < n; ++i) {
                ((Display)this.getComponent(i)).select();
            }
        }
    }

    public void deselect() {
        if (this.isSelected) {
            this.isSelected = false;
            int n = this.getComponentCount();
            for (int i = 0; i < n; ++i) {
                ((Display)this.getComponent(i)).deselect();
            }
        }
    }

    public void setSelected() {
        this.isSelected = true;
    }

    public void setNotSelected() {
        this.isSelected = false;
    }

    public boolean isSelected() {
        return this.isSelected;
    }

    public boolean gotSelectedElements() {
        if (this.isSelected) {
            return true;
        }
        int n = this.getComponentCount();
        for (int i = 0; i < n; ++i) {
            if (!((Display)this.getComponent(i)).gotSelectedElements()) continue;
            return true;
        }
        return false;
    }

    public void setForegroundColor(Color color) {
        this.graphicContext.setForegroundColor(color);
    }

    public Color getForegroundColor() {
        return this.graphicContext.getForegroundColor();
    }

    public void setBackgroundColor(Color color) {
        this.graphicContext.setBackgroundColor(color);
    }

    public Color getBackgroundColor() {
        return this.graphicContext.getBackgroundColor();
    }

    public void setSelectionColor(Color color) {
        this.graphicContext.setSelectionColor(color);
    }

    public Color getSelectionColor() {
        return this.graphicContext.getSelectionColor();
    }

    public void setIconName(String string) {
    }

    public String getIconName() {
        return null;
    }

    public boolean isIcon() {
        return false;
    }

    public void iconify() {
        SelectionEvent selectionEvent = new SelectionEvent(this);
        Integer n = null;
        selectionEvent.setAction(3, n);
        this.fireSelectionEvent(selectionEvent);
        n = (Integer)selectionEvent.getArgument();
        if (n != 0) {
            Vector vector = null;
            selectionEvent.setAction(4, vector);
            this.fireSelectionEvent(selectionEvent);
            vector = (Vector)selectionEvent.getArgument();
            Vector<FormulaTreeStructure> vector2 = new Vector<FormulaTreeStructure>();
            for (int i = 0; i < n; ++i) {
                Display display = (Display)vector.elementAt(i);
                if (display.isSymbolOperatorDisplay()) continue;
                display.deselect();
                FormulaTreeStructure formulaTreeStructure = (FormulaTreeStructure)display.getListener();
                vector2.addElement(formulaTreeStructure);
            }
            selectionEvent.setAction(0, null);
            this.fireSelectionEvent(selectionEvent);
            ControlEvent controlEvent = new ControlEvent(this);
            controlEvent.setAction(2, vector2);
            this.fireControlEvent(controlEvent);
        }
    }

    public void uniconify() {
        SelectionEvent selectionEvent = new SelectionEvent(this);
        Integer n = null;
        selectionEvent.setAction(3, n);
        this.fireSelectionEvent(selectionEvent);
        n = (Integer)selectionEvent.getArgument();
        if (n != 0) {
            Vector vector = null;
            selectionEvent.setAction(4, vector);
            this.fireSelectionEvent(selectionEvent);
            vector = (Vector)selectionEvent.getArgument();
            selectionEvent.setAction(0, null);
            this.fireSelectionEvent(selectionEvent);
            Display display = null;
            FormulaTreeStructure formulaTreeStructure = null;
            for (int i = 0; i < n; ++i) {
                display = (Display)vector.elementAt(i);
                display.deselect();
                formulaTreeStructure = (FormulaTreeStructure)display.getListener();
                if (!formulaTreeStructure.isIcon()) continue;
                display.computeAncestorsAttributes();
                ControlEvent controlEvent = new ControlEvent(this);
                controlEvent.setAction(3, formulaTreeStructure);
                this.fireControlEvent(controlEvent);
            }
        }
    }

    public void uniconifyAll() {
        ControlEvent controlEvent = new ControlEvent(this);
        controlEvent.setAction(4, null);
        this.fireControlEvent(controlEvent);
    }

    public void setIsIconifiable(boolean bl) {
    }

    public boolean isIconifiable() {
        return false;
    }

    public void addControlListener(ControlListener controlListener) {
        this.listener = controlListener;
    }

    public void removeAllControlListener() {
        this.listener = null;
    }

    public void removeControlListener(ControlListener controlListener) {
        this.listener = null;
    }

    public void fireControlEvent(ControlEvent controlEvent) {
        this.listener.consumeControlEvent(controlEvent);
    }

    public ControlListener getListener() {
        return this.listener;
    }

    public void addSelectionEventListener(SelectionEventListener selectionEventListener) {
        selectionManager = selectionEventListener;
    }

    public void removeSelectionEventListener(SelectionEventListener selectionEventListener) {
        if (selectionEventListener == selectionManager) {
            selectionManager = null;
        }
    }

    public void fireSelectionEvent(SelectionEvent selectionEvent) {
        selectionManager.consumeSelectionEvent(selectionEvent);
    }

    public void ToString() {
        System.out.println(super.toString());
        System.out.println("\t x = " + this.getX() + " y = " + this.getY());
        System.out.println("\t ascent = " + this.ascent + " descent = " + this.descent);
        System.out.println("\t width = " + this.getWidth() + " height = " + this.getHeight());
    }

    public void whoAmI() {
        System.out.println("I am a " + this.getClass().getName() + " with the " + this.getLayout().getClass().getName() + " manager");
        System.out.println("My level is " + this.level);
        System.out.println("My children are :");
        for (int i = 0; i < this.getComponentCount(); ++i) {
            ((Display)this.getComponent(i)).whoAmI();
        }
    }
}

