/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.xml.util;

import org.freehep.xml.util.BadXMLException;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class SAXTraverser
extends DefaultHandler {
    private SAXTraverser previous;
    private XMLReader parser;
    private int stack = 0;

    public void setReader(XMLReader xMLReader) {
        this.parser = xMLReader;
        xMLReader.setContentHandler(this);
    }

    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        SAXTraverser sAXTraverser = this.handleElement(string3 = string3.intern(), attributes);
        if (sAXTraverser != this) {
            sAXTraverser.handleElementAttributes(attributes);
            sAXTraverser.previous = this;
            sAXTraverser.parser = this.parser;
            this.parser.setContentHandler(sAXTraverser);
        } else {
            ++this.stack;
        }
    }

    public void endElement(String string, String string2, String string3) throws SAXException {
        if (this.stack == 0) {
            this.handleEndElement(string2);
            this.previous.handleSubElement(this);
            this.parser.setContentHandler(this.previous);
        } else {
            --this.stack;
        }
    }

    protected void handleElementAttributes(Attributes attributes) throws SAXException {
    }

    protected void handleEndElement(String string) throws SAXException {
    }

    protected void handleSubElement(SAXTraverser sAXTraverser) throws SAXException {
    }

    protected SAXTraverser handleElement(String string, Attributes attributes) throws SAXException {
        throw new BadXMLException("Unhandled element " + string);
    }

    public boolean toBoolean(String string) throws BadXMLException {
        if (string.equalsIgnoreCase("true")) {
            return true;
        }
        if (string.equalsIgnoreCase("false")) {
            return false;
        }
        throw new BadXMLException("Bad boolean value " + string);
    }

    public double toDouble(String string) throws SAXException {
        try {
            return new Double(string);
        }
        catch (Throwable throwable) {
            throw new BadXMLException("Bad double value " + string);
        }
    }

    public float toFloat(String string) throws SAXException {
        try {
            return Float.parseFloat(string);
        }
        catch (Throwable throwable) {
            throw new BadXMLException("Bad float value " + string);
        }
    }

    public int toInt(String string) throws SAXException {
        try {
            return Integer.parseInt(string);
        }
        catch (Throwable throwable) {
            throw new BadXMLException("Bad integer value " + string);
        }
    }

    public short toShort(String string) throws SAXException {
        try {
            return Short.parseShort(string);
        }
        catch (Throwable throwable) {
            throw new BadXMLException("Bad short value " + string);
        }
    }

    public long toLong(String string) throws SAXException {
        try {
            return Long.parseLong(string);
        }
        catch (Throwable throwable) {
            throw new BadXMLException("Bad long value " + string);
        }
    }

    public byte toByte(String string) throws SAXException {
        try {
            return Byte.parseByte(string);
        }
        catch (Throwable throwable) {
            throw new BadXMLException("Bad byte value " + string);
        }
    }
}

