/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.util.export;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.freehep.util.export.ExportFileType;
import org.freehep.util.export.MimeTypes;

public class ExportFileTypeGroups {
    public static final String VECTOR = "vector";
    public static final String BITMAP = "bitmap";
    public static final String OTHER = "other";
    public static final String ALTERNATIVE = "alternative";
    private List groupNames = new ArrayList();
    private Map groups;
    private List alternatives;
    private Map labels;

    public ExportFileTypeGroups(List list) {
        this.groupNames.add(VECTOR);
        this.groupNames.add(BITMAP);
        this.groupNames.add(OTHER);
        this.groupNames.add(ALTERNATIVE);
        this.labels = new HashMap();
        this.labels.put(VECTOR, "Vector Formats");
        this.labels.put(BITMAP, "Bitmap Formats");
        this.labels.put(OTHER, "Other");
        this.labels.put(ALTERNATIVE, "Alternative Formats");
        this.groups = new HashMap();
        this.alternatives = new ArrayList();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            String string;
            ExportFileType exportFileType = (ExportFileType)iterator.next();
            String string2 = exportFileType.getMIMETypes()[0];
            String string3 = MimeTypes.isBitmap(string2) ? BITMAP : (MimeTypes.isVector(string2) ? VECTOR : OTHER);
            HashMap<String, ExportFileType> hashMap = (HashMap<String, ExportFileType>)this.groups.get(string3);
            if (hashMap == null) {
                hashMap = new HashMap<String, ExportFileType>();
                this.groups.put(string3, hashMap);
            }
            if (hashMap.get(string = exportFileType.getExtensions()[0]) == null) {
                hashMap.put(string, exportFileType);
                continue;
            }
            this.alternatives.add(exportFileType);
        }
    }

    public List getExportFileTypes(String string) {
        ArrayList arrayList = new ArrayList();
        if (string.equals(ALTERNATIVE)) {
            arrayList.addAll(this.alternatives);
        } else {
            Map map = (Map)this.groups.get(string);
            if (map != null) {
                arrayList.addAll(map.values());
            }
        }
        return arrayList;
    }

    public List getGroupNames() {
        return this.groupNames;
    }

    public String getLabel(String string) {
        return (String)this.labels.get(string);
    }
}

