/*
 * Decompiled with CFR 0.152.
 */
package rene.util.xml;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import rene.util.SimpleByteBuffer;
import rene.util.SimpleStringBuffer;
import rene.util.list.ListElement;
import rene.util.xml.XmlReaderException;
import rene.util.xml.XmlTag;
import rene.util.xml.XmlTagPI;
import rene.util.xml.XmlTagRoot;
import rene.util.xml.XmlTagText;
import rene.util.xml.XmlTranslator;
import rene.util.xml.XmlTree;

public class XmlReader {
    BufferedReader In;
    SimpleStringBuffer buf;
    String Line;
    int LinePos;

    public XmlReader() {
        this.buf = new SimpleStringBuffer(10000);
        this.Line = null;
        this.In = null;
    }

    public XmlReader(BufferedReader bufferedReader) {
        this.buf = new SimpleStringBuffer(10000);
        this.Line = null;
        this.In = bufferedReader;
    }

    public XmlReader(InputStream inputStream) throws XmlReaderException {
        block16: {
            this.buf = new SimpleStringBuffer(10000);
            this.Line = null;
            try {
                int n;
                BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream);
                SimpleByteBuffer simpleByteBuffer = new SimpleByteBuffer(10000);
                while ((n = bufferedInputStream.read()) >= 0) {
                    simpleByteBuffer.append((byte)n);
                }
                bufferedInputStream.close();
                byte[] byArray = simpleByteBuffer.getByteArray();
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
                XmlReader xmlReader = null;
                try {
                    xmlReader = new XmlReader(new BufferedReader(new InputStreamReader((InputStream)byteArrayInputStream, "ASCII")));
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    xmlReader = new XmlReader(new BufferedReader(new InputStreamReader(byteArrayInputStream)));
                }
                String string = null;
                while (true) {
                    int n2;
                    if ((n2 = xmlReader.read()) == -1) {
                        throw new Exception("<?xml> tag not found");
                    }
                    if (n2 != 60) continue;
                    if (xmlReader.found("?xml")) break;
                }
                String string2 = xmlReader.scanFor("?>");
                if (string2 == null) {
                    throw new Exception("<?xml> tag error");
                }
                int n3 = string2.indexOf("encoding=\"");
                if (n3 >= 0) {
                    int n4 = (string2 = string2.substring(n3 += "encoding=\"".length())).indexOf(34);
                    if (n4 < 0) {
                        throw new Exception("Closing bracket missing");
                    }
                    string = string2.substring(0, n4).toUpperCase();
                    if (string.equals("UTF-8")) {
                        string = "UTF8";
                    }
                }
                byteArrayInputStream = new ByteArrayInputStream(byArray);
                if (string == null) {
                    this.In = new BufferedReader(new InputStreamReader(byteArrayInputStream));
                    break block16;
                }
                try {
                    this.In = new BufferedReader(new InputStreamReader((InputStream)byteArrayInputStream, string));
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    try {
                        this.In = new BufferedReader(new InputStreamReader((InputStream)byteArrayInputStream, "ASCII"));
                    }
                    catch (UnsupportedEncodingException unsupportedEncodingException2) {
                        this.In = new BufferedReader(new InputStreamReader(byteArrayInputStream));
                    }
                }
            }
            catch (Exception exception) {
                throw new XmlReaderException(exception.toString());
            }
        }
    }

    public void init(InputStream inputStream) throws XmlReaderException {
        block16: {
            try {
                int n;
                BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream);
                SimpleByteBuffer simpleByteBuffer = new SimpleByteBuffer(10000);
                while ((n = bufferedInputStream.read()) >= 0) {
                    simpleByteBuffer.append((byte)n);
                }
                bufferedInputStream.close();
                byte[] byArray = simpleByteBuffer.getByteArray();
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
                XmlReader xmlReader = null;
                try {
                    xmlReader = new XmlReader(new BufferedReader(new InputStreamReader((InputStream)byteArrayInputStream, "ASCII")));
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    xmlReader = new XmlReader(new BufferedReader(new InputStreamReader(byteArrayInputStream)));
                }
                String string = null;
                while (true) {
                    int n2;
                    if ((n2 = xmlReader.read()) == -1) {
                        throw new Exception("<?xml> tag not found");
                    }
                    if (n2 != 60) continue;
                    if (xmlReader.found("?xml")) break;
                }
                String string2 = xmlReader.scanFor("?>");
                if (string2 == null) {
                    throw new Exception("<?xml> tag error");
                }
                int n3 = string2.indexOf("encoding=\"");
                if (n3 >= 0) {
                    int n4 = (string2 = string2.substring(n3 += "encoding=\"".length())).indexOf(34);
                    if (n4 < 0) {
                        throw new Exception("Closing bracket missing");
                    }
                    string = string2.substring(0, n4).toUpperCase();
                    if (string.equals("UTF-8")) {
                        string = "UTF8";
                    }
                }
                byteArrayInputStream = new ByteArrayInputStream(byArray);
                if (string == null) {
                    this.In = new BufferedReader(new InputStreamReader(byteArrayInputStream));
                    break block16;
                }
                try {
                    this.In = new BufferedReader(new InputStreamReader((InputStream)byteArrayInputStream, string));
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    try {
                        this.In = new BufferedReader(new InputStreamReader((InputStream)byteArrayInputStream, "ASCII"));
                    }
                    catch (UnsupportedEncodingException unsupportedEncodingException2) {
                        this.In = new BufferedReader(new InputStreamReader(byteArrayInputStream));
                    }
                }
            }
            catch (Exception exception) {
                throw new XmlReaderException(exception.toString());
            }
        }
    }

    public XmlTree scan() throws XmlReaderException {
        while (true) {
            int n;
            if ((n = this.read()) == -1) {
                return null;
            }
            if (n != 60) continue;
            if (this.found("?xml")) break;
        }
        String string = this.scanFor("?>");
        if (string == null) {
            return null;
        }
        XmlTree xmlTree = new XmlTree(new XmlTagRoot());
        xmlTree.addchild(new XmlTree(new XmlTagPI(string)));
        this.scanContent(xmlTree);
        return xmlTree;
    }

    public void scanContent(XmlTree xmlTree) throws XmlReaderException {
        while (true) {
            String string;
            if ((string = this.scanFor('<')) == null) {
                if (xmlTree.getTag() instanceof XmlTagRoot) {
                    return;
                }
                this.exception("File ended surprisingly");
            }
            if (!this.empty(string)) {
                xmlTree.addchild(new XmlTree(new XmlTagText(XmlTranslator.toText(string))));
            }
            if (this.found("!--")) {
                string = this.scanFor("-->");
                continue;
            }
            if (this.found("!")) {
                string = this.scanTagFor('>');
                continue;
            }
            if (this.found("?")) {
                string = this.scanTagFor("?>");
                xmlTree.addchild(new XmlTree(new XmlTagPI(string)));
                continue;
            }
            string = this.scanTagFor('>');
            if (string == null) {
                this.exception("> missing");
            }
            if (string.startsWith("/")) {
                if (string.substring(1).equals(xmlTree.getTag().name())) {
                    return;
                }
                this.exception("End tag without start tag");
            }
            if (string.endsWith("/")) {
                xmlTree.addchild(new XmlTree(new XmlTag(string.substring(0, string.length() - 1))));
                continue;
            }
            XmlTree xmlTree2 = new XmlTree(new XmlTag(string));
            this.scanContent(xmlTree2);
            xmlTree.addchild(xmlTree2);
        }
    }

    public boolean empty(String string) {
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            char c2 = string.charAt(i);
            if (c2 == ' ' || c2 == '\n' || c2 == '\t') continue;
            return false;
        }
        return true;
    }

    public int skipBlanks() throws XmlReaderException {
        int n;
        while ((n = this.read()) == 32 || n == 9 || n == 10) {
        }
        return n;
    }

    public String scanFor(char c2) throws XmlReaderException {
        this.buf.clear();
        int n = this.read();
        while (n != c2) {
            this.buf.append((char)n);
            n = this.read();
            if (n >= 0) continue;
            return null;
        }
        return this.buf.toString();
    }

    public String scanFor(String string) throws XmlReaderException {
        int n;
        this.buf.clear();
        while (!this.found(string)) {
            n = this.read();
            if (n < 0) {
                return null;
            }
            this.buf.append((char)n);
        }
        for (n = 0; n < string.length(); ++n) {
            this.read();
        }
        return this.buf.toString();
    }

    public String scanTagFor(char c2) throws XmlReaderException {
        this.buf.clear();
        int n = this.read();
        while (n != c2) {
            if (n == 34) {
                this.buf.append((char)n);
                while (true) {
                    if ((n = this.read()) < 0) {
                        return null;
                    }
                    if (n == 34) break;
                    this.buf.append((char)n);
                }
                this.buf.append((char)n);
            } else if (n == 39) {
                this.buf.append((char)n);
                while (true) {
                    if ((n = this.read()) < 0) {
                        return null;
                    }
                    if (n == 39) break;
                    this.buf.append((char)n);
                }
                this.buf.append((char)n);
            } else {
                this.buf.append((char)n);
            }
            if ((n = this.read()) >= 0) continue;
            return null;
        }
        return this.buf.toString();
    }

    public String scanTagFor(String string) throws XmlReaderException {
        int n;
        this.buf.clear();
        while (!this.found(string)) {
            n = this.read();
            if (n < 0) {
                return null;
            }
            if (n == 34) {
                this.buf.append((char)n);
                while (true) {
                    if ((n = this.read()) < 0) {
                        return null;
                    }
                    if (n == 34) break;
                    this.buf.append((char)n);
                }
                this.buf.append((char)n);
                continue;
            }
            if (n == 39) {
                this.buf.append((char)n);
                while (true) {
                    if ((n = this.read()) < 0) {
                        return null;
                    }
                    if (n == 39) break;
                    this.buf.append((char)n);
                }
                this.buf.append((char)n);
                continue;
            }
            this.buf.append((char)n);
        }
        for (n = 0; n < string.length(); ++n) {
            this.read();
        }
        return this.buf.toString();
    }

    public int read() throws XmlReaderException {
        try {
            if (this.Line == null) {
                this.Line = this.In.readLine();
                this.LinePos = 0;
            }
            if (this.Line == null) {
                return -1;
            }
            if (this.LinePos >= this.Line.length()) {
                this.Line = null;
                return 10;
            }
            return this.Line.charAt(this.LinePos++);
        }
        catch (Exception exception) {
            return -1;
        }
    }

    public boolean found(String string) {
        int n = string.length();
        if (this.LinePos + n > this.Line.length()) {
            return false;
        }
        for (int i = 0; i < n; ++i) {
            if (string.charAt(i) == this.Line.charAt(this.LinePos + i)) continue;
            return false;
        }
        return true;
    }

    public void exception(String string) throws XmlReaderException {
        throw new XmlReaderException(string, this.Line, this.LinePos);
    }

    public static void main(String[] stringArray) {
        try {
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream("rene\\util\\xml\\test.xml"), "UTF8"));
            XmlReader xmlReader = new XmlReader(bufferedReader);
            XmlTree xmlTree = xmlReader.scan();
            bufferedReader.close();
            XmlReader.print(xmlTree);
        }
        catch (XmlReaderException xmlReaderException) {
            System.out.println(xmlReaderException.toString() + "\n" + xmlReaderException.getLine() + "\n" + "Position : " + xmlReaderException.getPos());
        }
        catch (IOException iOException) {
            System.out.println(iOException);
        }
    }

    public static void print(XmlTree xmlTree) {
        XmlTag xmlTag = xmlTree.getTag();
        System.out.print("<" + xmlTag.name());
        for (int i = 0; i < xmlTag.countParams(); ++i) {
            System.out.print(" " + xmlTag.getParam(i) + "=\"" + xmlTag.getValue(i) + "\"");
        }
        System.out.println(">");
        for (ListElement listElement = xmlTree.children().first(); listElement != null; listElement = listElement.next()) {
            XmlReader.print((XmlTree)listElement.content());
        }
        System.out.println("</" + xmlTag.name() + ">");
    }

    public static boolean testXml(String string) {
        char c2;
        int n;
        for (n = 0; n < string.length() && (c2 = string.charAt(n)) != '<'; ++n) {
        }
        if (n >= string.length()) {
            return false;
        }
        return string.substring(n).startsWith("<?xml");
    }
}

