/*
 * Decompiled with CFR 0.152.
 */
package edu.hws.jcm.functions;

import edu.hws.jcm.awt.Controller;
import edu.hws.jcm.awt.JCMError;
import edu.hws.jcm.awt.VariableInput;
import edu.hws.jcm.data.NumUtils;
import edu.hws.jcm.draw.Axes;
import edu.hws.jcm.draw.CoordinateRect;
import edu.hws.jcm.draw.DisplayCanvas;
import edu.hws.jcm.draw.Drawable;
import edu.hws.jcm.functions.TableFunction;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Checkbox;
import java.awt.CheckboxGroup;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Label;
import java.awt.List;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;

public class TableFunctionInput
extends Panel
implements ItemListener,
ActionListener,
MouseListener,
MouseMotionListener {
    private VariableInput xInput;
    private VariableInput yInput;
    private DisplayCanvas canvas;
    private List pointList;
    private Button clearButton;
    private Button deleteButton;
    private Button addButton;
    private Checkbox[] styleCheckbox = new Checkbox[5];
    private CheckboxGroup styleGroup;
    private Controller onChange;
    private TableFunction function;
    private TableFunction editFunction;
    private int dragPoint = -1;
    private int startX;
    private int startY;
    private int prevY;
    private boolean moved;

    public TableFunctionInput() {
        this.xInput = new VariableInput();
        this.xInput.addActionListener(this);
        this.yInput = new VariableInput();
        this.yInput.addActionListener(this);
        this.pointList = new List();
        this.pointList.setBackground(Color.white);
        this.pointList.setFont(new Font("Monospaced", 0, 12));
        this.pointList.addItemListener(this);
        this.clearButton = new Button("Remove All Points");
        this.clearButton.addActionListener(this);
        this.deleteButton = new Button("Delete Point");
        this.deleteButton.setEnabled(false);
        this.deleteButton.addActionListener(this);
        this.addButton = new Button("Add/Modify Point");
        this.addButton.addActionListener(this);
        this.styleGroup = new CheckboxGroup();
        this.styleCheckbox[0] = new Checkbox("Smooth", true, this.styleGroup);
        this.styleCheckbox[1] = new Checkbox("Piecewise Linear", false, this.styleGroup);
        this.styleCheckbox[2] = new Checkbox("Step (nearest value)", false, this.styleGroup);
        this.styleCheckbox[3] = new Checkbox("Step (value from left)", false, this.styleGroup);
        this.styleCheckbox[4] = new Checkbox("Step (value from right)", false, this.styleGroup);
        int n = 0;
        while (n < 5) {
            this.styleCheckbox[n].addItemListener(this);
            ++n;
        }
        this.canvas = new DisplayCanvas(new CoordinateRect(-1.0, 1.0, -1.0, 1.0));
        this.canvas.add(new Axes());
        this.canvas.addMouseListener(this);
        this.canvas.addMouseMotionListener(this);
        this.function = new TableFunction();
        this.canvas.add(new Draw());
        Font font = new Font("Serif", 1, 12);
        Label label = new Label("Input Area");
        label.setForeground(Color.red);
        label.setFont(font);
        Label label2 = new Label("Type of Function", 1);
        label2.setForeground(Color.red);
        label2.setFont(font);
        Label label3 = new Label("Table of Values", 1);
        label3.setForeground(Color.red);
        label3.setFont(font);
        Panel panel = new Panel();
        panel.setLayout(new FlowLayout(1, 10000, 3));
        Panel panel2 = new Panel();
        panel2.setLayout(new GridLayout(6, 1, 3, 3));
        Panel panel3 = new Panel();
        panel3.setLayout(new BorderLayout());
        Panel panel4 = new Panel();
        panel4.setLayout(new BorderLayout(3, 3));
        panel4.add((Component)panel, "Center");
        panel4.add((Component)panel2, "East");
        this.setLayout(new BorderLayout(3, 3));
        this.add((Component)panel4, "North");
        this.add((Component)panel3, "West");
        this.add((Component)this.canvas, "Center");
        this.setBackground(Color.darkGray);
        panel.setBackground(Color.lightGray);
        panel2.setBackground(Color.lightGray);
        panel3.setBackground(Color.lightGray);
        Panel panel5 = new Panel();
        panel5.add(new Label("x = "));
        panel5.add(this.xInput);
        panel5.add(new Label(" y = "));
        panel5.add(this.yInput);
        Panel panel6 = new Panel();
        panel6.setLayout(new GridLayout(1, 2, 3, 3));
        panel6.add(this.deleteButton);
        panel6.add(this.clearButton);
        panel.add(label);
        panel.add(panel5);
        panel.add(this.addButton);
        panel.add(new Label("(Press RETURN in X to move to Y)"));
        panel.add(new Label("(Press RETURN in Y to add/modify point)"));
        panel2.add(label2);
        int n2 = 0;
        while (n2 < 5) {
            panel2.add(this.styleCheckbox[n2]);
            ++n2;
        }
        panel3.add((Component)this.pointList, "Center");
        panel3.add((Component)label3, "North");
        panel3.add((Component)panel6, "South");
    }

    public void startEdit(TableFunction tableFunction) {
        this.editFunction = tableFunction;
        this.revertEditFunction();
    }

    public void revertEditFunction() {
        if (this.editFunction == null) {
            this.clearAllPoints();
            return;
        }
        this.function.copyDataFrom(this.editFunction);
        this.pointList.removeAll();
        int n = this.function.getPointCount();
        int n2 = 0;
        while (n2 < n) {
            this.pointList.add(this.makePointString(this.function.getX(n2), this.function.getY(n2)));
            ++n2;
        }
        this.styleGroup.setSelectedCheckbox(this.styleCheckbox[this.function.getStyle()]);
        this.checkCanvas();
        if (this.onChange != null) {
            this.onChange.compute();
        }
    }

    public TableFunction finishEdit() {
        TableFunction tableFunction;
        if (this.editFunction == null) {
            tableFunction = this.copyOfCurrentFunction();
        } else {
            this.editFunction.copyDataFrom(this.function);
            tableFunction = this.editFunction;
            this.editFunction = null;
        }
        return tableFunction;
    }

    public void cancelEdit() {
        this.editFunction = null;
    }

    public TableFunction copyOfCurrentFunction() {
        TableFunction tableFunction = new TableFunction();
        tableFunction.copyDataFrom(this.function);
        tableFunction.setName(this.function.getName());
        return tableFunction;
    }

    public void setOnChange(Controller controller) {
        this.onChange = controller;
    }

    public Controller getOnChange() {
        return this.onChange;
    }

    private void deletePoint() {
        int n = this.pointList.getSelectedIndex();
        if (n >= 0) {
            this.pointList.remove(n);
            this.function.removePointAt(n);
            this.checkCanvas();
            if (this.onChange != null) {
                this.onChange.compute();
            }
        }
        this.deleteButton.setEnabled(false);
    }

    private void clearAllPoints() {
        this.function.removeAllPoints();
        this.pointList.removeAll();
        this.deleteButton.setEnabled(false);
        if (this.onChange != null) {
            this.onChange.compute();
        }
        this.checkCanvas();
    }

    private void addPoint() {
        double d;
        double d2;
        try {
            this.xInput.checkInput();
            d2 = this.xInput.getVal();
        }
        catch (JCMError jCMError) {
            this.canvas.setErrorMessage(null, "The input for x does is not a legal real number.");
            this.xInput.requestFocus();
            this.xInput.selectAll();
            return;
        }
        try {
            this.yInput.checkInput();
            d = this.yInput.getVal();
        }
        catch (JCMError jCMError) {
            this.canvas.setErrorMessage(null, "The input for y does is not a legal real number.");
            this.yInput.requestFocus();
            this.yInput.selectAll();
            return;
        }
        String string = this.makePointString(d2, d);
        int n = this.function.findPoint(d2);
        if (n >= 0 && d == this.function.getY(n)) {
            this.xInput.requestFocus();
            this.xInput.selectAll();
            return;
        }
        int n2 = this.function.addPoint(d2, d);
        if (n >= 0) {
            this.pointList.replaceItem(string, n);
        } else {
            this.pointList.addItem(string, n2);
        }
        this.deleteButton.setEnabled(this.pointList.getSelectedIndex() != -1);
        this.checkCanvas();
        if (this.onChange != null) {
            this.onChange.compute();
        }
        this.xInput.requestFocus();
        this.xInput.selectAll();
    }

    private String makePointString(double d, double d2) {
        String string = NumUtils.realToString(d);
        String string2 = NumUtils.realToString(d2);
        if (string.length() < 11) {
            string = String.valueOf("            ".substring(0, 11 - string.length())) + string;
        }
        if (string2.length() < 11) {
            string2 = String.valueOf("            ".substring(0, 11 - string2.length())) + string2;
        }
        return String.valueOf(string) + " " + string2;
    }

    private void selectPoint() {
        int n = this.pointList.getSelectedIndex();
        if (n >= 0) {
            this.xInput.setVal(this.function.getX(n));
            this.yInput.setVal(this.function.getY(n));
            this.yInput.requestFocus();
            this.yInput.selectAll();
        }
        this.deleteButton.setEnabled(n >= 0);
    }

    private void changeStyle() {
        int n = 0;
        Checkbox checkbox = this.styleGroup.getSelectedCheckbox();
        int n2 = 1;
        while (n2 < 5) {
            if (checkbox == this.styleCheckbox[n2]) {
                n = n2;
            }
            ++n2;
        }
        if (this.function.getStyle() == n) {
            return;
        }
        this.function.setStyle(n);
        this.canvas.doRedraw();
        if (this.onChange != null) {
            this.onChange.compute();
        }
    }

    private void checkCanvas() {
        double d;
        int n = this.function.getPointCount();
        double d2 = -1.0;
        double d3 = 1.0;
        double d4 = -1.0;
        double d5 = 1.0;
        if (n > 0) {
            if (n == 1) {
                d2 = this.function.getX(0);
                if (Math.abs(d2) < 10000.0) {
                    d3 = d2 + 1.0;
                    d2 -= 1.0;
                } else {
                    d3 = d2 - Math.abs(d2) / 10.0;
                    d2 -= Math.abs(d2) / 10.0;
                }
            } else {
                d2 = this.function.getX(0);
                d3 = this.function.getX(n - 1);
            }
            d5 = d4 = this.function.getY(0);
            int n2 = 1;
            while (n2 < n) {
                d = this.function.getY(n2);
                if (d < d4) {
                    d4 = d;
                } else if (d > d5) {
                    d5 = d;
                }
                ++n2;
            }
            d = Math.abs(d4 - d5);
            if (d < 1.0E-10 && Math.abs(d4) < 10000.0 && Math.abs(d5) < 10000.0) {
                d5 += 1.0;
                d4 -= 1.0;
            } else {
                d5 += d * 0.15;
                d4 -= d * 0.15;
            }
        }
        CoordinateRect coordinateRect = this.canvas.getCoordinateRect(0);
        d = Math.abs(coordinateRect.getYmin() - coordinateRect.getYmax());
        double d6 = Math.abs(d5 - d4);
        if (d3 != coordinateRect.getXmax() || d2 != coordinateRect.getXmin() || d6 > 1.3 * d || d6 < 0.5 * d || d5 > coordinateRect.getYmax() - 0.1 * d || d4 < coordinateRect.getYmin() + 0.1 * d) {
            coordinateRect.setLimits(d2, d3, d4, d5);
        }
        this.canvas.doRedraw();
    }

    public Insets getInsets() {
        return new Insets(3, 3, 3, 3);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.deleteButton) {
            this.deletePoint();
        } else if (object == this.clearButton) {
            this.clearAllPoints();
        } else if (object == this.xInput) {
            this.yInput.requestFocus();
            this.yInput.selectAll();
        } else {
            this.addPoint();
        }
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getSource() == this.pointList) {
            this.selectPoint();
        } else {
            this.changeStyle();
        }
    }

    public void mousePressed(MouseEvent mouseEvent) {
        this.dragPoint = -1;
        this.moved = false;
        int n = this.function.getPointCount();
        CoordinateRect coordinateRect = this.canvas.getCoordinateRect(0);
        int n2 = 0;
        while (n2 < n) {
            int n3 = coordinateRect.xToPixel(this.function.getX(n2));
            int n4 = coordinateRect.yToPixel(this.function.getY(n2));
            if (mouseEvent.getX() >= n3 - 3 && mouseEvent.getX() <= n3 + 3 && mouseEvent.getY() >= n4 - 3 && mouseEvent.getY() <= n4 + 3) {
                this.startX = mouseEvent.getX();
                this.prevY = this.startY = mouseEvent.getY();
                this.pointList.deselect(this.pointList.getSelectedIndex());
                this.pointList.select(n2);
                this.selectPoint();
                this.dragPoint = n2;
                return;
            }
            ++n2;
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        if (this.dragPoint == -1) {
            return;
        }
        if (!this.moved) {
            this.dragPoint = -1;
            return;
        }
        this.mouseDragged(mouseEvent);
        this.pointList.replaceItem(this.makePointString(this.function.getX(this.dragPoint), this.function.getY(this.dragPoint)), this.dragPoint);
        this.pointList.select(this.dragPoint);
        this.dragPoint = -1;
        if (this.onChange != null) {
            this.onChange.compute();
        }
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        CoordinateRect coordinateRect;
        if (this.dragPoint == -1 || this.prevY == mouseEvent.getY()) {
            return;
        }
        if (!this.moved && Math.abs(mouseEvent.getY() - this.startY) < 3) {
            return;
        }
        this.moved = true;
        int n = mouseEvent.getY();
        if (n < (coordinateRect = this.canvas.getCoordinateRect(0)).getTop() + 4) {
            n = coordinateRect.getTop() + 4;
        } else if (n > coordinateRect.getTop() + coordinateRect.getHeight() - 4) {
            n = coordinateRect.getTop() + coordinateRect.getHeight() - 4;
        }
        if (Math.abs(mouseEvent.getX() - this.startX) > 72) {
            n = this.startY;
        }
        if (n == this.prevY) {
            return;
        }
        this.prevY = n;
        this.function.setY(this.dragPoint, coordinateRect.pixelToY(this.prevY));
        this.yInput.setVal(this.function.getY(this.dragPoint));
        this.canvas.doRedraw();
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mouseMoved(MouseEvent mouseEvent) {
    }

    private class Draw
    extends Drawable {
        public void draw(Graphics graphics, boolean bl) {
            int n;
            int n2;
            int n3;
            double d;
            double d2;
            int n4 = TableFunctionInput.this.function.getPointCount();
            if (n4 == 0) {
                return;
            }
            graphics.setColor(Color.magenta);
            switch (TableFunctionInput.this.function.getStyle()) {
                case 0: {
                    int n5;
                    double d3;
                    double d4;
                    int n6;
                    if (n4 <= 1) break;
                    try {
                        d2 = TableFunctionInput.this.function.getX(0);
                        d = TableFunctionInput.this.function.getVal(d2);
                        n3 = this.coords.xToPixel(d2);
                        n2 = this.coords.yToPixel(d);
                        n = this.coords.xToPixel(TableFunctionInput.this.function.getX(n4 - 1));
                        n6 = n3;
                        while (n6 < n) {
                            if ((n6 += 3) > n) {
                                n6 = n;
                            }
                            d4 = this.coords.pixelToX(n6);
                            d3 = TableFunctionInput.this.function.getVal(d4);
                            n5 = this.coords.yToPixel(d3);
                            graphics.drawLine(n3, n2, n6, n5);
                            n3 = n6;
                            n2 = n5;
                        }
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                    break;
                }
                case 1: {
                    int n5;
                    double d3;
                    double d4;
                    int n6;
                    d2 = TableFunctionInput.this.function.getX(0);
                    n3 = this.coords.xToPixel(d2);
                    d = TableFunctionInput.this.function.getY(0);
                    n2 = this.coords.yToPixel(d);
                    int n7 = 1;
                    while (n7 < n4) {
                        d4 = TableFunctionInput.this.function.getX(n7);
                        n6 = this.coords.xToPixel(d4);
                        d3 = TableFunctionInput.this.function.getY(n7);
                        n5 = this.coords.yToPixel(d3);
                        graphics.drawLine(n3, n2, n6, n5);
                        n3 = n6;
                        n2 = n5;
                        ++n7;
                    }
                    break;
                }
                case 2: {
                    double d4;
                    int n6;
                    d2 = TableFunctionInput.this.function.getX(0);
                    n3 = this.coords.xToPixel(d2);
                    int n8 = 0;
                    while (n8 < n4) {
                        if (n8 < n4 - 1) {
                            double d5 = TableFunctionInput.this.function.getX(n8 + 1);
                            d4 = (d2 + d5) / 2.0;
                            d2 = d5;
                        } else {
                            d4 = d2;
                        }
                        n6 = this.coords.xToPixel(d4);
                        d = TableFunctionInput.this.function.getY(n8);
                        n2 = this.coords.yToPixel(d);
                        graphics.drawLine(n3, n2, n6, n2);
                        n3 = n6;
                        ++n8;
                    }
                    break;
                }
                case 3: {
                    double d4;
                    int n6;
                    d2 = TableFunctionInput.this.function.getX(0);
                    n3 = this.coords.xToPixel(d2);
                    int n9 = 1;
                    while (n9 < n4) {
                        d4 = TableFunctionInput.this.function.getX(n9);
                        n6 = this.coords.xToPixel(d4);
                        d = TableFunctionInput.this.function.getY(n9 - 1);
                        n2 = this.coords.yToPixel(d);
                        graphics.drawLine(n3, n2, n6, n2);
                        n3 = n6;
                        ++n9;
                    }
                    break;
                }
                case 4: {
                    double d4;
                    int n6;
                    d2 = TableFunctionInput.this.function.getX(0);
                    n3 = this.coords.xToPixel(d2);
                    int n10 = 1;
                    while (n10 < n4) {
                        d4 = TableFunctionInput.this.function.getX(n10);
                        n6 = this.coords.xToPixel(d4);
                        d = TableFunctionInput.this.function.getY(n10);
                        n2 = this.coords.yToPixel(d);
                        graphics.drawLine(n3, n2, n6, n2);
                        n3 = n6;
                        ++n10;
                    }
                    break;
                }
            }
            n = 0;
            while (n < n4) {
                d2 = TableFunctionInput.this.function.getX(n);
                d = TableFunctionInput.this.function.getY(n);
                n3 = this.coords.xToPixel(d2);
                n2 = this.coords.yToPixel(d);
                graphics.fillOval(n3 - 2, n2 - 2, 5, 5);
                ++n;
            }
        }

        Draw() {
        }
    }
}

