/*
 * Decompiled with CFR 0.152.
 */
package edu.hws.jcm.data;

import edu.hws.jcm.data.ConditionalExpression;
import edu.hws.jcm.data.Constant;
import edu.hws.jcm.data.ExpressionCommand;
import edu.hws.jcm.data.ExpressionProgram;
import edu.hws.jcm.data.MathObject;
import edu.hws.jcm.data.ParseError;
import edu.hws.jcm.data.ParserContext;
import edu.hws.jcm.data.ParserExtension;
import edu.hws.jcm.data.StandardFunction;
import edu.hws.jcm.data.SymbolTable;
import edu.hws.jcm.data.Variable;
import java.io.Serializable;

public class Parser
implements Serializable {
    public static final int CASE_SENSITIVE = 1;
    public static final int OPTIONAL_STARS = 2;
    public static final int OPTIONAL_SPACES = 4;
    public static final int BRACKETS = 8;
    public static final int BRACES = 16;
    public static final int BOOLEANS = 32;
    public static final int FACTORIAL = 64;
    public static final int NO_UNDERSCORE_IN_IDENTIFIERS = 128;
    public static final int NO_DIGITS_IN_IDENTIFIERS = 256;
    public static final int OPTIONAL_PARENS = 512;
    public static final int STANDARD_FUNCTIONS = 1024;
    public static final int DEFAULT_OPTIONS = 1056;
    protected int options;
    protected SymbolTable symbols;

    public Parser() {
        this(null, 1056);
    }

    public Parser(Parser parser) {
        this(parser, 0);
    }

    public Parser(int n) {
        this(null, n);
    }

    public Parser(Parser parser, int n) {
        if (parser == null) {
            this.symbols = new SymbolTable();
            this.symbols.add(new Constant("e", Math.E));
            this.symbols.add(new Constant("pi", Math.PI));
        } else {
            this.symbols = new SymbolTable(parser.symbols);
            this.options = parser.options;
        }
        this.addOptions(n);
    }

    public void addOptions(int n) {
        if ((n & 0x400) != 0 && (this.options & 0x400) == 0) {
            int n2 = -36;
            while (n2 <= -17) {
                this.symbols.add(new StandardFunction(n2));
                ++n2;
            }
        }
        this.options |= n;
    }

    public ExpressionProgram parse(String string) {
        ParserContext parserContext = new ParserContext(string, this.options, this.symbols);
        if (string == null) {
            throw new ParseError("Can't parse a null string.", parserContext);
        }
        if (parserContext.look() == 1) {
            throw new ParseError("Can't parse an empty string.", parserContext);
        }
        boolean bl = (this.options & 0x20) != 0 ? this.parseLogicalExpression(parserContext) : this.parseExpression(parserContext);
        if (parserContext.look() != 1) {
            throw new ParseError("Extra data found after the end of a complete legal expression.", parserContext);
        }
        if (bl) {
            throw new ParseError("Found a logical-valued expression instead of a numeric expression.", parserContext);
        }
        parserContext.prog.trim();
        parserContext.prog.sourceString = string;
        return parserContext.prog;
    }

    public ExpressionProgram parseLogical(String string) {
        if ((this.options & 0x20) == 0) {
            throw new IllegalArgumentException("Internal Error:  Attempt to parse a logical-valued expression, but BOOLEANS option is not turned on.");
        }
        ParserContext parserContext = new ParserContext(string, this.options, this.symbols);
        if (string == null) {
            throw new ParseError("Can't parse a null string.", parserContext);
        }
        if (parserContext.look() == 1) {
            throw new ParseError("Can't parse an empty string.", parserContext);
        }
        boolean bl = this.parseLogicalExpression(parserContext);
        if (parserContext.look() != 1) {
            throw new ParseError("Extra data found after the end of a complete legal expression.", parserContext);
        }
        if (!bl) {
            throw new ParseError("Found a numeric-valued expression instead of a logical expression.", parserContext);
        }
        parserContext.prog.trim();
        return parserContext.prog;
    }

    public MathObject get(String string) {
        if ((this.options & 1) != 0) {
            return this.symbols.get(string);
        }
        return this.symbols.get(string.toLowerCase());
    }

    public void add(MathObject mathObject) {
        if ((this.options & 1) != 0) {
            this.symbols.add(mathObject);
        } else {
            this.symbols.add(mathObject.getName().toLowerCase(), mathObject);
        }
    }

    public void remove(String string) {
        if (string == null) {
            return;
        }
        if ((this.options & 1) != 0) {
            this.symbols.remove(string);
        } else {
            this.symbols.remove(string.toLowerCase());
        }
    }

    /*
     * Unable to fully structure code
     */
    public boolean parseLogicalExpression(ParserContext var1_1) {
        var2_2 = this.parseLogicalTerm(var1_1);
        var3_3 = var1_1.look();
        if (var3_3 != 4 || !var1_1.tokenString.equals("&") || var2_2) ** GOTO lbl11
        throw new ParseError("The AND operator can only be used with logical expressions.", var1_1);
lbl-1000:
        // 1 sources

        {
            var1_1.next();
            if (!this.parseLogicalTerm(var1_1)) {
                throw new ParseError("The AND operator can only be used with logical expressions.", var1_1);
            }
            var1_1.prog.addCommand(-12);
            var3_3 = var1_1.look();
lbl11:
            // 2 sources

            ** while (var3_3 == 4 && var1_1.tokenString.equals((Object)"&"))
        }
lbl12:
        // 1 sources

        if (var3_3 == 4 && var1_1.tokenString.equals("?")) {
            if (!var2_2) {
                throw new ParseError("The conditional operator, ?, can only be applied to a logical-valued expression.", var1_1);
            }
            var6_4 = var1_1.prog;
            var1_1.next();
            var1_1.prog = var4_5 = new ExpressionProgram();
            if (this.parseLogicalExpression(var1_1)) {
                throw new ParseError("The cases in a conditional expression cannot be logical-valued expressions.", var1_1);
            }
            var3_3 = var1_1.look();
            if (var3_3 == 4 && var1_1.tokenString.equals(":")) {
                var1_1.next();
                var1_1.prog = var5_6 = new ExpressionProgram();
                if (this.parseLogicalExpression(var1_1)) {
                    throw new ParseError("The cases in a conditional expression cannot be logical-valued expressions.", var1_1);
                }
            } else {
                var5_6 = null;
            }
            var1_1.prog = var6_4;
            var1_1.prog.addCommandObject(new ConditionalExpression(var4_5, var5_6));
            return false;
        }
        return var2_2;
    }

    /*
     * Unable to fully structure code
     */
    public boolean parseLogicalTerm(ParserContext var1_1) {
        var2_2 = this.parseLogicalFactor(var1_1);
        var3_3 = var1_1.look();
        if (var3_3 != 4 || !var1_1.tokenString.equals("|") || var2_2) ** GOTO lbl11
        throw new ParseError("The OR operator can only be used with logical expressions.", var1_1);
lbl-1000:
        // 1 sources

        {
            var1_1.next();
            if (!this.parseLogicalFactor(var1_1)) {
                throw new ParseError("The OR operator can only be used with logical expressions.", var1_1);
            }
            var1_1.prog.addCommand(-13);
            var3_3 = var1_1.look();
lbl11:
            // 2 sources

            ** while (var3_3 == 4 && var1_1.tokenString.equals((Object)"|"))
        }
lbl12:
        // 1 sources

        return var2_2;
    }

    public boolean parseLogicalFactor(ParserContext parserContext) {
        int n = parserContext.look();
        int n2 = 0;
        while (n == 4 && parserContext.tokenString.equals("~")) {
            parserContext.next();
            n = parserContext.look();
            ++n2;
        }
        boolean bl = this.parseRelation(parserContext);
        if (n2 > 0 && !bl) {
            throw new ParseError("The NOT operator can only be used with logical expressions.", parserContext);
        }
        if (n2 % 2 == 1) {
            parserContext.prog.addCommand(-14);
        }
        return bl;
    }

    public boolean parseRelation(ParserContext parserContext) {
        boolean bl = this.parseExpression(parserContext);
        int n = parserContext.look();
        if (n != 4) {
            return bl;
        }
        int n2 = 0;
        if (parserContext.tokenString.equals("=")) {
            n2 = -6;
        } else if (parserContext.tokenString.equals("<")) {
            n2 = -8;
        } else if (parserContext.tokenString.equals(">")) {
            n2 = -9;
        } else if (parserContext.tokenString.equals("<=")) {
            n2 = -10;
        } else if (parserContext.tokenString.equals(">=")) {
            n2 = -11;
        } else if (parserContext.tokenString.equals("<>")) {
            n2 = -7;
        }
        if (n2 == 0) {
            return bl;
        }
        if (bl) {
            throw new ParseError("A relational operator can only be used with numerical expressions.", parserContext);
        }
        parserContext.next();
        if (this.parseExpression(parserContext)) {
            throw new ParseError("A relational operator can only be used with numerical expressions.", parserContext);
        }
        n = parserContext.look();
        if (n == 4 && (parserContext.tokenString.equals("=") || parserContext.tokenString.equals("<") || parserContext.tokenString.equals(">") || parserContext.tokenString.equals("<=") || parserContext.tokenString.equals(">=") || parserContext.tokenString.equals("<>"))) {
            throw new ParseError("It is illegal to string together relations operators; use \"AND\" instead.", parserContext);
        }
        parserContext.prog.addCommand(n2);
        return true;
    }

    /*
     * Unable to fully structure code
     */
    public boolean parseExpression(ParserContext var1_1) {
        var2_2 = false;
        var3_3 = var1_1.look();
        if (var3_3 == 4 && (var1_1.tokenString.equals("+") || var1_1.tokenString.equals("-"))) {
            var2_2 = var1_1.tokenString.equals("-");
            var1_1.next();
        }
        var4_4 = this.parseTerm(var1_1);
        if (var2_2) {
            if (var4_4) {
                throw new ParseError("A unary + or - cannot be applied to a logical expression.", var1_1);
            }
            var1_1.prog.addCommand(-15);
        }
        if ((var3_3 = var1_1.look()) != 4 || !var1_1.tokenString.equals("+") && !var1_1.tokenString.equals("-") || !var4_4) ** GOTO lbl21
        throw new ParseError("A + or - operator cannot be applied to logical operands.", var1_1);
lbl-1000:
        // 1 sources

        {
            var1_1.next();
            v0 = var5_5 = var1_1.tokenString.equals("+") != false ? -1 : -2;
            if (this.parseTerm(var1_1)) {
                throw new ParseError("A + or - operator cannot be applied to logical operands.", var1_1);
            }
            var1_1.prog.addCommand(var5_5);
            var3_3 = var1_1.look();
lbl21:
            // 2 sources

            ** while (var3_3 == 4 && (var1_1.tokenString.equals((Object)"+") || var1_1.tokenString.equals((Object)"-")))
        }
lbl22:
        // 1 sources

        return var4_4;
    }

    /*
     * Unable to fully structure code
     */
    public boolean parseTerm(ParserContext var1_1) {
        var2_2 = false;
        var3_3 = this.parsePrimary(var1_1);
        var4_4 = var1_1.look();
        var5_5 = var1_1.tokenString;
        v0 = var2_2 = var3_3 == false && (this.options & 2) != 0 && (var4_4 == 2 || var4_4 == 3 || var4_4 == 4 && (var5_5.equals("(") != false || var5_5.equals("[") != false || var5_5.equals("{") != false));
        if (var4_4 != 4 || !var5_5.equals("*") && !var5_5.equals("/") || !var3_3) ** GOTO lbl18
        throw new ParseError("A * or / operator cannot be applied to logical operands.", var1_1);
lbl-1000:
        // 1 sources

        {
            if (!var2_2) {
                var1_1.next();
            }
            v1 = var6_6 = var2_2 != false || var5_5.equals("*") != false ? -3 : -4;
            if (this.parsePrimary(var1_1)) {
                throw new ParseError("A * or / operator cannot be applied to logical operands.", var1_1);
            }
            var1_1.prog.addCommand(var6_6);
            var4_4 = var1_1.look();
            var5_5 = var1_1.tokenString;
            v2 = var2_2 = var3_3 == false && (this.options & 2) != 0 && (var4_4 == 2 || var4_4 == 3 || var4_4 == 4 && (var5_5.equals("(") != false || var5_5.equals("[") != false || var5_5.equals("{") != false));
lbl18:
            // 2 sources

            ** while (var2_2 || var4_4 == 4 && (var5_5.equals((Object)"*") || var5_5.equals((Object)"/")))
        }
lbl19:
        // 1 sources

        return var3_3;
    }

    public boolean parsePrimary(ParserContext parserContext) {
        boolean bl = this.parseFactor(parserContext);
        int n = parserContext.look();
        if (n == 4 && parserContext.tokenString.equals("^")) {
            if (bl) {
                throw new ParseError("The exponentiation operator cannot be applied to logical operands.", parserContext);
            }
            parserContext.next();
            if (this.parsePrimary(parserContext)) {
                throw new ParseError("The exponentiation operator cannot be applied to logical operands.", parserContext);
            }
            parserContext.prog.addCommand(-5);
        }
        return bl;
    }

    public boolean parseFactor(ParserContext parserContext) {
        boolean bl = false;
        int n = parserContext.next();
        if (n == 2) {
            parserContext.prog.addConstant(parserContext.tokenValue);
        } else if (n == 3) {
            this.parseWord(parserContext);
        } else {
            if (n == 1) {
                throw new ParseError("Data ended in the middle of an incomplete expression.", parserContext);
            }
            if (n != 4) {
                throw new ParseError("Internal error:  Unknown token type.", parserContext);
            }
            if (parserContext.tokenString.equals("(")) {
                bl = this.parseGroup('(', ')', parserContext);
            } else if (parserContext.tokenString.equals("[") && (this.options & 8) != 0) {
                bl = this.parseGroup('[', ']', parserContext);
            } else if (parserContext.tokenString.equals("{") && (this.options & 0x10) != 0) {
                bl = this.parseGroup('{', '}', parserContext);
            } else {
                if (parserContext.tokenString.equals("}") && (this.options & 0x10) != 0) {
                    throw new ParseError("Misplaced right brace with no matching left brace.", parserContext);
                }
                if (parserContext.tokenString.equals("]") && (this.options & 8) != 0) {
                    throw new ParseError("Misplaced right bracket with no matching left bracket.", parserContext);
                }
                if (parserContext.tokenString.equals(")")) {
                    throw new ParseError("Misplaced right parenthesis with no matching left parenthesis.", parserContext);
                }
                throw new ParseError("Illegal or misplaced character \"" + parserContext.tokenString.charAt(0) + "\"", parserContext);
            }
        }
        if ((this.options & 0x40) != 0) {
            n = parserContext.look();
            while (n == 4 && parserContext.tokenString.equals("!")) {
                if (bl) {
                    throw new ParseError("The factorial operator cannot be applied to a logical value.", parserContext);
                }
                parserContext.next();
                parserContext.prog.addCommand(-16);
                n = parserContext.look();
            }
        }
        return bl;
    }

    private boolean parseGroup(char c, char c2, ParserContext parserContext) {
        boolean bl = (this.options & 0x20) == 0 ? this.parseExpression(parserContext) : this.parseLogicalExpression(parserContext);
        int n = parserContext.look();
        if (n != 4 || !parserContext.tokenString.equals(String.valueOf(c2))) {
            throw new ParseError("Missing \"" + c2 + "\" to match a previous \"" + c + "\".", parserContext);
        }
        parserContext.next();
        return bl;
    }

    private void parseWord(ParserContext parserContext) {
        if (parserContext.tokenObject == null) {
            throw new ParseError("Unknown word \"" + parserContext.tokenString + "\" encountered in an expression.", parserContext);
        }
        if (parserContext.tokenObject instanceof Variable || parserContext.tokenObject instanceof Constant) {
            parserContext.prog.addCommandObject((ExpressionCommand)((Object)parserContext.tokenObject));
        } else if (parserContext.tokenObject instanceof StandardFunction) {
            StandardFunction standardFunction = (StandardFunction)parserContext.tokenObject;
            int n = parserContext.look();
            if (n == 4 && (parserContext.tokenString.equals("(") || parserContext.tokenString.equals("[") && (this.options & 8) != 0 || parserContext.tokenString.equals("{") && (this.options & 0x10) != 0)) {
                parserContext.next();
                boolean bl = parserContext.tokenString.equals("(") ? this.parseGroup('(', ')', parserContext) : (parserContext.tokenString.equals("[") ? this.parseGroup('[', ']', parserContext) : this.parseGroup('{', '}', parserContext));
                if (bl) {
                    throw new ParseError("The argument of a function must be a numerical expression.", parserContext);
                }
            } else {
                if ((this.options & 0x200) == 0) {
                    throw new ParseError("Parentheses required around argument of standard function \"" + standardFunction.getName() + "\".", parserContext);
                }
                if (this.parseTerm(parserContext)) {
                    throw new ParseError("The argument of a function must be a numerical expression.", parserContext);
                }
            }
            parserContext.prog.addCommand(standardFunction.getOpCode());
        } else if (parserContext.tokenObject instanceof ParserExtension) {
            ((ParserExtension)parserContext.tokenObject).doParse(this, parserContext);
        } else {
            if (!(parserContext.tokenObject instanceof ExpressionCommand)) {
                throw new ParseError("Unexpected word \"" + parserContext.tokenObject.getName() + "\" encountered in an expression.", parserContext);
            }
            throw new ParseError("Unimplemented word \"" + parserContext.tokenObject.getName() + "\" encountered in an expression.", parserContext);
        }
    }
}

