/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.shape;

import java.util.BitSet;
import java.util.Vector;
import javax.vecmath.Point3f;
import javax.vecmath.Vector3f;
import org.jmol.api.JmolRendererInterface;
import org.jmol.g3d.Graphics3D;
import org.jmol.util.ArrayUtil;
import org.jmol.util.Escape;

public class Mesh {
    public static final String PREVIOUS_MESH_ID = "+PREVIOUS_MESH+";
    private JmolRendererInterface g3d;
    public String[] title = null;
    public String thisID;
    public boolean isValid = true;
    public String scriptCommand;
    public String colorCommand;
    public boolean visible = true;
    public short colix;
    public int vertexCount;
    public Point3f[] vertices;
    public short[] normixes;
    public int polygonCount;
    public int[][] polygonIndexes = null;
    public float scale = 1.0f;
    public boolean haveXyPoints;
    public int diameter;
    public float width;
    public Point3f ptCenter = new Point3f(0.0f, 0.0f, 0.0f);
    public String meshType = null;
    public Mesh linkedMesh = null;
    public BitSet[] bitsets;
    public int atomIndex = -1;
    public int modelIndex = -1;
    public int visibilityFlags;
    public boolean insideOut;
    public boolean showContourLines = false;
    public boolean showPoints = false;
    public boolean drawTriangles = false;
    public boolean fillTriangles = true;
    public boolean showTriangles = false;
    public boolean frontOnly = false;
    public boolean isTwoSided = true;
    public boolean isColorSolid = true;
    public boolean havePlanarContours = false;
    public static final int SEED_COUNT = 25;
    public int lighting = 67108883;
    public final Vector3f vAB = new Vector3f();
    public final Vector3f vAC = new Vector3f();
    public final Vector3f vTemp = new Vector3f();
    protected boolean haveCheckByte;
    public Vector data1;
    public Vector data2;

    public void setVisibilityFlags(int n) {
        this.visibilityFlags = n;
    }

    public Mesh() {
    }

    public Mesh(String string, JmolRendererInterface jmolRendererInterface, short s) {
        if (PREVIOUS_MESH_ID.equals(string)) {
            string = null;
        }
        this.thisID = string;
        this.g3d = jmolRendererInterface;
        this.colix = s;
    }

    public void clear(String string) {
        this.polygonCount = 0;
        this.vertexCount = 0;
        this.scale = 1.0f;
        this.vertices = null;
        this.polygonIndexes = null;
        this.havePlanarContours = false;
        this.showPoints = false;
        this.showContourLines = false;
        this.drawTriangles = false;
        this.fillTriangles = true;
        this.showTriangles = false;
        this.frontOnly = false;
        this.meshType = string;
    }

    public void initialize(int n) {
        Vector3f[] vector3fArray = this.getVertexNormals();
        this.normixes = new short[this.vertexCount];
        this.initializeNormixes(n, vector3fArray);
    }

    public Vector3f[] getVertexNormals() {
        Vector3f[] vector3fArray = new Vector3f[this.vertexCount];
        int n = this.vertexCount;
        while (--n >= 0) {
            vector3fArray[n] = new Vector3f();
        }
        this.sumVertexNormals(vector3fArray);
        n = this.vertexCount;
        while (--n >= 0) {
            vector3fArray[n].normalize();
        }
        return vector3fArray;
    }

    public void initializeNormixes(int n, Vector3f[] vector3fArray) {
        this.isTwoSided = n == 67108885;
        this.normixes = new short[this.vertexCount];
        int n2 = this.vertexCount;
        while (--n2 >= 0) {
            this.normixes[n2] = this.g3d.getNormix(vector3fArray[n2]);
        }
        this.lighting = 67108883;
        if (this.insideOut) {
            this.invertNormixes();
        }
        this.setLighting(n);
    }

    public void setLighting(int n) {
        if (n == this.lighting) {
            return;
        }
        this.flipLighting(this.lighting);
        this.lighting = n;
        this.flipLighting(this.lighting);
    }

    private void flipLighting(int n) {
        if (n == 67108885) {
            int n2 = this.vertexCount;
            while (--n2 >= 0) {
                this.normixes[n2] = ~this.normixes[n2];
            }
        } else if (n == 67108883 == this.insideOut) {
            this.invertNormixes();
        }
    }

    private void invertNormixes() {
        int n = this.vertexCount;
        while (--n >= 0) {
            this.normixes[n] = this.g3d.getInverseNormix(this.normixes[n]);
        }
    }

    public void setTranslucent(boolean bl, float f) {
        this.colix = Graphics3D.getColixTranslucent(this.colix, bl, f);
    }

    public void sumVertexNormals(Vector3f[] vector3fArray) {
        int n = this.haveCheckByte ? 1 : 0;
        int n2 = this.polygonCount;
        while (--n2 >= 0) {
            int[] nArray = this.polygonIndexes[n2];
            try {
                if (nArray == null) continue;
                Graphics3D.calcNormalizedNormal(this.vertices[nArray[0]], this.vertices[nArray[1]], this.vertices[nArray[2]], this.vTemp, this.vAB, this.vAC);
                float f = this.vTemp.length();
                if (!((double)f > 0.9) || !((double)f < 1.1)) continue;
                int n3 = nArray.length - n;
                while (--n3 >= 0) {
                    int n4 = nArray[n3];
                    vector3fArray[n4].add(this.vTemp);
                }
            }
            catch (Exception exception) {
            }
        }
    }

    public void setPolygonCount(int n) {
        this.polygonCount = n;
        if (n < 0) {
            return;
        }
        if (this.polygonIndexes == null || n > this.polygonIndexes.length) {
            this.polygonIndexes = new int[n][];
        }
    }

    public int addVertexCopy(Point3f point3f) {
        if (this.vertexCount == 0) {
            this.vertices = new Point3f[25];
        } else if (this.vertexCount == this.vertices.length) {
            this.vertices = (Point3f[])ArrayUtil.doubleLength(this.vertices);
        }
        this.vertices[this.vertexCount] = new Point3f(point3f);
        return this.vertexCount++;
    }

    public void addTriangle(int n, int n2, int n3) {
        if (this.polygonCount == 0) {
            this.polygonIndexes = new int[25][];
        } else if (this.polygonCount == this.polygonIndexes.length) {
            this.polygonIndexes = (int[][])ArrayUtil.doubleLength(this.polygonIndexes);
        }
        this.polygonIndexes[this.polygonCount++] = new int[]{n, n2, n3};
    }

    public void addQuad(int n, int n2, int n3, int n4) {
        if (this.polygonCount == 0) {
            this.polygonIndexes = new int[25][];
        } else if (this.polygonCount == this.polygonIndexes.length) {
            this.polygonIndexes = (int[][])ArrayUtil.doubleLength(this.polygonIndexes);
        }
        this.polygonIndexes[this.polygonCount++] = new int[]{n, n2, n3, n4};
    }

    public void setColix(short s) {
        this.colix = s;
    }

    public String getState(String string) {
        StringBuffer stringBuffer = new StringBuffer(string);
        if (!string.equals("mo")) {
            stringBuffer.append(" ID ").append(Escape.escape(this.thisID));
        }
        stringBuffer.append(this.fillTriangles ? " fill" : " noFill");
        stringBuffer.append(this.drawTriangles ? " mesh" : " noMesh");
        stringBuffer.append(this.showPoints ? " dots" : " noDots");
        stringBuffer.append(this.frontOnly ? " frontOnly" : " notFrontOnly");
        if (this.showContourLines) {
            stringBuffer.append(" contourlines");
        }
        if (this.showTriangles) {
            stringBuffer.append(" triangles");
        }
        stringBuffer.append(this.lighting == 0x4000006 ? " backlit" : (this.lighting == 67108885 ? " fullylit" : " frontlit"));
        if (!this.visible) {
            stringBuffer.append(" hidden");
        }
        return stringBuffer.toString();
    }
}

