/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.jvxl.data;

import java.util.BitSet;
import javax.vecmath.Point3f;
import org.jmol.g3d.Graphics3D;
import org.jmol.util.ArrayUtil;

public class MeshData {
    private static final int SEED_COUNT = 25;
    public static final int MODE_GET_VERTICES = 1;
    public static final int MODE_GET_COLOR_INDEXES = 2;
    public static final int MODE_PUT_SETS = 3;
    public static final int MODE_PUT_VERTICES = 4;
    public int polygonCount;
    public Point3f[] vertices;
    public short[] vertexColixes;
    public int vertexCount;
    public float[] vertexValues;
    public int[][] polygonIndexes;
    public short[] polygonColixes;
    public BitSet[] surfaceSet;
    public int[] vertexSets;
    public int nSets = 0;
    public Point3f[] dots;
    private boolean setsSuccessful;
    public int vertexIncrement = 1;
    private int lastColor;
    private short lastColix;

    public void clear(String string) {
        this.polygonCount = 0;
        this.vertexCount = 0;
        this.vertices = null;
        this.polygonIndexes = null;
        this.surfaceSet = null;
    }

    public int addVertexCopy(Point3f point3f, float f, int n) {
        if (n < 0) {
            this.vertexIncrement = -n;
        }
        if (this.vertexCount == 0) {
            this.vertexValues = new float[25];
        } else if (this.vertexCount >= this.vertexValues.length) {
            this.vertexValues = ArrayUtil.doubleLength(this.vertexValues);
        }
        this.vertexValues[this.vertexCount] = f;
        return this.addVertexCopy(point3f);
    }

    private int addVertexCopy(Point3f point3f) {
        if (this.vertexCount == 0) {
            this.vertices = new Point3f[25];
        } else if (this.vertexCount == this.vertices.length) {
            this.vertices = (Point3f[])ArrayUtil.doubleLength(this.vertices);
        }
        this.vertices[this.vertexCount] = new Point3f(point3f);
        return this.vertexCount++;
    }

    public void addTriangleCheck(int n, int n2, int n3, int n4, int n5) {
        if (this.vertexValues != null && (Float.isNaN(this.vertexValues[n]) || Float.isNaN(this.vertexValues[n2]) || Float.isNaN(this.vertexValues[n3]))) {
            return;
        }
        if (Float.isNaN(this.vertices[n].x) || Float.isNaN(this.vertices[n2].x) || Float.isNaN(this.vertices[n3].x)) {
            return;
        }
        if (this.polygonCount == 0) {
            this.polygonIndexes = new int[25][];
        } else if (this.polygonCount == this.polygonIndexes.length) {
            this.polygonIndexes = (int[][])ArrayUtil.doubleLength(this.polygonIndexes);
        }
        if (n5 != 0) {
            short s;
            if (this.polygonColixes == null) {
                this.polygonColixes = new short[25];
                this.lastColor = 0;
            } else if (this.polygonCount == this.polygonColixes.length) {
                this.polygonColixes = ArrayUtil.doubleLength(this.polygonColixes);
            }
            if (n5 == this.lastColor) {
                s = this.lastColix;
            } else {
                this.lastColor = n5;
                s = this.lastColix = Graphics3D.getColix(this.lastColor);
            }
            this.polygonColixes[this.polygonCount] = s;
        }
        this.polygonIndexes[this.polygonCount++] = new int[]{n, n2, n3, n4};
    }

    public BitSet[] getSurfaceSet() {
        return this.surfaceSet == null ? this.getSurfaceSet(0) : this.surfaceSet;
    }

    public BitSet[] getSurfaceSet(int n) {
        int n2;
        int n3;
        int n4;
        if (n == 0) {
            this.surfaceSet = new BitSet[100];
            this.nSets = 0;
        }
        this.setsSuccessful = true;
        for (n4 = 0; n4 < this.polygonCount; ++n4) {
            if (this.polygonIndexes[n4] == null) continue;
            int[] nArray = this.polygonIndexes[n4];
            n3 = this.findSet(nArray[0]);
            n2 = this.findSet(nArray[1]);
            int n5 = this.findSet(nArray[2]);
            if (n3 < 0 && n2 < 0 && n5 < 0) {
                this.createSet(nArray[0], nArray[1], nArray[2]);
                continue;
            }
            if (n3 == n2 && n2 == n5) continue;
            if (n3 >= 0) {
                this.surfaceSet[n3].set(nArray[1]);
                this.surfaceSet[n3].set(nArray[2]);
                if (n2 >= 0 && n2 != n3) {
                    this.mergeSets(n3, n2);
                }
                if (n5 < 0 || n5 == n3 || n5 == n2) continue;
                this.mergeSets(n3, n5);
                continue;
            }
            if (n2 >= 0) {
                this.surfaceSet[n2].set(nArray[0]);
                this.surfaceSet[n2].set(nArray[2]);
                if (n5 < 0 || n5 == n2) continue;
                this.mergeSets(n2, n5);
                continue;
            }
            this.surfaceSet[n5].set(nArray[0]);
            this.surfaceSet[n5].set(nArray[1]);
        }
        n4 = 0;
        for (int i = 0; i < this.nSets; ++i) {
            if (this.surfaceSet[i] == null) continue;
            ++n4;
        }
        BitSet[] bitSetArray = new BitSet[n4];
        n4 = 0;
        for (n3 = 0; n3 < this.nSets; ++n3) {
            if (this.surfaceSet[n3] == null) continue;
            bitSetArray[n4++] = this.surfaceSet[n3];
        }
        this.nSets = n4;
        this.surfaceSet = bitSetArray;
        if (!this.setsSuccessful && n < 2) {
            this.getSurfaceSet(++n);
        }
        if (n == 0) {
            this.vertexSets = new int[this.vertexCount];
            for (n3 = 0; n3 < this.nSets; ++n3) {
                for (n2 = 0; n2 < this.vertexCount; ++n2) {
                    if (!this.surfaceSet[n3].get(n2)) continue;
                    this.vertexSets[n2] = n3;
                }
            }
        }
        return this.surfaceSet;
    }

    private int findSet(int n) {
        for (int i = 0; i < this.nSets; ++i) {
            if (this.surfaceSet[i] == null || !this.surfaceSet[i].get(n)) continue;
            return i;
        }
        return -1;
    }

    private void createSet(int n, int n2, int n3) {
        int n4;
        for (n4 = 0; n4 < this.nSets && this.surfaceSet[n4] != null; ++n4) {
        }
        if (n4 >= 100) {
            this.setsSuccessful = false;
            return;
        }
        if (n4 == this.nSets) {
            this.nSets = n4 + 1;
        }
        this.surfaceSet[n4] = new BitSet();
        this.surfaceSet[n4].set(n);
        this.surfaceSet[n4].set(n2);
        this.surfaceSet[n4].set(n3);
    }

    private void mergeSets(int n, int n2) {
        this.surfaceSet[n].or(this.surfaceSet[n2]);
        this.surfaceSet[n2] = null;
    }

    public void invalidateSurfaceSet(int n) {
        int n2 = this.surfaceSet[n].length();
        while (--n2 >= 0) {
            if (!this.surfaceSet[n].get(n2)) continue;
            this.vertexValues[n2] = Float.NaN;
        }
        this.surfaceSet[n] = null;
    }

    public static boolean checkCutoff(int n, int n2, int n3, float[] fArray) {
        if (n < 0 || n2 < 0 || n3 < 0) {
            return false;
        }
        float f = fArray[n];
        float f2 = fArray[n2];
        float f3 = fArray[n3];
        return f >= 0.0f && f2 >= 0.0f && f3 >= 0.0f || f <= 0.0f && f2 <= 0.0f && f3 <= 0.0f;
    }

    private boolean setABC(int n) {
        int[] nArray = this.polygonIndexes[n];
        return nArray != null && !Float.isNaN(this.vertexValues[nArray[0]]) && !Float.isNaN(this.vertexValues[nArray[1]]) && !Float.isNaN(this.vertexValues[nArray[2]]);
    }

    public void invalidateTriangles() {
        int n = this.polygonCount;
        while (--n >= 0) {
            if (this.setABC(n)) continue;
            this.polygonIndexes[n] = null;
        }
    }
}

