/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.g3d;

import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.font.TextAttribute;
import java.util.Hashtable;
import org.jmol.g3d.Platform3D;
import org.jmol.util.Logger;

public final class Font3D {
    public final byte fid;
    public final String fontFace;
    public final String fontStyle;
    public final float fontSizeNominal;
    public final int idFontFace;
    public final int idFontStyle;
    public final float fontSize;
    public final Font font;
    public final FontMetrics fontMetrics;
    static Graphics graphicsOffscreen;
    private static final int FONT_ALLOCATION_UNIT = 8;
    private static int fontkeyCount;
    private static int[] fontkeys;
    private static Font3D[] font3ds;
    public static final int FONT_FACE_SANS = 0;
    public static final int FONT_FACE_SERIF = 1;
    public static final int FONT_FACE_MONO = 2;
    private static final String[] fontFaces;
    public static final int FONT_STYLE_PLAIN = 0;
    public static final int FONT_STYLE_BOLD = 1;
    public static final int FONT_STYLE_ITALIC = 2;
    public static final int FONT_STYLE_BOLDITALIC = 3;
    private static final String[] fontStyles;

    private Font3D(byte by, int n, int n2, float f, float f2, Font font, FontMetrics fontMetrics) {
        this.fid = by;
        this.fontFace = fontFaces[n];
        this.fontStyle = fontStyles[n2];
        this.idFontFace = n;
        this.idFontStyle = n2;
        this.fontSize = f;
        this.fontSizeNominal = f2;
        this.font = font;
        this.fontMetrics = fontMetrics;
    }

    static synchronized void initialize(Platform3D platform3D) {
        if (graphicsOffscreen == null) {
            graphicsOffscreen = platform3D.allocateOffscreenImage(1, 1).getGraphics();
        }
    }

    static Font3D getFont3D(int n, int n2, float f, float f2, Platform3D platform3D) {
        if (graphicsOffscreen == null) {
            Font3D.initialize(platform3D);
        }
        if (f > 255.0f) {
            f = 255.0f;
        }
        int n3 = (int)f << 4;
        int n4 = n & 3 | (n2 & 3) << 2 | n3 << 4;
        int n5 = fontkeyCount;
        while (--n5 > 0) {
            if (n4 != fontkeys[n5] || Font3D.font3ds[n5].fontSizeNominal != f2) continue;
            return font3ds[n5];
        }
        return Font3D.allocFont3D(n4, n, n2, f, f2);
    }

    private static synchronized Font3D allocFont3D(int n, int n2, int n3, float f, float f2) {
        Font3D font3D;
        Font3D[] font3DArray;
        Object object;
        int n4 = fontkeyCount;
        while (--n4 > 0) {
            if (n != fontkeys[n4] || Font3D.font3ds[n4].fontSizeNominal != f2) continue;
            return font3ds[n4];
        }
        if ((n4 = fontkeyCount++) == fontkeys.length) {
            object = new int[n4 + 8];
            System.arraycopy(fontkeys, 0, object, 0, n4);
            fontkeys = object;
            font3DArray = new Font3D[n4 + 8];
            System.arraycopy(font3ds, 0, font3DArray, 0, n4);
            font3ds = font3DArray;
        }
        object = new Font(Font3D.getFontMap(fontFaces[n2], n3, f));
        if (graphicsOffscreen == null) {
            Logger.error("Font3D.graphicsOffscreen not initialized");
        }
        font3DArray = graphicsOffscreen.getFontMetrics((Font)object);
        Font3D.font3ds[n4] = font3D = new Font3D((byte)n4, n2, n3, f, f2, (Font)object, (FontMetrics)font3DArray);
        Font3D.fontkeys[n4] = n;
        return font3D;
    }

    private static Hashtable getFontMap(String string, int n, float f) {
        Hashtable<TextAttribute, Object> hashtable = new Hashtable<TextAttribute, Object>();
        hashtable.put(TextAttribute.FAMILY, string);
        if ((n & 1) == 1) {
            hashtable.put(TextAttribute.WEIGHT, TextAttribute.WEIGHT_BOLD);
        }
        if ((n & 2) == 2) {
            hashtable.put(TextAttribute.POSTURE, TextAttribute.POSTURE_OBLIQUE);
        }
        hashtable.put(TextAttribute.SIZE, new Float(f));
        return hashtable;
    }

    public static int getFontFaceID(String string) {
        if ("Monospaced".equalsIgnoreCase(string)) {
            return 2;
        }
        if ("Serif".equalsIgnoreCase(string)) {
            return 1;
        }
        return 0;
    }

    public static int getFontStyleID(String string) {
        int n = 4;
        while (--n > 0 && !fontStyles[n].equalsIgnoreCase(string)) {
        }
        return n;
    }

    public static Font3D getFont3D(byte by) {
        return font3ds[by & 0xFF];
    }

    static {
        fontkeyCount = 1;
        fontkeys = new int[8];
        font3ds = new Font3D[8];
        fontFaces = new String[]{"SansSerif", "Serif", "Monospaced", ""};
        fontStyles = new String[]{"Plain", "Bold", "Italic", "BoldItalic"};
    }
}

