/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.readers.more;

import java.io.BufferedReader;
import java.util.Vector;
import javax.vecmath.Point3f;
import org.jmol.adapter.smarter.Atom;
import org.jmol.adapter.smarter.AtomSetCollection;
import org.jmol.adapter.smarter.AtomSetCollectionReader;
import org.jmol.util.Logger;

public class MdCrdReader
extends AtomSetCollectionReader {
    private Vector trajectorySteps;
    private int ptFloat = 0;
    private int lenLine = 0;

    public AtomSetCollection readAtomSetCollection(BufferedReader bufferedReader) {
        this.reader = bufferedReader;
        this.atomSetCollection = new AtomSetCollection("mdcrd");
        this.atomSetCollection.addAtom(new Atom());
        this.trajectorySteps = (Vector)this.htParams.get("trajectorySteps");
        if (this.trajectorySteps == null) {
            this.trajectorySteps = new Vector();
            this.htParams.put("trajectorySteps", this.trajectorySteps);
        }
        try {
            this.readLine();
            this.readCoordinates();
        }
        catch (Exception exception) {
            return this.setError(exception);
        }
        Logger.info("Total number of trajectory steps=" + this.trajectorySteps.size());
        return this.atomSetCollection;
    }

    void readCoordinates() throws Exception {
        this.line = null;
        int n = this.bsFilter == null ? this.templateAtomCount : (Integer)this.htParams.get("filteredAtomCount");
        boolean bl = this.htParams.containsKey("isPeriodic");
        int n2 = this.templateAtomCount * 3 + (bl ? 3 : 0);
        while (true) {
            if (this.doGetModel(++this.modelNumber)) {
                Point3f[] point3fArray = new Point3f[n];
                if (!this.getTrajectoryStep(point3fArray, bl)) {
                    return;
                }
                this.trajectorySteps.add(point3fArray);
                if (!this.isLastModel(this.modelNumber)) continue;
                return;
            }
            if (!this.skipFloats(n2)) break;
        }
    }

    private float getFloat() throws Exception {
        while (this.line == null || this.ptFloat >= this.lenLine) {
            if (this.readLine() == null) {
                return Float.NaN;
            }
            this.ptFloat = 0;
            this.lenLine = this.line.length();
        }
        this.ptFloat += 8;
        return this.parseFloat(this.line.substring(this.ptFloat - 8, this.ptFloat));
    }

    private Point3f getPoint() throws Exception {
        float f = this.getFloat();
        float f2 = this.getFloat();
        float f3 = this.getFloat();
        return Float.isNaN(f3) ? null : new Point3f(f, f2, f3);
    }

    private boolean getTrajectoryStep(Point3f[] point3fArray, boolean bl) throws Exception {
        int n = point3fArray.length;
        int n2 = -1;
        for (int i = 0; i < this.templateAtomCount; ++i) {
            Point3f point3f = this.getPoint();
            if (point3f == null) {
                return false;
            }
            if (this.bsFilter != null && !this.bsFilter.get(i)) continue;
            if (++n2 == n) {
                return false;
            }
            point3fArray[n2] = point3f;
        }
        if (bl) {
            this.getPoint();
        }
        return this.line != null;
    }

    private boolean skipFloats(int n) throws Exception {
        for (int i = 0; i < n && this.readLine() != null; i += this.getTokens().length) {
        }
        return this.line != null;
    }
}

