/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.readers.more;

import java.io.BufferedReader;
import java.util.StringTokenizer;
import org.jmol.adapter.smarter.Atom;
import org.jmol.adapter.smarter.AtomSetCollection;
import org.jmol.adapter.smarter.AtomSetCollectionReader;
import org.jmol.adapter.smarter.Bond;

public class JmeReader
extends AtomSetCollectionReader {
    StringTokenizer tokenizer;

    public AtomSetCollection readAtomSetCollection(BufferedReader bufferedReader) {
        this.reader = bufferedReader;
        this.atomSetCollection = new AtomSetCollection("jme");
        try {
            this.readLine();
            this.tokenizer = new StringTokenizer(this.line, "\t ");
            int n = this.parseInt(this.tokenizer.nextToken());
            int n2 = this.parseInt(this.tokenizer.nextToken());
            this.atomSetCollection.setCollectionName("JME");
            this.readAtoms(n);
            this.readBonds(n2);
        }
        catch (Exception exception) {
            return this.setError(exception);
        }
        return this.atomSetCollection;
    }

    void readAtoms(int n) throws Exception {
        for (int i = 0; i < n; ++i) {
            String string = this.tokenizer.nextToken();
            int n2 = string.indexOf(58);
            String string2 = (n2 > 0 ? string.substring(0, n2) : string).intern();
            float f = this.parseFloat(this.tokenizer.nextToken());
            float f2 = this.parseFloat(this.tokenizer.nextToken());
            float f3 = 0.0f;
            Atom atom = this.atomSetCollection.addNewAtom();
            atom.elementSymbol = string2;
            atom.set(f, f2, f3);
        }
    }

    void readBonds(int n) throws Exception {
        for (int i = 0; i < n; ++i) {
            int n2 = this.parseInt(this.tokenizer.nextToken());
            int n3 = this.parseInt(this.tokenizer.nextToken());
            int n4 = this.parseInt(this.tokenizer.nextToken());
            if (n4 < 1) {
                n4 = n4 == -1 ? 1025 : 1026;
            }
            this.atomSetCollection.addBond(new Bond(n2 - 1, n3 - 1, n4));
        }
    }
}

