/*
 * Decompiled with CFR 0.152.
 */
import java.applet.Applet;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.util.StringTokenizer;

public class PieChart
extends Applet {
    String title;
    Font font;
    FontMetrics fontMetrics;
    int titleHeight = 15;
    int columns;
    public int round = 1000;
    public float[] values;
    Color[] colors;
    public String[] labels;
    public float[] percent;
    public float[] angle;
    public float[] degree;
    public float[] radian;
    public float[] rawinput;
    int maxLabelWidth = 0;
    int maxValueWidth = 0;
    int max = 0;
    int strWidth = 0;
    public boolean showLabel = true;
    public boolean showPercent = false;
    public boolean showRadians = false;
    public boolean showDegrees = false;
    public boolean showInput = true;
    String unit;
    int lx = 0;
    int ly = 0;
    int cx = 0;
    int cy = 0;

    public synchronized void init() {
        String string;
        this.font = new Font("Sanserif", 1, 12);
        this.fontMetrics = this.getFontMetrics(this.font);
        String string2 = this.getParameter("bgcolor");
        if (string2 == null) {
            this.setBackground(Color.white);
        } else if (string2.equals("red")) {
            this.setBackground(Color.red);
        } else if (string2.equals("green")) {
            this.setBackground(Color.green);
        } else if (string2.equals("blue")) {
            this.setBackground(Color.blue);
        } else if (string2.equals("pink")) {
            this.setBackground(Color.pink);
        } else if (string2.equals("orange")) {
            this.setBackground(Color.orange);
        } else if (string2.equals("magenta")) {
            this.setBackground(Color.magenta);
        } else if (string2.equals("cyan")) {
            this.setBackground(Color.cyan);
        } else if (string2.equals("white")) {
            this.setBackground(Color.white);
        } else if (string2.equals("yellow")) {
            this.setBackground(Color.yellow);
        } else if (string2.equals("gray")) {
            this.setBackground(Color.gray);
        } else if (string2.equals("darkGray")) {
            this.setBackground(Color.darkGray);
        } else {
            this.setBackground(Color.white);
        }
        this.title = this.getParameter("title");
        if (this.title == null) {
            this.title = "WIMS Pie Chart";
        }
        this.unit = this.getParameter("unit");
        if (this.unit == null) {
            this.unit = "";
        }
        this.columns = (string = this.getParameter("columns")) == null ? 5 : Integer.parseInt(string);
        string = this.getParameter("rounding");
        if (string != null) {
            this.round = Integer.parseInt(string);
            if (this.round < 1) {
                this.round = 100;
            }
        }
        if ((string = this.getParameter("showdegrees")) == null) {
            this.showDegrees = false;
        } else {
            if (string.equalsIgnoreCase("YES")) {
                this.showDegrees = true;
            }
            if (string.equalsIgnoreCase("NO")) {
                this.showDegrees = false;
            }
        }
        string = this.getParameter("showradians");
        if (string == null) {
            this.showRadians = false;
        } else {
            if (string.equalsIgnoreCase("YES")) {
                this.showRadians = true;
            }
            if (string.equalsIgnoreCase("NO")) {
                this.showRadians = false;
            }
        }
        string = this.getParameter("showinput");
        if (string == null) {
            this.showInput = true;
        } else {
            if (string.equalsIgnoreCase("YES")) {
                this.showInput = true;
            }
            if (string.equalsIgnoreCase("NO")) {
                this.showInput = false;
            }
        }
        string = this.getParameter("showlabel");
        if (string == null) {
            this.showLabel = false;
        } else {
            if (string.equalsIgnoreCase("YES")) {
                this.showLabel = true;
            }
            if (string.equalsIgnoreCase("NO")) {
                this.showLabel = false;
            }
        }
        string = this.getParameter("showpercent");
        if (string == null) {
            this.showPercent = false;
        } else {
            if (string.equalsIgnoreCase("YES")) {
                this.showPercent = true;
            }
            if (string.equalsIgnoreCase("NO")) {
                this.showPercent = false;
            }
        }
        this.radian = new float[this.columns];
        this.degree = new float[this.columns];
        this.rawinput = new float[this.columns];
        this.values = new float[this.columns];
        this.colors = new Color[this.columns];
        this.labels = new String[this.columns];
        this.percent = new float[this.columns];
        this.angle = new float[this.columns];
        String string3 = null;
        float f = 0.0f;
        for (int i = 0; i < this.columns; ++i) {
            float f2;
            float f3;
            string3 = this.getParameter("Pvalue" + (i + 1));
            this.values[i] = f3 = Float.valueOf(string3.trim()).floatValue();
            this.rawinput[i] = f2 = Float.valueOf(string3).floatValue();
            f += this.values[i];
            string = this.getParameter("Plabel" + (i + 1));
            this.labels[i] = string == null ? "" : string;
            this.maxLabelWidth = Math.max(this.fontMetrics.stringWidth(this.labels[i]), this.maxLabelWidth);
            string = this.getParameter("Pcolor" + (i + 1));
            if (string != null) {
                if (string.equals("red")) {
                    this.colors[i] = Color.red;
                    continue;
                }
                if (string.equals("green")) {
                    this.colors[i] = Color.green;
                    continue;
                }
                if (string.equals("blue")) {
                    this.colors[i] = Color.blue;
                    continue;
                }
                if (string.equals("pink")) {
                    this.colors[i] = Color.pink;
                    continue;
                }
                if (string.equals("orange")) {
                    this.colors[i] = Color.orange;
                    continue;
                }
                if (string.equals("magenta")) {
                    this.colors[i] = Color.magenta;
                    continue;
                }
                if (string.equals("cyan")) {
                    this.colors[i] = Color.cyan;
                    continue;
                }
                if (string.equals("white")) {
                    this.colors[i] = Color.white;
                    continue;
                }
                if (string.equals("yellow")) {
                    this.colors[i] = Color.yellow;
                    continue;
                }
                if (string.equals("gray")) {
                    this.colors[i] = Color.gray;
                    continue;
                }
                if (string.equals("darkGray")) {
                    this.colors[i] = Color.darkGray;
                    continue;
                }
                this.colors[i] = Color.gray;
                continue;
            }
            this.colors[i] = Color.gray;
        }
        float f4 = 100.0f / f;
        for (int i = 0; i < this.columns; ++i) {
            this.percent[i] = (float)Math.round((float)this.round * this.values[i] * f4) / (float)this.round;
            this.angle[i] = (float)Math.round((double)this.round * 3.6 * (double)this.values[i] * (double)f4) / (float)this.round;
            this.degree[i] = (float)Math.round((double)((float)this.round * this.percent[i]) * 3.6) / (float)this.round;
            this.radian[i] = (float)Math.round((float)this.round * this.angle[i] / 180.0f) / (float)this.round;
        }
    }

    public synchronized void paint(Graphics graphics) {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        boolean bl = false;
        boolean bl2 = false;
        int n7 = 0;
        n3 = n4 = Math.min(this.getSize().width - 100, this.getSize().height - 100);
        n2 = 50;
        n = 50;
        if (this.getSize().width > n3) {
            n = (this.getSize().width - n3) / 2;
        }
        this.cx = n + n3 / 2;
        this.cy = n2 + n4 / 2;
        n7 = n3 / 2;
        this.strWidth = this.fontMetrics.stringWidth(this.title);
        Font font = new Font("Sanserif", 1, 16);
        graphics.setFont(font);
        graphics.setColor(Color.red);
        graphics.drawString(this.title, (this.getSize().width - this.strWidth) / 2, 15);
        graphics.setFont(this.font);
        int n8 = 90;
        int n9 = 0;
        int n10 = 0;
        int n11 = (int)(this.angle[0] / 2.0f);
        for (int i = 0; i < this.columns; ++i) {
            int n12;
            n9 = Math.round(this.angle[i]);
            graphics.setColor(this.colors[i]);
            if (i == this.columns - 1) {
                n9 = 360 - n10;
                graphics.fillArc(n, n2, n3, n4, n8, -n9);
                graphics.setColor(Color.black);
                graphics.drawArc(n, n2, n3, n4, n8, -n9);
                this.lx = (int)((double)this.cx + (double)n7 * Math.cos((float)n11 * 3.14f / 180.0f - 1.57f));
                this.ly = (int)((double)this.cy + (double)n7 * Math.sin((float)n11 * 3.14f / 180.0f - 1.57f));
                this.adjustLabel(i);
                n12 = this.ly + 15;
                if (this.showLabel) {
                    graphics.drawString(this.labels[i], this.lx, this.ly);
                    if (this.showDegrees) {
                        graphics.drawString(String.valueOf(this.degree[i]) + "\u00b0", this.lx, n12);
                        break;
                    }
                    if (this.showRadians) {
                        graphics.drawString(String.valueOf(this.radian[i]) + "\u03c0 rad", this.lx, n12);
                        break;
                    }
                    if (this.showPercent) {
                        graphics.drawString(String.valueOf(this.percent[i]) + " %", this.lx, n12);
                        break;
                    }
                    if (!this.showInput) break;
                    graphics.drawString(String.valueOf(this.rawinput[i]) + "  " + this.unit, this.lx, n12);
                    break;
                }
                if (this.showDegrees) {
                    graphics.drawString(String.valueOf(this.degree[i]) + "\u00b0", this.lx, n12);
                    break;
                }
                if (this.showRadians) {
                    graphics.drawString(String.valueOf(this.radian[i]) + "\u03c0 rad", this.lx, n12);
                    break;
                }
                if (this.showPercent) {
                    graphics.drawString(String.valueOf(Math.round((float)this.round * this.percent[i]) / this.round) + " %", this.lx, n12);
                    break;
                }
                if (!this.showInput) break;
                graphics.drawString(String.valueOf(this.rawinput[i]) + "  " + this.unit, this.lx, n12);
                break;
            }
            graphics.fillArc(n, n2, n3, n4, n8, -n9);
            graphics.setColor(Color.black);
            graphics.drawArc(n, n2, n3, n4, n8, -n9);
            n5 = (int)((double)this.cx + (double)n7 * Math.cos((float)(n10 += n9) * 3.14f / 180.0f - 1.57f));
            n6 = (int)((double)this.cy + (double)n7 * Math.sin((float)n10 * 3.14f / 180.0f - 1.57f));
            graphics.drawLine(this.cx, this.cy, n5, n6);
            this.lx = (int)((double)this.cx + (double)n7 * Math.cos((float)n11 * 3.14f / 180.0f - 1.57f));
            this.ly = (int)((double)this.cy + (double)n7 * Math.sin((float)n11 * 3.14f / 180.0f - 1.57f));
            this.adjustLabel(i);
            n12 = this.ly + 15;
            if (this.showLabel) {
                graphics.drawString(this.labels[i], this.lx, this.ly);
                if (this.showDegrees) {
                    graphics.drawString(String.valueOf(this.degree[i]) + "\u00b0", this.lx, n12);
                } else if (this.showRadians) {
                    graphics.drawString(String.valueOf(this.radian[i]) + "\u03c0 rad", this.lx, n12);
                } else if (this.showPercent) {
                    graphics.drawString(String.valueOf(this.percent[i]) + " %", this.lx, n12);
                } else if (this.showInput) {
                    graphics.drawString(String.valueOf(this.rawinput[i]) + "  " + this.unit, this.lx, n12);
                }
            } else if (this.showDegrees) {
                graphics.drawString(String.valueOf(this.degree[i]) + "\u00b0", this.lx, n12);
            } else if (this.showRadians) {
                graphics.drawString(String.valueOf(this.radian[i]) + "\u03c0 rad", this.lx, n12);
            } else if (this.showPercent) {
                graphics.drawString(String.valueOf(Math.round((float)this.round * this.percent[i]) / this.round) + " %", this.lx, n12);
            } else if (this.showInput) {
                graphics.drawString(String.valueOf(this.rawinput[i]) + "  " + this.unit, this.lx, n12);
            }
            n11 += (int)(this.angle[i] / 2.0f + this.angle[i + 1] / 2.0f);
            n8 += -n9;
        }
        graphics.setColor(Color.black);
        graphics.drawLine(this.cx, this.cy, this.cx, this.cy - n7);
    }

    private void adjustLabel(int n) {
        if (this.lx > this.cx && this.ly < this.cy) {
            this.lx += 5;
            this.ly -= 5;
        }
        if (this.lx > this.cx && this.ly > this.cy) {
            this.lx += 5;
            this.ly += 10;
        }
        if (this.lx < this.cx && this.ly > this.cy) {
            this.strWidth = this.fontMetrics.stringWidth(this.labels[n]);
            this.lx -= this.strWidth + 5;
            if (this.lx < 0) {
                this.lx = 0;
            }
        }
        if (this.lx < this.cx && this.ly < this.cy) {
            this.strWidth = this.fontMetrics.stringWidth(this.labels[n]);
            this.lx -= this.strWidth + 5;
            if (this.lx < 0) {
                this.lx = 0;
            }
        }
    }

    public static String replace(String string, String string2, String string3) {
        if (string != null) {
            int n = string2.length();
            StringBuffer stringBuffer = new StringBuffer();
            int n2 = -1;
            int n3 = 0;
            while ((n2 = string.indexOf(string2, n3)) != -1) {
                stringBuffer.append(string.substring(n3, n2));
                stringBuffer.append(string3);
                n3 = n2 + n;
            }
            stringBuffer.append(string.substring(n3));
            return stringBuffer.toString();
        }
        return "";
    }

    public String ReadApplet() {
        int n = this.values.length;
        String string = "";
        if (n == 0) {
            string = "error empty answer";
        } else {
            String string2 = "";
            for (int i = 0; i < n; ++i) {
                string2 = this.labels[i];
                float f = this.rawinput[i];
                string = string + "segment " + i + " [ " + string2 + " ] = " + f + "\n";
            }
        }
        return string;
    }

    public void SetApplet(String string) {
        float f;
        int n;
        String string2 = "";
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        int n2 = stringTokenizer.countTokens();
        float[] fArray = new float[n2];
        float f2 = 0.0f;
        for (n = 0; n < n2; ++n) {
            string2 = stringTokenizer.nextToken();
            if (string2.length() == 0) {
                string2 = "0";
            }
            f = Float.valueOf(string2).floatValue();
            System.out.println("input = " + f + "\n");
            this.rawinput[n] = f;
            fArray[n] = f;
            f2 += f;
        }
        for (n = 0; n < n2; ++n) {
            f = fArray[n];
            this.angle[n] = 360.0f * f / f2;
            this.percent[n] = 100.0f * f / f2;
            this.radian[n] = f / f2;
            this.degree[n] = 360.0f * f / f2;
        }
        this.repaint();
    }
}

