# -*- coding: utf-8 -*-
#   WillowNG - Content Filtering Web Proxy
#   Copyright (C) 2006  Travis Watkins
#
#   This library is free software; you can redistribute it and/or
#   modify it under the terms of the GNU Library General Public
#   License as published by the Free Software Foundation; either
#   version 2 of the License, or (at your option) any later version.
#
#   This library is distributed in the hope that it will be useful,
#   but WITHOUT ANY WARRANTY; without even the implied warranty of
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
#   Library General Public License for more details.
#
#   You should have received a copy of the GNU Library General Public
#   License along with this library; if not, write to the Free Software
#   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

import os

def setupTables(db):
    cur = db.cursor()
    cur.execute('SELECT name FROM sqlite_master WHERE type = "table" AND name = "__domains"')
    if cur.fetchone() == None:
        cur.execute('CREATE TABLE __domains (pool TEXT, domain TEXT)')
    cur.execute('SELECT name FROM sqlite_master WHERE type = "table" AND name = "good"')
    if cur.fetchone() == None:
        cur.execute('CREATE TABLE good (token TEXT, count INTEGER)')
    cur.execute('SELECT name FROM sqlite_master WHERE type = "table" AND name = "good__cache"')
    if cur.fetchone() == None:
        cur.execute('CREATE TABLE good__cache (token TEXT, count INTEGER)')
    cur.execute('SELECT name FROM sqlite_master WHERE type = "table" AND name = "bad"')
    if cur.fetchone() == None:
        cur.execute('CREATE TABLE bad (token TEXT, count INTEGER)')
    cur.execute('SELECT name FROM sqlite_master WHERE type = "table" AND name = "bad__cache"')
    if cur.fetchone() == None:
        cur.execute('CREATE TABLE bad__cache (token TEXT, count INTEGER)')
    cur.execute('SELECT name FROM sqlite_master WHERE type = "table" AND name = "__Corpus__"')
    if cur.fetchone() == None:
        cur.execute('CREATE TABLE __Corpus__ (token TEXT, count INTEGER)')
    db.commit()

def readConfig(confdir, datadir):
    config = {}
    try:
        lines = open(os.path.join(confdir, 'main.conf')).read().split('\n')
    except IOError:
        lines = []
    for line in lines:
        line = line.strip()
        if '=' in line and not line.startswith('#'):
            key, value = line.split('=', 1)
            config[key] = value
    if not config.has_key('domain_blocked_page'):
        config['domain_blocked_page'] = os.path.join(datadir, 'error_pages', 'domain.html')
    if not config.has_key('content_blocked_page'):
        config['content_blocked_page'] = os.path.join(datadir, 'error_pages', 'content.html')
    if not config.has_key('filter_on'):
        config['filter_on'] = 0
    return config

def writeConfig(confdir, config):
    conffile = open(os.path.join(confdir, 'main.conf'), 'w')
    for key, value in config.items():
        conffile.write(unicode(key) + '=' + unicode(value) + '\n')
