/*
 * NodeIndexedLineSet.h
 *
 * Copyright (C) 1999 Stephen F. White
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program (see the file "COPYING" for details); if 
 * not, write to the Free Software Foundation, Inc., 675 Mass Ave, 
 * Cambridge, MA 02139, USA.
 */

#ifndef _NODE_INDEXEDLINESET_H
#define _NODE_INDEXEDLINESET_H

#ifndef _NODE_H
#include "Node.h"
#endif
#ifndef _PROTO_MACROS_H
#include "ProtoMacros.h"
#endif
#ifndef _PROTO_H
#include "Proto.h"
#endif

#include "SFMFTypes.h"

class ProtoIndexedLineSet : public Proto {
public:
		    ProtoIndexedLineSet(Scene *scene);
    virtual Node   *create(Scene *scene);

    FieldIndex color;
    FieldIndex coord;
    FieldIndex colorIndex;
    FieldIndex colorPerVertex;
    FieldIndex coordIndex;
};

class NodeIndexedLineSet : public Node {
public:
		    NodeIndexedLineSet(Scene *scene, Proto *proto);

    virtual int	    getType() const { return NODE_INDEXED_LINE_SET; }
    virtual Node   *copy() const { return new NodeIndexedLineSet(*this); }
    virtual int	    getNodeClass() const { return GEOMETRY_NODE; }
    virtual void    draw();

    virtual bool    isInvalidChildNode(void) { return true; }
    virtual bool    hasBoundingBox(void)     { return true; }
    virtual Vec3f   getMinBoundingBox(void);
    virtual Vec3f   getMaxBoundingBox(void);
    virtual void    flip(int index);

    Node           *toPointSet(void);

    fieldMacros(SFNode,  color,          ProtoIndexedLineSet)
    fieldMacros(SFNode,  coord,          ProtoIndexedLineSet)
    fieldMacros(MFInt32, colorIndex,     ProtoIndexedLineSet)
    fieldMacros(SFBool,  colorPerVertex, ProtoIndexedLineSet)
    fieldMacros(MFInt32, coordIndex,     ProtoIndexedLineSet)
};


#endif // _NODE_INDEXEDLINESET_H
